;; Validation

(module
  (rec
    (type $a (sub (descriptor $b) (struct)))
    (type $b (sub (describes $a) (struct)))
    (type $c (sub $a (descriptor $d) (struct)))
    (type $d (sub $b (describes $c) (struct)))
  )

  ;; All nullness combinations
  (func (param (ref null any) (ref null $b)) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null any) (ref null $b)) (result (ref null any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )
  (func (param (ref null any) (ref $b)) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null any) (ref $b)) (result (ref null any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )
  (func (param (ref any) (ref null $b)) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref any) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref any) (ref null $b)) (result (ref any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )
  (func (param (ref any) (ref $b)) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref any) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref any) (ref $b)) (result (ref any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )

  ;; All nullness combinations with subtype descriptor
  (func (param (ref null any) (ref null $d)) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null any) (ref null $d)) (result (ref null any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )
  (func (param (ref null any) (ref $d)) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null any) (ref $d)) (result (ref null any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )
  (func (param (ref any) (ref null $d)) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref any) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref any) (ref null $d)) (result (ref any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )
  (func (param (ref any) (ref $d)) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref any) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref any) (ref $d)) (result (ref any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )

  ;; All nullness combinations with exact subtype descriptor
  (func (param (ref null any) (ref null (exact $d))) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null any) (ref null (exact $d))) (result (ref null any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )
  (func (param (ref null any) (ref (exact $d))) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null any) (ref (exact $d))) (result (ref null any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )
  (func (param (ref any) (ref null (exact $d))) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref any) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref any) (ref null (exact $d))) (result (ref any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )
  (func (param (ref any) (ref (exact $d))) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref any) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref any) (ref (exact $d))) (result (ref any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )

  ;; All nullness combinations with exact casts.
  (func (param (ref null any) (ref null (exact $b))) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null any) (ref null (exact $b))) (result (ref null any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
  )
  (func (param (ref null any) (ref (exact $b))) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null any) (ref (exact $b))) (result (ref null any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
  )
  (func (param (ref any) (ref null (exact $b))) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref any) (ref null (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref any) (ref null (exact $b))) (result (ref any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref any) (ref (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
  )
  (func (param (ref any) (ref (exact $b))) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref any) (ref null (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref any) (ref (exact $b))) (result (ref any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref any) (ref (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
  )

  ;; Unreachable descriptor
  (func (param (ref null any)) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null $a)
        (local.get 0)
        (unreachable)
      )
    )
    (unreachable)
  )
  (func (param (ref null any)) (result (ref null any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref $a)
        (local.get 0)
        (unreachable)
      )
    )
  )
  (func (param (ref any)) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref any) (ref null $a)
        (local.get 0)
        (unreachable)
      )
    )
    (unreachable)
  )
  (func (param (ref any)) (result (ref any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref any) (ref $a)
        (local.get 0)
        (unreachable)
      )
    )
  )
  (func (param (ref null any)) (result (ref any))
    (block (result (ref null (exact $a)))
      (br_on_cast_desc_fail 1 (ref null any) (ref null (exact $a))
        (local.get 0)
        (unreachable)
      )
    )
    (unreachable)
  )
  (func (param (ref null any)) (result (ref null any))
    (block (result (ref (exact $a)))
      (br_on_cast_desc_fail 1 (ref null any) (ref (exact $a))
        (local.get 0)
        (unreachable)
      )
    )
  )
  (func (param (ref any)) (result (ref any))
    (block (result (ref null (exact $a)))
      (br_on_cast_desc_fail 1 (ref any) (ref null (exact $a))
        (local.get 0)
        (unreachable)
      )
    )
    (unreachable)
  )
  (func (param (ref any)) (result (ref any))
    (block (result (ref (exact $a)))
      (br_on_cast_desc_fail 1 (ref any) (ref (exact $a))
        (local.get 0)
        (unreachable)
      )
    )
  )

  ;; Null descriptor
  (func (param (ref null any)) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null $a)
        (local.get 0)
        (ref.null none)
      )
    )
    (unreachable)
  )
  (func (param (ref null any)) (result (ref null any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref $a)
        (local.get 0)
        (ref.null none)
      )
    )
  )
  (func (param (ref any)) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref any) (ref null $a)
        (local.get 0)
        (ref.null none)
      )
    )
    (unreachable)
  )
  (func (param (ref any)) (result (ref any))
    (block (result (ref $a))
      (br_on_cast_desc_fail 1 (ref any) (ref $a)
        (local.get 0)
        (ref.null none)
      )
    )
  )
  (func (param (ref null any)) (result (ref any))
    (block (result (ref null (exact $a)))
      (br_on_cast_desc_fail 1 (ref null any) (ref null (exact $a))
        (local.get 0)
        (ref.null none)
      )
    )
    (unreachable)
  )
  (func (param (ref null any)) (result (ref null any))
    (block (result (ref (exact $a)))
      (br_on_cast_desc_fail 1 (ref null any) (ref (exact $a))
        (local.get 0)
        (ref.null none)
      )
    )
  )
  (func (param (ref any)) (result (ref any))
    (block (result (ref null (exact $a)))
      (br_on_cast_desc_fail 1 (ref any) (ref null (exact $a))
        (local.get 0)
        (ref.null none)
      )
    )
    (unreachable)
  )
  (func (param (ref any)) (result (ref any))
    (block (result (ref (exact $a)))
      (br_on_cast_desc_fail 1 (ref any) (ref (exact $a))
        (local.get 0)
        (ref.null none)
      )
    )
  )
)

(module
  (rec
    (type $a (sub (descriptor $b) (struct)))
    (type $b (sub (describes $a) (struct)))
    (type $c (sub $a (descriptor $d) (struct)))
    (type $d (sub $b (describes $c) (descriptor $e) (struct)))
    (type $e (describes $d) (struct))
  )

  ;; Cast to self
  (func (param (ref null $a) (ref null $b)) (result (ref $a))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null $a) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null $a) (ref null (exact $b))) (result (ref $a))
    (block (result (ref null (exact $a)))
      (br_on_cast_desc_fail 1 (ref null $a) (ref null (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )

  ;; Cast to unrelated type
  (func (param (ref null i31) (ref null $b)) (result (ref i31))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null i31) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null i31) (ref null (exact $b))) (result (ref i31))
    (block (result (ref null (exact $a)))
      (br_on_cast_desc_fail 1 (ref null i31) (ref null (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )

  ;; Cast from defined type to unrelated type
  (func (param (ref null $e) (ref null $b)) (result (ref $e))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null $e) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null $e) (ref null (exact $b))) (result (ref $e))
    (block (result (ref null (exact $a)))
      (br_on_cast_desc_fail 1 (ref null $e) (ref null (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )

  ;; Cast from exact defined type to unrelated type
  (func (param (ref null (exact $e)) (ref null $b)) (result (ref (exact $e)))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null (exact $e)) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null (exact $e)) (ref null (exact $b))) (result (ref (exact $e)))
    (block (result (ref null (exact $a)))
      (br_on_cast_desc_fail 1 (ref null (exact $e)) (ref null (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )

  ;; Cast to supertype
  (func (param (ref null $c) (ref null $b)) (result (ref $c))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null $c) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null $c) (ref null (exact $b))) (result (ref $c))
    (block (result (ref null (exact $a)))
      (br_on_cast_desc_fail 1 (ref null $c) (ref null (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )

  ;; Cast from exact to supertype
  (func (param (ref null (exact $c)) (ref null $b)) (result (ref $c))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null (exact $c)) (ref null $a)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null (exact $c)) (ref null (exact $b))) (result (ref $c))
    (block (result (ref null (exact $a)))
      (br_on_cast_desc_fail 1 (ref null (exact $c)) (ref null (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )

  ;; Cast to subtype
  (func (param (ref null $a) (ref null $d)) (result (ref $a))
    (block (result (ref null $c))
      (br_on_cast_desc_fail 1 (ref null $a) (ref null $c)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null $a) (ref null (exact $d))) (result (ref $a))
    (block (result (ref null (exact $c)))
      (br_on_cast_desc_fail 1 (ref null $a) (ref null (exact $c))
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )

  ;; Cast from exact to subtype
  (func (param (ref null (exact $a)) (ref null $d)) (result (ref (exact $a)))
    (block (result (ref null $c))
      (br_on_cast_desc_fail 1 (ref null (exact $a)) (ref null $c)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null (exact $a)) (ref null (exact $d))) (result (ref (exact $a)))
    (block (result (ref null (exact $c)))
      (br_on_cast_desc_fail 1 (ref null (exact $a)) (ref null (exact $c))
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )

  ;; Cast from null
  (func (param (ref null $b)) (result (ref $a))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null none) (ref null $a)
        (ref.null none)
        (local.get 0)
      )
    )
    (unreachable)
  )
  (func (param (ref null (exact $b))) (result (ref $a))
    (block (result (ref null (exact $a)))
      (br_on_cast_desc_fail 1 (ref null none) (ref null (exact $a))
        (ref.null none)
        (local.get 0)
      )
    )
    (unreachable)
  )

  ;; Cast from unreachable
  (func (param (ref null $b)) (result (ref any))
    (block (result (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null $a)
        (unreachable)
        (local.get 0)
      )
    )
    (unreachable)
  )
  (func (param (ref null (exact $b))) (result (ref any))
    (block (result (ref null (exact $a)))
      (br_on_cast_desc_fail 1 (ref null any) (ref null (exact $a))
        (unreachable)
        (local.get 0)
      )
    )
    (unreachable)
  )

  ;; Cast to descriptor type
  (func (param (ref null any) (ref null $e)) (result (ref any))
    (block (result (ref null $d))
      (br_on_cast_desc_fail 1 (ref null any) (ref null $d)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
  (func (param (ref null any) (ref null (exact $e))) (result (ref any))
    (block (result (ref null (exact $d)))
      (br_on_cast_desc_fail 1 (ref null any) (ref null (exact $d))
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
)

(assert_invalid
  (module
    ;; Type must exist.
    (func (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref 1)
        (unreachable)
      )
    )
  )
  "unknown type"
)

(assert_invalid
  (module
    ;; Type must have a descriptor.
    (func (result anyref)
      (br_on_cast_desc_fail 0 anyref anyref
        (unreachable)
      )
    )
  )
  "type any does not have a descriptor"
)

(assert_invalid
  (module
    ;; Type must have a descriptor.
    (func (result anyref)
      (br_on_cast_desc_fail 0 anyref nullref
        (unreachable)
      )
    )
  )
  "type none does not have a descriptor"
)

(assert_invalid
  (module
    (type $a (struct))
    ;; Type must have a descriptor.
    (func (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a)
        (unreachable)
      )
    )
  )
  "type 0 does not have a descriptor"
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; Cannot cast to descriptor without its own descriptor.
    (func (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $b) (unreachable))
    )
  )
  "type 1 does not have a descriptor"
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; Descriptor must have expected type.
    (func (param (ref null any) (ref null struct)) (result (ref null any))
      (br_on_cast_desc_fail 0 (ref null any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; Descriptor must be exact when cast is exact.
    (func (param (ref null any) (ref $b)) (result (ref null any))
      (br_on_cast_desc_fail 0 (ref null any) (ref (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; Descriptor must be exact when cast is exact, even if the descriptor is null.
    (func (param (ref null any)) (result (ref null any))
      (br_on_cast_desc_fail 0 (ref null any) (ref (exact $a))
        (local.get 0)
        (ref.null $b)
      )
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (sub (descriptor $b) (struct)))
      (type $b (sub (describes $a) (struct)))
      (type $c (sub $a (descriptor $d) (struct)))
      (type $d (sub $b (describes $c) (struct)))
    )
    ;; An exact reference to a subtype of the descriptor does not cut it.
    (func (param (ref null any) (ref (exact $d))) (result (ref null any))
      (br_on_cast_desc_fail 0 (ref null any) (ref (exact $a))
        (local.get 0)
        (local.get 1)
      )
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; Cannot cast across hierarchies.
    (func (param (ref null func) (ref $b)) (result (ref null any))
      (br_on_cast_desc_fail 0 (ref null func) (ref $a)
        (local.get 0)
        (local.get 1)
      )
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; Cannot cast across hierarchies even with unreachable input.
    (func (result (ref null any))
      (br_on_cast_desc_fail 0 (ref null func) (ref $a)
        (unreachable)
      )
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (sub (descriptor $b) (struct)))
      (type $b (sub (describes $a) (struct)))
      (type $c (sub $a (descriptor $d) (struct)))
      (type $d (sub $b (describes $c) (struct)))
    )
    ;; Ouput type is determined by immediate, not actual input.
    (func (param (ref $c) (ref $d)) (result (ref null any))
      (block (result (ref null $c))
        (br_on_cast_desc_fail 1 (ref $c) (ref $a)
          (local.get 0)
          (local.get 1)
        )
      )
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (sub (descriptor $b) (struct)))
      (type $b (sub (describes $a) (struct)))
      (type $c (sub $a (descriptor $d) (struct)))
      (type $d (sub $b (describes $c) (struct)))
    )
    ;; Same, but with an exact reference to the descriptor subtype.
    (func (param (ref $c) (ref (exact $d))) (result (ref null any))
      (block (result (ref null $c))
        (br_on_cast_desc_fail 1 (ref $c) (ref $a)
          (local.get 0)
          (local.get 1)
        )
      )
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (sub (descriptor $b) (struct)))
      (type $b (sub (describes $a) (struct)))
      (type $c (sub $a (descriptor $d) (struct)))
      (type $d (sub $b (describes $c) (struct)))
    )
    ;; Same, but now the cast value and descriptor are both null.
    (func (result (ref null any))
      (block (result (ref null $c))
        (br_on_cast_desc_fail 1 (ref null none) (ref $a)
          (ref.null none)
          (ref.null none)
        )
      )
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (sub (descriptor $b) (struct)))
      (type $b (sub (describes $a) (struct)))
      (type $c (sub $a (descriptor $d) (struct)))
      (type $d (sub $b (describes $c) (struct)))
    )
    ;; Same, but now the cast value and descriptor are bottom.
    (func (result (ref null any))
      (block (result (ref null $c))
        (br_on_cast_desc_fail 1 (ref none) (ref $a)
          (unreachable)
        )
      )
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; Branch type should be nullable.
    (func (param (ref null any) (ref null $b)) (result (ref any))
      (block (result (ref $a))
        (br_on_cast_desc_fail 1 (ref null any) (ref $a)
          (local.get 0)
          (local.get 1)
        )
      )
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; Invalid in constant expression.
    (global (ref $a) (br_on_cast_desc_fail 0 (ref null any) (ref null $a) (ref.null none) (ref.null none)))
  )
  "constant expression required"
)

;; Sent values

(module
  (rec
    (type $a (descriptor $b) (struct))
    (type $b (describes $a) (struct))
  )

  ;; One extra value.
  (func (param (ref null any) (ref null $b)) (result i32 (ref any))
    (block (result i32 (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null $a)
        (i32.const 42)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )

  ;; Two extra values.
  (func (param (ref null any) (ref null $b)) (result i32 i64 (ref any))
    (block (result i32 i64 (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null $a)
        (i32.const 42)
        (i64.const 1337)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )

  ;; Extra reference value.
  (func (param (ref null any) (ref null $b)) (result (ref null eq) (ref any))
    (block (result (ref null any) (ref null $a))
      (br_on_cast_desc_fail 1 (ref null any) (ref null $a)
        (local.get 1)
        (local.get 0)
        (local.get 1)
      )
    )
    (unreachable)
  )
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; No types at label.
    (func
      (br_on_cast_desc_fail 0 (ref null any) (ref $a)
        (unreachable)
      )
      (unreachable)
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; Too many types at label.
    (func (param (ref null any) (ref null $b)) (result i32 (ref null any))
      (br_on_cast_desc_fail 0 (ref null any) (ref $a)
        (local.get 0)
        (local.get 1)
      )
      (unreachable)
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; Mismatched types at label.
    (func (param (ref null any) (ref null $b)) (result (ref null eq) (ref null any))
      (br_on_cast_desc_fail 0 (ref null any) (ref $a)
        (local.get 0)
        (local.get 0)
        (local.get 1)
      )
      (unreachable)
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; No types at fallthrough.
    (func (result (ref null any))
      (block
        (br_on_cast_desc_fail 1 (ref null any) (ref $a)
          (unreachable)
        )
      )
      (unreachable)
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; Too many types at fallthrough.
    (func (result (ref null any))
      (block (result i32 (ref $a))
        (br_on_cast_desc_fail 1 (ref null any) (ref $a)
          (ref.null none)
          (ref.null none)
        )
      )
      (unreachable)
    )
  )
  "type mismatch"
)

(assert_invalid
  (module
    (rec
      (type $a (descriptor $b) (struct))
      (type $b (describes $a) (struct))
    )
    ;; Label types do not match fallthrough types.
    (func (result (ref null any) (ref null any))
      (block (result (ref null eq) (ref $a))
        (br_on_cast_desc_fail 1 (ref null any) (ref $a)
          (unreachable)
        )
      )
      (unreachable)
    )
  )
  "type mismatch"
)

;; Execution

(module
  (rec
    (type $a (sub (descriptor $b) (struct)))
    (type $b (sub (describes $a) (struct)))
    (type $c (sub $a (descriptor $d) (struct)))
    (type $d (sub $b (describes $c) (struct)))
  )
  (type $no-desc (struct))

  (global $b1-exact (ref null (exact $b)) (struct.new $b))
  (global $b2-exact (ref null (exact $b)) (struct.new $b))
  (global $b1 (ref null $b) (global.get $b1-exact))
  (global $b2 (ref null $b) (global.get $b2-exact))
  (global $a1 (ref null $a) (struct.new $a (global.get $b1-exact)))

  (global $d1-exact (ref null (exact $d)) (struct.new $d))
  (global $d2-exact (ref null (exact $d)) (struct.new $d))
  (global $d1 (ref null $d) (global.get $d1-exact))
  (global $d2 (ref null $d) (global.get $d2-exact))
  (global $c1 (ref null $c) (struct.new $c (global.get $d1-exact)))

  (global $c1-as-a (ref null $a) (global.get $c1))

  (global $a-null (ref null (exact $a)) (ref.null none))
  (global $b-null (ref null (exact $b)) (ref.null none))
  (global $c-null (ref null (exact $c)) (ref.null none))
  (global $d-null (ref null (exact $d)) (ref.null none))

  (global $no-desc (ref null (exact $no-desc)) (struct.new $no-desc))
  (global $no-desc-null (ref null (exact $no-desc)) (ref.null none))

  (global $i31 (ref null any) (ref.i31 (i32.const 0)))
  (global $i31-null (ref null any) (ref.null i31))

  (func (export "self-nullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $a-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-nullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $a1) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-nullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $a-null) (global.get $b1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-nullable-val-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $a1) (global.get $b1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-nullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $a1) (global.get $b2))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "self-nonnullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $a-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-nonnullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $a1) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-nonnullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $a-null) (global.get $b1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-nonnullable-val-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $a1) (global.get $b1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-nonnullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $a1) (global.get $b2))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "self-exact-nullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $a-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-exact-nullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $a1) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-exact-nullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $a-null) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-exact-nullable-val-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $a1) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-exact-nullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $a1) (global.get $b2-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "self-exact-nonnullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $a-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-exact-nonnullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $a1) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-exact-nonnullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $a-null) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-exact-nonnullable-val-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $a1) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "self-exact-nonnullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $a1) (global.get $b2-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "down-nullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $a-null) (global.get $d-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-nullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $c1-as-a) (global.get $d-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-nullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $a-null) (global.get $d1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-nullable-val-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $c1-as-a) (global.get $d1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-nullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $c1-as-a) (global.get $d2))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "down-nonnullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $c) (global.get $a-null) (global.get $d-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-nonnullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $c) (global.get $c1-as-a) (global.get $d-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-nonnullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $c) (global.get $a-null) (global.get $d1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-nonnullable-val-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $c) (global.get $c1-as-a) (global.get $d1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-nonnullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $c) (global.get $c1-as-a) (global.get $d2))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "down-exact-nullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $c)) (global.get $a-null) (global.get $d-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-exact-nullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $c)) (global.get $c1-as-a) (global.get $d-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-exact-nullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $c)) (global.get $a-null) (global.get $d1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-exact-nullable-val-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $c)) (global.get $c1-as-a) (global.get $d1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-exact-nullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $c)) (global.get $c1-as-a) (global.get $d2-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "down-exact-nonnullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $c)) (global.get $a-null) (global.get $d-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-exact-nonnullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $c)) (global.get $c1-as-a) (global.get $d-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-exact-nonnullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $c)) (global.get $a-null) (global.get $d1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-exact-nonnullable-val-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $c)) (global.get $c1-as-a) (global.get $d1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "down-exact-nonnullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $c)) (global.get $c1-as-a) (global.get $d2-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "up-nullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $c-null) (global.get $d-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-nullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $c1) (global.get $d-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-nullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $c-null) (global.get $d1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-nullable-val-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $c1) (global.get $d1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-nullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $c1) (global.get $d2))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "up-nonnullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $c-null) (global.get $d-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-nonnullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $c1) (global.get $d-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-nonnullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $c-null) (global.get $d1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-nonnullable-val-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $c1) (global.get $d1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-nonnullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $c1) (global.get $d2))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "up-exact-nullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $c-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-exact-nullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $c1) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-exact-nullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $c-null) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-exact-nullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $c1) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "up-exact-nonnullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $c-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-exact-nonnullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $c1) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-exact-nonnullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $c-null) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "up-exact-nonnullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $c1) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "nodesc-nullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $no-desc-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "nodesc-nullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $no-desc) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "nodesc-nullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $no-desc-null) (global.get $b1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "nodesc-nullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $no-desc) (global.get $b1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "nodesc-nonnullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $no-desc-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "nodesc-nonnullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $no-desc) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "nodesc-nonnullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $no-desc-null) (global.get $b1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "nodesc-nonnullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $no-desc) (global.get $b1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "nodesc-exact-nullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $no-desc-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "nodesc-exact-nullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $no-desc) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "nodesc-exact-nullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $no-desc-null) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "nodesc-exact-nullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $no-desc) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "nodesc-exact-nonnullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $no-desc-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "nodesc-exact-nonnullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $no-desc) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "nodesc-exact-nonnullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $no-desc-null) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "nodesc-exact-nonnullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $no-desc) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "i31-nullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $i31-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "i31-nullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $i31) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "i31-nullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $i31-null) (global.get $b1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "i31-nullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null $a) (global.get $i31) (global.get $b1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "i31-nonnullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $i31-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "i31-nonnullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $i31) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "i31-nonnullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $i31-null) (global.get $b1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "i31-nonnullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref $a) (global.get $i31) (global.get $b1))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "i31-exact-nullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $i31-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "i31-exact-nullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $i31) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "i31-exact-nullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $i31-null) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "i31-exact-nullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref null (exact $a)) (global.get $i31) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )

  (func (export "i31-exact-nonnullable-null-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $i31-null) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "i31-exact-nonnullable-val-null") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $i31) (global.get $b-null))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "i31-exact-nonnullable-null-desc") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $i31-null) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
  (func (export "i31-exact-nonnullable-val-other") (result i32)
    (block (result anyref)
      (br_on_cast_desc_fail 0 anyref (ref (exact $a)) (global.get $i31) (global.get $b1-exact))
      (return (i32.const 0))
    )
    (return (i32.const 1))
  )
)

(assert_trap (invoke "self-nullable-null-null") "null descriptor reference")
(assert_trap (invoke "self-nullable-val-null") "null descriptor reference")
(assert_return (invoke "self-nullable-null-desc") (i32.const 0))
(assert_return (invoke "self-nullable-val-desc") (i32.const 0))
(assert_return (invoke "self-nullable-val-other") (i32.const 1))

(assert_trap (invoke "self-nonnullable-null-null") "null descriptor reference")
(assert_trap (invoke "self-nonnullable-val-null") "null descriptor reference")
(assert_return (invoke "self-nonnullable-null-desc") (i32.const 1))
(assert_return (invoke "self-nonnullable-val-desc") (i32.const 0))
(assert_return (invoke "self-nonnullable-val-other") (i32.const 1))

(assert_trap (invoke "self-exact-nullable-null-null") "null descriptor reference")
(assert_trap (invoke "self-exact-nullable-val-null") "null descriptor reference")
(assert_return (invoke "self-exact-nullable-null-desc") (i32.const 0))
(assert_return (invoke "self-exact-nullable-val-desc") (i32.const 0))
(assert_return (invoke "self-exact-nullable-val-other") (i32.const 1))

(assert_trap (invoke "self-exact-nonnullable-null-null") "null descriptor reference")
(assert_trap (invoke "self-exact-nonnullable-val-null") "null descriptor reference")
(assert_return (invoke "self-exact-nonnullable-null-desc") (i32.const 1))
(assert_return (invoke "self-exact-nonnullable-val-desc") (i32.const 0))
(assert_return (invoke "self-exact-nonnullable-val-other") (i32.const 1))

(assert_trap (invoke "down-nullable-null-null") "null descriptor reference")
(assert_trap (invoke "down-nullable-val-null") "null descriptor reference")
(assert_return (invoke "down-nullable-null-desc") (i32.const 0))
(assert_return (invoke "down-nullable-val-desc") (i32.const 0))
(assert_return (invoke "down-nullable-val-other") (i32.const 1))

(assert_trap (invoke "down-nonnullable-null-null") "null descriptor reference")
(assert_trap (invoke "down-nonnullable-val-null") "null descriptor reference")
(assert_return (invoke "down-nonnullable-null-desc") (i32.const 1))
(assert_return (invoke "down-nonnullable-val-desc") (i32.const 0))
(assert_return (invoke "down-nonnullable-val-other") (i32.const 1))

(assert_trap (invoke "down-exact-nullable-null-null") "null descriptor reference")
(assert_trap (invoke "down-exact-nullable-val-null") "null descriptor reference")
(assert_return (invoke "down-exact-nullable-null-desc") (i32.const 0))
(assert_return (invoke "down-exact-nullable-val-desc") (i32.const 0))
(assert_return (invoke "down-exact-nullable-val-other") (i32.const 1))

(assert_trap (invoke "down-exact-nonnullable-null-null") "null descriptor reference")
(assert_trap (invoke "down-exact-nonnullable-val-null") "null descriptor reference")
(assert_return (invoke "down-exact-nonnullable-null-desc") (i32.const 1))
(assert_return (invoke "down-exact-nonnullable-val-desc") (i32.const 0))
(assert_return (invoke "down-exact-nonnullable-val-other") (i32.const 1))

(assert_trap (invoke "up-nullable-null-null") "null descriptor reference")
(assert_trap (invoke "up-nullable-val-null") "null descriptor reference")
(assert_return (invoke "up-nullable-null-desc") (i32.const 0))
(assert_return (invoke "up-nullable-val-desc") (i32.const 0))
(assert_return (invoke "up-nullable-val-other") (i32.const 1))

(assert_trap (invoke "up-nonnullable-null-null") "null descriptor reference")
(assert_trap (invoke "up-nonnullable-val-null") "null descriptor reference")
(assert_return (invoke "up-nonnullable-null-desc") (i32.const 1))
(assert_return (invoke "up-nonnullable-val-desc") (i32.const 0))
(assert_return (invoke "up-nonnullable-val-other") (i32.const 1))

(assert_trap (invoke "up-exact-nullable-null-null") "null descriptor reference")
(assert_trap (invoke "up-exact-nullable-val-null") "null descriptor reference")
(assert_return (invoke "up-exact-nullable-null-desc") (i32.const 0))
(assert_return (invoke "up-exact-nullable-val-other") (i32.const 1))

(assert_trap (invoke "up-exact-nonnullable-null-null") "null descriptor reference")
(assert_trap (invoke "up-exact-nonnullable-val-null") "null descriptor reference")
(assert_return (invoke "up-exact-nonnullable-null-desc") (i32.const 1))
(assert_return (invoke "up-exact-nonnullable-val-other") (i32.const 1))

(assert_trap (invoke "nodesc-nullable-null-null") "null descriptor reference")
(assert_trap (invoke "nodesc-nullable-val-null") "null descriptor reference")
(assert_return (invoke "nodesc-nullable-null-desc") (i32.const 0))
(assert_return (invoke "nodesc-nullable-val-other") (i32.const 1))

(assert_trap (invoke "nodesc-nonnullable-null-null") "null descriptor reference")
(assert_trap (invoke "nodesc-nonnullable-val-null") "null descriptor reference")
(assert_return (invoke "nodesc-nonnullable-null-desc") (i32.const 1))
(assert_return (invoke "nodesc-nonnullable-val-other") (i32.const 1))

(assert_trap (invoke "nodesc-exact-nullable-null-null") "null descriptor reference")
(assert_trap (invoke "nodesc-exact-nullable-val-null") "null descriptor reference")
(assert_return (invoke "nodesc-exact-nullable-null-desc") (i32.const 0))
(assert_return (invoke "nodesc-exact-nullable-val-other") (i32.const 1))

(assert_trap (invoke "nodesc-exact-nonnullable-null-null") "null descriptor reference")
(assert_trap (invoke "nodesc-exact-nonnullable-val-null") "null descriptor reference")
(assert_return (invoke "nodesc-exact-nonnullable-null-desc") (i32.const 1))
(assert_return (invoke "nodesc-exact-nonnullable-val-other") (i32.const 1))

(assert_trap (invoke "i31-nullable-null-null") "null descriptor reference")
(assert_trap (invoke "i31-nullable-val-null") "null descriptor reference")
(assert_return (invoke "i31-nullable-null-desc") (i32.const 0))
(assert_return (invoke "i31-nullable-val-other") (i32.const 1))

(assert_trap (invoke "i31-nonnullable-null-null") "null descriptor reference")
(assert_trap (invoke "i31-nonnullable-val-null") "null descriptor reference")
(assert_return (invoke "i31-nonnullable-null-desc") (i32.const 1))
(assert_return (invoke "i31-nonnullable-val-other") (i32.const 1))

(assert_trap (invoke "i31-exact-nullable-null-null") "null descriptor reference")
(assert_trap (invoke "i31-exact-nullable-val-null") "null descriptor reference")
(assert_return (invoke "i31-exact-nullable-null-desc") (i32.const 0))
(assert_return (invoke "i31-exact-nullable-val-other") (i32.const 1))

(assert_trap (invoke "i31-exact-nonnullable-null-null") "null descriptor reference")
(assert_trap (invoke "i31-exact-nonnullable-val-null") "null descriptor reference")
(assert_return (invoke "i31-exact-nonnullable-null-desc") (i32.const 1))
(assert_return (invoke "i31-exact-nonnullable-val-other") (i32.const 1))

(module
  (rec
    (type $a (descriptor $b) (struct))
    (type $b (describes $a) (struct))
  )

  (global $b1 (ref (exact $b)) (struct.new $b))
  (global $b2 (ref (exact $b)) (struct.new $b))
  (global $a1 (ref (exact $a)) (struct.new $a (global.get $b1)))

  (func $assert-eq-i32 (param i32 i32)
    (if
      (i32.eq (local.get 0) (local.get 1))
      (then (return))
      (else (unreachable))
    )
  )

  (func $assert-eq-ref (param eqref eqref)
    (if
      (ref.eq (local.get 0) (local.get 1))
      (then (return))
      (else (unreachable))
    )
  )

  (func (export "cast-succeeds-null")
    (block (result i32 i32 eqref)
      (i32.const 1)
      (i32.const 2)
      (ref.null none)
      (br_on_cast_desc_fail 0 eqref (ref null $a) (global.get $b1))
      (call $assert-eq-ref (ref.null none))
      (call $assert-eq-i32 (i32.const 2))
      (call $assert-eq-i32 (i32.const 1))
      (return)
    )
    (unreachable)
  )

  (func (export "cast-succeeds-val")
    (block (result i32 i32 eqref)
      (i32.const 1)
      (i32.const 2)
      (global.get $a1)
      (br_on_cast_desc_fail 0 eqref (ref null $a) (global.get $b1))
      (call $assert-eq-ref (global.get $a1))
      (call $assert-eq-i32 (i32.const 2))
      (call $assert-eq-i32 (i32.const 1))
      (return)
    )
    (unreachable)
  )

  (func (export "cast-fails-null")
    (block (result i32 i32 eqref)
      (i32.const 1)
      (i32.const 2)
      (ref.null none)
      (br_on_cast_desc_fail 0 eqref (ref $a) (global.get $b2))
      (unreachable)
    )
    (call $assert-eq-ref (ref.null none))
    (call $assert-eq-i32 (i32.const 2))
    (call $assert-eq-i32 (i32.const 1))
  )

  (func (export "cast-fails-val")
    (block (result i32 i32 eqref)
      (i32.const 1)
      (i32.const 2)
      (global.get $a1)
      (br_on_cast_desc_fail 0 eqref (ref $a) (global.get $b2))
      (unreachable)
    )
    (call $assert-eq-ref (global.get $a1))
    (call $assert-eq-i32 (i32.const 2))
    (call $assert-eq-i32 (i32.const 1))
  )
)

(assert_return (invoke "cast-succeeds-null"))
(assert_return (invoke "cast-succeeds-val"))
(assert_return (invoke "cast-fails-null"))
(assert_return (invoke "cast-fails-val"))
