# Developer Notes

These notes are for developers who want to contribute to the project and for me to remember how to do things.

## Setting up the development environment

python3 -m pip install flit
flit install --symlink

## Building the project

utitools uses [flit](https://flit.readthedocs.io/en/latest/) to build the project. To build the project, run the following command:

```bash
flit build
```

## Docs

Build docs with `mkdocs build` then deploy to GitHub pages with `mkdocs gh-deploy`

## Testing

Testing uses pytest. Use --doctest-glob to include the README.md file.

- `pytest --doctest-glob="*.md"`

## Publishing to PyPI

Update version using `bump-my-version bump minor --verbose`. (minor, major, patch, etc., use --dry-run if desired to see what will be changed)

Add and commit changes to git.

Then `flit build` followed by `flit publish`.

## Generating the uti.csv and uti_tree.json files

On non-macOS platforms, `utitools` does not have direct access to macOS UTI APIs. Instead, it relies on a cached dictionary loaded from a CSV (`uti.csv`) containing mappings of file extensions and UTIs. This provides a level of compatibility for platforms like Windows or Linux.

The CSV file must be generated using the script `generate_uti_csv.py` on macOS. The script calls the macOS APIs for every possible file extension under a specified lenght and writes the mappings to the CSV file. The CSV file must then be placed in `src/utitools`. This file is then used by `utitools` on non-macOS platforms. This is a hack but it works. PRs are welcome to improve this or provide a native way to get UTIs on non-macOS platforms.

There is also a `uti_tree.json` file that is used to look up content trees on non-macOS systems. This file is generated by the `generate_uti_tree.py` script which must be run on macOS then placed in the `src/utitools` directory.

## Creating stand-alone executables

If you are using `utitools` in a stand-alone executable, for example, using [pyinstaller](https://pyinstaller.org/en/stable/),
you will need to insure the packaging tool includes the `uti.csv` and `uti_tree.json` files in the packaged executable.

## Changelog

Use [auto-changelog](https://github.com/cookpete/auto-changelog):

- `auto-changelog --ignore-commit-pattern CHANGELOG -l 5`
