import logbook

from .utils import capturing_stderr_context


def test_default_format_unicode(logger):
    with capturing_stderr_context() as stream:
        logger.warning("\u2603")
    assert "WARNING: testlogger: \u2603" in stream.getvalue()


def test_default_format_encoded(logger):
    with capturing_stderr_context() as stream:
        # it's a string but it's in the right encoding so don't barf
        logger.warning("\u2603")
    assert "WARNING: testlogger: \u2603" in stream.getvalue()


def test_default_format_bad_encoding(logger):
    with capturing_stderr_context() as stream:
        # it's a string, is wrong, but just dump it in the logger,
        # don't try to decode/encode it
        logger.warning("Русский".encode("koi8-r"))
    expected = "WARNING: testlogger: b'\\xf2\\xd5\\xd3\\xd3\\xcb\\xc9\\xca'"
    assert expected in stream.getvalue()


def test_custom_unicode_format_unicode(logger):
    format_string = "[{record.level_name}] {record.channel}: {record.message}"
    with capturing_stderr_context() as stream:
        with logbook.StderrHandler(format_string=format_string):
            logger.warning("\u2603")
    assert "[WARNING] testlogger: \u2603" in stream.getvalue()


def test_custom_string_format_unicode(logger):
    format_string = "[{record.level_name}] {record.channel}: {record.message}"
    with capturing_stderr_context() as stream:
        with logbook.StderrHandler(format_string=format_string):
            logger.warning("\u2603")
    assert "[WARNING] testlogger: \u2603" in stream.getvalue()


def test_unicode_message_encoded_params(logger):
    with capturing_stderr_context() as stream:
        logger.warning("\u2603 {0}", "\u2603".encode())
    assert "WARNING: testlogger: \u2603 b'\\xe2\\x98\\x83'" in stream.getvalue()


def test_encoded_message_unicode_params(logger):
    with capturing_stderr_context() as stream:
        logger.warning("\u2603 {0}".encode(), "\u2603")
    assert "WARNING: testlogger: \u2603 \u2603" in stream.getvalue()
