import { Cell } from './widget';
import * as nbformat from '@jupyterlab/nbformat';
export declare namespace CellDragUtils {
    type ICellTargetArea = 'input' | 'prompt' | 'cell' | 'unknown';
    /**
     * Find the cell index containing the target html element.
     * This function traces up the DOM hierarchy to find the root cell
     * node. Then find the corresponding child and select it.
     *
     * @param node - the cell node or a child of the cell node.
     * @param cells - an iterable of Cells
     * @param isCellNode - a function that takes in a node and checks if
     * it is a cell node.
     *
     * @returns index of the cell we're looking for. Returns -1 if
     * the cell is not founds
     */
    function findCell(node: HTMLElement, cells: Iterable<Cell>, isCellNode: (node: HTMLElement) => boolean): number;
    /**
     * Detect which part of the cell triggered the MouseEvent
     *
     * @param cell - The cell which contains the MouseEvent's target
     * @param target - The DOM node which triggered the MouseEvent
     */
    function detectTargetArea(cell: Cell, target: HTMLElement): ICellTargetArea;
    /**
     * Detect if a drag event should be started. This is down if the
     * mouse is moved beyond a certain distance (DRAG_THRESHOLD).
     *
     * @param prevX - X Coordinate of the mouse pointer during the mousedown event
     * @param prevY - Y Coordinate of the mouse pointer during the mousedown event
     * @param nextX - Current X Coordinate of the mouse pointer
     * @param nextY - Current Y Coordinate of the mouse pointer
     */
    function shouldStartDrag(prevX: number, prevY: number, nextX: number, nextY: number): boolean;
    /**
     * Create an image for the cell(s) to be dragged
     *
     * @param activeCell - The cell from where the drag event is triggered
     * @param selectedCells - The cells to be dragged
     */
    function createCellDragImage(activeCell: Cell, selectedCells: nbformat.ICell[]): HTMLElement;
}
