// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import * as React from 'react';
import { TableOfContentsItem } from './tocitem';
/**
 * React component for a table of contents tree.
 */
export class TableOfContentsTree extends React.PureComponent {
    /**
     * Renders a table of contents tree.
     */
    render() {
        const { documentType } = this.props;
        return (React.createElement("ol", { className: "jp-TableOfContents-content", ...{ 'data-document-type': documentType } }, this.buildTree()));
    }
    /**
     * Convert the flat headings list to a nested tree list
     */
    buildTree() {
        if (this.props.headings.length === 0) {
            return [];
        }
        const buildOneTree = (currentIndex) => {
            const items = this.props.headings;
            const children = new Array();
            const current = items[currentIndex];
            let nextCandidateIndex = currentIndex + 1;
            while (nextCandidateIndex < items.length) {
                const candidateItem = items[nextCandidateIndex];
                if (candidateItem.level <= current.level) {
                    break;
                }
                const [child, nextIndex] = buildOneTree(nextCandidateIndex);
                children.push(child);
                nextCandidateIndex = nextIndex;
            }
            const currentTree = (React.createElement(TableOfContentsItem, { key: `${current.level}-${currentIndex}-${current.text}`, isActive: !!this.props.activeHeading && current === this.props.activeHeading, heading: current, onMouseDown: this.props.setActiveHeading, onCollapse: this.props.onCollapseChange }, children.length ? children : null));
            return [currentTree, nextCandidateIndex];
        };
        const trees = new Array();
        let currentIndex = 0;
        while (currentIndex < this.props.headings.length) {
            const [tree, nextIndex] = buildOneTree(currentIndex);
            trees.push(tree);
            currentIndex = nextIndex;
        }
        return trees;
    }
}
//# sourceMappingURL=toctree.js.map