import type { IRenderMime } from '@jupyterlab/rendermime-interfaces';
import { ServerConnection } from '@jupyterlab/services';
import { DataConnector, IDataConnector } from '@jupyterlab/statedb';
import { Token } from '@lumino/coreutils';
export type Language = {
    [key: string]: string;
};
/**
 * Translation connection interface.
 */
export interface ITranslatorConnector extends IDataConnector<Language, Language, {
    language: string;
}> {
}
/**
 * A service to connect to the server translation endpoint
 */
export declare const ITranslatorConnector: Token<ITranslatorConnector>;
export declare class TranslatorConnector extends DataConnector<Language, Language, {
    language: string;
}> implements ITranslatorConnector {
    constructor(translationsUrl?: string, serverSettings?: ServerConnection.ISettings);
    fetch(opts: {
        language: string;
    }): Promise<Language>;
    private _serverSettings;
    private _translationsUrl;
}
/**
 * Bundle of gettext-based translation functions for a specific domain.
 */
export type TranslationBundle = IRenderMime.TranslationBundle;
/**
 * Translation provider interface
 */
export interface ITranslator extends IRenderMime.ITranslator {
}
/**
 * Translation provider token
 */
export declare const ITranslator: Token<ITranslator>;
