import { IObservableJSON } from '@jupyterlab/observables';
import { ITranslator } from '@jupyterlab/translation';
import { Message } from '@lumino/messaging';
import { Widget } from '@lumino/widgets';
import { CodeEditor } from './editor';
/**
 * A widget for editing observable JSON.
 */
export declare class JSONEditor extends Widget {
    /**
     * Construct a new JSON editor.
     */
    constructor(options: JSONEditor.IOptions);
    /**
     * The code editor used by the editor.
     */
    readonly editor: CodeEditor.IEditor;
    /**
     * The code editor model used by the editor.
     */
    readonly model: CodeEditor.IModel;
    /**
     * The editor host node used by the JSON editor.
     */
    readonly headerNode: HTMLDivElement;
    /**
     * The editor host node used by the JSON editor.
     */
    readonly editorHostNode: HTMLDivElement;
    /**
     * The revert button used by the JSON editor.
     */
    readonly revertButtonNode: HTMLSpanElement;
    /**
     * The commit button used by the JSON editor.
     */
    readonly commitButtonNode: HTMLSpanElement;
    /**
     * The observable source.
     */
    get source(): IObservableJSON | null;
    set source(value: IObservableJSON | null);
    /**
     * Get whether the editor is dirty.
     */
    get isDirty(): boolean;
    /**
     * Dispose of the editor.
     */
    dispose(): void;
    /**
     * Handle the DOM events for the widget.
     *
     * @param event - The DOM event sent to the widget.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the notebook panel's node. It should
     * not be called directly by user code.
     */
    handleEvent(event: Event): void;
    /**
     * Handle `after-attach` messages for the widget.
     */
    protected onAfterAttach(msg: Message): void;
    /**
     * Handle `before-detach` messages for the widget.
     */
    protected onBeforeDetach(msg: Message): void;
    /**
     * Handle a change to the metadata of the source.
     */
    private _onSourceChanged;
    /**
     * Handle change events.
     */
    private _onModelChanged;
    /**
     * Handle blur events for the text area.
     */
    private _evtBlur;
    /**
     * Handle click events for the buttons.
     */
    private _evtClick;
    /**
     * Merge the user content.
     */
    private _mergeContent;
    /**
     * Set the value given the owner contents.
     */
    private _setValue;
    protected translator: ITranslator;
    private _trans;
    private _dataDirty;
    private _inputDirty;
    private _source;
    private _originalValue;
    private _changeGuard;
}
/**
 * The static namespace JSONEditor class statics.
 */
export declare namespace JSONEditor {
    /**
     * The options used to initialize a json editor.
     */
    interface IOptions {
        /**
         * The editor factory used by the editor.
         */
        editorFactory: CodeEditor.Factory;
        /**
         * The language translator.
         */
        translator?: ITranslator;
    }
}
