// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { Token } from '@lumino/coreutils';
export var ILanguageServerManager;
(function (ILanguageServerManager) {
    /**
     * LSP endpoint prefix.
     */
    ILanguageServerManager.URL_NS = 'lsp';
})(ILanguageServerManager || (ILanguageServerManager = {}));
/**
 * @alpha
 *
 * The virtual documents and language server connections manager
 * Require this token in your extension to access the associated virtual
 * document and LS connection of opened documents.
 *
 */
export const ILSPDocumentConnectionManager = new Token('@jupyterlab/lsp:ILSPDocumentConnectionManager', 'Provides the virtual documents and language server connections service.');
/**
 * @alpha
 *
 * The language server feature manager. Require this token in your extension
 * to register the client capabilities implemented by your extension.
 *
 */
export const ILSPFeatureManager = new Token('@jupyterlab/lsp:ILSPFeatureManager', 'Provides the language server feature manager. This token is required to register new client capabilities.');
/**
 * @alpha
 *
 * The code extractor manager. Require this token in your extension to
 * register new code extractors. Code extractor allows creating multiple
 * virtual documents from an opened document.
 *
 */
export const ILSPCodeExtractorsManager = new Token('@jupyterlab/lsp:ILSPCodeExtractorsManager', 'Provides the code extractor manager. This token is required in your extension to register code extractor allowing the creation of multiple virtual document from an opened document.');
/**
 * Method strings are reproduced here because a non-typing import of
 * `vscode-languageserver-protocol` is ridiculously expensive.
 */
export var Method;
(function (Method) {
    /** Server notifications */
    let ServerNotification;
    (function (ServerNotification) {
        ServerNotification["PUBLISH_DIAGNOSTICS"] = "textDocument/publishDiagnostics";
        ServerNotification["SHOW_MESSAGE"] = "window/showMessage";
        ServerNotification["LOG_TRACE"] = "$/logTrace";
        ServerNotification["LOG_MESSAGE"] = "window/logMessage";
    })(ServerNotification = Method.ServerNotification || (Method.ServerNotification = {}));
    /** Client notifications */
    let ClientNotification;
    (function (ClientNotification) {
        ClientNotification["DID_CHANGE"] = "textDocument/didChange";
        ClientNotification["DID_CHANGE_CONFIGURATION"] = "workspace/didChangeConfiguration";
        ClientNotification["DID_OPEN"] = "textDocument/didOpen";
        ClientNotification["DID_SAVE"] = "textDocument/didSave";
        ClientNotification["INITIALIZED"] = "initialized";
        ClientNotification["SET_TRACE"] = "$/setTrace";
    })(ClientNotification = Method.ClientNotification || (Method.ClientNotification = {}));
    /** Server requests */
    let ServerRequest;
    (function (ServerRequest) {
        ServerRequest["REGISTER_CAPABILITY"] = "client/registerCapability";
        ServerRequest["SHOW_MESSAGE_REQUEST"] = "window/showMessageRequest";
        ServerRequest["UNREGISTER_CAPABILITY"] = "client/unregisterCapability";
        ServerRequest["WORKSPACE_CONFIGURATION"] = "workspace/configuration";
    })(ServerRequest = Method.ServerRequest || (Method.ServerRequest = {}));
    /** Client requests */
    let ClientRequest;
    (function (ClientRequest) {
        ClientRequest["CODE_ACTION"] = "textDocument/codeAction";
        ClientRequest["COMPLETION"] = "textDocument/completion";
        ClientRequest["COMPLETION_ITEM_RESOLVE"] = "completionItem/resolve";
        ClientRequest["DEFINITION"] = "textDocument/definition";
        ClientRequest["DOCUMENT_COLOR"] = "textDocument/documentColor";
        ClientRequest["DOCUMENT_HIGHLIGHT"] = "textDocument/documentHighlight";
        ClientRequest["DOCUMENT_SYMBOL"] = "textDocument/documentSymbol";
        ClientRequest["HOVER"] = "textDocument/hover";
        ClientRequest["IMPLEMENTATION"] = "textDocument/implementation";
        ClientRequest["INITIALIZE"] = "initialize";
        ClientRequest["REFERENCES"] = "textDocument/references";
        ClientRequest["RENAME"] = "textDocument/rename";
        ClientRequest["SIGNATURE_HELP"] = "textDocument/signatureHelp";
        ClientRequest["TYPE_DEFINITION"] = "textDocument/typeDefinition";
        ClientRequest["LINKED_EDITING_RANGE"] = "textDocument/linkedEditingRange";
        ClientRequest["INLINE_VALUE"] = "textDocument/inlineValue";
        ClientRequest["INLAY_HINT"] = "textDocument/inlayHint";
        ClientRequest["WORKSPACE_SYMBOL"] = "workspace/symbol";
        ClientRequest["WORKSPACE_SYMBOL_RESOLVE"] = "workspaceSymbol/resolve";
        ClientRequest["FORMATTING"] = "textDocument/formatting";
        ClientRequest["RANGE_FORMATTING"] = "textDocument/rangeFormatting";
    })(ClientRequest = Method.ClientRequest || (Method.ClientRequest = {}));
})(Method || (Method = {}));
//# sourceMappingURL=tokens.js.map