/// <reference types="jest" />
import { ReadonlyJSONObject } from '@lumino/coreutils';
import { AttachedProperty } from '@lumino/properties';
import { ISignal } from '@lumino/signaling';
import { BaseManager } from './basemanager';
import { Contents } from './contents';
import { Kernel, KernelMessage } from './kernel';
import { KernelSpec } from './kernelspec';
import { ServiceManager } from './manager';
import { ServerConnection } from './serverconnection';
import { Session } from './session';
import { User, UserManager } from './user';
export declare const DEFAULT_NAME = "python3";
export declare const KERNELSPECS: {
    [key: string]: KernelSpec.ISpecModel;
};
export declare const KERNEL_MODELS: Kernel.IModel[];
export declare const NOTEBOOK_PATHS: {
    [kernelName: string]: string[];
};
/**
 * Clone a kernel connection.
 */
export declare function cloneKernel(kernel: Kernel.IKernelConnection): Kernel.IKernelConnection;
/**
 * A mock kernel object.
 *
 * @param model The model of the kernel
 */
export declare const KernelMock: jest.Mock<Kernel.IKernelConnection, [Private.RecursivePartial<Kernel.IKernelConnection.IOptions>], any>;
/**
 * A mock session connection.
 *
 * @param options Addition session options to use
 * @param model A session model to use
 */
export declare const SessionConnectionMock: jest.Mock<Session.ISessionConnection, [Private.RecursivePartial<Session.ISessionConnection.IOptions>, Kernel.IKernelConnection | null], any>;
/**
 * A mock contents manager.
 */
export declare const ContentsManagerMock: jest.Mock<Contents.IManager, [], any>;
/**
 * A mock sessions manager.
 */
export declare const SessionManagerMock: jest.Mock<Session.IManager, [], any>;
/**
 * A mock kernel specs manager
 */
export declare const KernelSpecManagerMock: jest.Mock<KernelSpec.IManager, [], any>;
/**
 * A mock service manager.
 */
export declare const ServiceManagerMock: jest.Mock<ServiceManager.IManager, [], any>;
/**
 * A mock kernel shell future.
 */
export declare const MockShellFuture: jest.Mock<Kernel.IShellFuture<KernelMessage.IShellMessage<KernelMessage.ShellMessageType>, KernelMessage.IShellMessage<KernelMessage.ShellMessageType>>, [KernelMessage.IShellMessage<KernelMessage.ShellMessageType>], any>;
export declare function changeKernel(kernel: Kernel.IKernelConnection, partialModel: Partial<Kernel.IModel>): Promise<Kernel.IKernelConnection>;
/**
 * A namespace for module private data.
 */
declare namespace Private {
    type RecursivePartial<T> = {
        [P in keyof T]?: RecursivePartial<T[P]>;
    };
    function createFile(options?: Contents.ICreateOptions): Contents.IModel;
    function fixSlash(path: string): string;
    function makeResponseError<T>(status: number): Promise<T>;
    function cloneKernel(options: RecursivePartial<Kernel.IKernelConnection.IOptions>): Kernel.IKernelConnection;
    function kernelSpecForKernelName(name: string): KernelSpec.ISpecModel;
    function getInfo(name: string): KernelMessage.IInfoReply;
    const RUNNING_KERNELS: Kernel.IKernelConnection[];
    const lastMessageProperty: AttachedProperty<Kernel.IKernelConnection, string>;
}
/**
 * The user API service manager.
 */
export declare class FakeUserManager extends BaseManager implements User.IManager {
    private _isReady;
    private _ready;
    private _identity;
    private _permissions;
    private _userChanged;
    private _connectionFailure;
    /**
     * Create a new user manager.
     */
    constructor(options: UserManager.IOptions | undefined, identity: User.IIdentity, permissions: ReadonlyJSONObject);
    /**
     * The server settings for the manager.
     */
    readonly serverSettings: ServerConnection.ISettings;
    /**
     * Test whether the manager is ready.
     */
    get isReady(): boolean;
    /**
     * A promise that fulfills when the manager is ready.
     */
    get ready(): Promise<void>;
    /**
     * Get the most recently fetched identity.
     */
    get identity(): User.IIdentity | null;
    /**
     * Get the most recently fetched permissions.
     */
    get permissions(): ReadonlyJSONObject | null;
    /**
     * A signal emitted when the user changes.
     */
    get userChanged(): ISignal<this, User.IUser>;
    /**
     * A signal emitted when there is a connection failure.
     */
    get connectionFailure(): ISignal<this, Error>;
    /**
     * Dispose of the resources used by the manager.
     */
    dispose(): void;
    /**
     * Force a refresh of the specs from the server.
     *
     * @returns A promise that resolves when the specs are fetched.
     *
     * #### Notes
     * This is intended to be called only in response to a user action,
     * since the manager maintains its internal state.
     */
    refreshUser(): Promise<void>;
}
export {};
