amends ".../snippetTest.pkl"

import "pkl:xml"

local function render(value: Any) = new xml.Renderer { xmlVersion = "1.0" }.renderValue(value)

examples {
  ["invalid attribute"] {
    module.catch(() ->
      render((xml.Element("bar")) {
        attributes {
          ["bar baz"] = "biz"
        }
      })
    )
  }
  ["colons are allowed"] {
    render((xml.Element("bar")) {
      attributes {
        ["xs:myTag"] = "my tag value"
      }
    })
  }
  ["escaping attribute values"] {
    render((xml.Element("bar")) {
      attributes {
        ["bar"] = "buz\"><script>maliciousThing();</script>"
      }
    })
  }
  ["invalid element name"] {
    module.catch(() ->
      render(xml.Element("bar>"))
    )
  }
  ["invalid empty element name"] {
    module.catch(() -> render((xml.Element("foo")) {
      name = ""
    }))
  }
  ["invalid empty attribute name"] {
    module.catch(() -> render((xml.Element("div")) {
      attributes {
        [""] = "bar"
      }
    }))
  }
  ["Unicode element name is not allowed"] {
    module.catch(() ->
      render(xml.Element("😍😎😡"))
    )
  }
  ["Unicode attribute name is not allowed"] {
    module.catch(() -> render((xml.Element("div")) {
        attributes {
          ["😍😎😡"] = "bar"
        }
      }))
  }
}
