class Person {
  name: String
  age: Int
  address: Address
  hobbies: List<String>
  friend: Person?
}

class Address {
  street: String
}

int = 123

float = 1.23

bool = true

string = "Pigeon"

unicodeString = "abc😀abc😎abc"

multiLineString = """
  have a
  great
  day
  """

list = List(
  123,
  1.23,
  bool,
  string,
  unicodeString,
  multiLineString,
  List(1, 2, 3),
  Set(1, 2, 3),
  Map("one", 1),
  new Dynamic { name = "Pigeon" }
)

set = Set(
  int,
  float,
  bool,
  string,
  unicodeString,
  multiLineString,
  List(1, 2, 3),
  Set(1, 2, 3),
  Map("one", 1),
  new Dynamic { name = "Pigeon" }
)

map = Map(
  "one", int,
  "two", float,
  "three", bool,
  "four", string,
  "five", unicodeString,
  "six", multiLineString,
  "seven", List(1, 2, 3),
  "eight", Set(1, 2, 3),
  "nine", Map("one", 1),
  "ten", new Dynamic { name = "Pigeon" },
  "eleven", null
)

listing = new Listing {
  123
  1.23
  bool
  string
  unicodeString
  multiLineString
  List(1, 2, 3)
  Set(1, 2, 3)
  Map("one", 1)
  new { name = "Pigeon" }
}

mapping = new Mapping {
  ["one"] = int
  ["two"] = float
  ["three"] = bool
  ["four"] = string
  ["five"] = unicodeString
  ["six"] = multiLineString
  ["seven"] = List(1, 2, 3)
  ["eight"] = Set(1, 2, 3)
  ["nine"] = Map("one", 1)
  ["ten"] = new { name = "Pigeon" }
  ["eleven"] = null
}

typedObject = new Person {
  name = "Pigeon"
  age = 30
  address {
    street = "Folsom St."
  }
  hobbies = List(
    "swimming",
    "gardening",
    "reading"
  )
  friend = null
}

container {
  name = "Pigeon"
  age = 30
  address {
    street = "Folsom St."
    hobbies = List(
      "swimming",
      "gardening",
      "reading"
    )
  }
  friend = null
}

output {
  renderer = new PropertiesRenderer {
    converters = (jsonValueRenderer.converters) {
      [Set]     = (it) -> jsonValueRenderer.renderValue(it)
      [List]    = (it) -> jsonValueRenderer.renderValue(it)
      [Listing] = (it) -> jsonValueRenderer.renderValue(it)
    }
  }
  local jsonValueRenderer = new JsonRenderer { indent = "" }
}
