/// module doc comment
@MyAnn { text = "module annotation" }
open module api.reflect.BaseModule

/// module property doc comment
@MyAnn { text = "module property annotation" }
int = 42
float = 12.3
string = "hello"
boolean = true
duration = 42.h
dataSize = 12.3.gb
pair = Pair(42, "hello")
list = List(1, 2, 3)
set = Set(1, 2, 3)
map = Map(1, "one", 2, "two", 3, "three")
listing = new Listing { 1; 2; 3 }
mapping = new Mapping { [1] = "one"; [2] = "two"; [3] = "three" }
dynamic = new Dynamic { name = "Pigeon"; age = 42 }
typed = new Person { age = 42 }

/// module method doc comment
@MyAnn { text = "module method annotation" }
function sing(person, songs) = "\(person.name) sings \(songs[0])"

int2: Int = 42
float2: Float = 12.3
string2: String = "hello"
boolean2: Boolean = true
duration2: Duration = 42.h
dataSize2: DataSize = 12.3.gb
pair2: Pair<Int, String> = Pair(42, "hello")
list2: List<Int> = List(1, 2, 3)
set2: Set<Int> = Set(1, 2, 3)
map2: Map<Int, String> = Map(1, "one", 2, "two", 3, "three")
listing2: Listing<Int> = new Listing { 1; 2; 3 }
mapping2: Mapping<Int, String> = new Mapping { [1] = "one"; [2] = "two"; [3] = "three" }
dynamic2: Dynamic = new Dynamic { name = "Pigeon"; age = 42 }
typed2: Person = new Person { age = 42 }

function sing2(person: Person, songs: List<String>): String = "\(person.name) sings \(songs[0])"

any: Any
noth: nothing
unkn: unknown
union: Int|List<String>|Person
nullable: Person?
stringLiteral: "yes"
constrained: String(length.isBetween(3, 10))
aliased: MyMap<Person>

hidden hiddenProp: String
const constProp: String = "the const prop"
fixed fixedProp: String = "the fixed prop"

/// class doc comment
@MyAnn { text = "class annotation" }
open class Person {
  name: String = "Pigeon"

  /// class property doc comment
  @MyAnn { text = "class property annotation"}
  age: Int = 42

  /// class method doc comment
  @MyAnn { text = "class method annotation" }
  function sing(songs: List<String>): String = "\(name) sings \(songs[0])"
}

class MyAnn extends Annotation {
  text: String
}

/// type alias doc comment
@MyAnn { text = "type alias annotation" }
typealias MyMap<V> = Map<String, V>(isEmpty)
