=head1 NAME

iPE::Util::Overlap::Node - Node type used for iPE::Overlap.

=head1 DESCRIPTION

The overlap object uses special nodes for insertion.  These are used to define intervals on which to detect overlaps.

=cut
package iPE::Util::Overlap::Node;
use iPE::Util::Interval;
use base("iPE::Util::Interval");
use Carp;
use strict;

=head1 FUNCTIONS

=over 8

=item new(hashref)

Creates a new overlap node.  The hashref must contain the keys 'low', 'high'  and 'letter' in order for it to properly construct the node.  The 'letter' key indicates which letter is used in the boundary coordinate.  Example:

    my $node = new iPE::Overlap::Node( {low => 20, high => "L-1", letter => "L"} );

You may also pass an optional object into the constructor, if you want the source of the interval to be accessible through the node object.

e.g.  {..., object => $feature}

=cut


=item overlaps(node)

Checks if the calling node overlaps the passed node.  Returns 1 if overlap.

=cut
sub overlaps {
    my ($n1, $n2) = @_;

    my @list = sort { $a->cmp($b) }
        ($n1->{low_}, $n1->{high_}, $n2->{low_}, $n2->{high_});

    #since equivalent coordinates don't evaluate to equal, the actual 
    #coordinates must be compared.
    if(($list[0]->coord eq $n1->{low_}->coord && 
            $list[1]->coord eq $n2->{low_}->coord) ||
       ($list[0]->coord eq $n2->{low_}->coord && 
            $list[1]->coord eq $n1->{low_}->coord))
            { return 1; }
    else    { return 0; }
}

=back

=head1 SEE ALSO

L<iPE::Overlap>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu).

=cut

1;
