=head1 NAME

iPE::Smoother::Pseudocount - A smoother which simply adds counts to the frequency counts.

=head1 DESCRIPTION

=head1 FUNCTIONS

=over 8

=cut

package iPE::Smoother::Pseudocount;
use base("iPE::Smoother");

=item init ()

Checks to see all parameters are sound for the pseudocount smoother.

=cut
sub init {
    my ($this) = @_;

    if(length($this->data) && $this->data =~ m/\S/ && 
            $this->data !~ m/^\s*[\d.]+\s*$/) {
        die "Invalidly formatted attribute pseudocounts $this->{data_} for Pseudocount smoother.\n".
            "Exexpecting format \"<num_pseudocounts>\"\n";
    }
    elsif($this->data !~ m/^\s*[\d.]+\s*$/) {
        $this->{data_} = 1;
    }
}

=item smoothArray (aref)

Adds counts to the array reference according to the data passed.

=cut
sub smoothAref {
    my ($this, $aref, $oldN) = @_;
    if(!defined($oldN)) { $oldN = $this->getArefTotal($aref); }

    for (my $i = 0; $i < scalar(@$aref) ; $i++) {
        $aref->[$i] += $this->data;
    }

    $this->renormalizeAref($aref, $oldN);
}

=item smoothHref (href)

Adds counts to all the keys in the passed hash reference.

=cut
sub smoothHref {
    my ($this, $href, $oldN) = @_;
    if(!defined($oldN)) { $oldN = $this->getHrefTotal($href); }

    for my $key (keys (%$href)) {
        $href->{$key} += $this->data;
    }

    $this->renormalizeHref($href, $oldN);
}

=back

=head1 SEE ALSO 

L<iPE::Smoother>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu).

=cut
1;
