#!/bin/bash

DEFAULT_PREFIX="/usr"
DEFAULT_DTD="share/sgml/dtd"
DEFAULT_DOC="share/iPE/doc"
DEFAULT_CONF="share/iPE/conf"

check_fail ()
{
    cmd=$1
    if [ $verbose -eq 1 ]; then
        $cmd
    else
        $cmd > /dev/null 2>&1
    fi
    exit_code=$?
    if [ $exit_code != "0" ]; then
        echo
        echo "Previous command failed."
        echo "Exit code $exit_code."
        echo "Output:"
        echo
        $cmd
        exit 1
    fi
}

echo
echo "iParameterEstimation installer"
echo "Copyright (C) 2005-2007 Washington University in Saint Louis"
echo "by Bob Zimmermann and Brent Lab"
echo "http://mblab.wustl.edu"
echo

# check if root.
id | grep "uid=0(" >/dev/null
if [ $? != "0" ]; then
    uname -a | grep -i CYGWIN >/dev/null
    if [ $? != "0" ]; then
        echo "You must be root to run install."
        echo ;
        exit 1;
    fi
fi

# check if we're in the right directory
if [ ! -f iPE.xs ]; then
    echo "Installer must be run from the toplevel iPE directory of the package."
    echo
    exit 1
fi

#check for verbosity
verbose=0
if [ $# -ge 1 ]; then
    if [ $1 = "-v" ]; then
        verbose=1
    else
        echo "Unknown option $1"
        echo "usage: $0 [-v]"
        echo
        exit 1
    fi
else
    echo "For verbose output, use $0 -v"
    echo
fi

echo "BE SURE TO USE ABSOLUTE PATHS FOR INSTALL DESTINATIONS"
echo 
echo "Please enter a prefix (or just press enter for the default)"
echo "where your bin and lib directories are"
echo -n "Install prefix: [$DEFAULT_PREFIX] "
read prefix

if [ -z $prefix ]; then
   prefix=$DEFAULT_PREFIX
fi

if [ ! -d $prefix ]; then
    mkdir -p $prefix
fi

echo
echo "A standard set of configuration files used for parameter estimation"
echo "come bundled in this package.  They should be place somewhere where"
echo "everyone can use them."
echo

echo -n "Where to put configuration files: [$prefix/$DEFAULT_CONF] "
read conf_dir

if [ -z $conf_dir ]; then
    conf_dir=$prefix/$DEFAULT_CONF
fi

if [ ! -d $conf_dir ]; then
    mkdir -p $conf_dir
fi

echo
echo "DTD files are description files which describe the format of XML files,"
echo "which are the input to iParameterEstimation.  They need to be system-wide"
echo "accessible in order to run iParamterEstimation."
echo

echo -n "Where to put DTD files: [$prefix/$DEFAULT_DTD] "
read dtd_dir

if [ -z $dtd_dir ]; then
   dtd_dir=$prefix/$DEFAULT_DTD
fi

if [ ! -d $dtd_dir ]; then
    mkdir -p $dtd_dir
fi

echo
echo "iParameterEstimation comes with user-level documentation in PDF form."
echo "You may install them anywhere on the system."
echo

echo -n "Where to put documentation: [$prefix/$DEFAULT_DOC] "
read doc_dir

if [ -z $doc_dir ]; then
    doc_dir=$prefix/$DEFAULT_DOC
fi

if [ ! -d $doc_dir ]; then
    mkdir -p $doc_dir
fi

echo "Attempting perl Makefile.PL..."
check_fail "perl Makefile.PL PREFIX=$prefix INSTALLDIRS=perl" 

echo "Attempting make..."
check_fail "make"

echo "Attempting make install..."
check_fail "make install"

echo "Installing DTD files..."
cp sgml/*.dtd $dtd_dir

echo "Installing scripts..."
cp scripts/* $prefix/bin

echo "Installing documentation..."
cp -r doc/example $doc_dir
cp doc/book/iPE-User-Guide.pdf $doc_dir/iPE-User-Guide.pdf

echo "Installing configuration files..."
cp -r conf/* $conf_dir

echo
echo "Installation complete."
echo "Set the system-wide SGML_SEARCH_PATH environment variable to $dtd_dir."
echo
