#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.20';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoG5XII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoR6m2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData12',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LevelInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::Canon::uuid',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GIF::Extensions',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::ColorBalanceUnknown2',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::DistortionInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ6III',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ8v2',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MenuSettingsZ9v5',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::VignetteInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ6III',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::DSA',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::LevelInfoK3III',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::AudioKeys',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::QuickTime::VideoKeys',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::HiddenInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag9406b',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::ACDSeeRegions',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GContainer',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::HDRGainMap',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apdi',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 115 => 0x69 },
	'about' => { 547 => 'about' },
	'aboutcvterm' => { 538 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 538 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 538 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 538 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 538 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 122 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 553 => 'absPeakAudioFilePath' },
	'academicfield' => { 543 => 'academicField' },
	'acceleration' => { 125 => 0x9404, 531 => 'Acceleration' },
	'accelerationtracking' => { 90 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 428 => 0x3 },
	'accelerometerdata' => { 417 => 'vrot' },
	'accelerometerx' => { 355 => 0x8d },
	'accelerometery' => { 355 => 0x8e },
	'accelerometerz' => { 355 => 0x8c },
	'accessoryserialnumber' => { 355 => 0x54 },
	'accessorytype' => { 355 => 0x53 },
	'acdseeregion' => { 497 => [\'Regions','RegionsRegionList'] },
	'acdseeregionalgarea' => { 497 => [\'Regions','RegionsRegionListALGArea'] },
	'acdseeregionalgareah' => { 497 => [\'Regions','RegionsRegionListALGAreaH'] },
	'acdseeregionalgareaw' => { 497 => [\'Regions','RegionsRegionListALGAreaW'] },
	'acdseeregionalgareax' => { 497 => [\'Regions','RegionsRegionListALGAreaX'] },
	'acdseeregionalgareay' => { 497 => [\'Regions','RegionsRegionListALGAreaY'] },
	'acdseeregionappliedtodimensions' => { 497 => [\'Regions','RegionsAppliedToDimensions'] },
	'acdseeregionappliedtodimensionsh' => { 497 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'acdseeregionappliedtodimensionsunit' => { 497 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'acdseeregionappliedtodimensionsw' => { 497 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'acdseeregiondlyarea' => { 497 => [\'Regions','RegionsRegionListDLYArea'] },
	'acdseeregiondlyareah' => { 497 => [\'Regions','RegionsRegionListDLYAreaH'] },
	'acdseeregiondlyareaw' => { 497 => [\'Regions','RegionsRegionListDLYAreaW'] },
	'acdseeregiondlyareax' => { 497 => [\'Regions','RegionsRegionListDLYAreaX'] },
	'acdseeregiondlyareay' => { 497 => [\'Regions','RegionsRegionListDLYAreaY'] },
	'acdseeregionname' => { 497 => [\'Regions','RegionsRegionListName'] },
	'acdseeregionnameassigntype' => { 497 => [\'Regions','RegionsRegionListNameAssignType'] },
	'acdseeregiontype' => { 497 => [\'Regions','RegionsRegionListType'] },
	'actionadvised' => { 138 => 0x2a },
	'activearea' => { 125 => 0xc68d },
	'actived-lighting' => { 243 => 0x22, 301 => 0x24 },
	'actived-lightingmode' => { 301 => 0x25 },
	'adaptervoltage' => { 145 => 0x407 },
	'addaspectratioinfo' => { 90 => 0x80e },
	'addiptcinformation' => { 90 => 0x815 },
	'additionalmodelinformation' => { 538 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 90 => 0x80f, 91 => 0x11, 92 => 0x13, 95 => 0x14 },
	'address' => { 168 => 'Address' },
	'adjustmentmode' => { 435 => 0x15 },
	'adlbracketingstep' => { 205 => 0x17 },
	'adlbracketingtype' => { 205 => 0x18 },
	'adobe' => { 126 => 'Adobe' },
	'adultcontentwarning' => { 341 => 'AdultContentWarning', 546 => 'adultContentWarning' },
	'advancedfilter' => { 133 => 0x1201 },
	'advancedraw' => { 303 => 0x76a43203 },
	'advancedscenetype' => { 355 => 0x3d },
	'advisory' => { 551 => 'Advisory' },
	'ae_iso' => { 363 => 0x2, 364 => 0x4, 365 => 0x12 },
	'aeaperture' => { 363 => 0x1, 364 => 0x3, 365 => 0x11 },
	'aeaperturesteps' => { 363 => 0x8, 364 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 90 => 0x104 },
	'aebbracketvalue' => { 82 => 0x11 },
	'aebracketingsteps' => { 205 => 0xf, 206 => 0xf, 283 => 0x174c },
	'aebsequence' => { 90 => 0x105 },
	'aebsequenceautocancel' => { 88 => 0x9, 89 => 0x9, 91 => 0x8, 92 => 0x9, 95 => 0x9, 96 => 0x7 },
	'aebshotcount' => { 90 => 0x106 },
	'aebxv' => { 363 => 0x4, 364 => 0x6 },
	'aeerror' => { 364 => 0x8 },
	'aeexposuretime' => { 363 => 0x0, 364 => 0x2, 365 => 0x10 },
	'aelbutton' => { 191 => 0x45 },
	'aelexposureindicator' => { 191 => 0x51 },
	'aelock' => { 191 => 0x5b, 312 => '4.2', 321 => '4.2', 331 => 0x201, 391 => 0x48, 445 => 0x40, 446 => 0x40, 447 => [0x86,0x286] },
	'aelockbutton' => { 310 => '16.1', 312 => '4.1', 315 => '15.1', 316 => '16.1', 317 => '16.1', 319 => '30.1', 320 => '16.1', 321 => '4.1', 323 => '17.1', 325 => '17.1' },
	'aelockbuttonplusdials' => { 310 => '16.2', 319 => '32.1', 323 => '44.1' },
	'aelockformb-d80' => { 325 => '3.1' },
	'aelockmetermodeafterfocus' => { 90 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 363 => 0x9, 364 => 0x10, 365 => 0x1c },
	'aemaxaperture2' => { 363 => 0xa, 364 => 0x11, 365 => 0x1d },
	'aemeteringmode' => { 363 => 0xc },
	'aemeteringmode2' => { 363 => '13.1' },
	'aemeteringsegments' => { 194 => 0x628, 391 => 0x209 },
	'aemicroadjustment' => { 90 => 0x110 },
	'aeminaperture' => { 363 => 0xb, 364 => 0x12, 365 => 0x1e },
	'aeminexposuretime' => { 363 => 0x5, 364 => 0x13, 365 => 0x1f },
	'aeprogrammode' => { 363 => 0x6 },
	'aeprojectlink' => { 525 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 525 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 525 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 525 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 525 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 525 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 37 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aestheticscore' => { 344 => 'aesthetic_score' },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 363 => 0xd },
	'aexv' => { 363 => 0x3, 364 => 0x5 },
	'af-assistilluminator' => { 326 => 0x1a, 327 => 0x19, 328 => 0x19, 329 => 0x19 },
	'af-cfocusdisplay' => { 327 => 0x234, 328 => 0x234, 329 => 0x24c },
	'af-cpriority' => { 134 => '0.2' },
	'af-cpriorityselection' => { 310 => '1.1', 311 => '1.1', 313 => '1.1', 314 => '1.1', 316 => '0.1', 317 => '0.1', 318 => '0.1', 319 => '1.1', 320 => '0.1', 323 => '1.1', 324 => '1.1', 326 => 0x3, 327 => 0x3, 328 => 0x3, 329 => 0x3 },
	'af-csetting' => { 130 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 130 => '0.2' },
	'af-ctrackingsensitivity' => { 130 => '0.1' },
	'af-czoneareaswitching' => { 130 => '0.3' },
	'af-onbutton' => { 313 => '70.1', 314 => '70.1', 324 => '70.1' },
	'af-onformb-d10' => { 310 => '3.3', 319 => '3.2' },
	'af-onformb-d11' => { 320 => '2.2' },
	'af-onformb-d12' => { 323 => '50.1' },
	'af-onoutoffocusrelease' => { 326 => 0x10, 327 => 0x10, 328 => 0x10, 329 => 0x10 },
	'af-spriority' => { 134 => '0.1' },
	'af-spriorityselection' => { 310 => '1.2', 311 => '1.2', 313 => '1.2', 314 => '1.2', 318 => '0.2', 319 => '1.2', 320 => '0.2', 323 => '1.2', 324 => '1.2', 326 => 0x5, 327 => 0x5, 328 => 0x5, 329 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 310 => '2.1', 311 => '2.1', 313 => '78.3', 314 => '78.3', 319 => '2.1', 323 => '2.1', 324 => '78.3', 326 => 0xf, 327 => 0xf, 328 => 0xf, 329 => 0xf },
	'afadjustment' => { 391 => 0x72, 400 => 0x267 },
	'afandmeteringbuttons' => { 90 => 0x701 },
	'afaperture' => { 236 => 0x5, 237 => 0x5, 241 => 0x5 },
	'afareaheight' => { 200 => [0x1a,0x34,0x50], 201 => 0x48 },
	'afareaillumination' => { 191 => 0x4b, 321 => '15.3' },
	'afareainitialheight' => { 258 => 0xbeb },
	'afareainitialwidth' => { 258 => 0xbea },
	'afareainitialxposition' => { 258 => 0xbe8 },
	'afareainitialyposition' => { 258 => 0xbe9 },
	'afareamode' => { 132 => '0.3', 187 => 0x33, 191 => 0xe, 199 => 0x0, 200 => 0x5, 201 => 0x5, 247 => 0x340, 249 => 0x224, 250 => 0x224, 251 => 0x210, 252 => 0x224, 253 => 0x224, 254 => 0x228, 355 => 0xf, 425 => 0x1205, 438 => [0xa,0x3a], 445 => 0x11, 446 => 0x10, 447 => 0x24, 459 => 0xb043, 485 => 0x17 },
	'afareamodesetting' => { 312 => '11.1', 315 => '0.1', 321 => '16.1', 325 => '2.1', 459 => 0x201c },
	'afareapointsize' => { 132 => '0.4' },
	'afareas' => { 331 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 90 => 0x51b },
	'afareawidth' => { 200 => [0x18,0x32,0x4e], 201 => 0x46 },
	'afareaxposition' => { 200 => [0x14,0x2e,0x4a], 201 => 0x42, 425 => 0x1203 },
	'afareaxposition1' => { 425 => 0x1201 },
	'afareayposition' => { 200 => [0x16,0x30,0x4c], 201 => 0x44, 425 => 0x1204 },
	'afareayposition1' => { 425 => 0x1202 },
	'afareazonesize' => { 132 => '0.5' },
	'afassist' => { 88 => 0x5, 96 => 0x5, 191 => 0x48, 310 => '2.5', 312 => '0.2', 315 => '0.2', 316 => '1.1', 317 => '1.1', 318 => '1.3', 319 => '2.4', 320 => '1.3', 321 => '0.2', 323 => '2.4', 325 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 90 => 0x50e, 91 => 0x4, 92 => 0x5, 93 => 0x4, 94 => 0x4, 95 => 0x5 },
	'afassistlamp' => { 355 => 0x31 },
	'afbuttonpressed' => { 447 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 366 => 0x6 },
	'afduringliveview' => { 90 => 0x511 },
	'affinea' => { 517 => 'AffineA' },
	'affineb' => { 517 => 'AffineB' },
	'affinec' => { 517 => 'AffineC' },
	'affined' => { 517 => 'AffineD' },
	'affinetune' => { 202 => 0x0, 249 => 0x6b0, 250 => 0x6c0, 251 => 0x5b0, 252 => 0x5e0, 253 => 0x5f8, 254 => 0x5fc, 331 => 0x306 },
	'affinetuneadj' => { 202 => 0x2, 276 => 0x2d1, 277 => 0x2dc, 331 => 0x307 },
	'affinetuneadjtele' => { 202 => 0x3 },
	'affinetuneindex' => { 202 => 0x1 },
	'affinex' => { 517 => 'AffineX' },
	'affiney' => { 517 => 'AffineY' },
	'afhold' => { 366 => 0x1fd },
	'afilluminator' => { 445 => 0x29, 459 => 0xb044 },
	'afimageheight' => { 200 => [0x12,0x2c,0x48], 201 => 0x40 },
	'afimagewidth' => { 200 => [0x10,0x2a,0x46], 201 => 0x3e },
	'afintegrationtime' => { 366 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 438 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 442 => 0x131 },
	'afmicroadjregisteredlenses' => { 442 => '305.1' },
	'afmicroadjustment' => { 90 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 442 => 0x130 },
	'afmode' => { 119 => 0x3009, 133 => 0x1022, 187 => 0x16, 435 => 0x5 },
	'afmoderestrictions' => { 311 => '50.3', 313 => '48.3', 314 => '48.3', 323 => '48.3', 324 => '48.3' },
	'afonaelockbuttonswitch' => { 90 => 0x702 },
	'afonbutton' => { 310 => '3.1', 311 => '47.1', 326 => 0x87, 327 => 0x83, 328 => 0x83, 329 => 0x83 },
	'afperformance' => { 1 => 0x23 },
	'afpoint' => { 37 => 0x13, 118 => 0x18, 187 => 0x15, 199 => 0x1, 334 => 0x308, 435 => 0x1f, 438 => [0x37,0x7], 442 => 0x19, 443 => 0x18, 444 => [0x18,0x20] },
	'afpointactivationarea' => { 89 => 0x11, 95 => 0x11 },
	'afpointareaexpansion' => { 90 => 0x508 },
	'afpointatshutterrelease' => { 438 => [0x39,0x9] },
	'afpointautoselection' => { 90 => 0x50b },
	'afpointbrightness' => { 90 => 0x50d, 310 => '2.4', 311 => '46.5', 313 => '2.2', 314 => '2.2', 323 => '2.3', 324 => '2.2' },
	'afpointdetails' => { 334 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 90 => 0x50c },
	'afpointillumination' => { 89 => 0xa, 310 => '2.3', 311 => '46.2', 313 => '47.2', 314 => '47.2', 318 => '1.2', 319 => '2.3', 320 => '1.2', 323 => '47.2', 324 => '47.2', 325 => '2.4' },
	'afpointinfocus' => { 438 => [0x38,0x8] },
	'afpointmode' => { 371 => 0x3 },
	'afpointposition' => { 119 => 0x2021, 355 => 0x4d },
	'afpointregistration' => { 88 => 0x7 },
	'afpoints' => { 190 => 0x10 },
	'afpointsel' => { 326 => 0xb, 327 => 0xb, 328 => 0xb, 329 => 0xb },
	'afpointselected' => { 191 => 0xd, 331 => 0x305, 391 => 0xe, 442 => 0x15, 443 => 0x14, 444 => [0x14,0x1c], 459 => 0x201e },
	'afpointselected2' => { 371 => 0x4 },
	'afpointselection' => { 89 => 0xb, 310 => '1.3', 311 => '1.3', 319 => '1.3', 323 => '1.3', 324 => '1.3' },
	'afpointselectionmethod' => { 90 => 0x50f, 91 => 0xc, 92 => 0xd, 95 => 0xd },
	'afpointsetting' => { 445 => 0x12, 446 => 0x11 },
	'afpointsinfocus' => { 82 => 0xe, 199 => 0x2, 200 => 0x30, 366 => 0xb, 367 => 0x4, 391 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 89 => 0xd },
	'afpointsselected' => { 200 => 0x1c, 367 => '4.1', 494 => 0x4 },
	'afpointsspecial' => { 367 => '4.2' },
	'afpointsunknown1' => { 366 => 0x0 },
	'afpointsunknown2' => { 366 => 0x2 },
	'afpointsused' => { 200 => [0xa,0x8], 201 => 0xa, 438 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 366 => 0x4 },
	'afresponse' => { 243 => 0xad },
	'afresult' => { 336 => 0x1038 },
	'afsearch' => { 331 => 0x303 },
	'afsensoractive' => { 187 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 425 => 0x1200 },
	'afstatus_00_b4' => { 441 => 0x0 },
	'afstatus_01_c4' => { 441 => 0x2 },
	'afstatus_02_d4' => { 441 => 0x4 },
	'afstatus_03_e4' => { 441 => 0x6 },
	'afstatus_04_f4' => { 441 => 0x8 },
	'afstatus_05_g4' => { 441 => 0xa },
	'afstatus_06_h4' => { 441 => 0xc },
	'afstatus_07_b3' => { 441 => 0xe },
	'afstatus_08_c3' => { 441 => 0x10 },
	'afstatus_09_d3' => { 441 => 0x12 },
	'afstatus_10_e3' => { 441 => 0x14 },
	'afstatus_11_f3' => { 441 => 0x16 },
	'afstatus_12_g3' => { 441 => 0x18 },
	'afstatus_13_h3' => { 441 => 0x1a },
	'afstatus_14_b2' => { 441 => 0x1c },
	'afstatus_15_c2' => { 441 => 0x1e },
	'afstatus_16_d2' => { 441 => 0x20 },
	'afstatus_17_e2' => { 441 => 0x22 },
	'afstatus_18_f2' => { 441 => 0x24 },
	'afstatus_19_g2' => { 441 => 0x26 },
	'afstatus_20_h2' => { 441 => 0x28 },
	'afstatus_21_c1' => { 441 => 0x2a },
	'afstatus_22_d1' => { 441 => 0x2c },
	'afstatus_23_e1' => { 441 => 0x2e },
	'afstatus_24_f1' => { 441 => 0x30 },
	'afstatus_25_g1' => { 441 => 0x32 },
	'afstatus_26_a7_vertical' => { 441 => 0x34 },
	'afstatus_27_a6_vertical' => { 441 => 0x36 },
	'afstatus_28_a5_vertical' => { 441 => 0x38 },
	'afstatus_29_c7_vertical' => { 441 => 0x3a },
	'afstatus_30_c6_vertical' => { 441 => 0x3c },
	'afstatus_31_c5_vertical' => { 441 => 0x3e },
	'afstatus_32_e7_vertical' => { 441 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 441 => 0x42 },
	'afstatus_34_e5_vertical' => { 441 => 0x44 },
	'afstatus_35_g7_vertical' => { 441 => 0x46 },
	'afstatus_36_g6_vertical' => { 441 => 0x48 },
	'afstatus_37_g5_vertical' => { 441 => 0x4a },
	'afstatus_38_i7_vertical' => { 441 => 0x4c },
	'afstatus_39_i6_vertical' => { 441 => 0x4e },
	'afstatus_40_i5_vertical' => { 441 => 0x50 },
	'afstatus_41_a7' => { 441 => 0x52 },
	'afstatus_42_b7' => { 441 => 0x54 },
	'afstatus_43_c7' => { 441 => 0x56 },
	'afstatus_44_d7' => { 441 => 0x58 },
	'afstatus_45_e7' => { 441 => 0x5a },
	'afstatus_46_f7' => { 441 => 0x5c },
	'afstatus_47_g7' => { 441 => 0x5e },
	'afstatus_48_h7' => { 441 => 0x60 },
	'afstatus_49_i7' => { 441 => 0x62 },
	'afstatus_50_a6' => { 441 => 0x64 },
	'afstatus_51_b6' => { 441 => 0x66 },
	'afstatus_52_c6' => { 441 => 0x68 },
	'afstatus_53_d6' => { 441 => 0x6a },
	'afstatus_54_e6_center' => { 441 => 0x6c },
	'afstatus_55_f6' => { 441 => 0x6e },
	'afstatus_56_g6' => { 441 => 0x70 },
	'afstatus_57_h6' => { 441 => 0x72 },
	'afstatus_58_i6' => { 441 => 0x74 },
	'afstatus_59_a5' => { 441 => 0x76 },
	'afstatus_60_b5' => { 441 => 0x78 },
	'afstatus_61_c5' => { 441 => 0x7a },
	'afstatus_62_d5' => { 441 => 0x7c },
	'afstatus_63_e5' => { 441 => 0x7e },
	'afstatus_64_f5' => { 441 => 0x80 },
	'afstatus_65_g5' => { 441 => 0x82 },
	'afstatus_66_h5' => { 441 => 0x84 },
	'afstatus_67_i5' => { 441 => 0x86 },
	'afstatus_68_c11' => { 441 => 0x88 },
	'afstatus_69_d11' => { 441 => 0x8a },
	'afstatus_70_e11' => { 441 => 0x8c },
	'afstatus_71_f11' => { 441 => 0x8e },
	'afstatus_72_g11' => { 441 => 0x90 },
	'afstatus_73_b10' => { 441 => 0x92 },
	'afstatus_74_c10' => { 441 => 0x94 },
	'afstatus_75_d10' => { 441 => 0x96 },
	'afstatus_76_e10' => { 441 => 0x98 },
	'afstatus_77_f10' => { 441 => 0x9a },
	'afstatus_78_g10' => { 441 => 0x9c },
	'afstatus_79_h10' => { 441 => 0x9e },
	'afstatus_80_b9' => { 441 => 0xa0 },
	'afstatus_81_c9' => { 441 => 0xa2 },
	'afstatus_82_d9' => { 441 => 0xa4 },
	'afstatus_83_e9' => { 441 => 0xa6 },
	'afstatus_84_f9' => { 441 => 0xa8 },
	'afstatus_85_g9' => { 441 => 0xaa },
	'afstatus_86_h9' => { 441 => 0xac },
	'afstatus_87_b8' => { 441 => 0xae },
	'afstatus_88_c8' => { 441 => 0xb0 },
	'afstatus_89_d8' => { 441 => 0xb2 },
	'afstatus_90_e8' => { 441 => 0xb4 },
	'afstatus_91_f8' => { 441 => 0xb6 },
	'afstatus_92_g8' => { 441 => 0xb8 },
	'afstatus_93_h8' => { 441 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 441 => 0xbc },
	'afstatusactivesensor' => { 187 => 0x2, 438 => [0x4,0x3b], 442 => 0x1e, 443 => 0x1b, 444 => [0x1b,0x21] },
	'afstatusbottom' => { 187 => 0x8, 442 => 0x2a, 443 => 0x21, 444 => 0x21 },
	'afstatusbottom-left' => { 187 => 0x12, 443 => 0x2b, 444 => 0x2b },
	'afstatusbottom-right' => { 187 => 0x6, 443 => 0x1f, 444 => 0x1f },
	'afstatusbottomassist-left' => { 442 => 0x28 },
	'afstatusbottomassist-right' => { 442 => 0x2c },
	'afstatusbottomhorizontal' => { 439 => 0x10, 440 => 0x1c },
	'afstatusbottomvertical' => { 439 => 0x16, 440 => 0x26 },
	'afstatuscenter-10' => { 442 => 0x34 },
	'afstatuscenter-11' => { 442 => 0x36 },
	'afstatuscenter-12' => { 442 => 0x38 },
	'afstatuscenter-14' => { 442 => 0x3c },
	'afstatuscenter-7' => { 442 => 0x2e },
	'afstatuscenter-9' => { 442 => 0x32 },
	'afstatuscenter-horizontal' => { 442 => 0x30 },
	'afstatuscenter-vertical' => { 442 => 0x3a },
	'afstatuscenterf2-8' => { 442 => 0x4c },
	'afstatuscenterhorizontal' => { 187 => 0x2f, 439 => 0xc, 440 => 0x18, 443 => 0x2f, 444 => 0x2f },
	'afstatuscentervertical' => { 187 => 0xc, 439 => 0x14, 440 => 0x22, 443 => 0x25, 444 => 0x25 },
	'afstatusfarleft' => { 439 => 0x6, 442 => 0x26 },
	'afstatusfarlefthorizontal' => { 440 => 0x4 },
	'afstatusfarleftvertical' => { 440 => 0x12 },
	'afstatusfarright' => { 439 => 0x18, 442 => 0x44 },
	'afstatusfarrighthorizontal' => { 440 => 0x2c },
	'afstatusfarrightvertical' => { 440 => 0x34 },
	'afstatusleft' => { 187 => 0x2d, 439 => 0x2, 442 => 0x22, 443 => 0x2d, 444 => 0x2d },
	'afstatuslefthorizontal' => { 440 => 0x6 },
	'afstatusleftvertical' => { 440 => 0xe },
	'afstatuslower-left' => { 439 => 0x4, 442 => 0x24 },
	'afstatuslower-lefthorizontal' => { 440 => 0xa },
	'afstatuslower-leftvertical' => { 440 => 0x10 },
	'afstatuslower-middle' => { 439 => 0x22, 440 => 0x24 },
	'afstatuslower-right' => { 439 => 0x1e, 442 => 0x4a },
	'afstatuslower-righthorizontal' => { 440 => 0x32 },
	'afstatuslower-rightvertical' => { 440 => 0x3a },
	'afstatuslowerfarleft' => { 440 => 0x8 },
	'afstatuslowerfarright' => { 440 => 0x30 },
	'afstatusmiddlehorizontal' => { 187 => 0xa, 443 => 0x23, 444 => 0x23 },
	'afstatusnearleft' => { 439 => 0xe, 440 => 0x1a },
	'afstatusnearright' => { 439 => 0xa, 440 => 0x16 },
	'afstatusright' => { 187 => 0x31, 439 => 0x1c, 442 => 0x48, 443 => 0x31, 444 => 0x31 },
	'afstatusrighthorizontal' => { 440 => 0x2e },
	'afstatusrightvertical' => { 440 => 0x38 },
	'afstatustop' => { 187 => 0xe, 442 => 0x40, 443 => 0x27, 444 => 0x27 },
	'afstatustop-left' => { 187 => 0x10, 443 => 0x29, 444 => 0x29 },
	'afstatustop-right' => { 187 => 0x4, 443 => 0x1d, 444 => 0x1d },
	'afstatustopassist-left' => { 442 => 0x3e },
	'afstatustopassist-right' => { 442 => 0x42 },
	'afstatustophorizontal' => { 439 => 0x8, 440 => 0x14 },
	'afstatustopvertical' => { 439 => 0x12, 440 => 0x1e },
	'afstatusupper-left' => { 439 => 0x0, 442 => 0x20 },
	'afstatusupper-lefthorizontal' => { 440 => 0x2 },
	'afstatusupper-leftvertical' => { 440 => 0xc },
	'afstatusupper-middle' => { 439 => 0x20, 440 => 0x20 },
	'afstatusupper-right' => { 439 => 0x1a, 442 => 0x46 },
	'afstatusupper-righthorizontal' => { 440 => 0x2a },
	'afstatusupper-rightvertical' => { 440 => 0x36 },
	'afstatusupperfarleft' => { 440 => 0x0 },
	'afstatusupperfarright' => { 440 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'afsubjectdetection' => { 355 => 0xe9 },
	'aftracking' => { 459 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 438 => 0x2 },
	'afwithshutter' => { 445 => 0x2a },
	'aggregateissuenumber' => { 543 => 'aggregateIssueNumber' },
	'aggregationtype' => { 543 => 'aggregationType' },
	'agreement' => { 546 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 145 => 0xe4e },
	'airplanemode' => { 247 => 0x9c0, 249 => 0x722, 250 => 0x732, 251 => 0x624, 252 => 0x654, 253 => 0x6bc, 254 => 0x6c0 },
	'aiservocontinuousshooting' => { 89 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 90 => 0x519 },
	'aiservoimagepriority' => { 90 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 90 => 0x51a },
	'aiservotrackingmethod' => { 90 => 0x504 },
	'aiservotrackingsensitivity' => { 89 => 0x14, 90 => 0x502 },
	'aisubjecttrackingmode' => { 331 => 0x309 },
	'album' => { 409 => ['albm',"\xa9alb"], 411 => 'album', 417 => ['albm',"\xa9alb"], 553 => 'album' },
	'albumartist' => { 186 => 'WM/AlbumArtist', 409 => 'aART', 417 => 'albr' },
	'albumcoverurl' => { 186 => 'WM/AlbumCoverURL' },
	'albumid' => { 409 => 'plID' },
	'albumtitle' => { 186 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 524 => 'AlreadyApplied', 526 => 'AlreadyApplied' },
	'alternatetitle' => { 543 => 'alternateTitle' },
	'alternatetitlea-lang' => { 543 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 543 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 543 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 204 => 0x6 },
	'alttapename' => { 553 => 'altTapeName' },
	'alttextaccessibility' => { 537 => 'AltTextAccessibility' },
	'alttimecode' => { 553 => 'altTimecode' },
	'alttimecodetimeformat' => { 553 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 553 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 553 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 421 => 0x5c },
	'ambientlight' => { 421 => 0x5e },
	'ambienttemperature' => { 125 => 0x9400, 419 => 0x14, 420 => 0x46, 421 => 0x50, 485 => 0x4, 531 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 419 => 0x13, 420 => 0x44, 421 => 0x4e },
	'analogbalance' => { 125 => 0xc627 },
	'analogcaptureiso' => { 145 => 0x89e },
	'analogisotable' => { 145 => 0x89d },
	'androidcapturefps' => { 411 => 'com.android.capture.fps' },
	'androidmake' => { 411 => 'com.android.manufacturer' },
	'androidmodel' => { 411 => 'com.android.model' },
	'androidversion' => { 411 => 'com.android.version' },
	'angleadj' => { 109 => 0x10003, 115 => 0x8b },
	'angleinforoll' => { 520 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 520 => 'AngleInfoYaw' },
	'anti-blur' => { 459 => 0xb04b },
	'antialiasstrength' => { 125 => 0xc632 },
	'antiflicker' => { 61 => 0x20 },
	'aperturelock' => { 311 => '38.2', 313 => '38.2', 314 => '38.2', 323 => '38.2', 324 => '38.2', 326 => 0xbc, 327 => 0xb8, 328 => 0xb8, 329 => 0xb8 },
	'aperturemode' => { 417 => 'apmd' },
	'aperturerange' => { 90 => 0x10d },
	'apertureringuse' => { 371 => '1.4' },
	'aperturesetting' => { 191 => 0x7, 445 => 0x30, 446 => 0x29, 447 => 0x1 },
	'aperturevalue' => { 99 => 0x2, 125 => 0x9202, 336 => 0x1002, 400 => 0x401, 530 => 'ApertureValue' },
	'appinfo' => { 500 => 'AppInfo' },
	'appinfoapplication' => { 500 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 500 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 500 => [\'AppInfo','AppInfoVersion'] },
	'apple_0x004e' => { 1 => 0x4e },
	'apple_0x004f' => { 1 => 0x4f },
	'applekeywords' => { 340 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 411 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 409 => 'apID' },
	'applestoreaccounttype' => { 409 => 'akID' },
	'applestorecatalogid' => { 409 => 'cnID' },
	'applestorecountry' => { 409 => 'sfID' },
	'applicationkeystring' => { 145 => 0x400 },
	'applicationnotes' => { 125 => 0x2bc, 360 => 0x2bc },
	'applicationrecordversion' => { 138 => 0x0 },
	'applyautomatically' => { 345 => 'ApplyAutomatically' },
	'applyshootingmeteringmode' => { 90 => 0x10e },
	'approved' => { 532 => 'Approved' },
	'approvedby' => { 532 => 'ApprovedBy' },
	'approximatefnumber' => { 350 => 0x313, 357 => 0x3406 },
	'approximatefocusdistance' => { 521 => 'ApproximateFocusDistance' },
	'appversion' => { 536 => 'AppVersion' },
	'aps-csizecapture' => { 478 => 0x114, 479 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 109 => 0x20914 },
	'armidentifier' => { 139 => 0x78 },
	'armversion' => { 139 => 0x7a },
	'arranger' => { 409 => "\xa9arg", 417 => "\xa9arg" },
	'arrangerkeywords' => { 417 => "\xa9ark" },
	'artdirector' => { 409 => "\xa9ard" },
	'artfilter' => { 331 => 0x529 },
	'artfiltereffect' => { 331 => 0x52f },
	'artist' => { 125 => 0x13b, 344 => 'Artist', 360 => 0x13b, 391 => 0x22e, 409 => "\xa9ART", 411 => 'artist', 417 => "\xa9ART", 549 => 'Artist', 553 => 'artist' },
	'artistid' => { 409 => 'atID' },
	'artmode' => { 119 => 0x301b },
	'artmodeparameters' => { 119 => 0x310b },
	'artwork' => { 411 => 'artwork' },
	'artworkcircadatecreated' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 538 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 538 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 335 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 335 => 0x1112, 391 => 0x80, 445 => 0x55, 446 => 0x55, 447 => 0xa, 472 => [0x192c,0x1a88], 473 => 0x192c, 474 => 0x1958, 475 => 0x192c, 476 => 0x188c },
	'assetid' => { 512 => 'AssetID' },
	'asshoticcprofile' => { 125 => 0xc68f },
	'asshotneutral' => { 125 => 0xc628 },
	'asshotpreprofilematrix' => { 125 => 0xc690 },
	'asshotprofilename' => { 125 => 0xc6f6 },
	'asshotwhitexy' => { 125 => 0xc629 },
	'assignbktbutton' => { 310 => '4.2', 311 => '16.1', 313 => '16.1', 314 => '16.1', 323 => '16.1', 324 => '16.1' },
	'assignfuncbutton' => { 90 => 0x70b },
	'assignmb-d17af-onbutton' => { 314 => '79.1' },
	'assignmb-d17funcbutton' => { 314 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 314 => '68.1' },
	'assignmb-d18af-onbutton' => { 324 => '79.1' },
	'assignmb-d18funcbutton' => { 324 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 324 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 313 => '75.1', 314 => '75.1', 324 => '75.1' },
	'assignmoviefunc2button' => { 313 => '82.1', 314 => '82.1', 324 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 313 => '75.2', 314 => '75.2', 324 => '75.2' },
	'assignmovierecordbutton' => { 311 => '43.2', 323 => '45.1', 326 => 0x9f, 327 => 0x9b, 328 => 0x9b, 329 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 313 => '45.1', 314 => '45.1', 324 => '45.1' },
	'assignmoviesubselector' => { 313 => '74.1', 314 => '74.1', 324 => '74.1' },
	'assignmoviesubselectorplusdials' => { 313 => '76.1', 314 => '76.1', 324 => '76.1' },
	'assignremotefnbutton' => { 311 => '54.1', 323 => '51.1' },
	'assistbuttonfunction' => { 88 => 0xd },
	'atcaptureusercrop' => { 145 => 0x943 },
	'attributionname' => { 522 => 'attributionName' },
	'attributionurl' => { 522 => 'attributionURL' },
	'audio' => { 355 => 0x20 },
	'audiobitrate' => { 72 => 0x6c, 538 => 'audioBitRate' },
	'audiobitratemode' => { 538 => 'audioBitRateMode' },
	'audiobitspersample' => { 538 => 'audioBitsPerSample' },
	'audiobutton' => { 328 => 0x17b, 329 => 0x193 },
	'audiobuttonplaybackmode' => { 328 => 0x1b9, 329 => 0x1d1 },
	'audiochannelcount' => { 538 => 'audioChannelCount' },
	'audiochannels' => { 72 => 0x70 },
	'audiochanneltype' => { 553 => 'audioChannelType' },
	'audiocompression' => { 90 => 0x816, 162 => 'Compression' },
	'audiocompressor' => { 553 => 'audioCompressor' },
	'audiodata' => { 503 => 'Data' },
	'audioduration' => { 138 => 0x99 },
	'audiogain' => { 408 => 'player.movie.audio.gain', 411 => 'player.movie.audio.gain' },
	'audiomimetype' => { 503 => 'Mime' },
	'audiomoddate' => { 553 => 'audioModDate' },
	'audiooutcue' => { 138 => 0x9a },
	'audiosamplerate' => { 72 => 0x6e, 553 => 'audioSampleRate' },
	'audiosampletype' => { 553 => 'audioSampleType' },
	'audiosamplingrate' => { 138 => 0x97 },
	'audiosamplingresolution' => { 138 => 0x98 },
	'audiotype' => { 138 => 0x96 },
	'author' => { 164 => 'Author', 340 => 'Author', 344 => 'Author', 407 => 'Author', 409 => ['auth',"\xa9aut"], 411 => 'author', 417 => 'auth', 518 => 'author', 540 => 'Author', 551 => 'Author' },
	'authorsposition' => { 541 => 'AuthorsPosition' },
	'authorurl' => { 186 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 90 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 381 => '0.1' },
	'autobracket' => { 435 => 0x19 },
	'autobracketing' => { 133 => 0x1100, 391 => 0x18, 425 => 0x1007 },
	'autobracketingmode' => { 322 => '12.3' },
	'autobracketingset' => { 322 => '12.1' },
	'autobracketmodem' => { 310 => '21.2', 311 => '13.3', 313 => '13.2', 314 => '13.2', 319 => '26.2', 323 => '13.3', 324 => '13.2', 326 => 0x63, 327 => 0x5f, 328 => 0x5f, 329 => 0x5f },
	'autobracketorder' => { 191 => 0x43, 310 => '21.3', 311 => '13.2', 313 => '13.1', 314 => '13.1', 319 => '26.3', 320 => '12.2', 321 => '2.2', 322 => '12.2', 323 => '13.2', 324 => '13.1', 325 => '13.2', 326 => 0x65, 327 => 0x61, 328 => 0x61, 329 => 0x61 },
	'autobracketset' => { 310 => '21.1', 311 => '13.1', 315 => '11.1', 316 => '12.1', 317 => '12.1', 319 => '26.1', 320 => '12.1', 321 => '2.1', 323 => '13.1', 325 => '13.1' },
	'autobrightness' => { 524 => 'AutoBrightness', 526 => 'AutoBrightness' },
	'autocapturecriteria' => { 203 => 0x1 },
	'autocapturecriteriamotiondirection' => { 203 => 0x5f },
	'autocapturecriteriamotionsize' => { 203 => 0x64 },
	'autocapturecriteriamotionspeed' => { 203 => 0x63 },
	'autocapturecriteriasubjectsize' => { 203 => 0x69 },
	'autocapturecriteriasubjecttype' => { 203 => 0x6a },
	'autocapturedframe' => { 203 => 0x0 },
	'autocapturedistancefar' => { 203 => 0x4a },
	'autocapturedistancenear' => { 203 => 0x4e },
	'autocapturepreset' => { 253 => 0x746, 254 => 0x74a },
	'autocapturerecordingtime' => { 203 => 0x37 },
	'autocapturewaittime' => { 203 => 0x38 },
	'autocontrast' => { 524 => 'AutoContrast', 526 => 'AutoContrast' },
	'autodistortioncontrol' => { 217 => 0x4, 247 => 0x2cf, 248 => 0x143 },
	'autodynamicrange' => { 133 => 0x140b },
	'autoexposure' => { 524 => 'AutoExposure', 526 => 'AutoExposure' },
	'autoexposurebracketing' => { 82 => 0x10 },
	'autoflashisosensitivity' => { 313 => '38.5', 314 => '38.5', 324 => '38.5', 326 => 0x5f, 327 => 0x5b, 328 => 0x5b, 329 => 0x5b },
	'autofocus' => { 334 => 0x209 },
	'autofocusmoderestrictions' => { 327 => 0x107, 328 => 0x107, 329 => 0x11d },
	'autofp' => { 321 => '7.3', 325 => '31.4' },
	'autoiso' => { 82 => 0x1, 119 => 0x3008, 247 => 0x288, 249 => 0x152, 250 => 0x152, 251 => 0x142, 252 => 0x156, 253 => 0x156, 254 => 0x15a, 312 => '1.1', 321 => '1.1' },
	'autoisomax' => { 312 => '1.2', 321 => '1.2' },
	'autoisominshutterspeed' => { 312 => '1.3', 321 => '1.3' },
	'autolateralca' => { 524 => 'AutoLateralCA', 526 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 67 => 0x2, 90 => 0x204, 109 => 0x20500, 115 => 0x6f },
	'autolightingoptimizeron' => { 109 => '0x20500.0', 115 => 0x6e },
	'autoportraitframed' => { 459 => 0x2016 },
	'autoredeye' => { 303 => 0xfe28a44f },
	'autorotate' => { 82 => 0x1b },
	'autoshadows' => { 524 => 'AutoShadows', 526 => 'AutoShadows' },
	'autotone' => { 524 => 'AutoTone', 526 => 'AutoTone' },
	'autotonedigest' => { 524 => 'AutoToneDigest', 526 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 524 => 'AutoToneDigestNoSat', 526 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 524 => 'AutoWhiteVersion', 526 => 'AutoWhiteVersion' },
	'auxiliaryimagetype' => { 519 => 'AuxiliaryImageType' },
	'auxiliarylens' => { 243 => 0x82 },
	'avaperturesetting' => { 371 => 0x13 },
	'averageblacklevel' => { 49 => 0xe7, 51 => 0xfb, 52 => 0x114, 53 => 0x146 },
	'averagelv' => { 194 => 0x38 },
	'avsettingwithoutlens' => { 90 => 0x707 },
	'azimuth' => { 172 => 'Azimuth' },
	'babyage' => { 355 => [0x8010,0x33] },
	'babyname' => { 355 => 0x66 },
	'backgroundalpha' => { 548 => 'bgalpha' },
	'balance' => { 408 => 'player.movie.audio.balance', 411 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 371 => 0x15 },
	'baseiso' => { 82 => 0x2, 103 => 0x101c, 145 => 0x903, 357 => 0x312a, 491 => 0x6 },
	'baseisodaylight' => { 145 => 0x910 },
	'baseisoflash' => { 145 => 0x913 },
	'baseisofluorescent' => { 145 => 0x912 },
	'baseisotungsten' => { 145 => 0x911 },
	'baselineexposure' => { 125 => 0xc62a },
	'baselineexposureoffset' => { 125 => 0xc7a5 },
	'baselinenoise' => { 125 => 0xc62b },
	'baselinesharpness' => { 125 => 0xc62c },
	'baserenditionishdr' => { 535 => 'BaseRenditionIsHDR' },
	'baseurl' => { 551 => 'BaseURL' },
	'bass' => { 408 => 'player.movie.audio.bass', 411 => 'player.movie.audio.bass' },
	'batterylevel' => { 355 => 0x38, 445 => 0x51, 449 => 0xc, 450 => 0x4, 451 => 0x4, 492 => 0x7, 493 => 0x5 },
	'batterylevel2' => { 493 => 0x7 },
	'batterylevelgrip1' => { 492 => 0x6 },
	'batterylevelgrip2' => { 492 => 0x8 },
	'batteryorder' => { 310 => '12.5', 319 => '13.2', 320 => '2.1', 323 => '3.1' },
	'batterystate' => { 191 => 0x60, 445 => 0x50, 451 => 0x14 },
	'batterytemperature' => { 449 => 0x1, 451 => 0x2, 492 => 0x5 },
	'batterytype' => { 69 => 0x38, 421 => 0x66 },
	'batteryunknown' => { 449 => 0x2, 451 => 0x0 },
	'batteryvoltage' => { 145 => 0x408, 419 => 0x2a, 420 => 0x49, 421 => 0x62, 449 => 0x8 },
	'batteryvoltage1' => { 451 => 0x6 },
	'batteryvoltage2' => { 451 => 0x8 },
	'batteryvoltageavg' => { 421 => 0x64 },
	'bayergreensplit' => { 125 => 0xc62d },
	'bayerpattern' => { 144 => 0xf902, 195 => 0x17 },
	'beatsperminute' => { 409 => 'tmpo' },
	'beatspliceparams' => { 553 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 553 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 553 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 553 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 553 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 553 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 310 => '13.1', 311 => '5.4', 312 => '0.1', 315 => '2.1', 316 => '3.1', 317 => '3.1', 319 => '10.1', 321 => '0.1', 323 => '5.5', 325 => '4.1' },
	'beeppitch' => { 320 => '3.1' },
	'beepvolume' => { 320 => '4.5' },
	'bestqualityscale' => { 125 => 0xc65c },
	'bestshotmode' => { 119 => 0x3007 },
	'bitdepth' => { 169 => 'BitDepth', 195 => 0x11, 269 => 0x41 },
	'bitspercomponent' => { 140 => 0x87 },
	'bitspersample' => { 125 => 0x102, 360 => 0xa, 549 => 'BitsPerSample' },
	'blackacquirerows' => { 145 => 0x18ba },
	'blacklevel' => { 125 => [0x7310,0xc61a], 214 => 0x20, 243 => 0x3d, 336 => [0x401,0x1012], 400 => 0x21d, 466 => [0x7300,0x7310] },
	'blacklevel2' => { 335 => 0x600, 339 => 0x600 },
	'blacklevelblue' => { 360 => 0x1e },
	'blacklevelbottom' => { 145 => 0x3f0 },
	'blackleveldata' => { 400 => 0x223 },
	'blackleveldeltah' => { 125 => 0xc61b },
	'blackleveldeltav' => { 125 => 0xc61c },
	'blacklevelgreen' => { 360 => 0x1d },
	'blacklevelred' => { 360 => 0x1c },
	'blacklevelrepeatdim' => { 125 => 0xc619 },
	'blacklevelrough' => { 145 => 0x40e },
	'blacklevelroughafter' => { 145 => 0x416 },
	'blacklevels' => { 38 => 0x1d },
	'blackleveltop' => { 145 => 0x3ef },
	'blackpoint' => { 391 => 0x200 },
	'blacks2012' => { 524 => 'Blacks2012', 526 => 'Blacks2012' },
	'blacksadj' => { 496 => 0x9018 },
	'bleachbypasstoning' => { 391 => 0x7f },
	'blockshotafresponse' => { 313 => '1.5', 314 => '1.5', 324 => '1.5', 326 => 0x7, 327 => 0x7, 328 => 0x7, 329 => 0x7 },
	'blogtitle' => { 543 => 'blogTitle' },
	'blogurl' => { 543 => 'blogURL' },
	'bluebalance' => { 336 => 0x1018, 360 => 0x12, 391 => 0x1b },
	'bluecurvelimits' => { 114 => 0x1fe },
	'bluecurvepoints' => { 113 => 0x79, 114 => 0x1d4 },
	'bluehsl' => { 109 => 0x20915 },
	'bluehue' => { 524 => 'BlueHue', 526 => 'BlueHue' },
	'bluesaturation' => { 524 => 'BlueSaturation', 526 => 'BlueSaturation' },
	'bluratinfinity' => { 508 => 'BlurAtInfinity' },
	'blurcontrol' => { 391 => 0x82 },
	'blurwarning' => { 133 => 0x1300 },
	'bodybatteryadload' => { 369 => 0x3 },
	'bodybatteryadnoload' => { 369 => 0x2 },
	'bodybatterypercent' => { 369 => 0x3 },
	'bodybatterystate' => { 369 => ['1.1',0x2] },
	'bodybatteryvoltage' => { 369 => 0x4 },
	'bodybatteryvoltage1' => { 369 => 0x2 },
	'bodybatteryvoltage2' => { 369 => 0x4 },
	'bodybatteryvoltage3' => { 369 => 0x6 },
	'bodybatteryvoltage4' => { 369 => 0x8 },
	'bodyfirmware' => { 426 => 0x0 },
	'bodyfirmwareversion' => { 332 => 0x104, 333 => 0x100, 336 => 0x104 },
	'bodyserialnumber' => { 426 => 0x10 },
	'bookedition' => { 543 => 'bookEdition' },
	'bootloaderversion' => { 420 => 0x26 },
	'bracketbutton' => { 250 => 0x808, 253 => 0x80c, 254 => 0x810 },
	'bracketbuttonplaybackmode' => { 250 => 0x810, 253 => 0x816, 254 => 0x81a },
	'bracketincrement' => { 247 => 0x34a, 249 => 0x22e, 250 => 0x22e, 251 => 0x21a, 252 => 0x22e, 253 => 0x22e, 254 => 0x232 },
	'bracketmode' => { 61 => 0x3 },
	'bracketprogram' => { 247 => 0x348, 249 => 0x22c, 250 => 0x22c, 251 => 0x218, 252 => 0x22c, 253 => 0x22c, 254 => 0x230 },
	'bracketsequence' => { 119 => 0x301d },
	'bracketset' => { 247 => 0x346, 249 => 0x22a, 250 => 0x22a, 251 => 0x216, 252 => 0x22a, 253 => 0x22a, 254 => 0x22e },
	'bracketsettings' => { 355 => 0x45 },
	'bracketshotnumber' => { 61 => 0x5, 371 => 0x9, 456 => 0x2b },
	'bracketshotnumber2' => { 456 => 0x2d },
	'bracketstep' => { 188 => 0xe },
	'bracketvalue' => { 61 => 0x4 },
	'brightness' => { 125 => 0xfe53, 163 => 'Brightness', 183 => 'Brightness', 188 => 0x2c, 261 => 0x34, 262 => 0x39, 263 => 0x41, 411 => 'player.movie.visual.brightness', 419 => 0x25, 421 => 0x54, 445 => 0x22, 459 => 0x2007, 524 => 'Brightness', 526 => 'Brightness' },
	'brightnessadj' => { 114 => 0x114, 296 => 0x0, 306 => 0x2d, 496 => 0x8018 },
	'brightnessvalue' => { 125 => 0x9203, 194 => [0x691,0x49c3], 336 => 0x1003, 464 => 0x1e, 468 => 0x1140, 469 => 0x1140, 470 => 0x111c, 471 => 0x1198, 472 => 0x1174, 473 => 0x102c, 474 => 0x224, 475 => 0x224, 476 => 0x219, 530 => 'BrightnessValue' },
	'buildnumber' => { 198 => 0x5500 },
	'bulbduration' => { 82 => 0x18 },
	'burstcount' => { 145 => 0x40d },
	'burstgroupid' => { 245 => 0x4 },
	'burstid' => { 504 => 'BurstID' },
	'burstmode' => { 147 => 0xa, 355 => 0x2a },
	'burstmode2' => { 147 => 0x18 },
	'burstprimary' => { 504 => 'BurstPrimary' },
	'burstshot' => { 435 => 0x34 },
	'burstspeed' => { 355 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 90 => 0x70a },
	'bwadjustment' => { 133 => 0x1049 },
	'bwfilter' => { 188 => 0x2a, 196 => 0x39 },
	'bwmagentagreen' => { 133 => 0x104b },
	'bwmode' => { 336 => 0x203 },
	'by-line' => { 138 => 0x50 },
	'by-linetitle' => { 138 => 0x55 },
	'bytecount' => { 543 => 'byteCount' },
	'c14configuration' => { 145 => 0x1964 },
	'cacheversion' => { 125 => 0xc7aa },
	'calibratedfocallength' => { 122 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 122 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 122 => 'CalibratedOpticalCenterY' },
	'calibration' => { 435 => [0x24,0x30] },
	'calibrationhistory' => { 145 => 0x9c9 },
	'calibrationilluminant1' => { 125 => 0xc65a },
	'calibrationilluminant2' => { 125 => 0xc65b },
	'calibrationilluminant3' => { 125 => 0xcd31 },
	'calibrationversion' => { 145 => 0x9c6 },
	'callforimage' => { 512 => 'CallForImage' },
	'camera' => { 500 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 417 => 'angl', 553 => 'cameraAngle' },
	'cameraappinfo' => { 500 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 500 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 500 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 500 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 506 => 'CameraBurstID' },
	'cameracalibration' => { 435 => 0x11f },
	'cameracalibration1' => { 125 => 0xc623 },
	'cameracalibration2' => { 125 => 0xc624 },
	'cameracalibration3' => { 125 => 0xcd32 },
	'cameracalibrationsig' => { 125 => 0xc6f3 },
	'cameracolorcalibration01' => { 39 => 0x0, 40 => 0x0 },
	'cameracolorcalibration02' => { 39 => 0x4, 40 => 0x5 },
	'cameracolorcalibration03' => { 39 => 0x8, 40 => 0xa },
	'cameracolorcalibration04' => { 39 => 0xc, 40 => 0xf },
	'cameracolorcalibration05' => { 39 => 0x10, 40 => 0x14 },
	'cameracolorcalibration06' => { 39 => 0x14, 40 => 0x19 },
	'cameracolorcalibration07' => { 39 => 0x18, 40 => 0x1e },
	'cameracolorcalibration08' => { 39 => 0x1c, 40 => 0x23 },
	'cameracolorcalibration09' => { 39 => 0x20, 40 => 0x28 },
	'cameracolorcalibration10' => { 39 => 0x24, 40 => 0x2d },
	'cameracolorcalibration11' => { 39 => 0x28, 40 => 0x32 },
	'cameracolorcalibration12' => { 39 => 0x2c, 40 => 0x37 },
	'cameracolorcalibration13' => { 39 => 0x30, 40 => 0x3c },
	'cameracolorcalibration14' => { 39 => 0x34, 40 => 0x41 },
	'cameracolorcalibration15' => { 39 => 0x38, 40 => 0x46 },
	'cameradepthmap' => { 500 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 500 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 500 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 500 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 500 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 500 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 500 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 500 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 500 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 500 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 500 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 500 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 411 => 'direction.facing' },
	'camerae-mountversion' => { 495 => 0xb },
	'cameraelevationangle' => { 125 => 0x9405, 531 => 'CameraElevationAngle' },
	'camerafilename' => { 512 => 'CameraFilename' },
	'camerafirmware' => { 125 => 0xa439, 531 => 'CameraFirmware' },
	'cameraid' => { 336 => 0x209, 417 => 'cmid', 434 => 0x209 },
	'cameraidentifier' => { 418 => 'camera.identifier' },
	'cameraimage' => { 500 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 500 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 500 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 500 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 500 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 500 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 500 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 500 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 500 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 500 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 500 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 500 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 500 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 500 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 37 => 0x10 },
	'cameralabel' => { 125 => 0xc7a1, 553 => 'cameraLabel' },
	'cameralightestimate' => { 500 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 500 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 500 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 500 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 500 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 512 => 'CameraMakeModel' },
	'cameramodel' => { 400 => 0x410, 553 => 'cameraModel' },
	'cameramodelid' => { 183 => 'CameraModelID' },
	'cameramodelrestriction' => { 524 => 'CameraModelRestriction', 526 => 'CameraModelRestriction' },
	'cameramotion' => { 411 => 'direction.motion' },
	'cameramove' => { 553 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 355 => 0x8f, 390 => 0x1, 395 => 0x1, 400 => 0x100, 451 => [0x16,0x18], 482 => 0x28, 483 => 0x24, 484 => 0x29 },
	'cameraowner' => { 148 => 0xc353 },
	'cameraparameters' => { 336 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 121 => 0x9, 417 => "\xa9gpt" },
	'camerapointcloud' => { 500 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 500 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 500 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 500 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 500 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 500 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 500 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 500 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 500 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 500 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 500 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 500 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 500 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 524 => 'CameraProfile', 526 => 'CameraProfile' },
	'cameraprofiledigest' => { 524 => 'CameraProfileDigest', 526 => 'CameraProfileDigest' },
	'cameraprofiles' => { 541 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 541 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 541 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 541 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 541 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 541 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 541 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 541 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 541 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 541 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 541 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 541 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 541 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 541 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 541 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 541 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 541 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 541 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 541 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 541 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 541 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 541 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 541 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 115 => 0xe1 },
	'camerarawcontrast' => { 115 => 0xe3 },
	'camerarawhighlightpoint' => { 115 => 0xe6 },
	'camerarawlinear' => { 115 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 115 => 0xe8 },
	'camerarawoutputshadowpoint' => { 115 => 0xe9 },
	'camerarawsaturation' => { 115 => 0xe2 },
	'camerarawshadowpoint' => { 115 => 0xe7 },
	'camerarawsharpness' => { 115 => 0xe5 },
	'cameraroll' => { 121 => 0xb, 417 => "\xa9grl" },
	'cameras' => { 500 => 'Cameras' },
	'cameraserialnumber' => { 125 => 0xc62f, 185 => 'CameraSerialNumber', 512 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 331 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 31 => [0x87,0x91], 32 => [0x99,0x9f,0xa4,0xa8,0x105], 36 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 82 => 0xc, 145 => 0x406, 335 => 0x1306, 350 => 0x320, 357 => 0x3402, 391 => 0x47, 432 => 0x43, 486 => 0x5 },
	'cameratemperature4' => { 396 => 0x14 },
	'cameratemperature5' => { 396 => 0x16 },
	'cameratemperaturerangemax' => { 127 => 0x5 },
	'cameratemperaturerangemin' => { 127 => 0x6 },
	'cameratrait' => { 500 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 1 => 0x2e, 82 => 0x1a, 336 => 0x207 },
	'cameratype2' => { 332 => 0x100 },
	'cameravendorinfo' => { 500 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 500 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 500 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 500 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 121 => 0xa, 417 => "\xa9gyw" },
	'camreverse' => { 122 => 'CamReverse' },
	'canondr4' => { 126 => 'CanonDR4' },
	'canonexposuremode' => { 37 => 0x14 },
	'canonfiledescription' => { 103 => 0x805 },
	'canonfilelength' => { 69 => 0xe },
	'canonfirmwareversion' => { 69 => 0x7, 103 => 0x80b },
	'canonflashinfo' => { 103 => 0x1028 },
	'canonflashmode' => { 37 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 37 => 0xa },
	'canonimagetype' => { 69 => 0x6, 103 => 0x815 },
	'canonlogversion' => { 68 => 0xb },
	'canonmodelid' => { 69 => 0x10, 103 => 0x1834 },
	'canonvrd' => { 126 => 'CanonVRD' },
	'caption' => { 518 => 'caption' },
	'caption-abstract' => { 138 => 0x78 },
	'captionsauthornames' => { 529 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 529 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 541 => 'CaptionWriter' },
	'captureframerate' => { 119 => 0x4001 },
	'captureheightnormal' => { 145 => 0x1839 },
	'capturelook' => { 145 => 0xc48 },
	'capturemode' => { 418 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 510 => 'CaptureSoftware' },
	'capturewidthnormal' => { 145 => 0x1838 },
	'capturewidthtest' => { 145 => 0x1842 },
	'cardshutterlock' => { 191 => 0x49 },
	'casioimagesize' => { 119 => 0x9 },
	'catalogsets' => { 138 => 0xff, 502 => 'CatalogSets', 516 => 'CatalogSets' },
	'categories' => { 69 => 0x23, 518 => 'categories' },
	'category' => { 138 => 0xf, 186 => 'WM/Category', 330 => 0x30, 409 => 'catg', 541 => 'Category' },
	'cbcrgain' => { 432 => 0xa036 },
	'cbcrgaindefault' => { 432 => 0xa035 },
	'cbcrmatrix' => { 432 => 0xa034 },
	'cbcrmatrixdefault' => { 432 => 0xa033 },
	'ccdboardversion' => { 350 => 0x331 },
	'ccdscanmode' => { 336 => 0x1039 },
	'ccdsensitivity' => { 292 => 0x6 },
	'ccdversion' => { 350 => 0x330 },
	'ccvavgluminancenits' => { 534 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 534 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 534 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 534 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 534 => 'ccv_white_xy' },
	'cellglobalid' => { 523 => 'cgi' },
	'celllength' => { 125 => 0x109 },
	'cellr' => { 523 => 'r' },
	'celltowerid' => { 523 => 'cellid' },
	'cellwidth' => { 125 => 0x108 },
	'centerafarea' => { 321 => '15.1' },
	'centerfocuspoint' => { 325 => '2.2' },
	'centerpixel' => { 145 => 0x40c },
	'centerweightedareasize' => { 310 => '7.1', 311 => '8.1', 313 => '8.1', 314 => '8.1', 318 => '7.1', 319 => '5.1', 320 => '7.1', 321 => '6.3', 323 => '8.1', 324 => '8.1', 325 => '8.1', 326 => 0x21, 327 => 0x1f, 328 => 0x1f, 329 => 0x1f },
	'certificate' => { 557 => 'Certificate' },
	'cfainterpolationalgorithm' => { 145 => 0xe60 },
	'cfainterpolationmetric' => { 145 => 0xe61 },
	'cfaoffsetcols' => { 145 => 0xc71 },
	'cfaoffsetrows' => { 145 => 0xc6f },
	'cfapattern' => { 125 => 0xa302, 360 => 0x9, 530 => 'CFAPattern' },
	'cfapattern2' => { 125 => 0x828e },
	'cfapatterncolumns' => { 530 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 530 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 530 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 125 => 0x828d },
	'cfazipperfixthreshold' => { 145 => 0xe62 },
	'channel' => { 543 => 'channel' },
	'channela-lang' => { 543 => [\'channel','channelA-lang'] },
	'channelchannel' => { 543 => [\'channel','channelChannel'] },
	'channels' => { 162 => 'Channels' },
	'channelsubchannel1' => { 543 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 543 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 543 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 543 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 417 => 'chpl' },
	'checkmark' => { 109 => 0x10101, 114 => 0x26a },
	'checkmark2' => { 115 => 0x8e },
	'childfontfiles' => { 558 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 310 => '10.3', 311 => '11.2', 327 => 0x10b, 328 => 0x10b, 329 => 0x121 },
	'chromablurradius' => { 125 => 0xc631 },
	'chromanoisecolorspace' => { 145 => 0xe6d },
	'chromanoiseedgemapthresh' => { 145 => 0xe6c },
	'chromanoisehighfthresh' => { 145 => 0xe6a },
	'chromanoiselowfthresh' => { 145 => 0xe6b },
	'chromaticaberration' => { 109 => 0x20703, 115 => 0x66, 432 => 0xa051 },
	'chromaticaberrationb' => { 524 => 'ChromaticAberrationB', 526 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 109 => 0x20708, 115 => 0x6b },
	'chromaticaberrationcorr' => { 84 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 125 => 0x7034, 380 => 0x1, 496 => 0x900d },
	'chromaticaberrationcorrparams' => { 125 => 0x7035, 490 => 0x66a, 491 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 109 => '0x20703.0', 115 => 0x62 },
	'chromaticaberrationr' => { 524 => 'ChromaticAberrationR', 526 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 109 => 0x20707, 115 => 0x6a },
	'chromaticaberrationsetting' => { 85 => 0x6 },
	'chrominancenoisereduction' => { 109 => 0x20601, 115 => 0x5e, 435 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 115 => 0x60 },
	'circadatecreated' => { 538 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 524 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 526 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 524 => 'CircularGradientBasedCorrections', 526 => 'CircularGradientBasedCorrections' },
	'city' => { 138 => 0x5a, 168 => 'City', 355 => 0x6d, 541 => 'City' },
	'city2' => { 355 => 0x80 },
	'clarity' => { 37 => 0x33, 133 => 0x100f, 262 => 0x35, 263 => 0x3d, 459 => 0x2036, 524 => 'Clarity', 526 => 'Clarity' },
	'clarity2012' => { 524 => 'Clarity2012', 526 => 'Clarity2012' },
	'claritycontrol' => { 391 => 0x96 },
	'classification' => { 417 => 'clsf' },
	'classifystate' => { 138 => 0xe1 },
	'clearretouch' => { 355 => 0x7c },
	'clearretouchvalue' => { 355 => 0xa3 },
	'client' => { 553 => 'client' },
	'clientname' => { 532 => 'ClientName' },
	'clipboardaspectratio' => { 524 => 'ClipboardAspectRatio', 526 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 524 => 'ClipboardOrientation', 526 => 'ClipboardOrientation' },
	'clipfilename' => { 417 => 'clfn' },
	'clipid' => { 417 => 'clid' },
	'clmodeshootingspeed' => { 310 => '10.2', 311 => '11.3', 313 => '11.2', 314 => '11.2', 319 => '11.2', 320 => '10.2', 323 => '11.2', 324 => '11.2', 325 => '11.1', 326 => 0x3f, 327 => 0x3b, 328 => 0x3b, 329 => 0x3b },
	'cluster' => { 524 => 'Cluster', 526 => 'Cluster' },
	'cmcontrast' => { 339 => 0x2022 },
	'cmddialsreverserotation' => { 326 => 0xbe, 327 => 0xba, 328 => 0xba, 329 => 0xba },
	'cmexposurecompensation' => { 339 => 0x2000 },
	'cmhue' => { 339 => 0x2021 },
	'cmsaturation' => { 339 => 0x2020 },
	'cmsharpness' => { 339 => 0x2023 },
	'cmwhitebalance' => { 339 => 0x2001 },
	'cmwhitebalancecomp' => { 339 => 0x2002 },
	'cmwhitebalancegraypoint' => { 339 => 0x2010 },
	'codec' => { 176 => 'Codec' },
	'codedcharacterset' => { 139 => 0x5a },
	'codeversion' => { 417 => 'cver' },
	'collection' => { 344 => 'Collection' },
	'collectionname' => { 177 => [\'Collections','CollectionsCollectionName'], 417 => 'coll' },
	'collections' => { 177 => 'Collections', 518 => 'collections' },
	'collectionuri' => { 177 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 411 => 'player.movie.visual.color', 542 => 'color' },
	'coloraberrationcontrol' => { 303 => 0xc89224b },
	'coloradjustment' => { 435 => 0x14 },
	'coloradjustmentmode' => { 434 => 0x210 },
	'coloranta' => { 558 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 558 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 558 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 558 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 558 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 558 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 558 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 558 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 558 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 558 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 558 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 558 => 'Colorants' },
	'colorantswatchname' => { 558 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 558 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 558 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 558 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 163 => 'ColorBalance' },
	'colorbalanceadj' => { 303 => 0x76a43202 },
	'colorbalanceblue' => { 188 => 0x1e },
	'colorbalancegreen' => { 188 => 0x1d },
	'colorbalancered' => { 188 => 0x1c },
	'colorbalanceversion' => { 213 => 0x4, 214 => 0x4, 215 => 0x0, 216 => 0x0 },
	'colorblur' => { 115 => 0x65 },
	'colorbluron' => { 109 => 0x20704 },
	'colorbooster' => { 303 => 0x5f0e7d23 },
	'colorboostlevel' => { 297 => 0x1 },
	'colorboosttype' => { 297 => 0x0 },
	'colorchromeeffect' => { 133 => 0x1048 },
	'colorchromefxblue' => { 133 => 0x104e },
	'colorclass' => { 402 => 0xde, 403 => 'ColorClass' },
	'colorcompensationfilter' => { 191 => [0x3a,0x5f], 193 => 0x111, 459 => 0xb022 },
	'colorcompensationfiltercustom' => { 445 => 0xd, 446 => 0xc },
	'colorcompensationfilterset' => { 445 => 0x8, 446 => 0x7, 447 => 0x18, 464 => 0xf },
	'colorcontrol' => { 336 => 0x102b },
	'colorcorrection' => { 496 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 331 => 0x532 },
	'colordataversion' => { 44 => 0x0, 45 => 0x0, 46 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0, 52 => 0x0, 53 => 0x0, 54 => 0x0 },
	'coloreffect' => { 355 => 0x28 },
	'colorfilter' => { 118 => 0x17, 119 => 0x3017, 188 => 0x29, 196 => [0x38,0x4d,0x4f], 398 => 0x17 },
	'colorgain' => { 269 => 0x51 },
	'colorgradeblending' => { 524 => 'ColorGradeBlending', 526 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 524 => 'ColorGradeGlobalHue', 526 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 524 => 'ColorGradeGlobalLum', 526 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 524 => 'ColorGradeGlobalSat', 526 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 524 => 'ColorGradeHighlightLum', 526 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 524 => 'ColorGradeMidtoneHue', 526 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 524 => 'ColorGradeMidtoneLum', 526 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 524 => 'ColorGradeMidtoneSat', 526 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 524 => 'ColorGradeShadowLum', 526 => 'ColorGradeShadowLum' },
	'colorhue' => { 109 => 0x20900, 243 => 0x8d },
	'colorimetricreference' => { 125 => 0xc6bf },
	'colorlabel' => { 529 => 'ColorLabel' },
	'colormatrix' => { 68 => 0xa, 335 => 0x200, 336 => 0x1011, 432 => 0xa030 },
	'colormatrix1' => { 125 => 0xc621, 400 => 0x106 },
	'colormatrix2' => { 125 => 0xc622, 339 => 0x200, 400 => 0x226 },
	'colormatrix3' => { 125 => 0xcd33 },
	'colormatrixa' => { 391 => 0x203 },
	'colormatrixa2' => { 391 => 0x21c },
	'colormatrixadobergb' => { 432 => 0xa032 },
	'colormatrixb' => { 391 => 0x204 },
	'colormatrixb2' => { 391 => 0x21d },
	'colormatrixnumber' => { 336 => 0x1019 },
	'colormatrixsrgb' => { 432 => 0xa031 },
	'colormode' => { 119 => 0x3015, 133 => 0x1210, 147 => 0x66, 188 => 0x28, 191 => 0x16, 193 => 0x101, 194 => 0x36, 196 => 0x7, 243 => 0x3, 292 => 0x4, 355 => 0x32, 435 => 0x2c, 459 => 0xb029, 541 => 'ColorMode' },
	'colormoirereduction' => { 109 => 0x20670, 304 => 0x15 },
	'colormoirereductionmode' => { 304 => 0x5 },
	'colormoirereductionon' => { 109 => '0x20670.0' },
	'colornoisereduction' => { 496 => 0x8029, 524 => 'ColorNoiseReduction', 526 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 524 => 'ColorNoiseReductionDetail', 526 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 304 => 0x18 },
	'colornoisereductionsharpness' => { 304 => 0x1c },
	'colornoisereductionsmoothness' => { 524 => 'ColorNoiseReductionSmoothness', 526 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 129 => 0x2 },
	'colorprofile' => { 188 => 0x33 },
	'colorprofilesettings' => { 331 => 0x539 },
	'colorrepresentation' => { 140 => 0x3c },
	'colorsaturationadj' => { 109 => 0x20305 },
	'colorsequence' => { 140 => 0x41 },
	'colorspace' => { 55 => 0x3, 69 => 0xb4, 103 => 0x10b4, 125 => 0xa001, 142 => 0x3, 169 => 'ColorSpace', 189 => 0x2f, 190 => 0x25, 191 => 0x17, 243 => 0x1e, 331 => 0x507, 391 => 0x37, 432 => 0xa011, 435 => 0xb, 445 => 0x1b, 446 => 0x83, 447 => 0xe, 464 => 0x6, 530 => 'ColorSpace' },
	'colorspace2' => { 68 => 0x9 },
	'colorspecapproximation' => { 142 => 0x2 },
	'colorspecdata' => { 142 => 0x3 },
	'colorspecmethod' => { 142 => 0x0 },
	'colorspecprecedence' => { 142 => 0x1 },
	'colortempasshot' => { 41 => 0x4, 42 => 0x7, 43 => 0x1d, 44 => 0x59, 45 => 0x6d, 46 => 0x6d, 47 => 0x26, 48 => 0x43, 51 => 0x43, 52 => 0x43, 53 => 0x43, 54 => 0x4b },
	'colortempauto' => { 41 => 0x9, 42 => 0xf, 43 => 0x22, 44 => 0x5e, 45 => 0x72, 47 => 0x1c, 48 => 0x48, 51 => 0x48, 52 => 0x48, 53 => 0x48, 54 => 0x50 },
	'colortempcloudy' => { 41 => 0x22, 42 => 0x37, 43 => 0x31, 44 => 0xa4, 45 => 0xdb, 46 => 0x7c, 47 => 0x35, 48 => 0x5c, 51 => 0x75, 52 => 0x8e, 53 => 0x93, 54 => 0x96, 391 => 0x55 },
	'colortempcustom' => { 48 => 0x84 },
	'colortempcustom1' => { 43 => 0x45 },
	'colortempcustom2' => { 43 => 0x4a },
	'colortempdaylight' => { 41 => 0x18, 42 => 0x27, 43 => 0x27, 44 => 0x9a, 45 => 0xd1, 46 => 0x72, 47 => 0x2b, 48 => 0x52, 51 => 0x6b, 52 => 0x84, 53 => 0x89, 54 => 0x8c, 391 => 0x53 },
	'colortemperature' => { 1 => 0x2d, 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 69 => 0xae, 79 => 0x9, 103 => 0x10ae, 133 => 0x1005, 145 => 0x846, 163 => 'ColorTemperature', 189 => [0x6e,0x49], 190 => 0x3f, 191 => [0x39,0x5e], 193 => 0x10b, 196 => [0x3c,0x4c,0x4e], 350 => 0x321, 391 => 0x50, 425 => 0x1308, 459 => 0xb021, 524 => 'Temperature', 526 => 'Temperature' },
	'colortemperatureadj' => { 496 => 0x8013 },
	'colortemperatureauto' => { 243 => 0x4f },
	'colortemperaturebg' => { 336 => 0x1013 },
	'colortemperaturecustom' => { 445 => 0xc, 446 => 0xb },
	'colortemperaturerg' => { 336 => 0x1014 },
	'colortemperatureset' => { 445 => 0x7, 446 => 0x6 },
	'colortemperaturesetting' => { 191 => 0x25, 447 => 0x17, 464 => 0xe },
	'colortempflash' => { 41 => 0x36, 42 => 0x57, 43 => 0x40, 44 => 0xb8, 45 => 0xef, 46 => 0x8b, 47 => 0x49, 48 => 0x70, 51 => 0x89, 52 => 0xa2, 53 => 0xa7, 54 => 0xaa, 391 => 0x5a },
	'colortempflashdata' => { 48 => 0x24a },
	'colortempfluorescent' => { 41 => 0x2c, 42 => 0x47, 43 => 0x3b, 44 => 0xae, 45 => 0xe5, 46 => 0x86, 47 => 0x3f, 48 => 0x66, 51 => 0x7f, 52 => 0x98, 53 => 0x9d, 54 => 0xa0 },
	'colortempfluorescentd' => { 391 => 0x57 },
	'colortempfluorescentn' => { 391 => 0x58 },
	'colortempfluorescentw' => { 391 => 0x59 },
	'colortempkelvin' => { 41 => 0x31, 42 => 0x4f, 44 => 0xb3, 45 => 0xea, 47 => 0x44, 48 => 0x6b, 51 => 0x84, 52 => 0x9d, 53 => 0xa2, 54 => 0xa5, 355 => 0x44, 425 => 0x1307 },
	'colortempmeasured' => { 41 => 0xe, 42 => 0x17, 44 => 0x63, 45 => 0x77, 48 => 0x4d, 51 => 0x4d, 52 => 0x4d, 53 => 0x4d, 54 => 0x55 },
	'colortemppc1' => { 47 => 0x94, 48 => 0x75 },
	'colortemppc2' => { 47 => 0x99, 48 => 0x7a },
	'colortemppc3' => { 47 => 0x9e, 48 => 0x7f },
	'colortempshade' => { 41 => 0x1d, 42 => 0x2f, 43 => 0x2c, 44 => 0x9f, 45 => 0xd6, 46 => 0x77, 47 => 0x30, 48 => 0x57, 51 => 0x70, 52 => 0x89, 53 => 0x8e, 54 => 0x91, 391 => 0x54 },
	'colortemptungsten' => { 41 => 0x27, 42 => 0x3f, 43 => 0x36, 44 => 0xa9, 45 => 0xe0, 46 => 0x81, 47 => 0x3a, 48 => 0x61, 51 => 0x7a, 52 => 0x93, 53 => 0x98, 54 => 0x9b, 391 => 0x56 },
	'colortempunknown' => { 41 => 0x13, 42 => 0x1f, 44 => 0x68, 45 => 0x7c, 47 => 0x21, 51 => 0x52, 52 => 0x52, 53 => 0x52, 54 => 0x5a },
	'colortempunknown10' => { 41 => 0x63, 42 => 0x9f, 44 => 0x95, 45 => 0xa9, 46 => 0xb8, 47 => 0x76, 51 => 0xa2, 52 => 0x7f, 53 => 0x7f, 54 => 0x87 },
	'colortempunknown11' => { 41 => 0x68, 42 => 0xa7, 44 => 0xbd, 45 => [0xae,0xb3], 46 => 0xbd, 47 => 0x7b, 51 => 0xa7, 52 => 0xa7, 53 => 0x84, 54 => 0xaf },
	'colortempunknown12' => { 41 => 0x6d, 42 => 0xaf, 44 => 0xc2, 45 => 0xb8, 46 => 0xc2, 47 => 0x80, 51 => 0xac, 52 => 0xac, 53 => 0xac, 54 => 0xb4 },
	'colortempunknown13' => { 41 => 0x72, 42 => 0xb7, 44 => 0xc7, 45 => 0xbd, 46 => 0xc7, 47 => 0x85, 51 => 0xb1, 52 => 0xb1, 53 => 0xb1, 54 => 0xb9 },
	'colortempunknown14' => { 44 => 0xcc, 45 => 0xc2, 46 => 0xcc, 47 => 0x8a, 51 => 0xb6, 52 => 0xb6, 53 => 0xb6, 54 => 0xbe },
	'colortempunknown15' => { 44 => 0xd1, 45 => 0xc7, 46 => 0xd1, 47 => 0x8f, 51 => 0xbb, 52 => 0xbb, 53 => 0xbb, 54 => 0xc3 },
	'colortempunknown16' => { 44 => 0xd6, 45 => 0xcc, 46 => 0xd6, 47 => 0xa3, 52 => 0xc0, 53 => 0xc0, 54 => 0xc8 },
	'colortempunknown17' => { 44 => 0xdb, 45 => 0xf4, 46 => 0xdb, 52 => 0xc5, 53 => 0xc5, 54 => 0xcd },
	'colortempunknown18' => { 44 => 0xe0, 45 => 0xf9, 46 => 0xe0, 52 => 0xca, 53 => 0xca, 54 => 0xd2 },
	'colortempunknown19' => { 44 => 0xe5, 45 => 0xfe, 46 => 0xe5, 52 => 0xcf, 53 => 0xcf, 54 => 0xd7 },
	'colortempunknown2' => { 41 => 0x3b, 42 => 0x5f, 44 => 0x6d, 45 => 0x81, 46 => 0x90, 47 => 0x4e, 51 => 0x57, 52 => 0x57, 53 => 0x57, 54 => 0x5f },
	'colortempunknown20' => { 44 => 0xea, 45 => 0x103, 46 => 0xea, 52 => 0xd4, 53 => 0xd4, 54 => 0xdc },
	'colortempunknown21' => { 44 => 0xef, 45 => 0x108, 46 => 0xef, 53 => 0xd9, 54 => 0xe1 },
	'colortempunknown22' => { 44 => 0xf4, 45 => 0x10d, 46 => 0xf4, 53 => 0xde, 54 => 0xe6 },
	'colortempunknown23' => { 44 => 0xf9, 45 => 0x112, 46 => 0xf9, 53 => 0xe3, 54 => 0xeb },
	'colortempunknown24' => { 44 => 0xfe, 45 => 0x117, 46 => 0xfe, 53 => 0xe8, 54 => 0xf0 },
	'colortempunknown25' => { 44 => 0x103, 45 => 0x11c, 46 => 0x103, 53 => 0xed, 54 => 0xf5 },
	'colortempunknown26' => { 44 => 0x108, 45 => 0x121, 46 => 0x108, 53 => 0xf2, 54 => 0xfa },
	'colortempunknown27' => { 44 => 0x10d, 45 => 0x126, 46 => 0x10d, 53 => 0xf7, 54 => 0xff },
	'colortempunknown28' => { 44 => 0x112, 46 => 0x112, 53 => 0xfc, 54 => 0x104 },
	'colortempunknown29' => { 44 => 0x117, 46 => 0x117, 53 => 0x101, 54 => 0x109 },
	'colortempunknown3' => { 41 => 0x40, 42 => 0x67, 44 => 0x72, 45 => 0x86, 46 => 0x95, 47 => 0x53, 51 => 0x5c, 52 => 0x5c, 53 => 0x5c, 54 => 0x64 },
	'colortempunknown30' => { 46 => 0x11c, 53 => 0x106 },
	'colortempunknown31' => { 46 => 0x121 },
	'colortempunknown32' => { 46 => 0x126 },
	'colortempunknown33' => { 46 => 0x12b },
	'colortempunknown4' => { 41 => 0x45, 42 => 0x6f, 44 => 0x77, 45 => 0x8b, 46 => 0x9a, 47 => 0x58, 51 => 0x61, 52 => 0x61, 53 => 0x61, 54 => 0x69 },
	'colortempunknown5' => { 41 => 0x4a, 42 => 0x77, 44 => 0x7c, 45 => 0x90, 46 => 0x9f, 47 => 0x5d, 51 => 0x66, 52 => 0x66, 53 => 0x66, 54 => 0x6e },
	'colortempunknown6' => { 41 => 0x4f, 42 => 0x7f, 44 => 0x81, 45 => 0x95, 46 => 0xa4, 47 => 0x62, 51 => 0x8e, 52 => 0x6b, 53 => 0x6b, 54 => 0x73 },
	'colortempunknown7' => { 41 => 0x54, 42 => 0x87, 44 => 0x86, 45 => 0x9a, 46 => 0xa9, 47 => 0x67, 51 => 0x93, 52 => 0x70, 53 => 0x70, 54 => 0x78 },
	'colortempunknown8' => { 41 => 0x59, 42 => 0x8f, 44 => 0x8b, 45 => 0x9f, 46 => 0xae, 47 => 0x6c, 51 => 0x98, 52 => 0x75, 53 => 0x75, 54 => 0x7d },
	'colortempunknown9' => { 41 => 0x5e, 42 => 0x97, 44 => 0x90, 45 => 0xa4, 46 => 0xb3, 47 => 0x71, 51 => 0x9d, 52 => 0x7a, 53 => 0x7a, 54 => 0x82 },
	'colortint' => { 354 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 37 => 0x2a, 55 => 0x2, 68 => 0x8 },
	'colortoneadj' => { 109 => 0x20304, 114 => 0x11e },
	'colortoneauto' => { 76 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 75 => 0x6c, 76 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 75 => 0x3c, 76 => 0x3c },
	'colortonemonochrome' => { 75 => 0x84, 76 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 75 => 0x54, 76 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 75 => 0x24, 76 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 75 => 0xc, 76 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 75 => 0x9c, 76 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 75 => 0xb4, 76 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 75 => 0xcc, 76 => 0xe4 },
	'columninterleavefactor' => { 125 => 0xcd43 },
	'comlenblksize' => { 145 => 0xfde8 },
	'commanddialframeadvancezoom' => { 253 => 0x804, 254 => 0x808 },
	'commanddialplaybackmode' => { 327 => 0x1cb, 328 => 0x1cb, 329 => 0x1e3 },
	'commanddials' => { 321 => '5.1' },
	'commanddialsaperturesetting' => { 310 => '17.3', 311 => '18.3', 313 => '18.3', 314 => '18.3', 319 => '33.3', 320 => '17.3', 323 => '18.3', 324 => '18.3' },
	'commanddialschangemainsub' => { 310 => '17.2', 311 => '18.1', 313 => '18.1', 314 => '18.1', 319 => '33.2', 320 => '17.2', 323 => '18.1', 324 => '18.1' },
	'commanddialsmenuandplayback' => { 310 => '17.4', 311 => '18.2', 313 => '18.2', 314 => '18.2', 319 => '33.4', 320 => '17.4', 323 => '18.2', 324 => '18.2' },
	'commanddialsreverserotation' => { 310 => '17.1', 311 => '6.4', 313 => '6.2', 314 => '6.2', 315 => '16.2', 316 => '17.2', 319 => '33.1', 320 => '17.1', 323 => '6.2', 324 => '6.2', 325 => '18.1' },
	'commanddialvideoplaybackmode' => { 327 => 0x1cd, 329 => 0x1e5 },
	'commanderchannel' => { 321 => '10.2', 322 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 321 => '13.1', 322 => '31.1' },
	'commandergroupa_ttlcomp' => { 325 => '32.1' },
	'commandergroupamanualoutput' => { 321 => '13.2', 322 => '28.2' },
	'commandergroupamode' => { 321 => '11.2', 322 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 321 => '14.1', 322 => '32.1' },
	'commandergroupb_ttlcomp' => { 325 => '33.1' },
	'commandergroupbmanualoutput' => { 321 => '14.2', 322 => '29.2' },
	'commandergroupbmode' => { 321 => '11.3', 322 => '29.1' },
	'commanderinternalflash' => { 321 => '11.1', 322 => '27.1' },
	'commanderinternalmanualoutput' => { 321 => '12.2', 322 => '27.2' },
	'commanderinternalttlchannel' => { 319 => '18.2' },
	'commanderinternalttlcomp' => { 321 => '12.1', 322 => '30.2', 325 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 319 => '20.1', 320 => '26.1' },
	'commanderinternalttlcompgroupa' => { 319 => '21.1', 320 => '27.1' },
	'commanderinternalttlcompgroupb' => { 319 => '22.1', 320 => '28.1' },
	'comment' => { 0 => 0x2, 126 => 'Comment', 164 => 'Comment', 344 => 'Comment', 409 => "\xa9cmt", 411 => 'comment', 417 => "\xa9cmt" },
	'compass' => { 428 => 0x4 },
	'compatiblebrands' => { 411 => 'compatible_brands' },
	'compatibleversion' => { 524 => 'CompatibleVersion', 526 => 'CompatibleVersion' },
	'compilation' => { 409 => 'cpil' },
	'compimageimagespersequence' => { 531 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 531 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 531 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 531 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 531 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 531 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 531 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 531 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 531 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 531 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 543 => 'complianceProfile' },
	'componentsconfiguration' => { 125 => 0x9101, 169 => 'Components', 530 => 'ComponentsConfiguration' },
	'componentversion' => { 103 => 0x80c },
	'composer' => { 186 => 'WM/Composer', 409 => ["\xa9com","\xa9wrt"], 417 => ["\xa9com","\xa9wrt"], 553 => 'composer' },
	'composerid' => { 409 => 'cmID' },
	'composerkeywords' => { 417 => "\xa9cok" },
	'compositeimage' => { 125 => 0xa460, 531 => 'CompositeImage' },
	'compositeimagecount' => { 125 => 0xa461, 531 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 125 => 0xa462, 531 => 'CompositeImageExposureTimes' },
	'composition' => { 512 => 'Composition' },
	'compositionadjust' => { 389 => '0.1' },
	'compositionadjustrotation' => { 389 => 0x7 },
	'compositionadjustx' => { 389 => 0x5 },
	'compositionadjusty' => { 389 => 0x6 },
	'compressedbitsperpixel' => { 125 => 0x9102, 530 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 193 => 0x40, 336 => 0x40 },
	'compression' => { 125 => 0x103, 360 => 0xb, 549 => 'Compression' },
	'compressionfactor' => { 331 => 0x50d },
	'compressionformat' => { 68 => 0x4 },
	'compressionratio' => { 169 => 'Compression', 336 => 0x1034 },
	'compressorversion' => { 417 => 'CNCV' },
	'condadobvfactor' => { 145 => 0xf3e },
	'condadodaybvthresh' => { 145 => 0xf3c },
	'condadodayoffsets' => { 145 => 0xf42 },
	'condadofluoffsets' => { 145 => 0xf44 },
	'condadofluthresh' => { 145 => 0xf41 },
	'condadoillfactor' => { 145 => 0xf3f },
	'condadoneurange' => { 145 => 0xf3d },
	'condadotunoffsets' => { 145 => 0xf43 },
	'condadotunthresh' => { 145 => 0xf40 },
	'conductor' => { 186 => 'WM/Conductor', 409 => "\xa9con" },
	'confidence' => { 507 => 'Confidence' },
	'confidencelevel' => { 520 => 'ConfidenceLevel' },
	'confidencemime' => { 507 => 'ConfidenceMime' },
	'constrainedcropheight' => { 114 => 0x266, 402 => 0xd6 },
	'constrainedcropwidth' => { 114 => 0x262, 402 => 0xd5 },
	'contact' => { 138 => 0x76 },
	'contactinfo' => { 524 => 'ContactInfo', 526 => 'ContactInfo', 542 => 'contactInfo' },
	'container' => { 500 => 'Container' },
	'containerdirectory' => { 500 => [\'Container','ContainerDirectory'], 505 => 'Directory' },
	'containerdirectoryitem' => { 500 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 500 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 500 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 500 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 500 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 538 => 'ContainerFormat' },
	'containerformatidentifier' => { 538 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 538 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 409 => "\xa9day", 417 => ['@day',"\xa9day"] },
	'contentdistributor' => { 186 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 417 => 'cdis' },
	'contentid' => { 417 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 411 => 'content.identifier' },
	'contentlocationcode' => { 138 => 0x1a },
	'contentlocationname' => { 138 => 0x1b },
	'contenttype' => { 543 => 'contentType' },
	'continuousbracketing' => { 191 => 0x20 },
	'continuousdrive' => { 37 => 0x5 },
	'continuousmodedisplay' => { 326 => 0x55, 327 => 0x51, 328 => 0x51, 329 => 0x51 },
	'continuousmodeliveview' => { 324 => '77.2' },
	'continuousshootingspeed' => { 90 => 0x610 },
	'continuousshotlimit' => { 90 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 37 => 0xd, 118 => 0xc, 119 => [0x3012,0x20], 125 => [0xa408,0xfe54], 133 => [0x1004,0x1006], 163 => 'Contrast', 183 => 'Contrast', 188 => 0x20, 189 => 0x31, 190 => 0x27, 191 => 0x19, 196 => 0x2, 261 => 0x33, 262 => 0x37, 263 => 0x3f, 336 => 0x1029, 355 => 0x39, 357 => 0x300a, 391 => 0x20, 398 => 0xc, 411 => 'player.movie.visual.contrast', 419 => 0x24, 421 => 0x52, 425 => 0x1012, 435 => 0xd, 445 => 0x1d, 446 => 0x1a, 459 => 0x2004, 524 => 'Contrast', 526 => 'Contrast', 530 => 'Contrast' },
	'contrast2012' => { 524 => 'Contrast2012', 526 => 'Contrast2012' },
	'contrastadj' => { 109 => 0x20303, 114 => 0x115, 306 => 0x2c, 496 => 0x8017 },
	'contrastauto' => { 76 => 0x90 },
	'contrastcurve' => { 243 => 0x8c },
	'contrastdetectaf' => { 200 => 0x4 },
	'contrastdetectafarea' => { 391 => 0x231 },
	'contrastdetectafinfocus' => { 200 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 75 => 0x60, 76 => 0x60 },
	'contrasthighlight' => { 391 => 0x6d },
	'contrasthighlightshadowadj' => { 391 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 75 => 0x30, 76 => 0x30 },
	'contrastmode' => { 355 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 75 => 0x78, 76 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 75 => 0x48, 76 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 75 => 0x18, 76 => 0x18 },
	'contrastsetting' => { 331 => 0x505, 339 => 0x1012, 447 => 0x10, 464 => 0x8 },
	'contrastshadow' => { 391 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 75 => 0x0, 76 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 75 => 0x90, 76 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 75 => 0xa8, 76 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 75 => 0xc0, 76 => 0xd8 },
	'contributedmedia' => { 553 => 'contributedMedia' },
	'contributedmediaduration' => { 553 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 553 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 553 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 553 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 553 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 553 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 553 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 553 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 553 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 553 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 527 => 'contributor', 538 => 'Contributor' },
	'contributoridentifier' => { 538 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 538 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 538 => [\'Contributor','ContributorRole'] },
	'contributors' => { 164 => 'Contributors' },
	'controldialset' => { 191 => 0x46 },
	'controlledvocabularyterm' => { 538 => 'CVterm' },
	'controllerboardversion' => { 350 => 0x332 },
	'controlmode' => { 82 => 0x12 },
	'controlringresponse' => { 326 => 0x1cf, 327 => 0x1d5, 328 => 0x1d5, 329 => 0x1ed },
	'controlringrotation' => { 90 => 0x712 },
	'conversionlens' => { 332 => 0x403, 355 => 0x35 },
	'converter' => { 125 => 0xfe4d, 292 => 0xb, 524 => 'Converter', 526 => 'Converter' },
	'converttograyscale' => { 524 => 'ConvertToGrayscale', 526 => 'ConvertToGrayscale' },
	'cookingequipment' => { 545 => 'cookingEquipment' },
	'cookingmethod' => { 545 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 125 => 0x8298, 164 => 'Copyright', 344 => 'Copyright', 360 => 0x8298, 391 => 0x22f, 407 => 'Copyright', 409 => ['cprt',"\xa9cpy"], 411 => 'copyright', 417 => ['cprt',"\xa9cpy"], 524 => 'Copyright', 526 => 'Copyright', 540 => 'Copyright', 546 => 'copyright', 549 => 'Copyright', 553 => 'copyright' },
	'copyrightflag' => { 405 => 0x40a },
	'copyrightnotice' => { 138 => 0x74 },
	'copyrightowner' => { 341 => 'CopyrightOwner' },
	'copyrightownerid' => { 341 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 341 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 341 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 341 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 341 => 'CopyrightStatus' },
	'copyrightyear' => { 538 => 'CopyrightYear', 543 => 'copyrightYear' },
	'coringfilter' => { 335 => 0x310, 336 => 0x102d, 339 => 0x310 },
	'coringvalues' => { 335 => 0x311, 339 => 0x311 },
	'corporateentity' => { 543 => 'corporateEntity' },
	'correctionalreadyapplied' => { 345 => 'CorrectionAlreadyApplied' },
	'correlatedcolortemp' => { 354 => 0x35b },
	'country' => { 168 => 'Country', 355 => 0x69, 541 => 'Country' },
	'country-primarylocationcode' => { 138 => 0x64 },
	'country-primarylocationname' => { 138 => 0x65 },
	'countrycode' => { 242 => 0x5, 403 => 'CountryCode', 537 => 'CountryCode' },
	'course' => { 545 => 'course' },
	'coverage' => { 527 => 'coverage' },
	'coverart' => { 409 => 'covr' },
	'coverdate' => { 543 => 'coverDate' },
	'coverdisplaydate' => { 543 => 'coverDisplayDate' },
	'coveruri' => { 417 => 'cvru' },
	'cpufirmwareversion' => { 391 => 0x28 },
	'crc32' => { 528 => 'crc32' },
	'createdate' => { 125 => 0x9004, 164 => 'CreateDate', 340 => 'CreationDate', 344 => 'create-date', 407 => 'CreationDate', 414 => 0x1, 551 => 'CreateDate' },
	'creationdate' => { 411 => 'creationdate', 540 => 'CreationDate', 543 => 'creationDate' },
	'creationtime' => { 344 => 'Creation Time', 411 => 'creation_time' },
	'creativestyle' => { 445 => 0x1a, 446 => 0x18, 456 => 0x41, 459 => 0xb020, 491 => 0x4a },
	'creativestylesetting' => { 447 => 0xf, 464 => 0x7 },
	'creativestylewaschanged' => { 496 => 0x8001 },
	'creator' => { 340 => 'Creator', 407 => 'Creator', 527 => 'creator', 538 => 'Creator', 540 => 'Creator' },
	'creatoraddress' => { 537 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 185 => 'CreatorAppId' },
	'creatorcity' => { 537 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 537 => 'CreatorContactInfo' },
	'creatorcountry' => { 537 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 538 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 403 => 'CreatorIdentity' },
	'creatorname' => { 538 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 185 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 537 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 537 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 538 => [\'Creator','CreatorRole'] },
	'creatortool' => { 551 => 'CreatorTool' },
	'creatorworkemail' => { 537 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 537 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 537 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 138 => 0x6e, 541 => 'Credit' },
	'creditline' => { 546 => 'creditLine' },
	'creditlinereq' => { 556 => 'CreditLineReq' },
	'creditlinerequired' => { 341 => 'CreditLineRequired' },
	'cropactive' => { 107 => 0x0, 114 => 0x244 },
	'cropangle' => { 107 => 0x8, 524 => 'CropAngle', 526 => 'CropAngle' },
	'croparea' => { 243 => 0x45, 496 => 0x9011 },
	'cropaspectratio' => { 109 => 0x30101, 114 => 0x260 },
	'cropaspectratiocustom' => { 109 => 0x30102 },
	'cropbottom' => { 129 => 0x9, 298 => 0x36, 360 => 0x31, 402 => 0xdc, 524 => 'CropBottom', 526 => 'CropBottom' },
	'cropbottommargin' => { 57 => 0x3 },
	'cropcircleactive' => { 115 => 0xd6 },
	'cropcircleradius' => { 115 => 0xd9 },
	'cropcirclex' => { 115 => 0xd7 },
	'cropcircley' => { 115 => 0xd8 },
	'cropconstraintowarp' => { 524 => 'CropConstrainToWarp', 526 => 'CropConstrainToWarp' },
	'cropflag' => { 133 => 0x1051 },
	'croph' => { 517 => 'CropH' },
	'cropheight' => { 107 => 0x6, 114 => 0x24c, 335 => 0x615, 339 => 0x615, 524 => 'CropHeight', 526 => 'CropHeight' },
	'crophispeed' => { 243 => 0x1b },
	'cropleft' => { 114 => 0x246, 129 => 0x6, 298 => 0x1e, 335 => 0x612, 339 => 0x612, 360 => 0x30, 402 => 0xd9, 524 => 'CropLeft', 526 => 'CropLeft' },
	'cropleftmargin' => { 57 => 0x0 },
	'cropmode' => { 133 => 0x104d, 425 => 0x1018 },
	'croporiginalheight' => { 107 => 0xb },
	'croporiginalwidth' => { 107 => 0xa },
	'cropoutputheight' => { 298 => 0xce },
	'cropoutputheightinches' => { 298 => 0x96 },
	'cropoutputpixels' => { 298 => 0xd6 },
	'cropoutputresolution' => { 298 => 0xb6 },
	'cropoutputscale' => { 298 => 0xbe },
	'cropoutputwidth' => { 298 => 0xc6 },
	'cropoutputwidthinches' => { 298 => 0x8e },
	'croppedareaimageheightpixels' => { 510 => 'CroppedAreaImageHeightPixels', 511 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 510 => 'CroppedAreaImageWidthPixels', 511 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 510 => 'CroppedAreaLeftPixels', 511 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 510 => 'CroppedAreaTopPixels', 511 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 425 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 425 => 0x1603 },
	'cropping' => { 496 => 0x9010 },
	'cropright' => { 129 => 0x8, 298 => 0x2e, 360 => 0x32, 402 => 0xdb, 524 => 'CropRight', 526 => 'CropRight' },
	'croprightmargin' => { 57 => 0x1 },
	'croprotatedoriginalheight' => { 107 => 0x2 },
	'croprotatedoriginalwidth' => { 107 => 0x1 },
	'croprotation' => { 107 => 0x7, 129 => 0xb },
	'cropscaledresolution' => { 298 => 0x9e },
	'cropsize' => { 133 => 0x1053 },
	'cropsourceresolution' => { 298 => 0xae },
	'croptop' => { 114 => 0x248, 129 => 0x7, 298 => 0x26, 335 => 0x613, 339 => 0x613, 360 => 0x2f, 402 => 0xda, 524 => 'CropTop', 526 => 'CropTop' },
	'croptopleft' => { 133 => 0x1052 },
	'croptopmargin' => { 57 => 0x2 },
	'cropunit' => { 524 => 'CropUnit', 526 => 'CropUnit' },
	'cropunits' => { 524 => 'CropUnits', 526 => 'CropUnits' },
	'cropw' => { 517 => 'CropW' },
	'cropwidth' => { 107 => 0x5, 114 => 0x24a, 335 => 0x614, 339 => 0x614, 524 => 'CropWidth', 526 => 'CropWidth' },
	'cropx' => { 107 => 0x3, 517 => 'CropX' },
	'cropy' => { 107 => 0x4, 517 => 'CropY' },
	'crossprocess' => { 391 => 0x7b },
	'crossprocessparams' => { 391 => 0x235 },
	'cuisine' => { 545 => 'cuisine' },
	'currenticcprofile' => { 125 => 0xc691 },
	'currentpreprofilematrix' => { 125 => 0xc692 },
	'currentversion' => { 496 => 0xd000 },
	'curve0x' => { 517 => 'Curve0x' },
	'curve0y' => { 517 => 'Curve0y' },
	'curve1x' => { 517 => 'Curve1x' },
	'curve1y' => { 517 => 'Curve1y' },
	'curve2x' => { 517 => 'Curve2x' },
	'curve2y' => { 517 => 'Curve2y' },
	'curve3x' => { 517 => 'Curve3x' },
	'curve3y' => { 517 => 'Curve3y' },
	'curve4x' => { 517 => 'Curve4x' },
	'curve4y' => { 517 => 'Curve4y' },
	'curves' => { 303 => 0x76a43201 },
	'custom1' => { 341 => 'Custom1' },
	'custom10' => { 341 => 'Custom10' },
	'custom2' => { 341 => 'Custom2' },
	'custom3' => { 341 => 'Custom3' },
	'custom4' => { 341 => 'Custom4' },
	'custom5' => { 341 => 'Custom5' },
	'custom6' => { 341 => 'Custom6' },
	'custom7' => { 341 => 'Custom7' },
	'custom8' => { 341 => 'Custom8' },
	'custom9' => { 341 => 'Custom9' },
	'customcolortone' => { 115 => 0x4c },
	'customcontrast' => { 115 => 0x4e },
	'customcontrols' => { 90 => 0x70c },
	'customdefaultunsharpfineness' => { 115 => 0xbe },
	'customdefaultunsharpstrength' => { 115 => 0xbc },
	'customdefaultunsharpthreshold' => { 115 => 0xc0 },
	'customilluminant' => { 145 => 0x405 },
	'customizedials' => { 90 => 0x715 },
	'customlinear' => { 115 => 0x4f },
	'customoutputhighlightpoint' => { 115 => 0x53 },
	'customoutputshadowpoint' => { 115 => 0x54 },
	'custompicturestyle' => { 109 => 0x10021 },
	'custompicturestyledata' => { 109 => 0xf0500 },
	'custompicturestylefilename' => { 69 => 0x4010 },
	'customrawhighlight' => { 115 => 0x7c },
	'customrawhighlightpoint' => { 115 => 0x51 },
	'customrawshadow' => { 115 => 0x85 },
	'customrawshadowpoint' => { 115 => 0x52 },
	'customrendered' => { 125 => 0xa401, 198 => 0x6420, 530 => 'CustomRendered' },
	'customsaturation' => { 115 => 0x4d, 331 => 0x503 },
	'customsettingsalldefault' => { 310 => '0.2', 319 => '0.2' },
	'customsettingsbank' => { 310 => '0.1', 311 => '0.1', 313 => '0.1', 314 => '0.1', 319 => '0.1', 323 => '0.2', 324 => '0.2', 327 => 0x1, 328 => 0x1, 329 => 0x1 },
	'customsharpness' => { 115 => 0x50 },
	'customunsharpmaskfineness' => { 115 => 0xb8 },
	'customunsharpmaskstrength' => { 115 => 0xb6 },
	'customunsharpmaskthreshold' => { 115 => 0xba },
	'customwb_rblevels' => { 464 => 0x1a },
	'customwb_rgblevels' => { 446 => 0x8, 447 => 0x19 },
	'customwbbluelevel' => { 191 => 0x36 },
	'customwberror' => { 191 => 0x37 },
	'customwbgreenlevel' => { 191 => 0x35 },
	'customwbredlevel' => { 191 => 0x34 },
	'customwbsetting' => { 191 => 0x26 },
	'cx' => { 417 => '_cx_' },
	'cy' => { 417 => '_cy_' },
	'd-lightinghq' => { 303 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 299 => 0x2 },
	'd-lightinghqhighlight' => { 299 => 0x1 },
	'd-lightinghqselected' => { 303 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 299 => 0x0 },
	'd-lightinghs' => { 303 => 0xce5554aa },
	'd-lightinghsadjustment' => { 300 => 0x0 },
	'd-lightinghscolorboost' => { 300 => 0x1 },
	'd-rangeoptimizerhighlight' => { 496 => 0x8024 },
	'd-rangeoptimizermode' => { 496 => 0x8022 },
	'd-rangeoptimizershadow' => { 496 => 0x802d },
	'd-rangeoptimizervalue' => { 496 => 0x8023 },
	'darkblacksegrows' => { 145 => 0x18d8 },
	'darkfocusenvironment' => { 355 => 0x8003 },
	'darkframecountfactor' => { 145 => 0xc85 },
	'darkframelongexposure' => { 145 => 0xc84 },
	'darkframeshortexposure' => { 145 => 0xc83 },
	'darkpedestal' => { 145 => 0xc7f },
	'datacompressionmethod' => { 140 => 0x6e },
	'dataimprint' => { 188 => 0x34 },
	'datamining' => { 341 => 'DataMining' },
	'dataonscreen' => { 538 => 'DataOnScreen' },
	'dataonscreenregion' => { 538 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 538 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 538 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 538 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 538 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 538 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 538 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 538 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 391 => 0x3d },
	'date' => { 391 => 0x6, 527 => 'date' },
	'dateacquired' => { 185 => 'DateAcquired', 186 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 138 => 0x37, 541 => 'DateCreated' },
	'datedisplayformat' => { 295 => 0x3 },
	'dateidentified' => { 124 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 315 => '4.2' },
	'daterecieved' => { 543 => 'dateRecieved' },
	'datesent' => { 139 => 0x46 },
	'datestampmode' => { 69 => 0x1c, 243 => 0x9d },
	'datetime' => { 518 => 'datetime', 549 => 'DateTime' },
	'datetimedigitized' => { 530 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 106 => 0x0, 125 => 0x9003, 161 => 0x14, 164 => 'OriginalDate', 412 => 'IDIT', 417 => 'date', 419 => 0xb, 420 => 0x3b, 421 => 0x3e, 530 => 'DateTimeOriginal' },
	'datetimestamp' => { 147 => 0x64 },
	'datetimeutc' => { 331 => 0x908 },
	'daylightsavings' => { 83 => 0x3, 295 => 0x2 },
	'dayofweek' => { 420 => 0x42, 421 => 0x4a },
	'dccontinent' => { 124 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 124 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 124 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 124 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 124 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 124 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 124 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 124 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 124 => 'Event' },
	'dcfootprintspatialfit' => { 124 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 124 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 124 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 124 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 124 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 124 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 124 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 124 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 124 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 124 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 124 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 124 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 124 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 124 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 124 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 124 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 124 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 124 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 172 => 'Declination' },
	'decposition' => { 188 => 0x32 },
	'defaultautogray' => { 524 => 'DefaultAutoGray', 526 => 'DefaultAutoGray' },
	'defaultautotone' => { 524 => 'DefaultAutoTone', 526 => 'DefaultAutoTone' },
	'defaultblackrender' => { 125 => 0xc7a6 },
	'defaultcroporigin' => { 125 => 0xc61f },
	'defaultcropsize' => { 125 => 0xc620 },
	'defaulteraseoption' => { 90 => 0x813 },
	'defaultscale' => { 125 => 0xc61e },
	'defaultsspecifictoiso' => { 524 => 'DefaultsSpecificToISO', 526 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 524 => 'DefaultsSpecificToSerial', 526 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 125 => 0xc7b5 },
	'defectisocode' => { 145 => 0x90f },
	'defringe' => { 524 => 'Defringe', 526 => 'Defringe' },
	'defringegreenamount' => { 524 => 'DefringeGreenAmount', 526 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 524 => 'DefringeGreenHueHi', 526 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 524 => 'DefringeGreenHueLo', 526 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 524 => 'DefringePurpleAmount', 526 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 524 => 'DefringePurpleHueHi', 526 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 524 => 'DefringePurpleHueLo', 526 => 'DefringePurpleHueLo' },
	'dehaze' => { 524 => 'Dehaze', 526 => 'Dehaze' },
	'deletedimagecount' => { 243 => 0xa6, 274 => 0x6e },
	'deprecatedon' => { 522 => 'deprecatedOn' },
	'depthbasedcorrcorrectionactive' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'] },
	'depthbasedcorrcorrectionamount' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'] },
	'depthbasedcorrcorrectionsyncid' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'] },
	'depthbasedcorrections' => { 524 => 'DepthBasedCorrections', 526 => 'DepthBasedCorrections' },
	'depthbasedcorrlocalcorrecteddepth' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'] },
	'depthbasedcorrlocalcurverefinesaturation' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'] },
	'depthbasedcorrmask' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'] },
	'depthbasedcorrmaskalpha' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'] },
	'depthbasedcorrmaskangle' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'] },
	'depthbasedcorrmaskbottom' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'] },
	'depthbasedcorrmaskcentervalue' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'] },
	'depthbasedcorrmaskcenterweight' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'] },
	'depthbasedcorrmaskdabs' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'] },
	'depthbasedcorrmaskfeather' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'] },
	'depthbasedcorrmaskflipped' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'] },
	'depthbasedcorrmaskflow' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'] },
	'depthbasedcorrmaskfullx' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'] },
	'depthbasedcorrmaskfully' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'] },
	'depthbasedcorrmaskinputdigest' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'] },
	'depthbasedcorrmaskleft' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'] },
	'depthbasedcorrmaskmaskactive' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'] },
	'depthbasedcorrmaskmaskblendmode' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'depthbasedcorrmaskmaskdigest' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'] },
	'depthbasedcorrmaskmaskinverted' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'] },
	'depthbasedcorrmaskmaskname' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'] },
	'depthbasedcorrmaskmasks' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'] },
	'depthbasedcorrmaskmasksalpha' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'depthbasedcorrmaskmasksangle' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'] },
	'depthbasedcorrmaskmasksbottom' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'] },
	'depthbasedcorrmaskmaskscentervalue' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'depthbasedcorrmaskmaskscenterweight' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'depthbasedcorrmaskmasksdabs' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'] },
	'depthbasedcorrmaskmasksfeather' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'] },
	'depthbasedcorrmaskmasksflipped' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'depthbasedcorrmaskmasksflow' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'] },
	'depthbasedcorrmaskmasksfullx' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'] },
	'depthbasedcorrmaskmasksfully' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'] },
	'depthbasedcorrmaskmasksinputdigest' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'depthbasedcorrmaskmasksleft' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'] },
	'depthbasedcorrmaskmasksmaskactive' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'depthbasedcorrmaskmasksmaskblendmode' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'depthbasedcorrmaskmasksmaskdigest' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'depthbasedcorrmaskmasksmaskinverted' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'depthbasedcorrmaskmasksmaskname' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'depthbasedcorrmaskmasksmasksubtype' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'depthbasedcorrmaskmasksmasksyncid' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'depthbasedcorrmaskmasksmaskversion' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'depthbasedcorrmaskmasksmidpoint' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'depthbasedcorrmaskmasksorigin' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'depthbasedcorrmaskmasksperimetervalue' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'depthbasedcorrmaskmasksradius' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'] },
	'depthbasedcorrmaskmasksreferencepoint' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'depthbasedcorrmaskmasksright' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'] },
	'depthbasedcorrmaskmasksroundness' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'depthbasedcorrmaskmaskssizex' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'depthbasedcorrmaskmaskssizey' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'depthbasedcorrmaskmaskstop' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'] },
	'depthbasedcorrmaskmasksubtype' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'] },
	'depthbasedcorrmaskmasksvalue' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'depthbasedcorrmaskmasksversion' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'] },
	'depthbasedcorrmaskmaskswhat' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'] },
	'depthbasedcorrmaskmaskswholeimagearea' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'depthbasedcorrmaskmasksx' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'] },
	'depthbasedcorrmaskmasksy' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'] },
	'depthbasedcorrmaskmasksyncid' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'depthbasedcorrmaskmaskszerox' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'depthbasedcorrmaskmaskszeroy' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'depthbasedcorrmaskmaskversion' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'] },
	'depthbasedcorrmaskmidpoint' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'] },
	'depthbasedcorrmaskorigin' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'] },
	'depthbasedcorrmaskperimetervalue' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'depthbasedcorrmaskradius' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'] },
	'depthbasedcorrmaskrange' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'depthbasedcorrmaskrangeareamodels' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'depthbasedcorrmaskrangeareamodelscolorsampleinfo' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'depthbasedcorrmaskrangeareamodelscomponents' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'depthbasedcorrmaskrangecoloramount' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'depthbasedcorrmaskrangedepthfeather' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'depthbasedcorrmaskrangedepthmax' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'depthbasedcorrmaskrangedepthmin' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'depthbasedcorrmaskrangeinvert' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'depthbasedcorrmaskrangelumfeather' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'depthbasedcorrmaskrangeluminancedepthsampleinfo' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'depthbasedcorrmaskrangelummax' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'depthbasedcorrmaskrangelummin' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'depthbasedcorrmaskrangelumrange' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'depthbasedcorrmaskrangesampletype' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'depthbasedcorrmaskrangetype' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'depthbasedcorrmaskrangeversion' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'depthbasedcorrmaskreferencepoint' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'] },
	'depthbasedcorrmaskright' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'] },
	'depthbasedcorrmaskroundness' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'] },
	'depthbasedcorrmasksizex' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'] },
	'depthbasedcorrmasksizey' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'] },
	'depthbasedcorrmasktop' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'] },
	'depthbasedcorrmaskvalue' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'] },
	'depthbasedcorrmaskversion' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'] },
	'depthbasedcorrmaskwhat' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'] },
	'depthbasedcorrmaskwholeimagearea' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'depthbasedcorrmaskx' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'] },
	'depthbasedcorrmasky' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'] },
	'depthbasedcorrmaskzerox' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'] },
	'depthbasedcorrmaskzeroy' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'] },
	'depthbasedcorrwhat' => { 524 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'], 526 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'] },
	'depthfar' => { 125 => 0xc7eb },
	'depthformat' => { 125 => 0xc7e9 },
	'depthimage' => { 507 => 'Data' },
	'depthmapinfo' => { 524 => 'DepthMapInfo', 526 => 'DepthMapInfo' },
	'depthmapinfobasehighlightguideinputdigest' => { 524 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'], 526 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'] },
	'depthmapinfobasehighlightguidetable' => { 524 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'], 526 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'] },
	'depthmapinfobasehighlightguideversion' => { 524 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'], 526 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'] },
	'depthmapinfobaselayereddepthinputdigest' => { 524 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'], 526 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'] },
	'depthmapinfobaselayereddepthtable' => { 524 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'], 526 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'] },
	'depthmapinfobaselayereddepthversion' => { 524 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'], 526 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'] },
	'depthmapinfobaserawdepthinputdigest' => { 524 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'], 526 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'] },
	'depthmapinfobaserawdepthtable' => { 524 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'], 526 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'] },
	'depthmapinfobaserawdepthversion' => { 524 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'], 526 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'] },
	'depthmapinfodepthsource' => { 524 => [\'DepthMapInfo','DepthMapInfoDepthSource'], 526 => [\'DepthMapInfo','DepthMapInfoDepthSource'] },
	'depthmeasuretype' => { 125 => 0xc7ed },
	'depthnear' => { 125 => 0xc7ea },
	'depthunits' => { 125 => 0xc7ec },
	'derivedfrom' => { 554 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 554 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 554 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 554 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 554 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 554 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 554 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 554 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 554 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 554 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 554 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 554 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 554 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 554 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 554 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 554 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 554 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 554 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 554 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 554 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 554 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 554 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 554 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 554 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 186 => 'Description', 344 => 'Description', 409 => ['desc','dscp',"\xa9des"], 411 => 'description', 417 => 'dscp', 524 => 'Description', 526 => 'Description', 527 => 'description', 551 => 'Description' },
	'destination' => { 139 => 0x5 },
	'destinationcity' => { 391 => 0x24, 397 => 0x3 },
	'destinationcitycode' => { 398 => 0x1001 },
	'destinationdst' => { 391 => 0x26, 397 => '0.3' },
	'developmentdynamicrange' => { 133 => 0x1403 },
	'deviantmatrixcustom' => { 145 => 0x7de },
	'deviantmatrixdaylight' => { 145 => 0x7da },
	'deviantmatrixflash' => { 145 => 0x7dd },
	'deviantmatrixfluorescent' => { 145 => 0x7dc },
	'deviantmatrixtungsten' => { 145 => 0x7db },
	'deviantwhitecustom' => { 145 => 0x842 },
	'deviantwhitedaylight' => { 145 => 0x83e },
	'deviantwhiteflash' => { 145 => 0x841 },
	'deviantwhitefluorescent' => { 145 => 0x840 },
	'deviantwhitetungsten' => { 145 => 0x83f },
	'device' => { 543 => 'device' },
	'devicesettingdescription' => { 530 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 530 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 530 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 530 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 432 => 0x2 },
	'dewarpdata' => { 122 => 'DewarpData' },
	'dewarpflag' => { 122 => 'DewarpFlag' },
	'dialdirectiontvav' => { 90 => 0x706 },
	'dietaryneeds' => { 545 => 'dietaryNeeds' },
	'diffractioncompensation' => { 232 => 0x20e, 247 => 0x2ce, 248 => 0x142, 249 => 0x1b2, 250 => 0x1b2, 251 => 0x1a2, 252 => 0x1b6, 253 => 0x1b6, 254 => 0x1ba },
	'diffractioncorrection' => { 355 => 0xbc, 380 => 0x3 },
	'diffractioncorrectionon' => { 109 => 0x2070b },
	'digitalcreationdate' => { 138 => 0x3e },
	'digitalcreationtime' => { 138 => 0x3f },
	'digitaldeehighlightadj' => { 269 => 0x202 },
	'digitaldeeshadowadj' => { 269 => 0x200 },
	'digitaldeethreshold' => { 269 => 0x201 },
	'digitalfilter' => { 435 => 0x59 },
	'digitalfilter01' => { 377 => 0x5 },
	'digitalfilter02' => { 377 => 0x16 },
	'digitalfilter03' => { 377 => 0x27 },
	'digitalfilter04' => { 377 => 0x38 },
	'digitalfilter05' => { 377 => 0x49 },
	'digitalfilter06' => { 377 => 0x5a },
	'digitalfilter07' => { 377 => 0x6b },
	'digitalfilter08' => { 377 => 0x7c },
	'digitalfilter09' => { 377 => 0x8d },
	'digitalfilter10' => { 377 => 0x9e },
	'digitalfilter11' => { 377 => 0xaf },
	'digitalfilter12' => { 377 => 0xc0 },
	'digitalfilter13' => { 377 => 0xd1 },
	'digitalfilter14' => { 377 => 0xe2 },
	'digitalfilter15' => { 377 => 0xf3 },
	'digitalfilter16' => { 377 => 0x104 },
	'digitalfilter17' => { 377 => 0x115 },
	'digitalfilter18' => { 377 => 0x126 },
	'digitalfilter19' => { 377 => 0x137 },
	'digitalfilter20' => { 377 => 0x148 },
	'digitalgain' => { 79 => 0xb },
	'digitalgem' => { 227 => 0x0 },
	'digitalice' => { 269 => 0x100 },
	'digitalimageguid' => { 538 => 'DigImageGUID' },
	'digitallensoptimizer' => { 67 => 0xa },
	'digitallensoptimizersetting' => { 85 => 0x9 },
	'digitalroc' => { 266 => 0x0 },
	'digitalsourcefiletype' => { 538 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 538 => 'DigitalSourceType' },
	'digitalzoom' => { 37 => 0xc, 118 => 0xa, 133 => 0x1044, 147 => 0x68, 158 => 0x22, 159 => 0x1e, 163 => 'DigitalZoom', 188 => 0xc, 243 => 0x86, 292 => 0xa, 336 => 0x204, 391 => 0x1e, 398 => 0xa, 434 => 0x204, 482 => 0x12, 483 => 0x12 },
	'digitalzoomon' => { 434 => 0x21b },
	'digitalzoomratio' => { 125 => 0xa404, 470 => 0x200, 472 => 0x21c, 530 => 'DigitalZoomRatio' },
	'director' => { 186 => 'WM/Director', 409 => "\xa9dir", 411 => 'director', 417 => "\xa9dir", 553 => 'director' },
	'directorphotography' => { 553 => 'directorPhotography' },
	'directory' => { 126 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba, 30 => 0xb21 },
	'directoryindex2' => { 21 => 0x29c },
	'directoryitem' => { 505 => [\'Directory','DirectoryItem'] },
	'directoryitemlabel' => { 505 => [\'Directory','DirectoryItemLabel'] },
	'directoryitemlength' => { 505 => [\'Directory','DirectoryItemLength'] },
	'directoryitemmime' => { 505 => [\'Directory','DirectoryItemMime'] },
	'directoryitempadding' => { 505 => [\'Directory','DirectoryItemPadding'] },
	'directoryitemsemantic' => { 505 => [\'Directory','DirectoryItemSemantic'] },
	'directoryitemuri' => { 505 => [\'Directory','DirectoryItemURI'] },
	'directorynumber' => { 220 => 0x3, 421 => 0x12 },
	'disableautocreation' => { 504 => 'DisableAutoCreation' },
	'disablesuggestedaction' => { 504 => 'DisableSuggestedAction' },
	'disclaimer' => { 344 => 'Disclaimer' },
	'discnumber' => { 553 => 'discNumber' },
	'dishtype' => { 545 => 'dishType' },
	'disknumber' => { 409 => 'disk' },
	'dispbutton' => { 253 => 0x7d4, 254 => 0x7d8, 327 => 0x2ab },
	'displayallafpoints' => { 90 => 0x514 },
	'displayaperture' => { 37 => 0x23 },
	'displayedunitsx' => { 406 => 0x2 },
	'displayedunitsy' => { 406 => 0x6 },
	'displayname' => { 411 => 'displayname', 542 => 'displayName' },
	'distance1' => { 147 => 0x28 },
	'distance2' => { 147 => 0x2c },
	'distance3' => { 147 => 0x30 },
	'distance4' => { 147 => 0x34 },
	'distortion' => { 432 => 0xa050 },
	'distortioncompensation' => { 496 => 0x8040 },
	'distortioncontrol' => { 274 => 0x10 },
	'distortioncorrection' => { 84 => 0x3, 109 => 0x20705, 115 => 0x67, 125 => 0x7036, 218 => 0x4, 331 => 0x50b, 359 => '7.1', 380 => 0x0, 490 => 0x601, 491 => 0x5b },
	'distortioncorrection2' => { 335 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 521 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 109 => '0x20705.0', 115 => 0x63 },
	'distortioncorrectionsetting' => { 85 => 0x7, 459 => 0x2013 },
	'distortioncorrectionvalue' => { 84 => 0x9 },
	'distortioncorrectionversion' => { 218 => 0x0 },
	'distortioncorrparams' => { 125 => 0x7037, 469 => 0x1a23, 472 => 0x1870, 474 => 0x189c, 475 => 0x18cc, 476 => 0x17d0, 490 => 0x6ca, 491 => 0x64 },
	'distortioncorrparamsnumber' => { 472 => 0x1899, 474 => 0x18c5, 475 => 0x18f5, 476 => 0x17f9 },
	'distortioncorrparamspresent' => { 472 => 0x1898, 474 => 0x18c4, 475 => 0x18f4, 476 => 0x17f8, 478 => 0x10b, 479 => 0x10b, 490 => 0x600, 491 => 0x5a },
	'distortioneffect' => { 109 => 0x20709 },
	'distortionn' => { 359 => 0xc },
	'distortionparam02' => { 359 => 0x2 },
	'distortionparam04' => { 359 => 0x4 },
	'distortionparam08' => { 359 => 0x8 },
	'distortionparam09' => { 359 => 0x9 },
	'distortionparam11' => { 359 => 0xb },
	'distortionscale' => { 359 => 0x5 },
	'distributor' => { 543 => 'distributor' },
	'distributorproductid' => { 542 => 'distributorProductID' },
	'dloon' => { 109 => '0x20706.0', 115 => 0xdc },
	'dlosetting' => { 109 => 0x20706, 115 => 0xdd },
	'dlosettingapplied' => { 108 => 0x4 },
	'dloshootingdistance' => { 115 => 0xde },
	'dloversion' => { 108 => 0x5 },
	'dmcomment' => { 553 => 'comment' },
	'dmdithermatrix' => { 145 => 0xc7a },
	'dmdithermatrixheight' => { 145 => 0xc7c },
	'dmdithermatrixwidth' => { 145 => 0xc7b },
	'dngadobedata' => { 125 => 0xc634 },
	'dngbackwardversion' => { 125 => 0xc613 },
	'dngignoresidecars' => { 524 => 'DNGIgnoreSidecars', 526 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 125 => 0xc630 },
	'dngprivatedata' => { 125 => 0xc634 },
	'dngversion' => { 125 => 0xc612 },
	'document' => { 344 => 'Document' },
	'documentancestors' => { 541 => 'DocumentAncestors' },
	'documenthistory' => { 138 => 0xe7 },
	'documentid' => { 554 => 'DocumentID' },
	'documentname' => { 125 => 0x10d },
	'documentnotes' => { 138 => 0xe6 },
	'doi' => { 543 => 'doi' },
	'dopesheet' => { 538 => 'Dopesheet' },
	'dopesheetlink' => { 538 => 'DopesheetLink' },
	'dopesheetlinklink' => { 538 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 538 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 145 => 0xc82 },
	'dpp' => { 518 => 'dpp' },
	'dprawbokehshift' => { 109 => 0x20b20 },
	'dprawbokehshiftarea' => { 109 => 0x20b21 },
	'dprawghostingreductionarea' => { 109 => 0x20b30 },
	'dprawmicroadjustbackfront' => { 109 => 0x20b10 },
	'dprawmicroadjuststrength' => { 109 => 0x20b12 },
	'dr4cameramodel' => { 110 => 0x3 },
	'drangepriority' => { 133 => 0x1443 },
	'drangepriorityauto' => { 133 => 0x1444 },
	'drangepriorityfixed' => { 133 => 0x1445 },
	'drivemode' => { 119 => 0x3103, 131 => '0.1', 188 => 0x6, 191 => 0x1e, 194 => 0xe, 198 => 0x64d0, 331 => 0x600, 391 => 0x34, 425 => 0x1002, 435 => 0x3, 445 => 0x4, 446 => 0x7e, 447 => 0x34 },
	'drivemode2' => { 191 => 0xa, 371 => 0x7, 456 => 0xe, 464 => 0x1 },
	'drivemodesetting' => { 447 => 0x4 },
	'drivespeed' => { 131 => '0.2' },
	'dspfirmwareversion' => { 391 => 0x27 },
	'dualpixelraw' => { 67 => 0xb },
	'duration' => { 72 => 0x6a, 162 => 'Duration', 176 => 'Duration', 545 => 'duration', 553 => 'duration' },
	'durationscale' => { 553 => [\'duration','durationScale'] },
	'durationvalue' => { 553 => [\'duration','durationValue'] },
	'dustremovaldata' => { 69 => 0x97 },
	'dxcropalert' => { 249 => 0x250, 250 => 0x250, 251 => 0x23c, 252 => 0x250, 253 => 0x250, 254 => 0x254 },
	'dynamicafarea' => { 310 => '1.4', 319 => '1.4' },
	'dynamicafareasize' => { 247 => 0x370, 249 => 0x254, 250 => 0x254, 251 => 0x240, 252 => 0x254, 253 => 0x254, 254 => 0x258 },
	'dynamicareaafassist' => { 326 => 0x18, 327 => 0x18, 328 => 0x18, 329 => 0x18 },
	'dynamicareaafdisplay' => { 311 => '46.1', 313 => '47.1', 314 => '47.1', 323 => '47.1', 324 => '47.1' },
	'dynamicrange' => { 133 => 0x1400 },
	'dynamicrangeboost' => { 355 => 0xee },
	'dynamicrangeexpansion' => { 391 => 0x69, 425 => 0x100e },
	'dynamicrangemax' => { 114 => 0x7c },
	'dynamicrangemin' => { 114 => 0x7a },
	'dynamicrangeoptimizer' => { 191 => 0x15, 459 => [0xb025,0xb04f], 468 => 0x1144, 469 => [0x1144,0x324], 470 => [0x1120,0x300], 471 => [0x119c,0x37c], 472 => [0x1178,0x328], 473 => [0x1030,0x50], 474 => [0x228,0x50], 475 => [0x228,0x50], 476 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 456 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 445 => 0x19, 446 => 0x17, 447 => 0xd, 456 => 0x79, 464 => 0x5 },
	'dynamicrangeoptimizermode' => { 194 => 0x15, 445 => 0x18, 446 => 0x16, 456 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 191 => 0x27, 447 => 0xc, 464 => 0x4 },
	'dynamicrangesetting' => { 133 => 0x1402 },
	'e-dialinprogram' => { 371 => '1.3' },
	'earliestageorloweststage' => { 124 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 124 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 124 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 124 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 124 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 500 => 'EarthPos' },
	'earthposaltitude' => { 500 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 500 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 500 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 500 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 500 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 500 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 500 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 500 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 325 => '6.1' },
	'easyexposurecompensation' => { 310 => '6.4', 311 => '6.5', 313 => '6.3', 314 => '6.3', 318 => '5.1', 319 => '4.4', 320 => '5.2', 323 => '6.3', 324 => '6.3', 326 => 0x1f, 327 => 0x1d, 328 => 0x1d, 329 => 0x1d },
	'easymode' => { 37 => 0xb },
	'edgemapslope' => { 145 => 0x930 },
	'edgemapx1' => { 145 => 0x931 },
	'edgemapx2' => { 145 => 0x932 },
	'edgemapx3' => { 145 => 0x934 },
	'edgemapx4' => { 145 => 0x935 },
	'edgenoisereduction' => { 304 => 0x4, 496 => 0x8028 },
	'edit1' => { 417 => "\xa9ed1" },
	'edit2' => { 417 => "\xa9ed2" },
	'edit3' => { 417 => "\xa9ed3" },
	'edit4' => { 417 => "\xa9ed4" },
	'edit5' => { 417 => "\xa9ed5" },
	'edit6' => { 417 => "\xa9ed6" },
	'edit7' => { 417 => "\xa9ed7" },
	'edit8' => { 417 => "\xa9ed8" },
	'edit9' => { 417 => "\xa9ed9" },
	'edition' => { 543 => 'edition' },
	'editorialupdate' => { 138 => 0x8 },
	'editstatus' => { 138 => 0x7, 403 => 'EditStatus', 518 => 'EditStatus' },
	'editversionname' => { 303 => 0x3d136244 },
	'effectivelv' => { 391 => 0x2d },
	'effectivemaxaperture' => { 236 => 0x12, 237 => 0x13, 241 => 0x14 },
	'eissn' => { 543 => 'eIssn' },
	'electricalblackcolumns' => { 145 => 0x1810 },
	'electronicfront-curtainshutter' => { 313 => '5.2', 314 => '5.2', 323 => '5.3', 324 => '5.2' },
	'electronicfrontcurtainshutter' => { 459 => 0x201a },
	'elevation' => { 172 => 'Elevation' },
	'email' => { 164 => 'EMail' },
	'embargodate' => { 546 => 'embargoDate' },
	'embdencrightsexpr' => { 538 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 538 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 538 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 538 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 541 => 'EmbeddedXMPDigest' },
	'emissivity' => { 127 => 0x3 },
	'emptyslotrelease' => { 247 => 0x98c, 249 => 0x723, 250 => 0x733, 251 => 0x625, 252 => 0x655, 253 => 0x6bd, 254 => 0x6c1 },
	'enablechromanoisereduction' => { 145 => 0xe6e },
	'enablesharpening' => { 145 => 0x92e },
	'encodedby' => { 186 => 'WM/EncodedBy', 409 => "\xa9enc" },
	'encodedwith' => { 411 => 'Encoded_With' },
	'encoder' => { 409 => "\xa9too", 411 => 'encoder', 417 => "\xa9too" },
	'encoderid' => { 417 => "\xa9enc" },
	'encodingtime' => { 186 => 'WM/EncodingTime' },
	'encryptionkey' => { 432 => 0xa020 },
	'endingpage' => { 543 => 'endingPage' },
	'enduser' => { 341 => 'EndUser' },
	'enduserid' => { 341 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 341 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 247 => 0x992, 249 => 0x746, 250 => 0x756, 251 => 0x648, 252 => 0x678, 253 => 0x6e0, 254 => 0x6e4 },
	'engineer' => { 553 => 'engineer' },
	'enhancedarktones' => { 296 => 0x8 },
	'enhancedenoisealreadyapplied' => { 521 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 521 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 521 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 521 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 521 => 'EnhanceDetailsVersion' },
	'enhancement' => { 118 => 0x16, 119 => 0x3016 },
	'enhanceparams' => { 125 => 0xc7ee },
	'enhancer' => { 335 => 0x300 },
	'enhancervalues' => { 335 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 521 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 521 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 521 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 139 => 0x28 },
	'envelopepriority' => { 139 => 0x3c },
	'enveloperecordversion' => { 139 => 0x0 },
	'episode' => { 538 => 'Episode' },
	'episodeglobaluniqueid' => { 409 => 'egid' },
	'episodeidentifier' => { 538 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 538 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 538 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 336 => 0x20c },
	'epsonimagewidth' => { 336 => 0x20b },
	'epsonsoftware' => { 336 => 0x20d },
	'equipmentinstitution' => { 499 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 499 => 'EquipmentManufacturer' },
	'equipmentversion' => { 332 => 0x0 },
	'ettlii' => { 90 => 0x304, 91 => 0xd, 92 => 0xe, 93 => 0x7, 94 => 0x7, 95 => 0xe },
	'event' => { 502 => 'Event', 516 => 'Event', 538 => 'Event', 543 => 'event' },
	'eventalias' => { 542 => 'eventAlias' },
	'eventdate' => { 124 => [\'Event','EventEventDate'] },
	'eventday' => { 124 => [\'Event','EventDay'] },
	'eventearliestdate' => { 124 => [\'Event','EventEarliestDate'] },
	'eventend' => { 542 => 'eventEnd' },
	'eventenddayofyear' => { 124 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 124 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 124 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 124 => [\'Event','EventHabitat'] },
	'eventid' => { 124 => [\'Event','EventEventID'], 538 => 'EventId' },
	'eventlatestdate' => { 124 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 124 => [\'Event','EventMonth'] },
	'eventnumber' => { 419 => 0x9, 420 => 0x37, 421 => 0x3a },
	'eventparenteventid' => { 124 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 124 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 124 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 124 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 124 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 124 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 542 => 'eventStart' },
	'eventstartdayofyear' => { 124 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 542 => 'eventSubtype' },
	'eventtime' => { 124 => [\'Event','EventEventTime'] },
	'eventtype' => { 542 => 'eventType' },
	'eventverbatimeventdate' => { 124 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 124 => [\'Event','EventYear'] },
	'evfgrid' => { 326 => 0x15f, 327 => 0x165, 328 => 0x165, 329 => 0x17d },
	'evfimageframe' => { 326 => 0x15e, 327 => 0x164, 328 => 0x164, 329 => 0x17c },
	'evfreleaseindicator' => { 327 => 0x24f, 328 => 0x24f, 329 => 0x267 },
	'evfwarmdisplaybrightness' => { 327 => 0x24d, 328 => 0x24d, 329 => 0x265 },
	'evfwarmdisplaymode' => { 327 => 0x24b, 328 => 0x24b, 329 => 0x263 },
	'evsteps' => { 371 => '1.2', 373 => 0x0 },
	'evstepsize' => { 315 => '5.1', 316 => '6.1', 317 => '6.1', 321 => '0.7' },
	'exclusivecoverage' => { 512 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 546 => 'exclusivityEndDate' },
	'excursiontolerance' => { 140 => 0x82 },
	'executiveproducer' => { 409 => "\xa9xpd" },
	'exif' => { 126 => 'EXIF' },
	'exifbyteorder' => { 126 => 'ExifByteOrder' },
	'exifcamerainfo' => { 138 => 0xe8 },
	'exifimageheight' => { 125 => 0xa003, 530 => 'PixelYDimension' },
	'exifimagewidth' => { 125 => 0xa002, 530 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 126 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 125 => 0x9000, 530 => 'ExifVersion' },
	'exitpupilposition' => { 236 => 0x4, 237 => 0x4, 241 => 0x4 },
	'expirationdate' => { 138 => 0x25, 546 => 'expirationDate' },
	'expirationtime' => { 138 => 0x26 },
	'exposure' => { 125 => 0xfe51, 524 => 'Exposure', 526 => 'Exposure' },
	'exposure2012' => { 524 => 'Exposure2012', 526 => 'Exposure2012' },
	'exposureadj' => { 301 => 0x0 },
	'exposureadj2' => { 301 => 0x12 },
	'exposureadjust' => { 435 => 0xc },
	'exposurebracketingindicatorlast' => { 191 => 0x52 },
	'exposurebracketshotnumber' => { 194 => 0x2d, 456 => 0x2f },
	'exposurebracketstepsize' => { 371 => 0x8 },
	'exposurebracketvalue' => { 243 => 0x19 },
	'exposurecompautocancel' => { 90 => 0x113 },
	'exposurecompensation' => { 82 => 0x6, 99 => 0x0, 125 => 0x9204, 147 => 0x24, 163 => 'ExposureComp', 183 => 'ExposureCompensation', 188 => 0xd, 189 => 0x53, 190 => 0x1e, 194 => 0x49c0, 336 => 0x1006, 391 => 0x16, 400 => 0x402, 432 => 0xa013, 435 => [0xc,0x35,0x4d], 468 => 0x114c, 469 => 0x114c, 470 => 0x1128, 472 => 0x1180, 473 => 0x1038, 474 => 0x230, 475 => 0x230, 476 => 0x223, 530 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 464 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 253 => 0x794, 254 => 0x798 },
	'exposurecompensationmode' => { 191 => 0x47, 194 => 0x2a },
	'exposurecompensationset' => { 445 => 0x3, 446 => 0x3, 447 => 0x3, 464 => 0x1e },
	'exposurecompensationsetting' => { 191 => 0x1 },
	'exposurecompstepsize' => { 310 => '6.3', 311 => '7.3', 313 => '7.3', 314 => '7.3', 319 => '4.3', 323 => '7.3', 324 => '7.3' },
	'exposurecontrolstep' => { 318 => '6.1', 320 => '6.1' },
	'exposurecontrolstepsize' => { 310 => '6.2', 311 => '7.1', 313 => '7.1', 314 => '7.1', 319 => '4.2', 323 => '7.1', 324 => '7.1', 325 => '7.1', 326 => 0x1d, 327 => 0x1b, 328 => 0x1b, 329 => 0x1b },
	'exposurecount' => { 133 => 0x1032 },
	'exposuredelay' => { 253 => 0x800, 254 => 0x804, 327 => 0x2f1 },
	'exposuredelaymode' => { 310 => '10.1', 311 => '11.1', 313 => '11.1', 314 => '11.1', 315 => '9.1', 316 => '10.1', 317 => '10.1', 319 => '10.4', 320 => '10.1', 321 => '6.4', 323 => '11.1', 324 => '11.1', 325 => '11.2' },
	'exposuredifference' => { 243 => 0xe },
	'exposuregaincustom' => { 145 => 0x89c },
	'exposuregaindaylight' => { 145 => 0x898 },
	'exposuregainflash' => { 145 => 0x89b },
	'exposuregainfluorescent' => { 145 => 0x89a },
	'exposuregaintungsten' => { 145 => 0x899 },
	'exposureindex' => { 125 => 0xa215, 530 => 'ExposureIndex' },
	'exposureindicator' => { 191 => 0x50 },
	'exposurelevelincrements' => { 88 => 0x6, 89 => 0x6, 90 => 0x101, 91 => 0x5, 92 => 0x6, 93 => 0x5, 94 => 0x5, 95 => 0x6, 96 => 0x4, 445 => 0x58, 446 => 0x58 },
	'exposurelockused' => { 510 => 'ExposureLockUsed' },
	'exposuremode' => { 125 => 0xa402, 163 => 'ExposureMode', 188 => 0x1, 189 => 0xa, 190 => 0x0, 191 => 0x0, 194 => 0x34, 331 => 0x200, 352 => 0x40d, 435 => 0x8, 459 => 0xb041, 530 => 'ExposureMode' },
	'exposuremodeinmanual' => { 90 => 0x10b },
	'exposureprogram' => { 125 => 0x8822, 425 => 0x1001, 438 => [0x17e,0x43], 445 => 0x3c, 446 => 0x3c, 447 => 0x5, 451 => 0x14, 456 => 0x3f, 464 => 0x2, 468 => 0x1175, 469 => 0x1179, 470 => 0x1155, 471 => 0x11d1, 472 => 0x11ad, 473 => 0x1065, 474 => 0x25d, 475 => 0x25d, 476 => 0x24c, 487 => 0xb, 488 => 0xc, 489 => 0xb, 491 => 0x48, 530 => 'ExposureProgram' },
	'exposureshift' => { 331 => 0x203 },
	'exposurestandardadjustment' => { 459 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 31 => 0x6, 32 => 0x7, 82 => 0x16, 125 => 0x829a, 144 => 0xfd05, 147 => 0x20, 149 => 0xfa24, 151 => 0xf104, 154 => 0x12, 156 => 0x38, 158 => 0x14, 159 => 0x10, 161 => 0x10, 163 => 'ExposureTime', 188 => 0x9, 189 => 0x35, 190 => 0x48, 191 => 0x8, 194 => 0x49b8, 391 => 0x12, 432 => 0xa018, 435 => [0x32,0x4a], 445 => 0x0, 446 => 0x0, 464 => [0x21,0x23,0x27], 491 => 0x10, 530 => 'ExposureTime' },
	'exposuretime2' => { 435 => [0x33,0x4b] },
	'exposuretuning' => { 243 => 0x1c },
	'exposurevalue' => { 145 => 0x3 },
	'exposurewarning' => { 133 => 0x1302 },
	'exrauto' => { 133 => 0x1033 },
	'exrmode' => { 133 => 0x1034 },
	'extdescraccessibility' => { 537 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 249 => 0x120, 250 => 0x120, 251 => 0x114, 252 => 0x124, 253 => 0x124, 254 => 0x128 },
	'extendedshutterspeeds' => { 326 => 0xf2, 327 => 0x102, 328 => 0x102, 329 => 0x118 },
	'extendedwbdetect' => { 331 => 0x902 },
	'extender' => { 332 => 0x301 },
	'extenderfirmwareversion' => { 332 => 0x304 },
	'extendermagnification' => { 165 => 'Magnification' },
	'extendermake' => { 165 => 'Make' },
	'extendermodel' => { 165 => 'Model', 332 => 0x303 },
	'extenderserialnumber' => { 165 => 'SerialNumber', 332 => 0x302 },
	'extenderstatus' => { 388 => 0x3 },
	'externalflash' => { 334 => 0x1201 },
	'externalflashae1' => { 336 => 0x101f },
	'externalflashae1_0' => { 336 => 0x101b },
	'externalflashae2' => { 336 => 0x1020 },
	'externalflashae2_0' => { 336 => 0x101c },
	'externalflashbounce' => { 334 => 0x1204, 336 => 0x1026, 378 => 0x1a },
	'externalflashcompensation' => { 223 => 0x1b },
	'externalflashexposurecomp' => { 243 => 0x17, 378 => 0x19 },
	'externalflashfirmware' => { 221 => 0x6, 222 => 0x6, 223 => 0x6, 224 => 0x6, 225 => 0x6, 226 => 0x6 },
	'externalflashflags' => { 221 => 0x8, 222 => 0x8, 223 => 0x8, 224 => 0x8, 226 => 0x8 },
	'externalflashguidenumber' => { 334 => 0x1203, 378 => '24.1' },
	'externalflashgvalue' => { 336 => 0x1025 },
	'externalflashmode' => { 336 => 0x1028, 378 => 0x2 },
	'externalflashreadystate' => { 225 => '9.1' },
	'externalflashstatus' => { 225 => '8.2' },
	'externalflashzoom' => { 334 => 0x1205, 336 => 0x1027 },
	'externalflashzoomoverride' => { 225 => '8.1' },
	'externalmetadatalink' => { 538 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 350 => 0x311, 353 => 0x311, 354 => 0x311, 357 => 0x3408 },
	'extrainfoversion' => { 449 => 0x1a },
	'eyedetection' => { 2 => 0x18 },
	'eyestartaf' => { 191 => 0x40 },
	'fac100per' => { 145 => 0xe94 },
	'fac170per' => { 145 => 0xe93 },
	'fac18per' => { 145 => 0xe92 },
	'face10position' => { 116 => 0x3f4, 117 => 0x1ec, 219 => 0x28, 375 => 0x12 },
	'face10size' => { 376 => 0x12 },
	'face11position' => { 219 => 0x2c, 375 => 0x14 },
	'face11size' => { 376 => 0x14 },
	'face12position' => { 219 => 0x30, 375 => 0x16 },
	'face12size' => { 376 => 0x16 },
	'face13position' => { 375 => 0x18 },
	'face13size' => { 376 => 0x18 },
	'face14position' => { 375 => 0x1a },
	'face14size' => { 376 => 0x1a },
	'face15position' => { 375 => 0x1c },
	'face15size' => { 376 => 0x1c },
	'face16position' => { 375 => 0x1e },
	'face16size' => { 376 => 0x1e },
	'face17position' => { 375 => 0x20 },
	'face17size' => { 376 => 0x20 },
	'face18position' => { 375 => 0x22 },
	'face18size' => { 376 => 0x22 },
	'face19position' => { 375 => 0x24 },
	'face19size' => { 376 => 0x24 },
	'face1position' => { 58 => 0x8, 116 => 0xd, 117 => 0x18, 219 => 0x4, 347 => 0x1, 375 => 0x0, 422 => 0xbc, 452 => 0x1, 453 => 0x0, 454 => 0x0, 455 => 0x5b },
	'face1size' => { 376 => 0x0 },
	'face20position' => { 375 => 0x26 },
	'face20size' => { 376 => 0x26 },
	'face21position' => { 375 => 0x28 },
	'face21size' => { 376 => 0x28 },
	'face22position' => { 375 => 0x2a },
	'face22size' => { 376 => 0x2a },
	'face23position' => { 375 => 0x2c },
	'face23size' => { 376 => 0x2c },
	'face24position' => { 375 => 0x2e },
	'face24size' => { 376 => 0x2e },
	'face25position' => { 375 => 0x30 },
	'face25size' => { 376 => 0x30 },
	'face26position' => { 375 => 0x32 },
	'face26size' => { 376 => 0x32 },
	'face27position' => { 375 => 0x34 },
	'face27size' => { 376 => 0x34 },
	'face28position' => { 375 => 0x36 },
	'face28size' => { 376 => 0x36 },
	'face29position' => { 375 => 0x38 },
	'face29size' => { 376 => 0x38 },
	'face2position' => { 58 => 0xa, 116 => 0x7c, 117 => 0x4c, 219 => 0x8, 347 => 0x5, 375 => 0x2, 422 => 0xc8, 452 => 0x6, 453 => 0x20, 454 => 0x25, 455 => 0x65 },
	'face2size' => { 376 => 0x2 },
	'face30position' => { 375 => 0x3a },
	'face30size' => { 376 => 0x3a },
	'face31position' => { 375 => 0x3c },
	'face31size' => { 376 => 0x3c },
	'face32position' => { 375 => 0x3e },
	'face32size' => { 376 => 0x3e },
	'face3position' => { 58 => 0xc, 116 => 0xeb, 117 => 0x80, 219 => 0xc, 347 => 0x9, 375 => 0x4, 422 => 0xd4, 452 => 0xb, 453 => 0x40, 454 => 0x4a, 455 => 0x6f },
	'face3size' => { 376 => 0x4 },
	'face4position' => { 58 => 0xe, 116 => 0x15a, 117 => 0xb4, 219 => 0x10, 347 => 0xd, 375 => 0x6, 422 => 0xe0, 452 => 0x10, 453 => 0x60, 454 => 0x6f, 455 => 0x79 },
	'face4size' => { 376 => 0x6 },
	'face5position' => { 58 => 0x10, 116 => 0x1c9, 117 => 0xe8, 219 => 0x14, 347 => 0x11, 375 => 0x8, 422 => 0xec, 452 => 0x15, 453 => 0x80, 454 => 0x94 },
	'face5size' => { 376 => 0x8 },
	'face6position' => { 58 => 0x12, 116 => 0x238, 117 => 0x11c, 219 => 0x18, 375 => 0xa, 422 => 0xf8, 452 => 0x1a, 453 => 0xa0, 454 => 0xb9 },
	'face6size' => { 376 => 0xa },
	'face7position' => { 58 => 0x14, 116 => 0x2a7, 117 => 0x150, 219 => 0x1c, 375 => 0xc, 422 => 0x104, 452 => 0x1f, 453 => 0xc0, 454 => 0xde },
	'face7size' => { 376 => 0xc },
	'face8position' => { 58 => 0x16, 116 => 0x316, 117 => 0x184, 219 => 0x20, 375 => 0xe, 422 => 0x110, 452 => 0x24, 453 => 0xe0, 454 => 0x103 },
	'face8size' => { 376 => 0xe },
	'face9position' => { 58 => 0x18, 116 => 0x385, 117 => 0x1b8, 219 => 0x24, 375 => 0x10 },
	'face9size' => { 376 => 0x10 },
	'facebalanceorigi' => { 517 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 517 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 517 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 517 => 'FaceBalanceWarmth' },
	'facedetect' => { 391 => 0x76, 432 => 0x100 },
	'facedetectarea' => { 335 => 0x1201 },
	'facedetectframecrop' => { 335 => 0x1207 },
	'facedetectframesize' => { 58 => 0x3, 116 => 0x1, 117 => 0x4, 219 => 0x1, 335 => 0x1203, 391 => 0x77, 422 => 0xb6 },
	'facedetection' => { 447 => 0x30, 464 => 0x19 },
	'faceelementpositions' => { 133 => 0x4203 },
	'faceelementselected' => { 133 => 0x4005 },
	'faceelementtypes' => { 133 => 0x4201 },
	'faceid' => { 520 => 'FaceID' },
	'faceinfounknown' => { 119 => 0x2089 },
	'facename' => { 432 => 0x123 },
	'faceorientation' => { 117 => 0x8 },
	'faceposition' => { 374 => 0x2, 433 => 0x4 },
	'facepositions' => { 133 => 0x4103 },
	'facerecognition' => { 432 => 0x120 },
	'facesdetected' => { 58 => 0x2, 59 => 0x2, 60 => 0x3, 116 => 0x0, 117 => 0x2, 119 => 0x211c, 133 => 0x4100, 219 => 0x3, 335 => 0x1200, 355 => 0x3f, 374 => 0x0, 422 => 0xb5, 433 => 0x0, 452 => 0x0, 455 => 0x3, 467 => 0x30 },
	'facesrecognized' => { 348 => 0x0 },
	'facewidth' => { 59 => 0x1 },
	'fade' => { 459 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 115 => 0x38 },
	'faithfuloutputshadowpoint' => { 115 => 0x39 },
	'faithfulrawcolortone' => { 115 => 0x31 },
	'faithfulrawcontrast' => { 115 => 0x33 },
	'faithfulrawhighlight' => { 115 => 0x79 },
	'faithfulrawhighlightpoint' => { 115 => 0x36 },
	'faithfulrawlinear' => { 115 => 0x34 },
	'faithfulrawsaturation' => { 115 => 0x32 },
	'faithfulrawshadow' => { 115 => 0x82 },
	'faithfulrawshadowpoint' => { 115 => 0x37 },
	'faithfulrawsharpness' => { 115 => 0x35 },
	'faithfulunsharpmaskfineness' => { 115 => 0xac },
	'faithfulunsharpmaskstrength' => { 115 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 115 => 0xae },
	'far' => { 507 => 'Far' },
	'fastresetlinetime' => { 145 => 0x1860 },
	'feedidentifier' => { 538 => 'FeedIdentifier' },
	'femicroadjustment' => { 90 => 0x111 },
	'ffid' => { 528 => 'ffid' },
	'field' => { 542 => 'field' },
	'fieldcount' => { 336 => 0x103f },
	'fieldofview' => { 417 => "FOV\x00" },
	'fifoenonepixeldelay' => { 145 => 0x1901 },
	'filecreatedate' => { 126 => 'FileCreateDate' },
	'filedatarate' => { 553 => 'fileDataRate' },
	'fileformat' => { 101 => 0x0, 139 => 0x14, 435 => [0x22,0x26], 459 => 0xb000 },
	'filegroupid' => { 126 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 30 => 0xb2d, 356 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 126 => 'FileModifyDate' },
	'filename' => { 126 => 'FileName' },
	'filenameasdelivered' => { 341 => 'FileNameAsDelivered' },
	'filenumber' => { 61 => 0x1, 69 => 0x8, 103 => 0x1817, 120 => 'Canon-FileNumber', 220 => 0x4, 421 => 0x10 },
	'filenumbermemory' => { 188 => 0x1a },
	'filenumbersequence' => { 310 => '12.2', 315 => '3.1', 316 => '4.1', 317 => '4.1', 319 => '11.1', 320 => '4.3', 325 => '5.2', 326 => 0x4e, 327 => 0x48, 328 => 0x48, 329 => 0x48 },
	'filepermissions' => { 126 => 'FilePermissions' },
	'filesource' => { 125 => 0xa300, 133 => 0x8000, 530 => 'FileSource' },
	'fileuserid' => { 126 => 'FileUserID' },
	'fileversion' => { 139 => 0x16 },
	'fillflashautoreduction' => { 88 => 0xe, 89 => 0xe, 96 => 0xa },
	'filllight' => { 524 => 'FillLight', 526 => 'FillLight' },
	'fillorder' => { 125 => 0x10a },
	'filmgraineffect' => { 331 => 0x538 },
	'filmmode' => { 133 => 0x1401, 352 => 0x412, 355 => 0x42 },
	'filmtype' => { 269 => 0x2 },
	'filtereffect' => { 61 => 0xe, 261 => 0x37, 262 => 0x3f, 263 => 0x47, 355 => 0xa1 },
	'filtereffectauto' => { 76 => 0xa0 },
	'filtereffectfaithful' => { 75 => 0x70, 76 => 0x70 },
	'filtereffectlandscape' => { 75 => 0x40, 76 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 75 => 0x88, 76 => 0x88 },
	'filtereffectneutral' => { 75 => 0x58, 76 => 0x58 },
	'filtereffectportrait' => { 75 => 0x28, 76 => 0x28 },
	'filtereffectstandard' => { 75 => 0x10, 76 => 0x10 },
	'filtereffectuserdef1' => { 75 => 0xa0, 76 => 0xb8 },
	'filtereffectuserdef2' => { 75 => 0xb8, 76 => 0xd0 },
	'filtereffectuserdef3' => { 75 => 0xd0, 76 => 0xe8 },
	'finderdisplayduringexposure' => { 89 => 0x1 },
	'finesharpness' => { 391 => 0x70 },
	'finetuneoptcenterweighted' => { 310 => '7.2', 311 => '9.1', 313 => '9.1', 314 => '9.1', 318 => '8.1', 323 => '9.1', 324 => '9.1', 325 => '9.1', 326 => 0x25, 327 => 0x23, 328 => 0x23, 329 => 0x23 },
	'finetuneopthighlightweighted' => { 313 => '46.1', 314 => '46.1', 323 => '46.1', 324 => '46.1', 326 => 0x29, 327 => 0x27, 328 => 0x27, 329 => 0x27 },
	'finetuneoptmatrixmetering' => { 310 => '8.1', 311 => '8.2', 313 => '8.2', 314 => '8.2', 318 => '7.2', 319 => '6.1', 323 => '8.2', 324 => '8.2', 325 => '8.2', 326 => 0x23, 327 => 0x21, 328 => 0x21, 329 => 0x21 },
	'finetuneoptspotmetering' => { 310 => '8.2', 311 => '9.2', 313 => '9.2', 314 => '9.2', 318 => '8.2', 319 => '6.2', 323 => '9.2', 324 => '9.2', 325 => '9.2', 326 => 0x27, 327 => 0x25, 328 => 0x25, 329 => 0x25 },
	'finishexposure' => { 145 => 0xdbd },
	'finishfiletype' => { 145 => 0xdb8 },
	'finishlook' => { 145 => 0xdbc },
	'finishnoise' => { 145 => 0xdba },
	'finishresolution' => { 145 => 0xdb9 },
	'finishsharpening' => { 145 => 0xdbb },
	'firmware' => { 336 => 0x405, 435 => [0x8c,0x17,0x3b], 521 => 'Firmware' },
	'firmware2' => { 435 => 0x57 },
	'firmwaredate' => { 118 => 0x15, 119 => 0x2001, 419 => 0x4, 421 => 0x30 },
	'firmwareid' => { 195 => 0x0 },
	'firmwarename' => { 432 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 69 => 0x1e, 423 => 0x0 },
	'firmwarerevision2' => { 423 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 145 => [0x415,0xce5], 161 => 0x57, 163 => 'FirmwareVersion', 353 => 0x320, 355 => 0x2, 357 => 0x3109, 391 => 0x230, 417 => ['CNFV','FIRM','info'], 420 => 0x18, 421 => 0x2a, 425 => 0x2 },
	'firmwareversions' => { 400 => 0x301 },
	'firstphotodate' => { 510 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 341 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 138 => 0x16, 518 => 'FixtureIdentifier' },
	'flash' => { 120 => 'XMP-Flash', 125 => 0x9209, 159 => 0x22, 189 => 0x1f, 190 => 0x15, 421 => 0x5a, 530 => 'Flash' },
	'flashaction' => { 445 => 0x3e, 446 => 0x3e, 459 => 0x2017, 464 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 445 => 0x4c, 446 => 0x4c, 464 => 0x77 },
	'flashactionexternal' => { 464 => [0x78,0x7c] },
	'flashactivity' => { 37 => 0x1c },
	'flashbatterylevel' => { 48 => 0x249 },
	'flashbias' => { 355 => 0x24 },
	'flashbits' => { 37 => 0x1d },
	'flashburstpriority' => { 326 => 0x101, 327 => 0x111, 328 => 0x111, 329 => 0x129 },
	'flashbuttonfunction' => { 90 => 0x70e },
	'flashchargelevel' => { 336 => 0x1010 },
	'flashcolorfilter' => { 223 => 0x10, 224 => 0x10, 226 => 0x10 },
	'flashcommandermode' => { 221 => '9.1', 222 => '9.1', 223 => '9.1', 224 => '9.1', 226 => '9.1' },
	'flashcompensation' => { 145 => 0x3f3, 221 => 0xa, 222 => 0xa, 223 => 0xa, 224 => 0x27, 225 => 0xa, 226 => 0xa, 521 => 'FlashCompensation' },
	'flashcontrol' => { 445 => 0x23, 446 => 0x1f, 447 => 0x21 },
	'flashcontrolbuilt-in' => { 319 => '16.1', 320 => '23.1', 322 => '23.1', 323 => '24.1' },
	'flashcontrolmode' => { 221 => '9.2', 222 => '9.2', 223 => '9.2', 224 => '9.2', 226 => '9.2', 232 => 0x214, 247 => 0x2d4, 248 => 0x148, 249 => 0x1b8, 250 => 0x1b8, 251 => 0x1a8, 252 => 0x1bc, 253 => 0x1bc, 254 => 0x1c0, 331 => 0x404 },
	'flashcurtain' => { 355 => 0x48 },
	'flashdefault' => { 191 => 0x42 },
	'flashdevice' => { 336 => 0x1005 },
	'flashdistance' => { 119 => 0x2034 },
	'flashenergy' => { 125 => 0xa20b, 530 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 243 => 0x18 },
	'flashexposurecomp' => { 82 => 0xf, 133 => 0x1011, 166 => 'ExposureComp', 188 => 0x23, 193 => 0x104, 194 => 0x49c1, 243 => 0x12, 331 => 0x401, 336 => 0x1023, 391 => 0x4d, 425 => 0x100b, 435 => [0x3a,0x56], 459 => 0x104 },
	'flashexposurecomp2' => { 290 => 0x4d2 },
	'flashexposurecomp3' => { 223 => 0x1d },
	'flashexposurecomp4' => { 223 => 0x27 },
	'flashexposurecomparea' => { 311 => '38.4', 313 => '38.4', 314 => '38.4', 323 => '38.4', 324 => '38.4', 326 => 0x5d, 327 => 0x59, 328 => 0x59, 329 => 0x59 },
	'flashexposurecompset' => { 191 => 0x10, 363 => 0xe, 445 => 0x14, 446 => 0x12, 447 => 0x23, 464 => 0x1f },
	'flashexposurecompset2' => { 464 => [0x26,0x2c] },
	'flashexposureindicator' => { 191 => 0x54 },
	'flashexposureindicatorlast' => { 191 => 0x56 },
	'flashexposureindicatornext' => { 191 => 0x55 },
	'flashexposurelock' => { 61 => 0x19 },
	'flashfired' => { 147 => 0x5d, 166 => 'Fired', 188 => 0x14, 289 => '590.3', 530 => [\'Flash','FlashFired'] },
	'flashfiring' => { 90 => 0x306, 91 => 0x6, 92 => 0x7, 95 => 0x7 },
	'flashfirmwareversion' => { 332 => 0x1002 },
	'flashfocallength' => { 221 => 0xb, 222 => 0xc, 223 => 0xc, 224 => 0xc, 225 => 0xc, 226 => 0x26 },
	'flashfunction' => { 194 => 0x31, 530 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 221 => 0xe, 222 => 0xf, 223 => 0xf, 224 => 0xf, 225 => 0xf, 226 => 0xf, 232 => 0x21a, 247 => 0x2da, 248 => 0x14e, 251 => 0x1ae, 252 => 0x1c2, 253 => 0x1c2, 254 => 0x1c6 },
	'flashgroupacompensation' => { 221 => 0x11, 222 => 0x12, 223 => 0x13, 224 => 0x28, 225 => 0x28, 226 => 0x28 },
	'flashgroupacontrolmode' => { 221 => 0xf, 222 => '16.1', 223 => '17.1', 224 => '17.1', 225 => '17.1', 226 => '17.1' },
	'flashgroupaoutput' => { 221 => 0x11, 222 => 0x12, 223 => 0x13, 224 => 0x28, 225 => 0x28, 226 => 0x28 },
	'flashgroupbcompensation' => { 221 => 0x12, 222 => 0x13, 223 => 0x14, 224 => 0x29, 225 => 0x29, 226 => 0x29 },
	'flashgroupbcontrolmode' => { 221 => 0x10, 222 => '17.1', 223 => '18.1', 224 => '18.1', 225 => '18.1', 226 => '18.1' },
	'flashgroupboutput' => { 221 => 0x12, 222 => 0x13, 223 => 0x14, 224 => 0x29, 225 => 0x29, 226 => 0x29 },
	'flashgroupccompensation' => { 222 => 0x14, 223 => 0x15, 224 => 0x2a, 225 => 0x2a, 226 => 0x2a },
	'flashgroupccontrolmode' => { 222 => '17.2', 223 => '18.2', 224 => '18.2', 225 => '18.2', 226 => '18.2' },
	'flashgroupcoutput' => { 222 => 0x14, 223 => 0x15, 224 => 0x2a, 225 => 0x2a, 226 => 0x2a },
	'flashguidenumber' => { 82 => 0xd, 100 => 0x0, 166 => 'GuideNumber' },
	'flashilluminationpattern' => { 226 => 0x25 },
	'flashintensity' => { 118 => [0x19,0x5], 331 => 0x405 },
	'flashlevel' => { 312 => 0x9, 459 => 0xb048 },
	'flashmake' => { 166 => 'Make' },
	'flashmanufacturer' => { 185 => 'FlashManufacturer' },
	'flashmastercompensation' => { 232 => 0x22e, 247 => 0x2ee, 248 => 0x162, 251 => 0x1aa, 252 => 0x1be, 253 => 0x1be, 254 => 0x1c2 },
	'flashmastercontrolmode' => { 232 => 0x22c, 247 => 0x2ec, 248 => 0x160 },
	'flashmasteroutput' => { 232 => 0x232, 247 => 0x2f2, 248 => 0x166 },
	'flashmetering' => { 188 => 0x3f, 191 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 391 => 0x20a },
	'flashmode' => { 118 => 0x4, 145 => 0x3f2, 147 => 0x5c, 158 => 0x27, 166 => 'Mode', 188 => 0x2, 189 => 0x20, 190 => 0x16, 191 => 0xf, 243 => 0x87, 331 => 0x400, 336 => 0x1004, 391 => 0xc, 398 => 0x4, 424 => 0x20, 425 => 0x100a, 434 => 0x225, 445 => 0x13, 446 => 0x7f, 447 => 0x20, 464 => 0x10, 468 => 0x1138, 469 => 0x1138, 470 => 0x1114, 471 => 0x1190, 472 => 0x116c, 473 => 0x1024, 474 => 0x21c, 475 => 0x21c, 476 => 0x211, 530 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 253 => 0x80e, 254 => 0x812 },
	'flashmodebuttonplaybackmode' => { 253 => 0x818, 254 => 0x81c },
	'flashmodel' => { 166 => 'Model', 185 => 'FlashModel', 332 => 0x1001 },
	'flashoptions' => { 371 => 0x2 },
	'flashoptions2' => { 371 => 0x10 },
	'flashoutput' => { 48 => 0x248, 82 => 0x21, 221 => 0xa, 222 => 0xa, 223 => 0xa, 224 => 0x27, 226 => 0x21, 232 => 0x21e, 247 => 0x2de, 248 => 0x152, 251 => 0x1b2, 252 => 0x1c6, 253 => 0x1c6, 254 => 0x1ca },
	'flashpixversion' => { 125 => 0xa000, 530 => 'FlashpixVersion' },
	'flashredeyemode' => { 530 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 232 => 0x228, 247 => 0x2e8, 248 => 0x15c, 251 => 0x1bc, 331 => 0x403 },
	'flashreturn' => { 530 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 166 => 'SerialNumber', 332 => 0x1003 },
	'flashsetting' => { 243 => 0x8 },
	'flashshutterspeed' => { 310 => '20.2', 311 => '23.2', 313 => '23.2', 314 => '23.2', 319 => '15.2', 320 => '22.2', 321 => '7.2', 322 => '22.2', 323 => '23.2', 324 => '23.2', 325 => '23.1', 326 => 0x5b, 327 => 0x57, 328 => 0x57, 329 => 0x57 },
	'flashsource' => { 221 => 0x4, 222 => 0x4, 223 => 0x4, 224 => 0x4, 225 => 0x4, 226 => 0x4 },
	'flashstatus' => { 378 => 0x0, 464 => [0x82,0x86], 478 => 0x31, 479 => 0x39, 480 => 0x39 },
	'flashstatusbuilt-in' => { 447 => [0x87,0x287] },
	'flashstatusexternal' => { 447 => [0x88,0x288] },
	'flashsyncspeed' => { 310 => '20.1', 311 => '23.1', 313 => '23.1', 314 => '23.1', 319 => '15.1', 320 => '22.1', 322 => '22.1', 323 => '23.1', 324 => '23.1', 326 => 0x57, 327 => 0x53, 328 => 0x53, 329 => 0x53 },
	'flashsyncspeedav' => { 88 => 0x3, 90 => 0x10f, 91 => 0x2, 92 => 0x3, 93 => 0x2, 94 => 0x2, 95 => 0x3, 96 => 0x6 },
	'flashthreshold' => { 100 => 0x1 },
	'flashtype' => { 166 => 'Type', 191 => 0x59, 243 => 0x9, 332 => 0x1000 },
	'flashwarning' => { 320 => '30.1', 321 => '7.1', 325 => '31.1', 355 => 0x62 },
	'flashwirelessoption' => { 232 => 0x234, 247 => 0x2e6, 248 => 0x15a, 251 => 0x1c8 },
	'flexiblespotposition' => { 459 => 0x201d },
	'flickadvancedirection' => { 327 => 0x25f, 328 => 0x25f, 329 => 0x277 },
	'flickerreduce' => { 434 => 0x218 },
	'flickerreduction' => { 133 => 0x1446, 273 => 0x7 },
	'flickerreductionindicator' => { 268 => 0x532 },
	'flickerreductionshooting' => { 247 => 0x2d0, 249 => 0x1b4, 250 => 0x1b4, 251 => 0x1a4, 252 => 0x1b8, 253 => 0x1b8, 254 => 0x1bc },
	'flightpitchdegree' => { 122 => 'FlightPitchDegree' },
	'flightrolldegree' => { 122 => 'FlightRollDegree' },
	'flightxspeed' => { 122 => 'FlightXSpeed' },
	'flightyawdegree' => { 122 => 'FlightYawDegree' },
	'flightyspeed' => { 122 => 'FlightYSpeed' },
	'flightzspeed' => { 122 => 'FlightZSpeed' },
	'fliphorizontal' => { 303 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 31 => 0x5, 32 => 0x6, 82 => 0x15, 125 => 0x829d, 144 => 0xfd04, 147 => 0x1e, 149 => 0xfa23, 151 => 0xf103, 154 => 0x13, 156 => 0x3c, 158 => 0x1c, 159 => 0x18, 161 => 0xc, 170 => 'FNumber', 188 => 0xa, 189 => 0x36, 190 => 0x47, 191 => 0x9, 194 => 0x49c7, 241 => 0x38, 354 => 0x35a, 391 => 0x13, 432 => 0xa019, 435 => [0x31,0x49], 445 => 0x1, 446 => 0x1, 464 => [0x20,0x22,0x26], 530 => 'FNumber' },
	'focaldistance' => { 508 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 63 => 0x1, 66 => 0x7, 119 => 0x1d, 125 => 0x920a, 154 => 0x1d, 170 => 'FocalLength', 188 => 0x12, 236 => 0xa, 237 => 0xb, 241 => [0xc,0x3c], 349 => 0x1, 391 => 0x1d, 400 => 0x403, 425 => 0x1500, 444 => 0xe, 472 => 0x1278, 473 => 0x1134, 474 => 0x32c, 475 => 0x32c, 476 => 0x30a, 530 => 'FocalLength' },
	'focallength2' => { 464 => [0x23,0x25,0x29] },
	'focallength35mm' => { 345 => 'FocalLength35mm' },
	'focallengthin35mmformat' => { 125 => 0xa405, 418 => 'camera.focal_length.35mm_equivalent', 432 => 0xa01a, 530 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 444 => 0x10 },
	'focalplaneafpointarea' => { 477 => 0x2 },
	'focalplaneafpointlocation1' => { 477 => 0x6 },
	'focalplaneafpointlocation10' => { 477 => 0x2a },
	'focalplaneafpointlocation11' => { 477 => 0x2e },
	'focalplaneafpointlocation12' => { 477 => 0x32 },
	'focalplaneafpointlocation13' => { 477 => 0x36 },
	'focalplaneafpointlocation14' => { 477 => 0x3a },
	'focalplaneafpointlocation15' => { 477 => 0x3e },
	'focalplaneafpointlocation2' => { 477 => 0xa },
	'focalplaneafpointlocation3' => { 477 => 0xe },
	'focalplaneafpointlocation4' => { 477 => 0x12 },
	'focalplaneafpointlocation5' => { 477 => 0x16 },
	'focalplaneafpointlocation6' => { 477 => 0x1a },
	'focalplaneafpointlocation7' => { 477 => 0x1e },
	'focalplaneafpointlocation8' => { 477 => 0x22 },
	'focalplaneafpointlocation9' => { 477 => 0x26 },
	'focalplaneafpointsused' => { 477 => 0x1 },
	'focalplanediagonal' => { 332 => 0x103, 336 => 0x205 },
	'focalplaneresolutionunit' => { 125 => 0xa210, 530 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 125 => 0xa20e, 530 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 63 => 0x2 },
	'focalplanexunknown' => { 63 => 0x2 },
	'focalplaneyresolution' => { 125 => 0xa20f, 530 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 63 => 0x3 },
	'focalplaneyunknown' => { 63 => 0x3 },
	'focalpointx' => { 508 => 'FocalPointX' },
	'focalpointy' => { 508 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 63 => 0x0 },
	'focalunits' => { 37 => 0x19 },
	'focus' => { 292 => 0x8 },
	'focusarea' => { 188 => 0x31 },
	'focusareaselection' => { 321 => '15.2' },
	'focusbracket' => { 355 => 0xbd },
	'focusbracketstepsize' => { 331 => 0x308 },
	'focuscontinuous' => { 37 => 0x20 },
	'focusdisplayaiservoandmf' => { 90 => 0x515 },
	'focusdistance' => { 170 => 'FocusDistance', 188 => 0x13, 194 => 0x49bb, 236 => 0x9, 237 => 0xa, 241 => [0xb,0x4e], 334 => 0x305, 349 => 0x0, 353 => 0x304, 354 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 61 => 0x15, 82 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 241 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 61 => 0x14, 82 => 0x13 },
	'focusholdbutton' => { 191 => 0x44 },
	'focusinfoversion' => { 334 => 0x0 },
	'focusingscreen' => { 89 => 0x0, 90 => 0x80b, 95 => 0x0 },
	'focuslocation' => { 459 => 0x2027 },
	'focuslocation2' => { 459 => 0x204a },
	'focuslocked' => { 187 => 0x14 },
	'focusmode' => { 37 => 0x7, 118 => 0x3, 119 => [0x3003,0xd], 133 => 0x1021, 145 => 0x3f5, 147 => 0x38, 163 => 'FocusMode', 188 => 0x30, 190 => 0xe, 191 => 0xc, 243 => 0x7, 331 => 0x301, 336 => 0x100b, 355 => 0x7, 391 => 0xd, 398 => 0x3, 425 => 0x1006, 438 => [0xb,0x5], 444 => [0x15,0x1d], 445 => 0x4d, 446 => 0x4d, 459 => [0xb042,0xb04e,0x201b], 464 => 0x13, 485 => 0x16 },
	'focusmode2' => { 132 => '0.1', 371 => '3.1', 464 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 312 => '10.1', 442 => 0x14, 443 => 0x15, 445 => 0x10, 446 => 0xf, 447 => 0x6 },
	'focusmodeswitch' => { 191 => 0x58, 445 => 0x2e },
	'focuspeakingdisplay' => { 326 => 0x22f, 327 => 0x235, 328 => 0x235, 329 => 0x24d },
	'focuspeakinghighlightcolor' => { 326 => 0x53, 327 => 0x4b, 328 => 0x4b, 329 => 0x4b },
	'focuspeakinglevel' => { 326 => 0x51, 327 => 0x49, 328 => 0x49, 329 => 0x49 },
	'focuspixel' => { 133 => 0x1023 },
	'focuspointlock' => { 327 => 0x1d3, 328 => 0x1d3, 329 => 0x1eb },
	'focuspointpersistence' => { 326 => 0xf5, 327 => 0x105, 328 => 0x105, 329 => 0x11b },
	'focuspointwrap' => { 310 => '2.2', 311 => '2.2', 313 => '2.1', 314 => '2.1', 318 => '1.1', 319 => '2.2', 320 => '1.1', 323 => '2.2', 324 => '2.1', 325 => '2.5', 326 => 0x16, 327 => 0x16, 328 => 0x16, 329 => 0x16 },
	'focusposition' => { 1 => 0x2f, 236 => 0x8, 237 => 0x8, 391 => 0x10, 456 => 0x9bb },
	'focusposition2' => { 464 => [0x29,0x2b,0x2f], 485 => 0x2d, 488 => 0x20 },
	'focuspositionhorizontal' => { 200 => 0x2f },
	'focuspositionvertical' => { 200 => 0x31 },
	'focusprocess' => { 331 => 0x302 },
	'focusrange' => { 37 => 0x12, 336 => 0x100a },
	'focusrangeindex' => { 381 => '3.1' },
	'focusresult' => { 201 => 0x4a },
	'focusringrotation' => { 90 => 0x713 },
	'focussetting' => { 435 => 0x6 },
	'focusshiftautoreset' => { 252 => 0x6da, 253 => 0x748, 254 => 0x74c },
	'focusshiftexposurelock' => { 232 => 0x1b4, 247 => 0x224, 248 => 0xe8, 249 => 0x100, 250 => 0x100, 251 => 0xf4, 252 => 0x104, 253 => 0x104, 254 => 0x108 },
	'focusshiftinterval' => { 232 => 0x1b0, 247 => 0x220, 248 => 0xe4, 249 => 0xfc, 250 => 0xfc, 251 => 0xf0, 252 => 0x100, 253 => 0x100, 254 => 0x104 },
	'focusshiftnumbershots' => { 232 => 0x1a8, 247 => 0x218, 248 => 0xdc, 249 => 0xf4, 250 => 0xf4, 251 => 0xe8, 252 => 0xf8, 253 => 0xf8, 254 => 0xfc },
	'focusshiftshooting' => { 271 => 0x20 },
	'focusshiftstepwidth' => { 232 => 0x1ac, 247 => 0x21c, 248 => 0xe0, 249 => 0xf8, 250 => 0xf8, 251 => 0xec, 252 => 0xfc, 253 => 0xfc, 254 => 0x100 },
	'focusstatus' => { 444 => 0x19, 445 => 0x53, 446 => 0x53 },
	'focusstepcount' => { 334 => 0x301, 336 => 0x100e },
	'focusstepinfinity' => { 334 => 0x303, 336 => 0x103b },
	'focusstepnear' => { 334 => 0x304, 336 => 0x103c },
	'focusstepsfrominfinity' => { 241 => 0x58 },
	'focustrackinglockon' => { 310 => ['1.5','4.1'], 311 => '1.4', 318 => '0.4', 319 => '3.1', 320 => '0.4', 323 => '1.4' },
	'focuswarning' => { 133 => 0x1301 },
	'foldername' => { 188 => 0x27 },
	'foldernumber' => { 445 => 0x9a, 447 => [0x402,0x114,0x316] },
	'fontcomposite' => { 558 => [\'Fonts','FontsComposite'] },
	'fontface' => { 558 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 558 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 558 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 558 => [\'Fonts','FontsFontName'] },
	'fonts' => { 558 => 'Fonts' },
	'fonttype' => { 558 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 558 => [\'Fonts','FontsVersionString'] },
	'for' => { 407 => 'For' },
	'forcewrite' => { 126 => 'ForceWrite' },
	'format' => { 417 => "\xa9fmt", 507 => 'Format', 527 => 'format', 551 => 'Format' },
	'forwardlock' => { 548 => 'forwardlock' },
	'forwardmatrix1' => { 125 => 0xc714 },
	'forwardmatrix2' => { 125 => 0xc715 },
	'forwardmatrix3' => { 125 => 0xcd34 },
	'fossilspecimen' => { 124 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 124 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 72 => [0x2,0x4] },
	'frameheight' => { 133 => 0x3822 },
	'framenum' => { 402 => 0xd7 },
	'framenumber' => { 133 => 0x8003, 194 => 0x3c, 391 => 0x29 },
	'framerate' => { 72 => [0x1,0x6], 125 => 0xc764, 133 => 0x3820 },
	'framereadouttime' => { 418 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 133 => 0x3821 },
	'framing' => { 542 => 'framing' },
	'freebytes' => { 103 => 0x1 },
	'freememorycardimages' => { 189 => [0x37,0x54], 190 => [0x2d,0x4a], 191 => 0x32 },
	'fujiflashmode' => { 133 => 0x1010 },
	'fujimodel' => { 133 => 0x1447 },
	'fujimodel2' => { 133 => 0x1448 },
	'fullframerateplaybackintent' => { 411 => 'full-frame-rate-playback-intent' },
	'fullhdhighspeedrec' => { 133 => 0x3824 },
	'fullimagesize' => { 459 => 0xb02b },
	'fullpanoheightpixels' => { 510 => 'FullPanoHeightPixels', 511 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 510 => 'FullPanoWidthPixels', 511 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 425 => 0x100d },
	'fullsizeimage' => { 169 => 'data' },
	'fullsizeimagename' => { 169 => '1Name' },
	'fullsizeimagetype' => { 169 => '0Type' },
	'func1button' => { 313 => '14.1', 314 => '14.1', 324 => '14.1', 326 => 0x67, 327 => 0x63, 328 => 0x63, 329 => 0x63 },
	'func1buttonplaybackmode' => { 326 => 0x19f, 327 => 0x1a5, 328 => 0x1a5, 329 => 0x1bd },
	'func1buttonplusdials' => { 313 => '42.1', 314 => '42.1', 324 => '42.1' },
	'func2button' => { 313 => '80.1', 314 => '80.1', 324 => '80.1', 326 => 0x77, 327 => 0x73, 328 => 0x73, 329 => 0x73 },
	'func2buttonplaybackmode' => { 326 => 0x1a1, 327 => 0x1a7, 328 => 0x1a7, 329 => 0x1bf },
	'func2buttonplusdials' => { 313 => '81.1' },
	'func3button' => { 313 => '83.1', 328 => 0x119, 329 => 0x131 },
	'func3buttonplaybackmode' => { 328 => 0x1a9, 329 => 0x1c1 },
	'func4button' => { 328 => 0x175, 329 => 0x18d },
	'func4buttonplaybackmode' => { 328 => 0x1af, 329 => 0x1c7 },
	'funcbutton' => { 310 => ['14.1','15.1'], 311 => '14.1', 319 => '28.1', 320 => '13.1', 323 => '14.1', 325 => '14.1' },
	'funcbuttonplusdials' => { 310 => ['14.2','15.2'], 311 => '14.2', 319 => '31.1', 323 => '42.1' },
	'functionbutton' => { 317 => '13.1', 321 => '5.2' },
	'gainbase' => { 335 => 0x610 },
	'gaincontrol' => { 125 => 0xa407, 530 => 'GainControl' },
	'gainmapmax' => { 535 => 'GainMapMax' },
	'gainmapmin' => { 535 => 'GainMapMin' },
	'gamma' => { 125 => 0xa500, 145 => 0x8fe, 342 => 'gAMA', 360 => 0x11c, 531 => 'Gamma', 535 => 'Gamma' },
	'gammablackpoint' => { 111 => 0xc },
	'gammacolortone' => { 111 => 0x3 },
	'gammacompensatedvalue' => { 140 => 0x91 },
	'gammacontrast' => { 111 => 0x2 },
	'gammacurveoutputrange' => { 111 => 0xf },
	'gammahighlight' => { 111 => 0xa },
	'gammalinear' => { 109 => 0x20200 },
	'gammamidpoint' => { 111 => 0xe },
	'gammasaturation' => { 111 => 0x4 },
	'gammashadow' => { 111 => 0x9 },
	'gammasharpnessstrength' => { 111 => 0x8 },
	'gammaunsharpmaskfineness' => { 111 => 0x6 },
	'gammaunsharpmaskstrength' => { 111 => 0x5 },
	'gammaunsharpmaskthreshold' => { 111 => 0x7 },
	'gammawhitepoint' => { 111 => 0xd },
	'garminsettings' => { 417 => 'pmcc' },
	'garminsoftware' => { 417 => 'uuid' },
	'gdalmetadata' => { 125 => 0xa480 },
	'gdalnodata' => { 125 => 0xa481 },
	'geimagesize' => { 133 => 0x1304 },
	'gemake' => { 135 => 0x300 },
	'gemodel' => { 135 => 0x207 },
	'genre' => { 409 => ['gnre',"\xa9gen"], 411 => 'genre', 417 => ['gnre',"\xa9gen"], 538 => 'Genre', 543 => 'genre', 553 => 'genre' },
	'genrecvid' => { 538 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 538 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 538 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 538 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 409 => 'geID' },
	'geography' => { 544 => 'geography' },
	'geolocate' => { 126 => 'Geolocate' },
	'geologicalcontext' => { 124 => 'GeologicalContext' },
	'geologicalcontextbed' => { 124 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 124 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 124 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 124 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 124 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 126 => 'Geosync' },
	'geotag' => { 126 => 'Geotag' },
	'geotiffasciiparams' => { 125 => 0x87b1 },
	'geotiffdirectory' => { 125 => 0x87af },
	'geotiffdoubleparams' => { 125 => 0x87b0 },
	'geotime' => { 126 => 'Geotime' },
	'giftftppriority' => { 512 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 122 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 122 => 'GimbalReverse' },
	'gimbalrolldegree' => { 122 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 122 => 'GimbalYawDegree' },
	'globalaltitude' => { 405 => 0x419 },
	'globalangle' => { 405 => 0x40d },
	'good' => { 553 => 'good' },
	'googlehostheader' => { 409 => 'gshh' },
	'googlepingmessage' => { 409 => 'gspm' },
	'googlepingurl' => { 409 => 'gspu' },
	'googleplusuploadcode' => { 125 => 0x9009 },
	'googlesourcedata' => { 409 => 'gssd' },
	'googlestarttime' => { 409 => 'gsst' },
	'googletrackduration' => { 409 => 'gstd' },
	'goprotype' => { 417 => 'GoPr' },
	'gpsaltitude' => { 137 => 0x6, 167 => 'Altitude', 530 => 'GPSAltitude' },
	'gpsaltituderef' => { 137 => 0x5, 530 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 137 => 0x1c, 530 => 'GPSAreaInformation' },
	'gpscoordinates' => { 409 => "\xa9xyz", 411 => 'location.ISO6709', 417 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 137 => 0x1d },
	'gpsdatetime' => { 167 => 'DateTime', 530 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 137 => 0x18, 167 => 'Bearing', 530 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 137 => 0x17, 530 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 137 => 0x1a, 167 => 'Distance', 530 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 137 => 0x19, 530 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 137 => 0x14, 530 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 137 => 0x13 },
	'gpsdestlongitude' => { 137 => 0x16, 530 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 137 => 0x15 },
	'gpsdifferential' => { 137 => 0x1e, 167 => 'Differential', 530 => 'GPSDifferential' },
	'gpsdop' => { 137 => 0xb, 530 => 'GPSDOP' },
	'gpshpositioningerror' => { 137 => 0x1f, 530 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 137 => 0x11, 530 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 137 => 0x10, 530 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 120 => 'GPS-GPSLatitude', 122 => 'GpsLatitude', 137 => 0x2, 167 => 'Latitude', 530 => 'GPSLatitude' },
	'gpslatituderef' => { 137 => 0x1 },
	'gpslongitude' => { 120 => 'GPS-GPSLongitude', 122 => 'GpsLongitude', 137 => 0x4, 167 => 'Longitude', 530 => 'GPSLongitude' },
	'gpslongituderef' => { 137 => 0x3 },
	'gpslongtitude' => { 122 => 'GpsLongtitude' },
	'gpsmapdatum' => { 137 => 0x12, 167 => 'Datum', 530 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 137 => 0xa, 167 => 'MeasureMode', 530 => 'GPSMeasureMode' },
	'gpsposition' => { 120 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 137 => 0x1b, 530 => 'GPSProcessingMethod' },
	'gpssatellites' => { 137 => 0x8, 167 => 'Satellites', 530 => 'GPSSatellites' },
	'gpsspeed' => { 137 => 0xd, 167 => 'Speed', 530 => 'GPSSpeed' },
	'gpsspeedref' => { 137 => 0xc, 530 => 'GPSSpeedRef' },
	'gpsstatus' => { 137 => 0x9, 530 => 'GPSStatus' },
	'gpsstring' => { 145 => 0x402 },
	'gpstimestamp' => { 137 => 0x7 },
	'gpstrack' => { 137 => 0xf, 167 => 'Heading', 530 => 'GPSTrack' },
	'gpstrackref' => { 137 => 0xe, 530 => 'GPSTrackRef' },
	'gpsversionid' => { 137 => 0x0, 530 => 'GPSVersionID' },
	'gradation' => { 331 => 0x50f },
	'gradientbasedcorractive' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 524 => 'GradientBasedCorrections', 526 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 524 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 526 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 524 => 'GrainAmount', 526 => 'GrainAmount' },
	'graineffectroughness' => { 133 => 0x1047 },
	'graineffectsize' => { 133 => 0x104c },
	'grainfrequency' => { 524 => 'GrainFrequency', 526 => 'GrainFrequency' },
	'grainseed' => { 524 => 'GrainSeed', 526 => 'GrainSeed' },
	'grainsize' => { 524 => 'GrainSize', 526 => 'GrainSize' },
	'graymixeraqua' => { 524 => 'GrayMixerAqua', 526 => 'GrayMixerAqua' },
	'graymixerblue' => { 524 => 'GrayMixerBlue', 526 => 'GrayMixerBlue' },
	'graymixergreen' => { 524 => 'GrayMixerGreen', 526 => 'GrayMixerGreen' },
	'graymixermagenta' => { 524 => 'GrayMixerMagenta', 526 => 'GrayMixerMagenta' },
	'graymixerorange' => { 524 => 'GrayMixerOrange', 526 => 'GrayMixerOrange' },
	'graymixerpurple' => { 524 => 'GrayMixerPurple', 526 => 'GrayMixerPurple' },
	'graymixerred' => { 524 => 'GrayMixerRed', 526 => 'GrayMixerRed' },
	'graymixeryellow' => { 524 => 'GrayMixerYellow', 526 => 'GrayMixerYellow' },
	'graypoint' => { 496 => 0x8021 },
	'grayresponseunit' => { 125 => 0x122 },
	'greencurvelimits' => { 114 => 0x1c4 },
	'greencurvepoints' => { 113 => 0x53, 114 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 109 => 0x20913 },
	'greenhue' => { 524 => 'GreenHue', 526 => 'GreenHue' },
	'greensaturation' => { 524 => 'GreenSaturation', 526 => 'GreenSaturation' },
	'griddisplay' => { 310 => '13.3', 311 => '4.3', 313 => '4.2', 314 => '4.2', 315 => '2.2', 319 => '10.5', 320 => '3.4', 321 => '6.1', 323 => '4.4', 324 => '4.2', 325 => '4.2' },
	'gripbatteryadload' => { 369 => 0x5 },
	'gripbatteryadnoload' => { 369 => 0x4 },
	'gripbatterypercent' => { 369 => 0x11 },
	'gripbatterystate' => { 369 => ['1.2',0x10] },
	'gripbatteryvoltage' => { 369 => 0x12 },
	'group' => { 524 => 'Group', 526 => 'Group' },
	'groupareaafillumination' => { 311 => '46.4', 314 => '47.4', 323 => '47.4' },
	'grouping' => { 409 => ['grup',"\xa9grp"], 417 => "\xa9grp" },
	'guid' => { 409 => 'GUID' },
	'h2resetblackpixels' => { 145 => 0x18a6 },
	'h3resetblackcolumns' => { 145 => 0x18ce },
	'h3resetblackpixels' => { 145 => 0x18b0 },
	'halftonehints' => { 125 => 0x141 },
	'hardlink' => { 126 => 'HardLink' },
	'hasalternative' => { 543 => 'hasAlternative' },
	'hascorrection' => { 543 => 'hasCorrection' },
	'hascorrectiona-lang' => { 543 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 543 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 543 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 524 => 'HasCrop', 526 => 'HasCrop' },
	'hasextendedxmp' => { 555 => 'HasExtendedXMP' },
	'hassettings' => { 524 => 'HasSettings', 526 => 'HasSettings' },
	'hastranslation' => { 543 => 'hasTranslation' },
	'hasvisibleoverprint' => { 558 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 558 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 248 => 0x35a },
	'hdmioutputresolution' => { 249 => 0x710, 250 => 0x720, 251 => 0x610, 252 => 0x640, 253 => 0x6a8, 254 => 0x6ac },
	'hdmiviewassist' => { 328 => 0x20f, 329 => 0x227 },
	'hdr' => { 64 => 0x1, 228 => 0x4, 229 => 0x4, 247 => 0x354, 249 => 0x23a, 250 => 0x23a, 253 => 0x23a, 254 => 0x23e, 355 => 0x9e, 391 => 0x85, 459 => 0x200a },
	'hdrcapacitymax' => { 535 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 535 => 'HDRCapacityMin' },
	'hdreditmode' => { 524 => 'HDREditMode', 526 => 'HDREditMode' },
	'hdreffect' => { 64 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrgainmapversion' => { 513 => 'HDRGainMapVersion' },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 228 => 0x5, 229 => 0x5, 247 => 0x360, 249 => 0x246, 250 => 0x246, 253 => 0x246, 254 => 0x24a, 447 => 0x2e, 464 => 0x17 },
	'hdrlevel2' => { 228 => 0x7 },
	'hdrplusmakernote' => { 504 => 'HdrPlusMakernote' },
	'hdrpmakernote' => { 504 => 'hdrp_makernote' },
	'hdrsetting' => { 447 => 0x2d, 464 => 0x16, 468 => 0x1148, 469 => 0x1148, 470 => 0x1124, 471 => 0x11a0, 472 => 0x117c, 473 => 0x1034, 474 => 0x22c, 475 => 0x22c, 476 => 0x21f },
	'hdrsmoothing' => { 228 => 0x6 },
	'hdvideo' => { 409 => 'hdvd' },
	'headline' => { 138 => 0x69, 538 => 'Headline', 541 => 'Headline' },
	'hiddendatalength' => { 457 => 0x1 },
	'hiddendataoffset' => { 457 => 0x0 },
	'hierarchicalkeywords' => { 178 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 178 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 178 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 178 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 178 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 515 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 124 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 247 => 0x16c, 249 => 0x48, 250 => 0x48, 252 => 0x48, 253 => 0x48, 254 => 0x48 },
	'highfrequencyflickerreduction' => { 247 => 0x386, 249 => 0x27c, 250 => 0x27c, 252 => 0x27c, 253 => 0x27c, 254 => 0x280 },
	'highisomultiplierblue' => { 360 => 0x1a },
	'highisomultipliergreen' => { 360 => 0x19 },
	'highisomultiplierred' => { 360 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 67 => 0x5, 90 => 0x202, 243 => 0xb1, 391 => 0x71, 445 => 0x2c, 446 => 0x26, 447 => 0x26, 459 => 0x2009, 464 => 0x12, 491 => 0x42 },
	'highisonoisereduction2' => { 459 => 0xb050 },
	'highlight' => { 435 => 0xf },
	'highlight2012' => { 524 => 'Highlight2012', 526 => 'Highlight2012' },
	'highlightadj' => { 109 => 0x2030c },
	'highlightcolordistortreduct' => { 496 => 0x8026 },
	'highlightlinearitylimit' => { 432 => 0xa025 },
	'highlightprotection' => { 302 => 0x6 },
	'highlightrecovery' => { 524 => 'HighlightRecovery', 526 => 'HighlightRecovery' },
	'highlights' => { 459 => 0x2033, 517 => 'Highlights' },
	'highlights2012' => { 524 => 'Highlights2012', 526 => 'Highlights2012' },
	'highlightsadj' => { 496 => 0x9019 },
	'highlightshadow' => { 355 => 0xad },
	'highlighttone' => { 133 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 67 => 0x3, 90 => 0x203 },
	'highlightwarning' => { 355 => 0x8002 },
	'highlowkeyadj' => { 391 => 0x6c },
	'highspeedsync' => { 191 => 0x5, 326 => 0x59, 327 => 0x55, 328 => 0x55, 329 => 0x55, 445 => 0x2, 446 => 0x2 },
	'hintversion' => { 417 => 'hinv' },
	'histogramxml' => { 303 => 0x83a1a25 },
	'history' => { 541 => 'History', 554 => 'History' },
	'historyaction' => { 554 => [\'History','HistoryAction'] },
	'historychanged' => { 554 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 554 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 554 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 554 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 554 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 145 => 0xc88 },
	'holefilldeltathreshold' => { 145 => 0xc7e },
	'hometowncity' => { 119 => 0x3006, 391 => 0x23, 397 => 0x2 },
	'hometowncitycode' => { 398 => 0x1000 },
	'hometowndst' => { 391 => 0x25, 397 => '0.2' },
	'hostcomputer' => { 125 => 0x13c },
	'hostsoftwarerendering' => { 145 => 0xce7 },
	'hue' => { 196 => 0x3b, 262 => 0x3d, 263 => 0x45, 391 => 0x67 },
	'hueadj' => { 306 => 0x2f, 496 => 0x8019 },
	'hueadjust' => { 425 => 0x1016 },
	'hueadjustment' => { 189 => 0x4a, 190 => 0x40, 243 => 0x92, 261 => 0x36 },
	'hueadjustmentaqua' => { 524 => 'HueAdjustmentAqua', 526 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 524 => 'HueAdjustmentBlue', 526 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 524 => 'HueAdjustmentGreen', 526 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 524 => 'HueAdjustmentMagenta', 526 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 524 => 'HueAdjustmentOrange', 526 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 524 => 'HueAdjustmentPurple', 526 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 524 => 'HueAdjustmentRed', 526 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 524 => 'HueAdjustmentYellow', 526 => 'HueAdjustmentYellow' },
	'huesetting' => { 339 => 0x1011 },
	'humanobservation' => { 124 => 'HumanObservation' },
	'humanobservationday' => { 124 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 124 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 124 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 124 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 124 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 124 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 124 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 124 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 124 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 124 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 124 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 124 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 124 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 124 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 124 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 124 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 124 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 124 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 124 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 124 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 125 => 0x9401, 531 => 'Humidity' },
	'icc_profile' => { 126 => 'ICC_Profile', 136 => 'ICCRGBG1/012' },
	'iccprofilename' => { 541 => 'ICCProfile' },
	'iconuri' => { 417 => 'icnu' },
	'idccreativestyle' => { 496 => 0x8000 },
	'idcpreviewlength' => { 496 => 0x202 },
	'idcpreviewstart' => { 496 => 0x201 },
	'identification' => { 124 => 'Identification' },
	'identificationid' => { 124 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 124 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 124 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 124 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 124 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 124 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 124 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 527 => 'identifier', 551 => 'Identifier' },
	'ifcameramodel' => { 145 => 0x9c8 },
	'illuminantdata1' => { 125 => 0xcd35 },
	'illuminantdata2' => { 125 => 0xcd36 },
	'illuminantdata3' => { 125 => 0xcd37 },
	'illumination' => { 321 => '0.5', 420 => 0x48 },
	'imageabsolutex' => { 145 => 0x3fe },
	'imageabsolutey' => { 145 => 0x3ff },
	'imageadjustment' => { 243 => 0x80, 292 => 0x5 },
	'imagealterationconstraints' => { 341 => 'ImageAlterationConstraints' },
	'imagearea' => { 233 => 0x2b, 270 => 0x2b, 278 => 0x10, 281 => 0x10 },
	'imageareaoffset' => { 391 => 0x38 },
	'imageauthentication' => { 243 => 0x20 },
	'imageboundary' => { 243 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 133 => 0x1438, 243 => 0xa5, 462 => 0x11b },
	'imagecreator' => { 341 => 'ImageCreator' },
	'imagecreatorid' => { 341 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 341 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 341 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 145 => 0x41f },
	'imagecropy' => { 145 => 0x420 },
	'imagedata' => { 509 => 'Data' },
	'imagedatasize' => { 243 => 0xa2 },
	'imagedescription' => { 125 => 0x10e, 549 => 'ImageDescription' },
	'imageduplicationconstraints' => { 341 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 303 => 0xfe443a45 },
	'imageeditcount' => { 391 => 0x41 },
	'imageediting' => { 391 => 0x32 },
	'imageeditingsoftware' => { 125 => 0xa43b, 531 => 'ImageEditingSoftware' },
	'imageeditor' => { 125 => 0xa438, 531 => 'ImageEditor' },
	'imageeffects' => { 425 => 0x1010 },
	'imagefileconstraints' => { 341 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 341 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 341 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 133 => 0x1436 },
	'imageheight' => { 125 => 0x101, 195 => 0xc, 400 => 0x10d, 507 => 'ImageHeight', 549 => 'ImageLength' },
	'imagehistory' => { 125 => 0x9213, 529 => 'ImageHistory' },
	'imageidnumber' => { 350 => 0x340 },
	'imagemimetype' => { 509 => 'Mime' },
	'imagenumber' => { 125 => 0x9211, 163 => 'ImageNumber', 189 => 0xae, 190 => 0x5e, 400 => 0x113, 445 => 0x9b, 447 => [0x400,'276.1',0x314], 521 => 'ImageNumber' },
	'imagenumber2' => { 190 => 0x62 },
	'imageoptimization' => { 243 => 0xa9 },
	'imageorientation' => { 138 => 0x83 },
	'imageprocessing' => { 243 => 0x1a },
	'imageprocessingfiledatecreated' => { 145 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 145 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 335 => 0x0 },
	'imagequality' => { 163 => 'ImageQuality', 280 => '723.2', 281 => '732.2', 289 => '708.1', 355 => 0x1 },
	'imagequality2' => { 331 => 0x603 },
	'imagerank' => { 512 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 145 => 0x600 },
	'imagerboardversion' => { 145 => 0x439 },
	'imagercols' => { 145 => 0x17d4 },
	'imageref' => { 536 => 'ImageRef' },
	'imageregion' => { 538 => 'ImageRegion' },
	'imageregionboundary' => { 538 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 538 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 538 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 538 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 538 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 538 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 538 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 538 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 538 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 538 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 538 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 538 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 538 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 538 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 538 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 538 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 538 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 538 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 538 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 145 => 0x944 },
	'imageresolutionjpg' => { 145 => 0x945 },
	'imagereview' => { 312 => '0.4', 321 => '0.4' },
	'imagereviewmonitorofftime' => { 311 => '21.1', 313 => '21.1', 314 => '21.1', 318 => '20.1', 323 => '21.1', 324 => '21.1', 326 => 0x3b, 327 => 0x39, 328 => 0x39, 329 => 0x39 },
	'imagereviewtime' => { 310 => '25.1', 312 => '2.1', 315 => '19.1', 316 => '20.1', 317 => '20.1', 319 => '9.2', 320 => '20.1', 325 => '21.2' },
	'imagerfiledatecreated' => { 145 => 0x9c5 },
	'imagerfileproductionlevel' => { 145 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 145 => 0x9c7 },
	'imagerotated' => { 158 => 0x2a },
	'imagerpowerondelaymsec' => { 145 => 0x5fd },
	'imagerrows' => { 145 => 0x17de },
	'imagesegmentlines' => { 145 => 0x184d },
	'imagesegmentstartline' => { 145 => 0x184c },
	'imagesequenceinfo' => { 125 => 0xcd44 },
	'imagesize' => { 169 => 'ImageSize' },
	'imagesizeraw' => { 243 => 0x3e },
	'imagesizerestriction' => { 546 => 'imageSizeRestriction' },
	'imagesourcedata' => { 125 => 0x935c },
	'imagespace' => { 145 => 0x909 },
	'imagestabilization' => { 37 => 0x22, 119 => 0x3020, 133 => 0x1422, 163 => 'ImageStabilization', 189 => 0xbd, 190 => 0x71, 191 => 0x57, 192 => 0x0, 193 => [0x18,0x107,0x113], 194 => 0x49c2, 243 => 0xac, 331 => 0x604, 334 => 0x1600, 355 => 0x1a, 450 => 0x12, 451 => 0x11, 459 => 0xb026 },
	'imagestabilization2' => { 449 => 0xa },
	'imagestabilizationsetting' => { 194 => 0x14, 445 => 0x3d, 446 => 0x3d, 456 => 0x14 },
	'imagestats' => { 125 => 0xcd46 },
	'imagestyle' => { 445 => 0x2d, 446 => 0x27 },
	'imagesupplier' => { 341 => 'ImageSupplier' },
	'imagesupplierid' => { 341 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 341 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 341 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 127 => 0x1 },
	'imagetemperaturemin' => { 127 => 0x2 },
	'imagetitle' => { 125 => 0xa436, 531 => 'ImageTitle' },
	'imagetone' => { 391 => 0x4f },
	'imagetype' => { 138 => 0x82, 341 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 69 => 0x28, 125 => 0xa420, 529 => 'ImageUniqueID', 530 => 'ImageUniqueID', 531 => 'ImageUniqueID' },
	'imagewidth' => { 125 => 0x100, 195 => 0xe, 400 => 0x10c, 507 => 'ImageWidth', 549 => 'ImageWidth' },
	'inclinationangle' => { 496 => 0x900f },
	'inclinationcorrection' => { 496 => 0x900e },
	'incrementaltemperature' => { 524 => 'IncrementalTemperature', 526 => 'IncrementalTemperature' },
	'incrementaltint' => { 524 => 'IncrementalTint', 526 => 'IncrementalTint' },
	'industry' => { 543 => 'industry', 544 => 'industry' },
	'infobuttonwhenshooting' => { 90 => 0x409 },
	'information' => { 411 => 'information', 417 => "\xa9inf" },
	'infourl' => { 417 => 'infu' },
	'infraredilluminator' => { 419 => 0x28 },
	'ingredientexclusion' => { 545 => 'ingredientExclusion' },
	'ingredients' => { 554 => 'Ingredients' },
	'ingredientsalternatepaths' => { 554 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 554 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 554 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 554 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 554 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 554 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 554 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 554 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 554 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 554 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 554 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 554 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 554 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 554 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 554 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 554 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 554 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 554 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 554 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 554 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 554 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 554 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 554 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 90 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 510 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 510 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 186 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 510 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 510 => 'InitialViewHeadingDegrees', 511 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 510 => 'InitialViewPitchDegrees', 511 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 510 => 'InitialViewRollDegrees', 511 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 310 => '4.4' },
	'initialzoomsetting' => { 310 => '9.3', 319 => '27.3' },
	'inkset' => { 125 => 0x14c },
	'inputprofile' => { 145 => 0x1389 },
	'instanceid' => { 554 => 'InstanceID' },
	'instantplaybacksetup' => { 191 => 0x3e },
	'instantplaybacktime' => { 191 => 0x3d },
	'instructions' => { 541 => 'Instructions' },
	'instrument' => { 553 => 'instrument' },
	'integrationtime' => { 145 => 0x423 },
	'intellectualgenre' => { 537 => 'IntellectualGenre' },
	'intelligentauto' => { 459 => 0xb052, 487 => 0xd, 488 => 0xe, 489 => 0xd },
	'intelligentcontrast' => { 56 => 0x4 },
	'intelligentd-range' => { 355 => 0x79 },
	'intelligentexposure' => { 355 => 0x5d },
	'intelligentresolution' => { 355 => 0x70 },
	'interchangecolorspace' => { 140 => 0x40 },
	'intergraphmatrix' => { 125 => 0x8480 },
	'internalflash' => { 188 => 0x2b, 310 => '23.1', 312 => '8.1', 315 => '22.1', 317 => '23.1', 321 => '8.1', 325 => '24.1', 334 => 0x1208 },
	'internalflashae1' => { 336 => 0x1021 },
	'internalflashae1_0' => { 336 => 0x101d },
	'internalflashae2' => { 336 => 0x1022 },
	'internalflashae2_0' => { 336 => 0x101e },
	'internalflashmode' => { 378 => 0x1 },
	'internalflashstrength' => { 378 => 0x3 },
	'internalflashtable' => { 336 => 0x1024 },
	'internallensserialnumber' => { 432 => 0xa005 },
	'internalndfilter' => { 355 => 0x9d },
	'internalserialnumber' => { 69 => 0x96, 81 => 0x9, 133 => 0x10, 194 => 0x49dc, 330 => 0x18, 332 => 0x102, 352 => 0x500, 355 => 0x25, 370 => 0x4, 425 => 0x5, 478 => [0x7c,0xf0], 479 => 0x88, 480 => [0x88,0x8a], 481 => 0x38 },
	'interopindex' => { 125 => 0x1, 531 => 'InteroperabilityIndex' },
	'interopversion' => { 125 => 0x2 },
	'interval' => { 268 => 0x20 },
	'intervaldurationhours' => { 247 => 0x1dc, 248 => 0xa0, 249 => 0xb8, 250 => 0xb8 },
	'intervaldurationminutes' => { 247 => 0x1e0, 248 => 0xa4, 249 => 0xbc, 250 => 0xbc },
	'intervaldurationseconds' => { 247 => 0x1e4, 248 => 0xa8, 249 => 0xc0, 250 => 0xc0 },
	'intervalexposuresmoothing' => { 232 => 0x184, 247 => 0x1f4, 248 => 0xb8, 249 => 0xd0, 250 => 0xd0 },
	'intervalframe' => { 268 => 0x24 },
	'intervallength' => { 188 => 0x10 },
	'intervalmode' => { 188 => 0x26 },
	'intervalnumber' => { 188 => 0x11 },
	'intervalpriority' => { 232 => 0x186, 247 => 0x1f6, 248 => 0xba, 249 => 0xd2, 250 => 0xd2 },
	'intervals' => { 232 => 0x17c, 247 => 0x1ec, 248 => 0xb0, 249 => 0xc8, 250 => 0xc8, 251 => 0xbc, 252 => 0xcc, 253 => 0xcc, 254 => 0xd0 },
	'intervalshooting' => { 233 => 0x24, 270 => 0x24, 271 => 0x28, 391 => 0x92 },
	'introtime' => { 553 => 'introTime' },
	'introtimescale' => { 553 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 553 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 145 => 0xdae },
	'ipfcameramodel' => { 145 => 0xe4d },
	'iptc' => { 126 => 'IPTC' },
	'iptc-naa' => { 125 => 0x83bb, 360 => 0x83bb },
	'iptcbitspersample' => { 140 => 0x56 },
	'iptcdigest' => { 405 => 0x425 },
	'iptcimageheight' => { 140 => 0x1e },
	'iptcimagerotation' => { 140 => 0x66 },
	'iptcimagewidth' => { 140 => 0x14 },
	'iptclastedited' => { 538 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 140 => 0xa },
	'iptcpixelheight' => { 140 => 0x32 },
	'iptcpixelwidth' => { 140 => 0x28 },
	'isalternativeof' => { 543 => 'isAlternativeOf' },
	'isbn' => { 543 => 'isbn' },
	'iscorrectionof' => { 543 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 115 => 0x3 },
	'ismergedhdr' => { 521 => 'IsMergedHDR' },
	'ismergedpanorama' => { 521 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 31 => 0x0, 32 => 0x1, 118 => 0x14, 119 => [0x3014,0x14], 125 => 0x8827, 144 => 0xfd06, 145 => 0x1784, 147 => 0x60, 149 => [0xfa2e,0xfa46], 150 => [0x27,0x28], 151 => 0xf105, 154 => 0x14, 156 => 0x4e, 158 => 0x1e, 159 => 0x1a, 161 => 0x34, 163 => 'ISO', 188 => 0x8, 194 => 0x49ba, 231 => 0x0, 243 => 0x2, 355 => 0xd1, 360 => [0x17,0x37], 391 => [0x8b,0x14], 398 => 0x14, 400 => 0x105, 432 => 0xa014, 435 => 0x86, 456 => 0x6f, 464 => [0x1f,0x21,0x25], 530 => 'ISOSpeedRatings' },
	'iso2' => { 231 => 0x6, 275 => 0x265, 276 => 0x25c, 277 => 0x265, 278 => 0x221, 279 => 0x25d, 280 => 0x256, 281 => 0x25d, 284 => 0x2b5, 287 => 0x265, 291 => 0x2b5 },
	'isoauto' => { 371 => '14.4' },
	'isoautoflashlimit' => { 249 => 0x156, 250 => 0x156, 251 => 0x146, 252 => 0x15a, 253 => 0x15a, 254 => 0x15e },
	'isoautohilimit' => { 230 => 0x5, 247 => 0x28a, 249 => 0x154, 250 => 0x154, 251 => 0x144, 252 => 0x158, 253 => 0x158, 254 => 0x15c, 273 => 0x5, 283 => 0x18eb },
	'isoautomax' => { 458 => 0x4 },
	'isoautomin' => { 458 => 0x2 },
	'isoautominspeed' => { 391 => 0x7a },
	'isoautoshuttertime' => { 230 => 0x4, 249 => 0x15e, 250 => 0x15e, 251 => 0x14e, 252 => 0x162, 253 => 0x162, 254 => 0x166, 273 => 0x4, 283 => 0x18ea },
	'isobutton' => { 253 => 0x796, 254 => 0x79a },
	'isocalibrationgain' => { 145 => 0x89f },
	'isodisplay' => { 313 => '4.1', 314 => '4.1', 315 => '2.3', 316 => '3.3', 317 => '3.3', 320 => '3.3', 323 => '4.3', 324 => '4.1', 325 => '4.3' },
	'isoexpansion' => { 90 => 0x103, 91 => 0x7, 92 => 0x8, 95 => 0x8, 231 => 0x4 },
	'isoexpansion2' => { 231 => 0xa },
	'isofloor' => { 371 => 0x6 },
	'isoselected' => { 354 => 0x359 },
	'isoselection' => { 243 => 0xf },
	'isosensitivitystep' => { 318 => '6.2', 320 => '6.2' },
	'isosetting' => { 147 => 0x5e, 159 => 0x14, 163 => 'ISOSetting', 188 => 0x24, 189 => 0x26, 190 => 0x1c, 191 => 0x13, 196 => 0x6, 243 => 0x13, 371 => '17.3', 424 => 0x27, 445 => 0x16, 446 => 0x14, 447 => 0x2, 456 => 0x6d, 458 => 0x0 },
	'isospeed' => { 125 => 0x8833, 531 => 'ISOSpeed' },
	'isospeedexpansion' => { 89 => 0x3 },
	'isospeedincrements' => { 90 => 0x102 },
	'isospeedlatitudeyyy' => { 125 => 0x8834, 531 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 125 => 0x8835, 531 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 90 => 0x103 },
	'isostepsize' => { 310 => '6.1', 311 => '7.2', 313 => '7.2', 314 => '7.2', 319 => '4.1', 323 => '7.2', 324 => '7.2', 326 => 0x14d, 327 => 0x15d, 328 => 0x15d, 329 => 0x175 },
	'isovalue' => { 336 => 0x1001 },
	'isrc' => { 409 => 'xid ' },
	'isrccode' => { 417 => "\xa9isr" },
	'issn' => { 543 => 'issn' },
	'issueidentifier' => { 543 => 'issueIdentifier' },
	'issuename' => { 543 => 'issueName' },
	'issueteaser' => { 543 => 'issueTeaser' },
	'issuetype' => { 543 => 'issueType' },
	'istranslationof' => { 543 => 'isTranslationOf' },
	'itemsubtype' => { 185 => 'ItemSubType' },
	'itunesu' => { 409 => 'itnu' },
	'jobid' => { 138 => 0xb8 },
	'jobname' => { 532 => 'JobName' },
	'jobref' => { 552 => 'JobRef' },
	'jobrefid' => { 552 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 552 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 552 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 532 => 'JobStatus' },
	'jpeg-heifswitch' => { 459 => 0x2039 },
	'jpeghandling' => { 524 => 'JPEGHandling', 526 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 355 => 0x43, 357 => 0x3034, 459 => 0xb047 },
	'jpegsize' => { 357 => 0x303a },
	'jpgcompression' => { 234 => 0x24, 243 => 0x44, 278 => '671.1' },
	'jpgfromraw' => { 103 => 0x2007, 120 => 'Exif-JpgFromRaw', 360 => 0x2e },
	'jpgfromrawlength' => { 125 => [0x117,0x202] },
	'jpgfromrawstart' => { 125 => [0x111,0x201] },
	'jpgrecordedpixels' => { 371 => '14.1' },
	'jurisdiction' => { 522 => 'jurisdiction' },
	'jxldecodespeed' => { 125 => 0xcd4b },
	'jxldistance' => { 125 => 0xcd49 },
	'jxleffort' => { 125 => 0xcd4a },
	'keepexposure' => { 327 => 0x237, 328 => 0x237, 329 => 0x24f },
	'kelvinwb_01' => { 379 => 0x5 },
	'kelvinwb_02' => { 379 => 0x9 },
	'kelvinwb_03' => { 379 => 0xd },
	'kelvinwb_04' => { 379 => 0x11 },
	'kelvinwb_05' => { 379 => 0x15 },
	'kelvinwb_06' => { 379 => 0x19 },
	'kelvinwb_07' => { 379 => 0x1d },
	'kelvinwb_08' => { 379 => 0x21 },
	'kelvinwb_09' => { 379 => 0x25 },
	'kelvinwb_10' => { 379 => 0x29 },
	'kelvinwb_11' => { 379 => 0x2d },
	'kelvinwb_12' => { 379 => 0x31 },
	'kelvinwb_13' => { 379 => 0x35 },
	'kelvinwb_14' => { 379 => 0x39 },
	'kelvinwb_15' => { 379 => 0x3d },
	'kelvinwb_16' => { 379 => 0x41 },
	'kelvinwb_daylight' => { 379 => 0x1 },
	'kerneldenominators' => { 145 => 0x933 },
	'key' => { 553 => 'key' },
	'keystonecompensation' => { 335 => 0x1900 },
	'keystonedirection' => { 335 => 0x1901 },
	'keystonevalue' => { 335 => 0x1906 },
	'keyword' => { 409 => 'keyw', 543 => 'keyword' },
	'keywordinfo' => { 178 => 'Keywords' },
	'keywords' => { 138 => 0x19, 164 => 'Keywords', 340 => 'Keywords', 407 => 'Keywords', 411 => 'keywords', 518 => 'keywords', 540 => 'Keywords', 551 => 'Keywords' },
	'killdate' => { 543 => 'killDate' },
	'killdatea-platform' => { 543 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 543 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 144 => 0xf908, 147 => 0xe, 149 => [0xfa1e,0xfa52], 155 => 0x70 },
	'kodakimagewidth' => { 144 => 0xf907, 147 => 0xc, 149 => [0xfa1d,0xfa51], 155 => 0x6c },
	'kodakinfotype' => { 144 => 0xfa00 },
	'kodaklook' => { 145 => 0xe4c },
	'kodaklookprofile' => { 145 => 0x138a },
	'kodakmaker' => { 155 => 0x8 },
	'kodakmodel' => { 147 => 0x0, 155 => 0x28 },
	'kodaktag' => { 145 => 0x3ea },
	'kodakversion' => { 145 => 0x0 },
	'label' => { 344 => 'Label', 551 => 'Label' },
	'labelname1' => { 536 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 536 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 355 => 0x6f },
	'landscapeoutputhighlightpoint' => { 115 => 0x26 },
	'landscapeoutputshadowpoint' => { 115 => 0x27 },
	'landscaperawcolortone' => { 115 => 0x1f },
	'landscaperawcontrast' => { 115 => 0x21 },
	'landscaperawhighlight' => { 115 => 0x77 },
	'landscaperawhighlightpoint' => { 115 => 0x24 },
	'landscaperawlinear' => { 115 => 0x22 },
	'landscaperawsaturation' => { 115 => 0x20 },
	'landscaperawshadow' => { 115 => 0x80 },
	'landscaperawshadowpoint' => { 115 => 0x25 },
	'landscaperawsharpness' => { 115 => 0x23 },
	'landscapeunsharpmaskfineness' => { 115 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 115 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 115 => 0xa2 },
	'language' => { 247 => 0x8fc, 249 => 0x6a2, 250 => 0x6a2, 251 => 0x592, 252 => 0x5c2, 253 => 0x5da, 254 => 0x5de, 527 => 'language' },
	'languageidentifier' => { 138 => 0x87 },
	'largestvalidinteriorrectheight' => { 510 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 510 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 510 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 510 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 188 => 0x1b },
	'lastkeywordiptc' => { 185 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 185 => 'LastKeywordXMP' },
	'lastphotodate' => { 510 => 'LastPhotoDate' },
	'lasturl' => { 554 => 'LastURL' },
	'lateralchromaticaberration' => { 459 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 521 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 124 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 124 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 124 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 124 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 124 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 122 => 'Latitude' },
	'lc1' => { 381 => 0x2 },
	'lc10' => { 381 => 0xb },
	'lc11' => { 381 => 0xc },
	'lc12' => { 381 => 0xd },
	'lc14' => { 381 => 0xf },
	'lc15' => { 381 => 0x10 },
	'lc3' => { 381 => 0x4 },
	'lc4' => { 381 => 0x5 },
	'lc5' => { 381 => 0x6 },
	'lc6' => { 381 => 0x7 },
	'lc7' => { 381 => 0x8 },
	'lc8' => { 381 => 0x9 },
	'lcddisplayatpoweron' => { 90 => 0x811, 94 => 0xa },
	'lcddisplayreturntoshoot' => { 95 => 0x12 },
	'lcdillumination' => { 310 => '17.5', 311 => '5.2', 313 => '5.1', 314 => '5.1', 319 => '10.3', 320 => '4.2', 323 => '5.2', 324 => '5.1', 325 => '5.4', 326 => 0xf1, 327 => 0x101, 328 => 0x101, 329 => 0x117 },
	'lcdilluminationduringbulb' => { 90 => 0x408 },
	'lcdmatrix' => { 145 => 0xe74 },
	'lcdmatrixchickfix' => { 145 => 0xe75 },
	'lcdmatrixmarvin' => { 145 => 0xe76 },
	'lcdpanels' => { 89 => 0x8 },
	'lcheditor' => { 303 => 0x8ae85e },
	'legacyiptcdigest' => { 541 => 'LegacyIPTCDigest' },
	'legalcode' => { 522 => 'legalcode' },
	'lens' => { 125 => 0xfdea, 243 => 0x84, 521 => 'Lens' },
	'lensafstopbutton' => { 88 => 0x11, 89 => 0x13, 90 => 0x506, 91 => 0x10, 92 => 0x12, 95 => 0x13, 96 => 0x9 },
	'lensaperturerange' => { 435 => [0x30,0x48] },
	'lensblur' => { 524 => 'LensBlur', 526 => 'LensBlur' },
	'lensbluractive' => { 524 => [\'LensBlur','LensBlurActive'], 526 => [\'LensBlur','LensBlurActive'] },
	'lensbluramount' => { 524 => [\'LensBlur','LensBlurBlurAmount'], 526 => [\'LensBlur','LensBlurBlurAmount'] },
	'lensblurbokehaspect' => { 524 => [\'LensBlur','LensBlurBokehAspect'], 526 => [\'LensBlur','LensBlurBokehAspect'] },
	'lensblurbokehrotation' => { 524 => [\'LensBlur','LensBlurBokehRotation'], 526 => [\'LensBlur','LensBlurBokehRotation'] },
	'lensblurbokehshape' => { 524 => [\'LensBlur','LensBlurBokehShape'], 526 => [\'LensBlur','LensBlurBokehShape'] },
	'lensblurbokehshapedetail' => { 524 => [\'LensBlur','LensBlurBokehShapeDetail'], 526 => [\'LensBlur','LensBlurBokehShapeDetail'] },
	'lensblurcateyeamount' => { 524 => [\'LensBlur','LensBlurCatEyeAmount'], 526 => [\'LensBlur','LensBlurCatEyeAmount'] },
	'lensblurcateyescale' => { 524 => [\'LensBlur','LensBlurCatEyeScale'], 526 => [\'LensBlur','LensBlurCatEyeScale'] },
	'lensblurfocalrange' => { 524 => [\'LensBlur','LensBlurFocalRange'], 526 => [\'LensBlur','LensBlurFocalRange'] },
	'lensblurfocalrangesource' => { 524 => [\'LensBlur','LensBlurFocalRangeSource'], 526 => [\'LensBlur','LensBlurFocalRangeSource'] },
	'lensblurhighlightsboost' => { 524 => [\'LensBlur','LensBlurHighlightsBoost'], 526 => [\'LensBlur','LensBlurHighlightsBoost'] },
	'lensblurhighlightsthreshold' => { 524 => [\'LensBlur','LensBlurHighlightsThreshold'], 526 => [\'LensBlur','LensBlurHighlightsThreshold'] },
	'lensblursampledarea' => { 524 => [\'LensBlur','LensBlurSampledArea'], 526 => [\'LensBlur','LensBlurSampledArea'] },
	'lensblursampledrange' => { 524 => [\'LensBlur','LensBlurSampledRange'], 526 => [\'LensBlur','LensBlurSampledRange'] },
	'lensblursphericalaberration' => { 524 => [\'LensBlur','LensBlurSphericalAberration'], 526 => [\'LensBlur','LensBlurSphericalAberration'] },
	'lensblursubjectrange' => { 524 => [\'LensBlur','LensBlurSubjectRange'], 526 => [\'LensBlur','LensBlurSubjectRange'] },
	'lensblurversion' => { 524 => [\'LensBlur','LensBlurVersion'], 526 => [\'LensBlur','LensBlurVersion'] },
	'lenscontrolring' => { 326 => 0xb1, 327 => 0xad, 328 => 0xad, 329 => 0xad },
	'lenscorrectionsettings' => { 529 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 521 => 'LensDistortInfo' },
	'lensdistortionparams' => { 336 => 0x206 },
	'lensdriveend' => { 241 => 0x56 },
	'lensdrivenoaf' => { 90 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 447 => 0x3f0, 495 => 0xd },
	'lensfirmware' => { 426 => 0x20, 432 => 0xa004 },
	'lensfirmwareversion' => { 241 => 0x34, 332 => 0x204, 355 => 0x60, 447 => 0x3f3, 495 => 0x14 },
	'lensfocallength' => { 109 => 0xf0512, 381 => 0x9 },
	'lensfocalrange' => { 435 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 311 => '55.1', 313 => '52.1', 314 => '52.1', 323 => '52.1', 324 => '52.1' },
	'lensformat' => { 472 => 0x1891, 474 => 0x18bd, 475 => 0x18ed, 476 => 0x17f1, 478 => 0x106, 479 => 0x106, 490 => 0x603, 491 => 0x5d },
	'lensfstops' => { 235 => 0x7, 236 => 0xc, 237 => 0xd, 241 => 0xe, 243 => 0x8b, 381 => '0.3' },
	'lensfunc1button' => { 326 => 0xa3, 327 => 0x9f, 328 => 0x9f, 329 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 250 => 0x80a, 253 => 0x810, 254 => 0x814 },
	'lensfunc2button' => { 326 => 0xab, 327 => 0xa7, 328 => 0xa7, 329 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 250 => 0x80c, 253 => 0x812, 254 => 0x816 },
	'lensid' => { 241 => 0x30, 521 => 'LensID' },
	'lensidnumber' => { 235 => 0x6, 236 => 0xb, 237 => 0xc, 241 => 0xd },
	'lensinfo' => { 125 => 0xa432, 387 => 0x2a, 521 => 'LensInfo', 531 => 'LensSpecification' },
	'lenskind' => { 381 => 0x1 },
	'lensmake' => { 125 => 0xa433, 170 => 'Make', 531 => 'LensMake' },
	'lensmanualdistortionamount' => { 524 => 'LensManualDistortionAmount', 526 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 185 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 435 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 69 => 0x95, 125 => 0xa434, 170 => 'Model', 185 => 'LensModel', 238 => 0x18a, 239 => 0x18b, 240 => 0x2ac, 332 => 0x203, 387 => 0xc, 400 => 0x412, 418 => 'camera.lens_model', 531 => 'LensModel' },
	'lensmodulationoptimizer' => { 133 => 0x1045 },
	'lensmount' => { 447 => 0x99, 472 => 0x1892, 474 => 0x18be, 475 => 0x18ee, 476 => 0x17f2, 478 => 0x105, 479 => 0x105, 490 => 0x604, 491 => 0x5e },
	'lensmount2' => { 495 => 0x8 },
	'lensmounttype' => { 241 => 0x5f },
	'lenspositionabsolute' => { 241 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 524 => 'LensProfileChromaticAberrationScale', 526 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 524 => 'LensProfileDigest', 526 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 524 => 'LensProfileDistortionScale', 526 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 524 => 'LensProfileEnable', 526 => 'LensProfileEnable' },
	'lensprofilefilename' => { 524 => 'LensProfileFilename', 526 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 524 => 'LensProfileIsEmbedded', 526 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 524 => 'LensProfileMatchKeyCameraModelName', 526 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 524 => 'LensProfileMatchKeyExifMake', 526 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 524 => 'LensProfileMatchKeyExifModel', 526 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 524 => 'LensProfileMatchKeyIsRaw', 526 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 524 => 'LensProfileMatchKeyLensID', 526 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 524 => 'LensProfileMatchKeyLensInfo', 526 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 524 => 'LensProfileMatchKeyLensName', 526 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 524 => 'LensProfileMatchKeySensorFormatFactor', 526 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 354 => 0x370, 524 => 'LensProfileName', 526 => 'LensProfileName' },
	'lensprofilesetup' => { 524 => 'LensProfileSetup', 526 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 524 => 'LensProfileVignettingScale', 526 => 'LensProfileVignettingScale' },
	'lensproperties' => { 332 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 35 => 0x16b, 65 => 0x0, 125 => 0xa435, 170 => 'SerialNumber', 332 => 0x202, 353 => 0x321, 355 => 0x52, 417 => 'LENS', 426 => 0x30, 521 => 'LensSerialNumber', 531 => 'LensSerialNumber' },
	'lensshutterlock' => { 191 => 0x4a },
	'lensspec' => { 442 => 0x0, 443 => 0x0, 444 => 0x0, 459 => 0xb02a },
	'lensspecfeatures' => { 478 => [0x115,0x116], 479 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 336 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 37 => 0x16, 193 => 0x10c, 194 => 0x49bd, 243 => 0x83, 332 => 0x201, 346 => 0x16, 350 => 0x310, 352 => 0x303, 353 => 0x303, 355 => 0x51, 357 => 0x3405, 382 => 0x0, 383 => 0x0, 384 => 0x1, 385 => 0x1, 386 => 0x1, 388 => 0x0, 432 => 0xa003, 435 => 0x27, 459 => 0xb027, 472 => 0x1896, 474 => 0x18c2, 475 => 0x18f2, 476 => 0x17f6, 478 => 0x109, 479 => 0x109, 490 => 0x608, 491 => 0x62 },
	'lenstype2' => { 447 => 0x3f7, 472 => 0x1893, 474 => 0x18bf, 475 => 0x18ef, 476 => 0x17f3, 478 => 0x107, 479 => 0x107, 490 => 0x605, 491 => 0x60 },
	'lenstype3' => { 495 => 0x9 },
	'lenstypemake' => { 355 => 0xc4 },
	'lenstypemodel' => { 355 => [0xc5,0xe4] },
	'lenszoomposition' => { 487 => 0x19, 488 => 0x1e, 491 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 363 => 0x15 },
	'levelmeter' => { 417 => ['Lvlm','lvlm'] },
	'levelorientation' => { 389 => 0x0 },
	'license' => { 522 => 'license' },
	'licensee' => { 341 => 'Licensee' },
	'licenseeid' => { 341 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 341 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 341 => 'LicenseeImageNotes' },
	'licenseename' => { 341 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 341 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 341 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 341 => 'LicenseeTransactionID' },
	'licenseid' => { 341 => 'LicenseID' },
	'licensestartdate' => { 341 => 'LicenseStartDate' },
	'licensetransactiondate' => { 341 => 'LicenseTransactionDate' },
	'licensetype' => { 528 => 'licensetype' },
	'licensor' => { 341 => 'Licensor' },
	'licensorcity' => { 341 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 341 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 341 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 341 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 341 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 341 => 'LicensorImageID' },
	'licensorname' => { 341 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 341 => 'LicensorNotes' },
	'licensorpostalcode' => { 341 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 341 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 341 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 341 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 341 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 341 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 341 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 341 => 'LicensorTransactionID' },
	'licensorurl' => { 341 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 336 => 0x1009 },
	'lightingmode' => { 119 => 0x302a },
	'lightreading' => { 391 => 0x15 },
	'lightsource' => { 125 => 0x9208, 243 => 0x90, 339 => 0x1000, 530 => 'LightSource' },
	'lightsourcespecial' => { 434 => 0x21d },
	'lightswitch' => { 323 => '0.1', 325 => '0.1' },
	'lightvaluecenter' => { 336 => 0x103d },
	'lightvalueperiphery' => { 336 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 326 => 0x143, 327 => 0x153, 328 => 0x153, 329 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 326 => 0x141, 327 => 0x151, 328 => 0x151, 329 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 326 => 0x140, 327 => 0x150, 328 => 0x150, 329 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 326 => 0x13f, 327 => 0x14f, 328 => 0x14f, 329 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 326 => 0x11, 327 => 0x11, 328 => 0x11, 329 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 326 => 0x14, 327 => 0x14, 328 => 0x14, 329 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 326 => 0x13, 327 => 0x13, 328 => 0x13, 329 => 0x13 },
	'limitafareamodeselauto' => { 326 => 0x15, 327 => 0x15, 328 => 0x15, 329 => 0x15 },
	'limitafareamodeselection' => { 311 => '51.1', 313 => '49.1', 314 => '49.1', 323 => '49.1', 324 => '49.1' },
	'limitreleasemodeselc120' => { 328 => '269.4', 329 => '293.4' },
	'limitreleasemodeselc30' => { 328 => '269.3', 329 => '293.3' },
	'limitreleasemodeselch' => { 328 => '269.2', 329 => '293.2' },
	'limitreleasemodeselcl' => { 328 => '269.1', 329 => '293.1' },
	'limitreleasemodeselself' => { 328 => '269.5', 329 => '293.5' },
	'limitselectableimagearea16to9' => { 326 => 0x4d, 327 => 0x47, 328 => 0x47, 329 => 0x47 },
	'limitselectableimagearea1to1' => { 326 => 0x4c, 327 => 0x46, 328 => 0x46, 329 => 0x46 },
	'limitselectableimageareadx' => { 326 => 0x4b, 327 => 0x45, 328 => 0x45, 329 => 0x45 },
	'linearitylimitblue' => { 360 => 0x10 },
	'linearitylimitgreen' => { 360 => 0xf },
	'linearitylimitred' => { 360 => 0xe },
	'linearityuppermargin' => { 44 => 0x32c, 45 => 0x282, 46 => 0x296, 49 => [0x2ba,0x2d1,0x2d5], 51 => 0x1e5, 52 => [0x1fe,0x2de], 53 => [0x232,0x310], 54 => 0x31e },
	'linearizationtable' => { 125 => 0xc618 },
	'linearresponselimit' => { 125 => 0xc62e },
	'link' => { 543 => 'link' },
	'linkaetoafpoint' => { 371 => '14.2' },
	'linkedencodedrightsexpr' => { 538 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 538 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 538 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 538 => 'LinkedEncRightsExpr' },
	'linkvrtofocuspoint' => { 247 => 0x3ec },
	'linlogcoring' => { 145 => 0x904 },
	'lithostratigraphicterms' => { 124 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 411 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 411 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 411 => 'live-photo.vitality-scoring-version' },
	'liveview' => { 366 => 0x1fa, 373 => 0x3 },
	'liveviewaf' => { 315 => '32.1', 325 => '34.1' },
	'liveviewafareamode' => { 320 => '34.1' },
	'liveviewafmethod' => { 464 => 0x20 },
	'liveviewafmode' => { 320 => '34.2' },
	'liveviewafsetting' => { 447 => 0x36 },
	'liveviewbuttonoptions' => { 311 => '50.2', 313 => '48.2', 314 => '48.2', 323 => '48.2', 324 => '48.2' },
	'liveviewexposuresimulation' => { 90 => 0x810 },
	'liveviewfocusmode' => { 447 => [0x8b,0x28b] },
	'liveviewmetering' => { 447 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 311 => '21.2', 313 => '21.2', 314 => '21.2', 316 => '20.2', 317 => '20.2', 318 => '20.2', 320 => '20.2', 323 => '21.2', 324 => '21.2' },
	'liveviewshooting' => { 61 => 0x13 },
	'livingspecimen' => { 124 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 124 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 138 => 0x79 },
	'localizedcameramodel' => { 125 => 0xc615 },
	'locallocationname' => { 432 => 0x30 },
	'location' => { 242 => 0x9, 355 => 0x67, 516 => 'Location', 537 => 'Location', 542 => 'location', 543 => 'location' },
	'locationaccuracyhorizontal' => { 411 => 'location.accuracy.horizontal' },
	'locationareacode' => { 523 => 'lac' },
	'locationbody' => { 411 => 'location.body' },
	'locationcreated' => { 538 => 'LocationCreated' },
	'locationcreatedcity' => { 538 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 538 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 538 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 538 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpsaltituderef' => { 538 => [\'LocationCreated','LocationCreatedGPSAltitudeRef'] },
	'locationcreatedgpslatitude' => { 538 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 538 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 538 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 538 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 538 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 538 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 538 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 538 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 411 => 'location.date' },
	'locationinformation' => { 417 => 'loci' },
	'locationinfoversion' => { 242 => 0x0 },
	'locationname' => { 411 => 'location.name', 432 => 0x31 },
	'locationnote' => { 411 => 'location.note' },
	'locationrole' => { 411 => 'location.role' },
	'locationshown' => { 538 => 'LocationShown' },
	'locationshowncity' => { 538 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 538 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 538 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 538 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpsaltituderef' => { 538 => [\'LocationShown','LocationShownGPSAltitudeRef'] },
	'locationshowngpslatitude' => { 538 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 538 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 538 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 538 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 538 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 538 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 538 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 538 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 90 => 0x709 },
	'logcomment' => { 553 => 'logComment' },
	'logscale' => { 145 => 0x902 },
	'longdescription' => { 409 => 'ldes' },
	'longexposurenoisereduction' => { 67 => 0x4, 90 => 0x201, 91 => 0x1, 92 => 0x2, 93 => 0x1, 94 => 0x1, 95 => 0x2, 96 => 0x1, 355 => 0x49, 445 => 0x2b, 446 => 0x25, 447 => 0x25, 459 => 0x2008, 464 => 0x11, 491 => 0x44 },
	'longexposurenoisereduction2' => { 61 => 0x8 },
	'longexposurenrused' => { 355 => 0xbe },
	'longitude' => { 122 => 'Longitude' },
	'look' => { 524 => 'Look', 526 => 'Look' },
	'lookamount' => { 524 => [\'Look','LookAmount'], 526 => [\'Look','LookAmount'] },
	'lookcluster' => { 524 => [\'Look','LookCluster'], 526 => [\'Look','LookCluster'] },
	'lookcopyright' => { 524 => [\'Look','LookCopyright'], 526 => [\'Look','LookCopyright'] },
	'lookgroup' => { 524 => [\'Look','LookGroup'], 526 => [\'Look','LookGroup'] },
	'lookname' => { 524 => 'LookName', 526 => 'LookName' },
	'lookparameters' => { 524 => [\'Look','LookParameters'], 526 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 524 => [\'Look','LookParametersCameraProfile'], 526 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 524 => [\'Look','LookParametersClarity2012'], 526 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 524 => [\'Look','LookParametersConvertToGrayscale'], 526 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparametershighlights2012' => { 524 => [\'Look','LookParametersHighlights2012'], 526 => [\'Look','LookParametersHighlights2012'] },
	'lookparameterslooktable' => { 524 => [\'Look','LookParametersLookTable'], 526 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 524 => [\'Look','LookParametersProcessVersion'], 526 => [\'Look','LookParametersProcessVersion'] },
	'lookparametersshadows2012' => { 524 => [\'Look','LookParametersShadows2012'], 526 => [\'Look','LookParametersShadows2012'] },
	'lookparameterstonecurvepv2012' => { 524 => [\'Look','LookParametersToneCurvePV2012'], 526 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 524 => [\'Look','LookParametersToneCurvePV2012Blue'], 526 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 524 => [\'Look','LookParametersToneCurvePV2012Green'], 526 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 524 => [\'Look','LookParametersToneCurvePV2012Red'], 526 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 524 => [\'Look','LookParametersVersion'], 526 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 524 => [\'Look','LookSupportsAmount'], 526 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 524 => [\'Look','LookSupportsMonochrome'], 526 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 524 => [\'Look','LookSupportsOutputReferred'], 526 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 524 => [\'Look','LookUUID'], 526 => [\'Look','LookUUID'] },
	'loop' => { 553 => 'loop' },
	'loopstyle' => { 417 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 124 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 524 => 'LuminanceAdjustmentAqua', 526 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 524 => 'LuminanceAdjustmentBlue', 526 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 524 => 'LuminanceAdjustmentGreen', 526 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 524 => 'LuminanceAdjustmentMagenta', 526 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 524 => 'LuminanceAdjustmentOrange', 526 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 524 => 'LuminanceAdjustmentPurple', 526 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 524 => 'LuminanceAdjustmentRed', 526 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 524 => 'LuminanceAdjustmentYellow', 526 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 114 => 0x150 },
	'luminancecurvepoints' => { 114 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 109 => 0x20600, 115 => 0x5f, 435 => 0x1b },
	'luminancenoisereductioncontrast' => { 524 => 'LuminanceNoiseReductionContrast', 526 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 524 => 'LuminanceNoiseReductionDetail', 526 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 115 => 0x6d },
	'luminancesmoothing' => { 524 => 'LuminanceSmoothing', 526 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 90 => [0x40b,0x40c] },
	'lyrics' => { 409 => "\xa9lyr", 417 => "\xa9lyr", 553 => 'lyrics' },
	'lyricsuri' => { 417 => 'lrcu' },
	'm16cversion' => { 350 => 0x333 },
	'macatom' => { 525 => 'macAtom' },
	'macatomapplicationcode' => { 525 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 525 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 525 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 124 => 'MachineObservation' },
	'machineobservationday' => { 124 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 124 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 124 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 124 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 124 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 124 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 124 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 124 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 124 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 124 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 124 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 124 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 124 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 124 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 124 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 124 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 124 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 124 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 124 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 124 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 133 => 0x1020, 135 => 0x202, 158 => 0x2b, 336 => 0x202, 424 => 0x21, 434 => 0x202, 459 => 0xb040 },
	'macroled' => { 334 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 61 => 0x10 },
	'macromode' => { 37 => 0x1, 188 => 0xb, 331 => 0x300, 355 => 0x1c, 425 => 0x1009 },
	'magentahsl' => { 109 => 0x20917 },
	'magicfilter' => { 331 => 0x52c },
	'magnifiedview' => { 92 => 0x11, 94 => 0x9 },
	'mainboardversion' => { 145 => 0x438 },
	'maindialexposurecomp' => { 321 => '0.6' },
	'mainingredient' => { 545 => 'mainIngredient' },
	'majorbrand' => { 411 => 'major_brand' },
	'majorversion' => { 514 => 'MajorVersion' },
	'make' => { 104 => 0x0, 121 => 0x1, 125 => 0x10f, 163 => 'Make', 344 => 'Make', 360 => 0x10f, 411 => 'make', 417 => ['@mak',"\xa9mak"], 542 => 'make', 549 => 'Make' },
	'makernote' => { 530 => 'MakerNote' },
	'makernoteapple' => { 123 => 'MakN', 125 => 0x927c },
	'makernotecanon' => { 87 => 'CMT3', 123 => 'MakN', 125 => 0x927c },
	'makernotecasio' => { 123 => 'MakN', 125 => 0x927c },
	'makernotecasio2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotedji' => { 123 => 'MakN', 125 => 0x927c },
	'makernotedjiinfo' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteflir' => { 123 => 'MakN', 125 => 0x927c },
	'makernotefujifilm' => { 123 => 'MakN', 125 => 0x927c },
	'makernotege' => { 123 => 'MakN', 125 => 0x927c },
	'makernotege2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehasselblad' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp6' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteisl' => { 123 => 'MakN', 125 => 0x927c },
	'makernotejvc' => { 123 => 'MakN', 125 => 0x927c },
	'makernotejvctext' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak10' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak11' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak12' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak1a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak1b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak5' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak6a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak6b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak7' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak8a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak8b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak8c' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak9' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodakunknown' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekyocera' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica10' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica2' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica3' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica4' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica5' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica6' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica7' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica8' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica9' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteminolta' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteminolta2' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteminolta3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotemotorola' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenikon' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenikon2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenikon3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenintendo' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteoffset' => { 434 => 0xff },
	'makernoteolympus' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteolympus2' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteolympus3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepanasonic' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepanasonic2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepanasonic3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax5' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax6' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentaxunknown' => { 417 => 'PXMN' },
	'makernotephaseone' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyx' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyx2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyx3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericoh' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericoh2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericohpentax' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericohtext' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesafety' => { 125 => 0xc635 },
	'makernotesamsung1a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesamsung1b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesamsung2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesanyo' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesanyoc4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesanyopatch' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesigma' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony5' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesonyericsson' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesonysrf' => { 123 => 'MakN', 125 => 0x927c },
	'makernotetype' => { 425 => 0x1 },
	'makernoteunknown' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteunknownbinary' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteunknowntext' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 193 => 0x0, 243 => 0x1, 336 => 0x0, 355 => 0x8000, 429 => 0x0, 432 => 0x1, 435 => [0x1d,0x1f], 448 => 0x2000 },
	'makerurl' => { 417 => "\xa9mal" },
	'managedfrom' => { 554 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 554 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 554 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 554 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 554 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 554 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 554 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 554 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 554 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 554 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 554 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 554 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 554 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 554 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 554 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 554 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 554 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 554 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 554 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 554 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 554 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 554 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 554 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 554 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 554 => 'Manager' },
	'managervariant' => { 554 => 'ManagerVariant' },
	'manageto' => { 554 => 'ManageTo' },
	'manageui' => { 554 => 'ManageUI' },
	'manifest' => { 554 => 'Manifest' },
	'manifestlinkform' => { 554 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 554 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 554 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 554 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 554 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 554 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 554 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 554 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 554 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 554 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 554 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 554 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 554 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 554 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 554 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 554 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 554 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 554 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 554 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 554 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 554 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 554 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 554 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 554 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 554 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 554 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 554 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 554 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 331 => 0x900, 355 => 0x86 },
	'manometerreading' => { 331 => 0x901 },
	'manualafpointselectpattern' => { 90 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 334 => 0x1209 },
	'manualflashoutput' => { 37 => 0x29, 312 => '8.2', 315 => '22.2', 316 => '23.1', 317 => '23.2', 319 => '16.2', 320 => '23.2', 321 => '8.2', 322 => '23.2', 325 => '24.2', 425 => 0x100c },
	'manualflashstrength' => { 331 => 0x406 },
	'manualfocusdistance' => { 243 => 0x85, 336 => 0x100c, 434 => 0x223 },
	'manualfocuspointillumination' => { 326 => 0x17, 327 => 0x17, 328 => 0x17, 329 => 0x17 },
	'manualfocusringinafmode' => { 326 => 0x1b, 327 => 0x1a, 328 => 0x1a, 329 => 0x1a },
	'manualtv' => { 89 => 0x5, 90 => 0x705 },
	'manufacturedate' => { 198 => 0x6705, 370 => 0x1 },
	'manufacturedate1' => { 427 => 0x4 },
	'manufacturedate2' => { 427 => 0x5 },
	'manufacturer' => { 507 => 'Manufacturer', 542 => 'manufacturer' },
	'mariahchromablursize' => { 145 => 0xf0d },
	'mariahmaphithreshold' => { 145 => 0xf0c },
	'mariahmaplothreshold' => { 145 => 0xf0b },
	'mariahsigmathreshold' => { 145 => 0xf0e },
	'mariahtexturethreshold' => { 145 => 0xf0a },
	'marked' => { 540 => 'Marked', 557 => 'Marked' },
	'markers' => { 553 => 'markers' },
	'markerscomment' => { 553 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 553 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 553 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 553 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 553 => [\'markers','markersCuePointType'] },
	'markersduration' => { 553 => [\'markers','markersDuration'] },
	'markerslocation' => { 553 => [\'markers','markersLocation'] },
	'markersname' => { 553 => [\'markers','markersName'] },
	'markersprobability' => { 553 => [\'markers','markersProbability'] },
	'markersspeaker' => { 553 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 553 => [\'markers','markersStartTime'] },
	'markerstarget' => { 553 => [\'markers','markersTarget'] },
	'markerstype' => { 553 => [\'markers','markersType'] },
	'maskedareas' => { 125 => 0xc68e },
	'maskgroupbasedcorractive' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 524 => 'MaskGroupBasedCorrections', 526 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 524 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 526 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 138 => 0xb9 },
	'mastergain' => { 269 => 0x50 },
	'materialsample' => { 124 => 'MaterialSample' },
	'materialsampleid' => { 124 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 311 => '50.1', 313 => '48.1', 314 => '48.1', 323 => '48.1', 324 => '48.1', 327 => 0x233, 328 => 0x233, 329 => 0x24b },
	'matrixselectk' => { 145 => 0x91b },
	'matrixselectthreshold' => { 145 => 0x91a },
	'matrixselectthreshold1' => { 145 => 0x91e },
	'matrixselectthreshold2' => { 145 => 0x91f },
	'matrixstructure' => { 416 => 0xa },
	'maxaperture' => { 37 => 0x1a, 145 => 0x3f9, 151 => 0x6103, 170 => 'MaxAperture', 188 => 0x17, 194 => 0x49c5, 241 => 0x36, 332 => 0x20a, 381 => '14.1' },
	'maxapertureatmaxfocal' => { 133 => 0x1407, 170 => 'MaxApertureAtMaxFocal', 235 => 0xb, 236 => 0x10, 237 => 0x11, 241 => 0x12, 332 => 0x206 },
	'maxapertureatminfocal' => { 133 => 0x1406, 235 => 0xa, 236 => 0xf, 237 => 0x10, 241 => 0x11, 332 => 0x205 },
	'maxaperturevalue' => { 125 => 0x9205, 400 => 0x414, 530 => 'MaxApertureValue' },
	'maxavailheight' => { 538 => 'MaxAvailHeight' },
	'maxavailwidth' => { 538 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 310 => 0xb, 311 => 0xc, 313 => '12.1', 314 => '12.1', 319 => 0xc, 320 => 0xb, 323 => '12.1', 324 => '12.1', 326 => 0x41, 327 => 0x3d, 328 => 0x3d, 329 => 0x3d },
	'maxfaces' => { 335 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 37 => 0x17, 133 => 0x1405, 170 => 'MaxFocalLength', 235 => 0x9, 236 => 0xe, 237 => 0xf, 241 => 0x10, 332 => 0x208, 472 => 0x127c, 473 => 0x1138, 474 => 0x330, 475 => 0x330, 476 => 0x30e },
	'maxfocallength2' => { 66 => 0x9 },
	'maximumdensityrange' => { 140 => 0x8c },
	'maxpagesize' => { 558 => 'MaxPageSize' },
	'maxpagesizeh' => { 558 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 558 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 558 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 145 => 0xc7d },
	'maxsamplevalue' => { 125 => 0x119 },
	'maxstorage' => { 548 => 'maxstorage' },
	'mb-d10batteries' => { 310 => '12.6' },
	'mb-d10batterytype' => { 319 => '13.3' },
	'mb-d11batterytype' => { 320 => '2.3' },
	'mb-d12batterytype' => { 323 => '3.2' },
	'mb-d80batteries' => { 321 => '6.5' },
	'mb-d80batterytype' => { 325 => '3.2' },
	'mcuversion' => { 235 => 0xc, 236 => 0x11, 237 => 0x12, 241 => 0x13 },
	'md5digest' => { 171 => 'zmd5' },
	'mditemfindercomment' => { 180 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 180 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 180 => 'MDItemFSLabel' },
	'mditemusertags' => { 180 => 'MDItemUserTags' },
	'meal' => { 545 => 'meal' },
	'measuredev' => { 28 => 0x9, 82 => 0x3, 103 => 0x1814, 163 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 82 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 194 => 0x690, 350 => 0x312, 353 => 0x312, 354 => 0x312, 357 => 0x3407 },
	'measuredrggb' => { 70 => 0x1 },
	'measuredrggbdata' => { 48 => 0x287 },
	'measurementaccuracy' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 124 => 'MeasurementOrFact' },
	'measurementremarks' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 507 => 'MeasureType' },
	'mechanicalshuttercount' => { 243 => 0x37 },
	'mediaclassprimaryid' => { 186 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 186 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 341 => 'MediaConstraints' },
	'mediacreatedate' => { 413 => 0x1 },
	'mediaeventiddate' => { 512 => 'MediaEventIdDate' },
	'mediamodifydate' => { 413 => 0x2 },
	'mediasummarycode' => { 341 => 'MediaSummaryCode' },
	'mediatype' => { 409 => 'stik' },
	'mediauid' => { 417 => 'MUID' },
	'memoaudioquality' => { 90 => 0x812 },
	'memorycardconfiguration' => { 451 => 0x16 },
	'memorycardnumber' => { 220 => 0x2 },
	'menubuttondisplayposition' => { 88 => 0xb, 91 => 0xa, 92 => 0xb, 95 => 0xb },
	'menubuttonreturn' => { 96 => 0xb },
	'menumonitorofftime' => { 310 => '26.1', 311 => '22.1', 313 => '22.1', 314 => '22.1', 318 => '21.1', 319 => '8.2', 320 => '21.1', 323 => '22.1', 324 => '22.1', 325 => '22.1', 326 => 0x39, 327 => 0x35, 328 => 0x35, 329 => 0x35 },
	'mergedimages' => { 355 => 0x76 },
	'metadataauthority' => { 538 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 538 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 538 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 551 => 'MetadataDate' },
	'metadataeditingsoftware' => { 125 => 0xa43c, 531 => 'MetadataEditingSoftware' },
	'metadatalastedited' => { 538 => 'metadataLastEdited' },
	'metadatalasteditor' => { 538 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 538 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 538 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 553 => 'metadataModDate' },
	'metaversion' => { 467 => 0x34 },
	'meterinfo1row1' => { 460 => 0x0, 461 => 0x0 },
	'meterinfo1row2' => { 460 => 0x6c, 461 => 0x5a },
	'meterinfo1row3' => { 460 => 0xd8, 461 => 0xb4 },
	'meterinfo1row4' => { 460 => 0x144, 461 => 0x10e },
	'meterinfo1row5' => { 460 => 0x1b0, 461 => 0x168 },
	'meterinfo1row6' => { 460 => 0x21c, 461 => 0x1c2 },
	'meterinfo1row7' => { 460 => 0x288, 461 => 0x21c },
	'meterinfo2row1' => { 460 => 0x2f4, 461 => 0x276 },
	'meterinfo2row2' => { 460 => 0x378, 461 => 0x2e4 },
	'meterinfo2row3' => { 460 => 0x3fc, 461 => 0x352 },
	'meterinfo2row4' => { 460 => 0x480, 461 => 0x3c0 },
	'meterinfo2row5' => { 460 => 0x504, 461 => 0x42e },
	'meterinfo2row6' => { 460 => 0x588, 461 => 0x49c },
	'meterinfo2row7' => { 460 => 0x60c, 461 => 0x50a },
	'meterinfo2row8' => { 460 => 0x690, 461 => 0x578 },
	'meterinfo2row9' => { 460 => 0x714, 461 => 0x5e6 },
	'metering' => { 312 => '6.1' },
	'meteringmode' => { 37 => 0x11, 125 => 0x9207, 147 => 0x1c, 188 => 0x7, 189 => 0x25, 191 => 0x12, 331 => 0x202, 391 => 0x17, 435 => 0x9, 445 => 0x15, 446 => 0x13, 447 => 0x7, 464 => 0x3, 468 => 0x1174, 469 => 0x1178, 470 => 0x1154, 471 => 0x11d0, 472 => 0x11ac, 473 => 0x1064, 474 => 0x25c, 475 => 0x25c, 476 => 0x24b, 530 => 'MeteringMode' },
	'meteringmode2' => { 371 => '2.1', 459 => 0x202c },
	'meteringmode3' => { 371 => '16.1' },
	'meteringoffscaleindicator' => { 191 => 0x53 },
	'meteringtime' => { 310 => '22.2', 312 => '3.2', 315 => '17.1', 316 => '18.1', 319 => '7.3', 320 => '18.1', 321 => '3.2', 325 => '19.1' },
	'micro1version' => { 420 => 0x1f },
	'micro2version' => { 420 => 0x2d },
	'microphoneattenuator' => { 249 => 0x34e, 250 => 0x34e, 251 => 0x2d2, 252 => 0x2fa, 253 => 0x2fa, 254 => 0x2fe },
	'microphonefrequencyresponse' => { 249 => 0x350, 250 => 0x350, 251 => 0x2d4, 252 => 0x2fc, 253 => 0x2fc, 254 => 0x300 },
	'microphonejackpower' => { 249 => 0x376, 250 => 0x376, 251 => 0x2fa, 252 => 0x322, 253 => 0x322, 254 => 0x326 },
	'microphonesensitivity' => { 249 => 0x34c, 250 => 0x34c, 251 => 0x2d0, 252 => 0x2f8, 253 => 0x2f8, 254 => 0x2fc },
	'microvideo' => { 504 => 'MicroVideo' },
	'microvideooffset' => { 504 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 504 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 504 => 'MicroVideoVersion' },
	'midrangesharpness' => { 263 => 0x3b },
	'mieversion' => { 171 => '0Vers' },
	'mime' => { 507 => 'Mime' },
	'minaperture' => { 37 => 0x1b, 145 => 0x3f8, 170 => 'MinAperture', 381 => '0.2' },
	'minaperturevalue' => { 400 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 37 => 0x18, 133 => 0x1404, 170 => 'MinFocalLength', 235 => 0x8, 236 => 0xd, 237 => 0xe, 241 => 0xf, 332 => 0x207, 472 => 0x127a, 473 => 0x1136, 474 => 0x32e, 475 => 0x32e, 476 => 0x30c },
	'minfocallength2' => { 66 => 0x8 },
	'minfocusdistance' => { 381 => 0x3 },
	'minimumiso' => { 355 => 0xe8 },
	'minintegrationrows' => { 145 => 0x1874 },
	'minoltadate' => { 188 => 0x15 },
	'minoltaimagesize' => { 188 => 0x4, 189 => 0xc, 190 => 0x2, 193 => 0x103 },
	'minoltamodelid' => { 188 => 0x25 },
	'minoltaquality' => { 188 => 0x5, 189 => 0xd, 190 => 0x3, 193 => [0x102,0x103] },
	'minoltatime' => { 188 => 0x16 },
	'minormodelagedisclosure' => { 341 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 411 => 'minor_version', 514 => 'MinorVersion' },
	'minsamplevalue' => { 125 => 0x118 },
	'mirrorlockup' => { 88 => 0xc, 89 => 0xc, 90 => 0x60f, 91 => 0xb, 92 => 0xc, 93 => 0x6, 94 => 0x6, 95 => 0xc, 96 => 0x3 },
	'mobilecountrycode' => { 523 => 'mcc' },
	'mobilenetworkcode' => { 523 => 'mnc' },
	'moddate' => { 344 => 'modify-date', 540 => 'ModDate' },
	'modedialposition' => { 451 => 0x14 },
	'model' => { 104 => 0x6, 125 => 0x110, 163 => 'Model', 344 => 'Model', 360 => 0x110, 391 => 0x23f, 411 => 'model', 417 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 435 => 0x84, 507 => 'Model', 542 => 'model', 549 => 'Model' },
	'modelage' => { 538 => 'ModelAge' },
	'modelid' => { 330 => 0x0 },
	'modelingflash' => { 310 => '21.4', 311 => '31.1', 313 => '31.1', 314 => '31.1', 319 => '26.4', 320 => '30.2', 321 => '7.4', 322 => '30.1', 323 => '31.1', 324 => '31.1', 325 => '31.3', 326 => 0x61, 327 => 0x5d, 328 => 0x5d, 329 => 0x5d },
	'modelreleaseid' => { 341 => 'ModelReleaseID' },
	'modelreleasestatus' => { 341 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 482 => 0x52, 483 => 0x46, 484 => 0x53 },
	'modeltiepoint' => { 125 => 0x8482 },
	'modeltransform' => { 125 => 0x85d8 },
	'modelyear' => { 542 => 'modelYear' },
	'modificationdate' => { 543 => 'modificationDate' },
	'modifiedcolortemp' => { 71 => 0x9 },
	'modifieddigitalgain' => { 71 => 0xb },
	'modifiedparamflag' => { 62 => 0x1 },
	'modifiedpicturestyle' => { 71 => 0xa },
	'modifiedsaturation' => { 331 => 0x504 },
	'modifiedsensorbluelevel' => { 71 => 0x5 },
	'modifiedsensorredlevel' => { 71 => 0x4 },
	'modifiedsharpness' => { 71 => 0x2 },
	'modifiedsharpnessfreq' => { 71 => 0x3 },
	'modifiedtonecurve' => { 71 => 0x1 },
	'modifiedwhitebalance' => { 71 => 0x8 },
	'modifiedwhitebalanceblue' => { 71 => 0x7 },
	'modifiedwhitebalancered' => { 71 => 0x6 },
	'modifydate' => { 125 => 0x132, 164 => 'ModifyDate', 340 => 'ModDate', 342 => 'tIME', 407 => 'ModDate', 414 => 0x2, 551 => 'ModifyDate' },
	'moirefilter' => { 125 => 0xfe58, 524 => 'MoireFilter', 526 => 'MoireFilter' },
	'monitorbrightness' => { 247 => 0x904, 249 => 0x69a, 250 => 0x6aa, 251 => 0x59a, 252 => 0x5ca, 253 => 0x5e2, 254 => 0x5e6 },
	'monitordisplayoff' => { 191 => 0x4c },
	'monitormatrix' => { 145 => 0x8fc },
	'monitorofftime' => { 310 => '18.2', 312 => '3.1', 321 => '3.1' },
	'monochromecolor' => { 331 => 0x53b },
	'monochromecontrast' => { 115 => 0x3c },
	'monochromefiltereffect' => { 109 => 0x20307, 115 => 0x3a, 355 => 0xac, 391 => 0x73 },
	'monochromegraineffect' => { 355 => 0xd2 },
	'monochromelinear' => { 115 => 0x3d },
	'monochromeoutputhighlightpoint' => { 115 => 0x41 },
	'monochromeoutputshadowpoint' => { 115 => 0x42 },
	'monochromeprofilesettings' => { 331 => 0x537 },
	'monochromerawhighlight' => { 115 => 0x7a },
	'monochromerawhighlightpoint' => { 115 => 0x3f },
	'monochromerawshadow' => { 115 => 0x83 },
	'monochromerawshadowpoint' => { 115 => 0x40 },
	'monochromesharpness' => { 115 => 0x3e },
	'monochrometoning' => { 391 => 0x74 },
	'monochrometoningeffect' => { 109 => 0x20306, 115 => 0x3b },
	'monochromeunsharpmaskfineness' => { 115 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 115 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 115 => 0xb4 },
	'monochromevignetting' => { 331 => 0x53a },
	'monthdaycreated' => { 147 => 0x12, 156 => 0xe },
	'mood' => { 186 => 'WM/Mood' },
	'moonphase' => { 419 => 0x12, 420 => 0x43, 421 => 0x4c },
	'morepermissions' => { 522 => 'morePermissions' },
	'motionphoto' => { 504 => 'MotionPhoto' },
	'motionphotopresentationtimestampus' => { 504 => 'MotionPhotoPresentationTimestampUs' },
	'motionphotoversion' => { 504 => 'MotionPhotoVersion' },
	'motionphotovideo' => { 412 => 'mpvd' },
	'motionsensitivity' => { 419 => 0x29, 421 => 0x60 },
	'movementcount' => { 409 => "\xa9mvc" },
	'movementname' => { 409 => "\xa9mvn" },
	'movementnumber' => { 409 => "\xa9mvi" },
	'movieactived-lighting' => { 248 => 0x238, 249 => 0x334, 250 => 0x334, 251 => 0x2b8, 252 => 0x2e0, 253 => 0x2e0, 254 => 0x2e4 },
	'movieaelockbuttonassignment' => { 323 => '40.1' },
	'movieaf-onbutton' => { 326 => 0xd3, 327 => 0xcb, 328 => 0xcb, 329 => 0xcb },
	'movieafareamode' => { 249 => 0x342, 250 => 0x342, 251 => 0x2c6, 252 => 0x2ee, 253 => 0x2ee, 254 => 0x2f2, 327 => 0x203, 328 => 0x203, 329 => 0x21b },
	'movieafspeed' => { 326 => 0xe5, 327 => 0xdd, 328 => 0xdd, 329 => 0xdd },
	'movieafspeedapply' => { 326 => 0xe7, 327 => 0xdf, 328 => 0xdf, 329 => 0xdf },
	'movieaftrackingsensitivity' => { 326 => 0xe9, 327 => 0xe1, 328 => 0xe1, 329 => 0xe1 },
	'movieaperturelock' => { 327 => 0x259, 328 => 0x259, 329 => 0x271 },
	'movieautodistortioncontrol' => { 248 => 0x242 },
	'moviediffractioncompensation' => { 248 => 0x241 },
	'moviedxcropalert' => { 249 => 0x377, 250 => 0x377, 251 => 0x2fb, 252 => 0x323, 253 => 0x323, 254 => 0x327 },
	'movieelectronicvr' => { 249 => 0x348, 250 => 0x348, 251 => 0x2cc, 252 => 0x2f4, 253 => 0x2f4, 254 => 0x2f8 },
	'movieevfgrid' => { 327 => 0x21d, 328 => 0x21d, 329 => 0x235 },
	'movieflickerreduction' => { 249 => 0x33c, 250 => 0x33c, 251 => 0x2c0, 252 => 0x2e8, 253 => 0x2e8, 254 => 0x2ec },
	'moviefocusmode' => { 248 => 0x248, 249 => 0x340, 250 => 0x340, 251 => 0x2c4, 252 => 0x2ec, 253 => 0x2ec, 254 => 0x2f0 },
	'moviefocuspointlock' => { 327 => 0x226, 328 => 0x226, 329 => 0x23e },
	'movieframerate' => { 247 => 0x48c, 248 => 0x1f8, 249 => 0x374, 250 => 0x370, 251 => 0x2f4, 252 => 0x31c, 253 => 0x31c, 254 => 0x320 },
	'movieframesize' => { 247 => 0x48a, 248 => 0x1f6, 249 => 0x372, 250 => 0x36e, 251 => 0x2f2, 252 => 0x31a, 253 => 0x31a, 254 => 0x31e },
	'moviefunc1button' => { 313 => '41.1', 314 => '41.1', 324 => '41.1', 326 => 0xc7, 327 => 0xc3, 328 => 0xc3, 329 => 0xc3 },
	'moviefunc2button' => { 326 => 0xcd, 327 => 0xc7, 328 => 0xc7, 329 => 0xc7 },
	'moviefunc3button' => { 328 => 0x127, 329 => 0x13f },
	'moviefunctionbutton' => { 311 => '41.1', 323 => '41.1' },
	'moviefunctionbuttonplusdials' => { 311 => '52.1' },
	'moviehighisonoisereduction' => { 248 => 0x23c, 249 => 0x336, 250 => 0x336, 251 => 0x2ba, 252 => 0x2e2, 253 => 0x2e2, 254 => 0x2e6 },
	'moviehighlightdisplaythreshold' => { 327 => 0x215, 328 => 0x215, 329 => 0x22d },
	'moviehighreszoom' => { 249 => 0x380, 250 => 0x380, 252 => 0x32c, 253 => 0x32c, 254 => 0x330 },
	'movieimagearea' => { 249 => 0x2da, 250 => 0x2da, 251 => 0x25c, 252 => 0x286, 253 => 0x286, 254 => 0x28a },
	'movieisoautocontrolmanualmode' => { 249 => 0x2e8, 250 => 0x2e8, 251 => 0x26a, 252 => 0x294, 253 => 0x294, 254 => 0x298 },
	'movieisoautohilimit' => { 249 => 0x2e6, 250 => 0x2e6, 251 => 0x268, 252 => 0x292, 253 => 0x292, 254 => 0x296 },
	'movieisoautomanualmode' => { 248 => 0x204, 249 => 0x2ea, 250 => 0x2ea, 251 => 0x26c, 252 => 0x296, 253 => 0x296, 254 => 0x29a },
	'movielenscontrolring' => { 326 => 0xdf, 327 => 0xd7, 328 => 0xd7, 329 => 0xd7 },
	'moviemeteringmode' => { 249 => 0x33e, 250 => 0x33e, 251 => 0x2c2, 252 => 0x2ea, 253 => 0x2ea, 254 => 0x2ee },
	'moviemidtonedisplayrange' => { 327 => 0x219, 328 => 0x219, 329 => 0x231 },
	'moviemidtonedisplayvalue' => { 327 => 0x217, 328 => 0x217, 329 => 0x22f },
	'moviemultiselector' => { 326 => 0xe1, 327 => 0xd9, 328 => 0xcf, 329 => 0xcf },
	'moviepreviewbutton' => { 311 => '41.2', 313 => '41.2', 314 => '41.2', 323 => '41.2', 324 => '41.2' },
	'moviepreviewbuttonplusdials' => { 311 => '52.2' },
	'movierecordbuttonplaybackmode' => { 326 => 0x1af, 327 => 0x1b5, 328 => 0x1b5, 329 => 0x1cd },
	'movieshutterbutton' => { 311 => '38.3', 313 => '38.3', 314 => '38.3', 323 => '38.3', 324 => '38.3' },
	'movieshutterspeedlock' => { 327 => 0x225, 328 => 0x225, 329 => 0x23d },
	'movieslowmotion' => { 247 => 0x416, 248 => 0x1fa },
	'moviesoundrecording' => { 249 => 0x34a, 250 => 0x34a, 251 => 0x2ce, 252 => 0x2f6, 253 => 0x2f6, 254 => 0x2fa },
	'moviesubjectdetection' => { 249 => 0x378, 250 => 0x378, 251 => 0x2fc, 252 => 0x324, 253 => 0x324, 254 => 0x328 },
	'moviesubselectorassignment' => { 311 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 311 => '53.1' },
	'movietonemap' => { 251 => 0x2ec, 252 => 0x314, 253 => 0x314, 254 => 0x318 },
	'movietype' => { 232 => 0x2ca, 247 => 0x41a, 248 => 0x1fe, 249 => 0x2e4, 250 => 0x2e4, 251 => 0x266, 252 => 0x290, 253 => 0x290, 254 => 0x294 },
	'movievibrationreduction' => { 248 => 0x24e },
	'movievibrationreductionsameasphoto' => { 248 => 0x24f },
	'movievignettecontrol' => { 248 => 0x23e, 249 => 0x1b0, 250 => 0x1b0, 251 => 0x1a0, 252 => 0x1b4, 253 => 0x1b4, 254 => 0x1b8 },
	'movievignettecontrolsameasphoto' => { 248 => 0x240 },
	'movievrmode' => { 249 => 0x344, 250 => 0x344, 251 => 0x2c8, 252 => 0x2f0, 253 => 0x2f0, 254 => 0x2f4 },
	'moviezebrapattern' => { 327 => 0x213, 328 => 0x213, 329 => 0x22b },
	'multiburstimageheight' => { 459 => 0x1002 },
	'multiburstimagewidth' => { 459 => 0x1001 },
	'multiburstmode' => { 459 => 0x1000 },
	'multicontrollerwhilemetering' => { 90 => 0x517 },
	'multiexposure' => { 73 => 0x1, 355 => 0xb4 },
	'multiexposureautogain' => { 256 => 0x3 },
	'multiexposurecontrol' => { 73 => 0x2 },
	'multiexposuremode' => { 256 => 0x1, 257 => 0x1 },
	'multiexposureoverlaymode' => { 257 => 0x3 },
	'multiexposureshots' => { 73 => 0x3, 247 => 0x1be, 249 => 0x9a, 250 => 0x9a, 251 => 0x8e, 252 => 0x9c, 253 => 0x9c, 254 => 0xa0, 256 => 0x2, 257 => 0x2 },
	'multiframenoisereduction' => { 447 => 0x35, 459 => 0x200b, 464 => 0x15 },
	'multiframenreffect' => { 459 => 0x2023 },
	'multifunctionlock' => { 90 => 0x70f },
	'multipleexposuremode' => { 247 => 0x1bc, 249 => 0x98, 250 => 0x98, 251 => 0x8c, 252 => 0x9a, 253 => 0x9a, 254 => 0x9e, 335 => 0x101c },
	'multipleexposureset' => { 371 => '10.1' },
	'multisample' => { 269 => 0x40 },
	'multiselector' => { 310 => '9.4', 311 => '10.3', 313 => '10.3', 314 => '10.3', 319 => '27.4', 323 => '10.3', 324 => '10.3' },
	'multiselectorliveview' => { 310 => '4.3', 313 => '37.1', 314 => '37.1', 323 => '37.1', 324 => '37.1' },
	'multiselectorliveviewmode' => { 283 => 0x18c2 },
	'multiselectorplaybackmode' => { 310 => ['13.5','9.2'], 311 => '10.2', 314 => '10.2', 319 => '27.2', 323 => '10.2', 324 => '10.2', 326 => 0xb7, 327 => 0xb3, 328 => 0xb3, 329 => 0xb3 },
	'multiselectorshootmode' => { 310 => '9.1', 311 => '10.1', 313 => '10.1', 314 => '10.1', 319 => '27.1', 323 => '10.1', 324 => '10.1', 326 => 0xb3, 327 => 0xaf, 328 => 0xaf, 329 => 0xaf },
	'multishot' => { 360 => 0x121 },
	'mute' => { 408 => 'player.movie.audio.mute', 411 => 'player.movie.audio.mute' },
	'mycolormode' => { 74 => 0x2 },
	'name' => { 417 => 'name', 524 => 'Name', 526 => 'Name' },
	'narrator' => { 409 => "\xa9nrt" },
	'nationalcatalognumber' => { 543 => 'nationalCatalogNumber' },
	'nativedigest' => { 530 => 'NativeDigest', 549 => 'NativeDigest' },
	'nativeformat' => { 519 => 'NativeFormat' },
	'ndfilter' => { 82 => 0x1c, 331 => 0x204, 425 => 0x1019 },
	'near' => { 507 => 'Near' },
	'nefbitdepth' => { 243 => 0xe22 },
	'nefcompression' => { 243 => 0x93, 244 => 0xa },
	'neflinearizationtable' => { 243 => 0x96 },
	'negativecachelargepreviewsize' => { 524 => 'NegativeCacheLargePreviewSize', 526 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 524 => 'NegativeCacheMaximumSize', 526 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 524 => 'NegativeCachePath', 526 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 521 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 391 => 0x88 },
	'neutraloutputhighlightpoint' => { 115 => 0x2f },
	'neutraloutputshadowpoint' => { 115 => 0x30 },
	'neutralrawcolortone' => { 115 => 0x28 },
	'neutralrawcontrast' => { 115 => 0x2a },
	'neutralrawhighlight' => { 115 => 0x78 },
	'neutralrawhighlightpoint' => { 115 => 0x2d },
	'neutralrawlinear' => { 115 => 0x2b },
	'neutralrawsaturation' => { 115 => 0x29 },
	'neutralrawshadow' => { 115 => 0x81 },
	'neutralrawshadowpoint' => { 115 => 0x2e },
	'neutralrawsharpness' => { 115 => 0x2c },
	'neutralunsharpmaskfineness' => { 115 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 115 => 0xa8 },
	'neutraunsharpmaskstrength' => { 115 => 0xa4 },
	'newlensdata' => { 241 => 0x2f },
	'newrawimagedigest' => { 125 => 0xc7a7 },
	'newsphotoversion' => { 140 => 0x0 },
	'nickname' => { 551 => 'Nickname' },
	'nikoncapturedata' => { 243 => 0xe01 },
	'nikoncaptureeditversions' => { 243 => 0xe13 },
	'nikoncaptureoffsets' => { 243 => 0xe0e },
	'nikoncaptureoutput' => { 243 => 0xe1e },
	'nikoncaptureversion' => { 243 => 0xe09 },
	'nikoniccprofile' => { 243 => 0xe1d },
	'nikonimagesize' => { 280 => '723.1', 281 => '732.1', 289 => 0x2c4 },
	'nikonmeteringmode' => { 206 => 0x17, 247 => 0x2d2, 248 => 0x146, 260 => 0x214 },
	'nikonsettings' => { 243 => 0x4e },
	'noisefilter' => { 331 => 0x527 },
	'noiseprofile' => { 125 => 0xc761 },
	'noisereduction' => { 133 => [0x100b,0x100e], 189 => 0xb0, 190 => 0x60, 191 => 0x3f, 243 => 0x95, 303 => 0x753dcbc0, 304 => 0x17, 331 => 0x50a, 336 => 0x103a, 355 => 0x2d, 391 => 0x49, 425 => 0x100f, 427 => 0x2a },
	'noisereduction2' => { 335 => 0x1010 },
	'noisereductionapplied' => { 125 => 0xc6f7 },
	'noisereductionintensity' => { 304 => 0x9 },
	'noisereductionmethod' => { 304 => 0x11 },
	'noisereductionmode' => { 496 => 0x801e },
	'noisereductionparametersatcapture' => { 145 => 0xe73 },
	'noisereductionparameterscamera' => { 145 => 0xe72 },
	'noisereductionparametershost3mp' => { 145 => 0xe71 },
	'noisereductionparametershost6mp' => { 145 => 0xe70 },
	'noisereductionparametershostrgb' => { 145 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 145 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 145 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 145 => 0xe63 },
	'noisereductionparams' => { 360 => 0x1b },
	'noisereductionsharpness' => { 304 => 0xd },
	'noisereductionstrength' => { 355 => 0xd6 },
	'noisereductionvalue' => { 496 => 0x8027 },
	'nomemorycard' => { 310 => '22.1', 311 => '4.2', 312 => '0.3', 315 => '2.4', 316 => '3.2', 317 => '3.2', 319 => '33.7', 320 => '3.2', 321 => '0.3', 323 => '4.2', 325 => '4.5' },
	'nominalmaxaperture' => { 381 => 0xa },
	'nominalminaperture' => { 381 => '10.1' },
	'noncpulens10focallength' => { 249 => 0x6c6, 250 => 0x6d6, 253 => 0x620, 254 => 0x624 },
	'noncpulens10maxaperture' => { 249 => 0x6ee, 250 => 0x738, 253 => 0x670, 254 => 0x674 },
	'noncpulens11focallength' => { 249 => 0x6c8, 250 => 0x6d8, 253 => 0x624, 254 => 0x628 },
	'noncpulens11maxaperture' => { 249 => 0x6f0, 250 => 0x73c, 253 => 0x674, 254 => 0x678 },
	'noncpulens12focallength' => { 249 => 0x6ca, 250 => 0x6da, 253 => 0x628, 254 => 0x62c },
	'noncpulens12maxaperture' => { 249 => 0x6f2, 250 => 0x740, 253 => 0x678, 254 => 0x67c },
	'noncpulens13focallength' => { 249 => 0x6cc, 250 => 0x6dc, 253 => 0x62c, 254 => 0x630 },
	'noncpulens13maxaperture' => { 249 => 0x6f4, 250 => 0x744, 253 => 0x67c, 254 => 0x680 },
	'noncpulens14focallength' => { 249 => 0x6ce, 250 => 0x6de, 253 => 0x630, 254 => 0x634 },
	'noncpulens14maxaperture' => { 249 => 0x6f6, 250 => 0x748, 253 => 0x680, 254 => 0x684 },
	'noncpulens15focallength' => { 249 => 0x6d0, 250 => 0x6e0, 253 => 0x634, 254 => 0x638 },
	'noncpulens15maxaperture' => { 249 => 0x6f8, 250 => 0x74c, 253 => 0x684, 254 => 0x688 },
	'noncpulens16focallength' => { 249 => 0x6d2, 250 => 0x6e2, 253 => 0x638, 254 => 0x63c },
	'noncpulens16maxaperture' => { 249 => 0x6fa, 250 => 0x750, 253 => 0x688, 254 => 0x68c },
	'noncpulens17focallength' => { 249 => 0x6d4, 250 => 0x6e4, 253 => 0x63c, 254 => 0x640 },
	'noncpulens17maxaperture' => { 249 => 0x6fc, 250 => 0x754, 253 => 0x68c, 254 => 0x690 },
	'noncpulens18focallength' => { 249 => 0x6d6, 250 => 0x6e6, 253 => 0x640, 254 => 0x644 },
	'noncpulens18maxaperture' => { 249 => 0x6fe, 250 => 0x758, 253 => 0x690, 254 => 0x694 },
	'noncpulens19focallength' => { 249 => 0x6d8, 250 => 0x6e8, 253 => 0x644, 254 => 0x648 },
	'noncpulens19maxaperture' => { 249 => 0x700, 250 => 0x75c, 253 => 0x694, 254 => 0x698 },
	'noncpulens1focallength' => { 249 => 0x6b4, 250 => 0x6c4, 253 => 0x5fc, 254 => 0x600 },
	'noncpulens1maxaperture' => { 249 => 0x6dc, 250 => 0x714, 253 => 0x64c, 254 => 0x650 },
	'noncpulens20focallength' => { 249 => 0x6da, 250 => 0x6ea, 253 => 0x648, 254 => 0x64c },
	'noncpulens20maxaperture' => { 249 => 0x702, 250 => 0x760, 253 => 0x698, 254 => 0x69c },
	'noncpulens2focallength' => { 249 => 0x6b6, 250 => 0x6c6, 253 => 0x600, 254 => 0x604 },
	'noncpulens2maxaperture' => { 249 => 0x6de, 250 => 0x718, 253 => 0x650, 254 => 0x654 },
	'noncpulens3focallength' => { 249 => 0x6b8, 250 => 0x6c8, 253 => 0x604, 254 => 0x606 },
	'noncpulens3maxaperture' => { 249 => 0x6e0, 250 => 0x71c, 253 => 0x654, 254 => 0x658 },
	'noncpulens4focallength' => { 249 => 0x6ba, 250 => 0x6ca, 253 => 0x608, 254 => 0x60c },
	'noncpulens4maxaperture' => { 249 => 0x6e2, 253 => 0x658, 254 => 0x65c },
	'noncpulens5focallength' => { 249 => 0x6bc, 250 => 0x6cc, 253 => 0x60c, 254 => 0x610 },
	'noncpulens5maxaperture' => { 249 => 0x6e4, 250 => 0x724, 253 => 0x65c, 254 => 0x660 },
	'noncpulens6focallength' => { 249 => 0x6be, 250 => 0x6ce, 253 => 0x610, 254 => 0x614 },
	'noncpulens6maxaperture' => { 249 => 0x6e6, 250 => 0x728, 253 => 0x660, 254 => 0x664 },
	'noncpulens7focallength' => { 249 => 0x6c0, 250 => 0x6d0, 253 => 0x614, 254 => 0x618 },
	'noncpulens7maxaperture' => { 249 => 0x6e8, 250 => 0x72c, 253 => 0x664, 254 => 0x668 },
	'noncpulens8focallength' => { 249 => 0x6c2, 250 => 0x6d2, 253 => 0x618, 254 => 0x61c },
	'noncpulens8maxaperture' => { 249 => 0x6ea, 250 => 0x730, 253 => 0x668, 254 => 0x66c },
	'noncpulens9focallength' => { 249 => 0x6c4, 250 => 0x6d4, 253 => 0x61c, 254 => 0x620 },
	'noncpulens9maxaperture' => { 249 => 0x6ec, 250 => 0x734, 253 => 0x66c, 254 => 0x670 },
	'normalizedcropcorners' => { 345 => 'NormalizedCropCorners' },
	'normallinetime' => { 145 => 0x186a },
	'normalwhitelevel' => { 44 => 0x32a, 45 => 0x280, 46 => 0x294, 49 => [0x2b8,0x2cf,0x2d3], 50 => 0x569, 51 => 0x1e3, 52 => [0x1fc,0x2dc], 53 => [0x230,0x30e], 54 => 0x31c },
	'notes' => { 498 => 'Notes', 518 => 'notes' },
	'npages' => { 558 => 'NPages' },
	'nullrecord' => { 103 => 0x0 },
	'numafpoints' => { 367 => 0x2 },
	'number' => { 543 => 'number' },
	'numberofbeats' => { 553 => 'numberOfBeats' },
	'numberoffocuspoints' => { 313 => '1.3', 314 => '1.3', 317 => '0.2', 318 => '0.3', 320 => '0.3' },
	'numfaceelements' => { 133 => 0x4200 },
	'numfacepositions' => { 347 => 0x0 },
	'numindexentries' => { 140 => 0x54 },
	'numwbentries' => { 361 => 0x0, 362 => 0x0 },
	'object' => { 543 => 'object' },
	'objectattributereference' => { 138 => 0x4 },
	'objectcycle' => { 138 => 0x4b, 518 => 'ObjectCycle' },
	'objectdescription' => { 542 => 'objectDescription' },
	'objectdistance' => { 118 => 0x6, 119 => 0x2022 },
	'objectname' => { 138 => 0x5 },
	'objectpreviewdata' => { 138 => 0xca },
	'objectpreviewfileformat' => { 138 => 0xc8 },
	'objectpreviewfileversion' => { 138 => 0xc9 },
	'objectsubtype' => { 542 => 'objectSubtype' },
	'objecttype' => { 542 => 'objectType' },
	'objecttypereference' => { 138 => 0x3 },
	'occurrence' => { 124 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 124 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 124 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 124 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 124 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 124 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 124 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 124 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 124 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 124 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 124 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 124 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 124 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 124 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 124 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 124 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 124 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 124 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 124 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 124 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 124 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 124 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 124 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 124 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 124 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 124 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 124 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 124 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 124 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 124 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 530 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 530 => [\'OECF','OECFNames'] },
	'oecfrows' => { 530 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 530 => [\'OECF','OECFValues'] },
	'offsaledate' => { 543 => 'offSaleDate' },
	'offsaledatea-platform' => { 543 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 543 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 145 => 0x190a },
	'offsethdr' => { 535 => 'OffsetHDR' },
	'offsetschema' => { 125 => 0xea1d },
	'offsetsdr' => { 535 => 'OffsetSDR' },
	'offsettime' => { 125 => 0x9010 },
	'offsettimedigitized' => { 125 => 0x9012 },
	'offsettimeoriginal' => { 125 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 320 => '15.1', 325 => '16.1' },
	'oldsubfiletype' => { 125 => 0xff },
	'olympusimageheight' => { 336 => 0x102f },
	'olympusimagewidth' => { 336 => 0x102e },
	'omenatcapturestrength' => { 145 => 0xa60 },
	'omenautostrength' => { 145 => 0xa5f },
	'omenearlystrength' => { 145 => 0xa5e },
	'omenfocallengthlimit' => { 145 => 0xa62 },
	'omeninitialipfstrength' => { 145 => 0xa5d },
	'omensurfaceindex' => { 145 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 336 => 0x302 },
	'onsaledate' => { 543 => 'onSaleDate' },
	'onsaledatea-platform' => { 543 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 543 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 543 => 'onSaleDay' },
	'onsaledaya-platform' => { 543 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 543 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 125 => 0xc740 },
	'opcodelist2' => { 125 => 0xc741 },
	'opcodelist3' => { 125 => 0xc74e },
	'opticalzoom' => { 149 => 0xfa3d, 151 => [0x6006,0xf006], 152 => 0x1000, 153 => 0xf, 156 => 0x1e, 158 => 0x20, 159 => 0x1c, 170 => 'OpticalZoom' },
	'opticalzoomcode' => { 82 => 0xa },
	'opticalzoommode' => { 355 => 0x34 },
	'opticalzoomon' => { 434 => 0x219 },
	'optionenddate' => { 546 => 'optionEndDate' },
	'opto-electricconvfactor' => { 530 => 'OECF' },
	'orangehsl' => { 109 => 0x20911 },
	'ordernumber' => { 133 => 0x8002 },
	'organisationinimagecode' => { 538 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 538 => 'OrganisationInImageName' },
	'organism' => { 124 => 'Organism' },
	'organismassociatedoccurrences' => { 124 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 124 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 124 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 124 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 124 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 124 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 124 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 543 => 'organization' },
	'orientation' => { 125 => 0x112, 360 => 0x112, 542 => 'orientation', 549 => 'Orientation' },
	'orientation2' => { 464 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 90 => 0x516 },
	'originalalbumtitle' => { 186 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 186 => 'WM/OriginalArtist', 409 => "\xa9ope" },
	'originalbestqualitysize' => { 125 => 0xc792 },
	'originalcreatedatetime' => { 512 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 120 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 69 => 0x83 },
	'originaldefaultcropsize' => { 125 => 0xc793 },
	'originaldefaultfinalsize' => { 125 => 0xc791 },
	'originaldirectory' => { 352 => 0x408 },
	'originaldocumentid' => { 554 => 'OriginalDocumentID' },
	'originalfilename' => { 103 => 0x816, 145 => 0x3e9, 157 => 0x20, 352 => 0x407, 512 => 'OriginalFilename' },
	'originalimagehash' => { 501 => 'OriginalImageHash' },
	'originalimagehashtype' => { 501 => 'OriginalImageHashType' },
	'originalimageheight' => { 84 => 0xc, 129 => 0x1 },
	'originalimagemd5' => { 501 => 'OriginalImageMD5' },
	'originalimagesize' => { 169 => 'OriginalImageSize' },
	'originalimagewidth' => { 84 => 0xb, 129 => 0x0 },
	'originallyricist' => { 186 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 125 => 0xc68c },
	'originalrawfiledigest' => { 125 => 0xc71d },
	'originalrawfilename' => { 125 => 0xc68b },
	'originaltransmissionreference' => { 138 => 0x67 },
	'originatingprogram' => { 138 => 0x41, 518 => 'OriginatingProgram' },
	'originplatform' => { 543 => 'originPlatform' },
	'os' => { 528 => 'os' },
	'otherconditions' => { 341 => 'OtherConditions' },
	'otherconstraints' => { 341 => 'OtherConstraints' },
	'otherimage' => { 120 => 'Exif-OtherImage' },
	'otherimageinfo' => { 341 => 'OtherImageInfo' },
	'otherimagelength' => { 125 => 0x202 },
	'otherimagestart' => { 125 => 0x201 },
	'otherlicensedocuments' => { 341 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 341 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 341 => 'OtherLicenseRequirements' },
	'outcue' => { 553 => 'outCue' },
	'outcuescale' => { 553 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 553 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 207 => 0x3 },
	'outputimagewidth' => { 207 => 0x2 },
	'outputlut' => { 355 => 0xa7 },
	'outputprofile' => { 145 => 0x138b },
	'outputresolution' => { 207 => 0x4 },
	'overclockcols' => { 145 => 0x189c },
	'overclockrows' => { 145 => 0x18c4 },
	'overridelookvignette' => { 524 => 'OverrideLookVignette', 526 => 'OverrideLookVignette' },
	'owner' => { 409 => 'ownr', 557 => 'Owner' },
	'ownerid' => { 138 => 0xbc },
	'ownername' => { 15 => 0x10f, 69 => 0x9, 103 => 0x810, 125 => [0xa430,0xfde8], 163 => 'OwnerName', 521 => 'OwnerName', 531 => 'CameraOwnerName' },
	'padding' => { 125 => 0xea1c },
	'pagecount' => { 543 => 'pageCount' },
	'pageimage' => { 551 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 551 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 551 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 551 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 551 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 551 => 'PageInfo' },
	'pagename' => { 125 => 0x11d },
	'pagenumber' => { 125 => 0x129 },
	'pageprogressiondirection' => { 543 => 'pageProgressionDirection' },
	'pagerange' => { 543 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 524 => 'PaintBasedCorrections', 526 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 524 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 526 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 358 => 0x0 },
	'panasonicexifversion' => { 355 => 0x26 },
	'panasonicimageheight' => { 355 => 0x4c },
	'panasonicimagewidth' => { 355 => 0x4b },
	'panasonicrawversion' => { 360 => 0x1 },
	'panasonictitle' => { 125 => 0xc6d2 },
	'panasonictitle2' => { 125 => 0xc6d3 },
	'panoramaangle' => { 133 => 0x1153 },
	'panoramacropbottom' => { 465 => 0x7 },
	'panoramacropleft' => { 465 => 0x4 },
	'panoramacropright' => { 465 => 0x6 },
	'panoramacroptop' => { 465 => 0x5 },
	'panoramadirection' => { 77 => 0x5, 133 => 0x1154, 465 => 0x3 },
	'panoramaframeheight' => { 465 => 0x9 },
	'panoramaframenumber' => { 77 => 0x2 },
	'panoramaframewidth' => { 465 => 0x8 },
	'panoramafullheight' => { 465 => 0x2 },
	'panoramafullwidth' => { 465 => 0x1 },
	'panoramamode' => { 147 => 0x3c, 331 => 0x601 },
	'panoramasize3d' => { 447 => 0x38 },
	'panoramasourceheight' => { 465 => 0xb },
	'panoramasourcewidth' => { 465 => 0xa },
	'panoramicstitchcameramotion' => { 183 => 'PanoramicStitchCameraMotion', 184 => 0x1 },
	'panoramicstitchmaptype' => { 183 => 'PanoramicStitchMapType', 184 => 0x2 },
	'panoramicstitchphi0' => { 183 => 'PanoramicStitchPhi0', 184 => 0x5 },
	'panoramicstitchphi1' => { 183 => 'PanoramicStitchPhi1', 184 => 0x6 },
	'panoramicstitchtheta0' => { 183 => 'PanoramicStitchTheta0', 184 => 0x3 },
	'panoramicstitchtheta1' => { 183 => 'PanoramicStitchTheta1', 184 => 0x4 },
	'panoramicstitchversion' => { 184 => 0x0 },
	'pantry' => { 554 => 'Pantry' },
	'pantryinstanceid' => { 554 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 133 => 0xb211, 330 => 0x28 },
	'parameters' => { 344 => 'parameters' },
	'parametricdarks' => { 524 => 'ParametricDarks', 526 => 'ParametricDarks' },
	'parametrichighlights' => { 524 => 'ParametricHighlights', 526 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 524 => 'ParametricHighlightSplit', 526 => 'ParametricHighlightSplit' },
	'parametriclights' => { 524 => 'ParametricLights', 526 => 'ParametricLights' },
	'parametricmidtonesplit' => { 524 => 'ParametricMidtoneSplit', 526 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 524 => 'ParametricShadows', 526 => 'ParametricShadows' },
	'parametricshadowsplit' => { 524 => 'ParametricShadowSplit', 526 => 'ParametricShadowSplit' },
	'parentalrating' => { 186 => 'WM/ParentalRating' },
	'parentid' => { 538 => 'parentId' },
	'parentmediaeventid' => { 512 => 'ParentMediaEventID' },
	'parentmeid' => { 512 => 'ParentMEID' },
	'parentproductid' => { 409 => '@ppi' },
	'parentreference1' => { 536 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 536 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 409 => '@PST' },
	'parenttitle' => { 409 => '@pti' },
	'partialactivecols1' => { 145 => 0x17e8 },
	'partialactivecols2' => { 145 => 0x17f2 },
	'partialactiverows1' => { 145 => 0x17fc },
	'partialactiverows2' => { 145 => 0x1806 },
	'partofcompilation' => { 553 => 'partOfCompilation' },
	'patientbirthdate' => { 499 => 'PatientDOB' },
	'patientid' => { 499 => 'PatientID' },
	'patientname' => { 499 => 'PatientName' },
	'patientsex' => { 499 => 'PatientSex' },
	'patternareaheight' => { 145 => 0x963 },
	'patternareawidth' => { 145 => 0x962 },
	'patterncorrectionfactorscale' => { 145 => 0x969 },
	'patterncropcols1' => { 145 => 0x96c },
	'patterncropcols2' => { 145 => 0x96d },
	'patterncroprows1' => { 145 => 0x96a },
	'patterncroprows2' => { 145 => 0x96b },
	'patternimagerheight' => { 145 => 0x961 },
	'patternimagerwidth' => { 145 => 0x960 },
	'patternx' => { 145 => 0x966 },
	'patterny' => { 145 => 0x967 },
	'pdfversion' => { 540 => 'PDFVersion' },
	'pentaximagesize' => { 391 => 0x9 },
	'pentaxmodelid' => { 370 => 0x0, 391 => 0x5 },
	'pentaxmodeltype' => { 391 => 0x1 },
	'pentaxversion' => { 391 => 0x0 },
	'people' => { 502 => 'People', 516 => 'People' },
	'perchannelblacklevel' => { 44 => 0x157, 45 => 0x16b, 46 => 0x17f, 48 => 0xc4, 49 => [0x2b4,0x2cb,0x2cf], 50 => [0x108,0x14d], 51 => 0x1df, 52 => [0x1f8,0x2d8], 53 => [0x22c,0x30a], 54 => 0x149 },
	'performer' => { 409 => 'perf', 417 => 'perf' },
	'performerkeywords' => { 417 => "\xa9prk" },
	'performers' => { 417 => "\xa9prf" },
	'performerurl' => { 417 => "\xa9prl" },
	'period' => { 186 => 'WM/Period' },
	'peripheralillumcentralradius' => { 496 => 0x8030 },
	'peripheralillumcentralvalue' => { 496 => 0x8031 },
	'peripheralillumination' => { 109 => 0x20702, 115 => 0x68 },
	'peripheralilluminationcorr' => { 67 => 0x1, 380 => 0x2 },
	'peripheralilluminationon' => { 109 => '0x20702.0', 115 => 0x64 },
	'peripheralillumperiphvalue' => { 496 => 0x8032 },
	'peripherallighting' => { 84 => 0x2, 133 => 0x3804 },
	'peripherallightingsetting' => { 85 => 0x5 },
	'peripherallightingvalue' => { 84 => 0x6 },
	'permissions' => { 546 => 'permissions' },
	'permits' => { 522 => 'permits' },
	'person' => { 543 => 'person' },
	'personality' => { 512 => 'Personality' },
	'personheard' => { 538 => 'PersonHeard' },
	'personheardidentifier' => { 538 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 538 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 538 => 'PersonInImage' },
	'personinimagecharacteristic' => { 538 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 538 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 538 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 538 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 538 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 538 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 538 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 538 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 538 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 524 => 'PerspectiveAspect', 526 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 524 => 'PerspectiveHorizontal', 526 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 524 => 'PerspectiveRotate', 526 => 'PerspectiveRotate' },
	'perspectivescale' => { 524 => 'PerspectiveScale', 526 => 'PerspectiveScale' },
	'perspectiveupright' => { 524 => 'PerspectiveUpright', 526 => 'PerspectiveUpright' },
	'perspectivevertical' => { 524 => 'PerspectiveVertical', 526 => 'PerspectiveVertical' },
	'perspectivex' => { 524 => 'PerspectiveX', 526 => 'PerspectiveX' },
	'perspectivey' => { 524 => 'PerspectiveY', 526 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 98 => 0x1 },
	'pf10retainprogramshift' => { 98 => 0xb },
	'pf13drivepriority' => { 98 => 0xe },
	'pf14disablefocussearch' => { 98 => 0xf },
	'pf15disableafassistbeam' => { 98 => 0x10 },
	'pf16autofocuspointshoot' => { 98 => 0x11 },
	'pf17disableafpointsel' => { 98 => 0x12 },
	'pf18enableautoafpointsel' => { 98 => 0x13 },
	'pf19continuousshootspeed' => { 98 => 0x14 },
	'pf19shootingspeedhigh' => { 97 => 0xa },
	'pf19shootingspeedlow' => { 97 => 0x9 },
	'pf1disableshootingmodes' => { 98 => 0x2 },
	'pf1value' => { 97 => 0x1 },
	'pf20limitcontinousshots' => { 98 => 0x15 },
	'pf20maxcontinousshots' => { 97 => 0xb },
	'pf21enablequietoperation' => { 98 => 0x16 },
	'pf23felocktime' => { 97 => 0xd },
	'pf23postreleasetime' => { 97 => 0xe },
	'pf23settimerlengths' => { 98 => 0x18 },
	'pf23shutterbuttontime' => { 97 => 0xc },
	'pf24lightlcdduringbulb' => { 98 => 0x19 },
	'pf25aemode' => { 97 => 0xf },
	'pf25afmode' => { 97 => 0x12 },
	'pf25afpointsel' => { 97 => 0x13 },
	'pf25colormatrix' => { 97 => 0x17 },
	'pf25defaultclearsettings' => { 98 => 0x1a },
	'pf25drivemode' => { 97 => 0x11 },
	'pf25imagesize' => { 97 => 0x14 },
	'pf25meteringmode' => { 97 => 0x10 },
	'pf25parameters' => { 97 => 0x16 },
	'pf25wbmode' => { 97 => 0x15 },
	'pf26shortenreleaselag' => { 98 => 0x1b },
	'pf27reversedialrotation' => { 98 => 0x1c },
	'pf27value' => { 97 => 0x18 },
	'pf28noquickdialexpcomp' => { 98 => 0x1d },
	'pf29quickdialswitchoff' => { 98 => 0x1e },
	'pf2disablemeteringmodes' => { 98 => 0x3 },
	'pf2value' => { 97 => 0x2 },
	'pf30enlargementmode' => { 98 => 0x1f },
	'pf31originaldecisiondata' => { 98 => 0x20 },
	'pf3manualexposuremetering' => { 98 => 0x4 },
	'pf3value' => { 97 => 0x3 },
	'pf4exposuretimelimits' => { 98 => 0x5 },
	'pf4exposuretimemax' => { 97 => 0x5 },
	'pf4exposuretimemin' => { 97 => 0x4 },
	'pf5aperturelimits' => { 98 => 0x6 },
	'pf5aperturemax' => { 97 => 0x7 },
	'pf5aperturemin' => { 97 => 0x6 },
	'pf6presetshootingmodes' => { 98 => 0x7 },
	'pf7bracketcontinuousshoot' => { 98 => 0x8 },
	'pf8bracketshots' => { 97 => 0x8 },
	'pf8setbracketshots' => { 98 => 0x9 },
	'pf9changebracketsequence' => { 98 => 0xa },
	'phasedetectaf' => { 200 => 0x6 },
	'phonenumber' => { 164 => 'Phone' },
	'photoeffect' => { 37 => 0x28 },
	'photoeffecthistoryxml' => { 303 => 0xe9651831 },
	'photoeffects' => { 303 => 0xab5eca5e },
	'photoeffectsblue' => { 305 => 0x8 },
	'photoeffectsgreen' => { 305 => 0x6 },
	'photoeffectsred' => { 305 => 0x4 },
	'photoeffectstype' => { 305 => 0x0 },
	'photographer' => { 125 => 0xa437, 531 => 'Photographer' },
	'photographicsensitivity' => { 531 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 310 => '17.6', 319 => '33.6' },
	'photometricinterpretation' => { 125 => 0x106, 549 => 'PhotometricInterpretation' },
	'photosappfeatureflags' => { 1 => 0x1f },
	'photoshootingmenubank' => { 249 => 0x11e, 250 => 0x11e, 251 => 0x112, 252 => 0x122, 253 => 0x122, 254 => 0x126, 255 => 0x24, 273 => 0x0 },
	'photoshootingmenubankimagearea' => { 246 => 0x6dd, 249 => 0x144, 250 => 0x144, 251 => 0x134, 252 => 0x148, 253 => 0x148, 254 => 0x14c, 273 => '7.1' },
	'photoshopbgrthumbnail' => { 405 => 0x409 },
	'photoshopquality' => { 404 => 0x0 },
	'photoshopthumbnail' => { 405 => 0x40c },
	'photostyle' => { 355 => 0x89 },
	'picasawebgphotoid' => { 529 => 'picasawebGPhotoId' },
	'pick' => { 553 => 'pick' },
	'picklabel' => { 529 => 'PickLabel' },
	'pictinfo' => { 434 => 0x208 },
	'picturecontrol' => { 303 => 0xe2173c47 },
	'picturecontrolactive' => { 306 => 0x0 },
	'picturecontroladjust' => { 261 => 0x30, 262 => 0x30, 263 => 0x36 },
	'picturecontrolbase' => { 261 => 0x18, 262 => 0x18, 263 => 0x1c },
	'picturecontroldata' => { 243 => [0xbd,0x23] },
	'picturecontrolmode' => { 306 => 0x13 },
	'picturecontrolname' => { 261 => 0x4, 262 => 0x4, 263 => 0x8 },
	'picturecontrolquickadjust' => { 261 => 0x31, 262 => 0x31, 263 => 0x37 },
	'pictureeffect' => { 459 => 0x200e },
	'pictureeffect2' => { 468 => 0x1163, 469 => 0x1167, 470 => 0x1143, 471 => 0x11bf, 472 => 0x119b, 473 => 0x1053, 474 => 0x24b, 475 => 0x24b, 476 => 0x23c, 491 => 0x46 },
	'picturefinish' => { 189 => 0x71 },
	'picturemode' => { 133 => 0x1031, 331 => 0x520, 391 => [0xb,0x33], 435 => 0x3d },
	'picturemode2' => { 371 => 0x0 },
	'picturemodebwfilter' => { 331 => 0x525 },
	'picturemodecontrast' => { 331 => 0x523 },
	'picturemodeeffect' => { 331 => 0x52d },
	'picturemodehue' => { 331 => 0x522 },
	'picturemodesaturation' => { 331 => 0x521 },
	'picturemodesharpness' => { 331 => 0x524 },
	'picturemodetone' => { 331 => 0x526 },
	'pictureprofile' => { 468 => [0x115e,0x115f], 469 => [0x1162,0x1163], 470 => [0x113e,0x113f], 471 => [0x11ba,0x11bb], 472 => [0x1196,0x1197], 473 => [0x104e,0x104f], 474 => [0x246,0x247], 475 => [0x246,0x247], 476 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 79 => 0xa, 109 => 0x20301, 115 => 0x2 },
	'picturestylepc' => { 69 => 0x4009 },
	'picturestyleuserdef' => { 69 => 0x4008 },
	'picturewizard' => { 432 => 0x21 },
	'picturewizardcolor' => { 431 => 0x1 },
	'picturewizardcontrast' => { 431 => 0x4 },
	'picturewizardmode' => { 431 => 0x0 },
	'picturewizardsaturation' => { 431 => 0x2 },
	'picturewizardsharpness' => { 431 => 0x3 },
	'pipelineversion' => { 183 => 'PipelineVersion' },
	'pitch' => { 121 => 0x6, 311 => '4.1', 323 => '4.1', 417 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 66 => 0x5, 259 => 0x4, 331 => 0x904, 345 => 'PitchAngle', 355 => 0x91, 389 => 0x2, 390 => 0x5, 430 => 0x1 },
	'pitchshift' => { 408 => 'player.movie.audio.pitchshift', 411 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 410 => 'pasp' },
	'pixelclockfrequency' => { 145 => 0x40b },
	'pixelcorrectionoffset' => { 145 => 0x972 },
	'pixelcorrectionscale' => { 145 => 0x971 },
	'pixelscale' => { 125 => 0x830e },
	'pixelshiftdelay' => { 247 => 0x38c, 250 => 0x802 },
	'pixelshiftinfo' => { 459 => 0x202f },
	'pixelshiftinterval' => { 247 => 0x38e },
	'pixelshiftnumbershots' => { 247 => 0x38a, 250 => 0x800 },
	'pixelshiftoffset' => { 133 => 0x1106 },
	'pixelshiftresolution' => { 392 => 0x0 },
	'pixelshiftshooting' => { 247 => 0x388, 250 => 0x7fe },
	'pixelshiftshots' => { 133 => 0x1105 },
	'pixelsperunitx' => { 343 => 0x0 },
	'pixelsperunity' => { 343 => 0x4 },
	'pixelunits' => { 343 => 0x8 },
	'planarconfiguration' => { 125 => 0x11c, 549 => 'PlanarConfiguration' },
	'plane' => { 500 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 500 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 500 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 500 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 500 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 500 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 500 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 500 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 500 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 500 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 500 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 500 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 500 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 500 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 500 => 'Planes' },
	'planningref' => { 538 => 'PlanningRef' },
	'planningrefidentifier' => { 538 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 538 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 538 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 558 => 'PlateNames' },
	'platform' => { 543 => 'platform' },
	'playallframes' => { 417 => 'AllF' },
	'playbackbutton' => { 250 => 0x804, 253 => 0x808, 254 => 0x80c },
	'playbackbuttonplaybackmode' => { 250 => 0x80e, 253 => 0x814, 254 => 0x818 },
	'playbackflickdown' => { 326 => 0x149, 327 => 0x159, 328 => 0x159, 329 => 0x171 },
	'playbackflickup' => { 326 => 0x145, 327 => 0x155, 328 => 0x155, 329 => 0x16d },
	'playbackmenustime' => { 315 => '20.1', 316 => '21.1', 317 => '21.1' },
	'playbackmonitorofftime' => { 310 => '25.2', 311 => '36.1', 313 => '36.1', 314 => '36.1', 318 => '35.1', 319 => '8.1', 320 => '35.1', 323 => '36.1', 324 => '36.1', 325 => '21.1', 326 => 0x37, 327 => 0x33, 328 => 0x33, 329 => 0x33 },
	'playbackzoom' => { 311 => '37.1' },
	'playdisplay' => { 191 => 0x4e },
	'playerversion' => { 411 => 'player.version' },
	'playgap' => { 409 => 'pgap' },
	'playmode' => { 417 => 'SDLN' },
	'playselection' => { 417 => 'SelO' },
	'plusversion' => { 341 => 'Version' },
	'pmversion' => { 403 => 'PMVersion' },
	'pngwarning' => { 344 => 'Warning' },
	'podcast' => { 409 => 'pcst' },
	'podcasturl' => { 409 => 'purl' },
	'poilevel' => { 242 => 0x8 },
	'portraitimpressionbalance' => { 247 => 0x378, 249 => 0x26e, 250 => 0x26e, 264 => 0xa0 },
	'portraitnote' => { 504 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 115 => 0x1d },
	'portraitoutputshadowpoint' => { 115 => 0x1e },
	'portraitrawcolortone' => { 115 => 0x16 },
	'portraitrawcontrast' => { 115 => 0x18 },
	'portraitrawhighlight' => { 115 => 0x76 },
	'portraitrawhighlightpoint' => { 115 => 0x1b },
	'portraitrawlinear' => { 115 => 0x19 },
	'portraitrawsaturation' => { 115 => 0x17 },
	'portraitrawshadow' => { 115 => 0x7f },
	'portraitrawshadowpoint' => { 115 => 0x1c },
	'portraitrawsharpness' => { 115 => 0x1a },
	'portraitrefiner' => { 119 => 0x302b },
	'portraitrequest' => { 504 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 115 => 0x9a },
	'portraitunsharpmaskstrength' => { 115 => 0x98 },
	'portraitunsharpmaskthreshold' => { 115 => 0x9c },
	'portraitversion' => { 504 => 'PortraitVersion' },
	'pose' => { 500 => 'Pose' },
	'poseheadingdegrees' => { 510 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 510 => 'PosePitchDegrees' },
	'posepositionx' => { 500 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 500 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 500 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 510 => 'PoseRollDegrees' },
	'poserotationw' => { 500 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 500 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 500 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 500 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 500 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 542 => 'positionDescriptor' },
	'postalcode' => { 168 => 'PostalCode' },
	'postcropvignetteamount' => { 524 => 'PostCropVignetteAmount', 526 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 524 => 'PostCropVignetteFeather', 526 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 524 => 'PostCropVignetteHighlightContrast', 526 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 524 => 'PostCropVignetteMidpoint', 526 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 524 => 'PostCropVignetteRoundness', 526 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 524 => 'PostCropVignetteStyle', 526 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 355 => 0xbf },
	'postreleaseburstlength' => { 252 => 0x714, 253 => 0x784, 254 => 0x788, 327 => 0x289 },
	'potentialface1position' => { 455 => 0xb },
	'potentialface2position' => { 455 => 0x15 },
	'potentialface3position' => { 455 => 0x1f },
	'potentialface4position' => { 455 => 0x29 },
	'potentialface5position' => { 455 => 0x33 },
	'potentialface6position' => { 455 => 0x3d },
	'potentialface7position' => { 455 => 0x47 },
	'potentialface8position' => { 455 => 0x51 },
	'poweravailable' => { 369 => '0.2' },
	'powersource' => { 369 => '0.1' },
	'poweruptime' => { 243 => 0xb6 },
	'preaf' => { 132 => '0.2' },
	'precaptureframes' => { 336 => 0x300 },
	'predictor' => { 125 => 0x13d },
	'preflashreturnstrength' => { 281 => 0x28a },
	'prefs' => { 138 => 0xdd, 403 => 'Prefs' },
	'prereadfastresetcount' => { 145 => 0x187e },
	'prereleaseburstlength' => { 252 => 0x712, 253 => 0x782, 254 => 0x786, 327 => 0x287 },
	'preservedfilename' => { 554 => 'PreservedFileName' },
	'preservedspecimen' => { 124 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 124 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 524 => 'PresetType', 526 => 'PresetType' },
	'presetwhitebalance' => { 191 => 0x24, 496 => 0x8002 },
	'presetwhitebalanceadj' => { 496 => 0x8014 },
	'pressure' => { 125 => 0x9402, 531 => 'Pressure' },
	'previewapplicationname' => { 125 => 0xc716 },
	'previewapplicationversion' => { 125 => 0xc717 },
	'previewbutton' => { 310 => ['14.1','15.1'], 311 => '15.1', 313 => '15.1', 314 => '15.1', 319 => '29.1', 320 => '14.1', 323 => '15.1', 324 => '15.1' },
	'previewbuttonplusdials' => { 310 => ['14.2','15.2'], 311 => '15.2', 313 => '43.1', 314 => '43.1', 319 => '31.2', 323 => '43.1', 324 => '43.1' },
	'previewcolorspace' => { 125 => 0xc71a },
	'previewcropbottom' => { 402 => 0xef },
	'previewcropleft' => { 402 => 0xec },
	'previewcropright' => { 402 => 0xee },
	'previewcroptop' => { 402 => 0xed },
	'previewdate' => { 415 => 0x0 },
	'previewdatetime' => { 125 => 0xc71b },
	'previewimage' => { 119 => 0x2000, 120 => 'Exif-PreviewImage', 126 => 'PreviewImage', 128 => 0x4, 173 => 'data', 193 => 0x81, 336 => 0x280, 353 => 0x300, 409 => 'snal', 417 => 'mcvr', 459 => 0x2001 },
	'previewimageborders' => { 391 => 0x3e },
	'previewimageheight' => { 78 => 0x4, 149 => 0xfa58 },
	'previewimagelength' => { 78 => 0x2, 119 => 0x3, 125 => [0x117,0x202], 193 => 0x89, 265 => 0x202, 331 => 0x102, 336 => 0x1037, 391 => 0x3, 424 => 0x1e, 429 => 0x3, 435 => [0x1b,0x1d], 448 => 0x202 },
	'previewimagename' => { 173 => '1Name' },
	'previewimagesize' => { 119 => 0x2, 154 => 0x2, 173 => 'ImageSize', 391 => 0x2, 435 => [0x1c,0x1e], 459 => 0xb02c, 496 => 0x9012 },
	'previewimagestart' => { 78 => 0x5, 119 => 0x4, 125 => [0x111,0x201], 193 => 0x88, 265 => 0x201, 331 => 0x101, 336 => 0x1036, 391 => 0x4, 424 => 0x1c, 429 => 0x2, 435 => [0x1a,0x1c], 448 => 0x201 },
	'previewimagetype' => { 173 => '0Type' },
	'previewimagevalid' => { 331 => 0x100, 336 => 0x1035 },
	'previewimagewidth' => { 78 => 0x3, 149 => 0xfa57 },
	'previewquality' => { 78 => 0x1 },
	'previewsettingsdigest' => { 125 => 0xc719 },
	'previewsettingsname' => { 125 => 0xc718 },
	'primaryafpoint' => { 200 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 125 => 0x13f, 549 => 'PrimaryChromaticities' },
	'primaryftp' => { 512 => 'PrimaryFTP' },
	'primaryslot' => { 255 => 0x25, 273 => 0x2 },
	'printim' => { 125 => 0xc4a5 },
	'prioritysetinawb' => { 459 => 0x202b },
	'prioritysetupshutterrelease' => { 191 => 0x1d, 445 => 0x28 },
	'privatertkinfo' => { 515 => 'privateRTKInfo' },
	'processbordercolsleft' => { 145 => 0xc61 },
	'processbordercolsright' => { 145 => 0xc62 },
	'processborderrowsbottom' => { 145 => 0xc64 },
	'processborderrowstop' => { 145 => 0xc63 },
	'processingsoftware' => { 125 => 0xb },
	'processversion' => { 524 => 'ProcessVersion', 526 => 'ProcessVersion' },
	'producer' => { 186 => 'WM/Producer', 340 => 'Producer', 409 => "\xa9prd", 411 => 'producer', 417 => "\xa9prd", 540 => 'Producer' },
	'producerkeywords' => { 417 => "\xa9pdk" },
	'productcode' => { 543 => 'productCode' },
	'productid' => { 139 => 0x32, 409 => 'prID', 542 => 'productID' },
	'productidtype' => { 542 => 'productIDType' },
	'productinimage' => { 538 => 'ProductInImage' },
	'productinimagedescription' => { 538 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 538 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 538 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 538 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 370 => 0x2 },
	'productorserviceconstraints' => { 341 => 'ProductOrServiceConstraints' },
	'productversion' => { 409 => 'VERS' },
	'profession' => { 543 => 'profession' },
	'profile' => { 500 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 125 => 0xc6f4 },
	'profilecameraindices' => { 500 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 125 => 0xc6fe },
	'profiledynamicrange' => { 125 => 0xcd47 },
	'profileembedpolicy' => { 125 => 0xc6fd },
	'profilegaintablemap' => { 125 => 0xcd2d },
	'profilegaintablemap2' => { 125 => 0xcd40 },
	'profilegroupname' => { 125 => 0xcd48 },
	'profilehuesatmapdata1' => { 125 => 0xc6fa },
	'profilehuesatmapdata2' => { 125 => 0xc6fb },
	'profilehuesatmapdata3' => { 125 => 0xcd39 },
	'profilehuesatmapdims' => { 125 => 0xc6f9 },
	'profilehuesatmapencoding' => { 125 => 0xc7a3 },
	'profilelooktabledata' => { 125 => 0xc726 },
	'profilelooktabledims' => { 125 => 0xc725 },
	'profilelooktableencoding' => { 125 => 0xc7a4 },
	'profilename' => { 125 => 0xc6f8, 342 => 'iCCP-name' },
	'profiles' => { 500 => 'Profiles' },
	'profiletonecurve' => { 125 => 0xc6fc },
	'profiletype' => { 500 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 355 => 0x3c },
	'programline' => { 371 => '1.1' },
	'programmode' => { 196 => 0x5 },
	'programshift' => { 243 => 0xd },
	'programversion' => { 138 => 0x46 },
	'prohibits' => { 522 => 'prohibits' },
	'projectiontype' => { 510 => 'ProjectionType', 511 => 'ProjectionType' },
	'projectname' => { 553 => 'projectName' },
	'projectref' => { 553 => 'projectRef' },
	'projectrefpath' => { 553 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 553 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 186 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 341 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 341 => 'PropertyReleaseStatus' },
	'provider' => { 186 => 'WM/Provider' },
	'province-state' => { 138 => 0x5f },
	'publicationdate' => { 543 => 'publicationDate' },
	'publicationdatea-platform' => { 543 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 543 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 543 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 543 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 543 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 538 => 'PublicationEvent' },
	'publicationeventdate' => { 538 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 538 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 538 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 543 => 'publicationName' },
	'publisher' => { 186 => 'WM/Publisher', 409 => "\xa9pub", 411 => 'publisher', 527 => 'publisher' },
	'publishingfrequency' => { 543 => 'publishingFrequency' },
	'pulldown' => { 553 => 'pullDown' },
	'purchasedate' => { 409 => 'purd' },
	'purplehsl' => { 109 => 0x20916 },
	'pxshiftperiphedgenr' => { 496 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 496 => 0x9014 },
	'quality' => { 0 => 0x1, 37 => 0x3, 118 => 0x2, 119 => 0x3002, 133 => 0x1000, 147 => 0x9, 243 => 0x4, 292 => 0x3, 336 => 0x201, 350 => 0x300, 391 => 0x8, 398 => 0x2, 435 => 0x16, 445 => 0x56, 446 => 0x56, 447 => 0xb, 459 => [0x102,0x202e] },
	'quality2' => { 468 => 0x1170, 469 => 0x1174, 470 => 0x1150, 472 => 0x11a8, 473 => 0x1060, 474 => 0x258, 475 => 0x258, 476 => 0x247, 482 => 0x29, 483 => 0x25, 484 => 0x2a },
	'qualitybutton' => { 328 => 0x17d, 329 => 0x195 },
	'qualitybuttonplaybackmode' => { 328 => 0x1bf, 329 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 119 => 0x8 },
	'quantizationmethod' => { 140 => 0x78 },
	'quickadjust' => { 306 => 0x2a },
	'quickcontroldialinmeter' => { 90 => 0x703 },
	'quickfix' => { 303 => 0x416391c6 },
	'quickshot' => { 434 => 0x213 },
	'quiettime' => { 145 => 0x188a },
	'radialdistortioncoefficient1' => { 218 => 0x14 },
	'radialdistortioncoefficient2' => { 218 => 0x1c },
	'radialdistortioncoefficient3' => { 218 => 0x24 },
	'rads' => { 417 => 'rads' },
	'rangefinder' => { 315 => '4.1', 316 => '5.1', 317 => '5.1' },
	'rangemask' => { 524 => 'RangeMaskMapInfo', 526 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 524 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 526 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 524 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 526 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 524 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 526 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 524 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 526 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 524 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 526 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 524 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 526 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 138 => 0x7d },
	'rating' => { 109 => 0x10100, 125 => 0x4746, 133 => 0x1431, 402 => 0xdf, 409 => 'rtng', 417 => 'rtng', 459 => 0x2002, 518 => 'rating', 528 => 'rating', 538 => 'Rating', 543 => 'rating', 551 => 'Rating' },
	'ratingpercent' => { 125 => 0x4749, 185 => 'Rating', 409 => 'rate', 551 => 'RatingPercent' },
	'ratingregion' => { 538 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 538 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 538 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 538 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 538 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpsaltituderef' => { 538 => [\'Rating','RatingRatingRegionGPSAltitudeRef'] },
	'ratingregiongpslatitude' => { 538 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 538 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 538 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 538 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 538 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 538 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 538 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 538 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 538 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 538 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 538 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 538 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 538 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 88 => 0x8, 193 => 0x109, 371 => 0xd },
	'rawbrightnessadj' => { 109 => 0x20001, 114 => 0x38 },
	'rawburstimagecount' => { 80 => 0x2 },
	'rawburstimagenum' => { 80 => 0x1 },
	'rawcoloradj' => { 114 => 0x2e },
	'rawcropbottom' => { 402 => 0xd4 },
	'rawcropleft' => { 402 => 0xd1 },
	'rawcropright' => { 402 => 0xd3 },
	'rawcroptop' => { 402 => 0xd2 },
	'rawcustomsaturation' => { 114 => 0x30 },
	'rawcustomtone' => { 114 => 0x34 },
	'rawdata' => { 432 => 0xa048 },
	'rawdatabyteorder' => { 432 => 0x40 },
	'rawdatacfapattern' => { 432 => 0x50 },
	'rawdatauniqueid' => { 125 => 0xc65d },
	'rawdepth' => { 195 => 0x10 },
	'rawdevartfilter' => { 338 => 0x121 },
	'rawdevautogradation' => { 338 => 0x119 },
	'rawdevcolorspace' => { 337 => 0x108, 338 => 0x109 },
	'rawdevcontrastvalue' => { 337 => 0x106, 338 => 0x105 },
	'rawdeveditstatus' => { 337 => 0x10b },
	'rawdevelopingsoftware' => { 125 => 0xa43a, 531 => 'RAWDevelopingSoftware' },
	'rawdevelopmentprocess' => { 391 => 0x62 },
	'rawdevengine' => { 337 => 0x109, 338 => 0x10b },
	'rawdevexposurebiasvalue' => { 337 => 0x100, 338 => 0x100 },
	'rawdevgradation' => { 338 => 0x112 },
	'rawdevgraypoint' => { 337 => 0x103, 338 => 0x104 },
	'rawdevmemorycoloremphasis' => { 337 => 0x105, 338 => 0x108 },
	'rawdevnoisereduction' => { 337 => 0x10a, 338 => 0x10a },
	'rawdevpicturemode' => { 338 => 0x10c },
	'rawdevpm_bwfilter' => { 338 => 0x110 },
	'rawdevpmcontrast' => { 338 => 0x10e },
	'rawdevpmnoisefilter' => { 338 => 0x120 },
	'rawdevpmpicturetone' => { 338 => 0x111 },
	'rawdevpmsaturation' => { 338 => 0x10d },
	'rawdevpmsharpness' => { 338 => 0x10f },
	'rawdevsaturation3' => { 338 => 0x113 },
	'rawdevsaturationemphasis' => { 337 => 0x104, 338 => 0x107 },
	'rawdevsettings' => { 337 => 0x10c },
	'rawdevsharpnessvalue' => { 337 => 0x107, 338 => 0x106 },
	'rawdevversion' => { 337 => 0x0, 338 => 0x0 },
	'rawdevwbfineadjustment' => { 337 => 0x102, 338 => 0x103 },
	'rawdevwhitebalance' => { 338 => 0x101 },
	'rawdevwhitebalancevalue' => { 337 => 0x101, 338 => 0x102 },
	'rawfile' => { 125 => 0xfe4c },
	'rawfilename' => { 524 => 'RawFileName', 526 => 'RawFileName' },
	'rawfiletype' => { 459 => 0x2029 },
	'rawformat' => { 360 => 0x2d, 400 => 0x10e },
	'rawimagecenter' => { 243 => 0x99 },
	'rawimagedigest' => { 125 => 0xc71c },
	'rawimagesize' => { 391 => 0x39 },
	'rawinfoversion' => { 339 => 0x0 },
	'rawjpgheight' => { 105 => 0x4 },
	'rawjpgquality' => { 61 => 0x6, 105 => 0x1 },
	'rawjpgsize' => { 61 => 0x7, 105 => 0x2 },
	'rawjpgwidth' => { 105 => 0x3 },
	'rawmeasuredrggb' => { 47 => 0x26a, 49 => 0x280, 51 => 0x194, 52 => [0x1ad,0x26b] },
	'rawrppused' => { 518 => 'rawrppused' },
	'rawtopreviewgain' => { 125 => 0xc7a8 },
	'readouttypeactual' => { 145 => 0x1903 },
	'readouttyperequested' => { 145 => 0x1902 },
	'reardisplay' => { 310 => '12.3', 311 => '6.2' },
	'recdevice' => { 538 => 'RecDevice' },
	'recdeviceattlensdescription' => { 538 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 538 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 538 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 538 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 538 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 545 => 'recipeEndingPage' },
	'recipepagerange' => { 545 => 'recipePageRange' },
	'recipesource' => { 545 => 'recipeSource' },
	'recipestartingpage' => { 545 => 'recipeStartingPage' },
	'recipetitle' => { 545 => 'recipeTitle' },
	'recognizedface1age' => { 348 => 0x20 },
	'recognizedface1name' => { 348 => 0x4 },
	'recognizedface1position' => { 348 => 0x18 },
	'recognizedface2age' => { 348 => 0x50 },
	'recognizedface2name' => { 348 => 0x34 },
	'recognizedface2position' => { 348 => 0x48 },
	'recognizedface3age' => { 348 => 0x80 },
	'recognizedface3name' => { 348 => 0x64 },
	'recognizedface3position' => { 348 => 0x78 },
	'recognizedfaceflags' => { 355 => 0x63 },
	'recommendedexposureindex' => { 125 => 0x8832, 531 => 'RecommendedExposureIndex' },
	'record' => { 124 => 'Record' },
	'recordbasisofrecord' => { 124 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 124 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 124 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 124 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 124 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 124 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 191 => 0x4d },
	'recorddynamicproperties' => { 124 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 103 => 0x1804 },
	'recordinformationwithheld' => { 124 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 417 => "\xa9phg" },
	'recordingformat' => { 425 => 0x1000 },
	'recordingmode' => { 118 => 0x1, 398 => 0x1 },
	'recordinstitutioncode' => { 124 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 124 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 417 => "\xa9lab" },
	'recordlabelurl' => { 417 => "\xa9lal" },
	'recordlocationdata' => { 251 => 0x660, 252 => 0x690, 253 => 0x6f8, 254 => 0x6fc },
	'recordmode' => { 37 => 0x9, 119 => 0x3000 },
	'recordownerinstitutioncode' => { 124 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 434 => 0x217 },
	'redbalance' => { 336 => 0x1017, 360 => 0x11, 391 => 0x1c },
	'redcurvelimits' => { 114 => 0x18a },
	'redcurvepoints' => { 113 => 0x2d, 114 => 0x160 },
	'redeyecorrection' => { 307 => 0x0 },
	'redeyeinfo' => { 524 => 'RedEyeInfo', 526 => 'RedEyeInfo' },
	'redeyereduction' => { 191 => 0x41, 445 => 0x6a, 447 => 0x28 },
	'redeyeremoval' => { 355 => 0xb9 },
	'redhsl' => { 109 => 0x20910 },
	'redhue' => { 524 => 'RedHue', 526 => 'RedHue' },
	'redsaturation' => { 524 => 'RedSaturation', 526 => 'RedSaturation' },
	'reductionmatrix1' => { 125 => 0xc625 },
	'reductionmatrix2' => { 125 => 0xc626 },
	'reductionmatrix3' => { 125 => 0xcd3a },
	'reelname' => { 125 => 0xc789, 417 => 'reel' },
	'reference1' => { 536 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 536 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 125 => 0x214, 549 => 'ReferenceBlackWhite' },
	'referencedate' => { 138 => 0x2f },
	'referencenumber' => { 138 => 0x32 },
	'references' => { 164 => 'References' },
	'referenceservice' => { 138 => 0x2d },
	'regionappliedtodimensions' => { 179 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 179 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 179 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 179 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 179 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 179 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 179 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 179 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 179 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 179 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 179 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 179 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 341 => 'RegionConstraints' },
	'regiondescription' => { 179 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 179 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 179 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 179 => 'Regions' },
	'regioninfoacdsee' => { 497 => 'Regions' },
	'regioninfodateregionsvalid' => { 182 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 182 => 'RegionInfo' },
	'regioninforegions' => { 182 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 179 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 179 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 182 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 182 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 182 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 182 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 182 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 179 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 179 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 179 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 538 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 538 => 'RegistryId' },
	'registryitemid' => { 538 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 538 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 162 => 'data' },
	'relatedaudiofilename' => { 162 => '1Name' },
	'relatedaudiofiletype' => { 162 => '0Type' },
	'relatedimagefileformat' => { 125 => 0x1000 },
	'relatedimageheight' => { 125 => 0x1002 },
	'relatedimagewidth' => { 125 => 0x1001 },
	'relatedresourceid' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 125 => 0xa004, 530 => 'RelatedSoundFile' },
	'relatedvideofile' => { 176 => 'data' },
	'relatedvideofilename' => { 176 => '1Name' },
	'relatedvideofiletype' => { 176 => '0Type' },
	'relation' => { 527 => 'relation' },
	'relationshipaccordingto' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 122 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 553 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 553 => 'relativeTimestamp' },
	'relativetimestampscale' => { 553 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 553 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 310 => '17.8', 311 => '18.5', 313 => '18.4', 314 => '18.4', 319 => '33.8', 320 => '17.6', 323 => '18.5', 324 => '18.4' },
	'releasedate' => { 138 => 0x1e, 409 => 'rldt', 518 => 'ReleaseDate', 553 => 'releaseDate' },
	'releasemode' => { 119 => 0x3001, 248 => 0x5c, 283 => 0x184d, 459 => 0xb049 },
	'releasemode2' => { 468 => 0x112c, 469 => [0x112c,0x8], 470 => [0x1108,0x8], 471 => [0x1184,0x8], 472 => [0x1160,0x8], 473 => [0x4,0x1018], 474 => [0x4,0x210], 475 => [0x4,0x210], 476 => [0x4,0x208], 478 => [0x67,0x3f], 479 => [0x6b,0x6d,0x73,0x4b], 480 => [0x6b,0x4b], 481 => 0x1f, 482 => 0x10, 483 => 0x10, 484 => 0x9, 491 => 0x34 },
	'releasemode3' => { 468 => 0x1128, 469 => 0x1128, 470 => 0x1104, 471 => 0x1180, 472 => 0x115c, 473 => 0x1014, 474 => 0x20c, 475 => 0x20c, 476 => 0x204 },
	'releaseready' => { 538 => 'ReleaseReady' },
	'releasesetting' => { 103 => 0x1016 },
	'releasetime' => { 138 => 0x23, 518 => 'ReleaseTime' },
	'remoteonduration' => { 312 => '3.4', 315 => '17.2', 316 => '18.2', 317 => '18.2', 318 => '18.2', 320 => '18.2', 321 => '4.3', 325 => '19.2' },
	'renditionclass' => { 554 => 'RenditionClass' },
	'renditionof' => { 554 => 'RenditionOf' },
	'renditionofalternatepaths' => { 554 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 554 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 554 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 554 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 554 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 554 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 554 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 554 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 554 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 554 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 554 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 554 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 554 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 554 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 554 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 554 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 554 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 554 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 554 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 554 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 554 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 554 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 554 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 554 => 'RenditionParams' },
	'repeatingflashcount' => { 221 => 0xd, 222 => 0xe, 223 => 0xe, 224 => 0xe, 225 => 0xe, 226 => 0xe, 319 => '17.2', 320 => '24.2', 321 => '9.2', 322 => '24.2', 325 => '25.2' },
	'repeatingflashcountbuilt-in' => { 290 => 0x4db },
	'repeatingflashcountexternal' => { 290 => 0x4c3 },
	'repeatingflashoutput' => { 319 => '17.1', 320 => '24.1', 321 => '9.1', 322 => '24.1', 325 => '25.1' },
	'repeatingflashoutputexternal' => { 290 => 0x4c0 },
	'repeatingflashrate' => { 221 => 0xc, 222 => 0xd, 223 => 0xd, 224 => 0xd, 225 => 0xd, 226 => 0xd, 319 => '18.1', 320 => '25.1', 321 => '10.1', 322 => '25.1', 325 => '26.1' },
	'repeatingflashratebuilt-in' => { 290 => 0x4da },
	'repeatingflashrateexternal' => { 290 => 0x4c2 },
	'requirements' => { 417 => "\xa9req" },
	'requires' => { 522 => 'requires' },
	'resampleparams' => { 553 => 'resampleParams' },
	'resampleparamsquality' => { 553 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 145 => 0xe50 },
	'resamplingkerneldenominators067' => { 145 => 0xe4f },
	'resamplingkerneldenominators100' => { 145 => 0xe51 },
	'resaved' => { 434 => 0x21e },
	'resetblacksegrows' => { 145 => 0x181a },
	'resolution' => { 169 => 'Resolution' },
	'resolutionmode' => { 435 => [0x87,0x4] },
	'resolutionunit' => { 125 => 0x128, 141 => 0x2, 549 => 'ResolutionUnit' },
	'resourceid' => { 124 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 124 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 124 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 90 => 0x612 },
	'restrictions' => { 546 => 'restrictions' },
	'retouchareafeather' => { 524 => [\'RetouchAreas','RetouchAreasFeather'], 526 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 524 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 526 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 524 => [\'RetouchAreas','RetouchAreasMasksAngle'], 526 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 524 => [\'RetouchAreas','RetouchAreasMasksBottom'], 526 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 524 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 526 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 524 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 526 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 524 => [\'RetouchAreas','RetouchAreasMasksDabs'], 526 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 524 => [\'RetouchAreas','RetouchAreasMasksFeather'], 526 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 524 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 526 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 524 => [\'RetouchAreas','RetouchAreasMasksFlow'], 526 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 524 => [\'RetouchAreas','RetouchAreasMasksFullX'], 526 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 524 => [\'RetouchAreas','RetouchAreasMasksFullY'], 526 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 524 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 526 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 524 => [\'RetouchAreas','RetouchAreasMasksLeft'], 526 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 524 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 526 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 524 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 526 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 524 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 526 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 524 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 526 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 524 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 526 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasks'], 526 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 524 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 526 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 524 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 526 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 524 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 526 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 524 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 526 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 524 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 526 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 524 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 526 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 524 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 526 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 524 => [\'RetouchAreas','RetouchAreasMasksRadius'], 526 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 524 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 526 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 524 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 526 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 524 => [\'RetouchAreas','RetouchAreasMasksRight'], 526 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 524 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 526 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 524 => [\'RetouchAreas','RetouchAreasMasks'], 526 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 524 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 526 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 524 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 526 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 524 => [\'RetouchAreas','RetouchAreasMasksTop'], 526 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 524 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 526 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 524 => [\'RetouchAreas','RetouchAreasMasksVersion'], 526 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 524 => [\'RetouchAreas','RetouchAreasMasksWhat'], 526 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 524 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 526 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 524 => [\'RetouchAreas','RetouchAreasMasksX'], 526 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 524 => [\'RetouchAreas','RetouchAreasMasksY'], 526 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 524 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 526 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 524 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 526 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 524 => [\'RetouchAreas','RetouchAreasMethod'], 526 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 524 => [\'RetouchAreas','RetouchAreasOffsetY'], 526 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 524 => [\'RetouchAreas','RetouchAreasOpacity'], 526 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 524 => 'RetouchAreas', 526 => 'RetouchAreas' },
	'retouchareaseed' => { 524 => [\'RetouchAreas','RetouchAreasSeed'], 526 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 524 => [\'RetouchAreas','RetouchAreasSourceState'], 526 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 524 => [\'RetouchAreas','RetouchAreasSourceX'], 526 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 524 => [\'RetouchAreas','RetouchAreasSpotType'], 526 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 243 => 0x9e },
	'retouchinfo' => { 524 => 'RetouchInfo', 526 => 'RetouchInfo' },
	'retouchnefprocessing' => { 267 => 0x5 },
	'retractlensonpoweroff' => { 90 => 0x814 },
	'reuse' => { 341 => 'Reuse' },
	'reuseallowed' => { 556 => 'ReuseAllowed' },
	'reuseprohibited' => { 546 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 317 => '5.2' },
	'reversefocusring' => { 327 => 0x163, 328 => 0x163, 329 => 0x17b },
	'reverseindicators' => { 310 => '12.1', 311 => '6.1', 313 => '6.1', 314 => '6.1', 315 => '4.3', 316 => '5.2', 317 => '5.4', 319 => '33.5', 320 => '5.1', 323 => '6.1', 324 => '6.1', 325 => '6.2', 326 => 0xc5, 327 => 0xc1, 328 => 0xc1, 329 => 0xc1 },
	'reverseshutterspeedaperture' => { 317 => '5.3' },
	'revision' => { 528 => 'revision' },
	'rflensmffocusringsensitivity' => { 90 => 0x714 },
	'rflenstype' => { 61 => 0x3d },
	'rgbcurvelimits' => { 114 => 0x238 },
	'rgbcurvepoints' => { 113 => 0x7, 114 => 0x20e },
	'rgbtables' => { 125 => 0xcd3f },
	'richtextcomment' => { 533 => 'RichTextComment' },
	'ricohdate' => { 424 => 0x6 },
	'ricohimageheight' => { 424 => 0x2 },
	'ricohimagewidth' => { 424 => 0x0 },
	'rightalbedo' => { 514 => 'RightAlbedo' },
	'rightascension' => { 172 => 'RightAscension' },
	'rights' => { 527 => 'rights' },
	'rightsagent' => { 546 => 'rightsAgent' },
	'rightsowner' => { 546 => 'rightsOwner' },
	'roll' => { 121 => 0x8, 417 => ['roll',"\xa9frl"] },
	'rollangle' => { 66 => 0x4, 133 => 0x144d, 259 => 0x0, 331 => 0x903, 345 => 'RollAngle', 355 => 0x90, 389 => 0x1, 390 => 0x3, 430 => 0x2 },
	'romoperationmode' => { 103 => 0x80d },
	'rotation' => { 31 => 0x17, 32 => 0x18, 102 => 0x3, 109 => 0x10002, 114 => 0x26e, 120 => 'QuickTime-Rotation', 129 => 0x4, 172 => 'Rotation', 189 => [0x65,0x50], 190 => 0x46, 191 => 0x5a, 194 => 0x10, 268 => 0x1a, 283 => 0x3693, 289 => '590.1', 303 => 0x76a43207, 355 => 0x30, 371 => '17.2', 402 => 0xd8, 410 => 'irot', 445 => 0x3f, 446 => 0x3f, 456 => 0x10 },
	'routedto' => { 532 => 'RoutedTo' },
	'routing' => { 407 => 'Routing' },
	'routingdestinations' => { 512 => 'RoutingDestinations' },
	'routingexclusions' => { 512 => 'RoutingExclusions' },
	'routingnotes' => { 532 => 'RoutingNotes' },
	'rowsperstrip' => { 125 => 0x116 },
	'rpp' => { 518 => 'rpp' },
	'rtkflag' => { 122 => 'RtkFlag' },
	'rtkstdhgt' => { 122 => 'RtkStdHgt' },
	'rtkstdlat' => { 122 => 'RtkStdLat' },
	'rtkstdlon' => { 122 => 'RtkStdLon' },
	'safetyshift' => { 90 => 0x108 },
	'safetyshiftinavortv' => { 88 => 0x10, 89 => 0x10, 91 => 0xf, 92 => 0x10, 95 => 0x10 },
	'sameexposurefornewaperture' => { 90 => 0x112 },
	'samplebits' => { 162 => 'SampleBits' },
	'samplepagerange' => { 543 => 'samplePageRange' },
	'samplerate' => { 162 => 'SampleRate' },
	'samplesperpixel' => { 125 => 0x115, 360 => 0x8, 549 => 'SamplesPerPixel' },
	'samplestructure' => { 140 => 0x5a },
	'samsungmodelid' => { 432 => 0x3 },
	'sanyoquality' => { 434 => 0x201 },
	'sanyothumbnail' => { 434 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 37 => 0xe, 55 => 0x1, 68 => 0x7, 118 => 0xd, 119 => [0x3013,0x1f], 125 => [0xa409,0xfe55], 133 => 0x1003, 163 => 'Saturation', 188 => 0x1f, 189 => 0x32, 190 => 0x28, 191 => 0x1a, 196 => 0x1, 243 => 0xaa, 261 => 0x35, 262 => 0x3b, 263 => 0x43, 355 => 0x40, 357 => 0x300d, 391 => 0x1f, 398 => 0xd, 419 => 0x27, 421 => 0x58, 424 => 0x28, 425 => 0x1013, 435 => 0x10, 445 => 0x1e, 446 => 0x1b, 459 => 0x2005, 524 => 'Saturation', 526 => 'Saturation', 530 => 'Saturation' },
	'saturationadj' => { 109 => 0x20901, 114 => 0x116, 243 => 0x94, 302 => 0x1, 306 => 0x2e, 496 => 0x8016 },
	'saturationadjustmentaqua' => { 524 => 'SaturationAdjustmentAqua', 526 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 524 => 'SaturationAdjustmentBlue', 526 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 524 => 'SaturationAdjustmentGreen', 526 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 524 => 'SaturationAdjustmentMagenta', 526 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 524 => 'SaturationAdjustmentOrange', 526 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 524 => 'SaturationAdjustmentPurple', 526 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 524 => 'SaturationAdjustmentRed', 526 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 524 => 'SaturationAdjustmentYellow', 526 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 76 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 75 => 0x68, 76 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 75 => 0x38, 76 => 0x38 },
	'saturationmonochrome' => { 75 => 0x80, 76 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 75 => 0x50, 76 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 75 => 0x20, 76 => 0x20 },
	'saturationsetting' => { 339 => 0x1010, 447 => 0x11, 464 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 75 => 0x8, 76 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 75 => 0x98, 76 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 75 => 0xb0, 76 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 75 => 0xc8, 76 => 0xe0 },
	'savefocusposition' => { 247 => 0x9b0 },
	'saveid' => { 554 => 'SaveID' },
	'sbaanalysiscomplete' => { 145 => 0xc35 },
	'sbablack' => { 145 => 0xc25 },
	'sbagmoffset' => { 145 => 0xc4a },
	'sbagray' => { 145 => 0xc26 },
	'sbagreenmagentabal' => { 145 => 0xc33 },
	'sbahighgray' => { 145 => 0xc46 },
	'sbailloffset' => { 145 => 0xc49 },
	'sbailluminantbal' => { 145 => 0xc34 },
	'sbalowgray' => { 145 => 0xc47 },
	'sbaneutralbal' => { 145 => 0xc32 },
	'sbawhite' => { 145 => 0xc27 },
	'scaletype' => { 553 => 'scaleType' },
	'scalingfactorheight' => { 345 => 'ScalingFactorHeight' },
	'scanimageenhancer' => { 269 => 0x60 },
	'scanningdirection' => { 140 => 0x64 },
	'scene' => { 417 => 'scen', 537 => 'Scene', 553 => 'scene' },
	'scenearea' => { 334 => 0x211, 336 => 0x1031 },
	'sceneassist' => { 243 => 0x9c },
	'scenecapturetype' => { 125 => 0xa406, 530 => 'SceneCaptureType' },
	'scenedetect' => { 334 => 0x210, 336 => 0x1030 },
	'scenedetectdata' => { 334 => 0x212, 336 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 149 => 0xfa02, 193 => 0x100, 243 => 0x8f, 331 => 0x509, 336 => 0x403, 355 => 0x8001, 364 => 0xf, 459 => 0xb023 },
	'scenemodeused' => { 151 => [0x6002,0xf002] },
	'scenerecognition' => { 133 => 0x1425 },
	'scenereferred' => { 534 => 'scene_referred' },
	'sceneselect' => { 434 => 0x21f },
	'scenetype' => { 125 => 0xa301, 530 => 'SceneType' },
	'screentips' => { 310 => '12.7', 311 => '5.3', 319 => '13.1', 320 => '4.4', 323 => '5.4', 325 => '5.1' },
	'scriptversion' => { 145 => 0x1770 },
	'sdrblend' => { 524 => 'SDRBlend', 526 => 'SDRBlend' },
	'sdrbrightness' => { 524 => 'SDRBrightness', 526 => 'SDRBrightness' },
	'sdrcontrast' => { 524 => 'SDRContrast', 526 => 'SDRContrast' },
	'sdrhighlights' => { 524 => 'SDRHighlights', 526 => 'SDRHighlights' },
	'sdrshadows' => { 524 => 'SDRShadows', 526 => 'SDRShadows' },
	'sdrwhites' => { 524 => 'SDRWhites', 526 => 'SDRWhites' },
	'seal' => { 125 => 0xcea1 },
	'season' => { 538 => 'Season', 542 => 'season' },
	'seasonidentifier' => { 538 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 538 => [\'Season','SeasonName'] },
	'seasonnumber' => { 538 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 512 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 247 => 0x35a, 249 => 0x240, 250 => 0x240, 251 => 0x22c, 252 => 0x240, 253 => 0x240, 254 => 0x244, 272 => 0x13c, 283 => 0x1d0 },
	'section' => { 543 => 'section' },
	'securityclassification' => { 125 => 0x9212 },
	'selectableafpoint' => { 90 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 90 => 0x512 },
	'selfdata' => { 122 => 'SelfData' },
	'selftimer' => { 37 => 0x2, 355 => 0x2e, 434 => 0x214, 468 => 0x1134, 469 => 0x1134, 470 => 0x1110, 471 => 0x118c, 472 => 0x1168, 473 => 0x1020, 474 => 0x218, 475 => 0x218, 476 => 0x210 },
	'selftimer2' => { 82 => 0x1d },
	'selftimerinterval' => { 320 => '19.2' },
	'selftimermode' => { 125 => 0x882b },
	'selftimershotcount' => { 311 => '20.2', 313 => '20.3', 314 => '20.3', 315 => '18.2', 316 => '19.2', 317 => '19.2', 318 => '19.3', 320 => '19.3', 323 => '20.3', 324 => '20.3', 325 => '20.2', 326 => 0x31, 327 => 0x2d, 328 => 0x2d, 329 => 0x2d },
	'selftimershotinterval' => { 311 => '20.3', 313 => '20.2', 314 => '20.2', 318 => '19.2', 323 => '20.2', 324 => '20.2', 326 => 0x35, 327 => 0x31, 328 => 0x31, 329 => 0x31 },
	'selftimertime' => { 103 => 0x1806, 191 => 0x1f, 310 => '18.1', 311 => '20.1', 312 => '3.3', 313 => '20.1', 314 => '20.1', 315 => '18.1', 316 => '19.1', 317 => '19.1', 318 => '19.1', 319 => '7.2', 320 => '19.1', 321 => '3.3', 323 => '20.1', 324 => '20.1', 325 => '20.1', 326 => 0x2d, 327 => 0x2b, 328 => 0x2b, 329 => 0x2b },
	'sellingagency' => { 543 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 125 => 0x8546 },
	'sensingmethod' => { 125 => 0xa217, 530 => 'SensingMethod' },
	'sensitivityadjust' => { 391 => 0x40 },
	'sensitivitysteps' => { 371 => ['14.3','17.4'], 373 => 0x1 },
	'sensitivitytype' => { 125 => 0x8830, 531 => 'SensitivityType' },
	'sensor' => { 198 => 0x665e },
	'sensorarea' => { 336 => 0x400 },
	'sensorareas' => { 432 => 0xa010 },
	'sensorbitdepth' => { 357 => 0x312d },
	'sensorbluelevel' => { 79 => 0x5 },
	'sensorcalibration' => { 335 => 0x805 },
	'sensorcleaning' => { 96 => 0xd },
	'sensorfullheight' => { 144 => 0xf904 },
	'sensorfullwidth' => { 144 => 0xf903 },
	'sensorheight' => { 144 => 0xf901, 149 => 0xfa21, 195 => 0x8, 357 => 0x312c, 400 => 0x109, 425 => 0x1602 },
	'sensorimageheight' => { 145 => 0x3ee },
	'sensorimagewidth' => { 145 => 0x3ed },
	'sensorleftborder' => { 145 => 0x3eb },
	'sensorleftmargin' => { 400 => 0x10a },
	'sensorpixelsize' => { 243 => 0x9a },
	'sensorredlevel' => { 79 => 0x4 },
	'sensorserialnumber' => { 145 => 0x9ce },
	'sensorshield' => { 249 => 0x76b, 250 => 0x77b, 251 => 0x66d, 252 => 0x69d, 253 => 0x705, 254 => 0x709 },
	'sensorsize' => { 163 => 'SensorSize', 391 => 0x35 },
	'sensortemperature' => { 334 => 0x1500, 336 => 0x1007, 396 => 0xc, 400 => 0x210, 435 => [0x39,0x55] },
	'sensortemperature2' => { 396 => 0xe, 400 => 0x211 },
	'sensortopborder' => { 145 => 0x3ec },
	'sensortopmargin' => { 400 => 0x10b },
	'sensortype' => { 355 => 0xca },
	'sensorwidth' => { 144 => 0xf900, 149 => 0xfa20, 195 => 0xa, 357 => 0x312b, 400 => 0x108, 425 => 0x1601 },
	'sequence' => { 419 => 0x7, 420 => 0x35, 421 => 0x36 },
	'sequencefilenumber' => { 469 => 0x4, 470 => 0x4, 471 => 0x4, 472 => 0x4, 482 => 0xc, 483 => 0xc, 484 => 0x1a },
	'sequenceimagenumber' => { 469 => 0x0, 470 => 0x0, 471 => 0x0, 472 => 0x0, 482 => 0x8, 483 => 0x8, 484 => 0x12, 491 => 0x24 },
	'sequencelength' => { 482 => 0x22, 483 => 0x1e, 484 => [0x16,0x1e] },
	'sequencename' => { 542 => 'sequenceName' },
	'sequencenumber' => { 82 => 0x9, 119 => 0x301c, 133 => 0x1101, 147 => 0x1d, 290 => 0x51c, 355 => 0x2b, 447 => [0x10c,0x30c], 459 => 0xb04a, 542 => 'sequenceNumber' },
	'sequenceshotinterval' => { 434 => 0x224 },
	'sequencetotalnumber' => { 542 => 'sequenceTotalNumber' },
	'sequentialshot' => { 434 => 0x20e },
	'serialnumber' => { 69 => 0xc, 103 => 0x180b, 125 => [0xa431,0xfde9], 144 => 0xfa04, 146 => 0xfa00, 148 => 0xc354, 149 => 0xfa19, 160 => 0x0, 163 => 'SerialNumber', 198 => 0x5501, 243 => [0xa0,0x1d], 332 => 0x101, 336 => [0x404,0x101a], 350 => 0x303, 352 => 0x305, 357 => 0x3103, 391 => 0x229, 400 => 0x102, 401 => 0x407, 417 => ['SNum','slno'], 419 => 0x15, 420 => 0x4b, 421 => 0x7e, 425 => 0x5, 432 => 0xa002, 435 => 0x2, 459 => 0x2031, 521 => 'SerialNumber', 531 => 'BodySerialNumber' },
	'serialnumberformat' => { 69 => 0x15, 103 => 0x183b },
	'serialnumberhash' => { 417 => 'CAME' },
	'series' => { 538 => 'Series' },
	'seriesdatetime' => { 499 => 'SeriesDateTime' },
	'seriesdescription' => { 499 => 'SeriesDescription' },
	'seriesidentifier' => { 538 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 499 => 'SeriesModality' },
	'seriesname' => { 538 => [\'Series','SeriesName'] },
	'seriesnumber' => { 499 => 'SeriesNumber', 543 => 'seriesNumber' },
	'seriestitle' => { 543 => 'seriesTitle' },
	'serviceidentifier' => { 139 => 0x1e },
	'servingsize' => { 545 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 93 => 0x0, 94 => 0x0 },
	'setbuttonwhenshooting' => { 88 => 0x1, 90 => 0x704, 96 => 0xc },
	'setclockfromlocationdata' => { 251 => 0x61d, 252 => 0x64d, 253 => 0x6b5, 254 => 0x6b9 },
	'setfunctionwhenshooting' => { 91 => 0x0, 92 => 0x1, 95 => 0x1 },
	'setting' => { 542 => 'setting' },
	'shadingcompensation' => { 331 => 0x50c, 355 => 0x8a },
	'shadingcompensation2' => { 335 => 0x1012 },
	'shadow' => { 435 => 0xe },
	'shadowadj' => { 109 => 0x2030b },
	'shadowcorrection' => { 391 => 0x79 },
	'shadowprotection' => { 302 => 0x0 },
	'shadows' => { 125 => 0xfe52, 459 => 0x2032, 517 => 'Shadows', 524 => 'Shadows', 526 => 'Shadows' },
	'shadows2012' => { 524 => 'Shadows2012', 526 => 'Shadows2012' },
	'shadowsadj' => { 496 => 0x901a },
	'shadowscale' => { 125 => 0xc633 },
	'shadowtint' => { 524 => 'ShadowTint', 526 => 'ShadowTint' },
	'shadowtone' => { 133 => 0x1040 },
	'shakereduction' => { 393 => 0x1, 394 => 0x1 },
	'shareduserrating' => { 186 => 'WM/SharedUserRating' },
	'sharpendetail' => { 524 => 'SharpenDetail', 526 => 'SharpenDetail' },
	'sharpenedgemasking' => { 524 => 'SharpenEdgeMasking', 526 => 'SharpenEdgeMasking' },
	'sharpening' => { 357 => 0x300b },
	'sharpeningadj' => { 306 => 0x2b },
	'sharpeningkernel' => { 145 => 0x92f },
	'sharpenradius' => { 524 => 'SharpenRadius', 526 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 37 => 0xf, 68 => 0x6, 79 => 0x2, 118 => 0xb, 119 => [0x3011,0x21], 125 => [0xa40a,0xfe56], 133 => 0x1001, 147 => 0x6b, 156 => 0x37, 163 => 'Sharpness', 188 => 0x21, 189 => 0x30, 190 => 0x26, 191 => 0x18, 196 => 0x3, 243 => 0x6, 261 => 0x32, 262 => 0x33, 263 => 0x39, 336 => 0x100f, 355 => 0x41, 391 => 0x21, 398 => 0xb, 419 => 0x26, 421 => 0x56, 424 => 0x22, 425 => [0x1003,0x1014], 435 => 0x11, 445 => 0x1c, 446 => 0x19, 459 => 0x2006, 491 => 0x52, 524 => 'Sharpness', 526 => 'Sharpness', 530 => 'Sharpness' },
	'sharpnessadj' => { 109 => 0x20310, 114 => 0x25a, 496 => 0x801a },
	'sharpnessadjon' => { 109 => '0x20310.0' },
	'sharpnessauto' => { 76 => 0x94 },
	'sharpnessfactor' => { 336 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 75 => 0x64, 76 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 79 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 75 => 0x34, 76 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 75 => 0x7c, 76 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 75 => 0x4c, 76 => 0x4c },
	'sharpnessovershoot' => { 496 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 75 => 0x1c, 76 => 0x1c },
	'sharpnessrange' => { 459 => 0x2035 },
	'sharpnesssetting' => { 331 => 0x506, 339 => 0x1013, 447 => 0x12, 464 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 75 => 0x4, 76 => 0x4 },
	'sharpnessstrength' => { 109 => 0x20311 },
	'sharpnessthreshold' => { 496 => 0x801d },
	'sharpnessundershoot' => { 496 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 75 => 0x94, 76 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 75 => 0xac, 76 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 75 => 0xc4, 76 => 0xdc },
	'shiftcols' => { 145 => 0xc70 },
	'shootid' => { 542 => 'shootID' },
	'shootingdistance' => { 109 => 0x20701 },
	'shootinginfodisplay' => { 310 => '13.2', 311 => '5.1', 319 => '10.2', 320 => '4.1', 323 => '5.1', 325 => '5.3' },
	'shootinginfomonitorofftime' => { 310 => '26.2', 311 => '22.2', 313 => '22.2', 314 => '22.2', 318 => '21.2', 319 => '9.1', 320 => '21.2', 323 => '22.2', 324 => '22.2', 325 => '22.2', 326 => 0x3d, 327 => 0x37, 328 => 0x37, 329 => 0x37 },
	'shootingmode' => { 163 => 'ShootingMode', 243 => 0x89, 355 => 0x1f },
	'shootingmodesetting' => { 312 => '5.1' },
	'shortdescription' => { 528 => 'shortdescription' },
	'shortdocumentid' => { 138 => 0xba },
	'shortname' => { 524 => 'ShortName', 526 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 90 => 0x80d },
	'shorttitle' => { 409 => '@sti' },
	'shotdate' => { 553 => 'shotDate' },
	'shotday' => { 553 => 'shotDay' },
	'shotlocation' => { 553 => 'shotLocation' },
	'shotlogdata' => { 504 => 'shot_log_data' },
	'shotname' => { 417 => 'shot', 553 => 'shotName' },
	'shotnumber' => { 553 => 'shotNumber' },
	'shotnumbersincepowerup' => { 463 => 0x44e, 482 => 0x1a, 483 => 0x16, 484 => 0xa },
	'shotnumbersincepowerup2' => { 447 => 0x200 },
	'shotsize' => { 553 => 'shotSize' },
	'shotsperinterval' => { 232 => 0x180, 247 => 0x1f0, 248 => 0xb4, 249 => 0xcc, 250 => 0xcc, 251 => 0xc0, 252 => 0xd0, 253 => 0xd0, 254 => 0xd4 },
	'showmovement' => { 409 => 'shwm' },
	'shownevent' => { 538 => 'EventExt' },
	'showneventidentifier' => { 538 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 538 => [\'EventExt','EventExtName'] },
	'shutter' => { 478 => 0x20, 479 => 0x26, 480 => 0x26 },
	'shutter-aelock' => { 88 => 0x4, 90 => 0x701, 91 => 0x3, 92 => 0x4, 93 => 0x3, 94 => 0x3, 95 => 0x4, 96 => 0x2 },
	'shutteraelbutton' => { 89 => 0x4 },
	'shutterbuttonafonbutton' => { 90 => 0x701 },
	'shuttercount' => { 11 => 0x176, 30 => [0xa95,0x293], 33 => 0xaf1, 34 => 0xd29, 61 => 0x1, 243 => 0xa7, 274 => [0x6a,0x157,0x24d], 275 => 0x286, 276 => 0x279, 277 => 0x284, 278 => 0x242, 279 => 0x280, 280 => 0x276, 281 => [0x27d,0x27f], 282 => 0x246, 284 => 0x2d6, 285 => 0x321, 286 => 0xbd8, 287 => 0x287, 288 => 0x320, 289 => 0x24a, 290 => 0x5fb, 291 => 0x2d5, 391 => 0x5d, 456 => 0x846, 462 => [0x125,0x14a], 478 => 0x32, 479 => 0x3a, 480 => 0x3a, 481 => 0xa },
	'shuttercount2' => { 478 => 0x4c, 479 => [0x50,0x52,0x58], 480 => 0x50 },
	'shuttercount3' => { 478 => [0x1a0,0x1aa,0x1bd], 479 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 88 => 0xf, 89 => 0xf, 90 => 0x305, 91 => 0xe, 92 => 0xf, 93 => 0x8, 94 => 0x8, 95 => 0xf, 96 => 0x8 },
	'shuttermode' => { 61 => 0x17, 147 => 0x1b, 243 => 0x34 },
	'shutterreleasebuttonae-l' => { 310 => '17.7', 311 => '18.4', 313 => '78.4', 314 => '78.4', 315 => '16.1', 316 => '17.1', 317 => '17.1', 318 => '17.1', 319 => '7.1', 320 => '17.5', 323 => '18.4', 324 => '78.4', 325 => '18.2', 326 => 0x2b, 327 => 0x29, 328 => 0x29, 329 => 0x29 },
	'shutterreleasemethod' => { 103 => 0x1010 },
	'shutterreleasenocfcard' => { 88 => 0x2, 89 => 0x2, 96 => 0xf },
	'shutterreleasetiming' => { 103 => 0x1011 },
	'shutterreleasewithoutlens' => { 90 => 0x711 },
	'shutterspeedlock' => { 311 => '38.1', 313 => '38.1', 314 => '38.1', 323 => '38.1', 324 => '38.1', 326 => 0xbb, 327 => 0xb7, 328 => 0xb7, 329 => 0xb7 },
	'shutterspeedrange' => { 90 => 0x10c },
	'shutterspeedsetting' => { 191 => 0x6, 445 => 0x2f, 446 => 0x28, 447 => 0x0 },
	'shutterspeedvalue' => { 99 => 0x1, 125 => 0x9201, 336 => 0x1000, 400 => 0x400, 530 => 'ShutterSpeedValue' },
	'shuttertype' => { 133 => 0x1050, 355 => 0x9f, 391 => 0x87, 484 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 541 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 145 => 0xe0d },
	'sigmascalingfactorcamera' => { 145 => 0xe0c },
	'sigmascalingfactorlowres' => { 145 => 0xe0b },
	'sigmasizetable' => { 145 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 243 => 0xbf, 247 => 0x9b7 },
	'similarityindex' => { 138 => 0xe4 },
	'singleframebracketing' => { 191 => 0x21 },
	'skilllevel' => { 545 => 'skillLevel' },
	'skintonecorrection' => { 391 => 0x95 },
	'skiplinetime' => { 145 => 0x184e },
	'slaveflashmeteringsegments' => { 391 => 0x20b },
	'slideshowname' => { 542 => 'slideshowName' },
	'slideshownumber' => { 542 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 542 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 247 => 0x364, 249 => 0x24a, 250 => 0x24a, 253 => 0x24a, 254 => 0x24e },
	'slowshutter' => { 82 => 0x8 },
	'slowsync' => { 133 => 0x1030 },
	'smartalbumcolor' => { 432 => 0x20 },
	'smartrange' => { 432 => 0xa012 },
	'smileshutter' => { 447 => 0x31 },
	'smileshuttermode' => { 447 => 0x27 },
	'smoothness' => { 125 => 0xfe57, 524 => 'Smoothness', 526 => 'Smoothness' },
	'snapshot' => { 538 => 'SnapshotLink' },
	'snapshotformat' => { 538 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 538 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 538 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 538 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 538 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 518 => 'Snapshots' },
	'snapshotusedvideoframe' => { 538 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 538 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 538 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 538 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 538 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 459 => 0x200f },
	'software' => { 125 => 0x131, 164 => 'Software', 344 => 'Software', 400 => 0x203, 411 => 'software', 435 => 0x18, 507 => 'Software', 549 => 'Software' },
	'softwareversion' => { 417 => ['@swr',"\xa9swr"], 434 => 0x207 },
	'soloist' => { 409 => "\xa9sol" },
	'songwriter' => { 417 => "\xa9swf" },
	'songwriterkeywords' => { 417 => "\xa9swk" },
	'sonycropsize' => { 125 => 0x74c8 },
	'sonycroptopleft' => { 125 => 0x74c7 },
	'sonydatetime' => { 467 => 0x6, 469 => 0x1b6, 470 => 0x210, 471 => 0x1fe, 472 => 0x22c },
	'sonydatetime2' => { 478 => 0x51 },
	'sonyexposuretime' => { 478 => 0x3a, 479 => 0x46, 480 => [0x66,0x46], 481 => 0x1a },
	'sonyexposuretime2' => { 491 => 0xe },
	'sonyfnumber' => { 478 => 0x3c, 479 => 0x48, 480 => [0x68,0x48], 481 => 0x1c, 491 => 0x14 },
	'sonyimageheight' => { 467 => 0x1a, 482 => 0x44, 483 => 0x3f },
	'sonyimageheightmax' => { 491 => 0x40 },
	'sonyimagesize' => { 191 => 0x3b, 445 => 0x54, 446 => 0x54, 447 => 0x9 },
	'sonyimagewidth' => { 467 => 0x1c },
	'sonyimagewidthmax' => { 491 => 0x3e },
	'sonyiso' => { 469 => 0x1218, 470 => 0x11f4, 471 => 0x1270, 472 => [0x1254,0x1258,0x1280], 473 => 0x113c, 474 => 0x344, 475 => 0x346, 476 => 0x320, 491 => 0x4 },
	'sonymaxaperture' => { 478 => 0x0, 479 => 0x0 },
	'sonymaxaperturevalue' => { 491 => 0x16 },
	'sonyminaperture' => { 478 => 0x1, 479 => 0x1 },
	'sonymodelid' => { 459 => 0xb001 },
	'sonyquality' => { 191 => 0x3c },
	'sonyrawimagesize' => { 125 => 0x7038 },
	'sonytimeminsec' => { 479 => 0x61 },
	'sortalbum' => { 409 => 'soal' },
	'sortalbumartist' => { 409 => 'soaa' },
	'sortartist' => { 409 => 'soar' },
	'sortcomposer' => { 409 => 'soco' },
	'sortname' => { 409 => 'sonm', 524 => 'SortName', 526 => 'SortName' },
	'sortshow' => { 409 => 'sosn' },
	'soundengineer' => { 409 => "\xa9sne" },
	'source' => { 138 => 0x73, 344 => 'Source', 527 => 'source', 528 => 'source', 541 => 'Source' },
	'sourcecount' => { 511 => 'SourceCount' },
	'sourcecredits' => { 417 => "\xa9src" },
	'sourcedirectoryindex' => { 377 => 0x0 },
	'sourcefileindex' => { 377 => 0x2 },
	'sourcephotoscount' => { 510 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 145 => 0x1390 },
	'spatialfrequencyresponse' => { 530 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 530 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 530 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 530 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 530 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 553 => 'speakerPlacement' },
	'specialeffectlevel' => { 119 => 0x3030 },
	'specialeffectmode' => { 119 => 0x2076 },
	'specialeffectsetting' => { 119 => 0x3031 },
	'specialinstructions' => { 138 => 0x28 },
	'specialmode' => { 336 => 0x200, 434 => 0x200 },
	'specialoccasion' => { 545 => 'specialOccasion' },
	'specialtypeid' => { 504 => 'SpecialTypeID' },
	'spectralsensitivity' => { 125 => 0x8824, 530 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 44 => 0x32b, 45 => 0x281, 46 => 0x295, 49 => [0x2b9,0x2d0,0x2d4], 50 => [0x56a,0x296], 51 => 0x1e4, 52 => [0x1fd,0x2dd], 53 => [0x231,0x30f], 54 => 0x31d },
	'speedx' => { 121 => 0x3, 417 => "\xa9xsp" },
	'speedy' => { 121 => 0x4, 417 => "\xa9ysp" },
	'speedz' => { 121 => 0x5, 417 => "\xa9zsp" },
	'spherical' => { 511 => 'Spherical' },
	'sphericalvideoxml' => { 126 => 'SphericalVideoXML' },
	'splitcolumn' => { 400 => 0x222 },
	'splittoningbalance' => { 524 => 'SplitToningBalance', 526 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 524 => 'SplitToningHighlightHue', 526 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 524 => 'SplitToningHighlightSaturation', 526 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 524 => 'SplitToningShadowHue', 526 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 524 => 'SplitToningShadowSaturation', 526 => 'SplitToningShadowSaturation' },
	'sport' => { 543 => 'sport' },
	'spotfocuspointx' => { 188 => 0x2d },
	'spotfocuspointy' => { 188 => 0x2e },
	'spotmeteringmode' => { 37 => 0x27 },
	'spotmeterlinktoafpoint' => { 90 => 0x107 },
	'sractive' => { 371 => '17.1' },
	'srawquality' => { 37 => 0x2e },
	'srfocallength' => { 393 => 0x3 },
	'srgbrendering' => { 342 => 'sRGB' },
	'srhalfpresstime' => { 393 => 0x2 },
	'srresult' => { 393 => 0x0, 394 => 0x0 },
	'stackedimage' => { 331 => 0x804 },
	'standardmatrixcustom' => { 145 => 0x7d4 },
	'standardmatrixdaylight' => { 145 => 0x7d0 },
	'standardmatrixflash' => { 145 => 0x7d3 },
	'standardmatrixfluorescent' => { 145 => 0x7d2 },
	'standardmatrixtungsten' => { 145 => 0x7d1 },
	'standardoutputhighlightpoint' => { 115 => 0x14 },
	'standardoutputsensitivity' => { 125 => 0x8831, 531 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 115 => 0x15 },
	'standardrawcolortone' => { 115 => 0xd },
	'standardrawcontrast' => { 115 => 0xf },
	'standardrawhighlight' => { 115 => 0x75 },
	'standardrawhighlightpoint' => { 115 => 0x12 },
	'standardrawlinear' => { 115 => 0x10 },
	'standardrawsaturation' => { 115 => 0xe },
	'standardrawshadow' => { 115 => 0x7e },
	'standardrawshadowpoint' => { 115 => 0x13 },
	'standardrawsharpness' => { 115 => 0x11 },
	'standardunsharpmaskfineness' => { 115 => 0x94 },
	'standardunsharpmaskstrength' => { 115 => 0x92 },
	'standardunsharpmaskthreshold' => { 115 => 0x96 },
	'standardwhitecustom' => { 145 => 0x838 },
	'standardwhitedaylight' => { 145 => 0x834 },
	'standardwhiteflash' => { 145 => 0x837 },
	'standardwhitefluorescent' => { 145 => 0x836 },
	'standardwhitetungsten' => { 145 => 0x835 },
	'standbytimer' => { 311 => '19.1', 313 => '19.1', 314 => '19.1', 317 => '18.1', 318 => '18.1', 323 => '19.1', 324 => '19.1' },
	'starlightview' => { 327 => 0x249, 328 => 0x249, 329 => 0x261 },
	'startingpage' => { 543 => 'startingPage' },
	'startmovieshooting' => { 90 => 0x70d },
	'starttimecode' => { 417 => "\xa9TIM", 553 => 'startTimecode' },
	'starttimecodetimeformat' => { 553 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 553 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 553 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 417 => "\xa9TSZ", 553 => 'startTimeSampleSize' },
	'starttimescale' => { 417 => "\xa9TSC", 553 => 'startTimeScale' },
	'state' => { 168 => 'State', 355 => 0x6b, 541 => 'State' },
	'status' => { 502 => 'Status', 516 => 'Status' },
	'stereomode' => { 511 => 'StereoMode' },
	'stitched' => { 511 => 'Stitched' },
	'stitchingsoftware' => { 510 => 'StitchingSoftware', 511 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 468 => 0x113e, 469 => 0x113e, 470 => 0x111a, 471 => 0x1196, 472 => 0x1172, 473 => 0x102a, 474 => 0x222, 475 => 0x222, 476 => 0x217, 491 => 0xa },
	'storagemethod' => { 195 => 0x12 },
	'storebyorientation' => { 311 => '46.3', 313 => '47.3', 314 => '47.3', 323 => '47.3', 324 => '47.3', 326 => 0xd, 327 => 0xd, 328 => 0xd, 329 => 0xd },
	'storedescription' => { 409 => 'sdes' },
	'storedformat' => { 519 => 'StoredFormat' },
	'storylineidentifier' => { 538 => 'StorylineIdentifier' },
	'straightenangle' => { 303 => 0x2fc08431 },
	'streamready' => { 538 => 'StreamReady' },
	'streamtype' => { 183 => 'StreamType' },
	'stretchmode' => { 553 => 'stretchMode' },
	'studydatetime' => { 499 => 'StudyDateTime' },
	'studydescription' => { 499 => 'StudyDescription' },
	'studyid' => { 499 => 'StudyID' },
	'studyphysician' => { 499 => 'StudyPhysician' },
	'styleperiod' => { 538 => 'StylePeriod' },
	'sub-location' => { 138 => 0x5c },
	'subcommanddialframeadvancezoom' => { 253 => 0x806, 254 => 0x80a },
	'subcommanddialplaybackmode' => { 327 => 0x1cf, 328 => 0x1cf, 329 => 0x1e7 },
	'subcommanddialvideoplaybackmode' => { 327 => 0x1d1, 329 => 0x1e9 },
	'subfiledata' => { 171 => 'data' },
	'subfiledirectory' => { 171 => '1Directory' },
	'subfilemimetype' => { 171 => '2MIME' },
	'subfilename' => { 171 => '1Name' },
	'subfileresource' => { 171 => 'rsrc' },
	'subfiletype' => { 125 => 0xfe, 171 => '0Type' },
	'subject' => { 340 => 'Subject', 407 => 'Subject', 527 => 'subject', 540 => 'Subject', 554 => 'subject' },
	'subjectarea' => { 125 => 0x9214, 530 => 'SubjectArea' },
	'subjectcode' => { 537 => 'SubjectCode' },
	'subjectdetection' => { 247 => 0x36e, 249 => 0x252, 250 => 0x252, 251 => 0x23e, 252 => 0x252, 253 => 0x252, 254 => 0x256 },
	'subjectdetectionareamf' => { 247 => 0x3ea },
	'subjectdistance' => { 125 => 0x9206, 147 => 0x3e, 530 => 'SubjectDistance' },
	'subjectdistancerange' => { 125 => 0xa40c, 530 => 'SubjectDistanceRange' },
	'subjectlocation' => { 125 => 0xa214, 530 => 'SubjectLocation' },
	'subjectmotion' => { 313 => '78.2', 314 => '78.2', 324 => '78.2', 327 => 0x103, 328 => 0x103, 329 => 0x119 },
	'subjectprogram' => { 188 => 0x22 },
	'subjectreference' => { 138 => 0xc },
	'subjecttodetect' => { 2 => 0x14 },
	'sublabels1' => { 536 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 536 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 120 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 120 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 120 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 125 => 0x9290 },
	'subsectimedigitized' => { 125 => 0x9292 },
	'subsectimeoriginal' => { 125 => 0x9291 },
	'subsection1' => { 543 => 'subsection1' },
	'subsection2' => { 543 => 'subsection2' },
	'subsection3' => { 543 => 'subsection3' },
	'subsection4' => { 543 => 'subsection4' },
	'subselector' => { 311 => '49.1', 313 => '71.1', 314 => '71.1', 324 => '71.1', 326 => 0x93, 327 => 0x8f, 328 => 0x8f, 329 => 0x8f },
	'subselectorassignment' => { 311 => '48.1' },
	'subselectorcenter' => { 313 => '72.1', 314 => '72.1', 324 => '72.1' },
	'subselectorplusdials' => { 311 => '49.2', 313 => '73.1', 314 => '73.1', 324 => '73.1' },
	'subtitle' => { 186 => 'WM/SubTitle', 409 => "\xa9st3", 417 => "\xa9snm", 543 => 'subtitle' },
	'subtitlekeywords' => { 417 => "\xa9snk" },
	'subversionfilename' => { 536 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 536 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 536 => 'SubVersions' },
	'superimposeddisplay' => { 88 => 0xa, 90 => 0x510, 91 => 0x9, 92 => 0xa, 95 => 0xa, 96 => 0xe },
	'supermacro' => { 69 => 0x1a },
	'supplementalcategories' => { 138 => 0x14, 541 => 'SupplementalCategories' },
	'supplementaltype' => { 140 => 0x37 },
	'supplementdisplayid' => { 543 => 'supplementDisplayID' },
	'supplementstartingpage' => { 543 => 'supplementStartingPage' },
	'supplementtitle' => { 543 => 'supplementTitle' },
	'supplychainsource' => { 538 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 538 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 538 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 524 => 'SupportsAmount', 526 => 'SupportsAmount' },
	'supportscolor' => { 524 => 'SupportsColor', 526 => 'SupportsColor' },
	'supportshighdynamicrange' => { 524 => 'SupportsHighDynamicRange', 526 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 524 => 'SupportsMonochrome', 526 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 524 => 'SupportsNormalDynamicRange', 526 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 524 => 'SupportsOutputReferred', 526 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 524 => 'SupportsSceneReferred', 526 => 'SupportsSceneReferred' },
	'svisosetting' => { 371 => 0x14 },
	'swatchcoloranta' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 558 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 558 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 558 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 558 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 558 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 355 => 0x93, 447 => 0x33 },
	'sweeppanoramafieldofview' => { 355 => 0x94 },
	'sweeppanoramasize' => { 447 => 0x32 },
	'switchtoregisteredafpoint' => { 89 => 0x12, 90 => 0x50a },
	'symlink' => { 126 => 'SymLink' },
	'syncreleasemode' => { 313 => '77.1', 314 => '77.1', 324 => '77.1', 326 => 0x45, 327 => 0x41, 328 => 0x41, 329 => 0x41 },
	'system' => { 400 => 0x204 },
	'tagged' => { 402 => 0xdd, 403 => 'Tagged', 518 => 'tagged' },
	'tagslist' => { 529 => 'TagsList' },
	'tagstructure' => { 536 => 'TagStructure' },
	'takenumber' => { 553 => 'takeNumber' },
	'tapename' => { 553 => 'tapeName' },
	'targetaperture' => { 82 => 0x4 },
	'targetaspectratio' => { 345 => 'TargetAspectRatio' },
	'targetcompressionratio' => { 101 => 0x1 },
	'targetdistancesetting' => { 103 => 0x1807 },
	'targetexposuretime' => { 82 => 0x5 },
	'targetimagetype' => { 103 => 0x100a },
	'targetprinter' => { 125 => 0x151 },
	'taxon' => { 124 => 'Taxon' },
	'taxonacceptednameusage' => { 124 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 124 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 124 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 124 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 124 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 124 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 124 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 124 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 124 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 124 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 124 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 124 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 124 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 124 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 124 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 124 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 124 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 124 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 124 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 124 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 124 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 124 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 124 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 124 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 124 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 124 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 124 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 124 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 124 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 124 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 124 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 124 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 124 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 124 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 145 => 0x196f },
	'tda1edgepolarity' => { 145 => 0x1971 },
	'tda1gain' => { 145 => 0x1970 },
	'tda1offset' => { 145 => 0x196e },
	'tda2bandwidth' => { 145 => 0x1979 },
	'tda2edgepolarity' => { 145 => 0x197b },
	'tda2gain' => { 145 => 0x197a },
	'tda2offset' => { 145 => 0x1978 },
	'tda3bandwidth' => { 145 => 0x1983 },
	'tda3edgepolarity' => { 145 => 0x1985 },
	'tda3gain' => { 145 => 0x1984 },
	'tda3offset' => { 145 => 0x1982 },
	'tda4bandwidth' => { 145 => 0x198d },
	'tda4edgepolarity' => { 145 => 0x198f },
	'tda4gain' => { 145 => 0x198e },
	'tda4offset' => { 145 => 0x198c },
	'teaser' => { 543 => 'teaser' },
	'teleconverter' => { 193 => 0x105, 459 => 0x105 },
	'tempampgainx100' => { 145 => 0x1914 },
	'tempo' => { 553 => 'tempo' },
	'temporalcoverage' => { 538 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 538 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 538 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 341 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 341 => 'TermsAndConditionsURL' },
	'testname' => { 126 => 'TestName' },
	'textencoding' => { 242 => 0x4 },
	'textlayername' => { 541 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 541 => 'TextLayers' },
	'textlayertext' => { 541 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 355 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 524 => 'Texture', 526 => 'Texture' },
	'three-dtrackingfacedetection' => { 313 => '1.4', 314 => '1.4', 324 => '1.4' },
	'three-dtrackingwatcharea' => { 313 => '78.1', 314 => '78.1', 324 => '78.1' },
	'thresholding' => { 125 => 0x107 },
	'thumbnailfilename' => { 103 => 0x817 },
	'thumbnailformat' => { 551 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 149 => 0xfa55, 551 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 103 => 0x2008, 120 => 'Exif-ThumbnailImage', 128 => 0x3, 174 => 'data', 336 => 0x100, 409 => 'tnal', 417 => 'thmb', 551 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 174 => '1Name' },
	'thumbnailimagesize' => { 174 => 'ImageSize' },
	'thumbnailimagetype' => { 174 => '0Type' },
	'thumbnailimagevalidarea' => { 69 => 0x13 },
	'thumbnaillength' => { 125 => 0x202 },
	'thumbnailoffset' => { 125 => 0x201 },
	'thumbnailpng' => { 417 => 'thmb' },
	'thumbnails' => { 551 => 'Thumbnails' },
	'thumbnailwidth' => { 149 => 0xfa54, 551 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 543 => 'ticker' },
	'tiffhandling' => { 524 => 'TIFFHandling', 526 => 'TIFFHandling' },
	'tiffmeteringimage' => { 194 => 0x104c, 456 => 0x1110 },
	'tilelength' => { 125 => 0x143 },
	'tilewidth' => { 125 => 0x142 },
	'time' => { 145 => 0x401, 391 => 0x7 },
	'timecodes' => { 125 => 0xc763 },
	'timecreated' => { 138 => 0x3c, 147 => 0x14, 156 => 0x10, 403 => 'TimeCreated' },
	'timelapseshotnumber' => { 358 => 0x10 },
	'timeperiod' => { 543 => 'timePeriod' },
	'timerfunctionbutton' => { 312 => '5.2', 315 => '12.1', 316 => '13.1' },
	'timerlength' => { 90 => 0x80c },
	'timerrecording' => { 355 => 0x96 },
	'timescaleparams' => { 553 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 553 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 553 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 553 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 139 => 0x50 },
	'timeshot' => { 512 => 'TimeShot' },
	'timesignature' => { 553 => 'timeSignature' },
	'timesincepoweron' => { 355 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 330 => 0x8, 344 => 'TimeStamp', 355 => 0xaf, 511 => 'Timestamp', 520 => 'Timestamp', 536 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 83 => 0x1, 247 => 0x8fe, 249 => 0x694, 250 => 0x6a4, 251 => 0x594, 252 => 0x5c4, 253 => 0x5dc, 254 => 0x5e0, 295 => 0x0, 428 => 0xa },
	'timezonecity' => { 83 => 0x2 },
	'timezonecode' => { 106 => 0x1 },
	'timezoneinfo' => { 106 => 0x2 },
	'timezoneoffset' => { 125 => 0x882a },
	'tint' => { 411 => 'player.movie.visual.tint', 524 => 'Tint', 526 => 'Tint' },
	'title' => { 164 => 'Title', 340 => 'Title', 344 => 'Title', 355 => 0x65, 407 => 'Title', 409 => ['titl',"\xa9nam"], 411 => 'title', 417 => ['titl',"\xa9nam"], 527 => 'title', 540 => 'Title', 551 => 'Title' },
	'togglestyleamount' => { 524 => 'ToggleStyleAmount', 526 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 524 => 'ToggleStyleDigest', 526 => 'ToggleStyleDigest' },
	'tonecomp' => { 243 => 0x81 },
	'tonecurve' => { 79 => 0x1, 391 => 0x402, 524 => 'ToneCurve', 526 => 'ToneCurve' },
	'tonecurveactive' => { 114 => 0x110 },
	'tonecurveadobergb' => { 432 => 0xa043 },
	'tonecurveadobergbdefault' => { 432 => 0xa041 },
	'tonecurveblue' => { 524 => 'ToneCurveBlue', 526 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 496 => 0x9003 },
	'tonecurvebluey' => { 496 => 0x9007 },
	'tonecurvebrightness' => { 109 => 0x20410 },
	'tonecurvebrightnessx' => { 496 => 0x9000 },
	'tonecurvebrightnessy' => { 496 => 0x9004 },
	'tonecurvecolorspace' => { 113 => 0x0 },
	'tonecurvecontrast' => { 109 => 0x20411 },
	'tonecurvegreen' => { 524 => 'ToneCurveGreen', 526 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 496 => 0x9002 },
	'tonecurvegreeny' => { 496 => 0x9006 },
	'tonecurveinputrange' => { 113 => 0x3 },
	'tonecurveinterpolation' => { 114 => 0x159 },
	'tonecurvemode' => { 114 => 0x113 },
	'tonecurvename' => { 524 => 'ToneCurveName', 526 => 'ToneCurveName' },
	'tonecurvename2012' => { 524 => 'ToneCurveName2012', 526 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 109 => '0x20400.1' },
	'tonecurveoutputrange' => { 113 => 0x5 },
	'tonecurveprofilename' => { 145 => 0x1391 },
	'tonecurveproperty' => { 114 => 0x3c },
	'tonecurvepv2012' => { 524 => 'ToneCurvePV2012', 526 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 524 => 'ToneCurvePV2012Blue', 526 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 524 => 'ToneCurvePV2012Green', 526 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 524 => 'ToneCurvePV2012Red', 526 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 524 => 'ToneCurveRed', 526 => 'ToneCurveRed' },
	'tonecurveredx' => { 496 => 0x9001 },
	'tonecurveredy' => { 496 => 0x9005 },
	'tonecurves' => { 391 => 0x403 },
	'tonecurveshape' => { 113 => 0x1 },
	'tonecurvesrgb' => { 432 => 0xa042 },
	'tonecurvesrgbdefault' => { 432 => 0xa040 },
	'tonecurvex' => { 113 => 0xa },
	'tonecurvey' => { 113 => 0xb },
	'tonelevel' => { 331 => 0x52e },
	'tonemap' => { 247 => 0x374, 249 => 0x26a, 250 => 0x26a },
	'tonemapstrength' => { 524 => 'ToneMapStrength', 526 => 'ToneMapStrength' },
	'toningeffect' => { 61 => 0xf, 243 => 0xb3, 261 => 0x38, 262 => 0x40, 263 => 0x48, 425 => 0x1015 },
	'toningeffectauto' => { 76 => 0xa4 },
	'toningeffectfaithful' => { 75 => 0x74, 76 => 0x74 },
	'toningeffectlandscape' => { 75 => 0x44, 76 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 75 => 0x8c, 76 => 0x8c },
	'toningeffectneutral' => { 75 => 0x5c, 76 => 0x5c },
	'toningeffectportrait' => { 75 => 0x2c, 76 => 0x2c },
	'toningeffectstandard' => { 75 => 0x14, 76 => 0x14 },
	'toningeffectuserdef1' => { 75 => 0xa4, 76 => 0xbc },
	'toningeffectuserdef2' => { 75 => 0xbc, 76 => 0xd4 },
	'toningeffectuserdef3' => { 75 => 0xd4, 76 => 0xec },
	'toningsaturation' => { 261 => 0x39, 262 => 0x41, 263 => 0x49 },
	'totalzoom' => { 147 => 0x62 },
	'touchae' => { 355 => 0xab },
	'touchfn' => { 326 => 0x154 },
	'touchfnareatall' => { 326 => 0x15b },
	'touchfnareawide' => { 326 => 0x159 },
	'touchfnrole' => { 326 => 0x155 },
	'track' => { 409 => "\xa9trk", 417 => "\xa9trk" },
	'trackcreatedate' => { 416 => 0x1 },
	'trackmodifydate' => { 416 => 0x2 },
	'tracknumber' => { 409 => 'trkn', 553 => 'trackNumber' },
	'tracks' => { 553 => 'Tracks' },
	'tracksframerate' => { 553 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 553 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 553 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 553 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 553 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 553 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 553 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 553 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 553 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 553 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 553 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 553 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 553 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 553 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 553 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 553 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 553 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 417 => 'kgtt' },
	'trailer' => { 126 => 'Trailer' },
	'trailersignature' => { 171 => 'zmie' },
	'transcript' => { 538 => 'Transcript' },
	'transcriptlink' => { 538 => 'TranscriptLink' },
	'transcriptlinklink' => { 538 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 538 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 125 => 0x12d, 549 => 'TransferFunction' },
	'transfertimenormal' => { 145 => 0x1888 },
	'transfertimetest' => { 145 => 0x1889 },
	'transform' => { 355 => [0x8012,0x59] },
	'transformation' => { 539 => 'Transformation' },
	'transmissionreference' => { 541 => 'TransmissionReference' },
	'trapped' => { 340 => 'Trapped', 540 => 'Trapped' },
	'trashbuttonfunction' => { 90 => 0x710 },
	'travelday' => { 355 => 0x36 },
	'treble' => { 408 => 'player.movie.audio.treble', 411 => 'player.movie.audio.treble' },
	'triggermode' => { 419 => 0x6, 420 => 0x34, 421 => 0x34 },
	'tstop' => { 125 => 0xc772 },
	'ttl_da_adown' => { 378 => 0x5 },
	'ttl_da_aup' => { 378 => 0x4 },
	'ttl_da_bdown' => { 378 => 0x7 },
	'ttl_da_bup' => { 378 => 0x6 },
	'tungstenawb' => { 368 => 0x1 },
	'tvepisode' => { 409 => 'tves' },
	'tvepisodeid' => { 409 => 'tven' },
	'tvexposuretimesetting' => { 371 => 0x12 },
	'tvnetworkname' => { 409 => 'tvnn' },
	'tvseason' => { 409 => 'tvsn' },
	'tvshow' => { 409 => 'tvsh' },
	'type' => { 506 => 'Type', 527 => 'type', 548 => 'type' },
	'typestatus' => { 124 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 125 => 0xc614 },
	'uniquedocumentid' => { 138 => 0xbb },
	'uniquematrixauto' => { 145 => 0x7e9 },
	'uniquematrixcustom' => { 145 => 0x7e8 },
	'uniquematrixdaylight' => { 145 => 0x7e4 },
	'uniquematrixflash' => { 145 => 0x7e7 },
	'uniquematrixfluorescent' => { 145 => 0x7e6 },
	'uniquematrixtungsten' => { 145 => 0x7e5 },
	'uniqueobjectname' => { 139 => 0x64 },
	'units' => { 507 => 'Units' },
	'unknown_aacr' => { 409 => 'AACR' },
	'unknown_cdek' => { 409 => 'CDEK' },
	'unknown_cdet' => { 409 => 'CDET' },
	'unknownblock' => { 391 => 0x405 },
	'unknownblock1' => { 335 => 0x635 },
	'unknownblock2' => { 335 => 0x636 },
	'unknownblock3' => { 335 => 0x1103 },
	'unknownblock4' => { 335 => 0x1104 },
	'unknowncontrast' => { 115 => 0x45 },
	'unknowndate' => { 400 => 0x212 },
	'unknownev' => { 145 => 0x1 },
	'unknownlinear' => { 115 => 0x46 },
	'unknownnumber' => { 103 => 0x180b },
	'unknownoutputhighlightpoint' => { 115 => 0x4a },
	'unknownoutputshadowpoint' => { 115 => 0x4b },
	'unknownrawhighlight' => { 115 => 0x7b },
	'unknownrawhighlightpoint' => { 115 => 0x48 },
	'unknownrawshadow' => { 115 => 0x84 },
	'unknownrawshadowpoint' => { 115 => 0x49 },
	'unknownsharpness' => { 115 => 0x47 },
	'unknowntags' => { 417 => 'TAGS' },
	'unknowntemperature' => { 127 => 0x4 },
	'unknownthumbnail' => { 417 => 'thmb' },
	'unsharp1color' => { 308 => 0x13 },
	'unsharp1halowidth' => { 308 => 0x19 },
	'unsharp1intensity' => { 308 => 0x17 },
	'unsharp1threshold' => { 308 => 0x1b },
	'unsharp2color' => { 308 => 0x2e },
	'unsharp2halowidth' => { 308 => 0x34 },
	'unsharp2intensity' => { 308 => 0x32 },
	'unsharp2threshold' => { 308 => 0x36 },
	'unsharp3color' => { 308 => 0x49 },
	'unsharp3halowidth' => { 308 => 0x4f },
	'unsharp3intensity' => { 308 => 0x4d },
	'unsharp3threshold' => { 308 => 0x51 },
	'unsharp4color' => { 308 => 0x64 },
	'unsharp4halowidth' => { 308 => 0x6a },
	'unsharp4intensity' => { 308 => 0x68 },
	'unsharp4threshold' => { 308 => 0x6c },
	'unsharpcount' => { 308 => 0x0 },
	'unsharpmask' => { 115 => 0x90, 303 => 0x76a43200 },
	'unsharpmaskfineness' => { 79 => 0xe, 109 => 0x20309 },
	'unsharpmaskstrength' => { 109 => 0x20308 },
	'unsharpmaskthreshold' => { 79 => 0xf, 109 => 0x2030a },
	'uprightcentermode' => { 524 => 'UprightCenterMode', 526 => 'UprightCenterMode' },
	'uprightcenternormx' => { 524 => 'UprightCenterNormX', 526 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 524 => 'UprightCenterNormY', 526 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 524 => 'UprightDependentDigest', 526 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 524 => 'UprightFocalLength35mm', 526 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 524 => 'UprightFocalMode', 526 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 524 => 'UprightFourSegments_0', 526 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 524 => 'UprightFourSegments_1', 526 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 524 => 'UprightFourSegments_2', 526 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 524 => 'UprightFourSegments_3', 526 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 524 => 'UprightFourSegmentsCount', 526 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 524 => 'UprightGuidedDependentDigest', 526 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 524 => 'UprightPreview', 526 => 'UprightPreview' },
	'uprighttransform_0' => { 524 => 'UprightTransform_0', 526 => 'UprightTransform_0' },
	'uprighttransform_1' => { 524 => 'UprightTransform_1', 526 => 'UprightTransform_1' },
	'uprighttransform_2' => { 524 => 'UprightTransform_2', 526 => 'UprightTransform_2' },
	'uprighttransform_3' => { 524 => 'UprightTransform_3', 526 => 'UprightTransform_3' },
	'uprighttransform_4' => { 524 => 'UprightTransform_4', 526 => 'UprightTransform_4' },
	'uprighttransform_5' => { 524 => 'UprightTransform_5', 526 => 'UprightTransform_5' },
	'uprighttransformcount' => { 524 => 'UprightTransformCount', 526 => 'UprightTransformCount' },
	'uprightversion' => { 524 => 'UprightVersion', 526 => 'UprightVersion' },
	'urgency' => { 138 => 0xa, 541 => 'Urgency' },
	'url' => { 164 => 'URL', 344 => 'URL', 405 => 0x40b, 543 => 'url' },
	'url_list' => { 405 => 0x41e },
	'urla-platform' => { 543 => [\'url','urlA-platform'] },
	'urlurl' => { 543 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 90 => 0x10a },
	'usableshootingmodes' => { 90 => 0x109 },
	'usage' => { 544 => 'usage' },
	'usageterms' => { 557 => 'UsageTerms' },
	'usbpowerdelivery' => { 247 => 0x9ac, 249 => 0x762, 250 => 0x772, 251 => 0x664, 252 => 0x694, 253 => 0x6fc, 254 => 0x700 },
	'usedialwithouthold' => { 326 => 0xc3, 327 => 0xbf, 328 => 0xbf, 329 => 0xbf },
	'useguidelines' => { 522 => 'useGuidelines' },
	'usepanoramaviewer' => { 510 => 'UsePanoramaViewer' },
	'usercollection' => { 411 => 'collection.user' },
	'usercomment' => { 103 => 0x805, 125 => 0x9286, 530 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 75 => 0xd8, 76 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 75 => 0xda, 76 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 75 => 0xdc, 76 => 0xf4 },
	'userfields' => { 516 => 'UserFields' },
	'userlabel' => { 419 => 0x2b, 420 => 0x5a, 421 => 0x68 },
	'userprofile' => { 350 => 0x302, 354 => 0x34c, 357 => 0x3038 },
	'userrating' => { 411 => 'rating.user', 417 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 89 => 0x7, 90 => 0x501 },
	'uspsnumber' => { 543 => 'uspsNumber' },
	'utmeasting' => { 175 => 'Easting' },
	'utmmapdatum' => { 175 => 'Datum' },
	'utmnorthing' => { 175 => 'Northing' },
	'utmzone' => { 175 => 'Zone' },
	'uuid' => { 524 => 'UUID', 526 => 'UUID' },
	'uv-irfiltercorrection' => { 350 => 0x325 },
	'validbits' => { 335 => 0x611, 336 => 0x102c },
	'validcropcorners' => { 345 => 'ValidCropCorners' },
	'validpixeldepth' => { 339 => 0x611 },
	'variablelowpassfilter' => { 459 => 0x2028 },
	'variousmodes' => { 147 => 0x26 },
	'variousmodes2' => { 147 => 0x3a },
	'variprogram' => { 243 => 0xab },
	'varraydacnominalvalues' => { 145 => 0x191e },
	'vendor' => { 417 => 'vndr' },
	'vendorinfo' => { 500 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 500 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 500 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 500 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 124 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 133 => 0x0, 345 => 'Version', 407 => 'Version', 411 => 'version', 524 => 'Version', 526 => 'Version', 535 => 'Version' },
	'versioncreatedate' => { 496 => 0xd100 },
	'versionid' => { 554 => 'VersionID' },
	'versionidentifier' => { 543 => 'versionIdentifier' },
	'versionmodifydate' => { 496 => 0xd101 },
	'versions' => { 554 => 'Versions' },
	'versionscomments' => { 554 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 554 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 554 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 554 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 554 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 554 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 554 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 554 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 554 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 554 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 554 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 310 => '3.2', 311 => '47.2', 313 => '79.1', 328 => 0x11d, 329 => 0x135 },
	'verticalclockoverlaps' => { 145 => 0x412 },
	'verticalfuncbutton' => { 311 => '42.2', 313 => '67.1', 328 => 0x115, 329 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 328 => 0x1b7, 329 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 311 => '43.1' },
	'verticalfuncplusdials' => { 313 => '68.1' },
	'verticalisobutton' => { 253 => 0x792, 254 => 0x796 },
	'verticalmovieafonbutton' => { 328 => 0x1f9, 329 => 0x211 },
	'verticalmoviefuncbutton' => { 328 => 0x1e1, 329 => 0x1f9 },
	'verticalmultiselector' => { 311 => '42.1', 313 => '66.1', 314 => '66.1', 324 => '66.1', 328 => 0x18f, 329 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 328 => 0x125, 329 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 90 => [0x510,0x51d] },
	'vibrance' => { 517 => 'Vibrance', 524 => 'Vibrance', 526 => 'Vibrance' },
	'vibrationreduction' => { 274 => [0x75,0x82,0x1ae], 282 => '586.1', 289 => '590.2', 293 => 0x4 },
	'videoalphamode' => { 553 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 553 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 553 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 553 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 538 => 'videoBitRate' },
	'videobitratemode' => { 538 => 'videoBitRateMode' },
	'videoburstmode' => { 355 => 0xbb },
	'videoburstresolution' => { 355 => 0xb3 },
	'videocodec' => { 72 => 0x74 },
	'videocolorspace' => { 553 => 'videoColorSpace' },
	'videocompression' => { 133 => 0x3806 },
	'videocompressor' => { 553 => 'videoCompressor' },
	'videodisplayaspectratio' => { 538 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 538 => 'videoEncodingProfile' },
	'videofieldorder' => { 553 => 'videoFieldOrder' },
	'videoframerate' => { 355 => 0x27, 553 => 'videoFrameRate' },
	'videoframesize' => { 553 => 'videoFrameSize' },
	'videoframesizeh' => { 553 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 553 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 553 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 553 => 'videoModDate' },
	'videopixelaspectratio' => { 553 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 553 => 'videoPixelDepth' },
	'videopreburst' => { 355 => 0xc1 },
	'videoquality' => { 119 => 0x4003 },
	'videorecordingmode' => { 133 => 0x3803 },
	'videoshottype' => { 538 => 'VideoShotType' },
	'videoshottypeidentifier' => { 538 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 538 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 538 => 'videoStreamsCount' },
	'viewfinder' => { 400 => 0x455 },
	'viewfinderdisplay' => { 310 => '12.4', 311 => '6.3' },
	'viewfinderwarning' => { 310 => '13.4', 320 => '3.5', 321 => '6.2', 325 => '4.4' },
	'viewfinderwarnings' => { 90 => 0x40a },
	'viewinfoduringexposure' => { 90 => 0x407 },
	'viewingmode' => { 447 => 0x2f, 464 => 0x18 },
	'viewingmode2' => { 447 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 253 => 0x7d2, 254 => 0x7d6, 327 => 0x2a9 },
	'viewpoint' => { 542 => 'viewpoint' },
	'vignetteamount' => { 524 => 'VignetteAmount', 526 => 'VignetteAmount' },
	'vignettecoefficient1' => { 294 => 0x24 },
	'vignettecoefficient2' => { 294 => 0x34 },
	'vignettecoefficient3' => { 294 => 0x44 },
	'vignettecontrol' => { 243 => 0x2a, 303 => 0x76a43205 },
	'vignettecontrolintensity' => { 303 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 521 => 'VignetteCorrectionAlreadyApplied' },
	'vignettecorrectionversion' => { 294 => 0x0 },
	'vignettemidpoint' => { 524 => 'VignetteMidpoint', 526 => 'VignetteMidpoint' },
	'vignetting' => { 425 => 0x1011, 432 => 0xa052 },
	'vignettingcorrection' => { 125 => 0x7031, 432 => 0xa053, 459 => 0x2011 },
	'vignettingcorrparams' => { 125 => 0x7032, 490 => 0x64a, 491 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 432 => 0xa054 },
	'virtualfocallength' => { 539 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 326 => 0x161, 327 => 0x167, 328 => 0x167, 329 => 0x17f },
	'virtualimagexcenter' => { 539 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 539 => 'VirtualImageYCenter' },
	'visualcolor' => { 538 => 'VisualColour' },
	'visualtechnique' => { 542 => 'visualTechnique' },
	'voicememo' => { 434 => 0x216 },
	'volume' => { 543 => 'volume' },
	'vr_0x66' => { 274 => 0x66 },
	'vrdoffset' => { 69 => 0xd0 },
	'vrmode' => { 247 => 0x342, 249 => 0x226, 250 => 0x226, 251 => 0x212, 252 => 0x226, 253 => 0x226, 254 => 0x22a, 293 => 0x6 },
	'vrtype' => { 293 => 0x8 },
	'waterdepth' => { 125 => 0x9403, 531 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 194 => 0x19a },
	'wb_bluelevel6500k' => { 194 => 0x18a },
	'wb_bluelevelcustom' => { 194 => 0x18e },
	'wb_bluelevelscloudy' => { 194 => 0x106 },
	'wb_bluelevelsdaylight' => { 194 => 0xea },
	'wb_bluelevelsflash' => { 194 => 0x122 },
	'wb_bluelevelsfluorescent' => { 194 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 194 => 0x254 },
	'wb_bluelevelsshade' => { 194 => 0x176 },
	'wb_bluelevelstungsten' => { 194 => 0xce },
	'wb_gbrglevels' => { 194 => 0xae, 197 => 0x4 },
	'wb_glevel' => { 335 => 0x11f },
	'wb_glevel3000k' => { 335 => 0x113 },
	'wb_glevel3300k' => { 335 => 0x114 },
	'wb_glevel3600k' => { 335 => 0x115 },
	'wb_glevel3900k' => { 335 => 0x116 },
	'wb_glevel4000k' => { 335 => 0x117 },
	'wb_glevel4300k' => { 335 => 0x118 },
	'wb_glevel4500k' => { 335 => 0x119 },
	'wb_glevel4800k' => { 335 => 0x11a },
	'wb_glevel5300k' => { 335 => 0x11b },
	'wb_glevel6000k' => { 335 => 0x11c },
	'wb_glevel6600k' => { 335 => 0x11d },
	'wb_glevel7500k' => { 335 => 0x11e },
	'wb_grbglevels' => { 211 => 0x0, 466 => 0x7303 },
	'wb_grbglevelsauto' => { 86 => 0x2, 466 => 0x7302 },
	'wb_grbglevelscloudy' => { 86 => 0x12 },
	'wb_grbglevelscustom1' => { 86 => 0x42 },
	'wb_grbglevelscustom2' => { 86 => 0x4a },
	'wb_grbglevelsdaylight' => { 86 => 0xa },
	'wb_grbglevelsflash' => { 86 => 0x32 },
	'wb_grbglevelsfluorescent' => { 86 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 86 => 0x2a },
	'wb_grbglevelstungsten' => { 86 => 0x1a },
	'wb_grbglevelsunderwater' => { 86 => 0x3a },
	'wb_rbgglevels' => { 208 => 0x0 },
	'wb_rblevels' => { 212 => 0x270, 243 => 0xc, 335 => 0x100 },
	'wb_rblevels1' => { 361 => 0x2 },
	'wb_rblevels2' => { 361 => 0x5 },
	'wb_rblevels3' => { 361 => 0x8 },
	'wb_rblevels3000k' => { 335 => 0x102 },
	'wb_rblevels3300k' => { 335 => 0x103 },
	'wb_rblevels3500k' => { 194 => 0x430 },
	'wb_rblevels3600k' => { 335 => 0x104 },
	'wb_rblevels3900k' => { 335 => 0x105 },
	'wb_rblevels4' => { 361 => 0xb },
	'wb_rblevels4000k' => { 335 => 0x106 },
	'wb_rblevels4300k' => { 335 => 0x107 },
	'wb_rblevels4500k' => { 335 => 0x108 },
	'wb_rblevels4800k' => { 335 => 0x109 },
	'wb_rblevels5' => { 361 => 0xe },
	'wb_rblevels5300k' => { 335 => 0x10a },
	'wb_rblevels6' => { 361 => 0x11 },
	'wb_rblevels6000k' => { 335 => 0x10b },
	'wb_rblevels6500k' => { 194 => 0x420 },
	'wb_rblevels6600k' => { 335 => 0x10c },
	'wb_rblevels7' => { 361 => 0x14 },
	'wb_rblevels7500k' => { 335 => 0x10d },
	'wb_rblevelsauto' => { 212 => 0x272, 339 => 0x110 },
	'wb_rblevelscloudy' => { 194 => 0x3f0, 196 => 0x10, 212 => 0x296, 339 => 0x121 },
	'wb_rblevelscoolwhitef' => { 194 => 0x308, 196 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 339 => 0x132 },
	'wb_rblevelscustom' => { 194 => 0x424, 196 => 0x1c },
	'wb_rblevelscwb1' => { 335 => 0x10e },
	'wb_rblevelscwb2' => { 335 => 0x10f },
	'wb_rblevelscwb3' => { 335 => 0x110 },
	'wb_rblevelscwb4' => { 335 => 0x111 },
	'wb_rblevelsdaylight' => { 194 => [0x3ec,0x528], 196 => 0xc, 212 => 0x274 },
	'wb_rblevelsdaylightf' => { 196 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 339 => 0x130 },
	'wb_rblevelsdaywhitef' => { 196 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 339 => 0x131 },
	'wb_rblevelseveningsunlight' => { 339 => 0x124 },
	'wb_rblevelsfineweather' => { 339 => 0x122 },
	'wb_rblevelsflash' => { 194 => [0x3f4,0x304], 196 => 0x18, 212 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 212 => 0x290 },
	'wb_rblevelsincandescent' => { 212 => 0x282 },
	'wb_rblevelsshade' => { 194 => 0x418, 196 => 0x20, 212 => 0x2b2, 339 => 0x120 },
	'wb_rblevelstungsten' => { 194 => 0x3e8, 196 => 0x8, 339 => 0x123 },
	'wb_rblevelsused' => { 339 => 0x100 },
	'wb_rblevelswhitef' => { 196 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 339 => 0x133 },
	'wb_redlevel3500k' => { 194 => 0x198 },
	'wb_redlevel6500k' => { 194 => 0x188 },
	'wb_redlevelcustom' => { 194 => 0x18c },
	'wb_redlevelscloudy' => { 194 => 0xf8 },
	'wb_redlevelsdaylight' => { 194 => 0xdc },
	'wb_redlevelsflash' => { 194 => 0x114 },
	'wb_redlevelsfluorescent' => { 194 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 194 => 0x1be },
	'wb_redlevelsshade' => { 194 => 0x168 },
	'wb_redlevelstungsten' => { 194 => 0xc0 },
	'wb_rgbglevels' => { 210 => 0x0 },
	'wb_rgblevels' => { 194 => [0x546,0x96], 351 => 0xd, 352 => 0x413, 357 => 0x3036, 400 => 0x107, 468 => 0x117c, 469 => 0x1180, 470 => 0x115c, 471 => 0x11d8, 472 => 0x11b4, 473 => 0x106c, 474 => 0x264, 475 => 0x264, 476 => 0x252 },
	'wb_rgblevels1' => { 362 => 0x2 },
	'wb_rgblevels2' => { 362 => 0x6 },
	'wb_rgblevels2500k' => { 466 => 0x782d },
	'wb_rgblevels3' => { 362 => 0xa },
	'wb_rgblevels3200k' => { 466 => 0x782c },
	'wb_rgblevels4' => { 362 => 0xe },
	'wb_rgblevels4500k' => { 466 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 362 => 0x12 },
	'wb_rgblevels6' => { 362 => 0x16 },
	'wb_rgblevels6000k' => { 466 => 0x782b },
	'wb_rgblevels7' => { 362 => 0x1a },
	'wb_rgblevels8500k' => { 466 => 0x782a },
	'wb_rgblevelsauto' => { 436 => 0x0 },
	'wb_rgblevelscloudy' => { 466 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 436 => 0x15 },
	'wb_rgblevelscustom2' => { 436 => 0x18 },
	'wb_rgblevelscustom3' => { 436 => 0x1b },
	'wb_rgblevelsdaylight' => { 436 => 0x3, 466 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 436 => 0x12, 466 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 436 => 0xf, 466 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 466 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 466 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 466 => 0x7828 },
	'wb_rgblevelsincandescent' => { 436 => 0xc },
	'wb_rgblevelsovercast' => { 436 => 0x9 },
	'wb_rgblevelsshade' => { 436 => 0x6, 466 => 0x7825 },
	'wb_rgblevelstungsten' => { 466 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 437 => 0x0 },
	'wb_rgblevelsunknown1' => { 437 => 0x3 },
	'wb_rgblevelsunknown2' => { 437 => 0x6 },
	'wb_rgblevelsunknown3' => { 437 => 0x9 },
	'wb_rgblevelsunknown4' => { 437 => 0xc },
	'wb_rgblevelsunknown5' => { 437 => 0xf },
	'wb_rgblevelsunknown6' => { 437 => 0x12 },
	'wb_rgblevelsunknown7' => { 437 => 0x15 },
	'wb_rgblevelsunknown8' => { 437 => 0x18 },
	'wb_rgblevelsunknown9' => { 437 => 0x1b },
	'wb_rgbmuldaylight' => { 145 => 0x852 },
	'wb_rgbmulflash' => { 145 => 0x855 },
	'wb_rgbmulfluorescent' => { 145 => 0x854 },
	'wb_rgbmultungsten' => { 145 => 0x853 },
	'wb_rggbblacklevels' => { 38 => 0x25 },
	'wb_rggblevels' => { 125 => 0x7313, 197 => 0x4, 209 => 0x0, 213 => 0x13e8, 214 => 0x38, 466 => 0x7313 },
	'wb_rggblevelsasshot' => { 41 => 0x0, 42 => 0x0, 43 => 0x19, 44 => 0x55, 45 => 0x69, 46 => 0x69, 47 => 0x22, 48 => 0x3f, 51 => 0x3f, 52 => 0x3f, 53 => 0x3f, 54 => 0x47 },
	'wb_rggblevelsauto' => { 38 => 0x1, 41 => 0x5, 42 => 0x8, 43 => 0x1e, 44 => 0x5a, 45 => 0x6e, 47 => 0x18, 48 => 0x44, 51 => 0x44, 52 => 0x44, 53 => 0x44, 54 => 0x4c, 213 => 0x1478, 214 => 0x114, 432 => 0xa022, 466 => 0x7312 },
	'wb_rggblevelsblack' => { 432 => 0xa028 },
	'wb_rggblevelscloudy' => { 38 => 0xd, 41 => 0x1e, 42 => 0x30, 43 => 0x2d, 44 => 0xa0, 45 => 0xd7, 46 => 0x78, 47 => 0x31, 48 => 0x58, 51 => 0x71, 52 => 0x8a, 53 => 0x8f, 54 => 0x92, 213 => 0x1408, 214 => 0x60, 391 => 0x20f, 399 => 0x14 },
	'wb_rggblevelscustom' => { 38 => 0x1d, 48 => 0x80, 213 => 0x1468, 214 => 0x100 },
	'wb_rggblevelscustom1' => { 43 => 0x41 },
	'wb_rggblevelscustom2' => { 43 => 0x46 },
	'wb_rggblevelsdaylight' => { 38 => 0x5, 41 => 0x14, 42 => 0x20, 43 => 0x23, 44 => 0x96, 45 => 0xcd, 46 => 0x6e, 47 => 0x27, 48 => 0x4e, 51 => 0x67, 52 => 0x80, 53 => 0x85, 54 => 0x88, 213 => 0x13f8, 214 => 0x4c, 391 => 0x20d, 399 => 0x2 },
	'wb_rggblevelsflash' => { 38 => 0x19, 41 => 0x32, 42 => 0x50, 43 => 0x3c, 44 => 0xb4, 45 => 0xeb, 46 => 0x87, 47 => 0x45, 48 => 0x6c, 51 => 0x85, 52 => 0x9e, 53 => 0xa3, 54 => 0xa6, 213 => 0x1448, 391 => 0x214, 399 => 0x41 },
	'wb_rggblevelsfluorescent' => { 38 => 0x15, 41 => 0x28, 42 => 0x40, 43 => 0x37, 44 => 0xaa, 45 => 0xe1, 46 => 0x82, 47 => 0x3b, 48 => 0x62, 51 => 0x7b, 52 => 0x94, 53 => 0x99, 54 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 214 => 0xc4, 391 => 0x211, 399 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 399 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 214 => 0xb0, 391 => 0x212, 399 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 213 => 0x1438, 214 => 0x9c, 391 => 0x213, 399 => 0x38 },
	'wb_rggblevelshtmercury' => { 214 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 432 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 432 => 0xa024 },
	'wb_rggblevelskelvin' => { 38 => 0x21, 41 => 0x2d, 42 => 0x48, 44 => 0xaf, 45 => 0xe6, 47 => 0x40, 48 => 0x67, 51 => 0x80, 52 => 0x99, 53 => 0x9e, 54 => 0xa1 },
	'wb_rggblevelsmeasured' => { 41 => 0xa, 42 => 0x10, 44 => 0x5f, 45 => 0x73, 48 => 0x49, 51 => 0x49, 52 => 0x49, 53 => 0x49, 54 => 0x51 },
	'wb_rggblevelspc1' => { 47 => 0x90, 48 => 0x71 },
	'wb_rggblevelspc2' => { 47 => 0x95, 48 => 0x76 },
	'wb_rggblevelspc3' => { 47 => 0x9a, 48 => 0x7b },
	'wb_rggblevelsshade' => { 38 => 0x9, 41 => 0x19, 42 => 0x28, 43 => 0x28, 44 => 0x9b, 45 => 0xd2, 46 => 0x73, 47 => 0x2c, 48 => 0x53, 51 => 0x6c, 52 => 0x85, 53 => 0x8a, 54 => 0x8d, 214 => 0x74, 391 => 0x20e, 399 => 0xb },
	'wb_rggblevelstungsten' => { 38 => 0x11, 41 => 0x23, 42 => 0x38, 43 => 0x32, 44 => 0xa5, 45 => 0xdc, 46 => 0x7d, 47 => 0x36, 48 => 0x5d, 51 => 0x76, 52 => 0x8f, 53 => 0x94, 54 => 0x97, 213 => 0x1428, 214 => 0x88, 391 => 0x210, 399 => 0x1d },
	'wb_rggblevelsuncorrected' => { 432 => 0xa021 },
	'wb_rggblevelsunknown' => { 41 => 0xf, 42 => 0x18, 44 => 0x64, 45 => 0x78, 47 => 0x1d, 51 => 0x4e, 52 => 0x4e, 53 => 0x4e, 54 => 0x56, 399 => 0x53 },
	'wb_rggblevelsunknown10' => { 41 => 0x5f, 42 => 0x98, 44 => 0x91, 45 => 0xa5, 46 => 0xb4, 47 => 0x72, 51 => 0x9e, 52 => 0x7b, 53 => 0x7b, 54 => 0x83 },
	'wb_rggblevelsunknown11' => { 41 => 0x64, 42 => 0xa0, 44 => 0xb9, 45 => [0xaa,0xaf], 46 => 0xb9, 47 => 0x77, 51 => 0xa3, 52 => 0xa3, 53 => 0x80, 54 => 0xab },
	'wb_rggblevelsunknown12' => { 41 => 0x69, 42 => 0xa8, 44 => 0xbe, 45 => 0xb4, 46 => 0xbe, 47 => 0x7c, 51 => 0xa8, 52 => 0xa8, 53 => 0xa8, 54 => 0xb0 },
	'wb_rggblevelsunknown13' => { 41 => 0x6e, 42 => 0xb0, 44 => 0xc3, 45 => 0xb9, 46 => 0xc3, 47 => 0x81, 51 => 0xad, 52 => 0xad, 53 => 0xad, 54 => 0xb5 },
	'wb_rggblevelsunknown14' => { 44 => 0xc8, 45 => 0xbe, 46 => 0xc8, 47 => 0x86, 51 => 0xb2, 52 => 0xb2, 53 => 0xb2, 54 => 0xba },
	'wb_rggblevelsunknown15' => { 44 => 0xcd, 45 => 0xc3, 46 => 0xcd, 47 => 0x8b, 51 => 0xb7, 52 => 0xb7, 53 => 0xb7, 54 => 0xbf },
	'wb_rggblevelsunknown16' => { 44 => 0xd2, 45 => 0xc8, 46 => 0xd2, 47 => 0x9f, 52 => 0xbc, 53 => 0xbc, 54 => 0xc4 },
	'wb_rggblevelsunknown17' => { 44 => 0xd7, 45 => 0xf0, 46 => 0xd7, 52 => 0xc1, 53 => 0xc1, 54 => 0xc9 },
	'wb_rggblevelsunknown18' => { 44 => 0xdc, 45 => 0xf5, 46 => 0xdc, 52 => 0xc6, 53 => 0xc6, 54 => 0xce },
	'wb_rggblevelsunknown19' => { 44 => 0xe1, 45 => 0xfa, 46 => 0xe1, 52 => 0xcb, 53 => 0xcb, 54 => 0xd3 },
	'wb_rggblevelsunknown2' => { 41 => 0x37, 42 => 0x58, 44 => 0x69, 45 => 0x7d, 46 => 0x8c, 47 => 0x4a, 51 => 0x53, 52 => 0x53, 53 => 0x53, 54 => 0x5b },
	'wb_rggblevelsunknown20' => { 44 => 0xe6, 45 => 0xff, 46 => 0xe6, 52 => 0xd0, 53 => 0xd0, 54 => 0xd8 },
	'wb_rggblevelsunknown21' => { 44 => 0xeb, 45 => 0x104, 46 => 0xeb, 53 => 0xd5, 54 => 0xdd },
	'wb_rggblevelsunknown22' => { 44 => 0xf0, 45 => 0x109, 46 => 0xf0, 53 => 0xda, 54 => 0xe2 },
	'wb_rggblevelsunknown23' => { 44 => 0xf5, 45 => 0x10e, 46 => 0xf5, 53 => 0xdf, 54 => 0xe7 },
	'wb_rggblevelsunknown24' => { 44 => 0xfa, 45 => 0x113, 46 => 0xfa, 53 => 0xe4, 54 => 0xec },
	'wb_rggblevelsunknown25' => { 44 => 0xff, 45 => 0x118, 46 => 0xff, 53 => 0xe9, 54 => 0xf1 },
	'wb_rggblevelsunknown26' => { 44 => 0x104, 45 => 0x11d, 46 => 0x104, 53 => 0xee, 54 => 0xf6 },
	'wb_rggblevelsunknown27' => { 44 => 0x109, 45 => 0x122, 46 => 0x109, 53 => 0xf3, 54 => 0xfb },
	'wb_rggblevelsunknown28' => { 44 => 0x10e, 46 => 0x10e, 53 => 0xf8, 54 => 0x100 },
	'wb_rggblevelsunknown29' => { 44 => 0x113, 46 => 0x113, 53 => 0xfd, 54 => 0x105 },
	'wb_rggblevelsunknown3' => { 41 => 0x3c, 42 => 0x60, 44 => 0x6e, 45 => 0x82, 46 => 0x91, 47 => 0x4f, 51 => 0x58, 52 => 0x58, 53 => 0x58, 54 => 0x60 },
	'wb_rggblevelsunknown30' => { 46 => 0x118, 53 => 0x102 },
	'wb_rggblevelsunknown31' => { 46 => 0x11d },
	'wb_rggblevelsunknown32' => { 46 => 0x122 },
	'wb_rggblevelsunknown33' => { 46 => 0x127 },
	'wb_rggblevelsunknown4' => { 41 => 0x41, 42 => 0x68, 44 => 0x73, 45 => 0x87, 46 => 0x96, 47 => 0x54, 51 => 0x5d, 52 => 0x5d, 53 => 0x5d, 54 => 0x65 },
	'wb_rggblevelsunknown5' => { 41 => 0x46, 42 => 0x70, 44 => 0x78, 45 => 0x8c, 46 => 0x9b, 47 => 0x59, 51 => 0x62, 52 => 0x62, 53 => 0x62, 54 => 0x6a },
	'wb_rggblevelsunknown6' => { 41 => 0x4b, 42 => 0x78, 44 => 0x7d, 45 => 0x91, 46 => 0xa0, 47 => 0x5e, 51 => 0x8a, 52 => 0x67, 53 => 0x67, 54 => 0x6f },
	'wb_rggblevelsunknown7' => { 41 => 0x50, 42 => 0x80, 44 => 0x82, 45 => 0x96, 46 => 0xa5, 47 => 0x63, 51 => 0x8f, 52 => 0x6c, 53 => 0x6c, 54 => 0x74 },
	'wb_rggblevelsunknown8' => { 41 => 0x55, 42 => 0x88, 44 => 0x87, 45 => 0x9b, 46 => 0xaa, 47 => 0x68, 51 => 0x94, 52 => 0x71, 53 => 0x71, 54 => 0x79 },
	'wb_rggblevelsunknown9' => { 41 => 0x5a, 42 => 0x90, 44 => 0x8c, 45 => 0xa0, 46 => 0xaf, 47 => 0x6d, 51 => 0x99, 52 => 0x76, 53 => 0x76, 54 => 0x7e },
	'wb_rggblevelsuserselected' => { 399 => 0x5c },
	'wbadjblueamber' => { 109 => 0x20106 },
	'wbadjbluebalance' => { 309 => 0x8 },
	'wbadjcolortemp' => { 109 => 0x20102, 114 => 0x1a },
	'wbadjlighting' => { 309 => 0x14 },
	'wbadjmagentagreen' => { 109 => 0x20105 },
	'wbadjmode' => { 309 => 0x10 },
	'wbadjredbalance' => { 309 => 0x0 },
	'wbadjrggblevels' => { 109 => 0x20125, 114 => 0x6 },
	'wbadjtemperature' => { 309 => 0x18 },
	'wbadjtint' => { 309 => 0x25 },
	'wbbluelevel' => { 350 => 0x324, 355 => 0x8006, 360 => 0x26 },
	'wbbracketingsteps' => { 205 => 0x10, 206 => 0x10, 283 => 0x174d },
	'wbbracketmode' => { 61 => 0x9 },
	'wbbracketshotnumber' => { 194 => 0x2b, 425 => 0x101a },
	'wbbracketvalueab' => { 61 => 0xc },
	'wbbracketvaluegm' => { 61 => 0xd },
	'wbbutton' => { 250 => 0x806, 253 => 0x80a, 254 => 0x80e },
	'wbbuttonplaybackmode' => { 327 => 0x1c5 },
	'wbfinetuneactive' => { 114 => 0x24 },
	'wbfinetunesaturation' => { 114 => 0x28 },
	'wbfinetunetone' => { 114 => 0x2c },
	'wbgreenlevel' => { 350 => 0x323, 355 => 0x8005, 360 => 0x25 },
	'wbmediaimagesizesetting' => { 90 => 0x708 },
	'wbmode' => { 196 => 0x4, 336 => 0x1015 },
	'wbredlevel' => { 350 => 0x322, 355 => 0x8004, 360 => 0x24 },
	'wbscale' => { 197 => 0x0 },
	'wbshiftab' => { 79 => 0xc, 355 => 0x46, 372 => 0x10 },
	'wbshiftab_gm' => { 459 => 0x2014 },
	'wbshiftab_gm_precise' => { 459 => 0x2026 },
	'wbshiftcreativecontrol' => { 355 => 0x92 },
	'wbshiftgm' => { 79 => 0xd, 355 => 0x47, 372 => 0x11 },
	'wbshiftintelligentauto' => { 355 => 0x8b },
	'wbtype1' => { 361 => 0x1, 362 => 0x1 },
	'wbtype2' => { 361 => 0x4, 362 => 0x5 },
	'wbtype3' => { 361 => 0x7, 362 => 0x9 },
	'wbtype4' => { 361 => 0xa, 362 => 0xd },
	'wbtype5' => { 361 => 0xd, 362 => 0x11 },
	'wbtype6' => { 361 => 0x10, 362 => 0x15 },
	'wbtype7' => { 361 => 0x13, 362 => 0x19 },
	'webstatement' => { 557 => 'WebStatement' },
	'weightedflatsubject' => { 515 => 'weightedFlatSubject' },
	'what' => { 524 => 'What', 526 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 79 => 0x8, 82 => 0x7, 118 => 0x7, 119 => [0x19,0x2012], 125 => [0xa403,0xfe4e], 133 => 0x1002, 145 => 0x3fc, 146 => 0xfa0d, 147 => 0x40, 158 => 0x1a, 188 => 0x3, 189 => 0xe, 190 => 0x4, 191 => 0xb, 193 => 0x115, 243 => 0x5, 292 => 0x7, 350 => 0x304, 355 => 0x3, 357 => 0x3033, 391 => 0x19, 398 => 0x7, 424 => 0x26, 425 => 0x1003, 435 => [0x88,0x3c,0x7,0x58], 445 => 0xf, 446 => 0xe, 459 => [0x115,0xb054], 524 => 'WhiteBalance', 526 => 'WhiteBalance', 530 => 'WhiteBalance' },
	'whitebalance0' => { 183 => 'WhiteBalance0' },
	'whitebalance1' => { 183 => 'WhiteBalance1' },
	'whitebalance2' => { 183 => 'WhiteBalance2', 331 => 0x500 },
	'whitebalanceadj' => { 109 => 0x20101, 114 => 0x18, 303 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 368 => 0x0 },
	'whitebalancebias' => { 119 => 0x2011, 336 => 0x304, 355 => 0x23 },
	'whitebalanceblue' => { 79 => 0x7 },
	'whitebalancebracket' => { 331 => 0x502, 336 => 0x303 },
	'whitebalancebracketing' => { 191 => 0x22, 194 => 0x2c, 456 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 328 => 0x1c5, 329 => 0x1dd },
	'whitebalancecomp' => { 339 => 0x1001 },
	'whitebalancedetected' => { 145 => 0x3fb },
	'whitebalancefinetune' => { 133 => 0x100a, 191 => 0x38, 193 => 0x112, 243 => [0xb,0x3f], 425 => 0x1004, 445 => 0x6, 446 => 0x5, 459 => 0x112 },
	'whitebalancemode' => { 145 => 0x3fa, 391 => 0x1a },
	'whitebalancered' => { 79 => 0x6 },
	'whitebalanceset' => { 371 => 0xa },
	'whitebalancesetting' => { 191 => 0x23, 445 => 0x5, 446 => 0x4, 447 => 0x16, 464 => 0xd },
	'whitebalancesetup' => { 432 => 0x41 },
	'whitebalancetemperature' => { 331 => 0x501 },
	'whiteboard' => { 336 => 0x301 },
	'whitelevel' => { 125 => 0xc61d, 391 => 0x7e, 466 => 0x787f },
	'whitepoint' => { 125 => 0x13e, 354 => 0x35d, 391 => 0x201, 549 => 'WhitePoint' },
	'whites2012' => { 524 => 'Whites2012', 526 => 'Whites2012' },
	'whitesadj' => { 496 => 0x9017 },
	'wideadapter' => { 425 => 0x1017 },
	'widefocuszone' => { 188 => 0x2f },
	'widerange' => { 434 => 0x20f },
	'windmode' => { 145 => 0x3f4 },
	'windnoisereduction' => { 249 => 0x352, 250 => 0x352, 251 => 0x2d6, 252 => 0x2fe, 253 => 0x2fe, 254 => 0x302 },
	'windowlocation' => { 417 => 'WLOC' },
	'windowsatom' => { 525 => 'windowsAtom' },
	'windowsatomextension' => { 525 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 525 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 525 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 543 => 'wordCount' },
	'work' => { 409 => "\xa9wrk" },
	'workcolorspace' => { 109 => 0x10200, 114 => 0x270 },
	'workflowtag' => { 538 => 'WorkflowTag' },
	'workflowtagcvid' => { 538 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 538 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 538 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 538 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 532 => 'WorkToDo' },
	'worldtimelocation' => { 355 => 0x3a, 391 => 0x22, 397 => '0.1' },
	'writer' => { 186 => 'WM/Writer' },
	'writer-editor' => { 138 => 0x7a },
	'x3filllight' => { 435 => 0x12 },
	'xattrmditemwherefroms' => { 181 => 'com.apple.metadata:kMDItemWhereFroms' },
	'xattrquarantine' => { 181 => 'com.apple.quarantine' },
	'xiaomiexifinfo' => { 411 => 'xiaomi.exifInfo.videoinfo' },
	'xiaomihdr10' => { 411 => 'com.xiaomi.hdr10' },
	'xiaomimodel' => { 125 => 0x9a00 },
	'xiaomipreviewvideocover' => { 411 => 'com.xiaomi.preview_video_cover' },
	'xiaomisettings' => { 125 => 0x9999 },
	'xilinxversion' => { 145 => 0x414 },
	'xml' => { 143 => 'xml ' },
	'xmp' => { 112 => 0xffff00f6, 126 => 'XMP', 136 => 'XMP Data/XMP' },
	'xmptoolkit' => { 550 => 'xmptk' },
	'xpauthor' => { 125 => 0x9c9d },
	'xpcomment' => { 125 => 0x9c9c },
	'xpkeywords' => { 125 => 0x9c9e },
	'xposition' => { 125 => 0x11e },
	'xpsubject' => { 125 => 0x9c9f },
	'xptitle' => { 125 => 0x9c9b },
	'xresolution' => { 125 => 0x11a, 141 => 0x3, 406 => 0x0, 549 => 'XResolution' },
	'xyresolution' => { 129 => 0x3 },
	'yaw' => { 121 => 0x7, 417 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 259 => 0x8, 430 => 0x0 },
	'ycbcrcoefficients' => { 125 => 0x211, 549 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 125 => 0x213, 549 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 125 => 0x212, 549 => 'YCbCrSubSampling' },
	'year' => { 409 => 'yrrc', 411 => 'year', 417 => 'yrrc' },
	'yearcreated' => { 147 => 0x10, 156 => 0xc },
	'yellowhsl' => { 109 => 0x20912 },
	'yield' => { 545 => 'yield' },
	'yposition' => { 125 => 0x11f },
	'yresolution' => { 125 => 0x11b, 141 => 0x5, 406 => 0x4, 549 => 'YResolution' },
	'zebrapatterntonerange' => { 327 => 0x211, 328 => 0x211, 329 => 0x229 },
	'zoneidentifier' => { 126 => 'ZoneIdentifier' },
	'zonematching' => { 193 => 0x10a, 196 => [0x3a,0x4a], 459 => 0xb024 },
	'zonematchingmode' => { 191 => 0x14 },
	'zonematchingon' => { 190 => 0x75 },
	'zonematchingvalue' => { 445 => 0x1f },
	'zoomedpreviewlength' => { 336 => 0xf05 },
	'zoomedpreviewsize' => { 336 => 0xf06 },
	'zoomedpreviewstart' => { 336 => 0xf04 },
	'zoomsourcewidth' => { 37 => 0x24 },
	'zoomstepcount' => { 334 => 0x300, 336 => 0x100d },
	'zoomtargetwidth' => { 37 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acdsee-rs' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actors' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aistream' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'alerts' => 1,
	'alexa' => 1,
	'alexa-paireddevicename' => 1,
	'alexa-pairing' => 1,
	'alexa-privacymode' => 1,
	'alexa-wakewordlanguage' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaisused' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'apdi' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiounwarped' => 1,
	'aspectratiowarped' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobluetooth' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiokeys' => 1,
	'audiolayer' => 1,
	'audiolevel' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioprotuneoption' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autoboostscore' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autopoweroff' => 1,
	'autoprotune' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitratesetting' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetoothmacaddress' => 1,
	'bluetoothname' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'byterange' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pa' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfog5xii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfor6m2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedelaytimer' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbor' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel01' => 1,
	'channel01description' => 1,
	'channel01dispmax' => 1,
	'channel01dispmin' => 1,
	'channel01flags' => 1,
	'channel01id' => 1,
	'channel01interval' => 1,
	'channel01max' => 1,
	'channel01min' => 1,
	'channel01multiplier' => 1,
	'channel01name' => 1,
	'channel01num' => 1,
	'channel01offset' => 1,
	'channel01type' => 1,
	'channel01units' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelcolordata' => 1,
	'channelcolorindicates' => 1,
	'channelcolorspace' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelopacity' => 1,
	'channeloptions' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chrominancetable' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationdatapresent' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalance0219' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown1' => 1,
	'colorbalanceunknown2' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata12' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransferfunction' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confidencemapimage' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'controllevel' => 1,
	'conttake' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coordinateunits' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custominfo' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz6iii' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'date1' => 1,
	'date2' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultsettings' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapimage' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'devicesounds' => 1,
	'dex' => 1,
	'diagonalfieldofview' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digestalgorithm' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'digitalzoomamount' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djidebug' => 1,
	'djimetadata' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'domain' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualfiles' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'durationsetting' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'ef' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicstabilizationon' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emergencysos' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exefilename' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposuretype' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'extremeweathermode' => 1,
	'f-stop' => 1,
	'f_' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fcc-id' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatsdcard' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'framedelay' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'garminmodel' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcontainer' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generalencapsulatedobject' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geob-data' => 1,
	'geob-desc' => 1,
	'geob-file' => 1,
	'geob-mime' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geolocationbearing' => 1,
	'geolocationcity' => 1,
	'geolocationcountry' => 1,
	'geolocationcountrycode' => 1,
	'geolocationdistance' => 1,
	'geolocationfeaturecode' => 1,
	'geolocationfeaturetype' => 1,
	'geolocationpopulation' => 1,
	'geolocationposition' => 1,
	'geolocationregion' => 1,
	'geolocationsubregion' => 1,
	'geolocationtimezone' => 1,
	'geolocationwarning' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalpalette' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'google' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gpmd_wolfbox' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsaltitudesystem' => 1,
	'gpsdata' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshomelatitude' => 1,
	'gpshomelongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpsinfo9' => 1,
	'gpslatitude2' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongitude2' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpsstamp' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'gravityvector' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'gridsize' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'halftonedegree' => 1,
	'halftonelpi' => 1,
	'halftonelpiunit' => 1,
	'halftonemisc' => 1,
	'halftonescreen' => 1,
	'halftoneshape' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasselbladxml' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdgainmapinfo' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgaincurve' => 1,
	'hdrgainmap' => 1,
	'hdrgm' => 1,
	'hdrimage' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdrvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddendata' => 1,
	'hiddeninfo' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hindsightsettings' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintmaxoutputvalue' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizoncontrol' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestabilisation' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imdb_id' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexbackground' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indextransparent' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsoninfo' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'keepusersettings' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keyalgorithm' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'keyversion' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensprojection' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'levelinfok3iii' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'ligogpsinfo' => 1,
	'ligojson' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedfilename' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'linux' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopcount' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'lumaaverage' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'luminancetable' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magneticvariation' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mappingxcoefficients' => 1,
	'mappingxmode' => 1,
	'mappingycoefficients' => 1,
	'mappingymode' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'marlindataversion' => 1,
	'marlindictionary' => 1,
	'marlinheader' => 1,
	'marlinvalues' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'mediamode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8' => 1,
	'menusettingsoffsetz8v2' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microphonewet' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modelstamp' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'mynextbase-paireddevicename' => 1,
	'mynextbase-pairing' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nbcd' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nextbasemeta' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlicenseplate' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'oleinfo' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'oneplus' => 1,
	'oneplustrailerlen' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationdatapresent' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parkingmode' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdbage' => 1,
	'pdbcreatedate' => 1,
	'pdbfilename' => 1,
	'pdbmodifydate' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'pdrversion' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'peg_info' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopstream' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'polynomialcoefficients' => 1,
	'polynomialpower' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'powerprofile' => 1,
	'pragma' => 1,
	'prediminanthue' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewjxl' => 1,
	'previewjxllength' => 1,
	'previewjxlstart' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsbleedwidth' => 1,
	'printflagsbleedwidthscale' => 1,
	'printflagscrop' => 1,
	'printflagsinfo' => 1,
	'printflagsversion' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protocol' => 1,
	'protune' => 1,
	'protuneisomode' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafcompression' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagenumber' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzoomactive' => 1,
	'rawzoomsize' => 1,
	'rawzoomtopleft' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinghistory' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'remasterinfo' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resolutionxlengthunit' => 1,
	'resolutionxunit' => 1,
	'resolutionylengthunit' => 1,
	'resolutionyunit' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'reversingcamera' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohinfo' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrdta' => 1,
	'ricohrdtb' => 1,
	'ricohrdtc' => 1,
	'ricohrdtg' => 1,
	'ricohrdtl' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtos' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungcaptureinfo' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungmodel' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'sceneclassification' => 1,
	'scenecolorimetryestimates' => 1,
	'sceneilluminance' => 1,
	'schedulecapture' => 1,
	'schedulecapturetime' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screendimming' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screensaver' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcardclass' => 1,
	'sdcardformat' => 1,
	'sdcardmanfdate' => 1,
	'sdcardmanfid' => 1,
	'sdcardmodelno' => 1,
	'sdcardoemid' => 1,
	'sdcardserialno' => 1,
	'sdcardsize' => 1,
	'sdcardtype' => 1,
	'sdcardusedspace' => 1,
	'sdcc-flp' => 1,
	'sealcomment' => 1,
	'sealversion' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondcam' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqcount' => 1,
	'seqfinal' => 1,
	'seqframeinfo' => 1,
	'seqid' => 1,
	'seqindex' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'seqtype' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'serialnumber2' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz6iii' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureformat' => 1,
	'signaturelength' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyhiddendata' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'speedrampsetting' => 1,
	'speedstamp' => 1,
	'speedunits' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spotmeter' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systeminfo' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag9406b' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailartist' => 1,
	'thumbnailbitspersample' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcolordepth' => 1,
	'thumbnailcompressedsize' => 1,
	'thumbnailcompression' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailcopyright' => 1,
	'thumbnaildata' => 1,
	'thumbnaildatetime' => 1,
	'thumbnaildescription' => 1,
	'thumbnailequipmake' => 1,
	'thumbnailequipmodel' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailimageheight' => 1,
	'thumbnailimagewidth' => 1,
	'thumbnailorientation' => 1,
	'thumbnailphotometricinterp' => 1,
	'thumbnailplanarconfig' => 1,
	'thumbnailplanes' => 1,
	'thumbnailprimarychromaticities' => 1,
	'thumbnailrawbytes' => 1,
	'thumbnailref' => 1,
	'thumbnailrefblackwhite' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailresolutionunit' => 1,
	'thumbnailresolutionx' => 1,
	'thumbnailresolutiony' => 1,
	'thumbnailrowsperstrip' => 1,
	'thumbnailsamplesperpixel' => 1,
	'thumbnailsoftware' => 1,
	'thumbnailstripbytecounts' => 1,
	'thumbnailstripoffsets' => 1,
	'thumbnailtiff' => 1,
	'thumbnailtransferfunction' => 1,
	'thumbnailurl' => 1,
	'thumbnailwhitepoint' => 1,
	'thumbnailycbcrcoefficients' => 1,
	'thumbnailycbcrpositioning' => 1,
	'thumbnailycbcrsubsampling' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'time1' => 1,
	'time2' => 1,
	'timeanddate' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelapse' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'timezonedst' => 1,
	'tipl' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'tmdb_id' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uniformresourcename' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'uniqueidentifier' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_grpl' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videokeys' => 1,
	'videolength' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignetteinfo' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'visualsampledesc' => 1,
	'vivo' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'what3words' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wi-fimacaddress' => 1,
	'wi-fipassword' => 1,
	'wi-fissid' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windprocessing' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpdsa' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomscalenormalization' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2025, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
