#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.20';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoG5XII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData12',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LevelInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::Canon::uuid',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GIF::Extensions',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::ColorBalanceUnknown2',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::DistortionInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ6III',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ8v2',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::VignetteInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ6III',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::DSA',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::LevelInfoK3III',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::HiddenInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag9406b',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::ACDSeeRegions',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GContainer',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 114 => 0x69 },
	'about' => { 541 => 'about' },
	'aboutcvterm' => { 532 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 532 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 532 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 532 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 532 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 121 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 547 => 'absPeakAudioFilePath' },
	'academicfield' => { 537 => 'academicField' },
	'acceleration' => { 124 => 0x9404, 525 => 'Acceleration' },
	'accelerationtracking' => { 89 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 424 => 0x3 },
	'accelerometerdata' => { 414 => 'vrot' },
	'accelerometerx' => { 353 => 0x8d },
	'accelerometery' => { 353 => 0x8e },
	'accelerometerz' => { 353 => 0x8c },
	'accessoryserialnumber' => { 353 => 0x54 },
	'accessorytype' => { 353 => 0x53 },
	'acdseeregion' => { 493 => [\'Regions','RegionsRegionList'] },
	'acdseeregionalgarea' => { 493 => [\'Regions','RegionsRegionListALGArea'] },
	'acdseeregionalgareah' => { 493 => [\'Regions','RegionsRegionListALGAreaH'] },
	'acdseeregionalgareaw' => { 493 => [\'Regions','RegionsRegionListALGAreaW'] },
	'acdseeregionalgareax' => { 493 => [\'Regions','RegionsRegionListALGAreaX'] },
	'acdseeregionalgareay' => { 493 => [\'Regions','RegionsRegionListALGAreaY'] },
	'acdseeregionappliedtodimensions' => { 493 => [\'Regions','RegionsAppliedToDimensions'] },
	'acdseeregionappliedtodimensionsh' => { 493 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'acdseeregionappliedtodimensionsunit' => { 493 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'acdseeregionappliedtodimensionsw' => { 493 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'acdseeregiondlyarea' => { 493 => [\'Regions','RegionsRegionListDLYArea'] },
	'acdseeregiondlyareah' => { 493 => [\'Regions','RegionsRegionListDLYAreaH'] },
	'acdseeregiondlyareaw' => { 493 => [\'Regions','RegionsRegionListDLYAreaW'] },
	'acdseeregiondlyareax' => { 493 => [\'Regions','RegionsRegionListDLYAreaX'] },
	'acdseeregiondlyareay' => { 493 => [\'Regions','RegionsRegionListDLYAreaY'] },
	'acdseeregionname' => { 493 => [\'Regions','RegionsRegionListName'] },
	'acdseeregionnameassigntype' => { 493 => [\'Regions','RegionsRegionListNameAssignType'] },
	'acdseeregiontype' => { 493 => [\'Regions','RegionsRegionListType'] },
	'actionadvised' => { 137 => 0x2a },
	'activearea' => { 124 => 0xc68d },
	'actived-lighting' => { 242 => 0x22, 299 => 0x24 },
	'actived-lightingmode' => { 299 => 0x25 },
	'adaptervoltage' => { 144 => 0x407 },
	'addaspectratioinfo' => { 89 => 0x80e },
	'addiptcinformation' => { 89 => 0x815 },
	'additionalmodelinformation' => { 532 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 89 => 0x80f, 90 => 0x11, 91 => 0x13, 94 => 0x14 },
	'address' => { 167 => 'Address' },
	'adjustmentmode' => { 431 => 0x15 },
	'adlbracketingstep' => { 204 => 0x17 },
	'adlbracketingtype' => { 204 => 0x18 },
	'adobe' => { 125 => 'Adobe' },
	'adultcontentwarning' => { 339 => 'AdultContentWarning', 540 => 'adultContentWarning' },
	'advancedfilter' => { 132 => 0x1201 },
	'advancedraw' => { 301 => 0x76a43203 },
	'advancedscenetype' => { 353 => 0x3d },
	'advisory' => { 545 => 'Advisory' },
	'ae_iso' => { 361 => 0x2, 362 => 0x4, 363 => 0x12 },
	'aeaperture' => { 361 => 0x1, 362 => 0x3, 363 => 0x11 },
	'aeaperturesteps' => { 361 => 0x8, 362 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 89 => 0x104 },
	'aebbracketvalue' => { 81 => 0x11 },
	'aebracketingsteps' => { 204 => 0xf, 205 => 0xf, 281 => 0x174c },
	'aebsequence' => { 89 => 0x105 },
	'aebsequenceautocancel' => { 87 => 0x9, 88 => 0x9, 90 => 0x8, 91 => 0x9, 94 => 0x9, 95 => 0x7 },
	'aebshotcount' => { 89 => 0x106 },
	'aebxv' => { 361 => 0x4, 362 => 0x6 },
	'aeerror' => { 362 => 0x8 },
	'aeexposuretime' => { 361 => 0x0, 362 => 0x2, 363 => 0x10 },
	'aelbutton' => { 190 => 0x45 },
	'aelexposureindicator' => { 190 => 0x51 },
	'aelock' => { 190 => 0x5b, 310 => '4.2', 319 => '4.2', 329 => 0x201, 389 => 0x48, 441 => 0x40, 442 => 0x40, 443 => [0x86,0x286] },
	'aelockbutton' => { 308 => '16.1', 310 => '4.1', 313 => '15.1', 314 => '16.1', 315 => '16.1', 317 => '30.1', 318 => '16.1', 319 => '4.1', 321 => '17.1', 323 => '17.1' },
	'aelockbuttonplusdials' => { 308 => '16.2', 317 => '32.1', 321 => '44.1' },
	'aelockformb-d80' => { 323 => '3.1' },
	'aelockmetermodeafterfocus' => { 89 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 361 => 0x9, 362 => 0x10, 363 => 0x1c },
	'aemaxaperture2' => { 361 => 0xa, 362 => 0x11, 363 => 0x1d },
	'aemeteringmode' => { 361 => 0xc },
	'aemeteringmode2' => { 361 => '13.1' },
	'aemeteringsegments' => { 193 => 0x628, 389 => 0x209 },
	'aemicroadjustment' => { 89 => 0x110 },
	'aeminaperture' => { 361 => 0xb, 362 => 0x12, 363 => 0x1e },
	'aeminexposuretime' => { 361 => 0x5, 362 => 0x13, 363 => 0x1f },
	'aeprogrammode' => { 361 => 0x6 },
	'aeprojectlink' => { 519 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 519 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 519 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 519 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 519 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 519 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 36 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aestheticscore' => { 342 => 'aesthetic_score' },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 361 => 0xd },
	'aexv' => { 361 => 0x3, 362 => 0x5 },
	'af-assistilluminator' => { 324 => 0x1a, 325 => 0x19, 326 => 0x19, 327 => 0x19 },
	'af-cfocusdisplay' => { 325 => 0x234, 326 => 0x234, 327 => 0x24c },
	'af-cpriority' => { 133 => '0.2' },
	'af-cpriorityselection' => { 308 => '1.1', 309 => '1.1', 311 => '1.1', 312 => '1.1', 314 => '0.1', 315 => '0.1', 316 => '0.1', 317 => '1.1', 318 => '0.1', 321 => '1.1', 322 => '1.1', 324 => 0x3, 325 => 0x3, 326 => 0x3, 327 => 0x3 },
	'af-csetting' => { 129 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 129 => '0.2' },
	'af-ctrackingsensitivity' => { 129 => '0.1' },
	'af-czoneareaswitching' => { 129 => '0.3' },
	'af-onbutton' => { 311 => '70.1', 312 => '70.1', 322 => '70.1' },
	'af-onformb-d10' => { 308 => '3.3', 317 => '3.2' },
	'af-onformb-d11' => { 318 => '2.2' },
	'af-onformb-d12' => { 321 => '50.1' },
	'af-onoutoffocusrelease' => { 324 => 0x10, 325 => 0x10, 326 => 0x10, 327 => 0x10 },
	'af-spriority' => { 133 => '0.1' },
	'af-spriorityselection' => { 308 => '1.2', 309 => '1.2', 311 => '1.2', 312 => '1.2', 316 => '0.2', 317 => '1.2', 318 => '0.2', 321 => '1.2', 322 => '1.2', 324 => 0x5, 325 => 0x5, 326 => 0x5, 327 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 308 => '2.1', 309 => '2.1', 311 => '78.3', 312 => '78.3', 317 => '2.1', 321 => '2.1', 322 => '78.3', 324 => 0xf, 325 => 0xf, 326 => 0xf, 327 => 0xf },
	'afadjustment' => { 389 => 0x72, 398 => 0x267 },
	'afandmeteringbuttons' => { 89 => 0x701 },
	'afaperture' => { 235 => 0x5, 236 => 0x5, 240 => 0x5 },
	'afareaheight' => { 199 => [0x1a,0x34,0x50], 200 => 0x48 },
	'afareaillumination' => { 190 => 0x4b, 319 => '15.3' },
	'afareainitialheight' => { 256 => 0xbeb },
	'afareainitialwidth' => { 256 => 0xbea },
	'afareainitialxposition' => { 256 => 0xbe8 },
	'afareainitialyposition' => { 256 => 0xbe9 },
	'afareamode' => { 131 => '0.3', 186 => 0x33, 190 => 0xe, 198 => 0x0, 199 => 0x5, 200 => 0x5, 246 => 0x340, 248 => 0x224, 249 => 0x224, 250 => 0x210, 251 => 0x224, 252 => 0x224, 353 => 0xf, 421 => 0x1205, 434 => [0xa,0x3a], 441 => 0x11, 442 => 0x10, 443 => 0x24, 455 => 0xb043, 481 => 0x17 },
	'afareamodesetting' => { 310 => '11.1', 313 => '0.1', 319 => '16.1', 323 => '2.1', 455 => 0x201c },
	'afareapointsize' => { 131 => '0.4' },
	'afareas' => { 329 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 89 => 0x51b },
	'afareawidth' => { 199 => [0x18,0x32,0x4e], 200 => 0x46 },
	'afareaxposition' => { 199 => [0x14,0x2e,0x4a], 200 => 0x42, 421 => 0x1203 },
	'afareaxposition1' => { 421 => 0x1201 },
	'afareayposition' => { 199 => [0x16,0x30,0x4c], 200 => 0x44, 421 => 0x1204 },
	'afareayposition1' => { 421 => 0x1202 },
	'afareazonesize' => { 131 => '0.5' },
	'afassist' => { 87 => 0x5, 95 => 0x5, 190 => 0x48, 308 => '2.5', 310 => '0.2', 313 => '0.2', 314 => '1.1', 315 => '1.1', 316 => '1.3', 317 => '2.4', 318 => '1.3', 319 => '0.2', 321 => '2.4', 323 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 89 => 0x50e, 90 => 0x4, 91 => 0x5, 92 => 0x4, 93 => 0x4, 94 => 0x5 },
	'afassistlamp' => { 353 => 0x31 },
	'afbuttonpressed' => { 443 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 364 => 0x6 },
	'afduringliveview' => { 89 => 0x511 },
	'affinea' => { 512 => 'AffineA' },
	'affineb' => { 512 => 'AffineB' },
	'affinec' => { 512 => 'AffineC' },
	'affined' => { 512 => 'AffineD' },
	'affinetune' => { 201 => 0x0, 248 => 0x6b0, 249 => 0x6c0, 250 => 0x5b0, 251 => 0x5e0, 252 => 0x5f8, 329 => 0x306 },
	'affinetuneadj' => { 201 => 0x2, 274 => 0x2d1, 275 => 0x2dc, 329 => 0x307 },
	'affinetuneadjtele' => { 201 => 0x3 },
	'affinetuneindex' => { 201 => 0x1 },
	'affinex' => { 512 => 'AffineX' },
	'affiney' => { 512 => 'AffineY' },
	'afhold' => { 364 => 0x1fd },
	'afilluminator' => { 441 => 0x29, 455 => 0xb044 },
	'afimageheight' => { 199 => [0x12,0x2c,0x48], 200 => 0x40 },
	'afimagewidth' => { 199 => [0x10,0x2a,0x46], 200 => 0x3e },
	'afintegrationtime' => { 364 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 434 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 438 => 0x131 },
	'afmicroadjregisteredlenses' => { 438 => '305.1' },
	'afmicroadjustment' => { 89 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 438 => 0x130 },
	'afmode' => { 118 => 0x3009, 132 => 0x1022, 186 => 0x16, 431 => 0x5 },
	'afmoderestrictions' => { 309 => '50.3', 311 => '48.3', 312 => '48.3', 321 => '48.3', 322 => '48.3' },
	'afonaelockbuttonswitch' => { 89 => 0x702 },
	'afonbutton' => { 308 => '3.1', 309 => '47.1', 324 => 0x87, 325 => 0x83, 326 => 0x83, 327 => 0x83 },
	'afperformance' => { 1 => 0x23 },
	'afpoint' => { 36 => 0x13, 117 => 0x18, 186 => 0x15, 198 => 0x1, 332 => 0x308, 431 => 0x1f, 434 => [0x37,0x7], 438 => 0x19, 439 => 0x18, 440 => [0x18,0x20] },
	'afpointactivationarea' => { 88 => 0x11, 94 => 0x11 },
	'afpointareaexpansion' => { 89 => 0x508 },
	'afpointatshutterrelease' => { 434 => [0x39,0x9] },
	'afpointautoselection' => { 89 => 0x50b },
	'afpointbrightness' => { 89 => 0x50d, 308 => '2.4', 309 => '46.5', 311 => '2.2', 312 => '2.2', 321 => '2.3', 322 => '2.2' },
	'afpointdetails' => { 332 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 89 => 0x50c },
	'afpointillumination' => { 88 => 0xa, 308 => '2.3', 309 => '46.2', 311 => '47.2', 312 => '47.2', 316 => '1.2', 317 => '2.3', 318 => '1.2', 321 => '47.2', 322 => '47.2', 323 => '2.4' },
	'afpointinfocus' => { 434 => [0x38,0x8] },
	'afpointmode' => { 369 => 0x3 },
	'afpointposition' => { 118 => 0x2021, 353 => 0x4d },
	'afpointregistration' => { 87 => 0x7 },
	'afpoints' => { 189 => 0x10 },
	'afpointsel' => { 324 => 0xb, 325 => 0xb, 326 => 0xb, 327 => 0xb },
	'afpointselected' => { 190 => 0xd, 329 => 0x305, 389 => 0xe, 438 => 0x15, 439 => 0x14, 440 => [0x14,0x1c], 455 => 0x201e },
	'afpointselected2' => { 369 => 0x4 },
	'afpointselection' => { 88 => 0xb, 308 => '1.3', 309 => '1.3', 317 => '1.3', 321 => '1.3', 322 => '1.3' },
	'afpointselectionmethod' => { 89 => 0x50f, 90 => 0xc, 91 => 0xd, 94 => 0xd },
	'afpointsetting' => { 441 => 0x12, 442 => 0x11 },
	'afpointsinfocus' => { 81 => 0xe, 198 => 0x2, 199 => 0x30, 364 => 0xb, 365 => 0x4, 389 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 88 => 0xd },
	'afpointsselected' => { 199 => 0x1c, 365 => '4.1', 490 => 0x4 },
	'afpointsspecial' => { 365 => '4.2' },
	'afpointsunknown1' => { 364 => 0x0 },
	'afpointsunknown2' => { 364 => 0x2 },
	'afpointsused' => { 199 => [0xa,0x8], 200 => 0xa, 434 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 364 => 0x4 },
	'afresponse' => { 242 => 0xad },
	'afresult' => { 334 => 0x1038 },
	'afsearch' => { 329 => 0x303 },
	'afsensoractive' => { 186 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 421 => 0x1200 },
	'afstatus_00_b4' => { 437 => 0x0 },
	'afstatus_01_c4' => { 437 => 0x2 },
	'afstatus_02_d4' => { 437 => 0x4 },
	'afstatus_03_e4' => { 437 => 0x6 },
	'afstatus_04_f4' => { 437 => 0x8 },
	'afstatus_05_g4' => { 437 => 0xa },
	'afstatus_06_h4' => { 437 => 0xc },
	'afstatus_07_b3' => { 437 => 0xe },
	'afstatus_08_c3' => { 437 => 0x10 },
	'afstatus_09_d3' => { 437 => 0x12 },
	'afstatus_10_e3' => { 437 => 0x14 },
	'afstatus_11_f3' => { 437 => 0x16 },
	'afstatus_12_g3' => { 437 => 0x18 },
	'afstatus_13_h3' => { 437 => 0x1a },
	'afstatus_14_b2' => { 437 => 0x1c },
	'afstatus_15_c2' => { 437 => 0x1e },
	'afstatus_16_d2' => { 437 => 0x20 },
	'afstatus_17_e2' => { 437 => 0x22 },
	'afstatus_18_f2' => { 437 => 0x24 },
	'afstatus_19_g2' => { 437 => 0x26 },
	'afstatus_20_h2' => { 437 => 0x28 },
	'afstatus_21_c1' => { 437 => 0x2a },
	'afstatus_22_d1' => { 437 => 0x2c },
	'afstatus_23_e1' => { 437 => 0x2e },
	'afstatus_24_f1' => { 437 => 0x30 },
	'afstatus_25_g1' => { 437 => 0x32 },
	'afstatus_26_a7_vertical' => { 437 => 0x34 },
	'afstatus_27_a6_vertical' => { 437 => 0x36 },
	'afstatus_28_a5_vertical' => { 437 => 0x38 },
	'afstatus_29_c7_vertical' => { 437 => 0x3a },
	'afstatus_30_c6_vertical' => { 437 => 0x3c },
	'afstatus_31_c5_vertical' => { 437 => 0x3e },
	'afstatus_32_e7_vertical' => { 437 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 437 => 0x42 },
	'afstatus_34_e5_vertical' => { 437 => 0x44 },
	'afstatus_35_g7_vertical' => { 437 => 0x46 },
	'afstatus_36_g6_vertical' => { 437 => 0x48 },
	'afstatus_37_g5_vertical' => { 437 => 0x4a },
	'afstatus_38_i7_vertical' => { 437 => 0x4c },
	'afstatus_39_i6_vertical' => { 437 => 0x4e },
	'afstatus_40_i5_vertical' => { 437 => 0x50 },
	'afstatus_41_a7' => { 437 => 0x52 },
	'afstatus_42_b7' => { 437 => 0x54 },
	'afstatus_43_c7' => { 437 => 0x56 },
	'afstatus_44_d7' => { 437 => 0x58 },
	'afstatus_45_e7' => { 437 => 0x5a },
	'afstatus_46_f7' => { 437 => 0x5c },
	'afstatus_47_g7' => { 437 => 0x5e },
	'afstatus_48_h7' => { 437 => 0x60 },
	'afstatus_49_i7' => { 437 => 0x62 },
	'afstatus_50_a6' => { 437 => 0x64 },
	'afstatus_51_b6' => { 437 => 0x66 },
	'afstatus_52_c6' => { 437 => 0x68 },
	'afstatus_53_d6' => { 437 => 0x6a },
	'afstatus_54_e6_center' => { 437 => 0x6c },
	'afstatus_55_f6' => { 437 => 0x6e },
	'afstatus_56_g6' => { 437 => 0x70 },
	'afstatus_57_h6' => { 437 => 0x72 },
	'afstatus_58_i6' => { 437 => 0x74 },
	'afstatus_59_a5' => { 437 => 0x76 },
	'afstatus_60_b5' => { 437 => 0x78 },
	'afstatus_61_c5' => { 437 => 0x7a },
	'afstatus_62_d5' => { 437 => 0x7c },
	'afstatus_63_e5' => { 437 => 0x7e },
	'afstatus_64_f5' => { 437 => 0x80 },
	'afstatus_65_g5' => { 437 => 0x82 },
	'afstatus_66_h5' => { 437 => 0x84 },
	'afstatus_67_i5' => { 437 => 0x86 },
	'afstatus_68_c11' => { 437 => 0x88 },
	'afstatus_69_d11' => { 437 => 0x8a },
	'afstatus_70_e11' => { 437 => 0x8c },
	'afstatus_71_f11' => { 437 => 0x8e },
	'afstatus_72_g11' => { 437 => 0x90 },
	'afstatus_73_b10' => { 437 => 0x92 },
	'afstatus_74_c10' => { 437 => 0x94 },
	'afstatus_75_d10' => { 437 => 0x96 },
	'afstatus_76_e10' => { 437 => 0x98 },
	'afstatus_77_f10' => { 437 => 0x9a },
	'afstatus_78_g10' => { 437 => 0x9c },
	'afstatus_79_h10' => { 437 => 0x9e },
	'afstatus_80_b9' => { 437 => 0xa0 },
	'afstatus_81_c9' => { 437 => 0xa2 },
	'afstatus_82_d9' => { 437 => 0xa4 },
	'afstatus_83_e9' => { 437 => 0xa6 },
	'afstatus_84_f9' => { 437 => 0xa8 },
	'afstatus_85_g9' => { 437 => 0xaa },
	'afstatus_86_h9' => { 437 => 0xac },
	'afstatus_87_b8' => { 437 => 0xae },
	'afstatus_88_c8' => { 437 => 0xb0 },
	'afstatus_89_d8' => { 437 => 0xb2 },
	'afstatus_90_e8' => { 437 => 0xb4 },
	'afstatus_91_f8' => { 437 => 0xb6 },
	'afstatus_92_g8' => { 437 => 0xb8 },
	'afstatus_93_h8' => { 437 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 437 => 0xbc },
	'afstatusactivesensor' => { 186 => 0x2, 434 => [0x4,0x3b], 438 => 0x1e, 439 => 0x1b, 440 => [0x1b,0x21] },
	'afstatusbottom' => { 186 => 0x8, 438 => 0x2a, 439 => 0x21, 440 => 0x21 },
	'afstatusbottom-left' => { 186 => 0x12, 439 => 0x2b, 440 => 0x2b },
	'afstatusbottom-right' => { 186 => 0x6, 439 => 0x1f, 440 => 0x1f },
	'afstatusbottomassist-left' => { 438 => 0x28 },
	'afstatusbottomassist-right' => { 438 => 0x2c },
	'afstatusbottomhorizontal' => { 435 => 0x10, 436 => 0x1c },
	'afstatusbottomvertical' => { 435 => 0x16, 436 => 0x26 },
	'afstatuscenter-10' => { 438 => 0x34 },
	'afstatuscenter-11' => { 438 => 0x36 },
	'afstatuscenter-12' => { 438 => 0x38 },
	'afstatuscenter-14' => { 438 => 0x3c },
	'afstatuscenter-7' => { 438 => 0x2e },
	'afstatuscenter-9' => { 438 => 0x32 },
	'afstatuscenter-horizontal' => { 438 => 0x30 },
	'afstatuscenter-vertical' => { 438 => 0x3a },
	'afstatuscenterf2-8' => { 438 => 0x4c },
	'afstatuscenterhorizontal' => { 186 => 0x2f, 435 => 0xc, 436 => 0x18, 439 => 0x2f, 440 => 0x2f },
	'afstatuscentervertical' => { 186 => 0xc, 435 => 0x14, 436 => 0x22, 439 => 0x25, 440 => 0x25 },
	'afstatusfarleft' => { 435 => 0x6, 438 => 0x26 },
	'afstatusfarlefthorizontal' => { 436 => 0x4 },
	'afstatusfarleftvertical' => { 436 => 0x12 },
	'afstatusfarright' => { 435 => 0x18, 438 => 0x44 },
	'afstatusfarrighthorizontal' => { 436 => 0x2c },
	'afstatusfarrightvertical' => { 436 => 0x34 },
	'afstatusleft' => { 186 => 0x2d, 435 => 0x2, 438 => 0x22, 439 => 0x2d, 440 => 0x2d },
	'afstatuslefthorizontal' => { 436 => 0x6 },
	'afstatusleftvertical' => { 436 => 0xe },
	'afstatuslower-left' => { 435 => 0x4, 438 => 0x24 },
	'afstatuslower-lefthorizontal' => { 436 => 0xa },
	'afstatuslower-leftvertical' => { 436 => 0x10 },
	'afstatuslower-middle' => { 435 => 0x22, 436 => 0x24 },
	'afstatuslower-right' => { 435 => 0x1e, 438 => 0x4a },
	'afstatuslower-righthorizontal' => { 436 => 0x32 },
	'afstatuslower-rightvertical' => { 436 => 0x3a },
	'afstatuslowerfarleft' => { 436 => 0x8 },
	'afstatuslowerfarright' => { 436 => 0x30 },
	'afstatusmiddlehorizontal' => { 186 => 0xa, 439 => 0x23, 440 => 0x23 },
	'afstatusnearleft' => { 435 => 0xe, 436 => 0x1a },
	'afstatusnearright' => { 435 => 0xa, 436 => 0x16 },
	'afstatusright' => { 186 => 0x31, 435 => 0x1c, 438 => 0x48, 439 => 0x31, 440 => 0x31 },
	'afstatusrighthorizontal' => { 436 => 0x2e },
	'afstatusrightvertical' => { 436 => 0x38 },
	'afstatustop' => { 186 => 0xe, 438 => 0x40, 439 => 0x27, 440 => 0x27 },
	'afstatustop-left' => { 186 => 0x10, 439 => 0x29, 440 => 0x29 },
	'afstatustop-right' => { 186 => 0x4, 439 => 0x1d, 440 => 0x1d },
	'afstatustopassist-left' => { 438 => 0x3e },
	'afstatustopassist-right' => { 438 => 0x42 },
	'afstatustophorizontal' => { 435 => 0x8, 436 => 0x14 },
	'afstatustopvertical' => { 435 => 0x12, 436 => 0x1e },
	'afstatusupper-left' => { 435 => 0x0, 438 => 0x20 },
	'afstatusupper-lefthorizontal' => { 436 => 0x2 },
	'afstatusupper-leftvertical' => { 436 => 0xc },
	'afstatusupper-middle' => { 435 => 0x20, 436 => 0x20 },
	'afstatusupper-right' => { 435 => 0x1a, 438 => 0x46 },
	'afstatusupper-righthorizontal' => { 436 => 0x2a },
	'afstatusupper-rightvertical' => { 436 => 0x36 },
	'afstatusupperfarleft' => { 436 => 0x0 },
	'afstatusupperfarright' => { 436 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 455 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 434 => 0x2 },
	'afwithshutter' => { 441 => 0x2a },
	'aggregateissuenumber' => { 537 => 'aggregateIssueNumber' },
	'aggregationtype' => { 537 => 'aggregationType' },
	'agreement' => { 540 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 144 => 0xe4e },
	'airplanemode' => { 246 => 0x9c0, 248 => 0x722, 249 => 0x732, 250 => 0x624, 251 => 0x654, 252 => 0x6bc },
	'aiservocontinuousshooting' => { 88 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 89 => 0x519 },
	'aiservoimagepriority' => { 89 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 89 => 0x51a },
	'aiservotrackingmethod' => { 89 => 0x504 },
	'aiservotrackingsensitivity' => { 88 => 0x14, 89 => 0x502 },
	'aisubjecttrackingmode' => { 329 => 0x309 },
	'album' => { 406 => ['albm',"\xa9alb"], 408 => 'album', 414 => ['albm',"\xa9alb"], 547 => 'album' },
	'albumartist' => { 185 => 'WM/AlbumArtist', 406 => 'aART', 414 => 'albr' },
	'albumcoverurl' => { 185 => 'WM/AlbumCoverURL' },
	'albumid' => { 406 => 'plID' },
	'albumtitle' => { 185 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 518 => 'AlreadyApplied', 520 => 'AlreadyApplied' },
	'alternatetitle' => { 537 => 'alternateTitle' },
	'alternatetitlea-lang' => { 537 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 537 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 537 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 203 => 0x6 },
	'alttapename' => { 547 => 'altTapeName' },
	'alttextaccessibility' => { 531 => 'AltTextAccessibility' },
	'alttimecode' => { 547 => 'altTimecode' },
	'alttimecodetimeformat' => { 547 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 547 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 547 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 417 => 0x5c },
	'ambientlight' => { 417 => 0x5e },
	'ambienttemperature' => { 124 => 0x9400, 415 => 0x14, 416 => 0x46, 417 => 0x50, 481 => 0x4, 525 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 415 => 0x13, 416 => 0x44, 417 => 0x4e },
	'analogbalance' => { 124 => 0xc627 },
	'analogcaptureiso' => { 144 => 0x89e },
	'analogisotable' => { 144 => 0x89d },
	'androidcapturefps' => { 408 => 'com.android.capture.fps' },
	'androidmake' => { 408 => 'com.android.manufacturer' },
	'androidmodel' => { 408 => 'com.android.model' },
	'androidversion' => { 408 => 'com.android.version' },
	'angleadj' => { 108 => 0x10003, 114 => 0x8b },
	'angleinforoll' => { 514 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 514 => 'AngleInfoYaw' },
	'anti-blur' => { 455 => 0xb04b },
	'antialiasstrength' => { 124 => 0xc632 },
	'antiflicker' => { 60 => 0x20 },
	'aperturelock' => { 309 => '38.2', 311 => '38.2', 312 => '38.2', 321 => '38.2', 322 => '38.2', 324 => 0xbc, 325 => 0xb8, 326 => 0xb8, 327 => 0xb8 },
	'aperturemode' => { 414 => 'apmd' },
	'aperturerange' => { 89 => 0x10d },
	'apertureringuse' => { 369 => '1.4' },
	'aperturesetting' => { 190 => 0x7, 441 => 0x30, 442 => 0x29, 443 => 0x1 },
	'aperturevalue' => { 98 => 0x2, 124 => 0x9202, 334 => 0x1002, 398 => 0x401, 524 => 'ApertureValue' },
	'appinfo' => { 496 => 'AppInfo' },
	'appinfoapplication' => { 496 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 496 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 496 => [\'AppInfo','AppInfoVersion'] },
	'apple_0x004e' => { 1 => 0x4e },
	'apple_0x004f' => { 1 => 0x4f },
	'applekeywords' => { 338 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 408 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 406 => 'apID' },
	'applestoreaccounttype' => { 406 => 'akID' },
	'applestorecatalogid' => { 406 => 'cnID' },
	'applestorecountry' => { 406 => 'sfID' },
	'applicationkeystring' => { 144 => 0x400 },
	'applicationnotes' => { 124 => 0x2bc, 358 => 0x2bc },
	'applicationrecordversion' => { 137 => 0x0 },
	'applyautomatically' => { 343 => 'ApplyAutomatically' },
	'applyshootingmeteringmode' => { 89 => 0x10e },
	'approved' => { 526 => 'Approved' },
	'approvedby' => { 526 => 'ApprovedBy' },
	'approximatefnumber' => { 348 => 0x313, 355 => 0x3406 },
	'approximatefocusdistance' => { 515 => 'ApproximateFocusDistance' },
	'appversion' => { 530 => 'AppVersion' },
	'aps-csizecapture' => { 474 => 0x114, 475 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 108 => 0x20914 },
	'armidentifier' => { 138 => 0x78 },
	'armversion' => { 138 => 0x7a },
	'arranger' => { 406 => "\xa9arg", 414 => "\xa9arg" },
	'arrangerkeywords' => { 414 => "\xa9ark" },
	'artdirector' => { 406 => "\xa9ard" },
	'artfilter' => { 329 => 0x529 },
	'artfiltereffect' => { 329 => 0x52f },
	'artist' => { 124 => 0x13b, 342 => 'Artist', 358 => 0x13b, 389 => 0x22e, 406 => "\xa9ART", 408 => 'artist', 414 => "\xa9ART", 543 => 'Artist', 547 => 'artist' },
	'artistid' => { 406 => 'atID' },
	'artmode' => { 118 => 0x301b },
	'artmodeparameters' => { 118 => 0x310b },
	'artwork' => { 408 => 'artwork' },
	'artworkcircadatecreated' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 532 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 532 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 333 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 333 => 0x1112, 389 => 0x80, 441 => 0x55, 442 => 0x55, 443 => 0xa, 468 => [0x192c,0x1a88], 469 => 0x192c, 470 => 0x1958, 471 => 0x192c, 472 => 0x188c },
	'assetid' => { 508 => 'AssetID' },
	'asshoticcprofile' => { 124 => 0xc68f },
	'asshotneutral' => { 124 => 0xc628 },
	'asshotpreprofilematrix' => { 124 => 0xc690 },
	'asshotprofilename' => { 124 => 0xc6f6 },
	'asshotwhitexy' => { 124 => 0xc629 },
	'assignbktbutton' => { 308 => '4.2', 309 => '16.1', 311 => '16.1', 312 => '16.1', 321 => '16.1', 322 => '16.1' },
	'assignfuncbutton' => { 89 => 0x70b },
	'assignmb-d17af-onbutton' => { 312 => '79.1' },
	'assignmb-d17funcbutton' => { 312 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 312 => '68.1' },
	'assignmb-d18af-onbutton' => { 322 => '79.1' },
	'assignmb-d18funcbutton' => { 322 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 322 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 311 => '75.1', 312 => '75.1', 322 => '75.1' },
	'assignmoviefunc2button' => { 311 => '82.1', 312 => '82.1', 322 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 311 => '75.2', 312 => '75.2', 322 => '75.2' },
	'assignmovierecordbutton' => { 309 => '43.2', 321 => '45.1', 324 => 0x9f, 325 => 0x9b, 326 => 0x9b, 327 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 311 => '45.1', 312 => '45.1', 322 => '45.1' },
	'assignmoviesubselector' => { 311 => '74.1', 312 => '74.1', 322 => '74.1' },
	'assignmoviesubselectorplusdials' => { 311 => '76.1', 312 => '76.1', 322 => '76.1' },
	'assignremotefnbutton' => { 309 => '54.1', 321 => '51.1' },
	'assistbuttonfunction' => { 87 => 0xd },
	'atcaptureusercrop' => { 144 => 0x943 },
	'attributionname' => { 516 => 'attributionName' },
	'attributionurl' => { 516 => 'attributionURL' },
	'audio' => { 353 => 0x20 },
	'audiobitrate' => { 71 => 0x6c, 532 => 'audioBitRate' },
	'audiobitratemode' => { 532 => 'audioBitRateMode' },
	'audiobitspersample' => { 532 => 'audioBitsPerSample' },
	'audiobutton' => { 326 => 0x17b, 327 => 0x193 },
	'audiobuttonplaybackmode' => { 326 => 0x1b9, 327 => 0x1d1 },
	'audiochannelcount' => { 532 => 'audioChannelCount' },
	'audiochannels' => { 71 => 0x70 },
	'audiochanneltype' => { 547 => 'audioChannelType' },
	'audiocompression' => { 89 => 0x816, 161 => 'Compression' },
	'audiocompressor' => { 547 => 'audioCompressor' },
	'audiodata' => { 499 => 'Data' },
	'audioduration' => { 137 => 0x99 },
	'audiogain' => { 408 => 'player.movie.audio.gain' },
	'audiomimetype' => { 499 => 'Mime' },
	'audiomoddate' => { 547 => 'audioModDate' },
	'audiooutcue' => { 137 => 0x9a },
	'audiosamplerate' => { 71 => 0x6e, 547 => 'audioSampleRate' },
	'audiosampletype' => { 547 => 'audioSampleType' },
	'audiosamplingrate' => { 137 => 0x97 },
	'audiosamplingresolution' => { 137 => 0x98 },
	'audiotype' => { 137 => 0x96 },
	'author' => { 163 => 'Author', 338 => 'Author', 342 => 'Author', 405 => 'Author', 406 => ['auth',"\xa9aut"], 408 => 'author', 414 => 'auth', 513 => 'author', 534 => 'Author', 545 => 'Author' },
	'authorsposition' => { 535 => 'AuthorsPosition' },
	'authorurl' => { 185 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 89 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 379 => '0.1' },
	'autobracket' => { 431 => 0x19 },
	'autobracketing' => { 132 => 0x1100, 389 => 0x18, 421 => 0x1007 },
	'autobracketingmode' => { 320 => '12.3' },
	'autobracketingset' => { 320 => '12.1' },
	'autobracketmodem' => { 308 => '21.2', 309 => '13.3', 311 => '13.2', 312 => '13.2', 317 => '26.2', 321 => '13.3', 322 => '13.2', 324 => 0x63, 325 => 0x5f, 326 => 0x5f, 327 => 0x5f },
	'autobracketorder' => { 190 => 0x43, 308 => '21.3', 309 => '13.2', 311 => '13.1', 312 => '13.1', 317 => '26.3', 318 => '12.2', 319 => '2.2', 320 => '12.2', 321 => '13.2', 322 => '13.1', 323 => '13.2', 324 => 0x65, 325 => 0x61, 326 => 0x61, 327 => 0x61 },
	'autobracketset' => { 308 => '21.1', 309 => '13.1', 313 => '11.1', 314 => '12.1', 315 => '12.1', 317 => '26.1', 318 => '12.1', 319 => '2.1', 321 => '13.1', 323 => '13.1' },
	'autobrightness' => { 518 => 'AutoBrightness', 520 => 'AutoBrightness' },
	'autocapturecriteria' => { 202 => 0x1 },
	'autocapturecriteriamotiondirection' => { 202 => 0x5f },
	'autocapturecriteriamotionsize' => { 202 => 0x64 },
	'autocapturecriteriamotionspeed' => { 202 => 0x63 },
	'autocapturecriteriasubjectsize' => { 202 => 0x69 },
	'autocapturecriteriasubjecttype' => { 202 => 0x6a },
	'autocapturedframe' => { 202 => 0x0 },
	'autocapturedistancefar' => { 202 => 0x4a },
	'autocapturedistancenear' => { 202 => 0x4e },
	'autocapturepreset' => { 252 => 0x746 },
	'autocapturerecordingtime' => { 202 => 0x37 },
	'autocapturewaittime' => { 202 => 0x38 },
	'autocontrast' => { 518 => 'AutoContrast', 520 => 'AutoContrast' },
	'autodistortioncontrol' => { 216 => 0x4, 246 => 0x2cf, 247 => 0x143 },
	'autodynamicrange' => { 132 => 0x140b },
	'autoexposure' => { 518 => 'AutoExposure', 520 => 'AutoExposure' },
	'autoexposurebracketing' => { 81 => 0x10 },
	'autoflashisosensitivity' => { 311 => '38.5', 312 => '38.5', 322 => '38.5', 324 => 0x5f, 325 => 0x5b, 326 => 0x5b, 327 => 0x5b },
	'autofocus' => { 332 => 0x209 },
	'autofocusmoderestrictions' => { 325 => 0x107, 326 => 0x107, 327 => 0x11d },
	'autofp' => { 319 => '7.3', 323 => '31.4' },
	'autoiso' => { 81 => 0x1, 118 => 0x3008, 246 => 0x288, 248 => 0x152, 249 => 0x152, 250 => 0x142, 251 => 0x156, 252 => 0x156, 310 => '1.1', 319 => '1.1' },
	'autoisomax' => { 310 => '1.2', 319 => '1.2' },
	'autoisominshutterspeed' => { 310 => '1.3', 319 => '1.3' },
	'autolateralca' => { 518 => 'AutoLateralCA', 520 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 66 => 0x2, 89 => 0x204, 108 => 0x20500, 114 => 0x6f },
	'autolightingoptimizeron' => { 108 => '0x20500.0', 114 => 0x6e },
	'autoportraitframed' => { 455 => 0x2016 },
	'autoredeye' => { 301 => 0xfe28a44f },
	'autorotate' => { 81 => 0x1b },
	'autoshadows' => { 518 => 'AutoShadows', 520 => 'AutoShadows' },
	'autotone' => { 518 => 'AutoTone', 520 => 'AutoTone' },
	'autotonedigest' => { 518 => 'AutoToneDigest', 520 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 518 => 'AutoToneDigestNoSat', 520 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 518 => 'AutoWhiteVersion', 520 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 242 => 0x82 },
	'avaperturesetting' => { 369 => 0x13 },
	'averageblacklevel' => { 48 => 0xe7, 50 => 0xfb, 51 => 0x114, 52 => 0x146 },
	'averagelv' => { 193 => 0x38 },
	'avsettingwithoutlens' => { 89 => 0x707 },
	'azimuth' => { 171 => 'Azimuth' },
	'babyage' => { 353 => [0x8010,0x33] },
	'babyname' => { 353 => 0x66 },
	'backgroundalpha' => { 542 => 'bgalpha' },
	'balance' => { 408 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 369 => 0x15 },
	'baseiso' => { 81 => 0x2, 102 => 0x101c, 144 => 0x903, 355 => 0x312a, 487 => 0x6 },
	'baseisodaylight' => { 144 => 0x910 },
	'baseisoflash' => { 144 => 0x913 },
	'baseisofluorescent' => { 144 => 0x912 },
	'baseisotungsten' => { 144 => 0x911 },
	'baselineexposure' => { 124 => 0xc62a },
	'baselineexposureoffset' => { 124 => 0xc7a5 },
	'baselinenoise' => { 124 => 0xc62b },
	'baselinesharpness' => { 124 => 0xc62c },
	'baserenditionishdr' => { 529 => 'BaseRenditionIsHDR' },
	'baseurl' => { 545 => 'BaseURL' },
	'bass' => { 408 => 'player.movie.audio.bass' },
	'batterylevel' => { 353 => 0x38, 441 => 0x51, 445 => 0xc, 446 => 0x4, 447 => 0x4, 488 => 0x7, 489 => 0x5 },
	'batterylevel2' => { 489 => 0x7 },
	'batterylevelgrip1' => { 488 => 0x6 },
	'batterylevelgrip2' => { 488 => 0x8 },
	'batteryorder' => { 308 => '12.5', 317 => '13.2', 318 => '2.1', 321 => '3.1' },
	'batterystate' => { 190 => 0x60, 441 => 0x50, 447 => 0x14 },
	'batterytemperature' => { 445 => 0x1, 447 => 0x2, 488 => 0x5 },
	'batterytype' => { 68 => 0x38, 417 => 0x66 },
	'batteryunknown' => { 445 => 0x2, 447 => 0x0 },
	'batteryvoltage' => { 144 => 0x408, 415 => 0x2a, 416 => 0x49, 417 => 0x62, 445 => 0x8 },
	'batteryvoltage1' => { 447 => 0x6 },
	'batteryvoltage2' => { 447 => 0x8 },
	'batteryvoltageavg' => { 417 => 0x64 },
	'bayergreensplit' => { 124 => 0xc62d },
	'bayerpattern' => { 143 => 0xf902, 194 => 0x17 },
	'beatsperminute' => { 406 => 'tmpo' },
	'beatspliceparams' => { 547 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 547 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 547 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 547 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 547 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 547 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 308 => '13.1', 309 => '5.4', 310 => '0.1', 313 => '2.1', 314 => '3.1', 315 => '3.1', 317 => '10.1', 319 => '0.1', 321 => '5.5', 323 => '4.1' },
	'beeppitch' => { 318 => '3.1' },
	'beepvolume' => { 318 => '4.5' },
	'bestqualityscale' => { 124 => 0xc65c },
	'bestshotmode' => { 118 => 0x3007 },
	'bitdepth' => { 168 => 'BitDepth', 194 => 0x11, 267 => 0x41 },
	'bitspercomponent' => { 139 => 0x87 },
	'bitspersample' => { 124 => 0x102, 358 => 0xa, 543 => 'BitsPerSample' },
	'blackacquirerows' => { 144 => 0x18ba },
	'blacklevel' => { 124 => [0x7310,0xc61a], 213 => 0x20, 242 => 0x3d, 334 => [0x401,0x1012], 398 => 0x21d, 462 => [0x7300,0x7310] },
	'blacklevel2' => { 333 => 0x600, 337 => 0x600 },
	'blacklevelblue' => { 358 => 0x1e },
	'blacklevelbottom' => { 144 => 0x3f0 },
	'blackleveldata' => { 398 => 0x223 },
	'blackleveldeltah' => { 124 => 0xc61b },
	'blackleveldeltav' => { 124 => 0xc61c },
	'blacklevelgreen' => { 358 => 0x1d },
	'blacklevelred' => { 358 => 0x1c },
	'blacklevelrepeatdim' => { 124 => 0xc619 },
	'blacklevelrough' => { 144 => 0x40e },
	'blacklevelroughafter' => { 144 => 0x416 },
	'blacklevels' => { 37 => 0x1d },
	'blackleveltop' => { 144 => 0x3ef },
	'blackpoint' => { 389 => 0x200 },
	'blacks2012' => { 518 => 'Blacks2012', 520 => 'Blacks2012' },
	'blacksadj' => { 492 => 0x9018 },
	'bleachbypasstoning' => { 389 => 0x7f },
	'blockshotafresponse' => { 311 => '1.5', 312 => '1.5', 322 => '1.5', 324 => 0x7, 325 => 0x7, 326 => 0x7, 327 => 0x7 },
	'blogtitle' => { 537 => 'blogTitle' },
	'blogurl' => { 537 => 'blogURL' },
	'bluebalance' => { 334 => 0x1018, 358 => 0x12, 389 => 0x1b },
	'bluecurvelimits' => { 113 => 0x1fe },
	'bluecurvepoints' => { 112 => 0x79, 113 => 0x1d4 },
	'bluehsl' => { 108 => 0x20915 },
	'bluehue' => { 518 => 'BlueHue', 520 => 'BlueHue' },
	'bluesaturation' => { 518 => 'BlueSaturation', 520 => 'BlueSaturation' },
	'bluratinfinity' => { 504 => 'BlurAtInfinity' },
	'blurcontrol' => { 389 => 0x82 },
	'blurwarning' => { 132 => 0x1300 },
	'bodybatteryadload' => { 367 => 0x3 },
	'bodybatteryadnoload' => { 367 => 0x2 },
	'bodybatterypercent' => { 367 => 0x3 },
	'bodybatterystate' => { 367 => ['1.1',0x2] },
	'bodybatteryvoltage' => { 367 => 0x4 },
	'bodybatteryvoltage1' => { 367 => 0x2 },
	'bodybatteryvoltage2' => { 367 => 0x4 },
	'bodybatteryvoltage3' => { 367 => 0x6 },
	'bodybatteryvoltage4' => { 367 => 0x8 },
	'bodyfirmware' => { 422 => 0x0 },
	'bodyfirmwareversion' => { 330 => 0x104, 331 => 0x100, 334 => 0x104 },
	'bodyserialnumber' => { 422 => 0x10 },
	'bookedition' => { 537 => 'bookEdition' },
	'bootloaderversion' => { 416 => 0x26 },
	'bracketbutton' => { 249 => 0x808, 252 => 0x80c },
	'bracketbuttonplaybackmode' => { 249 => 0x810, 252 => 0x816 },
	'bracketincrement' => { 246 => 0x34a, 248 => 0x22e, 249 => 0x22e, 250 => 0x21a, 251 => 0x22e, 252 => 0x22e },
	'bracketmode' => { 60 => 0x3 },
	'bracketprogram' => { 246 => 0x348, 248 => 0x22c, 249 => 0x22c, 250 => 0x218, 251 => 0x22c, 252 => 0x22c },
	'bracketsequence' => { 118 => 0x301d },
	'bracketset' => { 246 => 0x346, 248 => 0x22a, 249 => 0x22a, 250 => 0x216, 251 => 0x22a, 252 => 0x22a },
	'bracketsettings' => { 353 => 0x45 },
	'bracketshotnumber' => { 60 => 0x5, 369 => 0x9, 452 => 0x2b },
	'bracketshotnumber2' => { 452 => 0x2d },
	'bracketstep' => { 187 => 0xe },
	'bracketvalue' => { 60 => 0x4 },
	'brightness' => { 124 => 0xfe53, 162 => 'Brightness', 182 => 'Brightness', 187 => 0x2c, 259 => 0x34, 260 => 0x39, 261 => 0x41, 408 => 'player.movie.visual.brightness', 415 => 0x25, 417 => 0x54, 441 => 0x22, 455 => 0x2007, 518 => 'Brightness', 520 => 'Brightness' },
	'brightnessadj' => { 113 => 0x114, 294 => 0x0, 304 => 0x2d, 492 => 0x8018 },
	'brightnessvalue' => { 124 => 0x9203, 193 => [0x691,0x49c3], 334 => 0x1003, 460 => 0x1e, 464 => 0x1140, 465 => 0x1140, 466 => 0x111c, 467 => 0x1198, 468 => 0x1174, 469 => 0x102c, 470 => 0x224, 471 => 0x224, 472 => 0x219, 524 => 'BrightnessValue' },
	'buildnumber' => { 197 => 0x5500 },
	'bulbduration' => { 81 => 0x18 },
	'burstcount' => { 144 => 0x40d },
	'burstgroupid' => { 244 => 0x4 },
	'burstid' => { 500 => 'BurstID' },
	'burstmode' => { 146 => 0xa, 353 => 0x2a },
	'burstmode2' => { 146 => 0x18 },
	'burstprimary' => { 500 => 'BurstPrimary' },
	'burstshot' => { 431 => 0x34 },
	'burstspeed' => { 353 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 89 => 0x70a },
	'bwadjustment' => { 132 => 0x1049 },
	'bwfilter' => { 187 => 0x2a, 195 => 0x39 },
	'bwmagentagreen' => { 132 => 0x104b },
	'bwmode' => { 334 => 0x203 },
	'by-line' => { 137 => 0x50 },
	'by-linetitle' => { 137 => 0x55 },
	'bytecount' => { 537 => 'byteCount' },
	'c14configuration' => { 144 => 0x1964 },
	'cacheversion' => { 124 => 0xc7aa },
	'calibratedfocallength' => { 121 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 121 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 121 => 'CalibratedOpticalCenterY' },
	'calibration' => { 431 => [0x24,0x30] },
	'calibrationhistory' => { 144 => 0x9c9 },
	'calibrationilluminant1' => { 124 => 0xc65a },
	'calibrationilluminant2' => { 124 => 0xc65b },
	'calibrationilluminant3' => { 124 => 0xcd31 },
	'calibrationversion' => { 144 => 0x9c6 },
	'callforimage' => { 508 => 'CallForImage' },
	'camera' => { 496 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 414 => 'angl', 547 => 'cameraAngle' },
	'cameraappinfo' => { 496 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 496 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 496 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 496 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 502 => 'CameraBurstID' },
	'cameracalibration' => { 431 => 0x11f },
	'cameracalibration1' => { 124 => 0xc623 },
	'cameracalibration2' => { 124 => 0xc624 },
	'cameracalibration3' => { 124 => 0xcd32 },
	'cameracalibrationsig' => { 124 => 0xc6f3 },
	'cameracolorcalibration01' => { 38 => 0x0, 39 => 0x0 },
	'cameracolorcalibration02' => { 38 => 0x4, 39 => 0x5 },
	'cameracolorcalibration03' => { 38 => 0x8, 39 => 0xa },
	'cameracolorcalibration04' => { 38 => 0xc, 39 => 0xf },
	'cameracolorcalibration05' => { 38 => 0x10, 39 => 0x14 },
	'cameracolorcalibration06' => { 38 => 0x14, 39 => 0x19 },
	'cameracolorcalibration07' => { 38 => 0x18, 39 => 0x1e },
	'cameracolorcalibration08' => { 38 => 0x1c, 39 => 0x23 },
	'cameracolorcalibration09' => { 38 => 0x20, 39 => 0x28 },
	'cameracolorcalibration10' => { 38 => 0x24, 39 => 0x2d },
	'cameracolorcalibration11' => { 38 => 0x28, 39 => 0x32 },
	'cameracolorcalibration12' => { 38 => 0x2c, 39 => 0x37 },
	'cameracolorcalibration13' => { 38 => 0x30, 39 => 0x3c },
	'cameracolorcalibration14' => { 38 => 0x34, 39 => 0x41 },
	'cameracolorcalibration15' => { 38 => 0x38, 39 => 0x46 },
	'cameradepthmap' => { 496 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 496 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 496 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 496 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 496 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 496 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 496 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 496 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 496 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 496 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 496 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 496 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 408 => 'direction.facing' },
	'camerae-mountversion' => { 491 => 0xb },
	'cameraelevationangle' => { 124 => 0x9405, 525 => 'CameraElevationAngle' },
	'camerafilename' => { 508 => 'CameraFilename' },
	'camerafirmware' => { 124 => 0xa439, 525 => 'CameraFirmware' },
	'cameraid' => { 334 => 0x209, 414 => 'cmid', 430 => 0x209 },
	'cameraidentifier' => { 408 => 'camera.identifier' },
	'cameraimage' => { 496 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 496 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 496 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 496 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 496 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 496 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 496 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 496 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 496 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 496 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 496 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 496 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 496 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 496 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 36 => 0x10 },
	'cameralabel' => { 124 => 0xc7a1, 547 => 'cameraLabel' },
	'cameralightestimate' => { 496 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 496 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 496 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 496 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 496 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 508 => 'CameraMakeModel' },
	'cameramodel' => { 398 => 0x410, 547 => 'cameraModel' },
	'cameramodelid' => { 182 => 'CameraModelID' },
	'cameramodelrestriction' => { 518 => 'CameraModelRestriction', 520 => 'CameraModelRestriction' },
	'cameramotion' => { 408 => 'direction.motion' },
	'cameramove' => { 547 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 353 => 0x8f, 388 => 0x1, 393 => 0x1, 398 => 0x100, 447 => [0x16,0x18], 478 => 0x28, 479 => 0x24, 480 => 0x29 },
	'cameraowner' => { 147 => 0xc353 },
	'cameraparameters' => { 334 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 120 => 0x9, 414 => "\xa9gpt" },
	'camerapointcloud' => { 496 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 496 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 496 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 496 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 496 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 496 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 496 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 496 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 496 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 496 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 496 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 496 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 496 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 518 => 'CameraProfile', 520 => 'CameraProfile' },
	'cameraprofiledigest' => { 518 => 'CameraProfileDigest', 520 => 'CameraProfileDigest' },
	'cameraprofiles' => { 535 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 535 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 535 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 535 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 535 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 535 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 535 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 535 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 535 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 535 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 535 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 535 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 535 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 535 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 535 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 535 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 535 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 535 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 535 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 535 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 535 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 535 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 535 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 114 => 0xe1 },
	'camerarawcontrast' => { 114 => 0xe3 },
	'camerarawhighlightpoint' => { 114 => 0xe6 },
	'camerarawlinear' => { 114 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 114 => 0xe8 },
	'camerarawoutputshadowpoint' => { 114 => 0xe9 },
	'camerarawsaturation' => { 114 => 0xe2 },
	'camerarawshadowpoint' => { 114 => 0xe7 },
	'camerarawsharpness' => { 114 => 0xe5 },
	'cameraroll' => { 120 => 0xb, 414 => "\xa9grl" },
	'cameras' => { 496 => 'Cameras' },
	'cameraserialnumber' => { 124 => 0xc62f, 184 => 'CameraSerialNumber', 508 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 329 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 31 => [0x87,0x91], 32 => [0x99,0x9f,0xa4,0xa8,0x105], 35 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 81 => 0xc, 144 => 0x406, 333 => 0x1306, 348 => 0x320, 355 => 0x3402, 389 => 0x47, 428 => 0x43, 482 => 0x5 },
	'cameratemperature4' => { 394 => 0x14 },
	'cameratemperature5' => { 394 => 0x16 },
	'cameratemperaturerangemax' => { 126 => 0x5 },
	'cameratemperaturerangemin' => { 126 => 0x6 },
	'cameratrait' => { 496 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 1 => 0x2e, 81 => 0x1a, 334 => 0x207 },
	'cameratype2' => { 330 => 0x100 },
	'cameravendorinfo' => { 496 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 496 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 496 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 496 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 120 => 0xa, 414 => "\xa9gyw" },
	'camreverse' => { 121 => 'CamReverse' },
	'canondr4' => { 125 => 'CanonDR4' },
	'canonexposuremode' => { 36 => 0x14 },
	'canonfiledescription' => { 102 => 0x805 },
	'canonfilelength' => { 68 => 0xe },
	'canonfirmwareversion' => { 68 => 0x7, 102 => 0x80b },
	'canonflashinfo' => { 102 => 0x1028 },
	'canonflashmode' => { 36 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 36 => 0xa },
	'canonimagetype' => { 68 => 0x6, 102 => 0x815 },
	'canonlogversion' => { 67 => 0xb },
	'canonmodelid' => { 68 => 0x10, 102 => 0x1834 },
	'canonvrd' => { 125 => 'CanonVRD' },
	'caption' => { 513 => 'caption' },
	'caption-abstract' => { 137 => 0x78 },
	'captionsauthornames' => { 523 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 523 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 535 => 'CaptionWriter' },
	'captureframerate' => { 118 => 0x4001 },
	'captureheightnormal' => { 144 => 0x1839 },
	'capturelook' => { 144 => 0xc48 },
	'capturemode' => { 408 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 506 => 'CaptureSoftware' },
	'capturewidthnormal' => { 144 => 0x1838 },
	'capturewidthtest' => { 144 => 0x1842 },
	'cardshutterlock' => { 190 => 0x49 },
	'casioimagesize' => { 118 => 0x9 },
	'catalogsets' => { 137 => 0xff, 498 => 'CatalogSets', 511 => 'CatalogSets' },
	'categories' => { 68 => 0x23, 513 => 'categories' },
	'category' => { 137 => 0xf, 185 => 'WM/Category', 328 => 0x30, 406 => 'catg', 535 => 'Category' },
	'cbcrgain' => { 428 => 0xa036 },
	'cbcrgaindefault' => { 428 => 0xa035 },
	'cbcrmatrix' => { 428 => 0xa034 },
	'cbcrmatrixdefault' => { 428 => 0xa033 },
	'ccdboardversion' => { 348 => 0x331 },
	'ccdscanmode' => { 334 => 0x1039 },
	'ccdsensitivity' => { 290 => 0x6 },
	'ccdversion' => { 348 => 0x330 },
	'ccvavgluminancenits' => { 528 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 528 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 528 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 528 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 528 => 'ccv_white_xy' },
	'cellglobalid' => { 517 => 'cgi' },
	'celllength' => { 124 => 0x109 },
	'cellr' => { 517 => 'r' },
	'celltowerid' => { 517 => 'cellid' },
	'cellwidth' => { 124 => 0x108 },
	'centerafarea' => { 319 => '15.1' },
	'centerfocuspoint' => { 323 => '2.2' },
	'centerpixel' => { 144 => 0x40c },
	'centerweightedareasize' => { 308 => '7.1', 309 => '8.1', 311 => '8.1', 312 => '8.1', 316 => '7.1', 317 => '5.1', 318 => '7.1', 319 => '6.3', 321 => '8.1', 322 => '8.1', 323 => '8.1', 324 => 0x21, 325 => 0x1f, 326 => 0x1f, 327 => 0x1f },
	'certificate' => { 551 => 'Certificate' },
	'cfainterpolationalgorithm' => { 144 => 0xe60 },
	'cfainterpolationmetric' => { 144 => 0xe61 },
	'cfaoffsetcols' => { 144 => 0xc71 },
	'cfaoffsetrows' => { 144 => 0xc6f },
	'cfapattern' => { 124 => 0xa302, 358 => 0x9, 524 => 'CFAPattern' },
	'cfapattern2' => { 124 => 0x828e },
	'cfapatterncolumns' => { 524 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 524 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 524 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 124 => 0x828d },
	'cfazipperfixthreshold' => { 144 => 0xe62 },
	'channel' => { 537 => 'channel' },
	'channela-lang' => { 537 => [\'channel','channelA-lang'] },
	'channelchannel' => { 537 => [\'channel','channelChannel'] },
	'channels' => { 161 => 'Channels' },
	'channelsubchannel1' => { 537 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 537 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 537 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 537 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 414 => 'chpl' },
	'checkmark' => { 108 => 0x10101, 113 => 0x26a },
	'checkmark2' => { 114 => 0x8e },
	'childfontfiles' => { 552 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 308 => '10.3', 309 => '11.2', 325 => 0x10b, 326 => 0x10b, 327 => 0x121 },
	'chromablurradius' => { 124 => 0xc631 },
	'chromanoisecolorspace' => { 144 => 0xe6d },
	'chromanoiseedgemapthresh' => { 144 => 0xe6c },
	'chromanoisehighfthresh' => { 144 => 0xe6a },
	'chromanoiselowfthresh' => { 144 => 0xe6b },
	'chromaticaberration' => { 108 => 0x20703, 114 => 0x66, 428 => 0xa051 },
	'chromaticaberrationb' => { 518 => 'ChromaticAberrationB', 520 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 108 => 0x20708, 114 => 0x6b },
	'chromaticaberrationcorr' => { 83 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 124 => 0x7034, 378 => 0x1, 492 => 0x900d },
	'chromaticaberrationcorrparams' => { 124 => 0x7035, 486 => 0x66a, 487 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 108 => '0x20703.0', 114 => 0x62 },
	'chromaticaberrationr' => { 518 => 'ChromaticAberrationR', 520 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 108 => 0x20707, 114 => 0x6a },
	'chromaticaberrationsetting' => { 84 => 0x6 },
	'chrominancenoisereduction' => { 108 => 0x20601, 114 => 0x5e, 431 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 114 => 0x60 },
	'circadatecreated' => { 532 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 518 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 520 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 518 => 'CircularGradientBasedCorrections', 520 => 'CircularGradientBasedCorrections' },
	'city' => { 137 => 0x5a, 167 => 'City', 353 => 0x6d, 535 => 'City' },
	'city2' => { 353 => 0x80 },
	'clarity' => { 36 => 0x33, 132 => 0x100f, 260 => 0x35, 261 => 0x3d, 455 => 0x2036, 518 => 'Clarity', 520 => 'Clarity' },
	'clarity2012' => { 518 => 'Clarity2012', 520 => 'Clarity2012' },
	'claritycontrol' => { 389 => 0x96 },
	'classification' => { 414 => 'clsf' },
	'classifystate' => { 137 => 0xe1 },
	'clearretouch' => { 353 => 0x7c },
	'clearretouchvalue' => { 353 => 0xa3 },
	'client' => { 547 => 'client' },
	'clientname' => { 526 => 'ClientName' },
	'clipboardaspectratio' => { 518 => 'ClipboardAspectRatio', 520 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 518 => 'ClipboardOrientation', 520 => 'ClipboardOrientation' },
	'clipfilename' => { 414 => 'clfn' },
	'clipid' => { 414 => 'clid' },
	'clmodeshootingspeed' => { 308 => '10.2', 309 => '11.3', 311 => '11.2', 312 => '11.2', 317 => '11.2', 318 => '10.2', 321 => '11.2', 322 => '11.2', 323 => '11.1', 324 => 0x3f, 325 => 0x3b, 326 => 0x3b, 327 => 0x3b },
	'cluster' => { 518 => 'Cluster', 520 => 'Cluster' },
	'cmcontrast' => { 337 => 0x2022 },
	'cmddialsreverserotation' => { 324 => 0xbe, 325 => 0xba, 326 => 0xba, 327 => 0xba },
	'cmexposurecompensation' => { 337 => 0x2000 },
	'cmhue' => { 337 => 0x2021 },
	'cmsaturation' => { 337 => 0x2020 },
	'cmsharpness' => { 337 => 0x2023 },
	'cmwhitebalance' => { 337 => 0x2001 },
	'cmwhitebalancecomp' => { 337 => 0x2002 },
	'cmwhitebalancegraypoint' => { 337 => 0x2010 },
	'codec' => { 175 => 'Codec' },
	'codedcharacterset' => { 138 => 0x5a },
	'codeversion' => { 414 => 'cver' },
	'collection' => { 342 => 'Collection' },
	'collectionname' => { 176 => [\'Collections','CollectionsCollectionName'], 414 => 'coll' },
	'collections' => { 176 => 'Collections', 513 => 'collections' },
	'collectionuri' => { 176 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 408 => 'player.movie.visual.color', 536 => 'color' },
	'coloraberrationcontrol' => { 301 => 0xc89224b },
	'coloradjustment' => { 431 => 0x14 },
	'coloradjustmentmode' => { 430 => 0x210 },
	'coloranta' => { 552 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 552 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 552 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 552 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 552 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 552 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 552 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 552 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 552 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 552 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 552 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 552 => 'Colorants' },
	'colorantswatchname' => { 552 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 552 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 552 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 552 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 162 => 'ColorBalance' },
	'colorbalanceadj' => { 301 => 0x76a43202 },
	'colorbalanceblue' => { 187 => 0x1e },
	'colorbalancegreen' => { 187 => 0x1d },
	'colorbalancered' => { 187 => 0x1c },
	'colorbalanceversion' => { 212 => 0x4, 213 => 0x4, 214 => 0x0, 215 => 0x0 },
	'colorblur' => { 114 => 0x65 },
	'colorbluron' => { 108 => 0x20704 },
	'colorbooster' => { 301 => 0x5f0e7d23 },
	'colorboostlevel' => { 295 => 0x1 },
	'colorboosttype' => { 295 => 0x0 },
	'colorchromeeffect' => { 132 => 0x1048 },
	'colorchromefxblue' => { 132 => 0x104e },
	'colorclass' => { 400 => 0xde, 401 => 'ColorClass' },
	'colorcompensationfilter' => { 190 => [0x3a,0x5f], 192 => 0x111, 455 => 0xb022 },
	'colorcompensationfiltercustom' => { 441 => 0xd, 442 => 0xc },
	'colorcompensationfilterset' => { 441 => 0x8, 442 => 0x7, 443 => 0x18, 460 => 0xf },
	'colorcontrol' => { 334 => 0x102b },
	'colorcorrection' => { 492 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 329 => 0x532 },
	'colordataversion' => { 43 => 0x0, 44 => 0x0, 45 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0, 52 => 0x0, 53 => 0x0 },
	'coloreffect' => { 353 => 0x28 },
	'colorfilter' => { 117 => 0x17, 118 => 0x3017, 187 => 0x29, 195 => [0x38,0x4d,0x4f], 396 => 0x17 },
	'colorgain' => { 267 => 0x51 },
	'colorgradeblending' => { 518 => 'ColorGradeBlending', 520 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 518 => 'ColorGradeGlobalHue', 520 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 518 => 'ColorGradeGlobalLum', 520 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 518 => 'ColorGradeGlobalSat', 520 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 518 => 'ColorGradeHighlightLum', 520 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 518 => 'ColorGradeMidtoneHue', 520 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 518 => 'ColorGradeMidtoneLum', 520 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 518 => 'ColorGradeMidtoneSat', 520 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 518 => 'ColorGradeShadowLum', 520 => 'ColorGradeShadowLum' },
	'colorhue' => { 108 => 0x20900, 242 => 0x8d },
	'colorimetricreference' => { 124 => 0xc6bf },
	'colorlabel' => { 523 => 'ColorLabel' },
	'colormatrix' => { 67 => 0xa, 333 => 0x200, 334 => 0x1011, 428 => 0xa030 },
	'colormatrix1' => { 124 => 0xc621, 398 => 0x106 },
	'colormatrix2' => { 124 => 0xc622, 337 => 0x200, 398 => 0x226 },
	'colormatrix3' => { 124 => 0xcd33 },
	'colormatrixa' => { 389 => 0x203 },
	'colormatrixa2' => { 389 => 0x21c },
	'colormatrixadobergb' => { 428 => 0xa032 },
	'colormatrixb' => { 389 => 0x204 },
	'colormatrixb2' => { 389 => 0x21d },
	'colormatrixnumber' => { 334 => 0x1019 },
	'colormatrixsrgb' => { 428 => 0xa031 },
	'colormode' => { 118 => 0x3015, 132 => 0x1210, 146 => 0x66, 187 => 0x28, 190 => 0x16, 192 => 0x101, 193 => 0x36, 195 => 0x7, 242 => 0x3, 290 => 0x4, 353 => 0x32, 431 => 0x2c, 455 => 0xb029, 535 => 'ColorMode' },
	'colormoirereduction' => { 108 => 0x20670, 302 => 0x15 },
	'colormoirereductionmode' => { 302 => 0x5 },
	'colormoirereductionon' => { 108 => '0x20670.0' },
	'colornoisereduction' => { 492 => 0x8029, 518 => 'ColorNoiseReduction', 520 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 518 => 'ColorNoiseReductionDetail', 520 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 302 => 0x18 },
	'colornoisereductionsharpness' => { 302 => 0x1c },
	'colornoisereductionsmoothness' => { 518 => 'ColorNoiseReductionSmoothness', 520 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 128 => 0x2 },
	'colorprofile' => { 187 => 0x33 },
	'colorprofilesettings' => { 329 => 0x539 },
	'colorrepresentation' => { 139 => 0x3c },
	'colorsaturationadj' => { 108 => 0x20305 },
	'colorsequence' => { 139 => 0x41 },
	'colorspace' => { 54 => 0x3, 68 => 0xb4, 102 => 0x10b4, 124 => 0xa001, 141 => 0x3, 168 => 'ColorSpace', 188 => 0x2f, 189 => 0x25, 190 => 0x17, 242 => 0x1e, 329 => 0x507, 389 => 0x37, 428 => 0xa011, 431 => 0xb, 441 => 0x1b, 442 => 0x83, 443 => 0xe, 460 => 0x6, 524 => 'ColorSpace' },
	'colorspace2' => { 67 => 0x9 },
	'colorspecapproximation' => { 141 => 0x2 },
	'colorspecdata' => { 141 => 0x3 },
	'colorspecmethod' => { 141 => 0x0 },
	'colorspecprecedence' => { 141 => 0x1 },
	'colortempasshot' => { 40 => 0x4, 41 => 0x7, 42 => 0x1d, 43 => 0x59, 44 => 0x6d, 45 => 0x6d, 46 => 0x26, 47 => 0x43, 50 => 0x43, 51 => 0x43, 52 => 0x43, 53 => 0x4b },
	'colortempauto' => { 40 => 0x9, 41 => 0xf, 42 => 0x22, 43 => 0x5e, 44 => 0x72, 46 => 0x1c, 47 => 0x48, 50 => 0x48, 51 => 0x48, 52 => 0x48, 53 => 0x50 },
	'colortempcloudy' => { 40 => 0x22, 41 => 0x37, 42 => 0x31, 43 => 0xa4, 44 => 0xdb, 45 => 0x7c, 46 => 0x35, 47 => 0x5c, 50 => 0x75, 51 => 0x8e, 52 => 0x93, 53 => 0x96, 389 => 0x55 },
	'colortempcustom' => { 47 => 0x84 },
	'colortempcustom1' => { 42 => 0x45 },
	'colortempcustom2' => { 42 => 0x4a },
	'colortempdaylight' => { 40 => 0x18, 41 => 0x27, 42 => 0x27, 43 => 0x9a, 44 => 0xd1, 45 => 0x72, 46 => 0x2b, 47 => 0x52, 50 => 0x6b, 51 => 0x84, 52 => 0x89, 53 => 0x8c, 389 => 0x53 },
	'colortemperature' => { 1 => 0x2d, 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 68 => 0xae, 78 => 0x9, 102 => 0x10ae, 132 => 0x1005, 144 => 0x846, 162 => 'ColorTemperature', 188 => [0x6e,0x49], 189 => 0x3f, 190 => [0x39,0x5e], 192 => 0x10b, 195 => [0x3c,0x4c,0x4e], 348 => 0x321, 389 => 0x50, 421 => 0x1308, 455 => 0xb021, 518 => 'Temperature', 520 => 'Temperature' },
	'colortemperatureadj' => { 492 => 0x8013 },
	'colortemperatureauto' => { 242 => 0x4f },
	'colortemperaturebg' => { 334 => 0x1013 },
	'colortemperaturecustom' => { 441 => 0xc, 442 => 0xb },
	'colortemperaturerg' => { 334 => 0x1014 },
	'colortemperatureset' => { 441 => 0x7, 442 => 0x6 },
	'colortemperaturesetting' => { 190 => 0x25, 443 => 0x17, 460 => 0xe },
	'colortempflash' => { 40 => 0x36, 41 => 0x57, 42 => 0x40, 43 => 0xb8, 44 => 0xef, 45 => 0x8b, 46 => 0x49, 47 => 0x70, 50 => 0x89, 51 => 0xa2, 52 => 0xa7, 53 => 0xaa, 389 => 0x5a },
	'colortempflashdata' => { 47 => 0x24a },
	'colortempfluorescent' => { 40 => 0x2c, 41 => 0x47, 42 => 0x3b, 43 => 0xae, 44 => 0xe5, 45 => 0x86, 46 => 0x3f, 47 => 0x66, 50 => 0x7f, 51 => 0x98, 52 => 0x9d, 53 => 0xa0 },
	'colortempfluorescentd' => { 389 => 0x57 },
	'colortempfluorescentn' => { 389 => 0x58 },
	'colortempfluorescentw' => { 389 => 0x59 },
	'colortempkelvin' => { 40 => 0x31, 41 => 0x4f, 43 => 0xb3, 44 => 0xea, 46 => 0x44, 47 => 0x6b, 50 => 0x84, 51 => 0x9d, 52 => 0xa2, 53 => 0xa5, 353 => 0x44, 421 => 0x1307 },
	'colortempmeasured' => { 40 => 0xe, 41 => 0x17, 43 => 0x63, 44 => 0x77, 47 => 0x4d, 50 => 0x4d, 51 => 0x4d, 52 => 0x4d, 53 => 0x55 },
	'colortemppc1' => { 46 => 0x94, 47 => 0x75 },
	'colortemppc2' => { 46 => 0x99, 47 => 0x7a },
	'colortemppc3' => { 46 => 0x9e, 47 => 0x7f },
	'colortempshade' => { 40 => 0x1d, 41 => 0x2f, 42 => 0x2c, 43 => 0x9f, 44 => 0xd6, 45 => 0x77, 46 => 0x30, 47 => 0x57, 50 => 0x70, 51 => 0x89, 52 => 0x8e, 53 => 0x91, 389 => 0x54 },
	'colortemptungsten' => { 40 => 0x27, 41 => 0x3f, 42 => 0x36, 43 => 0xa9, 44 => 0xe0, 45 => 0x81, 46 => 0x3a, 47 => 0x61, 50 => 0x7a, 51 => 0x93, 52 => 0x98, 53 => 0x9b, 389 => 0x56 },
	'colortempunknown' => { 40 => 0x13, 41 => 0x1f, 43 => 0x68, 44 => 0x7c, 46 => 0x21, 50 => 0x52, 51 => 0x52, 52 => 0x52, 53 => 0x5a },
	'colortempunknown10' => { 40 => 0x63, 41 => 0x9f, 43 => 0x95, 44 => 0xa9, 45 => 0xb8, 46 => 0x76, 50 => 0xa2, 51 => 0x7f, 52 => 0x7f, 53 => 0x87 },
	'colortempunknown11' => { 40 => 0x68, 41 => 0xa7, 43 => 0xbd, 44 => [0xae,0xb3], 45 => 0xbd, 46 => 0x7b, 50 => 0xa7, 51 => 0xa7, 52 => 0x84, 53 => 0xaf },
	'colortempunknown12' => { 40 => 0x6d, 41 => 0xaf, 43 => 0xc2, 44 => 0xb8, 45 => 0xc2, 46 => 0x80, 50 => 0xac, 51 => 0xac, 52 => 0xac, 53 => 0xb4 },
	'colortempunknown13' => { 40 => 0x72, 41 => 0xb7, 43 => 0xc7, 44 => 0xbd, 45 => 0xc7, 46 => 0x85, 50 => 0xb1, 51 => 0xb1, 52 => 0xb1, 53 => 0xb9 },
	'colortempunknown14' => { 43 => 0xcc, 44 => 0xc2, 45 => 0xcc, 46 => 0x8a, 50 => 0xb6, 51 => 0xb6, 52 => 0xb6, 53 => 0xbe },
	'colortempunknown15' => { 43 => 0xd1, 44 => 0xc7, 45 => 0xd1, 46 => 0x8f, 50 => 0xbb, 51 => 0xbb, 52 => 0xbb, 53 => 0xc3 },
	'colortempunknown16' => { 43 => 0xd6, 44 => 0xcc, 45 => 0xd6, 46 => 0xa3, 51 => 0xc0, 52 => 0xc0, 53 => 0xc8 },
	'colortempunknown17' => { 43 => 0xdb, 44 => 0xf4, 45 => 0xdb, 51 => 0xc5, 52 => 0xc5, 53 => 0xcd },
	'colortempunknown18' => { 43 => 0xe0, 44 => 0xf9, 45 => 0xe0, 51 => 0xca, 52 => 0xca, 53 => 0xd2 },
	'colortempunknown19' => { 43 => 0xe5, 44 => 0xfe, 45 => 0xe5, 51 => 0xcf, 52 => 0xcf, 53 => 0xd7 },
	'colortempunknown2' => { 40 => 0x3b, 41 => 0x5f, 43 => 0x6d, 44 => 0x81, 45 => 0x90, 46 => 0x4e, 50 => 0x57, 51 => 0x57, 52 => 0x57, 53 => 0x5f },
	'colortempunknown20' => { 43 => 0xea, 44 => 0x103, 45 => 0xea, 51 => 0xd4, 52 => 0xd4, 53 => 0xdc },
	'colortempunknown21' => { 43 => 0xef, 44 => 0x108, 45 => 0xef, 52 => 0xd9, 53 => 0xe1 },
	'colortempunknown22' => { 43 => 0xf4, 44 => 0x10d, 45 => 0xf4, 52 => 0xde, 53 => 0xe6 },
	'colortempunknown23' => { 43 => 0xf9, 44 => 0x112, 45 => 0xf9, 52 => 0xe3, 53 => 0xeb },
	'colortempunknown24' => { 43 => 0xfe, 44 => 0x117, 45 => 0xfe, 52 => 0xe8, 53 => 0xf0 },
	'colortempunknown25' => { 43 => 0x103, 44 => 0x11c, 45 => 0x103, 52 => 0xed, 53 => 0xf5 },
	'colortempunknown26' => { 43 => 0x108, 44 => 0x121, 45 => 0x108, 52 => 0xf2, 53 => 0xfa },
	'colortempunknown27' => { 43 => 0x10d, 44 => 0x126, 45 => 0x10d, 52 => 0xf7, 53 => 0xff },
	'colortempunknown28' => { 43 => 0x112, 45 => 0x112, 52 => 0xfc, 53 => 0x104 },
	'colortempunknown29' => { 43 => 0x117, 45 => 0x117, 52 => 0x101, 53 => 0x109 },
	'colortempunknown3' => { 40 => 0x40, 41 => 0x67, 43 => 0x72, 44 => 0x86, 45 => 0x95, 46 => 0x53, 50 => 0x5c, 51 => 0x5c, 52 => 0x5c, 53 => 0x64 },
	'colortempunknown30' => { 45 => 0x11c, 52 => 0x106 },
	'colortempunknown31' => { 45 => 0x121 },
	'colortempunknown32' => { 45 => 0x126 },
	'colortempunknown33' => { 45 => 0x12b },
	'colortempunknown4' => { 40 => 0x45, 41 => 0x6f, 43 => 0x77, 44 => 0x8b, 45 => 0x9a, 46 => 0x58, 50 => 0x61, 51 => 0x61, 52 => 0x61, 53 => 0x69 },
	'colortempunknown5' => { 40 => 0x4a, 41 => 0x77, 43 => 0x7c, 44 => 0x90, 45 => 0x9f, 46 => 0x5d, 50 => 0x66, 51 => 0x66, 52 => 0x66, 53 => 0x6e },
	'colortempunknown6' => { 40 => 0x4f, 41 => 0x7f, 43 => 0x81, 44 => 0x95, 45 => 0xa4, 46 => 0x62, 50 => 0x8e, 51 => 0x6b, 52 => 0x6b, 53 => 0x73 },
	'colortempunknown7' => { 40 => 0x54, 41 => 0x87, 43 => 0x86, 44 => 0x9a, 45 => 0xa9, 46 => 0x67, 50 => 0x93, 51 => 0x70, 52 => 0x70, 53 => 0x78 },
	'colortempunknown8' => { 40 => 0x59, 41 => 0x8f, 43 => 0x8b, 44 => 0x9f, 45 => 0xae, 46 => 0x6c, 50 => 0x98, 51 => 0x75, 52 => 0x75, 53 => 0x7d },
	'colortempunknown9' => { 40 => 0x5e, 41 => 0x97, 43 => 0x90, 44 => 0xa4, 45 => 0xb3, 46 => 0x71, 50 => 0x9d, 51 => 0x7a, 52 => 0x7a, 53 => 0x82 },
	'colortint' => { 352 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 36 => 0x2a, 54 => 0x2, 67 => 0x8 },
	'colortoneadj' => { 108 => 0x20304, 113 => 0x11e },
	'colortoneauto' => { 75 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 74 => 0x6c, 75 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 74 => 0x3c, 75 => 0x3c },
	'colortonemonochrome' => { 74 => 0x84, 75 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 74 => 0x54, 75 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 74 => 0x24, 75 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 74 => 0xc, 75 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 74 => 0x9c, 75 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 74 => 0xb4, 75 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 74 => 0xcc, 75 => 0xe4 },
	'columninterleavefactor' => { 124 => 0xcd43 },
	'comlenblksize' => { 144 => 0xfde8 },
	'commanddialframeadvancezoom' => { 252 => 0x804 },
	'commanddialplaybackmode' => { 325 => 0x1cb, 326 => 0x1cb, 327 => 0x1e3 },
	'commanddials' => { 319 => '5.1' },
	'commanddialsaperturesetting' => { 308 => '17.3', 309 => '18.3', 311 => '18.3', 312 => '18.3', 317 => '33.3', 318 => '17.3', 321 => '18.3', 322 => '18.3' },
	'commanddialschangemainsub' => { 308 => '17.2', 309 => '18.1', 311 => '18.1', 312 => '18.1', 317 => '33.2', 318 => '17.2', 321 => '18.1', 322 => '18.1' },
	'commanddialsmenuandplayback' => { 308 => '17.4', 309 => '18.2', 311 => '18.2', 312 => '18.2', 317 => '33.4', 318 => '17.4', 321 => '18.2', 322 => '18.2' },
	'commanddialsreverserotation' => { 308 => '17.1', 309 => '6.4', 311 => '6.2', 312 => '6.2', 313 => '16.2', 314 => '17.2', 317 => '33.1', 318 => '17.1', 321 => '6.2', 322 => '6.2', 323 => '18.1' },
	'commanddialvideoplaybackmode' => { 325 => 0x1cd, 327 => 0x1e5 },
	'commanderchannel' => { 319 => '10.2', 320 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 319 => '13.1', 320 => '31.1' },
	'commandergroupa_ttlcomp' => { 323 => '32.1' },
	'commandergroupamanualoutput' => { 319 => '13.2', 320 => '28.2' },
	'commandergroupamode' => { 319 => '11.2', 320 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 319 => '14.1', 320 => '32.1' },
	'commandergroupb_ttlcomp' => { 323 => '33.1' },
	'commandergroupbmanualoutput' => { 319 => '14.2', 320 => '29.2' },
	'commandergroupbmode' => { 319 => '11.3', 320 => '29.1' },
	'commanderinternalflash' => { 319 => '11.1', 320 => '27.1' },
	'commanderinternalmanualoutput' => { 319 => '12.2', 320 => '27.2' },
	'commanderinternalttlchannel' => { 317 => '18.2' },
	'commanderinternalttlcomp' => { 319 => '12.1', 320 => '30.2', 323 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 317 => '20.1', 318 => '26.1' },
	'commanderinternalttlcompgroupa' => { 317 => '21.1', 318 => '27.1' },
	'commanderinternalttlcompgroupb' => { 317 => '22.1', 318 => '28.1' },
	'comment' => { 0 => 0x2, 125 => 'Comment', 163 => 'Comment', 342 => 'Comment', 406 => "\xa9cmt", 408 => 'comment', 414 => "\xa9cmt" },
	'compass' => { 424 => 0x4 },
	'compatiblebrands' => { 408 => 'compatible_brands' },
	'compatibleversion' => { 518 => 'CompatibleVersion', 520 => 'CompatibleVersion' },
	'compilation' => { 406 => 'cpil' },
	'compimageimagespersequence' => { 525 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 525 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 525 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 525 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 525 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 525 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 525 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 525 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 525 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 525 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 537 => 'complianceProfile' },
	'componentsconfiguration' => { 124 => 0x9101, 168 => 'Components', 524 => 'ComponentsConfiguration' },
	'componentversion' => { 102 => 0x80c },
	'composer' => { 185 => 'WM/Composer', 406 => ["\xa9com","\xa9wrt"], 414 => ["\xa9com","\xa9wrt"], 547 => 'composer' },
	'composerid' => { 406 => 'cmID' },
	'composerkeywords' => { 414 => "\xa9cok" },
	'compositeimage' => { 124 => 0xa460, 525 => 'CompositeImage' },
	'compositeimagecount' => { 124 => 0xa461, 525 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 124 => 0xa462, 525 => 'CompositeImageExposureTimes' },
	'composition' => { 508 => 'Composition' },
	'compositionadjust' => { 387 => '0.1' },
	'compositionadjustrotation' => { 387 => 0x7 },
	'compositionadjustx' => { 387 => 0x5 },
	'compositionadjusty' => { 387 => 0x6 },
	'compressedbitsperpixel' => { 124 => 0x9102, 524 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 192 => 0x40, 334 => 0x40 },
	'compression' => { 124 => 0x103, 358 => 0xb, 543 => 'Compression' },
	'compressionfactor' => { 329 => 0x50d },
	'compressionformat' => { 67 => 0x4 },
	'compressionratio' => { 168 => 'Compression', 334 => 0x1034 },
	'compressorversion' => { 414 => 'CNCV' },
	'condadobvfactor' => { 144 => 0xf3e },
	'condadodaybvthresh' => { 144 => 0xf3c },
	'condadodayoffsets' => { 144 => 0xf42 },
	'condadofluoffsets' => { 144 => 0xf44 },
	'condadofluthresh' => { 144 => 0xf41 },
	'condadoillfactor' => { 144 => 0xf3f },
	'condadoneurange' => { 144 => 0xf3d },
	'condadotunoffsets' => { 144 => 0xf43 },
	'condadotunthresh' => { 144 => 0xf40 },
	'conductor' => { 185 => 'WM/Conductor', 406 => "\xa9con" },
	'confidence' => { 503 => 'Confidence' },
	'confidencelevel' => { 514 => 'ConfidenceLevel' },
	'confidencemime' => { 503 => 'ConfidenceMime' },
	'constrainedcropheight' => { 113 => 0x266, 400 => 0xd6 },
	'constrainedcropwidth' => { 113 => 0x262, 400 => 0xd5 },
	'contact' => { 137 => 0x76 },
	'contactinfo' => { 518 => 'ContactInfo', 520 => 'ContactInfo', 536 => 'contactInfo' },
	'container' => { 496 => 'Container' },
	'containerdirectory' => { 496 => [\'Container','ContainerDirectory'], 501 => 'Directory' },
	'containerdirectoryitem' => { 496 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 496 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 496 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 496 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 496 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 532 => 'ContainerFormat' },
	'containerformatidentifier' => { 532 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 532 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 406 => "\xa9day", 414 => ['@day',"\xa9day"] },
	'contentdistributor' => { 185 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 414 => 'cdis' },
	'contentid' => { 414 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 408 => 'content.identifier' },
	'contentlocationcode' => { 137 => 0x1a },
	'contentlocationname' => { 137 => 0x1b },
	'contenttype' => { 537 => 'contentType' },
	'continuousbracketing' => { 190 => 0x20 },
	'continuousdrive' => { 36 => 0x5 },
	'continuousmodedisplay' => { 324 => 0x55, 325 => 0x51, 326 => 0x51, 327 => 0x51 },
	'continuousmodeliveview' => { 322 => '77.2' },
	'continuousshootingspeed' => { 89 => 0x610 },
	'continuousshotlimit' => { 89 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 36 => 0xd, 117 => 0xc, 118 => [0x3012,0x20], 124 => [0xa408,0xfe54], 132 => [0x1004,0x1006], 162 => 'Contrast', 182 => 'Contrast', 187 => 0x20, 188 => 0x31, 189 => 0x27, 190 => 0x19, 195 => 0x2, 259 => 0x33, 260 => 0x37, 261 => 0x3f, 334 => 0x1029, 353 => 0x39, 355 => 0x300a, 389 => 0x20, 396 => 0xc, 408 => 'player.movie.visual.contrast', 415 => 0x24, 417 => 0x52, 421 => 0x1012, 431 => 0xd, 441 => 0x1d, 442 => 0x1a, 455 => 0x2004, 518 => 'Contrast', 520 => 'Contrast', 524 => 'Contrast' },
	'contrast2012' => { 518 => 'Contrast2012', 520 => 'Contrast2012' },
	'contrastadj' => { 108 => 0x20303, 113 => 0x115, 304 => 0x2c, 492 => 0x8017 },
	'contrastauto' => { 75 => 0x90 },
	'contrastcurve' => { 242 => 0x8c },
	'contrastdetectaf' => { 199 => 0x4 },
	'contrastdetectafarea' => { 389 => 0x231 },
	'contrastdetectafinfocus' => { 199 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 74 => 0x60, 75 => 0x60 },
	'contrasthighlight' => { 389 => 0x6d },
	'contrasthighlightshadowadj' => { 389 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 74 => 0x30, 75 => 0x30 },
	'contrastmode' => { 353 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 74 => 0x78, 75 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 74 => 0x48, 75 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 74 => 0x18, 75 => 0x18 },
	'contrastsetting' => { 329 => 0x505, 337 => 0x1012, 443 => 0x10, 460 => 0x8 },
	'contrastshadow' => { 389 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 74 => 0x0, 75 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 74 => 0x90, 75 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 74 => 0xa8, 75 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 74 => 0xc0, 75 => 0xd8 },
	'contributedmedia' => { 547 => 'contributedMedia' },
	'contributedmediaduration' => { 547 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 547 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 547 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 547 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 547 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 547 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 547 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 547 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 547 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 547 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 521 => 'contributor', 532 => 'Contributor' },
	'contributoridentifier' => { 532 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 532 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 532 => [\'Contributor','ContributorRole'] },
	'contributors' => { 163 => 'Contributors' },
	'controldialset' => { 190 => 0x46 },
	'controlledvocabularyterm' => { 532 => 'CVterm' },
	'controllerboardversion' => { 348 => 0x332 },
	'controlmode' => { 81 => 0x12 },
	'controlringresponse' => { 324 => 0x1cf, 325 => 0x1d5, 326 => 0x1d5, 327 => 0x1ed },
	'controlringrotation' => { 89 => 0x712 },
	'conversionlens' => { 330 => 0x403, 353 => 0x35 },
	'converter' => { 124 => 0xfe4d, 290 => 0xb, 518 => 'Converter', 520 => 'Converter' },
	'converttograyscale' => { 518 => 'ConvertToGrayscale', 520 => 'ConvertToGrayscale' },
	'cookingequipment' => { 539 => 'cookingEquipment' },
	'cookingmethod' => { 539 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 124 => 0x8298, 163 => 'Copyright', 342 => 'Copyright', 358 => 0x8298, 389 => 0x22f, 405 => 'Copyright', 406 => ['cprt',"\xa9cpy"], 408 => 'copyright', 414 => ['cprt',"\xa9cpy"], 518 => 'Copyright', 520 => 'Copyright', 534 => 'Copyright', 540 => 'copyright', 543 => 'Copyright', 547 => 'copyright' },
	'copyrightflag' => { 403 => 0x40a },
	'copyrightnotice' => { 137 => 0x74 },
	'copyrightowner' => { 339 => 'CopyrightOwner' },
	'copyrightownerid' => { 339 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 339 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 339 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 339 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 339 => 'CopyrightStatus' },
	'copyrightyear' => { 532 => 'CopyrightYear', 537 => 'copyrightYear' },
	'coringfilter' => { 333 => 0x310, 334 => 0x102d, 337 => 0x310 },
	'coringvalues' => { 333 => 0x311, 337 => 0x311 },
	'corporateentity' => { 537 => 'corporateEntity' },
	'correctionalreadyapplied' => { 343 => 'CorrectionAlreadyApplied' },
	'correlatedcolortemp' => { 352 => 0x35b },
	'country' => { 167 => 'Country', 353 => 0x69, 535 => 'Country' },
	'country-primarylocationcode' => { 137 => 0x64 },
	'country-primarylocationname' => { 137 => 0x65 },
	'countrycode' => { 241 => 0x5, 401 => 'CountryCode', 531 => 'CountryCode' },
	'course' => { 539 => 'course' },
	'coverage' => { 521 => 'coverage' },
	'coverart' => { 406 => 'covr' },
	'coverdate' => { 537 => 'coverDate' },
	'coverdisplaydate' => { 537 => 'coverDisplayDate' },
	'coveruri' => { 414 => 'cvru' },
	'cpufirmwareversion' => { 389 => 0x28 },
	'crc32' => { 522 => 'crc32' },
	'createdate' => { 124 => 0x9004, 163 => 'CreateDate', 338 => 'CreationDate', 342 => 'create-date', 405 => 'CreationDate', 411 => 0x1, 545 => 'CreateDate' },
	'creationdate' => { 408 => 'creationdate', 534 => 'CreationDate', 537 => 'creationDate' },
	'creationtime' => { 342 => 'Creation Time', 408 => 'creation_time' },
	'creativestyle' => { 441 => 0x1a, 442 => 0x18, 452 => 0x41, 455 => 0xb020, 487 => 0x4a },
	'creativestylesetting' => { 443 => 0xf, 460 => 0x7 },
	'creativestylewaschanged' => { 492 => 0x8001 },
	'creator' => { 338 => 'Creator', 405 => 'Creator', 521 => 'creator', 532 => 'Creator', 534 => 'Creator' },
	'creatoraddress' => { 531 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 184 => 'CreatorAppId' },
	'creatorcity' => { 531 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 531 => 'CreatorContactInfo' },
	'creatorcountry' => { 531 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 532 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 401 => 'CreatorIdentity' },
	'creatorname' => { 532 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 184 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 531 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 531 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 532 => [\'Creator','CreatorRole'] },
	'creatortool' => { 545 => 'CreatorTool' },
	'creatorworkemail' => { 531 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 531 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 531 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 137 => 0x6e, 535 => 'Credit' },
	'creditline' => { 540 => 'creditLine' },
	'creditlinereq' => { 550 => 'CreditLineReq' },
	'creditlinerequired' => { 339 => 'CreditLineRequired' },
	'cropactive' => { 106 => 0x0, 113 => 0x244 },
	'cropangle' => { 106 => 0x8, 518 => 'CropAngle', 520 => 'CropAngle' },
	'croparea' => { 242 => 0x45, 492 => 0x9011 },
	'cropaspectratio' => { 108 => 0x30101, 113 => 0x260 },
	'cropaspectratiocustom' => { 108 => 0x30102 },
	'cropbottom' => { 128 => 0x9, 296 => 0x36, 358 => 0x31, 400 => 0xdc, 518 => 'CropBottom', 520 => 'CropBottom' },
	'cropbottommargin' => { 56 => 0x3 },
	'cropcircleactive' => { 114 => 0xd6 },
	'cropcircleradius' => { 114 => 0xd9 },
	'cropcirclex' => { 114 => 0xd7 },
	'cropcircley' => { 114 => 0xd8 },
	'cropconstraintowarp' => { 518 => 'CropConstrainToWarp', 520 => 'CropConstrainToWarp' },
	'cropflag' => { 132 => 0x1051 },
	'croph' => { 512 => 'CropH' },
	'cropheight' => { 106 => 0x6, 113 => 0x24c, 333 => 0x615, 337 => 0x615, 518 => 'CropHeight', 520 => 'CropHeight' },
	'crophispeed' => { 242 => 0x1b },
	'cropleft' => { 113 => 0x246, 128 => 0x6, 296 => 0x1e, 333 => 0x612, 337 => 0x612, 358 => 0x30, 400 => 0xd9, 518 => 'CropLeft', 520 => 'CropLeft' },
	'cropleftmargin' => { 56 => 0x0 },
	'cropmode' => { 132 => 0x104d, 421 => 0x1018 },
	'croporiginalheight' => { 106 => 0xb },
	'croporiginalwidth' => { 106 => 0xa },
	'cropoutputheight' => { 296 => 0xce },
	'cropoutputheightinches' => { 296 => 0x96 },
	'cropoutputpixels' => { 296 => 0xd6 },
	'cropoutputresolution' => { 296 => 0xb6 },
	'cropoutputscale' => { 296 => 0xbe },
	'cropoutputwidth' => { 296 => 0xc6 },
	'cropoutputwidthinches' => { 296 => 0x8e },
	'croppedareaimageheightpixels' => { 506 => 'CroppedAreaImageHeightPixels', 507 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 506 => 'CroppedAreaImageWidthPixels', 507 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 506 => 'CroppedAreaLeftPixels', 507 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 506 => 'CroppedAreaTopPixels', 507 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 421 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 421 => 0x1603 },
	'cropping' => { 492 => 0x9010 },
	'cropright' => { 128 => 0x8, 296 => 0x2e, 358 => 0x32, 400 => 0xdb, 518 => 'CropRight', 520 => 'CropRight' },
	'croprightmargin' => { 56 => 0x1 },
	'croprotatedoriginalheight' => { 106 => 0x2 },
	'croprotatedoriginalwidth' => { 106 => 0x1 },
	'croprotation' => { 106 => 0x7, 128 => 0xb },
	'cropscaledresolution' => { 296 => 0x9e },
	'cropsize' => { 132 => 0x1053 },
	'cropsourceresolution' => { 296 => 0xae },
	'croptop' => { 113 => 0x248, 128 => 0x7, 296 => 0x26, 333 => 0x613, 337 => 0x613, 358 => 0x2f, 400 => 0xda, 518 => 'CropTop', 520 => 'CropTop' },
	'croptopleft' => { 132 => 0x1052 },
	'croptopmargin' => { 56 => 0x2 },
	'cropunit' => { 518 => 'CropUnit', 520 => 'CropUnit' },
	'cropunits' => { 518 => 'CropUnits', 520 => 'CropUnits' },
	'cropw' => { 512 => 'CropW' },
	'cropwidth' => { 106 => 0x5, 113 => 0x24a, 333 => 0x614, 337 => 0x614, 518 => 'CropWidth', 520 => 'CropWidth' },
	'cropx' => { 106 => 0x3, 512 => 'CropX' },
	'cropy' => { 106 => 0x4, 512 => 'CropY' },
	'crossprocess' => { 389 => 0x7b },
	'crossprocessparams' => { 389 => 0x235 },
	'cuisine' => { 539 => 'cuisine' },
	'currenticcprofile' => { 124 => 0xc691 },
	'currentpreprofilematrix' => { 124 => 0xc692 },
	'currentversion' => { 492 => 0xd000 },
	'curve0x' => { 512 => 'Curve0x' },
	'curve0y' => { 512 => 'Curve0y' },
	'curve1x' => { 512 => 'Curve1x' },
	'curve1y' => { 512 => 'Curve1y' },
	'curve2x' => { 512 => 'Curve2x' },
	'curve2y' => { 512 => 'Curve2y' },
	'curve3x' => { 512 => 'Curve3x' },
	'curve3y' => { 512 => 'Curve3y' },
	'curve4x' => { 512 => 'Curve4x' },
	'curve4y' => { 512 => 'Curve4y' },
	'curves' => { 301 => 0x76a43201 },
	'custom1' => { 339 => 'Custom1' },
	'custom10' => { 339 => 'Custom10' },
	'custom2' => { 339 => 'Custom2' },
	'custom3' => { 339 => 'Custom3' },
	'custom4' => { 339 => 'Custom4' },
	'custom5' => { 339 => 'Custom5' },
	'custom6' => { 339 => 'Custom6' },
	'custom7' => { 339 => 'Custom7' },
	'custom8' => { 339 => 'Custom8' },
	'custom9' => { 339 => 'Custom9' },
	'customcolortone' => { 114 => 0x4c },
	'customcontrast' => { 114 => 0x4e },
	'customcontrols' => { 89 => 0x70c },
	'customdefaultunsharpfineness' => { 114 => 0xbe },
	'customdefaultunsharpstrength' => { 114 => 0xbc },
	'customdefaultunsharpthreshold' => { 114 => 0xc0 },
	'customilluminant' => { 144 => 0x405 },
	'customizedials' => { 89 => 0x715 },
	'customlinear' => { 114 => 0x4f },
	'customoutputhighlightpoint' => { 114 => 0x53 },
	'customoutputshadowpoint' => { 114 => 0x54 },
	'custompicturestyle' => { 108 => 0x10021 },
	'custompicturestyledata' => { 108 => 0xf0500 },
	'custompicturestylefilename' => { 68 => 0x4010 },
	'customrawhighlight' => { 114 => 0x7c },
	'customrawhighlightpoint' => { 114 => 0x51 },
	'customrawshadow' => { 114 => 0x85 },
	'customrawshadowpoint' => { 114 => 0x52 },
	'customrendered' => { 124 => 0xa401, 197 => 0x6420, 524 => 'CustomRendered' },
	'customsaturation' => { 114 => 0x4d, 329 => 0x503 },
	'customsettingsalldefault' => { 308 => '0.2', 317 => '0.2' },
	'customsettingsbank' => { 308 => '0.1', 309 => '0.1', 311 => '0.1', 312 => '0.1', 317 => '0.1', 321 => '0.2', 322 => '0.2', 325 => 0x1, 326 => 0x1, 327 => 0x1 },
	'customsharpness' => { 114 => 0x50 },
	'customunsharpmaskfineness' => { 114 => 0xb8 },
	'customunsharpmaskstrength' => { 114 => 0xb6 },
	'customunsharpmaskthreshold' => { 114 => 0xba },
	'customwb_rblevels' => { 460 => 0x1a },
	'customwb_rgblevels' => { 442 => 0x8, 443 => 0x19 },
	'customwbbluelevel' => { 190 => 0x36 },
	'customwberror' => { 190 => 0x37 },
	'customwbgreenlevel' => { 190 => 0x35 },
	'customwbredlevel' => { 190 => 0x34 },
	'customwbsetting' => { 190 => 0x26 },
	'cx' => { 414 => '_cx_' },
	'cy' => { 414 => '_cy_' },
	'd-lightinghq' => { 301 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 297 => 0x2 },
	'd-lightinghqhighlight' => { 297 => 0x1 },
	'd-lightinghqselected' => { 301 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 297 => 0x0 },
	'd-lightinghs' => { 301 => 0xce5554aa },
	'd-lightinghsadjustment' => { 298 => 0x0 },
	'd-lightinghscolorboost' => { 298 => 0x1 },
	'd-rangeoptimizerhighlight' => { 492 => 0x8024 },
	'd-rangeoptimizermode' => { 492 => 0x8022 },
	'd-rangeoptimizershadow' => { 492 => 0x802d },
	'd-rangeoptimizervalue' => { 492 => 0x8023 },
	'darkblacksegrows' => { 144 => 0x18d8 },
	'darkfocusenvironment' => { 353 => 0x8003 },
	'darkframecountfactor' => { 144 => 0xc85 },
	'darkframelongexposure' => { 144 => 0xc84 },
	'darkframeshortexposure' => { 144 => 0xc83 },
	'darkpedestal' => { 144 => 0xc7f },
	'datacompressionmethod' => { 139 => 0x6e },
	'dataimprint' => { 187 => 0x34 },
	'datamining' => { 339 => 'DataMining' },
	'dataonscreen' => { 532 => 'DataOnScreen' },
	'dataonscreenregion' => { 532 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 532 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 532 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 532 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 532 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 532 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 532 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 532 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 389 => 0x3d },
	'date' => { 389 => 0x6, 521 => 'date' },
	'dateacquired' => { 184 => 'DateAcquired', 185 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 137 => 0x37, 535 => 'DateCreated' },
	'datedisplayformat' => { 293 => 0x3 },
	'dateidentified' => { 123 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 313 => '4.2' },
	'daterecieved' => { 537 => 'dateRecieved' },
	'datesent' => { 138 => 0x46 },
	'datestampmode' => { 68 => 0x1c, 242 => 0x9d },
	'datetime' => { 513 => 'datetime', 543 => 'DateTime' },
	'datetimedigitized' => { 524 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 105 => 0x0, 124 => 0x9003, 160 => 0x14, 163 => 'OriginalDate', 409 => 'IDIT', 414 => 'date', 415 => 0xb, 416 => 0x3b, 417 => 0x3e, 524 => 'DateTimeOriginal' },
	'datetimestamp' => { 146 => 0x64 },
	'datetimeutc' => { 329 => 0x908 },
	'daylightsavings' => { 82 => 0x3, 293 => 0x2 },
	'dayofweek' => { 416 => 0x42, 417 => 0x4a },
	'dccontinent' => { 123 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 123 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 123 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 123 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 123 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 123 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 123 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 123 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 123 => 'Event' },
	'dcfootprintspatialfit' => { 123 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 123 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 123 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 123 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 123 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 123 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 123 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 123 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 123 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 123 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 123 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 123 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 123 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 123 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 123 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 123 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 123 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 123 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 123 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 123 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 123 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 123 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 123 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 123 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 123 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 123 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 123 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 123 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 123 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 123 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 171 => 'Declination' },
	'decposition' => { 187 => 0x32 },
	'defaultautogray' => { 518 => 'DefaultAutoGray', 520 => 'DefaultAutoGray' },
	'defaultautotone' => { 518 => 'DefaultAutoTone', 520 => 'DefaultAutoTone' },
	'defaultblackrender' => { 124 => 0xc7a6 },
	'defaultcroporigin' => { 124 => 0xc61f },
	'defaultcropsize' => { 124 => 0xc620 },
	'defaulteraseoption' => { 89 => 0x813 },
	'defaultscale' => { 124 => 0xc61e },
	'defaultsspecifictoiso' => { 518 => 'DefaultsSpecificToISO', 520 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 518 => 'DefaultsSpecificToSerial', 520 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 124 => 0xc7b5 },
	'defectisocode' => { 144 => 0x90f },
	'defringe' => { 518 => 'Defringe', 520 => 'Defringe' },
	'defringegreenamount' => { 518 => 'DefringeGreenAmount', 520 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 518 => 'DefringeGreenHueHi', 520 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 518 => 'DefringeGreenHueLo', 520 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 518 => 'DefringePurpleAmount', 520 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 518 => 'DefringePurpleHueHi', 520 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 518 => 'DefringePurpleHueLo', 520 => 'DefringePurpleHueLo' },
	'dehaze' => { 518 => 'Dehaze', 520 => 'Dehaze' },
	'deletedimagecount' => { 242 => 0xa6, 272 => 0x6e },
	'deprecatedon' => { 516 => 'deprecatedOn' },
	'depthbasedcorrcorrectionactive' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'] },
	'depthbasedcorrcorrectionamount' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'] },
	'depthbasedcorrcorrectionsyncid' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'] },
	'depthbasedcorrections' => { 518 => 'DepthBasedCorrections', 520 => 'DepthBasedCorrections' },
	'depthbasedcorrlocalcorrecteddepth' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'] },
	'depthbasedcorrlocalcurverefinesaturation' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'] },
	'depthbasedcorrmask' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'] },
	'depthbasedcorrmaskalpha' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'] },
	'depthbasedcorrmaskangle' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'] },
	'depthbasedcorrmaskbottom' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'] },
	'depthbasedcorrmaskcentervalue' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'] },
	'depthbasedcorrmaskcenterweight' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'] },
	'depthbasedcorrmaskdabs' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'] },
	'depthbasedcorrmaskfeather' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'] },
	'depthbasedcorrmaskflipped' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'] },
	'depthbasedcorrmaskflow' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'] },
	'depthbasedcorrmaskfullx' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'] },
	'depthbasedcorrmaskfully' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'] },
	'depthbasedcorrmaskinputdigest' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'] },
	'depthbasedcorrmaskleft' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'] },
	'depthbasedcorrmaskmaskactive' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'] },
	'depthbasedcorrmaskmaskblendmode' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'depthbasedcorrmaskmaskdigest' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'] },
	'depthbasedcorrmaskmaskinverted' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'] },
	'depthbasedcorrmaskmaskname' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'] },
	'depthbasedcorrmaskmasks' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'] },
	'depthbasedcorrmaskmasksalpha' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'depthbasedcorrmaskmasksangle' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'] },
	'depthbasedcorrmaskmasksbottom' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'] },
	'depthbasedcorrmaskmaskscentervalue' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'depthbasedcorrmaskmaskscenterweight' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'depthbasedcorrmaskmasksdabs' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'] },
	'depthbasedcorrmaskmasksfeather' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'] },
	'depthbasedcorrmaskmasksflipped' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'depthbasedcorrmaskmasksflow' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'] },
	'depthbasedcorrmaskmasksfullx' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'] },
	'depthbasedcorrmaskmasksfully' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'] },
	'depthbasedcorrmaskmasksinputdigest' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'depthbasedcorrmaskmasksleft' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'] },
	'depthbasedcorrmaskmasksmaskactive' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'depthbasedcorrmaskmasksmaskblendmode' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'depthbasedcorrmaskmasksmaskdigest' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'depthbasedcorrmaskmasksmaskinverted' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'depthbasedcorrmaskmasksmaskname' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'depthbasedcorrmaskmasksmasksubtype' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'depthbasedcorrmaskmasksmasksyncid' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'depthbasedcorrmaskmasksmaskversion' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'depthbasedcorrmaskmasksmidpoint' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'depthbasedcorrmaskmasksorigin' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'depthbasedcorrmaskmasksperimetervalue' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'depthbasedcorrmaskmasksradius' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'] },
	'depthbasedcorrmaskmasksreferencepoint' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'depthbasedcorrmaskmasksright' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'] },
	'depthbasedcorrmaskmasksroundness' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'depthbasedcorrmaskmaskssizex' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'depthbasedcorrmaskmaskssizey' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'depthbasedcorrmaskmaskstop' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'] },
	'depthbasedcorrmaskmasksubtype' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'] },
	'depthbasedcorrmaskmasksvalue' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'depthbasedcorrmaskmasksversion' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'] },
	'depthbasedcorrmaskmaskswhat' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'] },
	'depthbasedcorrmaskmaskswholeimagearea' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'depthbasedcorrmaskmasksx' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'] },
	'depthbasedcorrmaskmasksy' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'] },
	'depthbasedcorrmaskmasksyncid' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'depthbasedcorrmaskmaskszerox' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'depthbasedcorrmaskmaskszeroy' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'depthbasedcorrmaskmaskversion' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'] },
	'depthbasedcorrmaskmidpoint' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'] },
	'depthbasedcorrmaskorigin' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'] },
	'depthbasedcorrmaskperimetervalue' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'depthbasedcorrmaskradius' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'] },
	'depthbasedcorrmaskrange' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'depthbasedcorrmaskrangeareamodels' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'depthbasedcorrmaskrangeareamodelscolorsampleinfo' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'depthbasedcorrmaskrangeareamodelscomponents' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'depthbasedcorrmaskrangecoloramount' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'depthbasedcorrmaskrangedepthfeather' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'depthbasedcorrmaskrangedepthmax' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'depthbasedcorrmaskrangedepthmin' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'depthbasedcorrmaskrangeinvert' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'depthbasedcorrmaskrangelumfeather' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'depthbasedcorrmaskrangeluminancedepthsampleinfo' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'depthbasedcorrmaskrangelummax' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'depthbasedcorrmaskrangelummin' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'depthbasedcorrmaskrangelumrange' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'depthbasedcorrmaskrangesampletype' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'depthbasedcorrmaskrangetype' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'depthbasedcorrmaskrangeversion' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'depthbasedcorrmaskreferencepoint' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'] },
	'depthbasedcorrmaskright' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'] },
	'depthbasedcorrmaskroundness' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'] },
	'depthbasedcorrmasksizex' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'] },
	'depthbasedcorrmasksizey' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'] },
	'depthbasedcorrmasktop' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'] },
	'depthbasedcorrmaskvalue' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'] },
	'depthbasedcorrmaskversion' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'] },
	'depthbasedcorrmaskwhat' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'] },
	'depthbasedcorrmaskwholeimagearea' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'depthbasedcorrmaskx' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'] },
	'depthbasedcorrmasky' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'] },
	'depthbasedcorrmaskzerox' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'] },
	'depthbasedcorrmaskzeroy' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'] },
	'depthbasedcorrwhat' => { 518 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'], 520 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'] },
	'depthfar' => { 124 => 0xc7eb },
	'depthformat' => { 124 => 0xc7e9 },
	'depthimage' => { 503 => 'Data' },
	'depthmapinfo' => { 518 => 'DepthMapInfo', 520 => 'DepthMapInfo' },
	'depthmapinfobasehighlightguideinputdigest' => { 518 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'], 520 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'] },
	'depthmapinfobasehighlightguidetable' => { 518 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'], 520 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'] },
	'depthmapinfobasehighlightguideversion' => { 518 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'], 520 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'] },
	'depthmapinfobaselayereddepthinputdigest' => { 518 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'], 520 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'] },
	'depthmapinfobaselayereddepthtable' => { 518 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'], 520 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'] },
	'depthmapinfobaselayereddepthversion' => { 518 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'], 520 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'] },
	'depthmapinfobaserawdepthinputdigest' => { 518 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'], 520 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'] },
	'depthmapinfobaserawdepthtable' => { 518 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'], 520 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'] },
	'depthmapinfobaserawdepthversion' => { 518 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'], 520 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'] },
	'depthmapinfodepthsource' => { 518 => [\'DepthMapInfo','DepthMapInfoDepthSource'], 520 => [\'DepthMapInfo','DepthMapInfoDepthSource'] },
	'depthmeasuretype' => { 124 => 0xc7ed },
	'depthnear' => { 124 => 0xc7ea },
	'depthunits' => { 124 => 0xc7ec },
	'derivedfrom' => { 548 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 548 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 548 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 548 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 548 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 548 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 548 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 548 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 548 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 548 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 548 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 548 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 548 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 548 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 548 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 548 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 548 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 548 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 548 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 548 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 548 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 548 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 548 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 548 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 185 => 'Description', 342 => 'Description', 406 => ['desc','dscp',"\xa9des"], 408 => 'description', 414 => 'dscp', 518 => 'Description', 520 => 'Description', 521 => 'description', 545 => 'Description' },
	'destination' => { 138 => 0x5 },
	'destinationcity' => { 389 => 0x24, 395 => 0x3 },
	'destinationcitycode' => { 396 => 0x1001 },
	'destinationdst' => { 389 => 0x26, 395 => '0.3' },
	'developmentdynamicrange' => { 132 => 0x1403 },
	'deviantmatrixcustom' => { 144 => 0x7de },
	'deviantmatrixdaylight' => { 144 => 0x7da },
	'deviantmatrixflash' => { 144 => 0x7dd },
	'deviantmatrixfluorescent' => { 144 => 0x7dc },
	'deviantmatrixtungsten' => { 144 => 0x7db },
	'deviantwhitecustom' => { 144 => 0x842 },
	'deviantwhitedaylight' => { 144 => 0x83e },
	'deviantwhiteflash' => { 144 => 0x841 },
	'deviantwhitefluorescent' => { 144 => 0x840 },
	'deviantwhitetungsten' => { 144 => 0x83f },
	'device' => { 537 => 'device' },
	'devicesettingdescription' => { 524 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 524 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 524 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 524 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 428 => 0x2 },
	'dewarpdata' => { 121 => 'DewarpData' },
	'dewarpflag' => { 121 => 'DewarpFlag' },
	'dialdirectiontvav' => { 89 => 0x706 },
	'dietaryneeds' => { 539 => 'dietaryNeeds' },
	'diffractioncompensation' => { 231 => 0x20e, 246 => 0x2ce, 247 => 0x142, 248 => 0x1b2, 249 => 0x1b2, 250 => 0x1a2, 251 => 0x1b6, 252 => 0x1b6 },
	'diffractioncorrection' => { 353 => 0xbc, 378 => 0x3 },
	'diffractioncorrectionon' => { 108 => 0x2070b },
	'digitalcreationdate' => { 137 => 0x3e },
	'digitalcreationtime' => { 137 => 0x3f },
	'digitaldeehighlightadj' => { 267 => 0x202 },
	'digitaldeeshadowadj' => { 267 => 0x200 },
	'digitaldeethreshold' => { 267 => 0x201 },
	'digitalfilter' => { 431 => 0x59 },
	'digitalfilter01' => { 375 => 0x5 },
	'digitalfilter02' => { 375 => 0x16 },
	'digitalfilter03' => { 375 => 0x27 },
	'digitalfilter04' => { 375 => 0x38 },
	'digitalfilter05' => { 375 => 0x49 },
	'digitalfilter06' => { 375 => 0x5a },
	'digitalfilter07' => { 375 => 0x6b },
	'digitalfilter08' => { 375 => 0x7c },
	'digitalfilter09' => { 375 => 0x8d },
	'digitalfilter10' => { 375 => 0x9e },
	'digitalfilter11' => { 375 => 0xaf },
	'digitalfilter12' => { 375 => 0xc0 },
	'digitalfilter13' => { 375 => 0xd1 },
	'digitalfilter14' => { 375 => 0xe2 },
	'digitalfilter15' => { 375 => 0xf3 },
	'digitalfilter16' => { 375 => 0x104 },
	'digitalfilter17' => { 375 => 0x115 },
	'digitalfilter18' => { 375 => 0x126 },
	'digitalfilter19' => { 375 => 0x137 },
	'digitalfilter20' => { 375 => 0x148 },
	'digitalgain' => { 78 => 0xb },
	'digitalgem' => { 226 => 0x0 },
	'digitalice' => { 267 => 0x100 },
	'digitalimageguid' => { 532 => 'DigImageGUID' },
	'digitallensoptimizer' => { 66 => 0xa },
	'digitallensoptimizersetting' => { 84 => 0x9 },
	'digitalroc' => { 264 => 0x0 },
	'digitalsourcefiletype' => { 532 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 532 => 'DigitalSourceType' },
	'digitalzoom' => { 36 => 0xc, 117 => 0xa, 132 => 0x1044, 146 => 0x68, 157 => 0x22, 158 => 0x1e, 162 => 'DigitalZoom', 187 => 0xc, 242 => 0x86, 290 => 0xa, 334 => 0x204, 389 => 0x1e, 396 => 0xa, 430 => 0x204, 478 => 0x12, 479 => 0x12 },
	'digitalzoomon' => { 430 => 0x21b },
	'digitalzoomratio' => { 124 => 0xa404, 466 => 0x200, 468 => 0x21c, 524 => 'DigitalZoomRatio' },
	'director' => { 185 => 'WM/Director', 406 => "\xa9dir", 408 => 'director', 414 => "\xa9dir", 547 => 'director' },
	'directorphotography' => { 547 => 'directorPhotography' },
	'directory' => { 125 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba, 30 => 0xb21 },
	'directoryindex2' => { 21 => 0x29c },
	'directoryitem' => { 501 => [\'Directory','DirectoryItem'] },
	'directoryitemlabel' => { 501 => [\'Directory','DirectoryItemLabel'] },
	'directoryitemlength' => { 501 => [\'Directory','DirectoryItemLength'] },
	'directoryitemmime' => { 501 => [\'Directory','DirectoryItemMime'] },
	'directoryitempadding' => { 501 => [\'Directory','DirectoryItemPadding'] },
	'directoryitemsemantic' => { 501 => [\'Directory','DirectoryItemSemantic'] },
	'directoryitemuri' => { 501 => [\'Directory','DirectoryItemURI'] },
	'directorynumber' => { 219 => 0x3, 417 => 0x12 },
	'disableautocreation' => { 500 => 'DisableAutoCreation' },
	'disablesuggestedaction' => { 500 => 'DisableSuggestedAction' },
	'disclaimer' => { 342 => 'Disclaimer' },
	'discnumber' => { 547 => 'discNumber' },
	'dishtype' => { 539 => 'dishType' },
	'disknumber' => { 406 => 'disk' },
	'dispbutton' => { 252 => 0x7d4, 325 => 0x2ab },
	'displayallafpoints' => { 89 => 0x514 },
	'displayaperture' => { 36 => 0x23 },
	'displayedunitsx' => { 404 => 0x2 },
	'displayedunitsy' => { 404 => 0x6 },
	'displayname' => { 408 => 'displayname', 536 => 'displayName' },
	'distance1' => { 146 => 0x28 },
	'distance2' => { 146 => 0x2c },
	'distance3' => { 146 => 0x30 },
	'distance4' => { 146 => 0x34 },
	'distortion' => { 428 => 0xa050 },
	'distortioncompensation' => { 492 => 0x8040 },
	'distortioncontrol' => { 272 => 0x10 },
	'distortioncorrection' => { 83 => 0x3, 108 => 0x20705, 114 => 0x67, 124 => 0x7036, 217 => 0x4, 329 => 0x50b, 357 => '7.1', 378 => 0x0, 486 => 0x601, 487 => 0x5b },
	'distortioncorrection2' => { 333 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 515 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 108 => '0x20705.0', 114 => 0x63 },
	'distortioncorrectionsetting' => { 84 => 0x7, 455 => 0x2013 },
	'distortioncorrectionvalue' => { 83 => 0x9 },
	'distortioncorrectionversion' => { 217 => 0x0 },
	'distortioncorrparams' => { 124 => 0x7037, 465 => 0x1a23, 468 => 0x1870, 470 => 0x189c, 471 => 0x18cc, 472 => 0x17d0, 486 => 0x6ca, 487 => 0x64 },
	'distortioncorrparamsnumber' => { 468 => 0x1899, 470 => 0x18c5, 471 => 0x18f5, 472 => 0x17f9 },
	'distortioncorrparamspresent' => { 468 => 0x1898, 470 => 0x18c4, 471 => 0x18f4, 472 => 0x17f8, 474 => 0x10b, 475 => 0x10b, 486 => 0x600, 487 => 0x5a },
	'distortioneffect' => { 108 => 0x20709 },
	'distortionn' => { 357 => 0xc },
	'distortionparam02' => { 357 => 0x2 },
	'distortionparam04' => { 357 => 0x4 },
	'distortionparam08' => { 357 => 0x8 },
	'distortionparam09' => { 357 => 0x9 },
	'distortionparam11' => { 357 => 0xb },
	'distortionscale' => { 357 => 0x5 },
	'distributor' => { 537 => 'distributor' },
	'distributorproductid' => { 536 => 'distributorProductID' },
	'dloon' => { 108 => '0x20706.0', 114 => 0xdc },
	'dlosetting' => { 108 => 0x20706, 114 => 0xdd },
	'dlosettingapplied' => { 107 => 0x4 },
	'dloshootingdistance' => { 114 => 0xde },
	'dloversion' => { 107 => 0x5 },
	'dmcomment' => { 547 => 'comment' },
	'dmdithermatrix' => { 144 => 0xc7a },
	'dmdithermatrixheight' => { 144 => 0xc7c },
	'dmdithermatrixwidth' => { 144 => 0xc7b },
	'dngadobedata' => { 124 => 0xc634 },
	'dngbackwardversion' => { 124 => 0xc613 },
	'dngignoresidecars' => { 518 => 'DNGIgnoreSidecars', 520 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 124 => 0xc630 },
	'dngprivatedata' => { 124 => 0xc634 },
	'dngversion' => { 124 => 0xc612 },
	'document' => { 342 => 'Document' },
	'documentancestors' => { 535 => 'DocumentAncestors' },
	'documenthistory' => { 137 => 0xe7 },
	'documentid' => { 548 => 'DocumentID' },
	'documentname' => { 124 => 0x10d },
	'documentnotes' => { 137 => 0xe6 },
	'doi' => { 537 => 'doi' },
	'dopesheet' => { 532 => 'Dopesheet' },
	'dopesheetlink' => { 532 => 'DopesheetLink' },
	'dopesheetlinklink' => { 532 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 532 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 144 => 0xc82 },
	'dpp' => { 513 => 'dpp' },
	'dprawbokehshift' => { 108 => 0x20b20 },
	'dprawbokehshiftarea' => { 108 => 0x20b21 },
	'dprawghostingreductionarea' => { 108 => 0x20b30 },
	'dprawmicroadjustbackfront' => { 108 => 0x20b10 },
	'dprawmicroadjuststrength' => { 108 => 0x20b12 },
	'dr4cameramodel' => { 109 => 0x3 },
	'drangepriority' => { 132 => 0x1443 },
	'drangepriorityauto' => { 132 => 0x1444 },
	'drangepriorityfixed' => { 132 => 0x1445 },
	'drivemode' => { 118 => 0x3103, 130 => '0.1', 187 => 0x6, 190 => 0x1e, 193 => 0xe, 197 => 0x64d0, 329 => 0x600, 389 => 0x34, 421 => 0x1002, 431 => 0x3, 441 => 0x4, 442 => 0x7e, 443 => 0x34 },
	'drivemode2' => { 190 => 0xa, 369 => 0x7, 452 => 0xe, 460 => 0x1 },
	'drivemodesetting' => { 443 => 0x4 },
	'drivespeed' => { 130 => '0.2' },
	'dspfirmwareversion' => { 389 => 0x27 },
	'dualpixelraw' => { 66 => 0xb },
	'duration' => { 71 => 0x6a, 161 => 'Duration', 175 => 'Duration', 539 => 'duration', 547 => 'duration' },
	'durationscale' => { 547 => [\'duration','durationScale'] },
	'durationvalue' => { 547 => [\'duration','durationValue'] },
	'dustremovaldata' => { 68 => 0x97 },
	'dxcropalert' => { 248 => 0x250, 249 => 0x250, 250 => 0x23c, 251 => 0x250, 252 => 0x250 },
	'dynamicafarea' => { 308 => '1.4', 317 => '1.4' },
	'dynamicafareasize' => { 246 => 0x370, 248 => 0x254, 249 => 0x254, 250 => 0x240, 251 => 0x254, 252 => 0x254 },
	'dynamicareaafassist' => { 324 => 0x18, 325 => 0x18, 326 => 0x18, 327 => 0x18 },
	'dynamicareaafdisplay' => { 309 => '46.1', 311 => '47.1', 312 => '47.1', 321 => '47.1', 322 => '47.1' },
	'dynamicrange' => { 132 => 0x1400 },
	'dynamicrangeboost' => { 353 => 0xee },
	'dynamicrangeexpansion' => { 389 => 0x69, 421 => 0x100e },
	'dynamicrangemax' => { 113 => 0x7c },
	'dynamicrangemin' => { 113 => 0x7a },
	'dynamicrangeoptimizer' => { 190 => 0x15, 455 => [0xb025,0xb04f], 464 => 0x1144, 465 => [0x1144,0x324], 466 => [0x1120,0x300], 467 => [0x119c,0x37c], 468 => [0x1178,0x328], 469 => [0x1030,0x50], 470 => [0x228,0x50], 471 => [0x228,0x50], 472 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 452 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 441 => 0x19, 442 => 0x17, 443 => 0xd, 452 => 0x79, 460 => 0x5 },
	'dynamicrangeoptimizermode' => { 193 => 0x15, 441 => 0x18, 442 => 0x16, 452 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 190 => 0x27, 443 => 0xc, 460 => 0x4 },
	'dynamicrangesetting' => { 132 => 0x1402 },
	'e-dialinprogram' => { 369 => '1.3' },
	'earliestageorloweststage' => { 123 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 123 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 123 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 123 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 123 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 496 => 'EarthPos' },
	'earthposaltitude' => { 496 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 496 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 496 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 496 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 496 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 496 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 496 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 496 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 323 => '6.1' },
	'easyexposurecompensation' => { 308 => '6.4', 309 => '6.5', 311 => '6.3', 312 => '6.3', 316 => '5.1', 317 => '4.4', 318 => '5.2', 321 => '6.3', 322 => '6.3', 324 => 0x1f, 325 => 0x1d, 326 => 0x1d, 327 => 0x1d },
	'easymode' => { 36 => 0xb },
	'edgemapslope' => { 144 => 0x930 },
	'edgemapx1' => { 144 => 0x931 },
	'edgemapx2' => { 144 => 0x932 },
	'edgemapx3' => { 144 => 0x934 },
	'edgemapx4' => { 144 => 0x935 },
	'edgenoisereduction' => { 302 => 0x4, 492 => 0x8028 },
	'edit1' => { 414 => "\xa9ed1" },
	'edit2' => { 414 => "\xa9ed2" },
	'edit3' => { 414 => "\xa9ed3" },
	'edit4' => { 414 => "\xa9ed4" },
	'edit5' => { 414 => "\xa9ed5" },
	'edit6' => { 414 => "\xa9ed6" },
	'edit7' => { 414 => "\xa9ed7" },
	'edit8' => { 414 => "\xa9ed8" },
	'edit9' => { 414 => "\xa9ed9" },
	'edition' => { 537 => 'edition' },
	'editorialupdate' => { 137 => 0x8 },
	'editstatus' => { 137 => 0x7, 401 => 'EditStatus', 513 => 'EditStatus' },
	'editversionname' => { 301 => 0x3d136244 },
	'effectivelv' => { 389 => 0x2d },
	'effectivemaxaperture' => { 235 => 0x12, 236 => 0x13, 240 => 0x14 },
	'eissn' => { 537 => 'eIssn' },
	'electricalblackcolumns' => { 144 => 0x1810 },
	'electronicfront-curtainshutter' => { 311 => '5.2', 312 => '5.2', 321 => '5.3', 322 => '5.2' },
	'electronicfrontcurtainshutter' => { 455 => 0x201a },
	'elevation' => { 171 => 'Elevation' },
	'email' => { 163 => 'EMail' },
	'embargodate' => { 540 => 'embargoDate' },
	'embdencrightsexpr' => { 532 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 532 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 532 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 532 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 535 => 'EmbeddedXMPDigest' },
	'emissivity' => { 126 => 0x3 },
	'emptyslotrelease' => { 246 => 0x98c, 248 => 0x723, 249 => 0x733, 250 => 0x625, 251 => 0x655, 252 => 0x6bd },
	'enablechromanoisereduction' => { 144 => 0xe6e },
	'enablesharpening' => { 144 => 0x92e },
	'encodedby' => { 185 => 'WM/EncodedBy', 406 => "\xa9enc" },
	'encodedwith' => { 408 => 'Encoded_With' },
	'encoder' => { 406 => "\xa9too", 408 => 'encoder', 414 => "\xa9too" },
	'encoderid' => { 414 => "\xa9enc" },
	'encodingtime' => { 185 => 'WM/EncodingTime' },
	'encryptionkey' => { 428 => 0xa020 },
	'endingpage' => { 537 => 'endingPage' },
	'enduser' => { 339 => 'EndUser' },
	'enduserid' => { 339 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 339 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 246 => 0x992, 248 => 0x746, 249 => 0x756, 250 => 0x648, 251 => 0x678, 252 => 0x6e0 },
	'engineer' => { 547 => 'engineer' },
	'enhancedarktones' => { 294 => 0x8 },
	'enhancedenoisealreadyapplied' => { 515 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 515 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 515 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 515 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 515 => 'EnhanceDetailsVersion' },
	'enhancement' => { 117 => 0x16, 118 => 0x3016 },
	'enhanceparams' => { 124 => 0xc7ee },
	'enhancer' => { 333 => 0x300 },
	'enhancervalues' => { 333 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 515 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 515 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 515 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 138 => 0x28 },
	'envelopepriority' => { 138 => 0x3c },
	'enveloperecordversion' => { 138 => 0x0 },
	'episode' => { 532 => 'Episode' },
	'episodeglobaluniqueid' => { 406 => 'egid' },
	'episodeidentifier' => { 532 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 532 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 532 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 334 => 0x20c },
	'epsonimagewidth' => { 334 => 0x20b },
	'epsonsoftware' => { 334 => 0x20d },
	'equipmentinstitution' => { 495 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 495 => 'EquipmentManufacturer' },
	'equipmentversion' => { 330 => 0x0 },
	'ettlii' => { 89 => 0x304, 90 => 0xd, 91 => 0xe, 92 => 0x7, 93 => 0x7, 94 => 0xe },
	'event' => { 498 => 'Event', 511 => 'Event', 532 => 'Event', 537 => 'event' },
	'eventalias' => { 536 => 'eventAlias' },
	'eventdate' => { 123 => [\'Event','EventEventDate'] },
	'eventday' => { 123 => [\'Event','EventDay'] },
	'eventearliestdate' => { 123 => [\'Event','EventEarliestDate'] },
	'eventend' => { 536 => 'eventEnd' },
	'eventenddayofyear' => { 123 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 123 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 123 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 123 => [\'Event','EventHabitat'] },
	'eventid' => { 123 => [\'Event','EventEventID'], 532 => 'EventId' },
	'eventlatestdate' => { 123 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 123 => [\'Event','EventMonth'] },
	'eventnumber' => { 415 => 0x9, 416 => 0x37, 417 => 0x3a },
	'eventparenteventid' => { 123 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 123 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 123 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 123 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 123 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 123 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 536 => 'eventStart' },
	'eventstartdayofyear' => { 123 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 536 => 'eventSubtype' },
	'eventtime' => { 123 => [\'Event','EventEventTime'] },
	'eventtype' => { 536 => 'eventType' },
	'eventverbatimeventdate' => { 123 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 123 => [\'Event','EventYear'] },
	'evfgrid' => { 324 => 0x15f, 325 => 0x165, 326 => 0x165, 327 => 0x17d },
	'evfimageframe' => { 324 => 0x15e, 325 => 0x164, 326 => 0x164, 327 => 0x17c },
	'evfreleaseindicator' => { 325 => 0x24f, 326 => 0x24f, 327 => 0x267 },
	'evfwarmdisplaybrightness' => { 325 => 0x24d, 326 => 0x24d, 327 => 0x265 },
	'evfwarmdisplaymode' => { 325 => 0x24b, 326 => 0x24b, 327 => 0x263 },
	'evsteps' => { 369 => '1.2', 371 => 0x0 },
	'evstepsize' => { 313 => '5.1', 314 => '6.1', 315 => '6.1', 319 => '0.7' },
	'exclusivecoverage' => { 508 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 540 => 'exclusivityEndDate' },
	'excursiontolerance' => { 139 => 0x82 },
	'executiveproducer' => { 406 => "\xa9xpd" },
	'exif' => { 125 => 'EXIF' },
	'exifbyteorder' => { 125 => 'ExifByteOrder' },
	'exifcamerainfo' => { 137 => 0xe8 },
	'exifimageheight' => { 124 => 0xa003, 524 => 'PixelYDimension' },
	'exifimagewidth' => { 124 => 0xa002, 524 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 125 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 124 => 0x9000, 524 => 'ExifVersion' },
	'exitpupilposition' => { 235 => 0x4, 236 => 0x4, 240 => 0x4 },
	'expirationdate' => { 137 => 0x25, 540 => 'expirationDate' },
	'expirationtime' => { 137 => 0x26 },
	'exposure' => { 124 => 0xfe51, 518 => 'Exposure', 520 => 'Exposure' },
	'exposure2012' => { 518 => 'Exposure2012', 520 => 'Exposure2012' },
	'exposureadj' => { 299 => 0x0 },
	'exposureadj2' => { 299 => 0x12 },
	'exposureadjust' => { 431 => 0xc },
	'exposurebracketingindicatorlast' => { 190 => 0x52 },
	'exposurebracketshotnumber' => { 193 => 0x2d, 452 => 0x2f },
	'exposurebracketstepsize' => { 369 => 0x8 },
	'exposurebracketvalue' => { 242 => 0x19 },
	'exposurecompautocancel' => { 89 => 0x113 },
	'exposurecompensation' => { 81 => 0x6, 98 => 0x0, 124 => 0x9204, 146 => 0x24, 162 => 'ExposureComp', 182 => 'ExposureCompensation', 187 => 0xd, 188 => 0x53, 189 => 0x1e, 193 => 0x49c0, 334 => 0x1006, 389 => 0x16, 398 => 0x402, 428 => 0xa013, 431 => [0xc,0x35,0x4d], 464 => 0x114c, 465 => 0x114c, 466 => 0x1128, 468 => 0x1180, 469 => 0x1038, 470 => 0x230, 471 => 0x230, 472 => 0x223, 524 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 460 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 252 => 0x794 },
	'exposurecompensationmode' => { 190 => 0x47, 193 => 0x2a },
	'exposurecompensationset' => { 441 => 0x3, 442 => 0x3, 443 => 0x3, 460 => 0x1e },
	'exposurecompensationsetting' => { 190 => 0x1 },
	'exposurecompstepsize' => { 308 => '6.3', 309 => '7.3', 311 => '7.3', 312 => '7.3', 317 => '4.3', 321 => '7.3', 322 => '7.3' },
	'exposurecontrolstep' => { 316 => '6.1', 318 => '6.1' },
	'exposurecontrolstepsize' => { 308 => '6.2', 309 => '7.1', 311 => '7.1', 312 => '7.1', 317 => '4.2', 321 => '7.1', 322 => '7.1', 323 => '7.1', 324 => 0x1d, 325 => 0x1b, 326 => 0x1b, 327 => 0x1b },
	'exposurecount' => { 132 => 0x1032 },
	'exposuredelay' => { 252 => 0x800, 325 => 0x2f1 },
	'exposuredelaymode' => { 308 => '10.1', 309 => '11.1', 311 => '11.1', 312 => '11.1', 313 => '9.1', 314 => '10.1', 315 => '10.1', 317 => '10.4', 318 => '10.1', 319 => '6.4', 321 => '11.1', 322 => '11.1', 323 => '11.2' },
	'exposuredifference' => { 242 => 0xe },
	'exposuregaincustom' => { 144 => 0x89c },
	'exposuregaindaylight' => { 144 => 0x898 },
	'exposuregainflash' => { 144 => 0x89b },
	'exposuregainfluorescent' => { 144 => 0x89a },
	'exposuregaintungsten' => { 144 => 0x899 },
	'exposureindex' => { 124 => 0xa215, 524 => 'ExposureIndex' },
	'exposureindicator' => { 190 => 0x50 },
	'exposurelevelincrements' => { 87 => 0x6, 88 => 0x6, 89 => 0x101, 90 => 0x5, 91 => 0x6, 92 => 0x5, 93 => 0x5, 94 => 0x6, 95 => 0x4, 441 => 0x58, 442 => 0x58 },
	'exposurelockused' => { 506 => 'ExposureLockUsed' },
	'exposuremode' => { 124 => 0xa402, 162 => 'ExposureMode', 187 => 0x1, 188 => 0xa, 189 => 0x0, 190 => 0x0, 193 => 0x34, 329 => 0x200, 350 => 0x40d, 431 => 0x8, 455 => 0xb041, 524 => 'ExposureMode' },
	'exposuremodeinmanual' => { 89 => 0x10b },
	'exposureprogram' => { 124 => 0x8822, 421 => 0x1001, 434 => [0x17e,0x43], 441 => 0x3c, 442 => 0x3c, 443 => 0x5, 447 => 0x14, 452 => 0x3f, 460 => 0x2, 464 => 0x1175, 465 => 0x1179, 466 => 0x1155, 467 => 0x11d1, 468 => 0x11ad, 469 => 0x1065, 470 => 0x25d, 471 => 0x25d, 472 => 0x24c, 483 => 0xb, 484 => 0xc, 485 => 0xb, 487 => 0x48, 524 => 'ExposureProgram' },
	'exposureshift' => { 329 => 0x203 },
	'exposurestandardadjustment' => { 455 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 31 => 0x6, 32 => 0x7, 81 => 0x16, 124 => 0x829a, 143 => 0xfd05, 146 => 0x20, 148 => 0xfa24, 150 => 0xf104, 153 => 0x12, 155 => 0x38, 157 => 0x14, 158 => 0x10, 160 => 0x10, 162 => 'ExposureTime', 187 => 0x9, 188 => 0x35, 189 => 0x48, 190 => 0x8, 193 => 0x49b8, 389 => 0x12, 428 => 0xa018, 431 => [0x32,0x4a], 441 => 0x0, 442 => 0x0, 460 => [0x21,0x23,0x27], 487 => 0x10, 524 => 'ExposureTime' },
	'exposuretime2' => { 431 => [0x33,0x4b] },
	'exposuretuning' => { 242 => 0x1c },
	'exposurevalue' => { 144 => 0x3 },
	'exposurewarning' => { 132 => 0x1302 },
	'exrauto' => { 132 => 0x1033 },
	'exrmode' => { 132 => 0x1034 },
	'extdescraccessibility' => { 531 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 248 => 0x120, 249 => 0x120, 250 => 0x114, 251 => 0x124, 252 => 0x124 },
	'extendedshutterspeeds' => { 324 => 0xf2, 325 => 0x102, 326 => 0x102, 327 => 0x118 },
	'extendedwbdetect' => { 329 => 0x902 },
	'extender' => { 330 => 0x301 },
	'extenderfirmwareversion' => { 330 => 0x304 },
	'extendermagnification' => { 164 => 'Magnification' },
	'extendermake' => { 164 => 'Make' },
	'extendermodel' => { 164 => 'Model', 330 => 0x303 },
	'extenderserialnumber' => { 164 => 'SerialNumber', 330 => 0x302 },
	'extenderstatus' => { 386 => 0x3 },
	'externalflash' => { 332 => 0x1201 },
	'externalflashae1' => { 334 => 0x101f },
	'externalflashae1_0' => { 334 => 0x101b },
	'externalflashae2' => { 334 => 0x1020 },
	'externalflashae2_0' => { 334 => 0x101c },
	'externalflashbounce' => { 332 => 0x1204, 334 => 0x1026, 376 => 0x1a },
	'externalflashcompensation' => { 222 => 0x1b },
	'externalflashexposurecomp' => { 242 => 0x17, 376 => 0x19 },
	'externalflashfirmware' => { 220 => 0x6, 221 => 0x6, 222 => 0x6, 223 => 0x6, 224 => 0x6, 225 => 0x6 },
	'externalflashflags' => { 220 => 0x8, 221 => 0x8, 222 => 0x8, 223 => 0x8, 225 => 0x8 },
	'externalflashguidenumber' => { 332 => 0x1203, 376 => '24.1' },
	'externalflashgvalue' => { 334 => 0x1025 },
	'externalflashmode' => { 334 => 0x1028, 376 => 0x2 },
	'externalflashreadystate' => { 224 => '9.1' },
	'externalflashstatus' => { 224 => '8.2' },
	'externalflashzoom' => { 332 => 0x1205, 334 => 0x1027 },
	'externalflashzoomoverride' => { 224 => '8.1' },
	'externalmetadatalink' => { 532 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 348 => 0x311, 351 => 0x311, 352 => 0x311, 355 => 0x3408 },
	'extrainfoversion' => { 445 => 0x1a },
	'eyedetection' => { 2 => 0x18 },
	'eyestartaf' => { 190 => 0x40 },
	'fac100per' => { 144 => 0xe94 },
	'fac170per' => { 144 => 0xe93 },
	'fac18per' => { 144 => 0xe92 },
	'face10position' => { 115 => 0x3f4, 116 => 0x1ec, 218 => 0x28, 373 => 0x12 },
	'face10size' => { 374 => 0x12 },
	'face11position' => { 218 => 0x2c, 373 => 0x14 },
	'face11size' => { 374 => 0x14 },
	'face12position' => { 218 => 0x30, 373 => 0x16 },
	'face12size' => { 374 => 0x16 },
	'face13position' => { 373 => 0x18 },
	'face13size' => { 374 => 0x18 },
	'face14position' => { 373 => 0x1a },
	'face14size' => { 374 => 0x1a },
	'face15position' => { 373 => 0x1c },
	'face15size' => { 374 => 0x1c },
	'face16position' => { 373 => 0x1e },
	'face16size' => { 374 => 0x1e },
	'face17position' => { 373 => 0x20 },
	'face17size' => { 374 => 0x20 },
	'face18position' => { 373 => 0x22 },
	'face18size' => { 374 => 0x22 },
	'face19position' => { 373 => 0x24 },
	'face19size' => { 374 => 0x24 },
	'face1position' => { 57 => 0x8, 115 => 0xd, 116 => 0x18, 218 => 0x4, 345 => 0x1, 373 => 0x0, 418 => 0xbc, 448 => 0x1, 449 => 0x0, 450 => 0x0, 451 => 0x5b },
	'face1size' => { 374 => 0x0 },
	'face20position' => { 373 => 0x26 },
	'face20size' => { 374 => 0x26 },
	'face21position' => { 373 => 0x28 },
	'face21size' => { 374 => 0x28 },
	'face22position' => { 373 => 0x2a },
	'face22size' => { 374 => 0x2a },
	'face23position' => { 373 => 0x2c },
	'face23size' => { 374 => 0x2c },
	'face24position' => { 373 => 0x2e },
	'face24size' => { 374 => 0x2e },
	'face25position' => { 373 => 0x30 },
	'face25size' => { 374 => 0x30 },
	'face26position' => { 373 => 0x32 },
	'face26size' => { 374 => 0x32 },
	'face27position' => { 373 => 0x34 },
	'face27size' => { 374 => 0x34 },
	'face28position' => { 373 => 0x36 },
	'face28size' => { 374 => 0x36 },
	'face29position' => { 373 => 0x38 },
	'face29size' => { 374 => 0x38 },
	'face2position' => { 57 => 0xa, 115 => 0x7c, 116 => 0x4c, 218 => 0x8, 345 => 0x5, 373 => 0x2, 418 => 0xc8, 448 => 0x6, 449 => 0x20, 450 => 0x25, 451 => 0x65 },
	'face2size' => { 374 => 0x2 },
	'face30position' => { 373 => 0x3a },
	'face30size' => { 374 => 0x3a },
	'face31position' => { 373 => 0x3c },
	'face31size' => { 374 => 0x3c },
	'face32position' => { 373 => 0x3e },
	'face32size' => { 374 => 0x3e },
	'face3position' => { 57 => 0xc, 115 => 0xeb, 116 => 0x80, 218 => 0xc, 345 => 0x9, 373 => 0x4, 418 => 0xd4, 448 => 0xb, 449 => 0x40, 450 => 0x4a, 451 => 0x6f },
	'face3size' => { 374 => 0x4 },
	'face4position' => { 57 => 0xe, 115 => 0x15a, 116 => 0xb4, 218 => 0x10, 345 => 0xd, 373 => 0x6, 418 => 0xe0, 448 => 0x10, 449 => 0x60, 450 => 0x6f, 451 => 0x79 },
	'face4size' => { 374 => 0x6 },
	'face5position' => { 57 => 0x10, 115 => 0x1c9, 116 => 0xe8, 218 => 0x14, 345 => 0x11, 373 => 0x8, 418 => 0xec, 448 => 0x15, 449 => 0x80, 450 => 0x94 },
	'face5size' => { 374 => 0x8 },
	'face6position' => { 57 => 0x12, 115 => 0x238, 116 => 0x11c, 218 => 0x18, 373 => 0xa, 418 => 0xf8, 448 => 0x1a, 449 => 0xa0, 450 => 0xb9 },
	'face6size' => { 374 => 0xa },
	'face7position' => { 57 => 0x14, 115 => 0x2a7, 116 => 0x150, 218 => 0x1c, 373 => 0xc, 418 => 0x104, 448 => 0x1f, 449 => 0xc0, 450 => 0xde },
	'face7size' => { 374 => 0xc },
	'face8position' => { 57 => 0x16, 115 => 0x316, 116 => 0x184, 218 => 0x20, 373 => 0xe, 418 => 0x110, 448 => 0x24, 449 => 0xe0, 450 => 0x103 },
	'face8size' => { 374 => 0xe },
	'face9position' => { 57 => 0x18, 115 => 0x385, 116 => 0x1b8, 218 => 0x24, 373 => 0x10 },
	'face9size' => { 374 => 0x10 },
	'facebalanceorigi' => { 512 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 512 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 512 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 512 => 'FaceBalanceWarmth' },
	'facedetect' => { 389 => 0x76, 428 => 0x100 },
	'facedetectarea' => { 333 => 0x1201 },
	'facedetectframecrop' => { 333 => 0x1207 },
	'facedetectframesize' => { 57 => 0x3, 115 => 0x1, 116 => 0x4, 218 => 0x1, 333 => 0x1203, 389 => 0x77, 418 => 0xb6 },
	'facedetection' => { 443 => 0x30, 460 => 0x19 },
	'faceelementpositions' => { 132 => 0x4203 },
	'faceelementselected' => { 132 => 0x4005 },
	'faceelementtypes' => { 132 => 0x4201 },
	'faceid' => { 514 => 'FaceID' },
	'faceinfounknown' => { 118 => 0x2089 },
	'facename' => { 428 => 0x123 },
	'faceorientation' => { 116 => 0x8 },
	'faceposition' => { 372 => 0x2, 429 => 0x4 },
	'facepositions' => { 132 => 0x4103 },
	'facerecognition' => { 428 => 0x120 },
	'facesdetected' => { 57 => 0x2, 58 => 0x2, 59 => 0x3, 115 => 0x0, 116 => 0x2, 118 => 0x211c, 132 => 0x4100, 218 => 0x3, 333 => 0x1200, 353 => 0x3f, 372 => 0x0, 418 => 0xb5, 429 => 0x0, 448 => 0x0, 451 => 0x3, 463 => 0x30 },
	'facesrecognized' => { 346 => 0x0 },
	'facewidth' => { 58 => 0x1 },
	'fade' => { 455 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 114 => 0x38 },
	'faithfuloutputshadowpoint' => { 114 => 0x39 },
	'faithfulrawcolortone' => { 114 => 0x31 },
	'faithfulrawcontrast' => { 114 => 0x33 },
	'faithfulrawhighlight' => { 114 => 0x79 },
	'faithfulrawhighlightpoint' => { 114 => 0x36 },
	'faithfulrawlinear' => { 114 => 0x34 },
	'faithfulrawsaturation' => { 114 => 0x32 },
	'faithfulrawshadow' => { 114 => 0x82 },
	'faithfulrawshadowpoint' => { 114 => 0x37 },
	'faithfulrawsharpness' => { 114 => 0x35 },
	'faithfulunsharpmaskfineness' => { 114 => 0xac },
	'faithfulunsharpmaskstrength' => { 114 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 114 => 0xae },
	'far' => { 503 => 'Far' },
	'fastresetlinetime' => { 144 => 0x1860 },
	'feedidentifier' => { 532 => 'FeedIdentifier' },
	'femicroadjustment' => { 89 => 0x111 },
	'ffid' => { 522 => 'ffid' },
	'field' => { 536 => 'field' },
	'fieldcount' => { 334 => 0x103f },
	'fieldofview' => { 414 => "FOV\x00" },
	'fifoenonepixeldelay' => { 144 => 0x1901 },
	'filecreatedate' => { 125 => 'FileCreateDate' },
	'filedatarate' => { 547 => 'fileDataRate' },
	'fileformat' => { 100 => 0x0, 138 => 0x14, 431 => [0x22,0x26], 455 => 0xb000 },
	'filegroupid' => { 125 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 30 => 0xb2d, 354 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 125 => 'FileModifyDate' },
	'filename' => { 125 => 'FileName' },
	'filenameasdelivered' => { 339 => 'FileNameAsDelivered' },
	'filenumber' => { 60 => 0x1, 68 => 0x8, 102 => 0x1817, 119 => 'Canon-FileNumber', 219 => 0x4, 417 => 0x10 },
	'filenumbermemory' => { 187 => 0x1a },
	'filenumbersequence' => { 308 => '12.2', 313 => '3.1', 314 => '4.1', 315 => '4.1', 317 => '11.1', 318 => '4.3', 323 => '5.2', 324 => 0x4e, 325 => 0x48, 326 => 0x48, 327 => 0x48 },
	'filepermissions' => { 125 => 'FilePermissions' },
	'filesource' => { 124 => 0xa300, 132 => 0x8000, 524 => 'FileSource' },
	'fileuserid' => { 125 => 'FileUserID' },
	'fileversion' => { 138 => 0x16 },
	'fillflashautoreduction' => { 87 => 0xe, 88 => 0xe, 95 => 0xa },
	'filllight' => { 518 => 'FillLight', 520 => 'FillLight' },
	'fillorder' => { 124 => 0x10a },
	'filmgraineffect' => { 329 => 0x538 },
	'filmmode' => { 132 => 0x1401, 350 => 0x412, 353 => 0x42 },
	'filmtype' => { 267 => 0x2 },
	'filtereffect' => { 60 => 0xe, 259 => 0x37, 260 => 0x3f, 261 => 0x47, 353 => 0xa1 },
	'filtereffectauto' => { 75 => 0xa0 },
	'filtereffectfaithful' => { 74 => 0x70, 75 => 0x70 },
	'filtereffectlandscape' => { 74 => 0x40, 75 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 74 => 0x88, 75 => 0x88 },
	'filtereffectneutral' => { 74 => 0x58, 75 => 0x58 },
	'filtereffectportrait' => { 74 => 0x28, 75 => 0x28 },
	'filtereffectstandard' => { 74 => 0x10, 75 => 0x10 },
	'filtereffectuserdef1' => { 74 => 0xa0, 75 => 0xb8 },
	'filtereffectuserdef2' => { 74 => 0xb8, 75 => 0xd0 },
	'filtereffectuserdef3' => { 74 => 0xd0, 75 => 0xe8 },
	'finderdisplayduringexposure' => { 88 => 0x1 },
	'finesharpness' => { 389 => 0x70 },
	'finetuneoptcenterweighted' => { 308 => '7.2', 309 => '9.1', 311 => '9.1', 312 => '9.1', 316 => '8.1', 321 => '9.1', 322 => '9.1', 323 => '9.1', 324 => 0x25, 325 => 0x23, 326 => 0x23, 327 => 0x23 },
	'finetuneopthighlightweighted' => { 311 => '46.1', 312 => '46.1', 321 => '46.1', 322 => '46.1', 324 => 0x29, 325 => 0x27, 326 => 0x27, 327 => 0x27 },
	'finetuneoptmatrixmetering' => { 308 => '8.1', 309 => '8.2', 311 => '8.2', 312 => '8.2', 316 => '7.2', 317 => '6.1', 321 => '8.2', 322 => '8.2', 323 => '8.2', 324 => 0x23, 325 => 0x21, 326 => 0x21, 327 => 0x21 },
	'finetuneoptspotmetering' => { 308 => '8.2', 309 => '9.2', 311 => '9.2', 312 => '9.2', 316 => '8.2', 317 => '6.2', 321 => '9.2', 322 => '9.2', 323 => '9.2', 324 => 0x27, 325 => 0x25, 326 => 0x25, 327 => 0x25 },
	'finishexposure' => { 144 => 0xdbd },
	'finishfiletype' => { 144 => 0xdb8 },
	'finishlook' => { 144 => 0xdbc },
	'finishnoise' => { 144 => 0xdba },
	'finishresolution' => { 144 => 0xdb9 },
	'finishsharpening' => { 144 => 0xdbb },
	'firmware' => { 334 => 0x405, 431 => [0x8c,0x17,0x3b], 515 => 'Firmware' },
	'firmware2' => { 431 => 0x57 },
	'firmwaredate' => { 117 => 0x15, 118 => 0x2001, 415 => 0x4, 417 => 0x30 },
	'firmwareid' => { 194 => 0x0 },
	'firmwarename' => { 428 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 68 => 0x1e, 419 => 0x0 },
	'firmwarerevision2' => { 419 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 144 => [0x415,0xce5], 160 => 0x57, 162 => 'FirmwareVersion', 351 => 0x320, 353 => 0x2, 355 => 0x3109, 389 => 0x230, 414 => ['CNFV','FIRM','info'], 416 => 0x18, 417 => 0x2a, 421 => 0x2 },
	'firmwareversions' => { 398 => 0x301 },
	'firstphotodate' => { 506 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 339 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 137 => 0x16, 513 => 'FixtureIdentifier' },
	'flash' => { 119 => 'XMP-Flash', 124 => 0x9209, 158 => 0x22, 188 => 0x1f, 189 => 0x15, 417 => 0x5a, 524 => 'Flash' },
	'flashaction' => { 441 => 0x3e, 442 => 0x3e, 455 => 0x2017, 460 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 441 => 0x4c, 442 => 0x4c, 460 => 0x77 },
	'flashactionexternal' => { 460 => [0x78,0x7c] },
	'flashactivity' => { 36 => 0x1c },
	'flashbatterylevel' => { 47 => 0x249 },
	'flashbias' => { 353 => 0x24 },
	'flashbits' => { 36 => 0x1d },
	'flashburstpriority' => { 324 => 0x101, 325 => 0x111, 326 => 0x111, 327 => 0x129 },
	'flashbuttonfunction' => { 89 => 0x70e },
	'flashchargelevel' => { 334 => 0x1010 },
	'flashcolorfilter' => { 222 => 0x10, 223 => 0x10, 225 => 0x10 },
	'flashcommandermode' => { 220 => '9.1', 221 => '9.1', 222 => '9.1', 223 => '9.1', 225 => '9.1' },
	'flashcompensation' => { 144 => 0x3f3, 220 => 0xa, 221 => 0xa, 222 => 0xa, 223 => 0x27, 224 => 0xa, 225 => 0xa, 515 => 'FlashCompensation' },
	'flashcontrol' => { 441 => 0x23, 442 => 0x1f, 443 => 0x21 },
	'flashcontrolbuilt-in' => { 317 => '16.1', 318 => '23.1', 320 => '23.1', 321 => '24.1' },
	'flashcontrolmode' => { 220 => '9.2', 221 => '9.2', 222 => '9.2', 223 => '9.2', 225 => '9.2', 231 => 0x214, 246 => 0x2d4, 247 => 0x148, 248 => 0x1b8, 249 => 0x1b8, 250 => 0x1a8, 251 => 0x1bc, 252 => 0x1bc, 329 => 0x404 },
	'flashcurtain' => { 353 => 0x48 },
	'flashdefault' => { 190 => 0x42 },
	'flashdevice' => { 334 => 0x1005 },
	'flashdistance' => { 118 => 0x2034 },
	'flashenergy' => { 124 => 0xa20b, 524 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 242 => 0x18 },
	'flashexposurecomp' => { 81 => 0xf, 132 => 0x1011, 165 => 'ExposureComp', 187 => 0x23, 192 => 0x104, 193 => 0x49c1, 242 => 0x12, 329 => 0x401, 334 => 0x1023, 389 => 0x4d, 421 => 0x100b, 431 => [0x3a,0x56], 455 => 0x104 },
	'flashexposurecomp2' => { 288 => 0x4d2 },
	'flashexposurecomp3' => { 222 => 0x1d },
	'flashexposurecomp4' => { 222 => 0x27 },
	'flashexposurecomparea' => { 309 => '38.4', 311 => '38.4', 312 => '38.4', 321 => '38.4', 322 => '38.4', 324 => 0x5d, 325 => 0x59, 326 => 0x59, 327 => 0x59 },
	'flashexposurecompset' => { 190 => 0x10, 361 => 0xe, 441 => 0x14, 442 => 0x12, 443 => 0x23, 460 => 0x1f },
	'flashexposurecompset2' => { 460 => [0x26,0x2c] },
	'flashexposureindicator' => { 190 => 0x54 },
	'flashexposureindicatorlast' => { 190 => 0x56 },
	'flashexposureindicatornext' => { 190 => 0x55 },
	'flashexposurelock' => { 60 => 0x19 },
	'flashfired' => { 146 => 0x5d, 165 => 'Fired', 187 => 0x14, 287 => '590.3', 524 => [\'Flash','FlashFired'] },
	'flashfiring' => { 89 => 0x306, 90 => 0x6, 91 => 0x7, 94 => 0x7 },
	'flashfirmwareversion' => { 330 => 0x1002 },
	'flashfocallength' => { 220 => 0xb, 221 => 0xc, 222 => 0xc, 223 => 0xc, 224 => 0xc, 225 => 0x26 },
	'flashfunction' => { 193 => 0x31, 524 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 220 => 0xe, 221 => 0xf, 222 => 0xf, 223 => 0xf, 224 => 0xf, 225 => 0xf, 231 => 0x21a, 246 => 0x2da, 247 => 0x14e, 250 => 0x1ae, 251 => 0x1c2, 252 => 0x1c2 },
	'flashgroupacompensation' => { 220 => 0x11, 221 => 0x12, 222 => 0x13, 223 => 0x28, 224 => 0x28, 225 => 0x28 },
	'flashgroupacontrolmode' => { 220 => 0xf, 221 => '16.1', 222 => '17.1', 223 => '17.1', 224 => '17.1', 225 => '17.1' },
	'flashgroupaoutput' => { 220 => 0x11, 221 => 0x12, 222 => 0x13, 223 => 0x28, 224 => 0x28, 225 => 0x28 },
	'flashgroupbcompensation' => { 220 => 0x12, 221 => 0x13, 222 => 0x14, 223 => 0x29, 224 => 0x29, 225 => 0x29 },
	'flashgroupbcontrolmode' => { 220 => 0x10, 221 => '17.1', 222 => '18.1', 223 => '18.1', 224 => '18.1', 225 => '18.1' },
	'flashgroupboutput' => { 220 => 0x12, 221 => 0x13, 222 => 0x14, 223 => 0x29, 224 => 0x29, 225 => 0x29 },
	'flashgroupccompensation' => { 221 => 0x14, 222 => 0x15, 223 => 0x2a, 224 => 0x2a, 225 => 0x2a },
	'flashgroupccontrolmode' => { 221 => '17.2', 222 => '18.2', 223 => '18.2', 224 => '18.2', 225 => '18.2' },
	'flashgroupcoutput' => { 221 => 0x14, 222 => 0x15, 223 => 0x2a, 224 => 0x2a, 225 => 0x2a },
	'flashguidenumber' => { 81 => 0xd, 99 => 0x0, 165 => 'GuideNumber' },
	'flashilluminationpattern' => { 225 => 0x25 },
	'flashintensity' => { 117 => [0x19,0x5], 329 => 0x405 },
	'flashlevel' => { 310 => 0x9, 455 => 0xb048 },
	'flashmake' => { 165 => 'Make' },
	'flashmanufacturer' => { 184 => 'FlashManufacturer' },
	'flashmastercompensation' => { 231 => 0x22e, 246 => 0x2ee, 247 => 0x162, 250 => 0x1aa, 251 => 0x1be, 252 => 0x1be },
	'flashmastercontrolmode' => { 231 => 0x22c, 246 => 0x2ec, 247 => 0x160 },
	'flashmasteroutput' => { 231 => 0x232, 246 => 0x2f2, 247 => 0x166 },
	'flashmetering' => { 187 => 0x3f, 190 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 389 => 0x20a },
	'flashmode' => { 117 => 0x4, 144 => 0x3f2, 146 => 0x5c, 157 => 0x27, 165 => 'Mode', 187 => 0x2, 188 => 0x20, 189 => 0x16, 190 => 0xf, 242 => 0x87, 329 => 0x400, 334 => 0x1004, 389 => 0xc, 396 => 0x4, 420 => 0x20, 421 => 0x100a, 430 => 0x225, 441 => 0x13, 442 => 0x7f, 443 => 0x20, 460 => 0x10, 464 => 0x1138, 465 => 0x1138, 466 => 0x1114, 467 => 0x1190, 468 => 0x116c, 469 => 0x1024, 470 => 0x21c, 471 => 0x21c, 472 => 0x211, 524 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 252 => 0x80e },
	'flashmodebuttonplaybackmode' => { 252 => 0x818 },
	'flashmodel' => { 165 => 'Model', 184 => 'FlashModel', 330 => 0x1001 },
	'flashoptions' => { 369 => 0x2 },
	'flashoptions2' => { 369 => 0x10 },
	'flashoutput' => { 47 => 0x248, 81 => 0x21, 220 => 0xa, 221 => 0xa, 222 => 0xa, 223 => 0x27, 225 => 0x21, 231 => 0x21e, 246 => 0x2de, 247 => 0x152, 250 => 0x1b2, 251 => 0x1c6, 252 => 0x1c6 },
	'flashpixversion' => { 124 => 0xa000, 524 => 'FlashpixVersion' },
	'flashredeyemode' => { 524 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 231 => 0x228, 246 => 0x2e8, 247 => 0x15c, 250 => 0x1bc, 329 => 0x403 },
	'flashreturn' => { 524 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 165 => 'SerialNumber', 330 => 0x1003 },
	'flashsetting' => { 242 => 0x8 },
	'flashshutterspeed' => { 308 => '20.2', 309 => '23.2', 311 => '23.2', 312 => '23.2', 317 => '15.2', 318 => '22.2', 319 => '7.2', 320 => '22.2', 321 => '23.2', 322 => '23.2', 323 => '23.1', 324 => 0x5b, 325 => 0x57, 326 => 0x57, 327 => 0x57 },
	'flashsource' => { 220 => 0x4, 221 => 0x4, 222 => 0x4, 223 => 0x4, 224 => 0x4, 225 => 0x4 },
	'flashstatus' => { 376 => 0x0, 460 => [0x82,0x86], 474 => 0x31, 475 => 0x39, 476 => 0x39 },
	'flashstatusbuilt-in' => { 443 => [0x87,0x287] },
	'flashstatusexternal' => { 443 => [0x88,0x288] },
	'flashsyncspeed' => { 308 => '20.1', 309 => '23.1', 311 => '23.1', 312 => '23.1', 317 => '15.1', 318 => '22.1', 320 => '22.1', 321 => '23.1', 322 => '23.1', 324 => 0x57, 325 => 0x53, 326 => 0x53, 327 => 0x53 },
	'flashsyncspeedav' => { 87 => 0x3, 89 => 0x10f, 90 => 0x2, 91 => 0x3, 92 => 0x2, 93 => 0x2, 94 => 0x3, 95 => 0x6 },
	'flashthreshold' => { 99 => 0x1 },
	'flashtype' => { 165 => 'Type', 190 => 0x59, 242 => 0x9, 330 => 0x1000 },
	'flashwarning' => { 318 => '30.1', 319 => '7.1', 323 => '31.1', 353 => 0x62 },
	'flashwirelessoption' => { 231 => 0x234, 246 => 0x2e6, 247 => 0x15a, 250 => 0x1c8 },
	'flexiblespotposition' => { 455 => 0x201d },
	'flickadvancedirection' => { 325 => 0x25f, 326 => 0x25f, 327 => 0x277 },
	'flickerreduce' => { 430 => 0x218 },
	'flickerreduction' => { 132 => 0x1446, 271 => 0x7 },
	'flickerreductionindicator' => { 266 => 0x532 },
	'flickerreductionshooting' => { 246 => 0x2d0, 248 => 0x1b4, 249 => 0x1b4, 250 => 0x1a4, 251 => 0x1b8, 252 => 0x1b8 },
	'flightpitchdegree' => { 121 => 'FlightPitchDegree' },
	'flightrolldegree' => { 121 => 'FlightRollDegree' },
	'flightxspeed' => { 121 => 'FlightXSpeed' },
	'flightyawdegree' => { 121 => 'FlightYawDegree' },
	'flightyspeed' => { 121 => 'FlightYSpeed' },
	'flightzspeed' => { 121 => 'FlightZSpeed' },
	'fliphorizontal' => { 301 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 31 => 0x5, 32 => 0x6, 81 => 0x15, 124 => 0x829d, 143 => 0xfd04, 146 => 0x1e, 148 => 0xfa23, 150 => 0xf103, 153 => 0x13, 155 => 0x3c, 157 => 0x1c, 158 => 0x18, 160 => 0xc, 169 => 'FNumber', 187 => 0xa, 188 => 0x36, 189 => 0x47, 190 => 0x9, 193 => 0x49c7, 240 => 0x38, 352 => 0x35a, 389 => 0x13, 428 => 0xa019, 431 => [0x31,0x49], 441 => 0x1, 442 => 0x1, 460 => [0x20,0x22,0x26], 524 => 'FNumber' },
	'focaldistance' => { 504 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 62 => 0x1, 65 => 0x7, 118 => 0x1d, 124 => 0x920a, 153 => 0x1d, 169 => 'FocalLength', 187 => 0x12, 235 => 0xa, 236 => 0xb, 240 => [0xc,0x3c], 347 => 0x1, 389 => 0x1d, 398 => 0x403, 421 => 0x1500, 440 => 0xe, 468 => 0x1278, 469 => 0x1134, 470 => 0x32c, 471 => 0x32c, 472 => 0x30a, 524 => 'FocalLength' },
	'focallength2' => { 460 => [0x23,0x25,0x29] },
	'focallength35mm' => { 343 => 'FocalLength35mm' },
	'focallengthin35mmformat' => { 124 => 0xa405, 428 => 0xa01a, 524 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 440 => 0x10 },
	'focalplaneafpointarea' => { 473 => 0x2 },
	'focalplaneafpointlocation1' => { 473 => 0x6 },
	'focalplaneafpointlocation10' => { 473 => 0x2a },
	'focalplaneafpointlocation11' => { 473 => 0x2e },
	'focalplaneafpointlocation12' => { 473 => 0x32 },
	'focalplaneafpointlocation13' => { 473 => 0x36 },
	'focalplaneafpointlocation14' => { 473 => 0x3a },
	'focalplaneafpointlocation15' => { 473 => 0x3e },
	'focalplaneafpointlocation2' => { 473 => 0xa },
	'focalplaneafpointlocation3' => { 473 => 0xe },
	'focalplaneafpointlocation4' => { 473 => 0x12 },
	'focalplaneafpointlocation5' => { 473 => 0x16 },
	'focalplaneafpointlocation6' => { 473 => 0x1a },
	'focalplaneafpointlocation7' => { 473 => 0x1e },
	'focalplaneafpointlocation8' => { 473 => 0x22 },
	'focalplaneafpointlocation9' => { 473 => 0x26 },
	'focalplaneafpointsused' => { 473 => 0x1 },
	'focalplanediagonal' => { 330 => 0x103, 334 => 0x205 },
	'focalplaneresolutionunit' => { 124 => 0xa210, 524 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 124 => 0xa20e, 524 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 62 => 0x2 },
	'focalplanexunknown' => { 62 => 0x2 },
	'focalplaneyresolution' => { 124 => 0xa20f, 524 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 62 => 0x3 },
	'focalplaneyunknown' => { 62 => 0x3 },
	'focalpointx' => { 504 => 'FocalPointX' },
	'focalpointy' => { 504 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 62 => 0x0 },
	'focalunits' => { 36 => 0x19 },
	'focus' => { 290 => 0x8 },
	'focusarea' => { 187 => 0x31 },
	'focusareaselection' => { 319 => '15.2' },
	'focusbracket' => { 353 => 0xbd },
	'focusbracketstepsize' => { 329 => 0x308 },
	'focuscontinuous' => { 36 => 0x20 },
	'focusdisplayaiservoandmf' => { 89 => 0x515 },
	'focusdistance' => { 169 => 'FocusDistance', 187 => 0x13, 193 => 0x49bb, 235 => 0x9, 236 => 0xa, 240 => [0xb,0x4e], 332 => 0x305, 347 => 0x0, 351 => 0x304, 352 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 60 => 0x15, 81 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 240 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 60 => 0x14, 81 => 0x13 },
	'focusholdbutton' => { 190 => 0x44 },
	'focusinfoversion' => { 332 => 0x0 },
	'focusingscreen' => { 88 => 0x0, 89 => 0x80b, 94 => 0x0 },
	'focuslocation' => { 455 => 0x2027 },
	'focuslocation2' => { 455 => 0x204a },
	'focuslocked' => { 186 => 0x14 },
	'focusmode' => { 36 => 0x7, 117 => 0x3, 118 => [0x3003,0xd], 132 => 0x1021, 144 => 0x3f5, 146 => 0x38, 162 => 'FocusMode', 187 => 0x30, 189 => 0xe, 190 => 0xc, 242 => 0x7, 329 => 0x301, 334 => 0x100b, 353 => 0x7, 389 => 0xd, 396 => 0x3, 421 => 0x1006, 434 => [0xb,0x5], 440 => [0x15,0x1d], 441 => 0x4d, 442 => 0x4d, 455 => [0xb042,0xb04e,0x201b], 460 => 0x13, 481 => 0x16 },
	'focusmode2' => { 131 => '0.1', 369 => '3.1', 460 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 310 => '10.1', 438 => 0x14, 439 => 0x15, 441 => 0x10, 442 => 0xf, 443 => 0x6 },
	'focusmodeswitch' => { 190 => 0x58, 441 => 0x2e },
	'focuspeakingdisplay' => { 324 => 0x22f, 325 => 0x235, 326 => 0x235, 327 => 0x24d },
	'focuspeakinghighlightcolor' => { 324 => 0x53, 325 => 0x4b, 326 => 0x4b, 327 => 0x4b },
	'focuspeakinglevel' => { 324 => 0x51, 325 => 0x49, 326 => 0x49, 327 => 0x49 },
	'focuspixel' => { 132 => 0x1023 },
	'focuspointlock' => { 325 => 0x1d3, 326 => 0x1d3, 327 => 0x1eb },
	'focuspointpersistence' => { 324 => 0xf5, 325 => 0x105, 326 => 0x105, 327 => 0x11b },
	'focuspointwrap' => { 308 => '2.2', 309 => '2.2', 311 => '2.1', 312 => '2.1', 316 => '1.1', 317 => '2.2', 318 => '1.1', 321 => '2.2', 322 => '2.1', 323 => '2.5', 324 => 0x16, 325 => 0x16, 326 => 0x16, 327 => 0x16 },
	'focusposition' => { 1 => 0x2f, 235 => 0x8, 236 => 0x8, 389 => 0x10, 452 => 0x9bb },
	'focusposition2' => { 460 => [0x29,0x2b,0x2f], 481 => 0x2d, 484 => 0x20 },
	'focuspositionhorizontal' => { 199 => 0x2f, 200 => 0x43 },
	'focuspositionvertical' => { 199 => 0x31, 200 => 0x45 },
	'focusprocess' => { 329 => 0x302 },
	'focusrange' => { 36 => 0x12, 334 => 0x100a },
	'focusrangeindex' => { 379 => '3.1' },
	'focusresult' => { 200 => 0x4a },
	'focusringrotation' => { 89 => 0x713 },
	'focussetting' => { 431 => 0x6 },
	'focusshiftautoreset' => { 251 => 0x6da, 252 => 0x748 },
	'focusshiftexposurelock' => { 231 => 0x1b4, 246 => 0x224, 247 => 0xe8, 248 => 0x100, 249 => 0x100, 250 => 0xf4, 251 => 0x104, 252 => 0x104 },
	'focusshiftinterval' => { 231 => 0x1b0, 246 => 0x220, 247 => 0xe4, 248 => 0xfc, 249 => 0xfc, 250 => 0xf0, 251 => 0x100, 252 => 0x100 },
	'focusshiftnumbershots' => { 231 => 0x1a8, 246 => 0x218, 247 => 0xdc, 248 => 0xf4, 249 => 0xf4, 250 => 0xe8, 251 => 0xf8, 252 => 0xf8 },
	'focusshiftshooting' => { 269 => 0x20 },
	'focusshiftstepwidth' => { 231 => 0x1ac, 246 => 0x21c, 247 => 0xe0, 248 => 0xf8, 249 => 0xf8, 250 => 0xec, 251 => 0xfc, 252 => 0xfc },
	'focusstatus' => { 440 => 0x19, 441 => 0x53, 442 => 0x53 },
	'focusstepcount' => { 332 => 0x301, 334 => 0x100e },
	'focusstepinfinity' => { 332 => 0x303, 334 => 0x103b },
	'focusstepnear' => { 332 => 0x304, 334 => 0x103c },
	'focusstepsfrominfinity' => { 240 => 0x58 },
	'focustrackinglockon' => { 308 => ['1.5','4.1'], 309 => '1.4', 316 => '0.4', 317 => '3.1', 318 => '0.4', 321 => '1.4' },
	'focuswarning' => { 132 => 0x1301 },
	'foldername' => { 187 => 0x27 },
	'foldernumber' => { 441 => 0x9a, 443 => [0x402,0x114,0x316] },
	'fontcomposite' => { 552 => [\'Fonts','FontsComposite'] },
	'fontface' => { 552 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 552 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 552 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 552 => [\'Fonts','FontsFontName'] },
	'fonts' => { 552 => 'Fonts' },
	'fonttype' => { 552 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 552 => [\'Fonts','FontsVersionString'] },
	'for' => { 405 => 'For' },
	'forcewrite' => { 125 => 'ForceWrite' },
	'format' => { 414 => "\xa9fmt", 503 => 'Format', 521 => 'format', 545 => 'Format' },
	'forwardlock' => { 542 => 'forwardlock' },
	'forwardmatrix1' => { 124 => 0xc714 },
	'forwardmatrix2' => { 124 => 0xc715 },
	'forwardmatrix3' => { 124 => 0xcd34 },
	'fossilspecimen' => { 123 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 123 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 71 => [0x2,0x4] },
	'frameheight' => { 132 => 0x3822 },
	'framenum' => { 400 => 0xd7 },
	'framenumber' => { 132 => 0x8003, 193 => 0x3c, 389 => 0x29 },
	'framerate' => { 71 => [0x1,0x6], 124 => 0xc764, 132 => 0x3820 },
	'framereadouttime' => { 408 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 132 => 0x3821 },
	'framing' => { 536 => 'framing' },
	'freebytes' => { 102 => 0x1 },
	'freememorycardimages' => { 188 => [0x37,0x54], 189 => [0x2d,0x4a], 190 => 0x32 },
	'fujiflashmode' => { 132 => 0x1010 },
	'fujimodel' => { 132 => 0x1447 },
	'fujimodel2' => { 132 => 0x1448 },
	'fullhdhighspeedrec' => { 132 => 0x3824 },
	'fullimagesize' => { 455 => 0xb02b },
	'fullpanoheightpixels' => { 506 => 'FullPanoHeightPixels', 507 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 506 => 'FullPanoWidthPixels', 507 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 421 => 0x100d },
	'fullsizeimage' => { 168 => 'data' },
	'fullsizeimagename' => { 168 => '1Name' },
	'fullsizeimagetype' => { 168 => '0Type' },
	'func1button' => { 311 => '14.1', 312 => '14.1', 322 => '14.1', 324 => 0x67, 325 => 0x63, 326 => 0x63, 327 => 0x63 },
	'func1buttonplaybackmode' => { 324 => 0x19f, 325 => 0x1a5, 326 => 0x1a5, 327 => 0x1bd },
	'func1buttonplusdials' => { 311 => '42.1', 312 => '42.1', 322 => '42.1' },
	'func2button' => { 311 => '80.1', 312 => '80.1', 322 => '80.1', 324 => 0x77, 325 => 0x73, 326 => 0x73, 327 => 0x73 },
	'func2buttonplaybackmode' => { 324 => 0x1a1, 325 => 0x1a7, 326 => 0x1a7, 327 => 0x1bf },
	'func2buttonplusdials' => { 311 => '81.1' },
	'func3button' => { 311 => '83.1', 326 => 0x119, 327 => 0x131 },
	'func3buttonplaybackmode' => { 326 => 0x1a9, 327 => 0x1c1 },
	'func4button' => { 326 => 0x175, 327 => 0x18d },
	'func4buttonplaybackmode' => { 326 => 0x1af, 327 => 0x1c7 },
	'funcbutton' => { 308 => ['14.1','15.1'], 309 => '14.1', 317 => '28.1', 318 => '13.1', 321 => '14.1', 323 => '14.1' },
	'funcbuttonplusdials' => { 308 => ['14.2','15.2'], 309 => '14.2', 317 => '31.1', 321 => '42.1' },
	'functionbutton' => { 315 => '13.1', 319 => '5.2' },
	'gainbase' => { 333 => 0x610 },
	'gaincontrol' => { 124 => 0xa407, 524 => 'GainControl' },
	'gainmapmax' => { 529 => 'GainMapMax' },
	'gainmapmin' => { 529 => 'GainMapMin' },
	'gamma' => { 124 => 0xa500, 144 => 0x8fe, 340 => 'gAMA', 358 => 0x11c, 525 => 'Gamma', 529 => 'Gamma' },
	'gammablackpoint' => { 110 => 0xc },
	'gammacolortone' => { 110 => 0x3 },
	'gammacompensatedvalue' => { 139 => 0x91 },
	'gammacontrast' => { 110 => 0x2 },
	'gammacurveoutputrange' => { 110 => 0xf },
	'gammahighlight' => { 110 => 0xa },
	'gammalinear' => { 108 => 0x20200 },
	'gammamidpoint' => { 110 => 0xe },
	'gammasaturation' => { 110 => 0x4 },
	'gammashadow' => { 110 => 0x9 },
	'gammasharpnessstrength' => { 110 => 0x8 },
	'gammaunsharpmaskfineness' => { 110 => 0x6 },
	'gammaunsharpmaskstrength' => { 110 => 0x5 },
	'gammaunsharpmaskthreshold' => { 110 => 0x7 },
	'gammawhitepoint' => { 110 => 0xd },
	'garminsettings' => { 414 => 'pmcc' },
	'garminsoftware' => { 414 => 'uuid' },
	'gdalmetadata' => { 124 => 0xa480 },
	'gdalnodata' => { 124 => 0xa481 },
	'geimagesize' => { 132 => 0x1304 },
	'gemake' => { 134 => 0x300 },
	'gemodel' => { 134 => 0x207 },
	'genre' => { 406 => ['gnre',"\xa9gen"], 408 => 'genre', 414 => ['gnre',"\xa9gen"], 532 => 'Genre', 537 => 'genre', 547 => 'genre' },
	'genrecvid' => { 532 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 532 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 532 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 532 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 406 => 'geID' },
	'geography' => { 538 => 'geography' },
	'geolocate' => { 125 => 'Geolocate' },
	'geologicalcontext' => { 123 => 'GeologicalContext' },
	'geologicalcontextbed' => { 123 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 123 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 123 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 123 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 123 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 125 => 'Geosync' },
	'geotag' => { 125 => 'Geotag' },
	'geotiffasciiparams' => { 124 => 0x87b1 },
	'geotiffdirectory' => { 124 => 0x87af },
	'geotiffdoubleparams' => { 124 => 0x87b0 },
	'geotime' => { 125 => 'Geotime' },
	'giftftppriority' => { 508 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 121 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 121 => 'GimbalReverse' },
	'gimbalrolldegree' => { 121 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 121 => 'GimbalYawDegree' },
	'globalaltitude' => { 403 => 0x419 },
	'globalangle' => { 403 => 0x40d },
	'good' => { 547 => 'good' },
	'googlehostheader' => { 406 => 'gshh' },
	'googlepingmessage' => { 406 => 'gspm' },
	'googlepingurl' => { 406 => 'gspu' },
	'googleplusuploadcode' => { 124 => 0x9009 },
	'googlesourcedata' => { 406 => 'gssd' },
	'googlestarttime' => { 406 => 'gsst' },
	'googletrackduration' => { 406 => 'gstd' },
	'goprotype' => { 414 => 'GoPr' },
	'gpsaltitude' => { 136 => 0x6, 166 => 'Altitude', 524 => 'GPSAltitude' },
	'gpsaltituderef' => { 136 => 0x5, 524 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 136 => 0x1c, 524 => 'GPSAreaInformation' },
	'gpscoordinates' => { 406 => "\xa9xyz", 408 => 'location.ISO6709', 414 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 136 => 0x1d },
	'gpsdatetime' => { 166 => 'DateTime', 524 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 136 => 0x18, 166 => 'Bearing', 524 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 136 => 0x17, 524 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 136 => 0x1a, 166 => 'Distance', 524 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 136 => 0x19, 524 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 136 => 0x14, 524 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 136 => 0x13 },
	'gpsdestlongitude' => { 136 => 0x16, 524 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 136 => 0x15 },
	'gpsdifferential' => { 136 => 0x1e, 166 => 'Differential', 524 => 'GPSDifferential' },
	'gpsdop' => { 136 => 0xb, 524 => 'GPSDOP' },
	'gpshpositioningerror' => { 136 => 0x1f, 524 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 136 => 0x11, 524 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 136 => 0x10, 524 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 119 => 'GPS-GPSLatitude', 121 => 'GpsLatitude', 136 => 0x2, 166 => 'Latitude', 524 => 'GPSLatitude' },
	'gpslatituderef' => { 136 => 0x1 },
	'gpslongitude' => { 119 => 'GPS-GPSLongitude', 121 => 'GpsLongitude', 136 => 0x4, 166 => 'Longitude', 524 => 'GPSLongitude' },
	'gpslongituderef' => { 136 => 0x3 },
	'gpslongtitude' => { 121 => 'GpsLongtitude' },
	'gpsmapdatum' => { 136 => 0x12, 166 => 'Datum', 524 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 136 => 0xa, 166 => 'MeasureMode', 524 => 'GPSMeasureMode' },
	'gpsposition' => { 119 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 136 => 0x1b, 524 => 'GPSProcessingMethod' },
	'gpssatellites' => { 136 => 0x8, 166 => 'Satellites', 524 => 'GPSSatellites' },
	'gpsspeed' => { 136 => 0xd, 166 => 'Speed', 524 => 'GPSSpeed' },
	'gpsspeedref' => { 136 => 0xc, 524 => 'GPSSpeedRef' },
	'gpsstatus' => { 136 => 0x9, 524 => 'GPSStatus' },
	'gpsstring' => { 144 => 0x402 },
	'gpstimestamp' => { 136 => 0x7 },
	'gpstrack' => { 136 => 0xf, 166 => 'Heading', 524 => 'GPSTrack' },
	'gpstrackref' => { 136 => 0xe, 524 => 'GPSTrackRef' },
	'gpsversionid' => { 136 => 0x0, 524 => 'GPSVersionID' },
	'gradation' => { 329 => 0x50f },
	'gradientbasedcorractive' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 518 => 'GradientBasedCorrections', 520 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 518 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 520 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 518 => 'GrainAmount', 520 => 'GrainAmount' },
	'graineffectroughness' => { 132 => 0x1047 },
	'graineffectsize' => { 132 => 0x104c },
	'grainfrequency' => { 518 => 'GrainFrequency', 520 => 'GrainFrequency' },
	'grainseed' => { 518 => 'GrainSeed', 520 => 'GrainSeed' },
	'grainsize' => { 518 => 'GrainSize', 520 => 'GrainSize' },
	'graymixeraqua' => { 518 => 'GrayMixerAqua', 520 => 'GrayMixerAqua' },
	'graymixerblue' => { 518 => 'GrayMixerBlue', 520 => 'GrayMixerBlue' },
	'graymixergreen' => { 518 => 'GrayMixerGreen', 520 => 'GrayMixerGreen' },
	'graymixermagenta' => { 518 => 'GrayMixerMagenta', 520 => 'GrayMixerMagenta' },
	'graymixerorange' => { 518 => 'GrayMixerOrange', 520 => 'GrayMixerOrange' },
	'graymixerpurple' => { 518 => 'GrayMixerPurple', 520 => 'GrayMixerPurple' },
	'graymixerred' => { 518 => 'GrayMixerRed', 520 => 'GrayMixerRed' },
	'graymixeryellow' => { 518 => 'GrayMixerYellow', 520 => 'GrayMixerYellow' },
	'graypoint' => { 492 => 0x8021 },
	'grayresponseunit' => { 124 => 0x122 },
	'greencurvelimits' => { 113 => 0x1c4 },
	'greencurvepoints' => { 112 => 0x53, 113 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 108 => 0x20913 },
	'greenhue' => { 518 => 'GreenHue', 520 => 'GreenHue' },
	'greensaturation' => { 518 => 'GreenSaturation', 520 => 'GreenSaturation' },
	'griddisplay' => { 308 => '13.3', 309 => '4.3', 311 => '4.2', 312 => '4.2', 313 => '2.2', 317 => '10.5', 318 => '3.4', 319 => '6.1', 321 => '4.4', 322 => '4.2', 323 => '4.2' },
	'gripbatteryadload' => { 367 => 0x5 },
	'gripbatteryadnoload' => { 367 => 0x4 },
	'gripbatterypercent' => { 367 => 0x11 },
	'gripbatterystate' => { 367 => ['1.2',0x10] },
	'gripbatteryvoltage' => { 367 => 0x12 },
	'group' => { 518 => 'Group', 520 => 'Group' },
	'groupareaafillumination' => { 309 => '46.4', 312 => '47.4', 321 => '47.4' },
	'grouping' => { 406 => ['grup',"\xa9grp"], 414 => "\xa9grp" },
	'guid' => { 406 => 'GUID' },
	'h2resetblackpixels' => { 144 => 0x18a6 },
	'h3resetblackcolumns' => { 144 => 0x18ce },
	'h3resetblackpixels' => { 144 => 0x18b0 },
	'halftonehints' => { 124 => 0x141 },
	'hardlink' => { 125 => 'HardLink' },
	'hasalternative' => { 537 => 'hasAlternative' },
	'hascorrection' => { 537 => 'hasCorrection' },
	'hascorrectiona-lang' => { 537 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 537 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 537 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 518 => 'HasCrop', 520 => 'HasCrop' },
	'hasextendedxmp' => { 549 => 'HasExtendedXMP' },
	'hassettings' => { 518 => 'HasSettings', 520 => 'HasSettings' },
	'hastranslation' => { 537 => 'hasTranslation' },
	'hasvisibleoverprint' => { 552 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 552 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 247 => 0x35a },
	'hdmioutputresolution' => { 248 => 0x710, 249 => 0x720, 250 => 0x610, 251 => 0x640, 252 => 0x6a8 },
	'hdmiviewassist' => { 326 => 0x20f, 327 => 0x227 },
	'hdr' => { 63 => 0x1, 227 => 0x4, 228 => 0x4, 246 => 0x354, 248 => 0x23a, 249 => 0x23a, 252 => 0x23a, 353 => 0x9e, 389 => 0x85, 455 => 0x200a },
	'hdrcapacitymax' => { 529 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 529 => 'HDRCapacityMin' },
	'hdreditmode' => { 518 => 'HDREditMode', 520 => 'HDREditMode' },
	'hdreffect' => { 63 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 227 => 0x5, 228 => 0x5, 246 => 0x360, 248 => 0x246, 249 => 0x246, 252 => 0x246, 443 => 0x2e, 460 => 0x17 },
	'hdrlevel2' => { 227 => 0x7 },
	'hdrplusmakernote' => { 500 => 'HdrPlusMakernote' },
	'hdrpmakernote' => { 500 => 'hdrp_makernote' },
	'hdrsetting' => { 443 => 0x2d, 460 => 0x16, 464 => 0x1148, 465 => 0x1148, 466 => 0x1124, 467 => 0x11a0, 468 => 0x117c, 469 => 0x1034, 470 => 0x22c, 471 => 0x22c, 472 => 0x21f },
	'hdrsmoothing' => { 227 => 0x6 },
	'hdvideo' => { 406 => 'hdvd' },
	'headline' => { 137 => 0x69, 532 => 'Headline', 535 => 'Headline' },
	'hiddendatalength' => { 453 => 0x1 },
	'hiddendataoffset' => { 453 => 0x0 },
	'hierarchicalkeywords' => { 177 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 177 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 177 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 177 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 177 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 177 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 177 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 177 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 177 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 177 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 177 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 177 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 177 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 177 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 177 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 177 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 177 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 177 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 510 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 123 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 246 => 0x16c, 248 => 0x48, 249 => 0x48, 251 => 0x48, 252 => 0x48 },
	'highfrequencyflickerreduction' => { 246 => 0x386, 248 => 0x27c, 249 => 0x27c, 251 => 0x27c, 252 => 0x27c },
	'highisomultiplierblue' => { 358 => 0x1a },
	'highisomultipliergreen' => { 358 => 0x19 },
	'highisomultiplierred' => { 358 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 66 => 0x5, 89 => 0x202, 242 => 0xb1, 389 => 0x71, 441 => 0x2c, 442 => 0x26, 443 => 0x26, 455 => 0x2009, 460 => 0x12, 487 => 0x42 },
	'highisonoisereduction2' => { 455 => 0xb050 },
	'highlight' => { 431 => 0xf },
	'highlight2012' => { 518 => 'Highlight2012', 520 => 'Highlight2012' },
	'highlightadj' => { 108 => 0x2030c },
	'highlightcolordistortreduct' => { 492 => 0x8026 },
	'highlightlinearitylimit' => { 428 => 0xa025 },
	'highlightprotection' => { 300 => 0x6 },
	'highlightrecovery' => { 518 => 'HighlightRecovery', 520 => 'HighlightRecovery' },
	'highlights' => { 455 => 0x2033, 512 => 'Highlights' },
	'highlights2012' => { 518 => 'Highlights2012', 520 => 'Highlights2012' },
	'highlightsadj' => { 492 => 0x9019 },
	'highlightshadow' => { 353 => 0xad },
	'highlighttone' => { 132 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 66 => 0x3, 89 => 0x203 },
	'highlightwarning' => { 353 => 0x8002 },
	'highlowkeyadj' => { 389 => 0x6c },
	'highspeedsync' => { 190 => 0x5, 324 => 0x59, 325 => 0x55, 326 => 0x55, 327 => 0x55, 441 => 0x2, 442 => 0x2 },
	'hintversion' => { 414 => 'hinv' },
	'histogramxml' => { 301 => 0x83a1a25 },
	'history' => { 535 => 'History', 548 => 'History' },
	'historyaction' => { 548 => [\'History','HistoryAction'] },
	'historychanged' => { 548 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 548 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 548 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 548 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 548 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 144 => 0xc88 },
	'holefilldeltathreshold' => { 144 => 0xc7e },
	'hometowncity' => { 118 => 0x3006, 389 => 0x23, 395 => 0x2 },
	'hometowncitycode' => { 396 => 0x1000 },
	'hometowndst' => { 389 => 0x25, 395 => '0.2' },
	'hostcomputer' => { 124 => 0x13c },
	'hostsoftwarerendering' => { 144 => 0xce7 },
	'hue' => { 195 => 0x3b, 260 => 0x3d, 261 => 0x45, 389 => 0x67 },
	'hueadj' => { 304 => 0x2f, 492 => 0x8019 },
	'hueadjust' => { 421 => 0x1016 },
	'hueadjustment' => { 188 => 0x4a, 189 => 0x40, 242 => 0x92, 259 => 0x36 },
	'hueadjustmentaqua' => { 518 => 'HueAdjustmentAqua', 520 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 518 => 'HueAdjustmentBlue', 520 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 518 => 'HueAdjustmentGreen', 520 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 518 => 'HueAdjustmentMagenta', 520 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 518 => 'HueAdjustmentOrange', 520 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 518 => 'HueAdjustmentPurple', 520 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 518 => 'HueAdjustmentRed', 520 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 518 => 'HueAdjustmentYellow', 520 => 'HueAdjustmentYellow' },
	'huesetting' => { 337 => 0x1011 },
	'humanobservation' => { 123 => 'HumanObservation' },
	'humanobservationday' => { 123 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 123 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 123 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 123 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 123 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 123 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 123 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 123 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 123 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 123 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 123 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 123 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 123 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 123 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 123 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 123 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 123 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 123 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 123 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 123 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 124 => 0x9401, 525 => 'Humidity' },
	'icc_profile' => { 125 => 'ICC_Profile', 135 => 'ICCRGBG1/012' },
	'iccprofilename' => { 535 => 'ICCProfile' },
	'iconuri' => { 414 => 'icnu' },
	'idccreativestyle' => { 492 => 0x8000 },
	'idcpreviewlength' => { 492 => 0x202 },
	'idcpreviewstart' => { 492 => 0x201 },
	'identification' => { 123 => 'Identification' },
	'identificationid' => { 123 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 123 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 123 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 123 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 123 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 123 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 123 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 521 => 'identifier', 545 => 'Identifier' },
	'ifcameramodel' => { 144 => 0x9c8 },
	'illuminantdata1' => { 124 => 0xcd35 },
	'illuminantdata2' => { 124 => 0xcd36 },
	'illuminantdata3' => { 124 => 0xcd37 },
	'illumination' => { 319 => '0.5', 416 => 0x48 },
	'imageabsolutex' => { 144 => 0x3fe },
	'imageabsolutey' => { 144 => 0x3ff },
	'imageadjustment' => { 242 => 0x80, 290 => 0x5 },
	'imagealterationconstraints' => { 339 => 'ImageAlterationConstraints' },
	'imagearea' => { 232 => 0x2b, 268 => 0x2b, 276 => 0x10, 279 => 0x10 },
	'imageareaoffset' => { 389 => 0x38 },
	'imageauthentication' => { 242 => 0x20 },
	'imageboundary' => { 242 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 132 => 0x1438, 242 => 0xa5, 458 => 0x11b },
	'imagecreator' => { 339 => 'ImageCreator' },
	'imagecreatorid' => { 339 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 339 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 339 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 144 => 0x41f },
	'imagecropy' => { 144 => 0x420 },
	'imagedata' => { 505 => 'Data' },
	'imagedatasize' => { 242 => 0xa2 },
	'imagedescription' => { 124 => 0x10e, 543 => 'ImageDescription' },
	'imageduplicationconstraints' => { 339 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 301 => 0xfe443a45 },
	'imageeditcount' => { 389 => 0x41 },
	'imageediting' => { 389 => 0x32 },
	'imageeditingsoftware' => { 124 => 0xa43b, 525 => 'ImageEditingSoftware' },
	'imageeditor' => { 124 => 0xa438, 525 => 'ImageEditor' },
	'imageeffects' => { 421 => 0x1010 },
	'imagefileconstraints' => { 339 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 339 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 339 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 132 => 0x1436 },
	'imageheight' => { 124 => 0x101, 194 => 0xc, 398 => 0x10d, 503 => 'ImageHeight', 543 => 'ImageLength' },
	'imagehistory' => { 124 => 0x9213, 523 => 'ImageHistory' },
	'imageidnumber' => { 348 => 0x340 },
	'imagemimetype' => { 505 => 'Mime' },
	'imagenumber' => { 124 => 0x9211, 162 => 'ImageNumber', 188 => 0xae, 189 => 0x5e, 398 => 0x113, 441 => 0x9b, 443 => [0x400,'276.1',0x314], 515 => 'ImageNumber' },
	'imagenumber2' => { 189 => 0x62 },
	'imageoptimization' => { 242 => 0xa9 },
	'imageorientation' => { 137 => 0x83 },
	'imageprocessing' => { 242 => 0x1a },
	'imageprocessingfiledatecreated' => { 144 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 144 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 333 => 0x0 },
	'imagequality' => { 162 => 'ImageQuality', 278 => '723.2', 279 => '732.2', 287 => '708.1', 353 => 0x1 },
	'imagequality2' => { 329 => 0x603 },
	'imagerank' => { 508 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 144 => 0x600 },
	'imagerboardversion' => { 144 => 0x439 },
	'imagercols' => { 144 => 0x17d4 },
	'imageref' => { 530 => 'ImageRef' },
	'imageregion' => { 532 => 'ImageRegion' },
	'imageregionboundary' => { 532 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 532 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 532 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 532 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 532 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 532 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 532 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 532 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 532 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 532 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 532 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 532 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 532 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 532 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 532 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 532 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 532 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 532 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 532 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 144 => 0x944 },
	'imageresolutionjpg' => { 144 => 0x945 },
	'imagereview' => { 310 => '0.4', 319 => '0.4' },
	'imagereviewmonitorofftime' => { 309 => '21.1', 311 => '21.1', 312 => '21.1', 316 => '20.1', 321 => '21.1', 322 => '21.1', 324 => 0x3b, 325 => 0x39, 326 => 0x39, 327 => 0x39 },
	'imagereviewtime' => { 308 => '25.1', 310 => '2.1', 313 => '19.1', 314 => '20.1', 315 => '20.1', 317 => '9.2', 318 => '20.1', 323 => '21.2' },
	'imagerfiledatecreated' => { 144 => 0x9c5 },
	'imagerfileproductionlevel' => { 144 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 144 => 0x9c7 },
	'imagerotated' => { 157 => 0x2a },
	'imagerpowerondelaymsec' => { 144 => 0x5fd },
	'imagerrows' => { 144 => 0x17de },
	'imagesegmentlines' => { 144 => 0x184d },
	'imagesegmentstartline' => { 144 => 0x184c },
	'imagesequenceinfo' => { 124 => 0xcd44 },
	'imagesize' => { 168 => 'ImageSize' },
	'imagesizeraw' => { 242 => 0x3e },
	'imagesizerestriction' => { 540 => 'imageSizeRestriction' },
	'imagesourcedata' => { 124 => 0x935c },
	'imagespace' => { 144 => 0x909 },
	'imagestabilization' => { 36 => 0x22, 118 => 0x3020, 132 => 0x1422, 162 => 'ImageStabilization', 188 => 0xbd, 189 => 0x71, 190 => 0x57, 191 => 0x0, 192 => [0x18,0x107,0x113], 193 => 0x49c2, 242 => 0xac, 329 => 0x604, 332 => 0x1600, 353 => 0x1a, 446 => 0x12, 447 => 0x11, 455 => 0xb026 },
	'imagestabilization2' => { 445 => 0xa },
	'imagestabilizationsetting' => { 193 => 0x14, 441 => 0x3d, 442 => 0x3d, 452 => 0x14 },
	'imagestats' => { 124 => 0xcd46 },
	'imagestyle' => { 441 => 0x2d, 442 => 0x27 },
	'imagesupplier' => { 339 => 'ImageSupplier' },
	'imagesupplierid' => { 339 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 339 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 339 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 126 => 0x1 },
	'imagetemperaturemin' => { 126 => 0x2 },
	'imagetitle' => { 124 => 0xa436, 525 => 'ImageTitle' },
	'imagetone' => { 389 => 0x4f },
	'imagetype' => { 137 => 0x82, 339 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 68 => 0x28, 124 => 0xa420, 523 => 'ImageUniqueID', 524 => 'ImageUniqueID', 525 => 'ImageUniqueID' },
	'imagewidth' => { 124 => 0x100, 194 => 0xe, 398 => 0x10c, 503 => 'ImageWidth', 543 => 'ImageWidth' },
	'inclinationangle' => { 492 => 0x900f },
	'inclinationcorrection' => { 492 => 0x900e },
	'incrementaltemperature' => { 518 => 'IncrementalTemperature', 520 => 'IncrementalTemperature' },
	'incrementaltint' => { 518 => 'IncrementalTint', 520 => 'IncrementalTint' },
	'industry' => { 537 => 'industry', 538 => 'industry' },
	'infobuttonwhenshooting' => { 89 => 0x409 },
	'information' => { 408 => 'information', 414 => "\xa9inf" },
	'infourl' => { 414 => 'infu' },
	'infraredilluminator' => { 415 => 0x28 },
	'ingredientexclusion' => { 539 => 'ingredientExclusion' },
	'ingredients' => { 548 => 'Ingredients' },
	'ingredientsalternatepaths' => { 548 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 548 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 548 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 548 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 548 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 548 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 548 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 548 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 548 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 548 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 548 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 548 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 548 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 548 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 548 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 548 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 548 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 548 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 548 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 548 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 548 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 548 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 548 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 89 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 506 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 506 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 185 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 506 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 506 => 'InitialViewHeadingDegrees', 507 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 506 => 'InitialViewPitchDegrees', 507 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 506 => 'InitialViewRollDegrees', 507 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 308 => '4.4' },
	'initialzoomsetting' => { 308 => '9.3', 317 => '27.3' },
	'inkset' => { 124 => 0x14c },
	'inputprofile' => { 144 => 0x1389 },
	'instanceid' => { 548 => 'InstanceID' },
	'instantplaybacksetup' => { 190 => 0x3e },
	'instantplaybacktime' => { 190 => 0x3d },
	'instructions' => { 535 => 'Instructions' },
	'instrument' => { 547 => 'instrument' },
	'integrationtime' => { 144 => 0x423 },
	'intellectualgenre' => { 531 => 'IntellectualGenre' },
	'intelligentauto' => { 455 => 0xb052, 483 => 0xd, 484 => 0xe, 485 => 0xd },
	'intelligentcontrast' => { 55 => 0x4 },
	'intelligentd-range' => { 353 => 0x79 },
	'intelligentexposure' => { 353 => 0x5d },
	'intelligentresolution' => { 353 => 0x70 },
	'interchangecolorspace' => { 139 => 0x40 },
	'intergraphmatrix' => { 124 => 0x8480 },
	'internalflash' => { 187 => 0x2b, 308 => '23.1', 310 => '8.1', 313 => '22.1', 315 => '23.1', 319 => '8.1', 323 => '24.1', 332 => 0x1208 },
	'internalflashae1' => { 334 => 0x1021 },
	'internalflashae1_0' => { 334 => 0x101d },
	'internalflashae2' => { 334 => 0x1022 },
	'internalflashae2_0' => { 334 => 0x101e },
	'internalflashmode' => { 376 => 0x1 },
	'internalflashstrength' => { 376 => 0x3 },
	'internalflashtable' => { 334 => 0x1024 },
	'internallensserialnumber' => { 428 => 0xa005 },
	'internalndfilter' => { 353 => 0x9d },
	'internalserialnumber' => { 68 => 0x96, 80 => 0x9, 132 => 0x10, 193 => 0x49dc, 328 => 0x18, 330 => 0x102, 350 => 0x500, 353 => 0x25, 368 => 0x4, 421 => 0x5, 474 => [0x7c,0xf0], 475 => 0x88, 476 => [0x88,0x8a], 477 => 0x38 },
	'interopindex' => { 124 => 0x1, 525 => 'InteroperabilityIndex' },
	'interopversion' => { 124 => 0x2 },
	'interval' => { 266 => 0x20 },
	'intervaldurationhours' => { 246 => 0x1dc, 247 => 0xa0, 248 => 0xb8, 249 => 0xb8 },
	'intervaldurationminutes' => { 246 => 0x1e0, 247 => 0xa4, 248 => 0xbc, 249 => 0xbc },
	'intervaldurationseconds' => { 246 => 0x1e4, 247 => 0xa8, 248 => 0xc0, 249 => 0xc0 },
	'intervalexposuresmoothing' => { 231 => 0x184, 246 => 0x1f4, 247 => 0xb8, 248 => 0xd0, 249 => 0xd0 },
	'intervalframe' => { 266 => 0x24 },
	'intervallength' => { 187 => 0x10 },
	'intervalmode' => { 187 => 0x26 },
	'intervalnumber' => { 187 => 0x11 },
	'intervalpriority' => { 231 => 0x186, 246 => 0x1f6, 247 => 0xba, 248 => 0xd2, 249 => 0xd2 },
	'intervals' => { 231 => 0x17c, 246 => 0x1ec, 247 => 0xb0, 248 => 0xc8, 249 => 0xc8, 250 => 0xbc, 251 => 0xcc, 252 => 0xcc },
	'intervalshooting' => { 232 => 0x24, 268 => 0x24, 269 => 0x28, 389 => 0x92 },
	'introtime' => { 547 => 'introTime' },
	'introtimescale' => { 547 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 547 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 144 => 0xdae },
	'ipfcameramodel' => { 144 => 0xe4d },
	'iptc' => { 125 => 'IPTC' },
	'iptc-naa' => { 124 => 0x83bb, 358 => 0x83bb },
	'iptcbitspersample' => { 139 => 0x56 },
	'iptcdigest' => { 403 => 0x425 },
	'iptcimageheight' => { 139 => 0x1e },
	'iptcimagerotation' => { 139 => 0x66 },
	'iptcimagewidth' => { 139 => 0x14 },
	'iptclastedited' => { 532 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 139 => 0xa },
	'iptcpixelheight' => { 139 => 0x32 },
	'iptcpixelwidth' => { 139 => 0x28 },
	'isalternativeof' => { 537 => 'isAlternativeOf' },
	'isbn' => { 537 => 'isbn' },
	'iscorrectionof' => { 537 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 114 => 0x3 },
	'ismergedhdr' => { 515 => 'IsMergedHDR' },
	'ismergedpanorama' => { 515 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 31 => 0x0, 32 => 0x1, 117 => 0x14, 118 => [0x3014,0x14], 124 => 0x8827, 143 => 0xfd06, 144 => 0x1784, 146 => 0x60, 148 => [0xfa2e,0xfa46], 149 => [0x27,0x28], 150 => 0xf105, 153 => 0x14, 155 => 0x4e, 157 => 0x1e, 158 => 0x1a, 160 => 0x34, 162 => 'ISO', 187 => 0x8, 193 => 0x49ba, 230 => 0x0, 242 => 0x2, 353 => 0xd1, 358 => [0x17,0x37], 389 => [0x8b,0x14], 396 => 0x14, 398 => 0x105, 428 => 0xa014, 431 => 0x86, 452 => 0x6f, 460 => [0x1f,0x21,0x25], 524 => 'ISOSpeedRatings' },
	'iso2' => { 230 => 0x6, 273 => 0x265, 274 => 0x25c, 275 => 0x265, 276 => 0x221, 277 => 0x25d, 278 => 0x256, 279 => 0x25d, 282 => 0x2b5, 285 => 0x265, 289 => 0x2b5 },
	'isoauto' => { 369 => '14.4' },
	'isoautoflashlimit' => { 248 => 0x156, 249 => 0x156, 250 => 0x146, 251 => 0x15a, 252 => 0x15a },
	'isoautohilimit' => { 229 => 0x5, 246 => 0x28a, 248 => 0x154, 249 => 0x154, 250 => 0x144, 251 => 0x158, 252 => 0x158, 271 => 0x5, 281 => 0x18eb },
	'isoautomax' => { 454 => 0x4 },
	'isoautomin' => { 454 => 0x2 },
	'isoautominspeed' => { 389 => 0x7a },
	'isoautoshuttertime' => { 229 => 0x4, 248 => 0x15e, 249 => 0x15e, 250 => 0x14e, 251 => 0x162, 252 => 0x162, 271 => 0x4, 281 => 0x18ea },
	'isobutton' => { 252 => 0x796 },
	'isocalibrationgain' => { 144 => 0x89f },
	'isodisplay' => { 311 => '4.1', 312 => '4.1', 313 => '2.3', 314 => '3.3', 315 => '3.3', 318 => '3.3', 321 => '4.3', 322 => '4.1', 323 => '4.3' },
	'isoexpansion' => { 89 => 0x103, 90 => 0x7, 91 => 0x8, 94 => 0x8, 230 => 0x4 },
	'isoexpansion2' => { 230 => 0xa },
	'isofloor' => { 369 => 0x6 },
	'isoselected' => { 352 => 0x359 },
	'isoselection' => { 242 => 0xf },
	'isosensitivitystep' => { 316 => '6.2', 318 => '6.2' },
	'isosetting' => { 146 => 0x5e, 158 => 0x14, 162 => 'ISOSetting', 187 => 0x24, 188 => 0x26, 189 => 0x1c, 190 => 0x13, 195 => 0x6, 242 => 0x13, 369 => '17.3', 420 => 0x27, 441 => 0x16, 442 => 0x14, 443 => 0x2, 452 => 0x6d, 454 => 0x0 },
	'isospeed' => { 124 => 0x8833, 525 => 'ISOSpeed' },
	'isospeedexpansion' => { 88 => 0x3 },
	'isospeedincrements' => { 89 => 0x102 },
	'isospeedlatitudeyyy' => { 124 => 0x8834, 525 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 124 => 0x8835, 525 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 89 => 0x103 },
	'isostepsize' => { 308 => '6.1', 309 => '7.2', 311 => '7.2', 312 => '7.2', 317 => '4.1', 321 => '7.2', 322 => '7.2', 324 => 0x14d, 325 => 0x15d, 326 => 0x15d, 327 => 0x175 },
	'isovalue' => { 334 => 0x1001 },
	'isrc' => { 406 => 'xid ' },
	'isrccode' => { 414 => "\xa9isr" },
	'issn' => { 537 => 'issn' },
	'issueidentifier' => { 537 => 'issueIdentifier' },
	'issuename' => { 537 => 'issueName' },
	'issueteaser' => { 537 => 'issueTeaser' },
	'issuetype' => { 537 => 'issueType' },
	'istranslationof' => { 537 => 'isTranslationOf' },
	'itemsubtype' => { 184 => 'ItemSubType' },
	'itunesu' => { 406 => 'itnu' },
	'jobid' => { 137 => 0xb8 },
	'jobname' => { 526 => 'JobName' },
	'jobref' => { 546 => 'JobRef' },
	'jobrefid' => { 546 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 546 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 546 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 526 => 'JobStatus' },
	'jpeg-heifswitch' => { 455 => 0x2039 },
	'jpeghandling' => { 518 => 'JPEGHandling', 520 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 353 => 0x43, 355 => 0x3034, 455 => 0xb047 },
	'jpegsize' => { 355 => 0x303a },
	'jpgcompression' => { 233 => 0x24, 242 => 0x44, 276 => '671.1' },
	'jpgfromraw' => { 102 => 0x2007, 119 => 'Exif-JpgFromRaw', 358 => 0x2e },
	'jpgfromrawlength' => { 124 => [0x117,0x202] },
	'jpgfromrawstart' => { 124 => [0x111,0x201] },
	'jpgrecordedpixels' => { 369 => '14.1' },
	'jurisdiction' => { 516 => 'jurisdiction' },
	'jxldecodespeed' => { 124 => 0xcd4b },
	'jxldistance' => { 124 => 0xcd49 },
	'jxleffort' => { 124 => 0xcd4a },
	'keepexposure' => { 325 => 0x237, 326 => 0x237, 327 => 0x24f },
	'kelvinwb_01' => { 377 => 0x5 },
	'kelvinwb_02' => { 377 => 0x9 },
	'kelvinwb_03' => { 377 => 0xd },
	'kelvinwb_04' => { 377 => 0x11 },
	'kelvinwb_05' => { 377 => 0x15 },
	'kelvinwb_06' => { 377 => 0x19 },
	'kelvinwb_07' => { 377 => 0x1d },
	'kelvinwb_08' => { 377 => 0x21 },
	'kelvinwb_09' => { 377 => 0x25 },
	'kelvinwb_10' => { 377 => 0x29 },
	'kelvinwb_11' => { 377 => 0x2d },
	'kelvinwb_12' => { 377 => 0x31 },
	'kelvinwb_13' => { 377 => 0x35 },
	'kelvinwb_14' => { 377 => 0x39 },
	'kelvinwb_15' => { 377 => 0x3d },
	'kelvinwb_16' => { 377 => 0x41 },
	'kelvinwb_daylight' => { 377 => 0x1 },
	'kerneldenominators' => { 144 => 0x933 },
	'key' => { 547 => 'key' },
	'keystonecompensation' => { 333 => 0x1900 },
	'keystonedirection' => { 333 => 0x1901 },
	'keystonevalue' => { 333 => 0x1906 },
	'keyword' => { 406 => 'keyw', 537 => 'keyword' },
	'keywordinfo' => { 177 => 'Keywords' },
	'keywords' => { 137 => 0x19, 163 => 'Keywords', 338 => 'Keywords', 405 => 'Keywords', 408 => 'keywords', 513 => 'keywords', 534 => 'Keywords', 545 => 'Keywords' },
	'killdate' => { 537 => 'killDate' },
	'killdatea-platform' => { 537 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 537 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 143 => 0xf908, 146 => 0xe, 148 => [0xfa1e,0xfa52], 154 => 0x70 },
	'kodakimagewidth' => { 143 => 0xf907, 146 => 0xc, 148 => [0xfa1d,0xfa51], 154 => 0x6c },
	'kodakinfotype' => { 143 => 0xfa00 },
	'kodaklook' => { 144 => 0xe4c },
	'kodaklookprofile' => { 144 => 0x138a },
	'kodakmaker' => { 154 => 0x8 },
	'kodakmodel' => { 146 => 0x0, 154 => 0x28 },
	'kodaktag' => { 144 => 0x3ea },
	'kodakversion' => { 144 => 0x0 },
	'label' => { 342 => 'Label', 545 => 'Label' },
	'labelname1' => { 530 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 530 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 353 => 0x6f },
	'landscapeoutputhighlightpoint' => { 114 => 0x26 },
	'landscapeoutputshadowpoint' => { 114 => 0x27 },
	'landscaperawcolortone' => { 114 => 0x1f },
	'landscaperawcontrast' => { 114 => 0x21 },
	'landscaperawhighlight' => { 114 => 0x77 },
	'landscaperawhighlightpoint' => { 114 => 0x24 },
	'landscaperawlinear' => { 114 => 0x22 },
	'landscaperawsaturation' => { 114 => 0x20 },
	'landscaperawshadow' => { 114 => 0x80 },
	'landscaperawshadowpoint' => { 114 => 0x25 },
	'landscaperawsharpness' => { 114 => 0x23 },
	'landscapeunsharpmaskfineness' => { 114 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 114 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 114 => 0xa2 },
	'language' => { 246 => 0x8fc, 248 => 0x6a2, 249 => 0x6a2, 250 => 0x592, 251 => 0x5c2, 252 => 0x5da, 521 => 'language' },
	'languageidentifier' => { 137 => 0x87 },
	'largestvalidinteriorrectheight' => { 506 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 506 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 506 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 506 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 187 => 0x1b },
	'lastkeywordiptc' => { 184 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 184 => 'LastKeywordXMP' },
	'lastphotodate' => { 506 => 'LastPhotoDate' },
	'lasturl' => { 548 => 'LastURL' },
	'lateralchromaticaberration' => { 455 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 515 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 123 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 123 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 123 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 123 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 123 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 121 => 'Latitude' },
	'lc1' => { 379 => 0x2 },
	'lc10' => { 379 => 0xb },
	'lc11' => { 379 => 0xc },
	'lc12' => { 379 => 0xd },
	'lc14' => { 379 => 0xf },
	'lc15' => { 379 => 0x10 },
	'lc3' => { 379 => 0x4 },
	'lc4' => { 379 => 0x5 },
	'lc5' => { 379 => 0x6 },
	'lc6' => { 379 => 0x7 },
	'lc7' => { 379 => 0x8 },
	'lc8' => { 379 => 0x9 },
	'lcddisplayatpoweron' => { 89 => 0x811, 93 => 0xa },
	'lcddisplayreturntoshoot' => { 94 => 0x12 },
	'lcdillumination' => { 308 => '17.5', 309 => '5.2', 311 => '5.1', 312 => '5.1', 317 => '10.3', 318 => '4.2', 321 => '5.2', 322 => '5.1', 323 => '5.4', 324 => 0xf1, 325 => 0x101, 326 => 0x101, 327 => 0x117 },
	'lcdilluminationduringbulb' => { 89 => 0x408 },
	'lcdmatrix' => { 144 => 0xe74 },
	'lcdmatrixchickfix' => { 144 => 0xe75 },
	'lcdmatrixmarvin' => { 144 => 0xe76 },
	'lcdpanels' => { 88 => 0x8 },
	'lcheditor' => { 301 => 0x8ae85e },
	'legacyiptcdigest' => { 535 => 'LegacyIPTCDigest' },
	'legalcode' => { 516 => 'legalcode' },
	'lens' => { 124 => 0xfdea, 242 => 0x84, 515 => 'Lens' },
	'lensafstopbutton' => { 87 => 0x11, 88 => 0x13, 89 => 0x506, 90 => 0x10, 91 => 0x12, 94 => 0x13, 95 => 0x9 },
	'lensaperturerange' => { 431 => [0x30,0x48] },
	'lensblur' => { 518 => 'LensBlur', 520 => 'LensBlur' },
	'lensbluractive' => { 518 => [\'LensBlur','LensBlurActive'], 520 => [\'LensBlur','LensBlurActive'] },
	'lensbluramount' => { 518 => [\'LensBlur','LensBlurBlurAmount'], 520 => [\'LensBlur','LensBlurBlurAmount'] },
	'lensblurbokehaspect' => { 518 => [\'LensBlur','LensBlurBokehAspect'], 520 => [\'LensBlur','LensBlurBokehAspect'] },
	'lensblurbokehrotation' => { 518 => [\'LensBlur','LensBlurBokehRotation'], 520 => [\'LensBlur','LensBlurBokehRotation'] },
	'lensblurbokehshape' => { 518 => [\'LensBlur','LensBlurBokehShape'], 520 => [\'LensBlur','LensBlurBokehShape'] },
	'lensblurbokehshapedetail' => { 518 => [\'LensBlur','LensBlurBokehShapeDetail'], 520 => [\'LensBlur','LensBlurBokehShapeDetail'] },
	'lensblurcateyeamount' => { 518 => [\'LensBlur','LensBlurCatEyeAmount'], 520 => [\'LensBlur','LensBlurCatEyeAmount'] },
	'lensblurcateyescale' => { 518 => [\'LensBlur','LensBlurCatEyeScale'], 520 => [\'LensBlur','LensBlurCatEyeScale'] },
	'lensblurfocalrange' => { 518 => [\'LensBlur','LensBlurFocalRange'], 520 => [\'LensBlur','LensBlurFocalRange'] },
	'lensblurfocalrangesource' => { 518 => [\'LensBlur','LensBlurFocalRangeSource'], 520 => [\'LensBlur','LensBlurFocalRangeSource'] },
	'lensblurhighlightsboost' => { 518 => [\'LensBlur','LensBlurHighlightsBoost'], 520 => [\'LensBlur','LensBlurHighlightsBoost'] },
	'lensblurhighlightsthreshold' => { 518 => [\'LensBlur','LensBlurHighlightsThreshold'], 520 => [\'LensBlur','LensBlurHighlightsThreshold'] },
	'lensblursampledarea' => { 518 => [\'LensBlur','LensBlurSampledArea'], 520 => [\'LensBlur','LensBlurSampledArea'] },
	'lensblursampledrange' => { 518 => [\'LensBlur','LensBlurSampledRange'], 520 => [\'LensBlur','LensBlurSampledRange'] },
	'lensblursphericalaberration' => { 518 => [\'LensBlur','LensBlurSphericalAberration'], 520 => [\'LensBlur','LensBlurSphericalAberration'] },
	'lensblursubjectrange' => { 518 => [\'LensBlur','LensBlurSubjectRange'], 520 => [\'LensBlur','LensBlurSubjectRange'] },
	'lensblurversion' => { 518 => [\'LensBlur','LensBlurVersion'], 520 => [\'LensBlur','LensBlurVersion'] },
	'lenscontrolring' => { 324 => 0xb1, 325 => 0xad, 326 => 0xad, 327 => 0xad },
	'lenscorrectionsettings' => { 523 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 515 => 'LensDistortInfo' },
	'lensdistortionparams' => { 334 => 0x206 },
	'lensdriveend' => { 240 => 0x56 },
	'lensdrivenoaf' => { 89 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 443 => 0x3f0, 491 => 0xd },
	'lensfirmware' => { 422 => 0x20, 428 => 0xa004 },
	'lensfirmwareversion' => { 240 => 0x34, 330 => 0x204, 353 => 0x60, 443 => 0x3f3, 491 => 0x14 },
	'lensfocallength' => { 108 => 0xf0512, 379 => 0x9 },
	'lensfocalrange' => { 431 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 309 => '55.1', 311 => '52.1', 312 => '52.1', 321 => '52.1', 322 => '52.1' },
	'lensformat' => { 468 => 0x1891, 470 => 0x18bd, 471 => 0x18ed, 472 => 0x17f1, 474 => 0x106, 475 => 0x106, 486 => 0x603, 487 => 0x5d },
	'lensfstops' => { 234 => 0x7, 235 => 0xc, 236 => 0xd, 240 => 0xe, 242 => 0x8b, 379 => '0.3' },
	'lensfunc1button' => { 324 => 0xa3, 325 => 0x9f, 326 => 0x9f, 327 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 249 => 0x80a, 252 => 0x810 },
	'lensfunc2button' => { 324 => 0xab, 325 => 0xa7, 326 => 0xa7, 327 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 249 => 0x80c, 252 => 0x812 },
	'lensid' => { 240 => 0x30, 515 => 'LensID' },
	'lensidnumber' => { 234 => 0x6, 235 => 0xb, 236 => 0xc, 240 => 0xd },
	'lensinfo' => { 124 => 0xa432, 385 => 0x2a, 515 => 'LensInfo', 525 => 'LensSpecification' },
	'lenskind' => { 379 => 0x1 },
	'lensmake' => { 124 => 0xa433, 169 => 'Make', 525 => 'LensMake' },
	'lensmanualdistortionamount' => { 518 => 'LensManualDistortionAmount', 520 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 184 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 431 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 68 => 0x95, 124 => 0xa434, 169 => 'Model', 184 => 'LensModel', 237 => 0x18a, 238 => 0x18b, 239 => 0x2ac, 330 => 0x203, 385 => 0xc, 398 => 0x412, 525 => 'LensModel' },
	'lensmodulationoptimizer' => { 132 => 0x1045 },
	'lensmount' => { 443 => 0x99, 468 => 0x1892, 470 => 0x18be, 471 => 0x18ee, 472 => 0x17f2, 474 => 0x105, 475 => 0x105, 486 => 0x604, 487 => 0x5e },
	'lensmount2' => { 491 => 0x8 },
	'lensmounttype' => { 240 => 0x5f },
	'lenspositionabsolute' => { 240 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 518 => 'LensProfileChromaticAberrationScale', 520 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 518 => 'LensProfileDigest', 520 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 518 => 'LensProfileDistortionScale', 520 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 518 => 'LensProfileEnable', 520 => 'LensProfileEnable' },
	'lensprofilefilename' => { 518 => 'LensProfileFilename', 520 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 518 => 'LensProfileIsEmbedded', 520 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 518 => 'LensProfileMatchKeyCameraModelName', 520 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 518 => 'LensProfileMatchKeyExifMake', 520 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 518 => 'LensProfileMatchKeyExifModel', 520 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 518 => 'LensProfileMatchKeyIsRaw', 520 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 518 => 'LensProfileMatchKeyLensID', 520 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 518 => 'LensProfileMatchKeyLensInfo', 520 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 518 => 'LensProfileMatchKeyLensName', 520 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 518 => 'LensProfileMatchKeySensorFormatFactor', 520 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 352 => 0x370, 518 => 'LensProfileName', 520 => 'LensProfileName' },
	'lensprofilesetup' => { 518 => 'LensProfileSetup', 520 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 518 => 'LensProfileVignettingScale', 520 => 'LensProfileVignettingScale' },
	'lensproperties' => { 330 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 34 => 0x16b, 64 => 0x0, 124 => 0xa435, 169 => 'SerialNumber', 330 => 0x202, 351 => 0x321, 353 => 0x52, 414 => 'LENS', 422 => 0x30, 515 => 'LensSerialNumber', 525 => 'LensSerialNumber' },
	'lensshutterlock' => { 190 => 0x4a },
	'lensspec' => { 438 => 0x0, 439 => 0x0, 440 => 0x0, 455 => 0xb02a },
	'lensspecfeatures' => { 474 => [0x115,0x116], 475 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 334 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 36 => 0x16, 192 => 0x10c, 193 => 0x49bd, 242 => 0x83, 330 => 0x201, 344 => 0x16, 348 => 0x310, 350 => 0x303, 351 => 0x303, 353 => 0x51, 355 => 0x3405, 380 => 0x0, 381 => 0x0, 382 => 0x1, 383 => 0x1, 384 => 0x1, 386 => 0x0, 428 => 0xa003, 431 => 0x27, 455 => 0xb027, 468 => 0x1896, 470 => 0x18c2, 471 => 0x18f2, 472 => 0x17f6, 474 => 0x109, 475 => 0x109, 486 => 0x608, 487 => 0x62 },
	'lenstype2' => { 443 => 0x3f7, 468 => 0x1893, 470 => 0x18bf, 471 => 0x18ef, 472 => 0x17f3, 474 => 0x107, 475 => 0x107, 486 => 0x605, 487 => 0x60 },
	'lenstype3' => { 491 => 0x9 },
	'lenstypemake' => { 353 => 0xc4 },
	'lenstypemodel' => { 353 => [0xc5,0xe4] },
	'lenszoomposition' => { 483 => 0x19, 484 => 0x1e, 487 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 361 => 0x15 },
	'levelmeter' => { 414 => ['Lvlm','lvlm'] },
	'levelorientation' => { 387 => 0x0 },
	'license' => { 516 => 'license' },
	'licensee' => { 339 => 'Licensee' },
	'licenseeid' => { 339 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 339 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 339 => 'LicenseeImageNotes' },
	'licenseename' => { 339 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 339 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 339 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 339 => 'LicenseeTransactionID' },
	'licenseid' => { 339 => 'LicenseID' },
	'licensestartdate' => { 339 => 'LicenseStartDate' },
	'licensetransactiondate' => { 339 => 'LicenseTransactionDate' },
	'licensetype' => { 522 => 'licensetype' },
	'licensor' => { 339 => 'Licensor' },
	'licensorcity' => { 339 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 339 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 339 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 339 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 339 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 339 => 'LicensorImageID' },
	'licensorname' => { 339 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 339 => 'LicensorNotes' },
	'licensorpostalcode' => { 339 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 339 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 339 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 339 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 339 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 339 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 339 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 339 => 'LicensorTransactionID' },
	'licensorurl' => { 339 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 334 => 0x1009 },
	'lightingmode' => { 118 => 0x302a },
	'lightreading' => { 389 => 0x15 },
	'lightsource' => { 124 => 0x9208, 242 => 0x90, 337 => 0x1000, 524 => 'LightSource' },
	'lightsourcespecial' => { 430 => 0x21d },
	'lightswitch' => { 321 => '0.1', 323 => '0.1' },
	'lightvaluecenter' => { 334 => 0x103d },
	'lightvalueperiphery' => { 334 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 324 => 0x143, 325 => 0x153, 326 => 0x153, 327 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 324 => 0x141, 325 => 0x151, 326 => 0x151, 327 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 324 => 0x140, 325 => 0x150, 326 => 0x150, 327 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 324 => 0x13f, 325 => 0x14f, 326 => 0x14f, 327 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 324 => 0x11, 325 => 0x11, 326 => 0x11, 327 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 324 => 0x14, 325 => 0x14, 326 => 0x14, 327 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 324 => 0x13, 325 => 0x13, 326 => 0x13, 327 => 0x13 },
	'limitafareamodeselauto' => { 324 => 0x15, 325 => 0x15, 326 => 0x15, 327 => 0x15 },
	'limitafareamodeselection' => { 309 => '51.1', 311 => '49.1', 312 => '49.1', 321 => '49.1', 322 => '49.1' },
	'limitreleasemodeselc120' => { 326 => '269.4', 327 => '293.4' },
	'limitreleasemodeselc30' => { 326 => '269.3', 327 => '293.3' },
	'limitreleasemodeselch' => { 326 => '269.2', 327 => '293.2' },
	'limitreleasemodeselcl' => { 326 => '269.1', 327 => '293.1' },
	'limitreleasemodeselself' => { 326 => '269.5', 327 => '293.5' },
	'limitselectableimagearea16to9' => { 324 => 0x4d, 325 => 0x47, 326 => 0x47, 327 => 0x47 },
	'limitselectableimagearea1to1' => { 324 => 0x4c, 325 => 0x46, 326 => 0x46, 327 => 0x46 },
	'limitselectableimageareadx' => { 324 => 0x4b, 325 => 0x45, 326 => 0x45, 327 => 0x45 },
	'linearitylimitblue' => { 358 => 0x10 },
	'linearitylimitgreen' => { 358 => 0xf },
	'linearitylimitred' => { 358 => 0xe },
	'linearityuppermargin' => { 43 => 0x32c, 44 => 0x282, 45 => 0x296, 48 => [0x2ba,0x2d1,0x2d5], 50 => 0x1e5, 51 => [0x1fe,0x2de], 52 => [0x232,0x310], 53 => 0x31e },
	'linearizationtable' => { 124 => 0xc618 },
	'linearresponselimit' => { 124 => 0xc62e },
	'link' => { 537 => 'link' },
	'linkaetoafpoint' => { 369 => '14.2' },
	'linkedencodedrightsexpr' => { 532 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 532 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 532 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 532 => 'LinkedEncRightsExpr' },
	'linkvrtofocuspoint' => { 246 => 0x3ec },
	'linlogcoring' => { 144 => 0x904 },
	'lithostratigraphicterms' => { 123 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 408 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 408 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 408 => 'live-photo.vitality-scoring-version' },
	'liveview' => { 364 => 0x1fa, 371 => 0x3 },
	'liveviewaf' => { 313 => '32.1', 323 => '34.1' },
	'liveviewafareamode' => { 318 => '34.1' },
	'liveviewafmethod' => { 460 => 0x20 },
	'liveviewafmode' => { 318 => '34.2' },
	'liveviewafsetting' => { 443 => 0x36 },
	'liveviewbuttonoptions' => { 309 => '50.2', 311 => '48.2', 312 => '48.2', 321 => '48.2', 322 => '48.2' },
	'liveviewexposuresimulation' => { 89 => 0x810 },
	'liveviewfocusmode' => { 443 => [0x8b,0x28b] },
	'liveviewmetering' => { 443 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 309 => '21.2', 311 => '21.2', 312 => '21.2', 314 => '20.2', 315 => '20.2', 316 => '20.2', 318 => '20.2', 321 => '21.2', 322 => '21.2' },
	'liveviewshooting' => { 60 => 0x13 },
	'livingspecimen' => { 123 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 123 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 137 => 0x79 },
	'localizedcameramodel' => { 124 => 0xc615 },
	'locallocationname' => { 428 => 0x30 },
	'location' => { 241 => 0x9, 353 => 0x67, 511 => 'Location', 531 => 'Location', 536 => 'location', 537 => 'location' },
	'locationaccuracyhorizontal' => { 408 => 'location.accuracy.horizontal' },
	'locationareacode' => { 517 => 'lac' },
	'locationbody' => { 408 => 'location.body' },
	'locationcreated' => { 532 => 'LocationCreated' },
	'locationcreatedcity' => { 532 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 532 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 532 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 532 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpsaltituderef' => { 532 => [\'LocationCreated','LocationCreatedGPSAltitudeRef'] },
	'locationcreatedgpslatitude' => { 532 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 532 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 532 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 532 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 532 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 532 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 532 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 532 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 408 => 'location.date' },
	'locationinformation' => { 414 => 'loci' },
	'locationinfoversion' => { 241 => 0x0 },
	'locationname' => { 408 => 'location.name', 428 => 0x31 },
	'locationnote' => { 408 => 'location.note' },
	'locationrole' => { 408 => 'location.role' },
	'locationshown' => { 532 => 'LocationShown' },
	'locationshowncity' => { 532 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 532 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 532 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 532 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpsaltituderef' => { 532 => [\'LocationShown','LocationShownGPSAltitudeRef'] },
	'locationshowngpslatitude' => { 532 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 532 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 532 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 532 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 532 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 532 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 532 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 532 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 89 => 0x709 },
	'logcomment' => { 547 => 'logComment' },
	'logscale' => { 144 => 0x902 },
	'longdescription' => { 406 => 'ldes' },
	'longexposurenoisereduction' => { 66 => 0x4, 89 => 0x201, 90 => 0x1, 91 => 0x2, 92 => 0x1, 93 => 0x1, 94 => 0x2, 95 => 0x1, 353 => 0x49, 441 => 0x2b, 442 => 0x25, 443 => 0x25, 455 => 0x2008, 460 => 0x11, 487 => 0x44 },
	'longexposurenoisereduction2' => { 60 => 0x8 },
	'longexposurenrused' => { 353 => 0xbe },
	'longitude' => { 121 => 'Longitude' },
	'look' => { 518 => 'Look', 520 => 'Look' },
	'lookamount' => { 518 => [\'Look','LookAmount'], 520 => [\'Look','LookAmount'] },
	'lookcluster' => { 518 => [\'Look','LookCluster'], 520 => [\'Look','LookCluster'] },
	'lookcopyright' => { 518 => [\'Look','LookCopyright'], 520 => [\'Look','LookCopyright'] },
	'lookgroup' => { 518 => [\'Look','LookGroup'], 520 => [\'Look','LookGroup'] },
	'lookname' => { 518 => 'LookName', 520 => 'LookName' },
	'lookparameters' => { 518 => [\'Look','LookParameters'], 520 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 518 => [\'Look','LookParametersCameraProfile'], 520 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 518 => [\'Look','LookParametersClarity2012'], 520 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 518 => [\'Look','LookParametersConvertToGrayscale'], 520 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparametershighlights2012' => { 518 => [\'Look','LookParametersHighlights2012'], 520 => [\'Look','LookParametersHighlights2012'] },
	'lookparameterslooktable' => { 518 => [\'Look','LookParametersLookTable'], 520 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 518 => [\'Look','LookParametersProcessVersion'], 520 => [\'Look','LookParametersProcessVersion'] },
	'lookparametersshadows2012' => { 518 => [\'Look','LookParametersShadows2012'], 520 => [\'Look','LookParametersShadows2012'] },
	'lookparameterstonecurvepv2012' => { 518 => [\'Look','LookParametersToneCurvePV2012'], 520 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 518 => [\'Look','LookParametersToneCurvePV2012Blue'], 520 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 518 => [\'Look','LookParametersToneCurvePV2012Green'], 520 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 518 => [\'Look','LookParametersToneCurvePV2012Red'], 520 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 518 => [\'Look','LookParametersVersion'], 520 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 518 => [\'Look','LookSupportsAmount'], 520 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 518 => [\'Look','LookSupportsMonochrome'], 520 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 518 => [\'Look','LookSupportsOutputReferred'], 520 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 518 => [\'Look','LookUUID'], 520 => [\'Look','LookUUID'] },
	'loop' => { 547 => 'loop' },
	'loopstyle' => { 414 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 123 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 518 => 'LuminanceAdjustmentAqua', 520 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 518 => 'LuminanceAdjustmentBlue', 520 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 518 => 'LuminanceAdjustmentGreen', 520 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 518 => 'LuminanceAdjustmentMagenta', 520 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 518 => 'LuminanceAdjustmentOrange', 520 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 518 => 'LuminanceAdjustmentPurple', 520 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 518 => 'LuminanceAdjustmentRed', 520 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 518 => 'LuminanceAdjustmentYellow', 520 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 113 => 0x150 },
	'luminancecurvepoints' => { 113 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 108 => 0x20600, 114 => 0x5f, 431 => 0x1b },
	'luminancenoisereductioncontrast' => { 518 => 'LuminanceNoiseReductionContrast', 520 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 518 => 'LuminanceNoiseReductionDetail', 520 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 114 => 0x6d },
	'luminancesmoothing' => { 518 => 'LuminanceSmoothing', 520 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 89 => [0x40b,0x40c] },
	'lyrics' => { 406 => "\xa9lyr", 414 => "\xa9lyr", 547 => 'lyrics' },
	'lyricsuri' => { 414 => 'lrcu' },
	'm16cversion' => { 348 => 0x333 },
	'macatom' => { 519 => 'macAtom' },
	'macatomapplicationcode' => { 519 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 519 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 519 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 123 => 'MachineObservation' },
	'machineobservationday' => { 123 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 123 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 123 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 123 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 123 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 123 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 123 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 123 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 123 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 123 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 123 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 123 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 123 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 123 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 123 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 123 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 123 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 123 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 123 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 123 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 132 => 0x1020, 134 => 0x202, 157 => 0x2b, 334 => 0x202, 420 => 0x21, 430 => 0x202, 455 => 0xb040 },
	'macroled' => { 332 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 60 => 0x10 },
	'macromode' => { 36 => 0x1, 187 => 0xb, 329 => 0x300, 353 => 0x1c, 421 => 0x1009 },
	'magentahsl' => { 108 => 0x20917 },
	'magicfilter' => { 329 => 0x52c },
	'magnifiedview' => { 91 => 0x11, 93 => 0x9 },
	'mainboardversion' => { 144 => 0x438 },
	'maindialexposurecomp' => { 319 => '0.6' },
	'mainingredient' => { 539 => 'mainIngredient' },
	'majorbrand' => { 408 => 'major_brand' },
	'majorversion' => { 509 => 'MajorVersion' },
	'make' => { 103 => 0x0, 120 => 0x1, 124 => 0x10f, 162 => 'Make', 342 => 'Make', 358 => 0x10f, 408 => 'make', 414 => ['@mak',"\xa9mak"], 536 => 'make', 543 => 'Make' },
	'makernote' => { 524 => 'MakerNote' },
	'makernoteapple' => { 122 => 'MakN', 124 => 0x927c },
	'makernotecanon' => { 86 => 'CMT3', 122 => 'MakN', 124 => 0x927c },
	'makernotecasio' => { 122 => 'MakN', 124 => 0x927c },
	'makernotecasio2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotedji' => { 122 => 'MakN', 124 => 0x927c },
	'makernotedjiinfo' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteflir' => { 122 => 'MakN', 124 => 0x927c },
	'makernotefujifilm' => { 122 => 'MakN', 124 => 0x927c },
	'makernotege' => { 122 => 'MakN', 124 => 0x927c },
	'makernotege2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotehasselblad' => { 122 => 'MakN', 124 => 0x927c },
	'makernotehp' => { 122 => 'MakN', 124 => 0x927c },
	'makernotehp2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotehp4' => { 122 => 'MakN', 124 => 0x927c },
	'makernotehp6' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteisl' => { 122 => 'MakN', 124 => 0x927c },
	'makernotejvc' => { 122 => 'MakN', 124 => 0x927c },
	'makernotejvctext' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak10' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak11' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak12' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak1a' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak1b' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak4' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak5' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak6a' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak6b' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak7' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak8a' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak8b' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak8c' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak9' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodakunknown' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekyocera' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica10' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica2' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica3' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica4' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica5' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica6' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica7' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica8' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica9' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteminolta' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteminolta2' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteminolta3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotemotorola' => { 122 => 'MakN', 124 => 0x927c },
	'makernotenikon' => { 122 => 'MakN', 124 => 0x927c },
	'makernotenikon2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotenikon3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotenintendo' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteoffset' => { 430 => 0xff },
	'makernoteolympus' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteolympus2' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteolympus3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepanasonic' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepanasonic2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepanasonic3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentax' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentax2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentax3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentax4' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentax5' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentax6' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentaxunknown' => { 414 => 'PXMN' },
	'makernotephaseone' => { 122 => 'MakN', 124 => 0x927c },
	'makernotereconyx' => { 122 => 'MakN', 124 => 0x927c },
	'makernotereconyx2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotereconyx3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotericoh' => { 122 => 'MakN', 124 => 0x927c },
	'makernotericoh2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotericohpentax' => { 122 => 'MakN', 124 => 0x927c },
	'makernotericohtext' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesafety' => { 124 => 0xc635 },
	'makernotesamsung1a' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesamsung1b' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesamsung2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesanyo' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesanyoc4' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesanyopatch' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesigma' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesony' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesony2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesony3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesony4' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesony5' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesonyericsson' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesonysrf' => { 122 => 'MakN', 124 => 0x927c },
	'makernotetype' => { 421 => 0x1 },
	'makernoteunknown' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteunknownbinary' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteunknowntext' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 192 => 0x0, 242 => 0x1, 334 => 0x0, 353 => 0x8000, 425 => 0x0, 428 => 0x1, 431 => [0x1d,0x1f], 444 => 0x2000 },
	'makerurl' => { 414 => "\xa9mal" },
	'managedfrom' => { 548 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 548 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 548 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 548 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 548 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 548 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 548 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 548 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 548 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 548 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 548 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 548 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 548 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 548 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 548 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 548 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 548 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 548 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 548 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 548 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 548 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 548 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 548 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 548 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 548 => 'Manager' },
	'managervariant' => { 548 => 'ManagerVariant' },
	'manageto' => { 548 => 'ManageTo' },
	'manageui' => { 548 => 'ManageUI' },
	'manifest' => { 548 => 'Manifest' },
	'manifestlinkform' => { 548 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 548 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 548 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 548 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 548 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 548 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 548 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 548 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 548 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 548 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 548 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 548 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 548 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 548 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 548 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 548 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 548 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 548 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 548 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 548 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 548 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 548 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 548 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 548 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 548 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 548 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 548 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 548 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 329 => 0x900, 353 => 0x86 },
	'manometerreading' => { 329 => 0x901 },
	'manualafpointselectpattern' => { 89 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 332 => 0x1209 },
	'manualflashoutput' => { 36 => 0x29, 310 => '8.2', 313 => '22.2', 314 => '23.1', 315 => '23.2', 317 => '16.2', 318 => '23.2', 319 => '8.2', 320 => '23.2', 323 => '24.2', 421 => 0x100c },
	'manualflashstrength' => { 329 => 0x406 },
	'manualfocusdistance' => { 242 => 0x85, 334 => 0x100c, 430 => 0x223 },
	'manualfocuspointillumination' => { 324 => 0x17, 325 => 0x17, 326 => 0x17, 327 => 0x17 },
	'manualfocusringinafmode' => { 324 => 0x1b, 325 => 0x1a, 326 => 0x1a, 327 => 0x1a },
	'manualtv' => { 88 => 0x5, 89 => 0x705 },
	'manufacturedate' => { 197 => 0x6705, 368 => 0x1 },
	'manufacturedate1' => { 423 => 0x4 },
	'manufacturedate2' => { 423 => 0x5 },
	'manufacturer' => { 503 => 'Manufacturer', 536 => 'manufacturer' },
	'mariahchromablursize' => { 144 => 0xf0d },
	'mariahmaphithreshold' => { 144 => 0xf0c },
	'mariahmaplothreshold' => { 144 => 0xf0b },
	'mariahsigmathreshold' => { 144 => 0xf0e },
	'mariahtexturethreshold' => { 144 => 0xf0a },
	'marked' => { 534 => 'Marked', 551 => 'Marked' },
	'markers' => { 547 => 'markers' },
	'markerscomment' => { 547 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 547 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 547 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 547 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 547 => [\'markers','markersCuePointType'] },
	'markersduration' => { 547 => [\'markers','markersDuration'] },
	'markerslocation' => { 547 => [\'markers','markersLocation'] },
	'markersname' => { 547 => [\'markers','markersName'] },
	'markersprobability' => { 547 => [\'markers','markersProbability'] },
	'markersspeaker' => { 547 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 547 => [\'markers','markersStartTime'] },
	'markerstarget' => { 547 => [\'markers','markersTarget'] },
	'markerstype' => { 547 => [\'markers','markersType'] },
	'maskedareas' => { 124 => 0xc68e },
	'maskgroupbasedcorractive' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 518 => 'MaskGroupBasedCorrections', 520 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 518 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 520 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 137 => 0xb9 },
	'mastergain' => { 267 => 0x50 },
	'materialsample' => { 123 => 'MaterialSample' },
	'materialsampleid' => { 123 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 309 => '50.1', 311 => '48.1', 312 => '48.1', 321 => '48.1', 322 => '48.1', 325 => 0x233, 326 => 0x233, 327 => 0x24b },
	'matrixselectk' => { 144 => 0x91b },
	'matrixselectthreshold' => { 144 => 0x91a },
	'matrixselectthreshold1' => { 144 => 0x91e },
	'matrixselectthreshold2' => { 144 => 0x91f },
	'matrixstructure' => { 413 => 0xa },
	'maxaperture' => { 36 => 0x1a, 144 => 0x3f9, 150 => 0x6103, 169 => 'MaxAperture', 187 => 0x17, 193 => 0x49c5, 240 => 0x36, 330 => 0x20a, 379 => '14.1' },
	'maxapertureatmaxfocal' => { 132 => 0x1407, 169 => 'MaxApertureAtMaxFocal', 234 => 0xb, 235 => 0x10, 236 => 0x11, 240 => 0x12, 330 => 0x206 },
	'maxapertureatminfocal' => { 132 => 0x1406, 234 => 0xa, 235 => 0xf, 236 => 0x10, 240 => 0x11, 330 => 0x205 },
	'maxaperturevalue' => { 124 => 0x9205, 398 => 0x414, 524 => 'MaxApertureValue' },
	'maxavailheight' => { 532 => 'MaxAvailHeight' },
	'maxavailwidth' => { 532 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 308 => 0xb, 309 => 0xc, 311 => '12.1', 312 => '12.1', 317 => 0xc, 318 => 0xb, 321 => '12.1', 322 => '12.1', 324 => 0x41, 325 => 0x3d, 326 => 0x3d, 327 => 0x3d },
	'maxfaces' => { 333 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 36 => 0x17, 132 => 0x1405, 169 => 'MaxFocalLength', 234 => 0x9, 235 => 0xe, 236 => 0xf, 240 => 0x10, 330 => 0x208, 468 => 0x127c, 469 => 0x1138, 470 => 0x330, 471 => 0x330, 472 => 0x30e },
	'maxfocallength2' => { 65 => 0x9 },
	'maximumdensityrange' => { 139 => 0x8c },
	'maxpagesize' => { 552 => 'MaxPageSize' },
	'maxpagesizeh' => { 552 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 552 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 552 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 144 => 0xc7d },
	'maxsamplevalue' => { 124 => 0x119 },
	'maxstorage' => { 542 => 'maxstorage' },
	'mb-d10batteries' => { 308 => '12.6' },
	'mb-d10batterytype' => { 317 => '13.3' },
	'mb-d11batterytype' => { 318 => '2.3' },
	'mb-d12batterytype' => { 321 => '3.2' },
	'mb-d80batteries' => { 319 => '6.5' },
	'mb-d80batterytype' => { 323 => '3.2' },
	'mcuversion' => { 234 => 0xc, 235 => 0x11, 236 => 0x12, 240 => 0x13 },
	'md5digest' => { 170 => 'zmd5' },
	'mditemfindercomment' => { 179 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 179 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 179 => 'MDItemFSLabel' },
	'mditemusertags' => { 179 => 'MDItemUserTags' },
	'meal' => { 539 => 'meal' },
	'measuredev' => { 28 => 0x9, 81 => 0x3, 102 => 0x1814, 162 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 81 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 193 => 0x690, 348 => 0x312, 351 => 0x312, 352 => 0x312, 355 => 0x3407 },
	'measuredrggb' => { 69 => 0x1 },
	'measuredrggbdata' => { 47 => 0x287 },
	'measurementaccuracy' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 123 => 'MeasurementOrFact' },
	'measurementremarks' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 503 => 'MeasureType' },
	'mechanicalshuttercount' => { 242 => 0x37 },
	'mediaclassprimaryid' => { 185 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 185 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 339 => 'MediaConstraints' },
	'mediacreatedate' => { 410 => 0x1 },
	'mediaeventiddate' => { 508 => 'MediaEventIdDate' },
	'mediamodifydate' => { 410 => 0x2 },
	'mediasummarycode' => { 339 => 'MediaSummaryCode' },
	'mediatype' => { 406 => 'stik' },
	'memoaudioquality' => { 89 => 0x812 },
	'memorycardconfiguration' => { 447 => 0x16 },
	'memorycardnumber' => { 219 => 0x2 },
	'menubuttondisplayposition' => { 87 => 0xb, 90 => 0xa, 91 => 0xb, 94 => 0xb },
	'menubuttonreturn' => { 95 => 0xb },
	'menumonitorofftime' => { 308 => '26.1', 309 => '22.1', 311 => '22.1', 312 => '22.1', 316 => '21.1', 317 => '8.2', 318 => '21.1', 321 => '22.1', 322 => '22.1', 323 => '22.1', 324 => 0x39, 325 => 0x35, 326 => 0x35, 327 => 0x35 },
	'mergedimages' => { 353 => 0x76 },
	'metadataauthority' => { 532 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 532 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 532 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 545 => 'MetadataDate' },
	'metadataeditingsoftware' => { 124 => 0xa43c, 525 => 'MetadataEditingSoftware' },
	'metadatalastedited' => { 532 => 'metadataLastEdited' },
	'metadatalasteditor' => { 532 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 532 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 532 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 547 => 'metadataModDate' },
	'metaversion' => { 463 => 0x34 },
	'meterinfo1row1' => { 456 => 0x0, 457 => 0x0 },
	'meterinfo1row2' => { 456 => 0x6c, 457 => 0x5a },
	'meterinfo1row3' => { 456 => 0xd8, 457 => 0xb4 },
	'meterinfo1row4' => { 456 => 0x144, 457 => 0x10e },
	'meterinfo1row5' => { 456 => 0x1b0, 457 => 0x168 },
	'meterinfo1row6' => { 456 => 0x21c, 457 => 0x1c2 },
	'meterinfo1row7' => { 456 => 0x288, 457 => 0x21c },
	'meterinfo2row1' => { 456 => 0x2f4, 457 => 0x276 },
	'meterinfo2row2' => { 456 => 0x378, 457 => 0x2e4 },
	'meterinfo2row3' => { 456 => 0x3fc, 457 => 0x352 },
	'meterinfo2row4' => { 456 => 0x480, 457 => 0x3c0 },
	'meterinfo2row5' => { 456 => 0x504, 457 => 0x42e },
	'meterinfo2row6' => { 456 => 0x588, 457 => 0x49c },
	'meterinfo2row7' => { 456 => 0x60c, 457 => 0x50a },
	'meterinfo2row8' => { 456 => 0x690, 457 => 0x578 },
	'meterinfo2row9' => { 456 => 0x714, 457 => 0x5e6 },
	'metering' => { 310 => '6.1' },
	'meteringmode' => { 36 => 0x11, 124 => 0x9207, 146 => 0x1c, 187 => 0x7, 188 => 0x25, 190 => 0x12, 329 => 0x202, 389 => 0x17, 431 => 0x9, 441 => 0x15, 442 => 0x13, 443 => 0x7, 460 => 0x3, 464 => 0x1174, 465 => 0x1178, 466 => 0x1154, 467 => 0x11d0, 468 => 0x11ac, 469 => 0x1064, 470 => 0x25c, 471 => 0x25c, 472 => 0x24b, 524 => 'MeteringMode' },
	'meteringmode2' => { 369 => '2.1', 455 => 0x202c },
	'meteringmode3' => { 369 => '16.1' },
	'meteringoffscaleindicator' => { 190 => 0x53 },
	'meteringtime' => { 308 => '22.2', 310 => '3.2', 313 => '17.1', 314 => '18.1', 317 => '7.3', 318 => '18.1', 319 => '3.2', 323 => '19.1' },
	'micro1version' => { 416 => 0x1f },
	'micro2version' => { 416 => 0x2d },
	'microphoneattenuator' => { 248 => 0x34e, 249 => 0x34e, 250 => 0x2d2, 251 => 0x2fa, 252 => 0x2fa },
	'microphonefrequencyresponse' => { 248 => 0x350, 249 => 0x350, 250 => 0x2d4, 251 => 0x2fc, 252 => 0x2fc },
	'microphonejackpower' => { 248 => 0x376, 249 => 0x376, 250 => 0x2fa, 251 => 0x322, 252 => 0x322 },
	'microphonesensitivity' => { 248 => 0x34c, 249 => 0x34c, 250 => 0x2d0, 251 => 0x2f8, 252 => 0x2f8 },
	'microvideo' => { 500 => 'MicroVideo' },
	'microvideooffset' => { 500 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 500 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 500 => 'MicroVideoVersion' },
	'midrangesharpness' => { 261 => 0x3b },
	'mieversion' => { 170 => '0Vers' },
	'mime' => { 503 => 'Mime' },
	'minaperture' => { 36 => 0x1b, 144 => 0x3f8, 169 => 'MinAperture', 379 => '0.2' },
	'minaperturevalue' => { 398 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 36 => 0x18, 132 => 0x1404, 169 => 'MinFocalLength', 234 => 0x8, 235 => 0xd, 236 => 0xe, 240 => 0xf, 330 => 0x207, 468 => 0x127a, 469 => 0x1136, 470 => 0x32e, 471 => 0x32e, 472 => 0x30c },
	'minfocallength2' => { 65 => 0x8 },
	'minfocusdistance' => { 379 => 0x3 },
	'minimumiso' => { 353 => 0xe8 },
	'minintegrationrows' => { 144 => 0x1874 },
	'minoltadate' => { 187 => 0x15 },
	'minoltaimagesize' => { 187 => 0x4, 188 => 0xc, 189 => 0x2, 192 => 0x103 },
	'minoltamodelid' => { 187 => 0x25 },
	'minoltaquality' => { 187 => 0x5, 188 => 0xd, 189 => 0x3, 192 => [0x102,0x103] },
	'minoltatime' => { 187 => 0x16 },
	'minormodelagedisclosure' => { 339 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 408 => 'minor_version', 509 => 'MinorVersion' },
	'minsamplevalue' => { 124 => 0x118 },
	'mirrorlockup' => { 87 => 0xc, 88 => 0xc, 89 => 0x60f, 90 => 0xb, 91 => 0xc, 92 => 0x6, 93 => 0x6, 94 => 0xc, 95 => 0x3 },
	'mobilecountrycode' => { 517 => 'mcc' },
	'mobilenetworkcode' => { 517 => 'mnc' },
	'moddate' => { 342 => 'modify-date', 534 => 'ModDate' },
	'modedialposition' => { 447 => 0x14 },
	'model' => { 103 => 0x6, 124 => 0x110, 162 => 'Model', 342 => 'Model', 358 => 0x110, 389 => 0x23f, 408 => 'model', 414 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 431 => 0x84, 503 => 'Model', 536 => 'model', 543 => 'Model' },
	'modelage' => { 532 => 'ModelAge' },
	'modelid' => { 328 => 0x0 },
	'modelingflash' => { 308 => '21.4', 309 => '31.1', 311 => '31.1', 312 => '31.1', 317 => '26.4', 318 => '30.2', 319 => '7.4', 320 => '30.1', 321 => '31.1', 322 => '31.1', 323 => '31.3', 324 => 0x61, 325 => 0x5d, 326 => 0x5d, 327 => 0x5d },
	'modelreleaseid' => { 339 => 'ModelReleaseID' },
	'modelreleasestatus' => { 339 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 478 => 0x52, 479 => 0x46, 480 => 0x53 },
	'modeltiepoint' => { 124 => 0x8482 },
	'modeltransform' => { 124 => 0x85d8 },
	'modelyear' => { 536 => 'modelYear' },
	'modificationdate' => { 537 => 'modificationDate' },
	'modifiedcolortemp' => { 70 => 0x9 },
	'modifieddigitalgain' => { 70 => 0xb },
	'modifiedparamflag' => { 61 => 0x1 },
	'modifiedpicturestyle' => { 70 => 0xa },
	'modifiedsaturation' => { 329 => 0x504 },
	'modifiedsensorbluelevel' => { 70 => 0x5 },
	'modifiedsensorredlevel' => { 70 => 0x4 },
	'modifiedsharpness' => { 70 => 0x2 },
	'modifiedsharpnessfreq' => { 70 => 0x3 },
	'modifiedtonecurve' => { 70 => 0x1 },
	'modifiedwhitebalance' => { 70 => 0x8 },
	'modifiedwhitebalanceblue' => { 70 => 0x7 },
	'modifiedwhitebalancered' => { 70 => 0x6 },
	'modifydate' => { 124 => 0x132, 163 => 'ModifyDate', 338 => 'ModDate', 340 => 'tIME', 405 => 'ModDate', 411 => 0x2, 545 => 'ModifyDate' },
	'moirefilter' => { 124 => 0xfe58, 518 => 'MoireFilter', 520 => 'MoireFilter' },
	'monitorbrightness' => { 246 => 0x904, 248 => 0x69a, 249 => 0x6aa, 250 => 0x59a, 251 => 0x5ca, 252 => 0x5e2 },
	'monitordisplayoff' => { 190 => 0x4c },
	'monitormatrix' => { 144 => 0x8fc },
	'monitorofftime' => { 308 => '18.2', 310 => '3.1', 319 => '3.1' },
	'monochromecolor' => { 329 => 0x53b },
	'monochromecontrast' => { 114 => 0x3c },
	'monochromefiltereffect' => { 108 => 0x20307, 114 => 0x3a, 353 => 0xac, 389 => 0x73 },
	'monochromegraineffect' => { 353 => 0xd2 },
	'monochromelinear' => { 114 => 0x3d },
	'monochromeoutputhighlightpoint' => { 114 => 0x41 },
	'monochromeoutputshadowpoint' => { 114 => 0x42 },
	'monochromeprofilesettings' => { 329 => 0x537 },
	'monochromerawhighlight' => { 114 => 0x7a },
	'monochromerawhighlightpoint' => { 114 => 0x3f },
	'monochromerawshadow' => { 114 => 0x83 },
	'monochromerawshadowpoint' => { 114 => 0x40 },
	'monochromesharpness' => { 114 => 0x3e },
	'monochrometoning' => { 389 => 0x74 },
	'monochrometoningeffect' => { 108 => 0x20306, 114 => 0x3b },
	'monochromeunsharpmaskfineness' => { 114 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 114 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 114 => 0xb4 },
	'monochromevignetting' => { 329 => 0x53a },
	'monthdaycreated' => { 146 => 0x12, 155 => 0xe },
	'mood' => { 185 => 'WM/Mood' },
	'moonphase' => { 415 => 0x12, 416 => 0x43, 417 => 0x4c },
	'morepermissions' => { 516 => 'morePermissions' },
	'motionphoto' => { 500 => 'MotionPhoto' },
	'motionphotopresentationtimestampus' => { 500 => 'MotionPhotoPresentationTimestampUs' },
	'motionphotoversion' => { 500 => 'MotionPhotoVersion' },
	'motionphotovideo' => { 409 => 'mpvd' },
	'motionsensitivity' => { 415 => 0x29, 417 => 0x60 },
	'movementcount' => { 406 => "\xa9mvc" },
	'movementname' => { 406 => "\xa9mvn" },
	'movementnumber' => { 406 => "\xa9mvi" },
	'movieactived-lighting' => { 247 => 0x238, 248 => 0x334, 249 => 0x334, 250 => 0x2b8, 251 => 0x2e0, 252 => 0x2e0 },
	'movieaelockbuttonassignment' => { 321 => '40.1' },
	'movieaf-onbutton' => { 324 => 0xd3, 325 => 0xcb, 326 => 0xcb, 327 => 0xcb },
	'movieafareamode' => { 248 => 0x342, 249 => 0x342, 250 => 0x2c6, 251 => 0x2ee, 252 => 0x2ee, 325 => 0x203, 326 => 0x203, 327 => 0x21b },
	'movieafspeed' => { 324 => 0xe5, 325 => 0xdd, 326 => 0xdd, 327 => 0xdd },
	'movieafspeedapply' => { 324 => 0xe7, 325 => 0xdf, 326 => 0xdf, 327 => 0xdf },
	'movieaftrackingsensitivity' => { 324 => 0xe9, 325 => 0xe1, 326 => 0xe1, 327 => 0xe1 },
	'movieaperturelock' => { 325 => 0x259, 326 => 0x259, 327 => 0x271 },
	'movieautodistortioncontrol' => { 247 => 0x242 },
	'moviediffractioncompensation' => { 247 => 0x241 },
	'moviedxcropalert' => { 248 => 0x377, 249 => 0x377, 250 => 0x2fb, 251 => 0x323, 252 => 0x323 },
	'movieelectronicvr' => { 248 => 0x348, 249 => 0x348, 250 => 0x2cc, 251 => 0x2f4, 252 => 0x2f4 },
	'movieevfgrid' => { 325 => 0x21d, 326 => 0x21d, 327 => 0x235 },
	'movieflickerreduction' => { 248 => 0x33c, 249 => 0x33c, 250 => 0x2c0, 251 => 0x2e8, 252 => 0x2e8 },
	'moviefocusmode' => { 247 => 0x248, 248 => 0x340, 249 => 0x340, 250 => 0x2c4, 251 => 0x2ec, 252 => 0x2ec },
	'moviefocuspointlock' => { 325 => 0x226, 326 => 0x226, 327 => 0x23e },
	'movieframerate' => { 246 => 0x48c, 247 => 0x1f8, 248 => 0x374, 249 => 0x370, 250 => 0x2f4, 251 => 0x31c, 252 => 0x31c },
	'movieframesize' => { 246 => 0x48a, 247 => 0x1f6, 248 => 0x372, 249 => 0x36e, 250 => 0x2f2, 251 => 0x31a, 252 => 0x31a },
	'moviefunc1button' => { 311 => '41.1', 312 => '41.1', 322 => '41.1', 324 => 0xc7, 325 => 0xc3, 326 => 0xc3, 327 => 0xc3 },
	'moviefunc2button' => { 324 => 0xcd, 325 => 0xc7, 326 => 0xc7, 327 => 0xc7 },
	'moviefunc3button' => { 326 => 0x127, 327 => 0x13f },
	'moviefunctionbutton' => { 309 => '41.1', 321 => '41.1' },
	'moviefunctionbuttonplusdials' => { 309 => '52.1' },
	'moviehighisonoisereduction' => { 247 => 0x23c, 248 => 0x336, 249 => 0x336, 250 => 0x2ba, 251 => 0x2e2, 252 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 325 => 0x215, 326 => 0x215, 327 => 0x22d },
	'moviehighreszoom' => { 248 => 0x380, 249 => 0x380, 251 => 0x32c, 252 => 0x32c },
	'movieimagearea' => { 248 => 0x2da, 249 => 0x2da, 250 => 0x25c, 251 => 0x286, 252 => 0x286 },
	'movieisoautocontrolmanualmode' => { 248 => 0x2e8, 249 => 0x2e8, 250 => 0x26a, 251 => 0x294, 252 => 0x294 },
	'movieisoautohilimit' => { 248 => 0x2e6, 249 => 0x2e6, 250 => 0x268, 251 => 0x292, 252 => 0x292 },
	'movieisoautomanualmode' => { 247 => 0x204, 248 => 0x2ea, 249 => 0x2ea, 250 => 0x26c, 251 => 0x296, 252 => 0x296 },
	'movielenscontrolring' => { 324 => 0xdf, 325 => 0xd7, 326 => 0xd7, 327 => 0xd7 },
	'moviemeteringmode' => { 248 => 0x33e, 249 => 0x33e, 250 => 0x2c2, 251 => 0x2ea, 252 => 0x2ea },
	'moviemidtonedisplayrange' => { 325 => 0x219, 326 => 0x219, 327 => 0x231 },
	'moviemidtonedisplayvalue' => { 325 => 0x217, 326 => 0x217, 327 => 0x22f },
	'moviemultiselector' => { 324 => 0xe1, 325 => 0xd9, 326 => 0xcf, 327 => 0xcf },
	'moviepreviewbutton' => { 309 => '41.2', 311 => '41.2', 312 => '41.2', 321 => '41.2', 322 => '41.2' },
	'moviepreviewbuttonplusdials' => { 309 => '52.2' },
	'movierecordbuttonplaybackmode' => { 324 => 0x1af, 325 => 0x1b5, 326 => 0x1b5, 327 => 0x1cd },
	'movieshutterbutton' => { 309 => '38.3', 311 => '38.3', 312 => '38.3', 321 => '38.3', 322 => '38.3' },
	'movieshutterspeedlock' => { 325 => 0x225, 326 => 0x225, 327 => 0x23d },
	'movieslowmotion' => { 246 => 0x416, 247 => 0x1fa },
	'moviesoundrecording' => { 248 => 0x34a, 249 => 0x34a, 250 => 0x2ce, 251 => 0x2f6, 252 => 0x2f6 },
	'moviesubjectdetection' => { 248 => 0x378, 249 => 0x378, 250 => 0x2fc, 251 => 0x324, 252 => 0x324 },
	'moviesubselectorassignment' => { 309 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 309 => '53.1' },
	'movietonemap' => { 250 => 0x2ec, 251 => 0x314, 252 => 0x314 },
	'movietype' => { 231 => 0x2ca, 246 => 0x41a, 247 => 0x1fe, 248 => 0x2e4, 249 => 0x2e4, 250 => 0x266, 251 => 0x290, 252 => 0x290 },
	'movievibrationreduction' => { 247 => 0x24e },
	'movievibrationreductionsameasphoto' => { 247 => 0x24f },
	'movievignettecontrol' => { 247 => 0x23e, 248 => 0x1b0, 249 => 0x1b0, 250 => 0x1a0, 251 => 0x1b4, 252 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 247 => 0x240 },
	'movievrmode' => { 248 => 0x344, 249 => 0x344, 250 => 0x2c8, 251 => 0x2f0, 252 => 0x2f0 },
	'moviezebrapattern' => { 325 => 0x213, 326 => 0x213, 327 => 0x22b },
	'multiburstimageheight' => { 455 => 0x1002 },
	'multiburstimagewidth' => { 455 => 0x1001 },
	'multiburstmode' => { 455 => 0x1000 },
	'multicontrollerwhilemetering' => { 89 => 0x517 },
	'multiexposure' => { 72 => 0x1, 353 => 0xb4 },
	'multiexposureautogain' => { 254 => 0x3 },
	'multiexposurecontrol' => { 72 => 0x2 },
	'multiexposuremode' => { 254 => 0x1, 255 => 0x1 },
	'multiexposureoverlaymode' => { 255 => 0x3 },
	'multiexposureshots' => { 72 => 0x3, 246 => 0x1be, 248 => 0x9a, 249 => 0x9a, 250 => 0x8e, 251 => 0x9c, 252 => 0x9c, 254 => 0x2, 255 => 0x2 },
	'multiframenoisereduction' => { 443 => 0x35, 455 => 0x200b, 460 => 0x15 },
	'multiframenreffect' => { 455 => 0x2023 },
	'multifunctionlock' => { 89 => 0x70f },
	'multipleexposuremode' => { 246 => 0x1bc, 248 => 0x98, 249 => 0x98, 250 => 0x8c, 251 => 0x9a, 252 => 0x9a, 333 => 0x101c },
	'multipleexposureset' => { 369 => '10.1' },
	'multisample' => { 267 => 0x40 },
	'multiselector' => { 308 => '9.4', 309 => '10.3', 311 => '10.3', 312 => '10.3', 317 => '27.4', 321 => '10.3', 322 => '10.3' },
	'multiselectorliveview' => { 308 => '4.3', 311 => '37.1', 312 => '37.1', 321 => '37.1', 322 => '37.1' },
	'multiselectorliveviewmode' => { 281 => 0x18c2 },
	'multiselectorplaybackmode' => { 308 => ['13.5','9.2'], 309 => '10.2', 312 => '10.2', 317 => '27.2', 321 => '10.2', 322 => '10.2', 324 => 0xb7, 325 => 0xb3, 326 => 0xb3, 327 => 0xb3 },
	'multiselectorshootmode' => { 308 => '9.1', 309 => '10.1', 311 => '10.1', 312 => '10.1', 317 => '27.1', 321 => '10.1', 322 => '10.1', 324 => 0xb3, 325 => 0xaf, 326 => 0xaf, 327 => 0xaf },
	'multishot' => { 358 => 0x121 },
	'mute' => { 408 => 'player.movie.audio.mute' },
	'mycolormode' => { 73 => 0x2 },
	'name' => { 414 => 'name', 518 => 'Name', 520 => 'Name' },
	'narrator' => { 406 => "\xa9nrt" },
	'nationalcatalognumber' => { 537 => 'nationalCatalogNumber' },
	'nativedigest' => { 524 => 'NativeDigest', 543 => 'NativeDigest' },
	'ndfilter' => { 81 => 0x1c, 329 => 0x204, 421 => 0x1019 },
	'near' => { 503 => 'Near' },
	'nefbitdepth' => { 242 => 0xe22 },
	'nefcompression' => { 242 => 0x93, 243 => 0xa },
	'neflinearizationtable' => { 242 => 0x96 },
	'negativecachelargepreviewsize' => { 518 => 'NegativeCacheLargePreviewSize', 520 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 518 => 'NegativeCacheMaximumSize', 520 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 518 => 'NegativeCachePath', 520 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 515 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 389 => 0x88 },
	'neutraloutputhighlightpoint' => { 114 => 0x2f },
	'neutraloutputshadowpoint' => { 114 => 0x30 },
	'neutralrawcolortone' => { 114 => 0x28 },
	'neutralrawcontrast' => { 114 => 0x2a },
	'neutralrawhighlight' => { 114 => 0x78 },
	'neutralrawhighlightpoint' => { 114 => 0x2d },
	'neutralrawlinear' => { 114 => 0x2b },
	'neutralrawsaturation' => { 114 => 0x29 },
	'neutralrawshadow' => { 114 => 0x81 },
	'neutralrawshadowpoint' => { 114 => 0x2e },
	'neutralrawsharpness' => { 114 => 0x2c },
	'neutralunsharpmaskfineness' => { 114 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 114 => 0xa8 },
	'neutraunsharpmaskstrength' => { 114 => 0xa4 },
	'newlensdata' => { 240 => 0x2f },
	'newrawimagedigest' => { 124 => 0xc7a7 },
	'newsphotoversion' => { 139 => 0x0 },
	'nickname' => { 545 => 'Nickname' },
	'nikoncapturedata' => { 242 => 0xe01 },
	'nikoncaptureeditversions' => { 242 => 0xe13 },
	'nikoncaptureoffsets' => { 242 => 0xe0e },
	'nikoncaptureoutput' => { 242 => 0xe1e },
	'nikoncaptureversion' => { 242 => 0xe09 },
	'nikoniccprofile' => { 242 => 0xe1d },
	'nikonimagesize' => { 278 => '723.1', 279 => '732.1', 287 => 0x2c4 },
	'nikonmeteringmode' => { 205 => 0x17, 246 => 0x2d2, 247 => 0x146, 258 => 0x214 },
	'nikonsettings' => { 242 => 0x4e },
	'noisefilter' => { 329 => 0x527 },
	'noiseprofile' => { 124 => 0xc761 },
	'noisereduction' => { 132 => [0x100b,0x100e], 188 => 0xb0, 189 => 0x60, 190 => 0x3f, 242 => 0x95, 301 => 0x753dcbc0, 302 => 0x17, 329 => 0x50a, 334 => 0x103a, 353 => 0x2d, 389 => 0x49, 421 => 0x100f, 423 => 0x2a },
	'noisereduction2' => { 333 => 0x1010 },
	'noisereductionapplied' => { 124 => 0xc6f7 },
	'noisereductionintensity' => { 302 => 0x9 },
	'noisereductionmethod' => { 302 => 0x11 },
	'noisereductionmode' => { 492 => 0x801e },
	'noisereductionparametersatcapture' => { 144 => 0xe73 },
	'noisereductionparameterscamera' => { 144 => 0xe72 },
	'noisereductionparametershost3mp' => { 144 => 0xe71 },
	'noisereductionparametershost6mp' => { 144 => 0xe70 },
	'noisereductionparametershostrgb' => { 144 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 144 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 144 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 144 => 0xe63 },
	'noisereductionparams' => { 358 => 0x1b },
	'noisereductionsharpness' => { 302 => 0xd },
	'noisereductionstrength' => { 353 => 0xd6 },
	'noisereductionvalue' => { 492 => 0x8027 },
	'nomemorycard' => { 308 => '22.1', 309 => '4.2', 310 => '0.3', 313 => '2.4', 314 => '3.2', 315 => '3.2', 317 => '33.7', 318 => '3.2', 319 => '0.3', 321 => '4.2', 323 => '4.5' },
	'nominalmaxaperture' => { 379 => 0xa },
	'nominalminaperture' => { 379 => '10.1' },
	'noncpulens10focallength' => { 248 => 0x6c6, 249 => 0x6d6, 252 => 0x620 },
	'noncpulens10maxaperture' => { 248 => 0x6ee, 249 => 0x738, 252 => 0x670 },
	'noncpulens11focallength' => { 248 => 0x6c8, 249 => 0x6d8, 252 => 0x624 },
	'noncpulens11maxaperture' => { 248 => 0x6f0, 249 => 0x73c, 252 => 0x674 },
	'noncpulens12focallength' => { 248 => 0x6ca, 249 => 0x6da, 252 => 0x628 },
	'noncpulens12maxaperture' => { 248 => 0x6f2, 249 => 0x740, 252 => 0x678 },
	'noncpulens13focallength' => { 248 => 0x6cc, 249 => 0x6dc, 252 => 0x62c },
	'noncpulens13maxaperture' => { 248 => 0x6f4, 249 => 0x744, 252 => 0x67c },
	'noncpulens14focallength' => { 248 => 0x6ce, 249 => 0x6de, 252 => 0x630 },
	'noncpulens14maxaperture' => { 248 => 0x6f6, 249 => 0x748, 252 => 0x680 },
	'noncpulens15focallength' => { 248 => 0x6d0, 249 => 0x6e0, 252 => 0x634 },
	'noncpulens15maxaperture' => { 248 => 0x6f8, 249 => 0x74c, 252 => 0x684 },
	'noncpulens16focallength' => { 248 => 0x6d2, 249 => 0x6e2, 252 => 0x638 },
	'noncpulens16maxaperture' => { 248 => 0x6fa, 249 => 0x750, 252 => 0x688 },
	'noncpulens17focallength' => { 248 => 0x6d4, 249 => 0x6e4, 252 => 0x63c },
	'noncpulens17maxaperture' => { 248 => 0x6fc, 249 => 0x754, 252 => 0x68c },
	'noncpulens18focallength' => { 248 => 0x6d6, 249 => 0x6e6, 252 => 0x640 },
	'noncpulens18maxaperture' => { 248 => 0x6fe, 249 => 0x758, 252 => 0x690 },
	'noncpulens19focallength' => { 248 => 0x6d8, 249 => 0x6e8, 252 => 0x644 },
	'noncpulens19maxaperture' => { 248 => 0x700, 249 => 0x75c, 252 => 0x694 },
	'noncpulens1focallength' => { 248 => 0x6b4, 249 => 0x6c4, 252 => 0x5fc },
	'noncpulens1maxaperture' => { 248 => 0x6dc, 249 => 0x714, 252 => 0x64c },
	'noncpulens20focallength' => { 248 => 0x6da, 249 => 0x6ea, 252 => 0x648 },
	'noncpulens20maxaperture' => { 248 => 0x702, 249 => 0x760, 252 => 0x698 },
	'noncpulens2focallength' => { 248 => 0x6b6, 249 => 0x6c6, 252 => 0x600 },
	'noncpulens2maxaperture' => { 248 => 0x6de, 249 => 0x718, 252 => 0x650 },
	'noncpulens3focallength' => { 248 => 0x6b8, 249 => 0x6c8, 252 => 0x604 },
	'noncpulens3maxaperture' => { 248 => 0x6e0, 249 => 0x71c, 252 => 0x654 },
	'noncpulens4focallength' => { 248 => 0x6ba, 249 => 0x6ca, 252 => 0x608 },
	'noncpulens4maxaperture' => { 248 => 0x6e2, 252 => 0x658 },
	'noncpulens5focallength' => { 248 => 0x6bc, 249 => 0x6cc, 252 => 0x60c },
	'noncpulens5maxaperture' => { 248 => 0x6e4, 249 => 0x724, 252 => 0x65c },
	'noncpulens6focallength' => { 248 => 0x6be, 249 => 0x6ce, 252 => 0x610 },
	'noncpulens6maxaperture' => { 248 => 0x6e6, 249 => 0x728, 252 => 0x660 },
	'noncpulens7focallength' => { 248 => 0x6c0, 249 => 0x6d0, 252 => 0x614 },
	'noncpulens7maxaperture' => { 248 => 0x6e8, 249 => 0x72c, 252 => 0x664 },
	'noncpulens8focallength' => { 248 => 0x6c2, 249 => 0x6d2, 252 => 0x618 },
	'noncpulens8maxaperture' => { 248 => 0x6ea, 249 => 0x730, 252 => 0x668 },
	'noncpulens9focallength' => { 248 => 0x6c4, 249 => 0x6d4, 252 => 0x61c },
	'noncpulens9maxaperture' => { 248 => 0x6ec, 249 => 0x734, 252 => 0x66c },
	'normalizedcropcorners' => { 343 => 'NormalizedCropCorners' },
	'normallinetime' => { 144 => 0x186a },
	'normalwhitelevel' => { 43 => 0x32a, 44 => 0x280, 45 => 0x294, 48 => [0x2b8,0x2cf,0x2d3], 49 => 0x569, 50 => 0x1e3, 51 => [0x1fc,0x2dc], 52 => [0x230,0x30e], 53 => 0x31c },
	'notes' => { 494 => 'Notes', 513 => 'notes' },
	'npages' => { 552 => 'NPages' },
	'nullrecord' => { 102 => 0x0 },
	'numafpoints' => { 365 => 0x2 },
	'number' => { 537 => 'number' },
	'numberofbeats' => { 547 => 'numberOfBeats' },
	'numberoffocuspoints' => { 311 => '1.3', 312 => '1.3', 315 => '0.2', 316 => '0.3', 318 => '0.3' },
	'numfaceelements' => { 132 => 0x4200 },
	'numfacepositions' => { 345 => 0x0 },
	'numindexentries' => { 139 => 0x54 },
	'numwbentries' => { 359 => 0x0, 360 => 0x0 },
	'object' => { 537 => 'object' },
	'objectattributereference' => { 137 => 0x4 },
	'objectcycle' => { 137 => 0x4b, 513 => 'ObjectCycle' },
	'objectdescription' => { 536 => 'objectDescription' },
	'objectdistance' => { 117 => 0x6, 118 => 0x2022 },
	'objectname' => { 137 => 0x5 },
	'objectpreviewdata' => { 137 => 0xca },
	'objectpreviewfileformat' => { 137 => 0xc8 },
	'objectpreviewfileversion' => { 137 => 0xc9 },
	'objectsubtype' => { 536 => 'objectSubtype' },
	'objecttype' => { 536 => 'objectType' },
	'objecttypereference' => { 137 => 0x3 },
	'occurrence' => { 123 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 123 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 123 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 123 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 123 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 123 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 123 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 123 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 123 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 123 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 123 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 123 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 123 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 123 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 123 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 123 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 123 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 123 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 123 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 123 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 123 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 123 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 123 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 123 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 123 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 123 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 123 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 123 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 123 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 123 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 524 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 524 => [\'OECF','OECFNames'] },
	'oecfrows' => { 524 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 524 => [\'OECF','OECFValues'] },
	'offsaledate' => { 537 => 'offSaleDate' },
	'offsaledatea-platform' => { 537 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 537 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 144 => 0x190a },
	'offsethdr' => { 529 => 'OffsetHDR' },
	'offsetschema' => { 124 => 0xea1d },
	'offsetsdr' => { 529 => 'OffsetSDR' },
	'offsettime' => { 124 => 0x9010 },
	'offsettimedigitized' => { 124 => 0x9012 },
	'offsettimeoriginal' => { 124 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 318 => '15.1', 323 => '16.1' },
	'oldsubfiletype' => { 124 => 0xff },
	'olympusimageheight' => { 334 => 0x102f },
	'olympusimagewidth' => { 334 => 0x102e },
	'omenatcapturestrength' => { 144 => 0xa60 },
	'omenautostrength' => { 144 => 0xa5f },
	'omenearlystrength' => { 144 => 0xa5e },
	'omenfocallengthlimit' => { 144 => 0xa62 },
	'omeninitialipfstrength' => { 144 => 0xa5d },
	'omensurfaceindex' => { 144 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 334 => 0x302 },
	'onsaledate' => { 537 => 'onSaleDate' },
	'onsaledatea-platform' => { 537 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 537 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 537 => 'onSaleDay' },
	'onsaledaya-platform' => { 537 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 537 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 124 => 0xc740 },
	'opcodelist2' => { 124 => 0xc741 },
	'opcodelist3' => { 124 => 0xc74e },
	'opticalzoom' => { 148 => 0xfa3d, 150 => [0x6006,0xf006], 151 => 0x1000, 152 => 0xf, 155 => 0x1e, 157 => 0x20, 158 => 0x1c, 169 => 'OpticalZoom' },
	'opticalzoomcode' => { 81 => 0xa },
	'opticalzoommode' => { 353 => 0x34 },
	'opticalzoomon' => { 430 => 0x219 },
	'optionenddate' => { 540 => 'optionEndDate' },
	'opto-electricconvfactor' => { 524 => 'OECF' },
	'orangehsl' => { 108 => 0x20911 },
	'ordernumber' => { 132 => 0x8002 },
	'organisationinimagecode' => { 532 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 532 => 'OrganisationInImageName' },
	'organism' => { 123 => 'Organism' },
	'organismassociatedoccurrences' => { 123 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 123 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 123 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 123 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 123 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 123 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 123 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 537 => 'organization' },
	'orientation' => { 124 => 0x112, 358 => 0x112, 536 => 'orientation', 543 => 'Orientation' },
	'orientation2' => { 460 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 89 => 0x516 },
	'originalalbumtitle' => { 185 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 185 => 'WM/OriginalArtist', 406 => "\xa9ope" },
	'originalbestqualitysize' => { 124 => 0xc792 },
	'originalcreatedatetime' => { 508 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 119 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 68 => 0x83 },
	'originaldefaultcropsize' => { 124 => 0xc793 },
	'originaldefaultfinalsize' => { 124 => 0xc791 },
	'originaldirectory' => { 350 => 0x408 },
	'originaldocumentid' => { 548 => 'OriginalDocumentID' },
	'originalfilename' => { 102 => 0x816, 144 => 0x3e9, 156 => 0x20, 350 => 0x407, 508 => 'OriginalFilename' },
	'originalimagehash' => { 497 => 'OriginalImageHash' },
	'originalimagehashtype' => { 497 => 'OriginalImageHashType' },
	'originalimageheight' => { 83 => 0xc, 128 => 0x1 },
	'originalimagemd5' => { 497 => 'OriginalImageMD5' },
	'originalimagesize' => { 168 => 'OriginalImageSize' },
	'originalimagewidth' => { 83 => 0xb, 128 => 0x0 },
	'originallyricist' => { 185 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 124 => 0xc68c },
	'originalrawfiledigest' => { 124 => 0xc71d },
	'originalrawfilename' => { 124 => 0xc68b },
	'originaltransmissionreference' => { 137 => 0x67 },
	'originatingprogram' => { 137 => 0x41, 513 => 'OriginatingProgram' },
	'originplatform' => { 537 => 'originPlatform' },
	'os' => { 522 => 'os' },
	'otherconditions' => { 339 => 'OtherConditions' },
	'otherconstraints' => { 339 => 'OtherConstraints' },
	'otherimage' => { 119 => 'Exif-OtherImage' },
	'otherimageinfo' => { 339 => 'OtherImageInfo' },
	'otherimagelength' => { 124 => 0x202 },
	'otherimagestart' => { 124 => 0x201 },
	'otherlicensedocuments' => { 339 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 339 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 339 => 'OtherLicenseRequirements' },
	'outcue' => { 547 => 'outCue' },
	'outcuescale' => { 547 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 547 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 206 => 0x3 },
	'outputimagewidth' => { 206 => 0x2 },
	'outputlut' => { 353 => 0xa7 },
	'outputprofile' => { 144 => 0x138b },
	'outputresolution' => { 206 => 0x4 },
	'overclockcols' => { 144 => 0x189c },
	'overclockrows' => { 144 => 0x18c4 },
	'overridelookvignette' => { 518 => 'OverrideLookVignette', 520 => 'OverrideLookVignette' },
	'owner' => { 406 => 'ownr', 551 => 'Owner' },
	'ownerid' => { 137 => 0xbc },
	'ownername' => { 15 => 0x10f, 68 => 0x9, 102 => 0x810, 124 => [0xa430,0xfde8], 162 => 'OwnerName', 515 => 'OwnerName', 525 => 'CameraOwnerName' },
	'padding' => { 124 => 0xea1c },
	'pagecount' => { 537 => 'pageCount' },
	'pageimage' => { 545 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 545 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 545 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 545 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 545 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 545 => 'PageInfo' },
	'pagename' => { 124 => 0x11d },
	'pagenumber' => { 124 => 0x129 },
	'pageprogressiondirection' => { 537 => 'pageProgressionDirection' },
	'pagerange' => { 537 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 518 => 'PaintBasedCorrections', 520 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 518 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 520 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 356 => 0x0 },
	'panasonicexifversion' => { 353 => 0x26 },
	'panasonicimageheight' => { 353 => 0x4c },
	'panasonicimagewidth' => { 353 => 0x4b },
	'panasonicrawversion' => { 358 => 0x1 },
	'panasonictitle' => { 124 => 0xc6d2 },
	'panasonictitle2' => { 124 => 0xc6d3 },
	'panoramaangle' => { 132 => 0x1153 },
	'panoramacropbottom' => { 461 => 0x7 },
	'panoramacropleft' => { 461 => 0x4 },
	'panoramacropright' => { 461 => 0x6 },
	'panoramacroptop' => { 461 => 0x5 },
	'panoramadirection' => { 76 => 0x5, 132 => 0x1154, 461 => 0x3 },
	'panoramaframeheight' => { 461 => 0x9 },
	'panoramaframenumber' => { 76 => 0x2 },
	'panoramaframewidth' => { 461 => 0x8 },
	'panoramafullheight' => { 461 => 0x2 },
	'panoramafullwidth' => { 461 => 0x1 },
	'panoramamode' => { 146 => 0x3c, 329 => 0x601 },
	'panoramasize3d' => { 443 => 0x38 },
	'panoramasourceheight' => { 461 => 0xb },
	'panoramasourcewidth' => { 461 => 0xa },
	'panoramicstitchcameramotion' => { 182 => 'PanoramicStitchCameraMotion', 183 => 0x1 },
	'panoramicstitchmaptype' => { 182 => 'PanoramicStitchMapType', 183 => 0x2 },
	'panoramicstitchphi0' => { 182 => 'PanoramicStitchPhi0', 183 => 0x5 },
	'panoramicstitchphi1' => { 182 => 'PanoramicStitchPhi1', 183 => 0x6 },
	'panoramicstitchtheta0' => { 182 => 'PanoramicStitchTheta0', 183 => 0x3 },
	'panoramicstitchtheta1' => { 182 => 'PanoramicStitchTheta1', 183 => 0x4 },
	'panoramicstitchversion' => { 183 => 0x0 },
	'pantry' => { 548 => 'Pantry' },
	'pantryinstanceid' => { 548 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 132 => 0xb211, 328 => 0x28 },
	'parameters' => { 342 => 'parameters' },
	'parametricdarks' => { 518 => 'ParametricDarks', 520 => 'ParametricDarks' },
	'parametrichighlights' => { 518 => 'ParametricHighlights', 520 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 518 => 'ParametricHighlightSplit', 520 => 'ParametricHighlightSplit' },
	'parametriclights' => { 518 => 'ParametricLights', 520 => 'ParametricLights' },
	'parametricmidtonesplit' => { 518 => 'ParametricMidtoneSplit', 520 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 518 => 'ParametricShadows', 520 => 'ParametricShadows' },
	'parametricshadowsplit' => { 518 => 'ParametricShadowSplit', 520 => 'ParametricShadowSplit' },
	'parentalrating' => { 185 => 'WM/ParentalRating' },
	'parentid' => { 532 => 'parentId' },
	'parentmediaeventid' => { 508 => 'ParentMediaEventID' },
	'parentmeid' => { 508 => 'ParentMEID' },
	'parentproductid' => { 406 => '@ppi' },
	'parentreference1' => { 530 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 530 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 406 => '@PST' },
	'parenttitle' => { 406 => '@pti' },
	'partialactivecols1' => { 144 => 0x17e8 },
	'partialactivecols2' => { 144 => 0x17f2 },
	'partialactiverows1' => { 144 => 0x17fc },
	'partialactiverows2' => { 144 => 0x1806 },
	'partofcompilation' => { 547 => 'partOfCompilation' },
	'patientbirthdate' => { 495 => 'PatientDOB' },
	'patientid' => { 495 => 'PatientID' },
	'patientname' => { 495 => 'PatientName' },
	'patientsex' => { 495 => 'PatientSex' },
	'patternareaheight' => { 144 => 0x963 },
	'patternareawidth' => { 144 => 0x962 },
	'patterncorrectionfactorscale' => { 144 => 0x969 },
	'patterncropcols1' => { 144 => 0x96c },
	'patterncropcols2' => { 144 => 0x96d },
	'patterncroprows1' => { 144 => 0x96a },
	'patterncroprows2' => { 144 => 0x96b },
	'patternimagerheight' => { 144 => 0x961 },
	'patternimagerwidth' => { 144 => 0x960 },
	'patternx' => { 144 => 0x966 },
	'patterny' => { 144 => 0x967 },
	'pdfversion' => { 534 => 'PDFVersion' },
	'pentaximagesize' => { 389 => 0x9 },
	'pentaxmodelid' => { 368 => 0x0, 389 => 0x5 },
	'pentaxmodeltype' => { 389 => 0x1 },
	'pentaxversion' => { 389 => 0x0 },
	'people' => { 498 => 'People', 511 => 'People' },
	'perchannelblacklevel' => { 43 => 0x157, 44 => 0x16b, 45 => 0x17f, 47 => 0xc4, 48 => [0x2b4,0x2cb,0x2cf], 49 => [0x108,0x14d], 50 => 0x1df, 51 => [0x1f8,0x2d8], 52 => [0x22c,0x30a], 53 => 0x149 },
	'performer' => { 406 => 'perf', 414 => 'perf' },
	'performerkeywords' => { 414 => "\xa9prk" },
	'performers' => { 414 => "\xa9prf" },
	'performerurl' => { 414 => "\xa9prl" },
	'period' => { 185 => 'WM/Period' },
	'peripheralillumcentralradius' => { 492 => 0x8030 },
	'peripheralillumcentralvalue' => { 492 => 0x8031 },
	'peripheralillumination' => { 108 => 0x20702, 114 => 0x68 },
	'peripheralilluminationcorr' => { 66 => 0x1, 378 => 0x2 },
	'peripheralilluminationon' => { 108 => '0x20702.0', 114 => 0x64 },
	'peripheralillumperiphvalue' => { 492 => 0x8032 },
	'peripherallighting' => { 83 => 0x2, 132 => 0x3804 },
	'peripherallightingsetting' => { 84 => 0x5 },
	'peripherallightingvalue' => { 83 => 0x6 },
	'permissions' => { 540 => 'permissions' },
	'permits' => { 516 => 'permits' },
	'person' => { 537 => 'person' },
	'personality' => { 508 => 'Personality' },
	'personheard' => { 532 => 'PersonHeard' },
	'personheardidentifier' => { 532 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 532 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 532 => 'PersonInImage' },
	'personinimagecharacteristic' => { 532 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 532 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 532 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 532 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 532 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 532 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 532 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 532 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 532 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 518 => 'PerspectiveAspect', 520 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 518 => 'PerspectiveHorizontal', 520 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 518 => 'PerspectiveRotate', 520 => 'PerspectiveRotate' },
	'perspectivescale' => { 518 => 'PerspectiveScale', 520 => 'PerspectiveScale' },
	'perspectiveupright' => { 518 => 'PerspectiveUpright', 520 => 'PerspectiveUpright' },
	'perspectivevertical' => { 518 => 'PerspectiveVertical', 520 => 'PerspectiveVertical' },
	'perspectivex' => { 518 => 'PerspectiveX', 520 => 'PerspectiveX' },
	'perspectivey' => { 518 => 'PerspectiveY', 520 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 97 => 0x1 },
	'pf10retainprogramshift' => { 97 => 0xb },
	'pf13drivepriority' => { 97 => 0xe },
	'pf14disablefocussearch' => { 97 => 0xf },
	'pf15disableafassistbeam' => { 97 => 0x10 },
	'pf16autofocuspointshoot' => { 97 => 0x11 },
	'pf17disableafpointsel' => { 97 => 0x12 },
	'pf18enableautoafpointsel' => { 97 => 0x13 },
	'pf19continuousshootspeed' => { 97 => 0x14 },
	'pf19shootingspeedhigh' => { 96 => 0xa },
	'pf19shootingspeedlow' => { 96 => 0x9 },
	'pf1disableshootingmodes' => { 97 => 0x2 },
	'pf1value' => { 96 => 0x1 },
	'pf20limitcontinousshots' => { 97 => 0x15 },
	'pf20maxcontinousshots' => { 96 => 0xb },
	'pf21enablequietoperation' => { 97 => 0x16 },
	'pf23felocktime' => { 96 => 0xd },
	'pf23postreleasetime' => { 96 => 0xe },
	'pf23settimerlengths' => { 97 => 0x18 },
	'pf23shutterbuttontime' => { 96 => 0xc },
	'pf24lightlcdduringbulb' => { 97 => 0x19 },
	'pf25aemode' => { 96 => 0xf },
	'pf25afmode' => { 96 => 0x12 },
	'pf25afpointsel' => { 96 => 0x13 },
	'pf25colormatrix' => { 96 => 0x17 },
	'pf25defaultclearsettings' => { 97 => 0x1a },
	'pf25drivemode' => { 96 => 0x11 },
	'pf25imagesize' => { 96 => 0x14 },
	'pf25meteringmode' => { 96 => 0x10 },
	'pf25parameters' => { 96 => 0x16 },
	'pf25wbmode' => { 96 => 0x15 },
	'pf26shortenreleaselag' => { 97 => 0x1b },
	'pf27reversedialrotation' => { 97 => 0x1c },
	'pf27value' => { 96 => 0x18 },
	'pf28noquickdialexpcomp' => { 97 => 0x1d },
	'pf29quickdialswitchoff' => { 97 => 0x1e },
	'pf2disablemeteringmodes' => { 97 => 0x3 },
	'pf2value' => { 96 => 0x2 },
	'pf30enlargementmode' => { 97 => 0x1f },
	'pf31originaldecisiondata' => { 97 => 0x20 },
	'pf3manualexposuremetering' => { 97 => 0x4 },
	'pf3value' => { 96 => 0x3 },
	'pf4exposuretimelimits' => { 97 => 0x5 },
	'pf4exposuretimemax' => { 96 => 0x5 },
	'pf4exposuretimemin' => { 96 => 0x4 },
	'pf5aperturelimits' => { 97 => 0x6 },
	'pf5aperturemax' => { 96 => 0x7 },
	'pf5aperturemin' => { 96 => 0x6 },
	'pf6presetshootingmodes' => { 97 => 0x7 },
	'pf7bracketcontinuousshoot' => { 97 => 0x8 },
	'pf8bracketshots' => { 96 => 0x8 },
	'pf8setbracketshots' => { 97 => 0x9 },
	'pf9changebracketsequence' => { 97 => 0xa },
	'phasedetectaf' => { 199 => 0x6 },
	'phonenumber' => { 163 => 'Phone' },
	'photoeffect' => { 36 => 0x28 },
	'photoeffecthistoryxml' => { 301 => 0xe9651831 },
	'photoeffects' => { 301 => 0xab5eca5e },
	'photoeffectsblue' => { 303 => 0x8 },
	'photoeffectsgreen' => { 303 => 0x6 },
	'photoeffectsred' => { 303 => 0x4 },
	'photoeffectstype' => { 303 => 0x0 },
	'photographer' => { 124 => 0xa437, 525 => 'Photographer' },
	'photographicsensitivity' => { 525 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 308 => '17.6', 317 => '33.6' },
	'photometricinterpretation' => { 124 => 0x106, 543 => 'PhotometricInterpretation' },
	'photosappfeatureflags' => { 1 => 0x1f },
	'photoshootingmenubank' => { 248 => 0x11e, 249 => 0x11e, 250 => 0x112, 251 => 0x122, 252 => 0x122, 253 => 0x24, 271 => 0x0 },
	'photoshootingmenubankimagearea' => { 245 => 0x6dd, 248 => 0x144, 249 => 0x144, 250 => 0x134, 251 => 0x148, 252 => 0x148, 271 => '7.1' },
	'photoshopbgrthumbnail' => { 403 => 0x409 },
	'photoshopquality' => { 402 => 0x0 },
	'photoshopthumbnail' => { 403 => 0x40c },
	'photostyle' => { 353 => 0x89 },
	'picasawebgphotoid' => { 523 => 'picasawebGPhotoId' },
	'pick' => { 547 => 'pick' },
	'picklabel' => { 523 => 'PickLabel' },
	'pictinfo' => { 430 => 0x208 },
	'picturecontrol' => { 301 => 0xe2173c47 },
	'picturecontrolactive' => { 304 => 0x0 },
	'picturecontroladjust' => { 259 => 0x30, 260 => 0x30, 261 => 0x36 },
	'picturecontrolbase' => { 259 => 0x18, 260 => 0x18, 261 => 0x1c },
	'picturecontroldata' => { 242 => [0xbd,0x23] },
	'picturecontrolmode' => { 304 => 0x13 },
	'picturecontrolname' => { 259 => 0x4, 260 => 0x4, 261 => 0x8 },
	'picturecontrolquickadjust' => { 259 => 0x31, 260 => 0x31, 261 => 0x37 },
	'pictureeffect' => { 455 => 0x200e },
	'pictureeffect2' => { 464 => 0x1163, 465 => 0x1167, 466 => 0x1143, 467 => 0x11bf, 468 => 0x119b, 469 => 0x1053, 470 => 0x24b, 471 => 0x24b, 472 => 0x23c, 487 => 0x46 },
	'picturefinish' => { 188 => 0x71 },
	'picturemode' => { 132 => 0x1031, 329 => 0x520, 389 => [0xb,0x33], 431 => 0x3d },
	'picturemode2' => { 369 => 0x0 },
	'picturemodebwfilter' => { 329 => 0x525 },
	'picturemodecontrast' => { 329 => 0x523 },
	'picturemodeeffect' => { 329 => 0x52d },
	'picturemodehue' => { 329 => 0x522 },
	'picturemodesaturation' => { 329 => 0x521 },
	'picturemodesharpness' => { 329 => 0x524 },
	'picturemodetone' => { 329 => 0x526 },
	'pictureprofile' => { 464 => [0x115e,0x115f], 465 => [0x1162,0x1163], 466 => [0x113e,0x113f], 467 => [0x11ba,0x11bb], 468 => [0x1196,0x1197], 469 => [0x104e,0x104f], 470 => [0x246,0x247], 471 => [0x246,0x247], 472 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 78 => 0xa, 108 => 0x20301, 114 => 0x2 },
	'picturestylepc' => { 68 => 0x4009 },
	'picturestyleuserdef' => { 68 => 0x4008 },
	'picturewizard' => { 428 => 0x21 },
	'picturewizardcolor' => { 427 => 0x1 },
	'picturewizardcontrast' => { 427 => 0x4 },
	'picturewizardmode' => { 427 => 0x0 },
	'picturewizardsaturation' => { 427 => 0x2 },
	'picturewizardsharpness' => { 427 => 0x3 },
	'pipelineversion' => { 182 => 'PipelineVersion' },
	'pitch' => { 120 => 0x6, 309 => '4.1', 321 => '4.1', 414 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 65 => 0x5, 257 => 0x4, 329 => 0x904, 343 => 'PitchAngle', 353 => 0x91, 387 => 0x2, 388 => 0x5, 426 => 0x1 },
	'pitchshift' => { 408 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 407 => 'pasp' },
	'pixelclockfrequency' => { 144 => 0x40b },
	'pixelcorrectionoffset' => { 144 => 0x972 },
	'pixelcorrectionscale' => { 144 => 0x971 },
	'pixelscale' => { 124 => 0x830e },
	'pixelshiftdelay' => { 246 => 0x38c, 249 => 0x802 },
	'pixelshiftinfo' => { 455 => 0x202f },
	'pixelshiftinterval' => { 246 => 0x38e },
	'pixelshiftnumbershots' => { 246 => 0x38a, 249 => 0x800 },
	'pixelshiftoffset' => { 132 => 0x1106 },
	'pixelshiftresolution' => { 390 => 0x0 },
	'pixelshiftshooting' => { 246 => 0x388, 249 => 0x7fe },
	'pixelshiftshots' => { 132 => 0x1105 },
	'pixelsperunitx' => { 341 => 0x0 },
	'pixelsperunity' => { 341 => 0x4 },
	'pixelunits' => { 341 => 0x8 },
	'planarconfiguration' => { 124 => 0x11c, 543 => 'PlanarConfiguration' },
	'plane' => { 496 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 496 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 496 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 496 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 496 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 496 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 496 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 496 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 496 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 496 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 496 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 496 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 496 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 496 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 496 => 'Planes' },
	'planningref' => { 532 => 'PlanningRef' },
	'planningrefidentifier' => { 532 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 532 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 532 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 552 => 'PlateNames' },
	'platform' => { 537 => 'platform' },
	'playallframes' => { 414 => 'AllF' },
	'playbackbutton' => { 249 => 0x804, 252 => 0x808 },
	'playbackbuttonplaybackmode' => { 249 => 0x80e, 252 => 0x814 },
	'playbackflickdown' => { 324 => 0x149, 325 => 0x159, 326 => 0x159, 327 => 0x171 },
	'playbackflickup' => { 324 => 0x145, 325 => 0x155, 326 => 0x155, 327 => 0x16d },
	'playbackmenustime' => { 313 => '20.1', 314 => '21.1', 315 => '21.1' },
	'playbackmonitorofftime' => { 308 => '25.2', 309 => '36.1', 311 => '36.1', 312 => '36.1', 316 => '35.1', 317 => '8.1', 318 => '35.1', 321 => '36.1', 322 => '36.1', 323 => '21.1', 324 => 0x37, 325 => 0x33, 326 => 0x33, 327 => 0x33 },
	'playbackzoom' => { 309 => '37.1' },
	'playdisplay' => { 190 => 0x4e },
	'playerversion' => { 408 => 'player.version' },
	'playgap' => { 406 => 'pgap' },
	'playmode' => { 414 => 'SDLN' },
	'playselection' => { 414 => 'SelO' },
	'plusversion' => { 339 => 'Version' },
	'pmversion' => { 401 => 'PMVersion' },
	'pngwarning' => { 342 => 'Warning' },
	'podcast' => { 406 => 'pcst' },
	'podcasturl' => { 406 => 'purl' },
	'poilevel' => { 241 => 0x8 },
	'portraitimpressionbalance' => { 246 => 0x378, 248 => 0x26e, 249 => 0x26e, 262 => 0xa0 },
	'portraitnote' => { 500 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 114 => 0x1d },
	'portraitoutputshadowpoint' => { 114 => 0x1e },
	'portraitrawcolortone' => { 114 => 0x16 },
	'portraitrawcontrast' => { 114 => 0x18 },
	'portraitrawhighlight' => { 114 => 0x76 },
	'portraitrawhighlightpoint' => { 114 => 0x1b },
	'portraitrawlinear' => { 114 => 0x19 },
	'portraitrawsaturation' => { 114 => 0x17 },
	'portraitrawshadow' => { 114 => 0x7f },
	'portraitrawshadowpoint' => { 114 => 0x1c },
	'portraitrawsharpness' => { 114 => 0x1a },
	'portraitrefiner' => { 118 => 0x302b },
	'portraitrequest' => { 500 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 114 => 0x9a },
	'portraitunsharpmaskstrength' => { 114 => 0x98 },
	'portraitunsharpmaskthreshold' => { 114 => 0x9c },
	'portraitversion' => { 500 => 'PortraitVersion' },
	'pose' => { 496 => 'Pose' },
	'poseheadingdegrees' => { 506 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 506 => 'PosePitchDegrees' },
	'posepositionx' => { 496 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 496 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 496 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 506 => 'PoseRollDegrees' },
	'poserotationw' => { 496 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 496 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 496 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 496 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 496 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 536 => 'positionDescriptor' },
	'postalcode' => { 167 => 'PostalCode' },
	'postcropvignetteamount' => { 518 => 'PostCropVignetteAmount', 520 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 518 => 'PostCropVignetteFeather', 520 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 518 => 'PostCropVignetteHighlightContrast', 520 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 518 => 'PostCropVignetteMidpoint', 520 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 518 => 'PostCropVignetteRoundness', 520 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 518 => 'PostCropVignetteStyle', 520 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 353 => 0xbf },
	'postreleaseburstlength' => { 251 => 0x714, 252 => 0x784, 325 => 0x289 },
	'potentialface1position' => { 451 => 0xb },
	'potentialface2position' => { 451 => 0x15 },
	'potentialface3position' => { 451 => 0x1f },
	'potentialface4position' => { 451 => 0x29 },
	'potentialface5position' => { 451 => 0x33 },
	'potentialface6position' => { 451 => 0x3d },
	'potentialface7position' => { 451 => 0x47 },
	'potentialface8position' => { 451 => 0x51 },
	'poweravailable' => { 367 => '0.2' },
	'powersource' => { 367 => '0.1' },
	'poweruptime' => { 242 => 0xb6 },
	'preaf' => { 131 => '0.2' },
	'precaptureframes' => { 334 => 0x300 },
	'predictor' => { 124 => 0x13d },
	'preflashreturnstrength' => { 279 => 0x28a },
	'prefs' => { 137 => 0xdd, 401 => 'Prefs' },
	'prereadfastresetcount' => { 144 => 0x187e },
	'prereleaseburstlength' => { 251 => 0x712, 252 => 0x782, 325 => 0x287 },
	'preservedfilename' => { 548 => 'PreservedFileName' },
	'preservedspecimen' => { 123 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 123 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 518 => 'PresetType', 520 => 'PresetType' },
	'presetwhitebalance' => { 190 => 0x24, 492 => 0x8002 },
	'presetwhitebalanceadj' => { 492 => 0x8014 },
	'pressure' => { 124 => 0x9402, 525 => 'Pressure' },
	'previewapplicationname' => { 124 => 0xc716 },
	'previewapplicationversion' => { 124 => 0xc717 },
	'previewbutton' => { 308 => ['14.1','15.1'], 309 => '15.1', 311 => '15.1', 312 => '15.1', 317 => '29.1', 318 => '14.1', 321 => '15.1', 322 => '15.1' },
	'previewbuttonplusdials' => { 308 => ['14.2','15.2'], 309 => '15.2', 311 => '43.1', 312 => '43.1', 317 => '31.2', 321 => '43.1', 322 => '43.1' },
	'previewcolorspace' => { 124 => 0xc71a },
	'previewcropbottom' => { 400 => 0xef },
	'previewcropleft' => { 400 => 0xec },
	'previewcropright' => { 400 => 0xee },
	'previewcroptop' => { 400 => 0xed },
	'previewdate' => { 412 => 0x0 },
	'previewdatetime' => { 124 => 0xc71b },
	'previewimage' => { 118 => 0x2000, 119 => 'Exif-PreviewImage', 125 => 'PreviewImage', 127 => 0x4, 172 => 'data', 192 => 0x81, 334 => 0x280, 351 => 0x300, 406 => 'snal', 414 => 'mcvr', 455 => 0x2001 },
	'previewimageborders' => { 389 => 0x3e },
	'previewimageheight' => { 77 => 0x4, 148 => 0xfa58 },
	'previewimagelength' => { 77 => 0x2, 118 => 0x3, 124 => [0x117,0x202], 192 => 0x89, 263 => 0x202, 329 => 0x102, 334 => 0x1037, 389 => 0x3, 420 => 0x1e, 425 => 0x3, 431 => [0x1b,0x1d], 444 => 0x202 },
	'previewimagename' => { 172 => '1Name' },
	'previewimagesize' => { 118 => 0x2, 153 => 0x2, 172 => 'ImageSize', 389 => 0x2, 431 => [0x1c,0x1e], 455 => 0xb02c, 492 => 0x9012 },
	'previewimagestart' => { 77 => 0x5, 118 => 0x4, 124 => [0x111,0x201], 192 => 0x88, 263 => 0x201, 329 => 0x101, 334 => 0x1036, 389 => 0x4, 420 => 0x1c, 425 => 0x2, 431 => [0x1a,0x1c], 444 => 0x201 },
	'previewimagetype' => { 172 => '0Type' },
	'previewimagevalid' => { 329 => 0x100, 334 => 0x1035 },
	'previewimagewidth' => { 77 => 0x3, 148 => 0xfa57 },
	'previewquality' => { 77 => 0x1 },
	'previewsettingsdigest' => { 124 => 0xc719 },
	'previewsettingsname' => { 124 => 0xc718 },
	'primaryafpoint' => { 199 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 124 => 0x13f, 543 => 'PrimaryChromaticities' },
	'primaryftp' => { 508 => 'PrimaryFTP' },
	'primaryslot' => { 253 => 0x25, 271 => 0x2 },
	'printim' => { 124 => 0xc4a5 },
	'prioritysetinawb' => { 455 => 0x202b },
	'prioritysetupshutterrelease' => { 190 => 0x1d, 441 => 0x28 },
	'privatertkinfo' => { 510 => 'privateRTKInfo' },
	'processbordercolsleft' => { 144 => 0xc61 },
	'processbordercolsright' => { 144 => 0xc62 },
	'processborderrowsbottom' => { 144 => 0xc64 },
	'processborderrowstop' => { 144 => 0xc63 },
	'processingsoftware' => { 124 => 0xb },
	'processversion' => { 518 => 'ProcessVersion', 520 => 'ProcessVersion' },
	'producer' => { 185 => 'WM/Producer', 338 => 'Producer', 406 => "\xa9prd", 408 => 'producer', 414 => "\xa9prd", 534 => 'Producer' },
	'producerkeywords' => { 414 => "\xa9pdk" },
	'productcode' => { 537 => 'productCode' },
	'productid' => { 138 => 0x32, 406 => 'prID', 536 => 'productID' },
	'productidtype' => { 536 => 'productIDType' },
	'productinimage' => { 532 => 'ProductInImage' },
	'productinimagedescription' => { 532 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 532 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 532 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 532 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 368 => 0x2 },
	'productorserviceconstraints' => { 339 => 'ProductOrServiceConstraints' },
	'productversion' => { 406 => 'VERS' },
	'profession' => { 537 => 'profession' },
	'profile' => { 496 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 124 => 0xc6f4 },
	'profilecameraindices' => { 496 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 124 => 0xc6fe },
	'profiledynamicrange' => { 124 => 0xcd47 },
	'profileembedpolicy' => { 124 => 0xc6fd },
	'profilegaintablemap' => { 124 => 0xcd2d },
	'profilegaintablemap2' => { 124 => 0xcd40 },
	'profilegroupname' => { 124 => 0xcd48 },
	'profilehuesatmapdata1' => { 124 => 0xc6fa },
	'profilehuesatmapdata2' => { 124 => 0xc6fb },
	'profilehuesatmapdata3' => { 124 => 0xcd39 },
	'profilehuesatmapdims' => { 124 => 0xc6f9 },
	'profilehuesatmapencoding' => { 124 => 0xc7a3 },
	'profilelooktabledata' => { 124 => 0xc726 },
	'profilelooktabledims' => { 124 => 0xc725 },
	'profilelooktableencoding' => { 124 => 0xc7a4 },
	'profilename' => { 124 => 0xc6f8, 340 => 'iCCP-name' },
	'profiles' => { 496 => 'Profiles' },
	'profiletonecurve' => { 124 => 0xc6fc },
	'profiletype' => { 496 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 353 => 0x3c },
	'programline' => { 369 => '1.1' },
	'programmode' => { 195 => 0x5 },
	'programshift' => { 242 => 0xd },
	'programversion' => { 137 => 0x46 },
	'prohibits' => { 516 => 'prohibits' },
	'projectiontype' => { 506 => 'ProjectionType', 507 => 'ProjectionType' },
	'projectname' => { 547 => 'projectName' },
	'projectref' => { 547 => 'projectRef' },
	'projectrefpath' => { 547 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 547 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 185 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 339 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 339 => 'PropertyReleaseStatus' },
	'provider' => { 185 => 'WM/Provider' },
	'province-state' => { 137 => 0x5f },
	'publicationdate' => { 537 => 'publicationDate' },
	'publicationdatea-platform' => { 537 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 537 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 537 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 537 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 537 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 532 => 'PublicationEvent' },
	'publicationeventdate' => { 532 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 532 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 532 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 537 => 'publicationName' },
	'publisher' => { 185 => 'WM/Publisher', 406 => "\xa9pub", 408 => 'publisher', 521 => 'publisher' },
	'publishingfrequency' => { 537 => 'publishingFrequency' },
	'pulldown' => { 547 => 'pullDown' },
	'purchasedate' => { 406 => 'purd' },
	'purplehsl' => { 108 => 0x20916 },
	'pxshiftperiphedgenr' => { 492 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 492 => 0x9014 },
	'quality' => { 0 => 0x1, 36 => 0x3, 117 => 0x2, 118 => 0x3002, 132 => 0x1000, 146 => 0x9, 242 => 0x4, 290 => 0x3, 334 => 0x201, 348 => 0x300, 389 => 0x8, 396 => 0x2, 431 => 0x16, 441 => 0x56, 442 => 0x56, 443 => 0xb, 455 => [0x102,0x202e] },
	'quality2' => { 464 => 0x1170, 465 => 0x1174, 466 => 0x1150, 468 => 0x11a8, 469 => 0x1060, 470 => 0x258, 471 => 0x258, 472 => 0x247, 478 => 0x29, 479 => 0x25, 480 => 0x2a },
	'qualitybutton' => { 326 => 0x17d, 327 => 0x195 },
	'qualitybuttonplaybackmode' => { 326 => 0x1bf, 327 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 118 => 0x8 },
	'quantizationmethod' => { 139 => 0x78 },
	'quickadjust' => { 304 => 0x2a },
	'quickcontroldialinmeter' => { 89 => 0x703 },
	'quickfix' => { 301 => 0x416391c6 },
	'quickshot' => { 430 => 0x213 },
	'quiettime' => { 144 => 0x188a },
	'radialdistortioncoefficient1' => { 217 => 0x14 },
	'radialdistortioncoefficient2' => { 217 => 0x1c },
	'radialdistortioncoefficient3' => { 217 => 0x24 },
	'rads' => { 414 => 'rads' },
	'rangefinder' => { 313 => '4.1', 314 => '5.1', 315 => '5.1' },
	'rangemask' => { 518 => 'RangeMaskMapInfo', 520 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 518 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 520 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 518 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 520 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 518 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 520 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 518 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 520 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 518 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 520 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 518 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 520 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 137 => 0x7d },
	'rating' => { 108 => 0x10100, 124 => 0x4746, 132 => 0x1431, 400 => 0xdf, 406 => 'rtng', 414 => 'rtng', 455 => 0x2002, 513 => 'rating', 522 => 'rating', 532 => 'Rating', 537 => 'rating', 545 => 'Rating' },
	'ratingpercent' => { 124 => 0x4749, 184 => 'Rating', 406 => 'rate', 545 => 'RatingPercent' },
	'ratingregion' => { 532 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 532 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 532 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 532 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 532 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpsaltituderef' => { 532 => [\'Rating','RatingRatingRegionGPSAltitudeRef'] },
	'ratingregiongpslatitude' => { 532 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 532 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 532 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 532 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 532 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 532 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 532 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 532 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 532 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 532 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 532 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 532 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 532 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 87 => 0x8, 192 => 0x109, 369 => 0xd },
	'rawbrightnessadj' => { 108 => 0x20001, 113 => 0x38 },
	'rawburstimagecount' => { 79 => 0x2 },
	'rawburstimagenum' => { 79 => 0x1 },
	'rawcoloradj' => { 113 => 0x2e },
	'rawcropbottom' => { 400 => 0xd4 },
	'rawcropleft' => { 400 => 0xd1 },
	'rawcropright' => { 400 => 0xd3 },
	'rawcroptop' => { 400 => 0xd2 },
	'rawcustomsaturation' => { 113 => 0x30 },
	'rawcustomtone' => { 113 => 0x34 },
	'rawdata' => { 428 => 0xa048 },
	'rawdatabyteorder' => { 428 => 0x40 },
	'rawdatacfapattern' => { 428 => 0x50 },
	'rawdatauniqueid' => { 124 => 0xc65d },
	'rawdepth' => { 194 => 0x10 },
	'rawdevartfilter' => { 336 => 0x121 },
	'rawdevautogradation' => { 336 => 0x119 },
	'rawdevcolorspace' => { 335 => 0x108, 336 => 0x109 },
	'rawdevcontrastvalue' => { 335 => 0x106, 336 => 0x105 },
	'rawdeveditstatus' => { 335 => 0x10b },
	'rawdevelopingsoftware' => { 124 => 0xa43a, 525 => 'RAWDevelopingSoftware' },
	'rawdevelopmentprocess' => { 389 => 0x62 },
	'rawdevengine' => { 335 => 0x109, 336 => 0x10b },
	'rawdevexposurebiasvalue' => { 335 => 0x100, 336 => 0x100 },
	'rawdevgradation' => { 336 => 0x112 },
	'rawdevgraypoint' => { 335 => 0x103, 336 => 0x104 },
	'rawdevmemorycoloremphasis' => { 335 => 0x105, 336 => 0x108 },
	'rawdevnoisereduction' => { 335 => 0x10a, 336 => 0x10a },
	'rawdevpicturemode' => { 336 => 0x10c },
	'rawdevpm_bwfilter' => { 336 => 0x110 },
	'rawdevpmcontrast' => { 336 => 0x10e },
	'rawdevpmnoisefilter' => { 336 => 0x120 },
	'rawdevpmpicturetone' => { 336 => 0x111 },
	'rawdevpmsaturation' => { 336 => 0x10d },
	'rawdevpmsharpness' => { 336 => 0x10f },
	'rawdevsaturation3' => { 336 => 0x113 },
	'rawdevsaturationemphasis' => { 335 => 0x104, 336 => 0x107 },
	'rawdevsettings' => { 335 => 0x10c },
	'rawdevsharpnessvalue' => { 335 => 0x107, 336 => 0x106 },
	'rawdevversion' => { 335 => 0x0, 336 => 0x0 },
	'rawdevwbfineadjustment' => { 335 => 0x102, 336 => 0x103 },
	'rawdevwhitebalance' => { 336 => 0x101 },
	'rawdevwhitebalancevalue' => { 335 => 0x101, 336 => 0x102 },
	'rawfile' => { 124 => 0xfe4c },
	'rawfilename' => { 518 => 'RawFileName', 520 => 'RawFileName' },
	'rawfiletype' => { 455 => 0x2029 },
	'rawformat' => { 358 => 0x2d, 398 => 0x10e },
	'rawimagecenter' => { 242 => 0x99 },
	'rawimagedigest' => { 124 => 0xc71c },
	'rawimagesize' => { 389 => 0x39 },
	'rawinfoversion' => { 337 => 0x0 },
	'rawjpgheight' => { 104 => 0x4 },
	'rawjpgquality' => { 60 => 0x6, 104 => 0x1 },
	'rawjpgsize' => { 60 => 0x7, 104 => 0x2 },
	'rawjpgwidth' => { 104 => 0x3 },
	'rawmeasuredrggb' => { 46 => 0x26a, 48 => 0x280, 50 => 0x194, 51 => [0x1ad,0x26b] },
	'rawrppused' => { 513 => 'rawrppused' },
	'rawtopreviewgain' => { 124 => 0xc7a8 },
	'readouttypeactual' => { 144 => 0x1903 },
	'readouttyperequested' => { 144 => 0x1902 },
	'reardisplay' => { 308 => '12.3', 309 => '6.2' },
	'recdevice' => { 532 => 'RecDevice' },
	'recdeviceattlensdescription' => { 532 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 532 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 532 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 532 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 532 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 539 => 'recipeEndingPage' },
	'recipepagerange' => { 539 => 'recipePageRange' },
	'recipesource' => { 539 => 'recipeSource' },
	'recipestartingpage' => { 539 => 'recipeStartingPage' },
	'recipetitle' => { 539 => 'recipeTitle' },
	'recognizedface1age' => { 346 => 0x20 },
	'recognizedface1name' => { 346 => 0x4 },
	'recognizedface1position' => { 346 => 0x18 },
	'recognizedface2age' => { 346 => 0x50 },
	'recognizedface2name' => { 346 => 0x34 },
	'recognizedface2position' => { 346 => 0x48 },
	'recognizedface3age' => { 346 => 0x80 },
	'recognizedface3name' => { 346 => 0x64 },
	'recognizedface3position' => { 346 => 0x78 },
	'recognizedfaceflags' => { 353 => 0x63 },
	'recommendedexposureindex' => { 124 => 0x8832, 525 => 'RecommendedExposureIndex' },
	'record' => { 123 => 'Record' },
	'recordbasisofrecord' => { 123 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 123 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 123 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 123 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 123 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 123 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 190 => 0x4d },
	'recorddynamicproperties' => { 123 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 102 => 0x1804 },
	'recordinformationwithheld' => { 123 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 414 => "\xa9phg" },
	'recordingformat' => { 421 => 0x1000 },
	'recordingmode' => { 117 => 0x1, 396 => 0x1 },
	'recordinstitutioncode' => { 123 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 123 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 414 => "\xa9lab" },
	'recordlabelurl' => { 414 => "\xa9lal" },
	'recordlocationdata' => { 250 => 0x660, 251 => 0x690, 252 => 0x6f8 },
	'recordmode' => { 36 => 0x9, 118 => 0x3000 },
	'recordownerinstitutioncode' => { 123 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 430 => 0x217 },
	'redbalance' => { 334 => 0x1017, 358 => 0x11, 389 => 0x1c },
	'redcurvelimits' => { 113 => 0x18a },
	'redcurvepoints' => { 112 => 0x2d, 113 => 0x160 },
	'redeyecorrection' => { 305 => 0x0 },
	'redeyeinfo' => { 518 => 'RedEyeInfo', 520 => 'RedEyeInfo' },
	'redeyereduction' => { 190 => 0x41, 441 => 0x6a, 443 => 0x28 },
	'redeyeremoval' => { 353 => 0xb9 },
	'redhsl' => { 108 => 0x20910 },
	'redhue' => { 518 => 'RedHue', 520 => 'RedHue' },
	'redsaturation' => { 518 => 'RedSaturation', 520 => 'RedSaturation' },
	'reductionmatrix1' => { 124 => 0xc625 },
	'reductionmatrix2' => { 124 => 0xc626 },
	'reductionmatrix3' => { 124 => 0xcd3a },
	'reelname' => { 124 => 0xc789, 414 => 'reel' },
	'reference1' => { 530 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 530 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 124 => 0x214, 543 => 'ReferenceBlackWhite' },
	'referencedate' => { 137 => 0x2f },
	'referencenumber' => { 137 => 0x32 },
	'references' => { 163 => 'References' },
	'referenceservice' => { 137 => 0x2d },
	'regionappliedtodimensions' => { 178 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 178 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 178 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 178 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 178 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 178 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 178 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 178 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 178 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 178 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 178 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 178 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 339 => 'RegionConstraints' },
	'regiondescription' => { 178 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 178 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 178 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 178 => 'Regions' },
	'regioninfoacdsee' => { 493 => 'Regions' },
	'regioninfodateregionsvalid' => { 181 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 181 => 'RegionInfo' },
	'regioninforegions' => { 181 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 178 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 178 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 181 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 181 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 181 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 181 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 181 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 178 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 178 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 178 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 532 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 532 => 'RegistryId' },
	'registryitemid' => { 532 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 532 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 161 => 'data' },
	'relatedaudiofilename' => { 161 => '1Name' },
	'relatedaudiofiletype' => { 161 => '0Type' },
	'relatedimagefileformat' => { 124 => 0x1000 },
	'relatedimageheight' => { 124 => 0x1002 },
	'relatedimagewidth' => { 124 => 0x1001 },
	'relatedresourceid' => { 123 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 124 => 0xa004, 524 => 'RelatedSoundFile' },
	'relatedvideofile' => { 175 => 'data' },
	'relatedvideofilename' => { 175 => '1Name' },
	'relatedvideofiletype' => { 175 => '0Type' },
	'relation' => { 521 => 'relation' },
	'relationshipaccordingto' => { 123 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 123 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 123 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 123 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 123 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 121 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 547 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 547 => 'relativeTimestamp' },
	'relativetimestampscale' => { 547 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 547 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 308 => '17.8', 309 => '18.5', 311 => '18.4', 312 => '18.4', 317 => '33.8', 318 => '17.6', 321 => '18.5', 322 => '18.4' },
	'releasedate' => { 137 => 0x1e, 406 => 'rldt', 513 => 'ReleaseDate', 547 => 'releaseDate' },
	'releasemode' => { 118 => 0x3001, 247 => 0x5c, 281 => 0x184d, 455 => 0xb049 },
	'releasemode2' => { 464 => 0x112c, 465 => [0x112c,0x8], 466 => [0x1108,0x8], 467 => [0x1184,0x8], 468 => [0x1160,0x8], 469 => [0x4,0x1018], 470 => [0x4,0x210], 471 => [0x4,0x210], 472 => [0x4,0x208], 474 => [0x67,0x3f], 475 => [0x6b,0x6d,0x73,0x4b], 476 => [0x6b,0x4b], 477 => 0x1f, 478 => 0x10, 479 => 0x10, 480 => 0x9, 487 => 0x34 },
	'releasemode3' => { 464 => 0x1128, 465 => 0x1128, 466 => 0x1104, 467 => 0x1180, 468 => 0x115c, 469 => 0x1014, 470 => 0x20c, 471 => 0x20c, 472 => 0x204 },
	'releaseready' => { 532 => 'ReleaseReady' },
	'releasesetting' => { 102 => 0x1016 },
	'releasetime' => { 137 => 0x23, 513 => 'ReleaseTime' },
	'remoteonduration' => { 310 => '3.4', 313 => '17.2', 314 => '18.2', 315 => '18.2', 316 => '18.2', 318 => '18.2', 319 => '4.3', 323 => '19.2' },
	'renditionclass' => { 548 => 'RenditionClass' },
	'renditionof' => { 548 => 'RenditionOf' },
	'renditionofalternatepaths' => { 548 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 548 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 548 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 548 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 548 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 548 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 548 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 548 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 548 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 548 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 548 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 548 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 548 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 548 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 548 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 548 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 548 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 548 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 548 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 548 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 548 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 548 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 548 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 548 => 'RenditionParams' },
	'repeatingflashcount' => { 220 => 0xd, 221 => 0xe, 222 => 0xe, 223 => 0xe, 224 => 0xe, 225 => 0xe, 317 => '17.2', 318 => '24.2', 319 => '9.2', 320 => '24.2', 323 => '25.2' },
	'repeatingflashcountbuilt-in' => { 288 => 0x4db },
	'repeatingflashcountexternal' => { 288 => 0x4c3 },
	'repeatingflashoutput' => { 317 => '17.1', 318 => '24.1', 319 => '9.1', 320 => '24.1', 323 => '25.1' },
	'repeatingflashoutputexternal' => { 288 => 0x4c0 },
	'repeatingflashrate' => { 220 => 0xc, 221 => 0xd, 222 => 0xd, 223 => 0xd, 224 => 0xd, 225 => 0xd, 317 => '18.1', 318 => '25.1', 319 => '10.1', 320 => '25.1', 323 => '26.1' },
	'repeatingflashratebuilt-in' => { 288 => 0x4da },
	'repeatingflashrateexternal' => { 288 => 0x4c2 },
	'requirements' => { 414 => "\xa9req" },
	'requires' => { 516 => 'requires' },
	'resampleparams' => { 547 => 'resampleParams' },
	'resampleparamsquality' => { 547 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 144 => 0xe50 },
	'resamplingkerneldenominators067' => { 144 => 0xe4f },
	'resamplingkerneldenominators100' => { 144 => 0xe51 },
	'resaved' => { 430 => 0x21e },
	'resetblacksegrows' => { 144 => 0x181a },
	'resolution' => { 168 => 'Resolution' },
	'resolutionmode' => { 431 => [0x87,0x4] },
	'resolutionunit' => { 124 => 0x128, 140 => 0x2, 543 => 'ResolutionUnit' },
	'resourceid' => { 123 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 123 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 123 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 89 => 0x612 },
	'restrictions' => { 540 => 'restrictions' },
	'retouchareafeather' => { 518 => [\'RetouchAreas','RetouchAreasFeather'], 520 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 518 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 520 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 518 => [\'RetouchAreas','RetouchAreasMasksAngle'], 520 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 518 => [\'RetouchAreas','RetouchAreasMasksBottom'], 520 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 518 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 520 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 518 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 520 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 518 => [\'RetouchAreas','RetouchAreasMasksDabs'], 520 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 518 => [\'RetouchAreas','RetouchAreasMasksFeather'], 520 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 518 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 520 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 518 => [\'RetouchAreas','RetouchAreasMasksFlow'], 520 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 518 => [\'RetouchAreas','RetouchAreasMasksFullX'], 520 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 518 => [\'RetouchAreas','RetouchAreasMasksFullY'], 520 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 518 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 520 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 518 => [\'RetouchAreas','RetouchAreasMasksLeft'], 520 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 518 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 520 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 518 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 520 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 518 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 520 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 518 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 520 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 518 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 520 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasks'], 520 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 518 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 520 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 518 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 520 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 518 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 520 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 518 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 520 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 518 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 520 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 518 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 520 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 518 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 520 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 518 => [\'RetouchAreas','RetouchAreasMasksRadius'], 520 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 518 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 520 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 518 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 520 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 518 => [\'RetouchAreas','RetouchAreasMasksRight'], 520 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 518 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 520 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 518 => [\'RetouchAreas','RetouchAreasMasks'], 520 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 518 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 520 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 518 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 520 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 518 => [\'RetouchAreas','RetouchAreasMasksTop'], 520 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 518 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 520 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 518 => [\'RetouchAreas','RetouchAreasMasksVersion'], 520 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 518 => [\'RetouchAreas','RetouchAreasMasksWhat'], 520 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 518 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 520 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 518 => [\'RetouchAreas','RetouchAreasMasksX'], 520 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 518 => [\'RetouchAreas','RetouchAreasMasksY'], 520 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 518 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 520 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 518 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 520 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 518 => [\'RetouchAreas','RetouchAreasMethod'], 520 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 518 => [\'RetouchAreas','RetouchAreasOffsetY'], 520 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 518 => [\'RetouchAreas','RetouchAreasOpacity'], 520 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 518 => 'RetouchAreas', 520 => 'RetouchAreas' },
	'retouchareaseed' => { 518 => [\'RetouchAreas','RetouchAreasSeed'], 520 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 518 => [\'RetouchAreas','RetouchAreasSourceState'], 520 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 518 => [\'RetouchAreas','RetouchAreasSourceX'], 520 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 518 => [\'RetouchAreas','RetouchAreasSpotType'], 520 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 242 => 0x9e },
	'retouchinfo' => { 518 => 'RetouchInfo', 520 => 'RetouchInfo' },
	'retouchnefprocessing' => { 265 => 0x5 },
	'retractlensonpoweroff' => { 89 => 0x814 },
	'reuse' => { 339 => 'Reuse' },
	'reuseallowed' => { 550 => 'ReuseAllowed' },
	'reuseprohibited' => { 540 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 315 => '5.2' },
	'reversefocusring' => { 325 => 0x163, 326 => 0x163, 327 => 0x17b },
	'reverseindicators' => { 308 => '12.1', 309 => '6.1', 311 => '6.1', 312 => '6.1', 313 => '4.3', 314 => '5.2', 315 => '5.4', 317 => '33.5', 318 => '5.1', 321 => '6.1', 322 => '6.1', 323 => '6.2', 324 => 0xc5, 325 => 0xc1, 326 => 0xc1, 327 => 0xc1 },
	'reverseshutterspeedaperture' => { 315 => '5.3' },
	'revision' => { 522 => 'revision' },
	'rflensmffocusringsensitivity' => { 89 => 0x714 },
	'rflenstype' => { 60 => 0x3d },
	'rgbcurvelimits' => { 113 => 0x238 },
	'rgbcurvepoints' => { 112 => 0x7, 113 => 0x20e },
	'rgbtables' => { 124 => 0xcd3f },
	'richtextcomment' => { 527 => 'RichTextComment' },
	'ricohdate' => { 420 => 0x6 },
	'ricohimageheight' => { 420 => 0x2 },
	'ricohimagewidth' => { 420 => 0x0 },
	'rightalbedo' => { 509 => 'RightAlbedo' },
	'rightascension' => { 171 => 'RightAscension' },
	'rights' => { 521 => 'rights' },
	'rightsagent' => { 540 => 'rightsAgent' },
	'rightsowner' => { 540 => 'rightsOwner' },
	'roll' => { 120 => 0x8, 414 => ['roll',"\xa9frl"] },
	'rollangle' => { 65 => 0x4, 132 => 0x144d, 257 => 0x0, 329 => 0x903, 343 => 'RollAngle', 353 => 0x90, 387 => 0x1, 388 => 0x3, 426 => 0x2 },
	'romoperationmode' => { 102 => 0x80d },
	'rotation' => { 31 => 0x17, 32 => 0x18, 101 => 0x3, 108 => 0x10002, 113 => 0x26e, 119 => 'QuickTime-Rotation', 128 => 0x4, 171 => 'Rotation', 188 => [0x65,0x50], 189 => 0x46, 190 => 0x5a, 193 => 0x10, 266 => 0x1a, 281 => 0x3693, 287 => '590.1', 301 => 0x76a43207, 353 => 0x30, 369 => '17.2', 400 => 0xd8, 407 => 'irot', 441 => 0x3f, 442 => 0x3f, 452 => 0x10 },
	'routedto' => { 526 => 'RoutedTo' },
	'routing' => { 405 => 'Routing' },
	'routingdestinations' => { 508 => 'RoutingDestinations' },
	'routingexclusions' => { 508 => 'RoutingExclusions' },
	'routingnotes' => { 526 => 'RoutingNotes' },
	'rowsperstrip' => { 124 => 0x116 },
	'rpp' => { 513 => 'rpp' },
	'rtkflag' => { 121 => 'RtkFlag' },
	'rtkstdhgt' => { 121 => 'RtkStdHgt' },
	'rtkstdlat' => { 121 => 'RtkStdLat' },
	'rtkstdlon' => { 121 => 'RtkStdLon' },
	'safetyshift' => { 89 => 0x108 },
	'safetyshiftinavortv' => { 87 => 0x10, 88 => 0x10, 90 => 0xf, 91 => 0x10, 94 => 0x10 },
	'sameexposurefornewaperture' => { 89 => 0x112 },
	'samplebits' => { 161 => 'SampleBits' },
	'samplepagerange' => { 537 => 'samplePageRange' },
	'samplerate' => { 161 => 'SampleRate' },
	'samplesperpixel' => { 124 => 0x115, 358 => 0x8, 543 => 'SamplesPerPixel' },
	'samplestructure' => { 139 => 0x5a },
	'samsungmodelid' => { 428 => 0x3 },
	'sanyoquality' => { 430 => 0x201 },
	'sanyothumbnail' => { 430 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 36 => 0xe, 54 => 0x1, 67 => 0x7, 117 => 0xd, 118 => [0x3013,0x1f], 124 => [0xa409,0xfe55], 132 => 0x1003, 162 => 'Saturation', 187 => 0x1f, 188 => 0x32, 189 => 0x28, 190 => 0x1a, 195 => 0x1, 242 => 0xaa, 259 => 0x35, 260 => 0x3b, 261 => 0x43, 353 => 0x40, 355 => 0x300d, 389 => 0x1f, 396 => 0xd, 415 => 0x27, 417 => 0x58, 420 => 0x28, 421 => 0x1013, 431 => 0x10, 441 => 0x1e, 442 => 0x1b, 455 => 0x2005, 518 => 'Saturation', 520 => 'Saturation', 524 => 'Saturation' },
	'saturationadj' => { 108 => 0x20901, 113 => 0x116, 242 => 0x94, 300 => 0x1, 304 => 0x2e, 492 => 0x8016 },
	'saturationadjustmentaqua' => { 518 => 'SaturationAdjustmentAqua', 520 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 518 => 'SaturationAdjustmentBlue', 520 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 518 => 'SaturationAdjustmentGreen', 520 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 518 => 'SaturationAdjustmentMagenta', 520 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 518 => 'SaturationAdjustmentOrange', 520 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 518 => 'SaturationAdjustmentPurple', 520 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 518 => 'SaturationAdjustmentRed', 520 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 518 => 'SaturationAdjustmentYellow', 520 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 75 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 74 => 0x68, 75 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 74 => 0x38, 75 => 0x38 },
	'saturationmonochrome' => { 74 => 0x80, 75 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 74 => 0x50, 75 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 74 => 0x20, 75 => 0x20 },
	'saturationsetting' => { 337 => 0x1010, 443 => 0x11, 460 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 74 => 0x8, 75 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 74 => 0x98, 75 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 74 => 0xb0, 75 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 74 => 0xc8, 75 => 0xe0 },
	'savefocusposition' => { 246 => 0x9b0 },
	'saveid' => { 548 => 'SaveID' },
	'sbaanalysiscomplete' => { 144 => 0xc35 },
	'sbablack' => { 144 => 0xc25 },
	'sbagmoffset' => { 144 => 0xc4a },
	'sbagray' => { 144 => 0xc26 },
	'sbagreenmagentabal' => { 144 => 0xc33 },
	'sbahighgray' => { 144 => 0xc46 },
	'sbailloffset' => { 144 => 0xc49 },
	'sbailluminantbal' => { 144 => 0xc34 },
	'sbalowgray' => { 144 => 0xc47 },
	'sbaneutralbal' => { 144 => 0xc32 },
	'sbawhite' => { 144 => 0xc27 },
	'scaletype' => { 547 => 'scaleType' },
	'scalingfactorheight' => { 343 => 'ScalingFactorHeight' },
	'scanimageenhancer' => { 267 => 0x60 },
	'scanningdirection' => { 139 => 0x64 },
	'scene' => { 414 => 'scen', 531 => 'Scene', 547 => 'scene' },
	'scenearea' => { 332 => 0x211, 334 => 0x1031 },
	'sceneassist' => { 242 => 0x9c },
	'scenecapturetype' => { 124 => 0xa406, 524 => 'SceneCaptureType' },
	'scenedetect' => { 332 => 0x210, 334 => 0x1030 },
	'scenedetectdata' => { 332 => 0x212, 334 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 148 => 0xfa02, 192 => 0x100, 242 => 0x8f, 329 => 0x509, 334 => 0x403, 353 => 0x8001, 362 => 0xf, 455 => 0xb023 },
	'scenemodeused' => { 150 => [0x6002,0xf002] },
	'scenerecognition' => { 132 => 0x1425 },
	'scenereferred' => { 528 => 'scene_referred' },
	'sceneselect' => { 430 => 0x21f },
	'scenetype' => { 124 => 0xa301, 524 => 'SceneType' },
	'screentips' => { 308 => '12.7', 309 => '5.3', 317 => '13.1', 318 => '4.4', 321 => '5.4', 323 => '5.1' },
	'scriptversion' => { 144 => 0x1770 },
	'sdrblend' => { 518 => 'SDRBlend', 520 => 'SDRBlend' },
	'sdrbrightness' => { 518 => 'SDRBrightness', 520 => 'SDRBrightness' },
	'sdrcontrast' => { 518 => 'SDRContrast', 520 => 'SDRContrast' },
	'sdrhighlights' => { 518 => 'SDRHighlights', 520 => 'SDRHighlights' },
	'sdrshadows' => { 518 => 'SDRShadows', 520 => 'SDRShadows' },
	'sdrwhites' => { 518 => 'SDRWhites', 520 => 'SDRWhites' },
	'seal' => { 124 => 0xcea1 },
	'season' => { 532 => 'Season', 536 => 'season' },
	'seasonidentifier' => { 532 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 532 => [\'Season','SeasonName'] },
	'seasonnumber' => { 532 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 508 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 246 => 0x35a, 248 => 0x240, 249 => 0x240, 250 => 0x22c, 251 => 0x240, 252 => 0x240, 270 => 0x13c, 281 => 0x1d0 },
	'section' => { 537 => 'section' },
	'securityclassification' => { 124 => 0x9212 },
	'selectableafpoint' => { 89 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 89 => 0x512 },
	'selfdata' => { 121 => 'SelfData' },
	'selftimer' => { 36 => 0x2, 353 => 0x2e, 430 => 0x214, 464 => 0x1134, 465 => 0x1134, 466 => 0x1110, 467 => 0x118c, 468 => 0x1168, 469 => 0x1020, 470 => 0x218, 471 => 0x218, 472 => 0x210 },
	'selftimer2' => { 81 => 0x1d },
	'selftimerinterval' => { 318 => '19.2' },
	'selftimermode' => { 124 => 0x882b },
	'selftimershotcount' => { 309 => '20.2', 311 => '20.3', 312 => '20.3', 313 => '18.2', 314 => '19.2', 315 => '19.2', 316 => '19.3', 318 => '19.3', 321 => '20.3', 322 => '20.3', 323 => '20.2', 324 => 0x31, 325 => 0x2d, 326 => 0x2d, 327 => 0x2d },
	'selftimershotinterval' => { 309 => '20.3', 311 => '20.2', 312 => '20.2', 316 => '19.2', 321 => '20.2', 322 => '20.2', 324 => 0x35, 325 => 0x31, 326 => 0x31, 327 => 0x31 },
	'selftimertime' => { 102 => 0x1806, 190 => 0x1f, 308 => '18.1', 309 => '20.1', 310 => '3.3', 311 => '20.1', 312 => '20.1', 313 => '18.1', 314 => '19.1', 315 => '19.1', 316 => '19.1', 317 => '7.2', 318 => '19.1', 319 => '3.3', 321 => '20.1', 322 => '20.1', 323 => '20.1', 324 => 0x2d, 325 => 0x2b, 326 => 0x2b, 327 => 0x2b },
	'sellingagency' => { 537 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 124 => 0x8546 },
	'sensingmethod' => { 124 => 0xa217, 524 => 'SensingMethod' },
	'sensitivityadjust' => { 389 => 0x40 },
	'sensitivitysteps' => { 369 => ['14.3','17.4'], 371 => 0x1 },
	'sensitivitytype' => { 124 => 0x8830, 525 => 'SensitivityType' },
	'sensor' => { 197 => 0x665e },
	'sensorarea' => { 334 => 0x400 },
	'sensorareas' => { 428 => 0xa010 },
	'sensorbitdepth' => { 355 => 0x312d },
	'sensorbluelevel' => { 78 => 0x5 },
	'sensorcalibration' => { 333 => 0x805 },
	'sensorcleaning' => { 95 => 0xd },
	'sensorfullheight' => { 143 => 0xf904 },
	'sensorfullwidth' => { 143 => 0xf903 },
	'sensorheight' => { 143 => 0xf901, 148 => 0xfa21, 194 => 0x8, 355 => 0x312c, 398 => 0x109, 421 => 0x1602 },
	'sensorimageheight' => { 144 => 0x3ee },
	'sensorimagewidth' => { 144 => 0x3ed },
	'sensorleftborder' => { 144 => 0x3eb },
	'sensorleftmargin' => { 398 => 0x10a },
	'sensorpixelsize' => { 242 => 0x9a },
	'sensorredlevel' => { 78 => 0x4 },
	'sensorserialnumber' => { 144 => 0x9ce },
	'sensorshield' => { 248 => 0x76b, 249 => 0x77b, 250 => 0x66d, 251 => 0x69d, 252 => 0x705 },
	'sensorsize' => { 162 => 'SensorSize', 389 => 0x35 },
	'sensortemperature' => { 332 => 0x1500, 334 => 0x1007, 394 => 0xc, 398 => 0x210, 431 => [0x39,0x55] },
	'sensortemperature2' => { 394 => 0xe, 398 => 0x211 },
	'sensortopborder' => { 144 => 0x3ec },
	'sensortopmargin' => { 398 => 0x10b },
	'sensortype' => { 353 => 0xca },
	'sensorwidth' => { 143 => 0xf900, 148 => 0xfa20, 194 => 0xa, 355 => 0x312b, 398 => 0x108, 421 => 0x1601 },
	'sequence' => { 415 => 0x7, 416 => 0x35, 417 => 0x36 },
	'sequencefilenumber' => { 465 => 0x4, 466 => 0x4, 467 => 0x4, 468 => 0x4, 478 => 0xc, 479 => 0xc, 480 => 0x1a },
	'sequenceimagenumber' => { 465 => 0x0, 466 => 0x0, 467 => 0x0, 468 => 0x0, 478 => 0x8, 479 => 0x8, 480 => 0x12, 487 => 0x24 },
	'sequencelength' => { 478 => 0x22, 479 => 0x1e, 480 => [0x16,0x1e] },
	'sequencename' => { 536 => 'sequenceName' },
	'sequencenumber' => { 81 => 0x9, 118 => 0x301c, 132 => 0x1101, 146 => 0x1d, 288 => 0x51c, 353 => 0x2b, 443 => [0x10c,0x30c], 455 => 0xb04a, 536 => 'sequenceNumber' },
	'sequenceshotinterval' => { 430 => 0x224 },
	'sequencetotalnumber' => { 536 => 'sequenceTotalNumber' },
	'sequentialshot' => { 430 => 0x20e },
	'serialnumber' => { 68 => 0xc, 102 => 0x180b, 124 => [0xa431,0xfde9], 143 => 0xfa04, 145 => 0xfa00, 147 => 0xc354, 148 => 0xfa19, 159 => 0x0, 162 => 'SerialNumber', 197 => 0x5501, 242 => [0xa0,0x1d], 330 => 0x101, 334 => [0x404,0x101a], 348 => 0x303, 350 => 0x305, 355 => 0x3103, 389 => 0x229, 398 => 0x102, 399 => 0x407, 414 => ['SNum','slno'], 415 => 0x15, 416 => 0x4b, 417 => 0x7e, 421 => 0x5, 428 => 0xa002, 431 => 0x2, 455 => 0x2031, 515 => 'SerialNumber', 525 => 'BodySerialNumber' },
	'serialnumberformat' => { 68 => 0x15, 102 => 0x183b },
	'serialnumberhash' => { 414 => 'CAME' },
	'series' => { 532 => 'Series' },
	'seriesdatetime' => { 495 => 'SeriesDateTime' },
	'seriesdescription' => { 495 => 'SeriesDescription' },
	'seriesidentifier' => { 532 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 495 => 'SeriesModality' },
	'seriesname' => { 532 => [\'Series','SeriesName'] },
	'seriesnumber' => { 495 => 'SeriesNumber', 537 => 'seriesNumber' },
	'seriestitle' => { 537 => 'seriesTitle' },
	'serviceidentifier' => { 138 => 0x1e },
	'servingsize' => { 539 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 92 => 0x0, 93 => 0x0 },
	'setbuttonwhenshooting' => { 87 => 0x1, 89 => 0x704, 95 => 0xc },
	'setclockfromlocationdata' => { 250 => 0x61d, 251 => 0x64d, 252 => 0x6b5 },
	'setfunctionwhenshooting' => { 90 => 0x0, 91 => 0x1, 94 => 0x1 },
	'setting' => { 536 => 'setting' },
	'shadingcompensation' => { 329 => 0x50c, 353 => 0x8a },
	'shadingcompensation2' => { 333 => 0x1012 },
	'shadow' => { 431 => 0xe },
	'shadowadj' => { 108 => 0x2030b },
	'shadowcorrection' => { 389 => 0x79 },
	'shadowprotection' => { 300 => 0x0 },
	'shadows' => { 124 => 0xfe52, 455 => 0x2032, 512 => 'Shadows', 518 => 'Shadows', 520 => 'Shadows' },
	'shadows2012' => { 518 => 'Shadows2012', 520 => 'Shadows2012' },
	'shadowsadj' => { 492 => 0x901a },
	'shadowscale' => { 124 => 0xc633 },
	'shadowtint' => { 518 => 'ShadowTint', 520 => 'ShadowTint' },
	'shadowtone' => { 132 => 0x1040 },
	'shakereduction' => { 391 => 0x1, 392 => 0x1 },
	'shareduserrating' => { 185 => 'WM/SharedUserRating' },
	'sharpendetail' => { 518 => 'SharpenDetail', 520 => 'SharpenDetail' },
	'sharpenedgemasking' => { 518 => 'SharpenEdgeMasking', 520 => 'SharpenEdgeMasking' },
	'sharpening' => { 355 => 0x300b },
	'sharpeningadj' => { 304 => 0x2b },
	'sharpeningkernel' => { 144 => 0x92f },
	'sharpenradius' => { 518 => 'SharpenRadius', 520 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 36 => 0xf, 67 => 0x6, 78 => 0x2, 117 => 0xb, 118 => [0x3011,0x21], 124 => [0xa40a,0xfe56], 132 => 0x1001, 146 => 0x6b, 155 => 0x37, 162 => 'Sharpness', 187 => 0x21, 188 => 0x30, 189 => 0x26, 190 => 0x18, 195 => 0x3, 242 => 0x6, 259 => 0x32, 260 => 0x33, 261 => 0x39, 334 => 0x100f, 353 => 0x41, 389 => 0x21, 396 => 0xb, 415 => 0x26, 417 => 0x56, 420 => 0x22, 421 => [0x1003,0x1014], 431 => 0x11, 441 => 0x1c, 442 => 0x19, 455 => 0x2006, 487 => 0x52, 518 => 'Sharpness', 520 => 'Sharpness', 524 => 'Sharpness' },
	'sharpnessadj' => { 108 => 0x20310, 113 => 0x25a, 492 => 0x801a },
	'sharpnessadjon' => { 108 => '0x20310.0' },
	'sharpnessauto' => { 75 => 0x94 },
	'sharpnessfactor' => { 334 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 74 => 0x64, 75 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 78 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 74 => 0x34, 75 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 74 => 0x7c, 75 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 74 => 0x4c, 75 => 0x4c },
	'sharpnessovershoot' => { 492 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 74 => 0x1c, 75 => 0x1c },
	'sharpnessrange' => { 455 => 0x2035 },
	'sharpnesssetting' => { 329 => 0x506, 337 => 0x1013, 443 => 0x12, 460 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 74 => 0x4, 75 => 0x4 },
	'sharpnessstrength' => { 108 => 0x20311 },
	'sharpnessthreshold' => { 492 => 0x801d },
	'sharpnessundershoot' => { 492 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 74 => 0x94, 75 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 74 => 0xac, 75 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 74 => 0xc4, 75 => 0xdc },
	'shiftcols' => { 144 => 0xc70 },
	'shootid' => { 536 => 'shootID' },
	'shootingdistance' => { 108 => 0x20701 },
	'shootinginfodisplay' => { 308 => '13.2', 309 => '5.1', 317 => '10.2', 318 => '4.1', 321 => '5.1', 323 => '5.3' },
	'shootinginfomonitorofftime' => { 308 => '26.2', 309 => '22.2', 311 => '22.2', 312 => '22.2', 316 => '21.2', 317 => '9.1', 318 => '21.2', 321 => '22.2', 322 => '22.2', 323 => '22.2', 324 => 0x3d, 325 => 0x37, 326 => 0x37, 327 => 0x37 },
	'shootingmode' => { 162 => 'ShootingMode', 242 => 0x89, 353 => 0x1f },
	'shootingmodesetting' => { 310 => '5.1' },
	'shortdescription' => { 522 => 'shortdescription' },
	'shortdocumentid' => { 137 => 0xba },
	'shortname' => { 518 => 'ShortName', 520 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 89 => 0x80d },
	'shorttitle' => { 406 => '@sti' },
	'shotdate' => { 547 => 'shotDate' },
	'shotday' => { 547 => 'shotDay' },
	'shotlocation' => { 547 => 'shotLocation' },
	'shotlogdata' => { 500 => 'shot_log_data' },
	'shotname' => { 414 => 'shot', 547 => 'shotName' },
	'shotnumber' => { 547 => 'shotNumber' },
	'shotnumbersincepowerup' => { 459 => 0x44e, 478 => 0x1a, 479 => 0x16, 480 => 0xa },
	'shotnumbersincepowerup2' => { 443 => 0x200 },
	'shotsize' => { 547 => 'shotSize' },
	'shotsperinterval' => { 231 => 0x180, 246 => 0x1f0, 247 => 0xb4, 248 => 0xcc, 249 => 0xcc, 250 => 0xc0, 251 => 0xd0, 252 => 0xd0 },
	'showmovement' => { 406 => 'shwm' },
	'shownevent' => { 532 => 'EventExt' },
	'showneventidentifier' => { 532 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 532 => [\'EventExt','EventExtName'] },
	'shutter' => { 474 => 0x20, 475 => 0x26, 476 => 0x26 },
	'shutter-aelock' => { 87 => 0x4, 89 => 0x701, 90 => 0x3, 91 => 0x4, 92 => 0x3, 93 => 0x3, 94 => 0x4, 95 => 0x2 },
	'shutteraelbutton' => { 88 => 0x4 },
	'shutterbuttonafonbutton' => { 89 => 0x701 },
	'shuttercount' => { 11 => 0x176, 30 => [0xa95,0x293], 33 => 0xaf1, 60 => 0x1, 242 => 0xa7, 272 => [0x6a,0x157,0x24d], 273 => 0x286, 274 => 0x279, 275 => 0x284, 276 => 0x242, 277 => 0x280, 278 => 0x276, 279 => [0x27d,0x27f], 280 => 0x246, 282 => 0x2d6, 283 => 0x321, 284 => 0xbd8, 285 => 0x287, 286 => 0x320, 287 => 0x24a, 288 => 0x5fb, 289 => 0x2d5, 389 => 0x5d, 452 => 0x846, 458 => [0x125,0x14a], 474 => 0x32, 475 => 0x3a, 476 => 0x3a, 477 => 0xa },
	'shuttercount2' => { 474 => 0x4c, 475 => [0x50,0x52,0x58], 476 => 0x50 },
	'shuttercount3' => { 474 => [0x1a0,0x1aa,0x1bd], 475 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 87 => 0xf, 88 => 0xf, 89 => 0x305, 90 => 0xe, 91 => 0xf, 92 => 0x8, 93 => 0x8, 94 => 0xf, 95 => 0x8 },
	'shuttermode' => { 60 => 0x17, 146 => 0x1b, 242 => 0x34 },
	'shutterreleasebuttonae-l' => { 308 => '17.7', 309 => '18.4', 311 => '78.4', 312 => '78.4', 313 => '16.1', 314 => '17.1', 315 => '17.1', 316 => '17.1', 317 => '7.1', 318 => '17.5', 321 => '18.4', 322 => '78.4', 323 => '18.2', 324 => 0x2b, 325 => 0x29, 326 => 0x29, 327 => 0x29 },
	'shutterreleasemethod' => { 102 => 0x1010 },
	'shutterreleasenocfcard' => { 87 => 0x2, 88 => 0x2, 95 => 0xf },
	'shutterreleasetiming' => { 102 => 0x1011 },
	'shutterreleasewithoutlens' => { 89 => 0x711 },
	'shutterspeedlock' => { 309 => '38.1', 311 => '38.1', 312 => '38.1', 321 => '38.1', 322 => '38.1', 324 => 0xbb, 325 => 0xb7, 326 => 0xb7, 327 => 0xb7 },
	'shutterspeedrange' => { 89 => 0x10c },
	'shutterspeedsetting' => { 190 => 0x6, 441 => 0x2f, 442 => 0x28, 443 => 0x0 },
	'shutterspeedvalue' => { 98 => 0x1, 124 => 0x9201, 334 => 0x1000, 398 => 0x400, 524 => 'ShutterSpeedValue' },
	'shuttertype' => { 132 => 0x1050, 353 => 0x9f, 389 => 0x87, 480 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 535 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 144 => 0xe0d },
	'sigmascalingfactorcamera' => { 144 => 0xe0c },
	'sigmascalingfactorlowres' => { 144 => 0xe0b },
	'sigmasizetable' => { 144 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 242 => 0xbf, 246 => 0x9b7 },
	'similarityindex' => { 137 => 0xe4 },
	'singleframebracketing' => { 190 => 0x21 },
	'skilllevel' => { 539 => 'skillLevel' },
	'skintonecorrection' => { 389 => 0x95 },
	'skiplinetime' => { 144 => 0x184e },
	'slaveflashmeteringsegments' => { 389 => 0x20b },
	'slideshowname' => { 536 => 'slideshowName' },
	'slideshownumber' => { 536 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 536 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 246 => 0x364, 248 => 0x24a, 249 => 0x24a, 252 => 0x24a },
	'slowshutter' => { 81 => 0x8 },
	'slowsync' => { 132 => 0x1030 },
	'smartalbumcolor' => { 428 => 0x20 },
	'smartrange' => { 428 => 0xa012 },
	'smileshutter' => { 443 => 0x31 },
	'smileshuttermode' => { 443 => 0x27 },
	'smoothness' => { 124 => 0xfe57, 518 => 'Smoothness', 520 => 'Smoothness' },
	'snapshot' => { 532 => 'SnapshotLink' },
	'snapshotformat' => { 532 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 532 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 532 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 532 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 532 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 513 => 'Snapshots' },
	'snapshotusedvideoframe' => { 532 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 532 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 532 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 532 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 532 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 455 => 0x200f },
	'software' => { 124 => 0x131, 163 => 'Software', 342 => 'Software', 398 => 0x203, 408 => 'software', 431 => 0x18, 503 => 'Software', 543 => 'Software' },
	'softwareversion' => { 414 => ['@swr',"\xa9swr"], 430 => 0x207 },
	'soloist' => { 406 => "\xa9sol" },
	'songwriter' => { 414 => "\xa9swf" },
	'songwriterkeywords' => { 414 => "\xa9swk" },
	'sonycropsize' => { 124 => 0x74c8 },
	'sonycroptopleft' => { 124 => 0x74c7 },
	'sonydatetime' => { 463 => 0x6, 465 => 0x1b6, 466 => 0x210, 467 => 0x1fe, 468 => 0x22c },
	'sonydatetime2' => { 474 => 0x51 },
	'sonyexposuretime' => { 474 => 0x3a, 475 => 0x46, 476 => [0x66,0x46], 477 => 0x1a },
	'sonyexposuretime2' => { 487 => 0xe },
	'sonyfnumber' => { 474 => 0x3c, 475 => 0x48, 476 => [0x68,0x48], 477 => 0x1c, 487 => 0x14 },
	'sonyimageheight' => { 463 => 0x1a, 478 => 0x44, 479 => 0x3f },
	'sonyimageheightmax' => { 487 => 0x40 },
	'sonyimagesize' => { 190 => 0x3b, 441 => 0x54, 442 => 0x54, 443 => 0x9 },
	'sonyimagewidth' => { 463 => 0x1c },
	'sonyimagewidthmax' => { 487 => 0x3e },
	'sonyiso' => { 465 => 0x1218, 466 => 0x11f4, 467 => 0x1270, 468 => [0x1254,0x1258,0x1280], 469 => 0x113c, 470 => 0x344, 471 => 0x346, 472 => 0x320, 487 => 0x4 },
	'sonymaxaperture' => { 474 => 0x0, 475 => 0x0 },
	'sonymaxaperturevalue' => { 487 => 0x16 },
	'sonyminaperture' => { 474 => 0x1, 475 => 0x1 },
	'sonymodelid' => { 455 => 0xb001 },
	'sonyquality' => { 190 => 0x3c },
	'sonyrawimagesize' => { 124 => 0x7038 },
	'sonytimeminsec' => { 475 => 0x61 },
	'sortalbum' => { 406 => 'soal' },
	'sortalbumartist' => { 406 => 'soaa' },
	'sortartist' => { 406 => 'soar' },
	'sortcomposer' => { 406 => 'soco' },
	'sortname' => { 406 => 'sonm', 518 => 'SortName', 520 => 'SortName' },
	'sortshow' => { 406 => 'sosn' },
	'soundengineer' => { 406 => "\xa9sne" },
	'source' => { 137 => 0x73, 342 => 'Source', 521 => 'source', 522 => 'source', 535 => 'Source' },
	'sourcecount' => { 507 => 'SourceCount' },
	'sourcecredits' => { 414 => "\xa9src" },
	'sourcedirectoryindex' => { 375 => 0x0 },
	'sourcefileindex' => { 375 => 0x2 },
	'sourcephotoscount' => { 506 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 144 => 0x1390 },
	'spatialfrequencyresponse' => { 524 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 524 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 524 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 524 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 524 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 547 => 'speakerPlacement' },
	'specialeffectlevel' => { 118 => 0x3030 },
	'specialeffectmode' => { 118 => 0x2076 },
	'specialeffectsetting' => { 118 => 0x3031 },
	'specialinstructions' => { 137 => 0x28 },
	'specialmode' => { 334 => 0x200, 430 => 0x200 },
	'specialoccasion' => { 539 => 'specialOccasion' },
	'specialtypeid' => { 500 => 'SpecialTypeID' },
	'spectralsensitivity' => { 124 => 0x8824, 524 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 43 => 0x32b, 44 => 0x281, 45 => 0x295, 48 => [0x2b9,0x2d0,0x2d4], 49 => [0x56a,0x296], 50 => 0x1e4, 51 => [0x1fd,0x2dd], 52 => [0x231,0x30f], 53 => 0x31d },
	'speedx' => { 120 => 0x3, 414 => "\xa9xsp" },
	'speedy' => { 120 => 0x4, 414 => "\xa9ysp" },
	'speedz' => { 120 => 0x5, 414 => "\xa9zsp" },
	'spherical' => { 507 => 'Spherical' },
	'sphericalvideoxml' => { 125 => 'SphericalVideoXML' },
	'splitcolumn' => { 398 => 0x222 },
	'splittoningbalance' => { 518 => 'SplitToningBalance', 520 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 518 => 'SplitToningHighlightHue', 520 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 518 => 'SplitToningHighlightSaturation', 520 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 518 => 'SplitToningShadowHue', 520 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 518 => 'SplitToningShadowSaturation', 520 => 'SplitToningShadowSaturation' },
	'sport' => { 537 => 'sport' },
	'spotfocuspointx' => { 187 => 0x2d },
	'spotfocuspointy' => { 187 => 0x2e },
	'spotmeteringmode' => { 36 => 0x27 },
	'spotmeterlinktoafpoint' => { 89 => 0x107 },
	'sractive' => { 369 => '17.1' },
	'srawquality' => { 36 => 0x2e },
	'srfocallength' => { 391 => 0x3 },
	'srgbrendering' => { 340 => 'sRGB' },
	'srhalfpresstime' => { 391 => 0x2 },
	'srresult' => { 391 => 0x0, 392 => 0x0 },
	'stackedimage' => { 329 => 0x804 },
	'standardmatrixcustom' => { 144 => 0x7d4 },
	'standardmatrixdaylight' => { 144 => 0x7d0 },
	'standardmatrixflash' => { 144 => 0x7d3 },
	'standardmatrixfluorescent' => { 144 => 0x7d2 },
	'standardmatrixtungsten' => { 144 => 0x7d1 },
	'standardoutputhighlightpoint' => { 114 => 0x14 },
	'standardoutputsensitivity' => { 124 => 0x8831, 525 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 114 => 0x15 },
	'standardrawcolortone' => { 114 => 0xd },
	'standardrawcontrast' => { 114 => 0xf },
	'standardrawhighlight' => { 114 => 0x75 },
	'standardrawhighlightpoint' => { 114 => 0x12 },
	'standardrawlinear' => { 114 => 0x10 },
	'standardrawsaturation' => { 114 => 0xe },
	'standardrawshadow' => { 114 => 0x7e },
	'standardrawshadowpoint' => { 114 => 0x13 },
	'standardrawsharpness' => { 114 => 0x11 },
	'standardunsharpmaskfineness' => { 114 => 0x94 },
	'standardunsharpmaskstrength' => { 114 => 0x92 },
	'standardunsharpmaskthreshold' => { 114 => 0x96 },
	'standardwhitecustom' => { 144 => 0x838 },
	'standardwhitedaylight' => { 144 => 0x834 },
	'standardwhiteflash' => { 144 => 0x837 },
	'standardwhitefluorescent' => { 144 => 0x836 },
	'standardwhitetungsten' => { 144 => 0x835 },
	'standbytimer' => { 309 => '19.1', 311 => '19.1', 312 => '19.1', 315 => '18.1', 316 => '18.1', 321 => '19.1', 322 => '19.1' },
	'starlightview' => { 325 => 0x249, 326 => 0x249, 327 => 0x261 },
	'startingpage' => { 537 => 'startingPage' },
	'startmovieshooting' => { 89 => 0x70d },
	'starttimecode' => { 414 => "\xa9TIM", 547 => 'startTimecode' },
	'starttimecodetimeformat' => { 547 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 547 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 547 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 414 => "\xa9TSZ", 547 => 'startTimeSampleSize' },
	'starttimescale' => { 414 => "\xa9TSC", 547 => 'startTimeScale' },
	'state' => { 167 => 'State', 353 => 0x6b, 535 => 'State' },
	'status' => { 498 => 'Status', 511 => 'Status' },
	'stereomode' => { 507 => 'StereoMode' },
	'stitched' => { 507 => 'Stitched' },
	'stitchingsoftware' => { 506 => 'StitchingSoftware', 507 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 464 => 0x113e, 465 => 0x113e, 466 => 0x111a, 467 => 0x1196, 468 => 0x1172, 469 => 0x102a, 470 => 0x222, 471 => 0x222, 472 => 0x217, 487 => 0xa },
	'storagemethod' => { 194 => 0x12 },
	'storebyorientation' => { 309 => '46.3', 311 => '47.3', 312 => '47.3', 321 => '47.3', 322 => '47.3', 324 => 0xd, 325 => 0xd, 326 => 0xd, 327 => 0xd },
	'storedescription' => { 406 => 'sdes' },
	'storylineidentifier' => { 532 => 'StorylineIdentifier' },
	'straightenangle' => { 301 => 0x2fc08431 },
	'streamready' => { 532 => 'StreamReady' },
	'streamtype' => { 182 => 'StreamType' },
	'stretchmode' => { 547 => 'stretchMode' },
	'studydatetime' => { 495 => 'StudyDateTime' },
	'studydescription' => { 495 => 'StudyDescription' },
	'studyid' => { 495 => 'StudyID' },
	'studyphysician' => { 495 => 'StudyPhysician' },
	'styleperiod' => { 532 => 'StylePeriod' },
	'sub-location' => { 137 => 0x5c },
	'subcommanddialframeadvancezoom' => { 252 => 0x806 },
	'subcommanddialplaybackmode' => { 325 => 0x1cf, 326 => 0x1cf, 327 => 0x1e7 },
	'subcommanddialvideoplaybackmode' => { 325 => 0x1d1, 327 => 0x1e9 },
	'subfiledata' => { 170 => 'data' },
	'subfiledirectory' => { 170 => '1Directory' },
	'subfilemimetype' => { 170 => '2MIME' },
	'subfilename' => { 170 => '1Name' },
	'subfileresource' => { 170 => 'rsrc' },
	'subfiletype' => { 124 => 0xfe, 170 => '0Type' },
	'subject' => { 338 => 'Subject', 405 => 'Subject', 521 => 'subject', 534 => 'Subject', 548 => 'subject' },
	'subjectarea' => { 124 => 0x9214, 524 => 'SubjectArea' },
	'subjectcode' => { 531 => 'SubjectCode' },
	'subjectdetection' => { 246 => 0x36e, 248 => 0x252, 249 => 0x252, 250 => 0x23e, 251 => 0x252, 252 => 0x252 },
	'subjectdetectionareamf' => { 246 => 0x3ea },
	'subjectdistance' => { 124 => 0x9206, 146 => 0x3e, 524 => 'SubjectDistance' },
	'subjectdistancerange' => { 124 => 0xa40c, 524 => 'SubjectDistanceRange' },
	'subjectlocation' => { 124 => 0xa214, 524 => 'SubjectLocation' },
	'subjectmotion' => { 311 => '78.2', 312 => '78.2', 322 => '78.2', 325 => 0x103, 326 => 0x103, 327 => 0x119 },
	'subjectprogram' => { 187 => 0x22 },
	'subjectreference' => { 137 => 0xc },
	'subjecttodetect' => { 2 => 0x14 },
	'sublabels1' => { 530 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 530 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 119 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 119 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 119 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 124 => 0x9290 },
	'subsectimedigitized' => { 124 => 0x9292 },
	'subsectimeoriginal' => { 124 => 0x9291 },
	'subsection1' => { 537 => 'subsection1' },
	'subsection2' => { 537 => 'subsection2' },
	'subsection3' => { 537 => 'subsection3' },
	'subsection4' => { 537 => 'subsection4' },
	'subselector' => { 309 => '49.1', 311 => '71.1', 312 => '71.1', 322 => '71.1', 324 => 0x93, 325 => 0x8f, 326 => 0x8f, 327 => 0x8f },
	'subselectorassignment' => { 309 => '48.1' },
	'subselectorcenter' => { 311 => '72.1', 312 => '72.1', 322 => '72.1' },
	'subselectorplusdials' => { 309 => '49.2', 311 => '73.1', 312 => '73.1', 322 => '73.1' },
	'subtitle' => { 185 => 'WM/SubTitle', 406 => "\xa9st3", 414 => "\xa9snm", 537 => 'subtitle' },
	'subtitlekeywords' => { 414 => "\xa9snk" },
	'subversionfilename' => { 530 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 530 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 530 => 'SubVersions' },
	'superimposeddisplay' => { 87 => 0xa, 89 => 0x510, 90 => 0x9, 91 => 0xa, 94 => 0xa, 95 => 0xe },
	'supermacro' => { 68 => 0x1a },
	'supplementalcategories' => { 137 => 0x14, 535 => 'SupplementalCategories' },
	'supplementaltype' => { 139 => 0x37 },
	'supplementdisplayid' => { 537 => 'supplementDisplayID' },
	'supplementstartingpage' => { 537 => 'supplementStartingPage' },
	'supplementtitle' => { 537 => 'supplementTitle' },
	'supplychainsource' => { 532 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 532 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 532 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 518 => 'SupportsAmount', 520 => 'SupportsAmount' },
	'supportscolor' => { 518 => 'SupportsColor', 520 => 'SupportsColor' },
	'supportshighdynamicrange' => { 518 => 'SupportsHighDynamicRange', 520 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 518 => 'SupportsMonochrome', 520 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 518 => 'SupportsNormalDynamicRange', 520 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 518 => 'SupportsOutputReferred', 520 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 518 => 'SupportsSceneReferred', 520 => 'SupportsSceneReferred' },
	'svisosetting' => { 369 => 0x14 },
	'swatchcoloranta' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 552 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 552 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 552 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 552 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 552 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 353 => 0x93, 443 => 0x33 },
	'sweeppanoramafieldofview' => { 353 => 0x94 },
	'sweeppanoramasize' => { 443 => 0x32 },
	'switchtoregisteredafpoint' => { 88 => 0x12, 89 => 0x50a },
	'symlink' => { 125 => 'SymLink' },
	'syncreleasemode' => { 311 => '77.1', 312 => '77.1', 322 => '77.1', 324 => 0x45, 325 => 0x41, 326 => 0x41, 327 => 0x41 },
	'system' => { 398 => 0x204 },
	'tagged' => { 400 => 0xdd, 401 => 'Tagged', 513 => 'tagged' },
	'tagslist' => { 523 => 'TagsList' },
	'tagstructure' => { 530 => 'TagStructure' },
	'takenumber' => { 547 => 'takeNumber' },
	'tapename' => { 547 => 'tapeName' },
	'targetaperture' => { 81 => 0x4 },
	'targetaspectratio' => { 343 => 'TargetAspectRatio' },
	'targetcompressionratio' => { 100 => 0x1 },
	'targetdistancesetting' => { 102 => 0x1807 },
	'targetexposuretime' => { 81 => 0x5 },
	'targetimagetype' => { 102 => 0x100a },
	'targetprinter' => { 124 => 0x151 },
	'taxon' => { 123 => 'Taxon' },
	'taxonacceptednameusage' => { 123 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 123 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 123 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 123 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 123 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 123 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 123 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 123 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 123 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 123 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 123 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 123 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 123 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 123 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 123 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 123 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 123 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 123 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 123 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 123 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 123 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 123 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 123 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 123 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 123 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 123 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 123 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 123 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 123 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 123 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 123 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 123 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 123 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 123 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 144 => 0x196f },
	'tda1edgepolarity' => { 144 => 0x1971 },
	'tda1gain' => { 144 => 0x1970 },
	'tda1offset' => { 144 => 0x196e },
	'tda2bandwidth' => { 144 => 0x1979 },
	'tda2edgepolarity' => { 144 => 0x197b },
	'tda2gain' => { 144 => 0x197a },
	'tda2offset' => { 144 => 0x1978 },
	'tda3bandwidth' => { 144 => 0x1983 },
	'tda3edgepolarity' => { 144 => 0x1985 },
	'tda3gain' => { 144 => 0x1984 },
	'tda3offset' => { 144 => 0x1982 },
	'tda4bandwidth' => { 144 => 0x198d },
	'tda4edgepolarity' => { 144 => 0x198f },
	'tda4gain' => { 144 => 0x198e },
	'tda4offset' => { 144 => 0x198c },
	'teaser' => { 537 => 'teaser' },
	'teleconverter' => { 192 => 0x105, 455 => 0x105 },
	'tempampgainx100' => { 144 => 0x1914 },
	'tempo' => { 547 => 'tempo' },
	'temporalcoverage' => { 532 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 532 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 532 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 339 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 339 => 'TermsAndConditionsURL' },
	'testname' => { 125 => 'TestName' },
	'textencoding' => { 241 => 0x4 },
	'textlayername' => { 535 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 535 => 'TextLayers' },
	'textlayertext' => { 535 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 353 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 518 => 'Texture', 520 => 'Texture' },
	'three-dtrackingfacedetection' => { 311 => '1.4', 312 => '1.4', 322 => '1.4' },
	'three-dtrackingwatcharea' => { 311 => '78.1', 312 => '78.1', 322 => '78.1' },
	'thresholding' => { 124 => 0x107 },
	'thumbnailfilename' => { 102 => 0x817 },
	'thumbnailformat' => { 545 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 148 => 0xfa55, 545 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 102 => 0x2008, 119 => 'Exif-ThumbnailImage', 127 => 0x3, 173 => 'data', 334 => 0x100, 406 => 'tnal', 414 => 'thmb', 545 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 173 => '1Name' },
	'thumbnailimagesize' => { 173 => 'ImageSize' },
	'thumbnailimagetype' => { 173 => '0Type' },
	'thumbnailimagevalidarea' => { 68 => 0x13 },
	'thumbnaillength' => { 124 => 0x202 },
	'thumbnailoffset' => { 124 => 0x201 },
	'thumbnailpng' => { 414 => 'thmb' },
	'thumbnails' => { 545 => 'Thumbnails' },
	'thumbnailwidth' => { 148 => 0xfa54, 545 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 537 => 'ticker' },
	'tiffhandling' => { 518 => 'TIFFHandling', 520 => 'TIFFHandling' },
	'tiffmeteringimage' => { 193 => 0x104c, 452 => 0x1110 },
	'tilelength' => { 124 => 0x143 },
	'tilewidth' => { 124 => 0x142 },
	'time' => { 144 => 0x401, 389 => 0x7 },
	'timecodes' => { 124 => 0xc763 },
	'timecreated' => { 137 => 0x3c, 146 => 0x14, 155 => 0x10, 401 => 'TimeCreated' },
	'timelapseshotnumber' => { 356 => 0x10 },
	'timeperiod' => { 537 => 'timePeriod' },
	'timerfunctionbutton' => { 310 => '5.2', 313 => '12.1', 314 => '13.1' },
	'timerlength' => { 89 => 0x80c },
	'timerrecording' => { 353 => 0x96 },
	'timescaleparams' => { 547 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 547 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 547 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 547 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 138 => 0x50 },
	'timeshot' => { 508 => 'TimeShot' },
	'timesignature' => { 547 => 'timeSignature' },
	'timesincepoweron' => { 353 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 328 => 0x8, 342 => 'TimeStamp', 353 => 0xaf, 507 => 'Timestamp', 514 => 'Timestamp', 530 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 82 => 0x1, 246 => 0x8fe, 248 => 0x694, 249 => 0x6a4, 250 => 0x594, 251 => 0x5c4, 252 => 0x5dc, 293 => 0x0, 424 => 0xa },
	'timezonecity' => { 82 => 0x2 },
	'timezonecode' => { 105 => 0x1 },
	'timezoneinfo' => { 105 => 0x2 },
	'timezoneoffset' => { 124 => 0x882a },
	'tint' => { 408 => 'player.movie.visual.tint', 518 => 'Tint', 520 => 'Tint' },
	'title' => { 163 => 'Title', 338 => 'Title', 342 => 'Title', 353 => 0x65, 405 => 'Title', 406 => ['titl',"\xa9nam"], 408 => 'title', 414 => ['titl',"\xa9nam"], 521 => 'title', 534 => 'Title', 545 => 'Title' },
	'togglestyleamount' => { 518 => 'ToggleStyleAmount', 520 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 518 => 'ToggleStyleDigest', 520 => 'ToggleStyleDigest' },
	'tonecomp' => { 242 => 0x81 },
	'tonecurve' => { 78 => 0x1, 389 => 0x402, 518 => 'ToneCurve', 520 => 'ToneCurve' },
	'tonecurveactive' => { 113 => 0x110 },
	'tonecurveadobergb' => { 428 => 0xa043 },
	'tonecurveadobergbdefault' => { 428 => 0xa041 },
	'tonecurveblue' => { 518 => 'ToneCurveBlue', 520 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 492 => 0x9003 },
	'tonecurvebluey' => { 492 => 0x9007 },
	'tonecurvebrightness' => { 108 => 0x20410 },
	'tonecurvebrightnessx' => { 492 => 0x9000 },
	'tonecurvebrightnessy' => { 492 => 0x9004 },
	'tonecurvecolorspace' => { 112 => 0x0 },
	'tonecurvecontrast' => { 108 => 0x20411 },
	'tonecurvegreen' => { 518 => 'ToneCurveGreen', 520 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 492 => 0x9002 },
	'tonecurvegreeny' => { 492 => 0x9006 },
	'tonecurveinputrange' => { 112 => 0x3 },
	'tonecurveinterpolation' => { 113 => 0x159 },
	'tonecurvemode' => { 113 => 0x113 },
	'tonecurvename' => { 518 => 'ToneCurveName', 520 => 'ToneCurveName' },
	'tonecurvename2012' => { 518 => 'ToneCurveName2012', 520 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 108 => '0x20400.1' },
	'tonecurveoutputrange' => { 112 => 0x5 },
	'tonecurveprofilename' => { 144 => 0x1391 },
	'tonecurveproperty' => { 113 => 0x3c },
	'tonecurvepv2012' => { 518 => 'ToneCurvePV2012', 520 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 518 => 'ToneCurvePV2012Blue', 520 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 518 => 'ToneCurvePV2012Green', 520 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 518 => 'ToneCurvePV2012Red', 520 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 518 => 'ToneCurveRed', 520 => 'ToneCurveRed' },
	'tonecurveredx' => { 492 => 0x9001 },
	'tonecurveredy' => { 492 => 0x9005 },
	'tonecurves' => { 389 => 0x403 },
	'tonecurveshape' => { 112 => 0x1 },
	'tonecurvesrgb' => { 428 => 0xa042 },
	'tonecurvesrgbdefault' => { 428 => 0xa040 },
	'tonecurvex' => { 112 => 0xa },
	'tonecurvey' => { 112 => 0xb },
	'tonelevel' => { 329 => 0x52e },
	'tonemap' => { 246 => 0x374, 248 => 0x26a, 249 => 0x26a },
	'tonemapstrength' => { 518 => 'ToneMapStrength', 520 => 'ToneMapStrength' },
	'toningeffect' => { 60 => 0xf, 242 => 0xb3, 259 => 0x38, 260 => 0x40, 261 => 0x48, 421 => 0x1015 },
	'toningeffectauto' => { 75 => 0xa4 },
	'toningeffectfaithful' => { 74 => 0x74, 75 => 0x74 },
	'toningeffectlandscape' => { 74 => 0x44, 75 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 74 => 0x8c, 75 => 0x8c },
	'toningeffectneutral' => { 74 => 0x5c, 75 => 0x5c },
	'toningeffectportrait' => { 74 => 0x2c, 75 => 0x2c },
	'toningeffectstandard' => { 74 => 0x14, 75 => 0x14 },
	'toningeffectuserdef1' => { 74 => 0xa4, 75 => 0xbc },
	'toningeffectuserdef2' => { 74 => 0xbc, 75 => 0xd4 },
	'toningeffectuserdef3' => { 74 => 0xd4, 75 => 0xec },
	'toningsaturation' => { 259 => 0x39, 260 => 0x41, 261 => 0x49 },
	'totalzoom' => { 146 => 0x62 },
	'touchae' => { 353 => 0xab },
	'touchfn' => { 324 => 0x154 },
	'touchfnareatall' => { 324 => 0x15b },
	'touchfnareawide' => { 324 => 0x159 },
	'touchfnrole' => { 324 => 0x155 },
	'track' => { 406 => "\xa9trk", 414 => "\xa9trk" },
	'trackcreatedate' => { 413 => 0x1 },
	'trackmodifydate' => { 413 => 0x2 },
	'tracknumber' => { 406 => 'trkn', 547 => 'trackNumber' },
	'tracks' => { 547 => 'Tracks' },
	'tracksframerate' => { 547 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 547 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 547 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 547 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 547 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 547 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 547 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 547 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 547 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 547 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 547 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 547 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 547 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 547 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 547 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 547 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 547 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 414 => 'kgtt' },
	'trailer' => { 125 => 'Trailer' },
	'trailersignature' => { 170 => 'zmie' },
	'transcript' => { 532 => 'Transcript' },
	'transcriptlink' => { 532 => 'TranscriptLink' },
	'transcriptlinklink' => { 532 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 532 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 124 => 0x12d, 543 => 'TransferFunction' },
	'transfertimenormal' => { 144 => 0x1888 },
	'transfertimetest' => { 144 => 0x1889 },
	'transform' => { 353 => [0x8012,0x59] },
	'transformation' => { 533 => 'Transformation' },
	'transmissionreference' => { 535 => 'TransmissionReference' },
	'trapped' => { 338 => 'Trapped', 534 => 'Trapped' },
	'trashbuttonfunction' => { 89 => 0x710 },
	'travelday' => { 353 => 0x36 },
	'treble' => { 408 => 'player.movie.audio.treble' },
	'triggermode' => { 415 => 0x6, 416 => 0x34, 417 => 0x34 },
	'tstop' => { 124 => 0xc772 },
	'ttl_da_adown' => { 376 => 0x5 },
	'ttl_da_aup' => { 376 => 0x4 },
	'ttl_da_bdown' => { 376 => 0x7 },
	'ttl_da_bup' => { 376 => 0x6 },
	'tungstenawb' => { 366 => 0x1 },
	'tvepisode' => { 406 => 'tves' },
	'tvepisodeid' => { 406 => 'tven' },
	'tvexposuretimesetting' => { 369 => 0x12 },
	'tvnetworkname' => { 406 => 'tvnn' },
	'tvseason' => { 406 => 'tvsn' },
	'tvshow' => { 406 => 'tvsh' },
	'type' => { 502 => 'Type', 521 => 'type', 542 => 'type' },
	'typestatus' => { 123 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 124 => 0xc614 },
	'uniquedocumentid' => { 137 => 0xbb },
	'uniquematrixauto' => { 144 => 0x7e9 },
	'uniquematrixcustom' => { 144 => 0x7e8 },
	'uniquematrixdaylight' => { 144 => 0x7e4 },
	'uniquematrixflash' => { 144 => 0x7e7 },
	'uniquematrixfluorescent' => { 144 => 0x7e6 },
	'uniquematrixtungsten' => { 144 => 0x7e5 },
	'uniqueobjectname' => { 138 => 0x64 },
	'units' => { 503 => 'Units' },
	'unknown_aacr' => { 406 => 'AACR' },
	'unknown_cdek' => { 406 => 'CDEK' },
	'unknown_cdet' => { 406 => 'CDET' },
	'unknownblock' => { 389 => 0x405 },
	'unknownblock1' => { 333 => 0x635 },
	'unknownblock2' => { 333 => 0x636 },
	'unknownblock3' => { 333 => 0x1103 },
	'unknownblock4' => { 333 => 0x1104 },
	'unknowncontrast' => { 114 => 0x45 },
	'unknowndate' => { 398 => 0x212 },
	'unknownev' => { 144 => 0x1 },
	'unknownlinear' => { 114 => 0x46 },
	'unknownnumber' => { 102 => 0x180b },
	'unknownoutputhighlightpoint' => { 114 => 0x4a },
	'unknownoutputshadowpoint' => { 114 => 0x4b },
	'unknownrawhighlight' => { 114 => 0x7b },
	'unknownrawhighlightpoint' => { 114 => 0x48 },
	'unknownrawshadow' => { 114 => 0x84 },
	'unknownrawshadowpoint' => { 114 => 0x49 },
	'unknownsharpness' => { 114 => 0x47 },
	'unknowntags' => { 414 => 'TAGS' },
	'unknowntemperature' => { 126 => 0x4 },
	'unknownthumbnail' => { 414 => 'thmb' },
	'unsharp1color' => { 306 => 0x13 },
	'unsharp1halowidth' => { 306 => 0x19 },
	'unsharp1intensity' => { 306 => 0x17 },
	'unsharp1threshold' => { 306 => 0x1b },
	'unsharp2color' => { 306 => 0x2e },
	'unsharp2halowidth' => { 306 => 0x34 },
	'unsharp2intensity' => { 306 => 0x32 },
	'unsharp2threshold' => { 306 => 0x36 },
	'unsharp3color' => { 306 => 0x49 },
	'unsharp3halowidth' => { 306 => 0x4f },
	'unsharp3intensity' => { 306 => 0x4d },
	'unsharp3threshold' => { 306 => 0x51 },
	'unsharp4color' => { 306 => 0x64 },
	'unsharp4halowidth' => { 306 => 0x6a },
	'unsharp4intensity' => { 306 => 0x68 },
	'unsharp4threshold' => { 306 => 0x6c },
	'unsharpcount' => { 306 => 0x0 },
	'unsharpmask' => { 114 => 0x90, 301 => 0x76a43200 },
	'unsharpmaskfineness' => { 78 => 0xe, 108 => 0x20309 },
	'unsharpmaskstrength' => { 108 => 0x20308 },
	'unsharpmaskthreshold' => { 78 => 0xf, 108 => 0x2030a },
	'uprightcentermode' => { 518 => 'UprightCenterMode', 520 => 'UprightCenterMode' },
	'uprightcenternormx' => { 518 => 'UprightCenterNormX', 520 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 518 => 'UprightCenterNormY', 520 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 518 => 'UprightDependentDigest', 520 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 518 => 'UprightFocalLength35mm', 520 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 518 => 'UprightFocalMode', 520 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 518 => 'UprightFourSegments_0', 520 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 518 => 'UprightFourSegments_1', 520 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 518 => 'UprightFourSegments_2', 520 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 518 => 'UprightFourSegments_3', 520 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 518 => 'UprightFourSegmentsCount', 520 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 518 => 'UprightGuidedDependentDigest', 520 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 518 => 'UprightPreview', 520 => 'UprightPreview' },
	'uprighttransform_0' => { 518 => 'UprightTransform_0', 520 => 'UprightTransform_0' },
	'uprighttransform_1' => { 518 => 'UprightTransform_1', 520 => 'UprightTransform_1' },
	'uprighttransform_2' => { 518 => 'UprightTransform_2', 520 => 'UprightTransform_2' },
	'uprighttransform_3' => { 518 => 'UprightTransform_3', 520 => 'UprightTransform_3' },
	'uprighttransform_4' => { 518 => 'UprightTransform_4', 520 => 'UprightTransform_4' },
	'uprighttransform_5' => { 518 => 'UprightTransform_5', 520 => 'UprightTransform_5' },
	'uprighttransformcount' => { 518 => 'UprightTransformCount', 520 => 'UprightTransformCount' },
	'uprightversion' => { 518 => 'UprightVersion', 520 => 'UprightVersion' },
	'urgency' => { 137 => 0xa, 535 => 'Urgency' },
	'url' => { 163 => 'URL', 342 => 'URL', 403 => 0x40b, 537 => 'url' },
	'url_list' => { 403 => 0x41e },
	'urla-platform' => { 537 => [\'url','urlA-platform'] },
	'urlurl' => { 537 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 89 => 0x10a },
	'usableshootingmodes' => { 89 => 0x109 },
	'usage' => { 538 => 'usage' },
	'usageterms' => { 551 => 'UsageTerms' },
	'usbpowerdelivery' => { 246 => 0x9ac, 248 => 0x762, 249 => 0x772, 250 => 0x664, 251 => 0x694, 252 => 0x6fc },
	'usedialwithouthold' => { 324 => 0xc3, 325 => 0xbf, 326 => 0xbf, 327 => 0xbf },
	'useguidelines' => { 516 => 'useGuidelines' },
	'usepanoramaviewer' => { 506 => 'UsePanoramaViewer' },
	'usercollection' => { 408 => 'collection.user' },
	'usercomment' => { 102 => 0x805, 124 => 0x9286, 524 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 74 => 0xd8, 75 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 74 => 0xda, 75 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 74 => 0xdc, 75 => 0xf4 },
	'userfields' => { 511 => 'UserFields' },
	'userlabel' => { 415 => 0x2b, 416 => 0x5a, 417 => 0x68 },
	'userprofile' => { 348 => 0x302, 352 => 0x34c, 355 => 0x3038 },
	'userrating' => { 408 => 'rating.user', 414 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 88 => 0x7, 89 => 0x501 },
	'uspsnumber' => { 537 => 'uspsNumber' },
	'utmeasting' => { 174 => 'Easting' },
	'utmmapdatum' => { 174 => 'Datum' },
	'utmnorthing' => { 174 => 'Northing' },
	'utmzone' => { 174 => 'Zone' },
	'uuid' => { 518 => 'UUID', 520 => 'UUID' },
	'uv-irfiltercorrection' => { 348 => 0x325 },
	'validbits' => { 333 => 0x611, 334 => 0x102c },
	'validcropcorners' => { 343 => 'ValidCropCorners' },
	'validpixeldepth' => { 337 => 0x611 },
	'variablelowpassfilter' => { 455 => 0x2028 },
	'variousmodes' => { 146 => 0x26 },
	'variousmodes2' => { 146 => 0x3a },
	'variprogram' => { 242 => 0xab },
	'varraydacnominalvalues' => { 144 => 0x191e },
	'vendor' => { 414 => 'vndr' },
	'vendorinfo' => { 496 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 496 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 496 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 496 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 123 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 132 => 0x0, 343 => 'Version', 405 => 'Version', 408 => 'version', 518 => 'Version', 520 => 'Version', 529 => 'Version' },
	'versioncreatedate' => { 492 => 0xd100 },
	'versionid' => { 548 => 'VersionID' },
	'versionidentifier' => { 537 => 'versionIdentifier' },
	'versionmodifydate' => { 492 => 0xd101 },
	'versions' => { 548 => 'Versions' },
	'versionscomments' => { 548 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 548 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 548 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 548 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 548 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 548 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 548 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 548 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 548 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 548 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 548 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 308 => '3.2', 309 => '47.2', 311 => '79.1', 326 => 0x11d, 327 => 0x135 },
	'verticalclockoverlaps' => { 144 => 0x412 },
	'verticalfuncbutton' => { 309 => '42.2', 311 => '67.1', 326 => 0x115, 327 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 326 => 0x1b7, 327 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 309 => '43.1' },
	'verticalfuncplusdials' => { 311 => '68.1' },
	'verticalisobutton' => { 252 => 0x792 },
	'verticalmovieafonbutton' => { 326 => 0x1f9, 327 => 0x211 },
	'verticalmoviefuncbutton' => { 326 => 0x1e1, 327 => 0x1f9 },
	'verticalmultiselector' => { 309 => '42.1', 311 => '66.1', 312 => '66.1', 322 => '66.1', 326 => 0x18f, 327 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 326 => 0x125, 327 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 89 => [0x510,0x51d] },
	'vibrance' => { 512 => 'Vibrance', 518 => 'Vibrance', 520 => 'Vibrance' },
	'vibrationreduction' => { 272 => [0x75,0x82,0x1ae], 280 => '586.1', 287 => '590.2', 291 => 0x4 },
	'videoalphamode' => { 547 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 547 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 547 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 547 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 532 => 'videoBitRate' },
	'videobitratemode' => { 532 => 'videoBitRateMode' },
	'videoburstmode' => { 353 => 0xbb },
	'videoburstresolution' => { 353 => 0xb3 },
	'videocodec' => { 71 => 0x74 },
	'videocolorspace' => { 547 => 'videoColorSpace' },
	'videocompression' => { 132 => 0x3806 },
	'videocompressor' => { 547 => 'videoCompressor' },
	'videodisplayaspectratio' => { 532 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 532 => 'videoEncodingProfile' },
	'videofieldorder' => { 547 => 'videoFieldOrder' },
	'videoframerate' => { 353 => 0x27, 547 => 'videoFrameRate' },
	'videoframesize' => { 547 => 'videoFrameSize' },
	'videoframesizeh' => { 547 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 547 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 547 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 547 => 'videoModDate' },
	'videopixelaspectratio' => { 547 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 547 => 'videoPixelDepth' },
	'videopreburst' => { 353 => 0xc1 },
	'videoquality' => { 118 => 0x4003 },
	'videorecordingmode' => { 132 => 0x3803 },
	'videoshottype' => { 532 => 'VideoShotType' },
	'videoshottypeidentifier' => { 532 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 532 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 532 => 'videoStreamsCount' },
	'viewfinder' => { 398 => 0x455 },
	'viewfinderdisplay' => { 308 => '12.4', 309 => '6.3' },
	'viewfinderwarning' => { 308 => '13.4', 318 => '3.5', 319 => '6.2', 323 => '4.4' },
	'viewfinderwarnings' => { 89 => 0x40a },
	'viewinfoduringexposure' => { 89 => 0x407 },
	'viewingmode' => { 443 => 0x2f, 460 => 0x18 },
	'viewingmode2' => { 443 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 252 => 0x7d2, 325 => 0x2a9 },
	'viewpoint' => { 536 => 'viewpoint' },
	'vignetteamount' => { 518 => 'VignetteAmount', 520 => 'VignetteAmount' },
	'vignettecoefficient1' => { 292 => 0x24 },
	'vignettecoefficient2' => { 292 => 0x34 },
	'vignettecoefficient3' => { 292 => 0x44 },
	'vignettecontrol' => { 242 => 0x2a, 301 => 0x76a43205 },
	'vignettecontrolintensity' => { 301 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 515 => 'VignetteCorrectionAlreadyApplied' },
	'vignettecorrectionversion' => { 292 => 0x0 },
	'vignettemidpoint' => { 518 => 'VignetteMidpoint', 520 => 'VignetteMidpoint' },
	'vignetting' => { 421 => 0x1011, 428 => 0xa052 },
	'vignettingcorrection' => { 124 => 0x7031, 428 => 0xa053, 455 => 0x2011 },
	'vignettingcorrparams' => { 124 => 0x7032, 486 => 0x64a, 487 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 428 => 0xa054 },
	'virtualfocallength' => { 533 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 324 => 0x161, 325 => 0x167, 326 => 0x167, 327 => 0x17f },
	'virtualimagexcenter' => { 533 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 533 => 'VirtualImageYCenter' },
	'visualcolor' => { 532 => 'VisualColour' },
	'visualtechnique' => { 536 => 'visualTechnique' },
	'voicememo' => { 430 => 0x216 },
	'volume' => { 537 => 'volume' },
	'vr_0x66' => { 272 => 0x66 },
	'vrdoffset' => { 68 => 0xd0 },
	'vrmode' => { 246 => 0x342, 248 => 0x226, 249 => 0x226, 250 => 0x212, 251 => 0x226, 252 => 0x226, 291 => 0x6 },
	'vrtype' => { 291 => 0x8 },
	'waterdepth' => { 124 => 0x9403, 525 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 193 => 0x19a },
	'wb_bluelevel6500k' => { 193 => 0x18a },
	'wb_bluelevelcustom' => { 193 => 0x18e },
	'wb_bluelevelscloudy' => { 193 => 0x106 },
	'wb_bluelevelsdaylight' => { 193 => 0xea },
	'wb_bluelevelsflash' => { 193 => 0x122 },
	'wb_bluelevelsfluorescent' => { 193 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 193 => 0x254 },
	'wb_bluelevelsshade' => { 193 => 0x176 },
	'wb_bluelevelstungsten' => { 193 => 0xce },
	'wb_gbrglevels' => { 193 => 0xae, 196 => 0x4 },
	'wb_glevel' => { 333 => 0x11f },
	'wb_glevel3000k' => { 333 => 0x113 },
	'wb_glevel3300k' => { 333 => 0x114 },
	'wb_glevel3600k' => { 333 => 0x115 },
	'wb_glevel3900k' => { 333 => 0x116 },
	'wb_glevel4000k' => { 333 => 0x117 },
	'wb_glevel4300k' => { 333 => 0x118 },
	'wb_glevel4500k' => { 333 => 0x119 },
	'wb_glevel4800k' => { 333 => 0x11a },
	'wb_glevel5300k' => { 333 => 0x11b },
	'wb_glevel6000k' => { 333 => 0x11c },
	'wb_glevel6600k' => { 333 => 0x11d },
	'wb_glevel7500k' => { 333 => 0x11e },
	'wb_grbglevels' => { 210 => 0x0, 462 => 0x7303 },
	'wb_grbglevelsauto' => { 85 => 0x2, 462 => 0x7302 },
	'wb_grbglevelscloudy' => { 85 => 0x12 },
	'wb_grbglevelscustom1' => { 85 => 0x42 },
	'wb_grbglevelscustom2' => { 85 => 0x4a },
	'wb_grbglevelsdaylight' => { 85 => 0xa },
	'wb_grbglevelsflash' => { 85 => 0x32 },
	'wb_grbglevelsfluorescent' => { 85 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 85 => 0x2a },
	'wb_grbglevelstungsten' => { 85 => 0x1a },
	'wb_grbglevelsunderwater' => { 85 => 0x3a },
	'wb_rbgglevels' => { 207 => 0x0 },
	'wb_rblevels' => { 211 => 0x270, 242 => 0xc, 333 => 0x100 },
	'wb_rblevels1' => { 359 => 0x2 },
	'wb_rblevels2' => { 359 => 0x5 },
	'wb_rblevels3' => { 359 => 0x8 },
	'wb_rblevels3000k' => { 333 => 0x102 },
	'wb_rblevels3300k' => { 333 => 0x103 },
	'wb_rblevels3500k' => { 193 => 0x430 },
	'wb_rblevels3600k' => { 333 => 0x104 },
	'wb_rblevels3900k' => { 333 => 0x105 },
	'wb_rblevels4' => { 359 => 0xb },
	'wb_rblevels4000k' => { 333 => 0x106 },
	'wb_rblevels4300k' => { 333 => 0x107 },
	'wb_rblevels4500k' => { 333 => 0x108 },
	'wb_rblevels4800k' => { 333 => 0x109 },
	'wb_rblevels5' => { 359 => 0xe },
	'wb_rblevels5300k' => { 333 => 0x10a },
	'wb_rblevels6' => { 359 => 0x11 },
	'wb_rblevels6000k' => { 333 => 0x10b },
	'wb_rblevels6500k' => { 193 => 0x420 },
	'wb_rblevels6600k' => { 333 => 0x10c },
	'wb_rblevels7' => { 359 => 0x14 },
	'wb_rblevels7500k' => { 333 => 0x10d },
	'wb_rblevelsauto' => { 211 => 0x272, 337 => 0x110 },
	'wb_rblevelscloudy' => { 193 => 0x3f0, 195 => 0x10, 211 => 0x296, 337 => 0x121 },
	'wb_rblevelscoolwhitef' => { 193 => 0x308, 195 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 337 => 0x132 },
	'wb_rblevelscustom' => { 193 => 0x424, 195 => 0x1c },
	'wb_rblevelscwb1' => { 333 => 0x10e },
	'wb_rblevelscwb2' => { 333 => 0x10f },
	'wb_rblevelscwb3' => { 333 => 0x110 },
	'wb_rblevelscwb4' => { 333 => 0x111 },
	'wb_rblevelsdaylight' => { 193 => [0x3ec,0x528], 195 => 0xc, 211 => 0x274 },
	'wb_rblevelsdaylightf' => { 195 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 337 => 0x130 },
	'wb_rblevelsdaywhitef' => { 195 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 337 => 0x131 },
	'wb_rblevelseveningsunlight' => { 337 => 0x124 },
	'wb_rblevelsfineweather' => { 337 => 0x122 },
	'wb_rblevelsflash' => { 193 => [0x3f4,0x304], 195 => 0x18, 211 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 211 => 0x290 },
	'wb_rblevelsincandescent' => { 211 => 0x282 },
	'wb_rblevelsshade' => { 193 => 0x418, 195 => 0x20, 211 => 0x2b2, 337 => 0x120 },
	'wb_rblevelstungsten' => { 193 => 0x3e8, 195 => 0x8, 337 => 0x123 },
	'wb_rblevelsused' => { 337 => 0x100 },
	'wb_rblevelswhitef' => { 195 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 337 => 0x133 },
	'wb_redlevel3500k' => { 193 => 0x198 },
	'wb_redlevel6500k' => { 193 => 0x188 },
	'wb_redlevelcustom' => { 193 => 0x18c },
	'wb_redlevelscloudy' => { 193 => 0xf8 },
	'wb_redlevelsdaylight' => { 193 => 0xdc },
	'wb_redlevelsflash' => { 193 => 0x114 },
	'wb_redlevelsfluorescent' => { 193 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 193 => 0x1be },
	'wb_redlevelsshade' => { 193 => 0x168 },
	'wb_redlevelstungsten' => { 193 => 0xc0 },
	'wb_rgbglevels' => { 209 => 0x0 },
	'wb_rgblevels' => { 193 => [0x546,0x96], 349 => 0xd, 350 => 0x413, 355 => 0x3036, 398 => 0x107, 464 => 0x117c, 465 => 0x1180, 466 => 0x115c, 467 => 0x11d8, 468 => 0x11b4, 469 => 0x106c, 470 => 0x264, 471 => 0x264, 472 => 0x252 },
	'wb_rgblevels1' => { 360 => 0x2 },
	'wb_rgblevels2' => { 360 => 0x6 },
	'wb_rgblevels2500k' => { 462 => 0x782d },
	'wb_rgblevels3' => { 360 => 0xa },
	'wb_rgblevels3200k' => { 462 => 0x782c },
	'wb_rgblevels4' => { 360 => 0xe },
	'wb_rgblevels4500k' => { 462 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 360 => 0x12 },
	'wb_rgblevels6' => { 360 => 0x16 },
	'wb_rgblevels6000k' => { 462 => 0x782b },
	'wb_rgblevels7' => { 360 => 0x1a },
	'wb_rgblevels8500k' => { 462 => 0x782a },
	'wb_rgblevelsauto' => { 432 => 0x0 },
	'wb_rgblevelscloudy' => { 462 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 432 => 0x15 },
	'wb_rgblevelscustom2' => { 432 => 0x18 },
	'wb_rgblevelscustom3' => { 432 => 0x1b },
	'wb_rgblevelsdaylight' => { 432 => 0x3, 462 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 432 => 0x12, 462 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 432 => 0xf, 462 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 462 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 462 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 462 => 0x7828 },
	'wb_rgblevelsincandescent' => { 432 => 0xc },
	'wb_rgblevelsovercast' => { 432 => 0x9 },
	'wb_rgblevelsshade' => { 432 => 0x6, 462 => 0x7825 },
	'wb_rgblevelstungsten' => { 462 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 433 => 0x0 },
	'wb_rgblevelsunknown1' => { 433 => 0x3 },
	'wb_rgblevelsunknown2' => { 433 => 0x6 },
	'wb_rgblevelsunknown3' => { 433 => 0x9 },
	'wb_rgblevelsunknown4' => { 433 => 0xc },
	'wb_rgblevelsunknown5' => { 433 => 0xf },
	'wb_rgblevelsunknown6' => { 433 => 0x12 },
	'wb_rgblevelsunknown7' => { 433 => 0x15 },
	'wb_rgblevelsunknown8' => { 433 => 0x18 },
	'wb_rgblevelsunknown9' => { 433 => 0x1b },
	'wb_rgbmuldaylight' => { 144 => 0x852 },
	'wb_rgbmulflash' => { 144 => 0x855 },
	'wb_rgbmulfluorescent' => { 144 => 0x854 },
	'wb_rgbmultungsten' => { 144 => 0x853 },
	'wb_rggbblacklevels' => { 37 => 0x25 },
	'wb_rggblevels' => { 124 => 0x7313, 196 => 0x4, 208 => 0x0, 212 => 0x13e8, 213 => 0x38, 462 => 0x7313 },
	'wb_rggblevelsasshot' => { 40 => 0x0, 41 => 0x0, 42 => 0x19, 43 => 0x55, 44 => 0x69, 45 => 0x69, 46 => 0x22, 47 => 0x3f, 50 => 0x3f, 51 => 0x3f, 52 => 0x3f, 53 => 0x47 },
	'wb_rggblevelsauto' => { 37 => 0x1, 40 => 0x5, 41 => 0x8, 42 => 0x1e, 43 => 0x5a, 44 => 0x6e, 46 => 0x18, 47 => 0x44, 50 => 0x44, 51 => 0x44, 52 => 0x44, 53 => 0x4c, 212 => 0x1478, 213 => 0x114, 428 => 0xa022, 462 => 0x7312 },
	'wb_rggblevelsblack' => { 428 => 0xa028 },
	'wb_rggblevelscloudy' => { 37 => 0xd, 40 => 0x1e, 41 => 0x30, 42 => 0x2d, 43 => 0xa0, 44 => 0xd7, 45 => 0x78, 46 => 0x31, 47 => 0x58, 50 => 0x71, 51 => 0x8a, 52 => 0x8f, 53 => 0x92, 212 => 0x1408, 213 => 0x60, 389 => 0x20f, 397 => 0x14 },
	'wb_rggblevelscustom' => { 37 => 0x1d, 47 => 0x80, 212 => 0x1468, 213 => 0x100 },
	'wb_rggblevelscustom1' => { 42 => 0x41 },
	'wb_rggblevelscustom2' => { 42 => 0x46 },
	'wb_rggblevelsdaylight' => { 37 => 0x5, 40 => 0x14, 41 => 0x20, 42 => 0x23, 43 => 0x96, 44 => 0xcd, 45 => 0x6e, 46 => 0x27, 47 => 0x4e, 50 => 0x67, 51 => 0x80, 52 => 0x85, 53 => 0x88, 212 => 0x13f8, 213 => 0x4c, 389 => 0x20d, 397 => 0x2 },
	'wb_rggblevelsflash' => { 37 => 0x19, 40 => 0x32, 41 => 0x50, 42 => 0x3c, 43 => 0xb4, 44 => 0xeb, 45 => 0x87, 46 => 0x45, 47 => 0x6c, 50 => 0x85, 51 => 0x9e, 52 => 0xa3, 53 => 0xa6, 212 => 0x1448, 389 => 0x214, 397 => 0x41 },
	'wb_rggblevelsfluorescent' => { 37 => 0x15, 40 => 0x28, 41 => 0x40, 42 => 0x37, 43 => 0xaa, 44 => 0xe1, 45 => 0x82, 46 => 0x3b, 47 => 0x62, 50 => 0x7b, 51 => 0x94, 52 => 0x99, 53 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 213 => 0xc4, 389 => 0x211, 397 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 397 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 213 => 0xb0, 389 => 0x212, 397 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 212 => 0x1438, 213 => 0x9c, 389 => 0x213, 397 => 0x38 },
	'wb_rggblevelshtmercury' => { 213 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 428 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 428 => 0xa024 },
	'wb_rggblevelskelvin' => { 37 => 0x21, 40 => 0x2d, 41 => 0x48, 43 => 0xaf, 44 => 0xe6, 46 => 0x40, 47 => 0x67, 50 => 0x80, 51 => 0x99, 52 => 0x9e, 53 => 0xa1 },
	'wb_rggblevelsmeasured' => { 40 => 0xa, 41 => 0x10, 43 => 0x5f, 44 => 0x73, 47 => 0x49, 50 => 0x49, 51 => 0x49, 52 => 0x49, 53 => 0x51 },
	'wb_rggblevelspc1' => { 46 => 0x90, 47 => 0x71 },
	'wb_rggblevelspc2' => { 46 => 0x95, 47 => 0x76 },
	'wb_rggblevelspc3' => { 46 => 0x9a, 47 => 0x7b },
	'wb_rggblevelsshade' => { 37 => 0x9, 40 => 0x19, 41 => 0x28, 42 => 0x28, 43 => 0x9b, 44 => 0xd2, 45 => 0x73, 46 => 0x2c, 47 => 0x53, 50 => 0x6c, 51 => 0x85, 52 => 0x8a, 53 => 0x8d, 213 => 0x74, 389 => 0x20e, 397 => 0xb },
	'wb_rggblevelstungsten' => { 37 => 0x11, 40 => 0x23, 41 => 0x38, 42 => 0x32, 43 => 0xa5, 44 => 0xdc, 45 => 0x7d, 46 => 0x36, 47 => 0x5d, 50 => 0x76, 51 => 0x8f, 52 => 0x94, 53 => 0x97, 212 => 0x1428, 213 => 0x88, 389 => 0x210, 397 => 0x1d },
	'wb_rggblevelsuncorrected' => { 428 => 0xa021 },
	'wb_rggblevelsunknown' => { 40 => 0xf, 41 => 0x18, 43 => 0x64, 44 => 0x78, 46 => 0x1d, 50 => 0x4e, 51 => 0x4e, 52 => 0x4e, 53 => 0x56, 397 => 0x53 },
	'wb_rggblevelsunknown10' => { 40 => 0x5f, 41 => 0x98, 43 => 0x91, 44 => 0xa5, 45 => 0xb4, 46 => 0x72, 50 => 0x9e, 51 => 0x7b, 52 => 0x7b, 53 => 0x83 },
	'wb_rggblevelsunknown11' => { 40 => 0x64, 41 => 0xa0, 43 => 0xb9, 44 => [0xaa,0xaf], 45 => 0xb9, 46 => 0x77, 50 => 0xa3, 51 => 0xa3, 52 => 0x80, 53 => 0xab },
	'wb_rggblevelsunknown12' => { 40 => 0x69, 41 => 0xa8, 43 => 0xbe, 44 => 0xb4, 45 => 0xbe, 46 => 0x7c, 50 => 0xa8, 51 => 0xa8, 52 => 0xa8, 53 => 0xb0 },
	'wb_rggblevelsunknown13' => { 40 => 0x6e, 41 => 0xb0, 43 => 0xc3, 44 => 0xb9, 45 => 0xc3, 46 => 0x81, 50 => 0xad, 51 => 0xad, 52 => 0xad, 53 => 0xb5 },
	'wb_rggblevelsunknown14' => { 43 => 0xc8, 44 => 0xbe, 45 => 0xc8, 46 => 0x86, 50 => 0xb2, 51 => 0xb2, 52 => 0xb2, 53 => 0xba },
	'wb_rggblevelsunknown15' => { 43 => 0xcd, 44 => 0xc3, 45 => 0xcd, 46 => 0x8b, 50 => 0xb7, 51 => 0xb7, 52 => 0xb7, 53 => 0xbf },
	'wb_rggblevelsunknown16' => { 43 => 0xd2, 44 => 0xc8, 45 => 0xd2, 46 => 0x9f, 51 => 0xbc, 52 => 0xbc, 53 => 0xc4 },
	'wb_rggblevelsunknown17' => { 43 => 0xd7, 44 => 0xf0, 45 => 0xd7, 51 => 0xc1, 52 => 0xc1, 53 => 0xc9 },
	'wb_rggblevelsunknown18' => { 43 => 0xdc, 44 => 0xf5, 45 => 0xdc, 51 => 0xc6, 52 => 0xc6, 53 => 0xce },
	'wb_rggblevelsunknown19' => { 43 => 0xe1, 44 => 0xfa, 45 => 0xe1, 51 => 0xcb, 52 => 0xcb, 53 => 0xd3 },
	'wb_rggblevelsunknown2' => { 40 => 0x37, 41 => 0x58, 43 => 0x69, 44 => 0x7d, 45 => 0x8c, 46 => 0x4a, 50 => 0x53, 51 => 0x53, 52 => 0x53, 53 => 0x5b },
	'wb_rggblevelsunknown20' => { 43 => 0xe6, 44 => 0xff, 45 => 0xe6, 51 => 0xd0, 52 => 0xd0, 53 => 0xd8 },
	'wb_rggblevelsunknown21' => { 43 => 0xeb, 44 => 0x104, 45 => 0xeb, 52 => 0xd5, 53 => 0xdd },
	'wb_rggblevelsunknown22' => { 43 => 0xf0, 44 => 0x109, 45 => 0xf0, 52 => 0xda, 53 => 0xe2 },
	'wb_rggblevelsunknown23' => { 43 => 0xf5, 44 => 0x10e, 45 => 0xf5, 52 => 0xdf, 53 => 0xe7 },
	'wb_rggblevelsunknown24' => { 43 => 0xfa, 44 => 0x113, 45 => 0xfa, 52 => 0xe4, 53 => 0xec },
	'wb_rggblevelsunknown25' => { 43 => 0xff, 44 => 0x118, 45 => 0xff, 52 => 0xe9, 53 => 0xf1 },
	'wb_rggblevelsunknown26' => { 43 => 0x104, 44 => 0x11d, 45 => 0x104, 52 => 0xee, 53 => 0xf6 },
	'wb_rggblevelsunknown27' => { 43 => 0x109, 44 => 0x122, 45 => 0x109, 52 => 0xf3, 53 => 0xfb },
	'wb_rggblevelsunknown28' => { 43 => 0x10e, 45 => 0x10e, 52 => 0xf8, 53 => 0x100 },
	'wb_rggblevelsunknown29' => { 43 => 0x113, 45 => 0x113, 52 => 0xfd, 53 => 0x105 },
	'wb_rggblevelsunknown3' => { 40 => 0x3c, 41 => 0x60, 43 => 0x6e, 44 => 0x82, 45 => 0x91, 46 => 0x4f, 50 => 0x58, 51 => 0x58, 52 => 0x58, 53 => 0x60 },
	'wb_rggblevelsunknown30' => { 45 => 0x118, 52 => 0x102 },
	'wb_rggblevelsunknown31' => { 45 => 0x11d },
	'wb_rggblevelsunknown32' => { 45 => 0x122 },
	'wb_rggblevelsunknown33' => { 45 => 0x127 },
	'wb_rggblevelsunknown4' => { 40 => 0x41, 41 => 0x68, 43 => 0x73, 44 => 0x87, 45 => 0x96, 46 => 0x54, 50 => 0x5d, 51 => 0x5d, 52 => 0x5d, 53 => 0x65 },
	'wb_rggblevelsunknown5' => { 40 => 0x46, 41 => 0x70, 43 => 0x78, 44 => 0x8c, 45 => 0x9b, 46 => 0x59, 50 => 0x62, 51 => 0x62, 52 => 0x62, 53 => 0x6a },
	'wb_rggblevelsunknown6' => { 40 => 0x4b, 41 => 0x78, 43 => 0x7d, 44 => 0x91, 45 => 0xa0, 46 => 0x5e, 50 => 0x8a, 51 => 0x67, 52 => 0x67, 53 => 0x6f },
	'wb_rggblevelsunknown7' => { 40 => 0x50, 41 => 0x80, 43 => 0x82, 44 => 0x96, 45 => 0xa5, 46 => 0x63, 50 => 0x8f, 51 => 0x6c, 52 => 0x6c, 53 => 0x74 },
	'wb_rggblevelsunknown8' => { 40 => 0x55, 41 => 0x88, 43 => 0x87, 44 => 0x9b, 45 => 0xaa, 46 => 0x68, 50 => 0x94, 51 => 0x71, 52 => 0x71, 53 => 0x79 },
	'wb_rggblevelsunknown9' => { 40 => 0x5a, 41 => 0x90, 43 => 0x8c, 44 => 0xa0, 45 => 0xaf, 46 => 0x6d, 50 => 0x99, 51 => 0x76, 52 => 0x76, 53 => 0x7e },
	'wb_rggblevelsuserselected' => { 397 => 0x5c },
	'wbadjblueamber' => { 108 => 0x20106 },
	'wbadjbluebalance' => { 307 => 0x8 },
	'wbadjcolortemp' => { 108 => 0x20102, 113 => 0x1a },
	'wbadjlighting' => { 307 => 0x14 },
	'wbadjmagentagreen' => { 108 => 0x20105 },
	'wbadjmode' => { 307 => 0x10 },
	'wbadjredbalance' => { 307 => 0x0 },
	'wbadjrggblevels' => { 108 => 0x20125, 113 => 0x6 },
	'wbadjtemperature' => { 307 => 0x18 },
	'wbadjtint' => { 307 => 0x25 },
	'wbbluelevel' => { 348 => 0x324, 353 => 0x8006, 358 => 0x26 },
	'wbbracketingsteps' => { 204 => 0x10, 205 => 0x10, 281 => 0x174d },
	'wbbracketmode' => { 60 => 0x9 },
	'wbbracketshotnumber' => { 193 => 0x2b, 421 => 0x101a },
	'wbbracketvalueab' => { 60 => 0xc },
	'wbbracketvaluegm' => { 60 => 0xd },
	'wbbutton' => { 249 => 0x806, 252 => 0x80a },
	'wbbuttonplaybackmode' => { 325 => 0x1c5 },
	'wbfinetuneactive' => { 113 => 0x24 },
	'wbfinetunesaturation' => { 113 => 0x28 },
	'wbfinetunetone' => { 113 => 0x2c },
	'wbgreenlevel' => { 348 => 0x323, 353 => 0x8005, 358 => 0x25 },
	'wbmediaimagesizesetting' => { 89 => 0x708 },
	'wbmode' => { 195 => 0x4, 334 => 0x1015 },
	'wbredlevel' => { 348 => 0x322, 353 => 0x8004, 358 => 0x24 },
	'wbscale' => { 196 => 0x0 },
	'wbshiftab' => { 78 => 0xc, 353 => 0x46, 370 => 0x10 },
	'wbshiftab_gm' => { 455 => 0x2014 },
	'wbshiftab_gm_precise' => { 455 => 0x2026 },
	'wbshiftcreativecontrol' => { 353 => 0x92 },
	'wbshiftgm' => { 78 => 0xd, 353 => 0x47, 370 => 0x11 },
	'wbshiftintelligentauto' => { 353 => 0x8b },
	'wbtype1' => { 359 => 0x1, 360 => 0x1 },
	'wbtype2' => { 359 => 0x4, 360 => 0x5 },
	'wbtype3' => { 359 => 0x7, 360 => 0x9 },
	'wbtype4' => { 359 => 0xa, 360 => 0xd },
	'wbtype5' => { 359 => 0xd, 360 => 0x11 },
	'wbtype6' => { 359 => 0x10, 360 => 0x15 },
	'wbtype7' => { 359 => 0x13, 360 => 0x19 },
	'webstatement' => { 551 => 'WebStatement' },
	'weightedflatsubject' => { 510 => 'weightedFlatSubject' },
	'what' => { 518 => 'What', 520 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 78 => 0x8, 81 => 0x7, 117 => 0x7, 118 => [0x19,0x2012], 124 => [0xa403,0xfe4e], 132 => 0x1002, 144 => 0x3fc, 145 => 0xfa0d, 146 => 0x40, 157 => 0x1a, 187 => 0x3, 188 => 0xe, 189 => 0x4, 190 => 0xb, 192 => 0x115, 242 => 0x5, 290 => 0x7, 348 => 0x304, 353 => 0x3, 355 => 0x3033, 389 => 0x19, 396 => 0x7, 420 => 0x26, 421 => 0x1003, 431 => [0x88,0x3c,0x7,0x58], 441 => 0xf, 442 => 0xe, 455 => [0x115,0xb054], 518 => 'WhiteBalance', 520 => 'WhiteBalance', 524 => 'WhiteBalance' },
	'whitebalance0' => { 182 => 'WhiteBalance0' },
	'whitebalance1' => { 182 => 'WhiteBalance1' },
	'whitebalance2' => { 182 => 'WhiteBalance2', 329 => 0x500 },
	'whitebalanceadj' => { 108 => 0x20101, 113 => 0x18, 301 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 366 => 0x0 },
	'whitebalancebias' => { 118 => 0x2011, 334 => 0x304, 353 => 0x23 },
	'whitebalanceblue' => { 78 => 0x7 },
	'whitebalancebracket' => { 329 => 0x502, 334 => 0x303 },
	'whitebalancebracketing' => { 190 => 0x22, 193 => 0x2c, 452 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 326 => 0x1c5, 327 => 0x1dd },
	'whitebalancecomp' => { 337 => 0x1001 },
	'whitebalancedetected' => { 144 => 0x3fb },
	'whitebalancefinetune' => { 132 => 0x100a, 190 => 0x38, 192 => 0x112, 242 => [0xb,0x3f], 421 => 0x1004, 441 => 0x6, 442 => 0x5, 455 => 0x112 },
	'whitebalancemode' => { 144 => 0x3fa, 389 => 0x1a },
	'whitebalancered' => { 78 => 0x6 },
	'whitebalanceset' => { 369 => 0xa },
	'whitebalancesetting' => { 190 => 0x23, 441 => 0x5, 442 => 0x4, 443 => 0x16, 460 => 0xd },
	'whitebalancesetup' => { 428 => 0x41 },
	'whitebalancetemperature' => { 329 => 0x501 },
	'whiteboard' => { 334 => 0x301 },
	'whitelevel' => { 124 => 0xc61d, 389 => 0x7e, 462 => 0x787f },
	'whitepoint' => { 124 => 0x13e, 352 => 0x35d, 389 => 0x201, 543 => 'WhitePoint' },
	'whites2012' => { 518 => 'Whites2012', 520 => 'Whites2012' },
	'whitesadj' => { 492 => 0x9017 },
	'wideadapter' => { 421 => 0x1017 },
	'widefocuszone' => { 187 => 0x2f },
	'widerange' => { 430 => 0x20f },
	'windmode' => { 144 => 0x3f4 },
	'windnoisereduction' => { 248 => 0x352, 249 => 0x352, 250 => 0x2d6, 251 => 0x2fe, 252 => 0x2fe },
	'windowlocation' => { 414 => 'WLOC' },
	'windowsatom' => { 519 => 'windowsAtom' },
	'windowsatomextension' => { 519 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 519 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 519 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 537 => 'wordCount' },
	'work' => { 406 => "\xa9wrk" },
	'workcolorspace' => { 108 => 0x10200, 113 => 0x270 },
	'workflowtag' => { 532 => 'WorkflowTag' },
	'workflowtagcvid' => { 532 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 532 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 532 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 532 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 526 => 'WorkToDo' },
	'worldtimelocation' => { 353 => 0x3a, 389 => 0x22, 395 => '0.1' },
	'writer' => { 185 => 'WM/Writer' },
	'writer-editor' => { 137 => 0x7a },
	'x3filllight' => { 431 => 0x12 },
	'xattrmditemwherefroms' => { 180 => 'com.apple.metadata:kMDItemWhereFroms' },
	'xattrquarantine' => { 180 => 'com.apple.quarantine' },
	'xiaomiexifinfo' => { 408 => 'xiaomi.exifInfo.videoinfo' },
	'xiaomihdr10' => { 408 => 'com.xiaomi.hdr10' },
	'xiaomimodel' => { 124 => 0x9a00 },
	'xiaomipreviewvideocover' => { 408 => 'com.xiaomi.preview_video_cover' },
	'xiaomisettings' => { 124 => 0x9999 },
	'xilinxversion' => { 144 => 0x414 },
	'xml' => { 142 => 'xml ' },
	'xmp' => { 111 => 0xffff00f6, 125 => 'XMP', 135 => 'XMP Data/XMP' },
	'xmptoolkit' => { 544 => 'xmptk' },
	'xpauthor' => { 124 => 0x9c9d },
	'xpcomment' => { 124 => 0x9c9c },
	'xpkeywords' => { 124 => 0x9c9e },
	'xposition' => { 124 => 0x11e },
	'xpsubject' => { 124 => 0x9c9f },
	'xptitle' => { 124 => 0x9c9b },
	'xresolution' => { 124 => 0x11a, 140 => 0x3, 404 => 0x0, 543 => 'XResolution' },
	'xyresolution' => { 128 => 0x3 },
	'yaw' => { 120 => 0x7, 414 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 257 => 0x8, 426 => 0x0 },
	'ycbcrcoefficients' => { 124 => 0x211, 543 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 124 => 0x213, 543 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 124 => 0x212, 543 => 'YCbCrSubSampling' },
	'year' => { 406 => 'yrrc', 408 => 'year', 414 => 'yrrc' },
	'yearcreated' => { 146 => 0x10, 155 => 0xc },
	'yellowhsl' => { 108 => 0x20912 },
	'yield' => { 539 => 'yield' },
	'yposition' => { 124 => 0x11f },
	'yresolution' => { 124 => 0x11b, 140 => 0x5, 404 => 0x4, 543 => 'YResolution' },
	'zebrapatterntonerange' => { 325 => 0x211, 326 => 0x211, 327 => 0x229 },
	'zoneidentifier' => { 125 => 'ZoneIdentifier' },
	'zonematching' => { 192 => 0x10a, 195 => [0x3a,0x4a], 455 => 0xb024 },
	'zonematchingmode' => { 190 => 0x14 },
	'zonematchingon' => { 189 => 0x75 },
	'zonematchingvalue' => { 441 => 0x1f },
	'zoomedpreviewlength' => { 334 => 0xf05 },
	'zoomedpreviewsize' => { 334 => 0xf06 },
	'zoomedpreviewstart' => { 334 => 0xf04 },
	'zoomsourcewidth' => { 36 => 0x24 },
	'zoomstepcount' => { 332 => 0x300, 334 => 0x100d },
	'zoomtargetwidth' => { 36 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acdsee-rs' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actors' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aistream' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'alerts' => 1,
	'alexa' => 1,
	'alexa-paireddevicename' => 1,
	'alexa-pairing' => 1,
	'alexa-privacymode' => 1,
	'alexa-wakewordlanguage' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiolevel' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autopoweroff' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetoothmacaddress' => 1,
	'bluetoothname' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'byterange' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pa' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfog5xii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbor' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel01' => 1,
	'channel01description' => 1,
	'channel01dispmax' => 1,
	'channel01dispmin' => 1,
	'channel01flags' => 1,
	'channel01id' => 1,
	'channel01interval' => 1,
	'channel01max' => 1,
	'channel01min' => 1,
	'channel01multiplier' => 1,
	'channel01name' => 1,
	'channel01num' => 1,
	'channel01offset' => 1,
	'channel01type' => 1,
	'channel01units' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chrominancetable' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalance0219' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown1' => 1,
	'colorbalanceunknown2' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata12' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransferfunction' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'conttake' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custominfo' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz6iii' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'date1' => 1,
	'date2' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultsettings' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'devicesounds' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digestalgorithm' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'domain' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualfiles' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'ef' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emergencysos' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'extremeweathermode' => 1,
	'f-stop' => 1,
	'f_' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fcc-id' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatsdcard' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'framedelay' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'garminmodel' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcontainer' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generalencapsulatedobject' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geob-data' => 1,
	'geob-desc' => 1,
	'geob-file' => 1,
	'geob-mime' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geolocationbearing' => 1,
	'geolocationcity' => 1,
	'geolocationcountry' => 1,
	'geolocationcountrycode' => 1,
	'geolocationdistance' => 1,
	'geolocationfeaturecode' => 1,
	'geolocationfeaturetype' => 1,
	'geolocationpopulation' => 1,
	'geolocationposition' => 1,
	'geolocationregion' => 1,
	'geolocationsubregion' => 1,
	'geolocationtimezone' => 1,
	'geolocationwarning' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalpalette' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gpmd_wolfbox' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsaltitudesystem' => 1,
	'gpsdata' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshomelatitude' => 1,
	'gpshomelongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatitude2' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongitude2' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpsstamp' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'gravityvector' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'gridsize' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'halftonedegree' => 1,
	'halftonelpi' => 1,
	'halftonelpiunit' => 1,
	'halftonemisc' => 1,
	'halftonescreen' => 1,
	'halftoneshape' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasselbladxml' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgm' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddendata' => 1,
	'hiddeninfo' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintmaxoutputvalue' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestabilisation' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imdb_id' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexbackground' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indextransparent' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'keepusersettings' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keyalgorithm' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'keyversion' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'levelinfok3iii' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'ligo_json' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedfilename' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'linux' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopcount' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'lumaaverage' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'luminancetable' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'marlindataversion' => 1,
	'marlindictionary' => 1,
	'marlinheader' => 1,
	'marlinvalues' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8' => 1,
	'menusettingsoffsetz8v2' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microphonewet' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modelstamp' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'mynextbase-paireddevicename' => 1,
	'mynextbase-pairing' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nbcd' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nextbasemeta' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlicenseplate' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'oleinfo' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parkingmode' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'pdrversion' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'peg_info' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopstream' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'prediminanthue' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewjxl' => 1,
	'previewjxllength' => 1,
	'previewjxlstart' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsbleedwidth' => 1,
	'printflagsbleedwidthscale' => 1,
	'printflagscrop' => 1,
	'printflagsinfo' => 1,
	'printflagsversion' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafcompression' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagenumber' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzoomactive' => 1,
	'rawzoomsize' => 1,
	'rawzoomtopleft' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinghistory' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'remasterinfo' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resolutionxlengthunit' => 1,
	'resolutionxunit' => 1,
	'resolutionylengthunit' => 1,
	'resolutionyunit' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'reversingcamera' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohinfo' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrdta' => 1,
	'ricohrdtb' => 1,
	'ricohrdtc' => 1,
	'ricohrdtg' => 1,
	'ricohrdtl' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtos' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungcaptureinfo' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungmodel' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'sceneclassification' => 1,
	'scenecolorimetryestimates' => 1,
	'sceneilluminance' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screendimming' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screensaver' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcardclass' => 1,
	'sdcardformat' => 1,
	'sdcardmanfdate' => 1,
	'sdcardmanfid' => 1,
	'sdcardmodelno' => 1,
	'sdcardoemid' => 1,
	'sdcardserialno' => 1,
	'sdcardsize' => 1,
	'sdcardtype' => 1,
	'sdcardusedspace' => 1,
	'sdcc-flp' => 1,
	'sealcomment' => 1,
	'sealversion' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondcam' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqcount' => 1,
	'seqfinal' => 1,
	'seqframeinfo' => 1,
	'seqid' => 1,
	'seqindex' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'seqtype' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz6iii' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureformat' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyhiddendata' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'speedstamp' => 1,
	'speedunits' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systeminfo' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag9406b' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailartist' => 1,
	'thumbnailbitspersample' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcolordepth' => 1,
	'thumbnailcompressedsize' => 1,
	'thumbnailcompression' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailcopyright' => 1,
	'thumbnaildata' => 1,
	'thumbnaildatetime' => 1,
	'thumbnaildescription' => 1,
	'thumbnailequipmake' => 1,
	'thumbnailequipmodel' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailimageheight' => 1,
	'thumbnailimagewidth' => 1,
	'thumbnailorientation' => 1,
	'thumbnailphotometricinterp' => 1,
	'thumbnailplanarconfig' => 1,
	'thumbnailplanes' => 1,
	'thumbnailprimarychromaticities' => 1,
	'thumbnailrawbytes' => 1,
	'thumbnailref' => 1,
	'thumbnailrefblackwhite' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailresolutionunit' => 1,
	'thumbnailresolutionx' => 1,
	'thumbnailresolutiony' => 1,
	'thumbnailrowsperstrip' => 1,
	'thumbnailsamplesperpixel' => 1,
	'thumbnailsoftware' => 1,
	'thumbnailstripbytecounts' => 1,
	'thumbnailstripoffsets' => 1,
	'thumbnailtiff' => 1,
	'thumbnailtransferfunction' => 1,
	'thumbnailurl' => 1,
	'thumbnailwhitepoint' => 1,
	'thumbnailycbcrcoefficients' => 1,
	'thumbnailycbcrpositioning' => 1,
	'thumbnailycbcrsubsampling' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'time1' => 1,
	'time2' => 1,
	'timeanddate' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelapse' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'timezonedst' => 1,
	'tipl' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'tmdb_id' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videolength' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignetteinfo' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'what3words' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wi-fimacaddress' => 1,
	'wi-fipassword' => 1,
	'wi-fissid' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windprocessing' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpdsa' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2024, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
