#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.14';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 100 => 0x69 },
	'about' => { 429 => 'about' },
	'aboutcvterm' => { 421 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 421 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 421 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 421 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 421 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'abspeakaudiofilepath' => { 435 => 'absPeakAudioFilePath' },
	'acceleration' => { 109 => 0x9404 },
	'accelerationtracking' => { 75 => 0x518 },
	'accelerometer' => { 341 => 0x3 },
	'accelerometerx' => { 279 => 0x8d },
	'accelerometery' => { 279 => 0x8e },
	'accelerometerz' => { 279 => 0x8c },
	'accessoryserialnumber' => { 279 => 0x54 },
	'accessorytype' => { 279 => 0x53 },
	'acedemicfield' => { 425 => 'acedemicField' },
	'actionadvised' => { 117 => 0x2a },
	'activearea' => { 109 => 0xc68d },
	'actived-lighting' => { 198 => 0x22, 234 => 0x24 },
	'actived-lightingmode' => { 234 => 0x25 },
	'adaptervoltage' => { 123 => 0x407 },
	'addaspectratioinfo' => { 75 => 0x80e },
	'additionalmodelinformation' => { 421 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 75 => 0x80f, 76 => 0x11, 77 => 0x13, 80 => 0x14 },
	'address' => { 144 => 'Address' },
	'adjustmentmode' => { 347 => 0x15 },
	'adlbracketingstep' => { 216 => 0x883 },
	'adlbracketingtype' => { 216 => 0x884 },
	'adobe' => { 110 => 'Adobe' },
	'adultcontentwarning' => { 268 => 'AdultContentWarning', 428 => 'adultContentWarning' },
	'advancedfilter' => { 114 => 0x1201 },
	'advancedraw' => { 236 => 0x76a43203 },
	'advancedscenetype' => { 279 => 0x3d },
	'advisory' => { 433 => 'Advisory' },
	'ae_iso' => { 286 => 0x2, 287 => 0x4, 288 => 0x12 },
	'aeaperture' => { 286 => 0x1, 287 => 0x3, 288 => 0x11 },
	'aeaperturesteps' => { 286 => 0x8, 287 => 0xb },
	'aebautocancel' => { 75 => 0x104 },
	'aebbracketvalue' => { 69 => 0x11 },
	'aebracketingsteps' => { 215 => 0x174c, 216 => 0x87b, 224 => 0x1756 },
	'aebsequence' => { 75 => 0x105 },
	'aebsequenceautocancel' => { 73 => 0x9, 74 => 0x9, 76 => 0x8, 77 => 0x9, 80 => 0x9, 81 => 0x7 },
	'aebshotcount' => { 75 => 0x106 },
	'aebxv' => { 286 => 0x4, 287 => 0x6 },
	'aeerror' => { 287 => 0x8 },
	'aeexposuretime' => { 286 => 0x0, 287 => 0x2, 288 => 0x10 },
	'aelbutton' => { 164 => 0x45 },
	'aelexposureindicator' => { 164 => 0x51 },
	'aelock' => { 164 => 0x5b, 245 => '4.2', 253 => '4.2', 258 => 0x201, 313 => 0x48, 355 => 0x40, 356 => 0x40, 357 => [0x86,0x286] },
	'aelockbutton' => { 243 => '16.1', 245 => '4.1', 247 => '15.1', 248 => '16.1', 249 => '16.1', 251 => '30.1', 252 => '16.1', 253 => '4.1', 255 => '17.1', 256 => '17.1' },
	'aelockbuttonplusdials' => { 243 => '16.2', 251 => '32.1', 255 => '44.1' },
	'aelockformb-d80' => { 256 => '3.1' },
	'aemaxaperture' => { 286 => 0x9, 287 => 0x10, 288 => 0x1c },
	'aemaxaperture2' => { 286 => 0xa, 287 => 0x11, 288 => 0x1d },
	'aemeteringmode' => { 286 => 0xc },
	'aemeteringmode2' => { 286 => '13.1' },
	'aemeteringsegments' => { 167 => 0x628, 313 => 0x209 },
	'aemicroadjustment' => { 75 => 0x110 },
	'aeminaperture' => { 286 => 0xb, 287 => 0x12, 288 => 0x1e },
	'aeminexposuretime' => { 286 => 0x5, 287 => 0x13, 288 => 0x1f },
	'aeprogrammode' => { 286 => 0x6 },
	'aeprojectlink' => { 410 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 410 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 410 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 410 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 410 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 410 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 33 => 0x21 },
	'aewhitebalance' => { 286 => 0xd },
	'aexv' => { 286 => 0x3, 287 => 0x5 },
	'af-cpriorityselection' => { 243 => '1.1', 244 => '1.1', 246 => '1.1', 248 => '0.1', 249 => '0.1', 250 => '0.1', 251 => '1.1', 252 => '0.1', 255 => '1.1' },
	'af-onbutton' => { 246 => '70.1' },
	'af-onformb-d10' => { 243 => '3.3', 251 => '3.2' },
	'af-onformb-d11' => { 252 => '2.2' },
	'af-onformb-d12' => { 255 => '50.1' },
	'af-spriorityselection' => { 243 => '1.2', 244 => '1.2', 246 => '1.4', 250 => '0.2', 251 => '1.2', 252 => '0.2', 255 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 243 => '2.1', 244 => '2.1', 246 => '78.3', 251 => '2.1', 255 => '2.1' },
	'afadjustment' => { 313 => 0x72 },
	'afandmeteringbuttons' => { 75 => 0x701 },
	'afaperture' => { 194 => 0x5, 195 => 0x5 },
	'afareaheight' => { 173 => 0x1a },
	'afareaillumination' => { 164 => 0x4b, 253 => '15.3' },
	'afareamode' => { 160 => 0x33, 164 => 0xe, 172 => 0x0, 173 => 0x5, 279 => 0xf, 338 => 0x1205, 348 => [0xa,0x3a], 355 => 0x11, 356 => 0x10, 357 => 0x24, 367 => 0xb043, 387 => 0x17 },
	'afareamodesetting' => { 245 => '11.1', 247 => '0.1', 253 => '16.1', 256 => '2.1', 367 => 0x201c },
	'afareas' => { 258 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 75 => 0x51b },
	'afareawidth' => { 173 => 0x18 },
	'afareaxposition' => { 173 => 0x14, 338 => 0x1203 },
	'afareaxposition1' => { 338 => 0x1201 },
	'afareayposition' => { 173 => 0x16, 338 => 0x1204 },
	'afareayposition1' => { 338 => 0x1202 },
	'afassist' => { 73 => 0x5, 81 => 0x5, 164 => 0x48, 243 => '2.5', 245 => '0.2', 247 => '0.2', 248 => '1.1', 249 => '1.1', 250 => '1.3', 251 => '2.4', 252 => '1.3', 253 => '0.2', 255 => '2.4', 256 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 75 => 0x50e, 76 => 0x4, 77 => 0x5, 78 => 0x4, 79 => 0x4, 80 => 0x5 },
	'afassistlamp' => { 279 => 0x31 },
	'afbuttonpressed' => { 357 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 289 => 0x6 },
	'afduringliveview' => { 75 => 0x511 },
	'affinea' => { 404 => 'AffineA' },
	'affineb' => { 404 => 'AffineB' },
	'affinec' => { 404 => 'AffineC' },
	'affined' => { 404 => 'AffineD' },
	'affinetune' => { 174 => 0x0, 258 => 0x306 },
	'affinetuneadj' => { 174 => 0x2, 208 => 0x2d1, 209 => 0x2dc, 258 => 0x307 },
	'affinetuneindex' => { 174 => 0x1 },
	'affinex' => { 404 => 'AffineX' },
	'affiney' => { 404 => 'AffineY' },
	'afhold' => { 289 => 0x1fd },
	'afilluminator' => { 355 => 0x29, 367 => 0xb044 },
	'afimageheight' => { 173 => 0x12 },
	'afimagewidth' => { 173 => 0x10 },
	'afintegrationtime' => { 289 => 0x7 },
	'afmicroadj' => { 348 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 352 => 0x131 },
	'afmicroadjregisteredlenses' => { 352 => '305.1' },
	'afmicroadjustment' => { 75 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 352 => 0x130 },
	'afmode' => { 104 => 0x3009, 114 => 0x1022, 160 => 0x16, 347 => 0x5 },
	'afmoderestrictions' => { 244 => '50.3', 246 => '48.3', 255 => '48.3' },
	'afonaelockbuttonswitch' => { 75 => 0x702 },
	'afonbutton' => { 243 => '3.1', 244 => '47.1' },
	'afpoint' => { 33 => 0x13, 103 => 0x18, 160 => 0x15, 172 => 0x1, 261 => 0x308, 347 => 0x1f, 348 => [0x37,0x7], 352 => 0x19, 353 => 0x18, 354 => [0x18,0x20] },
	'afpointactivationarea' => { 74 => 0x11, 80 => 0x11 },
	'afpointareaexpansion' => { 75 => 0x508 },
	'afpointatshutterrelease' => { 348 => [0x39,0x9] },
	'afpointautoselection' => { 75 => 0x50b },
	'afpointbrightness' => { 75 => 0x50d, 243 => '2.4', 244 => '46.5', 246 => '2.2', 255 => '2.3' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 75 => 0x50c },
	'afpointillumination' => { 74 => 0xa, 243 => '2.3', 244 => '46.2', 246 => '47.2', 250 => '1.2', 251 => '2.3', 252 => '1.2', 255 => '47.2', 256 => '2.4' },
	'afpointinfocus' => { 348 => [0x38,0x8] },
	'afpointmode' => { 294 => 0x3 },
	'afpointposition' => { 104 => 0x2021, 279 => 0x4d },
	'afpointregistration' => { 73 => 0x7 },
	'afpoints' => { 163 => 0x10 },
	'afpointselected' => { 164 => 0xd, 258 => 0x305, 313 => 0xe, 352 => 0x15, 353 => 0x14, 354 => [0x14,0x1c], 367 => 0x201e },
	'afpointselected2' => { 294 => 0x4 },
	'afpointselection' => { 74 => 0xb, 243 => '1.3', 244 => '1.3', 251 => '1.3', 255 => '1.3' },
	'afpointselectionmethod' => { 75 => 0x50f, 76 => 0xc, 77 => 0xd, 80 => 0xd },
	'afpointsetting' => { 355 => 0x12, 356 => 0x11 },
	'afpointsinfocus' => { 69 => 0xe, 172 => 0x2, 289 => 0xb, 290 => 0x4, 313 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 74 => 0xd },
	'afpointsselected' => { 290 => '4.1', 394 => 0x4 },
	'afpointsspecial' => { 290 => '4.2' },
	'afpointsunknown1' => { 289 => 0x0 },
	'afpointsunknown2' => { 289 => 0x2 },
	'afpointsused' => { 173 => 0x8, 348 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 289 => 0x4 },
	'afresponse' => { 198 => 0xad },
	'afresult' => { 263 => 0x1038 },
	'afsearch' => { 258 => 0x303 },
	'afsensoractive' => { 160 => 0x1 },
	'afstatus' => { 338 => 0x1200 },
	'afstatus_00_b4' => { 351 => 0x0 },
	'afstatus_01_c4' => { 351 => 0x2 },
	'afstatus_02_d4' => { 351 => 0x4 },
	'afstatus_03_e4' => { 351 => 0x6 },
	'afstatus_04_f4' => { 351 => 0x8 },
	'afstatus_05_g4' => { 351 => 0xa },
	'afstatus_06_h4' => { 351 => 0xc },
	'afstatus_07_b3' => { 351 => 0xe },
	'afstatus_08_c3' => { 351 => 0x10 },
	'afstatus_09_d3' => { 351 => 0x12 },
	'afstatus_10_e3' => { 351 => 0x14 },
	'afstatus_11_f3' => { 351 => 0x16 },
	'afstatus_12_g3' => { 351 => 0x18 },
	'afstatus_13_h3' => { 351 => 0x1a },
	'afstatus_14_b2' => { 351 => 0x1c },
	'afstatus_15_c2' => { 351 => 0x1e },
	'afstatus_16_d2' => { 351 => 0x20 },
	'afstatus_17_e2' => { 351 => 0x22 },
	'afstatus_18_f2' => { 351 => 0x24 },
	'afstatus_19_g2' => { 351 => 0x26 },
	'afstatus_20_h2' => { 351 => 0x28 },
	'afstatus_21_c1' => { 351 => 0x2a },
	'afstatus_22_d1' => { 351 => 0x2c },
	'afstatus_23_e1' => { 351 => 0x2e },
	'afstatus_24_f1' => { 351 => 0x30 },
	'afstatus_25_g1' => { 351 => 0x32 },
	'afstatus_26_a7_vertical' => { 351 => 0x34 },
	'afstatus_27_a6_vertical' => { 351 => 0x36 },
	'afstatus_28_a5_vertical' => { 351 => 0x38 },
	'afstatus_29_c7_vertical' => { 351 => 0x3a },
	'afstatus_30_c6_vertical' => { 351 => 0x3c },
	'afstatus_31_c5_vertical' => { 351 => 0x3e },
	'afstatus_32_e7_vertical' => { 351 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 351 => 0x42 },
	'afstatus_34_e5_vertical' => { 351 => 0x44 },
	'afstatus_35_g7_vertical' => { 351 => 0x46 },
	'afstatus_36_g6_vertical' => { 351 => 0x48 },
	'afstatus_37_g5_vertical' => { 351 => 0x4a },
	'afstatus_38_i7_vertical' => { 351 => 0x4c },
	'afstatus_39_i6_vertical' => { 351 => 0x4e },
	'afstatus_40_i5_vertical' => { 351 => 0x50 },
	'afstatus_41_a7' => { 351 => 0x52 },
	'afstatus_42_b7' => { 351 => 0x54 },
	'afstatus_43_c7' => { 351 => 0x56 },
	'afstatus_44_d7' => { 351 => 0x58 },
	'afstatus_45_e7' => { 351 => 0x5a },
	'afstatus_46_f7' => { 351 => 0x5c },
	'afstatus_47_g7' => { 351 => 0x5e },
	'afstatus_48_h7' => { 351 => 0x60 },
	'afstatus_49_i7' => { 351 => 0x62 },
	'afstatus_50_a6' => { 351 => 0x64 },
	'afstatus_51_b6' => { 351 => 0x66 },
	'afstatus_52_c6' => { 351 => 0x68 },
	'afstatus_53_d6' => { 351 => 0x6a },
	'afstatus_54_e6_center' => { 351 => 0x6c },
	'afstatus_55_f6' => { 351 => 0x6e },
	'afstatus_56_g6' => { 351 => 0x70 },
	'afstatus_57_h6' => { 351 => 0x72 },
	'afstatus_58_i6' => { 351 => 0x74 },
	'afstatus_59_a5' => { 351 => 0x76 },
	'afstatus_60_b5' => { 351 => 0x78 },
	'afstatus_61_c5' => { 351 => 0x7a },
	'afstatus_62_d5' => { 351 => 0x7c },
	'afstatus_63_e5' => { 351 => 0x7e },
	'afstatus_64_f5' => { 351 => 0x80 },
	'afstatus_65_g5' => { 351 => 0x82 },
	'afstatus_66_h5' => { 351 => 0x84 },
	'afstatus_67_i5' => { 351 => 0x86 },
	'afstatus_68_c11' => { 351 => 0x88 },
	'afstatus_69_d11' => { 351 => 0x8a },
	'afstatus_70_e11' => { 351 => 0x8c },
	'afstatus_71_f11' => { 351 => 0x8e },
	'afstatus_72_g11' => { 351 => 0x90 },
	'afstatus_73_b10' => { 351 => 0x92 },
	'afstatus_74_c10' => { 351 => 0x94 },
	'afstatus_75_d10' => { 351 => 0x96 },
	'afstatus_76_e10' => { 351 => 0x98 },
	'afstatus_77_f10' => { 351 => 0x9a },
	'afstatus_78_g10' => { 351 => 0x9c },
	'afstatus_79_h10' => { 351 => 0x9e },
	'afstatus_80_b9' => { 351 => 0xa0 },
	'afstatus_81_c9' => { 351 => 0xa2 },
	'afstatus_82_d9' => { 351 => 0xa4 },
	'afstatus_83_e9' => { 351 => 0xa6 },
	'afstatus_84_f9' => { 351 => 0xa8 },
	'afstatus_85_g9' => { 351 => 0xaa },
	'afstatus_86_h9' => { 351 => 0xac },
	'afstatus_87_b8' => { 351 => 0xae },
	'afstatus_88_c8' => { 351 => 0xb0 },
	'afstatus_89_d8' => { 351 => 0xb2 },
	'afstatus_90_e8' => { 351 => 0xb4 },
	'afstatus_91_f8' => { 351 => 0xb6 },
	'afstatus_92_g8' => { 351 => 0xb8 },
	'afstatus_93_h8' => { 351 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 351 => 0xbc },
	'afstatusactivesensor' => { 160 => 0x2, 348 => [0x4,0x3b], 352 => 0x1e, 353 => 0x1b, 354 => [0x1b,0x21] },
	'afstatusbottom' => { 160 => 0x8, 352 => 0x2a, 353 => 0x21, 354 => 0x21 },
	'afstatusbottom-left' => { 160 => 0x12, 353 => 0x2b, 354 => 0x2b },
	'afstatusbottom-right' => { 160 => 0x6, 353 => 0x1f, 354 => 0x1f },
	'afstatusbottomassist-left' => { 352 => 0x28 },
	'afstatusbottomassist-right' => { 352 => 0x2c },
	'afstatusbottomhorizontal' => { 349 => 0x10, 350 => 0x1c },
	'afstatusbottomvertical' => { 349 => 0x16, 350 => 0x26 },
	'afstatuscenter-10' => { 352 => 0x34 },
	'afstatuscenter-11' => { 352 => 0x36 },
	'afstatuscenter-12' => { 352 => 0x38 },
	'afstatuscenter-14' => { 352 => 0x3c },
	'afstatuscenter-7' => { 352 => 0x2e },
	'afstatuscenter-9' => { 352 => 0x32 },
	'afstatuscenter-horizontal' => { 352 => 0x30 },
	'afstatuscenter-vertical' => { 352 => 0x3a },
	'afstatuscenterf2-8' => { 352 => 0x4c },
	'afstatuscenterhorizontal' => { 160 => 0x2f, 349 => 0xc, 350 => 0x18, 353 => 0x2f, 354 => 0x2f },
	'afstatuscentervertical' => { 160 => 0xc, 349 => 0x14, 350 => 0x22, 353 => 0x25, 354 => 0x25 },
	'afstatusfarleft' => { 349 => 0x6, 352 => 0x26 },
	'afstatusfarlefthorizontal' => { 350 => 0x4 },
	'afstatusfarleftvertical' => { 350 => 0x12 },
	'afstatusfarright' => { 349 => 0x18, 352 => 0x44 },
	'afstatusfarrighthorizontal' => { 350 => 0x2c },
	'afstatusfarrightvertical' => { 350 => 0x34 },
	'afstatusleft' => { 160 => 0x2d, 349 => 0x2, 352 => 0x22, 353 => 0x2d, 354 => 0x2d },
	'afstatuslefthorizontal' => { 350 => 0x6 },
	'afstatusleftvertical' => { 350 => 0xe },
	'afstatuslower-left' => { 349 => 0x4, 352 => 0x24 },
	'afstatuslower-lefthorizontal' => { 350 => 0xa },
	'afstatuslower-leftvertical' => { 350 => 0x10 },
	'afstatuslower-middle' => { 349 => 0x22, 350 => 0x24 },
	'afstatuslower-right' => { 349 => 0x1e, 352 => 0x4a },
	'afstatuslower-righthorizontal' => { 350 => 0x32 },
	'afstatuslower-rightvertical' => { 350 => 0x3a },
	'afstatuslowerfarleft' => { 350 => 0x8 },
	'afstatuslowerfarright' => { 350 => 0x30 },
	'afstatusmiddlehorizontal' => { 160 => 0xa, 353 => 0x23, 354 => 0x23 },
	'afstatusnearleft' => { 349 => 0xe, 350 => 0x1a },
	'afstatusnearright' => { 349 => 0xa, 350 => 0x16 },
	'afstatusright' => { 160 => 0x31, 349 => 0x1c, 352 => 0x48, 353 => 0x31, 354 => 0x31 },
	'afstatusrighthorizontal' => { 350 => 0x2e },
	'afstatusrightvertical' => { 350 => 0x38 },
	'afstatustop' => { 160 => 0xe, 352 => 0x40, 353 => 0x27, 354 => 0x27 },
	'afstatustop-left' => { 160 => 0x10, 353 => 0x29, 354 => 0x29 },
	'afstatustop-right' => { 160 => 0x4, 353 => 0x1d, 354 => 0x1d },
	'afstatustopassist-left' => { 352 => 0x3e },
	'afstatustopassist-right' => { 352 => 0x42 },
	'afstatustophorizontal' => { 349 => 0x8, 350 => 0x14 },
	'afstatustopvertical' => { 349 => 0x12, 350 => 0x1e },
	'afstatusupper-left' => { 349 => 0x0, 352 => 0x20 },
	'afstatusupper-lefthorizontal' => { 350 => 0x2 },
	'afstatusupper-leftvertical' => { 350 => 0xc },
	'afstatusupper-middle' => { 349 => 0x20, 350 => 0x20 },
	'afstatusupper-right' => { 349 => 0x1a, 352 => 0x46 },
	'afstatusupper-righthorizontal' => { 350 => 0x2a },
	'afstatusupper-rightvertical' => { 350 => 0x36 },
	'afstatusupperfarleft' => { 350 => 0x0 },
	'afstatusupperfarright' => { 350 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 348 => 0x2 },
	'afwithshutter' => { 355 => 0x2a },
	'afzoneselected' => { 367 => 0x201e },
	'aggregateissuenumber' => { 425 => 'aggregateIssueNumber' },
	'aggregationtype' => { 425 => 'aggregationType' },
	'agreement' => { 428 => 'agreement' },
	'aiservocontinuousshooting' => { 74 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 75 => 0x519 },
	'aiservoimagepriority' => { 75 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 75 => 0x51a },
	'aiservotrackingmethod' => { 75 => 0x504 },
	'aiservotrackingsensitivity' => { 74 => 0x14, 75 => 0x502 },
	'album' => { 435 => 'album' },
	'alreadyapplied' => { 411 => 'AlreadyApplied' },
	'alternatetitle' => { 425 => 'alternateTitle' },
	'alternatetitlea-lang' => { 425 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 425 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 425 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 175 => 0x6 },
	'alttapename' => { 435 => 'altTapeName' },
	'alttimecode' => { 435 => 'altTimecode' },
	'alttimecodetimeformat' => { 435 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 435 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 435 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 109 => 0x9400, 334 => 0x14, 387 => 0x4 },
	'ambienttemperaturefahrenheit' => { 334 => 0x13 },
	'analogbalance' => { 109 => 0xc627 },
	'angleadj' => { 94 => 0x10003, 100 => 0x8b },
	'angleinforoll' => { 406 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 406 => 'AngleInfoYaw' },
	'anti-blur' => { 367 => 0xb04b },
	'antialiasstrength' => { 109 => 0xc632 },
	'aperturelock' => { 244 => '38.2', 246 => '38.2', 255 => '38.2' },
	'aperturerange' => { 75 => 0x10d },
	'apertureringuse' => { 294 => '1.4' },
	'aperturesetting' => { 164 => 0x7, 355 => 0x30, 356 => 0x29, 357 => 0x1 },
	'aperturevalue' => { 84 => 0x2, 109 => 0x9202, 263 => 0x1002, 322 => 0x401, 415 => 'ApertureValue' },
	'applekeywords' => { 267 => 'AAPL:Keywords' },
	'applicationnotes' => { 109 => 0x2bc, 283 => 0x2bc },
	'applicationrecordversion' => { 117 => 0x0 },
	'applyshootingmeteringmode' => { 75 => 0x10e },
	'approved' => { 417 => 'Approved' },
	'approvedby' => { 417 => 'ApprovedBy' },
	'approximatefnumber' => { 275 => 0x313, 281 => 0x3406 },
	'approximatefocusdistance' => { 407 => 'ApproximateFocusDistance' },
	'aquahsl' => { 94 => 0x20913 },
	'armidentifier' => { 118 => 0x78 },
	'armversion' => { 118 => 0x7a },
	'artfilter' => { 258 => 0x529 },
	'artfiltereffect' => { 258 => 0x52f },
	'artist' => { 109 => 0x13b, 271 => 'Artist', 313 => 0x22e, 431 => 'Artist', 435 => 'artist' },
	'artmode' => { 104 => 0x301b },
	'artmodeparameters' => { 104 => 0x310b },
	'artworkcircadatecreated' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontributiondescription' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 421 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworkscontentdescription' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworksource' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 421 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 262 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 262 => 0x1112, 313 => 0x80, 355 => 0x55, 356 => 0x55, 357 => 0xa },
	'asshoticcprofile' => { 109 => 0xc68f },
	'asshotneutral' => { 109 => 0xc628 },
	'asshotpreprofilematrix' => { 109 => 0xc690 },
	'asshotprofilename' => { 109 => 0xc6f6 },
	'asshotwhitexy' => { 109 => 0xc629 },
	'assignbktbutton' => { 243 => '4.2', 244 => '16.1', 246 => '16.1', 255 => '16.1' },
	'assignfuncbutton' => { 75 => 0x70b },
	'assignmb-d17af-onbutton' => { 246 => '79.1' },
	'assignmb-d17funcbutton' => { 246 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 246 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 246 => '75.1' },
	'assignmoviefunc2button' => { 246 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 246 => '75.2' },
	'assignmovierecordbutton' => { 244 => '43.2', 255 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 246 => '45.1' },
	'assignmoviesubselector' => { 246 => '74.1' },
	'assignmoviesubselectorplusdials' => { 246 => '76.1' },
	'assignremotefnbutton' => { 244 => '54.1', 255 => '51.1' },
	'assistbuttonfunction' => { 73 => 0xd },
	'attributionname' => { 408 => 'attributionName' },
	'attributionurl' => { 408 => 'attributionURL' },
	'audio' => { 279 => 0x20 },
	'audiobitrate' => { 60 => 0x6c },
	'audiochannels' => { 60 => 0x70 },
	'audiochanneltype' => { 435 => 'audioChannelType' },
	'audiocompression' => { 138 => 'Compression' },
	'audiocompressor' => { 435 => 'audioCompressor' },
	'audioduration' => { 117 => 0x99 },
	'audiomoddate' => { 435 => 'audioModDate' },
	'audiooutcue' => { 117 => 0x9a },
	'audiosamplerate' => { 60 => 0x6e, 435 => 'audioSampleRate' },
	'audiosampletype' => { 435 => 'audioSampleType' },
	'audiosamplingrate' => { 117 => 0x97 },
	'audiosamplingresolution' => { 117 => 0x98 },
	'audiotype' => { 117 => 0x96 },
	'author' => { 140 => 'Author', 267 => 'Author', 271 => 'Author', 329 => 'Author', 405 => 'author', 422 => 'Author', 433 => 'Author' },
	'authorsposition' => { 423 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 75 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 304 => '0.1' },
	'autobracket' => { 347 => 0x19 },
	'autobracketing' => { 114 => 0x1100, 313 => 0x18, 338 => 0x1007 },
	'autobracketingmode' => { 254 => '12.3' },
	'autobracketingset' => { 254 => '12.1' },
	'autobracketmodem' => { 243 => '21.2', 244 => '13.3', 246 => '13.2', 251 => '26.2', 255 => '13.3' },
	'autobracketorder' => { 164 => 0x43, 243 => '21.3', 244 => '13.2', 246 => '13.1', 251 => '26.3', 252 => '12.2', 253 => '2.2', 254 => '12.2', 255 => '13.2', 256 => '13.2' },
	'autobracketset' => { 243 => '21.1', 244 => '13.1', 247 => '11.1', 248 => '12.1', 249 => '12.1', 251 => '26.1', 252 => '12.1', 253 => '2.1', 255 => '13.1', 256 => '13.1' },
	'autobrightness' => { 411 => 'AutoBrightness' },
	'autocontrast' => { 411 => 'AutoContrast' },
	'autodistortioncontrol' => { 183 => 0x4 },
	'autodynamicrange' => { 114 => 0x140b },
	'autoexposure' => { 411 => 'AutoExposure' },
	'autoexposurebracketing' => { 69 => 0x10 },
	'autoflashisosensitivity' => { 246 => '38.5' },
	'autofocus' => { 261 => 0x209 },
	'autofp' => { 253 => '7.3', 256 => '31.4' },
	'autoiso' => { 69 => 0x1, 104 => 0x3008, 245 => '1.1', 253 => '1.1' },
	'autoisomax' => { 245 => '1.2', 253 => '1.2' },
	'autoisominshutterspeed' => { 245 => '1.3', 253 => '1.3' },
	'autolateralca' => { 411 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 56 => 0x2, 75 => 0x204, 94 => 0x20500, 100 => 0x6f },
	'autolightingoptimizeron' => { 94 => '0x20500.0', 100 => 0x6e },
	'autoportraitframed' => { 367 => 0x2016 },
	'autoredeye' => { 236 => 0xfe28a44f },
	'autorotate' => { 69 => 0x1b },
	'autoshadows' => { 411 => 'AutoShadows' },
	'autowhiteversion' => { 411 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 198 => 0x82 },
	'avaperturesetting' => { 294 => 0x13 },
	'averageblacklevel' => { 40 => 0xe7, 42 => 0xfb, 43 => 0x114, 44 => 0x146 },
	'averagelv' => { 167 => 0x38 },
	'avsettingwithoutlens' => { 75 => 0x707 },
	'azimuth' => { 148 => 'Azimuth' },
	'babyage' => { 279 => [0x8010,0x33] },
	'babyname' => { 279 => 0x66 },
	'backgroundalpha' => { 430 => 'bgalpha' },
	'baseexposurecompensation' => { 294 => 0x15 },
	'baseiso' => { 69 => 0x2, 88 => 0x101c, 123 => 0x903, 281 => 0x312a, 392 => 0x6 },
	'baselineexposure' => { 109 => 0xc62a },
	'baselineexposureoffset' => { 109 => 0xc7a5 },
	'baselinenoise' => { 109 => 0xc62b },
	'baselinesharpness' => { 109 => 0xc62c },
	'baseurl' => { 433 => 'BaseURL' },
	'batterylevel' => { 355 => 0x51, 359 => 0xc, 360 => 0x4, 361 => 0x4, 393 => 0x7 },
	'batterylevelgrip1' => { 393 => 0x6 },
	'batterylevelgrip2' => { 393 => 0x8 },
	'batteryorder' => { 243 => '12.5', 251 => '13.2', 252 => '2.1', 255 => '3.1' },
	'batterystate' => { 164 => 0x60, 355 => 0x50, 361 => 0x14 },
	'batterytemperature' => { 359 => 0x1, 361 => 0x2, 393 => 0x5 },
	'batteryunknown' => { 359 => 0x2, 361 => 0x0 },
	'batteryvoltage' => { 123 => 0x408, 334 => 0x2a, 359 => 0x8 },
	'batteryvoltage1' => { 361 => 0x6 },
	'batteryvoltage2' => { 361 => 0x8 },
	'bayergreensplit' => { 109 => 0xc62d },
	'bayerpattern' => { 122 => 0xf902, 168 => 0x17 },
	'beatspliceparams' => { 435 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 435 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 435 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 435 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 435 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 435 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 243 => '13.1', 244 => '5.4', 245 => '0.1', 247 => '2.1', 248 => '3.1', 249 => '3.1', 251 => '10.1', 253 => '0.1', 255 => '5.5', 256 => '4.1' },
	'beeppitch' => { 252 => '3.1' },
	'beepvolume' => { 252 => '4.5' },
	'bestqualityscale' => { 109 => 0xc65c },
	'bestshotmode' => { 104 => 0x3007 },
	'bitdepth' => { 145 => 'BitDepth', 168 => 0x11, 205 => 0x41 },
	'bitspercomponent' => { 119 => 0x87 },
	'bitspersample' => { 109 => 0x102, 431 => 'BitsPerSample' },
	'blacklevel' => { 109 => 0xc61a, 198 => 0x3d, 263 => [0x401,0x1012], 322 => 0x21d },
	'blacklevel1' => { 283 => 0x8 },
	'blacklevel2' => { 262 => 0x600, 266 => 0x600, 283 => 0x9 },
	'blacklevel3' => { 283 => 0xa },
	'blacklevelblue' => { 283 => 0x1e },
	'blackleveldata' => { 322 => 0x223 },
	'blackleveldeltah' => { 109 => 0xc61b },
	'blackleveldeltav' => { 109 => 0xc61c },
	'blacklevelgreen' => { 283 => 0x1d },
	'blacklevelred' => { 283 => 0x1c },
	'blacklevelrepeatdim' => { 109 => 0xc619 },
	'blackpoint' => { 313 => 0x200 },
	'blacks2012' => { 411 => 'Blacks2012' },
	'bleachbypasstoning' => { 313 => 0x7f },
	'blockshotafresponse' => { 246 => '1.5' },
	'blogtitle' => { 425 => 'blogTitle' },
	'blogurl' => { 425 => 'blogURL' },
	'bluebalance' => { 181 => 0x271, 263 => 0x1018, 283 => 0x12, 313 => 0x1b },
	'bluecurvelimits' => { 99 => 0x1fe },
	'bluecurvepoints' => { 98 => 0x79, 99 => 0x1d4 },
	'bluehsl' => { 94 => [0x20914,0x20915] },
	'bluehue' => { 411 => 'BlueHue' },
	'bluesaturation' => { 411 => 'BlueSaturation' },
	'blurcontrol' => { 313 => 0x82 },
	'blurwarning' => { 114 => 0x1300 },
	'bodybatteryadload' => { 292 => 0x3 },
	'bodybatteryadnoload' => { 292 => 0x2 },
	'bodybatterystate' => { 292 => '1.1' },
	'bodybatteryvoltage1' => { 292 => 0x2 },
	'bodybatteryvoltage2' => { 292 => 0x4 },
	'bodybatteryvoltage3' => { 292 => 0x6 },
	'bodybatteryvoltage4' => { 292 => 0x8 },
	'bodyfirmware' => { 339 => 0x0 },
	'bodyfirmwareversion' => { 259 => 0x104, 260 => 0x100, 263 => 0x104 },
	'bodyserialnumber' => { 339 => 0x10 },
	'bookedition' => { 425 => 'bookEdition' },
	'bracketmode' => { 51 => 0x3 },
	'bracketsequence' => { 104 => 0x301d },
	'bracketsettings' => { 279 => 0x45 },
	'bracketshotnumber' => { 51 => 0x5, 294 => 0x9, 366 => 0x2b },
	'bracketshotnumber2' => { 366 => 0x2d },
	'bracketstep' => { 161 => 0xe },
	'bracketvalue' => { 51 => 0x4 },
	'brightness' => { 109 => 0xfe53, 139 => 'Brightness', 157 => 'Brightness', 161 => 0x2c, 200 => 0x34, 201 => 0x39, 334 => 0x25, 355 => 0x22, 367 => 0x2007, 411 => 'Brightness' },
	'brightnessadj' => { 99 => 0x114, 229 => 0x0, 239 => 0x2d, 396 => 0x8018 },
	'brightnessvalue' => { 109 => 0x9203, 167 => [0x691,0x49c3], 263 => 0x1003, 371 => 0x1e, 374 => 0x1140, 375 => 0x1140, 376 => 0x111c, 377 => 0x1198, 378 => 0x1174, 379 => 0x102c, 380 => 0x224, 381 => 0x224, 415 => 'BrightnessValue' },
	'bulbduration' => { 69 => 0x18 },
	'burstmode' => { 125 => 0xa, 279 => 0x2a },
	'burstmode2' => { 125 => 0x18 },
	'burstshot' => { 347 => 0x34 },
	'burstspeed' => { 279 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 75 => 0x70a },
	'bwfilter' => { 161 => 0x2a, 169 => 0x39 },
	'bwmode' => { 263 => 0x203 },
	'by-line' => { 117 => 0x50 },
	'by-linetitle' => { 117 => 0x55 },
	'bytecount' => { 425 => 'byteCount' },
	'calibration' => { 347 => [0x24,0x30] },
	'calibrationilluminant1' => { 109 => 0xc65a },
	'calibrationilluminant2' => { 109 => 0xc65b },
	'cameraangle' => { 435 => 'cameraAngle' },
	'cameracalibration1' => { 109 => 0xc623 },
	'cameracalibration2' => { 109 => 0xc624 },
	'cameracalibrationsig' => { 109 => 0xc6f3 },
	'cameracolorcalibration01' => { 35 => 0x0, 41 => 0xba },
	'cameracolorcalibration02' => { 35 => 0x4, 41 => 0xbf },
	'cameracolorcalibration03' => { 35 => 0x8, 41 => 0xc4 },
	'cameracolorcalibration04' => { 35 => 0xc, 41 => 0xc9 },
	'cameracolorcalibration05' => { 35 => 0x10, 41 => 0xce },
	'cameracolorcalibration06' => { 35 => 0x14, 41 => 0xd3 },
	'cameracolorcalibration07' => { 35 => 0x18, 41 => 0xd8 },
	'cameracolorcalibration08' => { 35 => 0x1c, 41 => 0xdd },
	'cameracolorcalibration09' => { 35 => 0x20, 41 => 0xe2 },
	'cameracolorcalibration10' => { 35 => 0x24, 41 => 0xe7 },
	'cameracolorcalibration11' => { 35 => 0x28, 41 => 0xec },
	'cameracolorcalibration12' => { 35 => 0x2c, 41 => 0xf1 },
	'cameracolorcalibration13' => { 35 => 0x30, 41 => 0xf6 },
	'cameracolorcalibration14' => { 35 => 0x34, 41 => 0xfb },
	'cameracolorcalibration15' => { 35 => 0x38, 41 => 0x100 },
	'camerae-mountversion' => { 395 => 0xb },
	'cameraelevationangle' => { 109 => 0x9405 },
	'cameraid' => { 263 => 0x209, 346 => 0x209 },
	'cameraiso' => { 33 => 0x10 },
	'cameralabel' => { 109 => 0xc7a1, 435 => 'cameraLabel' },
	'cameramodel' => { 322 => 0x410, 435 => 'cameraModel' },
	'cameramodelid' => { 157 => 'CameraModelID' },
	'cameramove' => { 435 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 27 => 0x35, 28 => 0x96, 279 => 0x8f, 317 => 0x1, 322 => 0x100, 361 => [0x16,0x18], 384 => 0x28, 385 => 0x24, 386 => 0x29 },
	'cameraowner' => { 126 => 0xc353 },
	'cameraparameters' => { 263 => 0x2050 },
	'camerapicturestyle' => { 27 => 0xaf },
	'camerapitch' => { 106 => 0x9 },
	'cameraprofile' => { 411 => 'CameraProfile' },
	'cameraprofiledigest' => { 411 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 100 => 0xe1 },
	'camerarawcontrast' => { 100 => 0xe3 },
	'camerarawhighlightpoint' => { 100 => 0xe6 },
	'camerarawlinear' => { 100 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 100 => 0xe8 },
	'camerarawoutputshadowpoint' => { 100 => 0xe9 },
	'camerarawsaturation' => { 100 => 0xe2 },
	'camerarawshadowpoint' => { 100 => 0xe7 },
	'camerarawsharpness' => { 100 => 0xe5 },
	'cameraroll' => { 106 => 0xb },
	'cameraserialnumber' => { 109 => 0xc62f, 159 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 258 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x19, 28 => 0x1b, 29 => [0x87,0x91], 30 => [0x99,0x9f,0xa4,0xa8,0x105], 32 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 69 => 0xc, 123 => 0x406, 262 => 0x1306, 275 => 0x320, 281 => 0x3402, 313 => 0x47, 344 => 0x43, 388 => 0x5 },
	'cameratemperature4' => { 318 => 0x14 },
	'cameratemperature5' => { 318 => 0x16 },
	'cameratemperaturerangemax' => { 111 => 0x5 },
	'cameratemperaturerangemin' => { 111 => 0x6 },
	'cameratype' => { 69 => 0x1a, 263 => 0x207 },
	'cameratype2' => { 259 => 0x100 },
	'camerayaw' => { 106 => 0xa },
	'canondr4' => { 110 => 'CanonDR4' },
	'canonexposuremode' => { 33 => 0x14 },
	'canonfiledescription' => { 88 => 0x805 },
	'canonfilelength' => { 57 => 0xe },
	'canonfirmwareversion' => { 57 => 0x7, 88 => 0x80b },
	'canonflashinfo' => { 88 => 0x1028 },
	'canonflashmode' => { 33 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 33 => 0xa },
	'canonimagetype' => { 57 => 0x6, 88 => 0x815 },
	'canonmodelid' => { 57 => 0x10, 88 => 0x1834 },
	'canonvrd' => { 110 => 'CanonVRD' },
	'caption' => { 405 => 'caption' },
	'caption-abstract' => { 117 => 0x78 },
	'captionsauthornames' => { 414 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 414 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 423 => 'CaptionWriter' },
	'captureframerate' => { 104 => 0x4001 },
	'capturesoftware' => { 400 => 'CaptureSoftware' },
	'cardshutterlock' => { 164 => 0x49 },
	'casioimagesize' => { 104 => 0x9 },
	'catalogsets' => { 117 => 0xff, 399 => 'CatalogSets', 403 => 'CatalogSets' },
	'categories' => { 57 => 0x23, 405 => 'categories' },
	'category' => { 117 => 0xf, 257 => 0x30, 423 => 'Category' },
	'cbcrgain' => { 344 => 0xa036 },
	'cbcrgaindefault' => { 344 => 0xa035 },
	'cbcrmatrix' => { 344 => 0xa034 },
	'cbcrmatrixdefault' => { 344 => 0xa033 },
	'ccdboardversion' => { 275 => 0x331 },
	'ccdscanmode' => { 263 => 0x1039 },
	'ccdsensitivity' => { 226 => 0x6 },
	'ccdversion' => { 275 => 0x330 },
	'cellglobalid' => { 409 => 'cgi' },
	'celllength' => { 109 => 0x109 },
	'cellr' => { 409 => 'r' },
	'celltowerid' => { 409 => 'cellid' },
	'cellwidth' => { 109 => 0x108 },
	'centerafarea' => { 253 => '15.1' },
	'centerfocuspoint' => { 256 => '2.2' },
	'centerweightedareasize' => { 243 => '7.1', 244 => '8.1', 246 => '8.1', 250 => '7.1', 251 => '5.1', 252 => '7.1', 253 => '6.3', 255 => '8.1', 256 => '8.1' },
	'certificate' => { 439 => 'Certificate' },
	'cfapattern' => { 109 => 0xa302, 415 => 'CFAPattern' },
	'cfapattern2' => { 109 => 0x828e },
	'cfapatterncolumns' => { 415 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 415 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 415 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 109 => 0x828d },
	'channel' => { 425 => 'channel' },
	'channela-lang' => { 425 => [\'channel','channelA-lang'] },
	'channelchannel' => { 425 => [\'channel','channelChannel'] },
	'channels' => { 138 => 'Channels' },
	'channelsubchannel1' => { 425 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 425 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 425 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 425 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 94 => 0x10101, 99 => 0x26a },
	'checkmark2' => { 100 => 0x8e },
	'childfontfiles' => { 440 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 243 => '10.3', 244 => '11.2' },
	'chromablurradius' => { 109 => 0xc631 },
	'chromaticaberration' => { 94 => 0x20703, 100 => 0x66, 344 => 0xa051 },
	'chromaticaberrationb' => { 411 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 94 => 0x20708, 100 => 0x6b },
	'chromaticaberrationcorr' => { 71 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 303 => 0x1 },
	'chromaticaberrationon' => { 94 => '0x20703.0', 100 => 0x62 },
	'chromaticaberrationr' => { 411 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 94 => 0x20707, 100 => 0x6a },
	'chromaticaberrationsetting' => { 72 => 0x6 },
	'chrominancenoisereduction' => { 94 => 0x20601, 100 => 0x5e, 347 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 100 => 0x60 },
	'circgradbasedcorractive' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 411 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 411 => 'CircularGradientBasedCorrections' },
	'city' => { 117 => 0x5a, 144 => 'City', 279 => 0x6d, 423 => 'City' },
	'city2' => { 279 => 0x80 },
	'clarity' => { 201 => 0x35, 411 => 'Clarity' },
	'clarity2012' => { 411 => 'Clarity2012' },
	'classifystate' => { 117 => 0xe1 },
	'clearretouch' => { 279 => 0x7c },
	'clearretouchvalue' => { 279 => 0xa3 },
	'client' => { 435 => 'client' },
	'clientname' => { 417 => 'ClientName' },
	'clmodeshootingspeed' => { 243 => '10.2', 244 => '11.3', 246 => '11.2', 251 => '11.2', 252 => '10.2', 255 => '11.2', 256 => '11.1' },
	'cmcontrast' => { 266 => 0x2022 },
	'cmexposurecompensation' => { 266 => 0x2000 },
	'cmhue' => { 266 => 0x2021 },
	'cmsaturation' => { 266 => 0x2020 },
	'cmsharpness' => { 266 => 0x2023 },
	'cmwhitebalance' => { 266 => 0x2001 },
	'cmwhitebalancecomp' => { 266 => 0x2002 },
	'cmwhitebalancegraypoint' => { 266 => 0x2010 },
	'codec' => { 152 => 'Codec' },
	'codedcharacterset' => { 118 => 0x5a },
	'collectionname' => { 153 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 153 => 'Collections', 405 => 'collections' },
	'collectionuri' => { 153 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 424 => 'color' },
	'coloraberrationcontrol' => { 236 => 0xc89224b },
	'coloradjustment' => { 347 => 0x14 },
	'coloradjustmentmode' => { 346 => 0x210 },
	'coloranta' => { 440 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 440 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 440 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 440 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 440 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 440 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 440 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 440 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 440 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 440 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 440 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 440 => 'Colorants' },
	'colorantswatchname' => { 440 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 440 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 440 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 440 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 139 => 'ColorBalance' },
	'colorbalanceadj' => { 236 => 0x76a43202 },
	'colorbalanceblue' => { 161 => 0x1e },
	'colorbalancegreen' => { 161 => 0x1d },
	'colorbalancered' => { 161 => 0x1c },
	'colorbalanceversion' => { 182 => 0x0 },
	'colorblur' => { 100 => 0x65 },
	'colorbluron' => { 94 => 0x20704 },
	'colorbooster' => { 236 => 0x5f0e7d23 },
	'colorboostlevel' => { 230 => 0x1 },
	'colorboosttype' => { 230 => 0x0 },
	'colorclass' => { 324 => 0xde, 325 => 'ColorClass' },
	'colorcompensationfilter' => { 164 => [0x3a,0x5f], 166 => 0x111, 367 => 0xb022 },
	'colorcompensationfiltercustom' => { 355 => 0xd, 356 => 0xc },
	'colorcompensationfilterset' => { 355 => 0x8, 356 => 0x7, 357 => 0x18, 371 => 0xf },
	'colorcontrol' => { 263 => 0x102b },
	'colorcorrection' => { 396 => 0x8015 },
	'colorcreatoreffect' => { 258 => 0x532 },
	'colordataversion' => { 39 => 0x0, 40 => 0x0, 42 => 0x0, 43 => 0x0, 44 => 0x0 },
	'coloreffect' => { 279 => 0x28 },
	'colorfilter' => { 103 => 0x17, 104 => 0x3017, 161 => 0x29, 169 => [0x38,0x4d,0x4f], 320 => 0x17 },
	'colorgain' => { 205 => 0x51 },
	'colorhue' => { 94 => 0x20900, 198 => 0x8d },
	'colorimetricreference' => { 109 => 0xc6bf },
	'colorlabel' => { 414 => 'ColorLabel' },
	'colormatrix' => { 262 => 0x200, 263 => 0x1011, 344 => 0xa030 },
	'colormatrix1' => { 109 => 0xc621, 322 => 0x106 },
	'colormatrix2' => { 109 => 0xc622, 266 => 0x200, 322 => 0x226 },
	'colormatrixa' => { 313 => 0x203 },
	'colormatrixadobergb' => { 344 => 0xa032 },
	'colormatrixb' => { 313 => 0x204 },
	'colormatrixnumber' => { 263 => 0x1019 },
	'colormatrixsrgb' => { 344 => 0xa031 },
	'colormode' => { 104 => 0x3015, 114 => 0x1210, 125 => 0x66, 161 => 0x28, 164 => 0x16, 166 => 0x101, 167 => 0x36, 169 => 0x7, 198 => 0x3, 226 => 0x4, 279 => 0x32, 347 => 0x2c, 367 => 0xb029, 423 => 'ColorMode' },
	'colormoirereduction' => { 237 => 0x15 },
	'colormoirereductionmode' => { 237 => 0x5 },
	'colornoisereduction' => { 396 => 0x8029, 411 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 411 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 237 => 0x18 },
	'colornoisereductionsharpness' => { 237 => 0x1c },
	'colornoisereductionsmoothness' => { 411 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 113 => 0x2 },
	'colorprofile' => { 161 => 0x33 },
	'colorprofilesettings' => { 258 => 0x539 },
	'colorrepresentation' => { 119 => 0x3c },
	'colorsaturationadj' => { 94 => 0x20305 },
	'colorsequence' => { 119 => 0x41 },
	'colorspace' => { 45 => 0x3, 57 => 0xb4, 88 => 0x10b4, 109 => 0xa001, 145 => 'ColorSpace', 162 => 0x2f, 163 => 0x25, 164 => 0x17, 198 => 0x1e, 258 => 0x507, 313 => 0x37, 344 => 0xa011, 347 => 0xb, 355 => 0x1b, 356 => 0x83, 357 => 0xe, 371 => 0x6, 415 => 'ColorSpace' },
	'colortempasshot' => { 36 => 0x4, 37 => 0x1d, 38 => 0x26, 39 => 0x43, 42 => 0x43, 43 => 0x43, 44 => 0x43 },
	'colortempauto' => { 36 => 0x9, 37 => 0x22, 38 => 0x1c, 39 => 0x48, 42 => 0x48, 43 => 0x48, 44 => 0x48 },
	'colortempcloudy' => { 36 => 0x22, 37 => 0x31, 38 => 0x35, 39 => 0x5c, 42 => 0x75, 43 => 0x8e, 44 => 0x93, 313 => 0x55 },
	'colortempcustom' => { 39 => 0x84 },
	'colortempcustom1' => { 37 => 0x45 },
	'colortempcustom2' => { 37 => 0x4a },
	'colortempdaylight' => { 36 => 0x18, 37 => 0x27, 38 => 0x2b, 39 => 0x52, 42 => 0x6b, 43 => 0x84, 44 => 0x89, 313 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x135, 27 => 0x7b, 28 => 0x13a, 57 => 0xae, 67 => 0x9, 88 => 0x10ae, 114 => 0x1005, 123 => 0x846, 139 => 'ColorTemperature', 162 => [0x6e,0x49], 163 => 0x3f, 164 => [0x39,0x5e], 166 => 0x10b, 169 => [0x3c,0x4c,0x4e], 275 => 0x321, 313 => 0x50, 338 => 0x1308, 367 => 0xb021, 411 => 'Temperature' },
	'colortemperatureadj' => { 396 => 0x8013 },
	'colortemperaturebg' => { 263 => 0x1013 },
	'colortemperaturecustom' => { 355 => 0xc, 356 => 0xb },
	'colortemperaturerg' => { 263 => 0x1014 },
	'colortemperatureset' => { 355 => 0x7, 356 => 0x6 },
	'colortemperaturesetting' => { 164 => 0x25, 357 => 0x17, 371 => 0xe },
	'colortempflash' => { 36 => 0x36, 37 => 0x40, 38 => 0x49, 39 => 0x70, 42 => 0x89, 43 => 0xa2, 44 => 0xa7, 313 => 0x5a },
	'colortempflashdata' => { 39 => 0x24a },
	'colortempfluorescent' => { 36 => 0x2c, 37 => 0x3b, 38 => 0x3f, 39 => 0x66, 42 => 0x7f, 43 => 0x98, 44 => 0x9d },
	'colortempfluorescentd' => { 313 => 0x57 },
	'colortempfluorescentn' => { 313 => 0x58 },
	'colortempfluorescentw' => { 313 => 0x59 },
	'colortempkelvin' => { 36 => 0x31, 38 => 0x44, 39 => 0x6b, 42 => 0x84, 43 => 0x9d, 44 => 0xa2, 279 => 0x44, 338 => 0x1307 },
	'colortempmeasured' => { 36 => 0xe, 39 => 0x4d, 42 => 0x4d, 43 => 0x4d, 44 => 0x4d },
	'colortemppc1' => { 38 => 0x94, 39 => 0x75 },
	'colortemppc2' => { 38 => 0x99, 39 => 0x7a },
	'colortemppc3' => { 38 => 0x9e, 39 => 0x7f },
	'colortempshade' => { 36 => 0x1d, 37 => 0x2c, 38 => 0x30, 39 => 0x57, 42 => 0x70, 43 => 0x89, 44 => 0x8e, 313 => 0x54 },
	'colortemptungsten' => { 36 => 0x27, 37 => 0x36, 38 => 0x3a, 39 => 0x61, 42 => 0x7a, 43 => 0x93, 44 => 0x98, 313 => 0x56 },
	'colortempunknown' => { 36 => 0x13, 38 => 0x21, 42 => 0x52, 43 => 0x52, 44 => 0x52 },
	'colortempunknown10' => { 36 => 0x63, 38 => 0x76, 42 => 0xa2, 43 => 0x7f, 44 => 0x7f },
	'colortempunknown11' => { 36 => 0x68, 38 => 0x7b, 42 => 0xa7, 43 => 0xa7, 44 => 0x84 },
	'colortempunknown12' => { 36 => 0x6d, 38 => 0x80, 42 => 0xac, 43 => 0xac, 44 => 0xac },
	'colortempunknown13' => { 36 => 0x72, 38 => 0x85, 42 => 0xb1, 43 => 0xb1, 44 => 0xb1 },
	'colortempunknown14' => { 38 => 0x8a, 42 => 0xb6, 43 => 0xb6, 44 => 0xb6 },
	'colortempunknown15' => { 38 => 0x8f, 42 => 0xbb, 43 => 0xbb, 44 => 0xbb },
	'colortempunknown16' => { 38 => 0xa3, 43 => 0xc0, 44 => 0xc0 },
	'colortempunknown17' => { 43 => 0xc5, 44 => 0xc5 },
	'colortempunknown18' => { 43 => 0xca, 44 => 0xca },
	'colortempunknown19' => { 43 => 0xcf, 44 => 0xcf },
	'colortempunknown2' => { 36 => 0x3b, 38 => 0x4e, 42 => 0x57, 43 => 0x57, 44 => 0x57 },
	'colortempunknown20' => { 43 => 0xd4, 44 => 0xd4 },
	'colortempunknown21' => { 44 => 0xd9 },
	'colortempunknown22' => { 44 => 0xde },
	'colortempunknown23' => { 44 => 0xe3 },
	'colortempunknown24' => { 44 => 0xe8 },
	'colortempunknown25' => { 44 => 0xed },
	'colortempunknown26' => { 44 => 0xf2 },
	'colortempunknown27' => { 44 => 0xf7 },
	'colortempunknown28' => { 44 => 0xfc },
	'colortempunknown29' => { 44 => 0x101 },
	'colortempunknown3' => { 36 => 0x40, 38 => 0x53, 42 => 0x5c, 43 => 0x5c, 44 => 0x5c },
	'colortempunknown30' => { 44 => 0x106 },
	'colortempunknown4' => { 36 => 0x45, 38 => 0x58, 42 => 0x61, 43 => 0x61, 44 => 0x61 },
	'colortempunknown5' => { 36 => 0x4a, 38 => 0x5d, 42 => 0x66, 43 => 0x66, 44 => 0x66 },
	'colortempunknown6' => { 36 => 0x4f, 38 => 0x62, 42 => 0x8e, 43 => 0x6b, 44 => 0x6b },
	'colortempunknown7' => { 36 => 0x54, 38 => 0x67, 42 => 0x93, 43 => 0x70, 44 => 0x70 },
	'colortempunknown8' => { 36 => 0x59, 38 => 0x6c, 42 => 0x98, 43 => 0x75, 44 => 0x75 },
	'colortempunknown9' => { 36 => 0x5e, 38 => 0x71, 42 => 0x9d, 43 => 0x7a, 44 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 33 => 0x2a, 45 => 0x2 },
	'colortoneadj' => { 94 => 0x20304, 99 => 0x11e },
	'colortoneauto' => { 64 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 63 => 0x6c, 64 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 63 => 0x3c, 64 => 0x3c },
	'colortonemonochrome' => { 63 => 0x84, 64 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 63 => 0x54, 64 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 63 => 0x24, 64 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 63 => 0xc, 64 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 63 => 0x9c, 64 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 63 => 0xb4, 64 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 63 => 0xcc, 64 => 0xe4 },
	'commanddials' => { 253 => '5.1' },
	'commanddialsaperturesetting' => { 243 => '17.3', 244 => '18.3', 246 => '18.3', 251 => '33.3', 252 => '17.3', 255 => '18.3' },
	'commanddialschangemainsub' => { 243 => '17.2', 244 => '18.1', 246 => '18.1', 251 => '33.2', 252 => '17.2', 255 => '18.1' },
	'commanddialsmenuandplayback' => { 243 => '17.4', 244 => '18.2', 246 => '18.2', 251 => '33.4', 252 => '17.4', 255 => '18.2' },
	'commanddialsreverserotation' => { 243 => '17.1', 244 => '6.4', 246 => '6.2', 247 => '16.2', 248 => '17.2', 251 => '33.1', 252 => '17.1', 255 => '6.2', 256 => '18.1' },
	'commanderchannel' => { 253 => '10.2', 254 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 253 => '13.1', 254 => '31.1' },
	'commandergroupa_ttlcomp' => { 256 => '32.1' },
	'commandergroupamanualoutput' => { 253 => '13.2', 254 => '28.2' },
	'commandergroupamode' => { 253 => '11.2', 254 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 253 => '14.1', 254 => '32.1' },
	'commandergroupb_ttlcomp' => { 256 => '33.1' },
	'commandergroupbmanualoutput' => { 253 => '14.2', 254 => '29.2' },
	'commandergroupbmode' => { 253 => '11.3', 254 => '29.1' },
	'commanderinternalflash' => { 253 => '11.1', 254 => '27.1' },
	'commanderinternalmanualoutput' => { 253 => '12.2', 254 => '27.2' },
	'commanderinternalttlchannel' => { 251 => '18.2' },
	'commanderinternalttlcomp' => { 253 => '12.1', 254 => '30.2', 256 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 251 => '20.1', 252 => '26.1' },
	'commanderinternalttlcompgroupa' => { 251 => '21.1', 252 => '27.1' },
	'commanderinternalttlcompgroupb' => { 251 => '22.1', 252 => '28.1' },
	'comment' => { 0 => 0x2, 110 => 'Comment', 140 => 'Comment', 271 => 'Comment' },
	'compass' => { 341 => 0x4 },
	'complianceprofile' => { 425 => 'complianceProfile' },
	'componentsconfiguration' => { 109 => 0x9101, 145 => 'Components', 415 => 'ComponentsConfiguration' },
	'componentversion' => { 88 => 0x80c },
	'composer' => { 435 => 'composer' },
	'compositionadjust' => { 312 => '0.1' },
	'compositionadjustrotation' => { 312 => 0x7 },
	'compositionadjustx' => { 312 => 0x5 },
	'compositionadjusty' => { 312 => 0x6 },
	'compressedbitsperpixel' => { 109 => 0x9102, 415 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 166 => 0x40, 263 => 0x40 },
	'compression' => { 109 => 0x103, 431 => 'Compression' },
	'compressionfactor' => { 258 => 0x50d },
	'compressionratio' => { 145 => 'Compression', 263 => 0x1034 },
	'confidencelevel' => { 406 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 99 => 0x266, 324 => 0xd6 },
	'constrainedcropwidth' => { 99 => 0x262, 324 => 0xd5 },
	'contact' => { 117 => 0x76 },
	'contactinfo' => { 424 => 'contactInfo' },
	'contentlocationcode' => { 117 => 0x1a },
	'contentlocationname' => { 117 => 0x1b },
	'contenttype' => { 425 => 'contentType' },
	'continuousbracketing' => { 164 => 0x20 },
	'continuousdrive' => { 33 => 0x5 },
	'continuousshootingspeed' => { 75 => 0x610 },
	'continuousshotlimit' => { 75 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 33 => 0xd, 103 => 0xc, 104 => [0x3012,0x20], 109 => [0xa408,0xfe54], 114 => [0x1004,0x1006], 139 => 'Contrast', 157 => 'Contrast', 161 => 0x20, 162 => 0x31, 163 => 0x27, 164 => 0x19, 169 => 0x2, 200 => 0x33, 201 => 0x37, 263 => 0x1029, 279 => 0x39, 281 => 0x300a, 313 => 0x20, 320 => 0xc, 334 => 0x24, 338 => 0x1012, 347 => 0xd, 355 => 0x1d, 356 => 0x1a, 367 => 0x2004, 411 => 'Contrast', 415 => 'Contrast' },
	'contrast2012' => { 411 => 'Contrast2012' },
	'contrastadj' => { 94 => 0x20303, 99 => 0x115, 239 => 0x2c, 396 => 0x8017 },
	'contrastauto' => { 64 => 0x90 },
	'contrastcurve' => { 198 => 0x8c },
	'contrastdetectaf' => { 173 => 0x4 },
	'contrastdetectafarea' => { 313 => 0x231 },
	'contrastdetectafinfocus' => { 173 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 63 => 0x60, 64 => 0x60 },
	'contrasthighlight' => { 313 => 0x6d },
	'contrasthighlightshadowadj' => { 313 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 63 => 0x30, 64 => 0x30 },
	'contrastmode' => { 279 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 63 => 0x78, 64 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 63 => 0x48, 64 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 63 => 0x18, 64 => 0x18 },
	'contrastsetting' => { 258 => 0x505, 266 => 0x1012, 357 => 0x10, 371 => 0x8 },
	'contrastshadow' => { 313 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 63 => 0x0, 64 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 63 => 0x90, 64 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 63 => 0xa8, 64 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 63 => 0xc0, 64 => 0xd8 },
	'contributedmedia' => { 435 => 'contributedMedia' },
	'contributedmediaduration' => { 435 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 435 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 435 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 435 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 435 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 435 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 435 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 435 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 435 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 435 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 412 => 'contributor' },
	'contributors' => { 140 => 'Contributors' },
	'controldialset' => { 164 => 0x46 },
	'controlledvocabularyterm' => { 421 => 'CVterm' },
	'controllerboardversion' => { 275 => 0x332 },
	'controlmode' => { 69 => 0x12 },
	'conversionlens' => { 259 => 0x403, 279 => 0x35 },
	'converter' => { 109 => 0xfe4d, 226 => 0xb, 411 => 'Converter' },
	'converttograyscale' => { 411 => 'ConvertToGrayscale' },
	'cookingequipment' => { 427 => 'cookingEquipment' },
	'cookingmethod' => { 427 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 109 => 0x8298, 140 => 'Copyright', 271 => 'Copyright', 313 => 0x22f, 329 => 'Copyright', 422 => 'Copyright', 428 => 'copyright', 431 => 'Copyright', 435 => 'copyright' },
	'copyrightflag' => { 327 => 0x40a },
	'copyrightnotice' => { 117 => 0x74 },
	'copyrightowner' => { 268 => 'CopyrightOwner' },
	'copyrightownerid' => { 268 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 268 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 268 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 268 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 268 => 'CopyrightStatus' },
	'copyrightyear' => { 425 => 'copyrightYear' },
	'coringfilter' => { 262 => 0x310, 263 => 0x102d, 266 => 0x310 },
	'coringvalues' => { 262 => 0x311, 266 => 0x311 },
	'corporateentity' => { 425 => 'corporateEntity' },
	'country' => { 144 => 'Country', 279 => 0x69, 423 => 'Country' },
	'country-primarylocationcode' => { 117 => 0x64 },
	'country-primarylocationname' => { 117 => 0x65 },
	'countrycode' => { 197 => 0x5, 325 => 'CountryCode', 420 => 'CountryCode' },
	'course' => { 427 => 'course' },
	'coverage' => { 412 => 'coverage' },
	'coverdate' => { 425 => 'coverDate' },
	'coverdisplaydate' => { 425 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 313 => 0x28 },
	'crc32' => { 413 => 'crc32' },
	'createdate' => { 109 => 0x9004, 140 => 'CreateDate', 267 => 'CreationDate', 271 => 'create-date', 329 => 'CreationDate', 331 => 0x1, 433 => 'CreateDate' },
	'creationdate' => { 422 => 'CreationDate', 425 => 'creationDate' },
	'creationtime' => { 271 => 'Creation Time' },
	'creativestyle' => { 355 => 0x1a, 356 => 0x18, 366 => 0x41, 367 => 0xb020, 392 => 0x4a },
	'creativestylesetting' => { 357 => 0xf, 371 => 0x7 },
	'creativestylewaschanged' => { 396 => 0x8001 },
	'creator' => { 267 => 'Creator', 329 => 'Creator', 412 => 'creator', 422 => 'Creator' },
	'creatoraddress' => { 420 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 159 => 'CreatorAppId' },
	'creatorcity' => { 420 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 420 => 'CreatorContactInfo' },
	'creatorcountry' => { 420 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoropenwithuioptions' => { 159 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 420 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 420 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 433 => 'CreatorTool' },
	'creatorworkemail' => { 420 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 420 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 420 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 117 => 0x6e, 423 => 'Credit' },
	'creditline' => { 428 => 'creditLine' },
	'creditlinereq' => { 438 => 'CreditLineReq' },
	'creditlinerequired' => { 268 => 'CreditLineRequired' },
	'cropactive' => { 92 => 0x0, 99 => 0x244 },
	'cropangle' => { 411 => 'CropAngle' },
	'cropaspectratio' => { 94 => 0x30101, 99 => 0x260 },
	'cropaspectratiocustom' => { 94 => 0x30102 },
	'cropbottom' => { 113 => 0x9, 231 => 0x36, 283 => 0x31, 324 => 0xdc, 411 => 'CropBottom' },
	'cropbottommargin' => { 47 => 0x3 },
	'cropcircleactive' => { 100 => 0xd6 },
	'cropcircleradius' => { 100 => 0xd9 },
	'cropcirclex' => { 100 => 0xd7 },
	'cropcircley' => { 100 => 0xd8 },
	'cropconstraintowarp' => { 411 => 'CropConstrainToWarp' },
	'croph' => { 404 => 'CropH' },
	'cropheight' => { 92 => 0x6, 99 => 0x24c, 262 => 0x615, 266 => 0x615, 411 => 'CropHeight' },
	'crophispeed' => { 198 => 0x1b },
	'cropleft' => { 99 => 0x246, 113 => 0x6, 231 => 0x1e, 262 => 0x612, 266 => 0x612, 283 => 0x30, 324 => 0xd9, 411 => 'CropLeft' },
	'cropleftmargin' => { 47 => 0x0 },
	'cropmode35mm' => { 338 => 0x1018 },
	'croporiginalheight' => { 92 => 0xb },
	'croporiginalwidth' => { 92 => 0xa },
	'cropoutputheight' => { 231 => 0xce },
	'cropoutputheightinches' => { 231 => 0x96 },
	'cropoutputpixels' => { 231 => 0xd6 },
	'cropoutputresolution' => { 231 => 0xb6 },
	'cropoutputscale' => { 231 => 0xbe },
	'cropoutputwidth' => { 231 => 0xc6 },
	'cropoutputwidthinches' => { 231 => 0x8e },
	'croppedareaimageheightpixels' => { 400 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 400 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 400 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 400 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 338 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 338 => 0x1603 },
	'cropright' => { 113 => 0x8, 231 => 0x2e, 283 => 0x32, 324 => 0xdb, 411 => 'CropRight' },
	'croprightmargin' => { 47 => 0x1 },
	'croprotatedoriginalheight' => { 92 => 0x2 },
	'croprotatedoriginalwidth' => { 92 => 0x1 },
	'croprotation' => { 92 => 0x8, 113 => 0xb },
	'cropscaledresolution' => { 231 => 0x9e },
	'cropsourceresolution' => { 231 => 0xae },
	'croptop' => { 99 => 0x248, 113 => 0x7, 231 => 0x26, 262 => 0x613, 266 => 0x613, 283 => 0x2f, 324 => 0xda, 411 => 'CropTop' },
	'croptopmargin' => { 47 => 0x2 },
	'cropunit' => { 411 => 'CropUnit' },
	'cropunits' => { 411 => 'CropUnits' },
	'cropw' => { 404 => 'CropW' },
	'cropwidth' => { 92 => 0x5, 99 => 0x24a, 262 => 0x614, 266 => 0x614, 411 => 'CropWidth' },
	'cropx' => { 92 => 0x3, 404 => 'CropX' },
	'cropy' => { 92 => 0x4, 404 => 'CropY' },
	'crossprocess' => { 313 => 0x7b },
	'crossprocessparams' => { 313 => 0x235 },
	'cuisine' => { 427 => 'cuisine' },
	'currenticcprofile' => { 109 => 0xc691 },
	'currentpreprofilematrix' => { 109 => 0xc692 },
	'currentversion' => { 396 => 0xd000 },
	'curve0x' => { 404 => 'Curve0x' },
	'curve0y' => { 404 => 'Curve0y' },
	'curve1x' => { 404 => 'Curve1x' },
	'curve1y' => { 404 => 'Curve1y' },
	'curve2x' => { 404 => 'Curve2x' },
	'curve2y' => { 404 => 'Curve2y' },
	'curve3x' => { 404 => 'Curve3x' },
	'curve3y' => { 404 => 'Curve3y' },
	'curve4x' => { 404 => 'Curve4x' },
	'curve4y' => { 404 => 'Curve4y' },
	'curves' => { 236 => 0x76a43201 },
	'custom1' => { 268 => 'Custom1' },
	'custom10' => { 268 => 'Custom10' },
	'custom2' => { 268 => 'Custom2' },
	'custom3' => { 268 => 'Custom3' },
	'custom4' => { 268 => 'Custom4' },
	'custom5' => { 268 => 'Custom5' },
	'custom6' => { 268 => 'Custom6' },
	'custom7' => { 268 => 'Custom7' },
	'custom8' => { 268 => 'Custom8' },
	'custom9' => { 268 => 'Custom9' },
	'customcolortone' => { 100 => 0x4c },
	'customcontrast' => { 100 => 0x4e },
	'customcontrols' => { 75 => 0x70c },
	'customdefaultunsharpfineness' => { 100 => 0xbe },
	'customdefaultunsharpstrength' => { 100 => 0xbc },
	'customdefaultunsharpthreshold' => { 100 => 0xc0 },
	'customlinear' => { 100 => 0x4f },
	'customoutputhighlightpoint' => { 100 => 0x53 },
	'customoutputshadowpoint' => { 100 => 0x54 },
	'custompicturestyle' => { 94 => 0x10021 },
	'custompicturestyledata' => { 94 => 0xf0500 },
	'custompicturestylefilename' => { 57 => 0x4010 },
	'customrawhighlight' => { 100 => 0x7c },
	'customrawhighlightpoint' => { 100 => 0x51 },
	'customrawshadow' => { 100 => 0x85 },
	'customrawshadowpoint' => { 100 => 0x52 },
	'customrendered' => { 109 => 0xa401, 415 => 'CustomRendered' },
	'customsaturation' => { 100 => 0x4d, 258 => 0x503 },
	'customsettingsalldefault' => { 243 => '0.2', 251 => '0.2' },
	'customsettingsbank' => { 243 => '0.1', 244 => '0.1', 246 => '0.1', 251 => '0.1', 255 => '0.2' },
	'customsharpness' => { 100 => 0x50 },
	'customunsharpmaskfineness' => { 100 => 0xb8 },
	'customunsharpmaskstrength' => { 100 => 0xb6 },
	'customunsharpmaskthreshold' => { 100 => 0xba },
	'customwb_rblevels' => { 371 => 0x1a },
	'customwb_rgblevels' => { 356 => 0x8, 357 => 0x19 },
	'customwbbluelevel' => { 164 => 0x36 },
	'customwberror' => { 164 => 0x37 },
	'customwbgreenlevel' => { 164 => 0x35 },
	'customwbredlevel' => { 164 => 0x34 },
	'customwbsetting' => { 164 => 0x26 },
	'd-lightinghq' => { 236 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 232 => 0x2 },
	'd-lightinghqhighlight' => { 232 => 0x1 },
	'd-lightinghqselected' => { 236 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 232 => 0x0 },
	'd-lightinghs' => { 236 => 0xce5554aa },
	'd-lightinghsadjustment' => { 233 => 0x0 },
	'd-lightinghscolorboost' => { 233 => 0x1 },
	'd-rangeoptimizerhighlight' => { 396 => 0x8024 },
	'd-rangeoptimizermode' => { 396 => 0x8022 },
	'd-rangeoptimizershadow' => { 396 => 0x802d },
	'd-rangeoptimizervalue' => { 396 => 0x8023 },
	'd810meteringmode' => { 224 => 0x175e },
	'datacompressionmethod' => { 119 => 0x6e },
	'dataimprint' => { 161 => 0x34 },
	'datascaling' => { 313 => 0x3d },
	'date' => { 313 => 0x6, 412 => 'date' },
	'dateacquired' => { 159 => 'DateAcquired' },
	'datecreated' => { 117 => 0x37, 423 => 'DateCreated' },
	'datedisplayformat' => { 228 => 0x3 },
	'dateidentified' => { 108 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 247 => '4.2' },
	'daterecieved' => { 425 => 'dateRecieved' },
	'datesent' => { 118 => 0x46 },
	'datestampmode' => { 57 => 0x1c },
	'datetime' => { 405 => 'datetime', 431 => 'DateTime' },
	'datetimedigitized' => { 415 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 91 => 0x0, 109 => 0x9003, 137 => 0x14, 140 => 'OriginalDate', 334 => 0xb, 415 => 'DateTimeOriginal' },
	'datetimestamp' => { 125 => 0x64 },
	'datetimeutc' => { 258 => 0x908 },
	'daylightsavings' => { 70 => 0x3, 228 => 0x2 },
	'dccontinent' => { 108 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 108 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 108 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 108 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 108 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 108 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 108 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 108 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 108 => 'Event' },
	'dcfootprintspatialfit' => { 108 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 108 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 108 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 108 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 108 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 108 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 108 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 108 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 108 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 108 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 108 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 108 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 108 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 108 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 108 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 108 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 108 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 148 => 'Declination' },
	'decposition' => { 161 => 0x32 },
	'defaultautogray' => { 411 => 'DefaultAutoGray' },
	'defaultautotone' => { 411 => 'DefaultAutoTone' },
	'defaultblackrender' => { 109 => 0xc7a6 },
	'defaultcroporigin' => { 109 => 0xc61f },
	'defaultcropsize' => { 109 => 0xc620 },
	'defaulteraseoption' => { 75 => 0x813 },
	'defaultscale' => { 109 => 0xc61e },
	'defaultsspecifictoiso' => { 411 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 411 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 109 => 0xc7b5 },
	'defringe' => { 411 => 'Defringe' },
	'defringegreenamount' => { 411 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 411 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 411 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 411 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 411 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 411 => 'DefringePurpleHueLo' },
	'dehaze' => { 411 => 'Dehaze' },
	'deletedimagecount' => { 198 => 0xa6, 206 => 0x6e },
	'deprecatedon' => { 408 => 'deprecatedOn' },
	'derivedfrom' => { 436 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 436 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 436 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 436 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 436 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 436 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 436 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 436 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 436 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 436 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 436 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 436 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 436 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 436 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 436 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 436 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 436 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 436 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 436 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 436 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 436 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 436 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 436 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 436 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 271 => 'Description', 412 => 'description', 433 => 'Description' },
	'destination' => { 118 => 0x5 },
	'destinationcity' => { 313 => 0x24, 319 => 0x3 },
	'destinationcitycode' => { 320 => 0x1001 },
	'destinationdst' => { 313 => 0x26, 319 => '0.3' },
	'developmentdynamicrange' => { 114 => 0x1403 },
	'device' => { 425 => 'device' },
	'devicesettingdescription' => { 415 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 415 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 415 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 415 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 344 => 0x2 },
	'dialdirectiontvav' => { 75 => 0x706 },
	'dietaryneeds' => { 427 => 'dietaryNeeds' },
	'diffractioncorrection' => { 303 => 0x3 },
	'digitalcreationdate' => { 117 => 0x3e },
	'digitalcreationtime' => { 117 => 0x3f },
	'digitaldeehighlightadj' => { 205 => 0x202 },
	'digitaldeeshadowadj' => { 205 => 0x200 },
	'digitaldeethreshold' => { 205 => 0x201 },
	'digitalfilter' => { 347 => 0x59 },
	'digitalfilter01' => { 300 => 0x5 },
	'digitalfilter02' => { 300 => 0x16 },
	'digitalfilter03' => { 300 => 0x27 },
	'digitalfilter04' => { 300 => 0x38 },
	'digitalfilter05' => { 300 => 0x49 },
	'digitalfilter06' => { 300 => 0x5a },
	'digitalfilter07' => { 300 => 0x6b },
	'digitalfilter08' => { 300 => 0x7c },
	'digitalfilter09' => { 300 => 0x8d },
	'digitalfilter10' => { 300 => 0x9e },
	'digitalfilter11' => { 300 => 0xaf },
	'digitalfilter12' => { 300 => 0xc0 },
	'digitalfilter13' => { 300 => 0xd1 },
	'digitalfilter14' => { 300 => 0xe2 },
	'digitalfilter15' => { 300 => 0xf3 },
	'digitalfilter16' => { 300 => 0x104 },
	'digitalfilter17' => { 300 => 0x115 },
	'digitalfilter18' => { 300 => 0x126 },
	'digitalfilter19' => { 300 => 0x137 },
	'digitalfilter20' => { 300 => 0x148 },
	'digitalgain' => { 67 => 0xb },
	'digitalgem' => { 190 => 0x0 },
	'digitalice' => { 205 => 0x100 },
	'digitalimageguid' => { 421 => 'DigImageGUID' },
	'digitalroc' => { 203 => 0x0 },
	'digitalsourcefiletype' => { 421 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 421 => 'DigitalSourceType' },
	'digitalzoom' => { 33 => 0xc, 103 => 0xa, 125 => 0x68, 139 => 'DigitalZoom', 161 => 0xc, 198 => 0x86, 226 => 0xa, 263 => 0x204, 313 => 0x1e, 320 => 0xa, 346 => 0x204, 384 => 0x12, 385 => 0x12 },
	'digitalzoomon' => { 346 => 0x21b },
	'digitalzoomratio' => { 109 => 0xa404, 376 => 0x200, 378 => 0x21c, 415 => 'DigitalZoomRatio' },
	'director' => { 435 => 'director' },
	'directorphotography' => { 435 => 'directorPhotography' },
	'directory' => { 110 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 27 => 0x1f7, 28 => 0x4ba },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 185 => 0x3 },
	'disclaimer' => { 271 => 'Disclaimer' },
	'discnumber' => { 435 => 'discNumber' },
	'dishtype' => { 427 => 'dishType' },
	'displayallafpoints' => { 75 => 0x514 },
	'displayaperture' => { 33 => 0x23 },
	'displayedunitsx' => { 328 => 0x2 },
	'displayedunitsy' => { 328 => 0x6 },
	'displayname' => { 424 => 'displayName' },
	'distance1' => { 125 => 0x28 },
	'distance2' => { 125 => 0x2c },
	'distance3' => { 125 => 0x30 },
	'distance4' => { 125 => 0x34 },
	'distortion' => { 344 => 0xa050 },
	'distortioncontrol' => { 206 => 0x10 },
	'distortioncorrection' => { 94 => 0x20705, 100 => 0x67, 258 => 0x50b, 282 => '7.1', 303 => 0x0, 391 => 0x601, 392 => 0x5b },
	'distortioncorrection2' => { 262 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 407 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 94 => '0x20705.0', 100 => 0x63 },
	'distortioncorrectionsetting' => { 367 => 0x2013 },
	'distortioneffect' => { 94 => 0x20709 },
	'distortionn' => { 282 => 0xc },
	'distortionparam02' => { 282 => 0x2 },
	'distortionparam04' => { 282 => 0x4 },
	'distortionparam08' => { 282 => 0x8 },
	'distortionparam09' => { 282 => 0x9 },
	'distortionparam11' => { 282 => 0xb },
	'distortionscale' => { 282 => 0x5 },
	'distributor' => { 425 => 'distributor' },
	'distributorproductid' => { 424 => 'distributorProductID' },
	'dloon' => { 94 => '0x20706.0', 100 => 0xdc },
	'dlosetting' => { 94 => 0x20706, 100 => 0xdd },
	'dlosettingapplied' => { 93 => 0x4 },
	'dloshootingdistance' => { 100 => 0xde },
	'dloversion' => { 93 => 0x5 },
	'dmcomment' => { 435 => 'comment' },
	'dngadobedata' => { 109 => 0xc634 },
	'dngbackwardversion' => { 109 => 0xc613 },
	'dngignoresidecars' => { 411 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 109 => 0xc630 },
	'dngprivatedata' => { 109 => 0xc634 },
	'dngversion' => { 109 => 0xc612 },
	'document' => { 271 => 'Document' },
	'documentancestors' => { 423 => 'DocumentAncestors' },
	'documenthistory' => { 117 => 0xe7 },
	'documentid' => { 436 => 'DocumentID' },
	'documentname' => { 109 => 0x10d },
	'documentnotes' => { 117 => 0xe6 },
	'doi' => { 425 => 'doi' },
	'dpp' => { 405 => 'dpp' },
	'dr4cameramodel' => { 95 => 0x3 },
	'drivemode' => { 104 => 0x3103, 161 => 0x6, 164 => 0x1e, 167 => 0xe, 258 => 0x600, 313 => 0x34, 338 => 0x1002, 347 => 0x3, 355 => 0x4, 356 => 0x7e, 357 => 0x34 },
	'drivemode2' => { 164 => 0xa, 294 => 0x7, 366 => 0xe, 371 => 0x1 },
	'drivemodesetting' => { 357 => 0x4 },
	'dspfirmwareversion' => { 313 => 0x27 },
	'duration' => { 60 => 0x6a, 138 => 'Duration', 152 => 'Duration', 427 => 'duration', 435 => 'duration' },
	'durationscale' => { 435 => [\'duration','durationScale'] },
	'durationvalue' => { 435 => [\'duration','durationValue'] },
	'dustremovaldata' => { 57 => 0x97 },
	'dynamicafarea' => { 243 => '1.4', 251 => '1.4' },
	'dynamicareaafdisplay' => { 244 => '46.1', 246 => '47.1', 255 => '47.1' },
	'dynamicrange' => { 114 => 0x1400 },
	'dynamicrangeexpansion' => { 313 => 0x69, 338 => 0x100e },
	'dynamicrangemax' => { 99 => 0x7c },
	'dynamicrangemin' => { 99 => 0x7a },
	'dynamicrangeoptimizer' => { 164 => 0x15, 367 => [0xb025,0xb04f], 374 => 0x1144, 375 => [0x1144,0x324], 376 => [0x1120,0x300], 377 => [0x119c,0x37c], 378 => [0x1178,0x328], 379 => [0x1030,0x50], 380 => [0x228,0x50], 381 => [0x228,0x50] },
	'dynamicrangeoptimizerbracket' => { 366 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 355 => 0x19, 356 => 0x17, 357 => 0xd, 366 => 0x79, 371 => 0x5 },
	'dynamicrangeoptimizermode' => { 167 => 0x15, 355 => 0x18, 356 => 0x16, 366 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 164 => 0x27, 357 => 0xc, 371 => 0x4 },
	'dynamicrangesetting' => { 114 => 0x1402 },
	'e-dialinprogram' => { 294 => '1.3' },
	'earliestageorloweststage' => { 108 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 108 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 108 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 108 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 108 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 256 => '6.1' },
	'easyexposurecompensation' => { 243 => '6.4', 244 => '6.5', 246 => '6.3', 250 => '5.1', 251 => '4.4', 252 => '5.2', 255 => '6.3' },
	'easymode' => { 33 => 0xb },
	'edgenoisereduction' => { 237 => 0x4, 396 => 0x8028 },
	'edition' => { 425 => 'edition' },
	'editorialupdate' => { 117 => 0x8 },
	'editstatus' => { 117 => 0x7, 325 => 'EditStatus', 405 => 'EditStatus' },
	'editversionname' => { 236 => 0x3d136244 },
	'effectivelv' => { 313 => 0x2d },
	'effectivemaxaperture' => { 194 => 0x12, 195 => 0x13 },
	'eissn' => { 425 => 'eIssn' },
	'electronicfront-curtainshutter' => { 246 => '5.2', 255 => '5.3' },
	'elevation' => { 148 => 'Elevation' },
	'email' => { 140 => 'EMail' },
	'embargodate' => { 428 => 'embargoDate' },
	'embdencrightsexpr' => { 421 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 421 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 421 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 421 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 423 => 'EmbeddedXMPDigest' },
	'emissivity' => { 111 => 0x3 },
	'encryptionkey' => { 344 => 0xa020 },
	'endingpage' => { 425 => 'endingPage' },
	'enduser' => { 268 => 'EndUser' },
	'enduserid' => { 268 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 268 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 435 => 'engineer' },
	'enhancedarktones' => { 229 => 0x8 },
	'enhancement' => { 103 => 0x16, 104 => 0x3016 },
	'enhancer' => { 262 => 0x300 },
	'enhancervalues' => { 262 => 0x301 },
	'envelopenumber' => { 118 => 0x28 },
	'envelopepriority' => { 118 => 0x3c },
	'enveloperecordversion' => { 118 => 0x0 },
	'epsonimageheight' => { 263 => 0x20c },
	'epsonimagewidth' => { 263 => 0x20b },
	'epsonsoftware' => { 263 => 0x20d },
	'equipmentinstitution' => { 398 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 398 => 'EquipmentManufacturer' },
	'equipmentversion' => { 259 => 0x0 },
	'ettlii' => { 75 => 0x304, 76 => 0xd, 77 => 0xe, 78 => 0x7, 79 => 0x7, 80 => 0xe },
	'event' => { 399 => 'Event', 403 => 'Event', 421 => 'Event', 425 => 'event' },
	'eventalias' => { 424 => 'eventAlias' },
	'eventday' => { 108 => [\'Event','EventDay'] },
	'eventearliestdate' => { 108 => [\'Event','EventEarliestDate'] },
	'eventend' => { 424 => 'eventEnd' },
	'eventenddayofyear' => { 108 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 108 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 108 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 108 => [\'Event','EventHabitat'] },
	'eventid' => { 108 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 108 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 108 => [\'Event','EventMonth'] },
	'eventnumber' => { 334 => 0x9 },
	'eventremarks' => { 108 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 108 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 108 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 424 => 'eventStart' },
	'eventstartdayofyear' => { 108 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 424 => 'eventSubtype' },
	'eventtime' => { 108 => [\'Event','EventEventTime'] },
	'eventtype' => { 424 => 'eventType' },
	'eventverbatimeventdate' => { 108 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 108 => [\'Event','EventYear'] },
	'evsteps' => { 294 => '1.2', 296 => 0x0 },
	'evstepsize' => { 247 => '5.1', 248 => '6.1', 249 => '6.1', 253 => '0.7' },
	'exclusivityenddate' => { 428 => 'exclusivityEndDate' },
	'excursiontolerance' => { 119 => 0x82 },
	'exif' => { 110 => 'EXIF' },
	'exifbyteorder' => { 110 => 'ExifByteOrder' },
	'exifcamerainfo' => { 117 => 0xe8 },
	'exifimageheight' => { 109 => 0xa003, 415 => 'PixelYDimension' },
	'exifimagewidth' => { 109 => 0xa002, 415 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 110 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 109 => 0x9000, 415 => 'ExifVersion' },
	'exitpupilposition' => { 194 => 0x4, 195 => 0x4 },
	'expirationdate' => { 117 => 0x25, 428 => 'expirationDate' },
	'expirationtime' => { 117 => 0x26 },
	'exposure' => { 109 => 0xfe51, 411 => 'Exposure' },
	'exposure2012' => { 411 => 'Exposure2012' },
	'exposureadj' => { 234 => 0x0 },
	'exposureadj2' => { 234 => 0x12 },
	'exposureadjust' => { 347 => 0xc },
	'exposurebracketingindicatorlast' => { 164 => 0x52 },
	'exposurebracketshotnumber' => { 167 => 0x2d, 366 => 0x2f },
	'exposurebracketstepsize' => { 294 => 0x8 },
	'exposurebracketvalue' => { 198 => 0x19 },
	'exposurecompensation' => { 69 => 0x6, 84 => 0x0, 109 => 0x9204, 125 => 0x24, 139 => 'ExposureComp', 157 => 'ExposureCompensation', 161 => 0xd, 162 => 0x53, 163 => 0x1e, 167 => 0x49c0, 263 => 0x1006, 313 => 0x16, 322 => 0x402, 344 => 0xa013, 347 => [0xc,0x35,0x4d], 374 => 0x114c, 375 => 0x114c, 376 => 0x1128, 378 => 0x1180, 379 => 0x1038, 380 => 0x230, 381 => 0x230, 415 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 371 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 164 => 0x47, 167 => 0x2a },
	'exposurecompensationset' => { 355 => 0x3, 356 => 0x3, 357 => 0x3, 371 => 0x1e },
	'exposurecompensationsetting' => { 164 => 0x1 },
	'exposurecompstepsize' => { 243 => '6.3', 244 => '7.3', 246 => '7.3', 251 => '4.3', 255 => '7.3' },
	'exposurecontrolstep' => { 250 => '6.1', 252 => '6.1' },
	'exposurecontrolstepsize' => { 243 => '6.2', 244 => '7.1', 246 => '7.1', 251 => '4.2', 255 => '7.1', 256 => '7.1' },
	'exposurecount' => { 114 => 0x1032 },
	'exposuredelaymode' => { 243 => '10.1', 244 => '11.1', 246 => '11.1', 247 => '9.1', 248 => '10.1', 249 => '10.1', 251 => '10.4', 252 => '10.1', 253 => '6.4', 255 => '11.1', 256 => '11.2' },
	'exposuredifference' => { 198 => 0xe },
	'exposureindex' => { 109 => 0xa215, 415 => 'ExposureIndex' },
	'exposureindicator' => { 164 => 0x50 },
	'exposurelevelincrements' => { 73 => 0x6, 74 => 0x6, 75 => 0x101, 76 => 0x5, 77 => 0x6, 78 => 0x5, 79 => 0x5, 80 => 0x6, 81 => 0x4, 355 => 0x58, 356 => 0x58 },
	'exposurelockused' => { 400 => 'ExposureLockUsed' },
	'exposuremode' => { 109 => 0xa402, 139 => 'ExposureMode', 161 => 0x1, 162 => 0xa, 163 => 0x0, 164 => 0x0, 167 => 0x34, 258 => 0x200, 277 => 0x40d, 347 => 0x8, 367 => 0xb041, 415 => 'ExposureMode' },
	'exposuremodeinmanual' => { 75 => 0x10b },
	'exposureprogram' => { 109 => 0x8822, 338 => 0x1001, 348 => [0x17e,0x43], 355 => 0x3c, 356 => 0x3c, 357 => 0x5, 361 => 0x14, 366 => 0x3f, 371 => 0x2, 374 => 0x1175, 375 => 0x1179, 376 => 0x1155, 377 => 0x11d1, 378 => 0x11ad, 379 => 0x1065, 380 => 0x25d, 381 => 0x25d, 392 => 0x48, 415 => 'ExposureProgram' },
	'exposureshift' => { 258 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x6, 30 => 0x7, 69 => 0x16, 109 => 0x829a, 122 => 0xfd05, 125 => 0x20, 127 => 0xfa24, 129 => 0xf104, 132 => 0x12, 134 => 0x38, 137 => 0x10, 139 => 'ExposureTime', 161 => 0x9, 162 => 0x35, 163 => 0x48, 164 => 0x8, 167 => 0x49b8, 313 => 0x12, 344 => 0xa018, 347 => [0x32,0x4a], 355 => 0x0, 356 => 0x0, 371 => [0x21,0x23,0x27], 392 => 0x10, 415 => 'ExposureTime' },
	'exposuretime2' => { 347 => [0x33,0x4b] },
	'exposuretuning' => { 198 => 0x1c },
	'exposurevalue' => { 123 => 0x3 },
	'exposurewarning' => { 114 => 0x1302 },
	'exrauto' => { 114 => 0x1033 },
	'exrmode' => { 114 => 0x1034 },
	'extendedwbdetect' => { 258 => 0x902 },
	'extender' => { 259 => 0x301 },
	'extenderfirmwareversion' => { 259 => 0x304 },
	'extendermagnification' => { 141 => 'Magnification' },
	'extendermake' => { 141 => 'Make' },
	'extendermodel' => { 141 => 'Model', 259 => 0x303 },
	'extenderserialnumber' => { 141 => 'SerialNumber', 259 => 0x302 },
	'extenderstatus' => { 311 => 0x3 },
	'externalflash' => { 261 => 0x1201 },
	'externalflashae1' => { 263 => 0x101f },
	'externalflashae1_0' => { 263 => 0x101b },
	'externalflashae2' => { 263 => 0x1020 },
	'externalflashae2_0' => { 263 => 0x101c },
	'externalflashbounce' => { 261 => 0x1204, 263 => 0x1026, 301 => 0x1a },
	'externalflashcompensation' => { 188 => 0x1b },
	'externalflashexposurecomp' => { 198 => 0x17, 301 => 0x19 },
	'externalflashfirmware' => { 186 => 0x6, 187 => 0x6, 188 => 0x6 },
	'externalflashflags' => { 186 => 0x8, 187 => 0x8, 188 => 0x8 },
	'externalflashguidenumber' => { 261 => 0x1203, 301 => '24.1' },
	'externalflashgvalue' => { 263 => 0x1025 },
	'externalflashmode' => { 263 => 0x1028, 301 => 0x2 },
	'externalflashstatus' => { 189 => 0x8 },
	'externalflashzoom' => { 261 => 0x1205, 263 => 0x1027 },
	'externalsensorbrightnessvalue' => { 275 => 0x311, 281 => 0x3408 },
	'extrainfoversion' => { 359 => 0x1a },
	'eyestartaf' => { 164 => 0x40 },
	'face10position' => { 101 => 0x3f4, 102 => 0x1ec, 184 => 0x28, 298 => 0x12 },
	'face10size' => { 299 => 0x12 },
	'face11position' => { 184 => 0x2c, 298 => 0x14 },
	'face11size' => { 299 => 0x14 },
	'face12position' => { 184 => 0x30, 298 => 0x16 },
	'face12size' => { 299 => 0x16 },
	'face13position' => { 298 => 0x18 },
	'face13size' => { 299 => 0x18 },
	'face14position' => { 298 => 0x1a },
	'face14size' => { 299 => 0x1a },
	'face15position' => { 298 => 0x1c },
	'face15size' => { 299 => 0x1c },
	'face16position' => { 298 => 0x1e },
	'face16size' => { 299 => 0x1e },
	'face17position' => { 298 => 0x20 },
	'face17size' => { 299 => 0x20 },
	'face18position' => { 298 => 0x22 },
	'face18size' => { 299 => 0x22 },
	'face19position' => { 298 => 0x24 },
	'face19size' => { 299 => 0x24 },
	'face1position' => { 48 => 0x8, 101 => 0xd, 102 => 0x18, 184 => 0x4, 273 => 0x1, 298 => 0x0, 335 => 0xbc, 362 => 0x1, 363 => 0x0, 364 => 0x0, 365 => 0x5b },
	'face1size' => { 299 => 0x0 },
	'face20position' => { 298 => 0x26 },
	'face20size' => { 299 => 0x26 },
	'face21position' => { 298 => 0x28 },
	'face21size' => { 299 => 0x28 },
	'face22position' => { 298 => 0x2a },
	'face22size' => { 299 => 0x2a },
	'face23position' => { 298 => 0x2c },
	'face23size' => { 299 => 0x2c },
	'face24position' => { 298 => 0x2e },
	'face24size' => { 299 => 0x2e },
	'face25position' => { 298 => 0x30 },
	'face25size' => { 299 => 0x30 },
	'face26position' => { 298 => 0x32 },
	'face26size' => { 299 => 0x32 },
	'face27position' => { 298 => 0x34 },
	'face27size' => { 299 => 0x34 },
	'face28position' => { 298 => 0x36 },
	'face28size' => { 299 => 0x36 },
	'face29position' => { 298 => 0x38 },
	'face29size' => { 299 => 0x38 },
	'face2position' => { 48 => 0xa, 101 => 0x7c, 102 => 0x4c, 184 => 0x8, 273 => 0x5, 298 => 0x2, 335 => 0xc8, 362 => 0x6, 363 => 0x20, 364 => 0x25, 365 => 0x65 },
	'face2size' => { 299 => 0x2 },
	'face30position' => { 298 => 0x3a },
	'face30size' => { 299 => 0x3a },
	'face31position' => { 298 => 0x3c },
	'face31size' => { 299 => 0x3c },
	'face32position' => { 298 => 0x3e },
	'face32size' => { 299 => 0x3e },
	'face3position' => { 48 => 0xc, 101 => 0xeb, 102 => 0x80, 184 => 0xc, 273 => 0x9, 298 => 0x4, 335 => 0xd4, 362 => 0xb, 363 => 0x40, 364 => 0x4a, 365 => 0x6f },
	'face3size' => { 299 => 0x4 },
	'face4position' => { 48 => 0xe, 101 => 0x15a, 102 => 0xb4, 184 => 0x10, 273 => 0xd, 298 => 0x6, 335 => 0xe0, 362 => 0x10, 363 => 0x60, 364 => 0x6f, 365 => 0x79 },
	'face4size' => { 299 => 0x6 },
	'face5position' => { 48 => 0x10, 101 => 0x1c9, 102 => 0xe8, 184 => 0x14, 273 => 0x11, 298 => 0x8, 335 => 0xec, 362 => 0x15, 363 => 0x80, 364 => 0x94 },
	'face5size' => { 299 => 0x8 },
	'face6position' => { 48 => 0x12, 101 => 0x238, 102 => 0x11c, 184 => 0x18, 298 => 0xa, 335 => 0xf8, 362 => 0x1a, 363 => 0xa0, 364 => 0xb9 },
	'face6size' => { 299 => 0xa },
	'face7position' => { 48 => 0x14, 101 => 0x2a7, 102 => 0x150, 184 => 0x1c, 298 => 0xc, 335 => 0x104, 362 => 0x1f, 363 => 0xc0, 364 => 0xde },
	'face7size' => { 299 => 0xc },
	'face8position' => { 48 => 0x16, 101 => 0x316, 102 => 0x184, 184 => 0x20, 298 => 0xe, 335 => 0x110, 362 => 0x24, 363 => 0xe0, 364 => 0x103 },
	'face8size' => { 299 => 0xe },
	'face9position' => { 48 => 0x18, 101 => 0x385, 102 => 0x1b8, 184 => 0x24, 298 => 0x10 },
	'face9size' => { 299 => 0x10 },
	'facedetect' => { 313 => 0x76, 344 => 0x100 },
	'facedetectarea' => { 262 => 0x1201 },
	'facedetectframecrop' => { 262 => 0x1207 },
	'facedetectframesize' => { 48 => 0x3, 101 => 0x1, 102 => 0x4, 184 => 0x1, 262 => 0x1203, 313 => 0x77, 335 => 0xb6 },
	'facedetection' => { 357 => 0x30, 371 => 0x19 },
	'faceid' => { 406 => 'FaceID' },
	'faceinfounknown' => { 104 => 0x2089 },
	'facename' => { 344 => 0x123 },
	'faceorientation' => { 102 => 0x8 },
	'faceposition' => { 297 => 0x2, 345 => 0x4 },
	'facepositions' => { 114 => 0x4103 },
	'facerecognition' => { 344 => 0x120 },
	'facesdetected' => { 48 => 0x2, 49 => 0x2, 50 => 0x3, 101 => 0x0, 102 => 0x2, 104 => 0x211c, 114 => 0x4100, 184 => 0x3, 262 => 0x1200, 279 => 0x3f, 297 => 0x0, 335 => 0xb5, 345 => 0x0, 362 => 0x0, 365 => 0x3, 373 => 0x30 },
	'facesrecognized' => { 274 => 0x0 },
	'facewidth' => { 49 => 0x1 },
	'faithfuloutputhighlightpoint' => { 100 => 0x38 },
	'faithfuloutputshadowpoint' => { 100 => 0x39 },
	'faithfulrawcolortone' => { 100 => 0x31 },
	'faithfulrawcontrast' => { 100 => 0x33 },
	'faithfulrawhighlight' => { 100 => 0x79 },
	'faithfulrawhighlightpoint' => { 100 => 0x36 },
	'faithfulrawlinear' => { 100 => 0x34 },
	'faithfulrawsaturation' => { 100 => 0x32 },
	'faithfulrawshadow' => { 100 => 0x82 },
	'faithfulrawshadowpoint' => { 100 => 0x37 },
	'faithfulrawsharpness' => { 100 => 0x35 },
	'faithfulunsharpmaskfineness' => { 100 => 0xac },
	'faithfulunsharpmaskstrength' => { 100 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 100 => 0xae },
	'femicroadjustment' => { 75 => 0x111 },
	'ffid' => { 413 => 'ffid' },
	'field' => { 424 => 'field' },
	'fieldcount' => { 263 => 0x103f },
	'filecreatedate' => { 110 => 'FileCreateDate' },
	'filedatarate' => { 435 => 'fileDataRate' },
	'fileformat' => { 86 => 0x0, 118 => 0x14, 347 => [0x22,0x26], 367 => 0xb000 },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 27 => 0x1eb, 28 => 0x4ae, 280 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 110 => 'FileModifyDate' },
	'filename' => { 110 => 'FileName' },
	'filenameasdelivered' => { 268 => 'FileNameAsDelivered' },
	'filenumber' => { 51 => 0x1, 57 => 0x8, 88 => 0x1817, 105 => 'FileNumber', 185 => 0x4 },
	'filenumbermemory' => { 161 => 0x1a },
	'filenumbersequence' => { 243 => '12.2', 247 => '3.1', 248 => '4.1', 249 => '4.1', 251 => '11.1', 252 => '4.3', 256 => '5.2' },
	'filepermissions' => { 110 => 'FilePermissions' },
	'filesource' => { 109 => 0xa300, 114 => 0x8000, 415 => 'FileSource' },
	'fileversion' => { 118 => 0x16 },
	'fillflashautoreduction' => { 73 => 0xe, 74 => 0xe, 81 => 0xa },
	'filllight' => { 411 => 'FillLight' },
	'fillorder' => { 109 => 0x10a },
	'filmgraineffect' => { 258 => 0x538 },
	'filmmode' => { 114 => 0x1401, 277 => 0x412, 279 => 0x42 },
	'filmtype' => { 205 => 0x2 },
	'filtereffect' => { 51 => 0xe, 200 => 0x37, 201 => 0x3f },
	'filtereffectauto' => { 64 => 0xa0 },
	'filtereffectfaithful' => { 63 => 0x70, 64 => 0x70 },
	'filtereffectlandscape' => { 63 => 0x40, 64 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 63 => 0x88, 64 => 0x88 },
	'filtereffectneutral' => { 63 => 0x58, 64 => 0x58 },
	'filtereffectportrait' => { 63 => 0x28, 64 => 0x28 },
	'filtereffectstandard' => { 63 => 0x10, 64 => 0x10 },
	'filtereffectuserdef1' => { 63 => 0xa0, 64 => 0xb8 },
	'filtereffectuserdef2' => { 63 => 0xb8, 64 => 0xd0 },
	'filtereffectuserdef3' => { 63 => 0xd0, 64 => 0xe8 },
	'finderdisplayduringexposure' => { 74 => 0x1 },
	'finesharpness' => { 313 => 0x70 },
	'finetuneoptcenterweighted' => { 243 => '7.2', 244 => '9.1', 246 => '9.1', 250 => '8.1', 255 => '9.1', 256 => '9.1' },
	'finetuneopthighlightweighted' => { 246 => '46.1', 255 => '46.1' },
	'finetuneoptmatrixmetering' => { 243 => '8.1', 244 => '8.2', 246 => '8.2', 250 => '7.2', 251 => '6.1', 255 => '8.2', 256 => '8.2' },
	'finetuneoptspotmetering' => { 243 => '8.2', 244 => '9.2', 246 => '9.2', 250 => '8.2', 251 => '6.2', 255 => '9.2', 256 => '9.2' },
	'firmware' => { 263 => 0x405, 347 => [0x17,0x3b,0x57], 407 => 'Firmware' },
	'firmwaredate' => { 103 => 0x15, 104 => 0x2001, 334 => 0x4 },
	'firmwareid' => { 168 => 0x0 },
	'firmwarename' => { 344 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 57 => 0x1e, 336 => 0x0 },
	'firmwarerevision2' => { 336 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 123 => 0xce5, 137 => 0x57, 139 => 'FirmwareVersion', 279 => 0x2, 281 => 0x3109, 313 => 0x230, 338 => 0x2 },
	'firmwareversions' => { 322 => 0x301 },
	'firstphotodate' => { 400 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 268 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 117 => 0x16, 405 => 'FixtureIdentifier' },
	'flash' => { 105 => 'Flash', 109 => 0x9209, 162 => 0x1f, 163 => 0x15, 415 => 'Flash' },
	'flashaction' => { 355 => 0x3e, 356 => 0x3e, 367 => 0x2017, 371 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 355 => 0x4c, 356 => 0x4c, 371 => 0x77 },
	'flashactionexternal' => { 371 => [0x78,0x7c] },
	'flashactivity' => { 33 => 0x1c },
	'flashbatterylevel' => { 39 => 0x249 },
	'flashbias' => { 279 => 0x24 },
	'flashbits' => { 33 => 0x1d },
	'flashbuttonfunction' => { 75 => 0x70e },
	'flashchargelevel' => { 263 => 0x1010 },
	'flashcolorfilter' => { 188 => 0x10 },
	'flashcommandermode' => { 186 => '9.1', 187 => '9.1', 188 => '9.1' },
	'flashcompensation' => { 186 => 0xa, 187 => 0xa, 188 => 0xa, 407 => 'FlashCompensation' },
	'flashcontrol' => { 355 => 0x23, 356 => 0x1f, 357 => 0x21 },
	'flashcontrolbuilt-in' => { 251 => '16.1', 252 => '23.1', 254 => '23.1', 255 => '24.1' },
	'flashcontrolmode' => { 186 => '9.2', 187 => '9.2', 188 => '9.2', 258 => 0x404 },
	'flashcurtain' => { 279 => 0x48 },
	'flashdefault' => { 164 => 0x42 },
	'flashdevice' => { 263 => 0x1005 },
	'flashdistance' => { 104 => 0x2034 },
	'flashenergy' => { 109 => 0xa20b, 415 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 198 => 0x18 },
	'flashexposurecomp' => { 69 => 0xf, 114 => 0x1011, 142 => 'ExposureComp', 161 => 0x23, 166 => 0x104, 167 => 0x49c1, 198 => 0x12, 258 => 0x401, 263 => 0x1023, 313 => 0x4d, 338 => 0x100b, 347 => [0x3a,0x56], 367 => 0x104 },
	'flashexposurecomp2' => { 223 => 0x4d2 },
	'flashexposurecomp3' => { 188 => 0x1d },
	'flashexposurecomp4' => { 188 => 0x27 },
	'flashexposurecomparea' => { 244 => '38.4', 246 => '38.4', 255 => '38.4' },
	'flashexposurecompset' => { 164 => 0x10, 286 => 0xe, 355 => 0x14, 356 => 0x12, 357 => 0x23, 371 => 0x1f },
	'flashexposurecompset2' => { 371 => [0x26,0x2c] },
	'flashexposureindicator' => { 164 => 0x54 },
	'flashexposureindicatorlast' => { 164 => 0x56 },
	'flashexposureindicatornext' => { 164 => 0x55 },
	'flashexposurelock' => { 51 => 0x19 },
	'flashfired' => { 125 => 0x5d, 142 => 'Fired', 161 => 0x14, 222 => '590.3', 279 => 0x8007, 415 => [\'Flash','FlashFired'] },
	'flashfiring' => { 75 => 0x306, 76 => 0x6, 77 => 0x7, 80 => 0x7 },
	'flashfirmwareversion' => { 259 => 0x1002 },
	'flashfocallength' => { 186 => 0xb, 187 => 0xc, 188 => 0xc },
	'flashfunction' => { 167 => 0x31, 415 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 186 => 0xe, 187 => 0xf, 188 => 0xf },
	'flashgroupacompensation' => { 186 => 0x11, 187 => 0x12, 188 => 0x13 },
	'flashgroupacontrolmode' => { 186 => 0xf, 187 => '16.1', 188 => '17.1' },
	'flashgroupaoutput' => { 186 => 0x11, 187 => 0x12, 188 => 0x13 },
	'flashgroupbcompensation' => { 186 => 0x12, 187 => 0x13, 188 => 0x14 },
	'flashgroupbcontrolmode' => { 186 => 0x10, 187 => '17.1', 188 => '18.1' },
	'flashgroupboutput' => { 186 => 0x12, 187 => 0x13, 188 => 0x14 },
	'flashgroupccompensation' => { 187 => 0x14, 188 => 0x15 },
	'flashgroupccontrolmode' => { 187 => '17.2', 188 => '18.2' },
	'flashgroupcoutput' => { 187 => 0x14, 188 => 0x15 },
	'flashguidenumber' => { 69 => 0xd, 85 => 0x0, 142 => 'GuideNumber' },
	'flashintensity' => { 103 => [0x19,0x5], 258 => 0x405 },
	'flashlevel' => { 245 => 0x9, 367 => 0xb048 },
	'flashmake' => { 142 => 'Make' },
	'flashmanufacturer' => { 159 => 'FlashManufacturer' },
	'flashmetering' => { 161 => 0x3f, 164 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 27 => 0x15 },
	'flashmeteringsegments' => { 313 => 0x20a },
	'flashmode' => { 103 => 0x4, 125 => 0x5c, 142 => 'Mode', 161 => 0x2, 162 => 0x20, 163 => 0x16, 164 => 0xf, 198 => 0x87, 258 => 0x400, 263 => 0x1004, 313 => 0xc, 320 => 0x4, 337 => 0x20, 338 => 0x100a, 346 => 0x225, 355 => 0x13, 356 => 0x7f, 357 => 0x20, 371 => 0x10, 374 => 0x1138, 375 => 0x1138, 376 => 0x1114, 377 => 0x1190, 378 => 0x116c, 379 => 0x1024, 380 => 0x21c, 381 => 0x21c, 415 => [\'Flash','FlashMode'] },
	'flashmodel' => { 142 => 'Model', 159 => 'FlashModel', 259 => 0x1001 },
	'flashoptions' => { 294 => 0x2 },
	'flashoptions2' => { 294 => 0x10 },
	'flashoutput' => { 39 => 0x248, 69 => 0x21, 186 => 0xa, 187 => 0xa, 188 => 0xa },
	'flashpixversion' => { 109 => 0xa000, 415 => 'FlashpixVersion' },
	'flashredeyemode' => { 415 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 258 => 0x403 },
	'flashreturn' => { 415 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 142 => 'SerialNumber', 259 => 0x1003 },
	'flashsetting' => { 198 => 0x8 },
	'flashshutterspeed' => { 243 => '20.2', 244 => '23.2', 246 => '23.2', 251 => '15.2', 252 => '22.2', 253 => '7.2', 254 => '22.2', 255 => '23.2', 256 => '23.1' },
	'flashsource' => { 186 => 0x4, 187 => 0x4, 188 => 0x4 },
	'flashstatus' => { 301 => 0x0, 371 => [0x82,0x86], 383 => [0x31,0x39] },
	'flashstatusbuilt-in' => { 357 => [0x87,0x287] },
	'flashstatusexternal' => { 357 => [0x88,0x288] },
	'flashsyncspeed' => { 243 => '20.1', 244 => '23.1', 246 => '23.1', 251 => '15.1', 252 => '22.1', 254 => '22.1', 255 => '23.1' },
	'flashsyncspeedav' => { 73 => 0x3, 75 => 0x10f, 76 => 0x2, 77 => 0x3, 78 => 0x2, 79 => 0x2, 80 => 0x3, 81 => 0x6 },
	'flashthreshold' => { 85 => 0x1 },
	'flashtype' => { 142 => 'Type', 164 => 0x59, 198 => 0x9, 259 => 0x1000 },
	'flashwarning' => { 252 => '30.1', 253 => '7.1', 256 => '31.1', 279 => 0x62 },
	'flexiblespotposition' => { 367 => 0x201d },
	'flickerreduce' => { 346 => 0x218 },
	'flickerreduction' => { 216 => 0xe84 },
	'flickerreductionindicator' => { 216 => 0x5e2 },
	'fliphorizontal' => { 236 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x5, 30 => 0x6, 69 => 0x15, 109 => 0x829d, 122 => 0xfd04, 125 => 0x1e, 127 => 0xfa23, 129 => 0xf103, 132 => 0x13, 134 => 0x3c, 137 => 0xc, 146 => 'FNumber', 161 => 0xa, 162 => 0x36, 163 => 0x47, 164 => 0x9, 167 => 0x49c7, 313 => 0x13, 344 => 0xa019, 347 => [0x31,0x49], 355 => 0x1, 356 => 0x1, 371 => [0x20,0x22,0x26], 415 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x1e, 28 => 0x23, 53 => 0x1, 104 => 0x1d, 109 => 0x920a, 132 => 0x1d, 146 => 'FocalLength', 161 => 0x12, 194 => 0xa, 195 => 0xb, 313 => 0x1d, 322 => 0x403, 338 => 0x1500, 354 => 0xe, 378 => 0x1278, 379 => 0x1134, 380 => 0x32c, 381 => 0x32c, 415 => 'FocalLength' },
	'focallength2' => { 371 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 109 => 0xa405, 344 => 0xa01a, 415 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 354 => 0x10 },
	'focalplaneafpointarea' => { 382 => 0x2 },
	'focalplaneafpointlocation1' => { 382 => 0x6 },
	'focalplaneafpointlocation10' => { 382 => 0x2a },
	'focalplaneafpointlocation11' => { 382 => 0x2e },
	'focalplaneafpointlocation12' => { 382 => 0x32 },
	'focalplaneafpointlocation13' => { 382 => 0x36 },
	'focalplaneafpointlocation14' => { 382 => 0x3a },
	'focalplaneafpointlocation15' => { 382 => 0x3e },
	'focalplaneafpointlocation2' => { 382 => 0xa },
	'focalplaneafpointlocation3' => { 382 => 0xe },
	'focalplaneafpointlocation4' => { 382 => 0x12 },
	'focalplaneafpointlocation5' => { 382 => 0x16 },
	'focalplaneafpointlocation6' => { 382 => 0x1a },
	'focalplaneafpointlocation7' => { 382 => 0x1e },
	'focalplaneafpointlocation8' => { 382 => 0x22 },
	'focalplaneafpointlocation9' => { 382 => 0x26 },
	'focalplaneafpointsused' => { 382 => 0x1 },
	'focalplanediagonal' => { 259 => 0x103, 263 => 0x205 },
	'focalplaneresolutionunit' => { 109 => 0xa210, 415 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 109 => 0xa20e, 415 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 53 => 0x2 },
	'focalplanexunknown' => { 53 => 0x2 },
	'focalplaneyresolution' => { 109 => 0xa20f, 415 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 53 => 0x3 },
	'focalplaneyunknown' => { 53 => 0x3 },
	'focaltype' => { 9 => 0x2d, 53 => 0x0 },
	'focalunits' => { 33 => 0x19 },
	'focus' => { 226 => 0x8 },
	'focusarea' => { 161 => 0x31 },
	'focusareaselection' => { 253 => '15.2' },
	'focuscontinuous' => { 33 => 0x20 },
	'focusdisplayaiservoandmf' => { 75 => 0x515 },
	'focusdistance' => { 146 => 'FocusDistance', 161 => 0x13, 167 => 0x49bb, 194 => 0x9, 195 => 0xa, 261 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0xa7, 27 => 0x56, 28 => 0xa7, 51 => 0x15, 69 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0xa5, 27 => 0x54, 28 => 0xa5, 51 => 0x14, 69 => 0x13 },
	'focusholdbutton' => { 164 => 0x44 },
	'focusinfoversion' => { 261 => 0x0 },
	'focusingscreen' => { 74 => 0x0, 75 => 0x80b, 80 => 0x0 },
	'focuslocation' => { 367 => 0x2027 },
	'focuslocked' => { 160 => 0x14 },
	'focusmode' => { 33 => 0x7, 103 => 0x3, 104 => [0x3003,0xd], 114 => 0x1021, 125 => 0x38, 139 => 'FocusMode', 161 => 0x30, 163 => 0xe, 164 => 0xc, 198 => 0x7, 258 => 0x301, 263 => 0x100b, 279 => 0x7, 313 => 0xd, 320 => 0x3, 338 => 0x1006, 348 => [0xb,0x5], 354 => [0x15,0x1d], 355 => 0x4d, 356 => 0x4d, 367 => [0xb042,0xb04e,0x201b], 371 => 0x13, 387 => 0x16 },
	'focusmode2' => { 294 => '3.1', 371 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 245 => '10.1', 352 => 0x14, 353 => 0x15, 355 => 0x10, 356 => 0xf, 357 => 0x6 },
	'focusmodeswitch' => { 164 => 0x58, 355 => 0x2e },
	'focuspixel' => { 114 => 0x1023 },
	'focuspointwrap' => { 243 => '2.2', 244 => '2.2', 246 => '2.1', 250 => '1.1', 251 => '2.2', 252 => '1.1', 255 => '2.2', 256 => '2.5' },
	'focusposition' => { 194 => 0x8, 195 => 0x8, 313 => 0x10, 366 => 0x9bb },
	'focusposition2' => { 371 => [0x29,0x2b,0x2f], 387 => 0x2d, 390 => 0x20 },
	'focusprocess' => { 258 => 0x302 },
	'focusrange' => { 33 => 0x12, 263 => 0x100a },
	'focusrangeindex' => { 304 => '3.1' },
	'focussetting' => { 347 => 0x6 },
	'focusstatus' => { 354 => 0x19, 355 => 0x53, 356 => 0x53 },
	'focusstepcount' => { 261 => 0x301, 263 => 0x100e },
	'focusstepinfinity' => { 261 => 0x303, 263 => 0x103b },
	'focusstepnear' => { 261 => 0x304, 263 => 0x103c },
	'focustrackinglockon' => { 243 => ['1.5','4.1'], 244 => '1.4', 250 => '0.4', 251 => '3.1', 252 => '0.4', 255 => '1.4' },
	'focuswarning' => { 114 => 0x1301 },
	'foldername' => { 161 => 0x27 },
	'foldernumber' => { 355 => 0x9a, 357 => [0x402,0x114,0x316] },
	'fontcomposite' => { 440 => [\'Fonts','FontsComposite'] },
	'fontface' => { 440 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 440 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 440 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 440 => [\'Fonts','FontsFontName'] },
	'fonts' => { 440 => 'Fonts' },
	'fonttype' => { 440 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 440 => [\'Fonts','FontsVersionString'] },
	'for' => { 329 => 'For' },
	'format' => { 412 => 'format', 433 => 'Format' },
	'forwardlock' => { 430 => 'forwardlock' },
	'forwardmatrix1' => { 109 => 0xc714 },
	'forwardmatrix2' => { 109 => 0xc715 },
	'framecount' => { 60 => [0x2,0x4] },
	'frameheight' => { 114 => 0x3822 },
	'framenum' => { 324 => 0xd7 },
	'framenumber' => { 114 => 0x8003, 167 => 0x3c, 313 => 0x29 },
	'framerate' => { 60 => [0x1,0x6], 109 => 0xc764, 114 => 0x3820 },
	'framewidth' => { 114 => 0x3821 },
	'framing' => { 424 => 'framing' },
	'freebytes' => { 88 => 0x1 },
	'freememorycardimages' => { 162 => [0x37,0x54], 163 => [0x2d,0x4a], 164 => 0x32 },
	'fujiflashmode' => { 114 => 0x1010 },
	'fullimagesize' => { 367 => 0xb02b },
	'fullpanoheightpixels' => { 400 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 400 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 338 => 0x100d },
	'fullsizeimage' => { 145 => 'data' },
	'fullsizeimagename' => { 145 => '1Name' },
	'fullsizeimagetype' => { 145 => '0Type' },
	'func1button' => { 246 => '14.1' },
	'func1buttonplusdials' => { 246 => '42.1' },
	'func2button' => { 246 => '80.1' },
	'funcbutton' => { 243 => ['14.1','15.1'], 244 => '14.1', 251 => '28.1', 252 => '13.1', 255 => '14.1', 256 => '14.1' },
	'funcbuttonplusdials' => { 243 => ['14.2','15.2'], 244 => '14.2', 251 => '31.1', 255 => '42.1' },
	'functionbutton' => { 249 => '13.1', 253 => '5.2' },
	'gainbase' => { 262 => 0x610 },
	'gaincontrol' => { 109 => 0xa407, 415 => 'GainControl' },
	'gamma' => { 109 => 0xa500, 416 => 'Gamma' },
	'gammablackpoint' => { 96 => 0xc },
	'gammacolortone' => { 96 => 0x3 },
	'gammacompensatedvalue' => { 119 => 0x91 },
	'gammacontrast' => { 96 => 0x2 },
	'gammacurveoutputrange' => { 96 => 0xf },
	'gammahighlight' => { 96 => 0xa },
	'gammalinear' => { 94 => 0x20200 },
	'gammamidpoint' => { 96 => 0xe },
	'gammasaturation' => { 96 => 0x4 },
	'gammashadow' => { 96 => 0x9 },
	'gammasharpnessstrength' => { 96 => 0x8 },
	'gammaunsharpmaskfineness' => { 96 => 0x6 },
	'gammaunsharpmaskstrength' => { 96 => 0x5 },
	'gammaunsharpmaskthreshold' => { 96 => 0x7 },
	'gammawhitepoint' => { 96 => 0xd },
	'geimagesize' => { 114 => 0x1304 },
	'gemake' => { 115 => 0x300 },
	'gemodel' => { 115 => 0x207 },
	'genre' => { 425 => 'genre', 435 => 'genre' },
	'geography' => { 426 => 'geography' },
	'geologicalcontext' => { 108 => 'GeologicalContext' },
	'geologicalcontextbed' => { 108 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 108 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 108 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 108 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 108 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 110 => 'Geosync' },
	'geotag' => { 110 => 'Geotag' },
	'geotiffasciiparams' => { 109 => 0x87b1 },
	'geotiffdirectory' => { 109 => 0x87af },
	'geotiffdoubleparams' => { 109 => 0x87b0 },
	'geotime' => { 110 => 'Geotime' },
	'globalaltitude' => { 327 => 0x419 },
	'globalangle' => { 327 => 0x40d },
	'good' => { 435 => 'good' },
	'googleplusuploadcode' => { 109 => 0x9009 },
	'gpsaltitude' => { 116 => 0x6, 143 => 'Altitude', 415 => 'GPSAltitude' },
	'gpsaltituderef' => { 116 => 0x5, 415 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 116 => 0x1c, 415 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 116 => 0x1d },
	'gpsdatetime' => { 143 => 'DateTime', 415 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 116 => 0x18, 143 => 'Bearing', 415 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 116 => 0x17, 415 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 116 => 0x1a, 143 => 'Distance', 415 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 116 => 0x19, 415 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 116 => 0x14, 415 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 116 => 0x13 },
	'gpsdestlongitude' => { 116 => 0x16, 415 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 116 => 0x15 },
	'gpsdifferential' => { 116 => 0x1e, 143 => 'Differential', 415 => 'GPSDifferential' },
	'gpsdop' => { 116 => 0xb, 415 => 'GPSDOP' },
	'gpshpositioningerror' => { 116 => 0x1f, 415 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 116 => 0x11, 415 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 116 => 0x10, 415 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 116 => 0x2, 143 => 'Latitude', 415 => 'GPSLatitude' },
	'gpslatituderef' => { 116 => 0x1 },
	'gpslongitude' => { 116 => 0x4, 143 => 'Longitude', 415 => 'GPSLongitude' },
	'gpslongituderef' => { 116 => 0x3 },
	'gpsmapdatum' => { 116 => 0x12, 143 => 'Datum', 415 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 116 => 0xa, 143 => 'MeasureMode', 415 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 116 => 0x1b, 415 => 'GPSProcessingMethod' },
	'gpssatellites' => { 116 => 0x8, 143 => 'Satellites', 415 => 'GPSSatellites' },
	'gpsspeed' => { 116 => 0xd, 143 => 'Speed', 415 => 'GPSSpeed' },
	'gpsspeedref' => { 116 => 0xc, 415 => 'GPSSpeedRef' },
	'gpsstatus' => { 116 => 0x9, 415 => 'GPSStatus' },
	'gpstimestamp' => { 116 => 0x7 },
	'gpstrack' => { 116 => 0xf, 143 => 'Heading', 415 => 'GPSTrack' },
	'gpstrackref' => { 116 => 0xe, 415 => 'GPSTrackRef' },
	'gpsversionid' => { 116 => 0x0, 415 => 'GPSVersionID' },
	'gradation' => { 258 => 0x50f },
	'gradientbasedcorractive' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 411 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 411 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 411 => 'GrainAmount' },
	'grainfrequency' => { 411 => 'GrainFrequency' },
	'grainsize' => { 411 => 'GrainSize' },
	'graymixeraqua' => { 411 => 'GrayMixerAqua' },
	'graymixerblue' => { 411 => 'GrayMixerBlue' },
	'graymixergreen' => { 411 => 'GrayMixerGreen' },
	'graymixermagenta' => { 411 => 'GrayMixerMagenta' },
	'graymixerorange' => { 411 => 'GrayMixerOrange' },
	'graymixerpurple' => { 411 => 'GrayMixerPurple' },
	'graymixerred' => { 411 => 'GrayMixerRed' },
	'graymixeryellow' => { 411 => 'GrayMixerYellow' },
	'graypoint' => { 396 => 0x8021 },
	'grayresponseunit' => { 109 => 0x122 },
	'greencurvelimits' => { 99 => 0x1c4 },
	'greencurvepoints' => { 98 => 0x53, 99 => 0x19a },
	'greenhsl' => { 94 => 0x20912 },
	'greenhue' => { 411 => 'GreenHue' },
	'greensaturation' => { 411 => 'GreenSaturation' },
	'griddisplay' => { 243 => '13.3', 244 => '4.3', 246 => '4.2', 247 => '2.2', 251 => '10.5', 252 => '3.4', 253 => '6.1', 255 => '4.4', 256 => '4.2' },
	'gripbatteryadload' => { 292 => 0x5 },
	'gripbatteryadnoload' => { 292 => 0x4 },
	'gripbatterystate' => { 292 => '1.2' },
	'groupareaafillumination' => { 244 => '46.4', 246 => '47.4', 255 => '47.4' },
	'halftonehints' => { 109 => 0x141 },
	'hardlink' => { 110 => 'HardLink' },
	'hasalternative' => { 425 => 'hasAlternative' },
	'hascorrection' => { 425 => 'hasCorrection' },
	'hascorrectiona-lang' => { 425 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 425 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 425 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 411 => 'HasCrop' },
	'hasextendedxmp' => { 437 => 'HasExtendedXMP' },
	'hassettings' => { 411 => 'HasSettings' },
	'hastranslation' => { 425 => 'hasTranslation' },
	'hasvisibleoverprint' => { 440 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 440 => 'HasVisibleTransparency' },
	'hdr' => { 54 => 0x1, 191 => 0x4, 279 => 0x9e, 313 => 0x85, 367 => 0x200a },
	'hdreffect' => { 54 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 191 => 0x0 },
	'hdrlevel' => { 191 => 0x5, 357 => 0x2e, 371 => 0x17 },
	'hdrlevel2' => { 191 => 0x7 },
	'hdrsetting' => { 357 => 0x2d, 371 => 0x16, 374 => 0x1148, 375 => 0x1148, 376 => 0x1124, 377 => 0x11a0, 378 => 0x117c, 379 => 0x1034, 380 => 0x22c, 381 => 0x22c },
	'hdrsmoothing' => { 191 => 0x6 },
	'headline' => { 117 => 0x69, 423 => 'Headline' },
	'hierarchicalkeywords' => { 154 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 154 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 154 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 154 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 154 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 402 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 108 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 283 => 0x1a },
	'highisomultipliergreen' => { 283 => 0x19 },
	'highisomultiplierred' => { 283 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 27 => 0xc9, 56 => 0x5, 75 => 0x202, 114 => 0x100e, 198 => 0xb1, 313 => 0x71, 355 => 0x2c, 356 => 0x26, 357 => 0x26, 367 => 0x2009, 371 => 0x12, 392 => 0x42 },
	'highisonoisereduction2' => { 367 => 0xb050 },
	'highlight' => { 347 => 0xf },
	'highlightadj' => { 94 => 0x2030c },
	'highlightcolordistortreduct' => { 396 => 0x8026 },
	'highlightlinearitylimit' => { 344 => 0xa025 },
	'highlightprotection' => { 235 => 0x6 },
	'highlightrecovery' => { 411 => 'HighlightRecovery' },
	'highlights' => { 404 => 'Highlights' },
	'highlights2012' => { 411 => 'Highlights2012' },
	'highlighttone' => { 114 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 27 => 0x7, 56 => 0x3, 75 => 0x203 },
	'highlowkeyadj' => { 313 => 0x6c },
	'highspeedsync' => { 164 => 0x5, 355 => 0x2, 356 => 0x2 },
	'histogramxml' => { 236 => 0x83a1a25 },
	'history' => { 423 => 'History', 436 => 'History' },
	'historyaction' => { 436 => [\'History','HistoryAction'] },
	'historychanged' => { 436 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 436 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 436 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 436 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 436 => [\'History','HistoryWhen'] },
	'hometowncity' => { 104 => 0x3006, 313 => 0x23, 319 => 0x2 },
	'hometowncitycode' => { 320 => 0x1000 },
	'hometowndst' => { 313 => 0x25, 319 => '0.2' },
	'hostcomputer' => { 109 => 0x13c },
	'hue' => { 169 => 0x3b, 201 => 0x3d, 313 => 0x67 },
	'hueadj' => { 239 => 0x2f, 396 => 0x8019 },
	'hueadjust' => { 338 => 0x1016 },
	'hueadjustment' => { 162 => 0x4a, 163 => 0x40, 198 => 0x92, 200 => 0x36 },
	'hueadjustmentaqua' => { 411 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 411 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 411 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 411 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 411 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 411 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 411 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 411 => 'HueAdjustmentYellow' },
	'huesetting' => { 266 => 0x1011 },
	'humidity' => { 109 => 0x9401 },
	'icc_profile' => { 110 => 'ICC_Profile' },
	'iccprofilename' => { 423 => 'ICCProfile' },
	'idccreativestyle' => { 396 => 0x8000 },
	'idcpreviewlength' => { 396 => 0x202 },
	'idcpreviewstart' => { 396 => 0x201 },
	'identification' => { 108 => 'Identification' },
	'identificationid' => { 108 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 108 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 108 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 108 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 108 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 108 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 412 => 'identifier', 433 => 'Identifier' },
	'illumination' => { 253 => '0.5' },
	'imageadjustment' => { 198 => 0x80, 226 => 0x5 },
	'imagealterationconstraints' => { 268 => 'ImageAlterationConstraints' },
	'imagearea' => { 210 => 0x10, 213 => 0x10 },
	'imageareaoffset' => { 313 => 0x38 },
	'imageauthentication' => { 198 => 0x20 },
	'imageboundary' => { 198 => 0x16 },
	'imagecount' => { 114 => 0x1438, 198 => 0xa5, 369 => 0x11b, 383 => [0x32,0x3a] },
	'imagecount2' => { 383 => [0x4c,0x58] },
	'imagecount3' => { 383 => [0x1a0,0x1aa,0x1bd,0x1cb] },
	'imagecreator' => { 268 => 'ImageCreator' },
	'imagecreatorid' => { 268 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 268 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 268 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 198 => 0xa2 },
	'imagedescription' => { 109 => 0x10e, 431 => 'ImageDescription' },
	'imageduplicationconstraints' => { 268 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 236 => 0xfe443a45 },
	'imageeditcount' => { 313 => 0x41 },
	'imageediting' => { 313 => 0x32 },
	'imageeffects' => { 338 => 0x1010 },
	'imagefileconstraints' => { 268 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 268 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 268 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 114 => 0x1436 },
	'imageheight' => { 109 => 0x101, 168 => 0xc, 322 => 0x10d, 431 => 'ImageLength' },
	'imagehistory' => { 109 => 0x9213, 414 => 'ImageHistory' },
	'imageidnumber' => { 275 => 0x340 },
	'imagenumber' => { 109 => 0x9211, 139 => 'ImageNumber', 162 => 0xae, 163 => 0x5e, 322 => 0x113, 355 => 0x9b, 357 => [0x400,'276.1',0x314], 407 => 'ImageNumber' },
	'imagenumber2' => { 163 => 0x62 },
	'imageoptimization' => { 198 => 0xa9 },
	'imageorientation' => { 117 => 0x83 },
	'imageprocessing' => { 198 => 0x1a },
	'imageprocessingversion' => { 262 => 0x0 },
	'imagequality' => { 139 => 'ImageQuality', 212 => '723.2', 213 => '732.2', 222 => '708.1', 279 => 0x1 },
	'imagequality2' => { 258 => 0x603 },
	'imageref' => { 419 => 'ImageRef' },
	'imagereview' => { 245 => '0.4', 253 => '0.4' },
	'imagereviewmonitorofftime' => { 244 => '21.1', 246 => '21.1', 250 => '20.1', 255 => '21.1' },
	'imagereviewtime' => { 243 => '25.1', 245 => '2.1', 247 => '19.1', 248 => '20.1', 249 => '20.1', 251 => '9.2', 252 => '20.1', 256 => '21.2' },
	'imagesize' => { 145 => 'ImageSize' },
	'imagesizerestriction' => { 428 => 'imageSizeRestriction' },
	'imagesourcedata' => { 109 => 0x935c },
	'imagestabilization' => { 33 => 0x22, 104 => 0x3020, 114 => 0x1422, 139 => 'ImageStabilization', 162 => 0xbd, 163 => 0x71, 164 => 0x57, 165 => 0x0, 166 => [0x18,0x107,0x113], 167 => 0x49c2, 198 => 0xac, 258 => 0x604, 261 => 0x1600, 279 => 0x1a, 360 => 0x12, 361 => 0x11, 367 => 0xb026 },
	'imagestabilization2' => { 359 => 0xa },
	'imagestabilizationsetting' => { 167 => 0x14, 355 => 0x3d, 356 => 0x3d, 366 => 0x14 },
	'imagestyle' => { 355 => 0x2d, 356 => 0x27 },
	'imagesupplier' => { 268 => 'ImageSupplier' },
	'imagesupplierid' => { 268 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 268 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 268 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 111 => 0x1 },
	'imagetemperaturemin' => { 111 => 0x2 },
	'imagetone' => { 313 => 0x4f },
	'imagetype' => { 117 => 0x82, 268 => 'ImageType' },
	'imageuniqueid' => { 57 => 0x28, 109 => 0xa420, 415 => 'ImageUniqueID' },
	'imagewidth' => { 109 => 0x100, 168 => 0xe, 322 => 0x10c, 431 => 'ImageWidth' },
	'incrementaltemperature' => { 411 => 'IncrementalTemperature' },
	'incrementaltint' => { 411 => 'IncrementalTint' },
	'industry' => { 425 => 'industry', 426 => 'industry' },
	'infobuttonwhenshooting' => { 75 => 0x409 },
	'infraredilluminator' => { 334 => 0x28 },
	'ingredientexclusion' => { 427 => 'ingredientExclusion' },
	'ingredients' => { 436 => 'Ingredients' },
	'ingredientsalternatepaths' => { 436 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 436 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 436 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 436 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 436 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 436 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 436 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 436 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 436 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 436 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 436 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 436 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 436 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 436 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 436 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 436 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 436 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 436 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 436 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 436 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 436 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 436 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 436 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 75 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 400 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 400 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 400 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 400 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 400 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 243 => '4.4' },
	'initialzoomsetting' => { 243 => '9.3', 251 => '27.3' },
	'inkset' => { 109 => 0x14c },
	'inputprofile' => { 123 => 0x1389 },
	'instanceid' => { 436 => 'InstanceID' },
	'instantplaybacksetup' => { 164 => 0x3e },
	'instantplaybacktime' => { 164 => 0x3d },
	'instructions' => { 423 => 'Instructions' },
	'instrument' => { 435 => 'instrument' },
	'intellectualgenre' => { 420 => 'IntellectualGenre' },
	'intelligentauto' => { 367 => 0xb052 },
	'intelligentcontrast' => { 46 => 0x4 },
	'intelligentd-range' => { 279 => 0x79 },
	'intelligentexposure' => { 279 => 0x5d },
	'intelligentresolution' => { 279 => 0x70 },
	'interchangecolorspace' => { 119 => 0x40 },
	'internalflash' => { 161 => 0x2b, 243 => '23.1', 245 => '8.1', 247 => '22.1', 249 => '23.1', 253 => '8.1', 256 => '24.1', 261 => 0x1208 },
	'internalflashae1' => { 263 => 0x1021 },
	'internalflashae1_0' => { 263 => 0x101d },
	'internalflashae2' => { 263 => 0x1022 },
	'internalflashae2_0' => { 263 => 0x101e },
	'internalflashmode' => { 301 => 0x1 },
	'internalflashstrength' => { 301 => 0x3 },
	'internalflashtable' => { 263 => 0x1024 },
	'internallensserialnumber' => { 344 => 0xa005 },
	'internalndfilter' => { 279 => 0x9d },
	'internalserialnumber' => { 57 => 0x96, 68 => 0x9, 114 => 0x10, 167 => 0x49dc, 257 => 0x18, 259 => 0x102, 279 => 0x25, 293 => 0x4, 338 => 0x5, 383 => [0x7c,0x88,0xf0] },
	'interopindex' => { 109 => 0x1, 416 => 'InteroperabilityIndex' },
	'interopversion' => { 109 => 0x2 },
	'intervallength' => { 161 => 0x10 },
	'intervalmode' => { 161 => 0x26 },
	'intervalnumber' => { 161 => 0x11 },
	'introtime' => { 435 => 'introTime' },
	'introtimescale' => { 435 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 435 => [\'introTime','introTimeValue'] },
	'iptc' => { 110 => 'IPTC' },
	'iptc-naa' => { 109 => 0x83bb, 283 => 0x83bb },
	'iptcbitspersample' => { 119 => 0x56 },
	'iptcdigest' => { 327 => 0x425 },
	'iptcimageheight' => { 119 => 0x1e },
	'iptcimagerotation' => { 119 => 0x66 },
	'iptcimagewidth' => { 119 => 0x14 },
	'iptclastedited' => { 421 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 119 => 0xa },
	'iptcpixelheight' => { 119 => 0x32 },
	'iptcpixelwidth' => { 119 => 0x28 },
	'isalternativeof' => { 425 => 'isAlternativeOf' },
	'isbn' => { 425 => 'isbn' },
	'iscorrectionof' => { 425 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 100 => 0x3 },
	'ismergedhdr' => { 407 => 'IsMergedHDR' },
	'ismergedpanorama' => { 407 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x0, 30 => 0x1, 103 => 0x14, 104 => [0x3014,0x14], 109 => 0x8827, 122 => 0xfd06, 123 => 0x1784, 125 => 0x60, 127 => [0xfa2e,0xfa46], 128 => [0x27,0x28], 129 => 0xf105, 132 => 0x14, 134 => 0x4e, 137 => 0x34, 139 => 'ISO', 161 => 0x8, 167 => 0x49ba, 192 => 0x0, 198 => 0x2, 283 => 0x17, 313 => [0x8b,0x14], 320 => 0x14, 322 => 0x105, 344 => 0xa014, 366 => 0x6f, 371 => [0x1f,0x21,0x25], 415 => 'ISOSpeedRatings' },
	'iso2' => { 192 => 0x6, 207 => 0x265, 208 => 0x25c, 209 => 0x265, 210 => 0x221, 211 => 0x25d, 212 => 0x256, 213 => 0x25d, 217 => 0x2b5, 220 => 0x265, 225 => 0x2b5 },
	'isoauto' => { 294 => '14.4' },
	'isoautohilimit' => { 215 => 0x18eb, 216 => 0xe82, 224 => 0x185d },
	'isoautoparameters' => { 313 => 0x7a },
	'isoautoshuttertime' => { 215 => 0x18ea, 216 => 0xe81, 224 => 0x185c },
	'isodisplay' => { 246 => '4.1', 247 => '2.3', 248 => '3.3', 249 => '3.3', 252 => '3.3', 255 => '4.3', 256 => '4.3' },
	'isoexpansion' => { 75 => 0x103, 76 => 0x7, 77 => 0x8, 80 => 0x8, 192 => 0x4 },
	'isoexpansion2' => { 192 => 0xa },
	'isofloor' => { 294 => 0x6 },
	'isoselection' => { 198 => 0xf },
	'isosensitivitystep' => { 250 => '6.2', 252 => '6.2' },
	'isosetting' => { 125 => 0x5e, 139 => 'ISOSetting', 161 => 0x24, 162 => 0x26, 163 => 0x1c, 164 => 0x13, 169 => 0x6, 198 => 0x13, 294 => '17.3', 337 => 0x27, 355 => 0x16, 356 => 0x14, 357 => 0x2, 366 => 0x6d },
	'isospeed' => { 109 => 0x8833, 416 => 'ISOSpeed' },
	'isospeedexpansion' => { 74 => 0x3 },
	'isospeedincrements' => { 75 => 0x102 },
	'isospeedlatitudeyyy' => { 109 => 0x8834, 416 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 109 => 0x8835, 416 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 75 => 0x103 },
	'isostepsize' => { 243 => '6.1', 244 => '7.2', 246 => '7.2', 251 => '4.1', 255 => '7.2' },
	'isovalue' => { 263 => 0x1001 },
	'issn' => { 425 => 'issn' },
	'issueidentifier' => { 425 => 'issueIdentifier' },
	'issuename' => { 425 => 'issueName' },
	'issueteaser' => { 425 => 'issueTeaser' },
	'issuetype' => { 425 => 'issueType' },
	'istranslationof' => { 425 => 'isTranslationOf' },
	'jobid' => { 117 => 0xb8 },
	'jobname' => { 417 => 'JobName' },
	'jobref' => { 434 => 'JobRef' },
	'jobrefid' => { 434 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 434 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 434 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 417 => 'JobStatus' },
	'jpeghandling' => { 411 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 281 => 0x3034, 367 => 0xb047 },
	'jpegsize' => { 281 => 0x303a },
	'jpgcompression' => { 216 => 0x7d4 },
	'jpgfromraw' => { 88 => 0x2007, 105 => 'JpgFromRaw', 283 => 0x2e },
	'jpgfromrawlength' => { 109 => [0x117,0x202] },
	'jpgfromrawstart' => { 109 => [0x111,0x201] },
	'jpgrecordedpixels' => { 294 => '14.1' },
	'jurisdiction' => { 408 => 'jurisdiction' },
	'kelvinwb_01' => { 302 => 0x5 },
	'kelvinwb_02' => { 302 => 0x9 },
	'kelvinwb_03' => { 302 => 0xd },
	'kelvinwb_04' => { 302 => 0x11 },
	'kelvinwb_05' => { 302 => 0x15 },
	'kelvinwb_06' => { 302 => 0x19 },
	'kelvinwb_07' => { 302 => 0x1d },
	'kelvinwb_08' => { 302 => 0x21 },
	'kelvinwb_09' => { 302 => 0x25 },
	'kelvinwb_10' => { 302 => 0x29 },
	'kelvinwb_11' => { 302 => 0x2d },
	'kelvinwb_12' => { 302 => 0x31 },
	'kelvinwb_13' => { 302 => 0x35 },
	'kelvinwb_14' => { 302 => 0x39 },
	'kelvinwb_15' => { 302 => 0x3d },
	'kelvinwb_16' => { 302 => 0x41 },
	'kelvinwb_daylight' => { 302 => 0x1 },
	'key' => { 435 => 'key' },
	'keystonecompensation' => { 262 => 0x1900 },
	'keystonedirection' => { 262 => 0x1901 },
	'keystonevalue' => { 262 => 0x1906 },
	'keyword' => { 425 => 'keyword' },
	'keywordinfo' => { 154 => 'Keywords' },
	'keywords' => { 117 => 0x19, 140 => 'Keywords', 267 => 'Keywords', 329 => 'Keywords', 405 => 'keywords', 422 => 'Keywords', 433 => 'Keywords' },
	'killdate' => { 425 => 'killDate' },
	'killdatea-platform' => { 425 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 425 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 122 => 0xf908, 125 => 0xe, 127 => [0xfa1e,0xfa52], 133 => 0x70 },
	'kodakimagewidth' => { 122 => 0xf907, 125 => 0xc, 127 => [0xfa1d,0xfa51], 133 => 0x6c },
	'kodakinfotype' => { 122 => 0xfa00 },
	'kodaklook' => { 123 => 0xe4c },
	'kodaklookprofile' => { 123 => 0x138a },
	'kodakmaker' => { 133 => 0x8 },
	'kodakmodel' => { 125 => 0x0, 133 => 0x28 },
	'label' => { 271 => 'Label', 433 => 'Label' },
	'labelname1' => { 419 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 419 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 279 => 0x6f },
	'landscapeoutputhighlightpoint' => { 100 => 0x26 },
	'landscapeoutputshadowpoint' => { 100 => 0x27 },
	'landscaperawcolortone' => { 100 => 0x1f },
	'landscaperawcontrast' => { 100 => 0x21 },
	'landscaperawhighlight' => { 100 => 0x77 },
	'landscaperawhighlightpoint' => { 100 => 0x24 },
	'landscaperawlinear' => { 100 => 0x22 },
	'landscaperawsaturation' => { 100 => 0x20 },
	'landscaperawshadow' => { 100 => 0x80 },
	'landscaperawshadowpoint' => { 100 => 0x25 },
	'landscaperawsharpness' => { 100 => 0x23 },
	'landscapeunsharpmaskfineness' => { 100 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 100 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 100 => 0xa2 },
	'language' => { 412 => 'language' },
	'languageidentifier' => { 117 => 0x87 },
	'largestvalidinteriorrectheight' => { 400 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 400 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 400 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 400 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 161 => 0x1b },
	'lastkeywordiptc' => { 159 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 159 => 'LastKeywordXMP' },
	'lastphotodate' => { 400 => 'LastPhotoDate' },
	'lasturl' => { 436 => 'LastURL' },
	'lateralchromaticaberration' => { 367 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 407 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 108 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 108 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 108 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 108 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 108 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 304 => 0x2 },
	'lc10' => { 304 => 0xb },
	'lc11' => { 304 => 0xc },
	'lc12' => { 304 => 0xd },
	'lc14' => { 304 => 0xf },
	'lc15' => { 304 => 0x10 },
	'lc3' => { 304 => 0x4 },
	'lc4' => { 304 => 0x5 },
	'lc5' => { 304 => 0x6 },
	'lc6' => { 304 => 0x7 },
	'lc7' => { 304 => 0x8 },
	'lc8' => { 304 => 0x9 },
	'lcddisplayatpoweron' => { 75 => 0x811, 79 => 0xa },
	'lcddisplayreturntoshoot' => { 80 => 0x12 },
	'lcdillumination' => { 243 => '17.5', 244 => '5.2', 246 => '5.1', 251 => '10.3', 252 => '4.2', 255 => '5.2', 256 => '5.4' },
	'lcdilluminationduringbulb' => { 75 => 0x408 },
	'lcdpanels' => { 74 => 0x8 },
	'lcheditor' => { 236 => 0x8ae85e },
	'legacyiptcdigest' => { 423 => 'LegacyIPTCDigest' },
	'legalcode' => { 408 => 'legalcode' },
	'lens' => { 109 => 0xfdea, 198 => 0x84, 407 => 'Lens' },
	'lensafstopbutton' => { 73 => 0x11, 74 => 0x13, 75 => 0x506, 76 => 0x10, 77 => 0x12, 80 => 0x13, 81 => 0x9 },
	'lensaperturerange' => { 347 => [0x30,0x48] },
	'lenscorrectionsettings' => { 414 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 407 => 'LensDistortInfo' },
	'lensdistortionparams' => { 263 => 0x206 },
	'lensdrivenoaf' => { 75 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 357 => 0x3f0, 395 => 0xd },
	'lensfirmware' => { 339 => 0x20, 344 => 0xa004 },
	'lensfirmwareversion' => { 259 => 0x204, 279 => 0x60, 357 => 0x3f4, 395 => 0x15 },
	'lensfocallength' => { 94 => 0xf0512, 304 => 0x9 },
	'lensfocalrange' => { 347 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 244 => '55.1', 246 => '52.1', 255 => '52.1' },
	'lensformat' => { 378 => 0x1891, 380 => 0x18bd, 381 => 0x18ed, 383 => 0x106, 391 => 0x603, 392 => 0x5d },
	'lensfstops' => { 193 => 0x7, 194 => 0xc, 195 => 0xd, 198 => 0x8b, 304 => '0.3' },
	'lensid' => { 407 => 'LensID' },
	'lensidnumber' => { 193 => 0x6, 194 => 0xb, 195 => 0xc },
	'lensinfo' => { 109 => 0xa432, 310 => 0x2a, 407 => 'LensInfo', 416 => 'LensSpecification' },
	'lenskind' => { 304 => 0x1 },
	'lensmake' => { 109 => 0xa433, 146 => 'Make', 416 => 'LensMake' },
	'lensmanualdistortionamount' => { 411 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 159 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 347 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 57 => 0x95, 109 => 0xa434, 146 => 'Model', 159 => 'LensModel', 196 => 0x18a, 259 => 0x203, 277 => 0x303, 310 => 0xc, 322 => 0x412, 416 => 'LensModel' },
	'lensmount' => { 357 => 0x99, 378 => 0x1892, 380 => 0x18be, 381 => 0x18ee, 383 => 0x105, 391 => 0x604, 392 => 0x5e },
	'lensmount2' => { 395 => 0x8 },
	'lensparameters' => { 375 => 0x1a23, 378 => 0x1870, 380 => 0x189c, 381 => 0x18cc, 391 => 0x6ca, 392 => 0x64 },
	'lensprofilechromaticaberrationscale' => { 411 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 411 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 411 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 411 => 'LensProfileEnable' },
	'lensprofilefilename' => { 411 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 411 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 411 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 411 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 411 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 411 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 411 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 411 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 411 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 411 => 'LensProfileName' },
	'lensprofilesetup' => { 411 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 411 => 'LensProfileVignettingScale' },
	'lensproperties' => { 259 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 31 => 0x16b, 55 => 0x0, 109 => 0xa435, 146 => 'SerialNumber', 259 => 0x202, 279 => 0x52, 339 => 0x30, 407 => 'LensSerialNumber', 416 => 'LensSerialNumber' },
	'lensshutterlock' => { 164 => 0x4a },
	'lensspec' => { 352 => 0x0, 353 => 0x0, 354 => 0x0, 367 => 0xb02a },
	'lensspecfeatures' => { 383 => [0x115,0x116] },
	'lenstemperature' => { 263 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x184, 27 => 0x112, 28 => 0x189, 33 => 0x16, 166 => 0x10c, 167 => 0x49bd, 198 => 0x83, 259 => 0x201, 272 => 0x16, 275 => 0x310, 278 => 0x303, 279 => 0x51, 281 => 0x3405, 305 => 0x0, 306 => 0x0, 307 => 0x1, 308 => 0x1, 309 => 0x1, 311 => 0x0, 344 => 0xa003, 347 => 0x27, 367 => 0xb027, 378 => 0x1896, 380 => 0x18c2, 381 => 0x18f2, 383 => 0x109, 391 => 0x608, 392 => 0x62 },
	'lenstype2' => { 357 => 0x3f7, 378 => 0x1893, 380 => 0x18bf, 381 => 0x18ef, 383 => 0x107, 391 => 0x605, 392 => 0x60 },
	'lenstype3' => { 395 => 0x9 },
	'lenszoomposition' => { 389 => 0x19, 390 => 0x1e, 392 => [0x342,0x35a] },
	'levelindicator' => { 286 => 0x15 },
	'levelorientation' => { 312 => 0x0 },
	'license' => { 408 => 'license' },
	'licensee' => { 268 => 'Licensee' },
	'licenseeid' => { 268 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 268 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 268 => 'LicenseeImageNotes' },
	'licenseename' => { 268 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 268 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 268 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 268 => 'LicenseeTransactionID' },
	'licenseid' => { 268 => 'LicenseID' },
	'licensestartdate' => { 268 => 'LicenseStartDate' },
	'licensetransactiondate' => { 268 => 'LicenseTransactionDate' },
	'licensetype' => { 413 => 'licensetype' },
	'licensor' => { 268 => 'Licensor' },
	'licensorcity' => { 268 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 268 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 268 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 268 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 268 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 268 => 'LicensorImageID' },
	'licensorname' => { 268 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 268 => 'LicensorNotes' },
	'licensorpostalcode' => { 268 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 268 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 268 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 268 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 268 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 268 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 268 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 268 => 'LicensorTransactionID' },
	'licensorurl' => { 268 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 263 => 0x1009 },
	'lightingmode' => { 104 => 0x302a },
	'lightreading' => { 313 => 0x15 },
	'lightsource' => { 109 => 0x9208, 198 => 0x90, 266 => 0x1000, 415 => 'LightSource' },
	'lightsourcespecial' => { 346 => 0x21d },
	'lightswitch' => { 255 => '0.1', 256 => '0.1' },
	'lightvaluecenter' => { 263 => 0x103d },
	'lightvalueperiphery' => { 263 => 0x103e },
	'limitafareamodeselection' => { 244 => '51.1', 246 => '49.1', 255 => '49.1' },
	'linearitylimitblue' => { 283 => 0x10 },
	'linearitylimitgreen' => { 283 => 0xf },
	'linearitylimitred' => { 283 => 0xe },
	'linearityuppermargin' => { 40 => [0x2ba,0x2d1,0x2d5], 42 => 0x1e5, 43 => [0x1fe,0x2de], 44 => [0x232,0x310] },
	'linearizationtable' => { 109 => 0xc618 },
	'linearresponselimit' => { 109 => 0xc62e },
	'link' => { 425 => 'link' },
	'linkaetoafpoint' => { 294 => '14.2' },
	'linkedencodedrightsexpr' => { 421 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 421 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 421 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 421 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 108 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 247 => '32.1', 256 => '34.1' },
	'liveviewafareamode' => { 252 => '34.1' },
	'liveviewafmethod' => { 371 => 0x20 },
	'liveviewafmode' => { 252 => '34.2' },
	'liveviewafsetting' => { 357 => 0x36 },
	'liveviewbuttonoptions' => { 244 => '50.2', 246 => '48.2', 255 => '48.2' },
	'liveviewexposuresimulation' => { 75 => 0x810 },
	'liveviewfocusmode' => { 357 => [0x8b,0x28b] },
	'liveviewmetering' => { 357 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 244 => '21.2', 246 => '21.2', 248 => '20.2', 249 => '20.2', 250 => '20.2', 252 => '20.2', 255 => '21.2' },
	'liveviewshooting' => { 51 => 0x13 },
	'localcaption' => { 117 => 0x79 },
	'localizedcameramodel' => { 109 => 0xc615 },
	'locallocationname' => { 344 => 0x30 },
	'location' => { 197 => 0x9, 279 => 0x67, 403 => 'Location', 420 => 'Location', 424 => 'location', 425 => 'location' },
	'locationareacode' => { 409 => 'lac' },
	'locationcreated' => { 421 => 'LocationCreated' },
	'locationcreatedcity' => { 421 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 421 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 421 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedlocationid' => { 421 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedprovincestate' => { 421 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 421 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 421 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 197 => 0x0 },
	'locationname' => { 344 => 0x31 },
	'locationshown' => { 421 => 'LocationShown' },
	'locationshowncity' => { 421 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 421 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 421 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownlocationid' => { 421 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownprovincestate' => { 421 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 421 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 421 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 75 => 0x709 },
	'logcomment' => { 435 => 'logComment' },
	'longexposurenoisereduction' => { 56 => 0x4, 75 => 0x201, 76 => 0x1, 77 => 0x2, 78 => 0x1, 79 => 0x1, 80 => 0x2, 81 => 0x1, 279 => 0x49, 355 => 0x2b, 356 => 0x25, 357 => 0x25, 367 => 0x2008, 371 => 0x11, 392 => 0x44 },
	'longexposurenoisereduction2' => { 51 => 0x8 },
	'loop' => { 435 => 'loop' },
	'lowestbiostratigraphiczone' => { 108 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 411 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 411 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 411 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 411 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 411 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 411 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 411 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 411 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 99 => 0x150 },
	'luminancecurvepoints' => { 99 => 0x126 },
	'luminancenoisereduction' => { 94 => 0x20600, 100 => 0x5f, 347 => 0x1b },
	'luminancenoisereductioncontrast' => { 411 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 411 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 100 => 0x6d },
	'luminancesmoothing' => { 411 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 75 => [0x40b,0x40c] },
	'lyrics' => { 435 => 'lyrics' },
	'm16cversion' => { 275 => 0x333 },
	'macatom' => { 410 => 'macAtom' },
	'macatomapplicationcode' => { 410 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 410 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 410 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 114 => 0x1020, 115 => 0x202, 263 => 0x202, 337 => 0x21, 346 => 0x202, 367 => 0xb040 },
	'macroled' => { 261 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 51 => 0x10 },
	'macromode' => { 33 => 0x1, 161 => 0xb, 258 => 0x300, 279 => 0x1c, 338 => 0x1009 },
	'magentahsl' => { 94 => 0x20917 },
	'magicfilter' => { 258 => 0x52c },
	'magnifiedview' => { 77 => 0x11, 79 => 0x9 },
	'maindialexposurecomp' => { 253 => '0.6' },
	'mainingredient' => { 427 => 'mainIngredient' },
	'make' => { 89 => 0x0, 106 => 0x1, 109 => 0x10f, 139 => 'Make', 271 => 'Make', 283 => 0x10f, 424 => 'make', 431 => 'Make' },
	'makernote' => { 415 => 'MakerNote' },
	'makernoteapple' => { 107 => 'MakN', 109 => 0x927c },
	'makernotecanon' => { 107 => 'MakN', 109 => 0x927c },
	'makernotecasio' => { 107 => 'MakN', 109 => 0x927c },
	'makernotecasio2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotedji' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteflir' => { 107 => 'MakN', 109 => 0x927c },
	'makernotefujifilm' => { 107 => 'MakN', 109 => 0x927c },
	'makernotege' => { 107 => 'MakN', 109 => 0x927c },
	'makernotege2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehasselblad' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehp' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehp2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehp4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehp6' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteisl' => { 107 => 'MakN', 109 => 0x927c },
	'makernotejvc' => { 107 => 'MakN', 109 => 0x927c },
	'makernotejvctext' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak10' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak11' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak1a' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak1b' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak5' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak6a' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak6b' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak7' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak8a' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak8b' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak8c' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak9' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodakunknown' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekyocera' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica2' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica3' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica4' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica5' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica6' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica7' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica8' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica9' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteminolta' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteminolta2' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteminolta3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotemotorola' => { 107 => 'MakN', 109 => 0x927c },
	'makernotenikon' => { 107 => 'MakN', 109 => 0x927c },
	'makernotenikon2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotenikon3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotenintendo' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteoffset' => { 346 => 0xff },
	'makernoteolympus' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteolympus2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepanasonic' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepanasonic2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax5' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax6' => { 107 => 'MakN', 109 => 0x927c },
	'makernotephaseone' => { 107 => 'MakN', 109 => 0x927c },
	'makernotereconyx' => { 107 => 'MakN', 109 => 0x927c },
	'makernotericoh' => { 107 => 'MakN', 109 => 0x927c },
	'makernotericoh2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotericohtext' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesafety' => { 109 => 0xc635 },
	'makernotesamsung1a' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesamsung1b' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesamsung2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesanyo' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesanyoc4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesanyopatch' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesigma' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony5' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesonyericsson' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesonysrf' => { 107 => 'MakN', 109 => 0x927c },
	'makernotetype' => { 338 => 0x1 },
	'makernoteunknown' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteunknownbinary' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteunknowntext' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteversion' => { 166 => 0x0, 198 => 0x1, 263 => 0x0, 279 => 0x8000, 342 => 0x0, 344 => 0x1, 347 => [0x1d,0x1f], 358 => 0x2000 },
	'managedfrom' => { 436 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 436 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 436 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 436 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 436 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 436 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 436 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 436 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 436 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 436 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 436 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 436 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 436 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 436 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 436 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 436 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 436 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 436 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 436 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 436 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 436 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 436 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 436 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 436 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 436 => 'Manager' },
	'managervariant' => { 436 => 'ManagerVariant' },
	'manageto' => { 436 => 'ManageTo' },
	'manageui' => { 436 => 'ManageUI' },
	'manifest' => { 436 => 'Manifest' },
	'manifestlinkform' => { 436 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 436 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 436 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 436 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 436 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 436 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 436 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 436 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 436 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 436 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 436 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 436 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 436 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 436 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 436 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 436 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 436 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 436 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 436 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 436 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 436 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 436 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 436 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 436 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 436 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 436 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 436 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 436 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 258 => 0x900, 279 => 0x86 },
	'manometerreading' => { 258 => 0x901 },
	'manualafpointselectpattern' => { 75 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 261 => 0x1209 },
	'manualflashoutput' => { 33 => 0x29, 245 => '8.2', 247 => '22.2', 248 => '23.1', 249 => '23.2', 251 => '16.2', 252 => '23.2', 253 => '8.2', 254 => '23.2', 256 => '24.2', 338 => 0x100c },
	'manualflashstrength' => { 258 => 0x406 },
	'manualfocusdistance' => { 198 => 0x85, 263 => 0x100c, 346 => 0x223 },
	'manualtv' => { 74 => 0x5, 75 => 0x705 },
	'manufacturedate' => { 171 => 0x6705, 293 => 0x1 },
	'manufacturedate1' => { 340 => 0x4 },
	'manufacturedate2' => { 340 => 0x5 },
	'manufacturer' => { 424 => 'manufacturer' },
	'marked' => { 422 => 'Marked', 439 => 'Marked' },
	'markers' => { 435 => 'markers' },
	'markerscomment' => { 435 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 435 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 435 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 435 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 435 => [\'markers','markersCuePointType'] },
	'markersduration' => { 435 => [\'markers','markersDuration'] },
	'markerslocation' => { 435 => [\'markers','markersLocation'] },
	'markersname' => { 435 => [\'markers','markersName'] },
	'markersprobability' => { 435 => [\'markers','markersProbability'] },
	'markersspeaker' => { 435 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 435 => [\'markers','markersStartTime'] },
	'markerstarget' => { 435 => [\'markers','markersTarget'] },
	'markerstype' => { 435 => [\'markers','markersType'] },
	'maskedareas' => { 109 => 0xc68e },
	'masterdocumentid' => { 117 => 0xb9 },
	'mastergain' => { 205 => 0x50 },
	'matrixmetering' => { 244 => '50.1', 246 => '48.1', 255 => '48.1' },
	'maxaperture' => { 33 => 0x1a, 129 => 0x6103, 146 => 'MaxAperture', 161 => 0x17, 167 => 0x49c5, 259 => 0x20a, 304 => '14.1', 383 => 0x0 },
	'maxapertureatmaxfocal' => { 114 => 0x1407, 146 => 'MaxApertureAtMaxFocal', 193 => 0xb, 194 => 0x10, 195 => 0x11, 259 => 0x206 },
	'maxapertureatminfocal' => { 114 => 0x1406, 193 => 0xa, 194 => 0xf, 195 => 0x10, 259 => 0x205 },
	'maxaperturevalue' => { 109 => 0x9205, 322 => 0x414, 415 => 'MaxApertureValue' },
	'maxavailheight' => { 421 => 'MaxAvailHeight' },
	'maxavailwidth' => { 421 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 243 => 0xb, 244 => 0xc, 246 => '12.1', 251 => 0xc, 252 => 0xb, 255 => '12.1' },
	'maxfaces' => { 262 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x188, 27 => 0x116, 28 => 0x18d, 33 => 0x17, 114 => 0x1405, 146 => 'MaxFocalLength', 193 => 0x9, 194 => 0xe, 195 => 0xf, 259 => 0x208, 378 => 0x127c, 379 => 0x1138, 380 => 0x330, 381 => 0x330 },
	'maximumdensityrange' => { 119 => 0x8c },
	'maxpagesize' => { 440 => 'MaxPageSize' },
	'maxpagesizeh' => { 440 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 440 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 440 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 109 => 0x119 },
	'maxstorage' => { 430 => 'maxstorage' },
	'mb-d10batteries' => { 243 => '12.6' },
	'mb-d10batterytype' => { 251 => '13.3' },
	'mb-d11batterytype' => { 252 => '2.3' },
	'mb-d12batterytype' => { 255 => '3.2' },
	'mb-d80batteries' => { 253 => '6.5' },
	'mb-d80batterytype' => { 256 => '3.2' },
	'mcuversion' => { 193 => 0xc, 194 => 0x11, 195 => 0x12 },
	'md5digest' => { 147 => 'zmd5' },
	'meal' => { 427 => 'meal' },
	'measuredev' => { 27 => 0x9, 69 => 0x3, 88 => 0x1814, 139 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 27 => 0x8, 69 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 167 => 0x690, 275 => 0x312, 281 => 0x3407 },
	'measuredrggb' => { 58 => 0x1 },
	'measuredrggbdata' => { 39 => 0x287 },
	'measurementaccuracy' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 108 => 'MeasurementOrFact' },
	'measurementremarks' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 268 => 'MediaConstraints' },
	'mediacreatedate' => { 330 => 0x1 },
	'mediamodifydate' => { 330 => 0x2 },
	'mediasummarycode' => { 268 => 'MediaSummaryCode' },
	'memoaudioquality' => { 75 => 0x812 },
	'memorycardconfiguration' => { 361 => 0x16 },
	'memorycardnumber' => { 185 => 0x2 },
	'menubuttondisplayposition' => { 73 => 0xb, 76 => 0xa, 77 => 0xb, 80 => 0xb },
	'menubuttonreturn' => { 81 => 0xb },
	'menumonitorofftime' => { 243 => '26.1', 244 => '22.1', 246 => '22.1', 250 => '21.1', 251 => '8.2', 252 => '21.1', 255 => '22.1', 256 => '22.1' },
	'metadatadate' => { 433 => 'MetadataDate' },
	'metadatamoddate' => { 435 => 'metadataModDate' },
	'metaversion' => { 373 => 0x34 },
	'meterinfo1row1' => { 368 => 0x0 },
	'meterinfo1row2' => { 368 => 0x6c },
	'meterinfo1row3' => { 368 => 0xd8 },
	'meterinfo1row4' => { 368 => 0x144 },
	'meterinfo1row5' => { 368 => 0x1b0 },
	'meterinfo1row6' => { 368 => 0x21c },
	'meterinfo1row7' => { 368 => 0x288 },
	'meterinfo2row1' => { 368 => 0x2f4 },
	'meterinfo2row2' => { 368 => 0x378 },
	'meterinfo2row3' => { 368 => 0x3fc },
	'meterinfo2row4' => { 368 => 0x480 },
	'meterinfo2row5' => { 368 => 0x504 },
	'meterinfo2row6' => { 368 => 0x588 },
	'meterinfo2row7' => { 368 => 0x60c },
	'meterinfo2row8' => { 368 => 0x690 },
	'meterinfo2row9' => { 368 => 0x714 },
	'metering' => { 245 => '6.1' },
	'meteringmode' => { 33 => 0x11, 109 => 0x9207, 125 => 0x1c, 161 => 0x7, 162 => 0x25, 164 => 0x12, 258 => 0x202, 313 => 0x17, 347 => 0x9, 355 => 0x15, 356 => 0x13, 357 => 0x7, 371 => 0x3, 374 => 0x1174, 375 => 0x1178, 376 => 0x1154, 377 => 0x11d0, 378 => 0x11ac, 379 => 0x1064, 380 => 0x25c, 381 => 0x25c, 415 => 'MeteringMode' },
	'meteringmode2' => { 294 => '2.1' },
	'meteringmode3' => { 294 => '16.1' },
	'meteringoffscaleindicator' => { 164 => 0x53 },
	'meteringtime' => { 243 => '22.2', 245 => '3.2', 247 => '17.1', 248 => '18.1', 251 => '7.3', 252 => '18.1', 253 => '3.2', 256 => '19.1' },
	'mieversion' => { 147 => '0Vers' },
	'minaperture' => { 33 => 0x1b, 146 => 'MinAperture', 304 => '0.2', 383 => 0x1 },
	'minaperturevalue' => { 322 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x186, 27 => 0x114, 28 => 0x18b, 33 => 0x18, 114 => 0x1404, 146 => 'MinFocalLength', 193 => 0x8, 194 => 0xd, 195 => 0xe, 259 => 0x207, 378 => 0x127a, 379 => 0x1136, 380 => 0x32e, 381 => 0x32e },
	'minfocusdistance' => { 304 => 0x3 },
	'minoltadate' => { 161 => 0x15 },
	'minoltaimagesize' => { 161 => 0x4, 162 => 0xc, 163 => 0x2, 166 => 0x103 },
	'minoltamodelid' => { 161 => 0x25 },
	'minoltaquality' => { 161 => 0x5, 162 => 0xd, 163 => 0x3, 166 => [0x102,0x103] },
	'minoltatime' => { 161 => 0x16 },
	'minormodelagedisclosure' => { 268 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 109 => 0x118 },
	'mirrorlockup' => { 73 => 0xc, 74 => 0xc, 75 => 0x60f, 76 => 0xb, 77 => 0xc, 78 => 0x6, 79 => 0x6, 80 => 0xc, 81 => 0x3 },
	'mobilecountrycode' => { 409 => 'mcc' },
	'mobilenetworkcode' => { 409 => 'mnc' },
	'moddate' => { 271 => 'modify-date', 422 => 'ModDate' },
	'modedialposition' => { 361 => 0x14 },
	'model' => { 89 => 0x6, 109 => 0x110, 139 => 'Model', 271 => 'Model', 283 => 0x110, 347 => 0x84, 424 => 'model', 431 => 'Model' },
	'modelage' => { 421 => 'ModelAge' },
	'modelid' => { 257 => 0x0 },
	'modelingflash' => { 243 => '21.4', 244 => '31.1', 246 => '31.1', 251 => '26.4', 252 => '30.2', 253 => '7.4', 254 => '30.1', 255 => '31.1', 256 => '31.3' },
	'modelreleaseid' => { 268 => 'ModelReleaseID' },
	'modelreleasestatus' => { 268 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 384 => 0x52, 385 => 0x46, 386 => 0x53 },
	'modelyear' => { 424 => 'modelYear' },
	'modificationdate' => { 425 => 'modificationDate' },
	'modifiedcolortemp' => { 59 => 0x9 },
	'modifieddigitalgain' => { 59 => 0xb },
	'modifiedparamflag' => { 52 => 0x1 },
	'modifiedpicturestyle' => { 59 => 0xa },
	'modifiedsaturation' => { 258 => 0x504 },
	'modifiedsensorbluelevel' => { 59 => 0x5 },
	'modifiedsensorredlevel' => { 59 => 0x4 },
	'modifiedsharpness' => { 59 => 0x2 },
	'modifiedsharpnessfreq' => { 59 => 0x3 },
	'modifiedtonecurve' => { 59 => 0x1 },
	'modifiedwhitebalance' => { 59 => 0x8 },
	'modifiedwhitebalanceblue' => { 59 => 0x7 },
	'modifiedwhitebalancered' => { 59 => 0x6 },
	'modifydate' => { 109 => 0x132, 140 => 'ModifyDate', 267 => 'ModDate', 269 => 'tIME', 329 => 'ModDate', 331 => 0x2, 433 => 'ModifyDate' },
	'moirefilter' => { 109 => 0xfe58, 411 => 'MoireFilter' },
	'monitordisplayoff' => { 164 => 0x4c },
	'monitorofftime' => { 243 => '18.2', 245 => '3.1', 253 => '3.1' },
	'monochromecolor' => { 258 => 0x53b },
	'monochromecontrast' => { 100 => 0x3c },
	'monochromefiltereffect' => { 94 => 0x20307, 100 => 0x3a, 313 => 0x73 },
	'monochromelinear' => { 100 => 0x3d },
	'monochromeoutputhighlightpoint' => { 100 => 0x41 },
	'monochromeoutputshadowpoint' => { 100 => 0x42 },
	'monochromeprofilesettings' => { 258 => 0x537 },
	'monochromerawhighlight' => { 100 => 0x7a },
	'monochromerawhighlightpoint' => { 100 => 0x3f },
	'monochromerawshadow' => { 100 => 0x83 },
	'monochromerawshadowpoint' => { 100 => 0x40 },
	'monochromesharpness' => { 100 => 0x3e },
	'monochrometoning' => { 313 => 0x74 },
	'monochrometoningeffect' => { 94 => 0x20306, 100 => 0x3b },
	'monochromeunsharpmaskfineness' => { 100 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 100 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 100 => 0xb4 },
	'monochromevignetting' => { 258 => 0x53a },
	'monthdaycreated' => { 125 => 0x12, 134 => 0xe },
	'moonphase' => { 334 => 0x12 },
	'morepermissions' => { 408 => 'morePermissions' },
	'motionsensitivity' => { 334 => 0x29 },
	'movieaelockbuttonassignment' => { 255 => '40.1' },
	'moviefunctionbutton' => { 244 => '41.1', 255 => '41.1' },
	'moviefunctionbuttonplusdials' => { 244 => '52.1' },
	'moviepreviewbutton' => { 244 => '41.2', 246 => ['41.1','41.2'], 255 => '41.2' },
	'moviepreviewbuttonplusdials' => { 244 => '52.2' },
	'movieshutterbutton' => { 244 => '38.3', 246 => '38.3', 255 => '38.3' },
	'moviesubselectorassignment' => { 244 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 244 => '53.1' },
	'multiburstimageheight' => { 367 => 0x1002 },
	'multiburstimagewidth' => { 367 => 0x1001 },
	'multiburstmode' => { 367 => 0x1000 },
	'multicontrollerwhilemetering' => { 75 => 0x517 },
	'multiexposure' => { 61 => 0x1 },
	'multiexposureautogain' => { 199 => 0x3 },
	'multiexposurecontrol' => { 61 => 0x2 },
	'multiexposuremode' => { 199 => 0x1 },
	'multiexposureshots' => { 61 => 0x3, 199 => 0x2 },
	'multiframenoisereduction' => { 357 => 0x35, 367 => 0x200b, 371 => 0x15 },
	'multifunctionlock' => { 75 => 0x70f },
	'multipleexposuremode' => { 262 => 0x101c },
	'multipleexposureset' => { 294 => '10.1' },
	'multisample' => { 205 => 0x40 },
	'multiselector' => { 243 => '9.4', 244 => '10.3', 246 => '10.3', 251 => '27.4', 255 => '10.3' },
	'multiselectorliveview' => { 243 => '4.3', 246 => '37.1', 255 => '37.1' },
	'multiselectorliveviewmode' => { 215 => 0x18c2 },
	'multiselectorplaybackmode' => { 243 => ['13.5','9.2'], 244 => '10.2', 246 => '10.2', 251 => '27.2', 255 => '10.2' },
	'multiselectorshootmode' => { 243 => '9.1', 244 => '10.1', 246 => '10.1', 251 => '27.1', 255 => '10.1' },
	'mycolormode' => { 62 => 0x2 },
	'nationalcatalognumber' => { 425 => 'nationalCatalogNumber' },
	'nativedigest' => { 415 => 'NativeDigest', 431 => 'NativeDigest' },
	'ncdfileinfo' => { 123 => 0x414 },
	'ndfilter' => { 69 => 0x1c, 258 => 0x204, 338 => 0x1019 },
	'nefbitdepth' => { 198 => 0xe22 },
	'nefcompression' => { 198 => 0x93 },
	'neflinearizationtable' => { 198 => 0x96 },
	'negativecachelargepreviewsize' => { 411 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 411 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 411 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 313 => 0x88 },
	'neutraloutputhighlightpoint' => { 100 => 0x2f },
	'neutraloutputshadowpoint' => { 100 => 0x30 },
	'neutralrawcolortone' => { 100 => 0x28 },
	'neutralrawcontrast' => { 100 => 0x2a },
	'neutralrawhighlight' => { 100 => 0x78 },
	'neutralrawhighlightpoint' => { 100 => 0x2d },
	'neutralrawlinear' => { 100 => 0x2b },
	'neutralrawsaturation' => { 100 => 0x29 },
	'neutralrawshadow' => { 100 => 0x81 },
	'neutralrawshadowpoint' => { 100 => 0x2e },
	'neutralrawsharpness' => { 100 => 0x2c },
	'neutralunsharpmaskfineness' => { 100 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 100 => 0xa8 },
	'neutraunsharpmaskstrength' => { 100 => 0xa4 },
	'newrawimagedigest' => { 109 => 0xc7a7 },
	'newsphotoversion' => { 119 => 0x0 },
	'nickname' => { 433 => 'Nickname' },
	'nikoncapturedata' => { 198 => 0xe01 },
	'nikoncaptureeditversions' => { 198 => 0xe13 },
	'nikoncaptureoutput' => { 198 => 0xe1e },
	'nikoncaptureversion' => { 198 => 0xe09 },
	'nikoniccprofile' => { 198 => 0xe1d },
	'nikonimagesize' => { 212 => '723.1', 213 => '732.1', 222 => 0x2c4 },
	'noisefilter' => { 258 => 0x527 },
	'noiseprofile' => { 109 => 0xc761 },
	'noisereduction' => { 114 => 0x100b, 162 => 0xb0, 163 => 0x60, 164 => 0x3f, 198 => 0x95, 236 => 0x753dcbc0, 237 => 0x17, 258 => 0x50a, 263 => 0x103a, 279 => 0x2d, 313 => 0x49, 338 => 0x100f, 340 => 0x2a },
	'noisereduction2' => { 262 => 0x1010 },
	'noisereductionapplied' => { 109 => 0xc6f7 },
	'noisereductionintensity' => { 237 => 0x9 },
	'noisereductionmethod' => { 237 => 0x11 },
	'noisereductionmode' => { 396 => 0x801e },
	'noisereductionsharpness' => { 237 => 0xd },
	'noisereductionvalue' => { 396 => 0x8027 },
	'nomemorycard' => { 243 => '22.1', 244 => '4.2', 245 => '0.3', 247 => '2.4', 248 => '3.2', 249 => '3.2', 251 => '33.7', 252 => '3.2', 253 => '0.3', 255 => '4.2', 256 => '4.5' },
	'nominalmaxaperture' => { 304 => 0xa },
	'nominalminaperture' => { 304 => '10.1' },
	'normalwhitelevel' => { 40 => [0x2b8,0x2cf,0x2d3], 42 => 0x1e3, 43 => [0x1fc,0x2dc], 44 => [0x230,0x30e] },
	'notes' => { 397 => 'Notes', 405 => 'notes' },
	'npages' => { 440 => 'NPages' },
	'nrwdata' => { 198 => 0x14 },
	'nullrecord' => { 88 => 0x0 },
	'numafpoints' => { 290 => 0x2 },
	'number' => { 425 => 'number' },
	'numberofbeats' => { 435 => 'numberOfBeats' },
	'numberoffocuspoints' => { 246 => '1.2', 249 => '0.2', 250 => '0.3', 252 => '0.3' },
	'numfacepositions' => { 273 => 0x0 },
	'numindexentries' => { 119 => 0x54 },
	'numwbentries' => { 284 => 0x0, 285 => 0x0 },
	'object' => { 425 => 'object' },
	'objectattributereference' => { 117 => 0x4 },
	'objectcycle' => { 117 => 0x4b, 405 => 'ObjectCycle' },
	'objectdescription' => { 424 => 'objectDescription' },
	'objectdistance' => { 103 => 0x6, 104 => 0x2022 },
	'objectname' => { 117 => 0x5 },
	'objectpreviewdata' => { 117 => 0xca },
	'objectpreviewfileformat' => { 117 => 0xc8 },
	'objectpreviewfileversion' => { 117 => 0xc9 },
	'objectsubtype' => { 424 => 'objectSubtype' },
	'objecttype' => { 424 => 'objectType' },
	'objecttypereference' => { 117 => 0x3 },
	'occurrence' => { 108 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 108 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 108 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 108 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 108 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 108 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 108 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 108 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 108 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 108 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 108 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 108 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 108 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 108 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 108 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 108 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 108 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 108 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 108 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 108 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 108 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 108 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 108 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 108 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 415 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 415 => [\'OECF','OECFNames'] },
	'oecfrows' => { 415 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 415 => [\'OECF','OECFValues'] },
	'offsaledate' => { 425 => 'offSaleDate' },
	'offsaledatea-platform' => { 425 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 425 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 109 => 0xea1d },
	'offsettime' => { 109 => 0x9010 },
	'offsettimedigitized' => { 109 => 0x9012 },
	'offsettimeoriginal' => { 109 => 0x9011 },
	'okbutton' => { 252 => '15.1', 256 => '16.1' },
	'oldsubfiletype' => { 109 => 0xff },
	'olympusimageheight' => { 263 => 0x102f },
	'olympusimagewidth' => { 263 => 0x102e },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 263 => 0x302 },
	'onsaledate' => { 425 => 'onSaleDate' },
	'onsaledatea-platform' => { 425 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 425 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 425 => 'onSaleDay' },
	'onsaledaya-platform' => { 425 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 425 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 109 => 0xc740 },
	'opcodelist2' => { 109 => 0xc741 },
	'opcodelist3' => { 109 => 0xc74e },
	'opticalzoom' => { 127 => 0xfa3d, 129 => [0x6006,0xf006], 130 => 0x1000, 131 => 0xf, 134 => 0x1e, 146 => 'OpticalZoom' },
	'opticalzoomcode' => { 69 => 0xa },
	'opticalzoommode' => { 279 => 0x34 },
	'opticalzoomon' => { 346 => 0x219 },
	'optionenddate' => { 428 => 'optionEndDate' },
	'opto-electricconvfactor' => { 415 => 'OECF' },
	'orangehsl' => { 94 => 0x20911 },
	'ordernumber' => { 114 => 0x8002 },
	'organisationinimagecode' => { 421 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 421 => 'OrganisationInImageName' },
	'organization' => { 425 => 'organization' },
	'orientation' => { 109 => 0x112, 283 => 0x112, 424 => 'orientation', 431 => 'Orientation' },
	'orientation2' => { 371 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 75 => 0x516 },
	'originalbestqualitysize' => { 109 => 0xc792 },
	'originaldecisiondata' => { 105 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 57 => 0x83 },
	'originaldefaultcropsize' => { 109 => 0xc793 },
	'originaldefaultfinalsize' => { 109 => 0xc791 },
	'originaldirectory' => { 277 => 0x408 },
	'originaldocumentid' => { 436 => 'OriginalDocumentID' },
	'originalfilename' => { 88 => 0x816, 123 => 0x3e9, 135 => 0x20, 277 => 0x407, 401 => 'OriginalFilename' },
	'originalimageheight' => { 71 => 0xc, 113 => 0x1 },
	'originalimagewidth' => { 71 => 0xb, 113 => 0x0 },
	'originalrawfiledata' => { 109 => 0xc68c },
	'originalrawfiledigest' => { 109 => 0xc71d },
	'originalrawfilename' => { 109 => 0xc68b },
	'originaltransmissionreference' => { 117 => 0x67 },
	'originatingprogram' => { 117 => 0x41, 405 => 'OriginatingProgram' },
	'originplatform' => { 425 => 'originPlatform' },
	'os' => { 413 => 'os' },
	'otherconditions' => { 268 => 'OtherConditions' },
	'otherconstraints' => { 268 => 'OtherConstraints' },
	'otherimage' => { 105 => 'OtherImage' },
	'otherimageinfo' => { 268 => 'OtherImageInfo' },
	'otherimagelength' => { 109 => 0x202 },
	'otherimagestart' => { 109 => 0x201 },
	'otherlicensedocuments' => { 268 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 268 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 268 => 'OtherLicenseRequirements' },
	'outcue' => { 435 => 'outCue' },
	'outcuescale' => { 435 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 435 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 176 => 0x3 },
	'outputimagewidth' => { 176 => 0x2 },
	'outputprofile' => { 123 => 0x138b },
	'outputresolution' => { 176 => 0x4 },
	'owner' => { 439 => 'Owner' },
	'ownerid' => { 117 => 0xbc },
	'ownername' => { 14 => 0x10f, 57 => 0x9, 88 => 0x810, 109 => [0xa430,0xfde8], 139 => 'OwnerName', 407 => 'OwnerName', 416 => 'CameraOwnerName' },
	'padding' => { 109 => 0xea1c },
	'pagecount' => { 425 => 'pageCount' },
	'pageimage' => { 433 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 433 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 433 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 433 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 433 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 433 => 'PageInfo' },
	'pagename' => { 109 => 0x11d },
	'pagenumber' => { 109 => 0x129 },
	'pageprogressiondirection' => { 425 => 'pageProgressionDirection' },
	'pagerange' => { 425 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 411 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 411 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 279 => 0x26 },
	'panasonicimageheight' => { 279 => 0x4c },
	'panasonicimagewidth' => { 279 => 0x4b },
	'panasonicrawversion' => { 283 => 0x1 },
	'panasonictitle' => { 109 => 0xc6d2 },
	'panasonictitle2' => { 109 => 0xc6d3 },
	'panoramacropbottom' => { 372 => 0x7 },
	'panoramacropleft' => { 372 => 0x4 },
	'panoramacropright' => { 372 => 0x6 },
	'panoramacroptop' => { 372 => 0x5 },
	'panoramadirection' => { 65 => 0x5, 372 => 0x3 },
	'panoramaframeheight' => { 372 => 0x9 },
	'panoramaframenumber' => { 65 => 0x2 },
	'panoramaframewidth' => { 372 => 0x8 },
	'panoramafullheight' => { 372 => 0x2 },
	'panoramafullwidth' => { 372 => 0x1 },
	'panoramamode' => { 125 => 0x3c, 258 => 0x601 },
	'panoramasize3d' => { 357 => 0x38 },
	'panoramasourceheight' => { 372 => 0xb },
	'panoramasourcewidth' => { 372 => 0xa },
	'panoramicstitchcameramotion' => { 157 => 'PanoramicStitchCameraMotion', 158 => 0x1 },
	'panoramicstitchmaptype' => { 157 => 'PanoramicStitchMapType', 158 => 0x2 },
	'panoramicstitchphi0' => { 157 => 'PanoramicStitchPhi0', 158 => 0x5 },
	'panoramicstitchphi1' => { 157 => 'PanoramicStitchPhi1', 158 => 0x6 },
	'panoramicstitchtheta0' => { 157 => 'PanoramicStitchTheta0', 158 => 0x3 },
	'panoramicstitchtheta1' => { 157 => 'PanoramicStitchTheta1', 158 => 0x4 },
	'panoramicstitchversion' => { 158 => 0x0 },
	'pantry' => { 436 => 'Pantry' },
	'parallax' => { 114 => 0xb211, 257 => 0x28 },
	'parametricdarks' => { 411 => 'ParametricDarks' },
	'parametrichighlights' => { 411 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 411 => 'ParametricHighlightSplit' },
	'parametriclights' => { 411 => 'ParametricLights' },
	'parametricmidtonesplit' => { 411 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 411 => 'ParametricShadows' },
	'parametricshadowsplit' => { 411 => 'ParametricShadowSplit' },
	'parentmeid' => { 401 => 'ParentMEID' },
	'parentreference1' => { 419 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 419 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 435 => 'partOfCompilation' },
	'patientbirthdate' => { 398 => 'PatientDOB' },
	'patientid' => { 398 => 'PatientID' },
	'patientname' => { 398 => 'PatientName' },
	'patientsex' => { 398 => 'PatientSex' },
	'pdfversion' => { 422 => 'PDFVersion' },
	'pentaximagesize' => { 313 => 0x9 },
	'pentaxmodelid' => { 293 => 0x0, 313 => 0x5 },
	'pentaxmodeltype' => { 313 => 0x1 },
	'pentaxversion' => { 313 => 0x0 },
	'people' => { 399 => 'People', 403 => 'People' },
	'perchannelblacklevel' => { 39 => 0xc4, 40 => [0x2b4,0x2cb,0x2cf], 41 => 0x108, 42 => 0x1df, 43 => [0x1f8,0x2d8], 44 => [0x22c,0x30a] },
	'peripheralillumcentralradius' => { 396 => 0x8030 },
	'peripheralillumcentralvalue' => { 396 => 0x8031 },
	'peripheralillumination' => { 94 => 0x20702, 100 => 0x68 },
	'peripheralilluminationcorr' => { 56 => 0x1, 303 => 0x2 },
	'peripheralilluminationon' => { 94 => '0x20702.0', 100 => 0x64 },
	'peripheralillumperiphvalue' => { 396 => 0x8032 },
	'peripherallighting' => { 71 => 0x2 },
	'peripherallightingsetting' => { 72 => 0x5 },
	'peripherallightingvalue' => { 71 => 0x6 },
	'permissions' => { 428 => 'permissions' },
	'permits' => { 408 => 'permits' },
	'person' => { 425 => 'person' },
	'personality' => { 401 => 'Personality' },
	'personinimage' => { 421 => 'PersonInImage' },
	'personinimagecharacteristic' => { 421 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 421 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 421 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 421 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 421 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 421 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 421 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 421 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 421 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 411 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 411 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 411 => 'PerspectiveRotate' },
	'perspectivescale' => { 411 => 'PerspectiveScale' },
	'perspectiveupright' => { 411 => 'PerspectiveUpright' },
	'perspectivevertical' => { 411 => 'PerspectiveVertical' },
	'perspectivex' => { 411 => 'PerspectiveX' },
	'perspectivey' => { 411 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 83 => 0x1 },
	'pf10retainprogramshift' => { 83 => 0xb },
	'pf13drivepriority' => { 83 => 0xe },
	'pf14disablefocussearch' => { 83 => 0xf },
	'pf15disableafassistbeam' => { 83 => 0x10 },
	'pf16autofocuspointshoot' => { 83 => 0x11 },
	'pf17disableafpointsel' => { 83 => 0x12 },
	'pf18enableautoafpointsel' => { 83 => 0x13 },
	'pf19continuousshootspeed' => { 83 => 0x14 },
	'pf19shootingspeedhigh' => { 82 => 0xa },
	'pf19shootingspeedlow' => { 82 => 0x9 },
	'pf1disableshootingmodes' => { 83 => 0x2 },
	'pf1value' => { 82 => 0x1 },
	'pf20limitcontinousshots' => { 83 => 0x15 },
	'pf20maxcontinousshots' => { 82 => 0xb },
	'pf21enablequietoperation' => { 83 => 0x16 },
	'pf23felocktime' => { 82 => 0xd },
	'pf23postreleasetime' => { 82 => 0xe },
	'pf23settimerlengths' => { 83 => 0x18 },
	'pf23shutterbuttontime' => { 82 => 0xc },
	'pf24lightlcdduringbulb' => { 83 => 0x19 },
	'pf25aemode' => { 82 => 0xf },
	'pf25afmode' => { 82 => 0x12 },
	'pf25afpointsel' => { 82 => 0x13 },
	'pf25colormatrix' => { 82 => 0x17 },
	'pf25defaultclearsettings' => { 83 => 0x1a },
	'pf25drivemode' => { 82 => 0x11 },
	'pf25imagesize' => { 82 => 0x14 },
	'pf25meteringmode' => { 82 => 0x10 },
	'pf25parameters' => { 82 => 0x16 },
	'pf25wbmode' => { 82 => 0x15 },
	'pf26shortenreleaselag' => { 83 => 0x1b },
	'pf27reversedialrotation' => { 83 => 0x1c },
	'pf27value' => { 82 => 0x18 },
	'pf28noquickdialexpcomp' => { 83 => 0x1d },
	'pf29quickdialswitchoff' => { 83 => 0x1e },
	'pf2disablemeteringmodes' => { 83 => 0x3 },
	'pf2value' => { 82 => 0x2 },
	'pf30enlargementmode' => { 83 => 0x1f },
	'pf31originaldecisiondata' => { 83 => 0x20 },
	'pf3manualexposuremetering' => { 83 => 0x4 },
	'pf3value' => { 82 => 0x3 },
	'pf4exposuretimelimits' => { 83 => 0x5 },
	'pf4exposuretimemax' => { 82 => 0x5 },
	'pf4exposuretimemin' => { 82 => 0x4 },
	'pf5aperturelimits' => { 83 => 0x6 },
	'pf5aperturemax' => { 82 => 0x7 },
	'pf5aperturemin' => { 82 => 0x6 },
	'pf6presetshootingmodes' => { 83 => 0x7 },
	'pf7bracketcontinuousshoot' => { 83 => 0x8 },
	'pf8bracketshots' => { 82 => 0x8 },
	'pf8setbracketshots' => { 83 => 0x9 },
	'pf9changebracketsequence' => { 83 => 0xa },
	'phasedetectaf' => { 173 => 0x6 },
	'phonenumber' => { 140 => 'Phone' },
	'photoeffect' => { 33 => 0x28 },
	'photoeffecthistoryxml' => { 236 => 0xe9651831 },
	'photoeffects' => { 236 => 0xab5eca5e },
	'photoeffectsblue' => { 238 => 0x8 },
	'photoeffectsgreen' => { 238 => 0x6 },
	'photoeffectsred' => { 238 => 0x4 },
	'photoeffectstype' => { 238 => 0x0 },
	'photographicsensitivity' => { 416 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 243 => '17.6', 251 => '33.6' },
	'photometricinterpretation' => { 109 => 0x106, 431 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 216 => 0xe7d },
	'photoshootingmenubankimagearea' => { 216 => '3716.1' },
	'photoshopbgrthumbnail' => { 327 => 0x409 },
	'photoshopquality' => { 326 => 0x0 },
	'photoshopthumbnail' => { 327 => 0x40c },
	'photostyle' => { 279 => 0x89 },
	'picklabel' => { 414 => 'PickLabel' },
	'pictinfo' => { 346 => 0x208 },
	'picturecontrol' => { 236 => 0xe2173c47 },
	'picturecontrolactive' => { 239 => 0x0 },
	'picturecontroladjust' => { 200 => 0x30, 201 => 0x30 },
	'picturecontrolbase' => { 200 => 0x18, 201 => 0x18 },
	'picturecontroldata' => { 198 => [0xbd,0x23] },
	'picturecontrolmode' => { 239 => 0x13 },
	'picturecontrolname' => { 200 => 0x4, 201 => 0x4 },
	'picturecontrolquickadjust' => { 200 => 0x31, 201 => 0x31 },
	'pictureeffect' => { 367 => 0x200e },
	'pictureeffect2' => { 374 => 0x1163, 375 => 0x1167, 376 => 0x1143, 377 => 0x11bf, 378 => 0x119b, 379 => 0x1053, 380 => 0x24b, 381 => 0x24b, 392 => 0x46 },
	'picturefinish' => { 162 => 0x71 },
	'picturemode' => { 114 => 0x1031, 258 => 0x520, 313 => [0xb,0x33], 347 => 0x3d },
	'picturemode2' => { 294 => 0x0 },
	'picturemodebwfilter' => { 258 => 0x525 },
	'picturemodecontrast' => { 258 => 0x523 },
	'picturemodeeffect' => { 258 => 0x52d },
	'picturemodehue' => { 258 => 0x522 },
	'picturemodesaturation' => { 258 => 0x521 },
	'picturemodesharpness' => { 258 => 0x524 },
	'picturemodetone' => { 258 => 0x526 },
	'pictureprofile' => { 374 => [0x115e,0x115f], 375 => [0x1162,0x1163], 376 => [0x113e,0x113f], 377 => [0x11ba,0x11bb], 378 => [0x1196,0x1197], 379 => [0x104e,0x104f], 380 => [0x246,0x247], 381 => [0x246,0x247] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 26 => 0x169, 67 => 0xa, 94 => 0x20301, 100 => 0x2 },
	'picturewizard' => { 344 => 0x21 },
	'picturewizardcolor' => { 343 => 0x1 },
	'picturewizardcontrast' => { 343 => 0x4 },
	'picturewizardmode' => { 343 => 0x0 },
	'picturewizardsaturation' => { 343 => 0x2 },
	'picturewizardsharpness' => { 343 => 0x3 },
	'pipelineversion' => { 157 => 'PipelineVersion' },
	'pitch' => { 106 => 0x6, 244 => '4.1', 255 => '4.1' },
	'pitchangle' => { 215 => 0x350f, 224 => 0x36f8, 258 => 0x904, 279 => 0x91, 312 => 0x2 },
	'pixelshiftresolution' => { 314 => 0x0 },
	'pixelsperunitx' => { 270 => 0x0 },
	'pixelsperunity' => { 270 => 0x4 },
	'pixelunits' => { 270 => 0x8 },
	'planarconfiguration' => { 109 => 0x11c, 431 => 'PlanarConfiguration' },
	'platenames' => { 440 => 'PlateNames' },
	'platform' => { 425 => 'platform' },
	'playbackmenustime' => { 247 => '20.1', 248 => '21.1', 249 => '21.1' },
	'playbackmonitorofftime' => { 243 => '25.2', 244 => '36.1', 246 => '36.1', 250 => '35.1', 251 => '8.1', 252 => '35.1', 255 => '36.1', 256 => '21.1' },
	'playbackzoom' => { 244 => '37.1' },
	'playdisplay' => { 164 => 0x4e },
	'plusversion' => { 268 => 'Version' },
	'pmversion' => { 325 => 'PMVersion' },
	'pngwarning' => { 271 => 'Warning' },
	'poilevel' => { 197 => 0x8 },
	'portraitoutputhighlightpoint' => { 100 => 0x1d },
	'portraitoutputshadowpoint' => { 100 => 0x1e },
	'portraitrawcolortone' => { 100 => 0x16 },
	'portraitrawcontrast' => { 100 => 0x18 },
	'portraitrawhighlight' => { 100 => 0x76 },
	'portraitrawhighlightpoint' => { 100 => 0x1b },
	'portraitrawlinear' => { 100 => 0x19 },
	'portraitrawsaturation' => { 100 => 0x17 },
	'portraitrawshadow' => { 100 => 0x7f },
	'portraitrawshadowpoint' => { 100 => 0x1c },
	'portraitrawsharpness' => { 100 => 0x1a },
	'portraitrefiner' => { 104 => 0x302b },
	'portraitunsharpmaskfineness' => { 100 => 0x9a },
	'portraitunsharpmaskstrength' => { 100 => 0x98 },
	'portraitunsharpmaskthreshold' => { 100 => 0x9c },
	'poseheadingdegrees' => { 400 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 400 => 'PosePitchDegrees' },
	'poserolldegrees' => { 400 => 'PoseRollDegrees' },
	'positiondescriptor' => { 424 => 'positionDescriptor' },
	'postalcode' => { 144 => 'PostalCode' },
	'postcropvignetteamount' => { 411 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 411 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 411 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 411 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 411 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 411 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 365 => 0xb },
	'potentialface2position' => { 365 => 0x15 },
	'potentialface3position' => { 365 => 0x1f },
	'potentialface4position' => { 365 => 0x29 },
	'potentialface5position' => { 365 => 0x33 },
	'potentialface6position' => { 365 => 0x3d },
	'potentialface7position' => { 365 => 0x47 },
	'potentialface8position' => { 365 => 0x51 },
	'powersource' => { 292 => '0.1' },
	'poweruptime' => { 198 => 0xb6 },
	'precaptureframes' => { 263 => 0x300 },
	'predictor' => { 109 => 0x13d },
	'preflashreturnstrength' => { 213 => 0x28a },
	'prefs' => { 117 => 0xdd, 325 => 'Prefs' },
	'preservedfilename' => { 436 => 'PreservedFileName' },
	'presetwhitebalance' => { 164 => 0x24, 396 => 0x8002 },
	'presetwhitebalanceadj' => { 396 => 0x8014 },
	'pressure' => { 109 => 0x9402 },
	'previewapplicationname' => { 109 => 0xc716 },
	'previewapplicationversion' => { 109 => 0xc717 },
	'previewbutton' => { 243 => ['14.1','15.1'], 244 => '15.1', 246 => '15.1', 251 => '29.1', 252 => '14.1', 255 => '15.1' },
	'previewbuttonplusdials' => { 243 => ['14.2','15.2'], 244 => '15.2', 246 => '43.1', 251 => '31.2', 255 => '43.1' },
	'previewcolorspace' => { 109 => 0xc71a },
	'previewcropbottom' => { 324 => 0xef },
	'previewcropleft' => { 324 => 0xec },
	'previewcropright' => { 324 => 0xee },
	'previewcroptop' => { 324 => 0xed },
	'previewdate' => { 332 => 0x0 },
	'previewdatetime' => { 109 => 0xc71b },
	'previewimage' => { 104 => 0x2000, 105 => 'PreviewImage', 110 => 'PreviewImage', 112 => 0x4, 149 => 'data', 166 => 0x81, 263 => 0x280, 278 => 0x300, 367 => 0x2001 },
	'previewimageborders' => { 313 => 0x3e },
	'previewimageheight' => { 66 => 0x4, 127 => 0xfa58 },
	'previewimagelength' => { 66 => 0x2, 104 => 0x3, 109 => [0x117,0x202], 166 => 0x89, 202 => 0x202, 258 => 0x102, 263 => 0x1037, 313 => 0x3, 337 => 0x1e, 342 => 0x3, 347 => [0x1b,0x1d], 358 => 0x202 },
	'previewimagename' => { 149 => '1Name' },
	'previewimagesize' => { 104 => 0x2, 132 => 0x2, 149 => 'ImageSize', 313 => 0x2, 347 => [0x1c,0x1e], 367 => 0xb02c },
	'previewimagestart' => { 66 => 0x5, 104 => 0x4, 109 => [0x111,0x201], 166 => 0x88, 202 => 0x201, 258 => 0x101, 263 => 0x1036, 313 => 0x4, 337 => 0x1c, 342 => 0x2, 347 => [0x1a,0x1c], 358 => 0x201 },
	'previewimagetype' => { 149 => '0Type' },
	'previewimagevalid' => { 258 => 0x100, 263 => 0x1035 },
	'previewimagewidth' => { 66 => 0x3, 127 => 0xfa57 },
	'previewquality' => { 66 => 0x1 },
	'previewsettingsdigest' => { 109 => 0xc719 },
	'previewsettingsname' => { 109 => 0xc718 },
	'primaryafpoint' => { 173 => 0x7 },
	'primarychromaticities' => { 109 => 0x13f, 431 => 'PrimaryChromaticities' },
	'primaryslot' => { 216 => 0xe7f },
	'printim' => { 109 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 164 => 0x1d, 355 => 0x28 },
	'privatertkinfo' => { 402 => 'privateRTKInfo' },
	'processingsoftware' => { 109 => 0xb },
	'processversion' => { 411 => 'ProcessVersion' },
	'producer' => { 267 => 'Producer', 422 => 'Producer' },
	'productcode' => { 425 => 'productCode' },
	'productid' => { 118 => 0x32, 424 => 'productID' },
	'productidtype' => { 424 => 'productIDType' },
	'productinimage' => { 421 => 'ProductInImage' },
	'productinimagedescription' => { 421 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 421 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 421 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 293 => 0x2 },
	'productorserviceconstraints' => { 268 => 'ProductOrServiceConstraints' },
	'profession' => { 425 => 'profession' },
	'profilecalibrationsig' => { 109 => 0xc6f4 },
	'profilecopyright' => { 109 => 0xc6fe },
	'profileembedpolicy' => { 109 => 0xc6fd },
	'profilehuesatmapdata1' => { 109 => 0xc6fa },
	'profilehuesatmapdata2' => { 109 => 0xc6fb },
	'profilehuesatmapdims' => { 109 => 0xc6f9 },
	'profilehuesatmapencoding' => { 109 => 0xc7a3 },
	'profilelooktabledata' => { 109 => 0xc726 },
	'profilelooktabledims' => { 109 => 0xc725 },
	'profilelooktableencoding' => { 109 => 0xc7a4 },
	'profilename' => { 109 => 0xc6f8 },
	'profiletonecurve' => { 109 => 0xc6fc },
	'programiso' => { 279 => 0x3c },
	'programline' => { 294 => '1.1' },
	'programmode' => { 169 => 0x5 },
	'programshift' => { 198 => 0xd },
	'programversion' => { 117 => 0x46 },
	'prohibits' => { 408 => 'prohibits' },
	'projectiontype' => { 400 => 'ProjectionType' },
	'projectname' => { 435 => 'projectName' },
	'projectref' => { 435 => 'projectRef' },
	'projectrefpath' => { 435 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 435 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 268 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 268 => 'PropertyReleaseStatus' },
	'province-state' => { 117 => 0x5f },
	'publicationdate' => { 425 => 'publicationDate' },
	'publicationdatea-platform' => { 425 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 425 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 425 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 425 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 425 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationname' => { 425 => 'publicationName' },
	'publisher' => { 412 => 'publisher' },
	'publishingfrequency' => { 425 => 'publishingFrequency' },
	'pulldown' => { 435 => 'pullDown' },
	'purplehsl' => { 94 => 0x20916 },
	'quality' => { 0 => 0x1, 33 => 0x3, 103 => 0x2, 104 => 0x3002, 114 => 0x1000, 125 => 0x9, 198 => 0x4, 226 => 0x3, 263 => 0x201, 275 => 0x300, 313 => 0x8, 320 => 0x2, 347 => 0x16, 355 => 0x56, 356 => 0x56, 357 => 0xb, 367 => 0x102 },
	'quality2' => { 374 => 0x1170, 375 => 0x1174, 376 => 0x1150, 378 => 0x11a8, 379 => 0x1060, 380 => 0x258, 381 => 0x258, 384 => 0x29, 385 => 0x25, 386 => 0x2a },
	'qualitymode' => { 104 => 0x8 },
	'quantizationmethod' => { 119 => 0x78 },
	'quickadjust' => { 239 => 0x2a },
	'quickcontroldialinmeter' => { 75 => 0x703 },
	'quickfix' => { 236 => 0x416391c6 },
	'quickshot' => { 346 => 0x213 },
	'rangefinder' => { 247 => '4.1', 248 => '5.1', 249 => '5.1' },
	'rasterizedcaption' => { 117 => 0x7d },
	'rating' => { 109 => 0x4746, 114 => 0x1431, 324 => 0xdf, 367 => 0x2002, 405 => 'rating', 413 => 'rating', 425 => 'rating', 433 => 'Rating' },
	'ratingpercent' => { 109 => 0x4749, 159 => 'Rating' },
	'rawandjpgrecording' => { 73 => 0x8, 166 => 0x109, 294 => 0xd },
	'rawbrightnessadj' => { 94 => 0x20001, 99 => 0x38 },
	'rawcoloradj' => { 99 => 0x2e },
	'rawcropbottom' => { 324 => 0xd4 },
	'rawcropleft' => { 324 => 0xd1 },
	'rawcropright' => { 324 => 0xd3 },
	'rawcroptop' => { 324 => 0xd2 },
	'rawcustomsaturation' => { 99 => 0x30 },
	'rawcustomtone' => { 99 => 0x34 },
	'rawdata' => { 344 => 0xa048 },
	'rawdatauniqueid' => { 109 => 0xc65d },
	'rawdepth' => { 168 => 0x10 },
	'rawdevartfilter' => { 265 => 0x121 },
	'rawdevautogradation' => { 265 => 0x119 },
	'rawdevcolorspace' => { 264 => 0x108, 265 => 0x109 },
	'rawdevcontrastvalue' => { 264 => 0x106, 265 => 0x105 },
	'rawdeveditstatus' => { 264 => 0x10b },
	'rawdevelopmentprocess' => { 313 => 0x62 },
	'rawdevengine' => { 264 => 0x109, 265 => 0x10b },
	'rawdevexposurebiasvalue' => { 264 => 0x100, 265 => 0x100 },
	'rawdevgradation' => { 265 => 0x112 },
	'rawdevgraypoint' => { 264 => 0x103, 265 => 0x104 },
	'rawdevmemorycoloremphasis' => { 264 => 0x105, 265 => 0x108 },
	'rawdevnoisereduction' => { 264 => 0x10a, 265 => 0x10a },
	'rawdevpicturemode' => { 265 => 0x10c },
	'rawdevpm_bwfilter' => { 265 => 0x110 },
	'rawdevpmcontrast' => { 265 => 0x10e },
	'rawdevpmnoisefilter' => { 265 => 0x120 },
	'rawdevpmpicturetone' => { 265 => 0x111 },
	'rawdevpmsaturation' => { 265 => 0x10d },
	'rawdevpmsharpness' => { 265 => 0x10f },
	'rawdevsaturation3' => { 265 => 0x113 },
	'rawdevsaturationemphasis' => { 264 => 0x104, 265 => 0x107 },
	'rawdevsettings' => { 264 => 0x10c },
	'rawdevsharpnessvalue' => { 264 => 0x107, 265 => 0x106 },
	'rawdevversion' => { 264 => 0x0, 265 => 0x0 },
	'rawdevwbfineadjustment' => { 264 => 0x102, 265 => 0x103 },
	'rawdevwhitebalance' => { 265 => 0x101 },
	'rawdevwhitebalancevalue' => { 264 => 0x101, 265 => 0x102 },
	'rawfile' => { 109 => 0xfe4c },
	'rawfilename' => { 411 => 'RawFileName' },
	'rawformat' => { 322 => 0x10e },
	'rawimagecenter' => { 198 => 0x99 },
	'rawimagedigest' => { 109 => 0xc71c },
	'rawimagesize' => { 313 => 0x39 },
	'rawinfoversion' => { 266 => 0x0 },
	'rawjpgheight' => { 90 => 0x4 },
	'rawjpgquality' => { 51 => 0x6, 90 => 0x1 },
	'rawjpgsize' => { 51 => 0x7, 90 => 0x2 },
	'rawjpgwidth' => { 90 => 0x3 },
	'rawmeasuredrggb' => { 38 => 0x26a, 40 => 0x280, 42 => 0x194, 43 => [0x1ad,0x26b] },
	'rawrppused' => { 405 => 'rawrppused' },
	'rawtopreviewgain' => { 109 => 0xc7a8 },
	'reardisplay' => { 243 => '12.3', 244 => '6.2' },
	'recipeendingpage' => { 427 => 'recipeEndingPage' },
	'recipepagerange' => { 427 => 'recipePageRange' },
	'recipesource' => { 427 => 'recipeSource' },
	'recipestartingpage' => { 427 => 'recipeStartingPage' },
	'recipetitle' => { 427 => 'recipeTitle' },
	'recognizedface1age' => { 274 => 0x20 },
	'recognizedface1name' => { 274 => 0x4 },
	'recognizedface1position' => { 274 => 0x18 },
	'recognizedface2age' => { 274 => 0x50 },
	'recognizedface2name' => { 274 => 0x34 },
	'recognizedface2position' => { 274 => 0x48 },
	'recognizedface3age' => { 274 => 0x80 },
	'recognizedface3name' => { 274 => 0x64 },
	'recognizedface3position' => { 274 => 0x78 },
	'recognizedfaceflags' => { 279 => 0x63 },
	'recommendedexposureindex' => { 109 => 0x8832, 416 => 'RecommendedExposureIndex' },
	'record' => { 108 => 'Record' },
	'recordbasisofrecord' => { 108 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 108 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 108 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 108 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 108 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 108 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 164 => 0x4d },
	'recorddynamicproperties' => { 108 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 88 => 0x1804 },
	'recordinformationwithheld' => { 108 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 338 => 0x1000 },
	'recordingmode' => { 103 => 0x1, 320 => 0x1 },
	'recordinstitutioncode' => { 108 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 108 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 33 => 0x9, 104 => 0x3000 },
	'recordownerinstitutioncode' => { 108 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 346 => 0x217 },
	'redbalance' => { 181 => 0x270, 263 => 0x1017, 283 => 0x11, 313 => 0x1c },
	'redcurvelimits' => { 99 => 0x18a },
	'redcurvepoints' => { 98 => 0x2d, 99 => 0x160 },
	'redeyecorrection' => { 240 => 0x0 },
	'redeyeinfo' => { 411 => 'RedEyeInfo' },
	'redeyereduction' => { 164 => 0x41, 355 => 0x6a, 357 => 0x28 },
	'redhsl' => { 94 => 0x20910 },
	'redhue' => { 411 => 'RedHue' },
	'redsaturation' => { 411 => 'RedSaturation' },
	'reductionmatrix1' => { 109 => 0xc625 },
	'reductionmatrix2' => { 109 => 0xc626 },
	'reelname' => { 109 => 0xc789 },
	'reference1' => { 419 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 419 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 109 => 0x214, 431 => 'ReferenceBlackWhite' },
	'referencedate' => { 117 => 0x2f },
	'referencenumber' => { 117 => 0x32 },
	'references' => { 140 => 'References' },
	'referenceservice' => { 117 => 0x2d },
	'regionappliedtodimensions' => { 155 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 155 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 155 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 155 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 155 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 155 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 155 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 155 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 155 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 155 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 155 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 155 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 268 => 'RegionConstraints' },
	'regiondescription' => { 155 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 155 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 155 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 155 => 'Regions' },
	'regioninfodateregionsvalid' => { 156 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 156 => 'RegionInfo' },
	'regioninforegions' => { 156 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 155 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 155 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 156 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 156 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 156 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 156 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 156 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 155 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 155 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 155 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 421 => 'RegistryId' },
	'registryitemid' => { 421 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 421 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 138 => 'data' },
	'relatedaudiofilename' => { 138 => '1Name' },
	'relatedaudiofiletype' => { 138 => '0Type' },
	'relatedimagefileformat' => { 109 => 0x1000 },
	'relatedimageheight' => { 109 => 0x1002 },
	'relatedimagewidth' => { 109 => 0x1001 },
	'relatedresourceid' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 109 => 0xa004, 415 => 'RelatedSoundFile' },
	'relatedvideofile' => { 152 => 'data' },
	'relatedvideofilename' => { 152 => '1Name' },
	'relatedvideofiletype' => { 152 => '0Type' },
	'relation' => { 412 => 'relation' },
	'relationshipaccordingto' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 435 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 435 => 'relativeTimestamp' },
	'relativetimestampscale' => { 435 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 435 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 243 => '17.8', 244 => '18.5', 246 => '18.4', 251 => '33.8', 252 => '17.6', 255 => '18.5' },
	'releasedate' => { 117 => 0x1e, 405 => 'ReleaseDate', 435 => 'releaseDate' },
	'releasemode' => { 104 => 0x3001, 215 => 0x184d, 367 => 0xb049 },
	'releasemode2' => { 374 => 0x112c, 375 => [0x112c,0x8], 376 => [0x1108,0x8], 377 => [0x1184,0x8], 378 => [0x1160,0x8], 379 => [0x4,0x1018], 380 => [0x4,0x210], 381 => [0x4,0x210], 383 => [0x67,0x73,0x3f,0x4b], 384 => 0x10, 385 => 0x10, 386 => 0x9, 392 => 0x34 },
	'releasemode3' => { 374 => 0x1128, 375 => 0x1128, 376 => 0x1104, 377 => 0x1180, 378 => 0x115c, 379 => 0x1014, 380 => 0x20c, 381 => 0x20c },
	'releasesetting' => { 88 => 0x1016 },
	'releasetime' => { 117 => 0x23, 405 => 'ReleaseTime' },
	'remoteonduration' => { 245 => '3.4', 247 => '17.2', 248 => '18.2', 249 => '18.2', 250 => '18.2', 252 => '18.2', 253 => '4.3', 256 => '19.2' },
	'renditionclass' => { 436 => 'RenditionClass' },
	'renditionof' => { 436 => 'RenditionOf' },
	'renditionofalternatepaths' => { 436 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 436 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 436 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 436 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 436 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 436 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 436 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 436 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 436 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 436 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 436 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 436 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 436 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 436 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 436 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 436 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 436 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 436 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 436 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 436 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 436 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 436 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 436 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 436 => 'RenditionParams' },
	'repeatingflashcount' => { 186 => 0xd, 187 => 0xe, 188 => 0xe, 251 => '17.2', 252 => '24.2', 253 => '9.2', 254 => '24.2', 256 => '25.2' },
	'repeatingflashcountbuilt-in' => { 223 => 0x4db },
	'repeatingflashcountexternal' => { 223 => 0x4c3 },
	'repeatingflashoutput' => { 251 => '17.1', 252 => '24.1', 253 => '9.1', 254 => '24.1', 256 => '25.1' },
	'repeatingflashoutputexternal' => { 223 => 0x4c0 },
	'repeatingflashrate' => { 186 => 0xc, 187 => 0xd, 188 => 0xd, 251 => '18.1', 252 => '25.1', 253 => '10.1', 254 => '25.1', 256 => '26.1' },
	'repeatingflashratebuilt-in' => { 223 => 0x4da },
	'repeatingflashrateexternal' => { 223 => 0x4c2 },
	'requires' => { 408 => 'requires' },
	'resampleparams' => { 435 => 'resampleParams' },
	'resampleparamsquality' => { 435 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 346 => 0x21e },
	'resolution' => { 145 => 'Resolution' },
	'resolutionmode' => { 347 => 0x4 },
	'resolutionunit' => { 109 => 0x128, 120 => 0x2, 431 => 'ResolutionUnit' },
	'resourceid' => { 108 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 108 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 108 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 75 => 0x612 },
	'restrictions' => { 428 => 'restrictions' },
	'retouchareafeather' => { 411 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 411 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 411 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 411 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 411 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 411 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 411 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 411 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 411 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 411 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 411 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 411 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 411 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 411 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 411 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 411 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 411 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 411 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 411 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 411 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 411 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 411 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 411 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 411 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 411 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 411 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 411 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 411 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 411 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 411 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 411 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 411 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 411 => 'RetouchAreas' },
	'retouchareaseed' => { 411 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 411 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 411 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 411 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 198 => 0x9e },
	'retouchinfo' => { 411 => 'RetouchInfo' },
	'retouchnefprocessing' => { 204 => 0x5 },
	'retractlensonpoweroff' => { 75 => 0x814 },
	'reuse' => { 268 => 'Reuse' },
	'reuseallowed' => { 438 => 'ReuseAllowed' },
	'reuseprohibited' => { 428 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 249 => '5.2' },
	'reverseindicators' => { 243 => '12.1', 244 => '6.1', 246 => '6.1', 247 => '4.3', 248 => '5.2', 249 => '5.4', 251 => '33.5', 252 => '5.1', 255 => '6.1', 256 => '6.2' },
	'reverseshutterspeedaperture' => { 249 => '5.3' },
	'revision' => { 413 => 'revision' },
	'rgbcurvelimits' => { 99 => 0x238 },
	'rgbcurvepoints' => { 98 => 0x7, 99 => 0x20e },
	'richtextcomment' => { 418 => 'RichTextComment' },
	'ricohdate' => { 337 => 0x6 },
	'ricohimageheight' => { 337 => 0x2 },
	'ricohimagewidth' => { 337 => 0x0 },
	'rightascension' => { 148 => 'RightAscension' },
	'rights' => { 412 => 'rights' },
	'rightsagent' => { 428 => 'rightsAgent' },
	'rightsowner' => { 428 => 'rightsOwner' },
	'roll' => { 106 => 0x8 },
	'rollangle' => { 215 => 0x350b, 224 => 0x36f4, 258 => 0x903, 279 => 0x90, 312 => 0x1 },
	'romoperationmode' => { 88 => 0x80d },
	'rotation' => { 29 => 0x17, 30 => 0x18, 87 => 0x3, 94 => 0x10002, 99 => 0x26e, 113 => 0x4, 148 => 'Rotation', 162 => [0x65,0x50], 163 => 0x46, 164 => 0x5a, 167 => 0x10, 215 => 0x3693, 216 => 0xca, 222 => '590.1', 224 => 0x38be, 236 => 0x76a43207, 279 => 0x30, 294 => '17.2', 324 => 0xd8, 355 => 0x3f, 356 => 0x3f, 366 => 0x10 },
	'routedto' => { 417 => 'RoutedTo' },
	'routing' => { 329 => 'Routing' },
	'routingnotes' => { 417 => 'RoutingNotes' },
	'rowsperstrip' => { 109 => 0x116 },
	'rpp' => { 405 => 'rpp' },
	'safetyshift' => { 75 => 0x108 },
	'safetyshiftinavortv' => { 73 => 0x10, 74 => 0x10, 76 => 0xf, 77 => 0x10, 80 => 0x10 },
	'sameexposurefornewaperture' => { 75 => 0x112 },
	'samplebits' => { 138 => 'SampleBits' },
	'samplepagerange' => { 425 => 'samplePageRange' },
	'samplerate' => { 138 => 'SampleRate' },
	'samplesperpixel' => { 109 => 0x115, 431 => 'SamplesPerPixel' },
	'samplestructure' => { 119 => 0x5a },
	'samsungmodelid' => { 344 => 0x3 },
	'sanyoquality' => { 346 => 0x201 },
	'sanyothumbnail' => { 346 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 33 => 0xe, 45 => 0x1, 103 => 0xd, 104 => [0x3013,0x1f], 109 => [0xa409,0xfe55], 114 => 0x1003, 139 => 'Saturation', 161 => 0x1f, 162 => 0x32, 163 => 0x28, 164 => 0x1a, 169 => 0x1, 198 => [0x94,0xaa], 200 => 0x35, 201 => 0x3b, 279 => 0x40, 281 => 0x300d, 313 => 0x1f, 320 => 0xd, 334 => 0x27, 337 => 0x28, 338 => 0x1013, 347 => 0x10, 355 => 0x1e, 356 => 0x1b, 367 => 0x2005, 411 => 'Saturation', 415 => 'Saturation' },
	'saturationadj' => { 94 => 0x20901, 99 => 0x116, 235 => 0x1, 239 => 0x2e, 396 => 0x8016 },
	'saturationadjustmentaqua' => { 411 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 411 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 411 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 411 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 411 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 411 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 411 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 411 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 64 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 63 => 0x68, 64 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 63 => 0x38, 64 => 0x38 },
	'saturationmonochrome' => { 63 => 0x80, 64 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 63 => 0x50, 64 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 63 => 0x20, 64 => 0x20 },
	'saturationsetting' => { 266 => 0x1010, 357 => 0x11, 371 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 63 => 0x8, 64 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 63 => 0x98, 64 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 63 => 0xb0, 64 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 63 => 0xc8, 64 => 0xe0 },
	'saveid' => { 436 => 'SaveID' },
	'scaletype' => { 435 => 'scaleType' },
	'scanimageenhancer' => { 205 => 0x60 },
	'scanningdirection' => { 119 => 0x64 },
	'scene' => { 420 => 'Scene', 435 => 'scene' },
	'scenearea' => { 261 => 0x211, 263 => 0x1031 },
	'sceneassist' => { 198 => 0x9c },
	'scenecapturetype' => { 109 => 0xa406, 415 => 'SceneCaptureType' },
	'scenedetect' => { 261 => 0x210, 263 => 0x1030 },
	'scenedetectdata' => { 261 => 0x212, 263 => 0x1033 },
	'scenemode' => { 127 => 0xfa02, 166 => 0x100, 198 => 0x8f, 258 => 0x509, 263 => 0x403, 279 => 0x8001, 287 => 0xf, 367 => 0xb023 },
	'scenemodeused' => { 129 => [0x6002,0xf002] },
	'sceneselect' => { 346 => 0x21f },
	'scenetype' => { 109 => 0xa301, 415 => 'SceneType' },
	'screentips' => { 243 => '12.7', 244 => '5.3', 251 => '13.1', 252 => '4.4', 255 => '5.4', 256 => '5.1' },
	'season' => { 424 => 'season' },
	'secondaryslotfunction' => { 215 => 0x1d0, 224 => 0x1d0 },
	'section' => { 425 => 'section' },
	'securityclassification' => { 109 => 0x9212 },
	'selectableafpoint' => { 75 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 75 => 0x512 },
	'selftimer' => { 33 => 0x2, 279 => 0x2e, 346 => 0x214, 374 => 0x1134, 375 => 0x1134, 376 => 0x1110, 377 => 0x118c, 378 => 0x1168, 379 => 0x1020, 380 => 0x218, 381 => 0x218 },
	'selftimer2' => { 69 => 0x1d },
	'selftimerinterval' => { 252 => '19.2' },
	'selftimermode' => { 109 => 0x882b },
	'selftimershotcount' => { 244 => '20.2', 246 => '20.3', 247 => '18.2', 248 => '19.2', 249 => '19.2', 250 => '19.3', 252 => '19.3', 255 => '20.3', 256 => '20.2' },
	'selftimershotinterval' => { 244 => '20.3', 246 => '20.2', 250 => '19.2', 255 => '20.2' },
	'selftimertime' => { 88 => 0x1806, 164 => 0x1f, 243 => '18.1', 244 => '20.1', 245 => '3.3', 246 => '20.1', 247 => '18.1', 248 => '19.1', 249 => '19.1', 250 => '19.1', 251 => '7.2', 252 => '19.1', 253 => '3.3', 255 => '20.1', 256 => '20.1' },
	'sellingagency' => { 425 => 'sellingAgency' },
	'seminfo' => { 109 => 0x8546 },
	'sensingmethod' => { 109 => 0xa217, 415 => 'SensingMethod' },
	'sensitivityadjust' => { 313 => 0x40 },
	'sensitivitysteps' => { 294 => ['14.3','17.4'], 296 => 0x1 },
	'sensitivitytype' => { 109 => 0x8830, 416 => 'SensitivityType' },
	'sensor' => { 171 => 0x665e },
	'sensorareas' => { 344 => 0xa010 },
	'sensorbitdepth' => { 281 => 0x312d },
	'sensorbluelevel' => { 67 => 0x5 },
	'sensorcalibration' => { 262 => 0x805 },
	'sensorcleaning' => { 81 => 0xd },
	'sensorfullheight' => { 122 => 0xf904 },
	'sensorfullwidth' => { 122 => 0xf903 },
	'sensorheight' => { 122 => 0xf901, 127 => 0xfa21, 168 => 0x8, 281 => 0x312c, 322 => 0x109, 338 => 0x1602 },
	'sensorleftmargin' => { 322 => 0x10a },
	'sensorpixelsize' => { 198 => 0x9a },
	'sensorredlevel' => { 67 => 0x4 },
	'sensorserialnumber' => { 123 => 0x9ce },
	'sensorsize' => { 139 => 'SensorSize', 313 => 0x35 },
	'sensortemperature' => { 261 => 0x1500, 263 => 0x1007, 318 => 0xc, 322 => 0x210, 347 => [0x39,0x55] },
	'sensortemperature2' => { 318 => 0xe, 322 => 0x211 },
	'sensortopmargin' => { 322 => 0x10b },
	'sensorwidth' => { 122 => 0xf900, 127 => 0xfa20, 168 => 0xa, 281 => 0x312b, 322 => 0x108, 338 => 0x1601 },
	'sequence' => { 334 => 0x7 },
	'sequencefilenumber' => { 375 => 0x4, 376 => 0x4, 377 => 0x4, 378 => 0x4, 384 => 0xc, 385 => 0xc, 386 => 0x1a },
	'sequenceimagenumber' => { 375 => 0x0, 376 => 0x0, 377 => 0x0, 378 => 0x0, 384 => 0x8, 385 => 0x8, 386 => 0x12, 392 => 0x24 },
	'sequencelength' => { 384 => 0x22, 385 => 0x1e, 386 => [0x16,0x1e] },
	'sequencename' => { 424 => 'sequenceName' },
	'sequencenumber' => { 69 => 0x9, 104 => 0x301c, 114 => 0x1101, 125 => 0x1d, 223 => 0x51c, 279 => 0x2b, 357 => [0x10c,0x30c], 367 => 0xb04a, 424 => 'sequenceNumber' },
	'sequenceshotinterval' => { 346 => 0x224 },
	'sequencetotalnumber' => { 424 => 'sequenceTotalNumber' },
	'sequentialshot' => { 346 => 0x20e },
	'serialnumber' => { 57 => 0xc, 88 => 0x180b, 109 => [0xa431,0xfde9], 122 => 0xfa04, 124 => 0xfa00, 126 => 0xc354, 127 => 0xfa19, 136 => 0x0, 139 => 'SerialNumber', 198 => [0xa0,0x1d], 259 => 0x101, 263 => [0x404,0x101a], 275 => 0x303, 281 => 0x3103, 313 => 0x229, 322 => 0x102, 323 => 0x407, 334 => 0x15, 338 => 0x5, 347 => 0x2, 407 => 'SerialNumber', 416 => 'BodySerialNumber' },
	'serialnumberformat' => { 57 => 0x15, 88 => 0x183b },
	'seriesdatetime' => { 398 => 'SeriesDateTime' },
	'seriesdescription' => { 398 => 'SeriesDescription' },
	'seriesmodality' => { 398 => 'SeriesModality' },
	'seriesnumber' => { 398 => 'SeriesNumber', 425 => 'seriesNumber' },
	'seriestitle' => { 425 => 'seriesTitle' },
	'serviceidentifier' => { 118 => 0x1e },
	'servingsize' => { 427 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 78 => 0x0, 79 => 0x0 },
	'setbuttonwhenshooting' => { 73 => 0x1, 75 => 0x704, 81 => 0xc },
	'setfunctionwhenshooting' => { 76 => 0x0, 77 => 0x1, 80 => 0x1 },
	'setting' => { 424 => 'setting' },
	'shadingcompensation' => { 258 => 0x50c, 279 => 0x8a },
	'shadingcompensation2' => { 262 => 0x1012 },
	'shadow' => { 347 => 0xe },
	'shadowadj' => { 94 => 0x2030b },
	'shadowcorrection' => { 313 => 0x79 },
	'shadowprotection' => { 235 => 0x0 },
	'shadows' => { 109 => 0xfe52, 404 => 'Shadows', 411 => 'Shadows' },
	'shadows2012' => { 411 => 'Shadows2012' },
	'shadowscale' => { 109 => 0xc633 },
	'shadowtint' => { 411 => 'ShadowTint' },
	'shadowtone' => { 114 => 0x1040 },
	'shakereduction' => { 315 => 0x1, 316 => 0x1 },
	'sharpendetail' => { 411 => 'SharpenDetail' },
	'sharpenedgemasking' => { 411 => 'SharpenEdgeMasking' },
	'sharpening' => { 281 => 0x300b },
	'sharpeningadj' => { 239 => 0x2b },
	'sharpenradius' => { 411 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 33 => 0xf, 67 => 0x2, 103 => 0xb, 104 => [0x3011,0x21], 109 => [0xa40a,0xfe56], 114 => 0x1001, 125 => 0x6b, 134 => 0x37, 139 => 'Sharpness', 161 => 0x21, 162 => 0x30, 163 => 0x26, 164 => 0x18, 169 => 0x3, 198 => 0x6, 200 => 0x32, 201 => 0x33, 263 => 0x100f, 279 => 0x41, 313 => 0x21, 320 => 0xb, 334 => 0x26, 337 => 0x22, 338 => [0x1003,0x1014], 347 => 0x11, 355 => 0x1c, 356 => 0x19, 367 => 0x2006, 392 => 0x52, 411 => 'Sharpness', 415 => 'Sharpness' },
	'sharpnessadj' => { 94 => 0x20310, 99 => 0x25a, 396 => 0x801a },
	'sharpnessadjon' => { 94 => '0x20310.0' },
	'sharpnessauto' => { 64 => 0x94 },
	'sharpnessfactor' => { 263 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 63 => 0x64, 64 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 67 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 63 => 0x34, 64 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 63 => 0x7c, 64 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 63 => 0x4c, 64 => 0x4c },
	'sharpnessovershoot' => { 396 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 63 => 0x1c, 64 => 0x1c },
	'sharpnesssetting' => { 258 => 0x506, 266 => 0x1013, 357 => 0x12, 371 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 63 => 0x4, 64 => 0x4 },
	'sharpnessstrength' => { 94 => 0x20311 },
	'sharpnessthreshold' => { 396 => 0x801d },
	'sharpnessundershoot' => { 396 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 63 => 0x94, 64 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 63 => 0xac, 64 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 63 => 0xc4, 64 => 0xdc },
	'shootid' => { 424 => 'shootID' },
	'shootingdistance' => { 94 => 0x20701 },
	'shootinginfodisplay' => { 243 => '13.2', 244 => '5.1', 251 => '10.2', 252 => '4.1', 255 => '5.1', 256 => '5.3' },
	'shootinginfomonitorofftime' => { 243 => '26.2', 244 => '22.2', 246 => '22.2', 250 => '21.2', 251 => '9.1', 252 => '21.2', 255 => '22.2', 256 => '22.2' },
	'shootingmode' => { 139 => 'ShootingMode', 198 => 0x89, 279 => 0x1f },
	'shootingmodesetting' => { 245 => '5.1' },
	'shortdescription' => { 413 => 'shortdescription' },
	'shortdocumentid' => { 117 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 75 => 0x80d },
	'shotdate' => { 435 => 'shotDate' },
	'shotday' => { 435 => 'shotDay' },
	'shotlocation' => { 435 => 'shotLocation' },
	'shotname' => { 435 => 'shotName' },
	'shotnumber' => { 435 => 'shotNumber' },
	'shotnumbersincepowerup' => { 370 => 0x44e, 384 => 0x1a, 385 => 0x16, 386 => 0xa },
	'shotnumbersincepowerup2' => { 357 => 0x200 },
	'shotsize' => { 435 => 'shotSize' },
	'shutter-aelock' => { 73 => 0x4, 75 => 0x701, 76 => 0x3, 77 => 0x4, 78 => 0x3, 79 => 0x3, 80 => 0x4, 81 => 0x2 },
	'shutteraelbutton' => { 74 => 0x4 },
	'shutterbuttonafonbutton' => { 75 => 0x701 },
	'shuttercount' => { 10 => 0x176, 51 => 0x1, 198 => 0xa7, 206 => [0x6a,0x157,0x24d], 207 => 0x286, 208 => 0x279, 209 => 0x284, 210 => 0x242, 211 => 0x280, 212 => 0x276, 213 => [0x27d,0x27f], 214 => 0x246, 217 => 0x2d6, 218 => 0x321, 219 => 0xbd8, 220 => 0x287, 221 => 0x320, 222 => 0x24a, 223 => 0x5fb, 225 => 0x2d5, 313 => 0x5d, 366 => 0x846, 369 => [0x125,0x14a] },
	'shuttercurtainsync' => { 73 => 0xf, 74 => 0xf, 75 => 0x305, 76 => 0xe, 77 => 0xf, 78 => 0x8, 79 => 0x8, 80 => 0xf, 81 => 0x8 },
	'shuttermode' => { 125 => 0x1b },
	'shutterreleasebuttonae-l' => { 243 => '17.7', 244 => '18.4', 246 => '78.4', 247 => '16.1', 248 => '17.1', 249 => '17.1', 250 => '17.1', 251 => '7.1', 252 => '17.5', 255 => '18.4', 256 => '18.2' },
	'shutterreleasemethod' => { 88 => 0x1010 },
	'shutterreleasenocfcard' => { 73 => 0x2, 74 => 0x2, 81 => 0xf },
	'shutterreleasetiming' => { 88 => 0x1011 },
	'shutterreleasewithoutlens' => { 75 => 0x711 },
	'shutterspeedlock' => { 244 => '38.1', 246 => '38.1', 255 => '38.1' },
	'shutterspeedrange' => { 75 => 0x10c },
	'shutterspeedsetting' => { 164 => 0x6, 355 => 0x2f, 356 => 0x28, 357 => 0x0 },
	'shutterspeedvalue' => { 84 => 0x1, 109 => 0x9201, 263 => 0x1000, 322 => 0x400, 415 => 'ShutterSpeedValue' },
	'shuttertype' => { 114 => 0x1050, 279 => 0x9f },
	'sidecarforextension' => { 423 => 'SidecarForExtension' },
	'similarityindex' => { 117 => 0xe4 },
	'singleframebracketing' => { 164 => 0x21 },
	'skilllevel' => { 427 => 'skillLevel' },
	'slaveflashmeteringsegments' => { 313 => 0x20b },
	'slideshowname' => { 424 => 'slideshowName' },
	'slideshownumber' => { 424 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 424 => 'slideshowTotalNumber' },
	'slowshutter' => { 69 => 0x8 },
	'slowsync' => { 114 => 0x1030 },
	'smartrange' => { 344 => 0xa012 },
	'smileshutter' => { 357 => 0x31 },
	'smileshuttermode' => { 357 => 0x27 },
	'smoothness' => { 109 => 0xfe57, 411 => 'Smoothness' },
	'snapshots' => { 405 => 'Snapshots' },
	'softskineffect' => { 367 => 0x200f },
	'software' => { 109 => 0x131, 140 => 'Software', 271 => 'Software', 322 => 0x203, 347 => 0x18, 431 => 'Software' },
	'softwareversion' => { 346 => 0x207 },
	'sonydatetime' => { 373 => 0x6, 375 => 0x1b6, 376 => 0x210, 377 => 0x1fe, 378 => 0x22c },
	'sonydatetime2' => { 383 => [0x51,0x5d] },
	'sonyexposuretime' => { 383 => 0x46 },
	'sonyexposuretime2' => { 392 => 0xe },
	'sonyfnumber' => { 383 => [0x3c,0x48], 392 => 0x14 },
	'sonyimageheight' => { 373 => 0x1a, 384 => 0x44, 385 => 0x3f, 386 => 0x47 },
	'sonyimagesize' => { 164 => 0x3b, 355 => 0x54, 356 => 0x54, 357 => 0x9 },
	'sonyimagewidth' => { 373 => 0x1c },
	'sonyiso' => { 375 => 0x1218, 376 => 0x11f4, 377 => 0x1270, 378 => [0x1254,0x1258,0x1280], 379 => 0x113c, 380 => 0x344, 381 => 0x346, 392 => 0x4 },
	'sonymaxaperturevalue' => { 392 => 0x16 },
	'sonymodelid' => { 367 => 0xb001 },
	'sonyquality' => { 164 => 0x3c },
	'source' => { 117 => 0x73, 271 => 'Source', 412 => 'source', 413 => 'source', 423 => 'Source' },
	'sourcedirectoryindex' => { 300 => 0x0 },
	'sourcefileindex' => { 300 => 0x2 },
	'sourcephotoscount' => { 400 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 415 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 415 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 415 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 415 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 415 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 435 => 'speakerPlacement' },
	'specialeffectlevel' => { 104 => 0x3030 },
	'specialeffectmode' => { 104 => 0x2076 },
	'specialeffectsetting' => { 104 => 0x3031 },
	'specialinstructions' => { 117 => 0x28 },
	'specialmode' => { 263 => 0x200, 346 => 0x200 },
	'specialoccasion' => { 427 => 'specialOccasion' },
	'spectralsensitivity' => { 109 => 0x8824, 415 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 40 => [0x2b9,0x2d0,0x2d4], 42 => 0x1e4, 43 => [0x1fd,0x2dd], 44 => [0x231,0x30f] },
	'speedx' => { 106 => 0x3 },
	'speedy' => { 106 => 0x4 },
	'speedz' => { 106 => 0x5 },
	'splitcolumn' => { 322 => 0x222 },
	'splittoningbalance' => { 411 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 411 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 411 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 411 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 411 => 'SplitToningShadowSaturation' },
	'sport' => { 425 => 'sport' },
	'spotfocuspointx' => { 161 => 0x2d },
	'spotfocuspointy' => { 161 => 0x2e },
	'spotmeteringmode' => { 33 => 0x27 },
	'spotmeterlinktoafpoint' => { 75 => 0x107 },
	'sractive' => { 294 => '17.1' },
	'srawquality' => { 33 => 0x2e },
	'srfocallength' => { 315 => 0x3 },
	'srhalfpresstime' => { 315 => 0x2 },
	'srresult' => { 315 => 0x0, 316 => 0x0 },
	'stackedimage' => { 258 => 0x804 },
	'standardoutputhighlightpoint' => { 100 => 0x14 },
	'standardoutputsensitivity' => { 109 => 0x8831, 416 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 100 => 0x15 },
	'standardrawcolortone' => { 100 => 0xd },
	'standardrawcontrast' => { 100 => 0xf },
	'standardrawhighlight' => { 100 => 0x75 },
	'standardrawhighlightpoint' => { 100 => 0x12 },
	'standardrawlinear' => { 100 => 0x10 },
	'standardrawsaturation' => { 100 => 0xe },
	'standardrawshadow' => { 100 => 0x7e },
	'standardrawshadowpoint' => { 100 => 0x13 },
	'standardrawsharpness' => { 100 => 0x11 },
	'standardunsharpmaskfineness' => { 100 => 0x94 },
	'standardunsharpmaskstrength' => { 100 => 0x92 },
	'standardunsharpmaskthreshold' => { 100 => 0x96 },
	'standbytimer' => { 244 => '19.1', 246 => '19.1', 249 => '18.1', 250 => '18.1', 255 => '19.1' },
	'startingpage' => { 425 => 'startingPage' },
	'startmovieshooting' => { 75 => 0x70d },
	'starttimecode' => { 435 => 'startTimecode' },
	'starttimecodetimeformat' => { 435 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 435 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 435 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 435 => 'startTimeSampleSize' },
	'starttimescale' => { 435 => 'startTimeScale' },
	'state' => { 144 => 'State', 279 => 0x6b, 423 => 'State' },
	'status' => { 399 => 'Status', 403 => 'Status' },
	'stitchingsoftware' => { 400 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 374 => 0x113e, 375 => 0x113e, 376 => 0x111a, 377 => 0x1196, 378 => 0x1172, 379 => 0x102a, 380 => 0x222, 381 => 0x222, 392 => 0xa },
	'storagemethod' => { 168 => 0x12 },
	'storebyorientation' => { 244 => '46.3', 246 => '47.3', 255 => '47.3' },
	'straightenangle' => { 236 => 0x2fc08431 },
	'streamtype' => { 157 => 'StreamType' },
	'stretchmode' => { 435 => 'stretchMode' },
	'studydatetime' => { 398 => 'StudyDateTime' },
	'studydescription' => { 398 => 'StudyDescription' },
	'studyid' => { 398 => 'StudyID' },
	'studyphysician' => { 398 => 'StudyPhysician' },
	'sub-location' => { 117 => 0x5c },
	'subfiledata' => { 147 => 'data' },
	'subfiledirectory' => { 147 => '1Directory' },
	'subfilemimetype' => { 147 => '2MIME' },
	'subfilename' => { 147 => '1Name' },
	'subfileresource' => { 147 => 'rsrc' },
	'subfiletype' => { 109 => 0xfe, 147 => '0Type' },
	'subject' => { 267 => 'Subject', 329 => 'Subject', 412 => 'subject', 422 => 'Subject', 436 => 'subject' },
	'subjectarea' => { 109 => 0x9214, 415 => 'SubjectArea' },
	'subjectcode' => { 420 => 'SubjectCode' },
	'subjectdistance' => { 109 => 0x9206, 125 => 0x3e, 415 => 'SubjectDistance' },
	'subjectdistancerange' => { 109 => 0xa40c, 415 => 'SubjectDistanceRange' },
	'subjectlocation' => { 109 => 0xa214, 415 => 'SubjectLocation' },
	'subjectmotion' => { 246 => '78.2' },
	'subjectprogram' => { 161 => 0x22 },
	'subjectreference' => { 117 => 0xc },
	'sublabels4' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 419 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 419 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 105 => 'SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 105 => 'SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 105 => 'SubSecModifyDate' },
	'subsectime' => { 109 => 0x9290 },
	'subsectimedigitized' => { 109 => 0x9292 },
	'subsectimeoriginal' => { 109 => 0x9291 },
	'subsection1' => { 425 => 'subsection1' },
	'subsection2' => { 425 => 'subsection2' },
	'subsection3' => { 425 => 'subsection3' },
	'subsection4' => { 425 => 'subsection4' },
	'subselector' => { 244 => '49.1', 246 => '71.1' },
	'subselectorassignment' => { 244 => '48.1' },
	'subselectorcenter' => { 246 => '72.1' },
	'subselectorplusdials' => { 244 => '49.2', 246 => '73.1' },
	'subtitle' => { 425 => 'subtitle' },
	'subversionfilename' => { 419 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 419 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 419 => 'SubVersions' },
	'superimposeddisplay' => { 73 => 0xa, 75 => 0x510, 76 => 0x9, 77 => 0xa, 80 => 0xa, 81 => 0xe },
	'supermacro' => { 57 => 0x1a },
	'supplementalcategories' => { 117 => 0x14, 423 => 'SupplementalCategories' },
	'supplementaltype' => { 119 => 0x37 },
	'supplementdisplayid' => { 425 => 'supplementDisplayID' },
	'supplementstartingpage' => { 425 => 'supplementStartingPage' },
	'supplementtitle' => { 425 => 'supplementTitle' },
	'svisosetting' => { 294 => 0x14 },
	'swatchcoloranta' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 440 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 440 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 440 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 440 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 440 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 279 => 0x93, 357 => 0x33 },
	'sweeppanoramafieldofview' => { 279 => 0x94 },
	'sweeppanoramasize' => { 357 => 0x32 },
	'switchtoregisteredafpoint' => { 74 => 0x12, 75 => 0x50a },
	'syncreleasemode' => { 246 => '77.1' },
	'system' => { 322 => 0x204 },
	'tagged' => { 324 => 0xdd, 325 => 'Tagged', 405 => 'tagged' },
	'tagslist' => { 414 => 'TagsList' },
	'tagstructure' => { 419 => 'TagStructure' },
	'takenumber' => { 435 => 'takeNumber' },
	'tapename' => { 435 => 'tapeName' },
	'targetaperture' => { 69 => 0x4 },
	'targetcompressionratio' => { 86 => 0x1 },
	'targetdistancesetting' => { 88 => 0x1807 },
	'targetexposuretime' => { 69 => 0x5 },
	'targetimagetype' => { 88 => 0x100a },
	'targetprinter' => { 109 => 0x151 },
	'taxon' => { 108 => 'Taxon' },
	'taxonacceptednameusage' => { 108 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 108 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 108 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 108 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 108 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 108 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 108 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 108 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 108 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 108 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 108 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 108 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 108 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 108 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 108 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 108 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 108 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 108 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 108 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 108 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 108 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 108 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 108 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 108 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 108 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 108 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 108 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 108 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 108 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 108 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 108 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 108 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 108 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 425 => 'teaser' },
	'teleconverter' => { 166 => 0x105, 367 => 0x105 },
	'tempo' => { 435 => 'tempo' },
	'termsandconditionstext' => { 268 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 268 => 'TermsAndConditionsURL' },
	'testname' => { 110 => 'TestName' },
	'textencoding' => { 197 => 0x4 },
	'textlayername' => { 423 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 423 => 'TextLayers' },
	'textlayertext' => { 423 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 279 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 246 => '1.3' },
	'three-dtrackingwatcharea' => { 246 => '78.1' },
	'thresholding' => { 109 => 0x107 },
	'thumbnailfilename' => { 88 => 0x817 },
	'thumbnailformat' => { 433 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 127 => 0xfa55, 433 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 88 => 0x2008, 105 => 'ThumbnailImage', 112 => 0x3, 150 => 'data', 263 => 0x100, 433 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 150 => '1Name' },
	'thumbnailimagesize' => { 150 => 'ImageSize' },
	'thumbnailimagetype' => { 150 => '0Type' },
	'thumbnailimagevalidarea' => { 57 => 0x13 },
	'thumbnaillength' => { 109 => 0x202 },
	'thumbnailoffset' => { 109 => 0x201 },
	'thumbnails' => { 433 => 'Thumbnails' },
	'thumbnailwidth' => { 127 => 0xfa54, 433 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 425 => 'ticker' },
	'tiffhandling' => { 411 => 'TIFFHandling' },
	'tiffmeteringimage' => { 167 => 0x104c, 366 => 0x1110 },
	'tilelength' => { 109 => 0x143 },
	'tilewidth' => { 109 => 0x142 },
	'time' => { 123 => 0x401, 313 => 0x7 },
	'timecodes' => { 109 => 0xc763 },
	'timecreated' => { 117 => 0x3c, 125 => 0x14, 134 => 0x10, 325 => 'TimeCreated' },
	'timeperiod' => { 425 => 'timePeriod' },
	'timerfunctionbutton' => { 245 => '5.2', 247 => '12.1', 248 => '13.1' },
	'timerlength' => { 75 => 0x80c },
	'timerrecording' => { 279 => 0x96 },
	'timescaleparams' => { 435 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 435 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 435 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 435 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 118 => 0x50 },
	'timesignature' => { 435 => 'timeSignature' },
	'timesincepoweron' => { 279 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 257 => 0x8, 271 => 'TimeStamp', 406 => 'Timestamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 70 => 0x1, 228 => 0x0, 341 => 0xa },
	'timezonecity' => { 70 => 0x2 },
	'timezonecode' => { 91 => 0x1 },
	'timezoneinfo' => { 91 => 0x2 },
	'timezoneoffset' => { 109 => 0x882a },
	'tint' => { 411 => 'Tint' },
	'title' => { 140 => 'Title', 267 => 'Title', 271 => 'Title', 279 => 0x65, 329 => 'Title', 412 => 'title', 422 => 'Title', 433 => 'Title' },
	'tonecomp' => { 198 => 0x81 },
	'tonecurve' => { 67 => 0x1, 313 => 0x402, 411 => 'ToneCurve' },
	'tonecurveactive' => { 99 => 0x110 },
	'tonecurveadobergb' => { 344 => 0xa043 },
	'tonecurveadobergbdefault' => { 344 => 0xa041 },
	'tonecurveblue' => { 411 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 396 => 0x9003 },
	'tonecurvebluey' => { 396 => 0x9007 },
	'tonecurvebrightness' => { 94 => 0x20410 },
	'tonecurvebrightnessx' => { 396 => 0x9000 },
	'tonecurvebrightnessy' => { 396 => 0x9004 },
	'tonecurvecolorspace' => { 98 => 0x0 },
	'tonecurvecontrast' => { 94 => 0x20411 },
	'tonecurvefilename' => { 123 => 0x1391 },
	'tonecurvegreen' => { 411 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 396 => 0x9002 },
	'tonecurvegreeny' => { 396 => 0x9006 },
	'tonecurveinputrange' => { 98 => 0x3 },
	'tonecurveinterpolation' => { 99 => 0x159 },
	'tonecurvemode' => { 99 => 0x113 },
	'tonecurvename' => { 411 => 'ToneCurveName' },
	'tonecurvename2012' => { 411 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 94 => '0x20400.1' },
	'tonecurveoutputrange' => { 98 => 0x5 },
	'tonecurveproperty' => { 99 => 0x3c },
	'tonecurvepv2012' => { 411 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 411 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 411 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 411 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 411 => 'ToneCurveRed' },
	'tonecurveredx' => { 396 => 0x9001 },
	'tonecurveredy' => { 396 => 0x9005 },
	'tonecurves' => { 313 => 0x403 },
	'tonecurveshape' => { 98 => 0x1 },
	'tonecurvesrgb' => { 344 => 0xa042 },
	'tonecurvesrgbdefault' => { 344 => 0xa040 },
	'tonecurvex' => { 98 => 0xa },
	'tonecurvey' => { 98 => 0xb },
	'tonelevel' => { 258 => 0x52e },
	'tonemapstrength' => { 411 => 'ToneMapStrength' },
	'toningeffect' => { 51 => 0xf, 198 => 0xb3, 200 => 0x38, 201 => 0x40, 338 => 0x1015 },
	'toningeffectauto' => { 64 => 0xa4 },
	'toningeffectfaithful' => { 63 => 0x74, 64 => 0x74 },
	'toningeffectlandscape' => { 63 => 0x44, 64 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 63 => 0x8c, 64 => 0x8c },
	'toningeffectneutral' => { 63 => 0x5c, 64 => 0x5c },
	'toningeffectportrait' => { 63 => 0x2c, 64 => 0x2c },
	'toningeffectstandard' => { 63 => 0x14, 64 => 0x14 },
	'toningeffectuserdef1' => { 63 => 0xa4, 64 => 0xbc },
	'toningeffectuserdef2' => { 63 => 0xbc, 64 => 0xd4 },
	'toningeffectuserdef3' => { 63 => 0xd4, 64 => 0xec },
	'toningsaturation' => { 200 => 0x39, 201 => 0x41 },
	'totalzoom' => { 125 => 0x62 },
	'touchae' => { 279 => 0xab },
	'trackcreatedate' => { 333 => 0x1 },
	'trackmodifydate' => { 333 => 0x2 },
	'tracknumber' => { 435 => 'trackNumber' },
	'tracks' => { 435 => 'Tracks' },
	'tracksframerate' => { 435 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 435 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 435 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 435 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 435 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 435 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 435 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 435 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 435 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 435 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 435 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 435 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 435 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 435 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 435 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 435 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 435 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 147 => 'zmie' },
	'transferfunction' => { 109 => 0x12d, 431 => 'TransferFunction' },
	'transform' => { 279 => [0x8012,0x59] },
	'transmissionreference' => { 423 => 'TransmissionReference' },
	'trapped' => { 267 => 'Trapped', 422 => 'Trapped' },
	'trashbuttonfunction' => { 75 => 0x710 },
	'travelday' => { 279 => 0x36 },
	'triggermode' => { 334 => 0x6 },
	'tstop' => { 109 => 0xc772 },
	'ttl_da_adown' => { 301 => 0x5 },
	'ttl_da_aup' => { 301 => 0x4 },
	'ttl_da_bdown' => { 301 => 0x7 },
	'ttl_da_bup' => { 301 => 0x6 },
	'tungstenawb' => { 291 => 0x1 },
	'tvexposuretimesetting' => { 294 => 0x12 },
	'type' => { 412 => 'type', 430 => 'type' },
	'typestatus' => { 108 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 109 => 0xc614 },
	'uniquedocumentid' => { 117 => 0xbb },
	'uniqueobjectname' => { 118 => 0x64 },
	'unknownblock' => { 313 => 0x405 },
	'unknownblock1' => { 262 => 0x635 },
	'unknownblock2' => { 262 => 0x636 },
	'unknownblock3' => { 262 => 0x1103 },
	'unknownblock4' => { 262 => 0x1104 },
	'unknowncontrast' => { 100 => 0x45 },
	'unknowndate' => { 322 => 0x212 },
	'unknownev' => { 123 => 0x1 },
	'unknownlinear' => { 100 => 0x46 },
	'unknownnumber' => { 88 => 0x180b },
	'unknownoutputhighlightpoint' => { 100 => 0x4a },
	'unknownoutputshadowpoint' => { 100 => 0x4b },
	'unknownrawhighlight' => { 100 => 0x7b },
	'unknownrawhighlightpoint' => { 100 => 0x48 },
	'unknownrawshadow' => { 100 => 0x84 },
	'unknownrawshadowpoint' => { 100 => 0x49 },
	'unknownsharpness' => { 100 => 0x47 },
	'unknowntemperature' => { 111 => 0x4 },
	'unsharp1color' => { 241 => 0x13 },
	'unsharp1halowidth' => { 241 => 0x19 },
	'unsharp1intensity' => { 241 => 0x17 },
	'unsharp1threshold' => { 241 => 0x1b },
	'unsharp2color' => { 241 => 0x2e },
	'unsharp2halowidth' => { 241 => 0x34 },
	'unsharp2intensity' => { 241 => 0x32 },
	'unsharp2threshold' => { 241 => 0x36 },
	'unsharp3color' => { 241 => 0x49 },
	'unsharp3halowidth' => { 241 => 0x4f },
	'unsharp3intensity' => { 241 => 0x4d },
	'unsharp3threshold' => { 241 => 0x51 },
	'unsharp4color' => { 241 => 0x64 },
	'unsharp4halowidth' => { 241 => 0x6a },
	'unsharp4intensity' => { 241 => 0x68 },
	'unsharp4threshold' => { 241 => 0x6c },
	'unsharpcount' => { 241 => 0x0 },
	'unsharpmask' => { 100 => 0x90, 236 => 0x76a43200 },
	'unsharpmaskfineness' => { 94 => 0x20309 },
	'unsharpmaskstrength' => { 94 => 0x20308 },
	'unsharpmaskthreshold' => { 94 => 0x2030a },
	'uprightcentermode' => { 411 => 'UprightCenterMode' },
	'uprightcenternormx' => { 411 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 411 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 411 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 411 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 411 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 411 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 411 => 'UprightPreview' },
	'uprighttransform_0' => { 411 => 'UprightTransform_0' },
	'uprighttransform_1' => { 411 => 'UprightTransform_1' },
	'uprighttransform_2' => { 411 => 'UprightTransform_2' },
	'uprighttransform_3' => { 411 => 'UprightTransform_3' },
	'uprighttransform_4' => { 411 => 'UprightTransform_4' },
	'uprighttransform_5' => { 411 => 'UprightTransform_5' },
	'uprighttransformcount' => { 411 => 'UprightTransformCount' },
	'uprightversion' => { 411 => 'UprightVersion' },
	'urgency' => { 117 => 0xa, 423 => 'Urgency' },
	'url' => { 140 => 'URL', 271 => 'URL', 327 => 0x40b, 425 => 'url' },
	'url_list' => { 327 => 0x41e },
	'urla-platform' => { 425 => [\'url','urlA-platform'] },
	'urlurl' => { 425 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 75 => 0x10a },
	'usableshootingmodes' => { 75 => 0x109 },
	'usage' => { 426 => 'usage' },
	'usageterms' => { 439 => 'UsageTerms' },
	'useguidelines' => { 408 => 'useGuidelines' },
	'usepanoramaviewer' => { 400 => 'UsePanoramaViewer' },
	'usercomment' => { 88 => 0x805, 109 => 0x9286, 415 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 63 => 0xd8, 64 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 63 => 0xda, 64 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 63 => 0xdc, 64 => 0xf4 },
	'userfields' => { 403 => 'UserFields' },
	'userlabel' => { 334 => 0x2b },
	'userprofile' => { 275 => 0x302, 281 => 0x3038 },
	'usmlenselectronicmf' => { 2 => 0x7, 74 => 0x7, 75 => 0x501 },
	'uspsnumber' => { 425 => 'uspsNumber' },
	'utmeasting' => { 151 => 'Easting' },
	'utmmapdatum' => { 151 => 'Datum' },
	'utmnorthing' => { 151 => 'Northing' },
	'utmzone' => { 151 => 'Zone' },
	'uv-irfiltercorrection' => { 275 => 0x325 },
	'validbits' => { 262 => 0x611, 263 => 0x102c },
	'validpixeldepth' => { 266 => 0x611 },
	'variousmodes' => { 125 => 0x26 },
	'variousmodes2' => { 125 => 0x3a },
	'variprogram' => { 198 => 0xab },
	'version' => { 114 => 0x0, 329 => 'Version', 411 => 'Version' },
	'versioncreatedate' => { 396 => 0xd100 },
	'versionid' => { 436 => 'VersionID' },
	'versionidentifier' => { 425 => 'versionIdentifier' },
	'versionmodifydate' => { 396 => 0xd101 },
	'versions' => { 436 => 'Versions' },
	'versionscomments' => { 436 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 436 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 436 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 436 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 436 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 436 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 436 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 436 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 436 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 436 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 436 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 243 => '3.2', 244 => '47.2' },
	'verticalfuncbutton' => { 244 => '42.2' },
	'verticalfuncbuttonplusdials' => { 244 => '43.1' },
	'verticalmultiselector' => { 244 => '42.1', 246 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 75 => [0x510,0x51d] },
	'vibrance' => { 404 => 'Vibrance', 411 => 'Vibrance' },
	'vibrationreduction' => { 206 => [0x75,0x82,0x1ae], 214 => '586.1', 222 => '590.2', 227 => 0x4 },
	'videoalphamode' => { 435 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 435 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 435 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 435 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 60 => 0x74 },
	'videocolorspace' => { 435 => 'videoColorSpace' },
	'videocompressor' => { 435 => 'videoCompressor' },
	'videofieldorder' => { 435 => 'videoFieldOrder' },
	'videoframerate' => { 435 => 'videoFrameRate' },
	'videoframesize' => { 435 => 'videoFrameSize' },
	'videoframesizeh' => { 435 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 435 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 435 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 435 => 'videoModDate' },
	'videopixelaspectratio' => { 435 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 435 => 'videoPixelDepth' },
	'videoquality' => { 104 => 0x4003 },
	'viewfinderdisplay' => { 243 => '12.4', 244 => '6.3' },
	'viewfinderwarning' => { 243 => '13.4', 252 => '3.5', 253 => '6.2', 256 => '4.4' },
	'viewfinderwarnings' => { 75 => 0x40a },
	'viewinfoduringexposure' => { 75 => 0x407 },
	'viewingmode' => { 357 => 0x2f, 371 => 0x18 },
	'viewingmode2' => { 357 => [0x85,0x285] },
	'viewpoint' => { 424 => 'viewpoint' },
	'vignetteamount' => { 411 => 'VignetteAmount' },
	'vignettecontrol' => { 198 => 0x2a, 236 => 0x76a43205 },
	'vignettecontrolintensity' => { 236 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 407 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 411 => 'VignetteMidpoint' },
	'vignetting' => { 338 => 0x1011, 344 => 0xa052 },
	'vignettingcorrection' => { 344 => 0xa053, 367 => 0x2011 },
	'vignettingsetting' => { 344 => 0xa054 },
	'visualtechnique' => { 424 => 'visualTechnique' },
	'voicememo' => { 346 => 0x216 },
	'volume' => { 425 => 'volume' },
	'vr_0x66' => { 206 => 0x66 },
	'vrdoffset' => { 57 => 0xd0 },
	'vrmode' => { 227 => 0x6 },
	'waterdepth' => { 109 => 0x9403 },
	'wb_bluelevel3500k' => { 167 => 0x19a },
	'wb_bluelevel6500k' => { 167 => 0x18a },
	'wb_bluelevelcustom' => { 167 => 0x18e },
	'wb_bluelevelscloudy' => { 167 => 0x106 },
	'wb_bluelevelsdaylight' => { 167 => 0xea },
	'wb_bluelevelsflash' => { 167 => 0x122 },
	'wb_bluelevelsfluorescent' => { 167 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 167 => 0x254 },
	'wb_bluelevelsshade' => { 167 => 0x176 },
	'wb_bluelevelstungsten' => { 167 => 0xce },
	'wb_gbrglevels' => { 167 => 0xae, 170 => 0x4 },
	'wb_glevel' => { 262 => 0x11f },
	'wb_glevel3000k' => { 262 => 0x113 },
	'wb_glevel3300k' => { 262 => 0x114 },
	'wb_glevel3600k' => { 262 => 0x115 },
	'wb_glevel3900k' => { 262 => 0x116 },
	'wb_glevel4000k' => { 262 => 0x117 },
	'wb_glevel4300k' => { 262 => 0x118 },
	'wb_glevel4500k' => { 262 => 0x119 },
	'wb_glevel4800k' => { 262 => 0x11a },
	'wb_glevel5300k' => { 262 => 0x11b },
	'wb_glevel6000k' => { 262 => 0x11c },
	'wb_glevel6600k' => { 262 => 0x11d },
	'wb_glevel7500k' => { 262 => 0x11e },
	'wb_grbglevels' => { 180 => 0x0 },
	'wb_rbgglevels' => { 177 => 0x0 },
	'wb_rblevels' => { 198 => 0xc, 262 => 0x100 },
	'wb_rblevels1' => { 284 => 0x2 },
	'wb_rblevels2' => { 284 => 0x5 },
	'wb_rblevels3' => { 284 => 0x8 },
	'wb_rblevels3000k' => { 262 => 0x102 },
	'wb_rblevels3300k' => { 262 => 0x103 },
	'wb_rblevels3500k' => { 167 => 0x430 },
	'wb_rblevels3600k' => { 262 => 0x104 },
	'wb_rblevels3900k' => { 262 => 0x105 },
	'wb_rblevels4' => { 284 => 0xb },
	'wb_rblevels4000k' => { 262 => 0x106 },
	'wb_rblevels4300k' => { 262 => 0x107 },
	'wb_rblevels4500k' => { 262 => 0x108 },
	'wb_rblevels4800k' => { 262 => 0x109 },
	'wb_rblevels5' => { 284 => 0xe },
	'wb_rblevels5300k' => { 262 => 0x10a },
	'wb_rblevels6' => { 284 => 0x11 },
	'wb_rblevels6000k' => { 262 => 0x10b },
	'wb_rblevels6500k' => { 167 => 0x420 },
	'wb_rblevels6600k' => { 262 => 0x10c },
	'wb_rblevels7' => { 284 => 0x14 },
	'wb_rblevels7500k' => { 262 => 0x10d },
	'wb_rblevelsauto' => { 266 => 0x110 },
	'wb_rblevelscloudy' => { 167 => 0x3f0, 169 => 0x10, 266 => 0x121 },
	'wb_rblevelscoolwhitef' => { 167 => 0x308, 169 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 266 => 0x132 },
	'wb_rblevelscustom' => { 167 => 0x424 },
	'wb_rblevelscwb1' => { 262 => 0x10e },
	'wb_rblevelscwb2' => { 262 => 0x10f },
	'wb_rblevelscwb3' => { 262 => 0x110 },
	'wb_rblevelscwb4' => { 262 => 0x111 },
	'wb_rblevelsdaylight' => { 167 => [0x3ec,0x528], 169 => 0xc },
	'wb_rblevelsdaylightf' => { 169 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 266 => 0x130 },
	'wb_rblevelsdaywhitef' => { 169 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 266 => 0x131 },
	'wb_rblevelseveningsunlight' => { 266 => 0x124 },
	'wb_rblevelsfineweather' => { 266 => 0x122 },
	'wb_rblevelsflash' => { 167 => [0x3f4,0x304], 169 => 0x18 },
	'wb_rblevelsshade' => { 167 => 0x418, 169 => 0x20, 266 => 0x120 },
	'wb_rblevelstungsten' => { 167 => 0x3e8, 169 => 0x8, 266 => 0x123 },
	'wb_rblevelsunknown' => { 169 => 0x1c },
	'wb_rblevelsused' => { 266 => 0x100 },
	'wb_rblevelswhitef' => { 169 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 266 => 0x133 },
	'wb_redlevel3500k' => { 167 => 0x198 },
	'wb_redlevel6500k' => { 167 => 0x188 },
	'wb_redlevelcustom' => { 167 => 0x18c },
	'wb_redlevelscloudy' => { 167 => 0xf8 },
	'wb_redlevelsdaylight' => { 167 => 0xdc },
	'wb_redlevelsflash' => { 167 => 0x114 },
	'wb_redlevelsfluorescent' => { 167 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 167 => 0x1be },
	'wb_redlevelsshade' => { 167 => 0x168 },
	'wb_redlevelstungsten' => { 167 => 0xc0 },
	'wb_rgbglevels' => { 179 => 0x0 },
	'wb_rgblevels' => { 167 => [0x546,0x96], 276 => 0xd, 277 => 0x413, 281 => 0x3036, 322 => 0x107, 374 => 0x117c, 375 => 0x1180, 376 => 0x115c, 377 => 0x11d8, 378 => 0x11b4, 379 => 0x106c, 380 => 0x264, 381 => 0x264 },
	'wb_rgblevels1' => { 285 => 0x2 },
	'wb_rgblevels2' => { 285 => 0x6 },
	'wb_rgblevels3' => { 285 => 0xa },
	'wb_rgblevels4' => { 285 => 0xe },
	'wb_rgblevels5' => { 285 => 0x12 },
	'wb_rgblevels6' => { 285 => 0x16 },
	'wb_rgblevels7' => { 285 => 0x1a },
	'wb_rggbblacklevels' => { 34 => 0x25 },
	'wb_rggblevels' => { 170 => 0x4, 178 => 0x0 },
	'wb_rggblevelsasshot' => { 36 => 0x0, 37 => 0x19, 38 => 0x22, 39 => 0x3f, 42 => 0x3f, 43 => 0x3f, 44 => 0x3f },
	'wb_rggblevelsauto' => { 34 => 0x1, 36 => 0x5, 37 => 0x1e, 38 => 0x18, 39 => 0x44, 42 => 0x44, 43 => 0x44, 44 => 0x44, 344 => 0xa022 },
	'wb_rggblevelsblack' => { 344 => 0xa028 },
	'wb_rggblevelscloudy' => { 34 => 0xd, 36 => 0x1e, 37 => 0x2d, 38 => 0x31, 39 => 0x58, 42 => 0x71, 43 => 0x8a, 44 => 0x8f, 313 => 0x20f, 321 => 0x14 },
	'wb_rggblevelscustom' => { 34 => 0x1d, 39 => 0x80 },
	'wb_rggblevelscustom1' => { 37 => 0x41 },
	'wb_rggblevelscustom2' => { 37 => 0x46 },
	'wb_rggblevelsdaylight' => { 34 => 0x5, 36 => 0x14, 37 => 0x23, 38 => 0x27, 39 => 0x4e, 42 => 0x67, 43 => 0x80, 44 => 0x85, 313 => 0x20d, 321 => 0x2 },
	'wb_rggblevelsflash' => { 34 => 0x19, 36 => 0x32, 37 => 0x3c, 38 => 0x45, 39 => 0x6c, 42 => 0x85, 43 => 0x9e, 44 => 0xa3, 313 => 0x214, 321 => 0x41 },
	'wb_rggblevelsfluorescent' => { 34 => 0x15, 36 => 0x28, 37 => 0x37, 38 => 0x3b, 39 => 0x62, 42 => 0x7b, 43 => 0x94, 44 => 0x99 },
	'wb_rggblevelsfluorescentd' => { 313 => 0x211, 321 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 321 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 313 => 0x212, 321 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 313 => 0x213, 321 => 0x38 },
	'wb_rggblevelsilluminator1' => { 344 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 344 => 0xa024 },
	'wb_rggblevelskelvin' => { 34 => 0x21, 36 => 0x2d, 38 => 0x40, 39 => 0x67, 42 => 0x80, 43 => 0x99, 44 => 0x9e },
	'wb_rggblevelsmeasured' => { 36 => 0xa, 39 => 0x49, 42 => 0x49, 43 => 0x49, 44 => 0x49 },
	'wb_rggblevelspc1' => { 38 => 0x90, 39 => 0x71 },
	'wb_rggblevelspc2' => { 38 => 0x95, 39 => 0x76 },
	'wb_rggblevelspc3' => { 38 => 0x9a, 39 => 0x7b },
	'wb_rggblevelsshade' => { 34 => 0x9, 36 => 0x19, 37 => 0x28, 38 => 0x2c, 39 => 0x53, 42 => 0x6c, 43 => 0x85, 44 => 0x8a, 313 => 0x20e, 321 => 0xb },
	'wb_rggblevelstungsten' => { 34 => 0x11, 36 => 0x23, 37 => 0x32, 38 => 0x36, 39 => 0x5d, 42 => 0x76, 43 => 0x8f, 44 => 0x94, 313 => 0x210, 321 => 0x1d },
	'wb_rggblevelsuncorrected' => { 344 => 0xa021 },
	'wb_rggblevelsunknown' => { 36 => 0xf, 38 => 0x1d, 42 => 0x4e, 43 => 0x4e, 44 => 0x4e, 321 => 0x53 },
	'wb_rggblevelsunknown10' => { 36 => 0x5f, 38 => 0x72, 42 => 0x9e, 43 => 0x7b, 44 => 0x7b },
	'wb_rggblevelsunknown11' => { 36 => 0x64, 38 => 0x77, 42 => 0xa3, 43 => 0xa3, 44 => 0x80 },
	'wb_rggblevelsunknown12' => { 36 => 0x69, 38 => 0x7c, 42 => 0xa8, 43 => 0xa8, 44 => 0xa8 },
	'wb_rggblevelsunknown13' => { 36 => 0x6e, 38 => 0x81, 42 => 0xad, 43 => 0xad, 44 => 0xad },
	'wb_rggblevelsunknown14' => { 38 => 0x86, 42 => 0xb2, 43 => 0xb2, 44 => 0xb2 },
	'wb_rggblevelsunknown15' => { 38 => 0x8b, 42 => 0xb7, 43 => 0xb7, 44 => 0xb7 },
	'wb_rggblevelsunknown16' => { 38 => 0x9f, 43 => 0xbc, 44 => 0xbc },
	'wb_rggblevelsunknown17' => { 43 => 0xc1, 44 => 0xc1 },
	'wb_rggblevelsunknown18' => { 43 => 0xc6, 44 => 0xc6 },
	'wb_rggblevelsunknown19' => { 43 => 0xcb, 44 => 0xcb },
	'wb_rggblevelsunknown2' => { 36 => 0x37, 38 => 0x4a, 42 => 0x53, 43 => 0x53, 44 => 0x53 },
	'wb_rggblevelsunknown20' => { 43 => 0xd0, 44 => 0xd0 },
	'wb_rggblevelsunknown21' => { 44 => 0xd5 },
	'wb_rggblevelsunknown22' => { 44 => 0xda },
	'wb_rggblevelsunknown23' => { 44 => 0xdf },
	'wb_rggblevelsunknown24' => { 44 => 0xe4 },
	'wb_rggblevelsunknown25' => { 44 => 0xe9 },
	'wb_rggblevelsunknown26' => { 44 => 0xee },
	'wb_rggblevelsunknown27' => { 44 => 0xf3 },
	'wb_rggblevelsunknown28' => { 44 => 0xf8 },
	'wb_rggblevelsunknown29' => { 44 => 0xfd },
	'wb_rggblevelsunknown3' => { 36 => 0x3c, 38 => 0x4f, 42 => 0x58, 43 => 0x58, 44 => 0x58 },
	'wb_rggblevelsunknown30' => { 44 => 0x102 },
	'wb_rggblevelsunknown4' => { 36 => 0x41, 38 => 0x54, 42 => 0x5d, 43 => 0x5d, 44 => 0x5d },
	'wb_rggblevelsunknown5' => { 36 => 0x46, 38 => 0x59, 42 => 0x62, 43 => 0x62, 44 => 0x62 },
	'wb_rggblevelsunknown6' => { 36 => 0x4b, 38 => 0x5e, 42 => 0x8a, 43 => 0x67, 44 => 0x67 },
	'wb_rggblevelsunknown7' => { 36 => 0x50, 38 => 0x63, 42 => 0x8f, 43 => 0x6c, 44 => 0x6c },
	'wb_rggblevelsunknown8' => { 36 => 0x55, 38 => 0x68, 42 => 0x94, 43 => 0x71, 44 => 0x71 },
	'wb_rggblevelsunknown9' => { 36 => 0x5a, 38 => 0x6d, 42 => 0x99, 43 => 0x76, 44 => 0x76 },
	'wb_rggblevelsuserselected' => { 321 => 0x5c },
	'wbadjblueamber' => { 94 => 0x20106 },
	'wbadjbluebalance' => { 242 => 0x8 },
	'wbadjcolortemp' => { 94 => 0x20102, 99 => 0x1a },
	'wbadjlighting' => { 242 => 0x14 },
	'wbadjmagentagreen' => { 94 => 0x20105 },
	'wbadjmode' => { 242 => 0x10 },
	'wbadjredbalance' => { 242 => 0x0 },
	'wbadjrggblevels' => { 94 => 0x20125, 99 => 0x6 },
	'wbadjtemperature' => { 242 => 0x18 },
	'wbadjtint' => { 242 => 0x25 },
	'wbbluelevel' => { 275 => 0x324, 279 => 0x8006, 283 => 0x26 },
	'wbbracketingsteps' => { 215 => 0x174d, 216 => 0x87c, 224 => 0x1757 },
	'wbbracketmode' => { 51 => 0x9 },
	'wbbracketshotnumber' => { 167 => 0x2b, 338 => 0x101a },
	'wbbracketvalueab' => { 51 => 0xc },
	'wbbracketvaluegm' => { 51 => 0xd },
	'wbfinetuneactive' => { 99 => 0x24 },
	'wbfinetunesaturation' => { 99 => 0x28 },
	'wbfinetunetone' => { 99 => 0x2c },
	'wbgreenlevel' => { 275 => 0x323, 279 => 0x8005, 283 => 0x25 },
	'wbmediaimagesizesetting' => { 75 => 0x708 },
	'wbmode' => { 169 => 0x4, 263 => 0x1015 },
	'wbredlevel' => { 275 => 0x322, 279 => 0x8004, 283 => 0x24 },
	'wbscale' => { 170 => 0x0 },
	'wbshiftab' => { 67 => 0xc, 279 => 0x46, 295 => 0x10 },
	'wbshiftab_gm' => { 367 => 0x2014 },
	'wbshiftab_gm_precise' => { 367 => 0x2026 },
	'wbshiftgm' => { 67 => 0xd, 279 => 0x47, 295 => 0x11 },
	'wbtype1' => { 284 => 0x1, 285 => 0x1 },
	'wbtype2' => { 284 => 0x4, 285 => 0x5 },
	'wbtype3' => { 284 => 0x7, 285 => 0x9 },
	'wbtype4' => { 284 => 0xa, 285 => 0xd },
	'wbtype5' => { 284 => 0xd, 285 => 0x11 },
	'wbtype6' => { 284 => 0x10, 285 => 0x15 },
	'wbtype7' => { 284 => 0x13, 285 => 0x19 },
	'webstatement' => { 439 => 'WebStatement' },
	'what' => { 411 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x131, 27 => 0x77, 67 => 0x8, 69 => 0x7, 103 => 0x7, 104 => [0x19,0x2012], 109 => [0xa403,0xfe4e], 114 => 0x1002, 123 => 0x3fc, 124 => 0xfa0d, 125 => 0x40, 161 => 0x3, 162 => 0xe, 163 => 0x4, 164 => 0xb, 166 => 0x115, 198 => 0x5, 226 => 0x7, 275 => 0x304, 279 => 0x3, 281 => 0x3033, 313 => 0x19, 320 => 0x7, 337 => 0x26, 338 => 0x1003, 347 => [0x3c,0x7,0x58], 355 => 0xf, 356 => 0xe, 367 => [0x115,0xb054], 411 => 'WhiteBalance', 415 => 'WhiteBalance' },
	'whitebalance0' => { 157 => 'WhiteBalance0' },
	'whitebalance1' => { 157 => 'WhiteBalance1' },
	'whitebalance2' => { 157 => 'WhiteBalance2', 258 => 0x500 },
	'whitebalanceadj' => { 94 => 0x20101, 99 => 0x18, 236 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 291 => 0x0 },
	'whitebalancebias' => { 104 => 0x2011, 263 => 0x304, 279 => 0x23 },
	'whitebalanceblue' => { 67 => 0x7 },
	'whitebalancebracket' => { 258 => 0x502, 263 => 0x303 },
	'whitebalancebracketing' => { 164 => 0x22, 167 => 0x2c, 366 => 0x2c },
	'whitebalancecomp' => { 266 => 0x1001 },
	'whitebalancefinetune' => { 114 => 0x100a, 164 => 0x38, 166 => 0x112, 198 => 0xb, 338 => 0x1004, 355 => 0x6, 356 => 0x5, 367 => 0x112 },
	'whitebalancemode' => { 313 => 0x1a },
	'whitebalancered' => { 67 => 0x6 },
	'whitebalanceset' => { 294 => 0xa },
	'whitebalancesetting' => { 164 => 0x23, 355 => 0x5, 356 => 0x4, 357 => 0x16, 371 => 0xd },
	'whitebalancetemperature' => { 258 => 0x501 },
	'whiteboard' => { 263 => 0x301 },
	'whitelevel' => { 109 => 0xc61d, 313 => 0x7e },
	'whitepoint' => { 109 => 0x13e, 313 => 0x201, 431 => 'WhitePoint' },
	'whites2012' => { 411 => 'Whites2012' },
	'wideadapter' => { 338 => 0x1017 },
	'widefocuszone' => { 161 => 0x2f },
	'widerange' => { 346 => 0x20f },
	'windowsatom' => { 410 => 'windowsAtom' },
	'windowsatomextension' => { 410 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 410 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 410 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 425 => 'wordCount' },
	'workcolorspace' => { 94 => 0x10200, 99 => 0x270 },
	'worktodo' => { 417 => 'WorkToDo' },
	'worldtimelocation' => { 279 => 0x3a, 313 => 0x22, 319 => '0.1' },
	'writer-editor' => { 117 => 0x7a },
	'x3filllight' => { 347 => 0x12 },
	'xml' => { 121 => 'xml ' },
	'xmp' => { 97 => 0xffff00f6, 110 => 'XMP' },
	'xmptoolkit' => { 432 => 'xmptk' },
	'xpauthor' => { 109 => 0x9c9d },
	'xpcomment' => { 109 => 0x9c9c },
	'xpkeywords' => { 109 => 0x9c9e },
	'xposition' => { 109 => 0x11e },
	'xpsubject' => { 109 => 0x9c9f },
	'xptitle' => { 109 => 0x9c9b },
	'xresolution' => { 109 => 0x11a, 120 => 0x3, 328 => 0x0, 431 => 'XResolution' },
	'xyresolution' => { 113 => 0x3 },
	'yaw' => { 106 => 0x7 },
	'yawangle' => { 215 => 0x3513, 224 => 0x36fc },
	'ycbcrcoefficients' => { 109 => 0x211, 431 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 109 => 0x213, 431 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 109 => 0x212, 431 => 'YCbCrSubSampling' },
	'yearcreated' => { 125 => 0x10, 134 => 0xc },
	'yield' => { 427 => 'yield' },
	'yposition' => { 109 => 0x11f },
	'yresolution' => { 109 => 0x11b, 120 => 0x5, 328 => 0x4, 431 => 'YResolution' },
	'zonematching' => { 166 => 0x10a, 169 => [0x3a,0x4a], 367 => 0xb024 },
	'zonematchingmode' => { 164 => 0x14 },
	'zonematchingon' => { 163 => 0x75 },
	'zonematchingvalue' => { 355 => 0x1f },
	'zoomedpreviewlength' => { 263 => 0xf05 },
	'zoomedpreviewsize' => { 263 => 0xf06 },
	'zoomedpreviewstart' => { 263 => 0xf04 },
	'zoomsourcewidth' => { 33 => 0x24 },
	'zoomstepcount' => { 261 => 0x300, 263 => 0x100d },
	'zoomtargetwidth' => { 33 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationcontrol' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationcorrparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioncorrparams' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filegroupid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileuserid' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammainfo' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'int16u' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemtags' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestylepc' => 1,
	'picturestyleuserdef' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelshiftinfo' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'poseyawdegrees' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawfiletype' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'serialnumberhash' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecount' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spherical' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stereoscopic3d' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitched' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'variablelowpassfilter' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2016, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
