#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.13';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 98 => 0x69 },
	'about' => { 427 => 'about' },
	'aboutcvterm' => { 419 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 419 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 419 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 419 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 419 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'abspeakaudiofilepath' => { 433 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 73 => 0x518 },
	'accelerometer' => { 339 => 0x3 },
	'accelerometerx' => { 277 => 0x8d },
	'accelerometery' => { 277 => 0x8e },
	'accelerometerz' => { 277 => 0x8c },
	'accessoryserialnumber' => { 277 => 0x54 },
	'accessorytype' => { 277 => 0x53 },
	'acedemicfield' => { 423 => 'acedemicField' },
	'actionadvised' => { 115 => 0x2a },
	'activearea' => { 107 => 0xc68d },
	'actived-lighting' => { 196 => 0x22, 232 => 0x24 },
	'actived-lightingmode' => { 232 => 0x25 },
	'adaptervoltage' => { 121 => 0x407 },
	'addaspectratioinfo' => { 73 => 0x80e },
	'additionalmodelinformation' => { 419 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 73 => 0x80f, 74 => 0x11, 75 => 0x13, 78 => 0x14 },
	'address' => { 142 => 'Address' },
	'adjustmentmode' => { 345 => 0x15 },
	'adlbracketingstep' => { 214 => 0x883 },
	'adlbracketingtype' => { 214 => 0x884 },
	'adobe' => { 108 => 'Adobe' },
	'adultcontentwarning' => { 266 => 'AdultContentWarning', 426 => 'adultContentWarning' },
	'advancedfilter' => { 112 => 0x1201 },
	'advancedraw' => { 234 => 0x76a43203 },
	'advancedscenetype' => { 277 => 0x3d },
	'advisory' => { 431 => 'Advisory' },
	'ae_iso' => { 284 => 0x2, 285 => 0x4, 286 => 0x12 },
	'aeaperture' => { 284 => 0x1, 285 => 0x3, 286 => 0x11 },
	'aeaperturesteps' => { 284 => 0x8, 285 => 0xb },
	'aebautocancel' => { 73 => 0x104 },
	'aebbracketvalue' => { 67 => 0x11 },
	'aebracketingsteps' => { 213 => 0x174c, 214 => 0x87b, 222 => 0x1756 },
	'aebsequence' => { 73 => 0x105 },
	'aebsequenceautocancel' => { 71 => 0x9, 72 => 0x9, 74 => 0x8, 75 => 0x9, 78 => 0x9, 79 => 0x7 },
	'aebshotcount' => { 73 => 0x106 },
	'aebxv' => { 284 => 0x4, 285 => 0x6 },
	'aeerror' => { 285 => 0x8 },
	'aeexposuretime' => { 284 => 0x0, 285 => 0x2, 286 => 0x10 },
	'aelbutton' => { 162 => 0x45 },
	'aelexposureindicator' => { 162 => 0x51 },
	'aelock' => { 162 => 0x5b, 243 => '4.2', 251 => '4.2', 256 => 0x201, 311 => 0x48, 353 => 0x40, 354 => 0x40, 355 => [0x86,0x286] },
	'aelockbutton' => { 241 => '16.1', 243 => '4.1', 245 => '15.1', 246 => '16.1', 247 => '16.1', 249 => '30.1', 250 => '16.1', 251 => '4.1', 253 => '17.1', 254 => '17.1' },
	'aelockbuttonplusdials' => { 241 => '16.2', 249 => '32.1', 253 => '44.1' },
	'aelockformb-d80' => { 254 => '3.1' },
	'aemaxaperture' => { 284 => 0x9, 285 => 0x10, 286 => 0x1c },
	'aemaxaperture2' => { 284 => 0xa, 285 => 0x11, 286 => 0x1d },
	'aemeteringmode' => { 284 => 0xc },
	'aemeteringmode2' => { 284 => '13.1' },
	'aemeteringsegments' => { 165 => 0x628, 311 => 0x209 },
	'aemicroadjustment' => { 73 => 0x110 },
	'aeminaperture' => { 284 => 0xb, 285 => 0x12, 286 => 0x1e },
	'aeminexposuretime' => { 284 => 0x5, 285 => 0x13, 286 => 0x1f },
	'aeprogrammode' => { 284 => 0x6 },
	'aeprojectlink' => { 408 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 408 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 408 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 408 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 408 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 408 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 31 => 0x21 },
	'aewhitebalance' => { 284 => 0xd },
	'aexv' => { 284 => 0x3, 285 => 0x5 },
	'af-cpriorityselection' => { 241 => '1.1', 242 => '1.1', 244 => '1.1', 246 => '0.1', 247 => '0.1', 248 => '0.1', 249 => '1.1', 250 => '0.1', 253 => '1.1' },
	'af-onbutton' => { 244 => '70.1' },
	'af-onformb-d10' => { 241 => '3.3', 249 => '3.2' },
	'af-onformb-d11' => { 250 => '2.2' },
	'af-onformb-d12' => { 253 => '50.1' },
	'af-spriorityselection' => { 241 => '1.2', 242 => '1.2', 244 => '1.4', 248 => '0.2', 249 => '1.2', 250 => '0.2', 253 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 241 => '2.1', 242 => '2.1', 244 => '78.3', 249 => '2.1', 253 => '2.1' },
	'afadjustment' => { 311 => 0x72 },
	'afandmeteringbuttons' => { 73 => 0x701 },
	'afaperture' => { 192 => 0x5, 193 => 0x5 },
	'afareaheight' => { 171 => 0x1a },
	'afareaillumination' => { 162 => 0x4b, 251 => '15.3' },
	'afareamode' => { 158 => 0x33, 162 => 0xe, 170 => 0x0, 171 => 0x5, 277 => 0xf, 336 => 0x1205, 346 => [0xa,0x3a], 353 => 0x11, 354 => 0x10, 355 => 0x24, 365 => 0xb043, 385 => 0x17 },
	'afareamodesetting' => { 243 => '11.1', 245 => '0.1', 251 => '16.1', 254 => '2.1', 365 => 0x201c },
	'afareas' => { 256 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 73 => 0x51b },
	'afareawidth' => { 171 => 0x18 },
	'afareaxposition' => { 171 => 0x14, 336 => 0x1203 },
	'afareaxposition1' => { 336 => 0x1201 },
	'afareayposition' => { 171 => 0x16, 336 => 0x1204 },
	'afareayposition1' => { 336 => 0x1202 },
	'afassist' => { 71 => 0x5, 79 => 0x5, 162 => 0x48, 241 => '2.5', 243 => '0.2', 245 => '0.2', 246 => '1.1', 247 => '1.1', 248 => '1.3', 249 => '2.4', 250 => '1.3', 251 => '0.2', 253 => '2.4', 254 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 73 => 0x50e, 74 => 0x4, 75 => 0x5, 76 => 0x4, 77 => 0x4, 78 => 0x5 },
	'afassistlamp' => { 277 => 0x31 },
	'afbuttonpressed' => { 355 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 287 => 0x6 },
	'afduringliveview' => { 73 => 0x511 },
	'affinea' => { 402 => 'AffineA' },
	'affineb' => { 402 => 'AffineB' },
	'affinec' => { 402 => 'AffineC' },
	'affined' => { 402 => 'AffineD' },
	'affinetune' => { 172 => 0x0, 256 => 0x306 },
	'affinetuneadj' => { 172 => 0x2, 206 => 0x2d1, 207 => 0x2dc, 256 => 0x307 },
	'affinetuneindex' => { 172 => 0x1 },
	'affinex' => { 402 => 'AffineX' },
	'affiney' => { 402 => 'AffineY' },
	'afhold' => { 287 => 0x1fd },
	'afilluminator' => { 353 => 0x29, 365 => 0xb044 },
	'afimageheight' => { 171 => 0x12 },
	'afimagewidth' => { 171 => 0x10 },
	'afintegrationtime' => { 287 => 0x7 },
	'afmicroadj' => { 346 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 350 => 0x131 },
	'afmicroadjregisteredlenses' => { 350 => '305.1' },
	'afmicroadjustment' => { 73 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 350 => 0x130 },
	'afmode' => { 102 => 0x3009, 112 => 0x1022, 158 => 0x16, 345 => 0x5 },
	'afmoderestrictions' => { 242 => '50.3', 244 => '48.3', 253 => '48.3' },
	'afonaelockbuttonswitch' => { 73 => 0x702 },
	'afonbutton' => { 241 => '3.1', 242 => '47.1' },
	'afpoint' => { 31 => 0x13, 101 => 0x18, 158 => 0x15, 170 => 0x1, 259 => 0x308, 345 => 0x1f, 346 => [0x37,0x7], 350 => 0x19, 351 => 0x18, 352 => [0x18,0x20] },
	'afpointactivationarea' => { 72 => 0x11, 78 => 0x11 },
	'afpointareaexpansion' => { 73 => 0x508 },
	'afpointatshutterrelease' => { 346 => [0x39,0x9] },
	'afpointautoselection' => { 73 => 0x50b },
	'afpointbrightness' => { 73 => 0x50d, 241 => '2.4', 242 => '46.5', 244 => '2.2', 253 => '2.3' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 73 => 0x50c },
	'afpointillumination' => { 72 => 0xa, 241 => '2.3', 242 => '46.2', 244 => '47.2', 248 => '1.2', 249 => '2.3', 250 => '1.2', 253 => '47.2', 254 => '2.4' },
	'afpointinfocus' => { 346 => [0x38,0x8] },
	'afpointmode' => { 292 => 0x3 },
	'afpointposition' => { 102 => 0x2021, 277 => 0x4d },
	'afpointregistration' => { 71 => 0x7 },
	'afpoints' => { 161 => 0x10 },
	'afpointselected' => { 162 => 0xd, 256 => 0x305, 311 => 0xe, 350 => 0x15, 351 => 0x14, 352 => [0x14,0x1c], 365 => 0x201e },
	'afpointselected2' => { 292 => 0x4 },
	'afpointselection' => { 72 => 0xb, 241 => '1.3', 242 => '1.3', 249 => '1.3', 253 => '1.3' },
	'afpointselectionmethod' => { 73 => 0x50f, 74 => 0xc, 75 => 0xd, 78 => 0xd },
	'afpointsetting' => { 353 => 0x12, 354 => 0x11 },
	'afpointsinfocus' => { 67 => 0xe, 170 => 0x2, 287 => 0xb, 288 => 0x4, 311 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 72 => 0xd },
	'afpointsselected' => { 288 => '4.1', 392 => 0x4 },
	'afpointsspecial' => { 288 => '4.2' },
	'afpointsunknown1' => { 287 => 0x0 },
	'afpointsunknown2' => { 287 => 0x2 },
	'afpointsused' => { 171 => 0x8, 346 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 287 => 0x4 },
	'afresponse' => { 196 => 0xad },
	'afresult' => { 261 => 0x1038 },
	'afsearch' => { 256 => 0x303 },
	'afsensoractive' => { 158 => 0x1 },
	'afstatus' => { 336 => 0x1200 },
	'afstatus_00_b4' => { 349 => 0x0 },
	'afstatus_01_c4' => { 349 => 0x2 },
	'afstatus_02_d4' => { 349 => 0x4 },
	'afstatus_03_e4' => { 349 => 0x6 },
	'afstatus_04_f4' => { 349 => 0x8 },
	'afstatus_05_g4' => { 349 => 0xa },
	'afstatus_06_h4' => { 349 => 0xc },
	'afstatus_07_b3' => { 349 => 0xe },
	'afstatus_08_c3' => { 349 => 0x10 },
	'afstatus_09_d3' => { 349 => 0x12 },
	'afstatus_10_e3' => { 349 => 0x14 },
	'afstatus_11_f3' => { 349 => 0x16 },
	'afstatus_12_g3' => { 349 => 0x18 },
	'afstatus_13_h3' => { 349 => 0x1a },
	'afstatus_14_b2' => { 349 => 0x1c },
	'afstatus_15_c2' => { 349 => 0x1e },
	'afstatus_16_d2' => { 349 => 0x20 },
	'afstatus_17_e2' => { 349 => 0x22 },
	'afstatus_18_f2' => { 349 => 0x24 },
	'afstatus_19_g2' => { 349 => 0x26 },
	'afstatus_20_h2' => { 349 => 0x28 },
	'afstatus_21_c1' => { 349 => 0x2a },
	'afstatus_22_d1' => { 349 => 0x2c },
	'afstatus_23_e1' => { 349 => 0x2e },
	'afstatus_24_f1' => { 349 => 0x30 },
	'afstatus_25_g1' => { 349 => 0x32 },
	'afstatus_26_a7_vertical' => { 349 => 0x34 },
	'afstatus_27_a6_vertical' => { 349 => 0x36 },
	'afstatus_28_a5_vertical' => { 349 => 0x38 },
	'afstatus_29_c7_vertical' => { 349 => 0x3a },
	'afstatus_30_c6_vertical' => { 349 => 0x3c },
	'afstatus_31_c5_vertical' => { 349 => 0x3e },
	'afstatus_32_e7_vertical' => { 349 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 349 => 0x42 },
	'afstatus_34_e5_vertical' => { 349 => 0x44 },
	'afstatus_35_g7_vertical' => { 349 => 0x46 },
	'afstatus_36_g6_vertical' => { 349 => 0x48 },
	'afstatus_37_g5_vertical' => { 349 => 0x4a },
	'afstatus_38_i7_vertical' => { 349 => 0x4c },
	'afstatus_39_i6_vertical' => { 349 => 0x4e },
	'afstatus_40_i5_vertical' => { 349 => 0x50 },
	'afstatus_41_a7' => { 349 => 0x52 },
	'afstatus_42_b7' => { 349 => 0x54 },
	'afstatus_43_c7' => { 349 => 0x56 },
	'afstatus_44_d7' => { 349 => 0x58 },
	'afstatus_45_e7' => { 349 => 0x5a },
	'afstatus_46_f7' => { 349 => 0x5c },
	'afstatus_47_g7' => { 349 => 0x5e },
	'afstatus_48_h7' => { 349 => 0x60 },
	'afstatus_49_i7' => { 349 => 0x62 },
	'afstatus_50_a6' => { 349 => 0x64 },
	'afstatus_51_b6' => { 349 => 0x66 },
	'afstatus_52_c6' => { 349 => 0x68 },
	'afstatus_53_d6' => { 349 => 0x6a },
	'afstatus_54_e6_center' => { 349 => 0x6c },
	'afstatus_55_f6' => { 349 => 0x6e },
	'afstatus_56_g6' => { 349 => 0x70 },
	'afstatus_57_h6' => { 349 => 0x72 },
	'afstatus_58_i6' => { 349 => 0x74 },
	'afstatus_59_a5' => { 349 => 0x76 },
	'afstatus_60_b5' => { 349 => 0x78 },
	'afstatus_61_c5' => { 349 => 0x7a },
	'afstatus_62_d5' => { 349 => 0x7c },
	'afstatus_63_e5' => { 349 => 0x7e },
	'afstatus_64_f5' => { 349 => 0x80 },
	'afstatus_65_g5' => { 349 => 0x82 },
	'afstatus_66_h5' => { 349 => 0x84 },
	'afstatus_67_i5' => { 349 => 0x86 },
	'afstatus_68_c11' => { 349 => 0x88 },
	'afstatus_69_d11' => { 349 => 0x8a },
	'afstatus_70_e11' => { 349 => 0x8c },
	'afstatus_71_f11' => { 349 => 0x8e },
	'afstatus_72_g11' => { 349 => 0x90 },
	'afstatus_73_b10' => { 349 => 0x92 },
	'afstatus_74_c10' => { 349 => 0x94 },
	'afstatus_75_d10' => { 349 => 0x96 },
	'afstatus_76_e10' => { 349 => 0x98 },
	'afstatus_77_f10' => { 349 => 0x9a },
	'afstatus_78_g10' => { 349 => 0x9c },
	'afstatus_79_h10' => { 349 => 0x9e },
	'afstatus_80_b9' => { 349 => 0xa0 },
	'afstatus_81_c9' => { 349 => 0xa2 },
	'afstatus_82_d9' => { 349 => 0xa4 },
	'afstatus_83_e9' => { 349 => 0xa6 },
	'afstatus_84_f9' => { 349 => 0xa8 },
	'afstatus_85_g9' => { 349 => 0xaa },
	'afstatus_86_h9' => { 349 => 0xac },
	'afstatus_87_b8' => { 349 => 0xae },
	'afstatus_88_c8' => { 349 => 0xb0 },
	'afstatus_89_d8' => { 349 => 0xb2 },
	'afstatus_90_e8' => { 349 => 0xb4 },
	'afstatus_91_f8' => { 349 => 0xb6 },
	'afstatus_92_g8' => { 349 => 0xb8 },
	'afstatus_93_h8' => { 349 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 349 => 0xbc },
	'afstatusactivesensor' => { 158 => 0x2, 346 => [0x4,0x3b], 350 => 0x1e, 351 => 0x1b, 352 => [0x1b,0x21] },
	'afstatusbottom' => { 158 => 0x8, 350 => 0x2a, 351 => 0x21, 352 => 0x21 },
	'afstatusbottom-left' => { 158 => 0x12, 351 => 0x2b, 352 => 0x2b },
	'afstatusbottom-right' => { 158 => 0x6, 351 => 0x1f, 352 => 0x1f },
	'afstatusbottomassist-left' => { 350 => 0x28 },
	'afstatusbottomassist-right' => { 350 => 0x2c },
	'afstatusbottomhorizontal' => { 347 => 0x10, 348 => 0x1c },
	'afstatusbottomvertical' => { 347 => 0x16, 348 => 0x26 },
	'afstatuscenter-10' => { 350 => 0x34 },
	'afstatuscenter-11' => { 350 => 0x36 },
	'afstatuscenter-12' => { 350 => 0x38 },
	'afstatuscenter-14' => { 350 => 0x3c },
	'afstatuscenter-7' => { 350 => 0x2e },
	'afstatuscenter-9' => { 350 => 0x32 },
	'afstatuscenter-horizontal' => { 350 => 0x30 },
	'afstatuscenter-vertical' => { 350 => 0x3a },
	'afstatuscenterf2-8' => { 350 => 0x4c },
	'afstatuscenterhorizontal' => { 158 => 0x2f, 347 => 0xc, 348 => 0x18, 351 => 0x2f, 352 => 0x2f },
	'afstatuscentervertical' => { 158 => 0xc, 347 => 0x14, 348 => 0x22, 351 => 0x25, 352 => 0x25 },
	'afstatusfarleft' => { 347 => 0x6, 350 => 0x26 },
	'afstatusfarlefthorizontal' => { 348 => 0x4 },
	'afstatusfarleftvertical' => { 348 => 0x12 },
	'afstatusfarright' => { 347 => 0x18, 350 => 0x44 },
	'afstatusfarrighthorizontal' => { 348 => 0x2c },
	'afstatusfarrightvertical' => { 348 => 0x34 },
	'afstatusleft' => { 158 => 0x2d, 347 => 0x2, 350 => 0x22, 351 => 0x2d, 352 => 0x2d },
	'afstatuslefthorizontal' => { 348 => 0x6 },
	'afstatusleftvertical' => { 348 => 0xe },
	'afstatuslower-left' => { 347 => 0x4, 350 => 0x24 },
	'afstatuslower-lefthorizontal' => { 348 => 0xa },
	'afstatuslower-leftvertical' => { 348 => 0x10 },
	'afstatuslower-middle' => { 347 => 0x22, 348 => 0x24 },
	'afstatuslower-right' => { 347 => 0x1e, 350 => 0x4a },
	'afstatuslower-righthorizontal' => { 348 => 0x32 },
	'afstatuslower-rightvertical' => { 348 => 0x3a },
	'afstatuslowerfarleft' => { 348 => 0x8 },
	'afstatuslowerfarright' => { 348 => 0x30 },
	'afstatusmiddlehorizontal' => { 158 => 0xa, 351 => 0x23, 352 => 0x23 },
	'afstatusnearleft' => { 347 => 0xe, 348 => 0x1a },
	'afstatusnearright' => { 347 => 0xa, 348 => 0x16 },
	'afstatusright' => { 158 => 0x31, 347 => 0x1c, 350 => 0x48, 351 => 0x31, 352 => 0x31 },
	'afstatusrighthorizontal' => { 348 => 0x2e },
	'afstatusrightvertical' => { 348 => 0x38 },
	'afstatustop' => { 158 => 0xe, 350 => 0x40, 351 => 0x27, 352 => 0x27 },
	'afstatustop-left' => { 158 => 0x10, 351 => 0x29, 352 => 0x29 },
	'afstatustop-right' => { 158 => 0x4, 351 => 0x1d, 352 => 0x1d },
	'afstatustopassist-left' => { 350 => 0x3e },
	'afstatustopassist-right' => { 350 => 0x42 },
	'afstatustophorizontal' => { 347 => 0x8, 348 => 0x14 },
	'afstatustopvertical' => { 347 => 0x12, 348 => 0x1e },
	'afstatusupper-left' => { 347 => 0x0, 350 => 0x20 },
	'afstatusupper-lefthorizontal' => { 348 => 0x2 },
	'afstatusupper-leftvertical' => { 348 => 0xc },
	'afstatusupper-middle' => { 347 => 0x20, 348 => 0x20 },
	'afstatusupper-right' => { 347 => 0x1a, 350 => 0x46 },
	'afstatusupper-righthorizontal' => { 348 => 0x2a },
	'afstatusupper-rightvertical' => { 348 => 0x36 },
	'afstatusupperfarleft' => { 348 => 0x0 },
	'afstatusupperfarright' => { 348 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 346 => 0x2 },
	'afwithshutter' => { 353 => 0x2a },
	'afzoneselected' => { 365 => 0x201e },
	'aggregateissuenumber' => { 423 => 'aggregateIssueNumber' },
	'aggregationtype' => { 423 => 'aggregationType' },
	'agreement' => { 426 => 'agreement' },
	'aiservocontinuousshooting' => { 72 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 73 => 0x519 },
	'aiservoimagepriority' => { 73 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 73 => 0x51a },
	'aiservotrackingmethod' => { 73 => 0x504 },
	'aiservotrackingsensitivity' => { 72 => 0x14, 73 => 0x502 },
	'album' => { 433 => 'album' },
	'alreadyapplied' => { 409 => 'AlreadyApplied' },
	'alternatetitle' => { 423 => 'alternateTitle' },
	'alternatetitlea-lang' => { 423 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 423 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 423 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 173 => 0x6 },
	'alttapename' => { 433 => 'altTapeName' },
	'alttimecode' => { 433 => 'altTimecode' },
	'alttimecodetimeformat' => { 433 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 433 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 433 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 332 => 0x14, 385 => 0x4 },
	'ambienttemperaturefahrenheit' => { 332 => 0x13 },
	'analogbalance' => { 107 => 0xc627 },
	'angleadj' => { 92 => 0x10003, 98 => 0x8b },
	'angleinforoll' => { 404 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 404 => 'AngleInfoYaw' },
	'anti-blur' => { 365 => 0xb04b },
	'antialiasstrength' => { 107 => 0xc632 },
	'aperturelock' => { 242 => '38.2', 244 => '38.2', 253 => '38.2' },
	'aperturerange' => { 73 => 0x10d },
	'apertureringuse' => { 292 => '1.4' },
	'aperturesetting' => { 162 => 0x7, 353 => 0x30, 354 => 0x29, 355 => 0x1 },
	'aperturevalue' => { 82 => 0x2, 107 => 0x9202, 261 => 0x1002, 320 => 0x401, 413 => 'ApertureValue' },
	'applekeywords' => { 265 => 'AAPL:Keywords' },
	'applicationnotes' => { 107 => 0x2bc, 281 => 0x2bc },
	'applicationrecordversion' => { 115 => 0x0 },
	'applyshootingmeteringmode' => { 73 => 0x10e },
	'approved' => { 415 => 'Approved' },
	'approvedby' => { 415 => 'ApprovedBy' },
	'approximatefnumber' => { 273 => 0x313, 279 => 0x3406 },
	'approximatefocusdistance' => { 405 => 'ApproximateFocusDistance' },
	'aquahsl' => { 92 => 0x20913 },
	'armidentifier' => { 116 => 0x78 },
	'armversion' => { 116 => 0x7a },
	'artfilter' => { 256 => 0x529 },
	'artfiltereffect' => { 256 => 0x52f },
	'artist' => { 107 => 0x13b, 269 => 'Artist', 311 => 0x22e, 429 => 'Artist', 433 => 'artist' },
	'artmode' => { 102 => 0x301b },
	'artmodeparameters' => { 102 => 0x310b },
	'artworkcircadatecreated' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontributiondescription' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 419 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworkscontentdescription' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworksource' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 419 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 260 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 260 => 0x1112, 311 => 0x80, 353 => 0x55, 354 => 0x55, 355 => 0xa },
	'asshoticcprofile' => { 107 => 0xc68f },
	'asshotneutral' => { 107 => 0xc628 },
	'asshotpreprofilematrix' => { 107 => 0xc690 },
	'asshotprofilename' => { 107 => 0xc6f6 },
	'asshotwhitexy' => { 107 => 0xc629 },
	'assignbktbutton' => { 241 => '4.2', 242 => '16.1', 244 => '16.1', 253 => '16.1' },
	'assignfuncbutton' => { 73 => 0x70b },
	'assignmb-d17af-onbutton' => { 244 => '79.1' },
	'assignmb-d17funcbutton' => { 244 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 244 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 244 => '75.1' },
	'assignmoviefunc2button' => { 244 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 244 => '75.2' },
	'assignmovierecordbutton' => { 242 => '43.2', 253 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 244 => '45.1' },
	'assignmoviesubselector' => { 244 => '74.1' },
	'assignmoviesubselectorplusdials' => { 244 => '76.1' },
	'assignremotefnbutton' => { 242 => '54.1', 253 => '51.1' },
	'assistbuttonfunction' => { 71 => 0xd },
	'attributionname' => { 406 => 'attributionName' },
	'attributionurl' => { 406 => 'attributionURL' },
	'audio' => { 277 => 0x20 },
	'audiobitrate' => { 58 => 0x6c },
	'audiochannels' => { 58 => 0x70 },
	'audiochanneltype' => { 433 => 'audioChannelType' },
	'audiocompression' => { 136 => 'Compression' },
	'audiocompressor' => { 433 => 'audioCompressor' },
	'audioduration' => { 115 => 0x99 },
	'audiomoddate' => { 433 => 'audioModDate' },
	'audiooutcue' => { 115 => 0x9a },
	'audiosamplerate' => { 58 => 0x6e, 433 => 'audioSampleRate' },
	'audiosampletype' => { 433 => 'audioSampleType' },
	'audiosamplingrate' => { 115 => 0x97 },
	'audiosamplingresolution' => { 115 => 0x98 },
	'audiotype' => { 115 => 0x96 },
	'author' => { 138 => 'Author', 265 => 'Author', 269 => 'Author', 327 => 'Author', 403 => 'author', 420 => 'Author', 431 => 'Author' },
	'authorsposition' => { 421 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 73 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 302 => '0.1' },
	'autobracket' => { 345 => 0x19 },
	'autobracketing' => { 112 => 0x1100, 311 => 0x18, 336 => 0x1007 },
	'autobracketingmode' => { 252 => '12.3' },
	'autobracketingset' => { 252 => '12.1' },
	'autobracketmodem' => { 241 => '21.2', 242 => '13.3', 244 => '13.2', 249 => '26.2', 253 => '13.3' },
	'autobracketorder' => { 162 => 0x43, 241 => '21.3', 242 => '13.2', 244 => '13.1', 249 => '26.3', 250 => '12.2', 251 => '2.2', 252 => '12.2', 253 => '13.2', 254 => '13.2' },
	'autobracketset' => { 241 => '21.1', 242 => '13.1', 245 => '11.1', 246 => '12.1', 247 => '12.1', 249 => '26.1', 250 => '12.1', 251 => '2.1', 253 => '13.1', 254 => '13.1' },
	'autobrightness' => { 409 => 'AutoBrightness' },
	'autocontrast' => { 409 => 'AutoContrast' },
	'autodistortioncontrol' => { 181 => 0x4 },
	'autodynamicrange' => { 112 => 0x140b },
	'autoexposure' => { 409 => 'AutoExposure' },
	'autoexposurebracketing' => { 67 => 0x10 },
	'autoflashisosensitivity' => { 244 => '38.5' },
	'autofocus' => { 259 => 0x209 },
	'autofp' => { 251 => '7.3', 254 => '31.4' },
	'autoiso' => { 67 => 0x1, 102 => 0x3008, 243 => '1.1', 251 => '1.1' },
	'autoisomax' => { 243 => '1.2', 251 => '1.2' },
	'autoisominshutterspeed' => { 243 => '1.3', 251 => '1.3' },
	'autolateralca' => { 409 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 54 => 0x2, 73 => 0x204, 92 => 0x20500, 98 => 0x6f },
	'autolightingoptimizeron' => { 92 => '0x20500.0', 98 => 0x6e },
	'autoportraitframed' => { 365 => 0x2016 },
	'autoredeye' => { 234 => 0xfe28a44f },
	'autorotate' => { 67 => 0x1b },
	'autoshadows' => { 409 => 'AutoShadows' },
	'autowhiteversion' => { 409 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 196 => 0x82 },
	'avaperturesetting' => { 292 => 0x13 },
	'averageblacklevel' => { 38 => 0xe7, 40 => 0xfb, 41 => 0x114, 42 => 0x146 },
	'averagelv' => { 165 => 0x38 },
	'avsettingwithoutlens' => { 73 => 0x707 },
	'azimuth' => { 146 => 'Azimuth' },
	'babyage' => { 277 => [0x8010,0x33] },
	'babyname' => { 277 => 0x66 },
	'backgroundalpha' => { 428 => 'bgalpha' },
	'baseexposurecompensation' => { 292 => 0x15 },
	'baseiso' => { 67 => 0x2, 86 => 0x101c, 121 => 0x903, 279 => 0x312a, 390 => 0x6 },
	'baselineexposure' => { 107 => 0xc62a },
	'baselineexposureoffset' => { 107 => 0xc7a5 },
	'baselinenoise' => { 107 => 0xc62b },
	'baselinesharpness' => { 107 => 0xc62c },
	'baseurl' => { 431 => 'BaseURL' },
	'batterylevel' => { 353 => 0x51, 357 => 0xc, 358 => 0x4, 359 => 0x4, 391 => 0x7 },
	'batterylevelgrip1' => { 391 => 0x6 },
	'batterylevelgrip2' => { 391 => 0x8 },
	'batteryorder' => { 241 => '12.5', 249 => '13.2', 250 => '2.1', 253 => '3.1' },
	'batterystate' => { 162 => 0x60, 353 => 0x50, 359 => 0x14 },
	'batterytemperature' => { 357 => 0x1, 359 => 0x2, 391 => 0x5 },
	'batteryunknown' => { 357 => 0x2, 359 => 0x0 },
	'batteryvoltage' => { 121 => 0x408, 332 => 0x2a, 357 => 0x8 },
	'batteryvoltage1' => { 359 => 0x6 },
	'batteryvoltage2' => { 359 => 0x8 },
	'bayergreensplit' => { 107 => 0xc62d },
	'bayerpattern' => { 120 => 0xf902, 166 => 0x17 },
	'beatspliceparams' => { 433 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 433 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 433 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 433 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 433 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 433 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 241 => '13.1', 242 => '5.4', 243 => '0.1', 245 => '2.1', 246 => '3.1', 247 => '3.1', 249 => '10.1', 251 => '0.1', 253 => '5.5', 254 => '4.1' },
	'beeppitch' => { 250 => '3.1' },
	'beepvolume' => { 250 => '4.5' },
	'bestqualityscale' => { 107 => 0xc65c },
	'bestshotmode' => { 102 => 0x3007 },
	'bitdepth' => { 143 => 'BitDepth', 166 => 0x11, 203 => 0x41 },
	'bitspercomponent' => { 117 => 0x87 },
	'bitspersample' => { 107 => 0x102, 429 => 'BitsPerSample' },
	'blacklevel' => { 107 => 0xc61a, 196 => 0x3d, 261 => [0x401,0x1012], 320 => 0x21d },
	'blacklevel1' => { 281 => 0x8 },
	'blacklevel2' => { 260 => 0x600, 264 => 0x600, 281 => 0x9 },
	'blacklevel3' => { 281 => 0xa },
	'blacklevelblue' => { 281 => 0x1e },
	'blackleveldata' => { 320 => 0x223 },
	'blackleveldeltah' => { 107 => 0xc61b },
	'blackleveldeltav' => { 107 => 0xc61c },
	'blacklevelgreen' => { 281 => 0x1d },
	'blacklevelred' => { 281 => 0x1c },
	'blacklevelrepeatdim' => { 107 => 0xc619 },
	'blackpoint' => { 311 => 0x200 },
	'blacks2012' => { 409 => 'Blacks2012' },
	'bleachbypasstoning' => { 311 => 0x7f },
	'blockshotafresponse' => { 244 => '1.5' },
	'blogtitle' => { 423 => 'blogTitle' },
	'blogurl' => { 423 => 'blogURL' },
	'bluebalance' => { 179 => 0x271, 261 => 0x1018, 281 => 0x12, 311 => 0x1b },
	'bluecurvelimits' => { 97 => 0x1fe },
	'bluecurvepoints' => { 96 => 0x79, 97 => 0x1d4 },
	'bluehsl' => { 92 => [0x20914,0x20915] },
	'bluehue' => { 409 => 'BlueHue' },
	'bluesaturation' => { 409 => 'BlueSaturation' },
	'blurcontrol' => { 311 => 0x82 },
	'blurwarning' => { 112 => 0x1300 },
	'bodybatteryadload' => { 290 => 0x3 },
	'bodybatteryadnoload' => { 290 => 0x2 },
	'bodybatterystate' => { 290 => '1.1' },
	'bodybatteryvoltage1' => { 290 => 0x2 },
	'bodybatteryvoltage2' => { 290 => 0x4 },
	'bodybatteryvoltage3' => { 290 => 0x6 },
	'bodybatteryvoltage4' => { 290 => 0x8 },
	'bodyfirmware' => { 337 => 0x0 },
	'bodyfirmwareversion' => { 257 => 0x104, 258 => 0x100, 261 => 0x104 },
	'bodyserialnumber' => { 337 => 0x10 },
	'bookedition' => { 423 => 'bookEdition' },
	'bracketmode' => { 49 => 0x3 },
	'bracketsequence' => { 102 => 0x301d },
	'bracketsettings' => { 277 => 0x45 },
	'bracketshotnumber' => { 49 => 0x5, 292 => 0x9, 364 => 0x2b },
	'bracketshotnumber2' => { 364 => 0x2d },
	'bracketstep' => { 159 => 0xe },
	'bracketvalue' => { 49 => 0x4 },
	'brightness' => { 107 => 0xfe53, 137 => 'Brightness', 155 => 'Brightness', 159 => 0x2c, 198 => 0x34, 199 => 0x39, 332 => 0x25, 353 => 0x22, 365 => 0x2007, 409 => 'Brightness' },
	'brightnessadj' => { 97 => 0x114, 227 => 0x0, 237 => 0x2d, 394 => 0x8018 },
	'brightnessvalue' => { 107 => 0x9203, 165 => [0x691,0x49c3], 261 => 0x1003, 369 => 0x1e, 372 => 0x1140, 373 => 0x1140, 374 => 0x111c, 375 => 0x1198, 376 => 0x1174, 377 => 0x102c, 378 => 0x224, 379 => 0x224, 413 => 'BrightnessValue' },
	'bulbduration' => { 67 => 0x18 },
	'burstmode' => { 123 => 0xa, 277 => 0x2a },
	'burstmode2' => { 123 => 0x18 },
	'burstshot' => { 345 => 0x34 },
	'burstspeed' => { 277 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 73 => 0x70a },
	'bwfilter' => { 159 => 0x2a, 167 => 0x39 },
	'bwmode' => { 261 => 0x203 },
	'by-line' => { 115 => 0x50 },
	'by-linetitle' => { 115 => 0x55 },
	'bytecount' => { 423 => 'byteCount' },
	'calibration' => { 345 => [0x24,0x30] },
	'calibrationilluminant1' => { 107 => 0xc65a },
	'calibrationilluminant2' => { 107 => 0xc65b },
	'cameraangle' => { 433 => 'cameraAngle' },
	'cameracalibration1' => { 107 => 0xc623 },
	'cameracalibration2' => { 107 => 0xc624 },
	'cameracalibrationsig' => { 107 => 0xc6f3 },
	'cameracolorcalibration01' => { 33 => 0x0, 39 => 0xba },
	'cameracolorcalibration02' => { 33 => 0x4, 39 => 0xbf },
	'cameracolorcalibration03' => { 33 => 0x8, 39 => 0xc4 },
	'cameracolorcalibration04' => { 33 => 0xc, 39 => 0xc9 },
	'cameracolorcalibration05' => { 33 => 0x10, 39 => 0xce },
	'cameracolorcalibration06' => { 33 => 0x14, 39 => 0xd3 },
	'cameracolorcalibration07' => { 33 => 0x18, 39 => 0xd8 },
	'cameracolorcalibration08' => { 33 => 0x1c, 39 => 0xdd },
	'cameracolorcalibration09' => { 33 => 0x20, 39 => 0xe2 },
	'cameracolorcalibration10' => { 33 => 0x24, 39 => 0xe7 },
	'cameracolorcalibration11' => { 33 => 0x28, 39 => 0xec },
	'cameracolorcalibration12' => { 33 => 0x2c, 39 => 0xf1 },
	'cameracolorcalibration13' => { 33 => 0x30, 39 => 0xf6 },
	'cameracolorcalibration14' => { 33 => 0x34, 39 => 0xfb },
	'cameracolorcalibration15' => { 33 => 0x38, 39 => 0x100 },
	'camerae-mountversion' => { 393 => 0xb },
	'cameraid' => { 261 => 0x209, 344 => 0x209 },
	'cameraiso' => { 31 => 0x10 },
	'cameralabel' => { 107 => 0xc7a1, 433 => 'cameraLabel' },
	'cameramodel' => { 320 => 0x410, 433 => 'cameraModel' },
	'cameramodelid' => { 155 => 'CameraModelID' },
	'cameramove' => { 433 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 26 => 0x35, 277 => 0x8f, 315 => 0x1, 320 => 0x100, 359 => [0x16,0x18], 382 => 0x28, 383 => 0x24, 384 => 0x29 },
	'cameraowner' => { 124 => 0xc353 },
	'cameraparameters' => { 261 => 0x2050 },
	'camerapicturestyle' => { 26 => 0xaf },
	'camerapitch' => { 104 => 0x9 },
	'cameraprofile' => { 409 => 'CameraProfile' },
	'cameraprofiledigest' => { 409 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 98 => 0xe1 },
	'camerarawcontrast' => { 98 => 0xe3 },
	'camerarawhighlightpoint' => { 98 => 0xe6 },
	'camerarawlinear' => { 98 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 98 => 0xe8 },
	'camerarawoutputshadowpoint' => { 98 => 0xe9 },
	'camerarawsaturation' => { 98 => 0xe2 },
	'camerarawshadowpoint' => { 98 => 0xe7 },
	'camerarawsharpness' => { 98 => 0xe5 },
	'cameraroll' => { 104 => 0xb },
	'cameraserialnumber' => { 107 => 0xc62f, 157 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 256 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x19, 27 => [0x87,0x91], 28 => [0x99,0x9f,0xa4,0xa8,0x105], 30 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 67 => 0xc, 121 => 0x406, 260 => 0x1306, 273 => 0x320, 279 => 0x3402, 311 => 0x47, 342 => 0x43, 386 => 0x5 },
	'cameratemperature4' => { 316 => 0x14 },
	'cameratemperature5' => { 316 => 0x16 },
	'cameratemperaturerangemax' => { 109 => 0x5 },
	'cameratemperaturerangemin' => { 109 => 0x6 },
	'cameratype' => { 67 => 0x1a, 261 => 0x207 },
	'cameratype2' => { 257 => 0x100 },
	'camerayaw' => { 104 => 0xa },
	'canondr4' => { 108 => 'CanonDR4' },
	'canonexposuremode' => { 31 => 0x14 },
	'canonfiledescription' => { 86 => 0x805 },
	'canonfilelength' => { 55 => 0xe },
	'canonfirmwareversion' => { 55 => 0x7, 86 => 0x80b },
	'canonflashinfo' => { 86 => 0x1028 },
	'canonflashmode' => { 31 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 31 => 0xa },
	'canonimagetype' => { 55 => 0x6, 86 => 0x815 },
	'canonmodelid' => { 55 => 0x10, 86 => 0x1834 },
	'canonvrd' => { 108 => 'CanonVRD' },
	'caption' => { 403 => 'caption' },
	'caption-abstract' => { 115 => 0x78 },
	'captionsauthornames' => { 412 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 412 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 421 => 'CaptionWriter' },
	'captureframerate' => { 102 => 0x4001 },
	'capturesoftware' => { 398 => 'CaptureSoftware' },
	'cardshutterlock' => { 162 => 0x49 },
	'casioimagesize' => { 102 => 0x9 },
	'catalogsets' => { 115 => 0xff, 397 => 'CatalogSets', 401 => 'CatalogSets' },
	'categories' => { 55 => 0x23, 403 => 'categories' },
	'category' => { 115 => 0xf, 255 => 0x30, 421 => 'Category' },
	'cbcrgain' => { 342 => 0xa036 },
	'cbcrgaindefault' => { 342 => 0xa035 },
	'cbcrmatrix' => { 342 => 0xa034 },
	'cbcrmatrixdefault' => { 342 => 0xa033 },
	'ccdboardversion' => { 273 => 0x331 },
	'ccdscanmode' => { 261 => 0x1039 },
	'ccdsensitivity' => { 224 => 0x6 },
	'ccdversion' => { 273 => 0x330 },
	'cellglobalid' => { 407 => 'cgi' },
	'celllength' => { 107 => 0x109 },
	'cellr' => { 407 => 'r' },
	'celltowerid' => { 407 => 'cellid' },
	'cellwidth' => { 107 => 0x108 },
	'centerafarea' => { 251 => '15.1' },
	'centerfocuspoint' => { 254 => '2.2' },
	'centerweightedareasize' => { 241 => '7.1', 242 => '8.1', 244 => '8.1', 248 => '7.1', 249 => '5.1', 250 => '7.1', 251 => '6.3', 253 => '8.1', 254 => '8.1' },
	'certificate' => { 437 => 'Certificate' },
	'cfapattern' => { 107 => 0xa302, 413 => 'CFAPattern' },
	'cfapattern2' => { 107 => 0x828e },
	'cfapatterncolumns' => { 413 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 413 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 413 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 107 => 0x828d },
	'channel' => { 423 => 'channel' },
	'channela-lang' => { 423 => [\'channel','channelA-lang'] },
	'channelchannel' => { 423 => [\'channel','channelChannel'] },
	'channels' => { 136 => 'Channels' },
	'channelsubchannel1' => { 423 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 423 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 423 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 423 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 92 => 0x10101, 97 => 0x26a },
	'checkmark2' => { 98 => 0x8e },
	'childfontfiles' => { 438 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 241 => '10.3', 242 => '11.2' },
	'chromablurradius' => { 107 => 0xc631 },
	'chromaticaberration' => { 92 => 0x20703, 98 => 0x66, 342 => 0xa051 },
	'chromaticaberrationb' => { 409 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 92 => 0x20708, 98 => 0x6b },
	'chromaticaberrationcorr' => { 69 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 301 => 0x1 },
	'chromaticaberrationon' => { 92 => '0x20703.0', 98 => 0x62 },
	'chromaticaberrationr' => { 409 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 92 => 0x20707, 98 => 0x6a },
	'chromaticaberrationsetting' => { 70 => 0x6 },
	'chrominancenoisereduction' => { 92 => 0x20601, 98 => 0x5e, 345 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 98 => 0x60 },
	'circgradbasedcorractive' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 409 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 409 => 'CircularGradientBasedCorrections' },
	'city' => { 115 => 0x5a, 142 => 'City', 277 => 0x6d, 421 => 'City' },
	'city2' => { 277 => 0x80 },
	'clarity' => { 199 => 0x35, 409 => 'Clarity' },
	'clarity2012' => { 409 => 'Clarity2012' },
	'classifystate' => { 115 => 0xe1 },
	'clearretouch' => { 277 => 0x7c },
	'clearretouchvalue' => { 277 => 0xa3 },
	'client' => { 433 => 'client' },
	'clientname' => { 415 => 'ClientName' },
	'clmodeshootingspeed' => { 241 => '10.2', 242 => '11.3', 244 => '11.2', 249 => '11.2', 250 => '10.2', 253 => '11.2', 254 => '11.1' },
	'cmcontrast' => { 264 => 0x2022 },
	'cmexposurecompensation' => { 264 => 0x2000 },
	'cmhue' => { 264 => 0x2021 },
	'cmsaturation' => { 264 => 0x2020 },
	'cmsharpness' => { 264 => 0x2023 },
	'cmwhitebalance' => { 264 => 0x2001 },
	'cmwhitebalancecomp' => { 264 => 0x2002 },
	'cmwhitebalancegraypoint' => { 264 => 0x2010 },
	'codec' => { 150 => 'Codec' },
	'codedcharacterset' => { 116 => 0x5a },
	'collectionname' => { 151 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 151 => 'Collections', 403 => 'collections' },
	'collectionuri' => { 151 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 422 => 'color' },
	'coloraberrationcontrol' => { 234 => 0xc89224b },
	'coloradjustment' => { 345 => 0x14 },
	'coloradjustmentmode' => { 344 => 0x210 },
	'coloranta' => { 438 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 438 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 438 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 438 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 438 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 438 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 438 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 438 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 438 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 438 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 438 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 438 => 'Colorants' },
	'colorantswatchname' => { 438 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 438 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 438 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 438 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 137 => 'ColorBalance' },
	'colorbalanceadj' => { 234 => 0x76a43202 },
	'colorbalanceblue' => { 159 => 0x1e },
	'colorbalancegreen' => { 159 => 0x1d },
	'colorbalancered' => { 159 => 0x1c },
	'colorbalanceversion' => { 180 => 0x0 },
	'colorblur' => { 98 => 0x65 },
	'colorbluron' => { 92 => 0x20704 },
	'colorbooster' => { 234 => 0x5f0e7d23 },
	'colorboostlevel' => { 228 => 0x1 },
	'colorboosttype' => { 228 => 0x0 },
	'colorclass' => { 322 => 0xde, 323 => 'ColorClass' },
	'colorcompensationfilter' => { 162 => [0x3a,0x5f], 164 => 0x111, 365 => 0xb022 },
	'colorcompensationfiltercustom' => { 353 => 0xd, 354 => 0xc },
	'colorcompensationfilterset' => { 353 => 0x8, 354 => 0x7, 355 => 0x18, 369 => 0xf },
	'colorcontrol' => { 261 => 0x102b },
	'colorcorrection' => { 394 => 0x8015 },
	'colorcreatoreffect' => { 256 => 0x532 },
	'colordataversion' => { 37 => 0x0, 38 => 0x0, 40 => 0x0, 41 => 0x0, 42 => 0x0 },
	'coloreffect' => { 277 => 0x28 },
	'colorfilter' => { 101 => 0x17, 102 => 0x3017, 159 => 0x29, 167 => [0x38,0x4d,0x4f], 318 => 0x17 },
	'colorgain' => { 203 => 0x51 },
	'colorhue' => { 92 => 0x20900, 196 => 0x8d },
	'colorimetricreference' => { 107 => 0xc6bf },
	'colorlabel' => { 412 => 'ColorLabel' },
	'colormatrix' => { 260 => 0x200, 261 => 0x1011, 342 => 0xa030 },
	'colormatrix1' => { 107 => 0xc621, 320 => 0x106 },
	'colormatrix2' => { 107 => 0xc622, 264 => 0x200, 320 => 0x226 },
	'colormatrixa' => { 311 => 0x203 },
	'colormatrixadobergb' => { 342 => 0xa032 },
	'colormatrixb' => { 311 => 0x204 },
	'colormatrixnumber' => { 261 => 0x1019 },
	'colormatrixsrgb' => { 342 => 0xa031 },
	'colormode' => { 102 => 0x3015, 112 => 0x1210, 123 => 0x66, 159 => 0x28, 162 => 0x16, 164 => 0x101, 165 => 0x36, 167 => 0x7, 196 => 0x3, 224 => 0x4, 277 => 0x32, 345 => 0x2c, 365 => 0xb029, 421 => 'ColorMode' },
	'colormoirereduction' => { 235 => 0x15 },
	'colormoirereductionmode' => { 235 => 0x5 },
	'colornoisereduction' => { 394 => 0x8029, 409 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 409 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 235 => 0x18 },
	'colornoisereductionsharpness' => { 235 => 0x1c },
	'colornoisereductionsmoothness' => { 409 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 111 => 0x2 },
	'colorprofile' => { 159 => 0x33 },
	'colorprofilesettings' => { 256 => 0x539 },
	'colorrepresentation' => { 117 => 0x3c },
	'colorsaturationadj' => { 92 => 0x20305 },
	'colorsequence' => { 117 => 0x41 },
	'colorspace' => { 43 => 0x3, 55 => 0xb4, 86 => 0x10b4, 107 => 0xa001, 143 => 'ColorSpace', 160 => 0x2f, 161 => 0x25, 162 => 0x17, 196 => 0x1e, 256 => 0x507, 311 => 0x37, 342 => 0xa011, 345 => 0xb, 353 => 0x1b, 354 => 0x83, 355 => 0xe, 369 => 0x6, 413 => 'ColorSpace' },
	'colortempasshot' => { 34 => 0x4, 35 => 0x1d, 36 => 0x26, 37 => 0x43, 40 => 0x43, 41 => 0x43, 42 => 0x43 },
	'colortempauto' => { 34 => 0x9, 35 => 0x22, 36 => 0x1c, 37 => 0x48, 40 => 0x48, 41 => 0x48, 42 => 0x48 },
	'colortempcloudy' => { 34 => 0x22, 35 => 0x31, 36 => 0x35, 37 => 0x5c, 40 => 0x75, 41 => 0x8e, 42 => 0x93, 311 => 0x55 },
	'colortempcustom' => { 37 => 0x84 },
	'colortempcustom1' => { 35 => 0x45 },
	'colortempcustom2' => { 35 => 0x4a },
	'colortempdaylight' => { 34 => 0x18, 35 => 0x27, 36 => 0x2b, 37 => 0x52, 40 => 0x6b, 41 => 0x84, 42 => 0x89, 311 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x7b, 55 => 0xae, 65 => 0x9, 86 => 0x10ae, 112 => 0x1005, 121 => 0x846, 137 => 'ColorTemperature', 160 => [0x6e,0x49], 161 => 0x3f, 162 => [0x39,0x5e], 164 => 0x10b, 167 => [0x3c,0x4c,0x4e], 273 => 0x321, 311 => 0x50, 336 => 0x1308, 365 => 0xb021, 409 => 'Temperature' },
	'colortemperatureadj' => { 394 => 0x8013 },
	'colortemperaturebg' => { 261 => 0x1013 },
	'colortemperaturecustom' => { 353 => 0xc, 354 => 0xb },
	'colortemperaturerg' => { 261 => 0x1014 },
	'colortemperatureset' => { 353 => 0x7, 354 => 0x6 },
	'colortemperaturesetting' => { 162 => 0x25, 355 => 0x17, 369 => 0xe },
	'colortempflash' => { 34 => 0x36, 35 => 0x40, 36 => 0x49, 37 => 0x70, 40 => 0x89, 41 => 0xa2, 42 => 0xa7, 311 => 0x5a },
	'colortempflashdata' => { 37 => 0x24a },
	'colortempfluorescent' => { 34 => 0x2c, 35 => 0x3b, 36 => 0x3f, 37 => 0x66, 40 => 0x7f, 41 => 0x98, 42 => 0x9d },
	'colortempfluorescentd' => { 311 => 0x57 },
	'colortempfluorescentn' => { 311 => 0x58 },
	'colortempfluorescentw' => { 311 => 0x59 },
	'colortempkelvin' => { 34 => 0x31, 36 => 0x44, 37 => 0x6b, 40 => 0x84, 41 => 0x9d, 42 => 0xa2, 277 => 0x44, 336 => 0x1307 },
	'colortempmeasured' => { 34 => 0xe, 37 => 0x4d, 40 => 0x4d, 41 => 0x4d, 42 => 0x4d },
	'colortemppc1' => { 36 => 0x94, 37 => 0x75 },
	'colortemppc2' => { 36 => 0x99, 37 => 0x7a },
	'colortemppc3' => { 36 => 0x9e, 37 => 0x7f },
	'colortempshade' => { 34 => 0x1d, 35 => 0x2c, 36 => 0x30, 37 => 0x57, 40 => 0x70, 41 => 0x89, 42 => 0x8e, 311 => 0x54 },
	'colortemptungsten' => { 34 => 0x27, 35 => 0x36, 36 => 0x3a, 37 => 0x61, 40 => 0x7a, 41 => 0x93, 42 => 0x98, 311 => 0x56 },
	'colortempunknown' => { 34 => 0x13, 36 => 0x21, 40 => 0x52, 41 => 0x52, 42 => 0x52 },
	'colortempunknown10' => { 34 => 0x63, 36 => 0x76, 40 => 0xa2, 41 => 0x7f, 42 => 0x7f },
	'colortempunknown11' => { 34 => 0x68, 36 => 0x7b, 40 => 0xa7, 41 => 0xa7, 42 => 0x84 },
	'colortempunknown12' => { 34 => 0x6d, 36 => 0x80, 40 => 0xac, 41 => 0xac, 42 => 0xac },
	'colortempunknown13' => { 34 => 0x72, 36 => 0x85, 40 => 0xb1, 41 => 0xb1, 42 => 0xb1 },
	'colortempunknown14' => { 36 => 0x8a, 40 => 0xb6, 41 => 0xb6, 42 => 0xb6 },
	'colortempunknown15' => { 36 => 0x8f, 40 => 0xbb, 41 => 0xbb, 42 => 0xbb },
	'colortempunknown16' => { 36 => 0xa3, 41 => 0xc0, 42 => 0xc0 },
	'colortempunknown17' => { 41 => 0xc5, 42 => 0xc5 },
	'colortempunknown18' => { 41 => 0xca, 42 => 0xca },
	'colortempunknown19' => { 41 => 0xcf, 42 => 0xcf },
	'colortempunknown2' => { 34 => 0x3b, 36 => 0x4e, 40 => 0x57, 41 => 0x57, 42 => 0x57 },
	'colortempunknown20' => { 41 => 0xd4, 42 => 0xd4 },
	'colortempunknown21' => { 42 => 0xd9 },
	'colortempunknown22' => { 42 => 0xde },
	'colortempunknown23' => { 42 => 0xe3 },
	'colortempunknown24' => { 42 => 0xe8 },
	'colortempunknown25' => { 42 => 0xed },
	'colortempunknown26' => { 42 => 0xf2 },
	'colortempunknown27' => { 42 => 0xf7 },
	'colortempunknown28' => { 42 => 0xfc },
	'colortempunknown29' => { 42 => 0x101 },
	'colortempunknown3' => { 34 => 0x40, 36 => 0x53, 40 => 0x5c, 41 => 0x5c, 42 => 0x5c },
	'colortempunknown30' => { 42 => 0x106 },
	'colortempunknown4' => { 34 => 0x45, 36 => 0x58, 40 => 0x61, 41 => 0x61, 42 => 0x61 },
	'colortempunknown5' => { 34 => 0x4a, 36 => 0x5d, 40 => 0x66, 41 => 0x66, 42 => 0x66 },
	'colortempunknown6' => { 34 => 0x4f, 36 => 0x62, 40 => 0x8e, 41 => 0x6b, 42 => 0x6b },
	'colortempunknown7' => { 34 => 0x54, 36 => 0x67, 40 => 0x93, 41 => 0x70, 42 => 0x70 },
	'colortempunknown8' => { 34 => 0x59, 36 => 0x6c, 40 => 0x98, 41 => 0x75, 42 => 0x75 },
	'colortempunknown9' => { 34 => 0x5e, 36 => 0x71, 40 => 0x9d, 41 => 0x7a, 42 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 31 => 0x2a, 43 => 0x2 },
	'colortoneadj' => { 92 => 0x20304, 97 => 0x11e },
	'colortoneauto' => { 62 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 61 => 0x6c, 62 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 61 => 0x3c, 62 => 0x3c },
	'colortonemonochrome' => { 61 => 0x84, 62 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 61 => 0x54, 62 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 61 => 0x24, 62 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 61 => 0xc, 62 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 61 => 0x9c, 62 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 61 => 0xb4, 62 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 61 => 0xcc, 62 => 0xe4 },
	'commanddials' => { 251 => '5.1' },
	'commanddialsaperturesetting' => { 241 => '17.3', 242 => '18.3', 244 => '18.3', 249 => '33.3', 250 => '17.3', 253 => '18.3' },
	'commanddialschangemainsub' => { 241 => '17.2', 242 => '18.1', 244 => '18.1', 249 => '33.2', 250 => '17.2', 253 => '18.1' },
	'commanddialsmenuandplayback' => { 241 => '17.4', 242 => '18.2', 244 => '18.2', 249 => '33.4', 250 => '17.4', 253 => '18.2' },
	'commanddialsreverserotation' => { 241 => '17.1', 242 => '6.4', 244 => '6.2', 245 => '16.2', 246 => '17.2', 249 => '33.1', 250 => '17.1', 253 => '6.2', 254 => '18.1' },
	'commanderchannel' => { 251 => '10.2', 252 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 251 => '13.1', 252 => '31.1' },
	'commandergroupa_ttlcomp' => { 254 => '32.1' },
	'commandergroupamanualoutput' => { 251 => '13.2', 252 => '28.2' },
	'commandergroupamode' => { 251 => '11.2', 252 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 251 => '14.1', 252 => '32.1' },
	'commandergroupb_ttlcomp' => { 254 => '33.1' },
	'commandergroupbmanualoutput' => { 251 => '14.2', 252 => '29.2' },
	'commandergroupbmode' => { 251 => '11.3', 252 => '29.1' },
	'commanderinternalflash' => { 251 => '11.1', 252 => '27.1' },
	'commanderinternalmanualoutput' => { 251 => '12.2', 252 => '27.2' },
	'commanderinternalttlchannel' => { 249 => '18.2' },
	'commanderinternalttlcomp' => { 251 => '12.1', 252 => '30.2', 254 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 249 => '20.1', 250 => '26.1' },
	'commanderinternalttlcompgroupa' => { 249 => '21.1', 250 => '27.1' },
	'commanderinternalttlcompgroupb' => { 249 => '22.1', 250 => '28.1' },
	'comment' => { 0 => 0x2, 108 => 'Comment', 138 => 'Comment', 269 => 'Comment' },
	'compass' => { 339 => 0x4 },
	'complianceprofile' => { 423 => 'complianceProfile' },
	'componentsconfiguration' => { 107 => 0x9101, 143 => 'Components', 413 => 'ComponentsConfiguration' },
	'componentversion' => { 86 => 0x80c },
	'composer' => { 433 => 'composer' },
	'compositionadjust' => { 310 => '0.1' },
	'compositionadjustrotation' => { 310 => 0x7 },
	'compositionadjustx' => { 310 => 0x5 },
	'compositionadjusty' => { 310 => 0x6 },
	'compressedbitsperpixel' => { 107 => 0x9102, 413 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 164 => 0x40, 261 => 0x40 },
	'compression' => { 107 => 0x103, 429 => 'Compression' },
	'compressionfactor' => { 256 => 0x50d },
	'compressionratio' => { 143 => 'Compression', 261 => 0x1034 },
	'confidencelevel' => { 404 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 97 => 0x266, 322 => 0xd6 },
	'constrainedcropwidth' => { 97 => 0x262, 322 => 0xd5 },
	'contact' => { 115 => 0x76 },
	'contactinfo' => { 422 => 'contactInfo' },
	'contentlocationcode' => { 115 => 0x1a },
	'contentlocationname' => { 115 => 0x1b },
	'contenttype' => { 423 => 'contentType' },
	'continuousbracketing' => { 162 => 0x20 },
	'continuousdrive' => { 31 => 0x5 },
	'continuousshootingspeed' => { 73 => 0x610 },
	'continuousshotlimit' => { 73 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 31 => 0xd, 101 => 0xc, 102 => [0x3012,0x20], 107 => [0xa408,0xfe54], 112 => [0x1004,0x1006], 137 => 'Contrast', 155 => 'Contrast', 159 => 0x20, 160 => 0x31, 161 => 0x27, 162 => 0x19, 167 => 0x2, 198 => 0x33, 199 => 0x37, 261 => 0x1029, 277 => 0x39, 279 => 0x300a, 311 => 0x20, 318 => 0xc, 332 => 0x24, 336 => 0x1012, 345 => 0xd, 353 => 0x1d, 354 => 0x1a, 365 => 0x2004, 409 => 'Contrast', 413 => 'Contrast' },
	'contrast2012' => { 409 => 'Contrast2012' },
	'contrastadj' => { 92 => 0x20303, 97 => 0x115, 237 => 0x2c, 394 => 0x8017 },
	'contrastauto' => { 62 => 0x90 },
	'contrastcurve' => { 196 => 0x8c },
	'contrastdetectaf' => { 171 => 0x4 },
	'contrastdetectafarea' => { 311 => 0x231 },
	'contrastdetectafinfocus' => { 171 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 61 => 0x60, 62 => 0x60 },
	'contrasthighlight' => { 311 => 0x6d },
	'contrasthighlightshadowadj' => { 311 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 61 => 0x30, 62 => 0x30 },
	'contrastmode' => { 277 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 61 => 0x78, 62 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 61 => 0x48, 62 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 61 => 0x18, 62 => 0x18 },
	'contrastsetting' => { 256 => 0x505, 264 => 0x1012, 355 => 0x10, 369 => 0x8 },
	'contrastshadow' => { 311 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 61 => 0x0, 62 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 61 => 0x90, 62 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 61 => 0xa8, 62 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 61 => 0xc0, 62 => 0xd8 },
	'contributedmedia' => { 433 => 'contributedMedia' },
	'contributedmediaduration' => { 433 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 433 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 433 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 433 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 433 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 433 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 433 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 433 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 433 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 433 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 410 => 'contributor' },
	'contributors' => { 138 => 'Contributors' },
	'controldialset' => { 162 => 0x46 },
	'controlledvocabularyterm' => { 419 => 'CVterm' },
	'controllerboardversion' => { 273 => 0x332 },
	'controlmode' => { 67 => 0x12 },
	'conversionlens' => { 257 => 0x403, 277 => 0x35 },
	'converter' => { 107 => 0xfe4d, 224 => 0xb, 409 => 'Converter' },
	'converttograyscale' => { 409 => 'ConvertToGrayscale' },
	'cookingequipment' => { 425 => 'cookingEquipment' },
	'cookingmethod' => { 425 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 107 => 0x8298, 138 => 'Copyright', 269 => 'Copyright', 311 => 0x22f, 327 => 'Copyright', 420 => 'Copyright', 426 => 'copyright', 429 => 'Copyright', 433 => 'copyright' },
	'copyrightflag' => { 325 => 0x40a },
	'copyrightnotice' => { 115 => 0x74 },
	'copyrightowner' => { 266 => 'CopyrightOwner' },
	'copyrightownerid' => { 266 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 266 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 266 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 266 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 266 => 'CopyrightStatus' },
	'copyrightyear' => { 423 => 'copyrightYear' },
	'coringfilter' => { 260 => 0x310, 261 => 0x102d, 264 => 0x310 },
	'coringvalues' => { 260 => 0x311, 264 => 0x311 },
	'corporateentity' => { 423 => 'corporateEntity' },
	'country' => { 142 => 'Country', 277 => 0x69, 421 => 'Country' },
	'country-primarylocationcode' => { 115 => 0x64 },
	'country-primarylocationname' => { 115 => 0x65 },
	'countrycode' => { 195 => 0x5, 323 => 'CountryCode', 418 => 'CountryCode' },
	'course' => { 425 => 'course' },
	'coverage' => { 410 => 'coverage' },
	'coverdate' => { 423 => 'coverDate' },
	'coverdisplaydate' => { 423 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 311 => 0x28 },
	'crc32' => { 411 => 'crc32' },
	'createdate' => { 107 => 0x9004, 138 => 'CreateDate', 265 => 'CreationDate', 269 => 'create-date', 327 => 'CreationDate', 329 => 0x1, 431 => 'CreateDate' },
	'creationdate' => { 420 => 'CreationDate', 423 => 'creationDate' },
	'creationtime' => { 269 => 'Creation Time' },
	'creativestyle' => { 353 => 0x1a, 354 => 0x18, 364 => 0x41, 365 => 0xb020, 390 => 0x4a },
	'creativestylesetting' => { 355 => 0xf, 369 => 0x7 },
	'creativestylewaschanged' => { 394 => 0x8001 },
	'creator' => { 265 => 'Creator', 327 => 'Creator', 410 => 'creator', 420 => 'Creator' },
	'creatoraddress' => { 418 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 157 => 'CreatorAppId' },
	'creatorcity' => { 418 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 418 => 'CreatorContactInfo' },
	'creatorcountry' => { 418 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoropenwithuioptions' => { 157 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 418 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 418 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 431 => 'CreatorTool' },
	'creatorworkemail' => { 418 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 418 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 418 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 115 => 0x6e, 421 => 'Credit' },
	'creditline' => { 426 => 'creditLine' },
	'creditlinereq' => { 436 => 'CreditLineReq' },
	'creditlinerequired' => { 266 => 'CreditLineRequired' },
	'cropactive' => { 90 => 0x0, 97 => 0x244 },
	'cropangle' => { 409 => 'CropAngle' },
	'cropaspectratio' => { 92 => 0x30101, 97 => 0x260 },
	'cropaspectratiocustom' => { 92 => 0x30102 },
	'cropbottom' => { 111 => 0x9, 229 => 0x36, 281 => 0x31, 322 => 0xdc, 409 => 'CropBottom' },
	'cropbottommargin' => { 45 => 0x3 },
	'cropcircleactive' => { 98 => 0xd6 },
	'cropcircleradius' => { 98 => 0xd9 },
	'cropcirclex' => { 98 => 0xd7 },
	'cropcircley' => { 98 => 0xd8 },
	'cropconstraintowarp' => { 409 => 'CropConstrainToWarp' },
	'croph' => { 402 => 'CropH' },
	'cropheight' => { 90 => 0x6, 97 => 0x24c, 260 => 0x615, 264 => 0x615, 409 => 'CropHeight' },
	'crophispeed' => { 196 => 0x1b },
	'cropleft' => { 97 => 0x246, 111 => 0x6, 229 => 0x1e, 260 => 0x612, 264 => 0x612, 281 => 0x30, 322 => 0xd9, 409 => 'CropLeft' },
	'cropleftmargin' => { 45 => 0x0 },
	'cropmode35mm' => { 336 => 0x1018 },
	'croporiginalheight' => { 90 => 0xb },
	'croporiginalwidth' => { 90 => 0xa },
	'cropoutputheight' => { 229 => 0xce },
	'cropoutputheightinches' => { 229 => 0x96 },
	'cropoutputpixels' => { 229 => 0xd6 },
	'cropoutputresolution' => { 229 => 0xb6 },
	'cropoutputscale' => { 229 => 0xbe },
	'cropoutputwidth' => { 229 => 0xc6 },
	'cropoutputwidthinches' => { 229 => 0x8e },
	'croppedareaimageheightpixels' => { 398 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 398 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 398 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 398 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 336 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 336 => 0x1603 },
	'cropright' => { 111 => 0x8, 229 => 0x2e, 281 => 0x32, 322 => 0xdb, 409 => 'CropRight' },
	'croprightmargin' => { 45 => 0x1 },
	'croprotatedoriginalheight' => { 90 => 0x2 },
	'croprotatedoriginalwidth' => { 90 => 0x1 },
	'croprotation' => { 90 => 0x8, 111 => 0xb },
	'cropscaledresolution' => { 229 => 0x9e },
	'cropsourceresolution' => { 229 => 0xae },
	'croptop' => { 97 => 0x248, 111 => 0x7, 229 => 0x26, 260 => 0x613, 264 => 0x613, 281 => 0x2f, 322 => 0xda, 409 => 'CropTop' },
	'croptopmargin' => { 45 => 0x2 },
	'cropunit' => { 409 => 'CropUnit' },
	'cropunits' => { 409 => 'CropUnits' },
	'cropw' => { 402 => 'CropW' },
	'cropwidth' => { 90 => 0x5, 97 => 0x24a, 260 => 0x614, 264 => 0x614, 409 => 'CropWidth' },
	'cropx' => { 90 => 0x3, 402 => 'CropX' },
	'cropy' => { 90 => 0x4, 402 => 'CropY' },
	'crossprocess' => { 311 => 0x7b },
	'crossprocessparams' => { 311 => 0x235 },
	'cuisine' => { 425 => 'cuisine' },
	'currenticcprofile' => { 107 => 0xc691 },
	'currentpreprofilematrix' => { 107 => 0xc692 },
	'currentversion' => { 394 => 0xd000 },
	'curve0x' => { 402 => 'Curve0x' },
	'curve0y' => { 402 => 'Curve0y' },
	'curve1x' => { 402 => 'Curve1x' },
	'curve1y' => { 402 => 'Curve1y' },
	'curve2x' => { 402 => 'Curve2x' },
	'curve2y' => { 402 => 'Curve2y' },
	'curve3x' => { 402 => 'Curve3x' },
	'curve3y' => { 402 => 'Curve3y' },
	'curve4x' => { 402 => 'Curve4x' },
	'curve4y' => { 402 => 'Curve4y' },
	'curves' => { 234 => 0x76a43201 },
	'custom1' => { 266 => 'Custom1' },
	'custom10' => { 266 => 'Custom10' },
	'custom2' => { 266 => 'Custom2' },
	'custom3' => { 266 => 'Custom3' },
	'custom4' => { 266 => 'Custom4' },
	'custom5' => { 266 => 'Custom5' },
	'custom6' => { 266 => 'Custom6' },
	'custom7' => { 266 => 'Custom7' },
	'custom8' => { 266 => 'Custom8' },
	'custom9' => { 266 => 'Custom9' },
	'customcolortone' => { 98 => 0x4c },
	'customcontrast' => { 98 => 0x4e },
	'customcontrols' => { 73 => 0x70c },
	'customdefaultunsharpfineness' => { 98 => 0xbe },
	'customdefaultunsharpstrength' => { 98 => 0xbc },
	'customdefaultunsharpthreshold' => { 98 => 0xc0 },
	'customlinear' => { 98 => 0x4f },
	'customoutputhighlightpoint' => { 98 => 0x53 },
	'customoutputshadowpoint' => { 98 => 0x54 },
	'custompicturestyle' => { 92 => 0x10021 },
	'custompicturestyledata' => { 92 => 0xf0500 },
	'custompicturestylefilename' => { 55 => 0x4010 },
	'customrawhighlight' => { 98 => 0x7c },
	'customrawhighlightpoint' => { 98 => 0x51 },
	'customrawshadow' => { 98 => 0x85 },
	'customrawshadowpoint' => { 98 => 0x52 },
	'customrendered' => { 107 => 0xa401, 413 => 'CustomRendered' },
	'customsaturation' => { 98 => 0x4d, 256 => 0x503 },
	'customsettingsalldefault' => { 241 => '0.2', 249 => '0.2' },
	'customsettingsbank' => { 241 => '0.1', 242 => '0.1', 244 => '0.1', 249 => '0.1', 253 => '0.2' },
	'customsharpness' => { 98 => 0x50 },
	'customunsharpmaskfineness' => { 98 => 0xb8 },
	'customunsharpmaskstrength' => { 98 => 0xb6 },
	'customunsharpmaskthreshold' => { 98 => 0xba },
	'customwb_rblevels' => { 369 => 0x1a },
	'customwb_rgblevels' => { 354 => 0x8, 355 => 0x19 },
	'customwbbluelevel' => { 162 => 0x36 },
	'customwberror' => { 162 => 0x37 },
	'customwbgreenlevel' => { 162 => 0x35 },
	'customwbredlevel' => { 162 => 0x34 },
	'customwbsetting' => { 162 => 0x26 },
	'd-lightinghq' => { 234 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 230 => 0x2 },
	'd-lightinghqhighlight' => { 230 => 0x1 },
	'd-lightinghqselected' => { 234 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 230 => 0x0 },
	'd-lightinghs' => { 234 => 0xce5554aa },
	'd-lightinghsadjustment' => { 231 => 0x0 },
	'd-lightinghscolorboost' => { 231 => 0x1 },
	'd-rangeoptimizerhighlight' => { 394 => 0x8024 },
	'd-rangeoptimizermode' => { 394 => 0x8022 },
	'd-rangeoptimizershadow' => { 394 => 0x802d },
	'd-rangeoptimizervalue' => { 394 => 0x8023 },
	'd810meteringmode' => { 222 => 0x175e },
	'datacompressionmethod' => { 117 => 0x6e },
	'dataimprint' => { 159 => 0x34 },
	'datascaling' => { 311 => 0x3d },
	'date' => { 311 => 0x6, 410 => 'date' },
	'dateacquired' => { 157 => 'DateAcquired' },
	'datecreated' => { 115 => 0x37, 421 => 'DateCreated' },
	'datedisplayformat' => { 226 => 0x3 },
	'dateidentified' => { 106 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 245 => '4.2' },
	'daterecieved' => { 423 => 'dateRecieved' },
	'datesent' => { 116 => 0x46 },
	'datestampmode' => { 55 => 0x1c },
	'datetime' => { 403 => 'datetime', 429 => 'DateTime' },
	'datetimedigitized' => { 413 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 89 => 0x0, 107 => 0x9003, 135 => 0x14, 138 => 'OriginalDate', 332 => 0xb, 413 => 'DateTimeOriginal' },
	'datetimestamp' => { 123 => 0x64 },
	'datetimeutc' => { 256 => 0x908 },
	'daylightsavings' => { 68 => 0x3, 226 => 0x2 },
	'dccontinent' => { 106 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 106 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 106 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 106 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 106 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 106 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 106 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 106 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 106 => 'Event' },
	'dcfootprintspatialfit' => { 106 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 106 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 106 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 106 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 106 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 106 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 106 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 106 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 106 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 106 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 106 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 106 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 106 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 106 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 106 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 106 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 106 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 106 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 106 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 106 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 106 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 106 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 106 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 106 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 106 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 106 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 106 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 106 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 106 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 106 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 106 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 106 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 106 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 106 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 106 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 106 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 106 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 146 => 'Declination' },
	'decposition' => { 159 => 0x32 },
	'defaultautogray' => { 409 => 'DefaultAutoGray' },
	'defaultautotone' => { 409 => 'DefaultAutoTone' },
	'defaultblackrender' => { 107 => 0xc7a6 },
	'defaultcroporigin' => { 107 => 0xc61f },
	'defaultcropsize' => { 107 => 0xc620 },
	'defaulteraseoption' => { 73 => 0x813 },
	'defaultscale' => { 107 => 0xc61e },
	'defaultsspecifictoiso' => { 409 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 409 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 107 => 0xc7b5 },
	'defringe' => { 409 => 'Defringe' },
	'defringegreenamount' => { 409 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 409 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 409 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 409 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 409 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 409 => 'DefringePurpleHueLo' },
	'dehaze' => { 409 => 'Dehaze' },
	'deletedimagecount' => { 196 => 0xa6, 204 => 0x6e },
	'deprecatedon' => { 406 => 'deprecatedOn' },
	'derivedfrom' => { 434 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 434 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 434 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 434 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 434 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 434 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 434 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 434 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 434 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 434 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 434 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 434 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 434 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 434 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 434 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 434 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 434 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 434 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 434 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 434 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 434 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 434 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 434 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 434 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 269 => 'Description', 410 => 'description', 431 => 'Description' },
	'destination' => { 116 => 0x5 },
	'destinationcity' => { 311 => 0x24, 317 => 0x3 },
	'destinationcitycode' => { 318 => 0x1001 },
	'destinationdst' => { 311 => 0x26, 317 => '0.3' },
	'developmentdynamicrange' => { 112 => 0x1403 },
	'device' => { 423 => 'device' },
	'devicesettingdescription' => { 413 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 413 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 413 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 413 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 342 => 0x2 },
	'dialdirectiontvav' => { 73 => 0x706 },
	'dietaryneeds' => { 425 => 'dietaryNeeds' },
	'diffractioncorrection' => { 301 => 0x3 },
	'digitalcreationdate' => { 115 => 0x3e },
	'digitalcreationtime' => { 115 => 0x3f },
	'digitaldeehighlightadj' => { 203 => 0x202 },
	'digitaldeeshadowadj' => { 203 => 0x200 },
	'digitaldeethreshold' => { 203 => 0x201 },
	'digitalfilter' => { 345 => 0x59 },
	'digitalfilter01' => { 298 => 0x5 },
	'digitalfilter02' => { 298 => 0x16 },
	'digitalfilter03' => { 298 => 0x27 },
	'digitalfilter04' => { 298 => 0x38 },
	'digitalfilter05' => { 298 => 0x49 },
	'digitalfilter06' => { 298 => 0x5a },
	'digitalfilter07' => { 298 => 0x6b },
	'digitalfilter08' => { 298 => 0x7c },
	'digitalfilter09' => { 298 => 0x8d },
	'digitalfilter10' => { 298 => 0x9e },
	'digitalfilter11' => { 298 => 0xaf },
	'digitalfilter12' => { 298 => 0xc0 },
	'digitalfilter13' => { 298 => 0xd1 },
	'digitalfilter14' => { 298 => 0xe2 },
	'digitalfilter15' => { 298 => 0xf3 },
	'digitalfilter16' => { 298 => 0x104 },
	'digitalfilter17' => { 298 => 0x115 },
	'digitalfilter18' => { 298 => 0x126 },
	'digitalfilter19' => { 298 => 0x137 },
	'digitalfilter20' => { 298 => 0x148 },
	'digitalgain' => { 65 => 0xb },
	'digitalgem' => { 188 => 0x0 },
	'digitalice' => { 203 => 0x100 },
	'digitalimageguid' => { 419 => 'DigImageGUID' },
	'digitalroc' => { 201 => 0x0 },
	'digitalsourcefiletype' => { 419 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 419 => 'DigitalSourceType' },
	'digitalzoom' => { 31 => 0xc, 101 => 0xa, 123 => 0x68, 137 => 'DigitalZoom', 159 => 0xc, 196 => 0x86, 224 => 0xa, 261 => 0x204, 311 => 0x1e, 318 => 0xa, 344 => 0x204, 382 => 0x12, 383 => 0x12 },
	'digitalzoomon' => { 344 => 0x21b },
	'digitalzoomratio' => { 107 => 0xa404, 374 => 0x200, 376 => 0x21c, 413 => 'DigitalZoomRatio' },
	'director' => { 433 => 'director' },
	'directorphotography' => { 433 => 'directorPhotography' },
	'directory' => { 108 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 26 => 0x1f7 },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 183 => 0x3 },
	'disclaimer' => { 269 => 'Disclaimer' },
	'discnumber' => { 433 => 'discNumber' },
	'dishtype' => { 425 => 'dishType' },
	'displayallafpoints' => { 73 => 0x514 },
	'displayaperture' => { 31 => 0x23 },
	'displayedunitsx' => { 326 => 0x2 },
	'displayedunitsy' => { 326 => 0x6 },
	'displayname' => { 422 => 'displayName' },
	'distance1' => { 123 => 0x28 },
	'distance2' => { 123 => 0x2c },
	'distance3' => { 123 => 0x30 },
	'distance4' => { 123 => 0x34 },
	'distortion' => { 342 => 0xa050 },
	'distortioncontrol' => { 204 => 0x10 },
	'distortioncorrection' => { 92 => 0x20705, 98 => 0x67, 256 => 0x50b, 280 => '7.1', 301 => 0x0, 389 => 0x601, 390 => 0x5b },
	'distortioncorrection2' => { 260 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 405 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 92 => '0x20705.0', 98 => 0x63 },
	'distortioncorrectionsetting' => { 365 => 0x2013 },
	'distortioneffect' => { 92 => 0x20709 },
	'distortionn' => { 280 => 0xc },
	'distortionparam02' => { 280 => 0x2 },
	'distortionparam04' => { 280 => 0x4 },
	'distortionparam08' => { 280 => 0x8 },
	'distortionparam09' => { 280 => 0x9 },
	'distortionparam11' => { 280 => 0xb },
	'distortionscale' => { 280 => 0x5 },
	'distributor' => { 423 => 'distributor' },
	'distributorproductid' => { 422 => 'distributorProductID' },
	'dloon' => { 92 => '0x20706.0', 98 => 0xdc },
	'dlosetting' => { 92 => 0x20706, 98 => 0xdd },
	'dlosettingapplied' => { 91 => 0x4 },
	'dloshootingdistance' => { 98 => 0xde },
	'dloversion' => { 91 => 0x5 },
	'dmcomment' => { 433 => 'comment' },
	'dngadobedata' => { 107 => 0xc634 },
	'dngbackwardversion' => { 107 => 0xc613 },
	'dngignoresidecars' => { 409 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 107 => 0xc630 },
	'dngprivatedata' => { 107 => 0xc634 },
	'dngversion' => { 107 => 0xc612 },
	'document' => { 269 => 'Document' },
	'documentancestors' => { 421 => 'DocumentAncestors' },
	'documenthistory' => { 115 => 0xe7 },
	'documentid' => { 434 => 'DocumentID' },
	'documentname' => { 107 => 0x10d },
	'documentnotes' => { 115 => 0xe6 },
	'doi' => { 423 => 'doi' },
	'dpp' => { 403 => 'dpp' },
	'dr4cameramodel' => { 93 => 0x3 },
	'drivemode' => { 102 => 0x3103, 159 => 0x6, 162 => 0x1e, 165 => 0xe, 256 => 0x600, 311 => 0x34, 336 => 0x1002, 345 => 0x3, 353 => 0x4, 354 => 0x7e, 355 => 0x34 },
	'drivemode2' => { 162 => 0xa, 292 => 0x7, 364 => 0xe, 369 => 0x1 },
	'drivemodesetting' => { 355 => 0x4 },
	'dspfirmwareversion' => { 311 => 0x27 },
	'duration' => { 58 => 0x6a, 136 => 'Duration', 150 => 'Duration', 425 => 'duration', 433 => 'duration' },
	'durationscale' => { 433 => [\'duration','durationScale'] },
	'durationvalue' => { 433 => [\'duration','durationValue'] },
	'dustremovaldata' => { 55 => 0x97 },
	'dynamicafarea' => { 241 => '1.4', 249 => '1.4' },
	'dynamicareaafdisplay' => { 242 => '46.1', 244 => '47.1', 253 => '47.1' },
	'dynamicrange' => { 112 => 0x1400 },
	'dynamicrangeexpansion' => { 311 => 0x69, 336 => 0x100e },
	'dynamicrangemax' => { 97 => 0x7c },
	'dynamicrangemin' => { 97 => 0x7a },
	'dynamicrangeoptimizer' => { 162 => 0x15, 365 => [0xb025,0xb04f], 372 => 0x1144, 373 => [0x1144,0x324], 374 => [0x1120,0x300], 375 => [0x119c,0x37c], 376 => [0x1178,0x328], 377 => [0x1030,0x50], 378 => [0x228,0x50], 379 => [0x228,0x50] },
	'dynamicrangeoptimizerbracket' => { 364 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 353 => 0x19, 354 => 0x17, 355 => 0xd, 364 => 0x79, 369 => 0x5 },
	'dynamicrangeoptimizermode' => { 165 => 0x15, 353 => 0x18, 354 => 0x16, 364 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 162 => 0x27, 355 => 0xc, 369 => 0x4 },
	'dynamicrangesetting' => { 112 => 0x1402 },
	'e-dialinprogram' => { 292 => '1.3' },
	'earliestageorloweststage' => { 106 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 106 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 106 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 106 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 106 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 254 => '6.1' },
	'easyexposurecompensation' => { 241 => '6.4', 242 => '6.5', 244 => '6.3', 248 => '5.1', 249 => '4.4', 250 => '5.2', 253 => '6.3' },
	'easymode' => { 31 => 0xb },
	'edgenoisereduction' => { 235 => 0x4, 394 => 0x8028 },
	'edition' => { 423 => 'edition' },
	'editorialupdate' => { 115 => 0x8 },
	'editstatus' => { 115 => 0x7, 323 => 'EditStatus', 403 => 'EditStatus' },
	'editversionname' => { 234 => 0x3d136244 },
	'effectivelv' => { 311 => 0x2d },
	'effectivemaxaperture' => { 192 => 0x12, 193 => 0x13 },
	'eissn' => { 423 => 'eIssn' },
	'electronicfront-curtainshutter' => { 244 => '5.2', 253 => '5.3' },
	'elevation' => { 146 => 'Elevation' },
	'email' => { 138 => 'EMail' },
	'embargodate' => { 426 => 'embargoDate' },
	'embdencrightsexpr' => { 419 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 419 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 419 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 419 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 421 => 'EmbeddedXMPDigest' },
	'emissivity' => { 109 => 0x3 },
	'encryptionkey' => { 342 => 0xa020 },
	'endingpage' => { 423 => 'endingPage' },
	'enduser' => { 266 => 'EndUser' },
	'enduserid' => { 266 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 266 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 433 => 'engineer' },
	'enhancedarktones' => { 227 => 0x8 },
	'enhancement' => { 101 => 0x16, 102 => 0x3016 },
	'enhancer' => { 260 => 0x300 },
	'enhancervalues' => { 260 => 0x301 },
	'envelopenumber' => { 116 => 0x28 },
	'envelopepriority' => { 116 => 0x3c },
	'enveloperecordversion' => { 116 => 0x0 },
	'epsonimageheight' => { 261 => 0x20c },
	'epsonimagewidth' => { 261 => 0x20b },
	'epsonsoftware' => { 261 => 0x20d },
	'equipmentinstitution' => { 396 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 396 => 'EquipmentManufacturer' },
	'equipmentversion' => { 257 => 0x0 },
	'ettlii' => { 73 => 0x304, 74 => 0xd, 75 => 0xe, 76 => 0x7, 77 => 0x7, 78 => 0xe },
	'event' => { 397 => 'Event', 401 => 'Event', 419 => 'Event', 423 => 'event' },
	'eventalias' => { 422 => 'eventAlias' },
	'eventday' => { 106 => [\'Event','EventDay'] },
	'eventearliestdate' => { 106 => [\'Event','EventEarliestDate'] },
	'eventend' => { 422 => 'eventEnd' },
	'eventenddayofyear' => { 106 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 106 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 106 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 106 => [\'Event','EventHabitat'] },
	'eventid' => { 106 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 106 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 106 => [\'Event','EventMonth'] },
	'eventnumber' => { 332 => 0x9 },
	'eventremarks' => { 106 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 106 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 106 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 422 => 'eventStart' },
	'eventstartdayofyear' => { 106 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 422 => 'eventSubtype' },
	'eventtime' => { 106 => [\'Event','EventEventTime'] },
	'eventtype' => { 422 => 'eventType' },
	'eventverbatimeventdate' => { 106 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 106 => [\'Event','EventYear'] },
	'evsteps' => { 292 => '1.2', 294 => 0x0 },
	'evstepsize' => { 245 => '5.1', 246 => '6.1', 247 => '6.1', 251 => '0.7' },
	'exclusivityenddate' => { 426 => 'exclusivityEndDate' },
	'excursiontolerance' => { 117 => 0x82 },
	'exif' => { 108 => 'EXIF' },
	'exifbyteorder' => { 108 => 'ExifByteOrder' },
	'exifcamerainfo' => { 115 => 0xe8 },
	'exifimageheight' => { 107 => 0xa003, 413 => 'PixelYDimension' },
	'exifimagewidth' => { 107 => 0xa002, 413 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 108 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 107 => 0x9000, 413 => 'ExifVersion' },
	'exitpupilposition' => { 192 => 0x4, 193 => 0x4 },
	'expirationdate' => { 115 => 0x25, 426 => 'expirationDate' },
	'expirationtime' => { 115 => 0x26 },
	'exposure' => { 107 => 0xfe51, 409 => 'Exposure' },
	'exposure2012' => { 409 => 'Exposure2012' },
	'exposureadj' => { 232 => 0x0 },
	'exposureadj2' => { 232 => 0x12 },
	'exposureadjust' => { 345 => 0xc },
	'exposurebracketingindicatorlast' => { 162 => 0x52 },
	'exposurebracketshotnumber' => { 165 => 0x2d, 364 => 0x2f },
	'exposurebracketstepsize' => { 292 => 0x8 },
	'exposurebracketvalue' => { 196 => 0x19 },
	'exposurecompensation' => { 67 => 0x6, 82 => 0x0, 107 => 0x9204, 123 => 0x24, 137 => 'ExposureComp', 155 => 'ExposureCompensation', 159 => 0xd, 160 => 0x53, 161 => 0x1e, 165 => 0x49c0, 261 => 0x1006, 311 => 0x16, 320 => 0x402, 342 => 0xa013, 345 => [0xc,0x35,0x4d], 372 => 0x114c, 373 => 0x114c, 374 => 0x1128, 376 => 0x1180, 377 => 0x1038, 378 => 0x230, 379 => 0x230, 413 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 369 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 162 => 0x47, 165 => 0x2a },
	'exposurecompensationset' => { 353 => 0x3, 354 => 0x3, 355 => 0x3, 369 => 0x1e },
	'exposurecompensationsetting' => { 162 => 0x1 },
	'exposurecompstepsize' => { 241 => '6.3', 242 => '7.3', 244 => '7.3', 249 => '4.3', 253 => '7.3' },
	'exposurecontrolstep' => { 248 => '6.1', 250 => '6.1' },
	'exposurecontrolstepsize' => { 241 => '6.2', 242 => '7.1', 244 => '7.1', 249 => '4.2', 253 => '7.1', 254 => '7.1' },
	'exposurecount' => { 112 => 0x1032 },
	'exposuredelaymode' => { 241 => '10.1', 242 => '11.1', 244 => '11.1', 245 => '9.1', 246 => '10.1', 247 => '10.1', 249 => '10.4', 250 => '10.1', 251 => '6.4', 253 => '11.1', 254 => '11.2' },
	'exposuredifference' => { 196 => 0xe },
	'exposureindex' => { 107 => 0xa215, 413 => 'ExposureIndex' },
	'exposureindicator' => { 162 => 0x50 },
	'exposurelevelincrements' => { 71 => 0x6, 72 => 0x6, 73 => 0x101, 74 => 0x5, 75 => 0x6, 76 => 0x5, 77 => 0x5, 78 => 0x6, 79 => 0x4, 353 => 0x58, 354 => 0x58 },
	'exposurelockused' => { 398 => 'ExposureLockUsed' },
	'exposuremode' => { 107 => 0xa402, 137 => 'ExposureMode', 159 => 0x1, 160 => 0xa, 161 => 0x0, 162 => 0x0, 165 => 0x34, 256 => 0x200, 275 => 0x40d, 345 => 0x8, 365 => 0xb041, 413 => 'ExposureMode' },
	'exposuremodeinmanual' => { 73 => 0x10b },
	'exposureprogram' => { 107 => 0x8822, 336 => 0x1001, 346 => [0x17e,0x43], 353 => 0x3c, 354 => 0x3c, 355 => 0x5, 359 => 0x14, 364 => 0x3f, 369 => 0x2, 372 => 0x1175, 373 => 0x1179, 374 => 0x1155, 375 => 0x11d1, 376 => 0x11ad, 377 => 0x1065, 378 => 0x25d, 379 => 0x25d, 390 => 0x48, 413 => 'ExposureProgram' },
	'exposureshift' => { 256 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x6, 28 => 0x7, 67 => 0x16, 107 => 0x829a, 120 => 0xfd05, 123 => 0x20, 125 => 0xfa24, 127 => 0xf104, 130 => 0x12, 132 => 0x38, 135 => 0x10, 137 => 'ExposureTime', 159 => 0x9, 160 => 0x35, 161 => 0x48, 162 => 0x8, 165 => 0x49b8, 311 => 0x12, 342 => 0xa018, 345 => [0x32,0x4a], 353 => 0x0, 354 => 0x0, 369 => [0x21,0x23,0x27], 390 => 0x10, 413 => 'ExposureTime' },
	'exposuretime2' => { 345 => [0x33,0x4b] },
	'exposuretuning' => { 196 => 0x1c },
	'exposurevalue' => { 121 => 0x3 },
	'exposurewarning' => { 112 => 0x1302 },
	'exrauto' => { 112 => 0x1033 },
	'exrmode' => { 112 => 0x1034 },
	'extendedwbdetect' => { 256 => 0x902 },
	'extender' => { 257 => 0x301 },
	'extenderfirmwareversion' => { 257 => 0x304 },
	'extendermagnification' => { 139 => 'Magnification' },
	'extendermake' => { 139 => 'Make' },
	'extendermodel' => { 139 => 'Model', 257 => 0x303 },
	'extenderserialnumber' => { 139 => 'SerialNumber', 257 => 0x302 },
	'extenderstatus' => { 309 => 0x3 },
	'externalflash' => { 259 => 0x1201 },
	'externalflashae1' => { 261 => 0x101f },
	'externalflashae1_0' => { 261 => 0x101b },
	'externalflashae2' => { 261 => 0x1020 },
	'externalflashae2_0' => { 261 => 0x101c },
	'externalflashbounce' => { 259 => 0x1204, 261 => 0x1026, 299 => 0x1a },
	'externalflashcompensation' => { 186 => 0x1b },
	'externalflashexposurecomp' => { 196 => 0x17, 299 => 0x19 },
	'externalflashfirmware' => { 184 => 0x6, 185 => 0x6, 186 => 0x6 },
	'externalflashflags' => { 184 => 0x8, 185 => 0x8, 186 => 0x8 },
	'externalflashguidenumber' => { 259 => 0x1203, 299 => '24.1' },
	'externalflashgvalue' => { 261 => 0x1025 },
	'externalflashmode' => { 261 => 0x1028, 299 => 0x2 },
	'externalflashstatus' => { 187 => 0x8 },
	'externalflashzoom' => { 259 => 0x1205, 261 => 0x1027 },
	'externalsensorbrightnessvalue' => { 273 => 0x311, 279 => 0x3408 },
	'extrainfoversion' => { 357 => 0x1a },
	'eyestartaf' => { 162 => 0x40 },
	'face10position' => { 99 => 0x3f4, 100 => 0x1ec, 182 => 0x28, 296 => 0x12 },
	'face10size' => { 297 => 0x12 },
	'face11position' => { 182 => 0x2c, 296 => 0x14 },
	'face11size' => { 297 => 0x14 },
	'face12position' => { 182 => 0x30, 296 => 0x16 },
	'face12size' => { 297 => 0x16 },
	'face13position' => { 296 => 0x18 },
	'face13size' => { 297 => 0x18 },
	'face14position' => { 296 => 0x1a },
	'face14size' => { 297 => 0x1a },
	'face15position' => { 296 => 0x1c },
	'face15size' => { 297 => 0x1c },
	'face16position' => { 296 => 0x1e },
	'face16size' => { 297 => 0x1e },
	'face17position' => { 296 => 0x20 },
	'face17size' => { 297 => 0x20 },
	'face18position' => { 296 => 0x22 },
	'face18size' => { 297 => 0x22 },
	'face19position' => { 296 => 0x24 },
	'face19size' => { 297 => 0x24 },
	'face1position' => { 46 => 0x8, 99 => 0xd, 100 => 0x18, 182 => 0x4, 271 => 0x1, 296 => 0x0, 333 => 0xbc, 360 => 0x1, 361 => 0x0, 362 => 0x0, 363 => 0x5b },
	'face1size' => { 297 => 0x0 },
	'face20position' => { 296 => 0x26 },
	'face20size' => { 297 => 0x26 },
	'face21position' => { 296 => 0x28 },
	'face21size' => { 297 => 0x28 },
	'face22position' => { 296 => 0x2a },
	'face22size' => { 297 => 0x2a },
	'face23position' => { 296 => 0x2c },
	'face23size' => { 297 => 0x2c },
	'face24position' => { 296 => 0x2e },
	'face24size' => { 297 => 0x2e },
	'face25position' => { 296 => 0x30 },
	'face25size' => { 297 => 0x30 },
	'face26position' => { 296 => 0x32 },
	'face26size' => { 297 => 0x32 },
	'face27position' => { 296 => 0x34 },
	'face27size' => { 297 => 0x34 },
	'face28position' => { 296 => 0x36 },
	'face28size' => { 297 => 0x36 },
	'face29position' => { 296 => 0x38 },
	'face29size' => { 297 => 0x38 },
	'face2position' => { 46 => 0xa, 99 => 0x7c, 100 => 0x4c, 182 => 0x8, 271 => 0x5, 296 => 0x2, 333 => 0xc8, 360 => 0x6, 361 => 0x20, 362 => 0x25, 363 => 0x65 },
	'face2size' => { 297 => 0x2 },
	'face30position' => { 296 => 0x3a },
	'face30size' => { 297 => 0x3a },
	'face31position' => { 296 => 0x3c },
	'face31size' => { 297 => 0x3c },
	'face32position' => { 296 => 0x3e },
	'face32size' => { 297 => 0x3e },
	'face3position' => { 46 => 0xc, 99 => 0xeb, 100 => 0x80, 182 => 0xc, 271 => 0x9, 296 => 0x4, 333 => 0xd4, 360 => 0xb, 361 => 0x40, 362 => 0x4a, 363 => 0x6f },
	'face3size' => { 297 => 0x4 },
	'face4position' => { 46 => 0xe, 99 => 0x15a, 100 => 0xb4, 182 => 0x10, 271 => 0xd, 296 => 0x6, 333 => 0xe0, 360 => 0x10, 361 => 0x60, 362 => 0x6f, 363 => 0x79 },
	'face4size' => { 297 => 0x6 },
	'face5position' => { 46 => 0x10, 99 => 0x1c9, 100 => 0xe8, 182 => 0x14, 271 => 0x11, 296 => 0x8, 333 => 0xec, 360 => 0x15, 361 => 0x80, 362 => 0x94 },
	'face5size' => { 297 => 0x8 },
	'face6position' => { 46 => 0x12, 99 => 0x238, 100 => 0x11c, 182 => 0x18, 296 => 0xa, 333 => 0xf8, 360 => 0x1a, 361 => 0xa0, 362 => 0xb9 },
	'face6size' => { 297 => 0xa },
	'face7position' => { 46 => 0x14, 99 => 0x2a7, 100 => 0x150, 182 => 0x1c, 296 => 0xc, 333 => 0x104, 360 => 0x1f, 361 => 0xc0, 362 => 0xde },
	'face7size' => { 297 => 0xc },
	'face8position' => { 46 => 0x16, 99 => 0x316, 100 => 0x184, 182 => 0x20, 296 => 0xe, 333 => 0x110, 360 => 0x24, 361 => 0xe0, 362 => 0x103 },
	'face8size' => { 297 => 0xe },
	'face9position' => { 46 => 0x18, 99 => 0x385, 100 => 0x1b8, 182 => 0x24, 296 => 0x10 },
	'face9size' => { 297 => 0x10 },
	'facedetect' => { 311 => 0x76, 342 => 0x100 },
	'facedetectarea' => { 260 => 0x1201 },
	'facedetectframecrop' => { 260 => 0x1207 },
	'facedetectframesize' => { 46 => 0x3, 99 => 0x1, 100 => 0x4, 182 => 0x1, 260 => 0x1203, 311 => 0x77, 333 => 0xb6 },
	'facedetection' => { 355 => 0x30, 369 => 0x19 },
	'faceid' => { 404 => 'FaceID' },
	'faceinfounknown' => { 102 => 0x2089 },
	'facename' => { 342 => 0x123 },
	'faceorientation' => { 100 => 0x8 },
	'faceposition' => { 295 => 0x2, 343 => 0x4 },
	'facepositions' => { 112 => 0x4103 },
	'facerecognition' => { 342 => 0x120 },
	'facesdetected' => { 46 => 0x2, 47 => 0x2, 48 => 0x3, 99 => 0x0, 100 => 0x2, 102 => 0x211c, 112 => 0x4100, 182 => 0x3, 260 => 0x1200, 277 => 0x3f, 295 => 0x0, 333 => 0xb5, 343 => 0x0, 360 => 0x0, 363 => 0x3, 371 => 0x30 },
	'facesrecognized' => { 272 => 0x0 },
	'facewidth' => { 47 => 0x1 },
	'faithfuloutputhighlightpoint' => { 98 => 0x38 },
	'faithfuloutputshadowpoint' => { 98 => 0x39 },
	'faithfulrawcolortone' => { 98 => 0x31 },
	'faithfulrawcontrast' => { 98 => 0x33 },
	'faithfulrawhighlight' => { 98 => 0x79 },
	'faithfulrawhighlightpoint' => { 98 => 0x36 },
	'faithfulrawlinear' => { 98 => 0x34 },
	'faithfulrawsaturation' => { 98 => 0x32 },
	'faithfulrawshadow' => { 98 => 0x82 },
	'faithfulrawshadowpoint' => { 98 => 0x37 },
	'faithfulrawsharpness' => { 98 => 0x35 },
	'faithfulunsharpmaskfineness' => { 98 => 0xac },
	'faithfulunsharpmaskstrength' => { 98 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 98 => 0xae },
	'femicroadjustment' => { 73 => 0x111 },
	'ffid' => { 411 => 'ffid' },
	'field' => { 422 => 'field' },
	'fieldcount' => { 261 => 0x103f },
	'filecreatedate' => { 108 => 'FileCreateDate' },
	'filedatarate' => { 433 => 'fileDataRate' },
	'fileformat' => { 84 => 0x0, 116 => 0x14, 345 => [0x22,0x26], 365 => 0xb000 },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 26 => 0x1eb, 278 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 108 => 'FileModifyDate' },
	'filename' => { 108 => 'FileName' },
	'filenameasdelivered' => { 266 => 'FileNameAsDelivered' },
	'filenumber' => { 49 => 0x1, 55 => 0x8, 86 => 0x1817, 103 => 'FileNumber', 183 => 0x4 },
	'filenumbermemory' => { 159 => 0x1a },
	'filenumbersequence' => { 241 => '12.2', 245 => '3.1', 246 => '4.1', 247 => '4.1', 249 => '11.1', 250 => '4.3', 254 => '5.2' },
	'filepermissions' => { 108 => 'FilePermissions' },
	'filesource' => { 107 => 0xa300, 112 => 0x8000, 413 => 'FileSource' },
	'fileversion' => { 116 => 0x16 },
	'fillflashautoreduction' => { 71 => 0xe, 72 => 0xe, 79 => 0xa },
	'filllight' => { 409 => 'FillLight' },
	'fillorder' => { 107 => 0x10a },
	'filmgraineffect' => { 256 => 0x538 },
	'filmmode' => { 112 => 0x1401, 275 => 0x412, 277 => 0x42 },
	'filmtype' => { 203 => 0x2 },
	'filtereffect' => { 49 => 0xe, 198 => 0x37, 199 => 0x3f },
	'filtereffectauto' => { 62 => 0xa0 },
	'filtereffectfaithful' => { 61 => 0x70, 62 => 0x70 },
	'filtereffectlandscape' => { 61 => 0x40, 62 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 61 => 0x88, 62 => 0x88 },
	'filtereffectneutral' => { 61 => 0x58, 62 => 0x58 },
	'filtereffectportrait' => { 61 => 0x28, 62 => 0x28 },
	'filtereffectstandard' => { 61 => 0x10, 62 => 0x10 },
	'filtereffectuserdef1' => { 61 => 0xa0, 62 => 0xb8 },
	'filtereffectuserdef2' => { 61 => 0xb8, 62 => 0xd0 },
	'filtereffectuserdef3' => { 61 => 0xd0, 62 => 0xe8 },
	'finderdisplayduringexposure' => { 72 => 0x1 },
	'finesharpness' => { 311 => 0x70 },
	'finetuneoptcenterweighted' => { 241 => '7.2', 242 => '9.1', 244 => '9.1', 248 => '8.1', 253 => '9.1', 254 => '9.1' },
	'finetuneopthighlightweighted' => { 244 => '46.1', 253 => '46.1' },
	'finetuneoptmatrixmetering' => { 241 => '8.1', 242 => '8.2', 244 => '8.2', 248 => '7.2', 249 => '6.1', 253 => '8.2', 254 => '8.2' },
	'finetuneoptspotmetering' => { 241 => '8.2', 242 => '9.2', 244 => '9.2', 248 => '8.2', 249 => '6.2', 253 => '9.2', 254 => '9.2' },
	'firmware' => { 261 => 0x405, 345 => [0x17,0x3b,0x57], 405 => 'Firmware' },
	'firmwaredate' => { 101 => 0x15, 102 => 0x2001, 332 => 0x4 },
	'firmwareid' => { 166 => 0x0 },
	'firmwarename' => { 342 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 55 => 0x1e, 334 => 0x0 },
	'firmwarerevision2' => { 334 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 121 => 0xce5, 135 => 0x57, 137 => 'FirmwareVersion', 277 => 0x2, 279 => 0x3109, 311 => 0x230, 336 => 0x2 },
	'firmwareversions' => { 320 => 0x301 },
	'firstphotodate' => { 398 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 266 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 115 => 0x16, 403 => 'FixtureIdentifier' },
	'flash' => { 103 => 'Flash', 107 => 0x9209, 160 => 0x1f, 161 => 0x15, 413 => 'Flash' },
	'flashaction' => { 353 => 0x3e, 354 => 0x3e, 365 => 0x2017, 369 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 353 => 0x4c, 354 => 0x4c, 369 => 0x77 },
	'flashactionexternal' => { 369 => [0x78,0x7c] },
	'flashactivity' => { 31 => 0x1c },
	'flashbatterylevel' => { 37 => 0x249 },
	'flashbias' => { 277 => 0x24 },
	'flashbits' => { 31 => 0x1d },
	'flashbuttonfunction' => { 73 => 0x70e },
	'flashchargelevel' => { 261 => 0x1010 },
	'flashcolorfilter' => { 186 => 0x10 },
	'flashcommandermode' => { 184 => '9.1', 185 => '9.1', 186 => '9.1' },
	'flashcompensation' => { 184 => 0xa, 185 => 0xa, 186 => 0xa, 405 => 'FlashCompensation' },
	'flashcontrol' => { 353 => 0x23, 354 => 0x1f, 355 => 0x21 },
	'flashcontrolbuilt-in' => { 249 => '16.1', 250 => '23.1', 252 => '23.1', 253 => '24.1' },
	'flashcontrolmode' => { 184 => '9.2', 185 => '9.2', 186 => '9.2', 256 => 0x404 },
	'flashcurtain' => { 277 => 0x48 },
	'flashdefault' => { 162 => 0x42 },
	'flashdevice' => { 261 => 0x1005 },
	'flashdistance' => { 102 => 0x2034 },
	'flashenergy' => { 107 => 0xa20b, 413 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 196 => 0x18 },
	'flashexposurecomp' => { 67 => 0xf, 112 => 0x1011, 140 => 'ExposureComp', 159 => 0x23, 164 => 0x104, 165 => 0x49c1, 196 => 0x12, 256 => 0x401, 261 => 0x1023, 311 => 0x4d, 336 => 0x100b, 345 => [0x3a,0x56], 365 => 0x104 },
	'flashexposurecomp2' => { 221 => 0x4d2 },
	'flashexposurecomp3' => { 186 => 0x1d },
	'flashexposurecomp4' => { 186 => 0x27 },
	'flashexposurecomparea' => { 242 => '38.4', 244 => '38.4', 253 => '38.4' },
	'flashexposurecompset' => { 162 => 0x10, 284 => 0xe, 353 => 0x14, 354 => 0x12, 355 => 0x23, 369 => 0x1f },
	'flashexposurecompset2' => { 369 => [0x26,0x2c] },
	'flashexposureindicator' => { 162 => 0x54 },
	'flashexposureindicatorlast' => { 162 => 0x56 },
	'flashexposureindicatornext' => { 162 => 0x55 },
	'flashexposurelock' => { 49 => 0x19 },
	'flashfired' => { 123 => 0x5d, 140 => 'Fired', 159 => 0x14, 220 => '590.3', 277 => 0x8007, 413 => [\'Flash','FlashFired'] },
	'flashfiring' => { 73 => 0x306, 74 => 0x6, 75 => 0x7, 78 => 0x7 },
	'flashfirmwareversion' => { 257 => 0x1002 },
	'flashfocallength' => { 184 => 0xb, 185 => 0xc, 186 => 0xc },
	'flashfunction' => { 165 => 0x31, 413 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 184 => 0xe, 185 => 0xf, 186 => 0xf },
	'flashgroupacompensation' => { 184 => 0x11, 185 => 0x12, 186 => 0x13 },
	'flashgroupacontrolmode' => { 184 => 0xf, 185 => '16.1', 186 => '17.1' },
	'flashgroupaoutput' => { 184 => 0x11, 185 => 0x12, 186 => 0x13 },
	'flashgroupbcompensation' => { 184 => 0x12, 185 => 0x13, 186 => 0x14 },
	'flashgroupbcontrolmode' => { 184 => 0x10, 185 => '17.1', 186 => '18.1' },
	'flashgroupboutput' => { 184 => 0x12, 185 => 0x13, 186 => 0x14 },
	'flashgroupccompensation' => { 185 => 0x14, 186 => 0x15 },
	'flashgroupccontrolmode' => { 185 => '17.2', 186 => '18.2' },
	'flashgroupcoutput' => { 185 => 0x14, 186 => 0x15 },
	'flashguidenumber' => { 67 => 0xd, 83 => 0x0, 140 => 'GuideNumber' },
	'flashintensity' => { 101 => [0x19,0x5], 256 => 0x405 },
	'flashlevel' => { 243 => 0x9, 365 => 0xb048 },
	'flashmake' => { 140 => 'Make' },
	'flashmanufacturer' => { 157 => 'FlashManufacturer' },
	'flashmetering' => { 159 => 0x3f, 162 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 26 => 0x15 },
	'flashmeteringsegments' => { 311 => 0x20a },
	'flashmode' => { 101 => 0x4, 123 => 0x5c, 140 => 'Mode', 159 => 0x2, 160 => 0x20, 161 => 0x16, 162 => 0xf, 196 => 0x87, 256 => 0x400, 261 => 0x1004, 311 => 0xc, 318 => 0x4, 335 => 0x20, 336 => 0x100a, 344 => 0x225, 353 => 0x13, 354 => 0x7f, 355 => 0x20, 369 => 0x10, 372 => 0x1138, 373 => 0x1138, 374 => 0x1114, 375 => 0x1190, 376 => 0x116c, 377 => 0x1024, 378 => 0x21c, 379 => 0x21c, 413 => [\'Flash','FlashMode'] },
	'flashmodel' => { 140 => 'Model', 157 => 'FlashModel', 257 => 0x1001 },
	'flashoptions' => { 292 => 0x2 },
	'flashoptions2' => { 292 => 0x10 },
	'flashoutput' => { 37 => 0x248, 67 => 0x21, 184 => 0xa, 185 => 0xa, 186 => 0xa },
	'flashpixversion' => { 107 => 0xa000, 413 => 'FlashpixVersion' },
	'flashredeyemode' => { 413 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 256 => 0x403 },
	'flashreturn' => { 413 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 140 => 'SerialNumber', 257 => 0x1003 },
	'flashsetting' => { 196 => 0x8 },
	'flashshutterspeed' => { 241 => '20.2', 242 => '23.2', 244 => '23.2', 249 => '15.2', 250 => '22.2', 251 => '7.2', 252 => '22.2', 253 => '23.2', 254 => '23.1' },
	'flashsource' => { 184 => 0x4, 185 => 0x4, 186 => 0x4 },
	'flashstatus' => { 299 => 0x0, 369 => [0x82,0x86], 381 => [0x31,0x39] },
	'flashstatusbuilt-in' => { 355 => [0x87,0x287] },
	'flashstatusexternal' => { 355 => [0x88,0x288] },
	'flashsyncspeed' => { 241 => '20.1', 242 => '23.1', 244 => '23.1', 249 => '15.1', 250 => '22.1', 252 => '22.1', 253 => '23.1' },
	'flashsyncspeedav' => { 71 => 0x3, 73 => 0x10f, 74 => 0x2, 75 => 0x3, 76 => 0x2, 77 => 0x2, 78 => 0x3, 79 => 0x6 },
	'flashthreshold' => { 83 => 0x1 },
	'flashtype' => { 140 => 'Type', 162 => 0x59, 196 => 0x9, 257 => 0x1000 },
	'flashwarning' => { 250 => '30.1', 251 => '7.1', 254 => '31.1', 277 => 0x62 },
	'flexiblespotposition' => { 365 => 0x201d },
	'flickerreduce' => { 344 => 0x218 },
	'flickerreduction' => { 214 => 0xe84 },
	'flickerreductionindicator' => { 214 => 0x5e2 },
	'fliphorizontal' => { 234 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x5, 28 => 0x6, 67 => 0x15, 107 => 0x829d, 120 => 0xfd04, 123 => 0x1e, 125 => 0xfa23, 127 => 0xf103, 130 => 0x13, 132 => 0x3c, 135 => 0xc, 144 => 'FNumber', 159 => 0xa, 160 => 0x36, 161 => 0x47, 162 => 0x9, 165 => 0x49c7, 311 => 0x13, 342 => 0xa019, 345 => [0x31,0x49], 353 => 0x1, 354 => 0x1, 369 => [0x20,0x22,0x26], 413 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x1e, 51 => 0x1, 102 => 0x1d, 107 => 0x920a, 130 => 0x1d, 144 => 'FocalLength', 159 => 0x12, 192 => 0xa, 193 => 0xb, 311 => 0x1d, 320 => 0x403, 336 => 0x1500, 352 => 0xe, 376 => 0x1278, 377 => 0x1134, 378 => 0x32c, 379 => 0x32c, 413 => 'FocalLength' },
	'focallength2' => { 369 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 107 => 0xa405, 342 => 0xa01a, 413 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 352 => 0x10 },
	'focalplaneafpointarea' => { 380 => 0x2 },
	'focalplaneafpointlocation1' => { 380 => 0x6 },
	'focalplaneafpointlocation10' => { 380 => 0x2a },
	'focalplaneafpointlocation11' => { 380 => 0x2e },
	'focalplaneafpointlocation12' => { 380 => 0x32 },
	'focalplaneafpointlocation13' => { 380 => 0x36 },
	'focalplaneafpointlocation14' => { 380 => 0x3a },
	'focalplaneafpointlocation15' => { 380 => 0x3e },
	'focalplaneafpointlocation2' => { 380 => 0xa },
	'focalplaneafpointlocation3' => { 380 => 0xe },
	'focalplaneafpointlocation4' => { 380 => 0x12 },
	'focalplaneafpointlocation5' => { 380 => 0x16 },
	'focalplaneafpointlocation6' => { 380 => 0x1a },
	'focalplaneafpointlocation7' => { 380 => 0x1e },
	'focalplaneafpointlocation8' => { 380 => 0x22 },
	'focalplaneafpointlocation9' => { 380 => 0x26 },
	'focalplaneafpointsused' => { 380 => 0x1 },
	'focalplanediagonal' => { 257 => 0x103, 261 => 0x205 },
	'focalplaneresolutionunit' => { 107 => 0xa210, 413 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 107 => 0xa20e, 413 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 51 => 0x2 },
	'focalplanexunknown' => { 51 => 0x2 },
	'focalplaneyresolution' => { 107 => 0xa20f, 413 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 51 => 0x3 },
	'focalplaneyunknown' => { 51 => 0x3 },
	'focaltype' => { 9 => 0x2d, 51 => 0x0 },
	'focalunits' => { 31 => 0x19 },
	'focus' => { 224 => 0x8 },
	'focusarea' => { 159 => 0x31 },
	'focusareaselection' => { 251 => '15.2' },
	'focuscontinuous' => { 31 => 0x20 },
	'focusdisplayaiservoandmf' => { 73 => 0x515 },
	'focusdistance' => { 144 => 'FocusDistance', 159 => 0x13, 165 => 0x49bb, 192 => 0x9, 193 => 0xa, 259 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0x56, 49 => 0x15, 67 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0x54, 49 => 0x14, 67 => 0x13 },
	'focusholdbutton' => { 162 => 0x44 },
	'focusinfoversion' => { 259 => 0x0 },
	'focusingscreen' => { 72 => 0x0, 73 => 0x80b, 78 => 0x0 },
	'focuslocation' => { 365 => 0x2027 },
	'focuslocked' => { 158 => 0x14 },
	'focusmode' => { 31 => 0x7, 101 => 0x3, 102 => [0x3003,0xd], 112 => 0x1021, 123 => 0x38, 137 => 'FocusMode', 159 => 0x30, 161 => 0xe, 162 => 0xc, 196 => 0x7, 256 => 0x301, 261 => 0x100b, 277 => 0x7, 311 => 0xd, 318 => 0x3, 336 => 0x1006, 346 => [0xb,0x5], 352 => [0x15,0x1d], 353 => 0x4d, 354 => 0x4d, 365 => [0xb042,0xb04e,0x201b], 369 => 0x13, 385 => 0x16 },
	'focusmode2' => { 292 => '3.1', 369 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 243 => '10.1', 350 => 0x14, 351 => 0x15, 353 => 0x10, 354 => 0xf, 355 => 0x6 },
	'focusmodeswitch' => { 162 => 0x58, 353 => 0x2e },
	'focuspixel' => { 112 => 0x1023 },
	'focuspointwrap' => { 241 => '2.2', 242 => '2.2', 244 => '2.1', 248 => '1.1', 249 => '2.2', 250 => '1.1', 253 => '2.2', 254 => '2.5' },
	'focusposition' => { 192 => 0x8, 193 => 0x8, 311 => 0x10, 364 => 0x9bb },
	'focusposition2' => { 369 => [0x29,0x2b,0x2f], 385 => 0x2d, 388 => 0x20 },
	'focusprocess' => { 256 => 0x302 },
	'focusrange' => { 31 => 0x12, 261 => 0x100a },
	'focusrangeindex' => { 302 => '3.1' },
	'focussetting' => { 345 => 0x6 },
	'focusstatus' => { 352 => 0x19, 353 => 0x53, 354 => 0x53 },
	'focusstepcount' => { 259 => 0x301, 261 => 0x100e },
	'focusstepinfinity' => { 259 => 0x303, 261 => 0x103b },
	'focusstepnear' => { 259 => 0x304, 261 => 0x103c },
	'focustrackinglockon' => { 241 => ['1.5','4.1'], 242 => '1.4', 248 => '0.4', 249 => '3.1', 250 => '0.4', 253 => '1.4' },
	'focuswarning' => { 112 => 0x1301 },
	'foldername' => { 159 => 0x27 },
	'foldernumber' => { 353 => 0x9a, 355 => [0x402,0x114,0x316] },
	'fontcomposite' => { 438 => [\'Fonts','FontsComposite'] },
	'fontface' => { 438 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 438 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 438 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 438 => [\'Fonts','FontsFontName'] },
	'fonts' => { 438 => 'Fonts' },
	'fonttype' => { 438 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 438 => [\'Fonts','FontsVersionString'] },
	'for' => { 327 => 'For' },
	'format' => { 410 => 'format', 431 => 'Format' },
	'forwardlock' => { 428 => 'forwardlock' },
	'forwardmatrix1' => { 107 => 0xc714 },
	'forwardmatrix2' => { 107 => 0xc715 },
	'framecount' => { 58 => [0x2,0x4] },
	'frameheight' => { 112 => 0x3822 },
	'framenum' => { 322 => 0xd7 },
	'framenumber' => { 112 => 0x8003, 165 => 0x3c, 311 => 0x29 },
	'framerate' => { 58 => [0x1,0x6], 107 => 0xc764, 112 => 0x3820 },
	'framewidth' => { 112 => 0x3821 },
	'framing' => { 422 => 'framing' },
	'freebytes' => { 86 => 0x1 },
	'freememorycardimages' => { 160 => [0x37,0x54], 161 => [0x2d,0x4a], 162 => 0x32 },
	'fujiflashmode' => { 112 => 0x1010 },
	'fullimagesize' => { 365 => 0xb02b },
	'fullpanoheightpixels' => { 398 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 398 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 336 => 0x100d },
	'fullsizeimage' => { 143 => 'data' },
	'fullsizeimagename' => { 143 => '1Name' },
	'fullsizeimagetype' => { 143 => '0Type' },
	'func1button' => { 244 => '14.1' },
	'func1buttonplusdials' => { 244 => '42.1' },
	'func2button' => { 244 => '80.1' },
	'funcbutton' => { 241 => ['14.1','15.1'], 242 => '14.1', 249 => '28.1', 250 => '13.1', 253 => '14.1', 254 => '14.1' },
	'funcbuttonplusdials' => { 241 => ['14.2','15.2'], 242 => '14.2', 249 => '31.1', 253 => '42.1' },
	'functionbutton' => { 247 => '13.1', 251 => '5.2' },
	'gainbase' => { 260 => 0x610 },
	'gaincontrol' => { 107 => 0xa407, 413 => 'GainControl' },
	'gamma' => { 107 => 0xa500, 414 => 'Gamma' },
	'gammablackpoint' => { 94 => 0xc },
	'gammacolortone' => { 94 => 0x3 },
	'gammacompensatedvalue' => { 117 => 0x91 },
	'gammacontrast' => { 94 => 0x2 },
	'gammacurveoutputrange' => { 94 => 0xf },
	'gammahighlight' => { 94 => 0xa },
	'gammalinear' => { 92 => 0x20200 },
	'gammamidpoint' => { 94 => 0xe },
	'gammasaturation' => { 94 => 0x4 },
	'gammashadow' => { 94 => 0x9 },
	'gammasharpnessstrength' => { 94 => 0x8 },
	'gammaunsharpmaskfineness' => { 94 => 0x6 },
	'gammaunsharpmaskstrength' => { 94 => 0x5 },
	'gammaunsharpmaskthreshold' => { 94 => 0x7 },
	'gammawhitepoint' => { 94 => 0xd },
	'geimagesize' => { 112 => 0x1304 },
	'gemake' => { 113 => 0x300 },
	'gemodel' => { 113 => 0x207 },
	'genre' => { 423 => 'genre', 433 => 'genre' },
	'geography' => { 424 => 'geography' },
	'geologicalcontext' => { 106 => 'GeologicalContext' },
	'geologicalcontextbed' => { 106 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 106 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 106 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 106 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 106 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 108 => 'Geosync' },
	'geotag' => { 108 => 'Geotag' },
	'geotiffasciiparams' => { 107 => 0x87b1 },
	'geotiffdirectory' => { 107 => 0x87af },
	'geotiffdoubleparams' => { 107 => 0x87b0 },
	'geotime' => { 108 => 'Geotime' },
	'globalaltitude' => { 325 => 0x419 },
	'globalangle' => { 325 => 0x40d },
	'good' => { 433 => 'good' },
	'googleplusuploadcode' => { 107 => 0x9009 },
	'gpsaltitude' => { 114 => 0x6, 141 => 'Altitude', 413 => 'GPSAltitude' },
	'gpsaltituderef' => { 114 => 0x5, 413 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 114 => 0x1c, 413 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 114 => 0x1d },
	'gpsdatetime' => { 141 => 'DateTime', 413 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 114 => 0x18, 141 => 'Bearing', 413 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 114 => 0x17, 413 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 114 => 0x1a, 141 => 'Distance', 413 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 114 => 0x19, 413 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 114 => 0x14, 413 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 114 => 0x13 },
	'gpsdestlongitude' => { 114 => 0x16, 413 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 114 => 0x15 },
	'gpsdifferential' => { 114 => 0x1e, 141 => 'Differential', 413 => 'GPSDifferential' },
	'gpsdop' => { 114 => 0xb, 413 => 'GPSDOP' },
	'gpshpositioningerror' => { 114 => 0x1f, 413 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 114 => 0x11, 413 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 114 => 0x10, 413 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 114 => 0x2, 141 => 'Latitude', 413 => 'GPSLatitude' },
	'gpslatituderef' => { 114 => 0x1 },
	'gpslongitude' => { 114 => 0x4, 141 => 'Longitude', 413 => 'GPSLongitude' },
	'gpslongituderef' => { 114 => 0x3 },
	'gpsmapdatum' => { 114 => 0x12, 141 => 'Datum', 413 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 114 => 0xa, 141 => 'MeasureMode', 413 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 114 => 0x1b, 413 => 'GPSProcessingMethod' },
	'gpssatellites' => { 114 => 0x8, 141 => 'Satellites', 413 => 'GPSSatellites' },
	'gpsspeed' => { 114 => 0xd, 141 => 'Speed', 413 => 'GPSSpeed' },
	'gpsspeedref' => { 114 => 0xc, 413 => 'GPSSpeedRef' },
	'gpsstatus' => { 114 => 0x9, 413 => 'GPSStatus' },
	'gpstimestamp' => { 114 => 0x7 },
	'gpstrack' => { 114 => 0xf, 141 => 'Heading', 413 => 'GPSTrack' },
	'gpstrackref' => { 114 => 0xe, 413 => 'GPSTrackRef' },
	'gpsversionid' => { 114 => 0x0, 413 => 'GPSVersionID' },
	'gradation' => { 256 => 0x50f },
	'gradientbasedcorractive' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 409 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 409 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 409 => 'GrainAmount' },
	'grainfrequency' => { 409 => 'GrainFrequency' },
	'grainsize' => { 409 => 'GrainSize' },
	'graymixeraqua' => { 409 => 'GrayMixerAqua' },
	'graymixerblue' => { 409 => 'GrayMixerBlue' },
	'graymixergreen' => { 409 => 'GrayMixerGreen' },
	'graymixermagenta' => { 409 => 'GrayMixerMagenta' },
	'graymixerorange' => { 409 => 'GrayMixerOrange' },
	'graymixerpurple' => { 409 => 'GrayMixerPurple' },
	'graymixerred' => { 409 => 'GrayMixerRed' },
	'graymixeryellow' => { 409 => 'GrayMixerYellow' },
	'graypoint' => { 394 => 0x8021 },
	'grayresponseunit' => { 107 => 0x122 },
	'greencurvelimits' => { 97 => 0x1c4 },
	'greencurvepoints' => { 96 => 0x53, 97 => 0x19a },
	'greenhsl' => { 92 => 0x20912 },
	'greenhue' => { 409 => 'GreenHue' },
	'greensaturation' => { 409 => 'GreenSaturation' },
	'griddisplay' => { 241 => '13.3', 242 => '4.3', 244 => '4.2', 245 => '2.2', 249 => '10.5', 250 => '3.4', 251 => '6.1', 253 => '4.4', 254 => '4.2' },
	'gripbatteryadload' => { 290 => 0x5 },
	'gripbatteryadnoload' => { 290 => 0x4 },
	'gripbatterystate' => { 290 => '1.2' },
	'groupareaafillumination' => { 242 => '46.4', 244 => '47.4', 253 => '47.4' },
	'halftonehints' => { 107 => 0x141 },
	'hardlink' => { 108 => 'HardLink' },
	'hasalternative' => { 423 => 'hasAlternative' },
	'hascorrection' => { 423 => 'hasCorrection' },
	'hascorrectiona-lang' => { 423 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 423 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 423 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 409 => 'HasCrop' },
	'hasextendedxmp' => { 435 => 'HasExtendedXMP' },
	'hassettings' => { 409 => 'HasSettings' },
	'hastranslation' => { 423 => 'hasTranslation' },
	'hasvisibleoverprint' => { 438 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 438 => 'HasVisibleTransparency' },
	'hdr' => { 52 => 0x1, 189 => 0x4, 277 => 0x9e, 311 => 0x85, 365 => 0x200a },
	'hdreffect' => { 52 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 189 => 0x0 },
	'hdrlevel' => { 189 => 0x5, 355 => 0x2e, 369 => 0x17 },
	'hdrlevel2' => { 189 => 0x7 },
	'hdrsetting' => { 355 => 0x2d, 369 => 0x16, 372 => 0x1148, 373 => 0x1148, 374 => 0x1124, 375 => 0x11a0, 376 => 0x117c, 377 => 0x1034, 378 => 0x22c, 379 => 0x22c },
	'hdrsmoothing' => { 189 => 0x6 },
	'headline' => { 115 => 0x69, 421 => 'Headline' },
	'hierarchicalkeywords' => { 152 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 152 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 152 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 152 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 152 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 152 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 152 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 152 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 152 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 152 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 152 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 152 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 152 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 152 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 152 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 152 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 152 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 152 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 400 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 106 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 281 => 0x1a },
	'highisomultipliergreen' => { 281 => 0x19 },
	'highisomultiplierred' => { 281 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 26 => 0xc9, 54 => 0x5, 73 => 0x202, 112 => 0x100e, 196 => 0xb1, 311 => 0x71, 353 => 0x2c, 354 => 0x26, 355 => 0x26, 365 => 0x2009, 369 => 0x12, 390 => 0x42 },
	'highisonoisereduction2' => { 365 => 0xb050 },
	'highlight' => { 345 => 0xf },
	'highlightadj' => { 92 => 0x2030c },
	'highlightcolordistortreduct' => { 394 => 0x8026 },
	'highlightlinearitylimit' => { 342 => 0xa025 },
	'highlightprotection' => { 233 => 0x6 },
	'highlightrecovery' => { 409 => 'HighlightRecovery' },
	'highlights' => { 402 => 'Highlights' },
	'highlights2012' => { 409 => 'Highlights2012' },
	'highlighttone' => { 112 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 26 => 0x7, 54 => 0x3, 73 => 0x203 },
	'highlowkeyadj' => { 311 => 0x6c },
	'highspeedsync' => { 162 => 0x5, 353 => 0x2, 354 => 0x2 },
	'histogramxml' => { 234 => 0x83a1a25 },
	'history' => { 421 => 'History', 434 => 'History' },
	'historyaction' => { 434 => [\'History','HistoryAction'] },
	'historychanged' => { 434 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 434 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 434 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 434 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 434 => [\'History','HistoryWhen'] },
	'hometowncity' => { 102 => 0x3006, 311 => 0x23, 317 => 0x2 },
	'hometowncitycode' => { 318 => 0x1000 },
	'hometowndst' => { 311 => 0x25, 317 => '0.2' },
	'hostcomputer' => { 107 => 0x13c },
	'hue' => { 167 => 0x3b, 199 => 0x3d, 311 => 0x67 },
	'hueadj' => { 237 => 0x2f, 394 => 0x8019 },
	'hueadjust' => { 336 => 0x1016 },
	'hueadjustment' => { 160 => 0x4a, 161 => 0x40, 196 => 0x92, 198 => 0x36 },
	'hueadjustmentaqua' => { 409 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 409 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 409 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 409 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 409 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 409 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 409 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 409 => 'HueAdjustmentYellow' },
	'huesetting' => { 264 => 0x1011 },
	'icc_profile' => { 108 => 'ICC_Profile' },
	'iccprofilename' => { 421 => 'ICCProfile' },
	'idccreativestyle' => { 394 => 0x8000 },
	'idcpreviewlength' => { 394 => 0x202 },
	'idcpreviewstart' => { 394 => 0x201 },
	'identification' => { 106 => 'Identification' },
	'identificationid' => { 106 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 106 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 106 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 106 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 106 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 106 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 410 => 'identifier', 431 => 'Identifier' },
	'illumination' => { 251 => '0.5' },
	'imageadjustment' => { 196 => 0x80, 224 => 0x5 },
	'imagealterationconstraints' => { 266 => 'ImageAlterationConstraints' },
	'imagearea' => { 208 => 0x10, 211 => 0x10 },
	'imageareaoffset' => { 311 => 0x38 },
	'imageauthentication' => { 196 => 0x20 },
	'imageboundary' => { 196 => 0x16 },
	'imagecount' => { 112 => 0x1438, 196 => 0xa5, 367 => 0x11b, 381 => [0x32,0x3a] },
	'imagecount2' => { 381 => [0x4c,0x58] },
	'imagecount3' => { 381 => [0x1a0,0x1aa,0x1bd,0x1cb] },
	'imagecreator' => { 266 => 'ImageCreator' },
	'imagecreatorid' => { 266 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 266 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 266 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 196 => 0xa2 },
	'imagedescription' => { 107 => 0x10e, 429 => 'ImageDescription' },
	'imageduplicationconstraints' => { 266 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 234 => 0xfe443a45 },
	'imageeditcount' => { 311 => 0x41 },
	'imageediting' => { 311 => 0x32 },
	'imageeffects' => { 336 => 0x1010 },
	'imagefileconstraints' => { 266 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 266 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 266 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 112 => 0x1436 },
	'imageheight' => { 107 => 0x101, 166 => 0xc, 320 => 0x10d, 429 => 'ImageLength' },
	'imagehistory' => { 107 => 0x9213, 412 => 'ImageHistory' },
	'imageidnumber' => { 273 => 0x340 },
	'imagenumber' => { 107 => 0x9211, 137 => 'ImageNumber', 160 => 0xae, 161 => 0x5e, 320 => 0x113, 353 => 0x9b, 355 => [0x400,'276.1',0x314], 405 => 'ImageNumber' },
	'imagenumber2' => { 161 => 0x62 },
	'imageoptimization' => { 196 => 0xa9 },
	'imageorientation' => { 115 => 0x83 },
	'imageprocessing' => { 196 => 0x1a },
	'imageprocessingversion' => { 260 => 0x0 },
	'imagequality' => { 137 => 'ImageQuality', 210 => '723.2', 211 => '732.2', 220 => '708.1', 277 => 0x1 },
	'imagequality2' => { 256 => 0x603 },
	'imageref' => { 417 => 'ImageRef' },
	'imagereview' => { 243 => '0.4', 251 => '0.4' },
	'imagereviewmonitorofftime' => { 242 => '21.1', 244 => '21.1', 248 => '20.1', 253 => '21.1' },
	'imagereviewtime' => { 241 => '25.1', 243 => '2.1', 245 => '19.1', 246 => '20.1', 247 => '20.1', 249 => '9.2', 250 => '20.1', 254 => '21.2' },
	'imagesize' => { 143 => 'ImageSize' },
	'imagesizerestriction' => { 426 => 'imageSizeRestriction' },
	'imagesourcedata' => { 107 => 0x935c },
	'imagestabilization' => { 31 => 0x22, 102 => 0x3020, 112 => 0x1422, 137 => 'ImageStabilization', 160 => 0xbd, 161 => 0x71, 162 => 0x57, 163 => 0x0, 164 => [0x18,0x107,0x113], 165 => 0x49c2, 196 => 0xac, 256 => 0x604, 259 => 0x1600, 277 => 0x1a, 358 => 0x12, 359 => 0x11, 365 => 0xb026 },
	'imagestabilization2' => { 357 => 0xa },
	'imagestabilizationsetting' => { 165 => 0x14, 353 => 0x3d, 354 => 0x3d, 364 => 0x14 },
	'imagestyle' => { 353 => 0x2d, 354 => 0x27 },
	'imagesupplier' => { 266 => 'ImageSupplier' },
	'imagesupplierid' => { 266 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 266 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 266 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 109 => 0x1 },
	'imagetemperaturemin' => { 109 => 0x2 },
	'imagetone' => { 311 => 0x4f },
	'imagetype' => { 115 => 0x82, 266 => 'ImageType' },
	'imageuniqueid' => { 55 => 0x28, 107 => 0xa420, 413 => 'ImageUniqueID' },
	'imagewidth' => { 107 => 0x100, 166 => 0xe, 320 => 0x10c, 429 => 'ImageWidth' },
	'incrementaltemperature' => { 409 => 'IncrementalTemperature' },
	'incrementaltint' => { 409 => 'IncrementalTint' },
	'industry' => { 423 => 'industry', 424 => 'industry' },
	'infobuttonwhenshooting' => { 73 => 0x409 },
	'infraredilluminator' => { 332 => 0x28 },
	'ingredientexclusion' => { 425 => 'ingredientExclusion' },
	'ingredients' => { 434 => 'Ingredients' },
	'ingredientsalternatepaths' => { 434 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 434 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 434 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 434 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 434 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 434 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 434 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 434 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 434 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 434 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 434 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 434 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 434 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 434 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 434 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 434 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 434 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 434 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 434 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 434 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 434 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 434 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 434 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 73 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 398 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 398 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 398 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 398 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 398 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 241 => '4.4' },
	'initialzoomsetting' => { 241 => '9.3', 249 => '27.3' },
	'inkset' => { 107 => 0x14c },
	'inputprofile' => { 121 => 0x1389 },
	'instanceid' => { 434 => 'InstanceID' },
	'instantplaybacksetup' => { 162 => 0x3e },
	'instantplaybacktime' => { 162 => 0x3d },
	'instructions' => { 421 => 'Instructions' },
	'instrument' => { 433 => 'instrument' },
	'intellectualgenre' => { 418 => 'IntellectualGenre' },
	'intelligentauto' => { 365 => 0xb052 },
	'intelligentcontrast' => { 44 => 0x4 },
	'intelligentd-range' => { 277 => 0x79 },
	'intelligentexposure' => { 277 => 0x5d },
	'intelligentresolution' => { 277 => 0x70 },
	'interchangecolorspace' => { 117 => 0x40 },
	'internalflash' => { 159 => 0x2b, 241 => '23.1', 243 => '8.1', 245 => '22.1', 247 => '23.1', 251 => '8.1', 254 => '24.1', 259 => 0x1208 },
	'internalflashae1' => { 261 => 0x1021 },
	'internalflashae1_0' => { 261 => 0x101d },
	'internalflashae2' => { 261 => 0x1022 },
	'internalflashae2_0' => { 261 => 0x101e },
	'internalflashmode' => { 299 => 0x1 },
	'internalflashstrength' => { 299 => 0x3 },
	'internalflashtable' => { 261 => 0x1024 },
	'internallensserialnumber' => { 342 => 0xa005 },
	'internalndfilter' => { 277 => 0x9d },
	'internalserialnumber' => { 55 => 0x96, 66 => 0x9, 112 => 0x10, 165 => 0x49dc, 255 => 0x18, 257 => 0x102, 277 => 0x25, 291 => 0x4, 336 => 0x5, 381 => [0x7c,0x88,0xf0] },
	'interopindex' => { 107 => 0x1, 414 => 'InteroperabilityIndex' },
	'interopversion' => { 107 => 0x2 },
	'intervallength' => { 159 => 0x10 },
	'intervalmode' => { 159 => 0x26 },
	'intervalnumber' => { 159 => 0x11 },
	'introtime' => { 433 => 'introTime' },
	'introtimescale' => { 433 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 433 => [\'introTime','introTimeValue'] },
	'iptc' => { 108 => 'IPTC' },
	'iptc-naa' => { 107 => 0x83bb, 281 => 0x83bb },
	'iptcbitspersample' => { 117 => 0x56 },
	'iptcdigest' => { 325 => 0x425 },
	'iptcimageheight' => { 117 => 0x1e },
	'iptcimagerotation' => { 117 => 0x66 },
	'iptcimagewidth' => { 117 => 0x14 },
	'iptclastedited' => { 419 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 117 => 0xa },
	'iptcpixelheight' => { 117 => 0x32 },
	'iptcpixelwidth' => { 117 => 0x28 },
	'isalternativeof' => { 423 => 'isAlternativeOf' },
	'isbn' => { 423 => 'isbn' },
	'iscorrectionof' => { 423 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 98 => 0x3 },
	'ismergedhdr' => { 405 => 'IsMergedHDR' },
	'ismergedpanorama' => { 405 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x0, 28 => 0x1, 101 => 0x14, 102 => [0x3014,0x14], 107 => 0x8827, 120 => 0xfd06, 121 => 0x1784, 123 => 0x60, 125 => [0xfa2e,0xfa46], 126 => [0x27,0x28], 127 => 0xf105, 130 => 0x14, 132 => 0x4e, 135 => 0x34, 137 => 'ISO', 159 => 0x8, 165 => 0x49ba, 190 => 0x0, 196 => 0x2, 281 => 0x17, 311 => [0x8b,0x14], 318 => 0x14, 320 => 0x105, 342 => 0xa014, 364 => 0x6f, 369 => [0x1f,0x21,0x25], 413 => 'ISOSpeedRatings' },
	'iso2' => { 190 => 0x6, 205 => 0x265, 206 => 0x25c, 207 => 0x265, 208 => 0x221, 209 => 0x25d, 210 => 0x256, 211 => 0x25d, 215 => 0x2b5, 218 => 0x265, 223 => 0x2b5 },
	'isoauto' => { 292 => '14.4' },
	'isoautohilimit' => { 213 => 0x18eb, 214 => 0xe82, 222 => 0x185d },
	'isoautoparameters' => { 311 => 0x7a },
	'isoautoshuttertime' => { 213 => 0x18ea, 214 => 0xe81, 222 => 0x185c },
	'isodisplay' => { 244 => '4.1', 245 => '2.3', 246 => '3.3', 247 => '3.3', 250 => '3.3', 253 => '4.3', 254 => '4.3' },
	'isoexpansion' => { 73 => 0x103, 74 => 0x7, 75 => 0x8, 78 => 0x8, 190 => 0x4 },
	'isoexpansion2' => { 190 => 0xa },
	'isofloor' => { 292 => 0x6 },
	'isoselection' => { 196 => 0xf },
	'isosensitivitystep' => { 248 => '6.2', 250 => '6.2' },
	'isosetting' => { 123 => 0x5e, 137 => 'ISOSetting', 159 => 0x24, 160 => 0x26, 161 => 0x1c, 162 => 0x13, 167 => 0x6, 196 => 0x13, 292 => '17.3', 335 => 0x27, 353 => 0x16, 354 => 0x14, 355 => 0x2, 364 => 0x6d },
	'isospeed' => { 107 => 0x8833, 414 => 'ISOSpeed' },
	'isospeedexpansion' => { 72 => 0x3 },
	'isospeedincrements' => { 73 => 0x102 },
	'isospeedlatitudeyyy' => { 107 => 0x8834, 414 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 107 => 0x8835, 414 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 73 => 0x103 },
	'isostepsize' => { 241 => '6.1', 242 => '7.2', 244 => '7.2', 249 => '4.1', 253 => '7.2' },
	'isovalue' => { 261 => 0x1001 },
	'issn' => { 423 => 'issn' },
	'issueidentifier' => { 423 => 'issueIdentifier' },
	'issuename' => { 423 => 'issueName' },
	'issueteaser' => { 423 => 'issueTeaser' },
	'issuetype' => { 423 => 'issueType' },
	'istranslationof' => { 423 => 'isTranslationOf' },
	'jobid' => { 115 => 0xb8 },
	'jobname' => { 415 => 'JobName' },
	'jobref' => { 432 => 'JobRef' },
	'jobrefid' => { 432 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 432 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 432 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 415 => 'JobStatus' },
	'jpeghandling' => { 409 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 279 => 0x3034, 365 => 0xb047 },
	'jpegsize' => { 279 => 0x303a },
	'jpgcompression' => { 214 => 0x7d4 },
	'jpgfromraw' => { 86 => 0x2007, 103 => 'JpgFromRaw', 281 => 0x2e },
	'jpgfromrawlength' => { 107 => [0x117,0x202] },
	'jpgfromrawstart' => { 107 => [0x111,0x201] },
	'jpgrecordedpixels' => { 292 => '14.1' },
	'jurisdiction' => { 406 => 'jurisdiction' },
	'kelvinwb_01' => { 300 => 0x5 },
	'kelvinwb_02' => { 300 => 0x9 },
	'kelvinwb_03' => { 300 => 0xd },
	'kelvinwb_04' => { 300 => 0x11 },
	'kelvinwb_05' => { 300 => 0x15 },
	'kelvinwb_06' => { 300 => 0x19 },
	'kelvinwb_07' => { 300 => 0x1d },
	'kelvinwb_08' => { 300 => 0x21 },
	'kelvinwb_09' => { 300 => 0x25 },
	'kelvinwb_10' => { 300 => 0x29 },
	'kelvinwb_11' => { 300 => 0x2d },
	'kelvinwb_12' => { 300 => 0x31 },
	'kelvinwb_13' => { 300 => 0x35 },
	'kelvinwb_14' => { 300 => 0x39 },
	'kelvinwb_15' => { 300 => 0x3d },
	'kelvinwb_16' => { 300 => 0x41 },
	'kelvinwb_daylight' => { 300 => 0x1 },
	'key' => { 433 => 'key' },
	'keystonecompensation' => { 260 => 0x1900 },
	'keystonedirection' => { 260 => 0x1901 },
	'keystonevalue' => { 260 => 0x1906 },
	'keyword' => { 423 => 'keyword' },
	'keywordinfo' => { 152 => 'Keywords' },
	'keywords' => { 115 => 0x19, 138 => 'Keywords', 265 => 'Keywords', 327 => 'Keywords', 403 => 'keywords', 420 => 'Keywords', 431 => 'Keywords' },
	'killdate' => { 423 => 'killDate' },
	'killdatea-platform' => { 423 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 423 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 120 => 0xf908, 123 => 0xe, 125 => [0xfa1e,0xfa52], 131 => 0x70 },
	'kodakimagewidth' => { 120 => 0xf907, 123 => 0xc, 125 => [0xfa1d,0xfa51], 131 => 0x6c },
	'kodakinfotype' => { 120 => 0xfa00 },
	'kodaklook' => { 121 => 0xe4c },
	'kodaklookprofile' => { 121 => 0x138a },
	'kodakmaker' => { 131 => 0x8 },
	'kodakmodel' => { 123 => 0x0, 131 => 0x28 },
	'label' => { 269 => 'Label', 431 => 'Label' },
	'labelname1' => { 417 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 417 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 277 => 0x6f },
	'landscapeoutputhighlightpoint' => { 98 => 0x26 },
	'landscapeoutputshadowpoint' => { 98 => 0x27 },
	'landscaperawcolortone' => { 98 => 0x1f },
	'landscaperawcontrast' => { 98 => 0x21 },
	'landscaperawhighlight' => { 98 => 0x77 },
	'landscaperawhighlightpoint' => { 98 => 0x24 },
	'landscaperawlinear' => { 98 => 0x22 },
	'landscaperawsaturation' => { 98 => 0x20 },
	'landscaperawshadow' => { 98 => 0x80 },
	'landscaperawshadowpoint' => { 98 => 0x25 },
	'landscaperawsharpness' => { 98 => 0x23 },
	'landscapeunsharpmaskfineness' => { 98 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 98 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 98 => 0xa2 },
	'language' => { 410 => 'language' },
	'languageidentifier' => { 115 => 0x87 },
	'largestvalidinteriorrectheight' => { 398 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 398 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 398 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 398 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 159 => 0x1b },
	'lastkeywordiptc' => { 157 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 157 => 'LastKeywordXMP' },
	'lastphotodate' => { 398 => 'LastPhotoDate' },
	'lasturl' => { 434 => 'LastURL' },
	'lateralchromaticaberration' => { 365 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 405 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 106 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 106 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 106 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 106 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 106 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 302 => 0x2 },
	'lc10' => { 302 => 0xb },
	'lc11' => { 302 => 0xc },
	'lc12' => { 302 => 0xd },
	'lc14' => { 302 => 0xf },
	'lc15' => { 302 => 0x10 },
	'lc3' => { 302 => 0x4 },
	'lc4' => { 302 => 0x5 },
	'lc5' => { 302 => 0x6 },
	'lc6' => { 302 => 0x7 },
	'lc7' => { 302 => 0x8 },
	'lc8' => { 302 => 0x9 },
	'lcddisplayatpoweron' => { 73 => 0x811, 77 => 0xa },
	'lcddisplayreturntoshoot' => { 78 => 0x12 },
	'lcdillumination' => { 241 => '17.5', 242 => '5.2', 244 => '5.1', 249 => '10.3', 250 => '4.2', 253 => '5.2', 254 => '5.4' },
	'lcdilluminationduringbulb' => { 73 => 0x408 },
	'lcdpanels' => { 72 => 0x8 },
	'lcheditor' => { 234 => 0x8ae85e },
	'legacyiptcdigest' => { 421 => 'LegacyIPTCDigest' },
	'legalcode' => { 406 => 'legalcode' },
	'lens' => { 107 => 0xfdea, 196 => 0x84, 405 => 'Lens' },
	'lensafstopbutton' => { 71 => 0x11, 72 => 0x13, 73 => 0x506, 74 => 0x10, 75 => 0x12, 78 => 0x13, 79 => 0x9 },
	'lensaperturerange' => { 345 => [0x30,0x48] },
	'lenscorrectionsettings' => { 412 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 405 => 'LensDistortInfo' },
	'lensdistortionparams' => { 261 => 0x206 },
	'lensdrivenoaf' => { 73 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 355 => 0x3f0, 393 => 0xd },
	'lensfirmware' => { 337 => 0x20, 342 => 0xa004 },
	'lensfirmwareversion' => { 257 => 0x204, 277 => 0x60, 355 => 0x3f4, 393 => 0x15 },
	'lensfocallength' => { 92 => 0xf0512, 302 => 0x9 },
	'lensfocalrange' => { 345 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 242 => '55.1', 244 => '52.1', 253 => '52.1' },
	'lensformat' => { 376 => 0x1891, 378 => 0x18bd, 379 => 0x18ed, 381 => 0x106, 389 => 0x603, 390 => 0x5d },
	'lensfstops' => { 191 => 0x7, 192 => 0xc, 193 => 0xd, 196 => 0x8b, 302 => '0.3' },
	'lensid' => { 405 => 'LensID' },
	'lensidnumber' => { 191 => 0x6, 192 => 0xb, 193 => 0xc },
	'lensinfo' => { 107 => 0xa432, 308 => 0x2a, 405 => 'LensInfo', 414 => 'LensSpecification' },
	'lenskind' => { 302 => 0x1 },
	'lensmake' => { 107 => 0xa433, 144 => 'Make', 414 => 'LensMake' },
	'lensmanualdistortionamount' => { 409 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 157 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 345 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 55 => 0x95, 107 => 0xa434, 144 => 'Model', 157 => 'LensModel', 194 => 0x18a, 257 => 0x203, 275 => 0x303, 308 => 0xc, 320 => 0x412, 414 => 'LensModel' },
	'lensmount' => { 355 => 0x99, 376 => 0x1892, 378 => 0x18be, 379 => 0x18ee, 381 => 0x105, 389 => 0x604, 390 => 0x5e },
	'lensmount2' => { 393 => 0x8 },
	'lensparameters' => { 373 => 0x1a23, 376 => 0x1870, 378 => 0x189c, 379 => 0x18cc, 389 => 0x6ca, 390 => 0x64 },
	'lensprofilechromaticaberrationscale' => { 409 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 409 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 409 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 409 => 'LensProfileEnable' },
	'lensprofilefilename' => { 409 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 409 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 409 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 409 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 409 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 409 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 409 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 409 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 409 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 409 => 'LensProfileName' },
	'lensprofilesetup' => { 409 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 409 => 'LensProfileVignettingScale' },
	'lensproperties' => { 257 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 29 => 0x16b, 53 => 0x0, 107 => 0xa435, 144 => 'SerialNumber', 257 => 0x202, 277 => 0x52, 337 => 0x30, 405 => 'LensSerialNumber', 414 => 'LensSerialNumber' },
	'lensshutterlock' => { 162 => 0x4a },
	'lensspec' => { 350 => 0x0, 351 => 0x0, 352 => 0x0, 365 => 0xb02a },
	'lensspecfeatures' => { 381 => [0x115,0x116] },
	'lenstemperature' => { 261 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x112, 31 => 0x16, 164 => 0x10c, 165 => 0x49bd, 196 => 0x83, 257 => 0x201, 270 => 0x16, 273 => 0x310, 276 => 0x303, 277 => 0x51, 279 => 0x3405, 303 => 0x0, 304 => 0x0, 305 => 0x1, 306 => 0x1, 307 => 0x1, 309 => 0x0, 342 => 0xa003, 345 => 0x27, 365 => 0xb027, 376 => 0x1896, 378 => 0x18c2, 379 => 0x18f2, 381 => 0x109, 389 => 0x608, 390 => 0x62 },
	'lenstype2' => { 355 => 0x3f7, 376 => 0x1893, 378 => 0x18bf, 379 => 0x18ef, 381 => 0x107, 389 => 0x605, 390 => 0x60 },
	'lenstype3' => { 393 => 0x9 },
	'lenszoomposition' => { 387 => 0x19, 388 => 0x1e, 390 => [0x342,0x35a] },
	'levelindicator' => { 284 => 0x15 },
	'levelorientation' => { 310 => 0x0 },
	'license' => { 406 => 'license' },
	'licensee' => { 266 => 'Licensee' },
	'licenseeid' => { 266 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 266 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 266 => 'LicenseeImageNotes' },
	'licenseename' => { 266 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 266 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 266 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 266 => 'LicenseeTransactionID' },
	'licenseid' => { 266 => 'LicenseID' },
	'licensestartdate' => { 266 => 'LicenseStartDate' },
	'licensetransactiondate' => { 266 => 'LicenseTransactionDate' },
	'licensetype' => { 411 => 'licensetype' },
	'licensor' => { 266 => 'Licensor' },
	'licensorcity' => { 266 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 266 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 266 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 266 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 266 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 266 => 'LicensorImageID' },
	'licensorname' => { 266 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 266 => 'LicensorNotes' },
	'licensorpostalcode' => { 266 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 266 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 266 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 266 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 266 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 266 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 266 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 266 => 'LicensorTransactionID' },
	'licensorurl' => { 266 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 261 => 0x1009 },
	'lightingmode' => { 102 => 0x302a },
	'lightreading' => { 311 => 0x15 },
	'lightsource' => { 107 => 0x9208, 196 => 0x90, 264 => 0x1000, 413 => 'LightSource' },
	'lightsourcespecial' => { 344 => 0x21d },
	'lightswitch' => { 253 => '0.1', 254 => '0.1' },
	'lightvaluecenter' => { 261 => 0x103d },
	'lightvalueperiphery' => { 261 => 0x103e },
	'limitafareamodeselection' => { 242 => '51.1', 244 => '49.1', 253 => '49.1' },
	'linearitylimitblue' => { 281 => 0x10 },
	'linearitylimitgreen' => { 281 => 0xf },
	'linearitylimitred' => { 281 => 0xe },
	'linearityuppermargin' => { 38 => [0x2ba,0x2d1,0x2d5], 40 => 0x1e5, 41 => [0x1fe,0x2de], 42 => [0x232,0x310] },
	'linearizationtable' => { 107 => 0xc618 },
	'linearresponselimit' => { 107 => 0xc62e },
	'link' => { 423 => 'link' },
	'linkaetoafpoint' => { 292 => '14.2' },
	'linkedencodedrightsexpr' => { 419 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 419 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 419 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 419 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 106 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 245 => '32.1', 254 => '34.1' },
	'liveviewafareamode' => { 250 => '34.1' },
	'liveviewafmethod' => { 369 => 0x20 },
	'liveviewafmode' => { 250 => '34.2' },
	'liveviewafsetting' => { 355 => 0x36 },
	'liveviewbuttonoptions' => { 242 => '50.2', 244 => '48.2', 253 => '48.2' },
	'liveviewexposuresimulation' => { 73 => 0x810 },
	'liveviewfocusmode' => { 355 => [0x8b,0x28b] },
	'liveviewmetering' => { 355 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 242 => '21.2', 244 => '21.2', 246 => '20.2', 247 => '20.2', 248 => '20.2', 250 => '20.2', 253 => '21.2' },
	'liveviewshooting' => { 49 => 0x13 },
	'localcaption' => { 115 => 0x79 },
	'localizedcameramodel' => { 107 => 0xc615 },
	'locallocationname' => { 342 => 0x30 },
	'location' => { 195 => 0x9, 277 => 0x67, 401 => 'Location', 418 => 'Location', 422 => 'location', 423 => 'location' },
	'locationareacode' => { 407 => 'lac' },
	'locationcreated' => { 419 => 'LocationCreated' },
	'locationcreatedcity' => { 419 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 419 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 419 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedlocationid' => { 419 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedprovincestate' => { 419 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 419 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 419 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 195 => 0x0 },
	'locationname' => { 342 => 0x31 },
	'locationshown' => { 419 => 'LocationShown' },
	'locationshowncity' => { 419 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 419 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 419 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownlocationid' => { 419 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownprovincestate' => { 419 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 419 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 419 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 73 => 0x709 },
	'logcomment' => { 433 => 'logComment' },
	'longexposurenoisereduction' => { 54 => 0x4, 73 => 0x201, 74 => 0x1, 75 => 0x2, 76 => 0x1, 77 => 0x1, 78 => 0x2, 79 => 0x1, 277 => 0x49, 353 => 0x2b, 354 => 0x25, 355 => 0x25, 365 => 0x2008, 369 => 0x11, 390 => 0x44 },
	'longexposurenoisereduction2' => { 49 => 0x8 },
	'loop' => { 433 => 'loop' },
	'lowestbiostratigraphiczone' => { 106 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 409 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 409 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 409 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 409 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 409 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 409 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 409 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 409 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 97 => 0x150 },
	'luminancecurvepoints' => { 97 => 0x126 },
	'luminancenoisereduction' => { 92 => 0x20600, 98 => 0x5f, 345 => 0x1b },
	'luminancenoisereductioncontrast' => { 409 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 409 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 98 => 0x6d },
	'luminancesmoothing' => { 409 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 73 => [0x40b,0x40c] },
	'lyrics' => { 433 => 'lyrics' },
	'm16cversion' => { 273 => 0x333 },
	'macatom' => { 408 => 'macAtom' },
	'macatomapplicationcode' => { 408 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 408 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 408 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 112 => 0x1020, 113 => 0x202, 261 => 0x202, 335 => 0x21, 344 => 0x202, 365 => 0xb040 },
	'macroled' => { 259 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 49 => 0x10 },
	'macromode' => { 31 => 0x1, 159 => 0xb, 256 => 0x300, 277 => 0x1c, 336 => 0x1009 },
	'magentahsl' => { 92 => 0x20917 },
	'magicfilter' => { 256 => 0x52c },
	'magnifiedview' => { 75 => 0x11, 77 => 0x9 },
	'maindialexposurecomp' => { 251 => '0.6' },
	'mainingredient' => { 425 => 'mainIngredient' },
	'make' => { 87 => 0x0, 104 => 0x1, 107 => 0x10f, 137 => 'Make', 269 => 'Make', 281 => 0x10f, 422 => 'make', 429 => 'Make' },
	'makernote' => { 413 => 'MakerNote' },
	'makernoteapple' => { 105 => 'MakN', 107 => 0x927c },
	'makernotecanon' => { 105 => 'MakN', 107 => 0x927c },
	'makernotecasio' => { 105 => 'MakN', 107 => 0x927c },
	'makernotecasio2' => { 105 => 'MakN', 107 => 0x927c },
	'makernotedji' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteflir' => { 105 => 'MakN', 107 => 0x927c },
	'makernotefujifilm' => { 105 => 'MakN', 107 => 0x927c },
	'makernotege' => { 105 => 'MakN', 107 => 0x927c },
	'makernotege2' => { 105 => 'MakN', 107 => 0x927c },
	'makernotehasselblad' => { 105 => 'MakN', 107 => 0x927c },
	'makernotehp' => { 105 => 'MakN', 107 => 0x927c },
	'makernotehp2' => { 105 => 'MakN', 107 => 0x927c },
	'makernotehp4' => { 105 => 'MakN', 107 => 0x927c },
	'makernotehp6' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteisl' => { 105 => 'MakN', 107 => 0x927c },
	'makernotejvc' => { 105 => 'MakN', 107 => 0x927c },
	'makernotejvctext' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak10' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak11' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak1a' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak1b' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak2' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak3' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak4' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak5' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak6a' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak6b' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak7' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak8a' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak8b' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak8c' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodak9' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekodakunknown' => { 105 => 'MakN', 107 => 0x927c },
	'makernotekyocera' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteleica' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteleica2' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteleica3' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteleica4' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteleica5' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteleica6' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteleica7' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteleica8' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteleica9' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteminolta' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteminolta2' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteminolta3' => { 105 => 'MakN', 107 => 0x927c },
	'makernotemotorola' => { 105 => 'MakN', 107 => 0x927c },
	'makernotenikon' => { 105 => 'MakN', 107 => 0x927c },
	'makernotenikon2' => { 105 => 'MakN', 107 => 0x927c },
	'makernotenikon3' => { 105 => 'MakN', 107 => 0x927c },
	'makernotenintendo' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteoffset' => { 344 => 0xff },
	'makernoteolympus' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteolympus2' => { 105 => 'MakN', 107 => 0x927c },
	'makernotepanasonic' => { 105 => 'MakN', 107 => 0x927c },
	'makernotepanasonic2' => { 105 => 'MakN', 107 => 0x927c },
	'makernotepentax' => { 105 => 'MakN', 107 => 0x927c },
	'makernotepentax2' => { 105 => 'MakN', 107 => 0x927c },
	'makernotepentax3' => { 105 => 'MakN', 107 => 0x927c },
	'makernotepentax4' => { 105 => 'MakN', 107 => 0x927c },
	'makernotepentax5' => { 105 => 'MakN', 107 => 0x927c },
	'makernotepentax6' => { 105 => 'MakN', 107 => 0x927c },
	'makernotephaseone' => { 105 => 'MakN', 107 => 0x927c },
	'makernotereconyx' => { 105 => 'MakN', 107 => 0x927c },
	'makernotericoh' => { 105 => 'MakN', 107 => 0x927c },
	'makernotericoh2' => { 105 => 'MakN', 107 => 0x927c },
	'makernotericohtext' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesafety' => { 107 => 0xc635 },
	'makernotesamsung1a' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesamsung1b' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesamsung2' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesanyo' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesanyoc4' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesanyopatch' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesigma' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesony' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesony2' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesony3' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesony4' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesony5' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesonyericsson' => { 105 => 'MakN', 107 => 0x927c },
	'makernotesonysrf' => { 105 => 'MakN', 107 => 0x927c },
	'makernotetype' => { 336 => 0x1 },
	'makernoteunknown' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteunknownbinary' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteunknowntext' => { 105 => 'MakN', 107 => 0x927c },
	'makernoteversion' => { 164 => 0x0, 196 => 0x1, 261 => 0x0, 277 => 0x8000, 340 => 0x0, 342 => 0x1, 345 => [0x1d,0x1f], 356 => 0x2000 },
	'managedfrom' => { 434 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 434 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 434 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 434 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 434 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 434 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 434 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 434 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 434 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 434 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 434 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 434 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 434 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 434 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 434 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 434 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 434 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 434 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 434 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 434 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 434 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 434 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 434 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 434 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 434 => 'Manager' },
	'managervariant' => { 434 => 'ManagerVariant' },
	'manageto' => { 434 => 'ManageTo' },
	'manageui' => { 434 => 'ManageUI' },
	'manifest' => { 434 => 'Manifest' },
	'manifestlinkform' => { 434 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 434 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 434 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 434 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 434 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 434 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 434 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 434 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 434 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 434 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 434 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 434 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 434 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 434 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 434 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 434 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 434 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 434 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 434 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 434 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 434 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 434 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 434 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 434 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 434 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 434 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 434 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 434 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 256 => 0x900, 277 => 0x86 },
	'manometerreading' => { 256 => 0x901 },
	'manualafpointselectpattern' => { 73 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 259 => 0x1209 },
	'manualflashoutput' => { 31 => 0x29, 243 => '8.2', 245 => '22.2', 246 => '23.1', 247 => '23.2', 249 => '16.2', 250 => '23.2', 251 => '8.2', 252 => '23.2', 254 => '24.2', 336 => 0x100c },
	'manualflashstrength' => { 256 => 0x406 },
	'manualfocusdistance' => { 196 => 0x85, 261 => 0x100c, 344 => 0x223 },
	'manualtv' => { 72 => 0x5, 73 => 0x705 },
	'manufacturedate' => { 169 => 0x6705, 291 => 0x1 },
	'manufacturedate1' => { 338 => 0x4 },
	'manufacturedate2' => { 338 => 0x5 },
	'manufacturer' => { 422 => 'manufacturer' },
	'marked' => { 420 => 'Marked', 437 => 'Marked' },
	'markers' => { 433 => 'markers' },
	'markerscomment' => { 433 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 433 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 433 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 433 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 433 => [\'markers','markersCuePointType'] },
	'markersduration' => { 433 => [\'markers','markersDuration'] },
	'markerslocation' => { 433 => [\'markers','markersLocation'] },
	'markersname' => { 433 => [\'markers','markersName'] },
	'markersprobability' => { 433 => [\'markers','markersProbability'] },
	'markersspeaker' => { 433 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 433 => [\'markers','markersStartTime'] },
	'markerstarget' => { 433 => [\'markers','markersTarget'] },
	'markerstype' => { 433 => [\'markers','markersType'] },
	'maskedareas' => { 107 => 0xc68e },
	'masterdocumentid' => { 115 => 0xb9 },
	'mastergain' => { 203 => 0x50 },
	'matrixmetering' => { 242 => '50.1', 244 => '48.1', 253 => '48.1' },
	'maxaperture' => { 31 => 0x1a, 127 => 0x6103, 144 => 'MaxAperture', 159 => 0x17, 165 => 0x49c5, 257 => 0x20a, 302 => '14.1', 381 => 0x0 },
	'maxapertureatmaxfocal' => { 112 => 0x1407, 144 => 'MaxApertureAtMaxFocal', 191 => 0xb, 192 => 0x10, 193 => 0x11, 257 => 0x206 },
	'maxapertureatminfocal' => { 112 => 0x1406, 191 => 0xa, 192 => 0xf, 193 => 0x10, 257 => 0x205 },
	'maxaperturevalue' => { 107 => 0x9205, 320 => 0x414, 413 => 'MaxApertureValue' },
	'maxavailheight' => { 419 => 'MaxAvailHeight' },
	'maxavailwidth' => { 419 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 241 => 0xb, 242 => 0xc, 244 => '12.1', 249 => 0xc, 250 => 0xb, 253 => '12.1' },
	'maxfaces' => { 260 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x116, 31 => 0x17, 112 => 0x1405, 144 => 'MaxFocalLength', 191 => 0x9, 192 => 0xe, 193 => 0xf, 257 => 0x208, 376 => 0x127c, 377 => 0x1138, 378 => 0x330, 379 => 0x330 },
	'maximumdensityrange' => { 117 => 0x8c },
	'maxpagesize' => { 438 => 'MaxPageSize' },
	'maxpagesizeh' => { 438 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 438 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 438 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 107 => 0x119 },
	'maxstorage' => { 428 => 'maxstorage' },
	'mb-d10batteries' => { 241 => '12.6' },
	'mb-d10batterytype' => { 249 => '13.3' },
	'mb-d11batterytype' => { 250 => '2.3' },
	'mb-d12batterytype' => { 253 => '3.2' },
	'mb-d80batteries' => { 251 => '6.5' },
	'mb-d80batterytype' => { 254 => '3.2' },
	'mcuversion' => { 191 => 0xc, 192 => 0x11, 193 => 0x12 },
	'md5digest' => { 145 => 'zmd5' },
	'meal' => { 425 => 'meal' },
	'measuredev' => { 26 => 0x9, 67 => 0x3, 86 => 0x1814, 137 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 26 => 0x8, 67 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 165 => 0x690, 273 => 0x312, 279 => 0x3407 },
	'measuredrggb' => { 56 => 0x1 },
	'measuredrggbdata' => { 37 => 0x287 },
	'measurementaccuracy' => { 106 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 106 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 106 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 106 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 106 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 106 => 'MeasurementOrFact' },
	'measurementremarks' => { 106 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 106 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 106 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 106 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 266 => 'MediaConstraints' },
	'mediacreatedate' => { 328 => 0x1 },
	'mediamodifydate' => { 328 => 0x2 },
	'mediasummarycode' => { 266 => 'MediaSummaryCode' },
	'memoaudioquality' => { 73 => 0x812 },
	'memorycardconfiguration' => { 359 => 0x16 },
	'memorycardnumber' => { 183 => 0x2 },
	'menubuttondisplayposition' => { 71 => 0xb, 74 => 0xa, 75 => 0xb, 78 => 0xb },
	'menubuttonreturn' => { 79 => 0xb },
	'menumonitorofftime' => { 241 => '26.1', 242 => '22.1', 244 => '22.1', 248 => '21.1', 249 => '8.2', 250 => '21.1', 253 => '22.1', 254 => '22.1' },
	'metadatadate' => { 431 => 'MetadataDate' },
	'metadatamoddate' => { 433 => 'metadataModDate' },
	'metaversion' => { 371 => 0x34 },
	'meterinfo1row1' => { 366 => 0x0 },
	'meterinfo1row2' => { 366 => 0x6c },
	'meterinfo1row3' => { 366 => 0xd8 },
	'meterinfo1row4' => { 366 => 0x144 },
	'meterinfo1row5' => { 366 => 0x1b0 },
	'meterinfo1row6' => { 366 => 0x21c },
	'meterinfo1row7' => { 366 => 0x288 },
	'meterinfo2row1' => { 366 => 0x2f4 },
	'meterinfo2row2' => { 366 => 0x378 },
	'meterinfo2row3' => { 366 => 0x3fc },
	'meterinfo2row4' => { 366 => 0x480 },
	'meterinfo2row5' => { 366 => 0x504 },
	'meterinfo2row6' => { 366 => 0x588 },
	'meterinfo2row7' => { 366 => 0x60c },
	'meterinfo2row8' => { 366 => 0x690 },
	'meterinfo2row9' => { 366 => 0x714 },
	'metering' => { 243 => '6.1' },
	'meteringmode' => { 31 => 0x11, 107 => 0x9207, 123 => 0x1c, 159 => 0x7, 160 => 0x25, 162 => 0x12, 256 => 0x202, 311 => 0x17, 345 => 0x9, 353 => 0x15, 354 => 0x13, 355 => 0x7, 369 => 0x3, 372 => 0x1174, 373 => 0x1178, 374 => 0x1154, 375 => 0x11d0, 376 => 0x11ac, 377 => 0x1064, 378 => 0x25c, 379 => 0x25c, 413 => 'MeteringMode' },
	'meteringmode2' => { 292 => '2.1' },
	'meteringmode3' => { 292 => '16.1' },
	'meteringoffscaleindicator' => { 162 => 0x53 },
	'meteringtime' => { 241 => '22.2', 243 => '3.2', 245 => '17.1', 246 => '18.1', 249 => '7.3', 250 => '18.1', 251 => '3.2', 254 => '19.1' },
	'mieversion' => { 145 => '0Vers' },
	'minaperture' => { 31 => 0x1b, 144 => 'MinAperture', 302 => '0.2', 381 => 0x1 },
	'minaperturevalue' => { 320 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x114, 31 => 0x18, 112 => 0x1404, 144 => 'MinFocalLength', 191 => 0x8, 192 => 0xd, 193 => 0xe, 257 => 0x207, 376 => 0x127a, 377 => 0x1136, 378 => 0x32e, 379 => 0x32e },
	'minfocusdistance' => { 302 => 0x3 },
	'minoltadate' => { 159 => 0x15 },
	'minoltaimagesize' => { 159 => 0x4, 160 => 0xc, 161 => 0x2, 164 => 0x103 },
	'minoltamodelid' => { 159 => 0x25 },
	'minoltaquality' => { 159 => 0x5, 160 => 0xd, 161 => 0x3, 164 => [0x102,0x103] },
	'minoltatime' => { 159 => 0x16 },
	'minormodelagedisclosure' => { 266 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 107 => 0x118 },
	'mirrorlockup' => { 71 => 0xc, 72 => 0xc, 73 => 0x60f, 74 => 0xb, 75 => 0xc, 76 => 0x6, 77 => 0x6, 78 => 0xc, 79 => 0x3 },
	'mobilecountrycode' => { 407 => 'mcc' },
	'mobilenetworkcode' => { 407 => 'mnc' },
	'moddate' => { 269 => 'modify-date', 420 => 'ModDate' },
	'modedialposition' => { 359 => 0x14 },
	'model' => { 87 => 0x6, 107 => 0x110, 137 => 'Model', 269 => 'Model', 281 => 0x110, 345 => 0x84, 422 => 'model', 429 => 'Model' },
	'modelage' => { 419 => 'ModelAge' },
	'modelid' => { 255 => 0x0 },
	'modelingflash' => { 241 => '21.4', 242 => '31.1', 244 => '31.1', 249 => '26.4', 250 => '30.2', 251 => '7.4', 252 => '30.1', 253 => '31.1', 254 => '31.3' },
	'modelreleaseid' => { 266 => 'ModelReleaseID' },
	'modelreleasestatus' => { 266 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 382 => 0x52, 383 => 0x46, 384 => 0x53 },
	'modelyear' => { 422 => 'modelYear' },
	'modificationdate' => { 423 => 'modificationDate' },
	'modifiedcolortemp' => { 57 => 0x9 },
	'modifieddigitalgain' => { 57 => 0xb },
	'modifiedparamflag' => { 50 => 0x1 },
	'modifiedpicturestyle' => { 57 => 0xa },
	'modifiedsaturation' => { 256 => 0x504 },
	'modifiedsensorbluelevel' => { 57 => 0x5 },
	'modifiedsensorredlevel' => { 57 => 0x4 },
	'modifiedsharpness' => { 57 => 0x2 },
	'modifiedsharpnessfreq' => { 57 => 0x3 },
	'modifiedtonecurve' => { 57 => 0x1 },
	'modifiedwhitebalance' => { 57 => 0x8 },
	'modifiedwhitebalanceblue' => { 57 => 0x7 },
	'modifiedwhitebalancered' => { 57 => 0x6 },
	'modifydate' => { 107 => 0x132, 138 => 'ModifyDate', 265 => 'ModDate', 267 => 'tIME', 327 => 'ModDate', 329 => 0x2, 431 => 'ModifyDate' },
	'moirefilter' => { 107 => 0xfe58, 409 => 'MoireFilter' },
	'monitordisplayoff' => { 162 => 0x4c },
	'monitorofftime' => { 241 => '18.2', 243 => '3.1', 251 => '3.1' },
	'monochromecolor' => { 256 => 0x53b },
	'monochromecontrast' => { 98 => 0x3c },
	'monochromefiltereffect' => { 92 => 0x20307, 98 => 0x3a, 311 => 0x73 },
	'monochromelinear' => { 98 => 0x3d },
	'monochromeoutputhighlightpoint' => { 98 => 0x41 },
	'monochromeoutputshadowpoint' => { 98 => 0x42 },
	'monochromeprofilesettings' => { 256 => 0x537 },
	'monochromerawhighlight' => { 98 => 0x7a },
	'monochromerawhighlightpoint' => { 98 => 0x3f },
	'monochromerawshadow' => { 98 => 0x83 },
	'monochromerawshadowpoint' => { 98 => 0x40 },
	'monochromesharpness' => { 98 => 0x3e },
	'monochrometoning' => { 311 => 0x74 },
	'monochrometoningeffect' => { 92 => 0x20306, 98 => 0x3b },
	'monochromeunsharpmaskfineness' => { 98 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 98 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 98 => 0xb4 },
	'monochromevignetting' => { 256 => 0x53a },
	'monthdaycreated' => { 123 => 0x12, 132 => 0xe },
	'moonphase' => { 332 => 0x12 },
	'morepermissions' => { 406 => 'morePermissions' },
	'motionsensitivity' => { 332 => 0x29 },
	'movieaelockbuttonassignment' => { 253 => '40.1' },
	'moviefunctionbutton' => { 242 => '41.1', 253 => '41.1' },
	'moviefunctionbuttonplusdials' => { 242 => '52.1' },
	'moviepreviewbutton' => { 242 => '41.2', 244 => ['41.1','41.2'], 253 => '41.2' },
	'moviepreviewbuttonplusdials' => { 242 => '52.2' },
	'movieshutterbutton' => { 242 => '38.3', 244 => '38.3', 253 => '38.3' },
	'moviesubselectorassignment' => { 242 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 242 => '53.1' },
	'multiburstimageheight' => { 365 => 0x1002 },
	'multiburstimagewidth' => { 365 => 0x1001 },
	'multiburstmode' => { 365 => 0x1000 },
	'multicontrollerwhilemetering' => { 73 => 0x517 },
	'multiexposure' => { 59 => 0x1 },
	'multiexposureautogain' => { 197 => 0x3 },
	'multiexposurecontrol' => { 59 => 0x2 },
	'multiexposuremode' => { 197 => 0x1 },
	'multiexposureshots' => { 59 => 0x3, 197 => 0x2 },
	'multiframenoisereduction' => { 355 => 0x35, 365 => 0x200b, 369 => 0x15 },
	'multifunctionlock' => { 73 => 0x70f },
	'multipleexposuremode' => { 260 => 0x101c },
	'multipleexposureset' => { 292 => '10.1' },
	'multisample' => { 203 => 0x40 },
	'multiselector' => { 241 => '9.4', 242 => '10.3', 244 => '10.3', 249 => '27.4', 253 => '10.3' },
	'multiselectorliveview' => { 241 => '4.3', 244 => '37.1', 253 => '37.1' },
	'multiselectorliveviewmode' => { 213 => 0x18c2 },
	'multiselectorplaybackmode' => { 241 => ['13.5','9.2'], 242 => '10.2', 244 => '10.2', 249 => '27.2', 253 => '10.2' },
	'multiselectorshootmode' => { 241 => '9.1', 242 => '10.1', 244 => '10.1', 249 => '27.1', 253 => '10.1' },
	'mycolormode' => { 60 => 0x2 },
	'nationalcatalognumber' => { 423 => 'nationalCatalogNumber' },
	'nativedigest' => { 413 => 'NativeDigest', 429 => 'NativeDigest' },
	'ncdfileinfo' => { 121 => 0x414 },
	'ndfilter' => { 67 => 0x1c, 256 => 0x204, 336 => 0x1019 },
	'nefbitdepth' => { 196 => 0xe22 },
	'nefcompression' => { 196 => 0x93 },
	'neflinearizationtable' => { 196 => 0x96 },
	'negativecachelargepreviewsize' => { 409 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 409 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 409 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 311 => 0x88 },
	'neutraloutputhighlightpoint' => { 98 => 0x2f },
	'neutraloutputshadowpoint' => { 98 => 0x30 },
	'neutralrawcolortone' => { 98 => 0x28 },
	'neutralrawcontrast' => { 98 => 0x2a },
	'neutralrawhighlight' => { 98 => 0x78 },
	'neutralrawhighlightpoint' => { 98 => 0x2d },
	'neutralrawlinear' => { 98 => 0x2b },
	'neutralrawsaturation' => { 98 => 0x29 },
	'neutralrawshadow' => { 98 => 0x81 },
	'neutralrawshadowpoint' => { 98 => 0x2e },
	'neutralrawsharpness' => { 98 => 0x2c },
	'neutralunsharpmaskfineness' => { 98 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 98 => 0xa8 },
	'neutraunsharpmaskstrength' => { 98 => 0xa4 },
	'newrawimagedigest' => { 107 => 0xc7a7 },
	'newsphotoversion' => { 117 => 0x0 },
	'nickname' => { 431 => 'Nickname' },
	'nikoncapturedata' => { 196 => 0xe01 },
	'nikoncaptureeditversions' => { 196 => 0xe13 },
	'nikoncaptureoutput' => { 196 => 0xe1e },
	'nikoncaptureversion' => { 196 => 0xe09 },
	'nikoniccprofile' => { 196 => 0xe1d },
	'nikonimagesize' => { 210 => '723.1', 211 => '732.1', 220 => 0x2c4 },
	'noisefilter' => { 256 => 0x527 },
	'noiseprofile' => { 107 => 0xc761 },
	'noisereduction' => { 112 => 0x100b, 160 => 0xb0, 161 => 0x60, 162 => 0x3f, 196 => 0x95, 234 => 0x753dcbc0, 235 => 0x17, 256 => 0x50a, 261 => 0x103a, 277 => 0x2d, 311 => 0x49, 336 => 0x100f, 338 => 0x2a },
	'noisereduction2' => { 260 => 0x1010 },
	'noisereductionapplied' => { 107 => 0xc6f7 },
	'noisereductionintensity' => { 235 => 0x9 },
	'noisereductionmethod' => { 235 => 0x11 },
	'noisereductionmode' => { 394 => 0x801e },
	'noisereductionsharpness' => { 235 => 0xd },
	'noisereductionvalue' => { 394 => 0x8027 },
	'nomemorycard' => { 241 => '22.1', 242 => '4.2', 243 => '0.3', 245 => '2.4', 246 => '3.2', 247 => '3.2', 249 => '33.7', 250 => '3.2', 251 => '0.3', 253 => '4.2', 254 => '4.5' },
	'nominalmaxaperture' => { 302 => 0xa },
	'nominalminaperture' => { 302 => '10.1' },
	'normalwhitelevel' => { 38 => [0x2b8,0x2cf,0x2d3], 40 => 0x1e3, 41 => [0x1fc,0x2dc], 42 => [0x230,0x30e] },
	'notes' => { 395 => 'Notes', 403 => 'notes' },
	'npages' => { 438 => 'NPages' },
	'nrwdata' => { 196 => 0x14 },
	'nullrecord' => { 86 => 0x0 },
	'numafpoints' => { 288 => 0x2 },
	'number' => { 423 => 'number' },
	'numberofbeats' => { 433 => 'numberOfBeats' },
	'numberoffocuspoints' => { 244 => '1.2', 247 => '0.2', 248 => '0.3', 250 => '0.3' },
	'numfacepositions' => { 271 => 0x0 },
	'numindexentries' => { 117 => 0x54 },
	'numwbentries' => { 282 => 0x0, 283 => 0x0 },
	'object' => { 423 => 'object' },
	'objectattributereference' => { 115 => 0x4 },
	'objectcycle' => { 115 => 0x4b, 403 => 'ObjectCycle' },
	'objectdescription' => { 422 => 'objectDescription' },
	'objectdistance' => { 101 => 0x6, 102 => 0x2022 },
	'objectname' => { 115 => 0x5 },
	'objectpreviewdata' => { 115 => 0xca },
	'objectpreviewfileformat' => { 115 => 0xc8 },
	'objectpreviewfileversion' => { 115 => 0xc9 },
	'objectsubtype' => { 422 => 'objectSubtype' },
	'objecttype' => { 422 => 'objectType' },
	'objecttypereference' => { 115 => 0x3 },
	'occurrence' => { 106 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 106 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 106 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 106 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 106 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 106 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 106 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 106 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 106 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 106 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 106 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 106 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 106 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 106 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 106 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 106 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 106 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 106 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 106 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 106 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 106 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 106 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 106 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 106 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 413 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 413 => [\'OECF','OECFNames'] },
	'oecfrows' => { 413 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 413 => [\'OECF','OECFValues'] },
	'offsaledate' => { 423 => 'offSaleDate' },
	'offsaledatea-platform' => { 423 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 423 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 107 => 0xea1d },
	'okbutton' => { 250 => '15.1', 254 => '16.1' },
	'oldsubfiletype' => { 107 => 0xff },
	'olympusimageheight' => { 261 => 0x102f },
	'olympusimagewidth' => { 261 => 0x102e },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 261 => 0x302 },
	'onsaledate' => { 423 => 'onSaleDate' },
	'onsaledatea-platform' => { 423 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 423 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 423 => 'onSaleDay' },
	'onsaledaya-platform' => { 423 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 423 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 107 => 0xc740 },
	'opcodelist2' => { 107 => 0xc741 },
	'opcodelist3' => { 107 => 0xc74e },
	'opticalzoom' => { 125 => 0xfa3d, 127 => [0x6006,0xf006], 128 => 0x1000, 129 => 0xf, 132 => 0x1e, 144 => 'OpticalZoom' },
	'opticalzoomcode' => { 67 => 0xa },
	'opticalzoommode' => { 277 => 0x34 },
	'opticalzoomon' => { 344 => 0x219 },
	'optionenddate' => { 426 => 'optionEndDate' },
	'opto-electricconvfactor' => { 413 => 'OECF' },
	'orangehsl' => { 92 => 0x20911 },
	'ordernumber' => { 112 => 0x8002 },
	'organisationinimagecode' => { 419 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 419 => 'OrganisationInImageName' },
	'organization' => { 423 => 'organization' },
	'orientation' => { 107 => 0x112, 281 => 0x112, 422 => 'orientation', 429 => 'Orientation' },
	'orientation2' => { 369 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 73 => 0x516 },
	'originalbestqualitysize' => { 107 => 0xc792 },
	'originaldecisiondata' => { 103 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 55 => 0x83 },
	'originaldefaultcropsize' => { 107 => 0xc793 },
	'originaldefaultfinalsize' => { 107 => 0xc791 },
	'originaldirectory' => { 275 => 0x408 },
	'originaldocumentid' => { 434 => 'OriginalDocumentID' },
	'originalfilename' => { 86 => 0x816, 121 => 0x3e9, 133 => 0x20, 275 => 0x407, 399 => 'OriginalFilename' },
	'originalimageheight' => { 69 => 0xc, 111 => 0x1 },
	'originalimagewidth' => { 69 => 0xb, 111 => 0x0 },
	'originalrawfiledata' => { 107 => 0xc68c },
	'originalrawfiledigest' => { 107 => 0xc71d },
	'originalrawfilename' => { 107 => 0xc68b },
	'originaltransmissionreference' => { 115 => 0x67 },
	'originatingprogram' => { 115 => 0x41, 403 => 'OriginatingProgram' },
	'originplatform' => { 423 => 'originPlatform' },
	'os' => { 411 => 'os' },
	'otherconditions' => { 266 => 'OtherConditions' },
	'otherconstraints' => { 266 => 'OtherConstraints' },
	'otherimage' => { 103 => 'OtherImage' },
	'otherimageinfo' => { 266 => 'OtherImageInfo' },
	'otherimagelength' => { 107 => 0x202 },
	'otherimagestart' => { 107 => 0x201 },
	'otherlicensedocuments' => { 266 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 266 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 266 => 'OtherLicenseRequirements' },
	'outcue' => { 433 => 'outCue' },
	'outcuescale' => { 433 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 433 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 174 => 0x3 },
	'outputimagewidth' => { 174 => 0x2 },
	'outputprofile' => { 121 => 0x138b },
	'outputresolution' => { 174 => 0x4 },
	'owner' => { 437 => 'Owner' },
	'ownerid' => { 115 => 0xbc },
	'ownername' => { 14 => 0x10f, 55 => 0x9, 86 => 0x810, 107 => [0xa430,0xfde8], 137 => 'OwnerName', 405 => 'OwnerName', 414 => 'CameraOwnerName' },
	'padding' => { 107 => 0xea1c },
	'pagecount' => { 423 => 'pageCount' },
	'pageimage' => { 431 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 431 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 431 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 431 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 431 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 431 => 'PageInfo' },
	'pagename' => { 107 => 0x11d },
	'pagenumber' => { 107 => 0x129 },
	'pageprogressiondirection' => { 423 => 'pageProgressionDirection' },
	'pagerange' => { 423 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 409 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 409 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 277 => 0x26 },
	'panasonicimageheight' => { 277 => 0x4c },
	'panasonicimagewidth' => { 277 => 0x4b },
	'panasonicrawversion' => { 281 => 0x1 },
	'panasonictitle' => { 107 => 0xc6d2 },
	'panasonictitle2' => { 107 => 0xc6d3 },
	'panoramacropbottom' => { 370 => 0x7 },
	'panoramacropleft' => { 370 => 0x4 },
	'panoramacropright' => { 370 => 0x6 },
	'panoramacroptop' => { 370 => 0x5 },
	'panoramadirection' => { 63 => 0x5, 370 => 0x3 },
	'panoramaframeheight' => { 370 => 0x9 },
	'panoramaframenumber' => { 63 => 0x2 },
	'panoramaframewidth' => { 370 => 0x8 },
	'panoramafullheight' => { 370 => 0x2 },
	'panoramafullwidth' => { 370 => 0x1 },
	'panoramamode' => { 123 => 0x3c, 256 => 0x601 },
	'panoramasize3d' => { 355 => 0x38 },
	'panoramasourceheight' => { 370 => 0xb },
	'panoramasourcewidth' => { 370 => 0xa },
	'panoramicstitchcameramotion' => { 155 => 'PanoramicStitchCameraMotion', 156 => 0x1 },
	'panoramicstitchmaptype' => { 155 => 'PanoramicStitchMapType', 156 => 0x2 },
	'panoramicstitchphi0' => { 155 => 'PanoramicStitchPhi0', 156 => 0x5 },
	'panoramicstitchphi1' => { 155 => 'PanoramicStitchPhi1', 156 => 0x6 },
	'panoramicstitchtheta0' => { 155 => 'PanoramicStitchTheta0', 156 => 0x3 },
	'panoramicstitchtheta1' => { 155 => 'PanoramicStitchTheta1', 156 => 0x4 },
	'panoramicstitchversion' => { 156 => 0x0 },
	'pantry' => { 434 => 'Pantry' },
	'parallax' => { 112 => 0xb211, 255 => 0x28 },
	'parametricdarks' => { 409 => 'ParametricDarks' },
	'parametrichighlights' => { 409 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 409 => 'ParametricHighlightSplit' },
	'parametriclights' => { 409 => 'ParametricLights' },
	'parametricmidtonesplit' => { 409 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 409 => 'ParametricShadows' },
	'parametricshadowsplit' => { 409 => 'ParametricShadowSplit' },
	'parentmeid' => { 399 => 'ParentMEID' },
	'parentreference1' => { 417 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 417 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 433 => 'partOfCompilation' },
	'patientbirthdate' => { 396 => 'PatientDOB' },
	'patientid' => { 396 => 'PatientID' },
	'patientname' => { 396 => 'PatientName' },
	'patientsex' => { 396 => 'PatientSex' },
	'pdfversion' => { 420 => 'PDFVersion' },
	'pentaximagesize' => { 311 => 0x9 },
	'pentaxmodelid' => { 291 => 0x0, 311 => 0x5 },
	'pentaxmodeltype' => { 311 => 0x1 },
	'pentaxversion' => { 311 => 0x0 },
	'people' => { 397 => 'People', 401 => 'People' },
	'perchannelblacklevel' => { 37 => 0xc4, 38 => [0x2b4,0x2cb,0x2cf], 39 => 0x108, 40 => 0x1df, 41 => [0x1f8,0x2d8], 42 => [0x22c,0x30a] },
	'peripheralillumcentralradius' => { 394 => 0x8030 },
	'peripheralillumcentralvalue' => { 394 => 0x8031 },
	'peripheralillumination' => { 92 => 0x20702, 98 => 0x68 },
	'peripheralilluminationcorr' => { 54 => 0x1, 301 => 0x2 },
	'peripheralilluminationon' => { 92 => '0x20702.0', 98 => 0x64 },
	'peripheralillumperiphvalue' => { 394 => 0x8032 },
	'peripherallighting' => { 69 => 0x2 },
	'peripherallightingsetting' => { 70 => 0x5 },
	'peripherallightingvalue' => { 69 => 0x6 },
	'permissions' => { 426 => 'permissions' },
	'permits' => { 406 => 'permits' },
	'person' => { 423 => 'person' },
	'personality' => { 399 => 'Personality' },
	'personinimage' => { 419 => 'PersonInImage' },
	'personinimagecharacteristic' => { 419 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 419 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 419 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 419 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 419 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 419 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 419 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 419 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 419 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 409 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 409 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 409 => 'PerspectiveRotate' },
	'perspectivescale' => { 409 => 'PerspectiveScale' },
	'perspectiveupright' => { 409 => 'PerspectiveUpright' },
	'perspectivevertical' => { 409 => 'PerspectiveVertical' },
	'perspectivex' => { 409 => 'PerspectiveX' },
	'perspectivey' => { 409 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 81 => 0x1 },
	'pf10retainprogramshift' => { 81 => 0xb },
	'pf13drivepriority' => { 81 => 0xe },
	'pf14disablefocussearch' => { 81 => 0xf },
	'pf15disableafassistbeam' => { 81 => 0x10 },
	'pf16autofocuspointshoot' => { 81 => 0x11 },
	'pf17disableafpointsel' => { 81 => 0x12 },
	'pf18enableautoafpointsel' => { 81 => 0x13 },
	'pf19continuousshootspeed' => { 81 => 0x14 },
	'pf19shootingspeedhigh' => { 80 => 0xa },
	'pf19shootingspeedlow' => { 80 => 0x9 },
	'pf1disableshootingmodes' => { 81 => 0x2 },
	'pf1value' => { 80 => 0x1 },
	'pf20limitcontinousshots' => { 81 => 0x15 },
	'pf20maxcontinousshots' => { 80 => 0xb },
	'pf21enablequietoperation' => { 81 => 0x16 },
	'pf23felocktime' => { 80 => 0xd },
	'pf23postreleasetime' => { 80 => 0xe },
	'pf23settimerlengths' => { 81 => 0x18 },
	'pf23shutterbuttontime' => { 80 => 0xc },
	'pf24lightlcdduringbulb' => { 81 => 0x19 },
	'pf25aemode' => { 80 => 0xf },
	'pf25afmode' => { 80 => 0x12 },
	'pf25afpointsel' => { 80 => 0x13 },
	'pf25colormatrix' => { 80 => 0x17 },
	'pf25defaultclearsettings' => { 81 => 0x1a },
	'pf25drivemode' => { 80 => 0x11 },
	'pf25imagesize' => { 80 => 0x14 },
	'pf25meteringmode' => { 80 => 0x10 },
	'pf25parameters' => { 80 => 0x16 },
	'pf25wbmode' => { 80 => 0x15 },
	'pf26shortenreleaselag' => { 81 => 0x1b },
	'pf27reversedialrotation' => { 81 => 0x1c },
	'pf27value' => { 80 => 0x18 },
	'pf28noquickdialexpcomp' => { 81 => 0x1d },
	'pf29quickdialswitchoff' => { 81 => 0x1e },
	'pf2disablemeteringmodes' => { 81 => 0x3 },
	'pf2value' => { 80 => 0x2 },
	'pf30enlargementmode' => { 81 => 0x1f },
	'pf31originaldecisiondata' => { 81 => 0x20 },
	'pf3manualexposuremetering' => { 81 => 0x4 },
	'pf3value' => { 80 => 0x3 },
	'pf4exposuretimelimits' => { 81 => 0x5 },
	'pf4exposuretimemax' => { 80 => 0x5 },
	'pf4exposuretimemin' => { 80 => 0x4 },
	'pf5aperturelimits' => { 81 => 0x6 },
	'pf5aperturemax' => { 80 => 0x7 },
	'pf5aperturemin' => { 80 => 0x6 },
	'pf6presetshootingmodes' => { 81 => 0x7 },
	'pf7bracketcontinuousshoot' => { 81 => 0x8 },
	'pf8bracketshots' => { 80 => 0x8 },
	'pf8setbracketshots' => { 81 => 0x9 },
	'pf9changebracketsequence' => { 81 => 0xa },
	'phasedetectaf' => { 171 => 0x6 },
	'phonenumber' => { 138 => 'Phone' },
	'photoeffect' => { 31 => 0x28 },
	'photoeffecthistoryxml' => { 234 => 0xe9651831 },
	'photoeffects' => { 234 => 0xab5eca5e },
	'photoeffectsblue' => { 236 => 0x8 },
	'photoeffectsgreen' => { 236 => 0x6 },
	'photoeffectsred' => { 236 => 0x4 },
	'photoeffectstype' => { 236 => 0x0 },
	'photographicsensitivity' => { 414 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 241 => '17.6', 249 => '33.6' },
	'photometricinterpretation' => { 107 => 0x106, 429 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 214 => 0xe7d },
	'photoshootingmenubankimagearea' => { 214 => '3716.1' },
	'photoshopbgrthumbnail' => { 325 => 0x409 },
	'photoshopquality' => { 324 => 0x0 },
	'photoshopthumbnail' => { 325 => 0x40c },
	'photostyle' => { 277 => 0x89 },
	'picklabel' => { 412 => 'PickLabel' },
	'pictinfo' => { 344 => 0x208 },
	'picturecontrol' => { 234 => 0xe2173c47 },
	'picturecontrolactive' => { 237 => 0x0 },
	'picturecontroladjust' => { 198 => 0x30, 199 => 0x30 },
	'picturecontrolbase' => { 198 => 0x18, 199 => 0x18 },
	'picturecontroldata' => { 196 => [0xbd,0x23] },
	'picturecontrolmode' => { 237 => 0x13 },
	'picturecontrolname' => { 198 => 0x4, 199 => 0x4 },
	'picturecontrolquickadjust' => { 198 => 0x31, 199 => 0x31 },
	'pictureeffect' => { 365 => 0x200e },
	'pictureeffect2' => { 372 => 0x1163, 373 => 0x1167, 374 => 0x1143, 375 => 0x11bf, 376 => 0x119b, 377 => 0x1053, 378 => 0x24b, 379 => 0x24b, 390 => 0x46 },
	'picturefinish' => { 160 => 0x71 },
	'picturemode' => { 112 => 0x1031, 256 => 0x520, 311 => [0xb,0x33], 345 => 0x3d },
	'picturemode2' => { 292 => 0x0 },
	'picturemodebwfilter' => { 256 => 0x525 },
	'picturemodecontrast' => { 256 => 0x523 },
	'picturemodeeffect' => { 256 => 0x52d },
	'picturemodehue' => { 256 => 0x522 },
	'picturemodesaturation' => { 256 => 0x521 },
	'picturemodesharpness' => { 256 => 0x524 },
	'picturemodetone' => { 256 => 0x526 },
	'pictureprofile' => { 372 => [0x115e,0x115f], 373 => [0x1162,0x1163], 374 => [0x113e,0x113f], 375 => [0x11ba,0x11bb], 376 => [0x1196,0x1197], 377 => [0x104e,0x104f], 378 => [0x246,0x247], 379 => [0x246,0x247] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 65 => 0xa, 92 => 0x20301, 98 => 0x2 },
	'picturewizard' => { 342 => 0x21 },
	'picturewizardcolor' => { 341 => 0x1 },
	'picturewizardcontrast' => { 341 => 0x4 },
	'picturewizardmode' => { 341 => 0x0 },
	'picturewizardsaturation' => { 341 => 0x2 },
	'picturewizardsharpness' => { 341 => 0x3 },
	'pipelineversion' => { 155 => 'PipelineVersion' },
	'pitch' => { 104 => 0x6, 242 => '4.1', 253 => '4.1' },
	'pitchangle' => { 213 => 0x350f, 222 => 0x36f8, 256 => 0x904, 277 => 0x91, 310 => 0x2 },
	'pixelshiftresolution' => { 312 => 0x0 },
	'pixelsperunitx' => { 268 => 0x0 },
	'pixelsperunity' => { 268 => 0x4 },
	'pixelunits' => { 268 => 0x8 },
	'planarconfiguration' => { 107 => 0x11c, 429 => 'PlanarConfiguration' },
	'platenames' => { 438 => 'PlateNames' },
	'platform' => { 423 => 'platform' },
	'playbackmenustime' => { 245 => '20.1', 246 => '21.1', 247 => '21.1' },
	'playbackmonitorofftime' => { 241 => '25.2', 242 => '36.1', 244 => '36.1', 248 => '35.1', 249 => '8.1', 250 => '35.1', 253 => '36.1', 254 => '21.1' },
	'playbackzoom' => { 242 => '37.1' },
	'playdisplay' => { 162 => 0x4e },
	'plusversion' => { 266 => 'Version' },
	'pmversion' => { 323 => 'PMVersion' },
	'pngwarning' => { 269 => 'Warning' },
	'poilevel' => { 195 => 0x8 },
	'portraitoutputhighlightpoint' => { 98 => 0x1d },
	'portraitoutputshadowpoint' => { 98 => 0x1e },
	'portraitrawcolortone' => { 98 => 0x16 },
	'portraitrawcontrast' => { 98 => 0x18 },
	'portraitrawhighlight' => { 98 => 0x76 },
	'portraitrawhighlightpoint' => { 98 => 0x1b },
	'portraitrawlinear' => { 98 => 0x19 },
	'portraitrawsaturation' => { 98 => 0x17 },
	'portraitrawshadow' => { 98 => 0x7f },
	'portraitrawshadowpoint' => { 98 => 0x1c },
	'portraitrawsharpness' => { 98 => 0x1a },
	'portraitrefiner' => { 102 => 0x302b },
	'portraitunsharpmaskfineness' => { 98 => 0x9a },
	'portraitunsharpmaskstrength' => { 98 => 0x98 },
	'portraitunsharpmaskthreshold' => { 98 => 0x9c },
	'poseheadingdegrees' => { 398 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 398 => 'PosePitchDegrees' },
	'poserolldegrees' => { 398 => 'PoseRollDegrees' },
	'positiondescriptor' => { 422 => 'positionDescriptor' },
	'postalcode' => { 142 => 'PostalCode' },
	'postcropvignetteamount' => { 409 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 409 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 409 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 409 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 409 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 409 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 363 => 0xb },
	'potentialface2position' => { 363 => 0x15 },
	'potentialface3position' => { 363 => 0x1f },
	'potentialface4position' => { 363 => 0x29 },
	'potentialface5position' => { 363 => 0x33 },
	'potentialface6position' => { 363 => 0x3d },
	'potentialface7position' => { 363 => 0x47 },
	'potentialface8position' => { 363 => 0x51 },
	'powersource' => { 290 => '0.1' },
	'poweruptime' => { 196 => 0xb6 },
	'precaptureframes' => { 261 => 0x300 },
	'predictor' => { 107 => 0x13d },
	'preflashreturnstrength' => { 211 => 0x28a },
	'prefs' => { 115 => 0xdd, 323 => 'Prefs' },
	'preservedfilename' => { 434 => 'PreservedFileName' },
	'presetwhitebalance' => { 162 => 0x24, 394 => 0x8002 },
	'presetwhitebalanceadj' => { 394 => 0x8014 },
	'previewapplicationname' => { 107 => 0xc716 },
	'previewapplicationversion' => { 107 => 0xc717 },
	'previewbutton' => { 241 => ['14.1','15.1'], 242 => '15.1', 244 => '15.1', 249 => '29.1', 250 => '14.1', 253 => '15.1' },
	'previewbuttonplusdials' => { 241 => ['14.2','15.2'], 242 => '15.2', 244 => '43.1', 249 => '31.2', 253 => '43.1' },
	'previewcolorspace' => { 107 => 0xc71a },
	'previewcropbottom' => { 322 => 0xef },
	'previewcropleft' => { 322 => 0xec },
	'previewcropright' => { 322 => 0xee },
	'previewcroptop' => { 322 => 0xed },
	'previewdate' => { 330 => 0x0 },
	'previewdatetime' => { 107 => 0xc71b },
	'previewimage' => { 102 => 0x2000, 103 => 'PreviewImage', 108 => 'PreviewImage', 110 => 0x4, 147 => 'data', 164 => 0x81, 261 => 0x280, 276 => 0x300, 365 => 0x2001 },
	'previewimageborders' => { 311 => 0x3e },
	'previewimageheight' => { 64 => 0x4, 125 => 0xfa58 },
	'previewimagelength' => { 64 => 0x2, 102 => 0x3, 107 => [0x117,0x202], 164 => 0x89, 200 => 0x202, 256 => 0x102, 261 => 0x1037, 311 => 0x3, 335 => 0x1e, 340 => 0x3, 345 => [0x1b,0x1d], 356 => 0x202 },
	'previewimagename' => { 147 => '1Name' },
	'previewimagesize' => { 102 => 0x2, 130 => 0x2, 147 => 'ImageSize', 311 => 0x2, 345 => [0x1c,0x1e], 365 => 0xb02c },
	'previewimagestart' => { 64 => 0x5, 102 => 0x4, 107 => [0x111,0x201], 164 => 0x88, 200 => 0x201, 256 => 0x101, 261 => 0x1036, 311 => 0x4, 335 => 0x1c, 340 => 0x2, 345 => [0x1a,0x1c], 356 => 0x201 },
	'previewimagetype' => { 147 => '0Type' },
	'previewimagevalid' => { 256 => 0x100, 261 => 0x1035 },
	'previewimagewidth' => { 64 => 0x3, 125 => 0xfa57 },
	'previewquality' => { 64 => 0x1 },
	'previewsettingsdigest' => { 107 => 0xc719 },
	'previewsettingsname' => { 107 => 0xc718 },
	'primaryafpoint' => { 171 => 0x7 },
	'primarychromaticities' => { 107 => 0x13f, 429 => 'PrimaryChromaticities' },
	'primaryslot' => { 214 => 0xe7f },
	'printim' => { 107 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 162 => 0x1d, 353 => 0x28 },
	'privatertkinfo' => { 400 => 'privateRTKInfo' },
	'processingsoftware' => { 107 => 0xb },
	'processversion' => { 409 => 'ProcessVersion' },
	'producer' => { 265 => 'Producer', 420 => 'Producer' },
	'productcode' => { 423 => 'productCode' },
	'productid' => { 116 => 0x32, 422 => 'productID' },
	'productidtype' => { 422 => 'productIDType' },
	'productinimage' => { 419 => 'ProductInImage' },
	'productinimagedescription' => { 419 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 419 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 419 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 291 => 0x2 },
	'productorserviceconstraints' => { 266 => 'ProductOrServiceConstraints' },
	'profession' => { 423 => 'profession' },
	'profilecalibrationsig' => { 107 => 0xc6f4 },
	'profilecopyright' => { 107 => 0xc6fe },
	'profileembedpolicy' => { 107 => 0xc6fd },
	'profilehuesatmapdata1' => { 107 => 0xc6fa },
	'profilehuesatmapdata2' => { 107 => 0xc6fb },
	'profilehuesatmapdims' => { 107 => 0xc6f9 },
	'profilehuesatmapencoding' => { 107 => 0xc7a3 },
	'profilelooktabledata' => { 107 => 0xc726 },
	'profilelooktabledims' => { 107 => 0xc725 },
	'profilelooktableencoding' => { 107 => 0xc7a4 },
	'profilename' => { 107 => 0xc6f8 },
	'profiletonecurve' => { 107 => 0xc6fc },
	'programiso' => { 277 => 0x3c },
	'programline' => { 292 => '1.1' },
	'programmode' => { 167 => 0x5 },
	'programshift' => { 196 => 0xd },
	'programversion' => { 115 => 0x46 },
	'prohibits' => { 406 => 'prohibits' },
	'projectiontype' => { 398 => 'ProjectionType' },
	'projectname' => { 433 => 'projectName' },
	'projectref' => { 433 => 'projectRef' },
	'projectrefpath' => { 433 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 433 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 266 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 266 => 'PropertyReleaseStatus' },
	'province-state' => { 115 => 0x5f },
	'publicationdate' => { 423 => 'publicationDate' },
	'publicationdatea-platform' => { 423 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 423 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 423 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 423 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 423 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationname' => { 423 => 'publicationName' },
	'publisher' => { 410 => 'publisher' },
	'publishingfrequency' => { 423 => 'publishingFrequency' },
	'pulldown' => { 433 => 'pullDown' },
	'purplehsl' => { 92 => 0x20916 },
	'quality' => { 0 => 0x1, 31 => 0x3, 101 => 0x2, 102 => 0x3002, 112 => 0x1000, 123 => 0x9, 196 => 0x4, 224 => 0x3, 261 => 0x201, 273 => 0x300, 311 => 0x8, 318 => 0x2, 345 => 0x16, 353 => 0x56, 354 => 0x56, 355 => 0xb, 365 => 0x102 },
	'quality2' => { 372 => 0x1170, 373 => 0x1174, 374 => 0x1150, 376 => 0x11a8, 377 => 0x1060, 378 => 0x258, 379 => 0x258, 382 => 0x29, 383 => 0x25, 384 => 0x2a },
	'qualitymode' => { 102 => 0x8 },
	'quantizationmethod' => { 117 => 0x78 },
	'quickadjust' => { 237 => 0x2a },
	'quickcontroldialinmeter' => { 73 => 0x703 },
	'quickfix' => { 234 => 0x416391c6 },
	'quickshot' => { 344 => 0x213 },
	'rangefinder' => { 245 => '4.1', 246 => '5.1', 247 => '5.1' },
	'rasterizedcaption' => { 115 => 0x7d },
	'rating' => { 107 => 0x4746, 112 => 0x1431, 322 => 0xdf, 365 => 0x2002, 403 => 'rating', 411 => 'rating', 423 => 'rating', 431 => 'Rating' },
	'ratingpercent' => { 107 => 0x4749, 157 => 'Rating' },
	'rawandjpgrecording' => { 71 => 0x8, 164 => 0x109, 292 => 0xd },
	'rawbrightnessadj' => { 92 => 0x20001, 97 => 0x38 },
	'rawcoloradj' => { 97 => 0x2e },
	'rawcropbottom' => { 322 => 0xd4 },
	'rawcropleft' => { 322 => 0xd1 },
	'rawcropright' => { 322 => 0xd3 },
	'rawcroptop' => { 322 => 0xd2 },
	'rawcustomsaturation' => { 97 => 0x30 },
	'rawcustomtone' => { 97 => 0x34 },
	'rawdata' => { 342 => 0xa048 },
	'rawdatauniqueid' => { 107 => 0xc65d },
	'rawdepth' => { 166 => 0x10 },
	'rawdevartfilter' => { 263 => 0x121 },
	'rawdevautogradation' => { 263 => 0x119 },
	'rawdevcolorspace' => { 262 => 0x108, 263 => 0x109 },
	'rawdevcontrastvalue' => { 262 => 0x106, 263 => 0x105 },
	'rawdeveditstatus' => { 262 => 0x10b },
	'rawdevelopmentprocess' => { 311 => 0x62 },
	'rawdevengine' => { 262 => 0x109, 263 => 0x10b },
	'rawdevexposurebiasvalue' => { 262 => 0x100, 263 => 0x100 },
	'rawdevgradation' => { 263 => 0x112 },
	'rawdevgraypoint' => { 262 => 0x103, 263 => 0x104 },
	'rawdevmemorycoloremphasis' => { 262 => 0x105, 263 => 0x108 },
	'rawdevnoisereduction' => { 262 => 0x10a, 263 => 0x10a },
	'rawdevpicturemode' => { 263 => 0x10c },
	'rawdevpm_bwfilter' => { 263 => 0x110 },
	'rawdevpmcontrast' => { 263 => 0x10e },
	'rawdevpmnoisefilter' => { 263 => 0x120 },
	'rawdevpmpicturetone' => { 263 => 0x111 },
	'rawdevpmsaturation' => { 263 => 0x10d },
	'rawdevpmsharpness' => { 263 => 0x10f },
	'rawdevsaturation3' => { 263 => 0x113 },
	'rawdevsaturationemphasis' => { 262 => 0x104, 263 => 0x107 },
	'rawdevsettings' => { 262 => 0x10c },
	'rawdevsharpnessvalue' => { 262 => 0x107, 263 => 0x106 },
	'rawdevversion' => { 262 => 0x0, 263 => 0x0 },
	'rawdevwbfineadjustment' => { 262 => 0x102, 263 => 0x103 },
	'rawdevwhitebalance' => { 263 => 0x101 },
	'rawdevwhitebalancevalue' => { 262 => 0x101, 263 => 0x102 },
	'rawfile' => { 107 => 0xfe4c },
	'rawfilename' => { 409 => 'RawFileName' },
	'rawformat' => { 320 => 0x10e },
	'rawimagecenter' => { 196 => 0x99 },
	'rawimagedigest' => { 107 => 0xc71c },
	'rawimagesize' => { 311 => 0x39 },
	'rawinfoversion' => { 264 => 0x0 },
	'rawjpgheight' => { 88 => 0x4 },
	'rawjpgquality' => { 49 => 0x6, 88 => 0x1 },
	'rawjpgsize' => { 49 => 0x7, 88 => 0x2 },
	'rawjpgwidth' => { 88 => 0x3 },
	'rawmeasuredrggb' => { 36 => 0x26a, 38 => 0x280, 40 => 0x194, 41 => [0x1ad,0x26b] },
	'rawrppused' => { 403 => 'rawrppused' },
	'rawtopreviewgain' => { 107 => 0xc7a8 },
	'reardisplay' => { 241 => '12.3', 242 => '6.2' },
	'recipeendingpage' => { 425 => 'recipeEndingPage' },
	'recipepagerange' => { 425 => 'recipePageRange' },
	'recipesource' => { 425 => 'recipeSource' },
	'recipestartingpage' => { 425 => 'recipeStartingPage' },
	'recipetitle' => { 425 => 'recipeTitle' },
	'recognizedface1age' => { 272 => 0x20 },
	'recognizedface1name' => { 272 => 0x4 },
	'recognizedface1position' => { 272 => 0x18 },
	'recognizedface2age' => { 272 => 0x50 },
	'recognizedface2name' => { 272 => 0x34 },
	'recognizedface2position' => { 272 => 0x48 },
	'recognizedface3age' => { 272 => 0x80 },
	'recognizedface3name' => { 272 => 0x64 },
	'recognizedface3position' => { 272 => 0x78 },
	'recognizedfaceflags' => { 277 => 0x63 },
	'recommendedexposureindex' => { 107 => 0x8832, 414 => 'RecommendedExposureIndex' },
	'record' => { 106 => 'Record' },
	'recordbasisofrecord' => { 106 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 106 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 106 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 106 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 106 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 106 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 162 => 0x4d },
	'recorddynamicproperties' => { 106 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 86 => 0x1804 },
	'recordinformationwithheld' => { 106 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 336 => 0x1000 },
	'recordingmode' => { 101 => 0x1, 318 => 0x1 },
	'recordinstitutioncode' => { 106 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 106 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 31 => 0x9, 102 => 0x3000 },
	'recordownerinstitutioncode' => { 106 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 344 => 0x217 },
	'redbalance' => { 179 => 0x270, 261 => 0x1017, 281 => 0x11, 311 => 0x1c },
	'redcurvelimits' => { 97 => 0x18a },
	'redcurvepoints' => { 96 => 0x2d, 97 => 0x160 },
	'redeyecorrection' => { 238 => 0x0 },
	'redeyeinfo' => { 409 => 'RedEyeInfo' },
	'redeyereduction' => { 162 => 0x41, 353 => 0x6a, 355 => 0x28 },
	'redhsl' => { 92 => 0x20910 },
	'redhue' => { 409 => 'RedHue' },
	'redsaturation' => { 409 => 'RedSaturation' },
	'reductionmatrix1' => { 107 => 0xc625 },
	'reductionmatrix2' => { 107 => 0xc626 },
	'reelname' => { 107 => 0xc789 },
	'reference1' => { 417 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 417 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 107 => 0x214, 429 => 'ReferenceBlackWhite' },
	'referencedate' => { 115 => 0x2f },
	'referencenumber' => { 115 => 0x32 },
	'references' => { 138 => 'References' },
	'referenceservice' => { 115 => 0x2d },
	'regionappliedtodimensions' => { 153 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 153 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 153 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 153 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 153 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 153 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 153 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 153 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 153 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 153 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 153 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 153 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 266 => 'RegionConstraints' },
	'regiondescription' => { 153 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 153 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 153 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 153 => 'Regions' },
	'regioninfodateregionsvalid' => { 154 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 154 => 'RegionInfo' },
	'regioninforegions' => { 154 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 153 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 153 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 154 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 154 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 154 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 154 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 154 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 153 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 153 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 153 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 419 => 'RegistryId' },
	'registryitemid' => { 419 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 419 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 136 => 'data' },
	'relatedaudiofilename' => { 136 => '1Name' },
	'relatedaudiofiletype' => { 136 => '0Type' },
	'relatedimagefileformat' => { 107 => 0x1000 },
	'relatedimageheight' => { 107 => 0x1002 },
	'relatedimagewidth' => { 107 => 0x1001 },
	'relatedresourceid' => { 106 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 107 => 0xa004, 413 => 'RelatedSoundFile' },
	'relatedvideofile' => { 150 => 'data' },
	'relatedvideofilename' => { 150 => '1Name' },
	'relatedvideofiletype' => { 150 => '0Type' },
	'relation' => { 410 => 'relation' },
	'relationshipaccordingto' => { 106 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 106 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 106 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 106 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 433 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 433 => 'relativeTimestamp' },
	'relativetimestampscale' => { 433 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 433 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 241 => '17.8', 242 => '18.5', 244 => '18.4', 249 => '33.8', 250 => '17.6', 253 => '18.5' },
	'releasedate' => { 115 => 0x1e, 403 => 'ReleaseDate', 433 => 'releaseDate' },
	'releasemode' => { 102 => 0x3001, 213 => 0x184d, 365 => 0xb049 },
	'releasemode2' => { 372 => 0x112c, 373 => [0x112c,0x8], 374 => [0x1108,0x8], 375 => [0x1184,0x8], 376 => [0x1160,0x8], 377 => [0x4,0x1018], 378 => [0x4,0x210], 379 => [0x4,0x210], 381 => [0x67,0x73,0x3f,0x4b], 382 => 0x10, 383 => 0x10, 384 => 0x9, 390 => 0x34 },
	'releasemode3' => { 372 => 0x1128, 373 => 0x1128, 374 => 0x1104, 375 => 0x1180, 376 => 0x115c, 377 => 0x1014, 378 => 0x20c, 379 => 0x20c },
	'releasesetting' => { 86 => 0x1016 },
	'releasetime' => { 115 => 0x23, 403 => 'ReleaseTime' },
	'remoteonduration' => { 243 => '3.4', 245 => '17.2', 246 => '18.2', 247 => '18.2', 248 => '18.2', 250 => '18.2', 251 => '4.3', 254 => '19.2' },
	'renditionclass' => { 434 => 'RenditionClass' },
	'renditionof' => { 434 => 'RenditionOf' },
	'renditionofalternatepaths' => { 434 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 434 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 434 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 434 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 434 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 434 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 434 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 434 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 434 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 434 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 434 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 434 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 434 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 434 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 434 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 434 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 434 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 434 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 434 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 434 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 434 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 434 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 434 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 434 => 'RenditionParams' },
	'repeatingflashcount' => { 184 => 0xd, 185 => 0xe, 186 => 0xe, 249 => '17.2', 250 => '24.2', 251 => '9.2', 252 => '24.2', 254 => '25.2' },
	'repeatingflashcountbuilt-in' => { 221 => 0x4db },
	'repeatingflashcountexternal' => { 221 => 0x4c3 },
	'repeatingflashoutput' => { 249 => '17.1', 250 => '24.1', 251 => '9.1', 252 => '24.1', 254 => '25.1' },
	'repeatingflashoutputexternal' => { 221 => 0x4c0 },
	'repeatingflashrate' => { 184 => 0xc, 185 => 0xd, 186 => 0xd, 249 => '18.1', 250 => '25.1', 251 => '10.1', 252 => '25.1', 254 => '26.1' },
	'repeatingflashratebuilt-in' => { 221 => 0x4da },
	'repeatingflashrateexternal' => { 221 => 0x4c2 },
	'requires' => { 406 => 'requires' },
	'resampleparams' => { 433 => 'resampleParams' },
	'resampleparamsquality' => { 433 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 344 => 0x21e },
	'resolution' => { 143 => 'Resolution' },
	'resolutionmode' => { 345 => 0x4 },
	'resolutionunit' => { 107 => 0x128, 118 => 0x2, 429 => 'ResolutionUnit' },
	'resourceid' => { 106 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 106 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 106 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 73 => 0x612 },
	'restrictions' => { 426 => 'restrictions' },
	'retouchareafeather' => { 409 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 409 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 409 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 409 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 409 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 409 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 409 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 409 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 409 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 409 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 409 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 409 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 409 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 409 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 409 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 409 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 409 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 409 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 409 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 409 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 409 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 409 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 409 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 409 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 409 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 409 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 409 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 409 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 409 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 409 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 409 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 409 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 409 => 'RetouchAreas' },
	'retouchareaseed' => { 409 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 409 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 409 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 409 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 196 => 0x9e },
	'retouchinfo' => { 409 => 'RetouchInfo' },
	'retouchnefprocessing' => { 202 => 0x5 },
	'retractlensonpoweroff' => { 73 => 0x814 },
	'reuse' => { 266 => 'Reuse' },
	'reuseallowed' => { 436 => 'ReuseAllowed' },
	'reuseprohibited' => { 426 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 247 => '5.2' },
	'reverseindicators' => { 241 => '12.1', 242 => '6.1', 244 => '6.1', 245 => '4.3', 246 => '5.2', 247 => '5.4', 249 => '33.5', 250 => '5.1', 253 => '6.1', 254 => '6.2' },
	'reverseshutterspeedaperture' => { 247 => '5.3' },
	'revision' => { 411 => 'revision' },
	'rgbcurvelimits' => { 97 => 0x238 },
	'rgbcurvepoints' => { 96 => 0x7, 97 => 0x20e },
	'richtextcomment' => { 416 => 'RichTextComment' },
	'ricohdate' => { 335 => 0x6 },
	'ricohimageheight' => { 335 => 0x2 },
	'ricohimagewidth' => { 335 => 0x0 },
	'rightascension' => { 146 => 'RightAscension' },
	'rights' => { 410 => 'rights' },
	'rightsagent' => { 426 => 'rightsAgent' },
	'rightsowner' => { 426 => 'rightsOwner' },
	'roll' => { 104 => 0x8 },
	'rollangle' => { 213 => 0x350b, 222 => 0x36f4, 256 => 0x903, 277 => 0x90, 310 => 0x1 },
	'romoperationmode' => { 86 => 0x80d },
	'rotation' => { 27 => 0x17, 28 => 0x18, 85 => 0x3, 92 => 0x10002, 97 => 0x26e, 111 => 0x4, 146 => 'Rotation', 160 => [0x65,0x50], 161 => 0x46, 162 => 0x5a, 165 => 0x10, 213 => 0x3693, 214 => 0xca, 220 => '590.1', 222 => 0x38be, 234 => 0x76a43207, 277 => 0x30, 292 => '17.2', 322 => 0xd8, 353 => 0x3f, 354 => 0x3f, 364 => 0x10 },
	'routedto' => { 415 => 'RoutedTo' },
	'routing' => { 327 => 'Routing' },
	'routingnotes' => { 415 => 'RoutingNotes' },
	'rowsperstrip' => { 107 => 0x116 },
	'rpp' => { 403 => 'rpp' },
	'safetyshift' => { 73 => 0x108 },
	'safetyshiftinavortv' => { 71 => 0x10, 72 => 0x10, 74 => 0xf, 75 => 0x10, 78 => 0x10 },
	'sameexposurefornewaperture' => { 73 => 0x112 },
	'samplebits' => { 136 => 'SampleBits' },
	'samplepagerange' => { 423 => 'samplePageRange' },
	'samplerate' => { 136 => 'SampleRate' },
	'samplesperpixel' => { 107 => 0x115, 429 => 'SamplesPerPixel' },
	'samplestructure' => { 117 => 0x5a },
	'samsungmodelid' => { 342 => 0x3 },
	'sanyoquality' => { 344 => 0x201 },
	'sanyothumbnail' => { 344 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 31 => 0xe, 43 => 0x1, 101 => 0xd, 102 => [0x3013,0x1f], 107 => [0xa409,0xfe55], 112 => 0x1003, 137 => 'Saturation', 159 => 0x1f, 160 => 0x32, 161 => 0x28, 162 => 0x1a, 167 => 0x1, 196 => [0x94,0xaa], 198 => 0x35, 199 => 0x3b, 277 => 0x40, 279 => 0x300d, 311 => 0x1f, 318 => 0xd, 332 => 0x27, 335 => 0x28, 336 => 0x1013, 345 => 0x10, 353 => 0x1e, 354 => 0x1b, 365 => 0x2005, 409 => 'Saturation', 413 => 'Saturation' },
	'saturationadj' => { 92 => 0x20901, 97 => 0x116, 233 => 0x1, 237 => 0x2e, 394 => 0x8016 },
	'saturationadjustmentaqua' => { 409 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 409 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 409 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 409 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 409 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 409 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 409 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 409 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 62 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 61 => 0x68, 62 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 61 => 0x38, 62 => 0x38 },
	'saturationmonochrome' => { 61 => 0x80, 62 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 61 => 0x50, 62 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 61 => 0x20, 62 => 0x20 },
	'saturationsetting' => { 264 => 0x1010, 355 => 0x11, 369 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 61 => 0x8, 62 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 61 => 0x98, 62 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 61 => 0xb0, 62 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 61 => 0xc8, 62 => 0xe0 },
	'saveid' => { 434 => 'SaveID' },
	'scaletype' => { 433 => 'scaleType' },
	'scanimageenhancer' => { 203 => 0x60 },
	'scanningdirection' => { 117 => 0x64 },
	'scene' => { 418 => 'Scene', 433 => 'scene' },
	'scenearea' => { 259 => 0x211, 261 => 0x1031 },
	'sceneassist' => { 196 => 0x9c },
	'scenecapturetype' => { 107 => 0xa406, 413 => 'SceneCaptureType' },
	'scenedetect' => { 259 => 0x210, 261 => 0x1030 },
	'scenedetectdata' => { 259 => 0x212, 261 => 0x1033 },
	'scenemode' => { 125 => 0xfa02, 164 => 0x100, 196 => 0x8f, 256 => 0x509, 261 => 0x403, 277 => 0x8001, 285 => 0xf, 365 => 0xb023 },
	'scenemodeused' => { 127 => [0x6002,0xf002] },
	'sceneselect' => { 344 => 0x21f },
	'scenetype' => { 107 => 0xa301, 413 => 'SceneType' },
	'screentips' => { 241 => '12.7', 242 => '5.3', 249 => '13.1', 250 => '4.4', 253 => '5.4', 254 => '5.1' },
	'season' => { 422 => 'season' },
	'secondaryslotfunction' => { 213 => 0x1d0, 222 => 0x1d0 },
	'section' => { 423 => 'section' },
	'securityclassification' => { 107 => 0x9212 },
	'selectableafpoint' => { 73 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 73 => 0x512 },
	'selftimer' => { 31 => 0x2, 277 => 0x2e, 344 => 0x214, 372 => 0x1134, 373 => 0x1134, 374 => 0x1110, 375 => 0x118c, 376 => 0x1168, 377 => 0x1020, 378 => 0x218, 379 => 0x218 },
	'selftimer2' => { 67 => 0x1d },
	'selftimerinterval' => { 250 => '19.2' },
	'selftimermode' => { 107 => 0x882b },
	'selftimershotcount' => { 242 => '20.2', 244 => '20.3', 245 => '18.2', 246 => '19.2', 247 => '19.2', 248 => '19.3', 250 => '19.3', 253 => '20.3', 254 => '20.2' },
	'selftimershotinterval' => { 242 => '20.3', 244 => '20.2', 248 => '19.2', 253 => '20.2' },
	'selftimertime' => { 86 => 0x1806, 162 => 0x1f, 241 => '18.1', 242 => '20.1', 243 => '3.3', 244 => '20.1', 245 => '18.1', 246 => '19.1', 247 => '19.1', 248 => '19.1', 249 => '7.2', 250 => '19.1', 251 => '3.3', 253 => '20.1', 254 => '20.1' },
	'sellingagency' => { 423 => 'sellingAgency' },
	'seminfo' => { 107 => 0x8546 },
	'sensingmethod' => { 107 => 0xa217, 413 => 'SensingMethod' },
	'sensitivityadjust' => { 311 => 0x40 },
	'sensitivitysteps' => { 292 => ['14.3','17.4'], 294 => 0x1 },
	'sensitivitytype' => { 107 => 0x8830, 414 => 'SensitivityType' },
	'sensor' => { 169 => 0x665e },
	'sensorareas' => { 342 => 0xa010 },
	'sensorbitdepth' => { 279 => 0x312d },
	'sensorbluelevel' => { 65 => 0x5 },
	'sensorcalibration' => { 260 => 0x805 },
	'sensorcleaning' => { 79 => 0xd },
	'sensorfullheight' => { 120 => 0xf904 },
	'sensorfullwidth' => { 120 => 0xf903 },
	'sensorheight' => { 120 => 0xf901, 125 => 0xfa21, 166 => 0x8, 279 => 0x312c, 320 => 0x109, 336 => 0x1602 },
	'sensorleftmargin' => { 320 => 0x10a },
	'sensorpixelsize' => { 196 => 0x9a },
	'sensorredlevel' => { 65 => 0x4 },
	'sensorserialnumber' => { 121 => 0x9ce },
	'sensorsize' => { 137 => 'SensorSize', 311 => 0x35 },
	'sensortemperature' => { 259 => 0x1500, 261 => 0x1007, 316 => 0xc, 320 => 0x210, 345 => [0x39,0x55] },
	'sensortemperature2' => { 316 => 0xe, 320 => 0x211 },
	'sensortopmargin' => { 320 => 0x10b },
	'sensorwidth' => { 120 => 0xf900, 125 => 0xfa20, 166 => 0xa, 279 => 0x312b, 320 => 0x108, 336 => 0x1601 },
	'sequence' => { 332 => 0x7 },
	'sequencefilenumber' => { 373 => 0x4, 374 => 0x4, 375 => 0x4, 376 => 0x4, 382 => 0xc, 383 => 0xc, 384 => 0x1a },
	'sequenceimagenumber' => { 373 => 0x0, 374 => 0x0, 375 => 0x0, 376 => 0x0, 382 => 0x8, 383 => 0x8, 384 => 0x12, 390 => 0x24 },
	'sequencelength' => { 382 => 0x22, 383 => 0x1e, 384 => [0x16,0x1e] },
	'sequencename' => { 422 => 'sequenceName' },
	'sequencenumber' => { 67 => 0x9, 102 => 0x301c, 112 => 0x1101, 123 => 0x1d, 221 => 0x51c, 277 => 0x2b, 355 => [0x10c,0x30c], 365 => 0xb04a, 422 => 'sequenceNumber' },
	'sequenceshotinterval' => { 344 => 0x224 },
	'sequencetotalnumber' => { 422 => 'sequenceTotalNumber' },
	'sequentialshot' => { 344 => 0x20e },
	'serialnumber' => { 55 => 0xc, 86 => 0x180b, 107 => [0xa431,0xfde9], 120 => 0xfa04, 122 => 0xfa00, 124 => 0xc354, 125 => 0xfa19, 134 => 0x0, 137 => 'SerialNumber', 196 => [0xa0,0x1d], 257 => 0x101, 261 => [0x404,0x101a], 273 => 0x303, 279 => 0x3103, 311 => 0x229, 320 => 0x102, 321 => 0x407, 332 => 0x15, 336 => 0x5, 345 => 0x2, 405 => 'SerialNumber', 414 => 'BodySerialNumber' },
	'serialnumberformat' => { 55 => 0x15, 86 => 0x183b },
	'seriesdatetime' => { 396 => 'SeriesDateTime' },
	'seriesdescription' => { 396 => 'SeriesDescription' },
	'seriesmodality' => { 396 => 'SeriesModality' },
	'seriesnumber' => { 396 => 'SeriesNumber', 423 => 'seriesNumber' },
	'seriestitle' => { 423 => 'seriesTitle' },
	'serviceidentifier' => { 116 => 0x1e },
	'servingsize' => { 425 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 76 => 0x0, 77 => 0x0 },
	'setbuttonwhenshooting' => { 71 => 0x1, 73 => 0x704, 79 => 0xc },
	'setfunctionwhenshooting' => { 74 => 0x0, 75 => 0x1, 78 => 0x1 },
	'setting' => { 422 => 'setting' },
	'shadingcompensation' => { 256 => 0x50c, 277 => 0x8a },
	'shadingcompensation2' => { 260 => 0x1012 },
	'shadow' => { 345 => 0xe },
	'shadowadj' => { 92 => 0x2030b },
	'shadowcorrection' => { 311 => 0x79 },
	'shadowprotection' => { 233 => 0x0 },
	'shadows' => { 107 => 0xfe52, 402 => 'Shadows', 409 => 'Shadows' },
	'shadows2012' => { 409 => 'Shadows2012' },
	'shadowscale' => { 107 => 0xc633 },
	'shadowtint' => { 409 => 'ShadowTint' },
	'shadowtone' => { 112 => 0x1040 },
	'shakereduction' => { 313 => 0x1, 314 => 0x1 },
	'sharpendetail' => { 409 => 'SharpenDetail' },
	'sharpenedgemasking' => { 409 => 'SharpenEdgeMasking' },
	'sharpening' => { 279 => 0x300b },
	'sharpeningadj' => { 237 => 0x2b },
	'sharpenradius' => { 409 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 31 => 0xf, 65 => 0x2, 101 => 0xb, 102 => [0x3011,0x21], 107 => [0xa40a,0xfe56], 112 => 0x1001, 123 => 0x6b, 132 => 0x37, 137 => 'Sharpness', 159 => 0x21, 160 => 0x30, 161 => 0x26, 162 => 0x18, 167 => 0x3, 196 => 0x6, 198 => 0x32, 199 => 0x33, 261 => 0x100f, 277 => 0x41, 311 => 0x21, 318 => 0xb, 332 => 0x26, 335 => 0x22, 336 => [0x1003,0x1014], 345 => 0x11, 353 => 0x1c, 354 => 0x19, 365 => 0x2006, 390 => 0x52, 409 => 'Sharpness', 413 => 'Sharpness' },
	'sharpnessadj' => { 92 => 0x20310, 97 => 0x25a, 394 => 0x801a },
	'sharpnessadjon' => { 92 => '0x20310.0' },
	'sharpnessauto' => { 62 => 0x94 },
	'sharpnessfactor' => { 261 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 61 => 0x64, 62 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 65 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 61 => 0x34, 62 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 61 => 0x7c, 62 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 61 => 0x4c, 62 => 0x4c },
	'sharpnessovershoot' => { 394 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 61 => 0x1c, 62 => 0x1c },
	'sharpnesssetting' => { 256 => 0x506, 264 => 0x1013, 355 => 0x12, 369 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 61 => 0x4, 62 => 0x4 },
	'sharpnessstrength' => { 92 => 0x20311 },
	'sharpnessthreshold' => { 394 => 0x801d },
	'sharpnessundershoot' => { 394 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 61 => 0x94, 62 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 61 => 0xac, 62 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 61 => 0xc4, 62 => 0xdc },
	'shootid' => { 422 => 'shootID' },
	'shootingdistance' => { 92 => 0x20701 },
	'shootinginfodisplay' => { 241 => '13.2', 242 => '5.1', 249 => '10.2', 250 => '4.1', 253 => '5.1', 254 => '5.3' },
	'shootinginfomonitorofftime' => { 241 => '26.2', 242 => '22.2', 244 => '22.2', 248 => '21.2', 249 => '9.1', 250 => '21.2', 253 => '22.2', 254 => '22.2' },
	'shootingmode' => { 137 => 'ShootingMode', 196 => 0x89, 277 => 0x1f },
	'shootingmodesetting' => { 243 => '5.1' },
	'shortdescription' => { 411 => 'shortdescription' },
	'shortdocumentid' => { 115 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 73 => 0x80d },
	'shotdate' => { 433 => 'shotDate' },
	'shotday' => { 433 => 'shotDay' },
	'shotlocation' => { 433 => 'shotLocation' },
	'shotname' => { 433 => 'shotName' },
	'shotnumber' => { 433 => 'shotNumber' },
	'shotnumbersincepowerup' => { 368 => 0x44e, 382 => 0x1a, 383 => 0x16, 384 => 0xa },
	'shotnumbersincepowerup2' => { 355 => 0x200 },
	'shotsize' => { 433 => 'shotSize' },
	'shutter-aelock' => { 71 => 0x4, 73 => 0x701, 74 => 0x3, 75 => 0x4, 76 => 0x3, 77 => 0x3, 78 => 0x4, 79 => 0x2 },
	'shutteraelbutton' => { 72 => 0x4 },
	'shutterbuttonafonbutton' => { 73 => 0x701 },
	'shuttercount' => { 10 => 0x176, 49 => 0x1, 196 => 0xa7, 204 => [0x6a,0x157,0x24d], 205 => 0x286, 206 => 0x279, 207 => 0x284, 208 => 0x242, 209 => 0x280, 210 => 0x276, 211 => [0x27d,0x27f], 212 => 0x246, 215 => 0x2d6, 216 => 0x321, 217 => 0xbd8, 218 => 0x287, 219 => 0x320, 220 => 0x24a, 221 => 0x5fb, 223 => 0x2d5, 311 => 0x5d, 364 => 0x846, 367 => [0x125,0x14a] },
	'shuttercurtainsync' => { 71 => 0xf, 72 => 0xf, 73 => 0x305, 74 => 0xe, 75 => 0xf, 76 => 0x8, 77 => 0x8, 78 => 0xf, 79 => 0x8 },
	'shuttermode' => { 123 => 0x1b },
	'shutterreleasebuttonae-l' => { 241 => '17.7', 242 => '18.4', 244 => '78.4', 245 => '16.1', 246 => '17.1', 247 => '17.1', 248 => '17.1', 249 => '7.1', 250 => '17.5', 253 => '18.4', 254 => '18.2' },
	'shutterreleasemethod' => { 86 => 0x1010 },
	'shutterreleasenocfcard' => { 71 => 0x2, 72 => 0x2, 79 => 0xf },
	'shutterreleasetiming' => { 86 => 0x1011 },
	'shutterreleasewithoutlens' => { 73 => 0x711 },
	'shutterspeedlock' => { 242 => '38.1', 244 => '38.1', 253 => '38.1' },
	'shutterspeedrange' => { 73 => 0x10c },
	'shutterspeedsetting' => { 162 => 0x6, 353 => 0x2f, 354 => 0x28, 355 => 0x0 },
	'shutterspeedvalue' => { 82 => 0x1, 107 => 0x9201, 261 => 0x1000, 320 => 0x400, 413 => 'ShutterSpeedValue' },
	'shuttertype' => { 112 => 0x1050, 277 => 0x9f },
	'sidecarforextension' => { 421 => 'SidecarForExtension' },
	'similarityindex' => { 115 => 0xe4 },
	'singleframebracketing' => { 162 => 0x21 },
	'skilllevel' => { 425 => 'skillLevel' },
	'slaveflashmeteringsegments' => { 311 => 0x20b },
	'slideshowname' => { 422 => 'slideshowName' },
	'slideshownumber' => { 422 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 422 => 'slideshowTotalNumber' },
	'slowshutter' => { 67 => 0x8 },
	'slowsync' => { 112 => 0x1030 },
	'smartrange' => { 342 => 0xa012 },
	'smileshutter' => { 355 => 0x31 },
	'smileshuttermode' => { 355 => 0x27 },
	'smoothness' => { 107 => 0xfe57, 409 => 'Smoothness' },
	'snapshots' => { 403 => 'Snapshots' },
	'softskineffect' => { 365 => 0x200f },
	'software' => { 107 => 0x131, 138 => 'Software', 269 => 'Software', 320 => 0x203, 345 => 0x18, 429 => 'Software' },
	'softwareversion' => { 344 => 0x207 },
	'sonydatetime' => { 371 => 0x6, 373 => 0x1b6, 374 => 0x210, 375 => 0x1fe, 376 => 0x22c },
	'sonydatetime2' => { 381 => [0x51,0x5d] },
	'sonyexposuretime' => { 381 => 0x46 },
	'sonyexposuretime2' => { 390 => 0xe },
	'sonyfnumber' => { 381 => [0x3c,0x48], 390 => 0x14 },
	'sonyimageheight' => { 371 => 0x1a, 382 => 0x44, 383 => 0x3f, 384 => 0x47 },
	'sonyimagesize' => { 162 => 0x3b, 353 => 0x54, 354 => 0x54, 355 => 0x9 },
	'sonyimagewidth' => { 371 => 0x1c },
	'sonyiso' => { 373 => 0x1218, 374 => 0x11f4, 375 => 0x1270, 376 => [0x1254,0x1258,0x1280], 377 => 0x113c, 378 => 0x344, 379 => 0x346, 390 => 0x4 },
	'sonymaxaperturevalue' => { 390 => 0x16 },
	'sonymodelid' => { 365 => 0xb001 },
	'sonyquality' => { 162 => 0x3c },
	'source' => { 115 => 0x73, 269 => 'Source', 410 => 'source', 411 => 'source', 421 => 'Source' },
	'sourcedirectoryindex' => { 298 => 0x0 },
	'sourcefileindex' => { 298 => 0x2 },
	'sourcephotoscount' => { 398 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 413 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 413 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 413 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 413 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 413 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 433 => 'speakerPlacement' },
	'specialeffectlevel' => { 102 => 0x3030 },
	'specialeffectmode' => { 102 => 0x2076 },
	'specialeffectsetting' => { 102 => 0x3031 },
	'specialinstructions' => { 115 => 0x28 },
	'specialmode' => { 261 => 0x200, 344 => 0x200 },
	'specialoccasion' => { 425 => 'specialOccasion' },
	'spectralsensitivity' => { 107 => 0x8824, 413 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 38 => [0x2b9,0x2d0,0x2d4], 40 => 0x1e4, 41 => [0x1fd,0x2dd], 42 => [0x231,0x30f] },
	'speedx' => { 104 => 0x3 },
	'speedy' => { 104 => 0x4 },
	'speedz' => { 104 => 0x5 },
	'splitcolumn' => { 320 => 0x222 },
	'splittoningbalance' => { 409 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 409 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 409 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 409 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 409 => 'SplitToningShadowSaturation' },
	'sport' => { 423 => 'sport' },
	'spotfocuspointx' => { 159 => 0x2d },
	'spotfocuspointy' => { 159 => 0x2e },
	'spotmeteringmode' => { 31 => 0x27 },
	'spotmeterlinktoafpoint' => { 73 => 0x107 },
	'sractive' => { 292 => '17.1' },
	'srawquality' => { 31 => 0x2e },
	'srfocallength' => { 313 => 0x3 },
	'srhalfpresstime' => { 313 => 0x2 },
	'srresult' => { 313 => 0x0, 314 => 0x0 },
	'stackedimage' => { 256 => 0x804 },
	'standardoutputhighlightpoint' => { 98 => 0x14 },
	'standardoutputsensitivity' => { 107 => 0x8831, 414 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 98 => 0x15 },
	'standardrawcolortone' => { 98 => 0xd },
	'standardrawcontrast' => { 98 => 0xf },
	'standardrawhighlight' => { 98 => 0x75 },
	'standardrawhighlightpoint' => { 98 => 0x12 },
	'standardrawlinear' => { 98 => 0x10 },
	'standardrawsaturation' => { 98 => 0xe },
	'standardrawshadow' => { 98 => 0x7e },
	'standardrawshadowpoint' => { 98 => 0x13 },
	'standardrawsharpness' => { 98 => 0x11 },
	'standardunsharpmaskfineness' => { 98 => 0x94 },
	'standardunsharpmaskstrength' => { 98 => 0x92 },
	'standardunsharpmaskthreshold' => { 98 => 0x96 },
	'standbytimer' => { 242 => '19.1', 244 => '19.1', 247 => '18.1', 248 => '18.1', 253 => '19.1' },
	'startingpage' => { 423 => 'startingPage' },
	'startmovieshooting' => { 73 => 0x70d },
	'starttimecode' => { 433 => 'startTimecode' },
	'starttimecodetimeformat' => { 433 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 433 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 433 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 433 => 'startTimeSampleSize' },
	'starttimescale' => { 433 => 'startTimeScale' },
	'state' => { 142 => 'State', 277 => 0x6b, 421 => 'State' },
	'status' => { 397 => 'Status', 401 => 'Status' },
	'stitchingsoftware' => { 398 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 372 => 0x113e, 373 => 0x113e, 374 => 0x111a, 375 => 0x1196, 376 => 0x1172, 377 => 0x102a, 378 => 0x222, 379 => 0x222, 390 => 0xa },
	'storagemethod' => { 166 => 0x12 },
	'storebyorientation' => { 242 => '46.3', 244 => '47.3', 253 => '47.3' },
	'straightenangle' => { 234 => 0x2fc08431 },
	'streamtype' => { 155 => 'StreamType' },
	'stretchmode' => { 433 => 'stretchMode' },
	'studydatetime' => { 396 => 'StudyDateTime' },
	'studydescription' => { 396 => 'StudyDescription' },
	'studyid' => { 396 => 'StudyID' },
	'studyphysician' => { 396 => 'StudyPhysician' },
	'sub-location' => { 115 => 0x5c },
	'subfiledata' => { 145 => 'data' },
	'subfiledirectory' => { 145 => '1Directory' },
	'subfilemimetype' => { 145 => '2MIME' },
	'subfilename' => { 145 => '1Name' },
	'subfileresource' => { 145 => 'rsrc' },
	'subfiletype' => { 107 => 0xfe, 145 => '0Type' },
	'subject' => { 265 => 'Subject', 327 => 'Subject', 410 => 'subject', 420 => 'Subject', 434 => 'subject' },
	'subjectarea' => { 107 => 0x9214, 413 => 'SubjectArea' },
	'subjectcode' => { 418 => 'SubjectCode' },
	'subjectdistance' => { 107 => 0x9206, 123 => 0x3e, 413 => 'SubjectDistance' },
	'subjectdistancerange' => { 107 => 0xa40c, 413 => 'SubjectDistanceRange' },
	'subjectlocation' => { 107 => 0xa214, 413 => 'SubjectLocation' },
	'subjectmotion' => { 244 => '78.2' },
	'subjectprogram' => { 159 => 0x22 },
	'subjectreference' => { 115 => 0xc },
	'sublabels4' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 417 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 417 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 107 => 0x9290 },
	'subsectimedigitized' => { 107 => 0x9292 },
	'subsectimeoriginal' => { 107 => 0x9291 },
	'subsection1' => { 423 => 'subsection1' },
	'subsection2' => { 423 => 'subsection2' },
	'subsection3' => { 423 => 'subsection3' },
	'subsection4' => { 423 => 'subsection4' },
	'subselector' => { 242 => '49.1', 244 => '71.1' },
	'subselectorassignment' => { 242 => '48.1' },
	'subselectorcenter' => { 244 => '72.1' },
	'subselectorplusdials' => { 242 => '49.2', 244 => '73.1' },
	'subtitle' => { 423 => 'subtitle' },
	'subversionfilename' => { 417 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 417 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 417 => 'SubVersions' },
	'superimposeddisplay' => { 71 => 0xa, 73 => 0x510, 74 => 0x9, 75 => 0xa, 78 => 0xa, 79 => 0xe },
	'supermacro' => { 55 => 0x1a },
	'supplementalcategories' => { 115 => 0x14, 421 => 'SupplementalCategories' },
	'supplementaltype' => { 117 => 0x37 },
	'supplementdisplayid' => { 423 => 'supplementDisplayID' },
	'supplementstartingpage' => { 423 => 'supplementStartingPage' },
	'supplementtitle' => { 423 => 'supplementTitle' },
	'svisosetting' => { 292 => 0x14 },
	'swatchcoloranta' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 438 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 438 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 438 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 438 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 438 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 277 => 0x93, 355 => 0x33 },
	'sweeppanoramafieldofview' => { 277 => 0x94 },
	'sweeppanoramasize' => { 355 => 0x32 },
	'switchtoregisteredafpoint' => { 72 => 0x12, 73 => 0x50a },
	'syncreleasemode' => { 244 => '77.1' },
	'system' => { 320 => 0x204 },
	'tagged' => { 322 => 0xdd, 323 => 'Tagged', 403 => 'tagged' },
	'tagslist' => { 412 => 'TagsList' },
	'tagstructure' => { 417 => 'TagStructure' },
	'takenumber' => { 433 => 'takeNumber' },
	'tapename' => { 433 => 'tapeName' },
	'targetaperture' => { 67 => 0x4 },
	'targetcompressionratio' => { 84 => 0x1 },
	'targetdistancesetting' => { 86 => 0x1807 },
	'targetexposuretime' => { 67 => 0x5 },
	'targetimagetype' => { 86 => 0x100a },
	'targetprinter' => { 107 => 0x151 },
	'taxon' => { 106 => 'Taxon' },
	'taxonacceptednameusage' => { 106 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 106 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 106 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 106 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 106 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 106 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 106 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 106 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 106 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 106 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 106 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 106 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 106 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 106 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 106 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 106 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 106 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 106 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 106 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 106 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 106 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 106 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 106 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 106 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 106 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 106 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 106 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 106 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 106 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 106 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 106 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 106 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 106 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 423 => 'teaser' },
	'teleconverter' => { 164 => 0x105, 365 => 0x105 },
	'tempo' => { 433 => 'tempo' },
	'termsandconditionstext' => { 266 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 266 => 'TermsAndConditionsURL' },
	'testname' => { 108 => 'TestName' },
	'textencoding' => { 195 => 0x4 },
	'textlayername' => { 421 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 421 => 'TextLayers' },
	'textlayertext' => { 421 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 277 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 244 => '1.3' },
	'three-dtrackingwatcharea' => { 244 => '78.1' },
	'thresholding' => { 107 => 0x107 },
	'thumbnailfilename' => { 86 => 0x817 },
	'thumbnailformat' => { 431 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 125 => 0xfa55, 431 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 86 => 0x2008, 103 => 'ThumbnailImage', 110 => 0x3, 148 => 'data', 261 => 0x100, 431 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 148 => '1Name' },
	'thumbnailimagesize' => { 148 => 'ImageSize' },
	'thumbnailimagetype' => { 148 => '0Type' },
	'thumbnailimagevalidarea' => { 55 => 0x13 },
	'thumbnaillength' => { 107 => 0x202 },
	'thumbnailoffset' => { 107 => 0x201 },
	'thumbnails' => { 431 => 'Thumbnails' },
	'thumbnailwidth' => { 125 => 0xfa54, 431 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 423 => 'ticker' },
	'tiffhandling' => { 409 => 'TIFFHandling' },
	'tiffmeteringimage' => { 165 => 0x104c, 364 => 0x1110 },
	'tilelength' => { 107 => 0x143 },
	'tilewidth' => { 107 => 0x142 },
	'time' => { 121 => 0x401, 311 => 0x7 },
	'timecodes' => { 107 => 0xc763 },
	'timecreated' => { 115 => 0x3c, 123 => 0x14, 132 => 0x10, 323 => 'TimeCreated' },
	'timeperiod' => { 423 => 'timePeriod' },
	'timerfunctionbutton' => { 243 => '5.2', 245 => '12.1', 246 => '13.1' },
	'timerlength' => { 73 => 0x80c },
	'timerrecording' => { 277 => 0x96 },
	'timescaleparams' => { 433 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 433 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 433 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 433 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 116 => 0x50 },
	'timesignature' => { 433 => 'timeSignature' },
	'timesincepoweron' => { 277 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 255 => 0x8, 269 => 'TimeStamp', 404 => 'Timestamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 68 => 0x1, 226 => 0x0, 339 => 0xa },
	'timezonecity' => { 68 => 0x2 },
	'timezonecode' => { 89 => 0x1 },
	'timezoneinfo' => { 89 => 0x2 },
	'timezoneoffset' => { 107 => 0x882a },
	'tint' => { 409 => 'Tint' },
	'title' => { 138 => 'Title', 265 => 'Title', 269 => 'Title', 277 => 0x65, 327 => 'Title', 410 => 'title', 420 => 'Title', 431 => 'Title' },
	'tonecomp' => { 196 => 0x81 },
	'tonecurve' => { 65 => 0x1, 311 => 0x402, 409 => 'ToneCurve' },
	'tonecurveactive' => { 97 => 0x110 },
	'tonecurveadobergb' => { 342 => 0xa043 },
	'tonecurveadobergbdefault' => { 342 => 0xa041 },
	'tonecurveblue' => { 409 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 394 => 0x9003 },
	'tonecurvebluey' => { 394 => 0x9007 },
	'tonecurvebrightness' => { 92 => 0x20410 },
	'tonecurvebrightnessx' => { 394 => 0x9000 },
	'tonecurvebrightnessy' => { 394 => 0x9004 },
	'tonecurvecolorspace' => { 96 => 0x0 },
	'tonecurvecontrast' => { 92 => 0x20411 },
	'tonecurvefilename' => { 121 => 0x1391 },
	'tonecurvegreen' => { 409 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 394 => 0x9002 },
	'tonecurvegreeny' => { 394 => 0x9006 },
	'tonecurveinputrange' => { 96 => 0x3 },
	'tonecurveinterpolation' => { 97 => 0x159 },
	'tonecurvemode' => { 97 => 0x113 },
	'tonecurvename' => { 409 => 'ToneCurveName' },
	'tonecurvename2012' => { 409 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 92 => '0x20400.1' },
	'tonecurveoutputrange' => { 96 => 0x5 },
	'tonecurveproperty' => { 97 => 0x3c },
	'tonecurvepv2012' => { 409 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 409 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 409 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 409 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 409 => 'ToneCurveRed' },
	'tonecurveredx' => { 394 => 0x9001 },
	'tonecurveredy' => { 394 => 0x9005 },
	'tonecurves' => { 311 => 0x403 },
	'tonecurveshape' => { 96 => 0x1 },
	'tonecurvesrgb' => { 342 => 0xa042 },
	'tonecurvesrgbdefault' => { 342 => 0xa040 },
	'tonecurvex' => { 96 => 0xa },
	'tonecurvey' => { 96 => 0xb },
	'tonelevel' => { 256 => 0x52e },
	'tonemapstrength' => { 409 => 'ToneMapStrength' },
	'toningeffect' => { 49 => 0xf, 196 => 0xb3, 198 => 0x38, 199 => 0x40, 336 => 0x1015 },
	'toningeffectauto' => { 62 => 0xa4 },
	'toningeffectfaithful' => { 61 => 0x74, 62 => 0x74 },
	'toningeffectlandscape' => { 61 => 0x44, 62 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 61 => 0x8c, 62 => 0x8c },
	'toningeffectneutral' => { 61 => 0x5c, 62 => 0x5c },
	'toningeffectportrait' => { 61 => 0x2c, 62 => 0x2c },
	'toningeffectstandard' => { 61 => 0x14, 62 => 0x14 },
	'toningeffectuserdef1' => { 61 => 0xa4, 62 => 0xbc },
	'toningeffectuserdef2' => { 61 => 0xbc, 62 => 0xd4 },
	'toningeffectuserdef3' => { 61 => 0xd4, 62 => 0xec },
	'toningsaturation' => { 198 => 0x39, 199 => 0x41 },
	'totalzoom' => { 123 => 0x62 },
	'touchae' => { 277 => 0xab },
	'trackcreatedate' => { 331 => 0x1 },
	'trackmodifydate' => { 331 => 0x2 },
	'tracknumber' => { 433 => 'trackNumber' },
	'tracks' => { 433 => 'Tracks' },
	'tracksframerate' => { 433 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 433 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 433 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 433 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 433 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 433 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 433 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 433 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 433 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 433 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 433 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 433 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 433 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 433 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 433 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 433 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 433 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 145 => 'zmie' },
	'transferfunction' => { 107 => 0x12d, 429 => 'TransferFunction' },
	'transform' => { 277 => [0x8012,0x59] },
	'transmissionreference' => { 421 => 'TransmissionReference' },
	'trapped' => { 265 => 'Trapped', 420 => 'Trapped' },
	'trashbuttonfunction' => { 73 => 0x710 },
	'travelday' => { 277 => 0x36 },
	'triggermode' => { 332 => 0x6 },
	'tstop' => { 107 => 0xc772 },
	'ttl_da_adown' => { 299 => 0x5 },
	'ttl_da_aup' => { 299 => 0x4 },
	'ttl_da_bdown' => { 299 => 0x7 },
	'ttl_da_bup' => { 299 => 0x6 },
	'tungstenawb' => { 289 => 0x1 },
	'tvexposuretimesetting' => { 292 => 0x12 },
	'type' => { 410 => 'type', 428 => 'type' },
	'typestatus' => { 106 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 107 => 0xc614 },
	'uniquedocumentid' => { 115 => 0xbb },
	'uniqueobjectname' => { 116 => 0x64 },
	'unknownblock' => { 311 => 0x405 },
	'unknownblock1' => { 260 => 0x635 },
	'unknownblock2' => { 260 => 0x636 },
	'unknownblock3' => { 260 => 0x1103 },
	'unknownblock4' => { 260 => 0x1104 },
	'unknowncontrast' => { 98 => 0x45 },
	'unknowndate' => { 320 => 0x212 },
	'unknownev' => { 121 => 0x1 },
	'unknownlinear' => { 98 => 0x46 },
	'unknownnumber' => { 86 => 0x180b },
	'unknownoutputhighlightpoint' => { 98 => 0x4a },
	'unknownoutputshadowpoint' => { 98 => 0x4b },
	'unknownrawhighlight' => { 98 => 0x7b },
	'unknownrawhighlightpoint' => { 98 => 0x48 },
	'unknownrawshadow' => { 98 => 0x84 },
	'unknownrawshadowpoint' => { 98 => 0x49 },
	'unknownsharpness' => { 98 => 0x47 },
	'unknowntemperature' => { 109 => 0x4 },
	'unsharp1color' => { 239 => 0x13 },
	'unsharp1halowidth' => { 239 => 0x19 },
	'unsharp1intensity' => { 239 => 0x17 },
	'unsharp1threshold' => { 239 => 0x1b },
	'unsharp2color' => { 239 => 0x2e },
	'unsharp2halowidth' => { 239 => 0x34 },
	'unsharp2intensity' => { 239 => 0x32 },
	'unsharp2threshold' => { 239 => 0x36 },
	'unsharp3color' => { 239 => 0x49 },
	'unsharp3halowidth' => { 239 => 0x4f },
	'unsharp3intensity' => { 239 => 0x4d },
	'unsharp3threshold' => { 239 => 0x51 },
	'unsharp4color' => { 239 => 0x64 },
	'unsharp4halowidth' => { 239 => 0x6a },
	'unsharp4intensity' => { 239 => 0x68 },
	'unsharp4threshold' => { 239 => 0x6c },
	'unsharpcount' => { 239 => 0x0 },
	'unsharpmask' => { 98 => 0x90, 234 => 0x76a43200 },
	'unsharpmaskfineness' => { 92 => 0x20309 },
	'unsharpmaskstrength' => { 92 => 0x20308 },
	'unsharpmaskthreshold' => { 92 => 0x2030a },
	'uprightcentermode' => { 409 => 'UprightCenterMode' },
	'uprightcenternormx' => { 409 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 409 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 409 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 409 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 409 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 409 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 409 => 'UprightPreview' },
	'uprighttransform_0' => { 409 => 'UprightTransform_0' },
	'uprighttransform_1' => { 409 => 'UprightTransform_1' },
	'uprighttransform_2' => { 409 => 'UprightTransform_2' },
	'uprighttransform_3' => { 409 => 'UprightTransform_3' },
	'uprighttransform_4' => { 409 => 'UprightTransform_4' },
	'uprighttransform_5' => { 409 => 'UprightTransform_5' },
	'uprighttransformcount' => { 409 => 'UprightTransformCount' },
	'uprightversion' => { 409 => 'UprightVersion' },
	'urgency' => { 115 => 0xa, 421 => 'Urgency' },
	'url' => { 138 => 'URL', 269 => 'URL', 325 => 0x40b, 423 => 'url' },
	'url_list' => { 325 => 0x41e },
	'urla-platform' => { 423 => [\'url','urlA-platform'] },
	'urlurl' => { 423 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 73 => 0x10a },
	'usableshootingmodes' => { 73 => 0x109 },
	'usage' => { 424 => 'usage' },
	'usageterms' => { 437 => 'UsageTerms' },
	'useguidelines' => { 406 => 'useGuidelines' },
	'usepanoramaviewer' => { 398 => 'UsePanoramaViewer' },
	'usercomment' => { 86 => 0x805, 107 => 0x9286, 413 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 61 => 0xd8, 62 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 61 => 0xda, 62 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 61 => 0xdc, 62 => 0xf4 },
	'userfields' => { 401 => 'UserFields' },
	'userlabel' => { 332 => 0x2b },
	'userprofile' => { 273 => 0x302, 279 => 0x3038 },
	'usmlenselectronicmf' => { 2 => 0x7, 72 => 0x7, 73 => 0x501 },
	'uspsnumber' => { 423 => 'uspsNumber' },
	'utmeasting' => { 149 => 'Easting' },
	'utmmapdatum' => { 149 => 'Datum' },
	'utmnorthing' => { 149 => 'Northing' },
	'utmzone' => { 149 => 'Zone' },
	'uv-irfiltercorrection' => { 273 => 0x325 },
	'validbits' => { 260 => 0x611, 261 => 0x102c },
	'validpixeldepth' => { 264 => 0x611 },
	'variousmodes' => { 123 => 0x26 },
	'variousmodes2' => { 123 => 0x3a },
	'variprogram' => { 196 => 0xab },
	'version' => { 112 => 0x0, 327 => 'Version', 409 => 'Version' },
	'versioncreatedate' => { 394 => 0xd100 },
	'versionid' => { 434 => 'VersionID' },
	'versionidentifier' => { 423 => 'versionIdentifier' },
	'versionmodifydate' => { 394 => 0xd101 },
	'versions' => { 434 => 'Versions' },
	'versionscomments' => { 434 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 434 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 434 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 434 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 434 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 434 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 434 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 434 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 434 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 434 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 434 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 241 => '3.2', 242 => '47.2' },
	'verticalfuncbutton' => { 242 => '42.2' },
	'verticalfuncbuttonplusdials' => { 242 => '43.1' },
	'verticalmultiselector' => { 242 => '42.1', 244 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 73 => [0x510,0x51d] },
	'vibrance' => { 402 => 'Vibrance', 409 => 'Vibrance' },
	'vibrationreduction' => { 204 => [0x75,0x82,0x1ae], 212 => '586.1', 220 => '590.2', 225 => 0x4 },
	'videoalphamode' => { 433 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 433 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 433 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 433 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 58 => 0x74 },
	'videocolorspace' => { 433 => 'videoColorSpace' },
	'videocompressor' => { 433 => 'videoCompressor' },
	'videofieldorder' => { 433 => 'videoFieldOrder' },
	'videoframerate' => { 433 => 'videoFrameRate' },
	'videoframesize' => { 433 => 'videoFrameSize' },
	'videoframesizeh' => { 433 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 433 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 433 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 433 => 'videoModDate' },
	'videopixelaspectratio' => { 433 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 433 => 'videoPixelDepth' },
	'videoquality' => { 102 => 0x4003 },
	'viewfinderdisplay' => { 241 => '12.4', 242 => '6.3' },
	'viewfinderwarning' => { 241 => '13.4', 250 => '3.5', 251 => '6.2', 254 => '4.4' },
	'viewfinderwarnings' => { 73 => 0x40a },
	'viewinfoduringexposure' => { 73 => 0x407 },
	'viewingmode' => { 355 => 0x2f, 369 => 0x18 },
	'viewingmode2' => { 355 => [0x85,0x285] },
	'viewpoint' => { 422 => 'viewpoint' },
	'vignetteamount' => { 409 => 'VignetteAmount' },
	'vignettecontrol' => { 196 => 0x2a, 234 => 0x76a43205 },
	'vignettecontrolintensity' => { 234 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 405 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 409 => 'VignetteMidpoint' },
	'vignetting' => { 336 => 0x1011, 342 => 0xa052 },
	'vignettingcorrection' => { 342 => 0xa053, 365 => 0x2011 },
	'vignettingsetting' => { 342 => 0xa054 },
	'visualtechnique' => { 422 => 'visualTechnique' },
	'voicememo' => { 344 => 0x216 },
	'volume' => { 423 => 'volume' },
	'vr_0x66' => { 204 => 0x66 },
	'vrdoffset' => { 55 => 0xd0 },
	'vrmode' => { 225 => 0x6 },
	'wb_bluelevel3500k' => { 165 => 0x19a },
	'wb_bluelevel6500k' => { 165 => 0x18a },
	'wb_bluelevelcustom' => { 165 => 0x18e },
	'wb_bluelevelscloudy' => { 165 => 0x106 },
	'wb_bluelevelsdaylight' => { 165 => 0xea },
	'wb_bluelevelsflash' => { 165 => 0x122 },
	'wb_bluelevelsfluorescent' => { 165 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 165 => 0x254 },
	'wb_bluelevelsshade' => { 165 => 0x176 },
	'wb_bluelevelstungsten' => { 165 => 0xce },
	'wb_gbrglevels' => { 165 => 0xae, 168 => 0x4 },
	'wb_glevel' => { 260 => 0x11f },
	'wb_glevel3000k' => { 260 => 0x113 },
	'wb_glevel3300k' => { 260 => 0x114 },
	'wb_glevel3600k' => { 260 => 0x115 },
	'wb_glevel3900k' => { 260 => 0x116 },
	'wb_glevel4000k' => { 260 => 0x117 },
	'wb_glevel4300k' => { 260 => 0x118 },
	'wb_glevel4500k' => { 260 => 0x119 },
	'wb_glevel4800k' => { 260 => 0x11a },
	'wb_glevel5300k' => { 260 => 0x11b },
	'wb_glevel6000k' => { 260 => 0x11c },
	'wb_glevel6600k' => { 260 => 0x11d },
	'wb_glevel7500k' => { 260 => 0x11e },
	'wb_grbglevels' => { 178 => 0x0 },
	'wb_rbgglevels' => { 175 => 0x0 },
	'wb_rblevels' => { 196 => 0xc, 260 => 0x100 },
	'wb_rblevels1' => { 282 => 0x2 },
	'wb_rblevels2' => { 282 => 0x5 },
	'wb_rblevels3' => { 282 => 0x8 },
	'wb_rblevels3000k' => { 260 => 0x102 },
	'wb_rblevels3300k' => { 260 => 0x103 },
	'wb_rblevels3500k' => { 165 => 0x430 },
	'wb_rblevels3600k' => { 260 => 0x104 },
	'wb_rblevels3900k' => { 260 => 0x105 },
	'wb_rblevels4' => { 282 => 0xb },
	'wb_rblevels4000k' => { 260 => 0x106 },
	'wb_rblevels4300k' => { 260 => 0x107 },
	'wb_rblevels4500k' => { 260 => 0x108 },
	'wb_rblevels4800k' => { 260 => 0x109 },
	'wb_rblevels5' => { 282 => 0xe },
	'wb_rblevels5300k' => { 260 => 0x10a },
	'wb_rblevels6' => { 282 => 0x11 },
	'wb_rblevels6000k' => { 260 => 0x10b },
	'wb_rblevels6500k' => { 165 => 0x420 },
	'wb_rblevels6600k' => { 260 => 0x10c },
	'wb_rblevels7' => { 282 => 0x14 },
	'wb_rblevels7500k' => { 260 => 0x10d },
	'wb_rblevelsauto' => { 264 => 0x110 },
	'wb_rblevelscloudy' => { 165 => 0x3f0, 167 => 0x10, 264 => 0x121 },
	'wb_rblevelscoolwhitef' => { 165 => 0x308, 167 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 264 => 0x132 },
	'wb_rblevelscustom' => { 165 => 0x424 },
	'wb_rblevelscwb1' => { 260 => 0x10e },
	'wb_rblevelscwb2' => { 260 => 0x10f },
	'wb_rblevelscwb3' => { 260 => 0x110 },
	'wb_rblevelscwb4' => { 260 => 0x111 },
	'wb_rblevelsdaylight' => { 165 => [0x3ec,0x528], 167 => 0xc },
	'wb_rblevelsdaylightf' => { 167 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 264 => 0x130 },
	'wb_rblevelsdaywhitef' => { 167 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 264 => 0x131 },
	'wb_rblevelseveningsunlight' => { 264 => 0x124 },
	'wb_rblevelsfineweather' => { 264 => 0x122 },
	'wb_rblevelsflash' => { 165 => [0x3f4,0x304], 167 => 0x18 },
	'wb_rblevelsshade' => { 165 => 0x418, 167 => 0x20, 264 => 0x120 },
	'wb_rblevelstungsten' => { 165 => 0x3e8, 167 => 0x8, 264 => 0x123 },
	'wb_rblevelsunknown' => { 167 => 0x1c },
	'wb_rblevelsused' => { 264 => 0x100 },
	'wb_rblevelswhitef' => { 167 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 264 => 0x133 },
	'wb_redlevel3500k' => { 165 => 0x198 },
	'wb_redlevel6500k' => { 165 => 0x188 },
	'wb_redlevelcustom' => { 165 => 0x18c },
	'wb_redlevelscloudy' => { 165 => 0xf8 },
	'wb_redlevelsdaylight' => { 165 => 0xdc },
	'wb_redlevelsflash' => { 165 => 0x114 },
	'wb_redlevelsfluorescent' => { 165 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 165 => 0x1be },
	'wb_redlevelsshade' => { 165 => 0x168 },
	'wb_redlevelstungsten' => { 165 => 0xc0 },
	'wb_rgbglevels' => { 177 => 0x0 },
	'wb_rgblevels' => { 165 => [0x546,0x96], 274 => 0xd, 275 => 0x413, 279 => 0x3036, 320 => 0x107, 372 => 0x117c, 373 => 0x1180, 374 => 0x115c, 375 => 0x11d8, 376 => 0x11b4, 377 => 0x106c, 378 => 0x264, 379 => 0x264 },
	'wb_rgblevels1' => { 283 => 0x2 },
	'wb_rgblevels2' => { 283 => 0x6 },
	'wb_rgblevels3' => { 283 => 0xa },
	'wb_rgblevels4' => { 283 => 0xe },
	'wb_rgblevels5' => { 283 => 0x12 },
	'wb_rgblevels6' => { 283 => 0x16 },
	'wb_rgblevels7' => { 283 => 0x1a },
	'wb_rggbblacklevels' => { 32 => 0x25 },
	'wb_rggblevels' => { 168 => 0x4, 176 => 0x0 },
	'wb_rggblevelsasshot' => { 34 => 0x0, 35 => 0x19, 36 => 0x22, 37 => 0x3f, 40 => 0x3f, 41 => 0x3f, 42 => 0x3f },
	'wb_rggblevelsauto' => { 32 => 0x1, 34 => 0x5, 35 => 0x1e, 36 => 0x18, 37 => 0x44, 40 => 0x44, 41 => 0x44, 42 => 0x44, 342 => 0xa022 },
	'wb_rggblevelsblack' => { 342 => 0xa028 },
	'wb_rggblevelscloudy' => { 32 => 0xd, 34 => 0x1e, 35 => 0x2d, 36 => 0x31, 37 => 0x58, 40 => 0x71, 41 => 0x8a, 42 => 0x8f, 311 => 0x20f, 319 => 0x14 },
	'wb_rggblevelscustom' => { 32 => 0x1d, 37 => 0x80 },
	'wb_rggblevelscustom1' => { 35 => 0x41 },
	'wb_rggblevelscustom2' => { 35 => 0x46 },
	'wb_rggblevelsdaylight' => { 32 => 0x5, 34 => 0x14, 35 => 0x23, 36 => 0x27, 37 => 0x4e, 40 => 0x67, 41 => 0x80, 42 => 0x85, 311 => 0x20d, 319 => 0x2 },
	'wb_rggblevelsflash' => { 32 => 0x19, 34 => 0x32, 35 => 0x3c, 36 => 0x45, 37 => 0x6c, 40 => 0x85, 41 => 0x9e, 42 => 0xa3, 311 => 0x214, 319 => 0x41 },
	'wb_rggblevelsfluorescent' => { 32 => 0x15, 34 => 0x28, 35 => 0x37, 36 => 0x3b, 37 => 0x62, 40 => 0x7b, 41 => 0x94, 42 => 0x99 },
	'wb_rggblevelsfluorescentd' => { 311 => 0x211, 319 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 319 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 311 => 0x212, 319 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 311 => 0x213, 319 => 0x38 },
	'wb_rggblevelsilluminator1' => { 342 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 342 => 0xa024 },
	'wb_rggblevelskelvin' => { 32 => 0x21, 34 => 0x2d, 36 => 0x40, 37 => 0x67, 40 => 0x80, 41 => 0x99, 42 => 0x9e },
	'wb_rggblevelsmeasured' => { 34 => 0xa, 37 => 0x49, 40 => 0x49, 41 => 0x49, 42 => 0x49 },
	'wb_rggblevelspc1' => { 36 => 0x90, 37 => 0x71 },
	'wb_rggblevelspc2' => { 36 => 0x95, 37 => 0x76 },
	'wb_rggblevelspc3' => { 36 => 0x9a, 37 => 0x7b },
	'wb_rggblevelsshade' => { 32 => 0x9, 34 => 0x19, 35 => 0x28, 36 => 0x2c, 37 => 0x53, 40 => 0x6c, 41 => 0x85, 42 => 0x8a, 311 => 0x20e, 319 => 0xb },
	'wb_rggblevelstungsten' => { 32 => 0x11, 34 => 0x23, 35 => 0x32, 36 => 0x36, 37 => 0x5d, 40 => 0x76, 41 => 0x8f, 42 => 0x94, 311 => 0x210, 319 => 0x1d },
	'wb_rggblevelsuncorrected' => { 342 => 0xa021 },
	'wb_rggblevelsunknown' => { 34 => 0xf, 36 => 0x1d, 40 => 0x4e, 41 => 0x4e, 42 => 0x4e, 319 => 0x53 },
	'wb_rggblevelsunknown10' => { 34 => 0x5f, 36 => 0x72, 40 => 0x9e, 41 => 0x7b, 42 => 0x7b },
	'wb_rggblevelsunknown11' => { 34 => 0x64, 36 => 0x77, 40 => 0xa3, 41 => 0xa3, 42 => 0x80 },
	'wb_rggblevelsunknown12' => { 34 => 0x69, 36 => 0x7c, 40 => 0xa8, 41 => 0xa8, 42 => 0xa8 },
	'wb_rggblevelsunknown13' => { 34 => 0x6e, 36 => 0x81, 40 => 0xad, 41 => 0xad, 42 => 0xad },
	'wb_rggblevelsunknown14' => { 36 => 0x86, 40 => 0xb2, 41 => 0xb2, 42 => 0xb2 },
	'wb_rggblevelsunknown15' => { 36 => 0x8b, 40 => 0xb7, 41 => 0xb7, 42 => 0xb7 },
	'wb_rggblevelsunknown16' => { 36 => 0x9f, 41 => 0xbc, 42 => 0xbc },
	'wb_rggblevelsunknown17' => { 41 => 0xc1, 42 => 0xc1 },
	'wb_rggblevelsunknown18' => { 41 => 0xc6, 42 => 0xc6 },
	'wb_rggblevelsunknown19' => { 41 => 0xcb, 42 => 0xcb },
	'wb_rggblevelsunknown2' => { 34 => 0x37, 36 => 0x4a, 40 => 0x53, 41 => 0x53, 42 => 0x53 },
	'wb_rggblevelsunknown20' => { 41 => 0xd0, 42 => 0xd0 },
	'wb_rggblevelsunknown21' => { 42 => 0xd5 },
	'wb_rggblevelsunknown22' => { 42 => 0xda },
	'wb_rggblevelsunknown23' => { 42 => 0xdf },
	'wb_rggblevelsunknown24' => { 42 => 0xe4 },
	'wb_rggblevelsunknown25' => { 42 => 0xe9 },
	'wb_rggblevelsunknown26' => { 42 => 0xee },
	'wb_rggblevelsunknown27' => { 42 => 0xf3 },
	'wb_rggblevelsunknown28' => { 42 => 0xf8 },
	'wb_rggblevelsunknown29' => { 42 => 0xfd },
	'wb_rggblevelsunknown3' => { 34 => 0x3c, 36 => 0x4f, 40 => 0x58, 41 => 0x58, 42 => 0x58 },
	'wb_rggblevelsunknown30' => { 42 => 0x102 },
	'wb_rggblevelsunknown4' => { 34 => 0x41, 36 => 0x54, 40 => 0x5d, 41 => 0x5d, 42 => 0x5d },
	'wb_rggblevelsunknown5' => { 34 => 0x46, 36 => 0x59, 40 => 0x62, 41 => 0x62, 42 => 0x62 },
	'wb_rggblevelsunknown6' => { 34 => 0x4b, 36 => 0x5e, 40 => 0x8a, 41 => 0x67, 42 => 0x67 },
	'wb_rggblevelsunknown7' => { 34 => 0x50, 36 => 0x63, 40 => 0x8f, 41 => 0x6c, 42 => 0x6c },
	'wb_rggblevelsunknown8' => { 34 => 0x55, 36 => 0x68, 40 => 0x94, 41 => 0x71, 42 => 0x71 },
	'wb_rggblevelsunknown9' => { 34 => 0x5a, 36 => 0x6d, 40 => 0x99, 41 => 0x76, 42 => 0x76 },
	'wb_rggblevelsuserselected' => { 319 => 0x5c },
	'wbadjblueamber' => { 92 => 0x20106 },
	'wbadjbluebalance' => { 240 => 0x8 },
	'wbadjcolortemp' => { 92 => 0x20102, 97 => 0x1a },
	'wbadjlighting' => { 240 => 0x14 },
	'wbadjmagentagreen' => { 92 => 0x20105 },
	'wbadjmode' => { 240 => 0x10 },
	'wbadjredbalance' => { 240 => 0x0 },
	'wbadjrggblevels' => { 92 => 0x20125, 97 => 0x6 },
	'wbadjtemperature' => { 240 => 0x18 },
	'wbadjtint' => { 240 => 0x25 },
	'wbbluelevel' => { 273 => 0x324, 277 => 0x8006, 281 => 0x26 },
	'wbbracketingsteps' => { 213 => 0x174d, 214 => 0x87c, 222 => 0x1757 },
	'wbbracketmode' => { 49 => 0x9 },
	'wbbracketshotnumber' => { 165 => 0x2b, 336 => 0x101a },
	'wbbracketvalueab' => { 49 => 0xc },
	'wbbracketvaluegm' => { 49 => 0xd },
	'wbfinetuneactive' => { 97 => 0x24 },
	'wbfinetunesaturation' => { 97 => 0x28 },
	'wbfinetunetone' => { 97 => 0x2c },
	'wbgreenlevel' => { 273 => 0x323, 277 => 0x8005, 281 => 0x25 },
	'wbmediaimagesizesetting' => { 73 => 0x708 },
	'wbmode' => { 167 => 0x4, 261 => 0x1015 },
	'wbredlevel' => { 273 => 0x322, 277 => 0x8004, 281 => 0x24 },
	'wbscale' => { 168 => 0x0 },
	'wbshiftab' => { 65 => 0xc, 277 => 0x46, 293 => 0x10 },
	'wbshiftab_gm' => { 365 => 0x2014 },
	'wbshiftab_gm_precise' => { 365 => 0x2026 },
	'wbshiftgm' => { 65 => 0xd, 277 => 0x47, 293 => 0x11 },
	'wbtype1' => { 282 => 0x1, 283 => 0x1 },
	'wbtype2' => { 282 => 0x4, 283 => 0x5 },
	'wbtype3' => { 282 => 0x7, 283 => 0x9 },
	'wbtype4' => { 282 => 0xa, 283 => 0xd },
	'wbtype5' => { 282 => 0xd, 283 => 0x11 },
	'wbtype6' => { 282 => 0x10, 283 => 0x15 },
	'wbtype7' => { 282 => 0x13, 283 => 0x19 },
	'webstatement' => { 437 => 'WebStatement' },
	'what' => { 409 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x77, 65 => 0x8, 67 => 0x7, 101 => 0x7, 102 => [0x19,0x2012], 107 => [0xa403,0xfe4e], 112 => 0x1002, 121 => 0x3fc, 122 => 0xfa0d, 123 => 0x40, 159 => 0x3, 160 => 0xe, 161 => 0x4, 162 => 0xb, 164 => 0x115, 196 => 0x5, 224 => 0x7, 273 => 0x304, 277 => 0x3, 279 => 0x3033, 311 => 0x19, 318 => 0x7, 335 => 0x26, 336 => 0x1003, 345 => [0x3c,0x7,0x58], 353 => 0xf, 354 => 0xe, 365 => [0x115,0xb054], 409 => 'WhiteBalance', 413 => 'WhiteBalance' },
	'whitebalance0' => { 155 => 'WhiteBalance0' },
	'whitebalance1' => { 155 => 'WhiteBalance1' },
	'whitebalance2' => { 155 => 'WhiteBalance2', 256 => 0x500 },
	'whitebalanceadj' => { 92 => 0x20101, 97 => 0x18, 234 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 289 => 0x0 },
	'whitebalancebias' => { 102 => 0x2011, 261 => 0x304, 277 => 0x23 },
	'whitebalanceblue' => { 65 => 0x7 },
	'whitebalancebracket' => { 256 => 0x502, 261 => 0x303 },
	'whitebalancebracketing' => { 162 => 0x22, 165 => 0x2c, 364 => 0x2c },
	'whitebalancecomp' => { 264 => 0x1001 },
	'whitebalancefinetune' => { 112 => 0x100a, 162 => 0x38, 164 => 0x112, 196 => 0xb, 336 => 0x1004, 353 => 0x6, 354 => 0x5, 365 => 0x112 },
	'whitebalancemode' => { 311 => 0x1a },
	'whitebalancered' => { 65 => 0x6 },
	'whitebalanceset' => { 292 => 0xa },
	'whitebalancesetting' => { 162 => 0x23, 353 => 0x5, 354 => 0x4, 355 => 0x16, 369 => 0xd },
	'whitebalancetemperature' => { 256 => 0x501 },
	'whiteboard' => { 261 => 0x301 },
	'whitelevel' => { 107 => 0xc61d, 311 => 0x7e },
	'whitepoint' => { 107 => 0x13e, 311 => 0x201, 429 => 'WhitePoint' },
	'whites2012' => { 409 => 'Whites2012' },
	'wideadapter' => { 336 => 0x1017 },
	'widefocuszone' => { 159 => 0x2f },
	'widerange' => { 344 => 0x20f },
	'windowsatom' => { 408 => 'windowsAtom' },
	'windowsatomextension' => { 408 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 408 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 408 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 423 => 'wordCount' },
	'workcolorspace' => { 92 => 0x10200, 97 => 0x270 },
	'worktodo' => { 415 => 'WorkToDo' },
	'worldtimelocation' => { 277 => 0x3a, 311 => 0x22, 317 => '0.1' },
	'writer-editor' => { 115 => 0x7a },
	'x3filllight' => { 345 => 0x12 },
	'xml' => { 119 => 'xml ' },
	'xmp' => { 95 => 0xffff00f6, 108 => 'XMP' },
	'xmptoolkit' => { 430 => 'xmptk' },
	'xpauthor' => { 107 => 0x9c9d },
	'xpcomment' => { 107 => 0x9c9c },
	'xpkeywords' => { 107 => 0x9c9e },
	'xposition' => { 107 => 0x11e },
	'xpsubject' => { 107 => 0x9c9f },
	'xptitle' => { 107 => 0x9c9b },
	'xresolution' => { 107 => 0x11a, 118 => 0x3, 326 => 0x0, 429 => 'XResolution' },
	'xyresolution' => { 111 => 0x3 },
	'yaw' => { 104 => 0x7 },
	'yawangle' => { 213 => 0x3513, 222 => 0x36fc },
	'ycbcrcoefficients' => { 107 => 0x211, 429 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 107 => 0x213, 429 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 107 => 0x212, 429 => 'YCbCrSubSampling' },
	'yearcreated' => { 123 => 0x10, 132 => 0xc },
	'yield' => { 425 => 'yield' },
	'yposition' => { 107 => 0x11f },
	'yresolution' => { 107 => 0x11b, 118 => 0x5, 326 => 0x4, 429 => 'YResolution' },
	'zonematching' => { 164 => 0x10a, 167 => [0x3a,0x4a], 365 => 0xb024 },
	'zonematchingmode' => { 162 => 0x14 },
	'zonematchingon' => { 161 => 0x75 },
	'zonematchingvalue' => { 353 => 0x1f },
	'zoomedpreviewlength' => { 261 => 0xf05 },
	'zoomedpreviewsize' => { 261 => 0xf06 },
	'zoomedpreviewstart' => { 261 => 0xf04 },
	'zoomsourcewidth' => { 31 => 0x24 },
	'zoomstepcount' => { 259 => 0x300, 261 => 0x100d },
	'zoomtargetwidth' => { 31 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationcontrol' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationcorrparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioncorrparams' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filegroupid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileuserid' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammainfo' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'int16u' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemtags' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestylepc' => 1,
	'picturestyleuserdef' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelshiftinfo' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'poseyawdegrees' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawfiletype' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'serialnumberhash' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecount' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spherical' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stereoscopic3d' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitched' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'variablelowpassfilter' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName || $field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2016, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
