#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.13';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 98 => 0x69 },
	'about' => { 424 => 'about' },
	'aboutcvterm' => { 416 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 416 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 416 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 416 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 416 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'abspeakaudiofilepath' => { 430 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 73 => 0x518 },
	'accelerometer' => { 336 => 0x3 },
	'accelerometerx' => { 275 => 0x8d },
	'accelerometery' => { 275 => 0x8e },
	'accelerometerz' => { 275 => 0x8c },
	'accessoryserialnumber' => { 275 => 0x54 },
	'accessorytype' => { 275 => 0x53 },
	'acedemicfield' => { 420 => 'acedemicField' },
	'actionadvised' => { 114 => 0x2a },
	'activearea' => { 106 => 0xc68d },
	'actived-lighting' => { 195 => 0x22, 231 => 0x24 },
	'actived-lightingmode' => { 231 => 0x25 },
	'adaptervoltage' => { 120 => 0x407 },
	'addaspectratioinfo' => { 73 => 0x80e },
	'additionalmodelinformation' => { 416 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 73 => 0x80f, 74 => 0x11, 75 => 0x13, 78 => 0x14 },
	'address' => { 141 => 'Address' },
	'adjustmentmode' => { 342 => 0x15 },
	'adlbracketingstep' => { 213 => 0x883 },
	'adlbracketingtype' => { 213 => 0x884 },
	'adobe' => { 107 => 'Adobe' },
	'adultcontentwarning' => { 264 => 'AdultContentWarning', 423 => 'adultContentWarning' },
	'advancedfilter' => { 111 => 0x1201 },
	'advancedraw' => { 233 => 0x76a43203 },
	'advancedscenetype' => { 275 => 0x3d },
	'advisory' => { 428 => 'Advisory' },
	'ae_iso' => { 282 => 0x2, 283 => 0x4, 284 => 0x12 },
	'aeaperture' => { 282 => 0x1, 283 => 0x3, 284 => 0x11 },
	'aeaperturesteps' => { 282 => 0x8, 283 => 0xb },
	'aebautocancel' => { 73 => 0x104 },
	'aebbracketvalue' => { 67 => 0x11 },
	'aebracketingsteps' => { 212 => 0x174c, 213 => 0x87b, 221 => 0x1756 },
	'aebsequence' => { 73 => 0x105 },
	'aebsequenceautocancel' => { 71 => 0x9, 72 => 0x9, 74 => 0x8, 75 => 0x9, 78 => 0x9, 79 => 0x7 },
	'aebshotcount' => { 73 => 0x106 },
	'aebxv' => { 282 => 0x4, 283 => 0x6 },
	'aeerror' => { 283 => 0x8 },
	'aeexposuretime' => { 282 => 0x0, 283 => 0x2, 284 => 0x10 },
	'aelbutton' => { 161 => 0x45 },
	'aelexposureindicator' => { 161 => 0x51 },
	'aelock' => { 161 => 0x5b, 242 => '4.2', 249 => '4.2', 254 => 0x201, 308 => 0x48, 350 => 0x40, 351 => 0x40, 352 => [0x86,0x286] },
	'aelockbutton' => { 240 => '16.1', 242 => '4.1', 244 => '15.1', 245 => '16.1', 246 => '16.1', 247 => '30.1', 248 => '16.1', 249 => '4.1', 251 => '17.1', 252 => '17.1' },
	'aelockbuttonplusdials' => { 240 => '16.2', 247 => '32.1', 251 => '44.1' },
	'aelockformb-d80' => { 252 => '3.1' },
	'aemaxaperture' => { 282 => 0x9, 283 => 0x10, 284 => 0x1c },
	'aemaxaperture2' => { 282 => 0xa, 283 => 0x11, 284 => 0x1d },
	'aemeteringmode' => { 282 => 0xc },
	'aemeteringmode2' => { 282 => '13.1' },
	'aemeteringsegments' => { 164 => 0x628, 308 => 0x209 },
	'aemicroadjustment' => { 73 => 0x110 },
	'aeminaperture' => { 282 => 0xb, 283 => 0x12, 284 => 0x1e },
	'aeminexposuretime' => { 282 => 0x5, 283 => 0x13, 284 => 0x1f },
	'aeprogrammode' => { 282 => 0x6 },
	'aeprojectlink' => { 405 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 405 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 405 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 405 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 405 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 405 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 31 => 0x21 },
	'aewhitebalance' => { 282 => 0xd },
	'aexv' => { 282 => 0x3, 283 => 0x5 },
	'af-cpriorityselection' => { 240 => '1.1', 241 => '1.1', 243 => '1.1', 245 => '0.1', 246 => '0.1', 247 => '1.1', 248 => '0.1', 251 => '1.1' },
	'af-onbutton' => { 243 => '70.1' },
	'af-onformb-d10' => { 240 => '3.3', 247 => '3.2' },
	'af-onformb-d11' => { 248 => '2.2' },
	'af-onformb-d12' => { 251 => '50.1' },
	'af-spriorityselection' => { 240 => '1.2', 241 => '1.2', 243 => '1.4', 247 => '1.2', 248 => '0.2', 251 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 240 => '2.1', 241 => '2.1', 243 => '78.3', 247 => '2.1', 251 => '2.1' },
	'afadjustment' => { 308 => 0x72 },
	'afandmeteringbuttons' => { 73 => 0x701 },
	'afaperture' => { 191 => 0x5, 192 => 0x5 },
	'afareaheight' => { 170 => 0x1a },
	'afareaillumination' => { 161 => 0x4b, 249 => '15.3' },
	'afareamode' => { 157 => 0x33, 161 => 0xe, 169 => 0x0, 170 => 0x5, 275 => 0xf, 333 => 0x1205, 343 => [0xa,0x3a], 350 => 0x11, 351 => 0x10, 352 => 0x24, 362 => 0xb043, 382 => 0x17 },
	'afareamodesetting' => { 242 => '11.1', 244 => '0.1', 249 => '16.1', 252 => '2.1', 362 => 0x201c },
	'afareas' => { 254 => 0x304 },
	'afareaselectmethod' => { 73 => 0x51b },
	'afareawidth' => { 170 => 0x18 },
	'afareaxposition' => { 170 => 0x14, 333 => 0x1203 },
	'afareaxposition1' => { 333 => 0x1201 },
	'afareayposition' => { 170 => 0x16, 333 => 0x1204 },
	'afareayposition1' => { 333 => 0x1202 },
	'afassist' => { 71 => 0x5, 79 => 0x5, 161 => 0x48, 240 => '2.5', 242 => '0.2', 244 => '0.2', 245 => '1.1', 246 => '1.1', 247 => '2.4', 248 => '1.4', 249 => '0.2', 251 => '2.4', 252 => '2.3' },
	'afassistbeam' => { 73 => 0x50e, 74 => 0x4, 75 => 0x5, 76 => 0x4, 77 => 0x4, 78 => 0x5 },
	'afassistlamp' => { 275 => 0x31 },
	'afbuttonpressed' => { 352 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 285 => 0x6 },
	'afduringliveview' => { 73 => 0x511 },
	'affinea' => { 399 => 'AffineA' },
	'affineb' => { 399 => 'AffineB' },
	'affinec' => { 399 => 'AffineC' },
	'affined' => { 399 => 'AffineD' },
	'affinetune' => { 171 => 0x0, 254 => 0x306 },
	'affinetuneadj' => { 171 => 0x2, 205 => 0x2d1, 206 => 0x2dc, 254 => 0x307 },
	'affinetuneindex' => { 171 => 0x1 },
	'affinex' => { 399 => 'AffineX' },
	'affiney' => { 399 => 'AffineY' },
	'afhold' => { 285 => 0x1fd },
	'afilluminator' => { 350 => 0x29, 362 => 0xb044 },
	'afimageheight' => { 170 => 0x12 },
	'afimagewidth' => { 170 => 0x10 },
	'afintegrationtime' => { 285 => 0x7 },
	'afmicroadj' => { 343 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 347 => 0x131 },
	'afmicroadjregisteredlenses' => { 347 => '305.1' },
	'afmicroadjustment' => { 73 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 347 => 0x130 },
	'afmode' => { 102 => 0x3009, 111 => 0x1022, 157 => 0x16, 342 => 0x5 },
	'afmoderestrictions' => { 241 => '50.3', 243 => '48.3', 251 => '48.3' },
	'afonaelockbuttonswitch' => { 73 => 0x702 },
	'afonbutton' => { 240 => '3.1', 241 => '47.1' },
	'afpoint' => { 31 => 0x13, 101 => 0x18, 157 => 0x15, 169 => 0x1, 257 => 0x308, 342 => 0x1f, 343 => [0x37,0x7], 347 => 0x19, 348 => 0x18, 349 => [0x18,0x20] },
	'afpointactivationarea' => { 72 => 0x11, 78 => 0x11 },
	'afpointareaexpansion' => { 73 => 0x508 },
	'afpointatshutterrelease' => { 343 => [0x39,0x9] },
	'afpointautoselection' => { 73 => 0x50b },
	'afpointbrightness' => { 73 => 0x50d, 240 => '2.4', 241 => '46.5', 243 => '2.2', 251 => '2.3' },
	'afpointdisplayduringfocus' => { 73 => 0x50c },
	'afpointillumination' => { 72 => 0xa, 240 => '2.3', 241 => '46.2', 243 => '47.2', 247 => '2.3', 248 => '1.3', 251 => '47.2', 252 => '2.4' },
	'afpointinfocus' => { 343 => [0x38,0x8] },
	'afpointmode' => { 289 => 0x3 },
	'afpointposition' => { 102 => 0x2021, 275 => 0x4d },
	'afpointregistration' => { 71 => 0x7 },
	'afpoints' => { 160 => 0x10 },
	'afpointselected' => { 161 => 0xd, 254 => 0x305, 308 => 0xe, 347 => 0x15, 348 => 0x14, 349 => [0x14,0x1c], 362 => 0x201e },
	'afpointselected2' => { 289 => 0x4 },
	'afpointselection' => { 72 => 0xb, 240 => '1.3', 241 => '1.3', 247 => '1.3', 251 => '1.3' },
	'afpointselectionmethod' => { 73 => 0x50f, 74 => 0xc, 75 => 0xd, 78 => 0xd },
	'afpointsetting' => { 350 => 0x12, 351 => 0x11 },
	'afpointsinfocus' => { 67 => 0xe, 169 => 0x2, 285 => 0xb, 308 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 72 => 0xd },
	'afpointsselected' => { 389 => 0x4 },
	'afpointsunknown1' => { 285 => 0x0 },
	'afpointsunknown2' => { 285 => 0x2 },
	'afpointsused' => { 170 => 0x8, 343 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 285 => 0x4 },
	'afresponse' => { 195 => 0xad },
	'afresult' => { 259 => 0x1038 },
	'afsearch' => { 254 => 0x303 },
	'afsensoractive' => { 157 => 0x1 },
	'afstatus' => { 333 => 0x1200 },
	'afstatus_00_b4' => { 346 => 0x0 },
	'afstatus_01_c4' => { 346 => 0x2 },
	'afstatus_02_d4' => { 346 => 0x4 },
	'afstatus_03_e4' => { 346 => 0x6 },
	'afstatus_04_f4' => { 346 => 0x8 },
	'afstatus_05_g4' => { 346 => 0xa },
	'afstatus_06_h4' => { 346 => 0xc },
	'afstatus_07_b3' => { 346 => 0xe },
	'afstatus_08_c3' => { 346 => 0x10 },
	'afstatus_09_d3' => { 346 => 0x12 },
	'afstatus_10_e3' => { 346 => 0x14 },
	'afstatus_11_f3' => { 346 => 0x16 },
	'afstatus_12_g3' => { 346 => 0x18 },
	'afstatus_13_h3' => { 346 => 0x1a },
	'afstatus_14_b2' => { 346 => 0x1c },
	'afstatus_15_c2' => { 346 => 0x1e },
	'afstatus_16_d2' => { 346 => 0x20 },
	'afstatus_17_e2' => { 346 => 0x22 },
	'afstatus_18_f2' => { 346 => 0x24 },
	'afstatus_19_g2' => { 346 => 0x26 },
	'afstatus_20_h2' => { 346 => 0x28 },
	'afstatus_21_c1' => { 346 => 0x2a },
	'afstatus_22_d1' => { 346 => 0x2c },
	'afstatus_23_e1' => { 346 => 0x2e },
	'afstatus_24_f1' => { 346 => 0x30 },
	'afstatus_25_g1' => { 346 => 0x32 },
	'afstatus_26_a7_vertical' => { 346 => 0x34 },
	'afstatus_27_a6_vertical' => { 346 => 0x36 },
	'afstatus_28_a5_vertical' => { 346 => 0x38 },
	'afstatus_29_c7_vertical' => { 346 => 0x3a },
	'afstatus_30_c6_vertical' => { 346 => 0x3c },
	'afstatus_31_c5_vertical' => { 346 => 0x3e },
	'afstatus_32_e7_vertical' => { 346 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 346 => 0x42 },
	'afstatus_34_e5_vertical' => { 346 => 0x44 },
	'afstatus_35_g7_vertical' => { 346 => 0x46 },
	'afstatus_36_g6_vertical' => { 346 => 0x48 },
	'afstatus_37_g5_vertical' => { 346 => 0x4a },
	'afstatus_38_i7_vertical' => { 346 => 0x4c },
	'afstatus_39_i6_vertical' => { 346 => 0x4e },
	'afstatus_40_i5_vertical' => { 346 => 0x50 },
	'afstatus_41_a7' => { 346 => 0x52 },
	'afstatus_42_b7' => { 346 => 0x54 },
	'afstatus_43_c7' => { 346 => 0x56 },
	'afstatus_44_d7' => { 346 => 0x58 },
	'afstatus_45_e7' => { 346 => 0x5a },
	'afstatus_46_f7' => { 346 => 0x5c },
	'afstatus_47_g7' => { 346 => 0x5e },
	'afstatus_48_h7' => { 346 => 0x60 },
	'afstatus_49_i7' => { 346 => 0x62 },
	'afstatus_50_a6' => { 346 => 0x64 },
	'afstatus_51_b6' => { 346 => 0x66 },
	'afstatus_52_c6' => { 346 => 0x68 },
	'afstatus_53_d6' => { 346 => 0x6a },
	'afstatus_54_e6_center' => { 346 => 0x6c },
	'afstatus_55_f6' => { 346 => 0x6e },
	'afstatus_56_g6' => { 346 => 0x70 },
	'afstatus_57_h6' => { 346 => 0x72 },
	'afstatus_58_i6' => { 346 => 0x74 },
	'afstatus_59_a5' => { 346 => 0x76 },
	'afstatus_60_b5' => { 346 => 0x78 },
	'afstatus_61_c5' => { 346 => 0x7a },
	'afstatus_62_d5' => { 346 => 0x7c },
	'afstatus_63_e5' => { 346 => 0x7e },
	'afstatus_64_f5' => { 346 => 0x80 },
	'afstatus_65_g5' => { 346 => 0x82 },
	'afstatus_66_h5' => { 346 => 0x84 },
	'afstatus_67_i5' => { 346 => 0x86 },
	'afstatus_68_c11' => { 346 => 0x88 },
	'afstatus_69_d11' => { 346 => 0x8a },
	'afstatus_70_e11' => { 346 => 0x8c },
	'afstatus_71_f11' => { 346 => 0x8e },
	'afstatus_72_g11' => { 346 => 0x90 },
	'afstatus_73_b10' => { 346 => 0x92 },
	'afstatus_74_c10' => { 346 => 0x94 },
	'afstatus_75_d10' => { 346 => 0x96 },
	'afstatus_76_e10' => { 346 => 0x98 },
	'afstatus_77_f10' => { 346 => 0x9a },
	'afstatus_78_g10' => { 346 => 0x9c },
	'afstatus_79_h10' => { 346 => 0x9e },
	'afstatus_80_b9' => { 346 => 0xa0 },
	'afstatus_81_c9' => { 346 => 0xa2 },
	'afstatus_82_d9' => { 346 => 0xa4 },
	'afstatus_83_e9' => { 346 => 0xa6 },
	'afstatus_84_f9' => { 346 => 0xa8 },
	'afstatus_85_g9' => { 346 => 0xaa },
	'afstatus_86_h9' => { 346 => 0xac },
	'afstatus_87_b8' => { 346 => 0xae },
	'afstatus_88_c8' => { 346 => 0xb0 },
	'afstatus_89_d8' => { 346 => 0xb2 },
	'afstatus_90_e8' => { 346 => 0xb4 },
	'afstatus_91_f8' => { 346 => 0xb6 },
	'afstatus_92_g8' => { 346 => 0xb8 },
	'afstatus_93_h8' => { 346 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 346 => 0xbc },
	'afstatusactivesensor' => { 157 => 0x2, 343 => [0x4,0x3b], 347 => 0x1e, 348 => 0x1b, 349 => [0x1b,0x21] },
	'afstatusbottom' => { 157 => 0x8, 347 => 0x2a, 348 => 0x21, 349 => 0x21 },
	'afstatusbottom-left' => { 157 => 0x12, 348 => 0x2b, 349 => 0x2b },
	'afstatusbottom-right' => { 157 => 0x6, 348 => 0x1f, 349 => 0x1f },
	'afstatusbottomassist-left' => { 347 => 0x28 },
	'afstatusbottomassist-right' => { 347 => 0x2c },
	'afstatusbottomhorizontal' => { 344 => 0x10, 345 => 0x1c },
	'afstatusbottomvertical' => { 344 => 0x16, 345 => 0x26 },
	'afstatuscenter-10' => { 347 => 0x34 },
	'afstatuscenter-11' => { 347 => 0x36 },
	'afstatuscenter-12' => { 347 => 0x38 },
	'afstatuscenter-14' => { 347 => 0x3c },
	'afstatuscenter-7' => { 347 => 0x2e },
	'afstatuscenter-9' => { 347 => 0x32 },
	'afstatuscenter-horizontal' => { 347 => 0x30 },
	'afstatuscenter-vertical' => { 347 => 0x3a },
	'afstatuscenterf2-8' => { 347 => 0x4c },
	'afstatuscenterhorizontal' => { 157 => 0x2f, 344 => 0xc, 345 => 0x18, 348 => 0x2f, 349 => 0x2f },
	'afstatuscentervertical' => { 157 => 0xc, 344 => 0x14, 345 => 0x22, 348 => 0x25, 349 => 0x25 },
	'afstatusfarleft' => { 344 => 0x6, 347 => 0x26 },
	'afstatusfarlefthorizontal' => { 345 => 0x4 },
	'afstatusfarleftvertical' => { 345 => 0x12 },
	'afstatusfarright' => { 344 => 0x18, 347 => 0x44 },
	'afstatusfarrighthorizontal' => { 345 => 0x2c },
	'afstatusfarrightvertical' => { 345 => 0x34 },
	'afstatusleft' => { 157 => 0x2d, 344 => 0x2, 347 => 0x22, 348 => 0x2d, 349 => 0x2d },
	'afstatuslefthorizontal' => { 345 => 0x6 },
	'afstatusleftvertical' => { 345 => 0xe },
	'afstatuslower-left' => { 344 => 0x4, 347 => 0x24 },
	'afstatuslower-lefthorizontal' => { 345 => 0xa },
	'afstatuslower-leftvertical' => { 345 => 0x10 },
	'afstatuslower-middle' => { 344 => 0x22, 345 => 0x24 },
	'afstatuslower-right' => { 344 => 0x1e, 347 => 0x4a },
	'afstatuslower-righthorizontal' => { 345 => 0x32 },
	'afstatuslower-rightvertical' => { 345 => 0x3a },
	'afstatuslowerfarleft' => { 345 => 0x8 },
	'afstatuslowerfarright' => { 345 => 0x30 },
	'afstatusmiddlehorizontal' => { 157 => 0xa, 348 => 0x23, 349 => 0x23 },
	'afstatusnearleft' => { 344 => 0xe, 345 => 0x1a },
	'afstatusnearright' => { 344 => 0xa, 345 => 0x16 },
	'afstatusright' => { 157 => 0x31, 344 => 0x1c, 347 => 0x48, 348 => 0x31, 349 => 0x31 },
	'afstatusrighthorizontal' => { 345 => 0x2e },
	'afstatusrightvertical' => { 345 => 0x38 },
	'afstatustop' => { 157 => 0xe, 347 => 0x40, 348 => 0x27, 349 => 0x27 },
	'afstatustop-left' => { 157 => 0x10, 348 => 0x29, 349 => 0x29 },
	'afstatustop-right' => { 157 => 0x4, 348 => 0x1d, 349 => 0x1d },
	'afstatustopassist-left' => { 347 => 0x3e },
	'afstatustopassist-right' => { 347 => 0x42 },
	'afstatustophorizontal' => { 344 => 0x8, 345 => 0x14 },
	'afstatustopvertical' => { 344 => 0x12, 345 => 0x1e },
	'afstatusupper-left' => { 344 => 0x0, 347 => 0x20 },
	'afstatusupper-lefthorizontal' => { 345 => 0x2 },
	'afstatusupper-leftvertical' => { 345 => 0xc },
	'afstatusupper-middle' => { 344 => 0x20, 345 => 0x20 },
	'afstatusupper-right' => { 344 => 0x1a, 347 => 0x46 },
	'afstatusupper-righthorizontal' => { 345 => 0x2a },
	'afstatusupper-rightvertical' => { 345 => 0x36 },
	'afstatusupperfarleft' => { 345 => 0x0 },
	'afstatusupperfarright' => { 345 => 0x28 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 343 => 0x2 },
	'afwithshutter' => { 350 => 0x2a },
	'afzoneselected' => { 362 => 0x201e },
	'aggregateissuenumber' => { 420 => 'aggregateIssueNumber' },
	'aggregationtype' => { 420 => 'aggregationType' },
	'agreement' => { 423 => 'agreement' },
	'aiservocontinuousshooting' => { 72 => 0x15 },
	'aiservofirstimagepriority' => { 73 => 0x519 },
	'aiservoimagepriority' => { 73 => 0x503 },
	'aiservosecondimagepriority' => { 73 => 0x51a },
	'aiservotrackingmethod' => { 73 => 0x504 },
	'aiservotrackingsensitivity' => { 72 => 0x14, 73 => 0x502 },
	'album' => { 430 => 'album' },
	'alreadyapplied' => { 406 => 'AlreadyApplied' },
	'alternatetitle' => { 420 => 'alternateTitle' },
	'alternatetitlea-lang' => { 420 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 420 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 420 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 172 => 0x6 },
	'alttapename' => { 430 => 'altTapeName' },
	'alttimecode' => { 430 => 'altTimecode' },
	'alttimecodetimeformat' => { 430 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 430 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 430 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 329 => 0x14, 382 => 0x4 },
	'ambienttemperaturefahrenheit' => { 329 => 0x13 },
	'analogbalance' => { 106 => 0xc627 },
	'angleadj' => { 92 => 0x10003, 98 => 0x8b },
	'angleinforoll' => { 401 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 401 => 'AngleInfoYaw' },
	'anti-blur' => { 362 => 0xb04b },
	'antialiasstrength' => { 106 => 0xc632 },
	'aperturelock' => { 241 => '38.2', 243 => '38.2', 251 => '38.2' },
	'aperturerange' => { 73 => 0x10d },
	'apertureringuse' => { 289 => '1.4' },
	'aperturesetting' => { 161 => 0x7, 350 => 0x30, 351 => 0x29, 352 => 0x1 },
	'aperturevalue' => { 82 => 0x2, 106 => 0x9202, 259 => 0x1002, 317 => 0x401, 410 => 'ApertureValue' },
	'applekeywords' => { 263 => 'AAPL:Keywords' },
	'applicationnotes' => { 106 => 0x2bc, 279 => 0x2bc },
	'applicationrecordversion' => { 114 => 0x0 },
	'applyshootingmeteringmode' => { 73 => 0x10e },
	'approved' => { 412 => 'Approved' },
	'approvedby' => { 412 => 'ApprovedBy' },
	'approximatefnumber' => { 271 => 0x313, 277 => 0x3406 },
	'approximatefocusdistance' => { 402 => 'ApproximateFocusDistance' },
	'aquahsl' => { 92 => 0x20913 },
	'armidentifier' => { 115 => 0x78 },
	'armversion' => { 115 => 0x7a },
	'artfilter' => { 254 => 0x529 },
	'artfiltereffect' => { 254 => 0x52f },
	'artist' => { 106 => 0x13b, 267 => 'Artist', 308 => 0x22e, 426 => 'Artist', 430 => 'artist' },
	'artmode' => { 102 => 0x301b },
	'artmodeparameters' => { 102 => 0x310b },
	'artworkcircadatecreated' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontributiondescription' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 416 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworkscontentdescription' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworksource' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 416 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 258 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 258 => 0x1112, 308 => 0x80, 350 => 0x55, 351 => 0x55, 352 => 0xa },
	'asshoticcprofile' => { 106 => 0xc68f },
	'asshotneutral' => { 106 => 0xc628 },
	'asshotpreprofilematrix' => { 106 => 0xc690 },
	'asshotprofilename' => { 106 => 0xc6f6 },
	'asshotwhitexy' => { 106 => 0xc629 },
	'assignbktbutton' => { 240 => '4.2', 241 => '16.1', 243 => '16.1', 251 => '16.1' },
	'assignfuncbutton' => { 73 => 0x70b },
	'assignmb-d17af-onbutton' => { 243 => '79.1' },
	'assignmb-d17funcbutton' => { 243 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 243 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 243 => '75.1' },
	'assignmoviefunc2button' => { 243 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 243 => '75.2' },
	'assignmovierecordbutton' => { 241 => '43.2', 251 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 243 => '45.1' },
	'assignmoviesubselector' => { 243 => '74.1' },
	'assignmoviesubselectorplusdials' => { 243 => '76.1' },
	'assignremotefnbutton' => { 241 => '54.1', 251 => '51.1' },
	'assistbuttonfunction' => { 71 => 0xd },
	'attributionname' => { 403 => 'attributionName' },
	'attributionurl' => { 403 => 'attributionURL' },
	'audio' => { 275 => 0x20 },
	'audiobitrate' => { 58 => 0x6c },
	'audiochannels' => { 58 => 0x70 },
	'audiochanneltype' => { 430 => 'audioChannelType' },
	'audiocompression' => { 135 => 'Compression' },
	'audiocompressor' => { 430 => 'audioCompressor' },
	'audioduration' => { 114 => 0x99 },
	'audiomoddate' => { 430 => 'audioModDate' },
	'audiooutcue' => { 114 => 0x9a },
	'audiosamplerate' => { 58 => 0x6e, 430 => 'audioSampleRate' },
	'audiosampletype' => { 430 => 'audioSampleType' },
	'audiosamplingrate' => { 114 => 0x97 },
	'audiosamplingresolution' => { 114 => 0x98 },
	'audiotype' => { 114 => 0x96 },
	'author' => { 137 => 'Author', 263 => 'Author', 267 => 'Author', 324 => 'Author', 400 => 'author', 417 => 'Author', 428 => 'Author' },
	'authorsposition' => { 418 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 73 => 0x51c },
	'autoaperture' => { 299 => '0.1' },
	'autobracket' => { 342 => 0x19 },
	'autobracketing' => { 111 => 0x1100, 308 => 0x18, 333 => 0x1007 },
	'autobracketingmode' => { 250 => '12.3' },
	'autobracketingset' => { 250 => '12.1' },
	'autobracketmodem' => { 240 => '21.2', 241 => '13.3', 243 => '13.2', 247 => '26.2', 251 => '13.3' },
	'autobracketorder' => { 161 => 0x43, 240 => '21.3', 241 => '13.2', 243 => '13.1', 247 => '26.3', 248 => '12.2', 249 => '2.2', 250 => '12.2', 251 => '13.2', 252 => '13.2' },
	'autobracketset' => { 240 => '21.1', 241 => '13.1', 244 => '11.1', 245 => '12.1', 246 => '12.1', 247 => '26.1', 248 => '12.1', 249 => '2.1', 251 => '13.1', 252 => '13.1' },
	'autobrightness' => { 406 => 'AutoBrightness' },
	'autocontrast' => { 406 => 'AutoContrast' },
	'autodistortioncontrol' => { 180 => 0x4 },
	'autodynamicrange' => { 111 => 0x140b },
	'autoexposure' => { 406 => 'AutoExposure' },
	'autoexposurebracketing' => { 67 => 0x10 },
	'autoflashisosensitivity' => { 243 => '38.5' },
	'autofocus' => { 257 => 0x209 },
	'autofp' => { 249 => '7.3', 252 => '31.4' },
	'autoiso' => { 67 => 0x1, 102 => 0x3008, 242 => '1.1', 249 => '1.1' },
	'autoisomax' => { 242 => '1.2', 249 => '1.2' },
	'autoisominshutterspeed' => { 242 => '1.3', 249 => '1.3' },
	'autolateralca' => { 406 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 54 => 0x2, 73 => 0x204, 92 => 0x20500, 98 => 0x6f },
	'autolightingoptimizeron' => { 92 => '0x20500.0', 98 => 0x6e },
	'autoportraitframed' => { 362 => 0x2016 },
	'autoredeye' => { 233 => 0xfe28a44f },
	'autorotate' => { 67 => 0x1b },
	'autoshadows' => { 406 => 'AutoShadows' },
	'autowhiteversion' => { 406 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 195 => 0x82 },
	'avaperturesetting' => { 289 => 0x13 },
	'averageblacklevel' => { 38 => 0xe7, 40 => 0xfb, 41 => 0x114, 42 => 0x146 },
	'averagelv' => { 164 => 0x38 },
	'avsettingwithoutlens' => { 73 => 0x707 },
	'azimuth' => { 145 => 'Azimuth' },
	'babyage' => { 275 => [0x8010,0x33] },
	'babyname' => { 275 => 0x66 },
	'backgroundalpha' => { 425 => 'bgalpha' },
	'baseexposurecompensation' => { 289 => 0x15 },
	'baseiso' => { 67 => 0x2, 86 => 0x101c, 120 => 0x903, 277 => 0x312a, 387 => 0x6 },
	'baselineexposure' => { 106 => 0xc62a },
	'baselineexposureoffset' => { 106 => 0xc7a5 },
	'baselinenoise' => { 106 => 0xc62b },
	'baselinesharpness' => { 106 => 0xc62c },
	'baseurl' => { 428 => 'BaseURL' },
	'batterylevel' => { 350 => 0x51, 354 => 0xc, 355 => 0x4, 356 => 0x4, 388 => 0x7 },
	'batterylevelgrip1' => { 388 => 0x6 },
	'batterylevelgrip2' => { 388 => 0x8 },
	'batteryorder' => { 240 => '12.5', 247 => '13.2', 248 => '2.1', 251 => '3.1' },
	'batterystate' => { 161 => 0x60, 350 => 0x50, 356 => 0x14 },
	'batterytemperature' => { 354 => 0x1, 356 => 0x2, 388 => 0x5 },
	'batteryunknown' => { 354 => 0x2, 356 => 0x0 },
	'batteryvoltage' => { 120 => 0x408, 329 => 0x2a, 354 => 0x8 },
	'batteryvoltage1' => { 356 => 0x6 },
	'batteryvoltage2' => { 356 => 0x8 },
	'bayergreensplit' => { 106 => 0xc62d },
	'bayerpattern' => { 119 => 0xf902, 165 => 0x17 },
	'beatspliceparams' => { 430 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 430 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 430 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 430 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 430 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 430 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 240 => '13.1', 241 => '5.4', 242 => '0.1', 244 => '2.1', 245 => '3.1', 246 => '3.1', 247 => '10.1', 249 => '0.1', 251 => '5.5', 252 => '4.1' },
	'beeppitch' => { 248 => '3.1' },
	'beepvolume' => { 248 => '4.5' },
	'bestqualityscale' => { 106 => 0xc65c },
	'bestshotmode' => { 102 => 0x3007 },
	'bitdepth' => { 142 => 'BitDepth', 165 => 0x11, 202 => 0x41 },
	'bitspercomponent' => { 116 => 0x87 },
	'bitspersample' => { 106 => 0x102, 426 => 'BitsPerSample' },
	'blacklevel' => { 106 => 0xc61a, 195 => 0x3d, 259 => [0x401,0x1012], 317 => 0x21d },
	'blacklevel1' => { 279 => 0x8 },
	'blacklevel2' => { 258 => 0x600, 262 => 0x600, 279 => 0x9 },
	'blacklevel3' => { 279 => 0xa },
	'blacklevelblue' => { 279 => 0x1e },
	'blackleveldata' => { 317 => 0x223 },
	'blackleveldeltah' => { 106 => 0xc61b },
	'blackleveldeltav' => { 106 => 0xc61c },
	'blacklevelgreen' => { 279 => 0x1d },
	'blacklevelred' => { 279 => 0x1c },
	'blacklevelrepeatdim' => { 106 => 0xc619 },
	'blackpoint' => { 308 => 0x200 },
	'blacks2012' => { 406 => 'Blacks2012' },
	'bleachbypasstoning' => { 308 => 0x7f },
	'blockshotafresponse' => { 243 => '1.5' },
	'blogtitle' => { 420 => 'blogTitle' },
	'blogurl' => { 420 => 'blogURL' },
	'bluebalance' => { 178 => 0x271, 259 => 0x1018, 279 => 0x12, 308 => 0x1b },
	'bluecurvelimits' => { 97 => 0x1fe },
	'bluecurvepoints' => { 96 => 0x79, 97 => 0x1d4 },
	'bluehsl' => { 92 => [0x20914,0x20915] },
	'bluehue' => { 406 => 'BlueHue' },
	'bluesaturation' => { 406 => 'BlueSaturation' },
	'blurcontrol' => { 308 => 0x82 },
	'blurwarning' => { 111 => 0x1300 },
	'bodybatteryadload' => { 287 => 0x3 },
	'bodybatteryadnoload' => { 287 => 0x2 },
	'bodybatterystate' => { 287 => '1.1' },
	'bodybatteryvoltage1' => { 287 => 0x2 },
	'bodybatteryvoltage2' => { 287 => 0x4 },
	'bodybatteryvoltage3' => { 287 => 0x6 },
	'bodybatteryvoltage4' => { 287 => 0x8 },
	'bodyfirmware' => { 334 => 0x0 },
	'bodyfirmwareversion' => { 255 => 0x104, 256 => 0x100, 259 => 0x104 },
	'bodyserialnumber' => { 334 => 0x10 },
	'bookedition' => { 420 => 'bookEdition' },
	'bracketmode' => { 49 => 0x3 },
	'bracketsequence' => { 102 => 0x301d },
	'bracketsettings' => { 275 => 0x45 },
	'bracketshotnumber' => { 49 => 0x5, 289 => 0x9, 361 => 0x2b },
	'bracketshotnumber2' => { 361 => 0x2d },
	'bracketstep' => { 158 => 0xe },
	'bracketvalue' => { 49 => 0x4 },
	'brightness' => { 106 => 0xfe53, 136 => 'Brightness', 154 => 'Brightness', 158 => 0x2c, 197 => 0x34, 198 => 0x39, 329 => 0x25, 350 => 0x22, 362 => 0x2007, 406 => 'Brightness' },
	'brightnessadj' => { 97 => 0x114, 226 => 0x0, 236 => 0x2d, 391 => 0x8018 },
	'brightnessvalue' => { 106 => 0x9203, 164 => [0x691,0x49c3], 259 => 0x1003, 366 => 0x1e, 369 => 0x1140, 370 => 0x1140, 371 => 0x111c, 372 => 0x1198, 373 => 0x1174, 374 => 0x102c, 375 => 0x224, 376 => 0x224, 410 => 'BrightnessValue' },
	'bulbduration' => { 67 => 0x18 },
	'burstmode' => { 122 => 0xa, 275 => 0x2a },
	'burstmode2' => { 122 => 0x18 },
	'burstshot' => { 342 => 0x34 },
	'burstspeed' => { 275 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 73 => 0x70a },
	'bwfilter' => { 158 => 0x2a, 166 => 0x39 },
	'bwmode' => { 259 => 0x203 },
	'by-line' => { 114 => 0x50 },
	'by-linetitle' => { 114 => 0x55 },
	'bytecount' => { 420 => 'byteCount' },
	'calibration' => { 342 => [0x24,0x30] },
	'calibrationilluminant1' => { 106 => 0xc65a },
	'calibrationilluminant2' => { 106 => 0xc65b },
	'cameraangle' => { 430 => 'cameraAngle' },
	'cameracalibration1' => { 106 => 0xc623 },
	'cameracalibration2' => { 106 => 0xc624 },
	'cameracalibrationsig' => { 106 => 0xc6f3 },
	'cameracolorcalibration01' => { 33 => 0x0, 39 => 0xba },
	'cameracolorcalibration02' => { 33 => 0x4, 39 => 0xbf },
	'cameracolorcalibration03' => { 33 => 0x8, 39 => 0xc4 },
	'cameracolorcalibration04' => { 33 => 0xc, 39 => 0xc9 },
	'cameracolorcalibration05' => { 33 => 0x10, 39 => 0xce },
	'cameracolorcalibration06' => { 33 => 0x14, 39 => 0xd3 },
	'cameracolorcalibration07' => { 33 => 0x18, 39 => 0xd8 },
	'cameracolorcalibration08' => { 33 => 0x1c, 39 => 0xdd },
	'cameracolorcalibration09' => { 33 => 0x20, 39 => 0xe2 },
	'cameracolorcalibration10' => { 33 => 0x24, 39 => 0xe7 },
	'cameracolorcalibration11' => { 33 => 0x28, 39 => 0xec },
	'cameracolorcalibration12' => { 33 => 0x2c, 39 => 0xf1 },
	'cameracolorcalibration13' => { 33 => 0x30, 39 => 0xf6 },
	'cameracolorcalibration14' => { 33 => 0x34, 39 => 0xfb },
	'cameracolorcalibration15' => { 33 => 0x38, 39 => 0x100 },
	'camerae-mountversion' => { 390 => 0xb },
	'cameraid' => { 259 => 0x209, 341 => 0x209 },
	'camerainclination' => { 212 => 0x3693, 213 => 0xca, 221 => 0x38be },
	'cameraiso' => { 31 => 0x10 },
	'cameralabel' => { 106 => 0xc7a1, 430 => 'cameraLabel' },
	'cameramodel' => { 317 => 0x410, 430 => 'cameraModel' },
	'cameramodelid' => { 154 => 'CameraModelID' },
	'cameramove' => { 430 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 26 => 0x35, 275 => 0x8f, 312 => 0x1, 317 => 0x100, 356 => [0x16,0x18], 379 => 0x28, 380 => 0x24, 381 => 0x29 },
	'cameraowner' => { 123 => 0xc353 },
	'cameraparameters' => { 259 => 0x2050 },
	'camerapicturestyle' => { 26 => 0xaf },
	'cameraprofile' => { 406 => 'CameraProfile' },
	'cameraprofiledigest' => { 406 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 98 => 0xe1 },
	'camerarawcontrast' => { 98 => 0xe3 },
	'camerarawhighlightpoint' => { 98 => 0xe6 },
	'camerarawlinear' => { 98 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 98 => 0xe8 },
	'camerarawoutputshadowpoint' => { 98 => 0xe9 },
	'camerarawsaturation' => { 98 => 0xe2 },
	'camerarawshadowpoint' => { 98 => 0xe7 },
	'camerarawsharpness' => { 98 => 0xe5 },
	'cameraserialnumber' => { 106 => 0xc62f, 156 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 254 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x19, 27 => [0x87,0x91], 28 => [0x99,0x9f,0xa4,0xa8,0x105], 30 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 67 => 0xc, 120 => 0x406, 258 => 0x1306, 271 => 0x320, 277 => 0x3402, 308 => 0x47, 339 => 0x43, 383 => 0x5 },
	'cameratemperature4' => { 313 => 0x14 },
	'cameratemperature5' => { 313 => 0x16 },
	'cameratemperaturerangemax' => { 108 => 0x5 },
	'cameratemperaturerangemin' => { 108 => 0x6 },
	'cameratype' => { 67 => 0x1a, 259 => 0x207 },
	'cameratype2' => { 255 => 0x100 },
	'canondr4' => { 107 => 'CanonDR4' },
	'canonexposuremode' => { 31 => 0x14 },
	'canonfiledescription' => { 86 => 0x805 },
	'canonfilelength' => { 55 => 0xe },
	'canonfirmwareversion' => { 55 => 0x7, 86 => 0x80b },
	'canonflashinfo' => { 86 => 0x1028 },
	'canonflashmode' => { 31 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 31 => 0xa },
	'canonimagetype' => { 55 => 0x6, 86 => 0x815 },
	'canonmodelid' => { 55 => 0x10, 86 => 0x1834 },
	'canonvrd' => { 107 => 'CanonVRD' },
	'caption' => { 400 => 'caption' },
	'caption-abstract' => { 114 => 0x78 },
	'captionsauthornames' => { 409 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 409 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 418 => 'CaptionWriter' },
	'captureframerate' => { 102 => 0x4001 },
	'capturesoftware' => { 395 => 'CaptureSoftware' },
	'cardshutterlock' => { 161 => 0x49 },
	'casioimagesize' => { 102 => 0x9 },
	'catalogsets' => { 114 => 0xff, 394 => 'CatalogSets', 398 => 'CatalogSets' },
	'categories' => { 55 => 0x23, 400 => 'categories' },
	'category' => { 114 => 0xf, 253 => 0x30, 418 => 'Category' },
	'cbcrgain' => { 339 => 0xa036 },
	'cbcrgaindefault' => { 339 => 0xa035 },
	'cbcrmatrix' => { 339 => 0xa034 },
	'cbcrmatrixdefault' => { 339 => 0xa033 },
	'ccdboardversion' => { 271 => 0x331 },
	'ccdscanmode' => { 259 => 0x1039 },
	'ccdsensitivity' => { 223 => 0x6 },
	'ccdversion' => { 271 => 0x330 },
	'cellglobalid' => { 404 => 'cgi' },
	'celllength' => { 106 => 0x109 },
	'cellr' => { 404 => 'r' },
	'celltowerid' => { 404 => 'cellid' },
	'cellwidth' => { 106 => 0x108 },
	'centerafarea' => { 249 => '15.1' },
	'centerfocuspoint' => { 252 => '2.2' },
	'centerweightedareasize' => { 240 => '7.1', 241 => '8.1', 243 => '8.1', 247 => '5.1', 248 => '7.1', 249 => '6.3', 251 => '8.1', 252 => '8.1' },
	'certificate' => { 434 => 'Certificate' },
	'cfapattern' => { 106 => 0xa302, 410 => 'CFAPattern' },
	'cfapattern2' => { 106 => 0x828e },
	'cfapatterncolumns' => { 410 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 410 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 410 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 106 => 0x828d },
	'channel' => { 420 => 'channel' },
	'channela-lang' => { 420 => [\'channel','channelA-lang'] },
	'channelchannel' => { 420 => [\'channel','channelChannel'] },
	'channels' => { 135 => 'Channels' },
	'channelsubchannel1' => { 420 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 420 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 420 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 420 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 92 => 0x10101, 97 => 0x26a },
	'checkmark2' => { 98 => 0x8e },
	'childfontfiles' => { 435 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 240 => '10.3', 241 => '11.2' },
	'chromablurradius' => { 106 => 0xc631 },
	'chromaticaberration' => { 92 => 0x20703, 98 => 0x66, 339 => 0xa051 },
	'chromaticaberrationb' => { 406 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 92 => 0x20708, 98 => 0x6b },
	'chromaticaberrationcorr' => { 69 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 298 => 0x1 },
	'chromaticaberrationon' => { 92 => '0x20703.0', 98 => 0x62 },
	'chromaticaberrationr' => { 406 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 92 => 0x20707, 98 => 0x6a },
	'chromaticaberrationsetting' => { 70 => 0x6 },
	'chrominancenoisereduction' => { 92 => 0x20601, 98 => 0x5e, 342 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 98 => 0x60 },
	'circgradbasedcorractive' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 406 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 406 => 'CircularGradientBasedCorrections' },
	'city' => { 114 => 0x5a, 141 => 'City', 275 => 0x6d, 418 => 'City' },
	'city2' => { 275 => 0x80 },
	'clarity' => { 198 => 0x35, 406 => 'Clarity' },
	'clarity2012' => { 406 => 'Clarity2012' },
	'classifystate' => { 114 => 0xe1 },
	'clearretouch' => { 275 => 0x7c },
	'clearretouchvalue' => { 275 => 0xa3 },
	'client' => { 430 => 'client' },
	'clientname' => { 412 => 'ClientName' },
	'clmodeshootingspeed' => { 240 => '10.2', 241 => '11.3', 243 => '11.2', 247 => '11.2', 248 => '10.2', 251 => '11.2', 252 => '11.1' },
	'cmcontrast' => { 262 => 0x2022 },
	'cmexposurecompensation' => { 262 => 0x2000 },
	'cmhue' => { 262 => 0x2021 },
	'cmsaturation' => { 262 => 0x2020 },
	'cmsharpness' => { 262 => 0x2023 },
	'cmwhitebalance' => { 262 => 0x2001 },
	'cmwhitebalancecomp' => { 262 => 0x2002 },
	'cmwhitebalancegraypoint' => { 262 => 0x2010 },
	'codec' => { 149 => 'Codec' },
	'codedcharacterset' => { 115 => 0x5a },
	'collectionname' => { 150 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 150 => 'Collections', 400 => 'collections' },
	'collectionuri' => { 150 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 419 => 'color' },
	'coloraberrationcontrol' => { 233 => 0xc89224b },
	'coloradjustment' => { 342 => 0x14 },
	'coloradjustmentmode' => { 341 => 0x210 },
	'coloranta' => { 435 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 435 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 435 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 435 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 435 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 435 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 435 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 435 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 435 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 435 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 435 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 435 => 'Colorants' },
	'colorantswatchname' => { 435 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 435 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 435 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 435 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 136 => 'ColorBalance' },
	'colorbalanceadj' => { 233 => 0x76a43202 },
	'colorbalanceblue' => { 158 => 0x1e },
	'colorbalancegreen' => { 158 => 0x1d },
	'colorbalancered' => { 158 => 0x1c },
	'colorbalanceversion' => { 179 => 0x0 },
	'colorblur' => { 98 => 0x65 },
	'colorbluron' => { 92 => 0x20704 },
	'colorbooster' => { 233 => 0x5f0e7d23 },
	'colorboostlevel' => { 227 => 0x1 },
	'colorboosttype' => { 227 => 0x0 },
	'colorclass' => { 319 => 0xde, 320 => 'ColorClass' },
	'colorcompensationfilter' => { 161 => [0x3a,0x5f], 163 => 0x111, 362 => 0xb022 },
	'colorcompensationfiltercustom' => { 350 => 0xd, 351 => 0xc },
	'colorcompensationfilterset' => { 350 => 0x8, 351 => 0x7, 352 => 0x18, 366 => 0xf },
	'colorcontrol' => { 259 => 0x102b },
	'colorcorrection' => { 391 => 0x8015 },
	'colorcreatoreffect' => { 254 => 0x532 },
	'colordataversion' => { 37 => 0x0, 38 => 0x0, 40 => 0x0, 41 => 0x0, 42 => 0x0 },
	'coloreffect' => { 275 => 0x28 },
	'colorfilter' => { 101 => 0x17, 102 => 0x3017, 158 => 0x29, 166 => [0x38,0x4d,0x4f], 315 => 0x17 },
	'colorgain' => { 202 => 0x51 },
	'colorhue' => { 92 => 0x20900, 195 => 0x8d },
	'colorimetricreference' => { 106 => 0xc6bf },
	'colorlabel' => { 409 => 'ColorLabel' },
	'colormatrix' => { 258 => 0x200, 259 => 0x1011, 339 => 0xa030 },
	'colormatrix1' => { 106 => 0xc621, 317 => 0x106 },
	'colormatrix2' => { 106 => 0xc622, 262 => 0x200, 317 => 0x226 },
	'colormatrixa' => { 308 => 0x203 },
	'colormatrixadobergb' => { 339 => 0xa032 },
	'colormatrixb' => { 308 => 0x204 },
	'colormatrixnumber' => { 259 => 0x1019 },
	'colormatrixsrgb' => { 339 => 0xa031 },
	'colormode' => { 102 => 0x3015, 111 => 0x1210, 122 => 0x66, 158 => 0x28, 161 => 0x16, 163 => 0x101, 164 => 0x36, 166 => 0x7, 195 => 0x3, 223 => 0x4, 275 => 0x32, 342 => 0x2c, 362 => 0xb029, 418 => 'ColorMode' },
	'colormoirereduction' => { 234 => 0x15 },
	'colormoirereductionmode' => { 234 => 0x5 },
	'colornoisereduction' => { 391 => 0x8029, 406 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 406 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 234 => 0x18 },
	'colornoisereductionsharpness' => { 234 => 0x1c },
	'colornoisereductionsmoothness' => { 406 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 110 => 0x2 },
	'colorprofile' => { 158 => 0x33 },
	'colorprofilesettings' => { 254 => 0x539 },
	'colorrepresentation' => { 116 => 0x3c },
	'colorsaturationadj' => { 92 => 0x20305 },
	'colorsequence' => { 116 => 0x41 },
	'colorspace' => { 43 => 0x3, 55 => 0xb4, 86 => 0x10b4, 106 => 0xa001, 142 => 'ColorSpace', 159 => 0x2f, 160 => 0x25, 161 => 0x17, 195 => 0x1e, 254 => 0x507, 308 => 0x37, 339 => 0xa011, 342 => 0xb, 350 => 0x1b, 351 => 0x83, 352 => 0xe, 366 => 0x6, 410 => 'ColorSpace' },
	'colortempasshot' => { 34 => 0x4, 35 => 0x1d, 36 => 0x26, 37 => 0x43, 40 => 0x43, 41 => 0x43, 42 => 0x43 },
	'colortempauto' => { 34 => 0x9, 35 => 0x22, 36 => 0x1c, 37 => 0x48, 40 => 0x48, 41 => 0x48, 42 => 0x48 },
	'colortempcloudy' => { 34 => 0x22, 35 => 0x31, 36 => 0x35, 37 => 0x5c, 40 => 0x75, 41 => 0x8e, 42 => 0x93, 308 => 0x55 },
	'colortempcustom' => { 37 => 0x84 },
	'colortempcustom1' => { 35 => 0x45 },
	'colortempcustom2' => { 35 => 0x4a },
	'colortempdaylight' => { 34 => 0x18, 35 => 0x27, 36 => 0x2b, 37 => 0x52, 40 => 0x6b, 41 => 0x84, 42 => 0x89, 308 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x7b, 55 => 0xae, 65 => 0x9, 86 => 0x10ae, 111 => 0x1005, 120 => 0x846, 136 => 'ColorTemperature', 159 => [0x6e,0x49], 160 => 0x3f, 161 => [0x39,0x5e], 163 => 0x10b, 166 => [0x3c,0x4c,0x4e], 271 => 0x321, 308 => 0x50, 333 => 0x1308, 362 => 0xb021, 406 => 'Temperature' },
	'colortemperatureadj' => { 391 => 0x8013 },
	'colortemperaturebg' => { 259 => 0x1013 },
	'colortemperaturecustom' => { 350 => 0xc, 351 => 0xb },
	'colortemperaturerg' => { 259 => 0x1014 },
	'colortemperatureset' => { 350 => 0x7, 351 => 0x6 },
	'colortemperaturesetting' => { 161 => 0x25, 352 => 0x17, 366 => 0xe },
	'colortempflash' => { 34 => 0x36, 35 => 0x40, 36 => 0x49, 37 => 0x70, 40 => 0x89, 41 => 0xa2, 42 => 0xa7, 308 => 0x5a },
	'colortempflashdata' => { 37 => 0x24a },
	'colortempfluorescent' => { 34 => 0x2c, 35 => 0x3b, 36 => 0x3f, 37 => 0x66, 40 => 0x7f, 41 => 0x98, 42 => 0x9d },
	'colortempfluorescentd' => { 308 => 0x57 },
	'colortempfluorescentn' => { 308 => 0x58 },
	'colortempfluorescentw' => { 308 => 0x59 },
	'colortempkelvin' => { 34 => 0x31, 36 => 0x44, 37 => 0x6b, 40 => 0x84, 41 => 0x9d, 42 => 0xa2, 275 => 0x44, 333 => 0x1307 },
	'colortempmeasured' => { 34 => 0xe, 37 => 0x4d, 40 => 0x4d, 41 => 0x4d, 42 => 0x4d },
	'colortemppc1' => { 36 => 0x94, 37 => 0x75 },
	'colortemppc2' => { 36 => 0x99, 37 => 0x7a },
	'colortemppc3' => { 36 => 0x9e, 37 => 0x7f },
	'colortempshade' => { 34 => 0x1d, 35 => 0x2c, 36 => 0x30, 37 => 0x57, 40 => 0x70, 41 => 0x89, 42 => 0x8e, 308 => 0x54 },
	'colortemptungsten' => { 34 => 0x27, 35 => 0x36, 36 => 0x3a, 37 => 0x61, 40 => 0x7a, 41 => 0x93, 42 => 0x98, 308 => 0x56 },
	'colortempunknown' => { 34 => 0x13, 36 => 0x21, 40 => 0x52, 41 => 0x52, 42 => 0x52 },
	'colortempunknown10' => { 34 => 0x63, 36 => 0x76, 40 => 0xa2, 41 => 0x7f, 42 => 0x7f },
	'colortempunknown11' => { 34 => 0x68, 36 => 0x7b, 40 => 0xa7, 41 => 0xa7, 42 => 0x84 },
	'colortempunknown12' => { 34 => 0x6d, 36 => 0x80, 40 => 0xac, 41 => 0xac, 42 => 0xac },
	'colortempunknown13' => { 34 => 0x72, 36 => 0x85, 40 => 0xb1, 41 => 0xb1, 42 => 0xb1 },
	'colortempunknown14' => { 36 => 0x8a, 40 => 0xb6, 41 => 0xb6, 42 => 0xb6 },
	'colortempunknown15' => { 36 => 0x8f, 40 => 0xbb, 41 => 0xbb, 42 => 0xbb },
	'colortempunknown16' => { 36 => 0xa3, 41 => 0xc0, 42 => 0xc0 },
	'colortempunknown17' => { 41 => 0xc5, 42 => 0xc5 },
	'colortempunknown18' => { 41 => 0xca, 42 => 0xca },
	'colortempunknown19' => { 41 => 0xcf, 42 => 0xcf },
	'colortempunknown2' => { 34 => 0x3b, 36 => 0x4e, 40 => 0x57, 41 => 0x57, 42 => 0x57 },
	'colortempunknown20' => { 41 => 0xd4, 42 => 0xd4 },
	'colortempunknown21' => { 42 => 0xd9 },
	'colortempunknown22' => { 42 => 0xde },
	'colortempunknown23' => { 42 => 0xe3 },
	'colortempunknown24' => { 42 => 0xe8 },
	'colortempunknown25' => { 42 => 0xed },
	'colortempunknown26' => { 42 => 0xf2 },
	'colortempunknown27' => { 42 => 0xf7 },
	'colortempunknown28' => { 42 => 0xfc },
	'colortempunknown29' => { 42 => 0x101 },
	'colortempunknown3' => { 34 => 0x40, 36 => 0x53, 40 => 0x5c, 41 => 0x5c, 42 => 0x5c },
	'colortempunknown30' => { 42 => 0x106 },
	'colortempunknown4' => { 34 => 0x45, 36 => 0x58, 40 => 0x61, 41 => 0x61, 42 => 0x61 },
	'colortempunknown5' => { 34 => 0x4a, 36 => 0x5d, 40 => 0x66, 41 => 0x66, 42 => 0x66 },
	'colortempunknown6' => { 34 => 0x4f, 36 => 0x62, 40 => 0x8e, 41 => 0x6b, 42 => 0x6b },
	'colortempunknown7' => { 34 => 0x54, 36 => 0x67, 40 => 0x93, 41 => 0x70, 42 => 0x70 },
	'colortempunknown8' => { 34 => 0x59, 36 => 0x6c, 40 => 0x98, 41 => 0x75, 42 => 0x75 },
	'colortempunknown9' => { 34 => 0x5e, 36 => 0x71, 40 => 0x9d, 41 => 0x7a, 42 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 31 => 0x2a, 43 => 0x2 },
	'colortoneadj' => { 92 => 0x20304, 97 => 0x11e },
	'colortoneauto' => { 62 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 61 => 0x6c, 62 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 61 => 0x3c, 62 => 0x3c },
	'colortonemonochrome' => { 61 => 0x84, 62 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 61 => 0x54, 62 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 61 => 0x24, 62 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 61 => 0xc, 62 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 61 => 0x9c, 62 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 61 => 0xb4, 62 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 61 => 0xcc, 62 => 0xe4 },
	'commanddials' => { 249 => '5.1' },
	'commanddialsaperturesetting' => { 240 => '17.3', 241 => '18.3', 243 => '18.3', 247 => '33.3', 248 => '17.3', 251 => '18.3' },
	'commanddialschangemainsub' => { 240 => '17.2', 241 => '18.1', 243 => '18.1', 247 => '33.2', 248 => '17.2', 251 => '18.1' },
	'commanddialsmenuandplayback' => { 240 => '17.4', 241 => '18.2', 243 => '18.2', 247 => '33.4', 248 => '17.4', 251 => '18.2' },
	'commanddialsreverserotation' => { 240 => '17.1', 241 => '6.4', 243 => '6.2', 244 => '16.2', 245 => '17.2', 247 => '33.1', 248 => '17.1', 251 => '6.2', 252 => '18.1' },
	'commanderchannel' => { 249 => '10.2', 250 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 249 => '13.1', 250 => '31.1' },
	'commandergroupa_ttlcomp' => { 252 => '32.1' },
	'commandergroupamanualoutput' => { 249 => '13.2', 250 => '28.2' },
	'commandergroupamode' => { 249 => '11.2', 250 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 249 => '14.1', 250 => '32.1' },
	'commandergroupb_ttlcomp' => { 252 => '33.1' },
	'commandergroupbmanualoutput' => { 249 => '14.2', 250 => '29.2' },
	'commandergroupbmode' => { 249 => '11.3', 250 => '29.1' },
	'commanderinternalflash' => { 249 => '11.1', 250 => '27.1' },
	'commanderinternalmanualoutput' => { 249 => '12.2', 250 => '27.2' },
	'commanderinternalttlchannel' => { 247 => '18.2' },
	'commanderinternalttlcomp' => { 249 => '12.1', 250 => '30.2', 252 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 247 => '20.1', 248 => '26.1' },
	'commanderinternalttlcompgroupa' => { 247 => '21.1', 248 => '27.1' },
	'commanderinternalttlcompgroupb' => { 247 => '22.1', 248 => '28.1' },
	'comment' => { 0 => 0x2, 107 => 'Comment', 137 => 'Comment', 267 => 'Comment' },
	'compass' => { 336 => 0x4 },
	'complianceprofile' => { 420 => 'complianceProfile' },
	'componentsconfiguration' => { 106 => 0x9101, 142 => 'Components', 410 => 'ComponentsConfiguration' },
	'componentversion' => { 86 => 0x80c },
	'composer' => { 430 => 'composer' },
	'compositionadjust' => { 307 => '0.1' },
	'compositionadjustrotation' => { 307 => 0x7 },
	'compositionadjustx' => { 307 => 0x5 },
	'compositionadjusty' => { 307 => 0x6 },
	'compressedbitsperpixel' => { 106 => 0x9102, 410 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 163 => 0x40, 259 => 0x40 },
	'compression' => { 106 => 0x103, 426 => 'Compression' },
	'compressionfactor' => { 254 => 0x50d },
	'compressionratio' => { 142 => 'Compression', 259 => 0x1034 },
	'confidencelevel' => { 401 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 97 => 0x266, 319 => 0xd6 },
	'constrainedcropwidth' => { 97 => 0x262, 319 => 0xd5 },
	'contact' => { 114 => 0x76 },
	'contactinfo' => { 419 => 'contactInfo' },
	'contentlocationcode' => { 114 => 0x1a },
	'contentlocationname' => { 114 => 0x1b },
	'contenttype' => { 420 => 'contentType' },
	'continuousbracketing' => { 161 => 0x20 },
	'continuousdrive' => { 31 => 0x5 },
	'continuousshootingspeed' => { 73 => 0x610 },
	'continuousshotlimit' => { 73 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 31 => 0xd, 101 => 0xc, 102 => [0x3012,0x20], 106 => [0xa408,0xfe54], 111 => [0x1004,0x1006], 136 => 'Contrast', 154 => 'Contrast', 158 => 0x20, 159 => 0x31, 160 => 0x27, 161 => 0x19, 166 => 0x2, 197 => 0x33, 198 => 0x37, 259 => 0x1029, 275 => 0x39, 277 => 0x300a, 308 => 0x20, 315 => 0xc, 329 => 0x24, 333 => 0x1012, 342 => 0xd, 350 => 0x1d, 351 => 0x1a, 362 => 0x2004, 406 => 'Contrast', 410 => 'Contrast' },
	'contrast2012' => { 406 => 'Contrast2012' },
	'contrastadj' => { 92 => 0x20303, 97 => 0x115, 236 => 0x2c, 391 => 0x8017 },
	'contrastauto' => { 62 => 0x90 },
	'contrastcurve' => { 195 => 0x8c },
	'contrastdetectaf' => { 170 => 0x4 },
	'contrastdetectafarea' => { 308 => 0x231 },
	'contrastdetectafinfocus' => { 170 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 61 => 0x60, 62 => 0x60 },
	'contrasthighlight' => { 308 => 0x6d },
	'contrasthighlightshadowadj' => { 308 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 61 => 0x30, 62 => 0x30 },
	'contrastmode' => { 275 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 61 => 0x78, 62 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 61 => 0x48, 62 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 61 => 0x18, 62 => 0x18 },
	'contrastsetting' => { 254 => 0x505, 262 => 0x1012, 352 => 0x10, 366 => 0x8 },
	'contrastshadow' => { 308 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 61 => 0x0, 62 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 61 => 0x90, 62 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 61 => 0xa8, 62 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 61 => 0xc0, 62 => 0xd8 },
	'contributedmedia' => { 430 => 'contributedMedia' },
	'contributedmediaduration' => { 430 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 430 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 430 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 430 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 430 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 430 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 430 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 430 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 430 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 430 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 407 => 'contributor' },
	'contributors' => { 137 => 'Contributors' },
	'controldialset' => { 161 => 0x46 },
	'controlledvocabularyterm' => { 416 => 'CVterm' },
	'controllerboardversion' => { 271 => 0x332 },
	'controlmode' => { 67 => 0x12 },
	'conversionlens' => { 255 => 0x403, 275 => 0x35 },
	'converter' => { 106 => 0xfe4d, 223 => 0xb, 406 => 'Converter' },
	'converttograyscale' => { 406 => 'ConvertToGrayscale' },
	'cookingequipment' => { 422 => 'cookingEquipment' },
	'cookingmethod' => { 422 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 106 => 0x8298, 137 => 'Copyright', 267 => 'Copyright', 308 => 0x22f, 324 => 'Copyright', 417 => 'Copyright', 423 => 'copyright', 426 => 'Copyright', 430 => 'copyright' },
	'copyrightflag' => { 322 => 0x40a },
	'copyrightnotice' => { 114 => 0x74 },
	'copyrightowner' => { 264 => 'CopyrightOwner' },
	'copyrightownerid' => { 264 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 264 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 264 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 264 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 264 => 'CopyrightStatus' },
	'copyrightyear' => { 420 => 'copyrightYear' },
	'coringfilter' => { 258 => 0x310, 259 => 0x102d, 262 => 0x310 },
	'coringvalues' => { 258 => 0x311, 262 => 0x311 },
	'corporateentity' => { 420 => 'corporateEntity' },
	'country' => { 141 => 'Country', 275 => 0x69, 418 => 'Country' },
	'country-primarylocationcode' => { 114 => 0x64 },
	'country-primarylocationname' => { 114 => 0x65 },
	'countrycode' => { 194 => 0x5, 320 => 'CountryCode', 415 => 'CountryCode' },
	'course' => { 422 => 'course' },
	'coverage' => { 407 => 'coverage' },
	'coverdate' => { 420 => 'coverDate' },
	'coverdisplaydate' => { 420 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 308 => 0x28 },
	'crc32' => { 408 => 'crc32' },
	'createdate' => { 106 => 0x9004, 137 => 'CreateDate', 263 => 'CreationDate', 267 => 'create-date', 324 => 'CreationDate', 326 => 0x1, 428 => 'CreateDate' },
	'creationdate' => { 417 => 'CreationDate', 420 => 'creationDate' },
	'creationtime' => { 267 => 'Creation Time' },
	'creativestyle' => { 350 => 0x1a, 351 => 0x18, 361 => 0x41, 362 => 0xb020, 387 => 0x4a },
	'creativestylesetting' => { 352 => 0xf, 366 => 0x7 },
	'creativestylewaschanged' => { 391 => 0x8001 },
	'creator' => { 263 => 'Creator', 324 => 'Creator', 407 => 'creator', 417 => 'Creator' },
	'creatoraddress' => { 415 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 156 => 'CreatorAppId' },
	'creatorcity' => { 415 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 415 => 'CreatorContactInfo' },
	'creatorcountry' => { 415 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoropenwithuioptions' => { 156 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 415 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 415 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 428 => 'CreatorTool' },
	'creatorworkemail' => { 415 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 415 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 415 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 114 => 0x6e, 418 => 'Credit' },
	'creditline' => { 423 => 'creditLine' },
	'creditlinereq' => { 433 => 'CreditLineReq' },
	'creditlinerequired' => { 264 => 'CreditLineRequired' },
	'cropactive' => { 90 => 0x0, 97 => 0x244 },
	'cropangle' => { 406 => 'CropAngle' },
	'cropaspectratio' => { 92 => 0x30101, 97 => 0x260 },
	'cropaspectratiocustom' => { 92 => 0x30102 },
	'cropbottom' => { 110 => 0x9, 228 => 0x36, 279 => 0x31, 319 => 0xdc, 406 => 'CropBottom' },
	'cropbottommargin' => { 45 => 0x3 },
	'cropcircleactive' => { 98 => 0xd6 },
	'cropcircleradius' => { 98 => 0xd9 },
	'cropcirclex' => { 98 => 0xd7 },
	'cropcircley' => { 98 => 0xd8 },
	'cropconstraintowarp' => { 406 => 'CropConstrainToWarp' },
	'croph' => { 399 => 'CropH' },
	'cropheight' => { 90 => 0x6, 97 => 0x24c, 258 => 0x615, 262 => 0x615, 406 => 'CropHeight' },
	'crophispeed' => { 195 => 0x1b },
	'cropleft' => { 97 => 0x246, 110 => 0x6, 228 => 0x1e, 258 => 0x612, 262 => 0x612, 279 => 0x30, 319 => 0xd9, 406 => 'CropLeft' },
	'cropleftmargin' => { 45 => 0x0 },
	'cropmode35mm' => { 333 => 0x1018 },
	'croporiginalheight' => { 90 => 0xb },
	'croporiginalwidth' => { 90 => 0xa },
	'cropoutputheight' => { 228 => 0xce },
	'cropoutputheightinches' => { 228 => 0x96 },
	'cropoutputpixels' => { 228 => 0xd6 },
	'cropoutputresolution' => { 228 => 0xb6 },
	'cropoutputscale' => { 228 => 0xbe },
	'cropoutputwidth' => { 228 => 0xc6 },
	'cropoutputwidthinches' => { 228 => 0x8e },
	'croppedareaimageheightpixels' => { 395 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 395 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 395 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 395 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 333 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 333 => 0x1603 },
	'cropright' => { 110 => 0x8, 228 => 0x2e, 279 => 0x32, 319 => 0xdb, 406 => 'CropRight' },
	'croprightmargin' => { 45 => 0x1 },
	'croprotatedoriginalheight' => { 90 => 0x2 },
	'croprotatedoriginalwidth' => { 90 => 0x1 },
	'croprotation' => { 90 => 0x8, 110 => 0xb },
	'cropscaledresolution' => { 228 => 0x9e },
	'cropsourceresolution' => { 228 => 0xae },
	'croptop' => { 97 => 0x248, 110 => 0x7, 228 => 0x26, 258 => 0x613, 262 => 0x613, 279 => 0x2f, 319 => 0xda, 406 => 'CropTop' },
	'croptopmargin' => { 45 => 0x2 },
	'cropunit' => { 406 => 'CropUnit' },
	'cropunits' => { 406 => 'CropUnits' },
	'cropw' => { 399 => 'CropW' },
	'cropwidth' => { 90 => 0x5, 97 => 0x24a, 258 => 0x614, 262 => 0x614, 406 => 'CropWidth' },
	'cropx' => { 90 => 0x3, 399 => 'CropX' },
	'cropy' => { 90 => 0x4, 399 => 'CropY' },
	'crossprocess' => { 308 => 0x7b },
	'crossprocessparams' => { 308 => 0x235 },
	'cuisine' => { 422 => 'cuisine' },
	'currenticcprofile' => { 106 => 0xc691 },
	'currentpreprofilematrix' => { 106 => 0xc692 },
	'currentversion' => { 391 => 0xd000 },
	'curve0x' => { 399 => 'Curve0x' },
	'curve0y' => { 399 => 'Curve0y' },
	'curve1x' => { 399 => 'Curve1x' },
	'curve1y' => { 399 => 'Curve1y' },
	'curve2x' => { 399 => 'Curve2x' },
	'curve2y' => { 399 => 'Curve2y' },
	'curve3x' => { 399 => 'Curve3x' },
	'curve3y' => { 399 => 'Curve3y' },
	'curve4x' => { 399 => 'Curve4x' },
	'curve4y' => { 399 => 'Curve4y' },
	'curves' => { 233 => 0x76a43201 },
	'custom1' => { 264 => 'Custom1' },
	'custom10' => { 264 => 'Custom10' },
	'custom2' => { 264 => 'Custom2' },
	'custom3' => { 264 => 'Custom3' },
	'custom4' => { 264 => 'Custom4' },
	'custom5' => { 264 => 'Custom5' },
	'custom6' => { 264 => 'Custom6' },
	'custom7' => { 264 => 'Custom7' },
	'custom8' => { 264 => 'Custom8' },
	'custom9' => { 264 => 'Custom9' },
	'customcolortone' => { 98 => 0x4c },
	'customcontrast' => { 98 => 0x4e },
	'customcontrols' => { 73 => 0x70c },
	'customdefaultunsharpfineness' => { 98 => 0xbe },
	'customdefaultunsharpstrength' => { 98 => 0xbc },
	'customdefaultunsharpthreshold' => { 98 => 0xc0 },
	'customlinear' => { 98 => 0x4f },
	'customoutputhighlightpoint' => { 98 => 0x53 },
	'customoutputshadowpoint' => { 98 => 0x54 },
	'custompicturestyle' => { 92 => 0x10021 },
	'custompicturestyledata' => { 92 => 0xf0500 },
	'custompicturestylefilename' => { 55 => 0x4010 },
	'customrawhighlight' => { 98 => 0x7c },
	'customrawhighlightpoint' => { 98 => 0x51 },
	'customrawshadow' => { 98 => 0x85 },
	'customrawshadowpoint' => { 98 => 0x52 },
	'customrendered' => { 106 => 0xa401, 410 => 'CustomRendered' },
	'customsaturation' => { 98 => 0x4d, 254 => 0x503 },
	'customsettingsalldefault' => { 240 => '0.2', 247 => '0.2' },
	'customsettingsbank' => { 240 => '0.1', 241 => '0.1', 243 => '0.1', 247 => '0.1', 251 => '0.2' },
	'customsharpness' => { 98 => 0x50 },
	'customunsharpmaskfineness' => { 98 => 0xb8 },
	'customunsharpmaskstrength' => { 98 => 0xb6 },
	'customunsharpmaskthreshold' => { 98 => 0xba },
	'customwb_rblevels' => { 366 => 0x1a },
	'customwb_rgblevels' => { 351 => 0x8, 352 => 0x19 },
	'customwbbluelevel' => { 161 => 0x36 },
	'customwberror' => { 161 => 0x37 },
	'customwbgreenlevel' => { 161 => 0x35 },
	'customwbredlevel' => { 161 => 0x34 },
	'customwbsetting' => { 161 => 0x26 },
	'd-lightinghq' => { 233 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 229 => 0x2 },
	'd-lightinghqhighlight' => { 229 => 0x1 },
	'd-lightinghqselected' => { 233 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 229 => 0x0 },
	'd-lightinghs' => { 233 => 0xce5554aa },
	'd-lightinghsadjustment' => { 230 => 0x0 },
	'd-lightinghscolorboost' => { 230 => 0x1 },
	'd-rangeoptimizerhighlight' => { 391 => 0x8024 },
	'd-rangeoptimizermode' => { 391 => 0x8022 },
	'd-rangeoptimizershadow' => { 391 => 0x802d },
	'd-rangeoptimizervalue' => { 391 => 0x8023 },
	'd810meteringmode' => { 221 => 0x175e },
	'datacompressionmethod' => { 116 => 0x6e },
	'dataimprint' => { 158 => 0x34 },
	'datascaling' => { 308 => 0x3d },
	'date' => { 308 => 0x6, 407 => 'date' },
	'dateacquired' => { 156 => 'DateAcquired' },
	'datecreated' => { 114 => 0x37, 418 => 'DateCreated' },
	'datedisplayformat' => { 225 => 0x3 },
	'dateidentified' => { 105 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 244 => '4.2' },
	'daterecieved' => { 420 => 'dateRecieved' },
	'datesent' => { 115 => 0x46 },
	'datestampmode' => { 55 => 0x1c },
	'datetime' => { 400 => 'datetime', 426 => 'DateTime' },
	'datetimedigitized' => { 410 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 89 => 0x0, 106 => 0x9003, 134 => 0x14, 137 => 'OriginalDate', 329 => 0xb, 410 => 'DateTimeOriginal' },
	'datetimestamp' => { 122 => 0x64 },
	'datetimeutc' => { 254 => 0x908 },
	'daylightsavings' => { 68 => 0x3, 225 => 0x2 },
	'dccontinent' => { 105 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 105 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 105 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 105 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 105 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 105 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 105 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 105 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 105 => 'Event' },
	'dcfootprintspatialfit' => { 105 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 105 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 105 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 105 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 105 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 105 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 105 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 105 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 105 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 105 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 105 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 105 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 105 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 105 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 105 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 105 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 105 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 145 => 'Declination' },
	'decposition' => { 158 => 0x32 },
	'defaultautogray' => { 406 => 'DefaultAutoGray' },
	'defaultautotone' => { 406 => 'DefaultAutoTone' },
	'defaultblackrender' => { 106 => 0xc7a6 },
	'defaultcroporigin' => { 106 => 0xc61f },
	'defaultcropsize' => { 106 => 0xc620 },
	'defaulteraseoption' => { 73 => 0x813 },
	'defaultscale' => { 106 => 0xc61e },
	'defaultsspecifictoiso' => { 406 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 406 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 106 => 0xc7b5 },
	'defringe' => { 406 => 'Defringe' },
	'defringegreenamount' => { 406 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 406 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 406 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 406 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 406 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 406 => 'DefringePurpleHueLo' },
	'dehaze' => { 406 => 'Dehaze' },
	'deletedimagecount' => { 195 => 0xa6, 203 => 0x6e },
	'deprecatedon' => { 403 => 'deprecatedOn' },
	'derivedfrom' => { 431 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 431 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 431 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 431 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 431 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 431 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 431 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 431 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 431 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 431 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 431 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 431 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 431 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 431 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 431 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 431 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 431 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 431 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 267 => 'Description', 407 => 'description', 428 => 'Description' },
	'destination' => { 115 => 0x5 },
	'destinationcity' => { 308 => 0x24, 314 => 0x3 },
	'destinationcitycode' => { 315 => 0x1001 },
	'destinationdst' => { 308 => 0x26, 314 => '0.3' },
	'developmentdynamicrange' => { 111 => 0x1403 },
	'device' => { 420 => 'device' },
	'devicesettingdescription' => { 410 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 410 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 410 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 410 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 339 => 0x2 },
	'dialdirectiontvav' => { 73 => 0x706 },
	'dietaryneeds' => { 422 => 'dietaryNeeds' },
	'diffractioncorrection' => { 298 => 0x3 },
	'digitalcreationdate' => { 114 => 0x3e },
	'digitalcreationtime' => { 114 => 0x3f },
	'digitaldeehighlightadj' => { 202 => 0x202 },
	'digitaldeeshadowadj' => { 202 => 0x200 },
	'digitaldeethreshold' => { 202 => 0x201 },
	'digitalfilter' => { 342 => 0x59 },
	'digitalfilter01' => { 295 => 0x5 },
	'digitalfilter02' => { 295 => 0x16 },
	'digitalfilter03' => { 295 => 0x27 },
	'digitalfilter04' => { 295 => 0x38 },
	'digitalfilter05' => { 295 => 0x49 },
	'digitalfilter06' => { 295 => 0x5a },
	'digitalfilter07' => { 295 => 0x6b },
	'digitalfilter08' => { 295 => 0x7c },
	'digitalfilter09' => { 295 => 0x8d },
	'digitalfilter10' => { 295 => 0x9e },
	'digitalfilter11' => { 295 => 0xaf },
	'digitalfilter12' => { 295 => 0xc0 },
	'digitalfilter13' => { 295 => 0xd1 },
	'digitalfilter14' => { 295 => 0xe2 },
	'digitalfilter15' => { 295 => 0xf3 },
	'digitalfilter16' => { 295 => 0x104 },
	'digitalfilter17' => { 295 => 0x115 },
	'digitalfilter18' => { 295 => 0x126 },
	'digitalfilter19' => { 295 => 0x137 },
	'digitalfilter20' => { 295 => 0x148 },
	'digitalgain' => { 65 => 0xb },
	'digitalgem' => { 187 => 0x0 },
	'digitalice' => { 202 => 0x100 },
	'digitalimageguid' => { 416 => 'DigImageGUID' },
	'digitalroc' => { 200 => 0x0 },
	'digitalsourcefiletype' => { 416 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 416 => 'DigitalSourceType' },
	'digitalzoom' => { 31 => 0xc, 101 => 0xa, 122 => 0x68, 136 => 'DigitalZoom', 158 => 0xc, 195 => 0x86, 223 => 0xa, 259 => 0x204, 308 => 0x1e, 315 => 0xa, 341 => 0x204, 379 => 0x12, 380 => 0x12 },
	'digitalzoomon' => { 341 => 0x21b },
	'digitalzoomratio' => { 106 => 0xa404, 371 => 0x200, 373 => 0x21c, 410 => 'DigitalZoomRatio' },
	'director' => { 430 => 'director' },
	'directorphotography' => { 430 => 'directorPhotography' },
	'directory' => { 107 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 26 => 0x1f7 },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 182 => 0x3 },
	'disclaimer' => { 267 => 'Disclaimer' },
	'discnumber' => { 430 => 'discNumber' },
	'dishtype' => { 422 => 'dishType' },
	'displayallafpoints' => { 73 => 0x514 },
	'displayaperture' => { 31 => 0x23 },
	'displayedunitsx' => { 323 => 0x2 },
	'displayedunitsy' => { 323 => 0x6 },
	'displayname' => { 419 => 'displayName' },
	'distance1' => { 122 => 0x28 },
	'distance2' => { 122 => 0x2c },
	'distance3' => { 122 => 0x30 },
	'distance4' => { 122 => 0x34 },
	'distortion' => { 339 => 0xa050 },
	'distortioncontrol' => { 203 => 0x10 },
	'distortioncorrection' => { 92 => 0x20705, 98 => 0x67, 254 => 0x50b, 278 => '7.1', 298 => 0x0, 386 => 0x601, 387 => 0x5b },
	'distortioncorrection2' => { 258 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 402 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 92 => '0x20705.0', 98 => 0x63 },
	'distortioncorrectionsetting' => { 362 => 0x2013 },
	'distortioneffect' => { 92 => 0x20709 },
	'distortionn' => { 278 => 0xc },
	'distortionparam02' => { 278 => 0x2 },
	'distortionparam04' => { 278 => 0x4 },
	'distortionparam08' => { 278 => 0x8 },
	'distortionparam09' => { 278 => 0x9 },
	'distortionparam11' => { 278 => 0xb },
	'distortionscale' => { 278 => 0x5 },
	'distributor' => { 420 => 'distributor' },
	'distributorproductid' => { 419 => 'distributorProductID' },
	'dloon' => { 92 => '0x20706.0', 98 => 0xdc },
	'dlosetting' => { 92 => 0x20706, 98 => 0xdd },
	'dlosettingapplied' => { 91 => 0x4 },
	'dloshootingdistance' => { 98 => 0xde },
	'dloversion' => { 91 => 0x5 },
	'dmcomment' => { 430 => 'comment' },
	'dngadobedata' => { 106 => 0xc634 },
	'dngbackwardversion' => { 106 => 0xc613 },
	'dngignoresidecars' => { 406 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 106 => 0xc630 },
	'dngprivatedata' => { 106 => 0xc634 },
	'dngversion' => { 106 => 0xc612 },
	'document' => { 267 => 'Document' },
	'documentancestors' => { 418 => 'DocumentAncestors' },
	'documenthistory' => { 114 => 0xe7 },
	'documentid' => { 431 => 'DocumentID' },
	'documentname' => { 106 => 0x10d },
	'documentnotes' => { 114 => 0xe6 },
	'doi' => { 420 => 'doi' },
	'dpp' => { 400 => 'dpp' },
	'dr4cameramodel' => { 93 => 0x3 },
	'drivemode' => { 102 => 0x3103, 158 => 0x6, 161 => 0x1e, 164 => 0xe, 254 => 0x600, 308 => 0x34, 333 => 0x1002, 342 => 0x3, 350 => 0x4, 351 => 0x7e, 352 => 0x34 },
	'drivemode2' => { 161 => 0xa, 289 => 0x7, 361 => 0xe, 366 => 0x1 },
	'drivemodesetting' => { 352 => 0x4 },
	'dspfirmwareversion' => { 308 => 0x27 },
	'duration' => { 58 => 0x6a, 135 => 'Duration', 149 => 'Duration', 422 => 'duration', 430 => 'duration' },
	'durationscale' => { 430 => [\'duration','durationScale'] },
	'durationvalue' => { 430 => [\'duration','durationValue'] },
	'dustremovaldata' => { 55 => 0x97 },
	'dynamicafarea' => { 240 => '1.4', 247 => '1.4' },
	'dynamicareaafdisplay' => { 241 => '46.1', 243 => '47.1', 251 => '47.1' },
	'dynamicrange' => { 111 => 0x1400 },
	'dynamicrangeexpansion' => { 308 => 0x69, 333 => 0x100e },
	'dynamicrangemax' => { 97 => 0x7c },
	'dynamicrangemin' => { 97 => 0x7a },
	'dynamicrangeoptimizer' => { 161 => 0x15, 362 => [0xb025,0xb04f], 369 => 0x1144, 370 => [0x1144,0x324], 371 => [0x1120,0x300], 372 => [0x119c,0x37c], 373 => [0x1178,0x328], 374 => [0x1030,0x50], 375 => [0x228,0x50], 376 => [0x228,0x50] },
	'dynamicrangeoptimizerbracket' => { 361 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 350 => 0x19, 351 => 0x17, 352 => 0xd, 361 => 0x79, 366 => 0x5 },
	'dynamicrangeoptimizermode' => { 164 => 0x15, 350 => 0x18, 351 => 0x16, 361 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 161 => 0x27, 352 => 0xc, 366 => 0x4 },
	'dynamicrangesetting' => { 111 => 0x1402 },
	'e-dialinprogram' => { 289 => '1.3' },
	'earliestageorloweststage' => { 105 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 105 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 105 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 105 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 105 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 252 => '6.1' },
	'easyexposurecompensation' => { 240 => '6.4', 241 => '6.5', 243 => '6.3', 247 => '4.4', 248 => '5.2', 251 => '6.3' },
	'easymode' => { 31 => 0xb },
	'edgenoisereduction' => { 234 => 0x4, 391 => 0x8028 },
	'edition' => { 420 => 'edition' },
	'editorialupdate' => { 114 => 0x8 },
	'editstatus' => { 114 => 0x7, 320 => 'EditStatus', 400 => 'EditStatus' },
	'editversionname' => { 233 => 0x3d136244 },
	'effectivelv' => { 308 => 0x2d },
	'effectivemaxaperture' => { 191 => 0x12, 192 => 0x13 },
	'eissn' => { 420 => 'eIssn' },
	'electronicfront-curtainshutter' => { 243 => '5.2', 251 => '5.3' },
	'elevation' => { 145 => 'Elevation' },
	'email' => { 137 => 'EMail' },
	'embargodate' => { 423 => 'embargoDate' },
	'embdencrightsexpr' => { 416 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 416 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 416 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 416 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 418 => 'EmbeddedXMPDigest' },
	'emissivity' => { 108 => 0x3 },
	'encryptionkey' => { 339 => 0xa020 },
	'endingpage' => { 420 => 'endingPage' },
	'enduser' => { 264 => 'EndUser' },
	'enduserid' => { 264 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 264 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 430 => 'engineer' },
	'enhancedarktones' => { 226 => 0x8 },
	'enhancement' => { 101 => 0x16, 102 => 0x3016 },
	'enhancer' => { 258 => 0x300 },
	'enhancervalues' => { 258 => 0x301 },
	'envelopenumber' => { 115 => 0x28 },
	'envelopepriority' => { 115 => 0x3c },
	'enveloperecordversion' => { 115 => 0x0 },
	'epsonimageheight' => { 259 => 0x20c },
	'epsonimagewidth' => { 259 => 0x20b },
	'epsonsoftware' => { 259 => 0x20d },
	'equipmentinstitution' => { 393 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 393 => 'EquipmentManufacturer' },
	'equipmentversion' => { 255 => 0x0 },
	'ettlii' => { 73 => 0x304, 74 => 0xd, 75 => 0xe, 76 => 0x7, 77 => 0x7, 78 => 0xe },
	'event' => { 394 => 'Event', 398 => 'Event', 416 => 'Event', 420 => 'event' },
	'eventalias' => { 419 => 'eventAlias' },
	'eventday' => { 105 => [\'Event','EventDay'] },
	'eventearliestdate' => { 105 => [\'Event','EventEarliestDate'] },
	'eventend' => { 419 => 'eventEnd' },
	'eventenddayofyear' => { 105 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 105 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 105 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 105 => [\'Event','EventHabitat'] },
	'eventid' => { 105 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 105 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 105 => [\'Event','EventMonth'] },
	'eventnumber' => { 329 => 0x9 },
	'eventremarks' => { 105 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 105 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 105 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 419 => 'eventStart' },
	'eventstartdayofyear' => { 105 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 419 => 'eventSubtype' },
	'eventtime' => { 105 => [\'Event','EventEventTime'] },
	'eventtype' => { 419 => 'eventType' },
	'eventverbatimeventdate' => { 105 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 105 => [\'Event','EventYear'] },
	'evsteps' => { 289 => '1.2', 291 => 0x0 },
	'evstepsize' => { 244 => '5.1', 245 => '6.1', 246 => '6.1', 249 => '0.7' },
	'exclusivityenddate' => { 423 => 'exclusivityEndDate' },
	'excursiontolerance' => { 116 => 0x82 },
	'exif' => { 107 => 'EXIF' },
	'exifbyteorder' => { 107 => 'ExifByteOrder' },
	'exifcamerainfo' => { 114 => 0xe8 },
	'exifimageheight' => { 106 => 0xa003, 410 => 'PixelYDimension' },
	'exifimagewidth' => { 106 => 0xa002, 410 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 107 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 106 => 0x9000, 410 => 'ExifVersion' },
	'exitpupilposition' => { 191 => 0x4, 192 => 0x4 },
	'expirationdate' => { 114 => 0x25, 423 => 'expirationDate' },
	'expirationtime' => { 114 => 0x26 },
	'exposure' => { 106 => 0xfe51, 406 => 'Exposure' },
	'exposure2012' => { 406 => 'Exposure2012' },
	'exposureadj' => { 231 => 0x0 },
	'exposureadj2' => { 231 => 0x12 },
	'exposureadjust' => { 342 => 0xc },
	'exposurebracketingindicatorlast' => { 161 => 0x52 },
	'exposurebracketshotnumber' => { 164 => 0x2d, 361 => 0x2f },
	'exposurebracketstepsize' => { 289 => 0x8 },
	'exposurebracketvalue' => { 195 => 0x19 },
	'exposurecompensation' => { 67 => 0x6, 82 => 0x0, 106 => 0x9204, 122 => 0x24, 136 => 'ExposureComp', 154 => 'ExposureCompensation', 158 => 0xd, 159 => 0x53, 160 => 0x1e, 164 => 0x49c0, 259 => 0x1006, 308 => 0x16, 317 => 0x402, 339 => 0xa013, 342 => [0xc,0x35,0x4d], 369 => 0x114c, 370 => 0x114c, 371 => 0x1128, 373 => 0x1180, 374 => 0x1038, 375 => 0x230, 376 => 0x230, 410 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 366 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 161 => 0x47, 164 => 0x2a },
	'exposurecompensationset' => { 350 => 0x3, 351 => 0x3, 352 => 0x3, 366 => 0x1e },
	'exposurecompensationsetting' => { 161 => 0x1 },
	'exposurecompstepsize' => { 240 => '6.3', 241 => '7.3', 243 => '7.3', 247 => '4.3', 251 => '7.3' },
	'exposurecontrolstep' => { 248 => '6.1' },
	'exposurecontrolstepsize' => { 240 => '6.2', 241 => '7.1', 243 => '7.1', 247 => '4.2', 251 => '7.1', 252 => '7.1' },
	'exposurecount' => { 111 => 0x1032 },
	'exposuredelaymode' => { 240 => '10.1', 241 => '11.1', 243 => '11.1', 244 => '9.1', 245 => '10.1', 246 => '10.1', 247 => '10.4', 248 => '10.1', 249 => '6.4', 251 => '11.1', 252 => '11.2' },
	'exposuredifference' => { 195 => 0xe },
	'exposureindex' => { 106 => 0xa215, 410 => 'ExposureIndex' },
	'exposureindicator' => { 161 => 0x50 },
	'exposurelevelincrements' => { 71 => 0x6, 72 => 0x6, 73 => 0x101, 74 => 0x5, 75 => 0x6, 76 => 0x5, 77 => 0x5, 78 => 0x6, 79 => 0x4, 350 => 0x58, 351 => 0x58 },
	'exposurelockused' => { 395 => 'ExposureLockUsed' },
	'exposuremode' => { 106 => 0xa402, 136 => 'ExposureMode', 158 => 0x1, 159 => 0xa, 160 => 0x0, 161 => 0x0, 164 => 0x34, 254 => 0x200, 273 => 0x40d, 342 => 0x8, 362 => 0xb041, 410 => 'ExposureMode' },
	'exposuremodeinmanual' => { 73 => 0x10b },
	'exposureprogram' => { 106 => 0x8822, 333 => 0x1001, 343 => [0x17e,0x43], 350 => 0x3c, 351 => 0x3c, 352 => 0x5, 356 => 0x14, 361 => 0x3f, 366 => 0x2, 369 => 0x1175, 370 => 0x1179, 371 => 0x1155, 372 => 0x11d1, 373 => 0x11ad, 374 => 0x1065, 375 => 0x25d, 376 => 0x25d, 387 => 0x48, 410 => 'ExposureProgram' },
	'exposureshift' => { 254 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x6, 28 => 0x7, 67 => 0x16, 106 => 0x829a, 119 => 0xfd05, 122 => 0x20, 124 => 0xfa24, 126 => 0xf104, 129 => 0x12, 131 => 0x38, 134 => 0x10, 136 => 'ExposureTime', 158 => 0x9, 159 => 0x35, 160 => 0x48, 161 => 0x8, 164 => 0x49b8, 308 => 0x12, 339 => 0xa018, 342 => [0x32,0x4a], 350 => 0x0, 351 => 0x0, 366 => [0x21,0x23,0x27], 387 => 0x10, 410 => 'ExposureTime' },
	'exposuretime2' => { 342 => [0x33,0x4b] },
	'exposuretuning' => { 195 => 0x1c },
	'exposurevalue' => { 120 => 0x3 },
	'exposurewarning' => { 111 => 0x1302 },
	'exrauto' => { 111 => 0x1033 },
	'exrmode' => { 111 => 0x1034 },
	'extendedwbdetect' => { 254 => 0x902 },
	'extender' => { 255 => 0x301 },
	'extenderfirmwareversion' => { 255 => 0x304 },
	'extendermagnification' => { 138 => 'Magnification' },
	'extendermake' => { 138 => 'Make' },
	'extendermodel' => { 138 => 'Model', 255 => 0x303 },
	'extenderserialnumber' => { 138 => 'SerialNumber', 255 => 0x302 },
	'extenderstatus' => { 306 => 0x3 },
	'externalflash' => { 257 => 0x1201 },
	'externalflashae1' => { 259 => 0x101f },
	'externalflashae1_0' => { 259 => 0x101b },
	'externalflashae2' => { 259 => 0x1020 },
	'externalflashae2_0' => { 259 => 0x101c },
	'externalflashbounce' => { 257 => 0x1204, 259 => 0x1026, 296 => 0x1a },
	'externalflashcompensation' => { 185 => 0x1b },
	'externalflashexposurecomp' => { 195 => 0x17, 296 => 0x19 },
	'externalflashfirmware' => { 183 => 0x6, 184 => 0x6, 185 => 0x6 },
	'externalflashflags' => { 183 => 0x8, 184 => 0x8, 185 => 0x8 },
	'externalflashguidenumber' => { 257 => 0x1203, 296 => '24.1' },
	'externalflashgvalue' => { 259 => 0x1025 },
	'externalflashmode' => { 259 => 0x1028, 296 => 0x2 },
	'externalflashstatus' => { 186 => 0x8 },
	'externalflashzoom' => { 257 => 0x1205, 259 => 0x1027 },
	'externalsensorbrightnessvalue' => { 271 => 0x311, 277 => 0x3408 },
	'extrainfoversion' => { 354 => 0x1a },
	'eyestartaf' => { 161 => 0x40 },
	'face10position' => { 99 => 0x3f4, 100 => 0x1ec, 181 => 0x28, 293 => 0x12 },
	'face10size' => { 294 => 0x12 },
	'face11position' => { 181 => 0x2c, 293 => 0x14 },
	'face11size' => { 294 => 0x14 },
	'face12position' => { 181 => 0x30, 293 => 0x16 },
	'face12size' => { 294 => 0x16 },
	'face13position' => { 293 => 0x18 },
	'face13size' => { 294 => 0x18 },
	'face14position' => { 293 => 0x1a },
	'face14size' => { 294 => 0x1a },
	'face15position' => { 293 => 0x1c },
	'face15size' => { 294 => 0x1c },
	'face16position' => { 293 => 0x1e },
	'face16size' => { 294 => 0x1e },
	'face17position' => { 293 => 0x20 },
	'face17size' => { 294 => 0x20 },
	'face18position' => { 293 => 0x22 },
	'face18size' => { 294 => 0x22 },
	'face19position' => { 293 => 0x24 },
	'face19size' => { 294 => 0x24 },
	'face1position' => { 46 => 0x8, 99 => 0xd, 100 => 0x18, 181 => 0x4, 269 => 0x1, 293 => 0x0, 330 => 0xbc, 357 => 0x1, 358 => 0x0, 359 => 0x0, 360 => 0x5b },
	'face1size' => { 294 => 0x0 },
	'face20position' => { 293 => 0x26 },
	'face20size' => { 294 => 0x26 },
	'face21position' => { 293 => 0x28 },
	'face21size' => { 294 => 0x28 },
	'face22position' => { 293 => 0x2a },
	'face22size' => { 294 => 0x2a },
	'face23position' => { 293 => 0x2c },
	'face23size' => { 294 => 0x2c },
	'face24position' => { 293 => 0x2e },
	'face24size' => { 294 => 0x2e },
	'face25position' => { 293 => 0x30 },
	'face25size' => { 294 => 0x30 },
	'face26position' => { 293 => 0x32 },
	'face26size' => { 294 => 0x32 },
	'face27position' => { 293 => 0x34 },
	'face27size' => { 294 => 0x34 },
	'face28position' => { 293 => 0x36 },
	'face28size' => { 294 => 0x36 },
	'face29position' => { 293 => 0x38 },
	'face29size' => { 294 => 0x38 },
	'face2position' => { 46 => 0xa, 99 => 0x7c, 100 => 0x4c, 181 => 0x8, 269 => 0x5, 293 => 0x2, 330 => 0xc8, 357 => 0x6, 358 => 0x20, 359 => 0x25, 360 => 0x65 },
	'face2size' => { 294 => 0x2 },
	'face30position' => { 293 => 0x3a },
	'face30size' => { 294 => 0x3a },
	'face31position' => { 293 => 0x3c },
	'face31size' => { 294 => 0x3c },
	'face32position' => { 293 => 0x3e },
	'face32size' => { 294 => 0x3e },
	'face3position' => { 46 => 0xc, 99 => 0xeb, 100 => 0x80, 181 => 0xc, 269 => 0x9, 293 => 0x4, 330 => 0xd4, 357 => 0xb, 358 => 0x40, 359 => 0x4a, 360 => 0x6f },
	'face3size' => { 294 => 0x4 },
	'face4position' => { 46 => 0xe, 99 => 0x15a, 100 => 0xb4, 181 => 0x10, 269 => 0xd, 293 => 0x6, 330 => 0xe0, 357 => 0x10, 358 => 0x60, 359 => 0x6f, 360 => 0x79 },
	'face4size' => { 294 => 0x6 },
	'face5position' => { 46 => 0x10, 99 => 0x1c9, 100 => 0xe8, 181 => 0x14, 269 => 0x11, 293 => 0x8, 330 => 0xec, 357 => 0x15, 358 => 0x80, 359 => 0x94 },
	'face5size' => { 294 => 0x8 },
	'face6position' => { 46 => 0x12, 99 => 0x238, 100 => 0x11c, 181 => 0x18, 293 => 0xa, 330 => 0xf8, 357 => 0x1a, 358 => 0xa0, 359 => 0xb9 },
	'face6size' => { 294 => 0xa },
	'face7position' => { 46 => 0x14, 99 => 0x2a7, 100 => 0x150, 181 => 0x1c, 293 => 0xc, 330 => 0x104, 357 => 0x1f, 358 => 0xc0, 359 => 0xde },
	'face7size' => { 294 => 0xc },
	'face8position' => { 46 => 0x16, 99 => 0x316, 100 => 0x184, 181 => 0x20, 293 => 0xe, 330 => 0x110, 357 => 0x24, 358 => 0xe0, 359 => 0x103 },
	'face8size' => { 294 => 0xe },
	'face9position' => { 46 => 0x18, 99 => 0x385, 100 => 0x1b8, 181 => 0x24, 293 => 0x10 },
	'face9size' => { 294 => 0x10 },
	'facedetect' => { 308 => 0x76, 339 => 0x100 },
	'facedetectarea' => { 258 => 0x1201 },
	'facedetectframecrop' => { 258 => 0x1207 },
	'facedetectframesize' => { 46 => 0x3, 99 => 0x1, 100 => 0x4, 181 => 0x1, 258 => 0x1203, 308 => 0x77, 330 => 0xb6 },
	'facedetection' => { 352 => 0x30, 366 => 0x19 },
	'faceid' => { 401 => 'FaceID' },
	'faceinfounknown' => { 102 => 0x2089 },
	'facename' => { 339 => 0x123 },
	'faceorientation' => { 100 => 0x8 },
	'faceposition' => { 292 => 0x2, 340 => 0x4 },
	'facepositions' => { 111 => 0x4103 },
	'facerecognition' => { 339 => 0x120 },
	'facesdetected' => { 46 => 0x2, 47 => 0x2, 48 => 0x3, 99 => 0x0, 100 => 0x2, 102 => 0x211c, 111 => 0x4100, 181 => 0x3, 258 => 0x1200, 275 => 0x3f, 292 => 0x0, 330 => 0xb5, 340 => 0x0, 357 => 0x0, 360 => 0x3, 368 => 0x30 },
	'facesrecognized' => { 270 => 0x0 },
	'facewidth' => { 47 => 0x1 },
	'faithfuloutputhighlightpoint' => { 98 => 0x38 },
	'faithfuloutputshadowpoint' => { 98 => 0x39 },
	'faithfulrawcolortone' => { 98 => 0x31 },
	'faithfulrawcontrast' => { 98 => 0x33 },
	'faithfulrawhighlight' => { 98 => 0x79 },
	'faithfulrawhighlightpoint' => { 98 => 0x36 },
	'faithfulrawlinear' => { 98 => 0x34 },
	'faithfulrawsaturation' => { 98 => 0x32 },
	'faithfulrawshadow' => { 98 => 0x82 },
	'faithfulrawshadowpoint' => { 98 => 0x37 },
	'faithfulrawsharpness' => { 98 => 0x35 },
	'faithfulunsharpmaskfineness' => { 98 => 0xac },
	'faithfulunsharpmaskstrength' => { 98 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 98 => 0xae },
	'femicroadjustment' => { 73 => 0x111 },
	'ffid' => { 408 => 'ffid' },
	'field' => { 419 => 'field' },
	'fieldcount' => { 259 => 0x103f },
	'filecreatedate' => { 107 => 'FileCreateDate' },
	'filedatarate' => { 430 => 'fileDataRate' },
	'fileformat' => { 84 => 0x0, 115 => 0x14, 342 => [0x22,0x26], 362 => 0xb000 },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 26 => 0x1eb, 276 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 107 => 'FileModifyDate' },
	'filename' => { 107 => 'FileName' },
	'filenameasdelivered' => { 264 => 'FileNameAsDelivered' },
	'filenumber' => { 49 => 0x1, 55 => 0x8, 86 => 0x1817, 103 => 'FileNumber', 182 => 0x4 },
	'filenumbermemory' => { 158 => 0x1a },
	'filenumbersequence' => { 240 => '12.2', 244 => '3.1', 245 => '4.1', 246 => '4.1', 247 => '11.1', 248 => '4.3', 252 => '5.2' },
	'filepermissions' => { 107 => 'FilePermissions' },
	'filesource' => { 106 => 0xa300, 111 => 0x8000, 410 => 'FileSource' },
	'fileversion' => { 115 => 0x16 },
	'fillflashautoreduction' => { 71 => 0xe, 72 => 0xe, 79 => 0xa },
	'filllight' => { 406 => 'FillLight' },
	'fillorder' => { 106 => 0x10a },
	'filmgraineffect' => { 254 => 0x538 },
	'filmmode' => { 111 => 0x1401, 273 => 0x412, 275 => 0x42 },
	'filmtype' => { 202 => 0x2 },
	'filtereffect' => { 49 => 0xe, 197 => 0x37, 198 => 0x3f },
	'filtereffectauto' => { 62 => 0xa0 },
	'filtereffectfaithful' => { 61 => 0x70, 62 => 0x70 },
	'filtereffectlandscape' => { 61 => 0x40, 62 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 61 => 0x88, 62 => 0x88 },
	'filtereffectneutral' => { 61 => 0x58, 62 => 0x58 },
	'filtereffectportrait' => { 61 => 0x28, 62 => 0x28 },
	'filtereffectstandard' => { 61 => 0x10, 62 => 0x10 },
	'filtereffectuserdef1' => { 61 => 0xa0, 62 => 0xb8 },
	'filtereffectuserdef2' => { 61 => 0xb8, 62 => 0xd0 },
	'filtereffectuserdef3' => { 61 => 0xd0, 62 => 0xe8 },
	'finderdisplayduringexposure' => { 72 => 0x1 },
	'finesharpness' => { 308 => 0x70 },
	'finetuneoptcenterweighted' => { 240 => '7.2', 241 => '9.1', 243 => '9.1', 251 => '9.1', 252 => '9.1' },
	'finetuneopthighlightweighted' => { 243 => '46.1', 251 => '46.1' },
	'finetuneoptmatrixmetering' => { 240 => '8.1', 241 => '8.2', 243 => '8.2', 247 => '6.1', 251 => '8.2', 252 => '8.2' },
	'finetuneoptspotmetering' => { 240 => '8.2', 241 => '9.2', 243 => '9.2', 247 => '6.2', 251 => '9.2', 252 => '9.2' },
	'firmware' => { 259 => 0x405, 342 => [0x17,0x3b,0x57], 402 => 'Firmware' },
	'firmwaredate' => { 101 => 0x15, 102 => 0x2001, 329 => 0x4 },
	'firmwareid' => { 165 => 0x0 },
	'firmwarename' => { 339 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 55 => 0x1e, 331 => 0x0 },
	'firmwarerevision2' => { 331 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 120 => 0xce5, 134 => 0x57, 136 => 'FirmwareVersion', 275 => 0x2, 277 => 0x3109, 308 => 0x230, 333 => 0x2 },
	'firmwareversions' => { 317 => 0x301 },
	'firstphotodate' => { 395 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 264 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 114 => 0x16, 400 => 'FixtureIdentifier' },
	'flash' => { 103 => 'Flash', 106 => 0x9209, 159 => 0x1f, 160 => 0x15, 410 => 'Flash' },
	'flashaction' => { 350 => 0x3e, 351 => 0x3e, 362 => 0x2017, 366 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 350 => 0x4c, 351 => 0x4c, 366 => 0x77 },
	'flashactionexternal' => { 366 => [0x78,0x7c] },
	'flashactivity' => { 31 => 0x1c },
	'flashbatterylevel' => { 37 => 0x249 },
	'flashbias' => { 275 => 0x24 },
	'flashbits' => { 31 => 0x1d },
	'flashbuttonfunction' => { 73 => 0x70e },
	'flashchargelevel' => { 259 => 0x1010 },
	'flashcolorfilter' => { 185 => 0x10 },
	'flashcommandermode' => { 183 => '9.1', 184 => '9.1', 185 => '9.1' },
	'flashcompensation' => { 183 => 0xa, 184 => 0xa, 185 => 0xa, 402 => 'FlashCompensation' },
	'flashcontrol' => { 350 => 0x23, 351 => 0x1f, 352 => 0x21 },
	'flashcontrolbuilt-in' => { 247 => '16.1', 248 => '23.1', 250 => '23.1', 251 => '24.1' },
	'flashcontrolmode' => { 183 => '9.2', 184 => '9.2', 185 => '9.2', 254 => 0x404 },
	'flashcurtain' => { 275 => 0x48 },
	'flashdefault' => { 161 => 0x42 },
	'flashdevice' => { 259 => 0x1005 },
	'flashdistance' => { 102 => 0x2034 },
	'flashenergy' => { 106 => 0xa20b, 410 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 195 => 0x18 },
	'flashexposurecomp' => { 67 => 0xf, 111 => 0x1011, 139 => 'ExposureComp', 158 => 0x23, 163 => 0x104, 164 => 0x49c1, 195 => 0x12, 254 => 0x401, 259 => 0x1023, 308 => 0x4d, 333 => 0x100b, 342 => [0x3a,0x56], 362 => 0x104 },
	'flashexposurecomp2' => { 220 => 0x4d2 },
	'flashexposurecomp3' => { 185 => 0x1d },
	'flashexposurecomp4' => { 185 => 0x27 },
	'flashexposurecomparea' => { 241 => '38.4', 243 => '38.4', 251 => '38.4' },
	'flashexposurecompset' => { 161 => 0x10, 282 => 0xe, 350 => 0x14, 351 => 0x12, 352 => 0x23, 366 => 0x1f },
	'flashexposurecompset2' => { 366 => [0x26,0x2c] },
	'flashexposureindicator' => { 161 => 0x54 },
	'flashexposureindicatorlast' => { 161 => 0x56 },
	'flashexposureindicatornext' => { 161 => 0x55 },
	'flashexposurelock' => { 49 => 0x19 },
	'flashfired' => { 122 => 0x5d, 139 => 'Fired', 158 => 0x14, 219 => '590.3', 275 => 0x8007, 410 => [\'Flash','FlashFired'] },
	'flashfiring' => { 73 => 0x306, 74 => 0x6, 75 => 0x7, 78 => 0x7 },
	'flashfirmwareversion' => { 255 => 0x1002 },
	'flashfocallength' => { 183 => 0xb, 184 => 0xc, 185 => 0xc },
	'flashfunction' => { 164 => 0x31, 410 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 183 => 0xe, 184 => 0xf, 185 => 0xf },
	'flashgroupacompensation' => { 183 => 0x11, 184 => 0x12, 185 => 0x13 },
	'flashgroupacontrolmode' => { 183 => 0xf, 184 => '16.1', 185 => '17.1' },
	'flashgroupaoutput' => { 183 => 0x11, 184 => 0x12, 185 => 0x13 },
	'flashgroupbcompensation' => { 183 => 0x12, 184 => 0x13, 185 => 0x14 },
	'flashgroupbcontrolmode' => { 183 => 0x10, 184 => '17.1', 185 => '18.1' },
	'flashgroupboutput' => { 183 => 0x12, 184 => 0x13, 185 => 0x14 },
	'flashgroupccompensation' => { 184 => 0x14, 185 => 0x15 },
	'flashgroupccontrolmode' => { 184 => '17.2', 185 => '18.2' },
	'flashgroupcoutput' => { 184 => 0x14, 185 => 0x15 },
	'flashguidenumber' => { 67 => 0xd, 83 => 0x0, 139 => 'GuideNumber' },
	'flashintensity' => { 101 => [0x19,0x5], 254 => 0x405 },
	'flashlevel' => { 242 => 0x9, 362 => 0xb048 },
	'flashmake' => { 139 => 'Make' },
	'flashmanufacturer' => { 156 => 'FlashManufacturer' },
	'flashmetering' => { 158 => 0x3f, 161 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 26 => 0x15 },
	'flashmeteringsegments' => { 308 => 0x20a },
	'flashmode' => { 101 => 0x4, 122 => 0x5c, 139 => 'Mode', 158 => 0x2, 159 => 0x20, 160 => 0x16, 161 => 0xf, 195 => 0x87, 254 => 0x400, 259 => 0x1004, 308 => 0xc, 315 => 0x4, 332 => 0x20, 333 => 0x100a, 341 => 0x225, 350 => 0x13, 351 => 0x7f, 352 => 0x20, 366 => 0x10, 369 => 0x1138, 370 => 0x1138, 371 => 0x1114, 372 => 0x1190, 373 => 0x116c, 374 => 0x1024, 375 => 0x21c, 376 => 0x21c, 410 => [\'Flash','FlashMode'] },
	'flashmodel' => { 139 => 'Model', 156 => 'FlashModel', 255 => 0x1001 },
	'flashoptions' => { 289 => 0x2 },
	'flashoptions2' => { 289 => 0x10 },
	'flashoutput' => { 37 => 0x248, 67 => 0x21, 183 => 0xa, 184 => 0xa, 185 => 0xa },
	'flashpixversion' => { 106 => 0xa000, 410 => 'FlashpixVersion' },
	'flashredeyemode' => { 410 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 254 => 0x403 },
	'flashreturn' => { 410 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 139 => 'SerialNumber', 255 => 0x1003 },
	'flashsetting' => { 195 => 0x8 },
	'flashshutterspeed' => { 240 => '20.2', 241 => '23.2', 243 => '23.2', 247 => '15.2', 248 => '22.2', 249 => '7.2', 250 => '22.2', 251 => '23.2', 252 => '23.1' },
	'flashsource' => { 183 => 0x4, 184 => 0x4, 185 => 0x4 },
	'flashstatus' => { 296 => 0x0, 366 => [0x82,0x86], 378 => [0x31,0x39] },
	'flashstatusbuilt-in' => { 352 => [0x87,0x287] },
	'flashstatusexternal' => { 352 => [0x88,0x288] },
	'flashsyncspeed' => { 240 => '20.1', 241 => '23.1', 243 => '23.1', 247 => '15.1', 248 => '22.1', 250 => '22.1', 251 => '23.1' },
	'flashsyncspeedav' => { 71 => 0x3, 73 => 0x10f, 74 => 0x2, 75 => 0x3, 76 => 0x2, 77 => 0x2, 78 => 0x3, 79 => 0x6 },
	'flashthreshold' => { 83 => 0x1 },
	'flashtype' => { 139 => 'Type', 161 => 0x59, 195 => 0x9, 255 => 0x1000 },
	'flashwarning' => { 248 => '30.1', 249 => '7.1', 252 => '31.1', 275 => 0x62 },
	'flexiblespotposition' => { 362 => 0x201d },
	'flickerreduce' => { 341 => 0x218 },
	'flickerreduction' => { 213 => 0xe84 },
	'flickerreductionindicator' => { 213 => 0x5e2 },
	'fliphorizontal' => { 233 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x5, 28 => 0x6, 67 => 0x15, 106 => 0x829d, 119 => 0xfd04, 122 => 0x1e, 124 => 0xfa23, 126 => 0xf103, 129 => 0x13, 131 => 0x3c, 134 => 0xc, 143 => 'FNumber', 158 => 0xa, 159 => 0x36, 160 => 0x47, 161 => 0x9, 164 => 0x49c7, 308 => 0x13, 339 => 0xa019, 342 => [0x31,0x49], 350 => 0x1, 351 => 0x1, 366 => [0x20,0x22,0x26], 410 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x1e, 51 => 0x1, 102 => 0x1d, 106 => 0x920a, 129 => 0x1d, 143 => 'FocalLength', 158 => 0x12, 191 => 0xa, 192 => 0xb, 308 => 0x1d, 317 => 0x403, 333 => 0x1500, 349 => 0xe, 373 => 0x1278, 374 => 0x1134, 375 => 0x32c, 376 => 0x32c, 410 => 'FocalLength' },
	'focallength2' => { 366 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 106 => 0xa405, 339 => 0xa01a, 410 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 349 => 0x10 },
	'focalplaneafpointarea' => { 377 => 0x2 },
	'focalplaneafpointlocation1' => { 377 => 0x6 },
	'focalplaneafpointlocation10' => { 377 => 0x2a },
	'focalplaneafpointlocation11' => { 377 => 0x2e },
	'focalplaneafpointlocation12' => { 377 => 0x32 },
	'focalplaneafpointlocation13' => { 377 => 0x36 },
	'focalplaneafpointlocation14' => { 377 => 0x3a },
	'focalplaneafpointlocation15' => { 377 => 0x3e },
	'focalplaneafpointlocation2' => { 377 => 0xa },
	'focalplaneafpointlocation3' => { 377 => 0xe },
	'focalplaneafpointlocation4' => { 377 => 0x12 },
	'focalplaneafpointlocation5' => { 377 => 0x16 },
	'focalplaneafpointlocation6' => { 377 => 0x1a },
	'focalplaneafpointlocation7' => { 377 => 0x1e },
	'focalplaneafpointlocation8' => { 377 => 0x22 },
	'focalplaneafpointlocation9' => { 377 => 0x26 },
	'focalplaneafpointsused' => { 377 => 0x1 },
	'focalplanediagonal' => { 255 => 0x103, 259 => 0x205 },
	'focalplaneresolutionunit' => { 106 => 0xa210, 410 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 106 => 0xa20e, 410 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 51 => 0x2 },
	'focalplanexunknown' => { 51 => 0x2 },
	'focalplaneyresolution' => { 106 => 0xa20f, 410 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 51 => 0x3 },
	'focalplaneyunknown' => { 51 => 0x3 },
	'focaltype' => { 9 => 0x2d, 51 => 0x0 },
	'focalunits' => { 31 => 0x19 },
	'focus' => { 223 => 0x8 },
	'focusarea' => { 158 => 0x31 },
	'focusareaselection' => { 249 => '15.2' },
	'focuscontinuous' => { 31 => 0x20 },
	'focusdisplayaiservoandmf' => { 73 => 0x515 },
	'focusdistance' => { 143 => 'FocusDistance', 158 => 0x13, 164 => 0x49bb, 191 => 0x9, 192 => 0xa, 257 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0x56, 49 => 0x15, 67 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0x54, 49 => 0x14, 67 => 0x13 },
	'focusholdbutton' => { 161 => 0x44 },
	'focusinfoversion' => { 257 => 0x0 },
	'focusingscreen' => { 72 => 0x0, 73 => 0x80b, 78 => 0x0 },
	'focuslocation' => { 362 => 0x2027 },
	'focuslocked' => { 157 => 0x14 },
	'focusmode' => { 31 => 0x7, 101 => 0x3, 102 => [0x3003,0xd], 111 => 0x1021, 122 => 0x38, 136 => 'FocusMode', 158 => 0x30, 160 => 0xe, 161 => 0xc, 195 => 0x7, 254 => 0x301, 259 => 0x100b, 275 => 0x7, 308 => 0xd, 315 => 0x3, 333 => 0x1006, 343 => [0xb,0x5], 349 => [0x15,0x1d], 350 => 0x4d, 351 => 0x4d, 362 => [0xb042,0xb04e,0x201b], 366 => 0x13, 382 => 0x16 },
	'focusmode2' => { 289 => '3.1', 366 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 242 => '10.1', 347 => 0x14, 348 => 0x15, 350 => 0x10, 351 => 0xf, 352 => 0x6 },
	'focusmodeswitch' => { 161 => 0x58, 350 => 0x2e },
	'focuspixel' => { 111 => 0x1023 },
	'focuspointwrap' => { 240 => '2.2', 241 => '2.2', 243 => '2.1', 247 => '2.2', 248 => '1.2', 251 => '2.2', 252 => '2.5' },
	'focusposition' => { 191 => 0x8, 192 => 0x8, 308 => 0x10, 361 => 0x9bb },
	'focusposition2' => { 366 => [0x29,0x2b,0x2f], 382 => 0x2d, 385 => 0x20 },
	'focusprocess' => { 254 => 0x302 },
	'focusrange' => { 31 => 0x12, 259 => 0x100a },
	'focusrangeindex' => { 299 => '3.1' },
	'focussetting' => { 342 => 0x6 },
	'focusstatus' => { 349 => 0x19, 350 => 0x53, 351 => 0x53 },
	'focusstepcount' => { 257 => 0x301, 259 => 0x100e },
	'focusstepinfinity' => { 257 => 0x303, 259 => 0x103b },
	'focusstepnear' => { 257 => 0x304, 259 => 0x103c },
	'focustrackinglockon' => { 240 => ['1.5','4.1'], 241 => '1.4', 247 => '3.1', 248 => '0.4', 251 => '1.4' },
	'focuswarning' => { 111 => 0x1301 },
	'foldername' => { 158 => 0x27 },
	'foldernumber' => { 350 => 0x9a, 352 => [0x402,0x114,0x316] },
	'fontcomposite' => { 435 => [\'Fonts','FontsComposite'] },
	'fontface' => { 435 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 435 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 435 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 435 => [\'Fonts','FontsFontName'] },
	'fonts' => { 435 => 'Fonts' },
	'fonttype' => { 435 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 435 => [\'Fonts','FontsVersionString'] },
	'for' => { 324 => 'For' },
	'format' => { 407 => 'format', 428 => 'Format' },
	'forwardlock' => { 425 => 'forwardlock' },
	'forwardmatrix1' => { 106 => 0xc714 },
	'forwardmatrix2' => { 106 => 0xc715 },
	'framecount' => { 58 => [0x2,0x4] },
	'frameheight' => { 111 => 0x3822 },
	'framenum' => { 319 => 0xd7 },
	'framenumber' => { 111 => 0x8003, 164 => 0x3c, 308 => 0x29 },
	'framerate' => { 58 => [0x1,0x6], 106 => 0xc764, 111 => 0x3820 },
	'framewidth' => { 111 => 0x3821 },
	'framing' => { 419 => 'framing' },
	'freebytes' => { 86 => 0x1 },
	'freememorycardimages' => { 159 => [0x37,0x54], 160 => [0x2d,0x4a], 161 => 0x32 },
	'fujiflashmode' => { 111 => 0x1010 },
	'fullimagesize' => { 362 => 0xb02b },
	'fullpanoheightpixels' => { 395 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 395 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 333 => 0x100d },
	'fullsizeimage' => { 142 => 'data' },
	'fullsizeimagename' => { 142 => '1Name' },
	'fullsizeimagetype' => { 142 => '0Type' },
	'func1button' => { 243 => '14.1' },
	'func1buttonplusdials' => { 243 => '42.1' },
	'func2button' => { 243 => '80.1' },
	'funcbutton' => { 240 => ['14.1','15.1'], 241 => '14.1', 247 => '28.1', 248 => '13.1', 251 => '14.1', 252 => '14.1' },
	'funcbuttonplusdials' => { 240 => ['14.2','15.2'], 241 => '14.2', 247 => '31.1', 251 => '42.1' },
	'functionbutton' => { 246 => '13.1', 249 => '5.2' },
	'gainbase' => { 258 => 0x610 },
	'gaincontrol' => { 106 => 0xa407, 410 => 'GainControl' },
	'gamma' => { 106 => 0xa500, 411 => 'Gamma' },
	'gammablackpoint' => { 94 => 0xc },
	'gammacolortone' => { 94 => 0x3 },
	'gammacompensatedvalue' => { 116 => 0x91 },
	'gammacontrast' => { 94 => 0x2 },
	'gammacurveoutputrange' => { 94 => 0xf },
	'gammahighlight' => { 94 => 0xa },
	'gammalinear' => { 92 => 0x20200 },
	'gammamidpoint' => { 94 => 0xe },
	'gammasaturation' => { 94 => 0x4 },
	'gammashadow' => { 94 => 0x9 },
	'gammasharpnessstrength' => { 94 => 0x8 },
	'gammaunsharpmaskfineness' => { 94 => 0x6 },
	'gammaunsharpmaskstrength' => { 94 => 0x5 },
	'gammaunsharpmaskthreshold' => { 94 => 0x7 },
	'gammawhitepoint' => { 94 => 0xd },
	'geimagesize' => { 111 => 0x1304 },
	'gemake' => { 112 => 0x300 },
	'gemodel' => { 112 => 0x207 },
	'genre' => { 420 => 'genre', 430 => 'genre' },
	'geography' => { 421 => 'geography' },
	'geologicalcontext' => { 105 => 'GeologicalContext' },
	'geologicalcontextbed' => { 105 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 105 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 105 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 105 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 105 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 107 => 'Geosync' },
	'geotag' => { 107 => 'Geotag' },
	'geotiffasciiparams' => { 106 => 0x87b1 },
	'geotiffdirectory' => { 106 => 0x87af },
	'geotiffdoubleparams' => { 106 => 0x87b0 },
	'geotime' => { 107 => 'Geotime' },
	'globalaltitude' => { 322 => 0x419 },
	'globalangle' => { 322 => 0x40d },
	'good' => { 430 => 'good' },
	'googleplusuploadcode' => { 106 => 0x9009 },
	'gpsaltitude' => { 113 => 0x6, 140 => 'Altitude', 410 => 'GPSAltitude' },
	'gpsaltituderef' => { 113 => 0x5, 410 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 113 => 0x1c, 410 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 113 => 0x1d },
	'gpsdatetime' => { 140 => 'DateTime', 410 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 113 => 0x18, 140 => 'Bearing', 410 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 113 => 0x17, 410 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 113 => 0x1a, 140 => 'Distance', 410 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 113 => 0x19, 410 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 113 => 0x14, 410 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 113 => 0x13 },
	'gpsdestlongitude' => { 113 => 0x16, 410 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 113 => 0x15 },
	'gpsdifferential' => { 113 => 0x1e, 140 => 'Differential', 410 => 'GPSDifferential' },
	'gpsdop' => { 113 => 0xb, 410 => 'GPSDOP' },
	'gpshpositioningerror' => { 113 => 0x1f, 410 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 113 => 0x11, 410 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 113 => 0x10, 410 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 113 => 0x2, 140 => 'Latitude', 410 => 'GPSLatitude' },
	'gpslatituderef' => { 113 => 0x1 },
	'gpslongitude' => { 113 => 0x4, 140 => 'Longitude', 410 => 'GPSLongitude' },
	'gpslongituderef' => { 113 => 0x3 },
	'gpsmapdatum' => { 113 => 0x12, 140 => 'Datum', 410 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 113 => 0xa, 140 => 'MeasureMode', 410 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 113 => 0x1b, 410 => 'GPSProcessingMethod' },
	'gpssatellites' => { 113 => 0x8, 140 => 'Satellites', 410 => 'GPSSatellites' },
	'gpsspeed' => { 113 => 0xd, 140 => 'Speed', 410 => 'GPSSpeed' },
	'gpsspeedref' => { 113 => 0xc, 410 => 'GPSSpeedRef' },
	'gpsstatus' => { 113 => 0x9, 410 => 'GPSStatus' },
	'gpstimestamp' => { 113 => 0x7 },
	'gpstrack' => { 113 => 0xf, 140 => 'Heading', 410 => 'GPSTrack' },
	'gpstrackref' => { 113 => 0xe, 410 => 'GPSTrackRef' },
	'gpsversionid' => { 113 => 0x0, 410 => 'GPSVersionID' },
	'gradation' => { 254 => 0x50f },
	'gradientbasedcorractive' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 406 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 406 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 406 => 'GrainAmount' },
	'grainfrequency' => { 406 => 'GrainFrequency' },
	'grainsize' => { 406 => 'GrainSize' },
	'graymixeraqua' => { 406 => 'GrayMixerAqua' },
	'graymixerblue' => { 406 => 'GrayMixerBlue' },
	'graymixergreen' => { 406 => 'GrayMixerGreen' },
	'graymixermagenta' => { 406 => 'GrayMixerMagenta' },
	'graymixerorange' => { 406 => 'GrayMixerOrange' },
	'graymixerpurple' => { 406 => 'GrayMixerPurple' },
	'graymixerred' => { 406 => 'GrayMixerRed' },
	'graymixeryellow' => { 406 => 'GrayMixerYellow' },
	'graypoint' => { 391 => 0x8021 },
	'grayresponseunit' => { 106 => 0x122 },
	'greencurvelimits' => { 97 => 0x1c4 },
	'greencurvepoints' => { 96 => 0x53, 97 => 0x19a },
	'greenhsl' => { 92 => 0x20912 },
	'greenhue' => { 406 => 'GreenHue' },
	'greensaturation' => { 406 => 'GreenSaturation' },
	'griddisplay' => { 240 => '13.3', 241 => '4.3', 243 => '4.2', 244 => '2.2', 247 => '10.5', 248 => '3.4', 249 => '6.1', 251 => '4.4', 252 => '4.2' },
	'gripbatteryadload' => { 287 => 0x5 },
	'gripbatteryadnoload' => { 287 => 0x4 },
	'gripbatterystate' => { 287 => '1.2' },
	'groupareaafillumination' => { 241 => '46.4', 243 => '47.4', 251 => '47.4' },
	'halftonehints' => { 106 => 0x141 },
	'hardlink' => { 107 => 'HardLink' },
	'hasalternative' => { 420 => 'hasAlternative' },
	'hascorrection' => { 420 => 'hasCorrection' },
	'hascorrectiona-lang' => { 420 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 420 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 420 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 406 => 'HasCrop' },
	'hasextendedxmp' => { 432 => 'HasExtendedXMP' },
	'hassettings' => { 406 => 'HasSettings' },
	'hastranslation' => { 420 => 'hasTranslation' },
	'hasvisibleoverprint' => { 435 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 435 => 'HasVisibleTransparency' },
	'hdr' => { 52 => 0x1, 188 => 0x4, 275 => 0x9e, 308 => 0x85, 362 => 0x200a },
	'hdreffect' => { 52 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 188 => 0x0 },
	'hdrlevel' => { 188 => 0x5, 352 => 0x2e, 366 => 0x17 },
	'hdrlevel2' => { 188 => 0x7 },
	'hdrsetting' => { 352 => 0x2d, 366 => 0x16, 369 => 0x1148, 370 => 0x1148, 371 => 0x1124, 372 => 0x11a0, 373 => 0x117c, 374 => 0x1034, 375 => 0x22c, 376 => 0x22c },
	'hdrsmoothing' => { 188 => 0x6 },
	'headline' => { 114 => 0x69, 418 => 'Headline' },
	'hierarchicalkeywords' => { 151 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 151 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 151 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 151 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 151 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 397 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 105 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 279 => 0x1a },
	'highisomultipliergreen' => { 279 => 0x19 },
	'highisomultiplierred' => { 279 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 26 => 0xc9, 54 => 0x5, 73 => 0x202, 111 => 0x100e, 195 => 0xb1, 308 => 0x71, 350 => 0x2c, 351 => 0x26, 352 => 0x26, 362 => 0x2009, 366 => 0x12, 387 => 0x42 },
	'highisonoisereduction2' => { 362 => 0xb050 },
	'highlight' => { 342 => 0xf },
	'highlightadj' => { 92 => 0x2030c },
	'highlightcolordistortreduct' => { 391 => 0x8026 },
	'highlightprotection' => { 232 => 0x6 },
	'highlightrecovery' => { 406 => 'HighlightRecovery' },
	'highlights' => { 399 => 'Highlights' },
	'highlights2012' => { 406 => 'Highlights2012' },
	'highlighttone' => { 111 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 26 => 0x7, 54 => 0x3, 73 => 0x203 },
	'highlowkeyadj' => { 308 => 0x6c },
	'highspeedsync' => { 161 => 0x5, 350 => 0x2, 351 => 0x2 },
	'histogramxml' => { 233 => 0x83a1a25 },
	'history' => { 418 => 'History', 431 => 'History' },
	'historyaction' => { 431 => [\'History','HistoryAction'] },
	'historychanged' => { 431 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 431 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 431 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 431 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 431 => [\'History','HistoryWhen'] },
	'hometowncity' => { 102 => 0x3006, 308 => 0x23, 314 => 0x2 },
	'hometowncitycode' => { 315 => 0x1000 },
	'hometowndst' => { 308 => 0x25, 314 => '0.2' },
	'hostcomputer' => { 106 => 0x13c },
	'hue' => { 166 => 0x3b, 198 => 0x3d, 308 => 0x67 },
	'hueadj' => { 236 => 0x2f, 391 => 0x8019 },
	'hueadjust' => { 333 => 0x1016 },
	'hueadjustment' => { 159 => 0x4a, 160 => 0x40, 195 => 0x92, 197 => 0x36 },
	'hueadjustmentaqua' => { 406 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 406 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 406 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 406 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 406 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 406 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 406 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 406 => 'HueAdjustmentYellow' },
	'huesetting' => { 262 => 0x1011 },
	'icc_profile' => { 107 => 'ICC_Profile' },
	'iccprofilename' => { 418 => 'ICCProfile' },
	'idccreativestyle' => { 391 => 0x8000 },
	'idcpreviewlength' => { 391 => 0x202 },
	'idcpreviewstart' => { 391 => 0x201 },
	'identification' => { 105 => 'Identification' },
	'identificationid' => { 105 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 105 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 105 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 105 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 105 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 105 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 407 => 'identifier', 428 => 'Identifier' },
	'illumination' => { 249 => '0.5' },
	'imageadjustment' => { 195 => 0x80, 223 => 0x5 },
	'imagealterationconstraints' => { 264 => 'ImageAlterationConstraints' },
	'imagearea' => { 207 => 0x10, 210 => 0x10 },
	'imageareaoffset' => { 308 => 0x38 },
	'imageauthentication' => { 195 => 0x20 },
	'imageboundary' => { 195 => 0x16 },
	'imagecount' => { 111 => 0x1438, 195 => 0xa5, 364 => 0x11b, 378 => [0x32,0x3a] },
	'imagecount2' => { 378 => [0x4c,0x58] },
	'imagecount3' => { 378 => [0x1a0,0x1aa,0x1bd,0x1cb] },
	'imagecreator' => { 264 => 'ImageCreator' },
	'imagecreatorid' => { 264 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 264 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 264 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 195 => 0xa2 },
	'imagedescription' => { 106 => 0x10e, 426 => 'ImageDescription' },
	'imageduplicationconstraints' => { 264 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 233 => 0xfe443a45 },
	'imageeditcount' => { 308 => 0x41 },
	'imageediting' => { 308 => 0x32 },
	'imageeffects' => { 333 => 0x1010 },
	'imagefileconstraints' => { 264 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 264 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 264 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 111 => 0x1436 },
	'imageheight' => { 106 => 0x101, 165 => 0xc, 317 => 0x10d, 426 => 'ImageLength' },
	'imagehistory' => { 106 => 0x9213, 409 => 'ImageHistory' },
	'imageidnumber' => { 271 => 0x340 },
	'imagenumber' => { 106 => 0x9211, 136 => 'ImageNumber', 159 => 0xae, 160 => 0x5e, 317 => 0x113, 350 => 0x9b, 352 => [0x400,'276.1',0x314], 402 => 'ImageNumber' },
	'imagenumber2' => { 160 => 0x62 },
	'imageoptimization' => { 195 => 0xa9 },
	'imageorientation' => { 114 => 0x83 },
	'imageprocessing' => { 195 => 0x1a },
	'imageprocessingversion' => { 258 => 0x0 },
	'imagequality' => { 136 => 'ImageQuality', 209 => '723.2', 210 => '732.2', 219 => '708.1', 275 => 0x1 },
	'imagequality2' => { 254 => 0x603 },
	'imageref' => { 414 => 'ImageRef' },
	'imagereview' => { 242 => '0.4', 249 => '0.4' },
	'imagereviewmonitorofftime' => { 241 => '21.1', 243 => '21.1', 251 => '21.1' },
	'imagereviewtime' => { 240 => '25.1', 242 => '2.1', 244 => '19.1', 245 => '20.1', 246 => '20.1', 247 => '9.2', 248 => '20.1', 252 => '21.2' },
	'imagesize' => { 142 => 'ImageSize' },
	'imagesizerestriction' => { 423 => 'imageSizeRestriction' },
	'imagesourcedata' => { 106 => 0x935c },
	'imagestabilization' => { 31 => 0x22, 102 => 0x3020, 111 => 0x1422, 136 => 'ImageStabilization', 159 => 0xbd, 160 => 0x71, 161 => 0x57, 162 => 0x0, 163 => [0x18,0x107,0x113], 164 => 0x49c2, 195 => 0xac, 254 => 0x604, 257 => 0x1600, 275 => 0x1a, 355 => 0x12, 356 => 0x11, 362 => 0xb026 },
	'imagestabilization2' => { 354 => 0xa },
	'imagestabilizationsetting' => { 164 => 0x14, 350 => 0x3d, 351 => 0x3d, 361 => 0x14 },
	'imagestyle' => { 350 => 0x2d, 351 => 0x27 },
	'imagesupplier' => { 264 => 'ImageSupplier' },
	'imagesupplierid' => { 264 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 264 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 264 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 108 => 0x1 },
	'imagetemperaturemin' => { 108 => 0x2 },
	'imagetone' => { 308 => 0x4f },
	'imagetype' => { 114 => 0x82, 264 => 'ImageType' },
	'imageuniqueid' => { 55 => 0x28, 106 => 0xa420, 410 => 'ImageUniqueID' },
	'imagewidth' => { 106 => 0x100, 165 => 0xe, 317 => 0x10c, 426 => 'ImageWidth' },
	'incrementaltemperature' => { 406 => 'IncrementalTemperature' },
	'incrementaltint' => { 406 => 'IncrementalTint' },
	'industry' => { 420 => 'industry', 421 => 'industry' },
	'infobuttonwhenshooting' => { 73 => 0x409 },
	'infraredilluminator' => { 329 => 0x28 },
	'ingredientexclusion' => { 422 => 'ingredientExclusion' },
	'ingredients' => { 431 => 'Ingredients' },
	'ingredientsalternatepaths' => { 431 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 431 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 431 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 431 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 431 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 431 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 431 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 431 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 431 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 431 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 431 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 431 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 431 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 431 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 431 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 431 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 431 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 73 => 0x51e },
	'initialhorizontalfovdegrees' => { 395 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 395 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 395 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 395 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 240 => '4.4' },
	'initialzoomsetting' => { 240 => '9.3', 247 => '27.3' },
	'inkset' => { 106 => 0x14c },
	'inputprofile' => { 120 => 0x1389 },
	'instanceid' => { 431 => 'InstanceID' },
	'instantplaybacksetup' => { 161 => 0x3e },
	'instantplaybacktime' => { 161 => 0x3d },
	'instructions' => { 418 => 'Instructions' },
	'instrument' => { 430 => 'instrument' },
	'intellectualgenre' => { 415 => 'IntellectualGenre' },
	'intelligentauto' => { 362 => 0xb052 },
	'intelligentcontrast' => { 44 => 0x4 },
	'intelligentd-range' => { 275 => 0x79 },
	'intelligentexposure' => { 275 => 0x5d },
	'intelligentresolution' => { 275 => 0x70 },
	'interchangecolorspace' => { 116 => 0x40 },
	'internalflash' => { 158 => 0x2b, 240 => '23.1', 242 => '8.1', 244 => '22.1', 246 => '23.1', 249 => '8.1', 252 => '24.1', 257 => 0x1208 },
	'internalflashae1' => { 259 => 0x1021 },
	'internalflashae1_0' => { 259 => 0x101d },
	'internalflashae2' => { 259 => 0x1022 },
	'internalflashae2_0' => { 259 => 0x101e },
	'internalflashmode' => { 296 => 0x1 },
	'internalflashstrength' => { 296 => 0x3 },
	'internalflashtable' => { 259 => 0x1024 },
	'internallensserialnumber' => { 339 => 0xa005 },
	'internalndfilter' => { 275 => 0x9d },
	'internalserialnumber' => { 55 => 0x96, 66 => 0x9, 111 => 0x10, 164 => 0x49dc, 253 => 0x18, 255 => 0x102, 275 => 0x25, 288 => 0x4, 333 => 0x5, 378 => [0x7c,0x88,0xf0] },
	'interopindex' => { 106 => 0x1, 411 => 'InteroperabilityIndex' },
	'interopversion' => { 106 => 0x2 },
	'intervallength' => { 158 => 0x10 },
	'intervalmode' => { 158 => 0x26 },
	'intervalnumber' => { 158 => 0x11 },
	'introtime' => { 430 => 'introTime' },
	'introtimescale' => { 430 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 430 => [\'introTime','introTimeValue'] },
	'iptc' => { 107 => 'IPTC' },
	'iptc-naa' => { 106 => 0x83bb, 279 => 0x83bb },
	'iptcbitspersample' => { 116 => 0x56 },
	'iptcdigest' => { 322 => 0x425 },
	'iptcimageheight' => { 116 => 0x1e },
	'iptcimagerotation' => { 116 => 0x66 },
	'iptcimagewidth' => { 116 => 0x14 },
	'iptclastedited' => { 416 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 116 => 0xa },
	'iptcpixelheight' => { 116 => 0x32 },
	'iptcpixelwidth' => { 116 => 0x28 },
	'isalternativeof' => { 420 => 'isAlternativeOf' },
	'isbn' => { 420 => 'isbn' },
	'iscorrectionof' => { 420 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 98 => 0x3 },
	'ismergedhdr' => { 402 => 'IsMergedHDR' },
	'ismergedpanorama' => { 402 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x0, 28 => 0x1, 101 => 0x14, 102 => [0x3014,0x14], 106 => 0x8827, 119 => 0xfd06, 120 => 0x1784, 122 => 0x60, 124 => [0xfa2e,0xfa46], 125 => [0x27,0x28], 126 => 0xf105, 129 => 0x14, 131 => 0x4e, 134 => 0x34, 136 => 'ISO', 158 => 0x8, 164 => 0x49ba, 189 => 0x0, 195 => 0x2, 279 => 0x17, 308 => [0x8b,0x14], 315 => 0x14, 317 => 0x105, 339 => 0xa014, 361 => 0x6f, 366 => [0x1f,0x21,0x25], 410 => 'ISOSpeedRatings' },
	'iso2' => { 189 => 0x6, 204 => 0x265, 205 => 0x25c, 206 => 0x265, 207 => 0x221, 208 => 0x25d, 209 => 0x256, 210 => 0x25d, 214 => 0x2b5, 217 => 0x265, 222 => 0x2b5 },
	'isoauto' => { 289 => '14.4' },
	'isoautohilimit' => { 212 => 0x18eb, 213 => 0xe82, 221 => 0x185d },
	'isoautoparameters' => { 308 => 0x7a },
	'isoautoshuttertime' => { 212 => 0x18ea, 213 => 0xe81, 221 => 0x185c },
	'isodisplay' => { 243 => '4.1', 244 => '2.3', 245 => '3.3', 246 => '3.3', 248 => '3.3', 251 => '4.3', 252 => '4.3' },
	'isoexpansion' => { 73 => 0x103, 74 => 0x7, 75 => 0x8, 78 => 0x8, 189 => 0x4 },
	'isoexpansion2' => { 189 => 0xa },
	'isofloor' => { 289 => 0x6 },
	'isoselection' => { 195 => 0xf },
	'isosensitivitystep' => { 248 => '6.2' },
	'isosetting' => { 122 => 0x5e, 136 => 'ISOSetting', 158 => 0x24, 159 => 0x26, 160 => 0x1c, 161 => 0x13, 166 => 0x6, 195 => 0x13, 289 => '17.3', 332 => 0x27, 350 => 0x16, 351 => 0x14, 352 => 0x2, 361 => 0x6d },
	'isospeed' => { 106 => 0x8833, 411 => 'ISOSpeed' },
	'isospeedexpansion' => { 72 => 0x3 },
	'isospeedincrements' => { 73 => 0x102 },
	'isospeedlatitudeyyy' => { 106 => 0x8834, 411 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 106 => 0x8835, 411 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 73 => 0x103 },
	'isostepsize' => { 240 => '6.1', 241 => '7.2', 243 => '7.2', 247 => '4.1', 251 => '7.2' },
	'isovalue' => { 259 => 0x1001 },
	'issn' => { 420 => 'issn' },
	'issueidentifier' => { 420 => 'issueIdentifier' },
	'issuename' => { 420 => 'issueName' },
	'issueteaser' => { 420 => 'issueTeaser' },
	'issuetype' => { 420 => 'issueType' },
	'istranslationof' => { 420 => 'isTranslationOf' },
	'jobid' => { 114 => 0xb8 },
	'jobname' => { 412 => 'JobName' },
	'jobref' => { 429 => 'JobRef' },
	'jobrefid' => { 429 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 429 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 429 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 412 => 'JobStatus' },
	'jpeghandling' => { 406 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 277 => 0x3034, 362 => 0xb047 },
	'jpegsize' => { 277 => 0x303a },
	'jpgcompression' => { 213 => 0x7d4 },
	'jpgfromraw' => { 86 => 0x2007, 103 => 'JpgFromRaw', 279 => 0x2e },
	'jpgfromrawlength' => { 106 => [0x117,0x202] },
	'jpgfromrawstart' => { 106 => [0x111,0x201] },
	'jpgrecordedpixels' => { 289 => '14.1' },
	'jurisdiction' => { 403 => 'jurisdiction' },
	'kelvinwb_01' => { 297 => 0x5 },
	'kelvinwb_02' => { 297 => 0x9 },
	'kelvinwb_03' => { 297 => 0xd },
	'kelvinwb_04' => { 297 => 0x11 },
	'kelvinwb_05' => { 297 => 0x15 },
	'kelvinwb_06' => { 297 => 0x19 },
	'kelvinwb_07' => { 297 => 0x1d },
	'kelvinwb_08' => { 297 => 0x21 },
	'kelvinwb_09' => { 297 => 0x25 },
	'kelvinwb_10' => { 297 => 0x29 },
	'kelvinwb_11' => { 297 => 0x2d },
	'kelvinwb_12' => { 297 => 0x31 },
	'kelvinwb_13' => { 297 => 0x35 },
	'kelvinwb_14' => { 297 => 0x39 },
	'kelvinwb_15' => { 297 => 0x3d },
	'kelvinwb_16' => { 297 => 0x41 },
	'kelvinwb_daylight' => { 297 => 0x1 },
	'key' => { 430 => 'key' },
	'keystonecompensation' => { 258 => 0x1900 },
	'keystonedirection' => { 258 => 0x1901 },
	'keystonevalue' => { 258 => 0x1906 },
	'keyword' => { 420 => 'keyword' },
	'keywordinfo' => { 151 => 'Keywords' },
	'keywords' => { 114 => 0x19, 137 => 'Keywords', 263 => 'Keywords', 324 => 'Keywords', 400 => 'keywords', 417 => 'Keywords', 428 => 'Keywords' },
	'killdate' => { 420 => 'killDate' },
	'killdatea-platform' => { 420 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 420 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 119 => 0xf908, 122 => 0xe, 124 => [0xfa1e,0xfa52], 130 => 0x70 },
	'kodakimagewidth' => { 119 => 0xf907, 122 => 0xc, 124 => [0xfa1d,0xfa51], 130 => 0x6c },
	'kodakinfotype' => { 119 => 0xfa00 },
	'kodaklook' => { 120 => 0xe4c },
	'kodaklookprofile' => { 120 => 0x138a },
	'kodakmaker' => { 130 => 0x8 },
	'kodakmodel' => { 122 => 0x0, 130 => 0x28 },
	'label' => { 267 => 'Label', 428 => 'Label' },
	'labelname1' => { 414 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 414 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 275 => 0x6f },
	'landscapeoutputhighlightpoint' => { 98 => 0x26 },
	'landscapeoutputshadowpoint' => { 98 => 0x27 },
	'landscaperawcolortone' => { 98 => 0x1f },
	'landscaperawcontrast' => { 98 => 0x21 },
	'landscaperawhighlight' => { 98 => 0x77 },
	'landscaperawhighlightpoint' => { 98 => 0x24 },
	'landscaperawlinear' => { 98 => 0x22 },
	'landscaperawsaturation' => { 98 => 0x20 },
	'landscaperawshadow' => { 98 => 0x80 },
	'landscaperawshadowpoint' => { 98 => 0x25 },
	'landscaperawsharpness' => { 98 => 0x23 },
	'landscapeunsharpmaskfineness' => { 98 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 98 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 98 => 0xa2 },
	'language' => { 407 => 'language' },
	'languageidentifier' => { 114 => 0x87 },
	'largestvalidinteriorrectheight' => { 395 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 395 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 395 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 395 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 158 => 0x1b },
	'lastkeywordiptc' => { 156 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 156 => 'LastKeywordXMP' },
	'lastphotodate' => { 395 => 'LastPhotoDate' },
	'lasturl' => { 431 => 'LastURL' },
	'lateralchromaticaberration' => { 362 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 402 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 105 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 105 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 105 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 105 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 105 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 299 => 0x2 },
	'lc10' => { 299 => 0xb },
	'lc11' => { 299 => 0xc },
	'lc12' => { 299 => 0xd },
	'lc14' => { 299 => 0xf },
	'lc15' => { 299 => 0x10 },
	'lc3' => { 299 => 0x4 },
	'lc4' => { 299 => 0x5 },
	'lc5' => { 299 => 0x6 },
	'lc6' => { 299 => 0x7 },
	'lc7' => { 299 => 0x8 },
	'lc8' => { 299 => 0x9 },
	'lcddisplayatpoweron' => { 73 => 0x811, 77 => 0xa },
	'lcddisplayreturntoshoot' => { 78 => 0x12 },
	'lcdillumination' => { 240 => '17.5', 241 => '5.2', 243 => '5.1', 247 => '10.3', 248 => '4.2', 251 => '5.2', 252 => '5.4' },
	'lcdilluminationduringbulb' => { 73 => 0x408 },
	'lcdpanels' => { 72 => 0x8 },
	'lcheditor' => { 233 => 0x8ae85e },
	'legacyiptcdigest' => { 418 => 'LegacyIPTCDigest' },
	'legalcode' => { 403 => 'legalcode' },
	'lens' => { 106 => 0xfdea, 195 => 0x84, 402 => 'Lens' },
	'lensafstopbutton' => { 71 => 0x11, 72 => 0x13, 73 => 0x506, 74 => 0x10, 75 => 0x12, 78 => 0x13, 79 => 0x9 },
	'lensaperturerange' => { 342 => [0x30,0x48] },
	'lenscorrectionsettings' => { 409 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 402 => 'LensDistortInfo' },
	'lensdistortionparams' => { 259 => 0x206 },
	'lensdrivenoaf' => { 73 => 0x505 },
	'lense-mountversion' => { 352 => 0x3f0, 390 => 0xd },
	'lensfirmware' => { 334 => 0x20, 339 => 0xa004 },
	'lensfirmwareversion' => { 255 => 0x204, 275 => 0x60, 352 => 0x3f4, 390 => 0x15 },
	'lensfocallength' => { 92 => 0xf0512, 299 => 0x9 },
	'lensfocalrange' => { 342 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 241 => '55.1', 243 => '52.1', 251 => '52.1' },
	'lensformat' => { 373 => 0x1891, 375 => 0x18bd, 376 => 0x18ed, 378 => 0x106, 386 => 0x603, 387 => 0x5d },
	'lensfstops' => { 190 => 0x7, 191 => 0xc, 192 => 0xd, 195 => 0x8b, 299 => '0.3' },
	'lensid' => { 402 => 'LensID' },
	'lensidnumber' => { 190 => 0x6, 191 => 0xb, 192 => 0xc },
	'lensinfo' => { 106 => 0xa432, 305 => 0x2a, 402 => 'LensInfo', 411 => 'LensSpecification' },
	'lenskind' => { 299 => 0x1 },
	'lensmake' => { 106 => 0xa433, 143 => 'Make', 411 => 'LensMake' },
	'lensmanualdistortionamount' => { 406 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 156 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 342 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 55 => 0x95, 106 => 0xa434, 143 => 'Model', 156 => 'LensModel', 193 => 0x18a, 255 => 0x203, 273 => 0x303, 305 => 0xc, 317 => 0x412, 411 => 'LensModel' },
	'lensmount' => { 352 => 0x99, 373 => 0x1892, 375 => 0x18be, 376 => 0x18ee, 378 => 0x105, 386 => 0x604, 387 => 0x5e },
	'lensmount2' => { 390 => 0x8 },
	'lensparameters' => { 370 => 0x1a23, 373 => 0x1870, 375 => 0x189c, 376 => 0x18cc, 386 => 0x6ca, 387 => 0x64 },
	'lensprofilechromaticaberrationscale' => { 406 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 406 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 406 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 406 => 'LensProfileEnable' },
	'lensprofilefilename' => { 406 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 406 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 406 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 406 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 406 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 406 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 406 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 406 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 406 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 406 => 'LensProfileName' },
	'lensprofilesetup' => { 406 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 406 => 'LensProfileVignettingScale' },
	'lensproperties' => { 255 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 29 => 0x16b, 53 => 0x0, 106 => 0xa435, 143 => 'SerialNumber', 255 => 0x202, 275 => 0x52, 334 => 0x30, 402 => 'LensSerialNumber', 411 => 'LensSerialNumber' },
	'lensshutterlock' => { 161 => 0x4a },
	'lensspec' => { 347 => 0x0, 348 => 0x0, 349 => 0x0, 362 => 0xb02a },
	'lensspecfeatures' => { 378 => [0x115,0x116] },
	'lenstemperature' => { 259 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x112, 31 => 0x16, 163 => 0x10c, 164 => 0x49bd, 195 => 0x83, 255 => 0x201, 268 => 0x16, 271 => 0x310, 274 => 0x303, 275 => 0x51, 277 => 0x3405, 300 => 0x0, 301 => 0x0, 302 => 0x1, 303 => 0x1, 304 => 0x1, 306 => 0x0, 339 => 0xa003, 342 => 0x27, 362 => 0xb027, 373 => 0x1896, 375 => 0x18c2, 376 => 0x18f2, 378 => 0x109, 386 => 0x608, 387 => 0x62 },
	'lenstype2' => { 352 => 0x3f7, 373 => 0x1893, 375 => 0x18bf, 376 => 0x18ef, 378 => 0x107, 386 => 0x605, 387 => 0x60 },
	'lenstype3' => { 390 => 0x9 },
	'lenszoomposition' => { 384 => 0x19, 385 => 0x1e, 387 => [0x342,0x35a] },
	'levelindicator' => { 282 => 0x15 },
	'levelorientation' => { 307 => 0x0 },
	'license' => { 403 => 'license' },
	'licensee' => { 264 => 'Licensee' },
	'licenseeid' => { 264 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 264 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 264 => 'LicenseeImageNotes' },
	'licenseename' => { 264 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 264 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 264 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 264 => 'LicenseeTransactionID' },
	'licenseid' => { 264 => 'LicenseID' },
	'licensestartdate' => { 264 => 'LicenseStartDate' },
	'licensetransactiondate' => { 264 => 'LicenseTransactionDate' },
	'licensetype' => { 408 => 'licensetype' },
	'licensor' => { 264 => 'Licensor' },
	'licensorcity' => { 264 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 264 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 264 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 264 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 264 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 264 => 'LicensorImageID' },
	'licensorname' => { 264 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 264 => 'LicensorNotes' },
	'licensorpostalcode' => { 264 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 264 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 264 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 264 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 264 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 264 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 264 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 264 => 'LicensorTransactionID' },
	'licensorurl' => { 264 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 259 => 0x1009 },
	'lightingmode' => { 102 => 0x302a },
	'lightreading' => { 308 => 0x15 },
	'lightsource' => { 106 => 0x9208, 195 => 0x90, 262 => 0x1000, 410 => 'LightSource' },
	'lightsourcespecial' => { 341 => 0x21d },
	'lightswitch' => { 251 => '0.1', 252 => '0.1' },
	'lightvaluecenter' => { 259 => 0x103d },
	'lightvalueperiphery' => { 259 => 0x103e },
	'limitafareamodeselection' => { 241 => '51.1', 243 => '49.1', 251 => '49.1' },
	'linearitylimitblue' => { 279 => 0x10 },
	'linearitylimitgreen' => { 279 => 0xf },
	'linearitylimitred' => { 279 => 0xe },
	'linearityuppermargin' => { 38 => [0x2ba,0x2d1,0x2d5], 40 => 0x1e5, 41 => [0x1fe,0x2de], 42 => [0x232,0x310] },
	'linearizationtable' => { 106 => 0xc618 },
	'linearresponselimit' => { 106 => 0xc62e },
	'link' => { 420 => 'link' },
	'linkaetoafpoint' => { 289 => '14.2' },
	'linkedencodedrightsexpr' => { 416 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 416 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 416 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 416 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 105 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 244 => '32.1', 252 => '34.1' },
	'liveviewafareamode' => { 248 => '34.1' },
	'liveviewafmethod' => { 366 => 0x20 },
	'liveviewafmode' => { 248 => '34.2' },
	'liveviewafsetting' => { 352 => 0x36 },
	'liveviewbuttonoptions' => { 241 => '50.2', 243 => '48.2', 251 => '48.2' },
	'liveviewexposuresimulation' => { 73 => 0x810 },
	'liveviewfocusmode' => { 352 => [0x8b,0x28b] },
	'liveviewmetering' => { 352 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 241 => '21.2', 243 => '21.2', 245 => '20.2', 246 => '20.2', 248 => '20.2', 251 => '21.2' },
	'liveviewshooting' => { 49 => 0x13 },
	'localcaption' => { 114 => 0x79 },
	'localizedcameramodel' => { 106 => 0xc615 },
	'locallocationname' => { 339 => 0x30 },
	'location' => { 194 => 0x9, 275 => 0x67, 398 => 'Location', 415 => 'Location', 419 => 'location', 420 => 'location' },
	'locationareacode' => { 404 => 'lac' },
	'locationcreated' => { 416 => 'LocationCreated' },
	'locationcreatedcity' => { 416 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 416 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 416 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedlocationid' => { 416 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedprovincestate' => { 416 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 416 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 416 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 194 => 0x0 },
	'locationname' => { 339 => 0x31 },
	'locationshown' => { 416 => 'LocationShown' },
	'locationshowncity' => { 416 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 416 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 416 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownlocationid' => { 416 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownprovincestate' => { 416 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 416 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 416 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 73 => 0x709 },
	'logcomment' => { 430 => 'logComment' },
	'longexposurenoisereduction' => { 54 => 0x4, 73 => 0x201, 74 => 0x1, 75 => 0x2, 76 => 0x1, 77 => 0x1, 78 => 0x2, 79 => 0x1, 275 => 0x49, 350 => 0x2b, 351 => 0x25, 352 => 0x25, 362 => 0x2008, 366 => 0x11, 387 => 0x44 },
	'longexposurenoisereduction2' => { 49 => 0x8 },
	'loop' => { 430 => 'loop' },
	'lowestbiostratigraphiczone' => { 105 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 406 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 406 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 406 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 406 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 406 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 406 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 406 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 406 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 97 => 0x150 },
	'luminancecurvepoints' => { 97 => 0x126 },
	'luminancenoisereduction' => { 92 => 0x20600, 98 => 0x5f, 342 => 0x1b },
	'luminancenoisereductioncontrast' => { 406 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 406 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 98 => 0x6d },
	'luminancesmoothing' => { 406 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 73 => [0x40b,0x40c] },
	'lyrics' => { 430 => 'lyrics' },
	'm16cversion' => { 271 => 0x333 },
	'macatom' => { 405 => 'macAtom' },
	'macatomapplicationcode' => { 405 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 405 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 405 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 111 => 0x1020, 112 => 0x202, 259 => 0x202, 332 => 0x21, 341 => 0x202, 362 => 0xb040 },
	'macroled' => { 257 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 49 => 0x10 },
	'macromode' => { 31 => 0x1, 158 => 0xb, 254 => 0x300, 275 => 0x1c, 333 => 0x1009 },
	'magentahsl' => { 92 => 0x20917 },
	'magicfilter' => { 254 => 0x52c },
	'magnifiedview' => { 75 => 0x11, 77 => 0x9 },
	'maindialexposurecomp' => { 249 => '0.6' },
	'mainingredient' => { 422 => 'mainIngredient' },
	'make' => { 87 => 0x0, 106 => 0x10f, 136 => 'Make', 267 => 'Make', 279 => 0x10f, 419 => 'make', 426 => 'Make' },
	'makernote' => { 410 => 'MakerNote' },
	'makernoteapple' => { 104 => 'MakN', 106 => 0x927c },
	'makernotecanon' => { 104 => 'MakN', 106 => 0x927c },
	'makernotecasio' => { 104 => 'MakN', 106 => 0x927c },
	'makernotecasio2' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteflir' => { 104 => 'MakN', 106 => 0x927c },
	'makernotefujifilm' => { 104 => 'MakN', 106 => 0x927c },
	'makernotege' => { 104 => 'MakN', 106 => 0x927c },
	'makernotege2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehasselblad' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehp' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehp2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehp4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehp6' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteisl' => { 104 => 'MakN', 106 => 0x927c },
	'makernotejvc' => { 104 => 'MakN', 106 => 0x927c },
	'makernotejvctext' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak10' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak11' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak1a' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak1b' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak5' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak6a' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak6b' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak7' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak8a' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak8b' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak8c' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak9' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodakunknown' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekyocera' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica2' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica3' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica4' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica5' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica6' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica7' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica8' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica9' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteminolta' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteminolta2' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteminolta3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotemotorola' => { 104 => 'MakN', 106 => 0x927c },
	'makernotenikon' => { 104 => 'MakN', 106 => 0x927c },
	'makernotenikon2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotenikon3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotenintendo' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteoffset' => { 341 => 0xff },
	'makernoteolympus' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteolympus2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepanasonic' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepanasonic2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax5' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax6' => { 104 => 'MakN', 106 => 0x927c },
	'makernotephaseone' => { 104 => 'MakN', 106 => 0x927c },
	'makernotereconyx' => { 104 => 'MakN', 106 => 0x927c },
	'makernotericoh' => { 104 => 'MakN', 106 => 0x927c },
	'makernotericoh2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotericohtext' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesafety' => { 106 => 0xc635 },
	'makernotesamsung1a' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesamsung1b' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesamsung2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesanyo' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesanyoc4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesanyopatch' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesigma' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony5' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesonyericsson' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesonysrf' => { 104 => 'MakN', 106 => 0x927c },
	'makernotetype' => { 333 => 0x1 },
	'makernoteunknown' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteunknownbinary' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteunknowntext' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteversion' => { 163 => 0x0, 195 => 0x1, 259 => 0x0, 275 => 0x8000, 337 => 0x0, 339 => 0x1, 342 => [0x1d,0x1f], 353 => 0x2000 },
	'managedfrom' => { 431 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 431 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 431 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 431 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 431 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 431 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 431 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 431 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 431 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 431 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 431 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 431 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 431 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 431 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 431 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 431 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 431 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 431 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 431 => 'Manager' },
	'managervariant' => { 431 => 'ManagerVariant' },
	'manageto' => { 431 => 'ManageTo' },
	'manageui' => { 431 => 'ManageUI' },
	'manifest' => { 431 => 'Manifest' },
	'manifestlinkform' => { 431 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 431 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 431 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 431 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 431 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 431 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 431 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 431 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 431 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 431 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 431 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 431 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 431 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 431 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 431 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 431 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 431 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 431 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 431 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 431 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 431 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 431 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 254 => 0x900, 275 => 0x86 },
	'manometerreading' => { 254 => 0x901 },
	'manualafpointselectpattern' => { 73 => 0x513 },
	'manualflash' => { 257 => 0x1209 },
	'manualflashoutput' => { 31 => 0x29, 242 => '8.2', 244 => '22.2', 245 => '23.1', 246 => '23.2', 247 => '16.2', 248 => '23.2', 249 => '8.2', 250 => '23.2', 252 => '24.2', 333 => 0x100c },
	'manualflashstrength' => { 254 => 0x406 },
	'manualfocusdistance' => { 195 => 0x85, 259 => 0x100c, 341 => 0x223 },
	'manualtv' => { 72 => 0x5, 73 => 0x705 },
	'manufacturedate' => { 168 => 0x6705, 288 => 0x1 },
	'manufacturedate1' => { 335 => 0x4 },
	'manufacturedate2' => { 335 => 0x5 },
	'manufacturer' => { 419 => 'manufacturer' },
	'marked' => { 417 => 'Marked', 434 => 'Marked' },
	'markers' => { 430 => 'markers' },
	'markerscomment' => { 430 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 430 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 430 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 430 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 430 => [\'markers','markersCuePointType'] },
	'markersduration' => { 430 => [\'markers','markersDuration'] },
	'markerslocation' => { 430 => [\'markers','markersLocation'] },
	'markersname' => { 430 => [\'markers','markersName'] },
	'markersprobability' => { 430 => [\'markers','markersProbability'] },
	'markersspeaker' => { 430 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 430 => [\'markers','markersStartTime'] },
	'markerstarget' => { 430 => [\'markers','markersTarget'] },
	'markerstype' => { 430 => [\'markers','markersType'] },
	'maskedareas' => { 106 => 0xc68e },
	'masterdocumentid' => { 114 => 0xb9 },
	'mastergain' => { 202 => 0x50 },
	'matrixmetering' => { 241 => '50.1', 243 => '48.1', 251 => '48.1' },
	'maxaperture' => { 31 => 0x1a, 126 => 0x6103, 143 => 'MaxAperture', 158 => 0x17, 164 => 0x49c5, 255 => 0x20a, 299 => '14.1', 378 => 0x0 },
	'maxapertureatmaxfocal' => { 111 => 0x1407, 143 => 'MaxApertureAtMaxFocal', 190 => 0xb, 191 => 0x10, 192 => 0x11, 255 => 0x206 },
	'maxapertureatminfocal' => { 111 => 0x1406, 190 => 0xa, 191 => 0xf, 192 => 0x10, 255 => 0x205 },
	'maxaperturevalue' => { 106 => 0x9205, 317 => 0x414, 410 => 'MaxApertureValue' },
	'maxavailheight' => { 416 => 'MaxAvailHeight' },
	'maxavailwidth' => { 416 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 240 => 0xb, 241 => 0xc, 243 => '12.1', 247 => 0xc, 248 => 0xb, 251 => '12.1' },
	'maxfaces' => { 258 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x116, 31 => 0x17, 111 => 0x1405, 143 => 'MaxFocalLength', 190 => 0x9, 191 => 0xe, 192 => 0xf, 255 => 0x208, 373 => 0x127c, 374 => 0x1138, 375 => 0x330, 376 => 0x330 },
	'maximumdensityrange' => { 116 => 0x8c },
	'maxpagesize' => { 435 => 'MaxPageSize' },
	'maxpagesizeh' => { 435 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 435 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 435 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 106 => 0x119 },
	'maxstorage' => { 425 => 'maxstorage' },
	'mb-d10batteries' => { 240 => '12.6' },
	'mb-d10batterytype' => { 247 => '13.3' },
	'mb-d11batterytype' => { 248 => '2.3' },
	'mb-d12batterytype' => { 251 => '3.2' },
	'mb-d80batteries' => { 249 => '6.5' },
	'mb-d80batterytype' => { 252 => '3.2' },
	'mcuversion' => { 190 => 0xc, 191 => 0x11, 192 => 0x12 },
	'md5digest' => { 144 => 'zmd5' },
	'meal' => { 422 => 'meal' },
	'measuredev' => { 26 => 0x9, 67 => 0x3, 86 => 0x1814, 136 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 26 => 0x8, 67 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 164 => 0x690, 271 => 0x312, 277 => 0x3407 },
	'measuredrggb' => { 56 => 0x1 },
	'measuredrggbdata' => { 37 => 0x287 },
	'measurementaccuracy' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 105 => 'MeasurementOrFact' },
	'measurementremarks' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 264 => 'MediaConstraints' },
	'mediacreatedate' => { 325 => 0x1 },
	'mediamodifydate' => { 325 => 0x2 },
	'mediasummarycode' => { 264 => 'MediaSummaryCode' },
	'memoaudioquality' => { 73 => 0x812 },
	'memorycardconfiguration' => { 356 => 0x16 },
	'memorycardnumber' => { 182 => 0x2 },
	'menubuttondisplayposition' => { 71 => 0xb, 74 => 0xa, 75 => 0xb, 78 => 0xb },
	'menubuttonreturn' => { 79 => 0xb },
	'menumonitorofftime' => { 240 => '26.1', 241 => '22.1', 243 => '22.1', 247 => '8.2', 248 => '21.1', 251 => '22.1', 252 => '22.1' },
	'metadatadate' => { 428 => 'MetadataDate' },
	'metadatamoddate' => { 430 => 'metadataModDate' },
	'metaversion' => { 368 => 0x34 },
	'meterinfo1row1' => { 363 => 0x0 },
	'meterinfo1row2' => { 363 => 0x6c },
	'meterinfo1row3' => { 363 => 0xd8 },
	'meterinfo1row4' => { 363 => 0x144 },
	'meterinfo1row5' => { 363 => 0x1b0 },
	'meterinfo1row6' => { 363 => 0x21c },
	'meterinfo1row7' => { 363 => 0x288 },
	'meterinfo2row1' => { 363 => 0x2f4 },
	'meterinfo2row2' => { 363 => 0x378 },
	'meterinfo2row3' => { 363 => 0x3fc },
	'meterinfo2row4' => { 363 => 0x480 },
	'meterinfo2row5' => { 363 => 0x504 },
	'meterinfo2row6' => { 363 => 0x588 },
	'meterinfo2row7' => { 363 => 0x60c },
	'meterinfo2row8' => { 363 => 0x690 },
	'meterinfo2row9' => { 363 => 0x714 },
	'metering' => { 242 => '6.1' },
	'meteringmode' => { 31 => 0x11, 106 => 0x9207, 122 => 0x1c, 158 => 0x7, 159 => 0x25, 161 => 0x12, 254 => 0x202, 308 => 0x17, 342 => 0x9, 350 => 0x15, 351 => 0x13, 352 => 0x7, 366 => 0x3, 369 => 0x1174, 370 => 0x1178, 371 => 0x1154, 372 => 0x11d0, 373 => 0x11ac, 374 => 0x1064, 375 => 0x25c, 376 => 0x25c, 410 => 'MeteringMode' },
	'meteringmode2' => { 289 => '2.1' },
	'meteringmode3' => { 289 => '16.1' },
	'meteringoffscaleindicator' => { 161 => 0x53 },
	'meteringtime' => { 240 => '22.2', 242 => '3.2', 244 => '17.1', 245 => '18.1', 247 => '7.3', 248 => '18.1', 249 => '3.2', 252 => '19.1' },
	'mieversion' => { 144 => '0Vers' },
	'minaperture' => { 31 => 0x1b, 143 => 'MinAperture', 299 => '0.2', 378 => 0x1 },
	'minaperturevalue' => { 317 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x114, 31 => 0x18, 111 => 0x1404, 143 => 'MinFocalLength', 190 => 0x8, 191 => 0xd, 192 => 0xe, 255 => 0x207, 373 => 0x127a, 374 => 0x1136, 375 => 0x32e, 376 => 0x32e },
	'minfocusdistance' => { 299 => 0x3 },
	'minoltadate' => { 158 => 0x15 },
	'minoltaimagesize' => { 158 => 0x4, 159 => 0xc, 160 => 0x2, 163 => 0x103 },
	'minoltamodelid' => { 158 => 0x25 },
	'minoltaquality' => { 158 => 0x5, 159 => 0xd, 160 => 0x3, 163 => [0x102,0x103] },
	'minoltatime' => { 158 => 0x16 },
	'minormodelagedisclosure' => { 264 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 106 => 0x118 },
	'mirrorlockup' => { 71 => 0xc, 72 => 0xc, 73 => 0x60f, 74 => 0xb, 75 => 0xc, 76 => 0x6, 77 => 0x6, 78 => 0xc, 79 => 0x3 },
	'mobilecountrycode' => { 404 => 'mcc' },
	'mobilenetworkcode' => { 404 => 'mnc' },
	'moddate' => { 267 => 'modify-date', 417 => 'ModDate' },
	'modedialposition' => { 356 => 0x14 },
	'model' => { 87 => 0x6, 106 => 0x110, 136 => 'Model', 267 => 'Model', 279 => 0x110, 419 => 'model', 426 => 'Model' },
	'modelage' => { 416 => 'ModelAge' },
	'modelid' => { 253 => 0x0 },
	'modelingflash' => { 240 => '21.4', 241 => '31.1', 243 => '31.1', 247 => '26.4', 248 => '30.2', 249 => '7.4', 250 => '30.1', 251 => '31.1', 252 => '31.3' },
	'modelreleaseid' => { 264 => 'ModelReleaseID' },
	'modelreleasestatus' => { 264 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 379 => 0x52, 380 => 0x46, 381 => 0x53 },
	'modelyear' => { 419 => 'modelYear' },
	'modificationdate' => { 420 => 'modificationDate' },
	'modifiedcolortemp' => { 57 => 0x9 },
	'modifieddigitalgain' => { 57 => 0xb },
	'modifiedparamflag' => { 50 => 0x1 },
	'modifiedpicturestyle' => { 57 => 0xa },
	'modifiedsaturation' => { 254 => 0x504 },
	'modifiedsensorbluelevel' => { 57 => 0x5 },
	'modifiedsensorredlevel' => { 57 => 0x4 },
	'modifiedsharpness' => { 57 => 0x2 },
	'modifiedsharpnessfreq' => { 57 => 0x3 },
	'modifiedtonecurve' => { 57 => 0x1 },
	'modifiedwhitebalance' => { 57 => 0x8 },
	'modifiedwhitebalanceblue' => { 57 => 0x7 },
	'modifiedwhitebalancered' => { 57 => 0x6 },
	'modifydate' => { 106 => 0x132, 137 => 'ModifyDate', 263 => 'ModDate', 265 => 'tIME', 324 => 'ModDate', 326 => 0x2, 428 => 'ModifyDate' },
	'moirefilter' => { 106 => 0xfe58, 406 => 'MoireFilter' },
	'monitordisplayoff' => { 161 => 0x4c },
	'monitorofftime' => { 240 => '18.2', 242 => '3.1', 249 => '3.1' },
	'monochromecolor' => { 254 => 0x53b },
	'monochromecontrast' => { 98 => 0x3c },
	'monochromefiltereffect' => { 92 => 0x20307, 98 => 0x3a, 308 => 0x73 },
	'monochromelinear' => { 98 => 0x3d },
	'monochromeoutputhighlightpoint' => { 98 => 0x41 },
	'monochromeoutputshadowpoint' => { 98 => 0x42 },
	'monochromeprofilesettings' => { 254 => 0x537 },
	'monochromerawhighlight' => { 98 => 0x7a },
	'monochromerawhighlightpoint' => { 98 => 0x3f },
	'monochromerawshadow' => { 98 => 0x83 },
	'monochromerawshadowpoint' => { 98 => 0x40 },
	'monochromesharpness' => { 98 => 0x3e },
	'monochrometoning' => { 308 => 0x74 },
	'monochrometoningeffect' => { 92 => 0x20306, 98 => 0x3b },
	'monochromeunsharpmaskfineness' => { 98 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 98 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 98 => 0xb4 },
	'monochromevignetting' => { 254 => 0x53a },
	'monthdaycreated' => { 122 => 0x12, 131 => 0xe },
	'moonphase' => { 329 => 0x12 },
	'morepermissions' => { 403 => 'morePermissions' },
	'motionsensitivity' => { 329 => 0x29 },
	'movieaelockbuttonassignment' => { 251 => '40.1' },
	'moviefunctionbutton' => { 241 => '41.1', 251 => '41.1' },
	'moviefunctionbuttonplusdials' => { 241 => '52.1' },
	'moviepreviewbutton' => { 241 => '41.2', 243 => ['41.1','41.2'], 251 => '41.2' },
	'moviepreviewbuttonplusdials' => { 241 => '52.2' },
	'movieshutterbutton' => { 241 => '38.3', 243 => '38.3', 251 => '38.3' },
	'moviesubselectorassignment' => { 241 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 241 => '53.1' },
	'multiburstimageheight' => { 362 => 0x1002 },
	'multiburstimagewidth' => { 362 => 0x1001 },
	'multiburstmode' => { 362 => 0x1000 },
	'multicontrollerwhilemetering' => { 73 => 0x517 },
	'multiexposure' => { 59 => 0x1 },
	'multiexposureautogain' => { 196 => 0x3 },
	'multiexposurecontrol' => { 59 => 0x2 },
	'multiexposuremode' => { 196 => 0x1 },
	'multiexposureshots' => { 59 => 0x3, 196 => 0x2 },
	'multiframenoisereduction' => { 352 => 0x35, 362 => 0x200b, 366 => 0x15 },
	'multifunctionlock' => { 73 => 0x70f },
	'multipleexposuremode' => { 258 => 0x101c },
	'multipleexposureset' => { 289 => '10.1' },
	'multisample' => { 202 => 0x40 },
	'multiselector' => { 240 => '9.4', 241 => '10.3', 243 => '10.3', 247 => '27.4', 251 => '10.3' },
	'multiselectorliveview' => { 240 => '4.3', 243 => '37.1', 251 => '37.1' },
	'multiselectorliveviewmode' => { 212 => 0x18c2 },
	'multiselectorplaybackmode' => { 240 => ['13.5','9.2'], 241 => '10.2', 243 => '10.2', 247 => '27.2', 251 => '10.2' },
	'multiselectorshootmode' => { 240 => '9.1', 241 => '10.1', 243 => '10.1', 247 => '27.1', 251 => '10.1' },
	'mycolormode' => { 60 => 0x2 },
	'nationalcatalognumber' => { 420 => 'nationalCatalogNumber' },
	'nativedigest' => { 410 => 'NativeDigest', 426 => 'NativeDigest' },
	'ncdfileinfo' => { 120 => 0x414 },
	'ndfilter' => { 67 => 0x1c, 254 => 0x204, 333 => 0x1019 },
	'nefbitdepth' => { 195 => 0xe22 },
	'nefcompression' => { 195 => 0x93 },
	'neflinearizationtable' => { 195 => 0x96 },
	'negativecachelargepreviewsize' => { 406 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 406 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 406 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 308 => 0x88 },
	'neutraloutputhighlightpoint' => { 98 => 0x2f },
	'neutraloutputshadowpoint' => { 98 => 0x30 },
	'neutralrawcolortone' => { 98 => 0x28 },
	'neutralrawcontrast' => { 98 => 0x2a },
	'neutralrawhighlight' => { 98 => 0x78 },
	'neutralrawhighlightpoint' => { 98 => 0x2d },
	'neutralrawlinear' => { 98 => 0x2b },
	'neutralrawsaturation' => { 98 => 0x29 },
	'neutralrawshadow' => { 98 => 0x81 },
	'neutralrawshadowpoint' => { 98 => 0x2e },
	'neutralrawsharpness' => { 98 => 0x2c },
	'neutralunsharpmaskfineness' => { 98 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 98 => 0xa8 },
	'neutraunsharpmaskstrength' => { 98 => 0xa4 },
	'newrawimagedigest' => { 106 => 0xc7a7 },
	'newsphotoversion' => { 116 => 0x0 },
	'nickname' => { 428 => 'Nickname' },
	'nikoncapturedata' => { 195 => 0xe01 },
	'nikoncaptureeditversions' => { 195 => 0xe13 },
	'nikoncaptureoutput' => { 195 => 0xe1e },
	'nikoncaptureversion' => { 195 => 0xe09 },
	'nikoniccprofile' => { 195 => 0xe1d },
	'nikonimagesize' => { 209 => '723.1', 210 => '732.1', 219 => 0x2c4 },
	'noisefilter' => { 254 => 0x527 },
	'noiseprofile' => { 106 => 0xc761 },
	'noisereduction' => { 111 => 0x100b, 159 => 0xb0, 160 => 0x60, 161 => 0x3f, 195 => 0x95, 233 => 0x753dcbc0, 234 => 0x17, 254 => 0x50a, 259 => 0x103a, 275 => 0x2d, 308 => 0x49, 333 => 0x100f, 335 => 0x2a },
	'noisereduction2' => { 258 => 0x1010 },
	'noisereductionapplied' => { 106 => 0xc6f7 },
	'noisereductionintensity' => { 234 => 0x9 },
	'noisereductionmethod' => { 234 => 0x11 },
	'noisereductionmode' => { 391 => 0x801e },
	'noisereductionsharpness' => { 234 => 0xd },
	'noisereductionvalue' => { 391 => 0x8027 },
	'nomemorycard' => { 240 => '22.1', 241 => '4.2', 242 => '0.3', 244 => '2.4', 245 => '3.2', 246 => '3.2', 247 => '33.7', 248 => '3.2', 249 => '0.3', 251 => '4.2', 252 => '4.5' },
	'nominalmaxaperture' => { 299 => 0xa },
	'nominalminaperture' => { 299 => '10.1' },
	'normalwhitelevel' => { 38 => [0x2b8,0x2cf,0x2d3], 40 => 0x1e3, 41 => [0x1fc,0x2dc], 42 => [0x230,0x30e] },
	'notes' => { 392 => 'Notes', 400 => 'notes' },
	'npages' => { 435 => 'NPages' },
	'nrwdata' => { 195 => 0x14 },
	'nullrecord' => { 86 => 0x0 },
	'number' => { 420 => 'number' },
	'numberofbeats' => { 430 => 'numberOfBeats' },
	'numberoffocuspoints' => { 243 => '1.2', 246 => '0.2', 248 => '0.3' },
	'numfacepositions' => { 269 => 0x0 },
	'numindexentries' => { 116 => 0x54 },
	'numwbentries' => { 280 => 0x0, 281 => 0x0 },
	'object' => { 420 => 'object' },
	'objectattributereference' => { 114 => 0x4 },
	'objectcycle' => { 114 => 0x4b, 400 => 'ObjectCycle' },
	'objectdescription' => { 419 => 'objectDescription' },
	'objectdistance' => { 101 => 0x6, 102 => 0x2022 },
	'objectname' => { 114 => 0x5 },
	'objectpreviewdata' => { 114 => 0xca },
	'objectpreviewfileformat' => { 114 => 0xc8 },
	'objectpreviewfileversion' => { 114 => 0xc9 },
	'objectsubtype' => { 419 => 'objectSubtype' },
	'objecttype' => { 419 => 'objectType' },
	'objecttypereference' => { 114 => 0x3 },
	'occurrence' => { 105 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 105 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 105 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 105 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 105 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 105 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 105 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 105 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 105 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 105 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 105 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 105 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 105 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 105 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 105 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 105 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 105 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 105 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 105 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 105 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 105 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 105 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 105 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 105 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 410 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 410 => [\'OECF','OECFNames'] },
	'oecfrows' => { 410 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 410 => [\'OECF','OECFValues'] },
	'offsaledate' => { 420 => 'offSaleDate' },
	'offsaledatea-platform' => { 420 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 420 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 106 => 0xea1d },
	'okbutton' => { 248 => '15.1', 252 => '16.1' },
	'oldsubfiletype' => { 106 => 0xff },
	'olympusimageheight' => { 259 => 0x102f },
	'olympusimagewidth' => { 259 => 0x102e },
	'onetouchwb' => { 259 => 0x302 },
	'onsaledate' => { 420 => 'onSaleDate' },
	'onsaledatea-platform' => { 420 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 420 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 420 => 'onSaleDay' },
	'onsaledaya-platform' => { 420 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 420 => [\'onSaleDay','onSaleDayDay'] },
	'opticalzoom' => { 124 => 0xfa3d, 126 => [0x6006,0xf006], 127 => 0x1000, 128 => 0xf, 131 => 0x1e, 143 => 'OpticalZoom' },
	'opticalzoomcode' => { 67 => 0xa },
	'opticalzoommode' => { 275 => 0x34 },
	'opticalzoomon' => { 341 => 0x219 },
	'optionenddate' => { 423 => 'optionEndDate' },
	'opto-electricconvfactor' => { 410 => 'OECF' },
	'orangehsl' => { 92 => 0x20911 },
	'ordernumber' => { 111 => 0x8002 },
	'organisationinimagecode' => { 416 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 416 => 'OrganisationInImageName' },
	'organization' => { 420 => 'organization' },
	'orientation' => { 106 => 0x112, 279 => 0x112, 419 => 'orientation', 426 => 'Orientation' },
	'orientation2' => { 366 => [0x28,0x2e] },
	'orientationlinkedafpoint' => { 73 => 0x516 },
	'originalbestqualitysize' => { 106 => 0xc792 },
	'originaldecisiondata' => { 103 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 55 => 0x83 },
	'originaldefaultcropsize' => { 106 => 0xc793 },
	'originaldefaultfinalsize' => { 106 => 0xc791 },
	'originaldirectory' => { 273 => 0x408 },
	'originaldocumentid' => { 431 => 'OriginalDocumentID' },
	'originalfilename' => { 86 => 0x816, 120 => 0x3e9, 132 => 0x20, 273 => 0x407, 396 => 'OriginalFilename' },
	'originalimageheight' => { 69 => 0xc, 110 => 0x1 },
	'originalimagewidth' => { 69 => 0xb, 110 => 0x0 },
	'originalrawfiledata' => { 106 => 0xc68c },
	'originalrawfiledigest' => { 106 => 0xc71d },
	'originalrawfilename' => { 106 => 0xc68b },
	'originaltransmissionreference' => { 114 => 0x67 },
	'originatingprogram' => { 114 => 0x41, 400 => 'OriginatingProgram' },
	'originplatform' => { 420 => 'originPlatform' },
	'os' => { 408 => 'os' },
	'otherconditions' => { 264 => 'OtherConditions' },
	'otherconstraints' => { 264 => 'OtherConstraints' },
	'otherimage' => { 103 => 'OtherImage' },
	'otherimageinfo' => { 264 => 'OtherImageInfo' },
	'otherimagelength' => { 106 => 0x202 },
	'otherimagestart' => { 106 => 0x201 },
	'otherlicensedocuments' => { 264 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 264 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 264 => 'OtherLicenseRequirements' },
	'outcue' => { 430 => 'outCue' },
	'outcuescale' => { 430 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 430 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 173 => 0x3 },
	'outputimagewidth' => { 173 => 0x2 },
	'outputprofile' => { 120 => 0x138b },
	'outputresolution' => { 173 => 0x4 },
	'owner' => { 434 => 'Owner' },
	'ownerid' => { 114 => 0xbc },
	'ownername' => { 14 => 0x10f, 55 => 0x9, 86 => 0x810, 106 => [0xa430,0xfde8], 136 => 'OwnerName', 402 => 'OwnerName', 411 => 'CameraOwnerName' },
	'padding' => { 106 => 0xea1c },
	'pagecount' => { 420 => 'pageCount' },
	'pageimage' => { 428 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 428 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 428 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 428 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 428 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 428 => 'PageInfo' },
	'pagename' => { 106 => 0x11d },
	'pagenumber' => { 106 => 0x129 },
	'pageprogressiondirection' => { 420 => 'pageProgressionDirection' },
	'pagerange' => { 420 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 406 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 406 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 275 => 0x26 },
	'panasonicimageheight' => { 275 => 0x4c },
	'panasonicimagewidth' => { 275 => 0x4b },
	'panasonicrawversion' => { 279 => 0x1 },
	'panasonictitle' => { 106 => 0xc6d2 },
	'panasonictitle2' => { 106 => 0xc6d3 },
	'panoramacropbottom' => { 367 => 0x7 },
	'panoramacropleft' => { 367 => 0x4 },
	'panoramacropright' => { 367 => 0x6 },
	'panoramacroptop' => { 367 => 0x5 },
	'panoramadirection' => { 63 => 0x5, 367 => 0x3 },
	'panoramaframeheight' => { 367 => 0x9 },
	'panoramaframenumber' => { 63 => 0x2 },
	'panoramaframewidth' => { 367 => 0x8 },
	'panoramafullheight' => { 367 => 0x2 },
	'panoramafullwidth' => { 367 => 0x1 },
	'panoramamode' => { 122 => 0x3c, 254 => 0x601 },
	'panoramasize3d' => { 352 => 0x38 },
	'panoramasourceheight' => { 367 => 0xb },
	'panoramasourcewidth' => { 367 => 0xa },
	'panoramicstitchcameramotion' => { 154 => 'PanoramicStitchCameraMotion', 155 => 0x1 },
	'panoramicstitchmaptype' => { 154 => 'PanoramicStitchMapType', 155 => 0x2 },
	'panoramicstitchphi0' => { 154 => 'PanoramicStitchPhi0', 155 => 0x5 },
	'panoramicstitchphi1' => { 154 => 'PanoramicStitchPhi1', 155 => 0x6 },
	'panoramicstitchtheta0' => { 154 => 'PanoramicStitchTheta0', 155 => 0x3 },
	'panoramicstitchtheta1' => { 154 => 'PanoramicStitchTheta1', 155 => 0x4 },
	'panoramicstitchversion' => { 155 => 0x0 },
	'pantry' => { 431 => 'Pantry' },
	'parallax' => { 111 => 0xb211, 253 => 0x28 },
	'parametricdarks' => { 406 => 'ParametricDarks' },
	'parametrichighlights' => { 406 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 406 => 'ParametricHighlightSplit' },
	'parametriclights' => { 406 => 'ParametricLights' },
	'parametricmidtonesplit' => { 406 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 406 => 'ParametricShadows' },
	'parametricshadowsplit' => { 406 => 'ParametricShadowSplit' },
	'parentmeid' => { 396 => 'ParentMEID' },
	'parentreference1' => { 414 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 414 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 430 => 'partOfCompilation' },
	'patientbirthdate' => { 393 => 'PatientDOB' },
	'patientid' => { 393 => 'PatientID' },
	'patientname' => { 393 => 'PatientName' },
	'patientsex' => { 393 => 'PatientSex' },
	'pdfversion' => { 417 => 'PDFVersion' },
	'pentaximagesize' => { 308 => 0x9 },
	'pentaxmodelid' => { 288 => 0x0, 308 => 0x5 },
	'pentaxmodeltype' => { 308 => 0x1 },
	'pentaxversion' => { 308 => 0x0 },
	'people' => { 394 => 'People', 398 => 'People' },
	'perchannelblacklevel' => { 37 => 0xc4, 38 => [0x2b4,0x2cb,0x2cf], 39 => 0x108, 40 => 0x1df, 41 => [0x1f8,0x2d8], 42 => [0x22c,0x30a] },
	'peripheralillumcentralradius' => { 391 => 0x8030 },
	'peripheralillumcentralvalue' => { 391 => 0x8031 },
	'peripheralillumination' => { 92 => 0x20702, 98 => 0x68 },
	'peripheralilluminationcorr' => { 54 => 0x1, 298 => 0x2 },
	'peripheralilluminationon' => { 92 => '0x20702.0', 98 => 0x64 },
	'peripheralillumperiphvalue' => { 391 => 0x8032 },
	'peripherallighting' => { 69 => 0x2 },
	'peripherallightingsetting' => { 70 => 0x5 },
	'peripherallightingvalue' => { 69 => 0x6 },
	'permissions' => { 423 => 'permissions' },
	'permits' => { 403 => 'permits' },
	'person' => { 420 => 'person' },
	'personality' => { 396 => 'Personality' },
	'personinimage' => { 416 => 'PersonInImage' },
	'personinimagecharacteristic' => { 416 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 416 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 416 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 416 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 416 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 416 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 416 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 416 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 416 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 406 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 406 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 406 => 'PerspectiveRotate' },
	'perspectivescale' => { 406 => 'PerspectiveScale' },
	'perspectiveupright' => { 406 => 'PerspectiveUpright' },
	'perspectivevertical' => { 406 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 81 => 0x1 },
	'pf10retainprogramshift' => { 81 => 0xb },
	'pf13drivepriority' => { 81 => 0xe },
	'pf14disablefocussearch' => { 81 => 0xf },
	'pf15disableafassistbeam' => { 81 => 0x10 },
	'pf16autofocuspointshoot' => { 81 => 0x11 },
	'pf17disableafpointsel' => { 81 => 0x12 },
	'pf18enableautoafpointsel' => { 81 => 0x13 },
	'pf19continuousshootspeed' => { 81 => 0x14 },
	'pf19shootingspeedhigh' => { 80 => 0xa },
	'pf19shootingspeedlow' => { 80 => 0x9 },
	'pf1disableshootingmodes' => { 81 => 0x2 },
	'pf1value' => { 80 => 0x1 },
	'pf20limitcontinousshots' => { 81 => 0x15 },
	'pf20maxcontinousshots' => { 80 => 0xb },
	'pf21enablequietoperation' => { 81 => 0x16 },
	'pf23felocktime' => { 80 => 0xd },
	'pf23postreleasetime' => { 80 => 0xe },
	'pf23settimerlengths' => { 81 => 0x18 },
	'pf23shutterbuttontime' => { 80 => 0xc },
	'pf24lightlcdduringbulb' => { 81 => 0x19 },
	'pf25aemode' => { 80 => 0xf },
	'pf25afmode' => { 80 => 0x12 },
	'pf25afpointsel' => { 80 => 0x13 },
	'pf25colormatrix' => { 80 => 0x17 },
	'pf25defaultclearsettings' => { 81 => 0x1a },
	'pf25drivemode' => { 80 => 0x11 },
	'pf25imagesize' => { 80 => 0x14 },
	'pf25meteringmode' => { 80 => 0x10 },
	'pf25parameters' => { 80 => 0x16 },
	'pf25wbmode' => { 80 => 0x15 },
	'pf26shortenreleaselag' => { 81 => 0x1b },
	'pf27reversedialrotation' => { 81 => 0x1c },
	'pf27value' => { 80 => 0x18 },
	'pf28noquickdialexpcomp' => { 81 => 0x1d },
	'pf29quickdialswitchoff' => { 81 => 0x1e },
	'pf2disablemeteringmodes' => { 81 => 0x3 },
	'pf2value' => { 80 => 0x2 },
	'pf30enlargementmode' => { 81 => 0x1f },
	'pf31originaldecisiondata' => { 81 => 0x20 },
	'pf3manualexposuremetering' => { 81 => 0x4 },
	'pf3value' => { 80 => 0x3 },
	'pf4exposuretimelimits' => { 81 => 0x5 },
	'pf4exposuretimemax' => { 80 => 0x5 },
	'pf4exposuretimemin' => { 80 => 0x4 },
	'pf5aperturelimits' => { 81 => 0x6 },
	'pf5aperturemax' => { 80 => 0x7 },
	'pf5aperturemin' => { 80 => 0x6 },
	'pf6presetshootingmodes' => { 81 => 0x7 },
	'pf7bracketcontinuousshoot' => { 81 => 0x8 },
	'pf8bracketshots' => { 80 => 0x8 },
	'pf8setbracketshots' => { 81 => 0x9 },
	'pf9changebracketsequence' => { 81 => 0xa },
	'phasedetectaf' => { 170 => 0x6 },
	'phonenumber' => { 137 => 'Phone' },
	'photoeffect' => { 31 => 0x28 },
	'photoeffecthistoryxml' => { 233 => 0xe9651831 },
	'photoeffects' => { 233 => 0xab5eca5e },
	'photoeffectsblue' => { 235 => 0x8 },
	'photoeffectsgreen' => { 235 => 0x6 },
	'photoeffectsred' => { 235 => 0x4 },
	'photoeffectstype' => { 235 => 0x0 },
	'photographicsensitivity' => { 411 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 240 => '17.6', 247 => '33.6' },
	'photometricinterpretation' => { 106 => 0x106, 426 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 213 => 0xe7d },
	'photoshootingmenubankimagearea' => { 213 => '3716.1' },
	'photoshopbgrthumbnail' => { 322 => 0x409 },
	'photoshopquality' => { 321 => 0x0 },
	'photoshopthumbnail' => { 322 => 0x40c },
	'photostyle' => { 275 => 0x89 },
	'picklabel' => { 409 => 'PickLabel' },
	'pictinfo' => { 341 => 0x208 },
	'picturecontrol' => { 233 => 0xe2173c47 },
	'picturecontrolactive' => { 236 => 0x0 },
	'picturecontroladjust' => { 197 => 0x30, 198 => 0x30 },
	'picturecontrolbase' => { 197 => 0x18, 198 => 0x18 },
	'picturecontroldata' => { 195 => [0xbd,0x23] },
	'picturecontrolmode' => { 236 => 0x13 },
	'picturecontrolname' => { 197 => 0x4, 198 => 0x4 },
	'picturecontrolquickadjust' => { 197 => 0x31, 198 => 0x31 },
	'pictureeffect' => { 362 => 0x200e },
	'pictureeffect2' => { 369 => 0x1163, 370 => 0x1167, 371 => 0x1143, 372 => 0x11bf, 373 => 0x119b, 374 => 0x1053, 375 => 0x24b, 376 => 0x24b, 387 => 0x46 },
	'picturefinish' => { 159 => 0x71 },
	'picturemode' => { 111 => 0x1031, 254 => 0x520, 308 => [0xb,0x33], 342 => 0x3d },
	'picturemode2' => { 289 => 0x0 },
	'picturemodebwfilter' => { 254 => 0x525 },
	'picturemodecontrast' => { 254 => 0x523 },
	'picturemodeeffect' => { 254 => 0x52d },
	'picturemodehue' => { 254 => 0x522 },
	'picturemodesaturation' => { 254 => 0x521 },
	'picturemodesharpness' => { 254 => 0x524 },
	'picturemodetone' => { 254 => 0x526 },
	'pictureprofile' => { 369 => [0x115e,0x115f], 370 => [0x1162,0x1163], 371 => [0x113e,0x113f], 372 => [0x11ba,0x11bb], 373 => [0x1196,0x1197], 374 => [0x104e,0x104f], 375 => [0x246,0x247], 376 => [0x246,0x247] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 65 => 0xa, 92 => 0x20301, 98 => 0x2 },
	'picturewizard' => { 339 => 0x21 },
	'picturewizardcolor' => { 338 => 0x1 },
	'picturewizardcontrast' => { 338 => 0x4 },
	'picturewizardmode' => { 338 => 0x0 },
	'picturewizardsaturation' => { 338 => 0x2 },
	'picturewizardsharpness' => { 338 => 0x3 },
	'pipelineversion' => { 154 => 'PipelineVersion' },
	'pitch' => { 241 => '4.1', 251 => '4.1' },
	'pitchangle' => { 212 => 0x350f, 221 => 0x36f8, 254 => 0x904, 275 => 0x91, 307 => 0x2 },
	'pixelshiftresolution' => { 309 => 0x0 },
	'pixelsperunitx' => { 266 => 0x0 },
	'pixelsperunity' => { 266 => 0x4 },
	'pixelunits' => { 266 => 0x8 },
	'planarconfiguration' => { 106 => 0x11c, 426 => 'PlanarConfiguration' },
	'platenames' => { 435 => 'PlateNames' },
	'platform' => { 420 => 'platform' },
	'playbackmenustime' => { 244 => '20.1', 245 => '21.1', 246 => '21.1' },
	'playbackmonitorofftime' => { 240 => '25.2', 241 => '36.1', 243 => '36.1', 247 => '8.1', 248 => '35.1', 251 => '36.1', 252 => '21.1' },
	'playbackzoom' => { 241 => '37.1' },
	'playdisplay' => { 161 => 0x4e },
	'plusversion' => { 264 => 'Version' },
	'pmversion' => { 320 => 'PMVersion' },
	'pngwarning' => { 267 => 'Warning' },
	'poilevel' => { 194 => 0x8 },
	'portraitoutputhighlightpoint' => { 98 => 0x1d },
	'portraitoutputshadowpoint' => { 98 => 0x1e },
	'portraitrawcolortone' => { 98 => 0x16 },
	'portraitrawcontrast' => { 98 => 0x18 },
	'portraitrawhighlight' => { 98 => 0x76 },
	'portraitrawhighlightpoint' => { 98 => 0x1b },
	'portraitrawlinear' => { 98 => 0x19 },
	'portraitrawsaturation' => { 98 => 0x17 },
	'portraitrawshadow' => { 98 => 0x7f },
	'portraitrawshadowpoint' => { 98 => 0x1c },
	'portraitrawsharpness' => { 98 => 0x1a },
	'portraitrefiner' => { 102 => 0x302b },
	'portraitunsharpmaskfineness' => { 98 => 0x9a },
	'portraitunsharpmaskstrength' => { 98 => 0x98 },
	'portraitunsharpmaskthreshold' => { 98 => 0x9c },
	'poseheadingdegrees' => { 395 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 395 => 'PosePitchDegrees' },
	'poserolldegrees' => { 395 => 'PoseRollDegrees' },
	'positiondescriptor' => { 419 => 'positionDescriptor' },
	'postalcode' => { 141 => 'PostalCode' },
	'postcropvignetteamount' => { 406 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 406 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 406 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 406 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 406 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 406 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 360 => 0xb },
	'potentialface2position' => { 360 => 0x15 },
	'potentialface3position' => { 360 => 0x1f },
	'potentialface4position' => { 360 => 0x29 },
	'potentialface5position' => { 360 => 0x33 },
	'potentialface6position' => { 360 => 0x3d },
	'potentialface7position' => { 360 => 0x47 },
	'potentialface8position' => { 360 => 0x51 },
	'powersource' => { 287 => '0.1' },
	'poweruptime' => { 195 => 0xb6 },
	'precaptureframes' => { 259 => 0x300 },
	'predictor' => { 106 => 0x13d },
	'preflashreturnstrength' => { 210 => 0x28a },
	'prefs' => { 114 => 0xdd, 320 => 'Prefs' },
	'preservedfilename' => { 431 => 'PreservedFileName' },
	'presetwhitebalance' => { 161 => 0x24, 391 => 0x8002 },
	'presetwhitebalanceadj' => { 391 => 0x8014 },
	'previewapplicationname' => { 106 => 0xc716 },
	'previewapplicationversion' => { 106 => 0xc717 },
	'previewbutton' => { 240 => ['14.1','15.1'], 241 => '15.1', 243 => '15.1', 247 => '29.1', 248 => '14.1', 251 => '15.1' },
	'previewbuttonplusdials' => { 240 => ['14.2','15.2'], 241 => '15.2', 243 => '43.1', 247 => '31.2', 251 => '43.1' },
	'previewcolorspace' => { 106 => 0xc71a },
	'previewcropbottom' => { 319 => 0xef },
	'previewcropleft' => { 319 => 0xec },
	'previewcropright' => { 319 => 0xee },
	'previewcroptop' => { 319 => 0xed },
	'previewdate' => { 327 => 0x0 },
	'previewdatetime' => { 106 => 0xc71b },
	'previewimage' => { 102 => 0x2000, 103 => 'PreviewImage', 107 => 'PreviewImage', 109 => 0x4, 146 => 'data', 163 => 0x81, 259 => 0x280, 274 => 0x300, 362 => 0x2001 },
	'previewimageborders' => { 308 => 0x3e },
	'previewimageheight' => { 64 => 0x4, 124 => 0xfa58 },
	'previewimagelength' => { 64 => 0x2, 102 => 0x3, 106 => [0x117,0x202], 163 => 0x89, 199 => 0x202, 254 => 0x102, 259 => 0x1037, 308 => 0x3, 332 => 0x1e, 337 => 0x3, 342 => [0x1b,0x1d], 353 => 0x202 },
	'previewimagename' => { 146 => '1Name' },
	'previewimagesize' => { 102 => 0x2, 129 => 0x2, 146 => 'ImageSize', 308 => 0x2, 342 => [0x1c,0x1e], 362 => 0xb02c },
	'previewimagestart' => { 64 => 0x5, 102 => 0x4, 106 => [0x111,0x201], 163 => 0x88, 199 => 0x201, 254 => 0x101, 259 => 0x1036, 308 => 0x4, 332 => 0x1c, 337 => 0x2, 342 => [0x1a,0x1c], 353 => 0x201 },
	'previewimagetype' => { 146 => '0Type' },
	'previewimagevalid' => { 254 => 0x100, 259 => 0x1035 },
	'previewimagewidth' => { 64 => 0x3, 124 => 0xfa57 },
	'previewquality' => { 64 => 0x1 },
	'previewsettingsdigest' => { 106 => 0xc719 },
	'previewsettingsname' => { 106 => 0xc718 },
	'primaryafpoint' => { 170 => 0x7 },
	'primarychromaticities' => { 106 => 0x13f, 426 => 'PrimaryChromaticities' },
	'primaryslot' => { 213 => 0xe7f },
	'printim' => { 106 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 161 => 0x1d, 350 => 0x28 },
	'privatertkinfo' => { 397 => 'privateRTKInfo' },
	'processingsoftware' => { 106 => 0xb },
	'processversion' => { 406 => 'ProcessVersion' },
	'producer' => { 263 => 'Producer', 417 => 'Producer' },
	'productcode' => { 420 => 'productCode' },
	'productid' => { 115 => 0x32, 419 => 'productID' },
	'productidtype' => { 419 => 'productIDType' },
	'productinimage' => { 416 => 'ProductInImage' },
	'productinimagedescription' => { 416 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 416 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 416 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 288 => 0x2 },
	'productorserviceconstraints' => { 264 => 'ProductOrServiceConstraints' },
	'profession' => { 420 => 'profession' },
	'profilecalibrationsig' => { 106 => 0xc6f4 },
	'profilecopyright' => { 106 => 0xc6fe },
	'profileembedpolicy' => { 106 => 0xc6fd },
	'profilehuesatmapdata1' => { 106 => 0xc6fa },
	'profilehuesatmapdata2' => { 106 => 0xc6fb },
	'profilehuesatmapdims' => { 106 => 0xc6f9 },
	'profilehuesatmapencoding' => { 106 => 0xc7a3 },
	'profilelooktabledata' => { 106 => 0xc726 },
	'profilelooktabledims' => { 106 => 0xc725 },
	'profilelooktableencoding' => { 106 => 0xc7a4 },
	'profilename' => { 106 => 0xc6f8 },
	'profiletonecurve' => { 106 => 0xc6fc },
	'programiso' => { 275 => 0x3c },
	'programline' => { 289 => '1.1' },
	'programmode' => { 166 => 0x5 },
	'programshift' => { 195 => 0xd },
	'programversion' => { 114 => 0x46 },
	'prohibits' => { 403 => 'prohibits' },
	'projectiontype' => { 395 => 'ProjectionType' },
	'projectname' => { 430 => 'projectName' },
	'projectref' => { 430 => 'projectRef' },
	'projectrefpath' => { 430 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 430 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 264 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 264 => 'PropertyReleaseStatus' },
	'province-state' => { 114 => 0x5f },
	'publicationdate' => { 420 => 'publicationDate' },
	'publicationdatea-platform' => { 420 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 420 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 420 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 420 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 420 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationname' => { 420 => 'publicationName' },
	'publisher' => { 407 => 'publisher' },
	'publishingfrequency' => { 420 => 'publishingFrequency' },
	'pulldown' => { 430 => 'pullDown' },
	'purplehsl' => { 92 => 0x20916 },
	'quality' => { 0 => 0x1, 31 => 0x3, 101 => 0x2, 102 => 0x3002, 111 => 0x1000, 122 => 0x9, 195 => 0x4, 223 => 0x3, 259 => 0x201, 271 => 0x300, 308 => 0x8, 315 => 0x2, 342 => 0x16, 350 => 0x56, 351 => 0x56, 352 => 0xb, 362 => 0x102 },
	'quality2' => { 369 => 0x1170, 370 => 0x1174, 371 => 0x1150, 373 => 0x11a8, 374 => 0x1060, 375 => 0x258, 376 => 0x258, 379 => 0x29, 380 => 0x25, 381 => 0x2a },
	'qualitymode' => { 102 => 0x8 },
	'quantizationmethod' => { 116 => 0x78 },
	'quickadjust' => { 236 => 0x2a },
	'quickcontroldialinmeter' => { 73 => 0x703 },
	'quickfix' => { 233 => 0x416391c6 },
	'quickshot' => { 341 => 0x213 },
	'rangefinder' => { 244 => '4.1', 245 => '5.1', 246 => '5.1' },
	'rasterizedcaption' => { 114 => 0x7d },
	'rating' => { 106 => 0x4746, 111 => 0x1431, 319 => 0xdf, 362 => 0x2002, 400 => 'rating', 408 => 'rating', 420 => 'rating', 428 => 'Rating' },
	'ratingpercent' => { 106 => 0x4749, 156 => 'Rating' },
	'rawandjpgrecording' => { 71 => 0x8, 163 => 0x109, 289 => 0xd },
	'rawbrightnessadj' => { 92 => 0x20001, 97 => 0x38 },
	'rawcoloradj' => { 97 => 0x2e },
	'rawcompressionmode' => { 339 => 0x45 },
	'rawcropbottom' => { 319 => 0xd4 },
	'rawcropleft' => { 319 => 0xd1 },
	'rawcropright' => { 319 => 0xd3 },
	'rawcroptop' => { 319 => 0xd2 },
	'rawcustomsaturation' => { 97 => 0x30 },
	'rawcustomtone' => { 97 => 0x34 },
	'rawdata' => { 339 => 0xa048 },
	'rawdatauniqueid' => { 106 => 0xc65d },
	'rawdepth' => { 165 => 0x10 },
	'rawdevartfilter' => { 261 => 0x121 },
	'rawdevautogradation' => { 261 => 0x119 },
	'rawdevcolorspace' => { 260 => 0x108, 261 => 0x109 },
	'rawdevcontrastvalue' => { 260 => 0x106, 261 => 0x105 },
	'rawdeveditstatus' => { 260 => 0x10b },
	'rawdevelopmentprocess' => { 308 => 0x62 },
	'rawdevengine' => { 260 => 0x109, 261 => 0x10b },
	'rawdevexposurebiasvalue' => { 260 => 0x100, 261 => 0x100 },
	'rawdevgradation' => { 261 => 0x112 },
	'rawdevgraypoint' => { 260 => 0x103, 261 => 0x104 },
	'rawdevmemorycoloremphasis' => { 260 => 0x105, 261 => 0x108 },
	'rawdevnoisereduction' => { 260 => 0x10a, 261 => 0x10a },
	'rawdevpicturemode' => { 261 => 0x10c },
	'rawdevpm_bwfilter' => { 261 => 0x110 },
	'rawdevpmcontrast' => { 261 => 0x10e },
	'rawdevpmnoisefilter' => { 261 => 0x120 },
	'rawdevpmpicturetone' => { 261 => 0x111 },
	'rawdevpmsaturation' => { 261 => 0x10d },
	'rawdevpmsharpness' => { 261 => 0x10f },
	'rawdevsaturation3' => { 261 => 0x113 },
	'rawdevsaturationemphasis' => { 260 => 0x104, 261 => 0x107 },
	'rawdevsettings' => { 260 => 0x10c },
	'rawdevsharpnessvalue' => { 260 => 0x107, 261 => 0x106 },
	'rawdevversion' => { 260 => 0x0, 261 => 0x0 },
	'rawdevwbfineadjustment' => { 260 => 0x102, 261 => 0x103 },
	'rawdevwhitebalance' => { 261 => 0x101 },
	'rawdevwhitebalancevalue' => { 260 => 0x101, 261 => 0x102 },
	'rawfile' => { 106 => 0xfe4c },
	'rawfilename' => { 406 => 'RawFileName' },
	'rawformat' => { 317 => 0x10e },
	'rawimagecenter' => { 195 => 0x99 },
	'rawimagedigest' => { 106 => 0xc71c },
	'rawimagesize' => { 308 => 0x39 },
	'rawinfoversion' => { 262 => 0x0 },
	'rawjpgheight' => { 88 => 0x4 },
	'rawjpgquality' => { 49 => 0x6, 88 => 0x1 },
	'rawjpgsize' => { 49 => 0x7, 88 => 0x2 },
	'rawjpgwidth' => { 88 => 0x3 },
	'rawmeasuredrggb' => { 36 => 0x26a, 38 => 0x280, 40 => 0x194, 41 => [0x1ad,0x26b] },
	'rawrppused' => { 400 => 'rawrppused' },
	'rawtopreviewgain' => { 106 => 0xc7a8 },
	'reardisplay' => { 240 => '12.3', 241 => '6.2' },
	'recipeendingpage' => { 422 => 'recipeEndingPage' },
	'recipepagerange' => { 422 => 'recipePageRange' },
	'recipesource' => { 422 => 'recipeSource' },
	'recipestartingpage' => { 422 => 'recipeStartingPage' },
	'recipetitle' => { 422 => 'recipeTitle' },
	'recognizedface1age' => { 270 => 0x20 },
	'recognizedface1name' => { 270 => 0x4 },
	'recognizedface1position' => { 270 => 0x18 },
	'recognizedface2age' => { 270 => 0x50 },
	'recognizedface2name' => { 270 => 0x34 },
	'recognizedface2position' => { 270 => 0x48 },
	'recognizedface3age' => { 270 => 0x80 },
	'recognizedface3name' => { 270 => 0x64 },
	'recognizedface3position' => { 270 => 0x78 },
	'recognizedfaceflags' => { 275 => 0x63 },
	'recommendedexposureindex' => { 106 => 0x8832, 411 => 'RecommendedExposureIndex' },
	'record' => { 105 => 'Record' },
	'recordbasisofrecord' => { 105 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 105 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 105 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 105 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 105 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 105 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 161 => 0x4d },
	'recorddynamicproperties' => { 105 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 86 => 0x1804 },
	'recordinformationwithheld' => { 105 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 333 => 0x1000 },
	'recordingmode' => { 101 => 0x1, 315 => 0x1 },
	'recordinstitutioncode' => { 105 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 105 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 31 => 0x9, 102 => 0x3000 },
	'recordownerinstitutioncode' => { 105 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 341 => 0x217 },
	'redbalance' => { 178 => 0x270, 259 => 0x1017, 279 => 0x11, 308 => 0x1c },
	'redcurvelimits' => { 97 => 0x18a },
	'redcurvepoints' => { 96 => 0x2d, 97 => 0x160 },
	'redeyecorrection' => { 237 => 0x0 },
	'redeyeinfo' => { 406 => 'RedEyeInfo' },
	'redeyereduction' => { 161 => 0x41, 350 => 0x6a, 352 => 0x28 },
	'redhsl' => { 92 => 0x20910 },
	'redhue' => { 406 => 'RedHue' },
	'redsaturation' => { 406 => 'RedSaturation' },
	'reductionmatrix1' => { 106 => 0xc625 },
	'reductionmatrix2' => { 106 => 0xc626 },
	'reelname' => { 106 => 0xc789 },
	'reference1' => { 414 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 414 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 106 => 0x214, 426 => 'ReferenceBlackWhite' },
	'referencedate' => { 114 => 0x2f },
	'referencenumber' => { 114 => 0x32 },
	'references' => { 137 => 'References' },
	'referenceservice' => { 114 => 0x2d },
	'regionappliedtodimensions' => { 152 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 152 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 152 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 152 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 152 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 152 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 152 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 152 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 152 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 152 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 152 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 152 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 264 => 'RegionConstraints' },
	'regiondescription' => { 152 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 152 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 152 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 152 => 'Regions' },
	'regioninfodateregionsvalid' => { 153 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 153 => 'RegionInfo' },
	'regioninforegions' => { 153 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 152 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 152 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 153 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 153 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 153 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 153 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 153 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 152 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 152 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 152 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 416 => 'RegistryId' },
	'registryitemid' => { 416 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 416 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 135 => 'data' },
	'relatedaudiofilename' => { 135 => '1Name' },
	'relatedaudiofiletype' => { 135 => '0Type' },
	'relatedimagefileformat' => { 106 => 0x1000 },
	'relatedimageheight' => { 106 => 0x1002 },
	'relatedimagewidth' => { 106 => 0x1001 },
	'relatedresourceid' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 106 => 0xa004, 410 => 'RelatedSoundFile' },
	'relatedvideofile' => { 149 => 'data' },
	'relatedvideofilename' => { 149 => '1Name' },
	'relatedvideofiletype' => { 149 => '0Type' },
	'relation' => { 407 => 'relation' },
	'relationshipaccordingto' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 430 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 430 => 'relativeTimestamp' },
	'relativetimestampscale' => { 430 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 430 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 240 => '17.8', 241 => '18.5', 243 => '18.4', 247 => '33.8', 248 => '17.6', 251 => '18.5' },
	'releasedate' => { 114 => 0x1e, 400 => 'ReleaseDate', 430 => 'releaseDate' },
	'releasemode' => { 102 => 0x3001, 212 => 0x184d, 362 => 0xb049 },
	'releasemode2' => { 369 => 0x112c, 370 => [0x112c,0x8], 371 => [0x1108,0x8], 372 => [0x1184,0x8], 373 => [0x1160,0x8], 374 => [0x4,0x1018], 375 => [0x4,0x210], 376 => [0x4,0x210], 378 => [0x67,0x73,0x3f,0x4b], 379 => 0x10, 380 => 0x10, 381 => 0x9, 387 => 0x34 },
	'releasemode3' => { 369 => 0x1128, 370 => 0x1128, 371 => 0x1104, 372 => 0x1180, 373 => 0x115c, 374 => 0x1014, 375 => 0x20c, 376 => 0x20c },
	'releasesetting' => { 86 => 0x1016 },
	'releasetime' => { 114 => 0x23, 400 => 'ReleaseTime' },
	'remoteonduration' => { 242 => '3.4', 244 => '17.2', 245 => '18.2', 246 => '18.2', 248 => '18.2', 249 => '4.3', 252 => '19.2' },
	'renditionclass' => { 431 => 'RenditionClass' },
	'renditionof' => { 431 => 'RenditionOf' },
	'renditionofalternatepaths' => { 431 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 431 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 431 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 431 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 431 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 431 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 431 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 431 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 431 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 431 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 431 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 431 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 431 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 431 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 431 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 431 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 431 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 431 => 'RenditionParams' },
	'repeatingflashcount' => { 183 => 0xd, 184 => 0xe, 185 => 0xe, 247 => '17.2', 248 => '24.2', 249 => '9.2', 250 => '24.2', 252 => '25.2' },
	'repeatingflashcountbuilt-in' => { 220 => 0x4db },
	'repeatingflashcountexternal' => { 220 => 0x4c3 },
	'repeatingflashoutput' => { 247 => '17.1', 248 => '24.1', 249 => '9.1', 250 => '24.1', 252 => '25.1' },
	'repeatingflashoutputexternal' => { 220 => 0x4c0 },
	'repeatingflashrate' => { 183 => 0xc, 184 => 0xd, 185 => 0xd, 247 => '18.1', 248 => '25.1', 249 => '10.1', 250 => '25.1', 252 => '26.1' },
	'repeatingflashratebuilt-in' => { 220 => 0x4da },
	'repeatingflashrateexternal' => { 220 => 0x4c2 },
	'requires' => { 403 => 'requires' },
	'resampleparams' => { 430 => 'resampleParams' },
	'resampleparamsquality' => { 430 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 341 => 0x21e },
	'resolution' => { 142 => 'Resolution' },
	'resolutionmode' => { 342 => 0x4 },
	'resolutionunit' => { 106 => 0x128, 117 => 0x2, 426 => 'ResolutionUnit' },
	'resourceid' => { 105 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 105 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 105 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 73 => 0x612 },
	'restrictions' => { 423 => 'restrictions' },
	'retouchareafeather' => { 406 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 406 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 406 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 406 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 406 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 406 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 406 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 406 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 406 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 406 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 406 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 406 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 406 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 406 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 406 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 406 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 406 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 406 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 406 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 406 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 406 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 406 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 406 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 406 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 406 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 406 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 406 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 406 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 406 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 406 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 406 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 406 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 406 => 'RetouchAreas' },
	'retouchareaseed' => { 406 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 406 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 406 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 406 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 195 => 0x9e },
	'retouchinfo' => { 406 => 'RetouchInfo' },
	'retouchnefprocessing' => { 201 => 0x5 },
	'retractlensonpoweroff' => { 73 => 0x814 },
	'reuse' => { 264 => 'Reuse' },
	'reuseallowed' => { 433 => 'ReuseAllowed' },
	'reuseprohibited' => { 423 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 246 => '5.2' },
	'reverseindicators' => { 240 => '12.1', 241 => '6.1', 243 => '6.1', 244 => '4.3', 245 => '5.2', 246 => '5.4', 247 => '33.5', 248 => '5.1', 251 => '6.1', 252 => '6.2' },
	'reverseshutterspeedaperture' => { 246 => '5.3' },
	'revision' => { 408 => 'revision' },
	'rgbcurvelimits' => { 97 => 0x238 },
	'rgbcurvepoints' => { 96 => 0x7, 97 => 0x20e },
	'richtextcomment' => { 413 => 'RichTextComment' },
	'ricohdate' => { 332 => 0x6 },
	'ricohimageheight' => { 332 => 0x2 },
	'ricohimagewidth' => { 332 => 0x0 },
	'rightascension' => { 145 => 'RightAscension' },
	'rights' => { 407 => 'rights' },
	'rightsagent' => { 423 => 'rightsAgent' },
	'rightsowner' => { 423 => 'rightsOwner' },
	'rollangle' => { 212 => 0x350b, 221 => 0x36f4, 254 => 0x903, 275 => 0x90, 307 => 0x1 },
	'romoperationmode' => { 86 => 0x80d },
	'rotation' => { 27 => 0x17, 28 => 0x18, 85 => 0x3, 92 => 0x10002, 97 => 0x26e, 110 => 0x4, 145 => 'Rotation', 159 => [0x65,0x50], 160 => 0x46, 161 => 0x5a, 164 => 0x10, 219 => '590.1', 233 => 0x76a43207, 275 => 0x30, 289 => '17.2', 319 => 0xd8, 350 => 0x3f, 351 => 0x3f, 361 => 0x10 },
	'routedto' => { 412 => 'RoutedTo' },
	'routing' => { 324 => 'Routing' },
	'routingnotes' => { 412 => 'RoutingNotes' },
	'rowsperstrip' => { 106 => 0x116 },
	'rpp' => { 400 => 'rpp' },
	'safetyshift' => { 73 => 0x108 },
	'safetyshiftinavortv' => { 71 => 0x10, 72 => 0x10, 74 => 0xf, 75 => 0x10, 78 => 0x10 },
	'sameexposurefornewaperture' => { 73 => 0x112 },
	'samplebits' => { 135 => 'SampleBits' },
	'samplepagerange' => { 420 => 'samplePageRange' },
	'samplerate' => { 135 => 'SampleRate' },
	'samplesperpixel' => { 106 => 0x115, 426 => 'SamplesPerPixel' },
	'samplestructure' => { 116 => 0x5a },
	'samsungmodelid' => { 339 => 0x3 },
	'sanyoquality' => { 341 => 0x201 },
	'sanyothumbnail' => { 341 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 31 => 0xe, 43 => 0x1, 101 => 0xd, 102 => [0x3013,0x1f], 106 => [0xa409,0xfe55], 111 => 0x1003, 136 => 'Saturation', 158 => 0x1f, 159 => 0x32, 160 => 0x28, 161 => 0x1a, 166 => 0x1, 195 => [0x94,0xaa], 197 => 0x35, 198 => 0x3b, 275 => 0x40, 277 => 0x300d, 308 => 0x1f, 315 => 0xd, 329 => 0x27, 332 => 0x28, 333 => 0x1013, 342 => 0x10, 350 => 0x1e, 351 => 0x1b, 362 => 0x2005, 406 => 'Saturation', 410 => 'Saturation' },
	'saturationadj' => { 92 => 0x20901, 97 => 0x116, 232 => 0x1, 236 => 0x2e, 391 => 0x8016 },
	'saturationadjustmentaqua' => { 406 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 406 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 406 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 406 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 406 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 406 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 406 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 406 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 62 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 61 => 0x68, 62 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 61 => 0x38, 62 => 0x38 },
	'saturationmonochrome' => { 61 => 0x80, 62 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 61 => 0x50, 62 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 61 => 0x20, 62 => 0x20 },
	'saturationsetting' => { 262 => 0x1010, 352 => 0x11, 366 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 61 => 0x8, 62 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 61 => 0x98, 62 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 61 => 0xb0, 62 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 61 => 0xc8, 62 => 0xe0 },
	'saveid' => { 431 => 'SaveID' },
	'scaletype' => { 430 => 'scaleType' },
	'scanimageenhancer' => { 202 => 0x60 },
	'scanningdirection' => { 116 => 0x64 },
	'scene' => { 415 => 'Scene', 430 => 'scene' },
	'scenearea' => { 257 => 0x211, 259 => 0x1031 },
	'sceneassist' => { 195 => 0x9c },
	'scenecapturetype' => { 106 => 0xa406, 410 => 'SceneCaptureType' },
	'scenedetect' => { 257 => 0x210, 259 => 0x1030 },
	'scenedetectdata' => { 257 => 0x212, 259 => 0x1033 },
	'scenemode' => { 124 => 0xfa02, 163 => 0x100, 195 => 0x8f, 254 => 0x509, 259 => 0x403, 275 => 0x8001, 283 => 0xf, 362 => 0xb023 },
	'scenemodeused' => { 126 => [0x6002,0xf002] },
	'sceneselect' => { 341 => 0x21f },
	'scenetype' => { 106 => 0xa301, 410 => 'SceneType' },
	'screentips' => { 240 => '12.7', 241 => '5.3', 247 => '13.1', 248 => '4.4', 251 => '5.4', 252 => '5.1' },
	'season' => { 419 => 'season' },
	'secondaryslotfunction' => { 212 => 0x1d0, 221 => 0x1d0 },
	'section' => { 420 => 'section' },
	'securityclassification' => { 106 => 0x9212 },
	'selectableafpoint' => { 73 => 0x509 },
	'selectafareaselectmode' => { 73 => 0x512 },
	'selftimer' => { 31 => 0x2, 275 => 0x2e, 341 => 0x214, 369 => 0x1134, 370 => 0x1134, 371 => 0x1110, 372 => 0x118c, 373 => 0x1168, 374 => 0x1020, 375 => 0x218, 376 => 0x218 },
	'selftimer2' => { 67 => 0x1d },
	'selftimerinterval' => { 248 => '19.2' },
	'selftimermode' => { 106 => 0x882b },
	'selftimershotcount' => { 241 => '20.2', 243 => '20.3', 244 => '18.2', 245 => '19.2', 246 => '19.2', 248 => '19.3', 251 => '20.3', 252 => '20.2' },
	'selftimershotinterval' => { 241 => '20.3', 243 => '20.2', 251 => '20.2' },
	'selftimertime' => { 86 => 0x1806, 161 => 0x1f, 240 => '18.1', 241 => '20.1', 242 => '3.3', 243 => '20.1', 244 => '18.1', 245 => '19.1', 246 => '19.1', 247 => '7.2', 248 => '19.1', 249 => '3.3', 251 => '20.1', 252 => '20.1' },
	'sellingagency' => { 420 => 'sellingAgency' },
	'seminfo' => { 106 => 0x8546 },
	'sensingmethod' => { 106 => 0xa217, 410 => 'SensingMethod' },
	'sensitivityadjust' => { 308 => 0x40 },
	'sensitivitysteps' => { 289 => ['14.3','17.4'], 291 => 0x1 },
	'sensitivitytype' => { 106 => 0x8830, 411 => 'SensitivityType' },
	'sensor' => { 168 => 0x665e },
	'sensorareas' => { 339 => 0xa010 },
	'sensorbitdepth' => { 277 => 0x312d },
	'sensorbluelevel' => { 65 => 0x5 },
	'sensorcalibration' => { 258 => 0x805 },
	'sensorcleaning' => { 79 => 0xd },
	'sensorfullheight' => { 119 => 0xf904 },
	'sensorfullwidth' => { 119 => 0xf903 },
	'sensorheight' => { 119 => 0xf901, 124 => 0xfa21, 165 => 0x8, 277 => 0x312c, 317 => 0x109, 333 => 0x1602 },
	'sensorleftmargin' => { 317 => 0x10a },
	'sensorpixelsize' => { 195 => 0x9a },
	'sensorredlevel' => { 65 => 0x4 },
	'sensorserialnumber' => { 120 => 0x9ce },
	'sensorsize' => { 136 => 'SensorSize', 308 => 0x35 },
	'sensortemperature' => { 257 => 0x1500, 259 => 0x1007, 313 => 0xc, 317 => 0x210, 342 => [0x39,0x55] },
	'sensortemperature2' => { 313 => 0xe, 317 => 0x211 },
	'sensortopmargin' => { 317 => 0x10b },
	'sensorwidth' => { 119 => 0xf900, 124 => 0xfa20, 165 => 0xa, 277 => 0x312b, 317 => 0x108, 333 => 0x1601 },
	'sequence' => { 329 => 0x7 },
	'sequencefilenumber' => { 370 => 0x4, 371 => 0x4, 372 => 0x4, 373 => 0x4, 379 => 0xc, 380 => 0xc, 381 => 0x1a },
	'sequenceimagenumber' => { 370 => 0x0, 371 => 0x0, 372 => 0x0, 373 => 0x0, 379 => 0x8, 380 => 0x8, 381 => 0x12, 387 => 0x24 },
	'sequencelength' => { 379 => 0x22, 380 => 0x1e, 381 => [0x16,0x1e] },
	'sequencename' => { 419 => 'sequenceName' },
	'sequencenumber' => { 67 => 0x9, 102 => 0x301c, 111 => 0x1101, 122 => 0x1d, 220 => 0x51c, 275 => 0x2b, 352 => [0x10c,0x30c], 362 => 0xb04a, 419 => 'sequenceNumber' },
	'sequenceshotinterval' => { 341 => 0x224 },
	'sequencetotalnumber' => { 419 => 'sequenceTotalNumber' },
	'sequentialshot' => { 341 => 0x20e },
	'serialnumber' => { 55 => 0xc, 86 => 0x180b, 106 => [0xa431,0xfde9], 119 => 0xfa04, 121 => 0xfa00, 123 => 0xc354, 124 => 0xfa19, 133 => 0x0, 136 => 'SerialNumber', 195 => [0xa0,0x1d], 255 => 0x101, 259 => [0x404,0x101a], 271 => 0x303, 277 => 0x3103, 308 => 0x229, 317 => 0x102, 318 => 0x407, 329 => 0x15, 333 => 0x5, 342 => 0x2, 402 => 'SerialNumber', 411 => 'BodySerialNumber' },
	'serialnumberformat' => { 55 => 0x15, 86 => 0x183b },
	'seriesdatetime' => { 393 => 'SeriesDateTime' },
	'seriesdescription' => { 393 => 'SeriesDescription' },
	'seriesmodality' => { 393 => 'SeriesModality' },
	'seriesnumber' => { 393 => 'SeriesNumber', 420 => 'seriesNumber' },
	'seriestitle' => { 420 => 'seriesTitle' },
	'serviceidentifier' => { 115 => 0x1e },
	'servingsize' => { 422 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 76 => 0x0, 77 => 0x0 },
	'setbuttonwhenshooting' => { 71 => 0x1, 73 => 0x704, 79 => 0xc },
	'setfunctionwhenshooting' => { 74 => 0x0, 75 => 0x1, 78 => 0x1 },
	'setting' => { 419 => 'setting' },
	'shadingcompensation' => { 254 => 0x50c, 275 => 0x8a },
	'shadingcompensation2' => { 258 => 0x1012 },
	'shadow' => { 342 => 0xe },
	'shadowadj' => { 92 => 0x2030b },
	'shadowcorrection' => { 308 => 0x79 },
	'shadowprotection' => { 232 => 0x0 },
	'shadows' => { 106 => 0xfe52, 399 => 'Shadows', 406 => 'Shadows' },
	'shadows2012' => { 406 => 'Shadows2012' },
	'shadowscale' => { 106 => 0xc633 },
	'shadowtint' => { 406 => 'ShadowTint' },
	'shadowtone' => { 111 => 0x1040 },
	'shakereduction' => { 310 => 0x1, 311 => 0x1 },
	'sharpendetail' => { 406 => 'SharpenDetail' },
	'sharpenedgemasking' => { 406 => 'SharpenEdgeMasking' },
	'sharpening' => { 277 => 0x300b },
	'sharpeningadj' => { 236 => 0x2b },
	'sharpenradius' => { 406 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 31 => 0xf, 65 => 0x2, 101 => 0xb, 102 => [0x3011,0x21], 106 => [0xa40a,0xfe56], 111 => 0x1001, 122 => 0x6b, 131 => 0x37, 136 => 'Sharpness', 158 => 0x21, 159 => 0x30, 160 => 0x26, 161 => 0x18, 166 => 0x3, 195 => 0x6, 197 => 0x32, 198 => 0x33, 259 => 0x100f, 275 => 0x41, 308 => 0x21, 315 => 0xb, 329 => 0x26, 332 => 0x22, 333 => [0x1003,0x1014], 342 => 0x11, 350 => 0x1c, 351 => 0x19, 362 => 0x2006, 387 => 0x52, 406 => 'Sharpness', 410 => 'Sharpness' },
	'sharpnessadj' => { 92 => 0x20310, 97 => 0x25a, 391 => 0x801a },
	'sharpnessadjon' => { 92 => '0x20310.0' },
	'sharpnessauto' => { 62 => 0x94 },
	'sharpnessfactor' => { 259 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 61 => 0x64, 62 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 65 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 61 => 0x34, 62 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 61 => 0x7c, 62 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 61 => 0x4c, 62 => 0x4c },
	'sharpnessovershoot' => { 391 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 61 => 0x1c, 62 => 0x1c },
	'sharpnesssetting' => { 254 => 0x506, 262 => 0x1013, 352 => 0x12, 366 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 61 => 0x4, 62 => 0x4 },
	'sharpnessstrength' => { 92 => 0x20311 },
	'sharpnessthreshold' => { 391 => 0x801d },
	'sharpnessundershoot' => { 391 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 61 => 0x94, 62 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 61 => 0xac, 62 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 61 => 0xc4, 62 => 0xdc },
	'shootid' => { 419 => 'shootID' },
	'shootingdistance' => { 92 => 0x20701 },
	'shootinginfodisplay' => { 240 => '13.2', 241 => '5.1', 247 => '10.2', 248 => '4.1', 251 => '5.1', 252 => '5.3' },
	'shootinginfomonitorofftime' => { 240 => '26.2', 241 => '22.2', 243 => '22.2', 247 => '9.1', 248 => '21.2', 251 => '22.2', 252 => '22.2' },
	'shootingmode' => { 136 => 'ShootingMode', 195 => 0x89, 275 => 0x1f },
	'shootingmodesetting' => { 242 => '5.1' },
	'shortdescription' => { 408 => 'shortdescription' },
	'shortdocumentid' => { 114 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 73 => 0x80d },
	'shotdate' => { 430 => 'shotDate' },
	'shotday' => { 430 => 'shotDay' },
	'shotlocation' => { 430 => 'shotLocation' },
	'shotname' => { 430 => 'shotName' },
	'shotnumber' => { 430 => 'shotNumber' },
	'shotnumbersincepowerup' => { 365 => 0x44e, 379 => 0x1a, 380 => 0x16, 381 => 0xa },
	'shotnumbersincepowerup2' => { 352 => 0x200 },
	'shotsize' => { 430 => 'shotSize' },
	'shutter-aelock' => { 71 => 0x4, 73 => 0x701, 74 => 0x3, 75 => 0x4, 76 => 0x3, 77 => 0x3, 78 => 0x4, 79 => 0x2 },
	'shutteraelbutton' => { 72 => 0x4 },
	'shutterbuttonafonbutton' => { 73 => 0x701 },
	'shuttercount' => { 10 => 0x176, 49 => 0x1, 195 => 0xa7, 203 => [0x6a,0x157,0x24d], 204 => 0x286, 205 => 0x279, 206 => 0x284, 207 => 0x242, 208 => 0x280, 209 => 0x276, 210 => [0x27d,0x27f], 211 => 0x246, 214 => 0x2d6, 215 => 0x321, 216 => 0xbd8, 217 => 0x287, 218 => 0x320, 219 => 0x24a, 220 => 0x5fb, 222 => 0x2d5, 308 => 0x5d, 361 => 0x846, 364 => [0x125,0x14a] },
	'shuttercurtainsync' => { 71 => 0xf, 72 => 0xf, 73 => 0x305, 74 => 0xe, 75 => 0xf, 76 => 0x8, 77 => 0x8, 78 => 0xf, 79 => 0x8 },
	'shuttermode' => { 122 => 0x1b },
	'shutterreleasebuttonae-l' => { 240 => '17.7', 241 => '18.4', 243 => '78.4', 244 => '16.1', 245 => '17.1', 246 => '17.1', 247 => '7.1', 248 => '17.5', 251 => '18.4', 252 => '18.2' },
	'shutterreleasemethod' => { 86 => 0x1010 },
	'shutterreleasenocfcard' => { 71 => 0x2, 72 => 0x2, 79 => 0xf },
	'shutterreleasetiming' => { 86 => 0x1011 },
	'shutterreleasewithoutlens' => { 73 => 0x711 },
	'shutterspeedlock' => { 241 => '38.1', 243 => '38.1', 251 => '38.1' },
	'shutterspeedrange' => { 73 => 0x10c },
	'shutterspeedsetting' => { 161 => 0x6, 350 => 0x2f, 351 => 0x28, 352 => 0x0 },
	'shutterspeedvalue' => { 82 => 0x1, 106 => 0x9201, 259 => 0x1000, 317 => 0x400, 410 => 'ShutterSpeedValue' },
	'shuttertype' => { 111 => 0x1050, 275 => 0x9f },
	'sidecarforextension' => { 418 => 'SidecarForExtension' },
	'similarityindex' => { 114 => 0xe4 },
	'singleframebracketing' => { 161 => 0x21 },
	'skilllevel' => { 422 => 'skillLevel' },
	'slaveflashmeteringsegments' => { 308 => 0x20b },
	'slideshowname' => { 419 => 'slideshowName' },
	'slideshownumber' => { 419 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 419 => 'slideshowTotalNumber' },
	'slowshutter' => { 67 => 0x8 },
	'slowsync' => { 111 => 0x1030 },
	'smartrange' => { 339 => 0xa012 },
	'smileshutter' => { 352 => 0x31 },
	'smileshuttermode' => { 352 => 0x27 },
	'smoothness' => { 106 => 0xfe57, 406 => 'Smoothness' },
	'snapshots' => { 400 => 'Snapshots' },
	'softskineffect' => { 362 => 0x200f },
	'software' => { 106 => 0x131, 137 => 'Software', 267 => 'Software', 317 => 0x203, 342 => 0x18, 426 => 'Software' },
	'softwareversion' => { 341 => 0x207 },
	'sonydatetime' => { 368 => 0x6, 370 => 0x1b6, 371 => 0x210, 372 => 0x1fe, 373 => 0x22c },
	'sonydatetime2' => { 378 => [0x51,0x5d] },
	'sonyexposuretime' => { 378 => 0x46 },
	'sonyexposuretime2' => { 387 => 0xe },
	'sonyfnumber' => { 378 => [0x3c,0x48], 387 => 0x14 },
	'sonyimageheight' => { 368 => 0x1a, 379 => 0x44, 380 => 0x3f, 381 => 0x47 },
	'sonyimagesize' => { 161 => 0x3b, 350 => 0x54, 351 => 0x54, 352 => 0x9 },
	'sonyimagewidth' => { 368 => 0x1c },
	'sonyiso' => { 370 => 0x1218, 371 => 0x11f4, 372 => 0x1270, 373 => [0x1254,0x1258,0x1280], 374 => 0x113c, 375 => 0x344, 376 => 0x346, 387 => 0x4 },
	'sonymaxaperturevalue' => { 387 => 0x16 },
	'sonymodelid' => { 362 => 0xb001 },
	'sonyquality' => { 161 => 0x3c },
	'source' => { 114 => 0x73, 267 => 'Source', 407 => 'source', 408 => 'source', 418 => 'Source' },
	'sourcedirectoryindex' => { 295 => 0x0 },
	'sourcefileindex' => { 295 => 0x2 },
	'sourcephotoscount' => { 395 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 410 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 410 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 410 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 410 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 410 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 430 => 'speakerPlacement' },
	'specialeffectlevel' => { 102 => 0x3030 },
	'specialeffectmode' => { 102 => 0x2076 },
	'specialeffectsetting' => { 102 => 0x3031 },
	'specialinstructions' => { 114 => 0x28 },
	'specialmode' => { 259 => 0x200, 341 => 0x200 },
	'specialoccasion' => { 422 => 'specialOccasion' },
	'spectralsensitivity' => { 106 => 0x8824, 410 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 38 => [0x2b9,0x2d0,0x2d4], 40 => 0x1e4, 41 => [0x1fd,0x2dd], 42 => [0x231,0x30f] },
	'splitcolumn' => { 317 => 0x222 },
	'splittoningbalance' => { 406 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 406 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 406 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 406 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 406 => 'SplitToningShadowSaturation' },
	'sport' => { 420 => 'sport' },
	'spotfocuspointx' => { 158 => 0x2d },
	'spotfocuspointy' => { 158 => 0x2e },
	'spotmeteringmode' => { 31 => 0x27 },
	'spotmeterlinktoafpoint' => { 73 => 0x107 },
	'sractive' => { 289 => '17.1' },
	'srawquality' => { 31 => 0x2e },
	'srfocallength' => { 310 => 0x3 },
	'srhalfpresstime' => { 310 => 0x2 },
	'srresult' => { 310 => 0x0, 311 => 0x0 },
	'stackedimage' => { 254 => 0x804 },
	'standardoutputhighlightpoint' => { 98 => 0x14 },
	'standardoutputsensitivity' => { 106 => 0x8831, 411 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 98 => 0x15 },
	'standardrawcolortone' => { 98 => 0xd },
	'standardrawcontrast' => { 98 => 0xf },
	'standardrawhighlight' => { 98 => 0x75 },
	'standardrawhighlightpoint' => { 98 => 0x12 },
	'standardrawlinear' => { 98 => 0x10 },
	'standardrawsaturation' => { 98 => 0xe },
	'standardrawshadow' => { 98 => 0x7e },
	'standardrawshadowpoint' => { 98 => 0x13 },
	'standardrawsharpness' => { 98 => 0x11 },
	'standardunsharpmaskfineness' => { 98 => 0x94 },
	'standardunsharpmaskstrength' => { 98 => 0x92 },
	'standardunsharpmaskthreshold' => { 98 => 0x96 },
	'standbytimer' => { 241 => '19.1', 243 => '19.1', 246 => '18.1', 251 => '19.1' },
	'startingpage' => { 420 => 'startingPage' },
	'startmovieshooting' => { 73 => 0x70d },
	'starttimecode' => { 430 => 'startTimecode' },
	'starttimecodetimeformat' => { 430 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 430 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 430 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 430 => 'startTimeSampleSize' },
	'starttimescale' => { 430 => 'startTimeScale' },
	'state' => { 141 => 'State', 275 => 0x6b, 418 => 'State' },
	'status' => { 394 => 'Status', 398 => 'Status' },
	'stitchingsoftware' => { 395 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 369 => 0x113e, 370 => 0x113e, 371 => 0x111a, 372 => 0x1196, 373 => 0x1172, 374 => 0x102a, 375 => 0x222, 376 => 0x222, 387 => 0xa },
	'storagemethod' => { 165 => 0x12 },
	'storebyorientation' => { 241 => '46.3', 243 => '47.3', 251 => '47.3' },
	'straightenangle' => { 233 => 0x2fc08431 },
	'streamtype' => { 154 => 'StreamType' },
	'stretchmode' => { 430 => 'stretchMode' },
	'studydatetime' => { 393 => 'StudyDateTime' },
	'studydescription' => { 393 => 'StudyDescription' },
	'studyid' => { 393 => 'StudyID' },
	'studyphysician' => { 393 => 'StudyPhysician' },
	'sub-location' => { 114 => 0x5c },
	'subfiledata' => { 144 => 'data' },
	'subfiledirectory' => { 144 => '1Directory' },
	'subfilemimetype' => { 144 => '2MIME' },
	'subfilename' => { 144 => '1Name' },
	'subfileresource' => { 144 => 'rsrc' },
	'subfiletype' => { 106 => 0xfe, 144 => '0Type' },
	'subject' => { 263 => 'Subject', 324 => 'Subject', 407 => 'subject', 417 => 'Subject', 431 => 'subject' },
	'subjectarea' => { 106 => 0x9214, 410 => 'SubjectArea' },
	'subjectcode' => { 415 => 'SubjectCode' },
	'subjectdistance' => { 106 => 0x9206, 122 => 0x3e, 410 => 'SubjectDistance' },
	'subjectdistancerange' => { 106 => 0xa40c, 410 => 'SubjectDistanceRange' },
	'subjectlocation' => { 106 => 0xa214, 410 => 'SubjectLocation' },
	'subjectmotion' => { 243 => '78.2' },
	'subjectprogram' => { 158 => 0x22 },
	'subjectreference' => { 114 => 0xc },
	'sublabels4' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 414 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 414 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 106 => 0x9290 },
	'subsectimedigitized' => { 106 => 0x9292 },
	'subsectimeoriginal' => { 106 => 0x9291 },
	'subsection1' => { 420 => 'subsection1' },
	'subsection2' => { 420 => 'subsection2' },
	'subsection3' => { 420 => 'subsection3' },
	'subsection4' => { 420 => 'subsection4' },
	'subselector' => { 241 => '49.1', 243 => '71.1' },
	'subselectorassignment' => { 241 => '48.1' },
	'subselectorcenter' => { 243 => '72.1' },
	'subselectorplusdials' => { 241 => '49.2', 243 => '73.1' },
	'subtitle' => { 420 => 'subtitle' },
	'subversionfilename' => { 414 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 414 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 414 => 'SubVersions' },
	'superimposeddisplay' => { 71 => 0xa, 73 => 0x510, 74 => 0x9, 75 => 0xa, 78 => 0xa, 79 => 0xe },
	'supermacro' => { 55 => 0x1a },
	'supplementalcategories' => { 114 => 0x14, 418 => 'SupplementalCategories' },
	'supplementaltype' => { 116 => 0x37 },
	'supplementdisplayid' => { 420 => 'supplementDisplayID' },
	'supplementstartingpage' => { 420 => 'supplementStartingPage' },
	'supplementtitle' => { 420 => 'supplementTitle' },
	'svisosetting' => { 289 => 0x14 },
	'swatchcoloranta' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 435 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 435 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 435 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 435 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 435 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 275 => 0x93, 352 => 0x33 },
	'sweeppanoramafieldofview' => { 275 => 0x94 },
	'sweeppanoramasize' => { 352 => 0x32 },
	'switchtoregisteredafpoint' => { 72 => 0x12, 73 => 0x50a },
	'syncreleasemode' => { 243 => '77.1' },
	'system' => { 317 => 0x204 },
	'tagged' => { 319 => 0xdd, 320 => 'Tagged', 400 => 'tagged' },
	'tagslist' => { 409 => 'TagsList' },
	'tagstructure' => { 414 => 'TagStructure' },
	'takenumber' => { 430 => 'takeNumber' },
	'tapename' => { 430 => 'tapeName' },
	'targetaperture' => { 67 => 0x4 },
	'targetcompressionratio' => { 84 => 0x1 },
	'targetdistancesetting' => { 86 => 0x1807 },
	'targetexposuretime' => { 67 => 0x5 },
	'targetimagetype' => { 86 => 0x100a },
	'targetprinter' => { 106 => 0x151 },
	'taxon' => { 105 => 'Taxon' },
	'taxonacceptednameusage' => { 105 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 105 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 105 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 105 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 105 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 105 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 105 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 105 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 105 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 105 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 105 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 105 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 105 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 105 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 105 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 105 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 105 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 105 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 105 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 105 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 105 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 105 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 105 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 105 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 105 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 105 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 105 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 105 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 105 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 105 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 105 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 105 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 105 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 420 => 'teaser' },
	'teleconverter' => { 163 => 0x105, 362 => 0x105 },
	'tempo' => { 430 => 'tempo' },
	'termsandconditionstext' => { 264 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 264 => 'TermsAndConditionsURL' },
	'testname' => { 107 => 'TestName' },
	'textencoding' => { 194 => 0x4 },
	'textlayername' => { 418 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 418 => 'TextLayers' },
	'textlayertext' => { 418 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 275 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 243 => '1.3' },
	'three-dtrackingwatcharea' => { 243 => '78.1' },
	'thresholding' => { 106 => 0x107 },
	'thumbnailfilename' => { 86 => 0x817 },
	'thumbnailformat' => { 428 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 124 => 0xfa55, 428 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 86 => 0x2008, 103 => 'ThumbnailImage', 109 => 0x3, 147 => 'data', 259 => 0x100, 428 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 147 => '1Name' },
	'thumbnailimagesize' => { 147 => 'ImageSize' },
	'thumbnailimagetype' => { 147 => '0Type' },
	'thumbnailimagevalidarea' => { 55 => 0x13 },
	'thumbnaillength' => { 106 => 0x202 },
	'thumbnailoffset' => { 106 => 0x201 },
	'thumbnails' => { 428 => 'Thumbnails' },
	'thumbnailwidth' => { 124 => 0xfa54, 428 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 420 => 'ticker' },
	'tiffhandling' => { 406 => 'TIFFHandling' },
	'tiffmeteringimage' => { 164 => 0x104c, 361 => 0x1110 },
	'tilelength' => { 106 => 0x143 },
	'tilewidth' => { 106 => 0x142 },
	'time' => { 120 => 0x401, 308 => 0x7 },
	'timecodes' => { 106 => 0xc763 },
	'timecreated' => { 114 => 0x3c, 122 => 0x14, 131 => 0x10, 320 => 'TimeCreated' },
	'timeperiod' => { 420 => 'timePeriod' },
	'timerfunctionbutton' => { 242 => '5.2', 244 => '12.1', 245 => '13.1' },
	'timerlength' => { 73 => 0x80c },
	'timerrecording' => { 275 => 0x96 },
	'timescaleparams' => { 430 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 430 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 430 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 430 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 115 => 0x50 },
	'timesignature' => { 430 => 'timeSignature' },
	'timesincepoweron' => { 275 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 253 => 0x8, 267 => 'TimeStamp', 401 => 'Timestamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 68 => 0x1, 225 => 0x0, 336 => 0xa },
	'timezonecity' => { 68 => 0x2 },
	'timezonecode' => { 89 => 0x1 },
	'timezoneinfo' => { 89 => 0x2 },
	'timezoneoffset' => { 106 => 0x882a },
	'tint' => { 406 => 'Tint' },
	'title' => { 137 => 'Title', 263 => 'Title', 267 => 'Title', 275 => 0x65, 324 => 'Title', 407 => 'title', 417 => 'Title', 428 => 'Title' },
	'tonecomp' => { 195 => 0x81 },
	'tonecurve' => { 65 => 0x1, 308 => 0x402, 406 => 'ToneCurve' },
	'tonecurveactive' => { 97 => 0x110 },
	'tonecurveadobergb' => { 339 => 0xa043 },
	'tonecurveadobergbdefault' => { 339 => 0xa041 },
	'tonecurveblue' => { 406 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 391 => 0x9003 },
	'tonecurvebluey' => { 391 => 0x9007 },
	'tonecurvebrightness' => { 92 => 0x20410 },
	'tonecurvebrightnessx' => { 391 => 0x9000 },
	'tonecurvebrightnessy' => { 391 => 0x9004 },
	'tonecurvecolorspace' => { 96 => 0x0 },
	'tonecurvecontrast' => { 92 => 0x20411 },
	'tonecurvefilename' => { 120 => 0x1391 },
	'tonecurvegreen' => { 406 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 391 => 0x9002 },
	'tonecurvegreeny' => { 391 => 0x9006 },
	'tonecurveinputrange' => { 96 => 0x3 },
	'tonecurveinterpolation' => { 97 => 0x159 },
	'tonecurvemode' => { 97 => 0x113 },
	'tonecurvename' => { 406 => 'ToneCurveName' },
	'tonecurvename2012' => { 406 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 92 => '0x20400.1' },
	'tonecurveoutputrange' => { 96 => 0x5 },
	'tonecurveproperty' => { 97 => 0x3c },
	'tonecurvepv2012' => { 406 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 406 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 406 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 406 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 406 => 'ToneCurveRed' },
	'tonecurveredx' => { 391 => 0x9001 },
	'tonecurveredy' => { 391 => 0x9005 },
	'tonecurves' => { 308 => 0x403 },
	'tonecurveshape' => { 96 => 0x1 },
	'tonecurvesrgb' => { 339 => 0xa042 },
	'tonecurvesrgbdefault' => { 339 => 0xa040 },
	'tonecurvex' => { 96 => 0xa },
	'tonecurvey' => { 96 => 0xb },
	'tonelevel' => { 254 => 0x52e },
	'tonemapstrength' => { 406 => 'ToneMapStrength' },
	'toningeffect' => { 49 => 0xf, 195 => 0xb3, 197 => 0x38, 198 => 0x40, 333 => 0x1015 },
	'toningeffectauto' => { 62 => 0xa4 },
	'toningeffectfaithful' => { 61 => 0x74, 62 => 0x74 },
	'toningeffectlandscape' => { 61 => 0x44, 62 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 61 => 0x8c, 62 => 0x8c },
	'toningeffectneutral' => { 61 => 0x5c, 62 => 0x5c },
	'toningeffectportrait' => { 61 => 0x2c, 62 => 0x2c },
	'toningeffectstandard' => { 61 => 0x14, 62 => 0x14 },
	'toningeffectuserdef1' => { 61 => 0xa4, 62 => 0xbc },
	'toningeffectuserdef2' => { 61 => 0xbc, 62 => 0xd4 },
	'toningeffectuserdef3' => { 61 => 0xd4, 62 => 0xec },
	'toningsaturation' => { 197 => 0x39, 198 => 0x41 },
	'totalzoom' => { 122 => 0x62 },
	'touchae' => { 275 => 0xab },
	'trackcreatedate' => { 328 => 0x1 },
	'trackmodifydate' => { 328 => 0x2 },
	'tracknumber' => { 430 => 'trackNumber' },
	'tracks' => { 430 => 'Tracks' },
	'tracksframerate' => { 430 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 430 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 430 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 430 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 430 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 430 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 430 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 430 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 430 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 430 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 430 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 430 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 430 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 430 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 430 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 430 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 430 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 144 => 'zmie' },
	'transferfunction' => { 106 => 0x12d, 426 => 'TransferFunction' },
	'transform' => { 275 => [0x8012,0x59] },
	'transmissionreference' => { 418 => 'TransmissionReference' },
	'trapped' => { 263 => 'Trapped', 417 => 'Trapped' },
	'trashbuttonfunction' => { 73 => 0x710 },
	'travelday' => { 275 => 0x36 },
	'triggermode' => { 329 => 0x6 },
	'tstop' => { 106 => 0xc772 },
	'ttl_da_adown' => { 296 => 0x5 },
	'ttl_da_aup' => { 296 => 0x4 },
	'ttl_da_bdown' => { 296 => 0x7 },
	'ttl_da_bup' => { 296 => 0x6 },
	'tungstenawb' => { 286 => 0x1 },
	'tvexposuretimesetting' => { 289 => 0x12 },
	'type' => { 407 => 'type', 425 => 'type' },
	'typestatus' => { 105 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 106 => 0xc614 },
	'uniquedocumentid' => { 114 => 0xbb },
	'uniqueobjectname' => { 115 => 0x64 },
	'unknownblock' => { 308 => 0x405 },
	'unknownblock1' => { 258 => 0x635 },
	'unknownblock2' => { 258 => 0x636 },
	'unknownblock3' => { 258 => 0x1103 },
	'unknownblock4' => { 258 => 0x1104 },
	'unknowncontrast' => { 98 => 0x45 },
	'unknowndate' => { 317 => 0x212 },
	'unknownev' => { 120 => 0x1 },
	'unknownlinear' => { 98 => 0x46 },
	'unknownnumber' => { 86 => 0x180b },
	'unknownoutputhighlightpoint' => { 98 => 0x4a },
	'unknownoutputshadowpoint' => { 98 => 0x4b },
	'unknownrawhighlight' => { 98 => 0x7b },
	'unknownrawhighlightpoint' => { 98 => 0x48 },
	'unknownrawshadow' => { 98 => 0x84 },
	'unknownrawshadowpoint' => { 98 => 0x49 },
	'unknownsharpness' => { 98 => 0x47 },
	'unknowntemperature' => { 108 => 0x4 },
	'unsharp1color' => { 238 => 0x13 },
	'unsharp1halowidth' => { 238 => 0x19 },
	'unsharp1intensity' => { 238 => 0x17 },
	'unsharp1threshold' => { 238 => 0x1b },
	'unsharp2color' => { 238 => 0x2e },
	'unsharp2halowidth' => { 238 => 0x34 },
	'unsharp2intensity' => { 238 => 0x32 },
	'unsharp2threshold' => { 238 => 0x36 },
	'unsharp3color' => { 238 => 0x49 },
	'unsharp3halowidth' => { 238 => 0x4f },
	'unsharp3intensity' => { 238 => 0x4d },
	'unsharp3threshold' => { 238 => 0x51 },
	'unsharp4color' => { 238 => 0x64 },
	'unsharp4halowidth' => { 238 => 0x6a },
	'unsharp4intensity' => { 238 => 0x68 },
	'unsharp4threshold' => { 238 => 0x6c },
	'unsharpcount' => { 238 => 0x0 },
	'unsharpmask' => { 98 => 0x90, 233 => 0x76a43200 },
	'unsharpmaskfineness' => { 92 => 0x20309 },
	'unsharpmaskstrength' => { 92 => 0x20308 },
	'unsharpmaskthreshold' => { 92 => 0x2030a },
	'uprightcentermode' => { 406 => 'UprightCenterMode' },
	'uprightcenternormx' => { 406 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 406 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 406 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 406 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 406 => 'UprightFocalMode' },
	'uprightpreview' => { 406 => 'UprightPreview' },
	'uprighttransform_0' => { 406 => 'UprightTransform_0' },
	'uprighttransform_1' => { 406 => 'UprightTransform_1' },
	'uprighttransform_2' => { 406 => 'UprightTransform_2' },
	'uprighttransform_3' => { 406 => 'UprightTransform_3' },
	'uprighttransform_4' => { 406 => 'UprightTransform_4' },
	'uprighttransformcount' => { 406 => 'UprightTransformCount' },
	'uprightversion' => { 406 => 'UprightVersion' },
	'urgency' => { 114 => 0xa, 418 => 'Urgency' },
	'url' => { 137 => 'URL', 267 => 'URL', 322 => 0x40b, 420 => 'url' },
	'url_list' => { 322 => 0x41e },
	'urla-platform' => { 420 => [\'url','urlA-platform'] },
	'urlurl' => { 420 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 73 => 0x10a },
	'usableshootingmodes' => { 73 => 0x109 },
	'usage' => { 421 => 'usage' },
	'usageterms' => { 434 => 'UsageTerms' },
	'useguidelines' => { 403 => 'useGuidelines' },
	'usepanoramaviewer' => { 395 => 'UsePanoramaViewer' },
	'usercomment' => { 86 => 0x805, 106 => 0x9286, 410 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 61 => 0xd8, 62 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 61 => 0xda, 62 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 61 => 0xdc, 62 => 0xf4 },
	'userfields' => { 398 => 'UserFields' },
	'userlabel' => { 329 => 0x2b },
	'userprofile' => { 271 => 0x302, 277 => 0x3038 },
	'usmlenselectronicmf' => { 72 => 0x7, 73 => 0x501 },
	'uspsnumber' => { 420 => 'uspsNumber' },
	'utmeasting' => { 148 => 'Easting' },
	'utmmapdatum' => { 148 => 'Datum' },
	'utmnorthing' => { 148 => 'Northing' },
	'utmzone' => { 148 => 'Zone' },
	'uv-irfiltercorrection' => { 271 => 0x325 },
	'validbits' => { 258 => 0x611, 259 => 0x102c },
	'validpixeldepth' => { 262 => 0x611 },
	'variousmodes' => { 122 => 0x26 },
	'variousmodes2' => { 122 => 0x3a },
	'variprogram' => { 195 => 0xab },
	'version' => { 111 => 0x0, 324 => 'Version', 406 => 'Version' },
	'versioncreatedate' => { 391 => 0xd100 },
	'versionid' => { 431 => 'VersionID' },
	'versionidentifier' => { 420 => 'versionIdentifier' },
	'versionmodifydate' => { 391 => 0xd101 },
	'versions' => { 431 => 'Versions' },
	'versionscomments' => { 431 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 431 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 431 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 431 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 431 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 431 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 431 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 431 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 431 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 431 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 431 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 240 => '3.2', 241 => '47.2' },
	'verticalfuncbutton' => { 241 => '42.2' },
	'verticalfuncbuttonplusdials' => { 241 => '43.1' },
	'verticalmultiselector' => { 241 => '42.1', 243 => '66.1' },
	'vfdisplayillumination' => { 73 => [0x510,0x51d] },
	'vibrance' => { 399 => 'Vibrance', 406 => 'Vibrance' },
	'vibrationreduction' => { 203 => [0x75,0x82,0x1ae], 211 => '586.1', 219 => '590.2', 224 => 0x4 },
	'videoalphamode' => { 430 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 430 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 430 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 430 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 58 => 0x74 },
	'videocolorspace' => { 430 => 'videoColorSpace' },
	'videocompressor' => { 430 => 'videoCompressor' },
	'videofieldorder' => { 430 => 'videoFieldOrder' },
	'videoframerate' => { 430 => 'videoFrameRate' },
	'videoframesize' => { 430 => 'videoFrameSize' },
	'videoframesizeh' => { 430 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 430 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 430 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 430 => 'videoModDate' },
	'videopixelaspectratio' => { 430 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 430 => 'videoPixelDepth' },
	'videoquality' => { 102 => 0x4003 },
	'viewfinderdisplay' => { 240 => '12.4', 241 => '6.3' },
	'viewfinderwarning' => { 240 => '13.4', 248 => '3.5', 249 => '6.2', 252 => '4.4' },
	'viewfinderwarnings' => { 73 => 0x40a },
	'viewinfoduringexposure' => { 73 => 0x407 },
	'viewingmode' => { 352 => 0x2f, 366 => 0x18 },
	'viewingmode2' => { 352 => [0x85,0x285] },
	'viewpoint' => { 419 => 'viewpoint' },
	'vignetteamount' => { 406 => 'VignetteAmount' },
	'vignettecontrol' => { 195 => 0x2a, 233 => 0x76a43205 },
	'vignettecontrolintensity' => { 233 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 402 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 406 => 'VignetteMidpoint' },
	'vignetting' => { 333 => 0x1011, 339 => 0xa052 },
	'vignettingcorrection' => { 339 => 0xa053, 362 => 0x2011 },
	'vignettingsetting' => { 339 => 0xa054 },
	'visualtechnique' => { 419 => 'visualTechnique' },
	'voicememo' => { 341 => 0x216 },
	'volume' => { 420 => 'volume' },
	'vr_0x66' => { 203 => 0x66 },
	'vrdoffset' => { 55 => 0xd0 },
	'vrmode' => { 224 => 0x6 },
	'wb_bluelevel3500k' => { 164 => 0x19a },
	'wb_bluelevel6500k' => { 164 => 0x18a },
	'wb_bluelevelcustom' => { 164 => 0x18e },
	'wb_bluelevelscloudy' => { 164 => 0x106 },
	'wb_bluelevelsdaylight' => { 164 => 0xea },
	'wb_bluelevelsflash' => { 164 => 0x122 },
	'wb_bluelevelsfluorescent' => { 164 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 164 => 0x254 },
	'wb_bluelevelsshade' => { 164 => 0x176 },
	'wb_bluelevelstungsten' => { 164 => 0xce },
	'wb_gbrglevels' => { 164 => 0xae, 167 => 0x4 },
	'wb_glevel' => { 258 => 0x11f },
	'wb_glevel3000k' => { 258 => 0x113 },
	'wb_glevel3300k' => { 258 => 0x114 },
	'wb_glevel3600k' => { 258 => 0x115 },
	'wb_glevel3900k' => { 258 => 0x116 },
	'wb_glevel4000k' => { 258 => 0x117 },
	'wb_glevel4300k' => { 258 => 0x118 },
	'wb_glevel4500k' => { 258 => 0x119 },
	'wb_glevel4800k' => { 258 => 0x11a },
	'wb_glevel5300k' => { 258 => 0x11b },
	'wb_glevel6000k' => { 258 => 0x11c },
	'wb_glevel6600k' => { 258 => 0x11d },
	'wb_glevel7500k' => { 258 => 0x11e },
	'wb_grbglevels' => { 177 => 0x0 },
	'wb_rbgglevels' => { 174 => 0x0 },
	'wb_rblevels' => { 195 => 0xc, 258 => 0x100 },
	'wb_rblevels1' => { 280 => 0x2 },
	'wb_rblevels2' => { 280 => 0x5 },
	'wb_rblevels3' => { 280 => 0x8 },
	'wb_rblevels3000k' => { 258 => 0x102 },
	'wb_rblevels3300k' => { 258 => 0x103 },
	'wb_rblevels3500k' => { 164 => 0x430 },
	'wb_rblevels3600k' => { 258 => 0x104 },
	'wb_rblevels3900k' => { 258 => 0x105 },
	'wb_rblevels4' => { 280 => 0xb },
	'wb_rblevels4000k' => { 258 => 0x106 },
	'wb_rblevels4300k' => { 258 => 0x107 },
	'wb_rblevels4500k' => { 258 => 0x108 },
	'wb_rblevels4800k' => { 258 => 0x109 },
	'wb_rblevels5' => { 280 => 0xe },
	'wb_rblevels5300k' => { 258 => 0x10a },
	'wb_rblevels6' => { 280 => 0x11 },
	'wb_rblevels6000k' => { 258 => 0x10b },
	'wb_rblevels6500k' => { 164 => 0x420 },
	'wb_rblevels6600k' => { 258 => 0x10c },
	'wb_rblevels7' => { 280 => 0x14 },
	'wb_rblevels7500k' => { 258 => 0x10d },
	'wb_rblevelsauto' => { 262 => 0x110 },
	'wb_rblevelscloudy' => { 164 => 0x3f0, 166 => 0x10, 262 => 0x121 },
	'wb_rblevelscoolwhitef' => { 164 => 0x308, 166 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 262 => 0x132 },
	'wb_rblevelscustom' => { 164 => 0x424 },
	'wb_rblevelscwb1' => { 258 => 0x10e },
	'wb_rblevelscwb2' => { 258 => 0x10f },
	'wb_rblevelscwb3' => { 258 => 0x110 },
	'wb_rblevelscwb4' => { 258 => 0x111 },
	'wb_rblevelsdaylight' => { 164 => [0x3ec,0x528], 166 => 0xc },
	'wb_rblevelsdaylightf' => { 166 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 262 => 0x130 },
	'wb_rblevelsdaywhitef' => { 166 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 262 => 0x131 },
	'wb_rblevelseveningsunlight' => { 262 => 0x124 },
	'wb_rblevelsfineweather' => { 262 => 0x122 },
	'wb_rblevelsflash' => { 164 => [0x3f4,0x304], 166 => 0x18 },
	'wb_rblevelsshade' => { 164 => 0x418, 166 => 0x20, 262 => 0x120 },
	'wb_rblevelstungsten' => { 164 => 0x3e8, 166 => 0x8, 262 => 0x123 },
	'wb_rblevelsunknown' => { 166 => 0x1c },
	'wb_rblevelsused' => { 262 => 0x100 },
	'wb_rblevelswhitef' => { 166 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 262 => 0x133 },
	'wb_redlevel3500k' => { 164 => 0x198 },
	'wb_redlevel6500k' => { 164 => 0x188 },
	'wb_redlevelcustom' => { 164 => 0x18c },
	'wb_redlevelscloudy' => { 164 => 0xf8 },
	'wb_redlevelsdaylight' => { 164 => 0xdc },
	'wb_redlevelsflash' => { 164 => 0x114 },
	'wb_redlevelsfluorescent' => { 164 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 164 => 0x1be },
	'wb_redlevelsshade' => { 164 => 0x168 },
	'wb_redlevelstungsten' => { 164 => 0xc0 },
	'wb_rgbglevels' => { 176 => 0x0 },
	'wb_rgblevels' => { 164 => [0x546,0x96], 272 => 0xd, 273 => 0x413, 277 => 0x3036, 317 => 0x107, 369 => 0x117c, 370 => 0x1180, 371 => 0x115c, 372 => 0x11d8, 373 => 0x11b4, 374 => 0x106c, 375 => 0x264, 376 => 0x264 },
	'wb_rgblevels1' => { 281 => 0x2 },
	'wb_rgblevels2' => { 281 => 0x6 },
	'wb_rgblevels3' => { 281 => 0xa },
	'wb_rgblevels4' => { 281 => 0xe },
	'wb_rgblevels5' => { 281 => 0x12 },
	'wb_rgblevels6' => { 281 => 0x16 },
	'wb_rgblevels7' => { 281 => 0x1a },
	'wb_rggbblacklevels' => { 32 => 0x25 },
	'wb_rggblevels' => { 167 => 0x4, 175 => 0x0 },
	'wb_rggblevelsasshot' => { 34 => 0x0, 35 => 0x19, 36 => 0x22, 37 => 0x3f, 40 => 0x3f, 41 => 0x3f, 42 => 0x3f },
	'wb_rggblevelsauto' => { 32 => 0x1, 34 => 0x5, 35 => 0x1e, 36 => 0x18, 37 => 0x44, 40 => 0x44, 41 => 0x44, 42 => 0x44, 339 => 0xa022 },
	'wb_rggblevelsblack' => { 339 => 0xa028 },
	'wb_rggblevelscloudy' => { 32 => 0xd, 34 => 0x1e, 35 => 0x2d, 36 => 0x31, 37 => 0x58, 40 => 0x71, 41 => 0x8a, 42 => 0x8f, 308 => 0x20f, 316 => 0x14 },
	'wb_rggblevelscustom' => { 32 => 0x1d, 37 => 0x80 },
	'wb_rggblevelscustom1' => { 35 => 0x41 },
	'wb_rggblevelscustom2' => { 35 => 0x46 },
	'wb_rggblevelsdaylight' => { 32 => 0x5, 34 => 0x14, 35 => 0x23, 36 => 0x27, 37 => 0x4e, 40 => 0x67, 41 => 0x80, 42 => 0x85, 308 => 0x20d, 316 => 0x2 },
	'wb_rggblevelsflash' => { 32 => 0x19, 34 => 0x32, 35 => 0x3c, 36 => 0x45, 37 => 0x6c, 40 => 0x85, 41 => 0x9e, 42 => 0xa3, 308 => 0x214, 316 => 0x41 },
	'wb_rggblevelsfluorescent' => { 32 => 0x15, 34 => 0x28, 35 => 0x37, 36 => 0x3b, 37 => 0x62, 40 => 0x7b, 41 => 0x94, 42 => 0x99 },
	'wb_rggblevelsfluorescentd' => { 308 => 0x211, 316 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 316 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 308 => 0x212, 316 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 308 => 0x213, 316 => 0x38 },
	'wb_rggblevelsilluminator1' => { 339 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 339 => 0xa024 },
	'wb_rggblevelskelvin' => { 32 => 0x21, 34 => 0x2d, 36 => 0x40, 37 => 0x67, 40 => 0x80, 41 => 0x99, 42 => 0x9e },
	'wb_rggblevelsmeasured' => { 34 => 0xa, 37 => 0x49, 40 => 0x49, 41 => 0x49, 42 => 0x49 },
	'wb_rggblevelspc1' => { 36 => 0x90, 37 => 0x71 },
	'wb_rggblevelspc2' => { 36 => 0x95, 37 => 0x76 },
	'wb_rggblevelspc3' => { 36 => 0x9a, 37 => 0x7b },
	'wb_rggblevelsshade' => { 32 => 0x9, 34 => 0x19, 35 => 0x28, 36 => 0x2c, 37 => 0x53, 40 => 0x6c, 41 => 0x85, 42 => 0x8a, 308 => 0x20e, 316 => 0xb },
	'wb_rggblevelstungsten' => { 32 => 0x11, 34 => 0x23, 35 => 0x32, 36 => 0x36, 37 => 0x5d, 40 => 0x76, 41 => 0x8f, 42 => 0x94, 308 => 0x210, 316 => 0x1d },
	'wb_rggblevelsuncorrected' => { 339 => 0xa021 },
	'wb_rggblevelsunknown' => { 34 => 0xf, 36 => 0x1d, 40 => 0x4e, 41 => 0x4e, 42 => 0x4e, 316 => 0x53 },
	'wb_rggblevelsunknown10' => { 34 => 0x5f, 36 => 0x72, 40 => 0x9e, 41 => 0x7b, 42 => 0x7b },
	'wb_rggblevelsunknown11' => { 34 => 0x64, 36 => 0x77, 40 => 0xa3, 41 => 0xa3, 42 => 0x80 },
	'wb_rggblevelsunknown12' => { 34 => 0x69, 36 => 0x7c, 40 => 0xa8, 41 => 0xa8, 42 => 0xa8 },
	'wb_rggblevelsunknown13' => { 34 => 0x6e, 36 => 0x81, 40 => 0xad, 41 => 0xad, 42 => 0xad },
	'wb_rggblevelsunknown14' => { 36 => 0x86, 40 => 0xb2, 41 => 0xb2, 42 => 0xb2 },
	'wb_rggblevelsunknown15' => { 36 => 0x8b, 40 => 0xb7, 41 => 0xb7, 42 => 0xb7 },
	'wb_rggblevelsunknown16' => { 36 => 0x9f, 41 => 0xbc, 42 => 0xbc },
	'wb_rggblevelsunknown17' => { 41 => 0xc1, 42 => 0xc1 },
	'wb_rggblevelsunknown18' => { 41 => 0xc6, 42 => 0xc6 },
	'wb_rggblevelsunknown19' => { 41 => 0xcb, 42 => 0xcb },
	'wb_rggblevelsunknown2' => { 34 => 0x37, 36 => 0x4a, 40 => 0x53, 41 => 0x53, 42 => 0x53 },
	'wb_rggblevelsunknown20' => { 41 => 0xd0, 42 => 0xd0 },
	'wb_rggblevelsunknown21' => { 42 => 0xd5 },
	'wb_rggblevelsunknown22' => { 42 => 0xda },
	'wb_rggblevelsunknown23' => { 42 => 0xdf },
	'wb_rggblevelsunknown24' => { 42 => 0xe4 },
	'wb_rggblevelsunknown25' => { 42 => 0xe9 },
	'wb_rggblevelsunknown26' => { 42 => 0xee },
	'wb_rggblevelsunknown27' => { 42 => 0xf3 },
	'wb_rggblevelsunknown28' => { 42 => 0xf8 },
	'wb_rggblevelsunknown29' => { 42 => 0xfd },
	'wb_rggblevelsunknown3' => { 34 => 0x3c, 36 => 0x4f, 40 => 0x58, 41 => 0x58, 42 => 0x58 },
	'wb_rggblevelsunknown30' => { 42 => 0x102 },
	'wb_rggblevelsunknown4' => { 34 => 0x41, 36 => 0x54, 40 => 0x5d, 41 => 0x5d, 42 => 0x5d },
	'wb_rggblevelsunknown5' => { 34 => 0x46, 36 => 0x59, 40 => 0x62, 41 => 0x62, 42 => 0x62 },
	'wb_rggblevelsunknown6' => { 34 => 0x4b, 36 => 0x5e, 40 => 0x8a, 41 => 0x67, 42 => 0x67 },
	'wb_rggblevelsunknown7' => { 34 => 0x50, 36 => 0x63, 40 => 0x8f, 41 => 0x6c, 42 => 0x6c },
	'wb_rggblevelsunknown8' => { 34 => 0x55, 36 => 0x68, 40 => 0x94, 41 => 0x71, 42 => 0x71 },
	'wb_rggblevelsunknown9' => { 34 => 0x5a, 36 => 0x6d, 40 => 0x99, 41 => 0x76, 42 => 0x76 },
	'wb_rggblevelsuserselected' => { 316 => 0x5c },
	'wbadjblueamber' => { 92 => 0x20106 },
	'wbadjbluebalance' => { 239 => 0x8 },
	'wbadjcolortemp' => { 92 => 0x20102, 97 => 0x1a },
	'wbadjlighting' => { 239 => 0x14 },
	'wbadjmagentagreen' => { 92 => 0x20105 },
	'wbadjmode' => { 239 => 0x10 },
	'wbadjredbalance' => { 239 => 0x0 },
	'wbadjrggblevels' => { 92 => 0x20125, 97 => 0x6 },
	'wbadjtemperature' => { 239 => 0x18 },
	'wbadjtint' => { 239 => 0x25 },
	'wbbluelevel' => { 271 => 0x324, 275 => 0x8006, 279 => 0x26 },
	'wbbracketingsteps' => { 212 => 0x174d, 213 => 0x87c, 221 => 0x1757 },
	'wbbracketmode' => { 49 => 0x9 },
	'wbbracketshotnumber' => { 164 => 0x2b, 333 => 0x101a },
	'wbbracketvalueab' => { 49 => 0xc },
	'wbbracketvaluegm' => { 49 => 0xd },
	'wbfinetuneactive' => { 97 => 0x24 },
	'wbfinetunesaturation' => { 97 => 0x28 },
	'wbfinetunetone' => { 97 => 0x2c },
	'wbgreenlevel' => { 271 => 0x323, 275 => 0x8005, 279 => 0x25 },
	'wbmediaimagesizesetting' => { 73 => 0x708 },
	'wbmode' => { 166 => 0x4, 259 => 0x1015 },
	'wbredlevel' => { 271 => 0x322, 275 => 0x8004, 279 => 0x24 },
	'wbscale' => { 167 => 0x0 },
	'wbshiftab' => { 65 => 0xc, 275 => 0x46, 290 => 0x10 },
	'wbshiftab_gm' => { 362 => 0x2014 },
	'wbshiftab_gm_precise' => { 362 => 0x2026 },
	'wbshiftgm' => { 65 => 0xd, 275 => 0x47, 290 => 0x11 },
	'wbtype1' => { 280 => 0x1, 281 => 0x1 },
	'wbtype2' => { 280 => 0x4, 281 => 0x5 },
	'wbtype3' => { 280 => 0x7, 281 => 0x9 },
	'wbtype4' => { 280 => 0xa, 281 => 0xd },
	'wbtype5' => { 280 => 0xd, 281 => 0x11 },
	'wbtype6' => { 280 => 0x10, 281 => 0x15 },
	'wbtype7' => { 280 => 0x13, 281 => 0x19 },
	'webstatement' => { 434 => 'WebStatement' },
	'what' => { 406 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x77, 65 => 0x8, 67 => 0x7, 101 => 0x7, 102 => [0x19,0x2012], 106 => [0xa403,0xfe4e], 111 => 0x1002, 120 => 0x3fc, 121 => 0xfa0d, 122 => 0x40, 158 => 0x3, 159 => 0xe, 160 => 0x4, 161 => 0xb, 163 => 0x115, 195 => 0x5, 223 => 0x7, 271 => 0x304, 275 => 0x3, 277 => 0x3033, 308 => 0x19, 315 => 0x7, 332 => 0x26, 333 => 0x1003, 342 => [0x3c,0x7,0x58], 350 => 0xf, 351 => 0xe, 362 => [0x115,0xb054], 406 => 'WhiteBalance', 410 => 'WhiteBalance' },
	'whitebalance0' => { 154 => 'WhiteBalance0' },
	'whitebalance1' => { 154 => 'WhiteBalance1' },
	'whitebalance2' => { 154 => 'WhiteBalance2', 254 => 0x500 },
	'whitebalanceadj' => { 92 => 0x20101, 97 => 0x18, 233 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 286 => 0x0 },
	'whitebalancebias' => { 102 => 0x2011, 259 => 0x304, 275 => 0x23 },
	'whitebalanceblue' => { 65 => 0x7 },
	'whitebalancebracket' => { 254 => 0x502, 259 => 0x303 },
	'whitebalancebracketing' => { 161 => 0x22, 164 => 0x2c, 361 => 0x2c },
	'whitebalancecomp' => { 262 => 0x1001 },
	'whitebalancefinetune' => { 111 => 0x100a, 161 => 0x38, 163 => 0x112, 195 => 0xb, 333 => 0x1004, 350 => 0x6, 351 => 0x5, 362 => 0x112 },
	'whitebalancemode' => { 308 => 0x1a },
	'whitebalancered' => { 65 => 0x6 },
	'whitebalanceset' => { 289 => 0xa },
	'whitebalancesetting' => { 161 => 0x23, 350 => 0x5, 351 => 0x4, 352 => 0x16, 366 => 0xd },
	'whitebalancetemperature' => { 254 => 0x501 },
	'whiteboard' => { 259 => 0x301 },
	'whitelevel' => { 106 => 0xc61d, 308 => 0x7e },
	'whitepoint' => { 106 => 0x13e, 308 => 0x201, 426 => 'WhitePoint' },
	'whites2012' => { 406 => 'Whites2012' },
	'wideadapter' => { 333 => 0x1017 },
	'widefocuszone' => { 158 => 0x2f },
	'widerange' => { 341 => 0x20f },
	'windowsatom' => { 405 => 'windowsAtom' },
	'windowsatomextension' => { 405 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 405 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 405 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 420 => 'wordCount' },
	'workcolorspace' => { 92 => 0x10200, 97 => 0x270 },
	'worktodo' => { 412 => 'WorkToDo' },
	'worldtimelocation' => { 275 => 0x3a, 308 => 0x22, 314 => '0.1' },
	'writer-editor' => { 114 => 0x7a },
	'x3filllight' => { 342 => 0x12 },
	'xml' => { 118 => 'xml ' },
	'xmp' => { 95 => 0xffff00f6, 107 => 'XMP' },
	'xmptoolkit' => { 427 => 'xmptk' },
	'xpauthor' => { 106 => 0x9c9d },
	'xpcomment' => { 106 => 0x9c9c },
	'xpkeywords' => { 106 => 0x9c9e },
	'xposition' => { 106 => 0x11e },
	'xpsubject' => { 106 => 0x9c9f },
	'xptitle' => { 106 => 0x9c9b },
	'xresolution' => { 106 => 0x11a, 117 => 0x3, 323 => 0x0, 426 => 'XResolution' },
	'xyresolution' => { 110 => 0x3 },
	'yawangle' => { 212 => 0x3513, 221 => 0x36fc },
	'ycbcrcoefficients' => { 106 => 0x211, 426 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 106 => 0x213, 426 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 106 => 0x212, 426 => 'YCbCrSubSampling' },
	'yearcreated' => { 122 => 0x10, 131 => 0xc },
	'yield' => { 422 => 'yield' },
	'yposition' => { 106 => 0x11f },
	'yresolution' => { 106 => 0x11b, 117 => 0x5, 323 => 0x4, 426 => 'YResolution' },
	'zonematching' => { 163 => 0x10a, 166 => [0x3a,0x4a], 362 => 0xb024 },
	'zonematchingmode' => { 161 => 0x14 },
	'zonematchingon' => { 160 => 0x75 },
	'zonematchingvalue' => { 350 => 0x1f },
	'zoomedpreviewlength' => { 259 => 0xf05 },
	'zoomedpreviewsize' => { 259 => 0xf06 },
	'zoomedpreviewstart' => { 259 => 0xf04 },
	'zoomsourcewidth' => { 31 => 0x24 },
	'zoomstepcount' => { 257 => 0x300, 259 => 0x100d },
	'zoomtargetwidth' => { 31 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationcorrparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioncorrparams' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filegroupid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileuserid' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammainfo' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemtags' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelshiftinfo' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawfiletype' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'serialnumberhash' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'variablelowpassfilter' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName || $field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2016, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
