<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/integrations/asp.net.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/metadata.yaml"
sidebar_label: "ASP.NET"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Windows Systems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# ASP.NET


<img src="https://netdata.cloud/img/windows.svg" width="150"/>


Plugin: windows.plugin
Module: PerflibASP

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors ASP.NET applications.


It queries for the 'ASP.NET' and 'ASP.NET Applications' objects from Perflib in order to gather the metrics.


This collector is only supported on the following platforms:

- windows

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The collector automatically detects all of the metrics, no further configuration is required.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per ASP.NET Global Data

These metrics refer to ASP.NET global metrics.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| aspnet.application_restarts | restarts | restarts |
| aspnet.worker_process_restarts | restarts | restarts |

### Per ASP.NET Applications

ASP.NET application performance counters

Labels:

| Label      | Description     |
|:-----------|:----------------|
| aspnet_app | The application name. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| aspnet.anonymous_request | requests | requests |
| aspnet.compilation_totals | compilations | compilations |
| aspnet.errors_during_preprocessing | preprocessing | errors |
| aspnet.errors_during_compilation | compilation | errors |
| aspnet.errors_during_execution | execution | errors |
| aspnet.errors_during_unhandled_execution | unhandled | errors |
| aspnet.requests_byte_total | in, out | bytes |
| aspnet.requests_executing | executing | requests |
| aspnet.requests_failed | executing | requests |
| aspnet.requests_not_found | not found | requests |
| aspnet.requests_in_application_queue | queue | requests |
| aspnet.requests_timeout | timeout | requests |
| aspnet.requests_succeeded | success | requests |
| aspnet.sessions_active | active | sessions |
| aspnet.sessions_abandoned | abandoned | sessions |
| aspnet.sessions_abandoned | abandoned | sessions |
| aspnet.sessions_timed_out | timed out | sessions |
| aspnet.transactions_aborted | aborted | transactions |
| aspnet.transactions_committed | committed | transactions |
| aspnet.transactions_pending | pending | transactions |
| aspnet.events_raised_per_sec | raised | events |
| aspnet.error_events_raised_per_sec | events | errors |
| aspnet.events_audit_success | events | errors |
| aspnet.events_audit_failure | audit | failures |
| aspnet.membership_auth_success | success | auth |
| aspnet.form_authentication_success | success | auth |
| aspnet.form_authentication_success | success | auth |
| aspnet.form_authentication_failure | failure | auth |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:windows]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options



| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| PerflibASP | An option to enable or disable the data collection. | yes | no |

#### Examples
There are no configuration examples.


