/* This file is part of HSPlasma.
 *
 * HSPlasma is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * HSPlasma is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HSPlasma.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pdUnifiedTypeMap.h"
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include "Debug/hsExceptions.hpp"
#include "Debug/plDebug.h"

const short pdUnifiedTypeMap::fUruM2PTable[TYPESPACE_MAX] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008,
    0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 0x0010, 0x0011,
    0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x001A,
    0x001B, 0x001C, 0x009B, 0x001E, 0x001F, 0x0020, 0x0021, 0x0022, 0x0023,
    0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002A, 0x002B, 0x002C,
    0x002D, 0x002E, 0x002F, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035,
    0x0036, 0x0037, 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E,
    0x003F, 0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050,
    0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059,
    0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F, 0x0060, 0x0061, 0x0062,
    0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B,
    0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073, 0x0074,
    0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D,
    0x007E, 0x007F, 0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086,
    0x0087, 0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 0x0098,
    0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F, 0x00A0, 0x00A1,
    0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7, 0x00A8, 0x00A9, 0x00AA,
    0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF, 0x00B0, 0x00B1, 0x00B2, 0x00B3,
    0x00B4, 0x00B5, 0x00B6, 0x00B7, 0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC,
    0x00BD, 0x00BE, 0x00BF, 0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5,
    0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE,
    0x00CF, 0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF, 0x00E0,
    0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9,
    0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F0, 0x00F1, 0x00F2,
    0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB,
    0x00FC, 0x00FD, 0x00FE, 0x00FF, 0x0100, 0x0101, 0x0102, 0x0103, 0x0104,
    0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010A, 0x010B, 0x010C, 0x010D,
    0x010E, 0x010F, 0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116,
    0x0117, 0x0118, 0x0119, 0x011A, 0x011B, 0x011C, 0x011D, 0x011E, 0x011F,
    0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 0x0128,
    0x0129, 0x012A, 0x012B, 0x012C, 0x012D, 0x012E,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

    0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207, 0x0208,
    0x0209, 0x020A, 0x020B, 0x020C, 0x020D, 0x020E, 0x020F, 0x0210, 0x0211,
    0x0212, 0x0213, 0x0214, 0x0215,     -1, 0x0217, 0x0218, 0x0219, 0x021A,
    0x021B, 0x021C, 0x021D, 0x021E, 0x021F, 0x0220, 0x0221, 0x0222, 0x0223,
    0x0224, 0x0225, 0x0226, 0x0227, 0x0228, 0x0229, 0x022A, 0x022B, 0x022C,
    0x022D, 0x022E, 0x022F, 0x0230, 0x0231, 0x0232, 0x0233, 0x0234, 0x0235,
    0x0236, 0x0237, 0x0238, 0x0239, 0x023A, 0x023B, 0x023C, 0x023D, 0x023E,
    0x023F, 0x0240, 0x0241, 0x0242, 0x0243, 0x0244, 0x0245, 0x0246, 0x0247,
    0x0248, 0x0249, 0x024A, 0x024B, 0x024C, 0x024D, 0x024E, 0x024F, 0x0250,
    0x0251, 0x0252, 0x0253, 0x0254, 0x0255, 0x0256, 0x0257, 0x0258, 0x0259,
    0x025A, 0x025B, 0x025C, 0x025D, 0x025E, 0x025F, 0x0260, 0x0261, 0x0262,
    0x0263, 0x0264, 0x0265, 0x0266, 0x0267, 0x0268, 0x0269, 0x026A, 0x026B,
    0x026C, 0x026D, 0x026E, 0x026F, 0x0270, 0x0271, 0x0272, 0x0273, 0x0274,
    0x0275, 0x0276, 0x0277, 0x0278, 0x0279, 0x027A, 0x027B, 0x027C, 0x027D,
    0x027E, 0x027F, 0x0280, 0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286,
    0x0287, 0x0288, 0x0289, 0x028A, 0x028B, 0x028C, 0x028D, 0x028E, 0x028F,
    0x0290, 0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297, 0x0298,
    0x0299, 0x029A, 0x029B, 0x029C, 0x029D, 0x029E, 0x029F, 0x02A0, 0x02A1,
    0x02A2, 0x02A3, 0x02A4, 0x02A5, 0x02A6, 0x02A7, 0x02A8, 0x02A9, 0x02AA,
    0x02AB, 0x02AC, 0x02AD, 0x02AE, 0x02AF, 0x02B0, 0x02B1, 0x02B2, 0x02B3,
    0x02B4, 0x02B5, 0x02B6, 0x02B7, 0x02B8, 0x02B9, 0x02BA, 0x02BB, 0x02BC,
    0x02BD, 0x02BE, 0x02BF, 0x02C0, 0x02C1, 0x02C2, 0x02C3, 0x02C4, 0x02C5,
    0x02C6, 0x02C7, 0x02C8, 0x02C9, 0x02CA, 0x02CB, 0x02CC, 0x02CD, 0x02CE,
    0x02CF, 0x02D0, 0x02D1, 0x02D2, 0x02D3, 0x02D4, 0x02D5, 0x02D6, 0x02D7,
    0x02D8, 0x02D9, 0x02DA, 0x02DB, 0x02DC, 0x02DD, 0x02DE, 0x02DF, 0x02E0,
    0x02E1, 0x02E2, 0x02E3, 0x02E4, 0x02E5, 0x02E6, 0x02E7, 0x02E8, 0x02E9,
    0x02EA, 0x02EB, 0x02EC, 0x02ED, 0x02EE, 0x02EF, 0x02F0, 0x02F1, 0x02F2,
    0x02F3, 0x02F4, 0x02F5, 0x02F6, 0x02F7, 0x02F8, 0x02F9, 0x02FA, 0x02FB,
    0x02FC, 0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302, 0x0303, 0x0304,
    0x0305, 0x0306, 0x0307, 0x0308, 0x0309, 0x030A, 0x030B, 0x030C, 0x030D,
    0x030E, 0x030F, 0x0310, 0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316,
    0x0317, 0x0318, 0x0319, 0x031A, 0x031B, 0x031C, 0x031D, 0x031E, 0x031F,
    0x0320, 0x0321, 0x0322, 0x0323, 0x0324, 0x0325, 0x0326, 0x0327, 0x0328,
    0x0329, 0x032A, 0x032B, 0x032C, 0x032D, 0x032E, 0x032F, 0x0330, 0x0331,
    0x0332, 0x0333, 0x0334, 0x0335, 0x0336, 0x0337, 0x0338, 0x0339, 0x033A,
    0x033B, 0x033C, 0x033D, 0x033E, 0x033F, 0x0340, 0x0341, 0x0342, 0x0343,
    0x0344, 0x0345, 0x0346, 0x0347, 0x0348, 0x0349, 0x034A, 0x034B, 0x034C,
    0x034D, 0x034E, 0x034F, 0x0350, 0x0351, 0x0352, 0x0353, 0x0354, 0x0355,
        -1, 0x0357, 0x0358, 0x0359, 0x035A, 0x035B, 0x035C, 0x035D, 0x035E,
    0x035F, 0x0360, 0x0361, 0x0362, 0x0363, 0x0364, 0x0365, 0x0366, 0x0367,
    0x0368, 0x0369, 0x036A, 0x036B, 0x036C, 0x036D, 0x036E, 0x036F, 0x0370,
    0x0371, 0x0372, 0x0373, 0x0374, 0x0375, 0x0376, 0x0377, 0x0378, 0x0379,
    0x037A, 0x037B, 0x037C, 0x037D, 0x037E, 0x037F, 0x0380, 0x0381, 0x0382,
    0x0383, 0x0384, 0x0385, 0x0386, 0x0387, 0x0388, 0x0389, 0x038A, 0x038B,
    0x038C, 0x038D, 0x038E, 0x038F, 0x0390, 0x0391, 0x0392, 0x0393, 0x0394,
    0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D,
    0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A2, 0x03A3, 0x03A4, 0x03A5, 0x03A6,
    0x03A7, 0x03A8, 0x03A9, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF,
    0x03B0, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7, 0x03B8,
    0x03B9, 0x03BA, 0x03BB, 0x0356,     -1,     -1, 0x0216,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1, 0x0421, 0x0422, 0x0423,
    0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042A, 0x042B, 0x042C,
    0x042D, 0x042E, 0x042F, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435,
    0x0436, 0x0437, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E,
    0x043F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
    0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 0x0450,
    0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457, 0x0458, 0x0459,
    0x045A, 0x045B, 0x045C, 0x045D, 0x045E, 0x045F, 0x0460, 0x0461, 0x0462,
    0x0463, 0x0464, 0x0465, 0x0466, 0x0467, 0x0468, 0x0469, 0x046A, 0x046B,
    0x046C, 0x046D, 0x046E, 0x046F, 0x0470, 0x0471, 0x0472, 0x0473, 0x0474,
    0x0475, 0x0476, 0x0477, 0x0478, 0x0479, 0x047A, 0x047B, 0x047C, 0x047D,
    0x047E, 0x047F, 0x0480, 0x0481, 0x0482, 0x0483, 0x0484, 0x0485, 0x0486,
    0x0487, 0x0488, 0x0489, 0x048A, 0x048B, 0x048C, 0x048D, 0x048E, 0x048F,
    0x0490, 0x0491, 0x0492,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1
};

const short pdUnifiedTypeMap::fPotSM2PTable[TYPESPACE_MAX] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008,
    0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 0x0010, 0x0011,
    0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x001A,
    0x001B, 0x001C, 0x009B, 0x001E, 0x001F, 0x0020, 0x0021, 0x0022, 0x0023,
    0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002A, 0x002B, 0x002C,
    0x002D, 0x002E, 0x002F, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035,
    0x0036, 0x0037, 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E,
    0x003F, 0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050,
    0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059,
    0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F, 0x0060, 0x0061, 0x0062,
    0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B,
    0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073, 0x0074,
    0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D,
    0x007E, 0x007F, 0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086,
    0x0087, 0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 0x0098,
    0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F, 0x00A0, 0x00A1,
    0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7, 0x00A8, 0x00A9, 0x00AA,
    0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF, 0x00B0, 0x00B1, 0x00B2, 0x00B3,
    0x00B4, 0x00B5, 0x00B6, 0x00B7, 0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC,
    0x00BD, 0x00BE, 0x00BF, 0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5,
    0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE,
    0x00CF, 0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF, 0x00E0,
    0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9,
    0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F0, 0x00F1, 0x00F2,
    0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB,
    0x00FC, 0x00FD, 0x00FE, 0x00FF, 0x0100, 0x0101, 0x0102, 0x0103, 0x0104,
    0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010A, 0x010B, 0x010C, 0x010D,
    0x010E, 0x010F, 0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116,
    0x0117, 0x0118, 0x0119, 0x011A, 0x011B, 0x011C, 0x011D, 0x011E, 0x011F,
    0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 0x0128,
    0x0129, 0x012A, 0x012B, 0x012C, 0x012D, 0x012E, 0x012F, 0x0130, 0x0131,
    0x0132, 0x0133, 0x0134, 0x0135, 0x0136,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

    0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207, 0x0208,
    0x0209, 0x020A, 0x020B, 0x020C, 0x020D, 0x020E, 0x020F, 0x0210, 0x0211,
    0x0212, 0x0213, 0x0214, 0x0215, 0x0216, 0x0217, 0x0218, 0x0219, 0x021A,
    0x021B, 0x021C, 0x021D, 0x021E, 0x021F, 0x0220, 0x0221, 0x0222, 0x0223,
    0x0224, 0x0225, 0x0226, 0x0227, 0x0228, 0x0229, 0x022A, 0x022B, 0x022C,
    0x022D, 0x022E, 0x022F, 0x0230, 0x0231, 0x0232, 0x0233, 0x0234, 0x0235,
    0x0236, 0x0237, 0x0238, 0x0239, 0x023A, 0x023B, 0x023C, 0x023D, 0x023E,
    0x023F, 0x0240, 0x0241, 0x0242, 0x0243, 0x0244, 0x0245, 0x0246, 0x0247,
    0x0248, 0x0249, 0x024A, 0x024B, 0x024C, 0x024D, 0x024E, 0x024F, 0x0250,
    0x0251, 0x0252, 0x0253, 0x0254, 0x0255, 0x0256, 0x0257, 0x0258, 0x0259,
    0x025A, 0x025B, 0x025C, 0x025D, 0x025E, 0x025F, 0x0260, 0x0261, 0x0262,
    0x0263, 0x0264, 0x0265, 0x0266, 0x0267, 0x0268, 0x0269, 0x026A, 0x026B,
    0x026C, 0x026D, 0x026E, 0x026F, 0x0270, 0x0271, 0x0272, 0x0273, 0x0274,
    0x0275, 0x0276, 0x0277, 0x0278, 0x0279, 0x027A, 0x027B, 0x027C, 0x027D,
    0x027E, 0x027F, 0x0280, 0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286,
    0x0287, 0x0288, 0x0289, 0x028A, 0x028B, 0x028C, 0x028D, 0x028E, 0x028F,
    0x0290, 0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297, 0x0298,
    0x0299, 0x029A, 0x029B, 0x029C, 0x029D, 0x029E, 0x029F, 0x02A0, 0x02A1,
    0x02A2, 0x02A3, 0x02A4, 0x02A5, 0x02A6, 0x02A7, 0x02A8, 0x02A9, 0x02AA,
    0x02AB, 0x02AC, 0x02AD, 0x02AE, 0x02AF, 0x02B0, 0x02B1, 0x02B2, 0x02B3,
    0x02B4, 0x02B5, 0x02B6, 0x02B7, 0x02B8, 0x02B9, 0x02BA, 0x02BB, 0x02BC,
    0x02BD, 0x02BE, 0x02BF, 0x02C0, 0x02C1, 0x02C2, 0x02C3, 0x02C4, 0x02C5,
    0x02C6, 0x02C7, 0x02C8, 0x02C9, 0x02CA, 0x02CB, 0x02CC, 0x02CD, 0x02CE,
    0x02CF, 0x02D0, 0x02D1, 0x02D2, 0x02D3, 0x02D4, 0x02D5, 0x02D6, 0x02D7,
    0x02D8, 0x02D9, 0x02DA, 0x02DB, 0x02DC, 0x02DD, 0x02DE, 0x02DF, 0x02E0,
    0x02E1, 0x02E2, 0x02E3, 0x02E4, 0x02E5, 0x02E6, 0x02E7, 0x02E8, 0x02E9,
    0x02EA, 0x02EB, 0x02EC, 0x02ED, 0x02EE, 0x02EF, 0x02F0, 0x02F1, 0x02F2,
    0x02F3, 0x02F4, 0x02F5, 0x02F6, 0x02F7, 0x02F8, 0x02F9, 0x02FA, 0x02FB,
    0x02FC, 0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302, 0x0303, 0x0304,
    0x0305, 0x0306, 0x0307, 0x0308, 0x0309, 0x030A, 0x030B, 0x030C, 0x030D,
    0x030E, 0x030F, 0x0310, 0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316,
    0x0317, 0x0318, 0x0319, 0x031A, 0x031B, 0x031C, 0x031D, 0x031E, 0x031F,
    0x0320, 0x0321, 0x0322, 0x0323, 0x0324, 0x0325, 0x0326, 0x0327, 0x0328,
    0x0329, 0x032A, 0x032B, 0x032C, 0x032D, 0x032E, 0x032F, 0x0330, 0x0331,
    0x0332, 0x0333, 0x0334, 0x0335, 0x0336, 0x0337, 0x0338, 0x0339, 0x033A,
    0x033B, 0x033C, 0x033D, 0x033E, 0x033F, 0x0340, 0x0341, 0x0342, 0x0343,
    0x0344, 0x0345, 0x0346, 0x0347, 0x0348, 0x0349, 0x034A, 0x034B, 0x034C,
    0x034D, 0x034E, 0x034F, 0x0350, 0x0351, 0x0352, 0x0353, 0x0354, 0x0355,
    0x0356, 0x0357, 0x0358, 0x0359, 0x035A, 0x035B, 0x035C, 0x035D, 0x035E,
    0x035F, 0x0360, 0x0361, 0x0362, 0x0363, 0x0364, 0x0365, 0x0366, 0x0367,
    0x0368, 0x0369, 0x036A, 0x036B, 0x036C, 0x036D, 0x036E, 0x036F, 0x0370,
    0x0371, 0x0372, 0x0373, 0x0374, 0x0375, 0x0376, 0x0377, 0x0378, 0x0379,
    0x037A, 0x037B, 0x037C, 0x037D, 0x037E, 0x037F, 0x0380, 0x0381, 0x0382,
    0x0383, 0x0384, 0x0385, 0x0386, 0x0387, 0x0388, 0x0389, 0x038A, 0x038B,
    0x038C, 0x038D, 0x038E, 0x038F, 0x0390, 0x0391, 0x0392, 0x0393, 0x0394,
    0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D,
    0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A2, 0x03A3, 0x03A4, 0x03A5, 0x03A6,
    0x03A7, 0x03A8, 0x03A9, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF,
    0x03B0, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7, 0x03B8,
    0x03B9, 0x03BA, 0x03BB,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1, 0x0422, 0x0423, 0x0424,
    0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D,
    0x042E, 0x042F, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436,
    0x0437, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,
    0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448,
    0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 0x0450, 0x0451,
    0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457, 0x0458, 0x0459, 0x045A,
    0x045B, 0x045C, 0x045D, 0x045E, 0x045F, 0x0460, 0x0461, 0x0462, 0x0463,
    0x0464, 0x0465, 0x0466, 0x0467, 0x0468, 0x0469, 0x046A, 0x046B, 0x046C,
    0x046D, 0x046E, 0x046F, 0x0470, 0x0471, 0x0472, 0x0473, 0x0474, 0x0475,
    0x0476, 0x0477, 0x0478, 0x0479, 0x047A, 0x047B, 0x047C, 0x047D, 0x047E,
    0x047F, 0x0480, 0x0481, 0x0482, 0x0483, 0x0484, 0x0485, 0x0486, 0x0487,
    0x0488, 0x0489, 0x048A, 0x048B, 0x048C, 0x048D, 0x048E, 0x048F, 0x0490,
    0x0491, 0x0492, 0x0493, 0x0494,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1
};

const short pdUnifiedTypeMap::fLiveM2PTable[TYPESPACE_MAX] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008,
    0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 0x0010, 0x0011,
    0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x001A,
    0x001B, 0x001C, 0x009B, 0x001E, 0x001F, 0x0020,     -1, 0x0022, 0x0023,
    0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002A, 0x002B, 0x002C,
    0x002D, 0x002E, 0x002F, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035,
    0x0036, 0x0037, 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E,
    0x003F, 0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050,
    0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059,
    0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F, 0x0060, 0x0061, 0x0062,
    0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B,
    0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073, 0x0074,
    0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D,
    0x007E, 0x007F, 0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086,
    0x0087, 0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 0x0098,
    0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F, 0x00A0, 0x00A1,
    0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7, 0x00A8, 0x00A9, 0x00AA,
    0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF, 0x00B0, 0x00B1, 0x00B2, 0x00B3,
    0x00B4, 0x00B5, 0x00B6, 0x00B7, 0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC,
    0x00BD, 0x00BE, 0x00BF, 0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5,
    0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE,
    0x00CF, 0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF, 0x00E0,
    0x00E1, 0x013C, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9,
    0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F0, 0x00F1, 0x00F2,
    0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB,
    0x00FC, 0x00FD, 0x00FE, 0x00FF, 0x0100, 0x0101, 0x0102, 0x0103, 0x0104,
    0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010A, 0x010B, 0x010C, 0x010D,
    0x010E, 0x010F, 0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116,
    0x0117, 0x0118, 0x0119, 0x011A, 0x011B, 0x011C, 0x011D, 0x011E, 0x011F,
    0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 0x0128,
    0x0129, 0x012A, 0x012B, 0x012C, 0x012D, 0x012E, 0x012F, 0x0130, 0x0131,
    0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137, 0x0138, 0x0139,     -1,
        -1,     -1,     -1,     -1,     -1, 0x0021,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    0x00E2,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    0x013A, 0x013B,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

    0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207, 0x0208,
    0x0209, 0x020A, 0x020B, 0x020C, 0x020D, 0x020E, 0x020F, 0x0210, 0x0211,
    0x0212, 0x0213, 0x0214, 0x0215, 0x0216, 0x0217, 0x0218, 0x0219, 0x021A,
    0x021B, 0x021C, 0x021D, 0x021E, 0x021F, 0x0220, 0x0221, 0x0222, 0x0223,
    0x0224, 0x0225, 0x0226, 0x0227, 0x0228, 0x0229, 0x022F, 0x0230,     -1,
    0x0232, 0x0233, 0x0234, 0x0235, 0x0236, 0x0237, 0x0238, 0x0239, 0x023A,
    0x023B, 0x023C, 0x023D, 0x023E, 0x023F, 0x0240, 0x0241, 0x0242, 0x0243,
    0x0244, 0x0245, 0x0246, 0x0247, 0x0248, 0x0249, 0x024A, 0x024B, 0x024C,
    0x024D, 0x024E, 0x024F, 0x0250, 0x0251, 0x0252, 0x0253, 0x0254, 0x0255,
    0x0256, 0x0257, 0x0258, 0x0259, 0x025A, 0x025B, 0x025C, 0x025D, 0x025E,
    0x025F, 0x0260, 0x0261, 0x0262, 0x0263, 0x0264, 0x0265, 0x0266, 0x0267,
    0x0268, 0x0269, 0x026A, 0x026B, 0x026C, 0x026D, 0x026E, 0x026F, 0x0270,
    0x0271, 0x0272, 0x0273, 0x0274, 0x0275, 0x0276, 0x0277,     -1, 0x0279,
    0x027A, 0x027B, 0x027C, 0x027D, 0x027E, 0x027F, 0x0280,     -1, 0x0282,
    0x0283, 0x0284, 0x0285, 0x0286, 0x0287, 0x0288, 0x0289, 0x028A, 0x028B,
    0x028C, 0x028D, 0x028E, 0x028F, 0x0290, 0x0291, 0x0292, 0x0293, 0x0294,
    0x0295, 0x0296, 0x0297, 0x0298, 0x0299, 0x029A, 0x029B, 0x029C, 0x029D,
    0x029E, 0x029F, 0x02A0, 0x02A1, 0x02A2, 0x02A3, 0x02A4, 0x02A5, 0x02A6,
    0x02A7, 0x02A8, 0x02A9, 0x02AA, 0x02AB, 0x02AC, 0x02AD, 0x02AE, 0x02AF,
    0x02B0, 0x02B1, 0x02B2, 0x02B3, 0x02B4, 0x02B5, 0x02B6, 0x02B7, 0x02B8,
    0x02B9, 0x02BA, 0x02BB, 0x02BC, 0x02BD, 0x02BE, 0x02BF, 0x02C0, 0x03C1,
    0x02C2, 0x02C3, 0x02C4, 0x02C5, 0x02C6, 0x02C7, 0x02C8, 0x02C9, 0x02CA,
    0x02CB, 0x02CC, 0x02CD, 0x02CE, 0x02CF, 0x02D0, 0x02D1, 0x02D2, 0x02D3,
    0x02D4, 0x02D5, 0x02D6, 0x02D7, 0x02D8, 0x02D9, 0x02DA, 0x02DB, 0x02DC,
    0x02DD, 0x02DE, 0x02DF, 0x02E0, 0x02E1, 0x02E2, 0x02E3, 0x02E4, 0x02E5,
    0x02E6, 0x02E7, 0x02E8, 0x02E9, 0x02EA, 0x02EB, 0x02EC, 0x02ED, 0x02EE,
    0x02EF, 0x02F0, 0x02F1, 0x02F2, 0x02F3, 0x02F4, 0x02F5, 0x02F6, 0x02F7,
    0x02F8, 0x02F9, 0x02FA, 0x02FB, 0x02FC, 0x02FD, 0x02FE, 0x02FF, 0x0300,
    0x0301, 0x0302, 0x0303, 0x0304, 0x0305, 0x0306, 0x0307, 0x0308, 0x0309,
    0x030A, 0x030B, 0x030C, 0x030D, 0x030E, 0x030F, 0x0310, 0x0311, 0x0312,
    0x0313, 0x0314, 0x0315, 0x0316, 0x0317, 0x0318, 0x0319, 0x031A, 0x031B,
    0x031C, 0x031D, 0x031E, 0x031F, 0x0320, 0x0321, 0x0322, 0x0323, 0x0324,
    0x0325, 0x0326, 0x0327, 0x0328, 0x0329, 0x032A, 0x032B, 0x032C, 0x032D,
    0x032E, 0x032F, 0x0330, 0x0331, 0x0332, 0x0333, 0x0334, 0x0335, 0x0336,
    0x0337, 0x0338, 0x0339, 0x033A, 0x033B, 0x033C, 0x033D, 0x033E, 0x033F,
    0x0340, 0x0341, 0x0342, 0x0343, 0x0344, 0x0345, 0x0346, 0x0347, 0x0348,
    0x0349, 0x034A, 0x034B, 0x034C, 0x034D, 0x034E, 0x034F, 0x0350, 0x0351,
        -1, 0x0353, 0x0354, 0x0355, 0x0356, 0x0357, 0x0358, 0x0359, 0x035A,
    0x035B, 0x035C, 0x035D, 0x035E, 0x035F, 0x0360,     -1, 0x0362, 0x0363,
    0x0364, 0x0365, 0x0366, 0x0367, 0x0368, 0x0369, 0x036A, 0x036B, 0x036C,
        -1, 0x036E, 0x036F, 0x0370, 0x0371, 0x0372, 0x0373, 0x0374, 0x0375,
    0x0376, 0x0377, 0x0378, 0x0379, 0x037A, 0x037B, 0x037C, 0x037D, 0x037E,
    0x037F, 0x0380, 0x0381, 0x0382, 0x0383, 0x0384, 0x0385, 0x0386, 0x0387,
    0x0388, 0x0389, 0x038A, 0x038B, 0x038C, 0x038D, 0x038E, 0x038F, 0x0390,
    0x0391, 0x0392, 0x0393, 0x0394, 0x0395,     -1, 0x0396,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 0x03A2,
    0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9, 0x03AA, 0x03AB,
    0x03AC, 0x03AD, 0x03AE, 0x03AF, 0x03B0, 0x03B1, 0x03B2, 0x03B3, 0x03B4,
    0x03B5, 0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD,
    0x03BE, 0x03BF, 0x03C0,     -1,     -1, 0x0278,     -1,     -1,     -1,
        -1,     -1,     -1, 0x022A, 0x022B, 0x022C, 0x022D, 0x022E, 0x0231,
    0x0281,     -1,     -1,     -1, 0x02C1,     -1,     -1, 0x0352, 0x0361,
    0x036D, 0x0397, 0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E,
    0x039F, 0x03A0, 0x03A1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1, 0x0427, 0x0428, 0x0429,
    0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F, 0x0430, 0x0431, 0x0432,
    0x0433, 0x0434, 0x0435, 0x0436, 0x0437, 0x0438, 0x0439, 0x043A, 0x043B,
    0x043C, 0x043D, 0x043E, 0x043F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444,
    0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D,
    0x044E, 0x044F, 0x0450, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456,
    0x0457, 0x0458, 0x0459, 0x045A, 0x045B, 0x045C, 0x045D, 0x045E, 0x045F,
    0x0460, 0x0461, 0x0462, 0x0463, 0x0464, 0x0465,     -1,     -1, 0x0468,
    0x0469, 0x046A, 0x046B, 0x046C, 0x046D, 0x046E, 0x046F, 0x0470, 0x0471,
    0x0472, 0x0473, 0x0474, 0x0475, 0x0476, 0x0477, 0x0478, 0x0479,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    0x0484, 0x0485, 0x0486, 0x0487, 0x0488, 0x0489, 0x048A, 0x048B, 0x048C,
    0x048D, 0x048E, 0x048F, 0x0490, 0x0491, 0x0492, 0x0493, 0x0494, 0x0495,
    0x0496, 0x0497, 0x0498, 0x0499,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1, 0x047A, 0x047B, 0x047C,
    0x047D, 0x047E, 0x047F, 0x0480, 0x049A, 0x0466, 0x0467, 0x0481, 0x0482,
    0x0483, 0x049B, 0x049C, 0x049D, 0x049E,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1
};

const short pdUnifiedTypeMap::fEoaM2PTable[TYPESPACE_MAX] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008,
    0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 0x0010, 0x0011,
    0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,     -1, 0x0019, 0x001A,
        -1, 0x001C, 0x0083, 0x001E, 0x001F, 0x0020,     -1,     -1,     -1,
    0x0024,     -1,     -1, 0x0027, 0x0028, 0x0029,     -1, 0x002A, 0x002B,
    0x002C, 0x002D, 0x002E, 0x002F, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034,
    0x0035, 0x0036, 0x0037, 0x0038, 0x0039,     -1,     -1, 0x003C, 0x003D,
    0x0103, 0x003E, 0x003F,     -1, 0x0040, 0x0041, 0x0042, 0x0043, 0x0044,
    0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D,
        -1,     -1,     -1, 0x004F, 0x0050, 0x0051, 0x0052,     -1,     -1,
        -1, 0x0055,     -1, 0x0053,     -1,     -1,     -1,     -1, 0x0057,
    0x0058,     -1, 0x0059,     -1, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E,
    0x005F, 0x0060,     -1, 0x0061,     -1, 0x0062, 0x0063, 0x0064, 0x0065,
    0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E,
    0x006F, 0x0070, 0x0071,     -1,     -1, 0x0072, 0x0073,     -1, 0x0074,
    0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D,
        -1,     -1,     -1,     -1,     -1,     -1, 0x007E, 0x007F, 0x0080,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 0x0087,
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F, 0x0090,
    0x0091, 0x0092, 0x0093,     -1, 0x0095, 0x0096, 0x0097,     -1,     -1,
    0x009A,     -1,     -1,     -1,     -1, 0x009B, 0x009C, 0x009D,     -1,
    0x009E, 0x009F, 0x00A0, 0x00A1, 0x00A2,     -1, 0x00A4, 0x00A5, 0x00A6,
    0x00A7, 0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE,     -1,
    0x00AF, 0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8,     -1,     -1, 0x00B9,     -1, 0x00BA, 0x00BB, 0x00BC, 0x00BD,
    0x00BE,     -1, 0x00BF, 0x00C0,     -1, 0x00C2, 0x00C3, 0x00C4, 0x00C5,
    0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE,
        -1, 0x00CF,     -1, 0x00D1, 0x00D2,     -1, 0x00D3,     -1, 0x00D4,
    0x00D5, 0x00D6, 0x00D7, 0x00D8,     -1,     -1,     -1,     -1,     -1,
    0x00D9, 0x00DA, 0x00DB, 0x00DC,     -1, 0x00DE, 0x00DF, 0x00E0, 0x00E1,
        -1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9,
    0x00EA, 0x00EB, 0x00EC, 0x00ED,     -1,     -1,     -1, 0x00EE, 0x00EF,
    0x00F0,     -1, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5,     -1, 0x00F6,
    0x00F7, 0x00F8, 0x00F9,     -1, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE,
    0x00FF,     -1,     -1, 0x0101,     -1, 0x010E, 0x0023, 0x0111,     -1,
        -1,     -1, 0x0018, 0x001B, 0x001D,     -1, 0x0021, 0x0022, 0x0025,
    0x0026, 0x003A, 0x003B, 0x004E, 0x0054, 0x0056, 0x0081, 0x0082, 0x0084,
    0x0085, 0x0086, 0x0094, 0x0098, 0x0099, 0x00A3, 0x00C1, 0x00D0, 0x00DD,
        -1, 0x0100, 0x0102, 0x0104, 0x0105, 0x0106, 0x0107, 0x0108, 0x0109,
    0x010A, 0x010B, 0x010C, 0x010D, 0x010F, 0x0110, 0x0112, 0x0113, 0x0114,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

        -1,     -1, 0x0201, 0x0202,     -1, 0x0203, 0x0204, 0x0205,     -1,
        -1, 0x0206, 0x0207, 0x0208,     -1, 0x020A, 0x020B, 0x020C,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1, 0x0211, 0x0212,
    0x0213,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1, 0x0215, 0x0216, 0x0217, 0x0218, 0x0219, 0x021A,     -1,
    0x021C, 0x021D, 0x021E, 0x021F, 0x0220, 0x0221, 0x0222, 0x0223, 0x0224,
    0x0225, 0x0226, 0x0227, 0x0228, 0x0229, 0x022A, 0x022B,     -1,     -1,
    0x022C,     -1, 0x022D, 0x022E, 0x022F, 0x0230,     -1,     -1,     -1,
    0x0231,     -1, 0x0232, 0x0233, 0x0234, 0x0235, 0x0236, 0x0237, 0x0238,
    0x0239, 0x023A, 0x023B, 0x023C, 0x023D, 0x023E, 0x023F, 0x0240,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1, 0x0241, 0x0242,     -1, 0x0243,
        -1,     -1,     -1,     -1,     -1,     -1, 0x0244, 0x0245,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    0x0246, 0x0247,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 0x0248,
        -1,     -1, 0x0249, 0x024A, 0x024B, 0x024C,     -1,     -1,     -1,
    0x024D, 0x024E, 0x024F, 0x0250, 0x0251, 0x0252, 0x0253, 0x0254, 0x0255,
    0x0256, 0x0257, 0x0258, 0x0259,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    0x025A,     -1,     -1,     -1,     -1,     -1,     -1, 0x025B,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1, 0x025C,     -1,     -1,     -1,     -1, 0x025D, 0x025E,     -1,
        -1,     -1, 0x025F, 0x0260, 0x0261, 0x0262, 0x0263, 0x0264, 0x0265,
    0x0266, 0x0267,     -1, 0x0268, 0x0269, 0x026A, 0x026B, 0x026C, 0x026D,
    0x026E, 0x026F,     -1,     -1, 0x0270, 0x0271,     -1, 0x0272,     -1,
        -1, 0x0273,     -1, 0x0274, 0x0275, 0x0276, 0x0277, 0x0278, 0x0279,
    0x027A, 0x027B, 0x027C, 0x027D, 0x027E, 0x027F, 0x0280,     -1, 0x0281,
    0x0282, 0x0283,     -1,     -1,     -1, 0x0284, 0x0285,     -1,     -1,
    0x0286, 0x0287, 0x0288, 0x0289, 0x028A, 0x028B, 0x028C, 0x028D, 0x028E,
    0x028F, 0x0290, 0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297,
        -1,     -1, 0x0298, 0x0299, 0x029A,     -1, 0x02F8,     -1,     -1,
        -1,     -1,     -1,     -1,     -1, 0x029B,     -1,     -1, 0x029C,
        -1,     -1, 0x029D, 0x029E, 0x029F, 0x02A0, 0x02A1, 0x02A2, 0x02A3,
    0x02A4, 0x02A5, 0x02A6, 0x02A7, 0x02A8, 0x02A9, 0x02AA, 0x02AB, 0x02AC,
    0x02AD, 0x02AE, 0x02AF, 0x02B0, 0x02B1, 0x02B2, 0x02B3,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1, 0x02B5,     -1,
        -1,     -1, 0x02B6,     -1,     -1,     -1,     -1, 0x02B7,     -1,
    0x02B8,     -1,     -1, 0x02BA,     -1, 0x02BB,     -1, 0x02BC, 0x02BD,
        -1,     -1, 0x02BF, 0x02C0, 0x02C1,     -1, 0x02C2,     -1,     -1,
        -1,     -1,     -1, 0x02C4, 0x02C5,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1, 0x02C6,     -1,     -1, 0x02C7,     -1,
    0x02C9, 0x02CA, 0x02CB, 0x02CC, 0x02CD,     -1, 0x02CE,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    0x02CF, 0x02D0, 0x02D1, 0x02D2, 0x02D3, 0x02D4, 0x02D5, 0x02D6,     -1,
        -1, 0x02D7, 0x02D8, 0x02D9, 0x02DA, 0x02DB, 0x02DC,     -1,     -1,
        -1, 0x02DD,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1, 0x02DE,     -1, 0x020F, 0x0337,     -1, 0x0200, 0x0209,
    0x020D, 0x020E, 0x0210, 0x0214,     -1,     -1,     -1,     -1, 0x021B,
        -1, 0x02B4, 0x02B9, 0x02BE,     -1, 0x02C3, 0x02C8,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1, 0x02DF,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    0x02E0, 0x02E1, 0x02E2, 0x02E3, 0x02E4,     -1, 0x02E5,     -1, 0x02E6,
    0x02E7, 0x02E8,     -1,     -1, 0x02E9, 0x02EA, 0x02EB,     -1,     -1,
    0x02EC,     -1,     -1, 0x02ED,     -1, 0x02F9,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1, 0x02EE, 0x02EF, 0x02F0,
    0x02F1, 0x02F2,     -1,     -1,     -1, 0x02F3,     -1,     -1,     -1,
        -1, 0x02F4, 0x02F5,     -1, 0x02F6, 0x02F7, 0x02FA, 0x02FB, 0x02FC,
    0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302, 0x0303, 0x0304, 0x0305,
    0x0306, 0x0307, 0x0308, 0x0309, 0x030A, 0x030B, 0x030C, 0x030D, 0x030E,
    0x030F, 0x0310, 0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316, 0x0317,
    0x0318, 0x0319, 0x031A, 0x031B, 0x031C, 0x031D, 0x031E, 0x031F, 0x0320,
    0x0321, 0x0322, 0x0323, 0x0324, 0x0325, 0x0326, 0x0327, 0x0328, 0x0329,
    0x032A, 0x032B, 0x032C, 0x032D, 0x032E, 0x032F, 0x0330, 0x0331, 0x0332,
    0x0333, 0x0334, 0x0335, 0x0336, 0x0338, 0x0339,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1
};

const short pdUnifiedTypeMap::fHexM2PTable[TYPESPACE_MAX] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008,
    0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 0x0010, 0x0011,
    0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,     -1,     -1, 0x001A,
        -1, 0x001C, 0x0083, 0x001E, 0x001F, 0x0020,     -1,     -1,     -1,
    0x0024,     -1,     -1, 0x0027, 0x0028, 0x0029,     -1, 0x002A, 0x002B,
    0x002C, 0x002D, 0x002E, 0x002F, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034,
    0x0035, 0x0036, 0x0037, 0x0038, 0x0039,     -1,     -1, 0x003C, 0x003D,
    0x0103, 0x003E, 0x003F,     -1, 0x0040, 0x0041, 0x0042, 0x0043, 0x0044,
    0x0045, 0x0046, 0x0047, 0x0048, 0x0049,     -1, 0x004B, 0x004C, 0x004D,
        -1,     -1,     -1, 0x004F, 0x0050, 0x0051, 0x0052,     -1,     -1,
        -1, 0x0055,     -1, 0x0053,     -1,     -1,     -1,     -1, 0x0057,
    0x0058,     -1, 0x0059,     -1, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E,
    0x005F, 0x0060,     -1, 0x0061,     -1, 0x0062, 0x0063, 0x0064, 0x0065,
    0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E,
    0x006F, 0x0070, 0x0071,     -1,     -1, 0x0072, 0x0073,     -1, 0x0074,
    0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D,
        -1,     -1,     -1,     -1,     -1,     -1, 0x007E, 0x007F, 0x0080,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 0x0087,
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F, 0x0090,
    0x0091, 0x0092, 0x0093,     -1, 0x0095, 0x0096, 0x0097,     -1,     -1,
    0x009A,     -1,     -1,     -1,     -1, 0x009B, 0x009C, 0x009D,     -1,
    0x009E, 0x009F, 0x00A0, 0x00A1, 0x00A2,     -1, 0x00A4, 0x00A5, 0x00A6,
    0x00A7, 0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE,     -1,
    0x00AF, 0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8,     -1,     -1, 0x00B9,     -1, 0x00BA, 0x00BB, 0x00BC, 0x00BD,
    0x00BE,     -1, 0x00BF, 0x00C0,     -1, 0x00C2, 0x00C3, 0x00C4, 0x00C5,
    0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE,
        -1, 0x00CF,     -1, 0x00D1, 0x00D2,     -1, 0x00D3,     -1, 0x00D4,
    0x00D5, 0x00D6, 0x00D7, 0x00D8,     -1,     -1,     -1,     -1,     -1,
    0x00D9, 0x00DA, 0x00DB, 0x00DC,     -1, 0x00DE,     -1, 0x00E0, 0x00E1,
        -1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9,
    0x00EA, 0x00EB, 0x00EC, 0x00ED,     -1,     -1,     -1, 0x00EE, 0x00EF,
    0x00F0,     -1, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5,     -1, 0x00F6,
    0x00F7, 0x00F8, 0x00F9,     -1, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE,
    0x00FF,     -1,     -1, 0x0101,     -1, 0x010E, 0x0023, 0x0111,     -1,
        -1,     -1, 0x0018,     -1, 0x001D,     -1, 0x0021, 0x0022, 0x0025,
    0x0026, 0x003A, 0x003B, 0x004E, 0x0054, 0x0056, 0x0081, 0x0082, 0x0084,
    0x0085, 0x0086, 0x0094, 0x0098,     -1, 0x00A3, 0x00C1, 0x00D0, 0x00DD,
        -1, 0x0100, 0x0102, 0x0104, 0x0105, 0x0106,     -1, 0x0108, 0x0109,
    0x010A, 0x010B, 0x010C, 0x010D, 0x010F, 0x0110, 0x0112, 0x0113, 0x0114,
        -1,     -1, 0x0019, 0x001B, 0x004A, 0x0099, 0x00DF, 0x0107, 0x0115,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

        -1,     -1, 0x0201, 0x0202,     -1, 0x0203, 0x0204, 0x0205,     -1,
        -1, 0x0206, 0x0207, 0x0208,     -1, 0x020A, 0x020B, 0x020C,     -1,
        -1,     -1,     -1,     -1, 0x033A,     -1,     -1, 0x0211, 0x0212,
    0x0213,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1, 0x0219, 0x021A,     -1,
        -1,     -1, 0x021E, 0x021F, 0x0220, 0x0221, 0x0222, 0x0223, 0x0224,
    0x0225, 0x0226, 0x0227, 0x0228, 0x0229, 0x022A, 0x022B,     -1,     -1,
    0x022C,     -1, 0x022D, 0x022E, 0x022F, 0x0230,     -1,     -1,     -1,
    0x0231,     -1, 0x0232, 0x0233, 0x0234, 0x0235, 0x0236, 0x0237, 0x0238,
    0x0239, 0x023A, 0x023B, 0x023C, 0x023D, 0x023E, 0x023F, 0x0240,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1, 0x0241, 0x0242,     -1, 0x0243,
        -1,     -1,     -1,     -1,     -1,     -1, 0x0244, 0x0245,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    0x0246, 0x0247,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 0x0248,
        -1,     -1, 0x0249, 0x024A, 0x024B, 0x024C,     -1,     -1,     -1,
    0x024D, 0x024E, 0x024F, 0x0250, 0x0251, 0x0252, 0x0253, 0x0254, 0x0255,
    0x0256, 0x0257, 0x0258, 0x0259,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    0x025A,     -1,     -1,     -1,     -1,     -1,     -1, 0x025B,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1, 0x025C,     -1,     -1,     -1,     -1, 0x025D, 0x025E,     -1,
        -1,     -1, 0x025F, 0x0260, 0x0261, 0x0262, 0x0263, 0x0264, 0x0265,
    0x0266, 0x0267,     -1, 0x0268, 0x0269, 0x026A, 0x026B, 0x026C, 0x026D,
    0x026E, 0x026F,     -1,     -1, 0x0270, 0x0271,     -1, 0x0272,     -1,
        -1, 0x0273,     -1, 0x0274, 0x0275, 0x0276, 0x0277, 0x0278, 0x0279,
    0x027A, 0x027B, 0x027C, 0x027D, 0x027E, 0x027F, 0x0280,     -1, 0x0281,
    0x0282, 0x0283,     -1,     -1,     -1, 0x0284, 0x0285,     -1,     -1,
    0x0286, 0x0287, 0x0288, 0x0289, 0x028A, 0x028B, 0x028C, 0x028D, 0x028E,
    0x028F, 0x0290, 0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297,
        -1,     -1, 0x0298, 0x0299, 0x029A,     -1, 0x02F8,     -1,     -1,
        -1,     -1,     -1,     -1,     -1, 0x029B,     -1,     -1, 0x029C,
        -1,     -1, 0x029D, 0x029E, 0x029F, 0x02A0, 0x02A1, 0x02A2, 0x02A3,
    0x02A4, 0x02A5, 0x02A6, 0x02A7, 0x02A8, 0x02A9, 0x02AA, 0x02AB, 0x02AC,
    0x02AD, 0x02AE, 0x02AF, 0x02B0, 0x02B1, 0x02B2, 0x02B3,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1, 0x02B5,     -1,
        -1,     -1, 0x02B6,     -1,     -1,     -1,     -1, 0x02B7,     -1,
    0x02B8,     -1,     -1, 0x02BA,     -1, 0x02BB,     -1, 0x02BC, 0x02BD,
        -1,     -1, 0x02BF, 0x02C0, 0x02C1,     -1, 0x02C2,     -1,     -1,
        -1,     -1,     -1, 0x02C4, 0x02C5,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1, 0x02C6,     -1,     -1, 0x02C7,     -1,
    0x02C9, 0x02CA, 0x02CB, 0x02CC, 0x02CD,     -1, 0x02CE,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    0x02CF, 0x02D0, 0x02D1, 0x02D2, 0x02D3,     -1, 0x02D5, 0x02D6,     -1,
        -1, 0x02D7, 0x02D8, 0x02D9, 0x02DA, 0x02DB, 0x02DC,     -1,     -1,
        -1, 0x02DD,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1, 0x02DE,     -1,     -1, 0x0337,     -1, 0x0200, 0x0209,
    0x020D, 0x020E, 0x0210, 0x0214,     -1,     -1,     -1,     -1, 0x021B,
        -1, 0x02B4, 0x02B9, 0x02BE,     -1, 0x02C3, 0x02C8,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1, 0x020F, 0x0215, 0x0216, 0x0217, 0x0218, 0x021C,
    0x021D, 0x02D4,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1, 0x02DF,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    0x02E0, 0x02E1, 0x02E2, 0x02E3, 0x02E4,     -1, 0x02E5,     -1, 0x02E6,
    0x02E7, 0x02E8,     -1,     -1, 0x02E9, 0x02EA, 0x02EB,     -1,     -1,
    0x02EC,     -1,     -1, 0x02ED,     -1, 0x02F9,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1, 0x02EE, 0x02EF, 0x02F0,
    0x02F1, 0x02F2,     -1,     -1,     -1, 0x02F3,     -1,     -1,     -1,
        -1, 0x02F4, 0x02F5,     -1, 0x02F6, 0x02F7, 0x02FA, 0x02FB, 0x02FC,
    0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302, 0x0303, 0x0304, 0x0305,
    0x0306, 0x0307, 0x0308, 0x0309, 0x030A, 0x030B, 0x030C, 0x030D, 0x030E,
    0x030F, 0x0310, 0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316, 0x0317,
    0x0318, 0x0319, 0x031A, 0x031B, 0x031C, 0x031D, 0x031E, 0x031F, 0x0320,
    0x0321, 0x0322, 0x0323, 0x0324, 0x0325, 0x0326, 0x0327, 0x0328, 0x0329,
    0x032A, 0x032B, 0x032C, 0x032D, 0x032E, 0x032F, 0x0330, 0x0331, 0x0332,
    0x0333, 0x0334, 0x0335, 0x0336, 0x0338, 0x0339,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1
};

const short pdUnifiedTypeMap::fUruP2MTable[TYPESPACE_MAX] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008,
    0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 0x0010, 0x0011,
    0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x001A,
    0x001B, 0x001C, 0x001D, 0x001E, 0x001F, 0x0020, 0x0021, 0x0022, 0x0023,
    0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002A, 0x002B, 0x002C,
    0x002D, 0x002E, 0x002F, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035,
    0x0036, 0x0037, 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E,
    0x003F, 0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050,
    0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059,
    0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F, 0x0060, 0x0061, 0x0062,
    0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B,
    0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073, 0x0074,
    0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D,
    0x007E, 0x007F, 0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086,
    0x0087, 0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 0x0098,
    0x0099, 0x009A, 0x001D, 0x009C, 0x009D, 0x009E, 0x009F, 0x00A0, 0x00A1,
    0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7, 0x00A8, 0x00A9, 0x00AA,
    0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF, 0x00B0, 0x00B1, 0x00B2, 0x00B3,
    0x00B4, 0x00B5, 0x00B6, 0x00B7, 0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC,
    0x00BD, 0x00BE, 0x00BF, 0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5,
    0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE,
    0x00CF, 0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF, 0x00E0,
    0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9,
    0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F0, 0x00F1, 0x00F2,
    0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB,
    0x00FC, 0x00FD, 0x00FE, 0x00FF, 0x0100, 0x0101, 0x0102, 0x0103, 0x0104,
    0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010A, 0x010B, 0x010C, 0x010D,
    0x010E, 0x010F, 0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116,
    0x0117, 0x0118, 0x0119, 0x011A, 0x011B, 0x011C, 0x011D, 0x011E, 0x011F,
    0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 0x0128,
    0x0129, 0x012A, 0x012B, 0x012C, 0x012D, 0x012E,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

    0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207, 0x0208,
    0x0209, 0x020A, 0x020B, 0x020C, 0x020D, 0x020E, 0x020F, 0x0210, 0x0211,
    0x0212, 0x0213, 0x0214, 0x0215, 0x03BF, 0x0217, 0x0218, 0x0219, 0x021A,
    0x021B, 0x021C, 0x021D, 0x021E, 0x021F, 0x0220, 0x0221, 0x0222, 0x0223,
    0x0224, 0x0225, 0x0226, 0x0227, 0x0228, 0x0229, 0x022A, 0x022B, 0x022C,
    0x022D, 0x022E, 0x022F, 0x0230, 0x0231, 0x0232, 0x0233, 0x0234, 0x0235,
    0x0236, 0x0237, 0x0238, 0x0239, 0x023A, 0x023B, 0x023C, 0x023D, 0x023E,
    0x023F, 0x0240, 0x0241, 0x0242, 0x0243, 0x0244, 0x0245, 0x0246, 0x0247,
    0x0248, 0x0249, 0x024A, 0x024B, 0x024C, 0x024D, 0x024E, 0x024F, 0x0250,
    0x0251, 0x0252, 0x0253, 0x0254, 0x0255, 0x0256, 0x0257, 0x0258, 0x0259,
    0x025A, 0x025B, 0x025C, 0x025D, 0x025E, 0x025F, 0x0260, 0x0261, 0x0262,
    0x0263, 0x0264, 0x0265, 0x0266, 0x0267, 0x0268, 0x0269, 0x026A, 0x026B,
    0x026C, 0x026D, 0x026E, 0x026F, 0x0270, 0x0271, 0x0272, 0x0273, 0x0274,
    0x0275, 0x0276, 0x0277, 0x0278, 0x0279, 0x027A, 0x027B, 0x027C, 0x027D,
    0x027E, 0x027F, 0x0280, 0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286,
    0x0287, 0x0288, 0x0289, 0x028A, 0x028B, 0x028C, 0x028D, 0x028E, 0x028F,
    0x0290, 0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297, 0x0298,
    0x0299, 0x029A, 0x029B, 0x029C, 0x029D, 0x029E, 0x029F, 0x02A0, 0x02A1,
    0x02A2, 0x02A3, 0x02A4, 0x02A5, 0x02A6, 0x02A7, 0x02A8, 0x02A9, 0x02AA,
    0x02AB, 0x02AC, 0x02AD, 0x02AE, 0x02AF, 0x02B0, 0x02B1, 0x02B2, 0x02B3,
    0x02B4, 0x02B5, 0x02B6, 0x02B7, 0x02B8, 0x02B9, 0x02BA, 0x02BB, 0x02BC,
    0x02BD, 0x02BE, 0x02BF, 0x02C0, 0x02C1, 0x02C2, 0x02C3, 0x02C4, 0x02C5,
    0x02C6, 0x02C7, 0x02C8, 0x02C9, 0x02CA, 0x02CB, 0x02CC, 0x02CD, 0x02CE,
    0x02CF, 0x02D0, 0x02D1, 0x02D2, 0x02D3, 0x02D4, 0x02D5, 0x02D6, 0x02D7,
    0x02D8, 0x02D9, 0x02DA, 0x02DB, 0x02DC, 0x02DD, 0x02DE, 0x02DF, 0x02E0,
    0x02E1, 0x02E2, 0x02E3, 0x02E4, 0x02E5, 0x02E6, 0x02E7, 0x02E8, 0x02E9,
    0x02EA, 0x02EB, 0x02EC, 0x02ED, 0x02EE, 0x02EF, 0x02F0, 0x02F1, 0x02F2,
    0x02F3, 0x02F4, 0x02F5, 0x02F6, 0x02F7, 0x02F8, 0x02F9, 0x02FA, 0x02FB,
    0x02FC, 0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302, 0x0303, 0x0304,
    0x0305, 0x0306, 0x0307, 0x0308, 0x0309, 0x030A, 0x030B, 0x030C, 0x030D,
    0x030E, 0x030F, 0x0310, 0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316,
    0x0317, 0x0318, 0x0319, 0x031A, 0x031B, 0x031C, 0x031D, 0x031E, 0x031F,
    0x0320, 0x0321, 0x0322, 0x0323, 0x0324, 0x0325, 0x0326, 0x0327, 0x0328,
    0x0329, 0x032A, 0x032B, 0x032C, 0x032D, 0x032E, 0x032F, 0x0330, 0x0331,
    0x0332, 0x0333, 0x0334, 0x0335, 0x0336, 0x0337, 0x0338, 0x0339, 0x033A,
    0x033B, 0x033C, 0x033D, 0x033E, 0x033F, 0x0340, 0x0341, 0x0342, 0x0343,
    0x0344, 0x0345, 0x0346, 0x0347, 0x0348, 0x0349, 0x034A, 0x034B, 0x034C,
    0x034D, 0x034E, 0x034F, 0x0350, 0x0351, 0x0352, 0x0353, 0x0354, 0x0355,
    0x03BC, 0x0357, 0x0358, 0x0359, 0x035A, 0x035B, 0x035C, 0x035D, 0x035E,
    0x035F, 0x0360, 0x0361, 0x0362, 0x0363, 0x0364, 0x0365, 0x0366, 0x0367,
    0x0368, 0x0369, 0x036A, 0x036B, 0x036C, 0x036D, 0x036E, 0x036F, 0x0370,
    0x0371, 0x0372, 0x0373, 0x0374, 0x0375, 0x0376, 0x0377, 0x0378, 0x0379,
    0x037A, 0x037B, 0x037C, 0x037D, 0x037E, 0x037F, 0x0380, 0x0381, 0x0382,
    0x0383, 0x0384, 0x0385, 0x0386, 0x0387, 0x0388, 0x0389, 0x038A, 0x038B,
    0x038C, 0x038D, 0x038E, 0x038F, 0x0390, 0x0391, 0x0392, 0x0393, 0x0394,
    0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D,
    0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A2, 0x03A3, 0x03A4, 0x03A5, 0x03A6,
    0x03A7, 0x03A8, 0x03A9, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF,
    0x03B0, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7, 0x03B8,
    0x03B9, 0x03BA, 0x03BB,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1, 0x0421, 0x0422, 0x0423,
    0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042A, 0x042B, 0x042C,
    0x042D, 0x042E, 0x042F, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435,
    0x0436, 0x0437, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E,
    0x043F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
    0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 0x0450,
    0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457, 0x0458, 0x0459,
    0x045A, 0x045B, 0x045C, 0x045D, 0x045E, 0x045F, 0x0460, 0x0461, 0x0462,
    0x0463, 0x0464, 0x0465, 0x0466, 0x0467, 0x0468, 0x0469, 0x046A, 0x046B,
    0x046C, 0x046D, 0x046E, 0x046F, 0x0470, 0x0471, 0x0472, 0x0473, 0x0474,
    0x0475, 0x0476, 0x0477, 0x0478, 0x0479, 0x047A, 0x047B, 0x047C, 0x047D,
    0x047E, 0x047F, 0x0480, 0x0481, 0x0482, 0x0483, 0x0484, 0x0485, 0x0486,
    0x0487, 0x0488, 0x0489, 0x048A, 0x048B, 0x048C, 0x048D, 0x048E, 0x048F,
    0x0490, 0x0491, 0x0492,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1
};

const short pdUnifiedTypeMap::fPotSP2MTable[TYPESPACE_MAX] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008,
    0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 0x0010, 0x0011,
    0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x001A,
    0x001B, 0x001C, 0x001D, 0x001E, 0x001F, 0x0020, 0x0021, 0x0022, 0x0023,
    0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002A, 0x002B, 0x002C,
    0x002D, 0x002E, 0x002F, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035,
    0x0036, 0x0037, 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E,
    0x003F, 0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050,
    0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059,
    0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F, 0x0060, 0x0061, 0x0062,
    0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B,
    0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073, 0x0074,
    0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D,
    0x007E, 0x007F, 0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086,
    0x0087, 0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 0x0098,
    0x0099, 0x009A, 0x001D, 0x009C, 0x009D, 0x009E, 0x009F, 0x00A0, 0x00A1,
    0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7, 0x00A8, 0x00A9, 0x00AA,
    0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF, 0x00B0, 0x00B1, 0x00B2, 0x00B3,
    0x00B4, 0x00B5, 0x00B6, 0x00B7, 0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC,
    0x00BD, 0x00BE, 0x00BF, 0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5,
    0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE,
    0x00CF, 0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF, 0x00E0,
    0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9,
    0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F0, 0x00F1, 0x00F2,
    0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB,
    0x00FC, 0x00FD, 0x00FE, 0x00FF, 0x0100, 0x0101, 0x0102, 0x0103, 0x0104,
    0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010A, 0x010B, 0x010C, 0x010D,
    0x010E, 0x010F, 0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116,
    0x0117, 0x0118, 0x0119, 0x011A, 0x011B, 0x011C, 0x011D, 0x011E, 0x011F,
    0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 0x0128,
    0x0129, 0x012A, 0x012B, 0x012C, 0x012D, 0x012E, 0x012F, 0x0130, 0x0131,
    0x0132, 0x0133, 0x0134, 0x0135, 0x0136,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

    0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207, 0x0208,
    0x0209, 0x020A, 0x020B, 0x020C, 0x020D, 0x020E, 0x020F, 0x0210, 0x0211,
    0x0212, 0x0213, 0x0214, 0x0215, 0x0216, 0x0217, 0x0218, 0x0219, 0x021A,
    0x021B, 0x021C, 0x021D, 0x021E, 0x021F, 0x0220, 0x0221, 0x0222, 0x0223,
    0x0224, 0x0225, 0x0226, 0x0227, 0x0228, 0x0229, 0x022A, 0x022B, 0x022C,
    0x022D, 0x022E, 0x022F, 0x0230, 0x0231, 0x0232, 0x0233, 0x0234, 0x0235,
    0x0236, 0x0237, 0x0238, 0x0239, 0x023A, 0x023B, 0x023C, 0x023D, 0x023E,
    0x023F, 0x0240, 0x0241, 0x0242, 0x0243, 0x0244, 0x0245, 0x0246, 0x0247,
    0x0248, 0x0249, 0x024A, 0x024B, 0x024C, 0x024D, 0x024E, 0x024F, 0x0250,
    0x0251, 0x0252, 0x0253, 0x0254, 0x0255, 0x0256, 0x0257, 0x0258, 0x0259,
    0x025A, 0x025B, 0x025C, 0x025D, 0x025E, 0x025F, 0x0260, 0x0261, 0x0262,
    0x0263, 0x0264, 0x0265, 0x0266, 0x0267, 0x0268, 0x0269, 0x026A, 0x026B,
    0x026C, 0x026D, 0x026E, 0x026F, 0x0270, 0x0271, 0x0272, 0x0273, 0x0274,
    0x0275, 0x0276, 0x0277, 0x0278, 0x0279, 0x027A, 0x027B, 0x027C, 0x027D,
    0x027E, 0x027F, 0x0280, 0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286,
    0x0287, 0x0288, 0x0289, 0x028A, 0x028B, 0x028C, 0x028D, 0x028E, 0x028F,
    0x0290, 0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297, 0x0298,
    0x0299, 0x029A, 0x029B, 0x029C, 0x029D, 0x029E, 0x029F, 0x02A0, 0x02A1,
    0x02A2, 0x02A3, 0x02A4, 0x02A5, 0x02A6, 0x02A7, 0x02A8, 0x02A9, 0x02AA,
    0x02AB, 0x02AC, 0x02AD, 0x02AE, 0x02AF, 0x02B0, 0x02B1, 0x02B2, 0x02B3,
    0x02B4, 0x02B5, 0x02B6, 0x02B7, 0x02B8, 0x02B9, 0x02BA, 0x02BB, 0x02BC,
    0x02BD, 0x02BE, 0x02BF, 0x02C0, 0x02C1, 0x02C2, 0x02C3, 0x02C4, 0x02C5,
    0x02C6, 0x02C7, 0x02C8, 0x02C9, 0x02CA, 0x02CB, 0x02CC, 0x02CD, 0x02CE,
    0x02CF, 0x02D0, 0x02D1, 0x02D2, 0x02D3, 0x02D4, 0x02D5, 0x02D6, 0x02D7,
    0x02D8, 0x02D9, 0x02DA, 0x02DB, 0x02DC, 0x02DD, 0x02DE, 0x02DF, 0x02E0,
    0x02E1, 0x02E2, 0x02E3, 0x02E4, 0x02E5, 0x02E6, 0x02E7, 0x02E8, 0x02E9,
    0x02EA, 0x02EB, 0x02EC, 0x02ED, 0x02EE, 0x02EF, 0x02F0, 0x02F1, 0x02F2,
    0x02F3, 0x02F4, 0x02F5, 0x02F6, 0x02F7, 0x02F8, 0x02F9, 0x02FA, 0x02FB,
    0x02FC, 0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302, 0x0303, 0x0304,
    0x0305, 0x0306, 0x0307, 0x0308, 0x0309, 0x030A, 0x030B, 0x030C, 0x030D,
    0x030E, 0x030F, 0x0310, 0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316,
    0x0317, 0x0318, 0x0319, 0x031A, 0x031B, 0x031C, 0x031D, 0x031E, 0x031F,
    0x0320, 0x0321, 0x0322, 0x0323, 0x0324, 0x0325, 0x0326, 0x0327, 0x0328,
    0x0329, 0x032A, 0x032B, 0x032C, 0x032D, 0x032E, 0x032F, 0x0330, 0x0331,
    0x0332, 0x0333, 0x0334, 0x0335, 0x0336, 0x0337, 0x0338, 0x0339, 0x033A,
    0x033B, 0x033C, 0x033D, 0x033E, 0x033F, 0x0340, 0x0341, 0x0342, 0x0343,
    0x0344, 0x0345, 0x0346, 0x0347, 0x0348, 0x0349, 0x034A, 0x034B, 0x034C,
    0x034D, 0x034E, 0x034F, 0x0350, 0x0351, 0x0352, 0x0353, 0x0354, 0x0355,
    0x0356, 0x0357, 0x0358, 0x0359, 0x035A, 0x035B, 0x035C, 0x035D, 0x035E,
    0x035F, 0x0360, 0x0361, 0x0362, 0x0363, 0x0364, 0x0365, 0x0366, 0x0367,
    0x0368, 0x0369, 0x036A, 0x036B, 0x036C, 0x036D, 0x036E, 0x036F, 0x0370,
    0x0371, 0x0372, 0x0373, 0x0374, 0x0375, 0x0376, 0x0377, 0x0378, 0x0379,
    0x037A, 0x037B, 0x037C, 0x037D, 0x037E, 0x037F, 0x0380, 0x0381, 0x0382,
    0x0383, 0x0384, 0x0385, 0x0386, 0x0387, 0x0388, 0x0389, 0x038A, 0x038B,
    0x038C, 0x038D, 0x038E, 0x038F, 0x0390, 0x0391, 0x0392, 0x0393, 0x0394,
    0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D,
    0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A2, 0x03A3, 0x03A4, 0x03A5, 0x03A6,
    0x03A7, 0x03A8, 0x03A9, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF,
    0x03B0, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7, 0x03B8,
    0x03B9, 0x03BA, 0x03BB,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1, 0x0421, 0x0422,
    0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042A, 0x042B,
    0x042C, 0x042D, 0x042E, 0x042F, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434,
    0x0435, 0x0436, 0x0437, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D,
    0x043E, 0x043F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446,
    0x0447, 0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F,
    0x0450, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457, 0x0458,
    0x0459, 0x045A, 0x045B, 0x045C, 0x045D, 0x045E, 0x045F, 0x0460, 0x0461,
    0x0462, 0x0463, 0x0464, 0x0465, 0x0466, 0x0467, 0x0468, 0x0469, 0x046A,
    0x046B, 0x046C, 0x046D, 0x046E, 0x046F, 0x0470, 0x0471, 0x0472, 0x0473,
    0x0474, 0x0475, 0x0476, 0x0477, 0x0478, 0x0479, 0x047A, 0x047B, 0x047C,
    0x047D, 0x047E, 0x047F, 0x0480, 0x0481, 0x0482, 0x0483, 0x0484, 0x0485,
    0x0486, 0x0487, 0x0488, 0x0489, 0x048A, 0x048B, 0x048C, 0x048D, 0x048E,
    0x048F, 0x0490, 0x0491, 0x0492, 0x0493,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1
};

const short pdUnifiedTypeMap::fLiveP2MTable[TYPESPACE_MAX] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008,
    0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 0x0010, 0x0011,
    0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x001A,
    0x001B, 0x001C, 0x001D, 0x001E, 0x001F, 0x0020, 0x0140, 0x0022, 0x0023,
    0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002A, 0x002B, 0x002C,
    0x002D, 0x002E, 0x002F, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035,
    0x0036, 0x0037, 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E,
    0x003F, 0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050,
    0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059,
    0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F, 0x0060, 0x0061, 0x0062,
    0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B,
    0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073, 0x0074,
    0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D,
    0x007E, 0x007F, 0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086,
    0x0087, 0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 0x0098,
    0x0099, 0x009A, 0x001D, 0x009C, 0x009D, 0x009E, 0x009F, 0x00A0, 0x00A1,
    0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7, 0x00A8, 0x00A9, 0x00AA,
    0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF, 0x00B0, 0x00B1, 0x00B2, 0x00B3,
    0x00B4, 0x00B5, 0x00B6, 0x00B7, 0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC,
    0x00BD, 0x00BE, 0x00BF, 0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5,
    0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE,
    0x00CF, 0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF, 0x00E0,
    0x00E1, 0x0156, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9,
    0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F0, 0x00F1, 0x00F2,
    0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB,
    0x00FC, 0x00FD, 0x00FE, 0x00FF, 0x0100, 0x0101, 0x0102, 0x0103, 0x0104,
    0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010A, 0x010B, 0x010C, 0x010D,
    0x010E, 0x010F, 0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116,
    0x0117, 0x0118, 0x0119, 0x011A, 0x011B, 0x011C, 0x011D, 0x011E, 0x011F,
    0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 0x0128,
    0x0129, 0x012A, 0x012B, 0x012C, 0x012D, 0x012E, 0x012F, 0x0130, 0x0131,
    0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137, 0x0138, 0x0139, 0x0168,
    0x0169, 0x00E2,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

    0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207, 0x0208,
    0x0209, 0x020A, 0x020B, 0x020C, 0x020D, 0x020E, 0x020F, 0x0210, 0x0211,
    0x0212, 0x0213, 0x0214, 0x0215, 0x0216, 0x0217, 0x0218, 0x0219, 0x021A,
    0x021B, 0x021C, 0x021D, 0x021E, 0x021F, 0x0220, 0x0221, 0x0222, 0x0223,
    0x0224, 0x0225, 0x0226, 0x0227, 0x0228, 0x0229, 0x03C5, 0x03C6, 0x03C7,
    0x03C8, 0x03C9, 0x022A, 0x022B, 0x03CA, 0x022D, 0x022E, 0x022F, 0x0230,
    0x0231, 0x0232, 0x0233, 0x0234, 0x0235, 0x0236, 0x0237, 0x0238, 0x0239,
    0x023A, 0x023B, 0x023C, 0x023D, 0x023E, 0x023F, 0x0240, 0x0241, 0x0242,
    0x0243, 0x0244, 0x0245, 0x0246, 0x0247, 0x0248, 0x0249, 0x024A, 0x024B,
    0x024C, 0x024D, 0x024E, 0x024F, 0x0250, 0x0251, 0x0252, 0x0253, 0x0254,
    0x0255, 0x0256, 0x0257, 0x0258, 0x0259, 0x025A, 0x025B, 0x025C, 0x025D,
    0x025E, 0x025F, 0x0260, 0x0261, 0x0262, 0x0263, 0x0264, 0x0265, 0x0266,
    0x0267, 0x0268, 0x0269, 0x026A, 0x026B, 0x026C, 0x026D, 0x026E, 0x026F,
    0x0270, 0x0271, 0x0272, 0x03BE, 0x0274, 0x0275, 0x0276, 0x0277, 0x0278,
    0x0279, 0x027A, 0x027B, 0x03CB, 0x027D, 0x027E, 0x027F, 0x0280, 0x0281,
    0x0282, 0x0283, 0x0284, 0x0285, 0x0286, 0x0287, 0x0288, 0x0289, 0x028A,
    0x028B, 0x028C, 0x028D, 0x028E, 0x028F, 0x0290, 0x0291, 0x0292, 0x0293,
    0x0294, 0x0295, 0x0296, 0x0297, 0x0298, 0x0299, 0x029A, 0x029B, 0x029C,
    0x029D, 0x029E, 0x029F, 0x02A0, 0x02A1, 0x02A2, 0x02A3, 0x02A4, 0x02A5,
    0x02A6, 0x02A7, 0x02A8, 0x02A9, 0x02AA, 0x02AB, 0x02AC, 0x02AD, 0x02AE,
    0x02AF, 0x02B0, 0x02B1, 0x02B2, 0x02B3, 0x02B4, 0x02B5, 0x02B6, 0x02B7,
    0x02B8, 0x02B9, 0x02BA, 0x02BB, 0x03CF, 0x02BD, 0x02BE, 0x02BF, 0x02C0,
    0x02C1, 0x02C2, 0x02C3, 0x02C4, 0x02C5, 0x02C6, 0x02C7, 0x02C8, 0x02C9,
    0x02CA, 0x02CB, 0x02CC, 0x02CD, 0x02CE, 0x02CF, 0x02D0, 0x02D1, 0x02D2,
    0x02D3, 0x02D4, 0x02D5, 0x02D6, 0x02D7, 0x02D8, 0x02D9, 0x02DA, 0x02DB,
    0x02DC, 0x02DD, 0x02DE, 0x02DF, 0x02E0, 0x02E1, 0x02E2, 0x02E3, 0x02E4,
    0x02E5, 0x02E6, 0x02E7, 0x02E8, 0x02E9, 0x02EA, 0x02EB, 0x02EC, 0x02ED,
    0x02EE, 0x02EF, 0x02F0, 0x02F1, 0x02F2, 0x02F3, 0x02F4, 0x02F5, 0x02F6,
    0x02F7, 0x02F8, 0x02F9, 0x02FA, 0x02FB, 0x02FC, 0x02FD, 0x02FE, 0x02FF,
    0x0300, 0x0301, 0x0302, 0x0303, 0x0304, 0x0305, 0x0306, 0x0307, 0x0308,
    0x0309, 0x030A, 0x030B, 0x030C, 0x030D, 0x030E, 0x030F, 0x0310, 0x0311,
    0x0312, 0x0313, 0x0314, 0x0315, 0x0316, 0x0317, 0x0318, 0x0319, 0x031A,
    0x031B, 0x031C, 0x031D, 0x031E, 0x031F, 0x0320, 0x0321, 0x0322, 0x0323,
    0x0324, 0x0325, 0x0326, 0x0327, 0x0328, 0x0329, 0x032A, 0x032B, 0x032C,
    0x032D, 0x032E, 0x032F, 0x0330, 0x0331, 0x0332, 0x0333, 0x0334, 0x0335,
    0x0336, 0x0337, 0x0338, 0x0339, 0x033A, 0x033B, 0x033C, 0x033D, 0x033E,
    0x033F, 0x0340, 0x0341, 0x0342, 0x0343, 0x0344, 0x0345, 0x0346, 0x0347,
    0x0348, 0x0349, 0x034A, 0x034B, 0x034C, 0x03D2, 0x034E, 0x034F, 0x0350,
    0x0351, 0x0352, 0x0353, 0x0354, 0x0355, 0x0356, 0x0357, 0x0358, 0x0359,
    0x035A, 0x035B, 0x03D3, 0x035D, 0x035E, 0x035F, 0x0360, 0x0361, 0x0362,
    0x0363, 0x0364, 0x0365, 0x0366, 0x0367, 0x03D4, 0x0369, 0x036A, 0x036B,
    0x036C, 0x036D, 0x036E, 0x036F, 0x0370, 0x0371, 0x0372, 0x0373, 0x0374,
    0x0375, 0x0376, 0x0377, 0x0378, 0x0379, 0x037A, 0x037B, 0x037C, 0x037D,
    0x037E, 0x037F, 0x0380, 0x0381, 0x0382, 0x0383, 0x0384, 0x0385, 0x0386,
    0x0387, 0x0388, 0x0389, 0x038A, 0x038B, 0x038C, 0x038D, 0x038E, 0x038F,
    0x0390, 0x0392, 0x03D5, 0x03D6, 0x03D7, 0x03D8, 0x03D9, 0x03DA, 0x03DB,
    0x03DC, 0x03DD, 0x03DE, 0x03DF, 0x039D, 0x039E, 0x039F, 0x03A0, 0x03A1,
    0x03A2, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9, 0x03AA,
    0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF, 0x03B0, 0x03B1, 0x03B2, 0x03B3,
    0x03B4, 0x03B5, 0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x02BC,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426,
    0x0427, 0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,
    0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437, 0x0438,
    0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F, 0x0440, 0x0441,
    0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044A,
    0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 0x0450, 0x0451, 0x0452, 0x0453,
    0x0454, 0x0455, 0x0456, 0x0457, 0x0458, 0x0459, 0x045A, 0x045B, 0x045C,
    0x045D, 0x045E, 0x045F, 0x04DD, 0x04DE, 0x0462, 0x0463, 0x0464, 0x0465,
    0x0466, 0x0467, 0x0468, 0x0469, 0x046A, 0x046B, 0x046C, 0x046D, 0x046E,
    0x046F, 0x0470, 0x0471, 0x0472, 0x0473, 0x04D5, 0x04D6, 0x04D7, 0x04D8,
    0x04D9, 0x04DA, 0x04DB, 0x04DF, 0x04E0, 0x04E1, 0x047E, 0x047F, 0x0480,
    0x0481, 0x0482, 0x0483, 0x0484, 0x0485, 0x0486, 0x0487, 0x0488, 0x0489,
    0x048A, 0x048B, 0x048C, 0x048D, 0x048E, 0x048F, 0x0490, 0x0491, 0x0492,
    0x0493, 0x04DC, 0x04E2, 0x04E3, 0x04E4, 0x04E5,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1
};

const short pdUnifiedTypeMap::fEoaP2MTable[TYPESPACE_MAX] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008,
    0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 0x0010, 0x0011,
    0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x013D, 0x0019, 0x001A,
    0x013E, 0x001C, 0x013F, 0x001E, 0x001F, 0x0020, 0x0141, 0x0142, 0x0138,
    0x0024, 0x0143, 0x0144, 0x0027, 0x0028, 0x0029, 0x002B, 0x002C, 0x002D,
    0x002E, 0x002F, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036,
    0x0037, 0x0038, 0x0039, 0x003A, 0x0145, 0x0146, 0x003D, 0x003E, 0x0040,
    0x0041, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004A,
    0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050, 0x0147, 0x0054, 0x0055,
    0x0056, 0x0057, 0x005D, 0x0148, 0x005B, 0x0149, 0x0062, 0x0063, 0x0065,
    0x0067, 0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006F, 0x0071,
    0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A,
    0x007B, 0x007C, 0x007D, 0x007E, 0x007F, 0x0080, 0x0083, 0x0084, 0x0086,
    0x0087, 0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0096, 0x0097, 0x0098, 0x014A, 0x014B, 0x001D, 0x014C, 0x014D, 0x014E,
    0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7, 0x00A8, 0x00A9,
    0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x014F, 0x00AF, 0x00B0, 0x00B1, 0x0150,
    0x0151, 0x00B4, 0x00B9, 0x00BA, 0x00BB, 0x00BD, 0x00BE, 0x00BF, 0x00C0,
    0x00C1, 0x0152, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, 0x00C8, 0x00C9,
    0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CF, 0x00D0, 0x00D1, 0x00D2, 0x00D3,
    0x00D4, 0x00D5, 0x00D6, 0x00D7, 0x00D8, 0x00DB, 0x00DD, 0x00DE, 0x00DF,
    0x00E0, 0x00E1, 0x00E3, 0x00E4, 0x0153, 0x00E6, 0x00E7, 0x00E8, 0x00E9,
    0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F0, 0x00F1, 0x00F2,
    0x00F4, 0x0154, 0x00F6, 0x00F7, 0x00F9, 0x00FB, 0x00FC, 0x00FD, 0x00FE,
    0x00FF, 0x0105, 0x0106, 0x0107, 0x0108, 0x0155, 0x010A, 0x010B, 0x010C,
    0x010D, 0x010F, 0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116,
    0x0117, 0x0118, 0x0119, 0x011A, 0x011E, 0x011F, 0x0120, 0x0122, 0x0123,
    0x0124, 0x0125, 0x0126, 0x0128, 0x0129, 0x012A, 0x012B, 0x012D, 0x012E,
    0x012F, 0x0130, 0x0131, 0x0132, 0x0157, 0x0135, 0x0158, 0x003F, 0x0159,
    0x015A, 0x015B, 0x015C, 0x015D, 0x015E, 0x015F, 0x0160, 0x0161, 0x0162,
    0x0137, 0x0163, 0x0164, 0x0139, 0x0165, 0x0166, 0x0167,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

    0x03C0, 0x0202, 0x0203, 0x0205, 0x0206, 0x0207, 0x020A, 0x020B, 0x020C,
    0x03C1, 0x020E, 0x020F, 0x0210, 0x03C2, 0x03C3, 0x03BD, 0x03C4, 0x0219,
    0x021A, 0x021B, 0x03C5, 0x0226, 0x0227, 0x0228, 0x0229, 0x022A, 0x022B,
    0x03CA, 0x022D, 0x022E, 0x022F, 0x0230, 0x0231, 0x0232, 0x0233, 0x0234,
    0x0235, 0x0236, 0x0237, 0x0238, 0x0239, 0x023A, 0x023B, 0x023C, 0x023F,
    0x0241, 0x0242, 0x0243, 0x0244, 0x0248, 0x024A, 0x024B, 0x024C, 0x024D,
    0x024E, 0x024F, 0x0250, 0x0251, 0x0252, 0x0253, 0x0254, 0x0255, 0x0256,
    0x0257, 0x0258, 0x0268, 0x0269, 0x026B, 0x0272, 0x0273, 0x027E, 0x027F,
    0x028F, 0x0292, 0x0293, 0x0294, 0x0295, 0x0299, 0x029A, 0x029B, 0x029C,
    0x029D, 0x029E, 0x029F, 0x02A0, 0x02A1, 0x02A2, 0x02A3, 0x02A4, 0x02A5,
    0x02B4, 0x02BB, 0x02C7, 0x02CC, 0x02CD, 0x02D1, 0x02D2, 0x02D3, 0x02D4,
    0x02D5, 0x02D6, 0x02D7, 0x02D8, 0x02D9, 0x02DB, 0x02DC, 0x02DD, 0x02DE,
    0x02DF, 0x02E0, 0x02E1, 0x02E2, 0x02E5, 0x02E6, 0x02E8, 0x02EB, 0x02ED,
    0x02EE, 0x02EF, 0x02F0, 0x02F1, 0x02F2, 0x02F3, 0x02F4, 0x02F5, 0x02F6,
    0x02F7, 0x02F8, 0x02F9, 0x02FB, 0x02FC, 0x02FD, 0x0301, 0x0302, 0x0305,
    0x0306, 0x0307, 0x0308, 0x0309, 0x030A, 0x030B, 0x030C, 0x030D, 0x030E,
    0x030F, 0x0310, 0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316, 0x0319,
    0x031A, 0x031B, 0x0325, 0x0328, 0x032B, 0x032C, 0x032D, 0x032E, 0x032F,
    0x0330, 0x0331, 0x0332, 0x0333, 0x0334, 0x0335, 0x0336, 0x0337, 0x0338,
    0x0339, 0x033A, 0x033B, 0x033C, 0x033D, 0x033E, 0x033F, 0x0340, 0x0341,
    0x03CC, 0x034B, 0x034F, 0x0354, 0x0356, 0x03CD, 0x0359, 0x035B, 0x035D,
    0x035E, 0x03CE, 0x0361, 0x0362, 0x0363, 0x0365, 0x03D0, 0x036B, 0x036C,
    0x0387, 0x038A, 0x03D1, 0x038C, 0x038D, 0x038E, 0x038F, 0x0390, 0x0392,
    0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A2, 0x03A3, 0x03A4, 0x03A5, 0x03A8,
    0x03A9, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03B1, 0x03BB, 0x0425, 0x0448,
    0x0449, 0x044A, 0x044B, 0x044C, 0x044E, 0x0450, 0x0451, 0x0452, 0x0455,
    0x0456, 0x0457, 0x045A, 0x045D, 0x0484, 0x0485, 0x0486, 0x0487, 0x0488,
    0x048C, 0x0491, 0x0492, 0x0494, 0x0495, 0x031D, 0x045F, 0x0496, 0x0497,
    0x0498, 0x0499, 0x049A, 0x049B, 0x049C, 0x049D, 0x049E, 0x049F, 0x04A0,
    0x04A1, 0x04A2, 0x04A3, 0x04A4, 0x04A5, 0x04A6, 0x04A7, 0x04A8, 0x04A9,
    0x04AA, 0x04AB, 0x04AC, 0x04AD, 0x04AE, 0x04AF, 0x04B0, 0x04B1, 0x04B2,
    0x04B3, 0x04B4, 0x04B5, 0x04B6, 0x04B7, 0x04B8, 0x04B9, 0x04BA, 0x04BB,
    0x04BC, 0x04BD, 0x04BE, 0x04BF, 0x04C0, 0x04C1, 0x04C2, 0x04C3, 0x04C4,
    0x04C5, 0x04C6, 0x04C7, 0x04C8, 0x04C9, 0x04CA, 0x04CB, 0x04CC, 0x04CD,
    0x04CE, 0x04CF, 0x04D0, 0x04D1, 0x04D2, 0x03BE, 0x04D3, 0x04D4,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1
};

const short pdUnifiedTypeMap::fHexP2MTable[TYPESPACE_MAX] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008,
    0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 0x0010, 0x0011,
    0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x013D, 0x016A, 0x001A,
    0x016B, 0x001C, 0x013F, 0x001E, 0x001F, 0x0020, 0x0141, 0x0142, 0x0138,
    0x0024, 0x0143, 0x0144, 0x0027, 0x0028, 0x0029, 0x002B, 0x002C, 0x002D,
    0x002E, 0x002F, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036,
    0x0037, 0x0038, 0x0039, 0x003A, 0x0145, 0x0146, 0x003D, 0x003E, 0x0040,
    0x0041, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004A,
    0x004B, 0x004C, 0x016C, 0x004E, 0x004F, 0x0050, 0x0147, 0x0054, 0x0055,
    0x0056, 0x0057, 0x005D, 0x0148, 0x005B, 0x0149, 0x0062, 0x0063, 0x0065,
    0x0067, 0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006F, 0x0071,
    0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A,
    0x007B, 0x007C, 0x007D, 0x007E, 0x007F, 0x0080, 0x0083, 0x0084, 0x0086,
    0x0087, 0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0096, 0x0097, 0x0098, 0x014A, 0x014B, 0x001D, 0x014C, 0x014D, 0x014E,
    0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7, 0x00A8, 0x00A9,
    0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x014F, 0x00AF, 0x00B0, 0x00B1, 0x0150,
    0x016D, 0x00B4, 0x00B9, 0x00BA, 0x00BB, 0x00BD, 0x00BE, 0x00BF, 0x00C0,
    0x00C1, 0x0152, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, 0x00C8, 0x00C9,
    0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CF, 0x00D0, 0x00D1, 0x00D2, 0x00D3,
    0x00D4, 0x00D5, 0x00D6, 0x00D7, 0x00D8, 0x00DB, 0x00DD, 0x00DE, 0x00DF,
    0x00E0, 0x00E1, 0x00E3, 0x00E4, 0x0153, 0x00E6, 0x00E7, 0x00E8, 0x00E9,
    0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F0, 0x00F1, 0x00F2,
    0x00F4, 0x0154, 0x00F6, 0x00F7, 0x00F9, 0x00FB, 0x00FC, 0x00FD, 0x00FE,
    0x00FF, 0x0105, 0x0106, 0x0107, 0x0108, 0x0155, 0x010A, 0x016E, 0x010C,
    0x010D, 0x010F, 0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116,
    0x0117, 0x0118, 0x0119, 0x011A, 0x011E, 0x011F, 0x0120, 0x0122, 0x0123,
    0x0124, 0x0125, 0x0126, 0x0128, 0x0129, 0x012A, 0x012B, 0x012D, 0x012E,
    0x012F, 0x0130, 0x0131, 0x0132, 0x0157, 0x0135, 0x0158, 0x003F, 0x0159,
    0x015A, 0x015B, 0x016F, 0x015D, 0x015E, 0x015F, 0x0160, 0x0161, 0x0162,
    0x0137, 0x0163, 0x0164, 0x0139, 0x0165, 0x0166, 0x0167, 0x0170,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

    0x03C0, 0x0202, 0x0203, 0x0205, 0x0206, 0x0207, 0x020A, 0x020B, 0x020C,
    0x03C1, 0x020E, 0x020F, 0x0210, 0x03C2, 0x03C3, 0x03E0, 0x03C4, 0x0219,
    0x021A, 0x021B, 0x03C5, 0x03E1, 0x03E2, 0x03E3, 0x03E4, 0x022A, 0x022B,
    0x03CA, 0x03E5, 0x03E6, 0x022F, 0x0230, 0x0231, 0x0232, 0x0233, 0x0234,
    0x0235, 0x0236, 0x0237, 0x0238, 0x0239, 0x023A, 0x023B, 0x023C, 0x023F,
    0x0241, 0x0242, 0x0243, 0x0244, 0x0248, 0x024A, 0x024B, 0x024C, 0x024D,
    0x024E, 0x024F, 0x0250, 0x0251, 0x0252, 0x0253, 0x0254, 0x0255, 0x0256,
    0x0257, 0x0258, 0x0268, 0x0269, 0x026B, 0x0272, 0x0273, 0x027E, 0x027F,
    0x028F, 0x0292, 0x0293, 0x0294, 0x0295, 0x0299, 0x029A, 0x029B, 0x029C,
    0x029D, 0x029E, 0x029F, 0x02A0, 0x02A1, 0x02A2, 0x02A3, 0x02A4, 0x02A5,
    0x02B4, 0x02BB, 0x02C7, 0x02CC, 0x02CD, 0x02D1, 0x02D2, 0x02D3, 0x02D4,
    0x02D5, 0x02D6, 0x02D7, 0x02D8, 0x02D9, 0x02DB, 0x02DC, 0x02DD, 0x02DE,
    0x02DF, 0x02E0, 0x02E1, 0x02E2, 0x02E5, 0x02E6, 0x02E8, 0x02EB, 0x02ED,
    0x02EE, 0x02EF, 0x02F0, 0x02F1, 0x02F2, 0x02F3, 0x02F4, 0x02F5, 0x02F6,
    0x02F7, 0x02F8, 0x02F9, 0x02FB, 0x02FC, 0x02FD, 0x0301, 0x0302, 0x0305,
    0x0306, 0x0307, 0x0308, 0x0309, 0x030A, 0x030B, 0x030C, 0x030D, 0x030E,
    0x030F, 0x0310, 0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316, 0x0319,
    0x031A, 0x031B, 0x0325, 0x0328, 0x032B, 0x032C, 0x032D, 0x032E, 0x032F,
    0x0330, 0x0331, 0x0332, 0x0333, 0x0334, 0x0335, 0x0336, 0x0337, 0x0338,
    0x0339, 0x033A, 0x033B, 0x033C, 0x033D, 0x033E, 0x033F, 0x0340, 0x0341,
    0x03CC, 0x034B, 0x034F, 0x0354, 0x0356, 0x03CD, 0x0359, 0x035B, 0x035D,
    0x035E, 0x03CE, 0x0361, 0x0362, 0x0363, 0x0365, 0x03D0, 0x036B, 0x036C,
    0x0387, 0x038A, 0x03D1, 0x038C, 0x038D, 0x038E, 0x038F, 0x0390, 0x0392,
    0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A2, 0x03E7, 0x03A4, 0x03A5, 0x03A8,
    0x03A9, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03B1, 0x03BB, 0x0425, 0x0448,
    0x0449, 0x044A, 0x044B, 0x044C, 0x044E, 0x0450, 0x0451, 0x0452, 0x0455,
    0x0456, 0x0457, 0x045A, 0x045D, 0x0484, 0x0485, 0x0486, 0x0487, 0x0488,
    0x048C, 0x0491, 0x0492, 0x0494, 0x0495, 0x031D, 0x045F, 0x0496, 0x0497,
    0x0498, 0x0499, 0x049A, 0x049B, 0x049C, 0x049D, 0x049E, 0x049F, 0x04A0,
    0x04A1, 0x04A2, 0x04A3, 0x04A4, 0x04A5, 0x04A6, 0x04A7, 0x04A8, 0x04A9,
    0x04AA, 0x04AB, 0x04AC, 0x04AD, 0x04AE, 0x04AF, 0x04B0, 0x04B1, 0x04B2,
    0x04B3, 0x04B4, 0x04B5, 0x04B6, 0x04B7, 0x04B8, 0x04B9, 0x04BA, 0x04BB,
    0x04BC, 0x04BD, 0x04BE, 0x04BF, 0x04C0, 0x04C1, 0x04C2, 0x04C3, 0x04C4,
    0x04C5, 0x04C6, 0x04C7, 0x04C8, 0x04C9, 0x04CA, 0x04CB, 0x04CC, 0x04CD,
    0x04CE, 0x04CF, 0x04D0, 0x04D1, 0x04D2, 0x03BE, 0x04D3, 0x04D4, 0x0216,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,

        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
        -1,     -1,     -1,     -1
};

const short pdUnifiedTypeMap::fLiveVerTable[TYPESPACE_MAX] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,
     0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,

     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,

     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
};

const short pdUnifiedTypeMap::fEoaVerTable[TYPESPACE_MAX] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  7,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 10,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  7,  0,  7,  7,  7,  0,
     0,  0,  7,  0,  0,  7,  0,  0,  0,  0,  0,  0,  7,  0,  0,  0,
     0,  0,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,

     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,

     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
};

const short pdUnifiedTypeMap::fHexVerTable[TYPESPACE_MAX] = {
//TODO: Probably incorrect...
     0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  7,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 10,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  8,  0,
     0,  0,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  7,  0,  7,  7,  7,  0,
     0,  0,  7,  0,  0,  7,  0,  0,  0,  0,  0,  0,  7,  0,  0,  0,
     0,  0,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,

     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,

     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
};

short pdUnifiedTypeMap::fCurrentVerTable[TYPESPACE_MAX] = {0};

const char* pdUnifiedTypeMap::fClassNames[TYPESPACE_MAX] = {
    "plSceneNode", "plSceneObject", "hsKeyedObject", "plBitmap", "plMipmap",
    "plCubicEnvironmap", "plLayer", "hsGMaterial", "plParticleSystem",
    "plParticleEffect", "plParticleCollisionEffectBeat",
    "plParticleFadeVolumeEffect", "plBoundInterface", "plRenderTarget",
    "plCubicRenderTarget", "plCubicRenderTargetModifier", "plObjInterface",
    "plAudioInterface", "plAudible", "plAudibleNull", "plWinAudible",
    "plCoordinateInterface", "plDrawInterface", "plDrawable", "plDrawableMesh",
    "plDrawableIce", "plPhysical", "plPhysicalMesh", "plSimulationInterface",
    "plCameraModifier", "plModifier", "plSingleModifier", "plSimpleModifier",
    "plSimpleTMModifier", "plRandomTMModifier", "plInterestingModifier",
    "plDetectorModifier", "plSimplePhysicalMesh", "plCompoundPhysicalMesh",
    "plMultiModifier", "plSynchedObject", "plSoundBuffer", "plAliasModifier",
    "plPickingDetector", "plCollisionDetector", "plLogicModifier",
    "plConditionalObject", "plANDConditionalObject", "plORConditionalObject",
    "plPickedConditionalObject", "plActivatorConditionalObject",
    "plTimerCallbackManager", "plKeyPressConditionalObject",
    "plAnimationEventConditionalObject", "plControlEventConditionalObject",
    "plObjectInBoxConditionalObject", "plLocalPlayerInBoxConditionalObject",
    "plObjectIntersectPlaneConditionalObject",
    "plLocalPlayerIntersectPlaneConditionalObject", "plPortalDrawable",
    "plPortalPhysical", "plSpawnModifier", "plFacingConditionalObject",
    "plGenericPhysical", "plViewFaceModifier", "plLayerInterface",
    "plLayerWrapper", "plLayerAnimation", "plLayerDepth", "plLayerMovie",
    "plLayerBink", "plLayerAVI", "plSound", "plWin32Sound", "plLayerOr",
    "plAudioSystem", "plDrawableSpans", "plDrawablePatchSet", "plInputManager",
    "plLogicModBase", "plFogEnvironment", "plNetApp", "plNetClientMgr",
    "pl2WayWinAudible", "plLightInfo", "plDirectionalLightInfo",
    "plOmniLightInfo", "plSpotLightInfo", "plLightSpace", "plNetClientApp",
    "plNetServerApp", "plClient", "plCompoundTMModifier", "plCameraBrain",
    "plCameraBrain_Default", "plCameraBrain_Drive", "plCameraBrain_Fixed",
    "plCameraBrain_FixedPan", "pfGUIClickMapCtrl", "plListener", "plAvatarMod",
    "plAvatarAnim", "plAvatarAnimMgr", "plOccluder", "plMobileOccluder",
    "plLayerShadowBase", "plLimitedDirLightInfo", "plAGAnim", "plAGModifier",
    "plAGMasterMod", "plCameraBrain_Avatar", "plCameraRegionDetector",
    "plCameraBrain_FP", "plLineFollowMod", "plLightModifier", "plOmniModifier",
    "plSpotModifier", "plLtdDirModifier", "plSeekPointMod", "plOneShotMod",
    "plRandomCommandMod", "plRandomSoundMod", "plPostEffectMod",
    "plObjectInVolumeDetector", "plResponderModifier", "plAxisAnimModifier",
    "plLayerLightBase", "plFollowMod", "plTransitionMgr", "plInventoryMod",
    "plInventoryObjMod", "plLinkEffectsMgr", "plWin32StreamingSound",
    "plPythonMod", "plActivatorActivatorConditionalObject", "plSoftVolume",
    "plSoftVolumeSimple", "plSoftVolumeComplex", "plSoftVolumeUnion",
    "plSoftVolumeIntersect", "plSoftVolumeInvert", "plWin32LinkSound",
    "plLayerLinkAnimation", "plArmatureMod", "plCameraBrain_Freelook",
    "plHavokConstraintsMod", "plHingeConstraintMod", "plWheelConstraintMod",
    "plStrongSpringConstraintMod", "plArmatureLODMod", "plWin32StaticSound",
    "pfGameGUIMgr", "pfGUIDialogMod", "plCameraBrain1", "plVirtualCam1",
    nullptr, "plCameraBrain1_Drive", "plCameraBrain1_POA",
    "plCameraBrain1_Avatar", "plCameraBrain1_Fixed", "plCameraBrain1_POAFixed",
    "pfGUIButtonMod", "plPythonFileMod", "pfGUIControlMod",
    "plExcludeRegionModifier", "pfGUIDraggableMod",
    "plVolumeSensorConditionalObject", "plVolActivatorConditionalObject",
    "plMsgForwarder", "plBlower", "pfGUIListBoxMod", "pfGUITextBoxMod",
    "pfGUIEditBoxMod", "plDynamicTextMap", "plSittingModifier",
    "pfGUIUpDownPairMod", "pfGUIValueCtrl", "pfGUIKnobCtrl", "plAvLadderMod",
    "plCameraBrain1_FirstPerson", "plCloneSpawnModifier", "plClothingItem",
    "plClothingOutfit", "plClothingBase", "plClothingMgr", "pfGUIDragBarCtrl",
    "pfGUICheckBoxCtrl", "pfGUIRadioGroupCtrl", "pfPlayerBookMod",
    "pfGUIDynDisplayCtrl", "plLayerProject", "plInputInterfaceMgr",
    "plRailCameraMod", "plMultistageBehMod", "plCameraBrain1_Circle",
    "plParticleWindEffect", "plAnimEventModifier", "plAutoProfile", "pfGUISkin",
    "plAVIWriter", "plParticleCollisionEffect", "plParticleCollisionEffectDie",
    "plParticleCollisionEffectBounce", "plInterfaceInfoModifier",
    "plSharedMesh", "plArmatureEffectsMgr", "pfMarkerMgr", "plVehicleModifier",
    "plParticleLocalWind", "plParticleUniformWind", "plInstanceDrawInterface",
    "plShadowMaster", "plShadowCaster", "plPointShadowMaster",
    "plDirectShadowMaster", "plSDLModifier", "plPhysicalSDLModifier",
    "plClothingSDLModifier", "plAvatarSDLModifier", "plAGMasterSDLModifier",
    "plPythonSDLModifier", "plLayerSDLModifier", "plAnimTimeConvertSDLModifier",
    "plResponderSDLModifier", "plSoundSDLModifier", "plResManagerHelper",
    "plHKSubWorld", "plArmatureEffect", "plArmatureEffectFootSound",
    "plEAXListenerMod", "plDynaDecalMgr", "plObjectInVolumeAndFacingDetector",
    "plDynaFootMgr", "plDynaRippleMgr", "plDynaBulletMgr", "plDecalEnableMod",
    "plPrintShape", "plDynaPuddleMgr", "pfGUIMultiLineEditCtrl",
    "plLayerAnimationBase", "plLayerSDLAnimation", "plATCAnim",
    "plAgeGlobalAnim", "plSubworldRegionDetector", "plAvatarMgr",
    "plNPCSpawnMod", "plActivePrintShape", "plExcludeRegionSDLModifier",
    "plLOSDispatch", "plDynaWakeMgr", "plSimulationMgr", "plWaveSet7",
    "plPanicLinkRegion", "plWin32GroupedSound", "plFilterCoordInterface",
    "plStereizer", "plCCRMgr", "plCCRSpecialist", "plCCRSeniorSpecialist",
    "plCCRShiftSupervisor", "plCCRGameOperator", "plShader", "plDynamicEnvMap",
    "plSimpleRegionSensor", "plMorphSequence", "plEmoteAnim",
    "plDynaRippleVSMgr", "plWaveSet6", "pfGUIProgressCtrl",
    "plMaintainersMarkerModifier", "plMorphSequenceSDLMod", "plMorphDataSet",
    "plHardRegion", "plHardRegionPlanes", "plHardRegionComplex",
    "plHardRegionUnion", "plHardRegionIntersect", "plHardRegionInvert",
    "plVisRegion", "plVisMgr", "plRegionBase", "pfGUIPopUpMenu", "pfGUIMenuItem",
    "plCoopCoordinator", "plFont", "plFontCache", "plRelevanceRegion",
    "plRelevanceMgr", "pfJournalBook", "plLayerTargetContainer",
    "plImageLibMod", "plParticleFlockEffect", "plParticleSDLMod", "plAgeLoader",
    "plWaveSetBase", "plPhysicalSndGroup", "pfBookData", "plDynaTorpedoMgr",
    "plDynaTorpedoVSMgr", "plClusterGroup", "plGameMarkerModifier",
    "plLODMipmap", "plSwimDetector", "plFadeOpacityMod", "plFadeOpacityLay",
    "plDistOpacityMod", "plArmatureModBase", "plSwimRegionInterface",
    "plSwimCircularCurrentRegion", "plParticleFollowSystemEffect",
    "plSwimStraightCurrentRegion", "pfObjectFlocker", "plGrassShaderMod",
    "plDynamicCamMap", nullptr, nullptr, nullptr, "plAutoWalkRegion",
    "plCrossfade", "plParticleFadeOutEffect", "pfSecurePreloader",
    "plWindBoneMod", "plCameraBrain_NovicePlus", "pfSubtitleMgr",
    "plPythonFileModConditionalObject", "plLayerTransform",
    "plBubbleShaderMod", "plLineFollowModBase", "plClientApp",
    "pfGUICreditsCtrl", "plCameraBrainUru", "plVirtualCamera",
    "plCameraBrainUru_Drive", "plCameraBrainUru_Follow",
    "plCameraBrainUru_Fixed", "pfGUISketchCtrl", "plLadderModifier",
    "plCameraBrainUru_FirstPerson", "plCameraBrainUru_Circle",
    "plEAXReverbEffect", "plSpawnMod", "plCameraBrain_Novice",
    "plAvatarPhysicalSDLModifier", "plDirectMusicSound", "plClientSessionMgr",
    "plSDLVarChangeNotifier", "plInterestWellModifier", "plElevatorModifier",
    "plCameraBrain_Expert", "plPagingRegionModifier", "plGuidepathModifier",
    "pfNodeMgr", "plEAXEffect", "plEAXPitchShifter", "plIKModifier",
    "plCameraBrain_M5", "plAGAnimBink", "plTreeShader", "plNodeRegionModifier",
    "plPiranhaRegionModifier", "plRidingAnimatedPhysicalDetector",
    "plVolumeSensorConditionalObjectNoArbitration", "plFXMaterial",
    "plMovableMod", "plMaterial", "plEffect", "plParticleBulletEffect",
    "plCameraBrain_Ground", "plCameraBrain_Flight", nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr,

    "plObjRefMsg", "plNodeRefMsg", "plMessage", "plRefMsg", "plGenRefMsg",
    "plTimeMsg", "plAnimCmdMsg", "plParticleUpdateMsg", "plLayRefMsg",
    "plMatRefMsg", "plCameraMsg", "plInputEventMsg", "plKeyEventMsg",
    "plMouseEventMsg", "plEvalMsg", "plTransformMsg", "plControlEventMsg",
    "plVaultCCRNode", "plLOSRequestMsg", "plLOSHitMsg", "plSingleModMsg",
    "plMultiModMsg", "plAvatarPhysicsEnableCallbackMsg", "plMemberUpdateMsg",
    "plNetMsgPagingRoom", "plActivatorMsg", "plDispatch", "plReceiver",
    "plMeshRefMsg", "hsGRenderProcs", "hsSfxAngleFade", "hsSfxDistFade",
    "hsSfxDistShade", "hsSfxGlobalShade", "hsSfxIntenseAlpha",
    "hsSfxObjDistFade", "hsSfxObjDistShade", "hsDynamicValue",
    "hsDynamicScalar", "hsDynamicColorRGBA", "hsDynamicMatrix33",
    "hsDynamicMatrix44", "plController", "plLeafController",
    "plScaleController", "plRotController", "plPosController",
    "plScalarController", "plPoint3Controller", "plScaleValueController",
    "plQuatController", "plMatrix33Controller", "plMatrix44Controller",
    "plEaseController", "plSimpleScaleController", "plSimpleRotController",
    "plCompoundRotController", "plSimplePosController",
    "plCompoundPosController", "plTMController", "hsFogControl", "plIntRefMsg",
    "plCollisionReactor", "plCorrectionMsg", "plPhysicalModifier",
    "plPickedMsg", "plCollideMsg", "plTriggerMsg", "plInterestingModMsg",
    "plDebugKeyEventMsg", "plPhysicalProperties", "plSimplePhys",
    "plMatrixUpdateMsg", "plCondRefMsg", "plTimerCallbackMsg",
    "plEventCallbackMsg", "plSpawnModMsg", "plSpawnRequestMsg",
    "plLoadCloneMsg", "plEnableMsg", "plWarpMsg", "plAttachMsg", "pfConsole",
    "plRenderMsg", "plAnimTimeConvert", "plSoundMsg", "plInterestingPing",
    "plNodeCleanupMsg", "plSpaceTree", "plNetMessage", "plNetMsgJoinReq",
    "plNetMsgJoinAck", "plNetMsgLeave", "plNetMsgPing", "plNetMsgRoomsList",
    "plNetMsgGroupOwner", "plNetMsgGameStateRequest", "plNetMsgSessionReset",
    "plNetMsgOmnibus", "plNetMsgObject", "plCCRInvisibleMsg", "plLinkInDoneMsg",
    "plNetMsgGameMessage", "plNetMsgStream", "plAudioSysMsg", "plDispatchBase",
    "plServerReplyMsg", "plDeviceRecreateMsg", "plNetMsgStreamHelper",
    "plNetMsgObjectHelper", "plIMouseXEventMsg", "plIMouseYEventMsg",
    "plIMouseBEventMsg", "plLogicTriggerMsg", "plPipeline", "plDX8Pipeline",
    "plNetMsgVoice", "plLightRefMsg", "plNetMsgStreamedObject",
    "plNetMsgSharedState", "plNetMsgTestAndSet", "plNetMsgGetSharedState",
    "plSharedStateMsg", "plNetGenericServerTask",
    "plNetLookupServerGetAgeInfoFromVaultTask", "plLoadAgeMsg",
    "plMessageWithCallbacks", "plClientMsg", "plClientRefMsg",
    "plNetMsgObjStateRequest", "plCCRPetitionMsg", "plVaultCCRInitializationTask",
    "plNetServerMsg", "plNetServerMsgWithContext", "plNetServerMsgRegisterServer",
    "plNetServerMsgUnregisterServer", "plNetServerMsgStartProcess",
    "plNetServerMsgRegisterProcess", "plNetServerMsgUnregisterProcess",
    "plNetServerMsgFindProcess", "plNetServerMsgProcessFound",
    "plNetMsgRoutingInfo", "plNetServerSessionInfo", "plSimulationMsg",
    "plSimulationSynchMsg", "plHKSimulationSynchMsg", "plAvatarMsg",
    "plAvTaskMsg", "plAvSeekMsg", "plAvOneShotMsg", "plSatisfiedMsg",
    "plNetMsgObjectListHelper", "plNetMsgObjectUpdateFilter", "plProxyDrawMsg",
    "plSelfDestructMsg", "plSimInfluenceMsg", "plForceMsg", "plOffsetForceMsg",
    "plTorqueMsg", "plImpulseMsg", "plOffsetImpulseMsg", "plAngularImpulseMsg",
    "plDampMsg", "plShiftMassMsg", "plSimStateMsg", "plFreezeMsg",
    "plEventGroupMsg", "plSuspendEventMsg", "plNetMsgMembersListReq",
    "plNetMsgMembersList", "plNetMsgMemberInfoHelper",
    "plNetMsgMemberListHelper", "plNetMsgMemberUpdate", "plNetMsgServerToClient",
    "plNetMsgCreatePlayer", "plNetMsgAuthenticateHello",
    "plNetMsgAuthenticateChallenge", "plConnectedToVaultMsg",
    "plCCRCommunicationMsg", "plNetMsgInitialAgeStateSent",
    "plInitialAgeStateLoadedMsg", "plNetServerMsgFindServerBase",
    "plNetServerMsgFindServerReplyBase", "plNetServerMsgFindAuthServer",
    "plNetServerMsgFindAuthServerReply", "plNetServerMsgFindVaultServer",
    "plNetServerMsgFindVaultServerReply", "plAvTaskSeekDoneMsg",
    "plAvatarSpawnNotifyMsg", "plNetServerMsgVaultTask", "plNetMsgVaultTask",
    "plAgeLinkStruct", "plVaultAgeInfoNode", "plNetMsgStreamableHelper",
    "plNetMsgReceiversListHelper", "plNetMsgListenListUpdate",
    "plNetServerMsgPing", "plNetMsgAlive", "plNetMsgTerminated",
    "plSDLModifierMsg", "plNetMsgSDLState", "plNetServerMsgSessionReset",
    "plCCRBanLinkingMsg", "plCCRSilencePlayerMsg", "plRenderRequestMsg",
    "plRenderRequestAck", "plNetMember", "plNetGameMember",
    "plNetTransportMember", "plConvexVolume", "plParticleGenerator",
    "plSimpleParticleGenerator", "plParticleEmitter", "plAGChannel",
    "plMatrixChannel", "plMatrixTimeScale", "plMatrixBlend",
    "plMatrixControllerChannel", "plQuatPointCombine", "plPointChannel",
    "plPointConstant", "plPointBlend", "plQuatChannel", "plQuatConstant",
    "plQuatBlend", "plLinkToAgeMsg", "plPlayerPageMsg", "plCmdIfaceModMsg",
    "plNetServerMsgPlsUpdatePlayer", "plListenerMsg", "plAnimPath",
    "plClothingUpdateBCMsg", "plNotifyMsg", "plFakeOutMsg",
    "plCursorChangeMsg", "plNodeChangeMsg", "plAvEnableMsg", "plLinkCallbackMsg",
    "plTransitionMsg", "plConsoleMsg", "plVolumeIsect", "plSphereIsect",
    "plConeIsect", "plCylinderIsect", "plParallelIsect", "plConvexIsect",
    "plComplexIsect", "plUnionIsect", "plIntersectionIsect", "plModulator",
    "plInventoryMsg", "plLinkEffectsTriggerMsg", "plLinkEffectBCMsg",
    "plResponderEnableMsg", "plNetServerMsgHello", "plNetServerMsgHelloReply",
    "plNetServerMember", "plResponderMsg", "plOneShotMsg",
    "plVaultAgeInfoListNode", "plNetServerMsgServerRegistered",
    "plPointTimeScale", "plPointControllerChannel", "plQuatTimeScale",
    "plAGApplicator", "plMatrixChannelApplicator", "plPointChannelApplicator",
    "plLightDiffuseApplicator", "plLightAmbientApplicator",
    "plLightSpecularApplicator", "plOmniApplicator", "plQuatChannelApplicator",
    "plScalarChannel", "plScalarTimeScale", "plScalarBlend",
    "plScalarControllerChannel", "plScalarChannelApplicator",
    "plSpotInnerApplicator", "plSpotOuterApplicator",
    "plNetServerMsgPlsRoutableMsg", "plPuppetBrainMsg", "plATCEaseCurve",
    "plConstAccelEaseCurve", "plSplineEaseCurve",
    "plVaultAgeInfoInitializationTask", "pfGameGUIMsg",
    "plNetServerMsgVaultRequestGameState", "plNetServerMsgVaultGameState",
    "plNetServerMsgVaultGameStateSave", "plNetServerMsgVaultGameStateSaved",
    "plNetServerMsgVaultGameStateLoad", "plNetClientTask",
    "plNetMsgSDLStateBCast", "plReplaceGeometryMsg",
    "plNetServerMsgExitProcess", "plNetServerMsgSaveGameState",
    "plDniCoordinateInfo", "plNetMsgGameMessageDirected", "plLinkOutUnloadMsg",
    "plScalarConstant", "plMatrixConstant", "plAGCmdMsg",
    "plParticleTransferMsg", "plParticleKillMsg", "plExcludeRegionMsg",
    "plOneTimeParticleGenerator", "plParticleApplicator",
    "plParticleLifeMinApplicator", "plParticleLifeMaxApplicator",
    "plParticlePPSApplicator", "plParticleAngleApplicator",
    "plParticleVelMinApplicator", "plParticleVelMaxApplicator",
    "plParticleScaleMinApplicator", "plParticleScaleMaxApplicator",
    "plDynamicTextMsg", "plCameraTargetFadeMsg", "plAgeLoadedMsg",
    "plPointControllerCacheChannel", "plScalarControllerCacheChannel",
    "plLinkEffectsTriggerPrepMsg", "plLinkEffectPrepBCMsg",
    "plAvatarInputStateMsg", "plAgeInfoStruct", "plSDLNotificationMsg",
    "plNetClientConnectAgeVaultTask", "plLinkingMgrMsg", "plVaultNotifyMsg",
    "plPlayerInfo", "plSwapSpansRefMsg", "pfKI", "plDISpansMsg",
    "plNetMsgCreatableHelper", "plServerGuid", "plNetMsgRequestMyVaultPlayerList",
    "plDelayedTransformMsg", "plSuperVNodeMgrInitTask", "plElementRefMsg",
    "plClothingMsg", "plEventGroupEnableMsg", "pfGUINotifyMsg", "plAvBrain",
    "plArmatureBrain", "plAvBrainHuman", "plAvBrainCritter", "plAvBrainDrive",
    "plAvBrainSample", "plAvBrainGeneric", "plAvBrainPuppet", "plAvBrainLadder",
    "plInputIfaceMgrMsg", "pfKIMsg", "plRemoteAvatarInfoMsg",
    "plMatrixDelayedCorrectionApplicator", "plAvPushBrainMsg", "plAvPopBrainMsg",
    "plRoomLoadNotifyMsg", "plAvTask", "plAvAnimTask", "plAvSeekTask",
    "plAvBlendedSeekTask", "plAvOneShotTask", "plAvEnableTask", "plAvTaskBrain",
    "plAnimStage", "plNetClientMember", "plNetClientCommTask",
    "plNetServerMsgAuthRequest", "plNetServerMsgAuthReply",
    "plNetClientCommAuthTask", "plClientGuid", "plNetMsgVaultPlayerList",
    "plNetMsgSetMyActivePlayer", "plNetServerMsgRequestAccountPlayerList",
    "plNetServerMsgAccountPlayerList", "plNetMsgPlayerCreated",
    "plNetServerMsgVaultCreatePlayer", "plNetServerMsgVaultPlayerCreated",
    "plNetMsgFindAge", "plNetMsgFindAgeReply", "plNetClientConnectPrepTask",
    "plNetClientAuthTask", "plNetClientGetPlayerVaultTask",
    "plNetClientSetActivePlayerTask", "plNetClientFindAgeTask",
    "plNetClientLeaveTask", "plNetClientJoinTask", "plNetClientCalibrateTask",
    "plNetMsgDeletePlayer", "plNetServerMsgVaultDeletePlayer",
    "plNetCoreStatsSummary", "plCreatableGenericValue", "plCreatableListHelper",
    "plCreatableStream", "plAvBrainGenericMsg", "plAvTaskSeek",
    "plAGInstanceCallbackMsg", "plArmatureEffectMsg", "plArmatureEffectStateMsg",
    "plShadowCastMsg", "plBoundsIsect", "plNetClientCommLeaveTask",
    "plResMgrHelperMsg", "plNetMsgAuthenticateResponse",
    "plNetMsgAccountAuthenticated", "plNetClientCommSendPeriodicAliveTask",
    "plNetClientCommCheckServerSilenceTask", "plNetClientCommPingTask",
    "plNetClientCommFindAgeTask", "plNetClientCommSetActivePlayerTask",
    "plNetClientCommGetPlayerListTask", "plNetClientCommCreatePlayerTask",
    "plNetClientCommJoinAgeTask", "plVaultAdminInitializationTask",
    "plMultistageModMsg", "plSoundVolumeApplicator", "plCutter", "plBulletMsg",
    "plDynaDecalEnableMsg", "plOmniCutoffApplicator", "plArmatureUpdateMsg",
    "plAvatarFootMsg", "plNetOwnershipMsg", "plNetMsgRelevanceRegions",
    "plParticleFlockMsg", "plAvatarBehaviorNotifyMsg", "plATCChannel",
    "plScalarSDLChannel", "plLoadAvatarMsg", "plAvatarSetTypeMsg",
    "plNetMsgLoadClone", "plNetMsgPlayerPage", "plVNodeInitTask",
    "plRippleShapeMsg", "plEventManager", "plVaultNeighborhoodInitializationTask",
    "plNetServerMsgAgentRecoveryRequest", "plNetServerMsgFrontendRecoveryRequest",
    "plNetServerMsgBackendRecoveryRequest", "plNetServerMsgAgentRecoveryData",
    "plNetServerMsgFrontendRecoveryData", "plNetServerMsgBackendRecoveryData",
    "plSubWorldMsg", "plMatrixDifferenceApp", "plAvBrainUser", "plDX9Pipeline",
    "plDXPipeline", "plPlayerMsg", "plAvBrainPirahna", "plAxisEventMsg",
    "plCrossfadeMsg", "pfSubtitleMsg", "plSDLStoreMsg", "plOmniSqApplicator",
    "plPreResourceMsg", "hsDynamicColorRGBA", "hsDynamicMatrix33",
    "hsDynamicMatrix44", "plCompoundController", "plNetClientMgrMsg",
    "plAgeLoaderMsg", "plAvBrainAvatar", "pfPythonNotifyMsg", "plNCAgeJoinerMsg",
    "plAvTaskDumbSeek", "plAvTaskSmartSeek", "plCreatableUuid", "plPreloaderMsg",
    "plNetCommAuthConnectedMsg", "plNetCommAuthMsg", "plNetCommFileListMsg",
    "plNetCommFileDownloadMsg", "plNetCommLinkToAgeMsg",
    "plNetCommPlayerListMsg", "plNetCommActivePlayerMsg",
    "plNetCommCreatePlayerMsg", "plNetCommDeletePlayerMsg",
    "plNetCommPublicAgeListMsg", "plNetCommPublicAgeMsg",
    "plNetCommRegisterAgeMsg", "plAnimEvalMsg", "plAvBrainFlight",
    "plAvBrainNPC", "plAvBrainBlimp", "plAvBrainFlightNPC",
    "plParticleBulletHitMsg", "pfPanicLinkMsg", "plAvTaskOneShot",
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,

    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, "plVaultGameServerInitializationTask",
    "plNetClientFindDefaultAgeTask", "plVaultAgeNode",
    "plVaultAgeInitializationTask", "plSetListenerMsg", "plVaultSystemNode",
    "plAvBrainSwim", "plNetMsgVault", "plNetServerMsgVault", "plVaultTask",
    "plVaultConnectTask", "plVaultNegotiateManifestTask",
    "plVaultFetchNodesTask", "plVaultSaveNodeTask", "plVaultFindNodeTask",
    "plVaultAddNodeRefTask", "plVaultRemoveNodeRefTask", "plVaultSendNodeTask",
    "plVaultNotifyOperationCallbackTask", "plVNodeMgrInitializationTask",
    "plVaultPlayerInitializationTask", "plNetVaultServerInitializationTask",
    "plCommonNeighborhoodsInitTask", "plVaultNodeRef", "plVaultNode",
    "plVaultFolderNode", "plVaultImageNode", "plVaultTextNoteNode",
    "plVaultSDLNode", "plVaultAgeLinkNode", "plVaultChronicleNode",
    "plVaultPlayerInfoNode", "plVaultMgrNode", "plVaultPlayerNode",
    "plSynchEnableMsg", "plNetVaultServerNode", "plVaultAdminNode",
    "plVaultGameServerNode", "plVaultPlayerInfoListNode",
    "plAvatarStealthModeMsg", "plEventCallbackInterceptMsg",
    "plDynamicEnvMapMsg", "plClimbMsg", "plIfaceFadeAvatarMsg", "plAvBrainClimb",
    "plSharedMeshBCMsg", "plNetVoiceListMsg", "plSwimMsg", "plMorphDelta",
    "plMatrixControllerCacheChannel", "plVaultMarkerNode", "pfMarkerMsg",
    "plPipeResMakeMsg", "plPipeRTMakeMsg", "plPipeGeoMakeMsg", "plAvCoopMsg",
    "plAvBrainCoop", "plSimSuppressMsg", "plVaultMarkerListNode",
    "plAvTaskOrient", "plAgeBeginLoadingMsg", "plSetNetGroupIDMsg",
    "pfBackdoorMsg", "plNetMsgPython", "pfPythonMsg", "plStateDataRecord",
    "plNetClientCommDeletePlayerTask", "plNetMsgSetTimeout",
    "plNetMsgActivePlayerSet", "plNetClientCommSetTimeoutTask",
    "plNetRoutableMsgOmnibus", "plNetMsgGetPublicAgeList",
    "plNetMsgPublicAgeList", "plNetMsgCreatePublicAge",
    "plNetMsgPublicAgeCreated", "plNetServerMsgEnvelope",
    "plNetClientCommGetPublicAgeListTask", "plNetClientCommCreatePublicAgeTask",
    "plNetServerMsgPendingMsgs", "plNetServerMsgRequestPendingMsgs",
    "plDbInterface", "plDbProxyInterface", "plDBGenericSQLDB", "plMySqlDB",
    "plNetGenericDatabase", "plNetVaultDatabase",
    "plNetServerMsgPlsUpdatePlayerReply", "plVaultDisconnectTask",
    "plNetClientCommSetAgePublicTask", "plNetClientCommRegisterOwnedAge",
    "plNetClientCommUnregisterOwnerAge", "plNetClientCommRegisterVisitAge",
    "plNetClientCommUnregisterVisitAge", "plNetMsgRemovePublicAge",
    "plNetMsgPublicAgeRemoved", "plNetClientCommRemovePublicAgeTask",
    "plCCRMessage", "plAvOneShotLinkTask", "plNetAuthDatabase",
    "plAvatarOpacityCallbackMsg", "plAGDetachCallbackMsg", "pfMovieEventMsg",
    "plMovieMsg", "plPipeTexMakeMsg", "plEventLog", "plDbEventLog",
    "plSyslogEventLog", "plCaptureRenderMsg", "plAgeLoaded2Msg",
    "plPseudoLinkEffectMsg", "plPseudoLinkAnimTriggerMsg",
    "plPseudoLinkAnimCallbackMsg", "pfClimbingWallMsg", "plClimbEventMsg",
    "plAvBrainQuab", "plSDLGameTimeElapsedVar", "plLinkEffectsDoneMsg",
    "plSDLVar", "plSDLStructVar", "plSDLBoolVar", "plSDLCharVar", "plSDLByteVar",
    "plSDLIntVar", "plSDLUIntVar", "plSDLFloatVar", "plSDLDoubleVar",
    "plSDLStringVar", "plSDLTimeVar", "plSDLUoidVar", "plSDLVector3Var",
    "plSDLPoint3Var", "plSDLQuaternionVar", "plSDLMatrix44Var", "plSDLRGBAVar",
    "plSDLAgeTimeOfDayVar", "plSDLAgeTimeElapsedVar", "plSDLMetaDoubleVar",
    "plSDLFixedArrayStructVar", "plSDLFixedArrayBoolVar",
    "plSDLFixedArrayCharVar", "plSDLFixedArrayByteVar", "plSDLFixedArrayIntVar",
    "plSDLFixedArrayUIntVar", "plSDLFixedArrayFloatVar",
    "plSDLFixedArrayDoubleVar", "plSDLFixedArrayStringVar",
    "plSDLFixedArrayTimeVar", "plSDLFixedArrayUoidVar",
    "plSDLFixedArrayVector3Var", "plSDLFixedArrayPoint3Var",
    "plSDLFixedArrayQuaternionVar", "plSDLFixedArrayMatrix44Var",
    "plSDLFixedArrayRGBAVar", "plSDLDynArrayStructVar", "plSDLDynArrayBoolVar",
    "plSDLDynArrayCharVar", "plSDLDynArrayByteVar", "plSDLDynArrayIntVar",
    "plSDLDynArrayUIntVar", "plSDLDynArrayFloatVar", "plSDLDynArrayDoubleVar",
    "plSDLDynArrayStringVar", "plSDLDynArrayTimeVar", "plSDLDynArrayUoidVar",
    "plSDLDynArrayVector3Var", "plSDLDynArrayPoint3Var",
    "plSDLDynArrayQuaternionVar", "plSDLDynArrayMatrix44Var",
    "plSDLDynArrayRGBAVar", "plSDLArrayVar", "plSDLVarChangeMsg", "plAvBrainPath",
    "plSDLBufferVar", "plSDLFixedArrayBufferVar", "plSDLDynArrayBufferVar",
    "plMatrixBorrowedChannel", "plNodeRegionMsg", "plEventCallbackSetupMsg",
    "plRelativeMatrixChannelApplicator", "plPiranhaRegionMsg", "pfGameMgrMsg",
    "pfGameCliMsg", "pfGameCli", "pfGmTicTacToe", "pfGmHeek", "pfGmMarker",
    "pfGmBlueSpiral", "plAccountUpdateMsg", "plAIMsg", "plAIBrainCreatedMsg",
    "pfGmClimbingWall", "plAIArrivedAtGoalMsg", "pfGmVarSync",
    "plLinearVelocityMsg", "plAngularVelocityMsg", "plRideAnimatedPhysMsg",
    "plAvBrainRideAnimatedPhysical", nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr
};

const char* pdUnifiedTypeMap::ClassName(short typeIdx)
{
    if (typeIdx < 0 || typeIdx >= TYPESPACE_MAX) {
        plDebug::Debug("pdUnifiedTypeMap::ClassName ERR: Got type {_04X}", typeIdx);
        return nullptr;
    }

    return fClassNames[typeIdx];
}

const char* pdUnifiedTypeMap::ClassName(short typeIdx, PlasmaVer ver)
{
    if (!ver.isValid())
        throw hsBadVersionException(__FILE__, __LINE__);
    return ClassName(PlasmaToMapped(typeIdx, ver));
}

short pdUnifiedTypeMap::ClassIndex(const char* typeName)
{
    for (size_t i=0; i<TYPESPACE_MAX; i++)
        if (fClassNames[i] && strcmp(fClassNames[i], typeName) == 0)
            return i;

    plDebug::Debug("pdUnifiedTypeMap::ClassIndex ERR: Got class {}", typeName);
    return -1;
}

short pdUnifiedTypeMap::PlasmaToMapped(short typeIdx, PlasmaVer ver)
{
    if (typeIdx < 0 || typeIdx >= TYPESPACE_MAX) {
        plDebug::Debug("pdUnifiedTypeMap::PlasmaToMapped ERR: Got type {_04X}", typeIdx);
        return -1;
    }

    ver = PlasmaVer::GetSafestVersion(ver);

    switch (ver) {
    case PlasmaVer::pvPrime:
        return fUruP2MTable[typeIdx];
    case PlasmaVer::pvPots:
        return fPotSP2MTable[typeIdx];
    case PlasmaVer::pvMoul:
    case PlasmaVer::pvMqo:
        return fLiveP2MTable[typeIdx];
    case PlasmaVer::pvEoa:
        return fEoaP2MTable[typeIdx];
    case PlasmaVer::pvHex:
        return fHexP2MTable[typeIdx];
    case PlasmaVer::pvUniversal:
        return typeIdx;
    default:
        return -1;
    }
}

short pdUnifiedTypeMap::MappedToPlasma(short typeIdx, PlasmaVer ver)
{
    if (typeIdx < 0 || typeIdx >= TYPESPACE_MAX) {
        plDebug::Debug("pdUnifiedTypeMap::MappedToPlasma ERR: Got type {_04X}", typeIdx);
        return -1;
    }

    ver = PlasmaVer::GetSafestVersion(ver);

    switch (ver) {
    case PlasmaVer::pvPrime:
        return fUruM2PTable[typeIdx];
    case PlasmaVer::pvPots:
        return fPotSM2PTable[typeIdx];
    case PlasmaVer::pvMoul:
    case PlasmaVer::pvMqo:
        return fLiveM2PTable[typeIdx];
    case PlasmaVer::pvEoa:
        return fEoaM2PTable[typeIdx];
    case PlasmaVer::pvHex:
        return fHexM2PTable[typeIdx];
    case PlasmaVer::pvUniversal:
        return typeIdx;
    default:
        return -1;
    }
}

short pdUnifiedTypeMap::ClassVersion(short typeIdx, PlasmaVer ver)
{
    if (PlasmaToMapped(typeIdx, ver) < 0)
        return -1;

    switch (ver) {
    case PlasmaVer::pvMoul:
    case PlasmaVer::pvMqo:
        return fLiveVerTable[PlasmaToMapped(typeIdx, ver)];
    case PlasmaVer::pvEoa:
        return fEoaVerTable[PlasmaToMapped(typeIdx, ver)];
    case PlasmaVer::pvHex:
        return fHexVerTable[PlasmaToMapped(typeIdx, ver)];
    default:
        throw hsBadVersionException(__FILE__, __LINE__);
    };
}

short pdUnifiedTypeMap::CurrentVersion(short typeIdx)
{
    if (typeIdx < 0 || typeIdx >= TYPESPACE_MAX) {
        plDebug::Debug("pdUnifiedTypeMap::CurrentVersion ERR: Got type {_04X}", typeIdx);
        return -1;
    }

    return fCurrentVerTable[typeIdx];
}

void pdUnifiedTypeMap::SetCurrentVersionBase(PlasmaVer ver)
{
    const short* base;

    switch (ver) {
    case PlasmaVer::pvMoul:
    case PlasmaVer::pvMqo:
        base = fLiveVerTable;
        break;
    case PlasmaVer::pvEoa:
        base = fEoaVerTable;
        break;
    case PlasmaVer::pvHex:
        base = fHexVerTable;
        break;
    default:
        throw hsBadVersionException(__FILE__, __LINE__);
    };

    for (size_t i = 0; i < TYPESPACE_MAX; i++) {
        fCurrentVerTable[i] = *(base + i);
    }
}

void pdUnifiedTypeMap::SetCurrentVersion(short typeIdx, PlasmaVer ver, short clsVer)
{
    fCurrentVerTable[PlasmaToMapped(typeIdx, ver)] = clsVer;
}
