/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.release;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.changelog.Changelog;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.Changelog;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.StringUtils;

public class ChangelogResolver {
    private static final String JRELEASER_CHANGELOG_ANCHOR = "<!-- JRELEASER_CHANGELOG_APPEND - Do not remove or modify this section -->";

    private ChangelogResolver() {
    }

    public static void resolve(JReleaserContext context) {
        String resolvedChangelog = Changelog.createChangelog(context);
        context.getChangelog().setResolvedChangelog(resolvedChangelog);
        if (StringUtils.isNotBlank((String)resolvedChangelog) && context.getModel().getProject().isRelease() && context.getModel().getRelease().getReleaser().getChangelog().getAppend().isEnabled()) {
            ChangelogResolver.appendChangelog(context, resolvedChangelog);
        }
    }

    private static void appendChangelog(JReleaserContext context, String resolvedChangelog) {
        BaseReleaser releaser = context.getModel().getRelease().getReleaser();
        Changelog.Append append = releaser.getChangelog().getAppend();
        TemplateContext props = context.fullProps();
        String resolvedTitle = MustacheUtils.applyTemplate((String)append.getTitle(), (TemplateContext)props);
        props.set("changelogTitle", (Object)MustacheUtils.passThrough((String)resolvedTitle));
        props.set("changelogContent", (Object)MustacheUtils.passThrough((String)resolvedChangelog));
        props.set("changelogChanges", (Object)MustacheUtils.passThrough((String)context.getChangelog().getFormattedChanges()));
        props.set("changelogContributors", (Object)MustacheUtils.passThrough((String)context.getChangelog().getFormattedContributors()));
        String appendableChangelog = StringUtils.stripMargin((String)MustacheUtils.applyTemplate((Reader)append.getResolvedContentTemplate(context), (TemplateContext)props));
        Path target = context.getBasedir().resolve(append.getTarget());
        String fullChangelog = null;
        try {
            fullChangelog = Files.exists(target, new LinkOption[0]) ? new String(Files.readAllBytes(target), StandardCharsets.UTF_8) : "";
        }
        catch (IOException e) {
            fullChangelog = "";
            context.getLogger().trace((Throwable)e);
            context.getLogger().warn(RB.$((String)"ERROR_cannot_read_changelog", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(target)});
        }
        String separator = ChangelogResolver.separator(releaser);
        fullChangelog = fullChangelog.contains(JRELEASER_CHANGELOG_ANCHOR) ? fullChangelog.replaceFirst(JRELEASER_CHANGELOG_ANCHOR, JRELEASER_CHANGELOG_ANCHOR + separator + appendableChangelog + separator + separator) : appendableChangelog + separator + separator + fullChangelog;
        context.getLogger().info(RB.$((String)"changelog.generator.store", (Object[])new Object[0]), new Object[]{context.getBasedir().relativize(target)});
        try {
            Files.write(target, fullChangelog.getBytes(StandardCharsets.UTF_8), Files.exists(target, new LinkOption[0]) ? StandardOpenOption.WRITE : StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            context.getLogger().trace((Throwable)e);
            context.getLogger().error(RB.$((String)"ERROR_unexpected_error_changelog_append", (Object[])new Object[0]));
        }
    }

    private static String separator(BaseReleaser<?, ?> releaser) {
        String separator = System.lineSeparator();
        if ("gitlab".equals(releaser.getServiceName())) {
            separator = separator + System.lineSeparator();
        }
        return separator;
    }
}

