/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.prompts;

import java.util.List;
import net.rubygrapefruit.platform.prompts.AbstractPrompter;
import net.rubygrapefruit.platform.prompts.InteractivePrompter;
import net.rubygrapefruit.platform.prompts.NonInteractivePrompter;
import net.rubygrapefruit.platform.prompts.PlainPrompter;
import net.rubygrapefruit.platform.terminal.TerminalOutput;
import net.rubygrapefruit.platform.terminal.Terminals;

public class Prompter {
    static final TerminalOutput.Color SELECTION_COLOR = TerminalOutput.Color.Cyan;
    private final AbstractPrompter implementation;

    public Prompter(Terminals terminals) {
        this.implementation = !terminals.isTerminalInput() || !terminals.isTerminal(Terminals.Output.Stdout) ? new NonInteractivePrompter() : (terminals.getTerminal(Terminals.Output.Stdout).supportsCursorMotion() && terminals.getTerminalInput().supportsRawMode() ? new InteractivePrompter(terminals) : new PlainPrompter(terminals));
    }

    public boolean isInteractive() {
        return this.implementation.isInteractive();
    }

    public Integer select(String prompt, List<String> options, int defaultOption) {
        return this.implementation.select(prompt, options, defaultOption);
    }

    public String enterText(String prompt, String defaultValue) {
        return this.implementation.enterText(prompt, defaultValue);
    }

    public String enterPassword(String prompt) {
        return this.implementation.enterPassword(prompt);
    }

    public Boolean askYesNo(String prompt, boolean defaultValue) {
        return this.implementation.askYesNo(prompt, defaultValue);
    }
}

