// Code generated by golex. DO NOT EDIT.

// Copyright 2017 The WL Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package wl

import (
	"strconv"
	"unicode/utf8"
)

func (lx *lexer) ReadRune() (r rune, sz int, err error) {
	if lx.c < 0 {
		lx.next()
	}
	c := int(lx.c)

yystate0:
	yyrule := -1
	_ = yyrule
	lx.in = lx.in[:0]
	lx.mark = -1

	goto yystart1

	goto yystate0 // silence unused label error
	goto yyAction // silence unused label error
yyAction:
	switch yyrule {
	case 1:
		goto yyrule1
	case 2:
		goto yyrule2
	case 3:
		goto yyrule3
	case 4:
		goto yyrule4
	}
	goto yystate1 // silence unused label error
yystate1:
	c = lx.next()
yystart1:
	switch {
	default:
		goto yyabort
	case c == '\\':
		goto yystate2
	}

yystate2:
	c = lx.next()
	switch {
	default:
		goto yyabort
	case c == '.':
		goto yystate3
	case c == ':':
		goto yystate9
	case c == '[':
		goto yystate14
	case c >= '0' && c <= '9':
		goto yystate6
	}

yystate3:
	c = lx.next()
	switch {
	default:
		goto yyabort
	case c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f':
		goto yystate4
	}

yystate4:
	c = lx.next()
	switch {
	default:
		goto yyabort
	case c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f':
		goto yystate5
	}

yystate5:
	c = lx.next()
	yyrule = 3
	lx.mark = len(lx.in)
	goto yyrule3

yystate6:
	c = lx.next()
	switch {
	default:
		goto yyabort
	case c >= '0' && c <= '9':
		goto yystate7
	}

yystate7:
	c = lx.next()
	switch {
	default:
		goto yyabort
	case c >= '0' && c <= '9':
		goto yystate8
	}

yystate8:
	c = lx.next()
	yyrule = 2
	lx.mark = len(lx.in)
	goto yyrule2

yystate9:
	c = lx.next()
	switch {
	default:
		goto yyabort
	case c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f':
		goto yystate10
	}

yystate10:
	c = lx.next()
	switch {
	default:
		goto yyabort
	case c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f':
		goto yystate11
	}

yystate11:
	c = lx.next()
	switch {
	default:
		goto yyabort
	case c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f':
		goto yystate12
	}

yystate12:
	c = lx.next()
	switch {
	default:
		goto yyabort
	case c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f':
		goto yystate13
	}

yystate13:
	c = lx.next()
	yyrule = 4
	lx.mark = len(lx.in)
	goto yyrule4

yystate14:
	c = lx.next()
	switch {
	default:
		goto yyabort
	case c >= 'A' && c <= 'Z':
		goto yystate15
	}

yystate15:
	c = lx.next()
	switch {
	default:
		goto yyabort
	case c == ']':
		goto yystate16
	case c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z':
		goto yystate15
	}

yystate16:
	c = lx.next()
	yyrule = 1
	lx.mark = len(lx.in)
	goto yyrule1

yyrule1: // "\["[A-Z][A-Za-z]*"]"
	{

		s := lx.token()
		return lx.named(s[2 : len(s)-1])
	}
yyrule2: // \\{d}{d}{d}
	{

		n, err := strconv.ParseInt(lx.token()[1:4], 8, 8)
		if err != nil {
			return 0, 0, err
		}
		return rune(n), 4, lx.rerr
	}
yyrule3: // \\\.{h}{h}
	{

		n, err := strconv.ParseInt(lx.token()[2:4], 16, 8)
		if err != nil {
			return 0, 0, err
		}
		return rune(n), 4, lx.rerr
	}
yyrule4: // \\\:{h}{h}{h}{h}
	{

		n, err := strconv.ParseInt(lx.token()[2:6], 16, 16)
		if err != nil {
			lx.errPos(lx.First.Pos(), err.Error())
			return 0, 0, err
		}
		return rune(n), 6, lx.rerr
	}
	panic("unreachable")

	goto yyabort // silence unused label error

yyabort: // no lexem recognized
	if lx.mark >= 0 {
		if len(lx.in) > lx.mark {
			lx.unget(rune(c))
			for i := len(lx.in) - 1; i >= lx.mark; i-- {
				lx.unget(lx.in[i])
			}
			lx.next()
		}
		lx.in = lx.in[:lx.mark]
		goto yyAction
	}

	switch n := len(lx.in); n {
	case 0: // [] z
		lx.c = -1
	case 1: // [x] z
		c = int(lx.in[0])
	}

	switch c {
	case '\n':
		lx.unget(IGNORE)
		return rune(c), 1, lx.err
	case IGNORE:
		return rune(c), 0, lx.err
	}

	return rune(c), utf8.RuneLen(rune(c)), lx.err
}
