// Code generated by yy. DO NOT EDIT.

// Copyright 2017 The WL Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package wl

import (
	"fmt"
)

func ExampleCommaOpt_case0() {
	fmt.Println(exampleAST(153, "{ 1.97 }") == (*CommaOpt)(nil))
	// Output:
	// false
}

func ExampleCommaOpt_case1() {
	fmt.Println(exampleAST(154, "{ 1.97 , ]"))
	// Output:
	// &wl.CommaOpt{
	// · Token: ',',
	// }
}

func ExampleExprList_case0() {
	fmt.Println(exampleAST(151, "{ 1.97 ,"))
	// Output:
	// &wl.ExprList{
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// }
}

func ExampleExprList_case1() {
	fmt.Println(exampleAST(152, "{ 1.97 , 1.98 ,"))
	// Output:
	// &wl.ExprList{
	// · ExprList: &wl.ExprList{
	// · · Case: 1,
	// · · Expression: &wl.Expression{
	// · · · Case: ExpressionFloat,
	// · · · Token: FLOAT, "1.98",
	// · · },
	// · · Token: ',',
	// · },
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// }
}

func ExampleExpression_preInc() {
	fmt.Println(exampleAST(2, "++ 1.97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionPreInc,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: INC, "++",
	// }
}

func ExampleExpression_preDec() {
	fmt.Println(exampleAST(3, "-- 1.97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionPreDec,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: DEC, "--",
	// }
}

func ExampleExpression_case002() {
	fmt.Println(exampleAST(4, ";;"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(2),
	// · Token: SPAN, ";;",
	// }
}

func ExampleExpression_case003() {
	fmt.Println(exampleAST(5, ";; 1.97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(3),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: SPAN, ";;",
	// }
}

func ExampleExpression_case004() {
	fmt.Println(exampleAST(6, "<< a"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(4),
	// · FileName: &wl.FileName{
	// · · Token: IDENT, "a",
	// · },
	// · Token: GET, "<<",
	// }
}

func ExampleExpression_case005() {
	fmt.Println(exampleAST(7, "\\@ 1.97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(5),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: SQRT2, "\\@",
	// }
}

func ExampleExpression_case006() {
	fmt.Println(exampleAST(8, "\\@ 1.97 \\% 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(6),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: SQRT2, "\\@",
	// · Token2: POWER_SUBSCRIPT2, "\\%",
	// }
}

func ExampleExpression_case007() {
	fmt.Println(exampleAST(9, "\\[Del] 1.97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(7),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: DEL, "∇",
	// }
}

func ExampleExpression_case008() {
	fmt.Println(exampleAST(10, "\\[Integrate] 1.97 \\[DifferentialD] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(8),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: INTEGRATE, "∫",
	// · Token2: DIFFERENTIAL_D, "\uf74c",
	// }
}

func ExampleExpression_case009() {
	fmt.Println(exampleAST(11, "\\[MinusPlus] 1.97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(9),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: MINUS_PLUS, "∓",
	// }
}

func ExampleExpression_case010() {
	fmt.Println(exampleAST(12, "\\[PlusMinus] 1.97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(10),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: PLUS_MINUS, "±",
	// }
}

func ExampleExpression_case011() {
	fmt.Println(exampleAST(13, "\\[Sqrt] 1.97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(11),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: SQRT, "√",
	// }
}

func ExampleExpression_case012() {
	fmt.Println(exampleAST(14, "\\[Square] 1.97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(12),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: SQUARE, "\uf520",
	// }
}

func ExampleExpression_case013() {
	fmt.Println(exampleAST(15, "! 1.97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(13),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: '!',
	// }
}

func ExampleExpression_parenExpr() {
	fmt.Println(exampleAST(16, "( 1.97 )"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionParenExpr,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: '(',
	// · Token2: ')',
	// }
}

func ExampleExpression_unaryPlus() {
	fmt.Println(exampleAST(17, "+ 1.97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionUnaryPlus,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: '+',
	// }
}

func ExampleExpression_unaryMinus() {
	fmt.Println(exampleAST(18, "- 1.97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionUnaryMinus,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: '-',
	// }
}

func ExampleExpression_case017() {
	fmt.Println(exampleAST(19, "{ }"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(17),
	// · Token: '{',
	// · Token2: '}',
	// }
}

func ExampleExpression_case018() {
	fmt.Println(exampleAST(20, "{ 1.97 }"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(18),
	// · ExprList: &wl.ExprList{
	// · · Expression: &wl.Expression{
	// · · · Case: ExpressionFloat,
	// · · · Token: FLOAT, "1.97",
	// · · },
	// · },
	// · Token: '{',
	// · Token2: '}',
	// }
}

func ExampleExpression_ne() {
	fmt.Println(exampleAST(21, "1.97 != 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionNe,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: UNEQUAL, "!=",
	// }
}

func ExampleExpression_lAnd() {
	fmt.Println(exampleAST(22, "1.97 && 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionLAnd,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: AND, "&&",
	// }
}

func ExampleExpression_case021() {
	fmt.Println(exampleAST(23, "1.97 ** 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(21),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: NON_COMMUTATIVE_MULTIPLY, "**",
	// }
}

func ExampleExpression_mulAssign() {
	fmt.Println(exampleAST(24, "1.97 *= 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionMulAssign,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: TIMES_BY, "*=",
	// }
}

func ExampleExpression_postInc() {
	fmt.Println(exampleAST(25, "1.97 ++"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionPostInc,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: INC, "++",
	// }
}

func ExampleExpression_addAssign() {
	fmt.Println(exampleAST(26, "1.97 += 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionAddAssign,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: ADD_TO, "+=",
	// }
}

func ExampleExpression_postDec() {
	fmt.Println(exampleAST(27, "1.97 --"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionPostDec,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: DEC, "--",
	// }
}

func ExampleExpression_subAssign() {
	fmt.Println(exampleAST(28, "1.97 -= 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionSubAssign,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: SUBTRACT_FROM, "-=",
	// }
}

func ExampleExpression_case027() {
	fmt.Println(exampleAST(29, "1.97 -> 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(27),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: RULE, "->",
	// }
}

func ExampleExpression_case028() {
	fmt.Println(exampleAST(30, "1.97 .."))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(28),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: REPEATED, "..",
	// }
}

func ExampleExpression_case029() {
	fmt.Println(exampleAST(31, "1.97 ..."))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(29),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: REPEATED_NULL, "...",
	// }
}

func ExampleExpression_case030() {
	fmt.Println(exampleAST(32, "1.97 /* 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(30),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: RIGHT_COMPOSITION, "/*",
	// }
}

func ExampleExpression_case031() {
	fmt.Println(exampleAST(33, "1.97 /. 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(31),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: REPLACEALL, "/.",
	// }
}

func ExampleExpression_case032() {
	fmt.Println(exampleAST(34, "1.97 // 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(32),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: POSTFIX, "//",
	// }
}

func ExampleExpression_case033() {
	fmt.Println(exampleAST(35, "1.97 //. 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(33),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: REPLACEREP, "//.",
	// }
}

func ExampleExpression_case034() {
	fmt.Println(exampleAST(36, "1.97 //@ 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(34),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: MAP_ALL, "//@",
	// }
}

func ExampleExpression_case035() {
	fmt.Println(exampleAST(37, "a/:b=c"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(35),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionIdent,
	// · · Token: IDENT, "a",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionAssign,
	// · · Expression: &wl.Expression{
	// · · · Case: ExpressionIdent,
	// · · · Token: IDENT, "b",
	// · · },
	// · · Expression2: &wl.Expression{
	// · · · Case: ExpressionIdent,
	// · · · Token: IDENT, "c",
	// · · },
	// · · Token: '=',
	// · },
	// · Token: TAG_SET, "/:",
	// }
}

func ExampleExpression_case036() {
	fmt.Println(exampleAST(38, "1.97 /; 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(36),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: CONDITION, "/;",
	// }
}

func ExampleExpression_case037() {
	fmt.Println(exampleAST(39, "1.97 /= 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(37),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: DIVIDE_BY, "/=",
	// }
}

func ExampleExpression_case038() {
	fmt.Println(exampleAST(40, "1.97 /@ 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(38),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: MAP, "/@",
	// }
}

func ExampleExpression_case039() {
	fmt.Println(exampleAST(41, "1.97 := 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(39),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: SET_DELAYED, ":=",
	// }
}

func ExampleExpression_case040() {
	fmt.Println(exampleAST(42, "1.97 :> 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(40),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: RULEDELAYED, ":>",
	// }
}

func ExampleExpression_case041() {
	fmt.Println(exampleAST(43, "1.97 ;;"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(41),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: SPAN, ";;",
	// }
}

func ExampleExpression_case042() {
	fmt.Println(exampleAST(44, "1.97 ;; 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(42),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: SPAN, ";;",
	// }
}

func ExampleExpression_le() {
	fmt.Println(exampleAST(45, "1.97 <= 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionLe,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: LEQ, "<=",
	// }
}

func ExampleExpression_case044() {
	fmt.Println(exampleAST(46, "1.97 <> 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(44),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: STRINGJOIN, "<>",
	// }
}

func ExampleExpression_case045() {
	fmt.Println(exampleAST(47, "1.97 =!= 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(45),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: UNSAME, "=!=",
	// }
}

func ExampleExpression_eq() {
	fmt.Println(exampleAST(48, "1.97 == 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionEq,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: EQUAL, "==",
	// }
}

func ExampleExpression_case047() {
	fmt.Println(exampleAST(49, "1.97 === 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(47),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: SAME, "===",
	// }
}

func ExampleExpression_ge() {
	fmt.Println(exampleAST(50, "1.97 >= 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionGe,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: GEQ, ">=",
	// }
}

func ExampleExpression_rsh() {
	fmt.Println(exampleAST(51, "1.97 >> b"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionRsh,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · FileName: &wl.FileName{
	// · · Token: IDENT, "b",
	// · },
	// · Token: PUT, ">>",
	// }
}

func ExampleExpression_case050() {
	fmt.Println(exampleAST(52, "1.97 >>> b"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(50),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · FileName: &wl.FileName{
	// · · Token: IDENT, "b",
	// · },
	// · Token: PUT_APPEND, ">>>",
	// }
}

func ExampleExpression_case051() {
	fmt.Println(exampleAST(53, "1.97 @* 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(51),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: COMPOSITION, "@*",
	// }
}

func ExampleExpression_case052() {
	fmt.Println(exampleAST(54, "1.97 @@ 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(52),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: APPLY, "@@",
	// }
}

func ExampleExpression_case053() {
	fmt.Println(exampleAST(55, "1.97 @@@ 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(53),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: APPLY_ALL, "@@@",
	// }
}

func ExampleExpression_case054() {
	fmt.Println(exampleAST(56, "1.97 [[ 1.98 ]]"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(54),
	// · ExprList: &wl.ExprList{
	// · · Expression: &wl.Expression{
	// · · · Case: ExpressionFloat,
	// · · · Token: FLOAT, "1.98",
	// · · },
	// · },
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: LPART, "[[",
	// · Token2: RPART, "]]",
	// }
}

func ExampleExpression_case055() {
	fmt.Println(exampleAST(57, "1.97 \\& 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(55),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: OVERSCRIPT, "\\&",
	// }
}

func ExampleExpression_case056() {
	fmt.Println(exampleAST(58, "1.97 \\+ 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(56),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: UNDERSCRIPT, "\\+",
	// }
}

func ExampleExpression_case057() {
	fmt.Println(exampleAST(59, "1.97 \\[Backslash] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(57),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: BACKSLASH, "∖",
	// }
}

func ExampleExpression_case058() {
	fmt.Println(exampleAST(60, "1.97 \\[Because] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(58),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: BECAUSE, "∵",
	// }
}

func ExampleExpression_case059() {
	fmt.Println(exampleAST(61, "1.97 \\[Cap] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(59),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: CAP, "⌢",
	// }
}

func ExampleExpression_case060() {
	fmt.Println(exampleAST(62, "1.97 \\[CenterDot] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(60),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: CENTER_DOT, "·",
	// }
}

func ExampleExpression_case061() {
	fmt.Println(exampleAST(63, "1.97 \\[CircleDot] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(61),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: CIRCLE_DOT, "⊙",
	// }
}

func ExampleExpression_case062() {
	fmt.Println(exampleAST(64, "1.97 \\[CircleMinus] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(62),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: CIRCLE_MINUS, "⊖",
	// }
}

func ExampleExpression_case063() {
	fmt.Println(exampleAST(65, "1.97 \\[CirclePlus] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(63),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: CIRCLE_PLUS, "⊕",
	// }
}

func ExampleExpression_case064() {
	fmt.Println(exampleAST(66, "1.97 \\[CircleTimes] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(64),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: CIRCLE_TIMES, "⊗",
	// }
}

func ExampleExpression_case065() {
	fmt.Println(exampleAST(67, "1.97 \\[ConjugateTranspose]"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(65),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: CONJUGATE_TRANSPOSE, "\uf3c9",
	// }
}

func ExampleExpression_case066() {
	fmt.Println(exampleAST(68, "1.97 \\[Conjugate]"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(66),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: CONJUGATE, "\uf3c8",
	// }
}

func ExampleExpression_case067() {
	fmt.Println(exampleAST(69, "1.97 \\[Coproduct] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(67),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: COPRODUCT, "∐",
	// }
}

func ExampleExpression_case068() {
	fmt.Println(exampleAST(70, "1.97 \\[Cross] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(68),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: CROSS, "\uf4a0",
	// }
}

func ExampleExpression_case069() {
	fmt.Println(exampleAST(71, "1.97 \\[Cup] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(69),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: CUP, "⌣",
	// }
}

func ExampleExpression_case070() {
	fmt.Println(exampleAST(72, "1.97 \\[Diamond] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(70),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: DIAMOND, "⋄",
	// }
}

func ExampleExpression_case071() {
	fmt.Println(exampleAST(73, "1.97 \\[DifferenceDelta] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(71),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: DIFFERENCE_DELTA, "∆",
	// }
}

func ExampleExpression_case072() {
	fmt.Println(exampleAST(74, "1.97 \\[DiscreteRatio] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(72),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: DISCRETE_RATIO, "\uf4a4",
	// }
}

func ExampleExpression_case073() {
	fmt.Println(exampleAST(75, "1.97 \\[DiscreteShift] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(73),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: DISCRETE_SHIFT, "\uf4a3",
	// }
}

func ExampleExpression_case074() {
	fmt.Println(exampleAST(76, "1.97 \\[DoubleLeftTee] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(74),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: DOUBLE_LEFT_TEE, "⫤",
	// }
}

func ExampleExpression_case075() {
	fmt.Println(exampleAST(77, "1.97 \\[DoubleRightTee] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(75),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: DOUBLE_RIGHT_TEE, "⊨",
	// }
}

func ExampleExpression_case076() {
	fmt.Println(exampleAST(78, "1.97 \\[DoubleVerticalBar] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(76),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: DOUBLE_VERTICAL_BAR, "∥",
	// }
}

func ExampleExpression_case077() {
	fmt.Println(exampleAST(79, "1.97 \\[DownTee] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(77),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: DOWN_TEE, "⊤",
	// }
}

func ExampleExpression_case078() {
	fmt.Println(exampleAST(80, "1.97 \\[Element] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(78),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: ELEMENT, "∈",
	// }
}

func ExampleExpression_case079() {
	fmt.Println(exampleAST(81, "1.97 \\[Equivalent] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(79),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: EQUIVALENT, "⧦",
	// }
}

func ExampleExpression_case080() {
	fmt.Println(exampleAST(82, "1.97 \\[Function] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(80),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: FUNCTION, "\uf4a1",
	// }
}

func ExampleExpression_case081() {
	fmt.Println(exampleAST(83, "1.97 \\[HermitianConjugate]"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(81),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: HERMITIAN_CONJUGATE, "\uf3ce",
	// }
}

func ExampleExpression_case082() {
	fmt.Println(exampleAST(84, "1.97 \\[Implies] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(82),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: IMPLIES, "\uf523",
	// }
}

func ExampleExpression_case083() {
	fmt.Println(exampleAST(85, "1.97 \\[Intersection] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(83),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: INTERSECTION, "⋂",
	// }
}

func ExampleExpression_case084() {
	fmt.Println(exampleAST(86, "1.97 \\[LeftTee] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(84),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: LEFT_TEE, "⊣",
	// }
}

func ExampleExpression_case085() {
	fmt.Println(exampleAST(87, "1.97 \\[Nand] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(85),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: NAND, "⊼",
	// }
}

func ExampleExpression_case086() {
	fmt.Println(exampleAST(88, "1.97 \\[Nor] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(86),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: NOR, "⊽",
	// }
}

func ExampleExpression_case087() {
	fmt.Println(exampleAST(89, "1.97 \\[NotDoubleVerticalBar] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(87),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: NOT_DOUBLE_VERTICAL_BAR, "∦",
	// }
}

func ExampleExpression_case088() {
	fmt.Println(exampleAST(90, "1.97 \\[NotElement] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(88),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: NOT_ELEMENT, "∉",
	// }
}

func ExampleExpression_case089() {
	fmt.Println(exampleAST(91, "1.97 \\[NotVerticalBar] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(89),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: NOT_VERTICAL_BAR, "\uf3d1",
	// }
}

func ExampleExpression_case090() {
	fmt.Println(exampleAST(92, "1.97 \\[PartialD] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(90),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: PARTIAL_D, "∂",
	// }
}

func ExampleExpression_case091() {
	fmt.Println(exampleAST(93, "1.97 \\[RightTee] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(91),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: RIGHT_TEE, "⊢",
	// }
}

func ExampleExpression_case092() {
	fmt.Println(exampleAST(94, "1.97 \\[SmallCircle] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(92),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: SMALL_CIRCLE, "∘",
	// }
}

func ExampleExpression_case093() {
	fmt.Println(exampleAST(95, "1.97 \\[Star] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(93),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: STAR, "⋆",
	// }
}

func ExampleExpression_case094() {
	fmt.Println(exampleAST(96, "1.97 \\[Subset] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(94),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: SUBSET, "⊂",
	// }
}

func ExampleExpression_case095() {
	fmt.Println(exampleAST(97, "1.97 \\[SuchThat] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(95),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: SUCH_THAT, "∍",
	// }
}

func ExampleExpression_case096() {
	fmt.Println(exampleAST(98, "1.97 \\[Superset] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(96),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: SUPERSET, "⊃",
	// }
}

func ExampleExpression_case097() {
	fmt.Println(exampleAST(99, "1.97 \\[Therefore] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(97),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: THEREFORE, "∴",
	// }
}

func ExampleExpression_case098() {
	fmt.Println(exampleAST(100, "1.97 \\[Transpose]"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(98),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: TRANSPOSE, "\uf3c7",
	// }
}

func ExampleExpression_case099() {
	fmt.Println(exampleAST(101, "1.97 \\[Union] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(99),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: UNION, "⋃",
	// }
}

func ExampleExpression_case100() {
	fmt.Println(exampleAST(102, "1.97 \\[UpTee] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(100),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: UP_TEE, "⊥",
	// }
}

func ExampleExpression_case101() {
	fmt.Println(exampleAST(103, "1.97 \\[Vee] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(101),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: VEE, "⋁",
	// }
}

func ExampleExpression_case102() {
	fmt.Println(exampleAST(104, "1.97 \\[VerticalBar] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(102),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: VERTICAL_BAR, "\uf3d0",
	// }
}

func ExampleExpression_case103() {
	fmt.Println(exampleAST(105, "1.97 \\[VerticalSeparator] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(103),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: VERTICAL_SEPARATOR, "\uf432",
	// }
}

func ExampleExpression_case104() {
	fmt.Println(exampleAST(106, "1.97 \\[VerticalTilde] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(104),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: VERTICAL_TILDE, "≀",
	// }
}

func ExampleExpression_case105() {
	fmt.Println(exampleAST(107, "1.97 \\[Wedge] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(105),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: WEDGE, "⋀",
	// }
}

func ExampleExpression_case106() {
	fmt.Println(exampleAST(108, "1.97 \\[Xnor] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(106),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: XNOR, "\uf4a2",
	// }
}

func ExampleExpression_case107() {
	fmt.Println(exampleAST(109, "1.97 \\[Xor] 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(107),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: XOR, "⊻",
	// }
}

func ExampleExpression_case108() {
	fmt.Println(exampleAST(110, "1.97 \\^ 1.98 \\% 1.99"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(108),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Expression3: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.99",
	// · },
	// · Token: POWER_SUBSCRIPT1, "\\^",
	// · Token2: POWER_SUBSCRIPT2, "\\%",
	// }
}

func ExampleExpression_case109() {
	fmt.Println(exampleAST(111, "1.97 \\_ 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(109),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: SUBSCRIPT, "\\_",
	// }
}

func ExampleExpression_case110() {
	fmt.Println(exampleAST(112, "1.97 \\` \"b\""))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(110),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: FORM_BOX, "\\`",
	// · Token2: STRING, "b",
	// }
}

func ExampleExpression_case111() {
	fmt.Println(exampleAST(113, "1.97 ^:= 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(111),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: UP_SET_DELAYED, "^:=",
	// }
}

func ExampleExpression_case112() {
	fmt.Println(exampleAST(114, "1.97 ^= 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(112),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: UP_SET, "^=",
	// }
}

func ExampleExpression_lOr() {
	fmt.Println(exampleAST(115, "1.97 || 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionLOr,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: OR, "||",
	// }
}

func ExampleExpression_case114() {
	fmt.Println(exampleAST(116, "1.97 ~~ 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(114),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: STRING_EXPRESSION, "~~",
	// }
}

func ExampleExpression_factorial() {
	fmt.Println(exampleAST(117, "1.97 !"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionFactorial,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: '!',
	// }
}

func ExampleExpression_case116() {
	fmt.Println(exampleAST(118, "1.97 ! !"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(116),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: '!',
	// · Token2: '!',
	// }
}

func ExampleExpression_case117() {
	fmt.Println(exampleAST(119, "1.97 &"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(117),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: '&',
	// }
}

func ExampleExpression_mul() {
	fmt.Println(exampleAST(120, "1.97 * 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionMul,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: '*',
	// }
}

func ExampleExpression_add() {
	fmt.Println(exampleAST(121, "1.97 + 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionAdd,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: '+',
	// }
}

func ExampleExpression_sub() {
	fmt.Println(exampleAST(122, "1.97 - 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionSub,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: '-',
	// }
}

func ExampleExpression_case121() {
	fmt.Println(exampleAST(123, "1.97 . 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(121),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: '.',
	// }
}

func ExampleExpression_div() {
	fmt.Println(exampleAST(124, "1.97 / 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionDiv,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: '/',
	// }
}

func ExampleExpression_case123() {
	fmt.Println(exampleAST(125, "1.97 : 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(123),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: ':',
	// }
}

func ExampleExpression_case124() {
	fmt.Println(exampleAST(126, "1.97 ;"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(124),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: ';',
	// }
}

func ExampleExpression_compound() {
	fmt.Println(exampleAST(127, "1.97 ; 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCompound,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: ';',
	// }
}

func ExampleExpression_lt() {
	fmt.Println(exampleAST(128, "1.97 < 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionLt,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: '<',
	// }
}

func ExampleExpression_case127() {
	fmt.Println(exampleAST(129, "1.97 = ."))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(127),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: '=',
	// · Token2: '.',
	// }
}

func ExampleExpression_assign() {
	fmt.Println(exampleAST(130, "1.97 = 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionAssign,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: '=',
	// }
}

func ExampleExpression_gt() {
	fmt.Println(exampleAST(131, "1.97 > 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionGt,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: '>',
	// }
}

func ExampleExpression_patternTest() {
	fmt.Println(exampleAST(132, "1.97 ? 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionPatternTest,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: '?',
	// }
}

func ExampleExpression_case131() {
	fmt.Println(exampleAST(133, "1.97 @ 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(131),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: '@',
	// }
}

func ExampleExpression_case132() {
	fmt.Println(exampleAST(134, "1.97 [ ]"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(132),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: '[',
	// · Token2: ']',
	// }
}

func ExampleExpression_case133() {
	fmt.Println(exampleAST(135, "1.97 [ 1.98 ]"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(133),
	// · ExprList: &wl.ExprList{
	// · · Expression: &wl.Expression{
	// · · · Case: ExpressionFloat,
	// · · · Token: FLOAT, "1.98",
	// · · },
	// · },
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: '[',
	// · Token2: ']',
	// }
}

func ExampleExpression_case134() {
	fmt.Println(exampleAST(136, "1.97 ^ 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(134),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: '^',
	// }
}

func ExampleExpression_or() {
	fmt.Println(exampleAST(137, "1.97 | 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionOr,
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: '|',
	// }
}

func ExampleExpression_case136() {
	fmt.Println(exampleAST(138, "1.97 ~ 1.98"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(136),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Expression2: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.98",
	// · },
	// · Token: '~',
	// }
}

func ExampleExpression_case137() {
	fmt.Println(exampleAST(139, "1.97 '"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(137),
	// · Expression: &wl.Expression{
	// · · Case: ExpressionFloat,
	// · · Token: FLOAT, "1.97",
	// · },
	// · Token: QUOTE, "'",
	// }
}

func ExampleExpression_infoShort() {
	fmt.Println(exampleAST(140, "? a"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionInfoShort,
	// · Tag: &wl.Tag{
	// · · Token: IDENT, "a",
	// · },
	// · Token: '?',
	// }
}

func ExampleExpression_info() {
	fmt.Println(exampleAST(141, "? ? a"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionInfo,
	// · Tag: &wl.Tag{
	// · · Token: IDENT, "a",
	// · },
	// · Token: '?',
	// · Token2: '?',
	// }
}

func ExampleExpression_float() {
	fmt.Println(exampleAST(142, "1.97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionFloat,
	// · Token: FLOAT, "1.97",
	// }
}

func ExampleExpression_ident() {
	fmt.Println(exampleAST(143, "a"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionIdent,
	// · Token: IDENT, "a",
	// }
}

func ExampleExpression_messageName() {
	fmt.Println(exampleAST(144, "a :: b"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionMessageName,
	// · Tag: &wl.Tag{
	// · · Token: IDENT, "b",
	// · },
	// · Token: IDENT, "a",
	// · Token2: MESSAGE_NAME, "::",
	// }
}

func ExampleExpression_messageName2() {
	fmt.Println(exampleAST(145, "a :: b :: c"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionMessageName2,
	// · Tag: &wl.Tag{
	// · · Token: IDENT, "b",
	// · },
	// · Tag2: &wl.Tag{
	// · · Token: IDENT, "c",
	// · },
	// · Token: IDENT, "a",
	// · Token2: MESSAGE_NAME, "::",
	// · Token3: MESSAGE_NAME, "::",
	// }
}

func ExampleExpression_integer() {
	fmt.Println(exampleAST(146, "97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionInteger,
	// · Token: INT, "97",
	// }
}

func ExampleExpression_case145() {
	fmt.Println(exampleAST(147, "%97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionCase(145),
	// · Token: OUT, "%97",
	// }
}

func ExampleExpression_pattern() {
	fmt.Println(exampleAST(148, "a_"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionPattern,
	// · Token: PATTERN, "a_",
	// }
}

func ExampleExpression_slot() {
	fmt.Println(exampleAST(149, "#97"))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionSlot,
	// · Token: SLOT, "#97",
	// }
}

func ExampleExpression_string() {
	fmt.Println(exampleAST(150, "\"a\""))
	// Output:
	// &wl.Expression{
	// · Case: ExpressionString,
	// · Token: STRING, "a",
	// }
}

func ExampleFileName_ident() {
	fmt.Println(exampleAST(155, "<< a"))
	// Output:
	// &wl.FileName{
	// · Token: IDENT, "a",
	// }
}

func ExampleFileName_string() {
	fmt.Println(exampleAST(156, "<< \"a\""))
	// Output:
	// &wl.FileName{
	// · Case: 1,
	// · Token: STRING, "a",
	// }
}

func ExampleTag_ident() {
	fmt.Println(exampleAST(157, "? a"))
	// Output:
	// &wl.Tag{
	// · Token: IDENT, "a",
	// }
}

func ExampleTag_string() {
	fmt.Println(exampleAST(158, "? \"a\""))
	// Output:
	// &wl.Tag{
	// · Case: 1,
	// · Token: STRING, "a",
	// }
}

func Examplestart_case0() {
	fmt.Println(exampleAST(1, "1.97"))
	// Output:
}
