export default function GraphicSvg() {
  return (
    <svg viewBox="0 0 582 582" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path
        className="ring outer"
        opacity=".5"
        d="M581 291a290 290 0 11-580 0 290 290 0 01580 0z"
        stroke="#62D4DC"
        strokeWidth="2"
      />
      <circle
        className="ring middle"
        cx="291"
        cy="291"
        r="215"
        stroke="#62D4DC"
        strokeWidth="2"
      />
      <circle
        className="ring inner"
        cx="291"
        cy="291"
        r="134"
        fill="url(#circle-fill)"
        stroke="#62D4DC"
        strokeWidth="4"
      />

      <g className="badge available" filter="url(#drop-shadow)">
        <rect
          x="197"
          y="75"
          width="114"
          height="32"
          rx="16"
          fill="url(#linear-gradient)"
        />
        <path
          d="M233.056 96H234.412L231.088 87.6H229.42L226.096 96H227.452L228.256 93.96H232.252L233.056 96ZM228.7 92.808L230.26 88.836L231.808 92.808H228.7ZM241.071 87.6L238.443 94.38L235.815 87.6H234.387L237.735 96H239.139L242.487 87.6H241.071ZM249.426 96H250.782L247.458 87.6H245.79L242.466 96H243.822L244.626 93.96H248.622L249.426 96ZM245.07 92.808L246.63 88.836L248.178 92.808H245.07ZM252.437 96H253.757V87.6H252.437V96ZM257.466 94.8V87.6H256.158V96H261.882V94.8H257.466ZM270.078 96H271.434L268.11 87.6H266.442L263.118 96H264.474L265.278 93.96H269.274L270.078 96ZM265.722 92.808L267.282 88.836L268.83 92.808H265.722ZM278.586 91.608C279.27 91.26 279.69 90.648 279.678 89.808C279.666 88.5 278.574 87.6 277.002 87.6H273.09V96H277.254C278.982 96 280.014 95.016 280.014 93.648C280.014 92.676 279.462 91.956 278.586 91.608ZM276.978 88.728C277.842 88.728 278.406 89.244 278.406 89.952C278.418 90.624 277.878 91.188 277.05 91.188H274.374V88.728H276.978ZM277.23 94.86H274.374V92.232H277.242C278.202 92.232 278.718 92.844 278.718 93.528C278.718 94.26 278.166 94.86 277.23 94.86ZM283.391 94.8V87.6H282.083V96H287.807V94.8H283.391ZM295.718 88.776V87.6H289.67V96H295.706V94.812H290.954V92.292H295.106V91.164H290.954V88.776H295.718Z"
          fill="#62D4DC"
        />
        <circle cx="213" cy="91" r="6" fill="#62D4DC" />
      </g>

      <g className="badge down" filter="url(#drop-shadow)">
        <rect
          x="325"
          y="398"
          width="85"
          height="32"
          rx="16"
          fill="url(#linear-gradient)"
        />
        <path
          d="M358.26 410.6H354.84V419H358.26C360.804 419 362.34 417.224 362.34 414.8C362.34 412.364 360.78 410.6 358.26 410.6ZM358.236 417.824H356.136V411.776H358.236C359.976 411.776 361.032 413.048 361.032 414.776C361.032 416.54 359.976 417.824 358.236 417.824ZM368.381 419.156C370.877 419.156 372.749 417.272 372.749 414.788C372.749 412.316 370.877 410.444 368.381 410.444C365.873 410.444 364.001 412.316 364.001 414.788C364.001 417.272 365.873 419.156 368.381 419.156ZM368.381 417.956C366.533 417.956 365.309 416.54 365.309 414.776C365.309 413.06 366.533 411.644 368.381 411.644C370.217 411.644 371.441 413.06 371.441 414.776C371.441 416.54 370.217 417.956 368.381 417.956ZM384.138 410.6L382.194 417.176L380.25 410.6H379.074L377.13 417.188L375.186 410.6H373.818L376.41 419H377.778L379.662 412.76L381.534 419H382.902L385.506 410.6H384.138ZM392.936 410.6V416.684L388.28 410.6H387.187V419H388.495V412.916L393.152 419H394.244V410.6H392.936Z"
          fill="#EC585D"
        />
        <circle cx="341" cy="414" r="6" fill="#EC585D" />
      </g>

      <g className="badge deploying" filter="url(#drop-shadow)">
        <rect
          x="111"
          y="512"
          width="118"
          height="32"
          rx="16"
          fill="url(#linear-gradient)"
        />
        <path
          d="M144.26 524.6H140.84V533H144.26C146.804 533 148.34 531.224 148.34 528.8C148.34 526.364 146.78 524.6 144.26 524.6ZM144.236 531.824H142.136V525.776H144.236C145.976 525.776 147.032 527.048 147.032 528.776C147.032 530.54 145.976 531.824 144.236 531.824ZM156.421 525.776V524.6H150.373V533H156.409V531.812H151.657V529.292H155.809V528.164H151.657V525.776H156.421ZM162.397 524.6H158.581V533H159.877V530.228H162.337C164.221 530.228 165.241 528.776 165.241 527.42C165.241 526.064 164.221 524.6 162.397 524.6ZM162.313 529.052H159.877V525.776H162.373C163.333 525.776 163.981 526.568 163.981 527.42C163.981 528.26 163.357 529.052 162.313 529.052ZM168.413 531.8V524.6H167.105V533H172.829V531.8H168.413ZM178.22 533.156C180.716 533.156 182.588 531.272 182.588 528.788C182.588 526.316 180.716 524.444 178.22 524.444C175.712 524.444 173.84 526.316 173.84 528.788C173.84 531.272 175.712 533.156 178.22 533.156ZM178.22 531.956C176.372 531.956 175.148 530.54 175.148 528.776C175.148 527.06 176.372 525.644 178.22 525.644C180.056 525.644 181.28 527.06 181.28 528.776C181.28 530.54 180.056 531.956 178.22 531.956ZM189.548 524.6L187.112 528.632L184.676 524.6H183.212L186.452 529.844V533H187.772V529.844L191.012 524.6H189.548ZM192.656 533H193.976V524.6H192.656V533ZM202.124 524.6V530.684L197.468 524.6H196.376V533H197.684V526.916L202.34 533H203.432V524.6H202.124ZM214.107 528.44H209.847V529.568L212.775 529.556C212.655 530.972 211.587 531.944 209.967 531.944C207.963 531.944 206.763 530.468 206.763 528.776C206.763 527.084 207.999 525.656 209.847 525.656C211.239 525.656 212.163 526.34 212.595 527.3L213.819 526.964C213.279 525.548 211.827 524.444 209.835 524.444C207.351 524.444 205.455 526.316 205.455 528.788C205.455 531.26 207.351 533.156 209.895 533.156C212.331 533.156 214.107 531.608 214.107 529.112V528.44Z"
          fill="#E99262"
        />
        <circle cx="127" cy="528" r="6" fill="#E99262" />
      </g>

      <g className="badge available" filter="url(#drop-shadow)">
        <rect
          x="197"
          y="75"
          height="32"
          width="114"
          rx="16"
          fill="url(#linear-gradient)"
        />
        <path
          d="M233.056 96H234.412L231.088 87.6H229.42L226.096 96H227.452L228.256 93.96H232.252L233.056 96ZM228.7 92.808L230.26 88.836L231.808 92.808H228.7ZM241.071 87.6L238.443 94.38L235.815 87.6H234.387L237.735 96H239.139L242.487 87.6H241.071ZM249.426 96H250.782L247.458 87.6H245.79L242.466 96H243.822L244.626 93.96H248.622L249.426 96ZM245.07 92.808L246.63 88.836L248.178 92.808H245.07ZM252.437 96H253.757V87.6H252.437V96ZM257.466 94.8V87.6H256.158V96H261.882V94.8H257.466ZM270.078 96H271.434L268.11 87.6H266.442L263.118 96H264.474L265.278 93.96H269.274L270.078 96ZM265.722 92.808L267.282 88.836L268.83 92.808H265.722ZM278.586 91.608C279.27 91.26 279.69 90.648 279.678 89.808C279.666 88.5 278.574 87.6 277.002 87.6H273.09V96H277.254C278.982 96 280.014 95.016 280.014 93.648C280.014 92.676 279.462 91.956 278.586 91.608ZM276.978 88.728C277.842 88.728 278.406 89.244 278.406 89.952C278.418 90.624 277.878 91.188 277.05 91.188H274.374V88.728H276.978ZM277.23 94.86H274.374V92.232H277.242C278.202 92.232 278.718 92.844 278.718 93.528C278.718 94.26 278.166 94.86 277.23 94.86ZM283.391 94.8V87.6H282.083V96H287.807V94.8H283.391ZM295.718 88.776V87.6H289.67V96H295.706V94.812H290.954V92.292H295.106V91.164H290.954V88.776H295.718Z"
          fill="#62D4DC"
        />
        <circle cx="213" cy="91" r="6" fill="#62D4DC" />
      </g>

      <g className="badge down" filter="url(#drop-shadow)">
        <rect
          x="325"
          y="398"
          width="85"
          height="32"
          rx="16"
          fill="url(#linear-gradient)"
        />
        <path
          d="M358.26 410.6H354.84V419H358.26C360.804 419 362.34 417.224 362.34 414.8C362.34 412.364 360.78 410.6 358.26 410.6ZM358.236 417.824H356.136V411.776H358.236C359.976 411.776 361.032 413.048 361.032 414.776C361.032 416.54 359.976 417.824 358.236 417.824ZM368.381 419.156C370.877 419.156 372.749 417.272 372.749 414.788C372.749 412.316 370.877 410.444 368.381 410.444C365.873 410.444 364.001 412.316 364.001 414.788C364.001 417.272 365.873 419.156 368.381 419.156ZM368.381 417.956C366.533 417.956 365.309 416.54 365.309 414.776C365.309 413.06 366.533 411.644 368.381 411.644C370.217 411.644 371.441 413.06 371.441 414.776C371.441 416.54 370.217 417.956 368.381 417.956ZM384.138 410.6L382.194 417.176L380.25 410.6H379.074L377.13 417.188L375.186 410.6H373.818L376.41 419H377.778L379.662 412.76L381.534 419H382.902L385.506 410.6H384.138ZM392.936 410.6V416.684L388.28 410.6H387.187V419H388.495V412.916L393.152 419H394.244V410.6H392.936Z"
          fill="#EC585D"
        />
        <circle cx="341" cy="414" r="6" fill="#EC585D" />
      </g>

      <g className="badge deploying" filter="url(#drop-shadow)">
        <rect
          x="111"
          y="512"
          width="118"
          height="32"
          rx="16"
          fill="url(#linear-gradient)"
        />
        <path
          d="M144.26 524.6H140.84V533H144.26C146.804 533 148.34 531.224 148.34 528.8C148.34 526.364 146.78 524.6 144.26 524.6ZM144.236 531.824H142.136V525.776H144.236C145.976 525.776 147.032 527.048 147.032 528.776C147.032 530.54 145.976 531.824 144.236 531.824ZM156.421 525.776V524.6H150.373V533H156.409V531.812H151.657V529.292H155.809V528.164H151.657V525.776H156.421ZM162.397 524.6H158.581V533H159.877V530.228H162.337C164.221 530.228 165.241 528.776 165.241 527.42C165.241 526.064 164.221 524.6 162.397 524.6ZM162.313 529.052H159.877V525.776H162.373C163.333 525.776 163.981 526.568 163.981 527.42C163.981 528.26 163.357 529.052 162.313 529.052ZM168.413 531.8V524.6H167.105V533H172.829V531.8H168.413ZM178.22 533.156C180.716 533.156 182.588 531.272 182.588 528.788C182.588 526.316 180.716 524.444 178.22 524.444C175.712 524.444 173.84 526.316 173.84 528.788C173.84 531.272 175.712 533.156 178.22 533.156ZM178.22 531.956C176.372 531.956 175.148 530.54 175.148 528.776C175.148 527.06 176.372 525.644 178.22 525.644C180.056 525.644 181.28 527.06 181.28 528.776C181.28 530.54 180.056 531.956 178.22 531.956ZM189.548 524.6L187.112 528.632L184.676 524.6H183.212L186.452 529.844V533H187.772V529.844L191.012 524.6H189.548ZM192.656 533H193.976V524.6H192.656V533ZM202.124 524.6V530.684L197.468 524.6H196.376V533H197.684V526.916L202.34 533H203.432V524.6H202.124ZM214.107 528.44H209.847V529.568L212.775 529.556C212.655 530.972 211.587 531.944 209.967 531.944C207.963 531.944 206.763 530.468 206.763 528.776C206.763 527.084 207.999 525.656 209.847 525.656C211.239 525.656 212.163 526.34 212.595 527.3L213.819 526.964C213.279 525.548 211.827 524.444 209.835 524.444C207.351 524.444 205.455 526.316 205.455 528.788C205.455 531.26 207.351 533.156 209.895 533.156C212.331 533.156 214.107 531.608 214.107 529.112V528.44Z"
          fill="#E99262"
        />
        <circle cx="127" cy="528" r="6" fill="#E99262" />
      </g>

      <g filter="url(#drop-shadow)">
        <rect x="67" y="226" width="471" height="135" rx="8" fill="white" />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M90.445 248.637h3.234v4.85h4.85v-4.85h3.234l-5.659-5.659-5.659 5.659zm0 6.467v1.617h11.318v-1.617H90.445zm-1.617 1.617h1.617v-3.234h-1.617v3.234zm12.935 0h1.617v-3.234h-1.617v3.234z"
          fill="#1D1E1F"
        />
        <path
          d="M119.932 254.446h-5.322v-9.856h-2.503v11.962h7.825v-2.106zm4.45 2.247c1.185 0 2.18-.506 2.653-1.352h.149v1.211h2.338v-6.234c0-1.948-1.368-3.092-3.789-3.092-2.296 0-3.846 1.053-4.004 2.727h2.222c.199-.572.779-.879 1.65-.879.994 0 1.542.456 1.542 1.244v.754l-2.214.133c-2.271.133-3.54 1.094-3.54 2.744 0 1.666 1.236 2.744 2.993 2.744zm.796-1.766c-.837 0-1.426-.423-1.426-1.127 0-.672.506-1.062 1.542-1.128l1.849-.124v.68c0 .961-.846 1.699-1.965 1.699zm7.318-9.682v2.263h-1.426v1.832h1.426v4.75c0 1.774.878 2.495 3.1 2.495.464 0 .912-.05 1.21-.108v-1.782a5.684 5.684 0 01-.713.041c-.82 0-1.185-.381-1.185-1.202v-4.194h1.898v-1.832h-1.898v-2.263h-2.412zm12.084 8.729c-.257.621-.912.97-1.865.97-1.26 0-2.056-.871-2.089-2.264v-.124h6.275v-.721c0-2.885-1.591-4.609-4.286-4.609-2.719 0-4.393 1.84-4.393 4.808 0 2.951 1.641 4.708 4.427 4.708 2.238 0 3.821-1.069 4.178-2.768h-2.247zm-1.956-4.949c1.127 0 1.857.779 1.906 2.031h-3.896c.083-1.227.871-2.031 1.99-2.031zm5.966 1.061c0 1.401.862 2.238 2.636 2.628l1.658.373c.805.182 1.153.464 1.153.928 0 .605-.647 1.02-1.584 1.02-.961 0-1.55-.373-1.732-1.003h-2.354c.165 1.724 1.624 2.71 4.037 2.71 2.395 0 4.028-1.177 4.028-2.984 0-1.359-.795-2.105-2.569-2.495l-1.716-.373c-.846-.191-1.236-.481-1.236-.945 0-.597.639-1.003 1.501-1.003.895 0 1.451.373 1.575.978h2.23c-.133-1.724-1.501-2.694-3.822-2.694-2.279 0-3.805 1.152-3.805 2.86zm10.377-4.841v2.263h-1.426v1.832h1.426v4.75c0 1.774.879 2.495 3.1 2.495.465 0 .912-.05 1.211-.108v-1.782a5.684 5.684 0 01-.713.041c-.821 0-1.186-.381-1.186-1.202v-4.194h1.899v-1.832h-1.899v-2.263h-2.412zm13.807 11.448c1.268 0 2.304-.589 2.793-1.575h.15v1.434h2.337v-12.617h-2.412v4.949h-.141c-.472-1.012-1.492-1.608-2.727-1.608-2.296 0-3.722 1.798-3.722 4.7 0 2.91 1.417 4.717 3.722 4.717zm.82-7.461c1.285 0 2.073 1.053 2.073 2.76 0 1.708-.779 2.753-2.073 2.753-1.293 0-2.064-1.037-2.064-2.761 0-1.716.78-2.752 2.064-2.752zm12.789 4.742c-.256.621-.911.97-1.865.97-1.26 0-2.056-.871-2.089-2.264v-.124h6.276v-.721c0-2.885-1.592-4.609-4.286-4.609-2.719 0-4.394 1.84-4.394 4.808 0 2.951 1.642 4.708 4.427 4.708 2.238 0 3.822-1.069 4.178-2.768h-2.247zm-1.956-4.949c1.128 0 1.857.779 1.907 2.031h-3.896c.082-1.227.87-2.031 1.989-2.031zm11.455-1.749c-1.261 0-2.297.621-2.794 1.649h-.149v-1.5h-2.338v12.153h2.412v-4.419h.149c.448.962 1.451 1.534 2.761 1.534 2.288 0 3.689-1.774 3.689-4.709 0-2.943-1.418-4.708-3.73-4.708zm-.821 7.469c-1.277 0-2.073-1.045-2.073-2.753 0-1.707.796-2.76 2.081-2.76s2.064 1.036 2.064 2.752c0 1.724-.771 2.761-2.072 2.761zm6.514 1.807h2.412v-12.617h-2.412v12.617zm8.892.19c2.811 0 4.502-1.774 4.502-4.758 0-2.959-1.716-4.758-4.502-4.758-2.785 0-4.501 1.807-4.501 4.758 0 2.976 1.691 4.758 4.501 4.758zm0-1.906c-1.293 0-2.022-1.045-2.022-2.852 0-1.79.738-2.843 2.022-2.843 1.277 0 2.023 1.053 2.023 2.843 0 1.807-.738 2.852-2.023 2.852zm7.144 5.032c2.28 0 3.399-.813 4.178-3.142l3.15-9.301h-2.553l-1.923 6.963h-.149l-1.924-6.963h-2.661l3.209 9.176-.083.349c-.199.737-.713 1.036-1.617 1.036-.099 0-.464-.008-.547-.025v1.882c.1.016.829.025.92.025zm8.926-3.316h2.413v-5.505c0-1.044.671-1.807 1.616-1.807.945 0 1.509.564 1.509 1.542v5.77h2.321v-5.612c0-.987.63-1.7 1.608-1.7 1.02 0 1.525.547 1.525 1.65v5.662h2.413v-6.267c0-1.882-1.136-3.059-2.96-3.059-1.276 0-2.329.671-2.752 1.683h-.149c-.365-1.045-1.244-1.683-2.528-1.683-1.202 0-2.156.638-2.529 1.683h-.149v-1.484h-2.338v9.127zm21.576-2.578c-.257.621-.911.97-1.865.97-1.26 0-2.056-.871-2.089-2.264v-.124h6.276v-.721c0-2.885-1.592-4.609-4.286-4.609-2.719 0-4.394 1.84-4.394 4.808 0 2.951 1.642 4.708 4.427 4.708 2.238 0 3.821-1.069 4.178-2.768h-2.247zm-1.956-4.949c1.127 0 1.857.779 1.907 2.031h-3.897c.083-1.227.871-2.031 1.99-2.031zm6.174 7.527h2.412v-5.281c0-1.235.688-2.031 1.807-2.031 1.144 0 1.683.672 1.683 1.957v5.355h2.412v-5.903c0-2.18-1.094-3.423-3.125-3.423-1.351 0-2.279.638-2.702 1.666h-.149v-1.467h-2.338v9.127zm11.264-11.307v2.263h-1.426v1.832h1.426v4.75c0 1.774.878 2.495 3.1 2.495.464 0 .912-.05 1.21-.108v-1.782a5.684 5.684 0 01-.713.041c-.82 0-1.185-.381-1.185-1.202v-4.194h1.898v-1.832h-1.898v-2.263h-2.412z"
          fill="#1D1E1F"
        />
        <path
          d="M375.351 256.371l3.645-10.253h-1.691l-2.75 8.349h-.12l-2.764-8.349h-1.734l3.666 10.253h1.748zm6.047-9.095a.965.965 0 00.966-.959.967.967 0 00-1.932 0c0 .526.433.959.966.959zm-.76 9.095h1.52v-7.716h-1.52v7.716zm8.839-2.068c-.284.626-.917.967-1.84.967-1.223 0-2.011-.881-2.061-2.281v-.071h5.464v-.526c0-2.416-1.3-3.887-3.453-3.887-2.182 0-3.567 1.571-3.567 4.022 0 2.466 1.357 3.993 3.574 3.993 1.769 0 3.02-.852 3.354-2.217h-1.471zm-1.897-4.554c1.129 0 1.868.817 1.904 2.067h-3.908c.085-1.243.874-2.067 2.004-2.067zm15.312-1.094h-1.528l-1.378 5.954h-.121l-1.592-5.954h-1.463l-1.592 5.954h-.114l-1.385-5.954h-1.549l2.132 7.716h1.57l1.591-5.755h.121l1.599 5.755h1.584l2.125-7.716zm7.695 7.844c1.016 0 1.862-.441 2.324-1.222h.121v1.094h1.47v-5.279c0-1.62-1.094-2.587-3.034-2.587-1.755 0-3.005.846-3.162 2.146h1.478c.171-.561.761-.881 1.613-.881 1.045 0 1.585.476 1.585 1.322v.675l-2.096.128c-1.841.113-2.878.916-2.878 2.302 0 1.407 1.087 2.302 2.579 2.302zm.391-1.229c-.831 0-1.435-.419-1.435-1.137 0-.704.483-1.08 1.549-1.151l1.89-.128v.668c0 .995-.853 1.748-2.004 1.748zm5.77 1.101h1.527v-10.743h-1.527v10.743zm3.893 0h1.528v-10.743h-1.528v10.743zm10.63.128c1.066 0 1.968-.504 2.43-1.35h.121v1.222h1.464v-10.743h-1.528v4.249h-.113c-.42-.846-1.315-1.357-2.374-1.357-1.954 0-3.211 1.556-3.211 3.986 0 2.444 1.243 3.993 3.211 3.993zm.434-6.672c1.279 0 2.082 1.037 2.082 2.686 0 1.663-.796 2.679-2.082 2.679-1.293 0-2.068-1.002-2.068-2.679 0-1.67.782-2.686 2.068-2.686zm10.949 4.476c-.284.626-.916.967-1.84.967-1.222 0-2.011-.881-2.061-2.281v-.071h5.464v-.526c0-2.416-1.3-3.887-3.453-3.887-2.181 0-3.567 1.571-3.567 4.022 0 2.466 1.357 3.993 3.574 3.993 1.77 0 3.02-.852 3.354-2.217h-1.471zm-1.897-4.554c1.13 0 1.869.817 1.904 2.067h-3.908c.086-1.243.874-2.067 2.004-2.067zm9.308-1.229c-1.051 0-1.961.532-2.43 1.414h-.113v-1.279h-1.471v10.288h1.527v-3.737h.121c.405.817 1.279 1.293 2.38 1.293 1.954 0 3.198-1.549 3.198-3.986 0-2.452-1.244-3.993-3.212-3.993zm-.433 6.672c-1.279 0-2.082-1.031-2.082-2.679 0-1.656.803-2.686 2.089-2.686 1.293 0 2.068 1.009 2.068 2.686s-.775 2.679-2.075 2.679zm5.556 1.179h1.528v-10.743h-1.528v10.743zm7.092.149c2.259 0 3.645-1.513 3.645-4.007 0-2.494-1.393-4.008-3.645-4.008-2.26 0-3.653 1.521-3.653 4.008 0 2.494 1.386 4.007 3.653 4.007zm0-1.3c-1.329 0-2.075-.988-2.075-2.707 0-1.72.746-2.714 2.075-2.714 1.321 0 2.074.994 2.074 2.714 0 1.712-.753 2.707-2.074 2.707zm5.954 3.951c1.577 0 2.309-.59 2.97-2.445l2.885-8.071h-1.62l-1.933 6.181h-.121l-1.939-6.181h-1.663l2.799 7.737-.113.398c-.263.817-.675 1.123-1.4 1.123a3.72 3.72 0 01-.497-.028v1.25c.142.021.504.036.632.036zm7.418-2.8h1.528v-4.739c0-1.009.703-1.798 1.634-1.798.91 0 1.492.547 1.492 1.428v5.109h1.499v-4.881c0-.931.647-1.656 1.635-1.656 1.002 0 1.499.519 1.499 1.585v4.952h1.528v-5.322c0-1.606-.91-2.544-2.473-2.544-1.073 0-1.961.547-2.352 1.379h-.121c-.341-.832-1.073-1.379-2.131-1.379-1.031 0-1.812.512-2.153 1.379h-.114v-1.229h-1.471v7.716zm18.034-2.068c-.284.626-.917.967-1.841.967-1.222 0-2.01-.881-2.06-2.281v-.071h5.464v-.526c0-2.416-1.3-3.887-3.453-3.887-2.182 0-3.567 1.571-3.567 4.022 0 2.466 1.357 3.993 3.574 3.993 1.769 0 3.02-.852 3.354-2.217h-1.471zm-1.897-4.554c1.129 0 1.868.817 1.904 2.067h-3.908c.085-1.243.874-2.067 2.004-2.067zm5.293 6.622h1.528v-4.526c0-1.244.718-2.011 1.847-2.011 1.13 0 1.67.625 1.67 1.904v4.633h1.528v-4.995c0-1.84-.952-2.871-2.679-2.871-1.165 0-1.933.519-2.309 1.372h-.114v-1.222h-1.471v7.716zm9.266-9.663v1.968h-1.23v1.222h1.23v4.441c0 1.485.675 2.082 2.373 2.082.298 0 .583-.036.831-.078v-1.215c-.213.021-.348.035-.582.035-.761 0-1.095-.362-1.095-1.194v-4.071h1.677v-1.222h-1.677v-1.968h-1.527zm4.711 4.107c0 1.144.682 1.797 2.153 2.138l1.35.32c.774.185 1.137.497 1.137.981 0 .632-.676 1.073-1.628 1.073-.923 0-1.492-.377-1.684-.981h-1.527c.135 1.343 1.336 2.174 3.176 2.174 1.847 0 3.204-.973 3.204-2.408 0-1.123-.689-1.755-2.16-2.097l-1.286-.298c-.838-.199-1.229-.497-1.229-.973 0-.626.647-1.045 1.499-1.045.867 0 1.421.377 1.563.952h1.464c-.149-1.336-1.286-2.146-3.027-2.146-1.748 0-3.005.967-3.005 2.31z"
          fill="#4294FF"
        />
        <path fill="#F2F2F3" d="M86.402 275.72h430v1h-430z" />
        <g clipPath="url(#version-badge)">
          <path
            d="M86.402 303.398c0-6.697 5.43-12.127 12.127-12.127h30.299c6.697 0 12.126 5.43 12.126 12.127 0 6.698-5.429 12.127-12.126 12.127H98.529c-6.697 0-12.127-5.429-12.127-12.127z"
            fill="#F0F5FF"
          />
          <path
            d="M88.828 293.697a2.426 2.426 0 012.425-2.426h44.851a2.425 2.425 0 012.425 2.426v19.402a2.425 2.425 0 01-2.425 2.426h-44.85a2.426 2.426 0 01-2.426-2.426v-19.402z"
            fill="#F0F5FF"
          />
          <path
            d="M101.978 300.539h-1.755l-2.079 6.666h-.13l-2.087-6.666h-1.77l3.025 8.359h1.778l3.018-8.359zm6.527 8.359h1.663v-2.209h1.532v-1.462h-1.532v-7.436h-2.456a152.054 152.054 0 00-4.626 7.436v1.462h5.419v2.209zm-3.764-3.748a126.278 126.278 0 013.687-5.904h.1v6.011h-3.787v-.107zm12.794 4.01c2.778 0 4.403-2.201 4.403-5.973 0-3.726-1.786-5.666-4.334-5.666-2.356 0-4.026 1.609-4.026 3.865 0 2.14 1.539 3.702 3.656 3.702 1.317 0 2.379-.616 2.91-1.678h.131c-.046 2.756-1.024 4.295-2.725 4.295-1.016 0-1.809-.554-2.071-1.47h-1.739c.331 1.786 1.824 2.925 3.795 2.925zm.077-5.465c-1.371 0-2.317-.962-2.317-2.363 0-1.34 1-2.371 2.332-2.371 1.324 0 2.325 1.047 2.325 2.417 0 1.347-.978 2.317-2.34 2.317zm10.491 5.473c2.471 0 4.18-1.332 4.18-3.249 0-1.431-.939-2.555-2.363-2.825v-.13c1.17-.301 1.909-1.247 1.909-2.456 0-1.747-1.547-2.987-3.726-2.987-2.178 0-3.725 1.24-3.725 2.987 0 1.201.754 2.163 1.909 2.456v.13c-1.424.285-2.356 1.409-2.356 2.833 0 1.917 1.701 3.241 4.172 3.241zm0-6.736c-1.208 0-2.024-.708-2.024-1.762 0-1.07.808-1.786 2.024-1.786 1.217 0 2.033.716 2.033 1.786 0 1.054-.824 1.762-2.033 1.762zm0 5.366c-1.424 0-2.409-.824-2.409-2.009 0-1.186.985-2.002 2.409-2.002s2.41.816 2.41 2.002c0 1.185-.986 2.009-2.41 2.009z"
            fill="#1563FF"
          />
        </g>
        <path
          d="M165.889 299.421l.166-.249.289.174.127.091c.309.237.959.843 1.1 1.846.245-.043.493-.065.742-.066.589 0 .985.137 1.21.249l.115.063.075.05.211.171-.072.219a2.228 2.228 0 01-.52.8c-.319.327-.88.714-1.774.764l-.196.006h-.163c-.408 1.072-.957 2.278-1.878 3.361a7.81 7.81 0 01-1.919 1.631 8.818 8.818 0 01-2.812 1.061 11.22 11.22 0 01-2.155.203c-1.6 0-3.011-.316-3.88-.869-.775-.491-1.371-1.295-1.772-2.386a9.002 9.002 0 01-.509-3.102.567.567 0 01.477-.565l.075-.006h11.627l.102-.007.164-.018c.283-.037.713-.121 1.016-.296-.362-.595-.465-1.291-.296-2.032.071-.311.183-.609.331-.888l.119-.205zm-10.427 1.368l.043.008a.136.136 0 01.086.09l.007.044v1.441l-.007.045a.145.145 0 01-.086.09l-.043.007h-1.558a.137.137 0 01-.129-.097l-.007-.045v-1.441l.007-.045a.138.138 0 01.086-.09l.043-.007h1.558zm2.147 0l.044.008c.04.014.072.047.085.09l.007.044v1.441l-.007.045a.145.145 0 01-.086.09l-.043.007h-1.558a.138.138 0 01-.13-.097l-.007-.045v-1.441c0-.063.039-.116.094-.135l.043-.007h1.558zm2.18 0l.043.008a.136.136 0 01.086.09l.007.044v1.441l-.007.045a.145.145 0 01-.086.09l-.043.007h-1.558a.137.137 0 01-.13-.097l-.007-.045v-1.441l.007-.045a.143.143 0 01.086-.09l.043-.007h1.559zm2.154 0l.043.007a.138.138 0 01.086.09l.007.045v1.441a.142.142 0 01-.093.135l-.043.007h-1.559a.137.137 0 01-.129-.097l-.007-.045v-1.441l.007-.045a.143.143 0 01.086-.09l.043-.007h1.559zm2.172 0l.044.007a.14.14 0 01.086.09l.007.045v1.441a.142.142 0 01-.093.135l-.044.007h-1.558a.137.137 0 01-.129-.097l-.007-.045v-1.441l.007-.045a.143.143 0 01.086-.09l.043-.007h1.558zm-6.506-2.073l.043.007c.04.014.072.047.086.089l.007.045v1.441a.142.142 0 01-.093.135l-.043.007h-1.558a.137.137 0 01-.13-.097l-.007-.045v-1.441c0-.062.039-.115.094-.134l.043-.007h1.558zm2.18 0l.043.007c.04.014.072.047.086.089l.007.045v1.441a.142.142 0 01-.093.135l-.043.007h-1.558a.137.137 0 01-.13-.097l-.007-.045v-1.441l.007-.045a.14.14 0 01.087-.089l.043-.007h1.558zm2.154 0c.06 0 .111.04.129.096l.007.045v1.441a.142.142 0 01-.093.135l-.043.007h-1.559a.137.137 0 01-.129-.097l-.007-.045v-1.441l.007-.045a.141.141 0 01.086-.089l.043-.007h1.559zm0-2.074c.06 0 .111.04.129.096l.007.045v1.442a.142.142 0 01-.093.134l-.043.007h-1.559a.136.136 0 01-.129-.096l-.007-.045v-1.442l.007-.045a.141.141 0 01.086-.089l.043-.007h1.559z"
          fill="#2396ED"
        />
        <path
          d="M176.567 309.898h2.056v-5.264c0-1.276.928-2.105 2.263-2.105.348 0 .895.058 1.052.116v-1.874a4.119 4.119 0 00-.853-.082c-1.169 0-2.147.663-2.396 1.558h-.141v-1.409h-1.981v9.06zm12.656-2.478c-.298.68-1.003 1.061-2.023 1.061-1.351 0-2.221-.962-2.271-2.495v-.108h6.333v-.655c0-2.843-1.55-4.559-4.136-4.559-2.628 0-4.261 1.832-4.261 4.741 0 2.902 1.608 4.676 4.277 4.676 2.139 0 3.656-1.028 4.029-2.661h-1.948zm-2.105-5.156c1.235 0 2.047.87 2.089 2.246h-4.27c.091-1.359.954-2.246 2.181-2.246zm11.064-1.575c-1.243 0-2.296.621-2.818 1.649h-.141v-1.5h-1.981v12.07h2.055v-4.386h.141c.465.962 1.468 1.526 2.769 1.526 2.288 0 3.714-1.799 3.714-4.676 0-2.901-1.442-4.683-3.739-4.683zm-.646 7.651c-1.401 0-2.272-1.136-2.28-2.968.008-1.832.887-2.967 2.288-2.967 1.409 0 2.263 1.11 2.263 2.967s-.845 2.968-2.271 2.968zm6.447 1.558h2.056v-12.567h-2.056v12.567zm7.069.15c1.186 0 2.18-.514 2.686-1.393h.141v1.243h1.981v-6.192c0-1.915-1.309-3.042-3.639-3.042-2.155 0-3.656 1.011-3.821 2.594h1.939c.191-.621.838-.961 1.783-.961 1.11 0 1.707.505 1.707 1.409v.779l-2.337.141c-2.205.125-3.441 1.078-3.441 2.703 0 1.658 1.252 2.719 3.001 2.719zm.605-1.584c-.911 0-1.566-.456-1.566-1.235 0-.754.538-1.177 1.691-1.252l2.047-.141v.738c0 1.078-.928 1.89-2.172 1.89zm7.31 4.717c2.031 0 3.001-.738 3.772-2.968l3.274-9.375h-2.172l-2.114 7.112h-.141l-2.122-7.112h-2.254l3.241 9.094-.108.422c-.265.854-.754 1.186-1.625 1.186-.141 0-.447-.008-.563-.025v1.633c.132.025.688.033.812.033zm14.024-7.162v-1.882h-5.446v1.882h5.446zm14.431-5.181h-2.048l-1.5 6.806h-.141l-1.758-6.806h-1.964l-1.741 6.806h-.141l-1.509-6.806h-2.072l2.453 9.06h2.139l1.758-6.565h.14l1.766 6.565h2.164l2.454-9.06zm7.259 6.582c-.298.68-1.003 1.061-2.022 1.061-1.352 0-2.222-.962-2.272-2.495v-.108h6.334v-.655c0-2.843-1.551-4.559-4.137-4.559-2.628 0-4.261 1.832-4.261 4.741 0 2.902 1.608 4.676 4.278 4.676 2.138 0 3.655-1.028 4.028-2.661h-1.948zm-2.105-5.156c1.235 0 2.047.87 2.089 2.246h-4.269c.091-1.359.953-2.246 2.18-2.246zm11.164 7.784c2.288 0 3.722-1.799 3.722-4.676 0-2.893-1.426-4.683-3.722-4.683-1.243 0-2.288.605-2.76 1.591h-.141v-4.949h-2.056v12.567h1.981v-1.434h.141c.514.995 1.567 1.584 2.835 1.584zm-.647-7.643c1.401 0 2.255 1.119 2.255 2.967 0 1.849-.845 2.968-2.255 2.968-1.409 0-2.288-1.136-2.288-2.968s.887-2.967 2.288-2.967zm7.882 1.575c.787 0 1.326-.556 1.326-1.285 0-.738-.539-1.285-1.326-1.285-.779 0-1.326.547-1.326 1.285 0 .729.547 1.285 1.326 1.285zm0 6.084c.787 0 1.326-.555 1.326-1.293 0-.729-.539-1.285-1.326-1.285-.779 0-1.326.556-1.326 1.285 0 .738.547 1.293 1.326 1.293zm4.052-.166h2.056v-12.567h-2.056v12.567zm7.069.15c1.185 0 2.18-.514 2.686-1.393h.141v1.243h1.981v-6.192c0-1.915-1.31-3.042-3.639-3.042-2.156 0-3.656 1.011-3.822 2.594h1.94c.191-.621.837-.961 1.782-.961 1.111 0 1.708.505 1.708 1.409v.779l-2.338.141c-2.205.125-3.44 1.078-3.44 2.703 0 1.658 1.252 2.719 3.001 2.719zm.605-1.584c-.912 0-1.567-.456-1.567-1.235 0-.754.539-1.177 1.691-1.252l2.048-.141v.738c0 1.078-.929 1.89-2.172 1.89zm7.251-9.848v2.28h-1.434v1.6h1.434v4.998c0 1.75.829 2.446 2.91 2.446.398 0 .779-.033 1.078-.091v-1.575c-.249.025-.406.041-.697.041-.862 0-1.243-.406-1.243-1.31v-4.509h1.94v-1.6H292v-2.28h-2.048zm11.786 8.804c-.298.68-1.003 1.061-2.022 1.061-1.351 0-2.222-.962-2.272-2.495v-.108h6.334v-.655c0-2.843-1.55-4.559-4.137-4.559-2.628 0-4.261 1.832-4.261 4.741 0 2.902 1.608 4.676 4.278 4.676 2.138 0 3.655-1.028 4.029-2.661h-1.949zm-2.105-5.156c1.235 0 2.047.87 2.089 2.246h-4.269c.091-1.359.953-2.246 2.18-2.246zm5.917 1.16c0 1.36.82 2.155 2.561 2.553l1.608.373c.863.199 1.252.531 1.252 1.045 0 .688-.721 1.161-1.757 1.161-1.028 0-1.666-.415-1.865-1.086h-2.031c.157 1.633 1.583 2.611 3.846 2.611s3.863-1.152 3.863-2.885c0-1.335-.804-2.072-2.537-2.47l-1.6-.357c-.911-.215-1.342-.539-1.342-1.053 0-.671.704-1.127 1.641-1.127.962 0 1.567.414 1.716 1.053h1.931c-.149-1.633-1.5-2.578-3.655-2.578-2.139 0-3.631 1.135-3.631 2.76zm10.061-4.808v2.28h-1.434v1.6h1.434v4.998c0 1.75.829 2.446 2.91 2.446.398 0 .779-.033 1.078-.091v-1.575c-.249.025-.406.041-.697.041-.862 0-1.243-.406-1.243-1.31v-4.509h1.94v-1.6h-1.94v-2.28h-2.048z"
          fill="#1D1E1F"
        />
        <path
          d="M95.34 323.607c-.16.008-.315.049-.459.119l-6.257 3.053a1.213 1.213 0 00-.647.823l-1.545 6.859a1.232 1.232 0 00.23 1.026l4.332 5.5a1.195 1.195 0 00.936.456l6.946-.001a1.184 1.184 0 00.935-.455l4.33-5.502a1.214 1.214 0 00.231-1.025l-1.546-6.86a1.22 1.22 0 00-.647-.822l-6.259-3.052a1.178 1.178 0 00-.58-.119z"
          fill="#326CE5"
        />
        <path
          d="M95.402 325.941c-.207 0-.374.191-.374.425v.109c.005.136.033.239.05.364.032.267.059.488.043.694a.425.425 0 01-.122.198l-.009.162a4.79 4.79 0 00-3.124 1.534 8.394 8.394 0 01-.136-.098c-.067.009-.134.03-.222-.022-.168-.116-.32-.275-.505-.466-.085-.092-.146-.179-.247-.268-.022-.02-.057-.047-.083-.067a.44.44 0 00-.26-.101.357.357 0 00-.3.135c-.128.165-.087.418.093.564l.005.004c.025.02.055.047.078.064.107.08.204.121.31.185.225.142.41.259.558.4.057.063.067.173.075.221l.12.109a5.035 5.035 0 00-.764 3.451l-.157.047c-.042.054-.1.14-.161.166-.193.062-.41.085-.672.113-.123.01-.229.004-.359.029a2.634 2.634 0 00-.1.024l-.003.001-.006.001c-.22.055-.362.262-.317.466.046.204.261.329.484.28l.005-.001.007-.003c.031-.007.07-.014.097-.022.128-.035.221-.086.336-.131.248-.091.453-.167.653-.196.084-.007.172.052.216.077l.163-.028a4.96 4.96 0 002.16 2.754l-.068.167c.025.065.052.152.033.216-.072.193-.197.396-.339.623-.068.104-.139.186-.2.305-.015.029-.034.073-.049.103-.096.211-.025.453.16.544.186.091.417-.005.517-.216v-.001-.001c.015-.029.035-.069.047-.097.053-.124.07-.23.108-.35.1-.255.153-.521.29-.688.037-.045.098-.063.161-.08l.085-.157a4.745 4.745 0 003.457.009l.08.147c.064.022.134.033.191.119.102.178.172.388.257.643.037.12.056.226.109.351.012.028.032.068.046.098.1.211.332.308.518.216.185-.091.256-.333.16-.543-.015-.031-.035-.075-.05-.103-.062-.12-.132-.2-.2-.305-.142-.227-.26-.415-.333-.607-.03-.1.006-.161.03-.226-.015-.017-.045-.11-.063-.155a4.957 4.957 0 002.159-2.774c.049.008.133.023.16.029.056-.038.108-.088.21-.079.2.029.405.105.653.196.115.045.208.097.336.132.027.008.066.014.097.021l.007.003.006.001c.222.049.437-.076.483-.28.046-.204-.096-.411-.317-.466-.032-.007-.078-.02-.109-.026-.13-.025-.236-.019-.359-.029-.262-.028-.479-.051-.672-.113-.078-.031-.134-.127-.161-.166l-.151-.045a5.046 5.046 0 00-.78-3.443l.132-.122c.006-.068.001-.14.07-.216.148-.142.334-.259.558-.4.106-.064.204-.105.311-.186.024-.018.057-.047.082-.067.18-.147.221-.399.092-.564-.129-.166-.379-.181-.558-.035-.026.021-.061.048-.084.068-.1.088-.162.176-.247.267-.184.192-.337.352-.505.467-.072.043-.179.028-.227.025l-.143.104a4.869 4.869 0 00-3.109-1.534 9.53 9.53 0 01-.009-.171c-.048-.047-.107-.088-.122-.191-.016-.206.01-.427.042-.694.018-.125.047-.228.052-.364l-.001-.109c0-.234-.168-.425-.375-.425h0zm-.469 2.968l-.111 2.006-.008.004a.328.328 0 01-.524.259l-.003.001-1.611-1.166a3.836 3.836 0 012.257-1.104zm.939 0c.852.107 1.64.501 2.244 1.105l-1.6 1.159-.006-.003a.326.326 0 01-.453-.062.337.337 0 01-.072-.195l-.002-.001-.111-2.003zm-3.78 1.853l1.47 1.344-.001.008a.343.343 0 01.041.465.328.328 0 01-.17.115l-.002.006-1.886.556a4.01 4.01 0 01.547-2.494zm6.61.001a4.07 4.07 0 01.564 2.487l-1.894-.558-.002-.008a.338.338 0 01-.13-.579v-.005l1.463-1.337h0zM95.1 332.21h.603l.375.478-.135.597-.54.266-.543-.267-.135-.597.376-.477zm1.933 1.636a.322.322 0 01.076.006l.003-.004 1.95.337a3.931 3.931 0 01-1.561 2.003l-.757-1.867.002-.004a.34.34 0 01.287-.471h0zm-3.276.009a.331.331 0 01.317.262.343.343 0 01-.019.208l.006.007-.75 1.849a3.945 3.945 0 01-1.556-1.99l1.934-.335.003.004a.285.285 0 01.065-.005v0zm1.633.81a.327.327 0 01.303.177h.007l.953 1.759a3.796 3.796 0 01-2.495-.002l.951-1.756h.002a.33.33 0 01.28-.178z"
          fill="#fff"
          stroke="#fff"
          strokeWidth=".219"
        />
        <path
          d="M95.34 323.607c-.16.008-.315.049-.459.119l-6.257 3.053a1.213 1.213 0 00-.647.823l-1.545 6.859a1.232 1.232 0 00.23 1.026l4.332 5.5a1.195 1.195 0 00.936.456l6.946-.001a1.184 1.184 0 00.935-.455l4.33-5.502a1.214 1.214 0 00.231-1.025l-1.546-6.86a1.22 1.22 0 00-.647-.822l-6.259-3.052a1.178 1.178 0 00-.58-.119z"
          fill="#326CE5"
        />
        <path
          d="M95.402 325.941c-.207 0-.374.191-.374.425v.109c.005.136.033.239.05.364.032.267.059.488.043.694a.425.425 0 01-.122.198l-.009.162a4.79 4.79 0 00-3.124 1.534 8.394 8.394 0 01-.136-.098c-.067.009-.134.03-.222-.022-.168-.116-.32-.275-.505-.466-.085-.092-.146-.179-.247-.268-.022-.02-.057-.047-.083-.067a.44.44 0 00-.26-.101.357.357 0 00-.3.135c-.128.165-.087.418.093.564l.005.004c.025.02.055.047.078.064.107.08.204.121.31.185.225.142.41.259.558.4.057.063.067.173.075.221l.12.109a5.035 5.035 0 00-.764 3.451l-.157.047c-.042.054-.1.14-.161.166-.193.062-.41.085-.672.113-.123.01-.229.004-.359.029a2.634 2.634 0 00-.1.024l-.003.001-.006.001c-.22.055-.362.262-.317.466.046.204.261.329.484.28l.005-.001.007-.003c.031-.007.07-.014.097-.022.128-.035.221-.086.336-.131.248-.091.453-.167.653-.196.084-.007.172.052.216.077l.163-.028a4.96 4.96 0 002.16 2.754l-.068.167c.025.065.052.152.033.216-.072.193-.197.396-.339.623-.068.104-.139.186-.2.305-.015.029-.034.073-.049.103-.096.211-.025.453.16.544.186.091.417-.005.517-.216v-.001-.001c.015-.029.035-.069.047-.097.053-.124.07-.23.108-.35.1-.255.153-.521.29-.688.037-.045.098-.063.161-.08l.085-.157a4.745 4.745 0 003.457.009l.08.147c.064.022.134.033.191.119.102.178.172.388.257.643.037.12.056.226.109.351.012.028.032.068.046.098.1.211.332.308.518.216.185-.091.256-.333.16-.543-.015-.031-.035-.075-.05-.103-.062-.12-.132-.2-.2-.305-.142-.227-.26-.415-.333-.607-.03-.1.006-.161.03-.226-.015-.017-.045-.11-.063-.155a4.957 4.957 0 002.159-2.774c.049.008.133.023.16.029.056-.038.108-.088.21-.079.2.029.405.105.653.196.115.045.208.097.336.132.027.008.066.014.097.021l.007.003.006.001c.222.049.437-.076.483-.28.046-.204-.096-.411-.317-.466-.032-.007-.078-.02-.109-.026-.13-.025-.236-.019-.359-.029-.262-.028-.479-.051-.672-.113-.078-.031-.134-.127-.161-.166l-.151-.045a5.046 5.046 0 00-.78-3.443l.132-.122c.006-.068.001-.14.07-.216.148-.142.334-.259.558-.4.106-.064.204-.105.311-.186.024-.018.057-.047.082-.067.18-.147.221-.399.092-.564-.129-.166-.379-.181-.558-.035-.026.021-.061.048-.084.068-.1.088-.162.176-.247.267-.184.192-.337.352-.505.467-.072.043-.179.028-.227.025l-.143.104a4.869 4.869 0 00-3.109-1.534 9.53 9.53 0 01-.009-.171c-.048-.047-.107-.088-.122-.191-.016-.206.01-.427.042-.694.018-.125.047-.228.052-.364l-.001-.109c0-.234-.168-.425-.375-.425h0zm-.469 2.968l-.111 2.006-.008.004a.328.328 0 01-.524.259l-.003.001-1.611-1.166a3.836 3.836 0 012.257-1.104zm.939 0c.852.107 1.64.501 2.244 1.105l-1.6 1.159-.006-.003a.326.326 0 01-.453-.062.337.337 0 01-.072-.195l-.002-.001-.111-2.003zm-3.78 1.853l1.47 1.344-.001.008a.343.343 0 01.041.465.328.328 0 01-.17.115l-.002.006-1.886.556a4.01 4.01 0 01.547-2.494zm6.61.001a4.07 4.07 0 01.564 2.487l-1.894-.558-.002-.008a.338.338 0 01-.13-.579v-.005l1.463-1.337h0zM95.1 332.21h.603l.375.478-.135.597-.54.266-.543-.267-.135-.597.376-.477zm1.933 1.636a.322.322 0 01.076.006l.003-.004 1.95.337a3.931 3.931 0 01-1.561 2.003l-.757-1.867.002-.004a.34.34 0 01.287-.471h0zm-3.276.009a.331.331 0 01.317.262.343.343 0 01-.019.208l.006.007-.75 1.849a3.945 3.945 0 01-1.556-1.99l1.934-.335.003.004a.285.285 0 01.065-.005v0zm1.633.81a.327.327 0 01.303.177h.007l.953 1.759a3.796 3.796 0 01-2.495-.002l.951-1.756h.002a.33.33 0 01.28-.178z"
          fill="#fff"
          stroke="#fff"
          strokeWidth=".219"
        />
        <circle cx="123.253" cy="332.525" r="4.851" fill="#2EB039" />
        <path
          d="M142.026 338.036h1.691l-3.702-10.253h-1.712l-3.702 10.253h1.634l.945-2.771h3.908l.938 2.771zm-2.949-8.441h.121l1.485 4.391h-3.098l1.492-4.391zm11.838.725h-1.62l-1.918 6.153h-.121l-1.926-6.153h-1.634l2.792 7.716h1.642l2.785-7.716zm3.418 7.844c1.016 0 1.861-.441 2.323-1.222h.121v1.094h1.471v-5.279c0-1.62-1.094-2.587-3.034-2.587-1.755 0-3.006.846-3.162 2.146h1.478c.17-.561.76-.881 1.613-.881 1.044 0 1.584.476 1.584 1.322v.675l-2.096.128c-1.84.113-2.877.916-2.877 2.302 0 1.407 1.087 2.302 2.579 2.302zm.391-1.229c-.832 0-1.436-.419-1.436-1.137 0-.704.483-1.08 1.549-1.151l1.89-.128v.668c0 .995-.852 1.748-2.003 1.748zm6.487-7.994a.965.965 0 00.966-.959.967.967 0 00-1.932 0c0 .526.433.959.966.959zm-.76 9.095h1.52v-7.716h-1.52v7.716zm3.837 0h1.527v-10.743h-1.527v10.743zm5.961.128c1.016 0 1.862-.441 2.324-1.222h.12v1.094h1.471v-5.279c0-1.62-1.094-2.587-3.034-2.587-1.755 0-3.005.846-3.162 2.146h1.478c.171-.561.76-.881 1.613-.881 1.045 0 1.585.476 1.585 1.322v.675l-2.097.128c-1.84.113-2.877.916-2.877 2.302 0 1.407 1.087 2.302 2.579 2.302zm.391-1.229c-.831 0-1.435-.419-1.435-1.137 0-.704.483-1.08 1.549-1.151l1.89-.128v.668c0 .995-.853 1.748-2.004 1.748zm9.798 1.229c1.954 0 3.198-1.556 3.198-3.986 0-2.452-1.237-3.993-3.198-3.993-1.058 0-1.968.518-2.38 1.357h-.121v-4.249h-1.527v10.743h1.47v-1.222h.114c.462.853 1.364 1.35 2.444 1.35zm-.44-6.672c1.293 0 2.067 1.016 2.067 2.686s-.774 2.679-2.067 2.679c-1.286 0-2.082-1.024-2.089-2.679.007-1.656.81-2.686 2.089-2.686zm5.549 6.544h1.528v-10.743h-1.528v10.743zm8.896-2.068c-.284.626-.916.967-1.84.967-1.222 0-2.011-.881-2.061-2.281v-.071h5.464v-.526c0-2.416-1.3-3.887-3.453-3.887-2.181 0-3.567 1.571-3.567 4.022 0 2.466 1.357 3.993 3.574 3.993 1.77 0 3.02-.852 3.354-2.217h-1.471zm-1.897-4.554c1.13 0 1.869.817 1.904 2.068h-3.908c.086-1.244.874-2.068 2.004-2.068z"
          fill="#727274"
        />
        <path
          d="M395.615 302.196h1.506c0-1.136.761-1.904 1.919-1.904 1.137 0 1.812.76 1.812 1.755 0 .832-.341 1.343-1.642 2.7l-3.51 3.652v1.08h6.907v-1.357h-4.732v-.12l2.259-2.274c1.798-1.805 2.316-2.651 2.316-3.837 0-1.684-1.385-2.913-3.311-2.913-2.067 0-3.524 1.335-3.524 3.218zm13.131 7.283h1.528v-4.519c0-1.208.696-2.01 1.946-2.01 1.081 0 1.656.632 1.656 1.904v4.625h1.528v-4.988c0-1.826-1.016-2.87-2.665-2.87-1.165 0-1.982.511-2.359 1.371h-.121v-4.256h-1.513v10.743zm12.079.15c2.26 0 3.645-1.514 3.645-4.008 0-2.494-1.392-4.007-3.645-4.007-2.259 0-3.652 1.52-3.652 4.007 0 2.494 1.386 4.008 3.652 4.008zm0-1.301c-1.329 0-2.075-.987-2.075-2.707 0-1.719.746-2.714 2.075-2.714 1.322 0 2.075.995 2.075 2.714 0 1.713-.753 2.707-2.075 2.707zm12.008-6.565h-1.527v4.526c0 1.244-.675 1.997-1.912 1.997-1.122 0-1.627-.611-1.627-1.89v-4.633h-1.527v5.009c0 1.812.952 2.857 2.664 2.857 1.173 0 1.961-.498 2.338-1.372h.121v1.222h1.47v-7.716zm2.217 7.716h1.528v-4.611c0-1.087.817-1.833 1.975-1.833.27 0 .725.05.853.085v-1.435a3.78 3.78 0 00-.682-.057c-1.009 0-1.869.547-2.089 1.307h-.114v-1.172h-1.471v7.716zm5.493-5.556c0 1.144.682 1.798 2.153 2.139l1.35.32c.774.184 1.137.497 1.137.98 0 .632-.675 1.073-1.627 1.073-.924 0-1.493-.377-1.684-.981h-1.528c.135 1.343 1.336 2.175 3.176 2.175 1.848 0 3.205-.974 3.205-2.409 0-1.123-.69-1.755-2.16-2.096l-1.286-.299c-.839-.199-1.23-.497-1.23-.973 0-.625.647-1.045 1.5-1.045.866 0 1.421.377 1.563.953h1.463c-.149-1.336-1.286-2.146-3.026-2.146-1.748 0-3.006.966-3.006 2.309zm14.14 5.684c1.016 0 1.861-.44 2.323-1.222h.121v1.094h1.471V304.2c0-1.62-1.094-2.586-3.034-2.586-1.755 0-3.006.845-3.162 2.146h1.478c.17-.562.76-.881 1.613-.881 1.044 0 1.584.476 1.584 1.321v.675l-2.096.128c-1.84.114-2.878.917-2.878 2.302 0 1.407 1.088 2.302 2.58 2.302zm.391-1.229c-.832 0-1.436-.419-1.436-1.137 0-.703.483-1.08 1.549-1.151l1.89-.128v.668c0 .995-.852 1.748-2.003 1.748zm8.96 4.05c2.188 0 3.574-1.115 3.574-2.87v-7.795h-1.464v1.229h-.121c-.433-.838-1.364-1.364-2.43-1.364-1.975 0-3.212 1.556-3.212 3.894 0 2.316 1.223 3.844 3.198 3.844 1.066 0 1.918-.462 2.387-1.3h.114v1.485c0 1.044-.753 1.669-2.025 1.669-1.03 0-1.677-.369-1.805-.952h-1.563c.163 1.301 1.414 2.16 3.347 2.16zm-.022-4.327c-1.314 0-2.053-1.002-2.053-2.579 0-1.578.739-2.587 2.053-2.587 1.301 0 2.096 1.009 2.096 2.587 0 1.577-.788 2.579-2.096 2.579zm9.081 1.528c2.26 0 3.645-1.514 3.645-4.008 0-2.494-1.392-4.007-3.645-4.007-2.259 0-3.652 1.52-3.652 4.007 0 2.494 1.385 4.008 3.652 4.008zm0-1.301c-1.329 0-2.075-.987-2.075-2.707 0-1.719.746-2.714 2.075-2.714 1.322 0 2.075.995 2.075 2.714 0 1.713-.753 2.707-2.075 2.707z"
          fill="#6F7682"
        />
        <path fill="#727274" d="M371.402 296.691h14.552v14.552h-14.552z"></path>
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M376.86 306.496l-2.528-2.528-.861.855 3.389 3.389 7.276-7.276-.855-.855-6.421 6.415z"
          fill="#fff"
        ></path>
      </g>

      <clipPath id="version-badge">
        <path
          d="M86.402 303.398c0-6.697 5.43-12.127 12.127-12.127h30.299c6.697 0 12.126 5.43 12.126 12.127 0 6.698-5.429 12.127-12.126 12.127H98.529c-6.697 0-12.127-5.429-12.127-12.127z"
          fill="#fff"
        />
      </clipPath>

      <linearGradient
        id="circle-fill"
        x1="408"
        y1="107"
        x2="116.292"
        y2="434.902"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#D3FDDB" />
        <stop offset="1" stopColor="#62D4DC" />
      </linearGradient>

      <linearGradient
        id="linear-gradient"
        x1="354.387"
        y1="404.264"
        x2="388.907"
        y2="462.372"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="#F7F7F7" />
      </linearGradient>

      <filter
        id="drop-shadow"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="2.31" />
        <feGaussianBlur stdDeviation=".924" />
        <feColorMatrix values="0 0 0 0 0.384314 0 0 0 0 0.831373 0 0 0 0 0.862745 0 0 0 0.01 0" />
        <feBlend
          mode="multiply"
          in2="BackgroundImageFix"
          result="effect1_dropShadow"
        />
        <feColorMatrix
          in="SourceAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="5.551" />
        <feGaussianBlur stdDeviation="2.22" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0.505882 0 0 0 0 0.588235 0 0 0 0.12 0" />
        <feBlend
          mode="multiply"
          in2="effect1_dropShadow"
          result="effect2_dropShadow"
        />
        <feColorMatrix
          in="SourceAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="10.452" />
        <feGaussianBlur stdDeviation="4.181" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.035 0" />
        <feBlend
          mode="multiply"
          in2="effect2_dropShadow"
          result="effect3_dropShadow"
        />
        <feColorMatrix
          in="SourceAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="18.644" />
        <feGaussianBlur stdDeviation="7.458" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0.505882 0 0 0 0 0.588235 0 0 0 0.02 0" />
        <feBlend
          mode="multiply"
          in2="effect3_dropShadow"
          result="effect4_dropShadow"
        />
        <feColorMatrix
          in="SourceAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="21" />
        <feGaussianBlur stdDeviation="13.949" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0.505882 0 0 0 0 0.588235 0 0 0 0.08 0" />
        <feBlend
          mode="multiply"
          in2="effect4_dropShadow"
          result="effect5_dropShadow"
        />
        <feColorMatrix
          in="SourceAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="3" />
        <feGaussianBlur stdDeviation="33.388" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0.505882 0 0 0 0 0.588235 0 0 0 0.07 0" />
        <feBlend
          mode="multiply"
          in2="effect5_dropShadow"
          result="effect6_dropShadow"
        />
        <feBlend in="SourceGraphic" in2="effect6_dropShadow" result="shape" />
      </filter>
    </svg>
  )
}
