package protocol

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type SecurityType int32

const (
	SecurityType_UNKNOWN           SecurityType = 0
	SecurityType_LEGACY            SecurityType = 1
	SecurityType_AUTO              SecurityType = 2
	SecurityType_AES128_GCM        SecurityType = 3
	SecurityType_CHACHA20_POLY1305 SecurityType = 4
	SecurityType_NONE              SecurityType = 5
)

var SecurityType_name = map[int32]string{
	0: "UNKNOWN",
	1: "LEGACY",
	2: "AUTO",
	3: "AES128_GCM",
	4: "CHACHA20_POLY1305",
	5: "NONE",
}

var SecurityType_value = map[string]int32{
	"UNKNOWN":           0,
	"LEGACY":            1,
	"AUTO":              2,
	"AES128_GCM":        3,
	"CHACHA20_POLY1305": 4,
	"NONE":              5,
}

func (x SecurityType) String() string {
	return proto.EnumName(SecurityType_name, int32(x))
}

func (SecurityType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5931f958a3c1d408, []int{0}
}

type SecurityConfig struct {
	Type                 SecurityType `protobuf:"varint,1,opt,name=type,proto3,enum=v2ray.core.common.protocol.SecurityType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SecurityConfig) Reset()         { *m = SecurityConfig{} }
func (m *SecurityConfig) String() string { return proto.CompactTextString(m) }
func (*SecurityConfig) ProtoMessage()    {}
func (*SecurityConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_5931f958a3c1d408, []int{0}
}

func (m *SecurityConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityConfig.Unmarshal(m, b)
}
func (m *SecurityConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityConfig.Marshal(b, m, deterministic)
}
func (m *SecurityConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityConfig.Merge(m, src)
}
func (m *SecurityConfig) XXX_Size() int {
	return xxx_messageInfo_SecurityConfig.Size(m)
}
func (m *SecurityConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityConfig proto.InternalMessageInfo

func (m *SecurityConfig) GetType() SecurityType {
	if m != nil {
		return m.Type
	}
	return SecurityType_UNKNOWN
}

func init() {
	proto.RegisterEnum("v2ray.core.common.protocol.SecurityType", SecurityType_name, SecurityType_value)
	proto.RegisterType((*SecurityConfig)(nil), "v2ray.core.common.protocol.SecurityConfig")
}

func init() {
	proto.RegisterFile("v2ray.com/core/common/protocol/headers.proto", fileDescriptor_5931f958a3c1d408)
}

var fileDescriptor_5931f958a3c1d408 = []byte{
	// 252 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0xd2, 0x29, 0x33, 0x2a, 0x4a,
	0xac, 0xd4, 0x4b, 0xce, 0xcf, 0xd5, 0x4f, 0xce, 0x2f, 0x4a, 0xd5, 0x4f, 0xce, 0xcf, 0xcd, 0xcd,
	0xcf, 0xd3, 0x2f, 0x28, 0xca, 0x2f, 0xc9, 0x4f, 0xce, 0xcf, 0xd1, 0xcf, 0x48, 0x4d, 0x4c, 0x49,
	0x2d, 0x2a, 0xd6, 0x03, 0x0b, 0x08, 0x49, 0xc1, 0x54, 0x17, 0xa5, 0xea, 0x41, 0x54, 0xea, 0xc1,
	0x54, 0x2a, 0xf9, 0x71, 0xf1, 0x05, 0xa7, 0x26, 0x97, 0x16, 0x65, 0x96, 0x54, 0x3a, 0xe7, 0xe7,
	0xa5, 0x65, 0xa6, 0x0b, 0xd9, 0x70, 0xb1, 0x94, 0x54, 0x16, 0xa4, 0x4a, 0x30, 0x2a, 0x30, 0x6a,
	0xf0, 0x19, 0x69, 0xe8, 0xe1, 0xd6, 0xac, 0x07, 0xd3, 0x19, 0x52, 0x59, 0x90, 0x1a, 0x04, 0xd6,
	0xa5, 0x95, 0xc4, 0xc5, 0x83, 0x2c, 0x2a, 0xc4, 0xcd, 0xc5, 0x1e, 0xea, 0xe7, 0xed, 0xe7, 0x1f,
	0xee, 0x27, 0xc0, 0x20, 0xc4, 0xc5, 0xc5, 0xe6, 0xe3, 0xea, 0xee, 0xe8, 0x1c, 0x29, 0xc0, 0x28,
	0xc4, 0xc1, 0xc5, 0xe2, 0x18, 0x1a, 0xe2, 0x2f, 0xc0, 0x24, 0xc4, 0xc7, 0xc5, 0xe5, 0xe8, 0x1a,
	0x6c, 0x68, 0x64, 0x11, 0xef, 0xee, 0xec, 0x2b, 0xc0, 0x2c, 0x24, 0xca, 0x25, 0xe8, 0xec, 0xe1,
	0xe8, 0xec, 0xe1, 0x68, 0x64, 0x10, 0x1f, 0xe0, 0xef, 0x13, 0x69, 0x68, 0x6c, 0x60, 0x2a, 0xc0,
	0x02, 0xd2, 0xe0, 0xe7, 0xef, 0xe7, 0x2a, 0xc0, 0xea, 0xe4, 0xc9, 0x25, 0x97, 0x9c, 0x9f, 0x8b,
	0xc7, 0x61, 0x01, 0x8c, 0x51, 0x1c, 0x30, 0xf6, 0x2a, 0x26, 0xa9, 0x30, 0xa3, 0xa0, 0xc4, 0x4a,
	0x3d, 0x67, 0x90, 0x42, 0x67, 0x88, 0xc2, 0x00, 0xa8, 0x64, 0x12, 0x1b, 0x58, 0x99, 0x31, 0x20,
	0x00, 0x00, 0xff, 0xff, 0x0b, 0xc1, 0xe1, 0x94, 0x51, 0x01, 0x00, 0x00,
}
