BEGIN        { FS = " *[;#] *"
               PROCINFO["sorted_in"] = "@ind_str_asc"
             }
/^$/ || /^#/ { next }

{
    split($1, se, /\.\./)
    start = strtonum("0x" se[1])
    end   = se[2] == "" ? start : strtonum("0x" se[2])
    name  = $2

    props[name] = sprintf("{0x%04X, 0x%04X},\n%s", start, end, props[name])
}

END {
    print("// Code generated by gen.zsh; DO NOT EDIT\n\npackage unidata\n")

    print("// Unicode properties\nconst (\n" \
          "\tPropUnknown = Property(iota)")
    for (k in props)
        print("\t" mkconst(k))
    print(")\n")

    print("// Properties is a list of all Unicode properties.\n" \
          "var Properties = map[Property]struct {\n" \
              "\tName   string\n" \
              "\tRanges [][2]rune\n" \
          "}{")
    for (k in props)
        printf("\t%s: {\"%s\", [][2]rune{\n%s}},\n", mkconst(k), gensub("_", " ", "g", k), props[k])
    print("}")
}

function mkconst(s) { return  "Prop" gensub("_", "", "g", s) }
