// Code generated by go generate; DO NOT EDIT.
package postman

import "errors"

type Permission int

const (
    NoAccess Permission = iota
    UserAdd Permission = iota
    UserRemove Permission = iota
    TeamAdminManage Permission = iota
    TeamDevelopersManage Permission = iota
    SsoManage Permission = iota
    CustomDomainAdd Permission = iota
    CustomDomainEdit Permission = iota
    CustomDomainRemove Permission = iota
    AuditLogsView Permission = iota
    UsageDataView Permission = iota
    BillingMembersManage Permission = iota
    PaymentManage Permission = iota
    PlanUpdate Permission = iota
    TeamWorkspacesView Permission = iota
    TeamWorkspacesCreate Permission = iota
    TeamPublicProfileEnable Permission = iota
    TeamPrivateApiNetworkManage Permission = iota
    ParternerWorkspaceView Permission = iota
    ParternerWorkspaceManage Permission = iota
    ParternerWorkspaceVisibilityManage Permission = iota
    PartnersManage Permission = iota
    FlowAdd Permission = iota
    FlowEdit Permission = iota
    FlowRun Permission = iota
    FlowPublish Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        UserAdd: "user:add",
        UserRemove: "user:remove",
        TeamAdminManage: "team_admin:manage",
        TeamDevelopersManage: "team_developers:manage",
        SsoManage: "sso:manage",
        CustomDomainAdd: "custom_domain:add",
        CustomDomainEdit: "custom_domain:edit",
        CustomDomainRemove: "custom_domain:remove",
        AuditLogsView: "audit_logs:view",
        UsageDataView: "usage_data:view",
        BillingMembersManage: "billing_members:manage",
        PaymentManage: "payment:manage",
        PlanUpdate: "plan:update",
        TeamWorkspacesView: "team_workspaces:view",
        TeamWorkspacesCreate: "team_workspaces:create",
        TeamPublicProfileEnable: "team_public_profile:enable",
        TeamPrivateApiNetworkManage: "team_private_api_network:manage",
        ParternerWorkspaceView: "parterner_workspace:view",
        ParternerWorkspaceManage: "parterner_workspace:manage",
        ParternerWorkspaceVisibilityManage: "parterner_workspace_visibility:manage",
        PartnersManage: "partners:manage",
        FlowAdd: "flow:add",
        FlowEdit: "flow:edit",
        FlowRun: "flow:run",
        FlowPublish: "flow:publish",
    }

    StringToPermission = map[string]Permission{
        "user:add": UserAdd,
        "user:remove": UserRemove,
        "team_admin:manage": TeamAdminManage,
        "team_developers:manage": TeamDevelopersManage,
        "sso:manage": SsoManage,
        "custom_domain:add": CustomDomainAdd,
        "custom_domain:edit": CustomDomainEdit,
        "custom_domain:remove": CustomDomainRemove,
        "audit_logs:view": AuditLogsView,
        "usage_data:view": UsageDataView,
        "billing_members:manage": BillingMembersManage,
        "payment:manage": PaymentManage,
        "plan:update": PlanUpdate,
        "team_workspaces:view": TeamWorkspacesView,
        "team_workspaces:create": TeamWorkspacesCreate,
        "team_public_profile:enable": TeamPublicProfileEnable,
        "team_private_api_network:manage": TeamPrivateApiNetworkManage,
        "parterner_workspace:view": ParternerWorkspaceView,
        "parterner_workspace:manage": ParternerWorkspaceManage,
        "parterner_workspace_visibility:manage": ParternerWorkspaceVisibilityManage,
        "partners:manage": PartnersManage,
        "flow:add": FlowAdd,
        "flow:edit": FlowEdit,
        "flow:run": FlowRun,
        "flow:publish": FlowPublish,
    }

    PermissionIDs = map[Permission]int{
        UserAdd: 0,
        UserRemove: 1,
        TeamAdminManage: 2,
        TeamDevelopersManage: 3,
        SsoManage: 4,
        CustomDomainAdd: 5,
        CustomDomainEdit: 6,
        CustomDomainRemove: 7,
        AuditLogsView: 8,
        UsageDataView: 9,
        BillingMembersManage: 10,
        PaymentManage: 11,
        PlanUpdate: 12,
        TeamWorkspacesView: 13,
        TeamWorkspacesCreate: 14,
        TeamPublicProfileEnable: 15,
        TeamPrivateApiNetworkManage: 16,
        ParternerWorkspaceView: 17,
        ParternerWorkspaceManage: 18,
        ParternerWorkspaceVisibilityManage: 19,
        PartnersManage: 20,
        FlowAdd: 21,
        FlowEdit: 22,
        FlowRun: 23,
        FlowPublish: 24,
    }

    IdToPermission = map[int]Permission{
        0: UserAdd,
        1: UserRemove,
        2: TeamAdminManage,
        3: TeamDevelopersManage,
        4: SsoManage,
        5: CustomDomainAdd,
        6: CustomDomainEdit,
        7: CustomDomainRemove,
        8: AuditLogsView,
        9: UsageDataView,
        10: BillingMembersManage,
        11: PaymentManage,
        12: PlanUpdate,
        13: TeamWorkspacesView,
        14: TeamWorkspacesCreate,
        15: TeamPublicProfileEnable,
        16: TeamPrivateApiNetworkManage,
        17: ParternerWorkspaceView,
        18: ParternerWorkspaceManage,
        19: ParternerWorkspaceVisibilityManage,
        20: PartnersManage,
        21: FlowAdd,
        22: FlowEdit,
        23: FlowRun,
        24: FlowPublish,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
