# Python

Trivy supports three types of Python package managers: `pip`, `Pipenv` and `Poetry`.
The following table provides an outline of the features Trivy offers.

| Package Manager | File             | Transitive dependencies | Dev dependencies | Dependency graph | Position | License |
|-----------------|------------------|:-----------------------:|:----------------:|:----------------:|:--------:|:-------:|
| pip             | requirements.txt |            -            |     Include      |        -         |    -     |    -    |
| Pipenv          | Pipfile.lock     |            ✅            |     Include      |        -         |    ✅     |    -    |
| Poetry          | poetry.lock      |            ✅            |     Exclude      |        ✅         |          |    -    |

In addition, Trivy supports two formats of Python packages: `egg` and `wheel`.

| Packaging | License |
|-----------|:-------:|
| Egg       |    ✅    |
| Wheel     |    ✅    |

These may be enabled or disabled depending on the target.
See [here](../detection/language.md) for the detail.

## Package managers
Trivy parses your files generated by package managers in filesystem/repository scanning.

### pip
`requirements.txt` files contain only the direct dependencies and not contain the transitive dependencies.
Therefore, Trivy scans only for the direct dependencies with `requirements.txt`.

Also, `requirements.txt` files don't contain information about dependencies used for development.
Trivy could detect vulnerabilities on the development packages, which not affect your production environment.

License detection is not supported for `pip`.

### Pipenv
Trivy parses `Pipfile.lock`.
`Pipfile.lock` files don't contain information about dependencies used for development.
Trivy could detect vulnerabilities on the development packages, which not affect your production environment.

License detection is not supported for `Pipenv`.

### Poetry
Trivy uses `poetry.lock` to identify dependencies and find vulnerabilities.
To build the correct dependency graph, `pyproject.toml` also needs to be present next to `poetry.lock`.

License detection is not supported for `Poetry`.

## Packaging
Trivy parses the manifest files of installed packages in container image scanning and so on.
See [here](https://packaging.python.org/en/latest/discussions/wheel-vs-egg/) for the detail.

### Egg
Trivy looks for `*.egg-info`, `*.egg-info/PKG-INFO`, `*.egg` and `EGG-INFO/PKG-INFO` to identify Python packages.

### Wheel
Trivy looks for `.dist-info/META-DATA` to identify Python packages.
