# Language-specific Packages

`Trivy` automatically detects the following files in the container and scans vulnerabilities in the application dependencies.

| Language | File                     | Image[^8] | Rootfs[^9] | Filesystem[^10] | Repository[^11] |Dev dependencies |
|----------|--------------------------|:---------:|:----------:|:--------------:|:--------------:|-----------------|
| Ruby     | Gemfile.lock             | -         | -          |       ✅        |       ✅        | included        |
|          | gemspec                  | ✅        | ✅         |       -        |       -        | included        |
| Python   | Pipfile.lock             | -         | -          |       ✅        |       ✅        | excluded        |
|          | poetry.lock              | -         | -          |       ✅        |       ✅        | included        |
|          | requirements.txt         | -         | -          |       ✅        |       ✅        | included        |
|          | egg package[^1]          | ✅        | ✅         |       -        |       -        | excluded        |
|          | wheel package[^2]        | ✅        | ✅         |       -        |       -        | excluded        |
| PHP      | composer.lock            | ✅        | ✅         |       ✅        |       ✅        | excluded        |
| Node.js  | package-lock.json        | -         | -          |       ✅        |       ✅        | excluded        |
|          | yarn.lock                | -         | -          |       ✅        |       ✅        | included        |
|          | package.json             | ✅        | ✅         |       -        |       -        | excluded        |
| .NET     | packages.lock.json       | ✅        | ✅         |       ✅        |       ✅        | included        |
|          | packages.config          | ✅        | ✅         |       ✅        |       ✅        | excluded        |
| Java     | JAR/WAR/PAR/EAR[^3][^4]  | ✅        | ✅         |       -        |       -        | included        |
|          | pom.xml[^5]              | -         | -          |       ✅        |       ✅        | excluded        |
| Go       | Binaries built by Go[^6] | ✅        | ✅         |       -        |       -        | excluded        |
|          | go.mod[^7]               | -         | -          |       ✅        |       ✅        | included        |
| Rust     | Cargo.lock               | ✅        | ✅         |       ✅        |       ✅        | included        |

The path of these files does not matter.

Example: [Dockerfile](https://github.com/aquasecurity/trivy-ci-test/blob/main/Dockerfile)

[^1]: `*.egg-info`, `*.egg-info/PKG-INFO`, `*.egg` and `EGG-INFO/PKG-INFO`
[^2]: `.dist-info/META-DATA`
[^3]: `*.jar`, `*.war`, `*.par` and `*.ear`
[^4]: It requires Internet access
[^5]: It requires Internet access when the POM doesn't exist in your local repository
[^6]: UPX-compressed binaries don't work
[^7]: If smaller than go 1.17, go.sum is also required
[^8]: ✅ means "enabled" and `-` means "disabled" in the image scanning
[^9]: ✅ means "enabled" and `-` means "disabled" in the rootfs scanning
[^10]: ✅ means "enabled" and `-` means "disabled" in the filesystem scanning
[^11]: ✅ means "enabled" and `-` means "disabled" in the git repository scanning
