# Language-specific Packages

`Trivy` automatically detects the following files in the container and scans vulnerabilities in the application dependencies.

| Language | File                     | Image[^6] | Rootfs[^7] | Filesysetm[^8] |  Repository[^9] |Dev dependencies |
|----------|--------------------------|:---------:|:----------:|:--------------:|:---------------:|-----------------|
| Ruby     | Gemfile.lock             | -         | -          | ✅             | ✅              | included        |
|          | gemspec                  | ✅        | ✅         | -              | -               | included        |
| Python   | Pipfile.lock             | -         | -          | ✅             | ✅              | excluded        |
|          | poetry.lock              | -         | -          | ✅             | ✅              | included        |
|          | requirements.txt         | -         | -          | ✅             | ✅              | included        |
|          | egg package[^1]          | ✅        | ✅         | -              | -               | excluded        |
|          | wheel package[^2]        | ✅        | ✅         | -              | -               | excluded        |
| PHP      | composer.lock            | ✅        | ✅         | ✅             | ✅              | excluded        |
| Node.js  | package-lock.json        | -         | -          | ✅             | ✅              | excluded        |
|          | yarn.lock                | -         | -          | ✅             | ✅              | included        |
|          | package.json             | ✅        | ✅         | -              | -               | excluded        |
| .NET     | packages.lock.json       | ✅        | ✅         | ✅             | ✅              | included        |
| Java     | JAR/WAR/EAR[^3][^4]      | ✅        | ✅         | ✅             | ✅              | included        |
| Go       | Binaries built by Go[^5] | ✅        | ✅         | -              | -               | excluded        |
|          | go.sum                   | -         | -          | ✅             | ✅              | included        |

The path of these files does not matter.

Example: [Dockerfile](https://github.com/aquasecurity/trivy-ci-test/blob/main/Dockerfile)

[^1]: `*.egg-info`, `*.egg-info/PKG-INFO`, `*.egg` and `EGG-INFO/PKG-INFO`
[^2]: `.dist-info/META-DATA`
[^3]: `*.jar`, `*.war`, and `*.ear`
[^4]: It requires the Internet access
[^5]: UPX-compressed binaries don't work
[^6]: ✅ means "enabled" and `-` means "disabled" in the image scanning
[^7]: ✅ means "enabled" and `-` means "disabled" in the rootfs scanning
[^8]: ✅ means "enabled" and `-` means "disabled" in the filesystem scanning
[^9]: ✅ means "enabled" and `-` means "disabled" in the git repository scanning
