// Code generated by Wire. DO NOT EDIT.

//go:generate wire
//+build !wireinject

package server

import (
	"github.com/aquasecurity/fanal/applier"
	"github.com/aquasecurity/fanal/cache"
	"github.com/aquasecurity/trivy-db/pkg/db"
	db2 "github.com/aquasecurity/trivy/pkg/db"
	"github.com/aquasecurity/trivy/pkg/detector/ospkg"
	"github.com/aquasecurity/trivy/pkg/github"
	"github.com/aquasecurity/trivy/pkg/indicator"
	"github.com/aquasecurity/trivy/pkg/result"
	"github.com/aquasecurity/trivy/pkg/scanner/local"
	"github.com/spf13/afero"
	"k8s.io/utils/clock"
)

// Injectors from inject.go:

func initializeScanServer(localArtifactCache cache.LocalArtifactCache) *ScanServer {
	applierApplier := applier.NewApplier(localArtifactCache)
	detector := ospkg.Detector{}
	scanner := local.NewScanner(applierApplier, detector)
	config := db.Config{}
	client := result.NewClient(config)
	scanServer := NewScanServer(scanner, client)
	return scanServer
}

func initializeDBWorker(cacheDir string, quiet bool) dbWorker {
	config := db.Config{}
	client := github.NewClient()
	progressBar := indicator.NewProgressBar(quiet)
	realClock := clock.RealClock{}
	fs := afero.NewOsFs()
	metadata := db2.NewMetadata(fs, cacheDir)
	dbClient := db2.NewClient(config, client, progressBar, realClock, metadata)
	serverDbWorker := newDBWorker(dbClient)
	return serverDbWorker
}
