# Tink

Using crypto in your application shouldn't have to feel like juggling chainsaws
in the dark. Tink is a crypto library written by a group of cryptographers and
security engineers at Google. It was born out of our extensive experience
working with Google's product teams, fixing weaknesses in implementations, and
providing simple APIs that can be used safely without needing a crypto
background.

Tink provides secure APIs that are easy to use correctly and hard(er) to misuse.
It reduces common crypto pitfalls with user-centered design, careful
implementation and code reviews, and extensive testing. At Google, Tink is
already being used to secure data of many products such as AdMob, Google Pay,
Google Assistant, Firebase, the Android Search App, etc.

## Documentation

For an overview of using Tink in Python, see the
[Python HOW-TO](../docs/PYTHON-HOWTO.md).

In addition, there are illustrative [examples of using Tink
Python](https://github.com/google/tink/tree/master/examples/python/) which can
used as a jumping off point.
