// Copyright 2020 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: third_party/tink/proto/kms_envelope.proto

package kms_envelope_go_proto

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	tink_go_proto "github.com/google/tink/go/proto/tink_go_proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type KmsEnvelopeAeadKeyFormat struct {
	// Required.
	// The location of the KEK in a remote KMS.
	// With Google Cloud KMS, valid values have this format:
	// gcp-kms://projects/*/locations/*/keyRings/*/cryptoKeys/*.
	// With AWS KMS, valid values have this format:
	// aws-kms://arn:aws:kms:<region>:<account-id>:key/<key-id>
	KekUri string `protobuf:"bytes,1,opt,name=kek_uri,json=kekUri,proto3" json:"kek_uri,omitempty"`
	// Key template of the Data Encryption Key, e.g., AesCtrHmacAeadKeyFormat.
	// Required.
	DekTemplate          *tink_go_proto.KeyTemplate `protobuf:"bytes,2,opt,name=dek_template,json=dekTemplate,proto3" json:"dek_template,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *KmsEnvelopeAeadKeyFormat) Reset()         { *m = KmsEnvelopeAeadKeyFormat{} }
func (m *KmsEnvelopeAeadKeyFormat) String() string { return proto.CompactTextString(m) }
func (*KmsEnvelopeAeadKeyFormat) ProtoMessage()    {}
func (*KmsEnvelopeAeadKeyFormat) Descriptor() ([]byte, []int) {
	return fileDescriptor_c02dbbaaedce3251, []int{0}
}

func (m *KmsEnvelopeAeadKeyFormat) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KmsEnvelopeAeadKeyFormat.Unmarshal(m, b)
}
func (m *KmsEnvelopeAeadKeyFormat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KmsEnvelopeAeadKeyFormat.Marshal(b, m, deterministic)
}
func (m *KmsEnvelopeAeadKeyFormat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KmsEnvelopeAeadKeyFormat.Merge(m, src)
}
func (m *KmsEnvelopeAeadKeyFormat) XXX_Size() int {
	return xxx_messageInfo_KmsEnvelopeAeadKeyFormat.Size(m)
}
func (m *KmsEnvelopeAeadKeyFormat) XXX_DiscardUnknown() {
	xxx_messageInfo_KmsEnvelopeAeadKeyFormat.DiscardUnknown(m)
}

var xxx_messageInfo_KmsEnvelopeAeadKeyFormat proto.InternalMessageInfo

func (m *KmsEnvelopeAeadKeyFormat) GetKekUri() string {
	if m != nil {
		return m.KekUri
	}
	return ""
}

func (m *KmsEnvelopeAeadKeyFormat) GetDekTemplate() *tink_go_proto.KeyTemplate {
	if m != nil {
		return m.DekTemplate
	}
	return nil
}

// There is no actual key material in the key.
type KmsEnvelopeAeadKey struct {
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// The key format also contains the params.
	Params               *KmsEnvelopeAeadKeyFormat `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *KmsEnvelopeAeadKey) Reset()         { *m = KmsEnvelopeAeadKey{} }
func (m *KmsEnvelopeAeadKey) String() string { return proto.CompactTextString(m) }
func (*KmsEnvelopeAeadKey) ProtoMessage()    {}
func (*KmsEnvelopeAeadKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_c02dbbaaedce3251, []int{1}
}

func (m *KmsEnvelopeAeadKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KmsEnvelopeAeadKey.Unmarshal(m, b)
}
func (m *KmsEnvelopeAeadKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KmsEnvelopeAeadKey.Marshal(b, m, deterministic)
}
func (m *KmsEnvelopeAeadKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KmsEnvelopeAeadKey.Merge(m, src)
}
func (m *KmsEnvelopeAeadKey) XXX_Size() int {
	return xxx_messageInfo_KmsEnvelopeAeadKey.Size(m)
}
func (m *KmsEnvelopeAeadKey) XXX_DiscardUnknown() {
	xxx_messageInfo_KmsEnvelopeAeadKey.DiscardUnknown(m)
}

var xxx_messageInfo_KmsEnvelopeAeadKey proto.InternalMessageInfo

func (m *KmsEnvelopeAeadKey) GetVersion() uint32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *KmsEnvelopeAeadKey) GetParams() *KmsEnvelopeAeadKeyFormat {
	if m != nil {
		return m.Params
	}
	return nil
}

func init() {
	proto.RegisterType((*KmsEnvelopeAeadKeyFormat)(nil), "google.crypto.tink.KmsEnvelopeAeadKeyFormat")
	proto.RegisterType((*KmsEnvelopeAeadKey)(nil), "google.crypto.tink.KmsEnvelopeAeadKey")
}

func init() {
	proto.RegisterFile("proto/kms_envelope.proto", fileDescriptor_c02dbbaaedce3251)
}

var fileDescriptor_c02dbbaaedce3251 = []byte{
	// 265 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x90, 0x41, 0x4b, 0xc3, 0x30,
	0x14, 0xc7, 0xe9, 0x0e, 0x1d, 0x66, 0x7a, 0xc9, 0xc5, 0x22, 0x82, 0x73, 0xa7, 0x09, 0x92, 0xc2,
	0xfc, 0x04, 0x16, 0x15, 0xa4, 0x20, 0xa3, 0xcc, 0x8b, 0x20, 0x21, 0x6b, 0x1f, 0x5d, 0x48, 0xd3,
	0x17, 0xd2, 0xb7, 0x49, 0xbf, 0x8e, 0x9f, 0x74, 0xac, 0xeb, 0x4e, 0x5b, 0x6f, 0xf9, 0x3f, 0xfe,
	0xbf, 0xfc, 0x92, 0xc7, 0x9e, 0x68, 0xa3, 0x7d, 0x21, 0x9d, 0xf2, 0xd4, 0xc6, 0xa4, 0x6b, 0x13,
	0x3b, 0x8f, 0x84, 0xb1, 0xb1, 0x8d, 0x84, 0x7a, 0x07, 0x15, 0x3a, 0x10, 0xdd, 0x88, 0xf3, 0x12,
	0xb1, 0xac, 0x40, 0xe4, 0xbe, 0x75, 0x84, 0xe2, 0x50, 0xbe, 0x7b, 0x1c, 0xc0, 0x0f, 0xc7, 0x23,
	0x36, 0xfb, 0x63, 0x51, 0x6a, 0x9b, 0xf7, 0xfe, 0xae, 0x57, 0x50, 0x45, 0x0a, 0xed, 0x07, 0x7a,
	0xab, 0x88, 0xdf, 0xb2, 0xb1, 0x01, 0x23, 0xb7, 0x5e, 0x47, 0xc1, 0x34, 0x98, 0x5f, 0x65, 0xa1,
	0x01, 0xf3, 0xed, 0x35, 0x4f, 0xd8, 0x75, 0x01, 0x46, 0x12, 0x58, 0x57, 0x29, 0x82, 0x68, 0x34,
	0x0d, 0xe6, 0x93, 0xc5, 0x83, 0x38, 0x7f, 0x82, 0x48, 0xa1, 0x5d, 0xf5, 0xb5, 0x6c, 0x52, 0x80,
	0x39, 0x85, 0x19, 0x31, 0x7e, 0x2e, 0xe6, 0x11, 0x1b, 0xef, 0xc0, 0x37, 0x1a, 0xeb, 0x4e, 0x79,
	0x93, 0x9d, 0x22, 0x7f, 0x63, 0xa1, 0x53, 0x5e, 0xd9, 0xa6, 0xb7, 0x3d, 0x5f, 0xb4, 0x0d, 0x7c,
	0x25, 0xeb, 0xd9, 0xe4, 0x97, 0xdd, 0xe7, 0x68, 0x2f, 0xa1, 0xdd, 0x3a, 0x96, 0xc1, 0xcf, 0xa2,
	0xd4, 0xb4, 0xd9, 0xae, 0x45, 0x8e, 0x36, 0x3e, 0xd6, 0x86, 0x16, 0x2f, 0x4b, 0x94, 0xdd, 0xf4,
	0x7f, 0x14, 0xae, 0x3e, 0xbf, 0xd2, 0x65, 0xb2, 0x0e, 0xbb, 0xfc, 0xb2, 0x0f, 0x00, 0x00, 0xff,
	0xff, 0x46, 0x8b, 0x55, 0xf5, 0xb8, 0x01, 0x00, 0x00,
}
