// Code generated by cue get go. DO NOT EDIT.

//cue:generate cue get go github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1

package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/util/intstr"
)

#Version: "v1"

// ByteSize is a valid memory size type based on powers-of-2, so 1KB is 1024B.
// Supported units: B, KB, KiB, MB, MiB, GB, GiB, TB, TiB, PB, PiB, EB, EiB Ex: `512MB`.
// +kubebuilder:validation:Pattern:="(^0|([0-9]*[.])?[0-9]+((K|M|G|T|E|P)i?)?B)$"
#ByteSize: string

// Duration is a valid time duration that can be parsed by Prometheus model.ParseDuration() function.
// Supported units: y, w, d, h, m, s, ms
// Examples: `30s`, `1m`, `1h20m15s`, `15d`
// +kubebuilder:validation:Pattern:="^(0|(([0-9]+)y)?(([0-9]+)w)?(([0-9]+)d)?(([0-9]+)h)?(([0-9]+)m)?(([0-9]+)s)?(([0-9]+)ms)?)$"
#Duration: string

// GoDuration is a valid time duration that can be parsed by Go's time.ParseDuration() function.
// Supported units: h, m, s, ms
// Examples: `45ms`, `30s`, `1m`, `1h20m15s`
// +kubebuilder:validation:Pattern:="^(0|(([0-9]+)h)?(([0-9]+)m)?(([0-9]+)s)?(([0-9]+)ms)?)$"
#GoDuration: string

// HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the
// pod's hosts file.
#HostAlias: {
	// IP address of the host file entry.
	// +kubebuilder:validation:Required
	ip: string @go(IP)

	// Hostnames for the above IP address.
	// +kubebuilder:validation:Required
	hostnames: [...string] @go(Hostnames,[]string)
}

// PrometheusRuleExcludeConfig enables users to configure excluded PrometheusRule names and their namespaces
// to be ignored while enforcing namespace label for alerts and metrics.
#PrometheusRuleExcludeConfig: {
	// RuleNamespace - namespace of excluded rule
	ruleNamespace: string @go(RuleNamespace)

	// RuleNamespace - name of excluded rule
	ruleName: string @go(RuleName)
}

// ObjectReference references a PodMonitor, ServiceMonitor, Probe or PrometheusRule object.
#ObjectReference: {
	// Group of the referent. When not specified, it defaults to `monitoring.coreos.com`
	// +optional
	// +kubebuilder:default:="monitoring.coreos.com"
	// +kubebuilder:validation:Enum=monitoring.coreos.com
	group: string @go(Group)

	// Resource of the referent.
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:Enum=prometheusrules;servicemonitors;podmonitors;probes
	resource: string @go(Resource)

	// Namespace of the referent.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:MinLength=1
	namespace: string @go(Namespace)

	// Name of the referent. When not set, all resources are matched.
	// +optional
	name?: string @go(Name)
}

// ArbitraryFSAccessThroughSMsConfig enables users to configure, whether
// a service monitor selected by the Prometheus instance is allowed to use
// arbitrary files on the file system of the Prometheus container. This is the case
// when e.g. a service monitor specifies a BearerTokenFile in an endpoint. A
// malicious user could create a service monitor selecting arbitrary secret files
// in the Prometheus container. Those secrets would then be sent with a scrape
// request by Prometheus to a malicious target. Denying the above would prevent the
// attack, users can instead use the BearerTokenSecret field.
#ArbitraryFSAccessThroughSMsConfig: {
	deny?: bool @go(Deny)
}

// Condition represents the state of the resources associated with the Prometheus or Alertmanager resource.
// +k8s:deepcopy-gen=true
#Condition: {
	// Type of the condition being reported.
	// +required
	type: #ConditionType @go(Type)

	// Status of the condition.
	// +required
	status: #ConditionStatus @go(Status)

	// lastTransitionTime is the time of the last update to the current status property.
	// +required
	lastTransitionTime: metav1.#Time @go(LastTransitionTime)

	// Reason for the condition's last transition.
	// +optional
	reason?: string @go(Reason)

	// Human-readable message indicating details for the condition's last transition.
	// +optional
	message?: string @go(Message)

	// ObservedGeneration represents the .metadata.generation that the
	// condition was set based upon. For instance, if `.metadata.generation` is
	// currently 12, but the `.status.conditions[].observedGeneration` is 9, the
	// condition is out of date with respect to the current state of the
	// instance.
	observedGeneration?: int64 @go(ObservedGeneration)
}

#ConditionType: string // #enumConditionType

#enumConditionType:
	#Available |
	#Reconciled

// Available indicates whether enough pods are ready to provide the
// service.
// The possible status values for this condition type are:
// - True: all pods are running and ready, the service is fully available.
// - Degraded: some pods aren't ready, the service is partially available.
// - False: no pods are running, the service is totally unavailable.
// - Unknown: the operator couldn't determine the condition status.
#Available: #ConditionType & "Available"

// Reconciled indicates whether the operator has reconciled the state of
// the underlying resources with the object's spec.
// The possible status values for this condition type are:
// - True: the reconciliation was successful.
// - False: the reconciliation failed.
// - Unknown: the operator couldn't determine the condition status.
#Reconciled: #ConditionType & "Reconciled"

#ConditionStatus: string // #enumConditionStatus

#enumConditionStatus:
	#ConditionTrue |
	#ConditionDegraded |
	#ConditionFalse |
	#ConditionUnknown

#ConditionTrue:     #ConditionStatus & "True"
#ConditionDegraded: #ConditionStatus & "Degraded"
#ConditionFalse:    #ConditionStatus & "False"
#ConditionUnknown:  #ConditionStatus & "Unknown"

// EmbeddedPersistentVolumeClaim is an embedded version of k8s.io/api/core/v1.PersistentVolumeClaim.
// It contains TypeMeta and a reduced ObjectMeta.
#EmbeddedPersistentVolumeClaim: {
	metav1.#TypeMeta

	// EmbeddedMetadata contains metadata relevant to an EmbeddedResource.
	metadata?: #EmbeddedObjectMetadata @go(EmbeddedObjectMetadata) @protobuf(1,bytes,opt)

	// Spec defines the desired characteristics of a volume requested by a pod author.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
	// +optional
	spec?: v1.#PersistentVolumeClaimSpec @go(Spec) @protobuf(2,bytes,opt)

	// Status represents the current information/status of a persistent volume claim.
	// Read-only.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
	// +optional
	status?: v1.#PersistentVolumeClaimStatus @go(Status) @protobuf(3,bytes,opt)
}

// EmbeddedObjectMetadata contains a subset of the fields included in k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta
// Only fields which are relevant to embedded resources are included.
#EmbeddedObjectMetadata: {
	// Name must be unique within a namespace. Is required when creating resources, although
	// some resources may allow a client to request the generation of an appropriate name
	// automatically. Name is primarily intended for creation idempotence and configuration
	// definition.
	// Cannot be updated.
	// More info: http://kubernetes.io/docs/user-guide/identifiers#names
	// +optional
	name?: string @go(Name) @protobuf(1,bytes,opt)

	// Map of string keys and values that can be used to organize and categorize
	// (scope and select) objects. May match selectors of replication controllers
	// and services.
	// More info: http://kubernetes.io/docs/user-guide/labels
	// +optional
	labels?: {[string]: string} @go(Labels,map[string]string) @protobuf(11,bytes,rep)

	// Annotations is an unstructured key value map stored with a resource that may be
	// set by external tools to store and retrieve arbitrary metadata. They are not
	// queryable and should be preserved when modifying objects.
	// More info: http://kubernetes.io/docs/user-guide/annotations
	// +optional
	annotations?: {[string]: string} @go(Annotations,map[string]string) @protobuf(12,bytes,rep)
}

// WebConfigFileFields defines the file content for --web.config.file flag.
// +k8s:deepcopy-gen=true
#WebConfigFileFields: {
	// Defines the TLS parameters for HTTPS.
	tlsConfig?: null | #WebTLSConfig @go(TLSConfig,*WebTLSConfig)

	// Defines HTTP parameters for web server.
	httpConfig?: null | #WebHTTPConfig @go(HTTPConfig,*WebHTTPConfig)
}

// WebHTTPConfig defines HTTP parameters for web server.
// +k8s:openapi-gen=true
#WebHTTPConfig: {
	// Enable HTTP/2 support. Note that HTTP/2 is only supported with TLS.
	// When TLSConfig is not configured, HTTP/2 will be disabled.
	// Whenever the value of the field changes, a rolling update will be triggered.
	http2?: null | bool @go(HTTP2,*bool)

	// List of headers that can be added to HTTP responses.
	headers?: null | #WebHTTPHeaders @go(Headers,*WebHTTPHeaders)
}

// WebHTTPHeaders defines the list of headers that can be added to HTTP responses.
// +k8s:openapi-gen=true
#WebHTTPHeaders: {
	// Set the Content-Security-Policy header to HTTP responses.
	// Unset if blank.
	contentSecurityPolicy?: string @go(ContentSecurityPolicy)

	// Set the X-Frame-Options header to HTTP responses.
	// Unset if blank. Accepted values are deny and sameorigin.
	// https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options
	//+kubebuilder:validation:Enum="";Deny;SameOrigin
	xFrameOptions?: string @go(XFrameOptions)

	// Set the X-Content-Type-Options header to HTTP responses.
	// Unset if blank. Accepted value is nosniff.
	// https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options
	//+kubebuilder:validation:Enum="";NoSniff
	xContentTypeOptions?: string @go(XContentTypeOptions)

	// Set the X-XSS-Protection header to all responses.
	// Unset if blank.
	// https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection
	xXSSProtection?: string @go(XXSSProtection)

	// Set the Strict-Transport-Security header to HTTP responses.
	// Unset if blank.
	// Please make sure that you use this with care as this header might force
	// browsers to load Prometheus and the other applications hosted on the same
	// domain and subdomains over HTTPS.
	// https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security
	strictTransportSecurity?: string @go(StrictTransportSecurity)
}

// WebTLSConfig defines the TLS parameters for HTTPS.
// +k8s:openapi-gen=true
#WebTLSConfig: {
	// Secret containing the TLS key for the server.
	keySecret: v1.#SecretKeySelector @go(KeySecret)

	// Contains the TLS certificate for the server.
	cert: #SecretOrConfigMap @go(Cert)

	// Server policy for client authentication. Maps to ClientAuth Policies.
	// For more detail on clientAuth options:
	// https://golang.org/pkg/crypto/tls/#ClientAuthType
	clientAuthType?: string @go(ClientAuthType)

	// Contains the CA certificate for client certificate authentication to the server.
	client_ca?: #SecretOrConfigMap @go(ClientCA)

	// Minimum TLS version that is acceptable. Defaults to TLS12.
	minVersion?: string @go(MinVersion)

	// Maximum TLS version that is acceptable. Defaults to TLS13.
	maxVersion?: string @go(MaxVersion)

	// List of supported cipher suites for TLS versions up to TLS 1.2. If empty,
	// Go default cipher suites are used. Available cipher suites are documented
	// in the go documentation: https://golang.org/pkg/crypto/tls/#pkg-constants
	cipherSuites?: [...string] @go(CipherSuites,[]string)

	// Controls whether the server selects the
	// client's most preferred cipher suite, or the server's most preferred
	// cipher suite. If true then the server's preference, as expressed in
	// the order of elements in cipherSuites, is used.
	preferServerCipherSuites?: null | bool @go(PreferServerCipherSuites,*bool)

	// Elliptic curves that will be used in an ECDHE handshake, in preference
	// order. Available curves are documented in the go documentation:
	// https://golang.org/pkg/crypto/tls/#CurveID
	curvePreferences?: [...string] @go(CurvePreferences,[]string)
}

// LabelName is a valid Prometheus label name which may only contain ASCII letters, numbers, as well as underscores.
// +kubebuilder:validation:Pattern:="^[a-zA-Z_][a-zA-Z0-9_]*$"
#LabelName: string

// Endpoint defines a scrapeable endpoint serving Prometheus metrics.
// +k8s:openapi-gen=true
#Endpoint: {
	// Name of the service port this endpoint refers to. Mutually exclusive with targetPort.
	port?: string @go(Port)

	// Name or number of the target port of the Pod behind the Service, the port must be specified with container port property. Mutually exclusive with port.
	targetPort?: null | intstr.#IntOrString @go(TargetPort,*intstr.IntOrString)

	// HTTP path to scrape for metrics.
	// If empty, Prometheus uses the default value (e.g. `/metrics`).
	path?: string @go(Path)

	// HTTP scheme to use for scraping.
	scheme?: string @go(Scheme)

	// Optional HTTP URL parameters
	params?: {[string]: [...string]} @go(Params,map[string][]string)

	// Interval at which metrics should be scraped
	// If not specified Prometheus' global scrape interval is used.
	interval?: #Duration @go(Interval)

	// Timeout after which the scrape is ended
	// If not specified, the Prometheus global scrape timeout is used unless it is less than `Interval` in which the latter is used.
	scrapeTimeout?: #Duration @go(ScrapeTimeout)

	// TLS configuration to use when scraping the endpoint
	tlsConfig?: null | #TLSConfig @go(TLSConfig,*TLSConfig)

	// File to read bearer token for scraping targets.
	bearerTokenFile?: string @go(BearerTokenFile)

	// Secret to mount to read bearer token for scraping targets. The secret
	// needs to be in the same namespace as the service monitor and accessible by
	// the Prometheus Operator.
	bearerTokenSecret?: v1.#SecretKeySelector @go(BearerTokenSecret)

	// Authorization section for this endpoint
	authorization?: null | #SafeAuthorization @go(Authorization,*SafeAuthorization)

	// HonorLabels chooses the metric's labels on collisions with target labels.
	honorLabels?: bool @go(HonorLabels)

	// HonorTimestamps controls whether Prometheus respects the timestamps present in scraped data.
	honorTimestamps?: null | bool @go(HonorTimestamps,*bool)

	// BasicAuth allow an endpoint to authenticate over basic authentication
	// More info: https://prometheus.io/docs/operating/configuration/#endpoints
	basicAuth?: null | #BasicAuth @go(BasicAuth,*BasicAuth)

	// OAuth2 for the URL. Only valid in Prometheus versions 2.27.0 and newer.
	oauth2?: null | #OAuth2 @go(OAuth2,*OAuth2)

	// MetricRelabelConfigs to apply to samples before ingestion.
	metricRelabelings?: [...null | #RelabelConfig] @go(MetricRelabelConfigs,[]*RelabelConfig)

	// RelabelConfigs to apply to samples before scraping.
	// Prometheus Operator automatically adds relabelings for a few standard Kubernetes fields.
	// The original scrape job's name is available via the `__tmp_prometheus_job_name` label.
	// More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#relabel_config
	relabelings?: [...null | #RelabelConfig] @go(RelabelConfigs,[]*RelabelConfig)

	// ProxyURL eg http://proxyserver:2195 Directs scrapes to proxy through this endpoint.
	proxyUrl?: null | string @go(ProxyURL,*string)

	// FollowRedirects configures whether scrape requests follow HTTP 3xx redirects.
	followRedirects?: null | bool @go(FollowRedirects,*bool)

	// Whether to enable HTTP2.
	enableHttp2?: null | bool @go(EnableHttp2,*bool)

	// Drop pods that are not running. (Failed, Succeeded). Enabled by default.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#pod-phase
	filterRunning?: null | bool @go(FilterRunning,*bool)
}

#AttachMetadata: {
	// When set to true, Prometheus must have permissions to get Nodes.
	node?: bool @go(Node)
}

// OAuth2 allows an endpoint to authenticate with OAuth2.
// More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#oauth2
// +k8s:openapi-gen=true
#OAuth2: {
	// The secret or configmap containing the OAuth2 client id
	clientId: #SecretOrConfigMap @go(ClientID)

	// The secret containing the OAuth2 client secret
	clientSecret: v1.#SecretKeySelector @go(ClientSecret)

	// The URL to fetch the token from
	// +kubebuilder:validation:MinLength=1
	tokenUrl: string @go(TokenURL)

	// OAuth2 scopes used for the token request
	scopes?: [...string] @go(Scopes,[]string)

	// Parameters to append to the token URL
	endpointParams?: {[string]: string} @go(EndpointParams,map[string]string)
}

// BasicAuth allow an endpoint to authenticate over basic authentication
// More info: https://prometheus.io/docs/operating/configuration/#endpoints
// +k8s:openapi-gen=true
#BasicAuth: {
	// The secret in the service monitor namespace that contains the username
	// for authentication.
	username?: v1.#SecretKeySelector @go(Username)

	// The secret in the service monitor namespace that contains the password
	// for authentication.
	password?: v1.#SecretKeySelector @go(Password)
}

// SecretOrConfigMap allows to specify data as a Secret or ConfigMap. Fields are mutually exclusive.
#SecretOrConfigMap: {
	// Secret containing data to use for the targets.
	secret?: null | v1.#SecretKeySelector @go(Secret,*v1.SecretKeySelector)

	// ConfigMap containing data to use for the targets.
	configMap?: null | v1.#ConfigMapKeySelector @go(ConfigMap,*v1.ConfigMapKeySelector)
}

// SafeTLSConfig specifies safe TLS configuration parameters.
// +k8s:openapi-gen=true
#SafeTLSConfig: {
	// Certificate authority used when verifying server certificates.
	ca?: #SecretOrConfigMap @go(CA)

	// Client certificate to present when doing client-authentication.
	cert?: #SecretOrConfigMap @go(Cert)

	// Secret containing the client key file for the targets.
	keySecret?: null | v1.#SecretKeySelector @go(KeySecret,*v1.SecretKeySelector)

	// Used to verify the hostname for the targets.
	serverName?: string @go(ServerName)

	// Disable target certificate validation.
	insecureSkipVerify?: bool @go(InsecureSkipVerify)
}

// TLSConfig extends the safe TLS configuration with file parameters.
// +k8s:openapi-gen=true
#TLSConfig: {
	#SafeTLSConfig

	// Path to the CA cert in the Prometheus container to use for the targets.
	caFile?: string @go(CAFile)

	// Path to the client cert file in the Prometheus container for the targets.
	certFile?: string @go(CertFile)

	// Path to the client key file in the Prometheus container for the targets.
	keyFile?: string @go(KeyFile)
}

// NamespaceSelector is a selector for selecting either all namespaces or a
// list of namespaces.
// If `any` is true, it takes precedence over `matchNames`.
// If `matchNames` is empty and `any` is false, it means that the objects are
// selected from the current namespace.
// +k8s:openapi-gen=true
#NamespaceSelector: {
	// Boolean describing whether all namespaces are selected in contrast to a
	// list restricting them.
	any?: bool @go(Any)

	// List of namespace names to select from.
	matchNames?: [...string] @go(MatchNames,[]string)
}

// Argument as part of the AdditionalArgs list.
// +k8s:openapi-gen=true
#Argument: {
	// Name of the argument, e.g. "scrape.discovery-reload-interval".
	// +kubebuilder:validation:MinLength=1
	name: string @go(Name)

	// Argument value, e.g. 30s. Can be empty for name-only arguments (e.g. --storage.tsdb.no-lockfile)
	value?: string @go(Value)
}
