// Code generated by cue get go. DO NOT EDIT.

//cue:generate cue get go github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1

package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/util/intstr"
)

#PrometheusRuleKind:    "PrometheusRule"
#PrometheusRuleName:    "prometheusrules"
#PrometheusRuleKindKey: "prometheusrule"

// PrometheusRule defines recording and alerting rules for a Prometheus instance
#PrometheusRule: {
	metav1.#TypeMeta
	metadata?: metav1.#ObjectMeta @go(ObjectMeta)

	// Specification of desired alerting rule definitions for Prometheus.
	spec: #PrometheusRuleSpec @go(Spec)
}

// PrometheusRuleSpec contains specification parameters for a Rule.
// +k8s:openapi-gen=true
#PrometheusRuleSpec: {
	// Content of Prometheus rule file
	// +listType=map
	// +listMapKey=name
	groups?: [...#RuleGroup] @go(Groups,[]RuleGroup)
}

// RuleGroup is a list of sequentially evaluated recording and alerting rules.
// +k8s:openapi-gen=true
#RuleGroup: {
	// Name of the rule group.
	// +kubebuilder:validation:MinLength=1
	name: string @go(Name)

	// Interval determines how often rules in the group are evaluated.
	interval?: #Duration @go(Interval)

	// List of alerting and recording rules.
	rules: [...#Rule] @go(Rules,[]Rule)

	// PartialResponseStrategy is only used by ThanosRuler and will
	// be ignored by Prometheus instances.
	// More info: https://github.com/thanos-io/thanos/blob/main/docs/components/rule.md#partial-response
	// +kubebuilder:validation:Pattern="^(?i)(abort|warn)?$"
	partial_response_strategy?: string @go(PartialResponseStrategy)
}

// Rule describes an alerting or recording rule
// See Prometheus documentation: [alerting](https://www.prometheus.io/docs/prometheus/latest/configuration/alerting_rules/) or [recording](https://www.prometheus.io/docs/prometheus/latest/configuration/recording_rules/#recording-rules) rule
// +k8s:openapi-gen=true
#Rule: {
	// Name of the time series to output to. Must be a valid metric name.
	// Only one of `record` and `alert` must be set.
	record?: string @go(Record)

	// Name of the alert. Must be a valid label value.
	// Only one of `record` and `alert` must be set.
	alert?: string @go(Alert)

	// PromQL expression to evaluate.
	expr: intstr.#IntOrString @go(Expr)

	// Alerts are considered firing once they have been returned for this long.
	for?: #Duration @go(For)

	// Labels to add or overwrite.
	labels?: {[string]: string} @go(Labels,map[string]string)

	// Annotations to add to each alert.
	// Only valid for alerting rules.
	annotations?: {[string]: string} @go(Annotations,map[string]string)
}

// PrometheusRuleList is a list of PrometheusRules.
// +k8s:openapi-gen=true
#PrometheusRuleList: {
	metav1.#TypeMeta

	// Standard list metadata
	// More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
	metadata?: metav1.#ListMeta @go(ListMeta)

	// List of Rules
	items: [...null | #PrometheusRule] @go(Items,[]*PrometheusRule)
}
