//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright 2020 The Tilt Dev Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by openapi-gen. DO NOT EDIT.

// This file was autogenerated by openapi-gen. Do not edit it manually!

package openapi

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	common "k8s.io/kube-openapi/pkg/common"
	spec "k8s.io/kube-openapi/pkg/validation/spec"
)

func GetOpenAPIDefinitions(ref common.ReferenceCallback) map[string]common.OpenAPIDefinition {
	return map[string]common.OpenAPIDefinition{
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Cluster":                           schema_pkg_apis_core_v1alpha1_Cluster(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ClusterConnection":                 schema_pkg_apis_core_v1alpha1_ClusterConnection(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ClusterConnectionStatus":           schema_pkg_apis_core_v1alpha1_ClusterConnectionStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ClusterList":                       schema_pkg_apis_core_v1alpha1_ClusterList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ClusterSpec":                       schema_pkg_apis_core_v1alpha1_ClusterSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ClusterStatus":                     schema_pkg_apis_core_v1alpha1_ClusterStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Cmd":                               schema_pkg_apis_core_v1alpha1_Cmd(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImage":                          schema_pkg_apis_core_v1alpha1_CmdImage(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageList":                      schema_pkg_apis_core_v1alpha1_CmdImageList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageSpec":                      schema_pkg_apis_core_v1alpha1_CmdImageSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageStateBuilding":             schema_pkg_apis_core_v1alpha1_CmdImageStateBuilding(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageStateCompleted":            schema_pkg_apis_core_v1alpha1_CmdImageStateCompleted(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageStateWaiting":              schema_pkg_apis_core_v1alpha1_CmdImageStateWaiting(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageStatus":                    schema_pkg_apis_core_v1alpha1_CmdImageStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdList":                           schema_pkg_apis_core_v1alpha1_CmdList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdSpec":                           schema_pkg_apis_core_v1alpha1_CmdSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdStateRunning":                   schema_pkg_apis_core_v1alpha1_CmdStateRunning(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdStateTerminated":                schema_pkg_apis_core_v1alpha1_CmdStateTerminated(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdStateWaiting":                   schema_pkg_apis_core_v1alpha1_CmdStateWaiting(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdStatus":                         schema_pkg_apis_core_v1alpha1_CmdStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ConfigMap":                         schema_pkg_apis_core_v1alpha1_ConfigMap(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ConfigMapDisableSource":            schema_pkg_apis_core_v1alpha1_ConfigMapDisableSource(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ConfigMapList":                     schema_pkg_apis_core_v1alpha1_ConfigMapList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ConfigMapStateSource":              schema_pkg_apis_core_v1alpha1_ConfigMapStateSource(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Container":                         schema_pkg_apis_core_v1alpha1_Container(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerLogStreamStatus":          schema_pkg_apis_core_v1alpha1_ContainerLogStreamStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerState":                    schema_pkg_apis_core_v1alpha1_ContainerState(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerStateRunning":             schema_pkg_apis_core_v1alpha1_ContainerStateRunning(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerStateTerminated":          schema_pkg_apis_core_v1alpha1_ContainerStateTerminated(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerStateWaiting":             schema_pkg_apis_core_v1alpha1_ContainerStateWaiting(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableResourceStatus":             schema_pkg_apis_core_v1alpha1_DisableResourceStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableSource":                     schema_pkg_apis_core_v1alpha1_DisableSource(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableStatus":                     schema_pkg_apis_core_v1alpha1_DisableStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerClusterConnection":           schema_pkg_apis_core_v1alpha1_DockerClusterConnection(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeLogStream":            schema_pkg_apis_core_v1alpha1_DockerComposeLogStream(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeLogStreamList":        schema_pkg_apis_core_v1alpha1_DockerComposeLogStreamList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeLogStreamSpec":        schema_pkg_apis_core_v1alpha1_DockerComposeLogStreamSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeLogStreamStatus":      schema_pkg_apis_core_v1alpha1_DockerComposeLogStreamStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeProject":              schema_pkg_apis_core_v1alpha1_DockerComposeProject(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeService":              schema_pkg_apis_core_v1alpha1_DockerComposeService(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeServiceList":          schema_pkg_apis_core_v1alpha1_DockerComposeServiceList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeServiceSpec":          schema_pkg_apis_core_v1alpha1_DockerComposeServiceSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeServiceStatus":        schema_pkg_apis_core_v1alpha1_DockerComposeServiceStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerContainerState":              schema_pkg_apis_core_v1alpha1_DockerContainerState(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImage":                       schema_pkg_apis_core_v1alpha1_DockerImage(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageList":                   schema_pkg_apis_core_v1alpha1_DockerImageList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageSpec":                   schema_pkg_apis_core_v1alpha1_DockerImageSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStageStatus":            schema_pkg_apis_core_v1alpha1_DockerImageStageStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStateBuilding":          schema_pkg_apis_core_v1alpha1_DockerImageStateBuilding(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStateCompleted":         schema_pkg_apis_core_v1alpha1_DockerImageStateCompleted(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStateWaiting":           schema_pkg_apis_core_v1alpha1_DockerImageStateWaiting(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStatus":                 schema_pkg_apis_core_v1alpha1_DockerImageStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerPortBinding":                 schema_pkg_apis_core_v1alpha1_DockerPortBinding(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExecAction":                        schema_pkg_apis_core_v1alpha1_ExecAction(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Extension":                         schema_pkg_apis_core_v1alpha1_Extension(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionList":                     schema_pkg_apis_core_v1alpha1_ExtensionList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionRepo":                     schema_pkg_apis_core_v1alpha1_ExtensionRepo(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionRepoList":                 schema_pkg_apis_core_v1alpha1_ExtensionRepoList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionRepoSpec":                 schema_pkg_apis_core_v1alpha1_ExtensionRepoSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionRepoStatus":               schema_pkg_apis_core_v1alpha1_ExtensionRepoStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionSpec":                     schema_pkg_apis_core_v1alpha1_ExtensionSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionStatus":                   schema_pkg_apis_core_v1alpha1_ExtensionStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.FileEvent":                         schema_pkg_apis_core_v1alpha1_FileEvent(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.FileWatch":                         schema_pkg_apis_core_v1alpha1_FileWatch(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.FileWatchList":                     schema_pkg_apis_core_v1alpha1_FileWatchList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.FileWatchSpec":                     schema_pkg_apis_core_v1alpha1_FileWatchSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.FileWatchStatus":                   schema_pkg_apis_core_v1alpha1_FileWatchStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Forward":                           schema_pkg_apis_core_v1alpha1_Forward(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ForwardStatus":                     schema_pkg_apis_core_v1alpha1_ForwardStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.HTTPGetAction":                     schema_pkg_apis_core_v1alpha1_HTTPGetAction(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.HTTPHeader":                        schema_pkg_apis_core_v1alpha1_HTTPHeader(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Handler":                           schema_pkg_apis_core_v1alpha1_Handler(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.IgnoreDef":                         schema_pkg_apis_core_v1alpha1_IgnoreDef(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMap":                          schema_pkg_apis_core_v1alpha1_ImageMap(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMapList":                      schema_pkg_apis_core_v1alpha1_ImageMapList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMapOverrideArgs":              schema_pkg_apis_core_v1alpha1_ImageMapOverrideArgs(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMapOverrideCommand":           schema_pkg_apis_core_v1alpha1_ImageMapOverrideCommand(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMapSpec":                      schema_pkg_apis_core_v1alpha1_ImageMapSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMapStatus":                    schema_pkg_apis_core_v1alpha1_ImageMapStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApply":                   schema_pkg_apis_core_v1alpha1_KubernetesApply(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApplyCmd":                schema_pkg_apis_core_v1alpha1_KubernetesApplyCmd(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApplyList":               schema_pkg_apis_core_v1alpha1_KubernetesApplyList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApplySpec":               schema_pkg_apis_core_v1alpha1_KubernetesApplySpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApplyStatus":             schema_pkg_apis_core_v1alpha1_KubernetesApplyStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesClusterConnection":       schema_pkg_apis_core_v1alpha1_KubernetesClusterConnection(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesClusterConnectionStatus": schema_pkg_apis_core_v1alpha1_KubernetesClusterConnectionStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscovery":               schema_pkg_apis_core_v1alpha1_KubernetesDiscovery(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoveryList":           schema_pkg_apis_core_v1alpha1_KubernetesDiscoveryList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoverySpec":           schema_pkg_apis_core_v1alpha1_KubernetesDiscoverySpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoveryStateRunning":   schema_pkg_apis_core_v1alpha1_KubernetesDiscoveryStateRunning(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoveryStateWaiting":   schema_pkg_apis_core_v1alpha1_KubernetesDiscoveryStateWaiting(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoveryStatus":         schema_pkg_apis_core_v1alpha1_KubernetesDiscoveryStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoveryTemplateSpec":   schema_pkg_apis_core_v1alpha1_KubernetesDiscoveryTemplateSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesImageLocator":            schema_pkg_apis_core_v1alpha1_KubernetesImageLocator(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesImageObjectDescriptor":   schema_pkg_apis_core_v1alpha1_KubernetesImageObjectDescriptor(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesWatchRef":                schema_pkg_apis_core_v1alpha1_KubernetesWatchRef(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdate":                        schema_pkg_apis_core_v1alpha1_LiveUpdate(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateContainerStateWaiting":   schema_pkg_apis_core_v1alpha1_LiveUpdateContainerStateWaiting(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateContainerStatus":         schema_pkg_apis_core_v1alpha1_LiveUpdateContainerStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateDockerComposeSelector":   schema_pkg_apis_core_v1alpha1_LiveUpdateDockerComposeSelector(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateExec":                    schema_pkg_apis_core_v1alpha1_LiveUpdateExec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateKubernetesSelector":      schema_pkg_apis_core_v1alpha1_LiveUpdateKubernetesSelector(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateList":                    schema_pkg_apis_core_v1alpha1_LiveUpdateList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateSelector":                schema_pkg_apis_core_v1alpha1_LiveUpdateSelector(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateSource":                  schema_pkg_apis_core_v1alpha1_LiveUpdateSource(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateSpec":                    schema_pkg_apis_core_v1alpha1_LiveUpdateSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateStateFailed":             schema_pkg_apis_core_v1alpha1_LiveUpdateStateFailed(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateStatus":                  schema_pkg_apis_core_v1alpha1_LiveUpdateStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateSync":                    schema_pkg_apis_core_v1alpha1_LiveUpdateSync(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ObjectSelector":                    schema_pkg_apis_core_v1alpha1_ObjectSelector(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Pod":                               schema_pkg_apis_core_v1alpha1_Pod(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodCondition":                      schema_pkg_apis_core_v1alpha1_PodCondition(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStream":                      schema_pkg_apis_core_v1alpha1_PodLogStream(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStreamList":                  schema_pkg_apis_core_v1alpha1_PodLogStreamList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStreamSpec":                  schema_pkg_apis_core_v1alpha1_PodLogStreamSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStreamStatus":                schema_pkg_apis_core_v1alpha1_PodLogStreamStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStreamTemplateSpec":          schema_pkg_apis_core_v1alpha1_PodLogStreamTemplateSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodOwner":                          schema_pkg_apis_core_v1alpha1_PodOwner(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForward":                       schema_pkg_apis_core_v1alpha1_PortForward(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForwardList":                   schema_pkg_apis_core_v1alpha1_PortForwardList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForwardSpec":                   schema_pkg_apis_core_v1alpha1_PortForwardSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForwardStatus":                 schema_pkg_apis_core_v1alpha1_PortForwardStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForwardTemplateSpec":           schema_pkg_apis_core_v1alpha1_PortForwardTemplateSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Probe":                             schema_pkg_apis_core_v1alpha1_Probe(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.RegistryHosting":                   schema_pkg_apis_core_v1alpha1_RegistryHosting(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.RestartOnSpec":                     schema_pkg_apis_core_v1alpha1_RestartOnSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Session":                           schema_pkg_apis_core_v1alpha1_Session(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.SessionCISpec":                     schema_pkg_apis_core_v1alpha1_SessionCISpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.SessionList":                       schema_pkg_apis_core_v1alpha1_SessionList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.SessionSpec":                       schema_pkg_apis_core_v1alpha1_SessionSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.SessionStatus":                     schema_pkg_apis_core_v1alpha1_SessionStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.StartOnSpec":                       schema_pkg_apis_core_v1alpha1_StartOnSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.StateSource":                       schema_pkg_apis_core_v1alpha1_StateSource(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.StopOnSpec":                        schema_pkg_apis_core_v1alpha1_StopOnSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TCPSocketAction":                   schema_pkg_apis_core_v1alpha1_TCPSocketAction(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Target":                            schema_pkg_apis_core_v1alpha1_Target(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetState":                       schema_pkg_apis_core_v1alpha1_TargetState(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetStateActive":                 schema_pkg_apis_core_v1alpha1_TargetStateActive(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetStateDisabled":               schema_pkg_apis_core_v1alpha1_TargetStateDisabled(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetStateTerminated":             schema_pkg_apis_core_v1alpha1_TargetStateTerminated(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetStateWaiting":                schema_pkg_apis_core_v1alpha1_TargetStateWaiting(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltBuild":                         schema_pkg_apis_core_v1alpha1_TiltBuild(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Tiltfile":                          schema_pkg_apis_core_v1alpha1_Tiltfile(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileList":                      schema_pkg_apis_core_v1alpha1_TiltfileList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileSpec":                      schema_pkg_apis_core_v1alpha1_TiltfileSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileStateRunning":              schema_pkg_apis_core_v1alpha1_TiltfileStateRunning(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileStateTerminated":           schema_pkg_apis_core_v1alpha1_TiltfileStateTerminated(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileStateWaiting":              schema_pkg_apis_core_v1alpha1_TiltfileStateWaiting(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileStatus":                    schema_pkg_apis_core_v1alpha1_TiltfileStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButton":                      schema_pkg_apis_core_v1alpha1_ToggleButton(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButtonList":                  schema_pkg_apis_core_v1alpha1_ToggleButtonList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButtonSpec":                  schema_pkg_apis_core_v1alpha1_ToggleButtonSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButtonStateSpec":             schema_pkg_apis_core_v1alpha1_ToggleButtonStateSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButtonStatus":                schema_pkg_apis_core_v1alpha1_ToggleButtonStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIBoolInputSpec":                   schema_pkg_apis_core_v1alpha1_UIBoolInputSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIBoolInputStatus":                 schema_pkg_apis_core_v1alpha1_UIBoolInputStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIBuildRunning":                    schema_pkg_apis_core_v1alpha1_UIBuildRunning(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIBuildTerminated":                 schema_pkg_apis_core_v1alpha1_UIBuildTerminated(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIButton":                          schema_pkg_apis_core_v1alpha1_UIButton(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIButtonList":                      schema_pkg_apis_core_v1alpha1_UIButtonList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIButtonSpec":                      schema_pkg_apis_core_v1alpha1_UIButtonSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIButtonStatus":                    schema_pkg_apis_core_v1alpha1_UIButtonStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIChoiceInputSpec":                 schema_pkg_apis_core_v1alpha1_UIChoiceInputSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIChoiceInputStatus":               schema_pkg_apis_core_v1alpha1_UIChoiceInputStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIComponentLocation":               schema_pkg_apis_core_v1alpha1_UIComponentLocation(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIComponentLocationResource":       schema_pkg_apis_core_v1alpha1_UIComponentLocationResource(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIFeatureFlag":                     schema_pkg_apis_core_v1alpha1_UIFeatureFlag(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIHiddenInputSpec":                 schema_pkg_apis_core_v1alpha1_UIHiddenInputSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIHiddenInputStatus":               schema_pkg_apis_core_v1alpha1_UIHiddenInputStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIInputSpec":                       schema_pkg_apis_core_v1alpha1_UIInputSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIInputStatus":                     schema_pkg_apis_core_v1alpha1_UIInputStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResource":                        schema_pkg_apis_core_v1alpha1_UIResource(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceCondition":               schema_pkg_apis_core_v1alpha1_UIResourceCondition(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceKubernetes":              schema_pkg_apis_core_v1alpha1_UIResourceKubernetes(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceLink":                    schema_pkg_apis_core_v1alpha1_UIResourceLink(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceList":                    schema_pkg_apis_core_v1alpha1_UIResourceList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceLocal":                   schema_pkg_apis_core_v1alpha1_UIResourceLocal(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceSpec":                    schema_pkg_apis_core_v1alpha1_UIResourceSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceStateWaiting":            schema_pkg_apis_core_v1alpha1_UIResourceStateWaiting(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceStateWaitingOnRef":       schema_pkg_apis_core_v1alpha1_UIResourceStateWaitingOnRef(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceStatus":                  schema_pkg_apis_core_v1alpha1_UIResourceStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceTargetSpec":              schema_pkg_apis_core_v1alpha1_UIResourceTargetSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UISession":                         schema_pkg_apis_core_v1alpha1_UISession(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UISessionList":                     schema_pkg_apis_core_v1alpha1_UISessionList(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UISessionSpec":                     schema_pkg_apis_core_v1alpha1_UISessionSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UISessionStatus":                   schema_pkg_apis_core_v1alpha1_UISessionStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UITextInputSpec":                   schema_pkg_apis_core_v1alpha1_UITextInputSpec(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UITextInputStatus":                 schema_pkg_apis_core_v1alpha1_UITextInputStatus(ref),
		"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.VersionSettings":                   schema_pkg_apis_core_v1alpha1_VersionSettings(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIGroup":                                     schema_pkg_apis_meta_v1_APIGroup(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIGroupList":                                 schema_pkg_apis_meta_v1_APIGroupList(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIResource":                                  schema_pkg_apis_meta_v1_APIResource(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIResourceList":                              schema_pkg_apis_meta_v1_APIResourceList(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIVersions":                                  schema_pkg_apis_meta_v1_APIVersions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ApplyOptions":                                 schema_pkg_apis_meta_v1_ApplyOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Condition":                                    schema_pkg_apis_meta_v1_Condition(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.CreateOptions":                                schema_pkg_apis_meta_v1_CreateOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.DeleteOptions":                                schema_pkg_apis_meta_v1_DeleteOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Duration":                                     schema_pkg_apis_meta_v1_Duration(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.FieldsV1":                                     schema_pkg_apis_meta_v1_FieldsV1(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GetOptions":                                   schema_pkg_apis_meta_v1_GetOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupKind":                                    schema_pkg_apis_meta_v1_GroupKind(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupResource":                                schema_pkg_apis_meta_v1_GroupResource(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersion":                                 schema_pkg_apis_meta_v1_GroupVersion(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery":                     schema_pkg_apis_meta_v1_GroupVersionForDiscovery(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind":                             schema_pkg_apis_meta_v1_GroupVersionKind(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionResource":                         schema_pkg_apis_meta_v1_GroupVersionResource(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.InternalEvent":                                schema_pkg_apis_meta_v1_InternalEvent(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector":                                schema_pkg_apis_meta_v1_LabelSelector(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement":                     schema_pkg_apis_meta_v1_LabelSelectorRequirement(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.List":                                         schema_pkg_apis_meta_v1_List(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta":                                     schema_pkg_apis_meta_v1_ListMeta(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ListOptions":                                  schema_pkg_apis_meta_v1_ListOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ManagedFieldsEntry":                           schema_pkg_apis_meta_v1_ManagedFieldsEntry(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime":                                    schema_pkg_apis_meta_v1_MicroTime(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta":                                   schema_pkg_apis_meta_v1_ObjectMeta(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference":                               schema_pkg_apis_meta_v1_OwnerReference(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.PartialObjectMetadata":                        schema_pkg_apis_meta_v1_PartialObjectMetadata(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.PartialObjectMetadataList":                    schema_pkg_apis_meta_v1_PartialObjectMetadataList(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Patch":                                        schema_pkg_apis_meta_v1_Patch(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.PatchOptions":                                 schema_pkg_apis_meta_v1_PatchOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Preconditions":                                schema_pkg_apis_meta_v1_Preconditions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.RootPaths":                                    schema_pkg_apis_meta_v1_RootPaths(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR":                    schema_pkg_apis_meta_v1_ServerAddressByClientCIDR(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Status":                                       schema_pkg_apis_meta_v1_Status(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.StatusCause":                                  schema_pkg_apis_meta_v1_StatusCause(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.StatusDetails":                                schema_pkg_apis_meta_v1_StatusDetails(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Table":                                        schema_pkg_apis_meta_v1_Table(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TableColumnDefinition":                        schema_pkg_apis_meta_v1_TableColumnDefinition(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TableOptions":                                 schema_pkg_apis_meta_v1_TableOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TableRow":                                     schema_pkg_apis_meta_v1_TableRow(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TableRowCondition":                            schema_pkg_apis_meta_v1_TableRowCondition(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Time":                                         schema_pkg_apis_meta_v1_Time(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Timestamp":                                    schema_pkg_apis_meta_v1_Timestamp(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta":                                     schema_pkg_apis_meta_v1_TypeMeta(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.UpdateOptions":                                schema_pkg_apis_meta_v1_UpdateOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.WatchEvent":                                   schema_pkg_apis_meta_v1_WatchEvent(ref),
		"k8s.io/apimachinery/pkg/runtime.RawExtension":                                      schema_k8sio_apimachinery_pkg_runtime_RawExtension(ref),
		"k8s.io/apimachinery/pkg/runtime.TypeMeta":                                          schema_k8sio_apimachinery_pkg_runtime_TypeMeta(ref),
		"k8s.io/apimachinery/pkg/runtime.Unknown":                                           schema_k8sio_apimachinery_pkg_runtime_Unknown(ref),
		"k8s.io/apimachinery/pkg/version.Info":                                              schema_k8sio_apimachinery_pkg_version_Info(ref),
	}
}

func schema_pkg_apis_core_v1alpha1_Cluster(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Cluster defines any runtime for running containers, in the broadest sense of the word \"runtime\".",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ClusterSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ClusterStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ClusterSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ClusterStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ClusterConnection(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Connection spec for an existing cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kubernetes": {
						SchemaProps: spec.SchemaProps{
							Description: "Defines connection to a Kubernetes cluster.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesClusterConnection"),
						},
					},
					"docker": {
						SchemaProps: spec.SchemaProps{
							Description: "Defines connection to a Docker daemon.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerClusterConnection"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerClusterConnection", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesClusterConnection"},
	}
}

func schema_pkg_apis_core_v1alpha1_ClusterConnectionStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Connection spec for an existing cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kubernetes": {
						SchemaProps: spec.SchemaProps{
							Description: "Defines connection to a Kubernetes cluster.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesClusterConnectionStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesClusterConnectionStatus"},
	}
}

func schema_pkg_apis_core_v1alpha1_ClusterList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Cluster"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Cluster", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ClusterSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterSpec defines how to find the cluster we're running containers on.\n\nTilt currently supports connecting to an existing Kubernetes cluster or an existing Docker Daemon (for Docker Compose).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"connection": {
						SchemaProps: spec.SchemaProps{
							Description: "Connection spec for an existing cluster.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ClusterConnection"),
						},
					},
					"defaultRegistry": {
						SchemaProps: spec.SchemaProps{
							Description: "DefaultRegistry determines where images for this Cluster should be pushed/pulled from if the Cluster itself does not provide local registry hosting metadata.\n\nIf not specified, no registry rewriting will occur, and the images will be pushed/pulled to from the registry specified by the corresponding image build directive (e.g. `docker_build` or `custom_build`).",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.RegistryHosting"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ClusterConnection", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.RegistryHosting"},
	}
}

func schema_pkg_apis_core_v1alpha1_ClusterStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterStatus defines the observed state of Cluster",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"arch": {
						SchemaProps: spec.SchemaProps{
							Description: "The preferred chip architecture of the cluster.\n\nOn Kubernetes, this will correspond to the kubernetes.io/arch annotation on a node.\n\nOn Docker, this will be the Architecture of the Docker daemon.\n\nNote that many clusters support multiple chipsets. This field doesn't intend that this is the only architecture a cluster supports, only that it's one of the architectures.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "An unrecoverable error connecting to the cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"connectedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "ConnectedAt indicates the time at which the cluster connection was established.\n\nConsumers can use this to detect when the underlying config has changed and refresh their client/connection accordingly.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"registry": {
						SchemaProps: spec.SchemaProps{
							Description: "Registry describes a local registry that developer tools can connect to. A local registry allows clients to load images into the local cluster by pushing to this registry.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.RegistryHosting"),
						},
					},
					"connection": {
						SchemaProps: spec.SchemaProps{
							Description: "Connection status for an existing cluster.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ClusterConnectionStatus"),
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is a cluster-provided, human-readable version string.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ClusterConnectionStatus", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.RegistryHosting", "k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_Cmd(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Cmd represents a process on the host machine.\n\nWhen the process exits, we will make a best-effort attempt (within OS limitations) to kill any spawned descendant processes.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_CmdImage(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CmdImage describes an image to build with an arbitrary shell command.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_CmdImageList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CmdImageList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImage"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImage", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_CmdImageSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CmdImageSpec describes how the custom script builds images and where it puts them.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ref": {
						SchemaProps: spec.SchemaProps{
							Description: "The named reference of the image.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"args": {
						SchemaProps: spec.SchemaProps{
							Description: "Command-line arguments. Must have length at least 1.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"dir": {
						SchemaProps: spec.SchemaProps{
							Description: "Process working directory.\n\nIf the working directory is not specified, the command is run in the default Tilt working directory.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imageMaps": {
						SchemaProps: spec.SchemaProps{
							Description: "Names of image maps that this build depends on.\n\nThe controller will watch all the image maps, and rebuild the image if any of the maps resolve to a new image.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"outputMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies where the image is built. If not specified, we assume the image was built to the local Docker image store.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"outputTag": {
						SchemaProps: spec.SchemaProps{
							Description: "Tag we expect the image to be built with (we use this to check that the expected image+tag has been created).\n\nIf empty, we create an expected tag at the beginning of CustomBuild (and export $EXPECTED_REF=name:expected_tag )",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"outputsImageRefTo": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies a filepath where the cmd script prints the result image ref.\n\nTilt will read it out when we're done to find the image.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cluster": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the cluster we're building for.\n\nWe'll use the cluster to determine the architecture of the image to build, and the registry to build it for.\n\nIf no cluster is specified, assumes the default cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clusterNeeds": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether the cluster needs access to the image.\n\nIf not specified, assumes we have to push up to the cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"ref"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_CmdImageStateBuilding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CmdImageStateBuilding expresses that an image build is in-progress.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason why the image is building.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time when the build started.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_CmdImageStateCompleted(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CmdImageStateCompleted expresses when the image build is finished and no new images need to be built.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason why the image was built.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error message if the build failed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time when we started building an image.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"finishedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time when we finished building an image",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_CmdImageStateWaiting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CmdImageStateWaiting expresses what we're waiting on to build an image.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason the image build is waiting.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_CmdImageStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CmdImageStatus describes the result of the image build.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ref": {
						SchemaProps: spec.SchemaProps{
							Description: "A fully-qualified image reference of a built image, as seen from the local network.\n\nUsually includes a name and an immutable tag.\n\nNB: If we're building to a particular registry, this may have a different hostname from the Spec `Ref` field.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"waiting": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a waiting image build.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageStateWaiting"),
						},
					},
					"building": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a building image.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageStateBuilding"),
						},
					},
					"completed": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a finished image build.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageStateCompleted"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageStateBuilding", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageStateCompleted", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdImageStateWaiting"},
	}
}

func schema_pkg_apis_core_v1alpha1_CmdList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CmdList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Cmd"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Cmd", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_CmdSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CmdSpec defines how to run a local command.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"args": {
						SchemaProps: spec.SchemaProps{
							Description: "Command-line arguments. Must have length at least 1.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"dir": {
						SchemaProps: spec.SchemaProps{
							Description: "Process working directory.\n\nIf the working directory is not specified, the command is run in the default Tilt working directory.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"env": {
						SchemaProps: spec.SchemaProps{
							Description: "Additional variables process environment.\n\nExpressed as a C-style array of strings of the form [\"KEY1=VALUE1\", \"KEY2=VALUE2\", ...].\n\nEnvironment variables are layered on top of the environment variables that Tilt runs with.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"readinessProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "Periodic probe of service readiness.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Probe"),
						},
					},
					"restartOn": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates objects that can trigger a restart of this command.\n\nWhen a restart is triggered, Tilt will try to gracefully shutdown any currently running process, waiting for it to exit before starting a new process. If the process doesn't shutdown within the allotted time, Tilt will kill the process abruptly.\n\nRestarts can happen even if the command is already done.\n\nLogs of the current process after the restart are discarded.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.RestartOnSpec"),
						},
					},
					"startOn": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates objects that can trigger a start/restart of this command.\n\nRestarts behave the same as RestartOn. The key difference is that a Cmd with any StartOn triggers will not have its command run until its StartOn is satisfied.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.StartOnSpec"),
						},
					},
					"disableSource": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies how to disable this.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableSource"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableSource", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Probe", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.RestartOnSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.StartOnSpec"},
	}
}

func schema_pkg_apis_core_v1alpha1_CmdStateRunning(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CmdStateRunning is a running state of a local command.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"pid": {
						SchemaProps: spec.SchemaProps{
							Description: "The process id of the command.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which the command was last started.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
				},
				Required: []string{"pid"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_CmdStateTerminated(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CmdStateTerminated is a terminated state of a local command.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"pid": {
						SchemaProps: spec.SchemaProps{
							Description: "The process id of the command.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"exitCode": {
						SchemaProps: spec.SchemaProps{
							Description: "Exit status from the last termination of the command",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which previous execution of the command started",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"finishedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which the command last terminated",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason the process is terminated",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"pid", "exitCode"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_CmdStateWaiting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CmdStateWaiting is a waiting state of a local command.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason the process is not yet running.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_CmdStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CmdStatus defines the observed state of Cmd\n\nBased loosely on ContainerStatus in Kubernetes",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"waiting": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a waiting process.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdStateWaiting"),
						},
					},
					"running": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a running process.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdStateRunning"),
						},
					},
					"terminated": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a terminated process.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdStateTerminated"),
						},
					},
					"ready": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies whether the command has passed its readiness probe.\n\nTerminating the command does not change its Ready state.\n\nIs always true when no readiness probe is defined.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"disableStatus": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about whether/why this is disabled.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdStateRunning", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdStateTerminated", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.CmdStateWaiting", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableStatus"},
	}
}

func schema_pkg_apis_core_v1alpha1_ConfigMap(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ConfigMap stores unstructured data that other controllers can read and write.\n\nUseful for sharing data from one system and subscribing to it from another.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ConfigMapDisableSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Specifies a ConfigMap to control a DisableSource",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the ConfigMap",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "The key where the enable/disable state is stored.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "key"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ConfigMapList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ConfigMapList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ConfigMap"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ConfigMap", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ConfigMapStateSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes how a ToggleButton's state is stored in a ConfigMap. The ConfigMap must be created separately - the ToggleButton will not automatically create it.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the ConfigMap",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "Key within the ConfigMap",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"onValue": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfigMap value corresponding to the button's \"on\" state. If not specified, \"true\" will be used.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"offValue": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfigMap value corresponding to the button's \"off\" state If not specified, \"false\" will be used.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "key"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_Container(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Container is an init or application container within a pod.\n\nThe Tilt API representation mirrors the Kubernetes API very closely. Irrelevant data is not included, and some fields might be simplified.\n\nThere might also be Tilt-specific status fields.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the container as defined in Kubernetes.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"id": {
						SchemaProps: spec.SchemaProps{
							Description: "ID is the normalized container ID (the `docker://` prefix is stripped).",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ready": {
						SchemaProps: spec.SchemaProps{
							Description: "Ready is true if the container is passing readiness checks (or has none defined).",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "Image is the image the container is running.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"restarts": {
						SchemaProps: spec.SchemaProps{
							Description: "Restarts is the number of times the container has restarted.\n\nThis includes restarts before the Tilt daemon was started if the container was already running.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"state": {
						SchemaProps: spec.SchemaProps{
							Description: "State provides details about the container's current condition.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerState"),
						},
					},
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "Ports are exposed ports as extracted from the Pod spec.\n\nThis is added by Tilt for convenience when managing port forwards.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: 0,
										Type:    []string{"integer"},
										Format:  "int32",
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "id", "ready", "image", "restarts", "state", "ports"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerState"},
	}
}

func schema_pkg_apis_core_v1alpha1_ContainerLogStreamStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerLogStreamStatus defines the current status of each individual container log stream.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the container.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"active": {
						SchemaProps: spec.SchemaProps{
							Description: "True when the stream is set up and streaming logs properly.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"terminated": {
						SchemaProps: spec.SchemaProps{
							Description: "True when the logs are done stream and the container is terminated.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "The last error message encountered while streaming.\n\nEmpty when the stream is actively streaming or successfully terminated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ContainerState(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerState holds a possible state of container.\n\nOnly one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"waiting": {
						SchemaProps: spec.SchemaProps{
							Description: "Waiting provides details about a container that is not yet running.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerStateWaiting"),
						},
					},
					"running": {
						SchemaProps: spec.SchemaProps{
							Description: "Running provides details about a currently executing container.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerStateRunning"),
						},
					},
					"terminated": {
						SchemaProps: spec.SchemaProps{
							Description: "Terminated provides details about an exited container.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerStateTerminated"),
						},
					},
				},
				Required: []string{"waiting", "running", "terminated"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerStateRunning", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerStateTerminated", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerStateWaiting"},
	}
}

func schema_pkg_apis_core_v1alpha1_ContainerStateRunning(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerStateRunning is a running state of a container.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "StartedAt is the time the container began running.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
				},
				Required: []string{"startedAt"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_ContainerStateTerminated(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerStateTerminated is a terminated state of a container.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "StartedAt is the time the container began running.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"finishedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "FinishedAt is the time the container stopped running.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason is a (brief) reason the container stopped running.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"exitCode": {
						SchemaProps: spec.SchemaProps{
							Description: "ExitCode is the exit status from the termination of the container.\n\nAny non-zero value indicates an error during termination.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"startedAt", "finishedAt", "exitCode"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_ContainerStateWaiting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerStateWaiting is a waiting state of a container.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason is a (brief) reason the container is not yet running.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"reason"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_DisableResourceStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Aggregated disable status of DisableSources that belong to a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabledCount": {
						SchemaProps: spec.SchemaProps{
							Description: "How many of the resource's sources are enabled.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"disabledCount": {
						SchemaProps: spec.SchemaProps{
							Description: "How many of the resource's sources are disabled.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"state": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this is currently disabled (if known)",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"sources": {
						SchemaProps: spec.SchemaProps{
							Description: "All unique sources that control the resource's objects' disable status.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableSource"),
									},
								},
							},
						},
					},
				},
				Required: []string{"enabledCount", "disabledCount", "state", "sources"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableSource"},
	}
}

func schema_pkg_apis_core_v1alpha1_DisableSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Points at a thing that can control whether something is disabled",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"configMap": {
						SchemaProps: spec.SchemaProps{
							Description: "Disabled by single ConfigMap value.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ConfigMapDisableSource"),
						},
					},
					"everyConfigMap": {
						SchemaProps: spec.SchemaProps{
							Description: "Disabled by multiple ConfigMap values, which must all be set to disabled to disable the object.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ConfigMapDisableSource"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ConfigMapDisableSource"},
	}
}

func schema_pkg_apis_core_v1alpha1_DisableStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"disabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this is currently disabled. Deprecated in favor of `State`.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time this status was updated.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason this status was updated.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"state": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this is currently disabled (if known)",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"disabled", "lastUpdateTime", "reason", "state"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerClusterConnection(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"host": {
						SchemaProps: spec.SchemaProps{
							Description: "The docker host to use.\n\nIf not specified, will read the DOCKER_HOST env or use the default docker host.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerComposeLogStream(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerComposeLogStream",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeLogStreamSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeLogStreamStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeLogStreamSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeLogStreamStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerComposeLogStreamList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerComposeLogStreamList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeLogStream"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeLogStream", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerComposeLogStreamSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerComposeLogStreamSpec defines the desired state of DockerComposeLogStream",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"service": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the service to stream from.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"project": {
						SchemaProps: spec.SchemaProps{
							Description: "A specification of the project the service belongs to.\n\nEach service spec keeps its own copy of the project spec.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeProject"),
						},
					},
				},
				Required: []string{"service", "project"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeProject"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerComposeLogStreamStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerComposeLogStreamStatus defines the observed state of DockerComposeLogStream",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "When we last started the log streamer.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Contains an error message when the log streamer is in an error state.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerComposeProject(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"configPaths": {
						SchemaProps: spec.SchemaProps{
							Description: "Configuration files to load.\n\nIf both ConfigPaths and ProjectPath/YAML are specified, the YAML is the source of truth, and the ConfigPaths are used to print diagnostic information.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"projectPath": {
						SchemaProps: spec.SchemaProps{
							Description: "The base path of the docker-compose project.\n\nExpressed in docker-compose as --project-directory.\n\nWhen used on the command-line, the Docker Compose spec mandates that this must be the directory of the first yaml file.  All additional yaml files are evaluated relative to this project path.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"yaml": {
						SchemaProps: spec.SchemaProps{
							Description: "The docker-compose config YAML.\n\nUsually contains multiple services.\n\nIf you have multiple docker-compose.yaml files, you can combine them into a single YAML with `docker-compose -f file1.yaml -f file2.yaml config`.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The docker-compose project name.\n\nIf omitted, the default is to use the NormalizedName of the ProjectPath base name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"envFile": {
						SchemaProps: spec.SchemaProps{
							Description: "Path to an env file to use. Passed to docker-compose as `--env-file FILE`.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerComposeService(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerComposeService represents a container orchestrated by Docker Compose.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeServiceSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeServiceStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeServiceSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeServiceStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerComposeServiceList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerComposeServiceList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeService"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeService", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerComposeServiceSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerComposeServiceSpec defines the desired state a Docker Compose container.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"service": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the service to create.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"project": {
						SchemaProps: spec.SchemaProps{
							Description: "A specification of the project the service belongs to.\n\nEach service spec keeps its own copy of the project spec.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeProject"),
						},
					},
					"imageMaps": {
						SchemaProps: spec.SchemaProps{
							Description: "The image maps that this deploy depends on.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"disableSource": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies how to disable this.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableSource"),
						},
					},
				},
				Required: []string{"service", "project"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableSource", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerComposeProject"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerComposeServiceStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerComposeServiceStatus defines the observed state of DockerComposeService, continuing to watch the container after it starts.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"disableStatus": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about whether/why this is disabled.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableStatus"),
						},
					},
					"portBindings": {
						SchemaProps: spec.SchemaProps{
							Description: "How docker binds container ports to the host network for this service.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerPortBinding"),
									},
								},
							},
						},
					},
					"containerState": {
						SchemaProps: spec.SchemaProps{
							Description: "Current state of the container for this service.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerContainerState"),
						},
					},
					"containerID": {
						SchemaProps: spec.SchemaProps{
							Description: "Current container ID.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"containerName": {
						SchemaProps: spec.SchemaProps{
							Description: "Current container name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"applyError": {
						SchemaProps: spec.SchemaProps{
							Description: "An error bringing up the container.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastApplyStartTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Timestamp of when we last started bringing up this service in Docker Compose.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"lastApplyFinishTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Timestamp of when we last finished bringing up this service in Docker Compose.\n\nWhen populated, must be equal or after the LastApplyStartTime field.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableStatus", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerContainerState", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerPortBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerContainerState(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "State of a standalone container in Docker.\n\nAn apiserver-compatible representation of this struct: https://pkg.go.dev/github.com/docker/docker/api/types#ContainerState",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "String representation of the container state. Can be one of \"created\", \"running\", \"paused\", \"restarting\", \"removing\", \"exited\", or \"dead\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"running": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether the container is running.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether the container is in an error state.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"exitCode": {
						SchemaProps: spec.SchemaProps{
							Description: "The exit code, if the container has exited.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "When the container process started.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"finishedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "When the container process finished.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerImage(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerImage describes an image to build with Docker.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerImageList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerImageList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImage"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImage", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerImageSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerImageSpec describes how to build a Docker image with `docker_build`.\n\nMost fields of this spec directly correspond to the Docker CLI.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ref": {
						SchemaProps: spec.SchemaProps{
							Description: "The named reference of the image.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dockerfileContents": {
						SchemaProps: spec.SchemaProps{
							Description: "Dockerfile contains the complete contents of the Dockerfile.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"context": {
						SchemaProps: spec.SchemaProps{
							Description: "Context specifies the Docker build context.\n\nMust be an absolute path on the local filesystem.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"contextIgnores": {
						SchemaProps: spec.SchemaProps{
							Description: "Ignores are filters on the Docker build context.\n\nThe DockerImage controller will NOT read ignores from .dockerignore files. Instead, all filters must be expressed in this field, which covers .dockerignore files, ignore= lists in the tiltfile, only= lists in the tiltfile, and more.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.IgnoreDef"),
									},
								},
							},
						},
					},
					"args": {
						SchemaProps: spec.SchemaProps{
							Description: "Args specifies the build arguments to the Dockerfile.\n\nEquivalent to `--build-arg` in the docker CLI.\n\nEach item should take the form \"KEY\" or \"KEY=VALUE\".",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "Target specifies the name of the stage in the Dockerfile to build.\n\nEquivalent to `--target` in the docker CLI.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"sshAgentConfigs": {
						SchemaProps: spec.SchemaProps{
							Description: "Pass SSH secrets to docker so it can clone private repos.\n\nhttps://docs.docker.com/develop/develop-images/build_enhancements/#using-ssh-to-access-private-data-in-builds\n\nEquivalent to `--ssh` in the docker CLI.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"secrets": {
						SchemaProps: spec.SchemaProps{
							Description: "Pass secrets to docker.\n\nhttps://docs.docker.com/develop/develop-images/build_enhancements/#new-docker-build-secret-information\n\nEquivalent to `--secret` in the Docker CLI.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"network": {
						SchemaProps: spec.SchemaProps{
							Description: "Set the networking mode for the RUN instructions in the docker build.\n\nEquivalent to `--network` in the Docker CLI.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"pull": {
						SchemaProps: spec.SchemaProps{
							Description: "Always attempt to pull a new version of the base image.\n\nEquivalent to `--pull` in the Docker CLI.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"cacheFrom": {
						SchemaProps: spec.SchemaProps{
							Description: "Images to use as cache sources.\n\nEquivalent to `--cache-from` in the Docker CLI.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"platform": {
						SchemaProps: spec.SchemaProps{
							Description: "Platform specifies architecture information for target image.\n\nhttps://docs.docker.com/desktop/multi-arch/\n\nEquivalent to `--platform` in the Docker CLI.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"extraTags": {
						SchemaProps: spec.SchemaProps{
							Description: "By default, Tilt creates a new temporary image reference for each build. The user can also specify their own reference, to integrate with other tooling (like build IDs for Jenkins build pipelines)\n\nEquivalent to the docker build --tag flag.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"imageMaps": {
						SchemaProps: spec.SchemaProps{
							Description: "Names of image maps that this build depends on.\n\nThe controller will watch all the image maps, rebuild the image if any of the maps resolve to a new image, and inject them into the dockerfile.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"cluster": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the cluster we're building for.\n\nWe'll use the cluster to determine the architecture of the image to build, and the registry to build it for.\n\nIf no cluster is specified, assumes the default cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clusterNeeds": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether the cluster needs access to the image.\n\nIf not specified, assumes we have to push up to the cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"ref"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.IgnoreDef"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerImageStageStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerImageStageStatus gives detailed report of each stage of the most recent image build.\n\nMost stages are derived from Buildkit's StatusResponse https://github.com/moby/buildkit/blob/35fcb28a009d6454b2915a5c8084b25ad851cf38/api/services/control/control.proto#L108 but Tilt may synthesize its own stages for the steps it owns.\n\nStages may be executed in parallel.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "A human-readable name of the stage.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cached": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether Buildkit was able to cache the stage based on inputs.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "The timestamp when we started working on the stage.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"finishedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "The timetsamp when we completed the work on the stage.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error message if the stage failed. If empty, the stage succeeded.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerImageStateBuilding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerImageStateBuilding expresses that an image build is in-progress.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason why the image is building.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time when the build started.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerImageStateCompleted(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerImageStateCompleted expresses when the image build is finished and no new images need to be built.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason why the image was built.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error message if the build failed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time when we started building an image.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"finishedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time when we finished building an image",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerImageStateWaiting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerImageStateWaiting expresses what we're waiting on to build an image.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason the image build is waiting.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerImageStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DockerImageStatus defines the observed state of DockerImage",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ref": {
						SchemaProps: spec.SchemaProps{
							Description: "A fully-qualified image reference of a built image, as seen from the local network.\n\nUsually includes a name and an immutable tag.\n\nNB: If we're building to a particular registry, this may have a different hostname from the Spec `Ref` field.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"waiting": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a waiting image build.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStateWaiting"),
						},
					},
					"building": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a building image.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStateBuilding"),
						},
					},
					"completed": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a finished image build.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStateCompleted"),
						},
					},
					"stageStatuses": {
						SchemaProps: spec.SchemaProps{
							Description: "Status information about each individual build stage of the most recent image build.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStageStatus"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStageStatus", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStateBuilding", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStateCompleted", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DockerImageStateWaiting"},
	}
}

func schema_pkg_apis_core_v1alpha1_DockerPortBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "How docker binds container ports to the host network",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"containerPort": {
						SchemaProps: spec.SchemaProps{
							Description: "The port inside the container.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"hostPort": {
						SchemaProps: spec.SchemaProps{
							Description: "The port on the host machine where Docker running.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"hostIP": {
						SchemaProps: spec.SchemaProps{
							Description: "The IP on the host machine where Docker is binding the network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ExecAction(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExecAction describes a \"run in container\" action.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"command": {
						SchemaProps: spec.SchemaProps{
							Description: "Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_Extension(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Extension defines an extension that's evaluated on Tilt startup.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ExtensionList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExtensionList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Extension"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Extension", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ExtensionRepo(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExtensionRepo specifies a repo or folder where a set of extensions live.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionRepoSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionRepoStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionRepoSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionRepoStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ExtensionRepoList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExtensionRepoList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionRepo"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExtensionRepo", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ExtensionRepoSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExtensionRepoSpec defines how to access the repo.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"url": {
						SchemaProps: spec.SchemaProps{
							Description: "The URL of the repo.\n\nAllowed: https: URLs that point to a public git repo file: URLs that point to a location on disk.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ref": {
						SchemaProps: spec.SchemaProps{
							Description: "A reference to sync the repo to. If empty, Tilt will always update the repo to the latest version.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"url"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ExtensionRepoStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExtensionRepoStatus defines the observed state of ExtensionRepo",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Contains information about any problems loading the repo.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastFetchedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time the repo was fetched and checked for validity.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "The path to the repo on local disk.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"checkoutRef": {
						SchemaProps: spec.SchemaProps{
							Description: "The reference that we currently have checked out. On git, this is the commit hash. On file repos, this is empty.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"staleReason": {
						SchemaProps: spec.SchemaProps{
							Description: "If StaleReason is non-empty, that indicates the repo failed to fetch, but we were successfully able to use an on-disk copy.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_ExtensionSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExtensionSpec defines the desired state of Extension",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"repoName": {
						SchemaProps: spec.SchemaProps{
							Description: "RepoName specifies the ExtensionRepo object where we should find this extension.\n\nThe Extension controller should watch for changes to this repo, and may update if this repo is deleted or moved.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"repoPath": {
						SchemaProps: spec.SchemaProps{
							Description: "RepoPath specifies the path to the extension directory inside the repo.\n\nOnce the repo is downloaded, this path should point to a directory with a Tiltfile as the main \"entrypoint\" of the extension.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"args": {
						SchemaProps: spec.SchemaProps{
							Description: "Arguments to the Tiltfile loaded by this extension.\n\nArguments can be positional (['a', 'b', 'c']) or flag-based ('--to-edit=a'). By default, a list of arguments indicates the list of services in the tiltfile that should be enabled.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"repoName", "repoPath"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ExtensionStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExtensionStatus defines the observed state of Extension",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Contains information about any problems loading the extension.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "The path to the extension on disk. This location should be shared and readable by all Tilt instances.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_FileEvent(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"time": {
						SchemaProps: spec.SchemaProps{
							Description: "Time is an approximate timestamp for a batch of file changes.\n\nThis will NOT exactly match any inode attributes (e.g. ctime, mtime) at the filesystem level and is purely informational or for use as an opaque watermark.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"seenFiles": {
						SchemaProps: spec.SchemaProps{
							Description: "SeenFiles is a list of paths which changed (create, modify, or delete).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"time", "seenFiles"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_FileWatch(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FileWatch",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.FileWatchSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.FileWatchStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.FileWatchSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.FileWatchStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_FileWatchList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FileWatchList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.FileWatch"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.FileWatch", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_FileWatchSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FileWatchSpec defines the desired state of FileWatch",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"watchedPaths": {
						SchemaProps: spec.SchemaProps{
							Description: "WatchedPaths are paths of directories or files to watch for changes to. It cannot be empty.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"ignores": {
						SchemaProps: spec.SchemaProps{
							Description: "Ignores are optional rules to filter out a subset of changes matched by WatchedPaths.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.IgnoreDef"),
									},
								},
							},
						},
					},
					"disableSource": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies how to disable this.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableSource"),
						},
					},
				},
				Required: []string{"watchedPaths"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableSource", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.IgnoreDef"},
	}
}

func schema_pkg_apis_core_v1alpha1_FileWatchStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FileWatchStatus defines the observed state of FileWatch",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"monitorStartTime": {
						SchemaProps: spec.SchemaProps{
							Description: "MonitorStartTime is the timestamp of when filesystem monitor was started. It is zero if the monitor has not been started yet.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"lastEventTime": {
						SchemaProps: spec.SchemaProps{
							Description: "LastEventTime is the timestamp of the most recent file event. It is zero if no events have been seen yet.\n\nIf the specifics of which files changed are not important, this field can be used as a watermark without needing to inspect FileEvents.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"fileEvents": {
						SchemaProps: spec.SchemaProps{
							Description: "FileEvents summarizes batches of file changes (create, modify, or delete) that have been seen in ascending chronological order. Only the most recent 20 events are included.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.FileEvent"),
									},
								},
							},
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error is set if there is a problem with the filesystem watch. If non-empty, consumers should assume that no filesystem events will be seen and that the file watcher is in a failed state.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"disableStatus": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about whether/why this is disabled.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableStatus", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.FileEvent", "k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_Forward(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Forward defines a port forward to execute on a given pod.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"localPort": {
						SchemaProps: spec.SchemaProps{
							Description: "The port to expose on the current machine.\n\nIf not specified (or 0), a random free port will be chosen and can be discovered via the status once established.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"containerPort": {
						SchemaProps: spec.SchemaProps{
							Description: "The port on the Kubernetes pod to connect to. Required.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"host": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional host to bind to on the current machine.\n\nIf not explicitly specified, uses the bind host of the tilt web UI (usually localhost).",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name to identify this port forward.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path to include as part of generated links for port forward.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"containerPort"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ForwardStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"localPort": {
						SchemaProps: spec.SchemaProps{
							Description: "LocalPort is the port bound to on the system running Tilt.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"containerPort": {
						SchemaProps: spec.SchemaProps{
							Description: "ContainerPort is the port in the container being forwarded.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"addresses": {
						SchemaProps: spec.SchemaProps{
							Description: "Addresses that the forwarder is bound to.\n\nFor example, a `localhost` host will bind to 127.0.0.1 and [::1].",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "StartedAt is the time at which the forward was initiated.\n\nIf the forwarder is not running yet, this will be zero/empty.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error is a human-readable description if a problem was encountered while initializing the forward.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"localPort", "containerPort", "addresses"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_HTTPGetAction(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HTTPGetAction describes an action based on HTTP Get requests.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path to access on the HTTP server.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "Name or number of the port to access on the container. Number must be in the range 1 to 65535.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"host": {
						SchemaProps: spec.SchemaProps{
							Description: "Host name to connect to, defaults to the pod IP. You probably want to set \"Host\" in httpHeaders instead.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"scheme": {
						SchemaProps: spec.SchemaProps{
							Description: "Scheme to use for connecting to the host. Defaults to HTTP.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"httpHeaders": {
						SchemaProps: spec.SchemaProps{
							Description: "Custom headers to set in the request. HTTP allows repeated headers.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.HTTPHeader"),
									},
								},
							},
						},
					},
				},
				Required: []string{"port"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.HTTPHeader"},
	}
}

func schema_pkg_apis_core_v1alpha1_HTTPHeader(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HTTPHeader describes a custom header to be used in HTTP probes",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The header field name",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "The header field value",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "value"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_Handler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Handler defines a specific action that should be taken in a probe.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"exec": {
						SchemaProps: spec.SchemaProps{
							Description: "One and only one of the following should be specified. Exec specifies the action to take.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExecAction"),
						},
					},
					"httpGet": {
						SchemaProps: spec.SchemaProps{
							Description: "HTTPGet specifies the http request to perform.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.HTTPGetAction"),
						},
					},
					"tcpSocket": {
						SchemaProps: spec.SchemaProps{
							Description: "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TCPSocketAction"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExecAction", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.HTTPGetAction", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TCPSocketAction"},
	}
}

func schema_pkg_apis_core_v1alpha1_IgnoreDef(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes sets of file paths that the FileWatch should ignore.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"basePath": {
						SchemaProps: spec.SchemaProps{
							Description: "BasePath is the base path for the patterns. It cannot be empty.\n\nIf no patterns are specified, everything under it will be recursively ignored.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"patterns": {
						SchemaProps: spec.SchemaProps{
							Description: "Patterns are dockerignore style rules. Absolute-style patterns will be rooted to the BasePath.\n\nSee https://docs.docker.com/engine/reference/builder/#dockerignore-file.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"basePath"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ImageMap(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageMap expresses the mapping from an image reference to a real, pushed image in an image registry that a container runtime can access.\n\nAnother way to think about the ImageMap is that ImageMapSpec is a mutable image reference (where the image might not exist yet), but ImageMapStatus is an immutable image reference (where, if an image is specified, it always exists).\n\nImageMap does not specify how the image is built or who is responsible for building this. But any API that builds images should produce an ImageMap.\n\nFor example, a builder that builds to a local image registry might create a map from: 'my-apiserver:dev' to 'localhost:5000/my-apiserver:content-based-label'.\n\nImageMap doesn't follow the usual Kubernetes-style API semantics (where the Status is the result of running the Spec). It's closer to a ConfigMap. Though the Status does represent a real runtime result (an image in a registry).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMapSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMapStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMapSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMapStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ImageMapList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageMapList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMap"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMap", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ImageMapOverrideArgs(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageMapArgsOverride defines args to inject when the image is injected. Only applies to types that embed a v1.Container with a Command field.\n\nhttps://pkg.go.dev/k8s.io/api/core/v1#Container",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"args": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of args strings.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"args"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ImageMapOverrideCommand(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageMapCommandOverride defines a command to inject when the image is injected. Only applies to types that embed a v1.Container with a Command field.\n\nhttps://pkg.go.dev/k8s.io/api/core/v1#Container",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"command": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of command strings.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"command"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ImageMapSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageMapSpec defines the desired state of ImageMap",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "A named image reference.\n\nDeployment tools expect this image reference to match an image in the YAML being deployed, and will replace that image reference.\n\nBy default, this selector will match an image if the names match (tags on both the selector and the matched reference are ignored).",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"matchExact": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, then tags on both the selector and the matched reference are used for matching. The selector will only match the reference if the tags match exactly.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"matchInEnvVars": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, then the selector will also match any strings in container env variables.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"overrideCommand": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the injector will replace the 'command' field in the container when it replaces the image.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMapOverrideCommand"),
						},
					},
					"overrideArgs": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the injector will replace the 'args' field in the container when it replaces the image.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMapOverrideArgs"),
						},
					},
				},
				Required: []string{"selector"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMapOverrideArgs", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ImageMapOverrideCommand"},
	}
}

func schema_pkg_apis_core_v1alpha1_ImageMapStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageMapStatus defines the observed state of ImageMap",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "A fully-qualified image reference, including a name and an immutable tag, as seen from the cluster container runtime that we're mapping this image to.\n\nNB: Container images often need to be referenced from different networks, including:\n\n1) The cluster container runtime 2) The local network 3) The cluster network\n\nAnd each of these cases may have distinct URLs. We might deprecate this field and only use fields of the form `ImageFromX`.\n\nFor more details on image references in different networks, see: https://github.com/kubernetes/enhancements/tree/master/keps/sig-cluster-lifecycle/generic/1755-communicating-a-local-registry#specification-for-localregistryhosting-v1",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imageFromLocal": {
						SchemaProps: spec.SchemaProps{
							Description: "A fully-qualified image reference, including a name and an immutable tag, as seen from the local network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imageFromCluster": {
						SchemaProps: spec.SchemaProps{
							Description: "A fully-qualified image reference, including a name and an immutable tag, as seen from the cluster container runtime.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"buildStartTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Timestamp indicating when the image started building.\n\nIntended to be used to determine which file changes were picked up by the image build. We can assume that any file changes before this timestamp were definitely included in the image, and any file changes after this timestamp may not be included in the image.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesApply(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesApply specifies a blob of YAML to apply, and a set of ImageMaps that the YAML depends on.\n\nThe KubernetesApply controller will resolve the ImageMaps into immutable image references. The controller will process the spec YAML, then apply it to the cluster. Those processing steps might include:\n\n- Injecting the resolved image references. - Adding custom labels so that Tilt can track the progress of the apply. - Modifying image pull rules to ensure the image is pulled correctly.\n\nThe controller won't apply anything until all ImageMaps resolve to real images.\n\nThe controller will watch all the image maps, and redeploy the entire YAML if any of the maps resolve to a new image.\n\nThe status field will contain both the raw applied object, and derived fields to help other controllers figure out how to watch the apply progress.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApplySpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApplyStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApplySpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApplyStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesApplyCmd(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"args": {
						SchemaProps: spec.SchemaProps{
							Description: "Args are the command-line arguments for the apply command. Must have length >= 1.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"dir": {
						SchemaProps: spec.SchemaProps{
							Description: "Process working directory.\n\nIf not specified, will default to Tilt working directory.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"env": {
						SchemaProps: spec.SchemaProps{
							Description: "Env are additional variables for the process environment.\n\nEnvironment variables are layered on top of the environment variables that Tilt runs with.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"args"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesApplyList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesApplyList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApply"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApply", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesApplySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesApplySpec defines the desired state of KubernetesApply",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"yaml": {
						SchemaProps: spec.SchemaProps{
							Description: "YAML to apply to the cluster.\n\nExactly one of YAML OR ApplyCmd MUST be provided.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imageMaps": {
						SchemaProps: spec.SchemaProps{
							Description: "Names of image maps that this applier depends on.\n\nThe controller will watch all the image maps, and redeploy the entire YAML if any of the maps resolve to a new image.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"imageLocators": {
						SchemaProps: spec.SchemaProps{
							Description: "Descriptors of how to find images in the YAML.\n\nNeeded when injecting images into CRDs.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesImageLocator"),
									},
								},
							},
						},
					},
					"timeout": {
						SchemaProps: spec.SchemaProps{
							Description: "The timeout on the apply operation.\n\nWe've had problems with both: 1) CRD apiservers that take an arbitrarily long time to apply, and 2) Infinite loops in the apimachinery So we offer the ability to set a timeout on Kubernetes apply operations.\n\nThe default timeout is 30s.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"kubernetesDiscoveryTemplateSpec": {
						SchemaProps: spec.SchemaProps{
							Description: "KubernetesDiscoveryTemplateSpec describes how we discover pods for resources created by this Apply.\n\nIf not specified, the KubernetesDiscovery controller will listen to all pods, and follow owner references to find the pods owned by these resources.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoveryTemplateSpec"),
						},
					},
					"portForwardTemplateSpec": {
						SchemaProps: spec.SchemaProps{
							Description: "PortForwardTemplateSpec describes the data model for port forwards that KubernetesApply should set up.\n\nUnderneath the hood, we'll create a KubernetesDiscovery object that finds the pods and sets up the port-forwarding. Only one PortForward will be active at a time.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForwardTemplateSpec"),
						},
					},
					"podLogStreamTemplateSpec": {
						SchemaProps: spec.SchemaProps{
							Description: "PodLogStreamTemplateSpec describes the data model for PodLogStreams that KubernetesApply should set up.\n\nUnderneath the hood, we'll create a KubernetesDiscovery object that finds the pods and sets up the pod log streams.\n\nIf no template is specified, the controller will stream all pod logs available from the apiserver.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStreamTemplateSpec"),
						},
					},
					"discoveryStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "DiscoveryStrategy describes how we set up pod watches for the applied resources. This affects all systems that attach to pods, including PortForwards, PodLogStreams, resource readiness, and live-updates.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"disableSource": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies how to disable this.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableSource"),
						},
					},
					"applyCmd": {
						SchemaProps: spec.SchemaProps{
							Description: "ApplyCmd is a custom command to execute to deploy entities to the Kubernetes cluster.\n\nThe command must be idempotent, e.g. it must not fail if some or all entities already exist.\n\nThe ApplyCmd MUST return valid Kubernetes YAML for the entities it applied to the cluster.\n\nExactly one of YAML OR ApplyCmd MUST be provided.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApplyCmd"),
						},
					},
					"restartOn": {
						SchemaProps: spec.SchemaProps{
							Description: "RestartOn determines external triggers that will result in an apply.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.RestartOnSpec"),
						},
					},
					"deleteCmd": {
						SchemaProps: spec.SchemaProps{
							Description: "DeleteCmd is a custom command to execute to delete entities created by ApplyCmd and clean up any additional state.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApplyCmd"),
						},
					},
					"cluster": {
						SchemaProps: spec.SchemaProps{
							Description: "Cluster name to determine the Kubernetes cluster.\n\nIf not provided, \"default\" will be used.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableSource", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesApplyCmd", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoveryTemplateSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesImageLocator", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStreamTemplateSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForwardTemplateSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.RestartOnSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesApplyStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesApplyStatus defines the observed state of KubernetesApply",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resultYAML": {
						SchemaProps: spec.SchemaProps{
							Description: "The result of applying the YAML to the cluster. This should contain UIDs for the applied resources.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "An error applying the YAML.\n\nIf there was an error, than ResultYAML should be empty (and vice versa).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastApplyTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Timestamp of we last finished applying this YAML to the cluster.\n\nWhen populated, must be equal or after the LastApplyStartTime field.\n\nis more consistent with how we name this in other API objects.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"lastApplyStartTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Timestamp of when we last started applying this YAML to the cluster.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"appliedInputHash": {
						SchemaProps: spec.SchemaProps{
							Description: "A base64-encoded hash of all the inputs to the apply.\n\nWe added this so that more procedural code can determine whether their updates have been applied yet or not by the reconciler. But any code using it this way should note that the reconciler may \"skip\" an update (e.g., if two images get updated in quick succession before the reconciler injects them into the YAML), so a particular ApplieInputHash might never appear.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"disableStatus": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about whether/why this is disabled.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableStatus"),
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions based on the result of the apply.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.Condition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.Condition", "k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesClusterConnection(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"context": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the kubeconfig context to use.\n\nIf not specified, will use the default context in the kubeconfig.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "The default namespace to use.\n\nIf not specified, will use the namespace in the kubeconfig.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesClusterConnectionStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Kubernetes-specific fields for connection status",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"context": {
						SchemaProps: spec.SchemaProps{
							Description: "The resolved kubeconfig context.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "The resolved default namespace.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cluster": {
						SchemaProps: spec.SchemaProps{
							Description: "The resolved cluster name (as determined by the kubeconfig context).",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"product": {
						SchemaProps: spec.SchemaProps{
							Description: "The product name for this cluster.\n\nFor a complete list of possible product names, see: https://pkg.go.dev/github.com/tilt-dev/clusterid#Product",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"configPath": {
						SchemaProps: spec.SchemaProps{
							Description: "The resolved config path.\n\nTilt will freeze the config and write it to a temporary directory. Subprocesses that depend on this cluster can find this file by reading the KUBECONFIG env var.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"context", "namespace", "cluster"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesDiscovery",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoverySpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoveryStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoverySpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoveryStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesDiscoveryList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesDiscoveryList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscovery"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscovery", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesDiscoverySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesDiscoverySpec defines the desired state of KubernetesDiscovery",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"watches": {
						SchemaProps: spec.SchemaProps{
							Description: "Watches determine what resources are discovered.\n\nIf a discovered resource (e.g. Pod) matches the KubernetesWatchRef UID exactly, it will be reported. If a discovered resource is transitively owned by the KubernetesWatchRef UID, it will be reported.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesWatchRef"),
									},
								},
							},
						},
					},
					"extraSelectors": {
						SchemaProps: spec.SchemaProps{
							Description: "ExtraSelectors are label selectors that will force discovery of a Pod even if it does not match the AncestorUID.\n\nThis should only be necessary in the event that a CRD creates Pods but does not set an owner reference to itself.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
									},
								},
							},
						},
					},
					"portForwardTemplateSpec": {
						SchemaProps: spec.SchemaProps{
							Description: "PortForwardTemplateSpec describes the data model for port forwards that KubernetesDiscovery should set up.\n\nThe KubernetesDiscovery controller will choose a \"best\" candidate for attaching the port-forwarding. Only one PortForward will be active at a time.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForwardTemplateSpec"),
						},
					},
					"podLogStreamTemplateSpec": {
						SchemaProps: spec.SchemaProps{
							Description: "PodLogStreamTemplateSpec describes the data model for PodLogStreams that KubernetesDiscovery should set up.\n\nThe KubernetesDiscovery controller will attach PodLogStream objects to all active pods it discovers.\n\nIf no template is specified, the controller will stream all pod logs available from the apiserver.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStreamTemplateSpec"),
						},
					},
					"cluster": {
						SchemaProps: spec.SchemaProps{
							Description: "Cluster name to determine the Kubernetes cluster.\n\nIf not provided, \"default\" will be used.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"watches"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesWatchRef", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStreamTemplateSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForwardTemplateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesDiscoveryStateRunning(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "StartTime is when Kubernetes resource discovery began.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
				},
				Required: []string{"startTime"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesDiscoveryStateWaiting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason the monitor has not yet been started.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"reason"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesDiscoveryStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesDiscoveryStatus defines the observed state of KubernetesDiscovery",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"monitorStartTime": {
						SchemaProps: spec.SchemaProps{
							Description: "MonitorStartTime is the timestamp of when Kubernetes resource discovery was started.\n\nIt is zero if discovery has not been started yet.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "Pods that have been discovered based on the criteria in the spec.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Pod"),
									},
								},
							},
						},
					},
					"waiting": {
						SchemaProps: spec.SchemaProps{
							Description: "Waiting contains information about why the monitor has not started.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoveryStateWaiting"),
						},
					},
					"running": {
						SchemaProps: spec.SchemaProps{
							Description: "Running contains information about the currently running monitor.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoveryStateRunning"),
						},
					},
				},
				Required: []string{"pods"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoveryStateRunning", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesDiscoveryStateWaiting", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Pod", "k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesDiscoveryTemplateSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"extraSelectors": {
						SchemaProps: spec.SchemaProps{
							Description: "ExtraSelectors are label selectors that will force discovery of a Pod even if it does not match the AncestorUID.\n\nThis should only be necessary in the event that a CRD creates Pods but does not set an owner reference to itself.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesImageLocator(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Finds image references in Kubernetes YAML.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects which objects to look in.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ObjectSelector"),
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "A JSON path to the image reference field.\n\nIf Object is empty, the field should be a string.\n\nIf Object is non-empty, the field should be an object with subfields.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "A descriptor of the path and structure of an object that describes an image reference. This is a common way to describe images in CRDs, breaking them down into an object rather than an image reference string.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesImageObjectDescriptor"),
						},
					},
				},
				Required: []string{"objectSelector", "path"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.KubernetesImageObjectDescriptor", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ObjectSelector"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesImageObjectDescriptor(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"repoField": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the field that contains the image repository.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"tagField": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the field that contains the image tag.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"repoField", "tagField"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesWatchRef(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesWatchRef is similar to v1.ObjectReference from the Kubernetes API and is used to determine what objects should be reported on based on discovery.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID is a Kubernetes object UID.\n\nIt should either be the exact object UID or the transitive owner.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace is the Kubernetes namespace for discovery. Required.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the Kubernetes object name.\n\nThis is not directly used in discovery; it is extra metadata.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"namespace"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_LiveUpdate(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LiveUpdate",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_LiveUpdateContainerStateWaiting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "One word camel-case reason why we're in a waiting state.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human-readable description of what's blocking.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_LiveUpdateContainerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LiveUpdateContainerStatus defines the observed state of the live-update syncer for a particular container.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"containerName": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the container in the pod.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"containerID": {
						SchemaProps: spec.SchemaProps{
							Description: "The ID of the container in the pod, in the format 'docker://<container_id>'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podName": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the pod this container belongs to.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "The namespace of the pod this container belongs to.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastFileTimeSynced": {
						SchemaProps: spec.SchemaProps{
							Description: "The timestamp of the most recent file update successfully synced to the container.\n\nMust match the timestamp in a FileEvent, not the time the sync was performed.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"lastExecError": {
						SchemaProps: spec.SchemaProps{
							Description: "Contains any error messages from the most recent sequence of Execs.\n\nEmpty if the most recent Execs completed successfully.\n\nAn ExecError is not necessarily a failure state. For example, a linter error in the container is something we'd want to surface to the user, but not an indication that the live-updater did something wrong.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"waiting": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a waiting live update.\n\nA live update is waiting when the reconciler is aware of file changes that need to be synced to the container, but has decided not to sync them yet.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateContainerStateWaiting"),
						},
					},
				},
				Required: []string{"containerName", "podName", "namespace"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateContainerStateWaiting", "k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_LiveUpdateDockerComposeSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Specifies how to select containers to live update inside Docker Compose.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"service": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of a DockerComposeService object.\n\nFor simple projects, this is usually the same as the service name in the docker-compose.yml file. (But it doesn't necessarily have to be.)",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"service"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_LiveUpdateExec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Runs a remote command after files have been synced to the container. Commonly used for small in-container changes (like moving files around, or restart processes).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"args": {
						SchemaProps: spec.SchemaProps{
							Description: "Command-line arguments to run inside the container. Must have length at least 1.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"triggerPaths": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of relative paths that trigger this command exec.\n\nIf not specified, all file changes seen by the LiveUpdate trigger this exec.\n\nPaths are specified relative to the the BasePath of the LiveUpdate.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"args"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_LiveUpdateKubernetesSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Specifies how to select containers to live update inside K8s.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"discoveryName": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of a KubernetesDiscovery object for finding pods.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"applyName": {
						SchemaProps: spec.SchemaProps{
							Description: "ApplyName is the name of a KubernetesApply object for filtering discovered pods to prevent updating old deployments.\n\nIf not provided, no filtering will be applied and all discovered Pods will be eligible for update.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "Image specifies the name of the image that we're copying files into.\n\nDetermines which containers in a pod to live-update. Matches images by name unless tag is explicitly specified.\n\nExactly one of Image, ContainerName, or ImageMapName MUST be specified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"containerName": {
						SchemaProps: spec.SchemaProps{
							Description: "ContainerName specifies the name of the container that we're copying files into.\n\nExactly one of Image, ContainerName, or ImageMapName MUST be specified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imageMapName": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageMapName specifies the name of an ImageMapName object to use for determining the image we're copying files into.\n\nExactly one of Image, ContainerName, or ImageMapName MUST be specified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"discoveryName"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_LiveUpdateList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LiveUpdateList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdate"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdate", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_LiveUpdateSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Specifies how to select containers to live update.\n\nEvery live update must be associated with some object for finding containers. In the future, we expect there to be other types of container discovery objects (like Docker Compose container discovery).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kubernetes": {
						SchemaProps: spec.SchemaProps{
							Description: "Finds containers in Kubernetes.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateKubernetesSelector"),
						},
					},
					"dockerCompose": {
						SchemaProps: spec.SchemaProps{
							Description: "Finds containers in Docker Compose.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateDockerComposeSelector"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateDockerComposeSelector", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateKubernetesSelector"},
	}
}

func schema_pkg_apis_core_v1alpha1_LiveUpdateSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Specifies how to pull in files.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"fileWatch": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of a FileWatch to use as a file source.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imageMap": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the ImageMap object to watch for which file changes from this source are included in the container image.\n\nIf not provided, the live-updater will copy any file changes that it's aware of, even if they're already included in the container.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_LiveUpdateSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LiveUpdateSpec defines the desired state of LiveUpdate",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"basePath": {
						SchemaProps: spec.SchemaProps{
							Description: "An absolute local path that serves as the basis for all path calculations.\n\nRelative paths in this object are calculated relative to the base path. It cannot be empty.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies how this live-updater finds the containers that need live update.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateSelector"),
						},
					},
					"sources": {
						SchemaProps: spec.SchemaProps{
							Description: "Sources of files to sync.\n\nEvery live update must be associated with at least one Source object to trigger the update. Usually, Tilt structures it so that there's a Source for each image we depend on.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateSource"),
									},
								},
							},
						},
					},
					"stopPaths": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of relative paths that will immediately stop the live-update for the current container.\n\nUsed to detect file changes that invalidate the entire container image, forcing a complete rebuild.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"syncs": {
						SchemaProps: spec.SchemaProps{
							Description: "Specify paths that can be live-updated into the container and their destinations. Any file changes observed that do not match any of these will invalidate the container image and force a complete rebuild.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateSync"),
									},
								},
							},
						},
					},
					"execs": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of commands to run inside the container after files are synced.\n\nNB: In some documentation, we call these 'runs'. 'exec' more clearly matches kubectl exec for remote commands.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateExec"),
									},
								},
							},
						},
					},
					"restart": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies whether Tilt should try to natively restart the container in-place after syncs and execs.\n\nNote that native restarts are only supported by Docker and Docker Compose (and NOT docker-shim or containerd, the most common Kubernetes runtimes).\n\nTo restart on live-update in Kubernetes, see the guide for how to apply extensions to add restart behavior:\n\nhttps://docs.tilt.dev/live_update_reference.html",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"basePath", "selector"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateExec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateSelector", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateSource", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateSync"},
	}
}

func schema_pkg_apis_core_v1alpha1_LiveUpdateStateFailed(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "If any of the containers are currently failing to process updates, the LiveUpdateStateFailed surfaces information about what's happening and what the live-updater is doing to fix the problem.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "One word camel-case reason why we've reached a failure state.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human-readable description of what's wrong.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "When the live-updater transitioned into a Failed state.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_LiveUpdateStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LiveUpdateStatus defines the observed state of LiveUpdate",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"containers": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of all containers that the live-updater is currently connected to.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateContainerStatus"),
									},
								},
							},
						},
					},
					"failed": {
						SchemaProps: spec.SchemaProps{
							Description: "If any of the containers are currently failing to process updates, the Failed state surfaces information about what's happening and what the live-updater is doing to fix the problem.\n\nIf all containers are updating successfully, Failed will be nil.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateStateFailed"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateContainerStatus", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.LiveUpdateStateFailed"},
	}
}

func schema_pkg_apis_core_v1alpha1_LiveUpdateSync(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Determines how a local path maps into a container image.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"localPath": {
						SchemaProps: spec.SchemaProps{
							Description: "A relative path to local files. Required.\n\nComputed relative to the live-update BasePath.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"containerPath": {
						SchemaProps: spec.SchemaProps{
							Description: "An absolute path inside the container. Required.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"localPath", "containerPath"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ObjectSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Selector for any Kubernetes-style API.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiVersionRegexp": {
						SchemaProps: spec.SchemaProps{
							Description: "A regular expression apiVersion match.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kindRegexp": {
						SchemaProps: spec.SchemaProps{
							Description: "A regular expression kind match.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nameRegexp": {
						SchemaProps: spec.SchemaProps{
							Description: "A regular expression name match.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespaceRegexp": {
						SchemaProps: spec.SchemaProps{
							Description: "A regular expression namespace match.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_Pod(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Pod is a collection of containers that can run on a host.\n\nThe Tilt API representation mirrors the Kubernetes API very closely. Irrelevant data is not included, and some fields might be simplified.\n\nThere might also be Tilt-specific status fields.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID is the unique Pod UID within the K8s cluster.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the Pod name within the K8s cluster.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace is the Pod namespace within the K8s cluster.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"createdAt": {
						SchemaProps: spec.SchemaProps{
							Description: "CreatedAt is when the Pod was created.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Phase is where the Pod is at in its current lifecycle.\n\nValid values for this are v1.PodPhase values from the Kubernetes API.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"deleting": {
						SchemaProps: spec.SchemaProps{
							Description: "Deleting indicates that the Pod is in the process of being removed.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions are various lifecycle conditions for this Pod.\n\nSee also v1.PodCondition in the Kubernetes API.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodCondition"),
									},
								},
							},
						},
					},
					"initContainers": {
						SchemaProps: spec.SchemaProps{
							Description: "InitContainers are containers executed prior to the Pod containers being executed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Container"),
									},
								},
							},
						},
					},
					"containers": {
						SchemaProps: spec.SchemaProps{
							Description: "Containers are the containers belonging to the Pod.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Container"),
									},
								},
							},
						},
					},
					"ancestorUID": {
						SchemaProps: spec.SchemaProps{
							Description: "AncestorUID is the UID from the WatchRef that matched this Pod.\n\nIf the Pod matched based on extra label selectors, this will be empty.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podTemplateSpecHash": {
						SchemaProps: spec.SchemaProps{
							Description: "PodTemplateSpecHash is a hash of the Pod template spec.\n\nTilt uses this to associate Pods with the build that triggered them.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is a concise description for the Pod's current state.\n\nThis is based off the status output from `kubectl get pod` and is not an \"enum-like\" value.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"errors": {
						SchemaProps: spec.SchemaProps{
							Description: "Errors are aggregated error messages for the Pod and its containers.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"owner": {
						SchemaProps: spec.SchemaProps{
							Description: "Direct owner of this pod, if available.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodOwner"),
						},
					},
				},
				Required: []string{"uid", "name", "namespace", "createdAt", "phase", "deleting", "containers", "status", "errors"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Container", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodCondition", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodOwner", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_PodCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodCondition is a lifecycle condition for a Pod.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of condition.\n\nValid values for this are v1.PodConditionType values from the Kubernetes API.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current state of the condition (True, False, or Unknown).\n\nValid values for this are v1.PodConditionStatus values from the Kubernetes API.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "LastTransitionTime is the last time the status changed.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason is a unique, one-word, CamelCase value for the cause of the last status change.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Message is a human-readable description of the last status change.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_PodLogStream(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodLogStream\n\nStreams logs from a pod on Kubernetes into the core Tilt engine.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStreamSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStreamStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStreamSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStreamStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_PodLogStreamList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodLogStreamList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStream"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PodLogStream", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_PodLogStreamSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodLogStreamSpec defines the desired state of PodLogStream\n\nTranslated into a PodLog query to the current Kubernetes cluster: https://pkg.go.dev/k8s.io/api/core/v1#PodLogOptions\n\nwhich Kubernetes context to use?",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"pod": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the pod to watch. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "The namespace of the pod to watch. Defaults to the kubecontext default namespace.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"sinceTime": {
						SchemaProps: spec.SchemaProps{
							Description: "An RFC3339 timestamp from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned.\n\nTranslates directly to the underlying PodLogOptions.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"onlyContainers": {
						SchemaProps: spec.SchemaProps{
							Description: "The names of containers to include in the stream.\n\nIf `onlyContainers` and `ignoreContainers` are not set, will watch all containers in the pod.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"ignoreContainers": {
						SchemaProps: spec.SchemaProps{
							Description: "The names of containers to exclude from the stream.\n\nIf `onlyContainers` and `ignoreContainers` are not set, will watch all containers in the pod.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"cluster": {
						SchemaProps: spec.SchemaProps{
							Description: "Cluster the Pod belongs to.\n\nIf not provided, \"default\" will be used.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_PodLogStreamStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodLogStreamStatus defines the observed state of PodLogStream",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"containerStatuses": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of containers being watched.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerLogStreamStatus"),
									},
								},
							},
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error message encountered while setting up the stream.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ContainerLogStreamStatus"},
	}
}

func schema_pkg_apis_core_v1alpha1_PodLogStreamTemplateSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodLogStreamTemplateSpec describes common attributes for PodLogStreams that can be shared across pods.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"sinceTime": {
						SchemaProps: spec.SchemaProps{
							Description: "An RFC3339 timestamp from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned.\n\nTranslates directly to the underlying PodLogOptions.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"onlyContainers": {
						SchemaProps: spec.SchemaProps{
							Description: "The names of containers to include in the stream.\n\nIf `onlyContainers` and `ignoreContainers` are not set, will watch all containers in the pod.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"ignoreContainers": {
						SchemaProps: spec.SchemaProps{
							Description: "The names of containers to exclude from the stream.\n\nIf `onlyContainers` and `ignoreContainers` are not set, will watch all containers in the pod.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_PodOwner(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodOwner contains information of the direct owner of the pod, if available.\n\nTools that need to select a most relevant pod or set of pods can use this info to group pods by owner.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the owner.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the owner.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the owner More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"creationTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "The creation timestamp of the owner.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
				},
				Required: []string{"name", "apiVersion", "kind"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_PortForward(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PortForward",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForwardSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForwardStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForwardSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForwardStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_PortForwardList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PortForwardList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForward"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.PortForward", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_PortForwardSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PortForwardSpec defines the desired state of PortForward",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"podName": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the pod to port forward to/from. Required.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "The namespace of the pod to port forward to/from. Defaults to the kubecontext default namespace.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"forwards": {
						SchemaProps: spec.SchemaProps{
							Description: "One or more port forwards to execute on the given pod. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Forward"),
									},
								},
							},
						},
					},
					"cluster": {
						SchemaProps: spec.SchemaProps{
							Description: "Cluster to forward ports from to the local machine.\n\nIf not specified, the default Kubernetes cluster will be used.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"podName", "forwards"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Forward"},
	}
}

func schema_pkg_apis_core_v1alpha1_PortForwardStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PortForwardStatus defines the observed state of PortForward",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"forwardStatuses": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ForwardStatus"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ForwardStatus"},
	}
}

func schema_pkg_apis_core_v1alpha1_PortForwardTemplateSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PortForwardTemplateSpec describes common attributes for PortForwards that can be shared across pods.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"forwards": {
						SchemaProps: spec.SchemaProps{
							Description: "One or more port forwards to execute on the given pod. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Forward"),
									},
								},
							},
						},
					},
				},
				Required: []string{"forwards"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Forward"},
	}
}

func schema_pkg_apis_core_v1alpha1_Probe(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Probe describes a health check to be performed to determine whether it is alive or ready to receive traffic.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"exec": {
						SchemaProps: spec.SchemaProps{
							Description: "One and only one of the following should be specified. Exec specifies the action to take.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExecAction"),
						},
					},
					"httpGet": {
						SchemaProps: spec.SchemaProps{
							Description: "HTTPGet specifies the http request to perform.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.HTTPGetAction"),
						},
					},
					"tcpSocket": {
						SchemaProps: spec.SchemaProps{
							Description: "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TCPSocketAction"),
						},
					},
					"initialDelaySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"periodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"successThreshold": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"failureThreshold": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ExecAction", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.HTTPGetAction", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TCPSocketAction"},
	}
}

func schema_pkg_apis_core_v1alpha1_RegistryHosting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"host": {
						SchemaProps: spec.SchemaProps{
							Description: "Host documents the host (hostname and port) of the registry, as seen from outside the cluster.\n\nThis is the registry host that tools outside the cluster should push images to.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostFromClusterNetwork": {
						SchemaProps: spec.SchemaProps{
							Description: "HostFromClusterNetwork documents the host (hostname and port) of the registry, as seen from networking inside the container pods.\n\nThis is the registry host that tools running on pods inside the cluster should push images to. If not set, then tools inside the cluster should assume the local registry is not available to them.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostFromContainerRuntime": {
						SchemaProps: spec.SchemaProps{
							Description: "HostFromContainerRuntime documents the host (hostname and port) of the registry, as seen from the cluster's container runtime.\n\nWhen tools apply Kubernetes objects to the cluster, this host should be used for image name fields. If not set, users of this field should use the value of Host instead.\n\nNote that it doesn't make sense semantically to define this field, but not define Host or HostFromClusterNetwork. That would imply a way to pull images without a way to push images.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"help": {
						SchemaProps: spec.SchemaProps{
							Description: "Help contains a URL pointing to documentation for users on how to set up and configure a local registry.\n\nTools can use this to nudge users to enable the registry. When possible, the writer should use as permanent a URL as possible to prevent drift (e.g., a version control SHA).\n\nWhen image pushes to a registry host specified in one of the other fields fail, the tool should display this help URL to the user. The help URL should contain instructions on how to diagnose broken or misconfigured registries.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"singleName": {
						SchemaProps: spec.SchemaProps{
							Description: "SingleName uses a shared image name for _all_ Tilt-built images and relies on tags to distinguish between logically distinct images.\n\nThis is most commonly used with Amazon Elastic Container Registry (ECR), which works differently than other image registries.\n\nAn ECR host takes the form https://aws_account_id.dkr.ecr.region.amazonaws.com. Each image name in that registry must be pre-created ಠ_ಠ and assigned IAM permissions. For example: https://aws_account_id.dkr.ecr.region.amazonaws.com/my-repo (They call this a repo).\n\nFor this reason, some users using ECR prefer to push all images to a single image name (ECR repo).\n\nA recommended pattern here is to create a \"personal\" image repo for each user during development.\n\nSee: https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html https://github.com/tilt-dev/tilt/issues/2419",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"host"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_RestartOnSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RestartOnSpec indicates the set of objects that can trigger a restart of this object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"fileWatches": {
						SchemaProps: spec.SchemaProps{
							Description: "FileWatches that can trigger a restart.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"uiButtons": {
						SchemaProps: spec.SchemaProps{
							Description: "UIButtons that can trigger a restart.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_Session(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Session provides introspective data about the status of the Tilt process.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.SessionSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.SessionStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.SessionSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.SessionStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_SessionCISpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"k8sGracePeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "Grace period given for Kubernetes resources to recover after they start failing.\n\nIf omitted, and in exitCondition=ci, the session will exit as soon as we see a pod failure.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"timeout": {
						SchemaProps: spec.SchemaProps{
							Description: "Timeout for the whole CI pipeline. Defaults to 30m.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1alpha1_SessionList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SessionList is a list of Session objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Session"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Session", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_SessionSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SessionSpec defines the desired state of Session",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"tiltfilePath": {
						SchemaProps: spec.SchemaProps{
							Description: "TiltfilePath is the path to the Tiltfile for the run. It cannot be empty.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"exitCondition": {
						SchemaProps: spec.SchemaProps{
							Description: "ExitCondition defines the criteria for Tilt to exit.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ci": {
						SchemaProps: spec.SchemaProps{
							Description: "Additional settings when in exitCondition=CI.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.SessionCISpec"),
						},
					},
				},
				Required: []string{"tiltfilePath", "exitCondition"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.SessionCISpec"},
	}
}

func schema_pkg_apis_core_v1alpha1_SessionStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SessionStatus defines the observed state of Session",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"pid": {
						SchemaProps: spec.SchemaProps{
							Description: "PID is the process identifier for this instance of Tilt.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "StartTime is when the Tilt engine was first started.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"targets": {
						SchemaProps: spec.SchemaProps{
							Description: "Targets are normalized representations of the servers/jobs managed by this Session.\n\nA resource from a Tiltfile might produce one or more targets. A target can also be shared across multiple resources (e.g. an image referenced by multiple K8s pods).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Target"),
									},
								},
							},
						},
					},
					"done": {
						SchemaProps: spec.SchemaProps{
							Description: "Done indicates whether this Session has completed its work and is ready to exit.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error is a non-empty string when the Session is Done but encountered a failure as defined by the ExitCondition from the SessionSpec.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"pid", "startTime", "targets", "done"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Target", "k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_StartOnSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StartOnSpec indicates the set of objects that can trigger a start/restart of this object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"startAfter": {
						SchemaProps: spec.SchemaProps{
							Description: "StartAfter indicates that events before this time should be ignored.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"uiButtons": {
						SchemaProps: spec.SchemaProps{
							Description: "UIButtons that can trigger a start/restart.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"uiButtons"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_StateSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes where a ToggleButton's state is stored. Exactly one type of source must be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"configMap": {
						SchemaProps: spec.SchemaProps{
							Description: "State is stored in a ConfigMap.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ConfigMapStateSource"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ConfigMapStateSource"},
	}
}

func schema_pkg_apis_core_v1alpha1_StopOnSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"uiButtons": {
						SchemaProps: spec.SchemaProps{
							Description: "UIButtons that can trigger a stop.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"uiButtons"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_TCPSocketAction(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TCPSocketAction describes an action based on opening a socket",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "Number or name of the port to access on the container. Number must be in the range 1 to 65535.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"host": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Host name to connect to, defaults to the pod IP.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"port"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_Target(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Target is a server or job whose execution is managed as part of this Session.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the target; this is auto-generated from Tiltfile resources.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the execution profile for this resource.\n\nJob targets run to completion (e.g. a build script or database migration script). Server targets run indefinitely (e.g. an HTTP server).",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources are one or more Tiltfile resources that this target is associated with.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"state": {
						SchemaProps: spec.SchemaProps{
							Description: "State provides information about the current status of the target.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetState"),
						},
					},
				},
				Required: []string{"name", "type", "resources", "state"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetState"},
	}
}

func schema_pkg_apis_core_v1alpha1_TargetState(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TargetState describes the current execution status for a target.\n\nEither EXACTLY one of Waiting, Active, Disabled, or Terminated will be populated or NONE of them will be. In the event that all states are null, the target is currently inactive or disabled and should not be expected to execute.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"waiting": {
						SchemaProps: spec.SchemaProps{
							Description: "Waiting being non-nil indicates that the next execution of the target has been queued but not yet started.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetStateWaiting"),
						},
					},
					"active": {
						SchemaProps: spec.SchemaProps{
							Description: "Active being non-nil indicates that the target is currently executing.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetStateActive"),
						},
					},
					"terminated": {
						SchemaProps: spec.SchemaProps{
							Description: "Terminated being non-nil indicates that the target finished execution either normally or due to failure.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetStateTerminated"),
						},
					},
					"disabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Disabled being non-nil indicates that the target is disabled.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetStateDisabled"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetStateActive", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetStateDisabled", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetStateTerminated", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TargetStateWaiting"},
	}
}

func schema_pkg_apis_core_v1alpha1_TargetStateActive(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TargetStateActive is a target that is currently running but has not yet finished.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "StartTime is when execution began.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"ready": {
						SchemaProps: spec.SchemaProps{
							Description: "Ready indicates that the target has passed readiness checks.\n\nIf the target does not use or support readiness checks, this is always true.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"startTime", "ready"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_TargetStateDisabled(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TargetStateDisabled is a target that has been disabled.",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_TargetStateTerminated(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TargetStateTerminated is a target that finished running, either because it completed successfully or encountered an error.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "StartTime is when the target began executing.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"finishTime": {
						SchemaProps: spec.SchemaProps{
							Description: "FinishTime is when the target stopped executing.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error is a non-empty string if the target encountered a failure during execution that caused it to stop.\n\nFor targets of type TargetTypeServer, this is always populated, as the target is expected to run indefinitely, and thus any termination is an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"graceStatus": {
						SchemaProps: spec.SchemaProps{
							Description: "Errors may be tolerated if the target is still within a grace period set on the session.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"startTime", "finishTime"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_TargetStateWaiting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TargetStateWaiting is a target that has been enqueued for execution but has not yet started.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"waitReason": {
						SchemaProps: spec.SchemaProps{
							Description: "WaitReason is a description for why the target is waiting and not yet active.\n\nThis is NOT the \"cause\" or \"trigger\" for the target being invoked.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"waitReason"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_TiltBuild(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Information about the running tilt binary.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "A semantic version string.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"commitSHA": {
						SchemaProps: spec.SchemaProps{
							Description: "The Git digest of the commit this binary was built at.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"date": {
						SchemaProps: spec.SchemaProps{
							Description: "A human-readable string representing when the binary was built.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dev": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates whether this is a development build (true) or an official release (false).",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_Tiltfile(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Tiltfile is the main way users add services to Tilt.\n\nThe Tiltfile evaluator executes the Tiltfile, then adds all the objects it creates as children of the Tiltfile object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_TiltfileList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TiltfileList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Tiltfile"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.Tiltfile", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_TiltfileSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TiltfileSpec defines the desired state of Tiltfile",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "The path to the Tiltfile on disk.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"labels": {
						SchemaProps: spec.SchemaProps{
							Description: "A set of labels to apply to all objects owned by this Tiltfile.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"restartOn": {
						SchemaProps: spec.SchemaProps{
							Description: "Objects that can trigger a re-execution of this Tiltfile.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.RestartOnSpec"),
						},
					},
					"args": {
						SchemaProps: spec.SchemaProps{
							Description: "Arguments to the Tiltfile.\n\nArguments can be positional (['a', 'b', 'c']) or flag-based ('--to-edit=a'). By default, a list of arguments indicates the list of services in the tiltfile that should be enabled.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"stopOn": {
						SchemaProps: spec.SchemaProps{
							Description: "Objects that can stop execution of this Tiltfile.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.StopOnSpec"),
						},
					},
				},
				Required: []string{"path"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.RestartOnSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.StopOnSpec"},
	}
}

func schema_pkg_apis_core_v1alpha1_TiltfileStateRunning(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TiltfileStateRunning is a running state of a tiltfile execution.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reasons": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason why this tiltfile was built. May contain more than one reason.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which previous execution of the command started.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_TiltfileStateTerminated(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TiltfileStateTerminated is a terminated state of a tiltfile execution.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reasons": {
						SchemaProps: spec.SchemaProps{
							Description: "The reasons why this tiltfile was built. May contain more than one reason.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error message if this tiltfile execution failed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which previous execution of the command started.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"finishedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which the command last terminated.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"warningCount": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of warnings generated by this Tiltfile. (brief) reason the process is terminated",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_TiltfileStateWaiting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TiltfileStateWaiting is a waiting state of a tiltfile execution.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason the tiltfile is waiting.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_TiltfileStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TiltfileStatus defines the observed state of Tiltfile",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"waiting": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a waiting tiltfile.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileStateWaiting"),
						},
					},
					"running": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a running tiltfile.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileStateRunning"),
						},
					},
					"terminated": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a terminated tiltfile.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileStateTerminated"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileStateRunning", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileStateTerminated", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltfileStateWaiting"},
	}
}

func schema_pkg_apis_core_v1alpha1_ToggleButton(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ToggleButton",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButtonSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButtonStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButtonSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButtonStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ToggleButtonList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ToggleButtonList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButton"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButton", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ToggleButtonSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ToggleButtonSpec defines the desired state of ToggleButton",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"location": {
						SchemaProps: spec.SchemaProps{
							Description: "Where to display the button",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIComponentLocation"),
						},
					},
					"on": {
						SchemaProps: spec.SchemaProps{
							Description: "Config for the button when it is \"on\"",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButtonStateSpec"),
						},
					},
					"off": {
						SchemaProps: spec.SchemaProps{
							Description: "Config for the button when it is \"off\"",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButtonStateSpec"),
						},
					},
					"defaultOn": {
						SchemaProps: spec.SchemaProps{
							Description: "If `StateSource` does not point at a valid value, the initial button state will be \"on\" or \"off\" depending on this bool",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"stateSource": {
						SchemaProps: spec.SchemaProps{
							Description: "Where the toggle button's state is stored",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.StateSource"),
						},
					},
				},
				Required: []string{"location", "on", "off", "defaultOn", "stateSource"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.StateSource", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.ToggleButtonStateSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIComponentLocation"},
	}
}

func schema_pkg_apis_core_v1alpha1_ToggleButtonStateSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes a state (on/off) of a ToggleButton",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"text": {
						SchemaProps: spec.SchemaProps{
							Description: "Text to appear on the button itself or as hover text (depending on button location).",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"iconName": {
						SchemaProps: spec.SchemaProps{
							Description: "IconName is a Material Icon to appear next to button text or on the button itself (depending on button location).\n\nValid values are icon font ligature names from the Material Icons set. See https://fonts.google.com/icons for the full list of available icons.\n\nIf both IconSVG and IconName are specified, IconSVG will take precedence.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"iconSVG": {
						SchemaProps: spec.SchemaProps{
							Description: "IconSVG is an SVG to use as the icon to appear next to button text or on the button itself (depending on button location).\n\nThis should be an <svg> element scaled for a 24x24 viewport.\n\nIf both IconSVG and IconName are specified, IconSVG will take precedence.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"requiresConfirmation": {
						SchemaProps: spec.SchemaProps{
							Description: "If true, clicking the button in this state requires a second click to confirm.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"text"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ToggleButtonStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ToggleButtonStatus defines the observed state of ToggleButton",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "If healthy, empty. If non-healthy, specifies a problem the ToggleButton encountered",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIBoolInputSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes a boolean checkbox input field attached to a button.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"defaultValue": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether the input is initially true or false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"trueString": {
						SchemaProps: spec.SchemaProps{
							Description: "If the input's value is converted to a string, use this when the value is true. If unspecified, its string value will be `\"true\"`",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"falseString": {
						SchemaProps: spec.SchemaProps{
							Description: "If the input's value is converted to a string, use this when the value is false. If unspecified, its string value will be `\"false\"`",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIBoolInputStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"value": {
						SchemaProps: spec.SchemaProps{
							Default: false,
							Type:    []string{"boolean"},
							Format:  "",
						},
					},
				},
				Required: []string{"value"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIBuildRunning(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIBuildRunning respresents an in-progress build/update in the user interface.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The time when the build started.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"spanID": {
						SchemaProps: spec.SchemaProps{
							Description: "The log span where the build logs are stored in the logstore.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIBuildTerminated(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIBuildRunning respresents a finished build/update in the user interface.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "A non-empty string if the build failed with an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"warnings": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of warnings encountered while running the build. These warnings will also be printed to the build's log.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The time when the build started.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"finishTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The time when the build finished.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"spanID": {
						SchemaProps: spec.SchemaProps{
							Description: "The log span where the build logs are stored in the logstore.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"isCrashRebuild": {
						SchemaProps: spec.SchemaProps{
							Description: "A crash rebuild happens when Tilt live-updated a container, then the pod crashed, wiping out the live-updates. Tilt does a full build+deploy to reset the pod state to what's on disk.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIButton(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIButton",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIButtonSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIButtonStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIButtonSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIButtonStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIButtonList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIButtonList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIButton"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIButton", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIButtonSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIButtonSpec defines the desired state of UIButton",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"location": {
						SchemaProps: spec.SchemaProps{
							Description: "Location associates the button with another component for layout.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIComponentLocation"),
						},
					},
					"text": {
						SchemaProps: spec.SchemaProps{
							Description: "Text to appear on the button itself or as hover text (depending on button location).",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"iconName": {
						SchemaProps: spec.SchemaProps{
							Description: "IconName is a Material Icon to appear next to button text or on the button itself (depending on button location).\n\nValid values are icon font ligature names from the Material Icons set. See https://fonts.google.com/icons for the full list of available icons.\n\nIf both IconSVG and IconName are specified, IconSVG will take precedence.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"iconSVG": {
						SchemaProps: spec.SchemaProps{
							Description: "IconSVG is an SVG to use as the icon to appear next to button text or on the button itself (depending on button location).\n\nThis should be an <svg> element scaled for a 24x24 viewport.\n\nIf both IconSVG and IconName are specified, IconSVG will take precedence.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"disabled": {
						SchemaProps: spec.SchemaProps{
							Description: "If true, the button will be rendered, but with an effect indicating it's disabled. It will also be unclickable.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"requiresConfirmation": {
						SchemaProps: spec.SchemaProps{
							Description: "If true, the UI will require the user to click the button a second time to confirm before taking action",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"inputs": {
						SchemaProps: spec.SchemaProps{
							Description: "Any inputs for this button.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIInputSpec"),
									},
								},
							},
						},
					},
				},
				Required: []string{"location", "text"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIComponentLocation", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIInputSpec"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIButtonStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIButtonStatus defines the observed state of UIButton",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"lastClickedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "LastClickedAt is the timestamp of the last time the button was clicked.\n\nIf the button has never clicked before, this will be the zero-value/null.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"inputs": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of any inputs on this button.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIInputStatus"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIInputStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIChoiceInputSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes a choice dropdown input field attached to a button",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"choices": {
						SchemaProps: spec.SchemaProps{
							Description: "The list of valid values for this field",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIChoiceInputStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"value": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"value"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIComponentLocation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIComponentLocation specifies where to put a UI component.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"componentID": {
						SchemaProps: spec.SchemaProps{
							Description: "ComponentID is the identifier of the parent component to associate this component with.\n\nFor example, this is a resource name if the ComponentType is Resource.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"componentType": {
						SchemaProps: spec.SchemaProps{
							Description: "ComponentType is the type of the parent component.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"componentID", "componentType"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIComponentLocationResource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceName": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"resourceName"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIFeatureFlag(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Configures Tilt to enable non-default features (e.g., experimental or deprecated).\n\nThe Tilt features controlled by this are generally in an unfinished state, and not yet documented.\n\nAs a Tilt user, you don’t need to worry about this unless something else directs you to (e.g., an experimental feature doc, or a conversation with a Tilt contributor).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the flag.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "The value of the flag.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIHiddenInputSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes a hidden input field attached to a button, with a value to pass on any submit.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"value": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"value"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIHiddenInputStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"value": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"value"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIInputSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Defines an Input to render in the UI. If UIButton is analogous to an HTML <form>, UIInput is analogous to an HTML <input>.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of this input. Must be unique within the UIButton.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"label": {
						SchemaProps: spec.SchemaProps{
							Description: "A label to display next to this input in the UI.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"text": {
						SchemaProps: spec.SchemaProps{
							Description: "A Text input that takes a string.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UITextInputSpec"),
						},
					},
					"bool": {
						SchemaProps: spec.SchemaProps{
							Description: "A Bool input that is true or false",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIBoolInputSpec"),
						},
					},
					"hidden": {
						SchemaProps: spec.SchemaProps{
							Description: "An input that has a constant value and does not display to the user",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIHiddenInputSpec"),
						},
					},
					"choice": {
						SchemaProps: spec.SchemaProps{
							Description: "A Choice input that takes a list of strings",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIChoiceInputSpec"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIBoolInputSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIChoiceInputSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIHiddenInputSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UITextInputSpec"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIInputStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "The status corresponding to a UIInputSpec",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the input whose status this is. Must match the `Name` of a corresponding UIInputSpec.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"text": {
						SchemaProps: spec.SchemaProps{
							Description: "The status of the input, if it's text",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UITextInputStatus"),
						},
					},
					"bool": {
						SchemaProps: spec.SchemaProps{
							Description: "The status of the input, if it's a bool",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIBoolInputStatus"),
						},
					},
					"hidden": {
						SchemaProps: spec.SchemaProps{
							Description: "The status of the input, if it's a hidden",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIHiddenInputStatus"),
						},
					},
					"choice": {
						SchemaProps: spec.SchemaProps{
							Description: "The status of the input, if it's a choice",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIChoiceInputStatus"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIBoolInputStatus", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIChoiceInputStatus", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIHiddenInputStatus", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UITextInputStatus"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIResource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIResource represents per-resource status data for rendering the web UI.\n\nTreat this as a legacy data structure that's more intended to make transition easier rather than a robust long-term API.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIResourceCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of UI Resource condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIResourceKubernetes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIResourceKubernetes contains status information specific to Kubernetes.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"podName": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the active pod.\n\nThe active pod tends to be what Tilt defaults to for port-forwards, live-updates, etc.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podCreationTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The creation time of the active pod.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"podUpdateStartTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last update time of the active pod",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"podStatus": {
						SchemaProps: spec.SchemaProps{
							Description: "The status of the active pod.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podStatusMessage": {
						SchemaProps: spec.SchemaProps{
							Description: "Extra error messaging around the current status of the active pod.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"allContainersReady": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether all the containers in the pod are currently healthy and have passed readiness checks.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"podRestarts": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of pod restarts.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"spanID": {
						SchemaProps: spec.SchemaProps{
							Description: "The span where this pod stores its logs in the Tilt logstore.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"displayNames": {
						SchemaProps: spec.SchemaProps{
							Description: "The list of all resources deployed in the Kubernetes deploy for this resource.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIResourceLink(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIResourceLink represents a link assocatiated with a UIResource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"url": {
						SchemaProps: spec.SchemaProps{
							Description: "A URL to link to.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The display label on a URL.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIResourceList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIResourceList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResource"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResource", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIResourceLocal(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIResourceLocal contains status information specific to local commands.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"pid": {
						SchemaProps: spec.SchemaProps{
							Description: "The PID of the actively running local command.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"isTest": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this represents a test job.\n\nDeprecated: Users should use labels for marking services as tests.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIResourceSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIResourceSpec is an empty struct. UIResource is a kludge for making Tilt's internal status readable, not for specifying behavior.",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIResourceStateWaiting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason is a unique, one-word reason for why the UIResource update is pending.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"on": {
						SchemaProps: spec.SchemaProps{
							Description: "HoldingOn is the set of objects blocking this resource from updating.\n\nThese objects might NOT be explicit dependencies of the current resource. For example, if an un-parallelizable resource is updating, all other resources with queued updates will be holding on it with a reason of `waiting-for-local`.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceStateWaitingOnRef"),
									},
								},
							},
						},
					},
				},
				Required: []string{"reason"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceStateWaitingOnRef"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIResourceStateWaitingOnRef(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"group": {
						SchemaProps: spec.SchemaProps{
							Description: "Group for the object type being waited on.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion for the object type being waited on.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the object type being waited on.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the object being waiting on.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"group", "apiVersion", "kind", "name"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UIResourceStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIResourceStatus defines the observed state of UIResource",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"lastDeployTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time this resource was deployed.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"triggerMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Bit mask representing whether this resource is run when: 1) When a file changes 2) When the resource initializes",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"buildHistory": {
						SchemaProps: spec.SchemaProps{
							Description: "Past completed builds.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIBuildTerminated"),
									},
								},
							},
						},
					},
					"currentBuild": {
						SchemaProps: spec.SchemaProps{
							Description: "The currently running build, if any.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIBuildRunning"),
						},
					},
					"pendingBuildSince": {
						SchemaProps: spec.SchemaProps{
							Description: "When the build was put in the pending queue.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"hasPendingChanges": {
						SchemaProps: spec.SchemaProps{
							Description: "True if the build was put in the pending queue due to file changes.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"endpointLinks": {
						SchemaProps: spec.SchemaProps{
							Description: "Links attached to this resource.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceLink"),
									},
								},
							},
						},
					},
					"k8sResourceInfo": {
						SchemaProps: spec.SchemaProps{
							Description: "Extra data about Kubernetes resources.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceKubernetes"),
						},
					},
					"localResourceInfo": {
						SchemaProps: spec.SchemaProps{
							Description: "Extra data about Local resources",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceLocal"),
						},
					},
					"runtimeStatus": {
						SchemaProps: spec.SchemaProps{
							Description: "The RuntimeStatus is a simple, high-level summary of the runtime state of a server.\n\nNot all resources run servers.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updateStatus": {
						SchemaProps: spec.SchemaProps{
							Description: "The UpdateStatus is a simple, high-level summary of any update tasks to bring the resource up-to-date.\n\nIf the resource runs a server, this may include both build tasks and live-update syncing.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"specs": {
						SchemaProps: spec.SchemaProps{
							Description: "Information about all the target specs that this resource summarizes.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceTargetSpec"),
									},
								},
							},
						},
					},
					"queued": {
						SchemaProps: spec.SchemaProps{
							Description: "Queued is a simple indicator of whether the resource is queued for an update.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"order": {
						SchemaProps: spec.SchemaProps{
							Description: "Order expresses the relative order of resources in the UI when they're not otherwise sorted. Lower integers go first. When two resources have the same order, they should be sorted by name.\n\nWhen UIResources are generated from the Tiltfile, we use the order they were added to the Tiltfile for the Order field.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"disableStatus": {
						SchemaProps: spec.SchemaProps{
							Description: "Information about the resource's objects' disabled status.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableResourceStatus"),
						},
					},
					"waiting": {
						SchemaProps: spec.SchemaProps{
							Description: "Waiting provides detail on why the resource is currently blocked from updating.",
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceStateWaiting"),
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a UIResource's current state.\n\nDesigned for compatibility with 'wait' and cross-resource status reporting. https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#typical-status-properties",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceCondition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.DisableResourceStatus", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIBuildRunning", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIBuildTerminated", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceCondition", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceKubernetes", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceLink", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceLocal", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceStateWaiting", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIResourceTargetSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_pkg_apis_core_v1alpha1_UIResourceTargetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UIResourceTargetSpec represents the spec of a build or deploy that a resource summarizes.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"id": {
						SchemaProps: spec.SchemaProps{
							Description: "The ID of the target.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "The type of the target.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hasLiveUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether the target has a live update assocated with it.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UISession(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UISession represents global status data for rendering the web UI.\n\nTreat this as a legacy data structure that's more intended to make transition easier rather than a robust long-term API.\n\nPer-resource status data should be stored in UIResource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UISessionSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UISessionStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UISessionSpec", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UISessionStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_UISessionList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UISessionList",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UISession"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UISession", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_UISessionSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UISessionSpec is an empty struct. UISession is a kludge for making Tilt's internal status readable, not for specifying behavior.",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UISessionStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UISessionStatus defines the observed state of UISession",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"featureFlags": {
						SchemaProps: spec.SchemaProps{
							Description: "FeatureFlags reports a list of experimental features that have been enabled.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIFeatureFlag"),
									},
								},
							},
						},
					},
					"needsAnalyticsNudge": {
						SchemaProps: spec.SchemaProps{
							Description: "NeedsAnalyticsNudge reports whether the UI hasn't opted in or out of analytics, and the UI should nudge them to do so.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"runningTiltBuild": {
						SchemaProps: spec.SchemaProps{
							Description: "RunningTiltBuild reports the currently running version of tilt that this UI is talking to.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltBuild"),
						},
					},
					"suggestedTiltVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "SuggestedTiltVersion tells the UI the recommended version for this user. If the version is different than what's running, the UI may display a prompt to upgrade.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"versionSettings": {
						SchemaProps: spec.SchemaProps{
							Description: "VersionSettings indicates whether version updates have been enabled/disabled from the Tiltfile.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.VersionSettings"),
						},
					},
					"tiltCloudUsername": {
						SchemaProps: spec.SchemaProps{
							Description: "TiltCloudUsername reports the username if the user is signed into TiltCloud.\n\ndeprecated: no longer populated",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"tiltCloudTeamName": {
						SchemaProps: spec.SchemaProps{
							Description: "TiltCloudUsername reports the human-readable team name if the user is signed into TiltCloud and the Tiltfile declares a team.\n\ndeprecated: no longer populated",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"tiltCloudSchemeHost": {
						SchemaProps: spec.SchemaProps{
							Description: "TiltCloudSchemeHost reports the base URL of the Tilt Cloud instance associated with this Tilt process. Usually https://cloud.tilt.dev\n\ndeprecated: no longer populated",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"tiltCloudTeamID": {
						SchemaProps: spec.SchemaProps{
							Description: "TiltCloudTeamID reports the unique team id if the user is signed into TiltCloud and the Tiltfile declares a team.\n\ndeprecated: no longer populated",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fatalError": {
						SchemaProps: spec.SchemaProps{
							Description: "A FatalError is an error that forces Tilt to stop its control loop. The API server will stay up and continue to serve the UI, but no further builds will happen.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"tiltStartTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The time that this instance of tilt started. Clients can use this to determine if the API server has restarted and all the objects need to be refreshed.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"tiltfileKey": {
						SchemaProps: spec.SchemaProps{
							Description: "An identifier for the Tiltfile that is running. Clients can use this to store data associated with a particular project in LocalStorage or other persistent storage.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.TiltBuild", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.UIFeatureFlag", "github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1.VersionSettings", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_UITextInputSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes a text input field attached to a button.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"defaultValue": {
						SchemaProps: spec.SchemaProps{
							Description: "Initial value for this field.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"placeholder": {
						SchemaProps: spec.SchemaProps{
							Description: "A short hint that describes the expected input of this field.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_UITextInputStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "The content of the text input.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"value"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_VersionSettings(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Information about how the Tilt binary handles updates.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"checkUpdates": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether version updates have been enabled/disabled from the Tiltfile.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_APIGroup(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIGroup contains the name, the supported versions, and the preferred version of a group.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the group.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"versions": {
						SchemaProps: spec.SchemaProps{
							Description: "versions are the versions supported in this group.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery"),
									},
								},
							},
						},
					},
					"preferredVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "preferredVersion is the version preferred by the API server, which probably is the storage version.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery"),
						},
					},
					"serverAddressByClientCIDRs": {
						SchemaProps: spec.SchemaProps{
							Description: "a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR"),
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "versions"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery", "k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR"},
	}
}

func schema_pkg_apis_meta_v1_APIGroupList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIGroupList is a list of APIGroup, to allow clients to discover the API at /apis.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groups": {
						SchemaProps: spec.SchemaProps{
							Description: "groups is a list of APIGroup.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.APIGroup"),
									},
								},
							},
						},
					},
				},
				Required: []string{"groups"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.APIGroup"},
	}
}

func schema_pkg_apis_meta_v1_APIResource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIResource specifies the name of a resource and whether it is namespaced.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the plural name of the resource.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"singularName": {
						SchemaProps: spec.SchemaProps{
							Description: "singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespaced": {
						SchemaProps: spec.SchemaProps{
							Description: "namespaced indicates if a resource is namespaced or not.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"group": {
						SchemaProps: spec.SchemaProps{
							Description: "group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource's group)\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verbs": {
						SchemaProps: spec.SchemaProps{
							Description: "verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"shortNames": {
						SchemaProps: spec.SchemaProps{
							Description: "shortNames is a list of suggested short names of the resource.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"categories": {
						SchemaProps: spec.SchemaProps{
							Description: "categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"storageVersionHash": {
						SchemaProps: spec.SchemaProps{
							Description: "The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "singularName", "namespaced", "kind", "verbs"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_APIResourceList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIResourceList is a list of APIResource, it is used to expose the name of the resources supported in a specific group and version, and if the resource is namespaced.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groupVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "groupVersion is the group and version this APIResourceList is for.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "resources contains the name of the resources and if they are namespaced.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.APIResource"),
									},
								},
							},
						},
					},
				},
				Required: []string{"groupVersion", "resources"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.APIResource"},
	}
}

func schema_pkg_apis_meta_v1_APIVersions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIVersions lists the versions that are available, to allow clients to discover the API at /api, which is the root path of the legacy v1 API.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"versions": {
						SchemaProps: spec.SchemaProps{
							Description: "versions are the api versions that are available.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"serverAddressByClientCIDRs": {
						SchemaProps: spec.SchemaProps{
							Description: "a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR"),
									},
								},
							},
						},
					},
				},
				Required: []string{"versions", "serverAddressByClientCIDRs"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR"},
	}
}

func schema_pkg_apis_meta_v1_ApplyOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ApplyOptions may be provided when applying an API object. FieldManager is required for apply requests. ApplyOptions is equivalent to PatchOptions. It is provided as a convenience with documentation that speaks specifically to how the options fields relate to apply.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dryRun": {
						SchemaProps: spec.SchemaProps{
							Description: "When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"force": {
						SchemaProps: spec.SchemaProps{
							Description: "Force is going to \"force\" Apply requests. It means user will re-acquire conflicting fields owned by other people.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"fieldManager": {
						SchemaProps: spec.SchemaProps{
							Description: "fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint. This field is required.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"force", "fieldManager"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_Condition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Condition contains details for one aspect of the current state of this API Resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type of condition in CamelCase or in foo.example.com/CamelCase.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration represents the .metadata.generation that the condition was set based upon. For instance, if .metadata.generation is currently 12, but the .status.conditions[x].observedGeneration is 9, the condition is out of date with respect to the current state of the instance.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastTransitionTime is the last time the condition transitioned from one status to another. This should be when the underlying condition changed.  If that is not known, then using the time when the API field changed is acceptable.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "reason contains a programmatic identifier indicating the reason for the condition's last transition. Producers of specific condition types may define expected values and meanings for this field, and whether the values are considered a guaranteed API. The value should be a CamelCase string. This field may not be empty.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "message is a human readable message indicating details about the transition. This may be an empty string.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status", "lastTransitionTime", "reason", "message"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_meta_v1_CreateOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CreateOptions may be provided when creating an API object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dryRun": {
						SchemaProps: spec.SchemaProps{
							Description: "When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"fieldManager": {
						SchemaProps: spec.SchemaProps{
							Description: "fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldValidation": {
						SchemaProps: spec.SchemaProps{
							Description: "fieldValidation instructs the server on how to handle objects in the request (POST/PUT/PATCH) containing unknown or duplicate fields, provided that the `ServerSideFieldValidation` feature gate is also enabled. Valid values are: - Ignore: This will ignore any unknown fields that are silently dropped from the object, and will ignore all but the last duplicate field that the decoder encounters. This is the default behavior prior to v1.23 and is the default behavior when the `ServerSideFieldValidation` feature gate is disabled. - Warn: This will send a warning via the standard warning response header for each unknown field that is dropped from the object, and for each duplicate field that is encountered. The request will still succeed if there are no other errors, and will only persist the last of any duplicate fields. This is the default when the `ServerSideFieldValidation` feature gate is enabled. - Strict: This will fail the request with a BadRequest error if any unknown fields would be dropped from the object, or if any duplicate fields are present. The error returned from the server will contain all unknown and duplicate fields encountered.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_DeleteOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeleteOptions may be provided when deleting an API object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"gracePeriodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"preconditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Preconditions"),
						},
					},
					"orphanDependents": {
						SchemaProps: spec.SchemaProps{
							Description: "Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"propagationPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dryRun": {
						SchemaProps: spec.SchemaProps{
							Description: "When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Preconditions"},
	}
}

func schema_pkg_apis_meta_v1_Duration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Duration is a wrapper around time.Duration which supports correct marshaling to YAML and JSON. In particular, it marshals into strings, which can be used as map keys in json.",
				Type:        v1.Duration{}.OpenAPISchemaType(),
				Format:      v1.Duration{}.OpenAPISchemaFormat(),
			},
		},
	}
}

func schema_pkg_apis_meta_v1_FieldsV1(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FieldsV1 stores a set of fields in a data structure like a Trie, in JSON format.\n\nEach key is either a '.' representing the field itself, and will always map to an empty set, or a string representing a sub-field or item. The string will follow one of these four formats: 'f:<name>', where <name> is the name of a field in a struct, or key in a map 'v:<value>', where <value> is the exact json formatted value of a list item 'i:<index>', where <index> is position of a item in a list 'k:<keys>', where <keys> is a map of  a list item's key fields to their unique values If a key maps to an empty Fields value, the field that key represents is part of the set.\n\nThe exact format is defined in sigs.k8s.io/structured-merge-diff",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_GetOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GetOptions is the standard query options to the standard REST get call.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "resourceVersion sets a constraint on what resource versions a request may be served from. See https://kubernetes.io/docs/reference/using-api/api-concepts/#resource-versions for details.\n\nDefaults to unset",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_GroupKind(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GroupKind specifies a Group and a Kind, but does not force a version.  This is useful for identifying concepts during lookup stages without having partially valid types",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"group": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"group", "kind"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_GroupResource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GroupResource specifies a Group and a Resource, but does not force a version.  This is useful for identifying concepts during lookup stages without having partially valid types",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"group": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"group", "resource"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_GroupVersion(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GroupVersion contains the \"group\" and the \"version\", which uniquely identifies the API.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"group": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"group", "version"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_GroupVersionForDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GroupVersion contains the \"group/version\" and \"version\" string of a version. It is made a struct to keep extensibility.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"groupVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "groupVersion specifies the API group and version in the form \"group/version\"",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "version specifies the version in the form of \"version\". This is to save the clients the trouble of splitting the GroupVersion.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"groupVersion", "version"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_GroupVersionKind(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GroupVersionKind unambiguously identifies a kind.  It doesn't anonymously include GroupVersion to avoid automatic coercion.  It doesn't use a GroupVersion to avoid custom marshalling",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"group": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"group", "version", "kind"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_GroupVersionResource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GroupVersionResource unambiguously identifies a resource.  It doesn't anonymously include GroupVersion to avoid automatic coercion.  It doesn't use a GroupVersion to avoid custom marshalling",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"group": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"group", "version", "resource"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_InternalEvent(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "InternalEvent makes watch.Event versioned",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"Type": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"Object": {
						SchemaProps: spec.SchemaProps{
							Description: "Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Bookmark: the object (instance of a type being watched) where\n   only ResourceVersion field is set. On successful restart of watch from a\n   bookmark resourceVersion, client is guaranteed to not get repeat event\n   nor miss any events.\n * If Type is Error: *api.Status is recommended; other types may make sense\n   depending on context.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.Object"),
						},
					},
				},
				Required: []string{"Type", "Object"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.Object"},
	}
}

func schema_pkg_apis_meta_v1_LabelSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"matchLabels": {
						SchemaProps: spec.SchemaProps{
							Description: "matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \"key\", the operator is \"In\", and the values array contains only \"value\". The requirements are ANDed.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"matchExpressions": {
						SchemaProps: spec.SchemaProps{
							Description: "matchExpressions is a list of label selector requirements. The requirements are ANDed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement"),
									},
								},
							},
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement"},
	}
}

func schema_pkg_apis_meta_v1_LabelSelectorRequirement(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"key": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "key",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "key is the label key that the selector applies to.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"operator": {
						SchemaProps: spec.SchemaProps{
							Description: "operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"values": {
						SchemaProps: spec.SchemaProps{
							Description: "values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"key", "operator"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_List(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "List holds a list of objects, which may not be known by the server.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of objects",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_meta_v1_ListMeta(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"selfLink": {
						SchemaProps: spec.SchemaProps{
							Description: "Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"continue": {
						SchemaProps: spec.SchemaProps{
							Description: "continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"remainingItemCount": {
						SchemaProps: spec.SchemaProps{
							Description: "remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_ListOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ListOptions is the query options to a standard REST list call.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"labelSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "A selector to restrict the list of returned objects by their labels. Defaults to everything.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "A selector to restrict the list of returned objects by their fields. Defaults to everything.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"watch": {
						SchemaProps: spec.SchemaProps{
							Description: "Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"allowWatchBookmarks": {
						SchemaProps: spec.SchemaProps{
							Description: "allowWatchBookmarks requests watch events with type \"BOOKMARK\". Servers that do not implement bookmarks may ignore this flag and bookmarks are sent at the server's discretion. Clients should not assume bookmarks are returned at any specific interval, nor may they assume the server will send any BOOKMARK event during a session. If this is not a watch, this field is ignored.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"resourceVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "resourceVersion sets a constraint on what resource versions a request may be served from. See https://kubernetes.io/docs/reference/using-api/api-concepts/#resource-versions for details.\n\nDefaults to unset",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceVersionMatch": {
						SchemaProps: spec.SchemaProps{
							Description: "resourceVersionMatch determines how resourceVersion is applied to list calls. It is highly recommended that resourceVersionMatch be set for list calls where resourceVersion is set See https://kubernetes.io/docs/reference/using-api/api-concepts/#resource-versions for details.\n\nDefaults to unset",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"limit": {
						SchemaProps: spec.SchemaProps{
							Description: "limit is a maximum number of responses to return for a list call. If more items exist, the server will set the `continue` field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.\n\nThe server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"continue": {
						SchemaProps: spec.SchemaProps{
							Description: "The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \"next key\".\n\nThis field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_ManagedFieldsEntry(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"manager": {
						SchemaProps: spec.SchemaProps{
							Description: "Manager is an identifier of the workflow managing these fields.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"operation": {
						SchemaProps: spec.SchemaProps{
							Description: "Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the version of this resource that this field set applies to. The format is \"group/version\" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"time": {
						SchemaProps: spec.SchemaProps{
							Description: "Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"fieldsType": {
						SchemaProps: spec.SchemaProps{
							Description: "FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: \"FieldsV1\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldsV1": {
						SchemaProps: spec.SchemaProps{
							Description: "FieldsV1 holds the first JSON version format as described in the \"FieldsV1\" type.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.FieldsV1"),
						},
					},
					"subresource": {
						SchemaProps: spec.SchemaProps{
							Description: "Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.FieldsV1", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_meta_v1_MicroTime(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MicroTime is version of Time with microsecond level precision.",
				Type:        v1.MicroTime{}.OpenAPISchemaType(),
				Format:      v1.MicroTime{}.OpenAPISchemaFormat(),
			},
		},
	}
}

func schema_pkg_apis_meta_v1_ObjectMeta(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"generateName": {
						SchemaProps: spec.SchemaProps{
							Description: "GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the \"default\" namespace, but \"default\" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selfLink": {
						SchemaProps: spec.SchemaProps{
							Description: "Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"generation": {
						SchemaProps: spec.SchemaProps{
							Description: "A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"creationTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"deletionTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"deletionGracePeriodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"labels": {
						SchemaProps: spec.SchemaProps{
							Description: "Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"annotations": {
						SchemaProps: spec.SchemaProps{
							Description: "Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"ownerReferences": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "uid",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference"),
									},
								},
							},
						},
					},
					"finalizers": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-strategy": "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"managedFields": {
						SchemaProps: spec.SchemaProps{
							Description: "ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \"ci-cd\". The set of fields is always in the version that the workflow used when modifying the object.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ManagedFieldsEntry"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ManagedFieldsEntry", "k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_meta_v1_OwnerReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OwnerReference contains enough information to let you identify an owning object. An owning object must be in the same namespace as the dependent, or be cluster-scoped, so there is no namespace field.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"controller": {
						SchemaProps: spec.SchemaProps{
							Description: "If true, this reference points to the managing controller.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"blockOwnerDeletion": {
						SchemaProps: spec.SchemaProps{
							Description: "If true, AND if the owner has the \"foregroundDeletion\" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs \"delete\" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"apiVersion", "kind", "name", "uid"},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_PartialObjectMetadata(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PartialObjectMetadata is a generic representation of any object with ObjectMeta. It allows clients to get access to a particular ObjectMeta schema without knowing the details of the version.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_meta_v1_PartialObjectMetadataList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PartialObjectMetadataList contains a list of objects containing only their metadata",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items contains each of the included items.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.PartialObjectMetadata"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.PartialObjectMetadata"},
	}
}

func schema_pkg_apis_meta_v1_Patch(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Patch is provided to give a concrete name and type to the Kubernetes PATCH request body.",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_PatchOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PatchOptions may be provided when patching an API object. PatchOptions is meant to be a superset of UpdateOptions.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dryRun": {
						SchemaProps: spec.SchemaProps{
							Description: "When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"force": {
						SchemaProps: spec.SchemaProps{
							Description: "Force is going to \"force\" Apply requests. It means user will re-acquire conflicting fields owned by other people. Force flag must be unset for non-apply patch requests.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"fieldManager": {
						SchemaProps: spec.SchemaProps{
							Description: "fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint. This field is required for apply requests (application/apply-patch) but optional for non-apply patch types (JsonPatch, MergePatch, StrategicMergePatch).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldValidation": {
						SchemaProps: spec.SchemaProps{
							Description: "fieldValidation instructs the server on how to handle objects in the request (POST/PUT/PATCH) containing unknown or duplicate fields, provided that the `ServerSideFieldValidation` feature gate is also enabled. Valid values are: - Ignore: This will ignore any unknown fields that are silently dropped from the object, and will ignore all but the last duplicate field that the decoder encounters. This is the default behavior prior to v1.23 and is the default behavior when the `ServerSideFieldValidation` feature gate is disabled. - Warn: This will send a warning via the standard warning response header for each unknown field that is dropped from the object, and for each duplicate field that is encountered. The request will still succeed if there are no other errors, and will only persist the last of any duplicate fields. This is the default when the `ServerSideFieldValidation` feature gate is enabled. - Strict: This will fail the request with a BadRequest error if any unknown fields would be dropped from the object, or if any duplicate fields are present. The error returned from the server will contain all unknown and duplicate fields encountered.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_Preconditions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the target UID.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the target ResourceVersion",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_RootPaths(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RootPaths lists the paths available at root. For example: \"/healthz\", \"/apis\".",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"paths": {
						SchemaProps: spec.SchemaProps{
							Description: "paths are the paths available at root.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"paths"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_ServerAddressByClientCIDR(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"clientCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "The CIDR with which clients can match their IP to figure out the server address that they should use.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"serverAddress": {
						SchemaProps: spec.SchemaProps{
							Description: "Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"clientCIDR", "serverAddress"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_Status(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Status is a return value for calls that don't return other objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the operation. One of: \"Success\" or \"Failure\". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human-readable description of the status of this operation.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "A machine-readable description of why this operation is in the \"Failure\" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"details": {
						SchemaProps: spec.SchemaProps{
							Description: "Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.StatusDetails"),
						},
					},
					"code": {
						SchemaProps: spec.SchemaProps{
							Description: "Suggested HTTP return code for this status, 0 if not set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.StatusDetails"},
	}
}

func schema_pkg_apis_meta_v1_StatusCause(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "A machine-readable description of the cause of the error. If this value is empty there is no information available.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human-readable description of the cause of the error.  This field may be presented as-is to a reader.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"field": {
						SchemaProps: spec.SchemaProps{
							Description: "The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  \"name\" - the field \"name\" on the current resource\n  \"items[0].name\" - the field \"name\" on the first array entry in \"items\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_StatusDetails(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response. The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"group": {
						SchemaProps: spec.SchemaProps{
							Description: "The group attribute of the resource associated with the status StatusReason.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"causes": {
						SchemaProps: spec.SchemaProps{
							Description: "The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.StatusCause"),
									},
								},
							},
						},
					},
					"retryAfterSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.StatusCause"},
	}
}

func schema_pkg_apis_meta_v1_Table(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Table is a tabular representation of a set of API resources. The server transforms the object into a set of preferred columns for quickly reviewing the objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"columnDefinitions": {
						SchemaProps: spec.SchemaProps{
							Description: "columnDefinitions describes each column in the returned items array. The number of cells per row will always match the number of column definitions.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.TableColumnDefinition"),
									},
								},
							},
						},
					},
					"rows": {
						SchemaProps: spec.SchemaProps{
							Description: "rows is the list of items in the table.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.TableRow"),
									},
								},
							},
						},
					},
				},
				Required: []string{"columnDefinitions", "rows"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.TableColumnDefinition", "k8s.io/apimachinery/pkg/apis/meta/v1.TableRow"},
	}
}

func schema_pkg_apis_meta_v1_TableColumnDefinition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TableColumnDefinition contains information about a column returned in the Table.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is a human readable name for the column.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is an OpenAPI type definition for this column, such as number, integer, string, or array. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"format": {
						SchemaProps: spec.SchemaProps{
							Description: "format is an optional OpenAPI type modifier for this column. A format modifies the type and imposes additional rules, like date or time formatting for a string. The 'name' format is applied to the primary identifier column which has type 'string' to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "description is a human readable description of this column.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"priority": {
						SchemaProps: spec.SchemaProps{
							Description: "priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a higher priority.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"name", "type", "format", "description", "priority"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_TableOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TableOptions are used when a Table is requested by the caller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"includeObject": {
						SchemaProps: spec.SchemaProps{
							Description: "includeObject decides whether to include each object along with its columnar information. Specifying \"None\" will return no object, specifying \"Object\" will return the full object contents, and specifying \"Metadata\" (the default) will return the object's metadata in the PartialObjectMetadata kind in version v1beta1 of the meta.k8s.io API group.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_TableRow(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TableRow is an individual row in a table.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"cells": {
						SchemaProps: spec.SchemaProps{
							Description: "cells will be as wide as the column definitions array and may contain strings, numbers (float64 or int64), booleans, simple maps, lists, or null. See the type field of the column definition for a more detailed description.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"object"},
										Format: "",
									},
								},
							},
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "conditions describe additional status of a row that are relevant for a human user. These conditions apply to the row, not to the object, and will be specific to table output. The only defined condition type is 'Completed', for a row that indicates a resource that has run to completion and can be given less visual priority.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.TableRowCondition"),
									},
								},
							},
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "This field contains the requested additional information about each object based on the includeObject policy when requesting the Table. If \"None\", this field is empty, if \"Object\" this will be the default serialization of the object for the current API version, and if \"Metadata\" (the default) will contain the object metadata. Check the returned kind and apiVersion of the object before parsing. The media type of the object will always match the enclosing list - if this as a JSON table, these will be JSON encoded objects.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
				},
				Required: []string{"cells"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.TableRowCondition", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_meta_v1_TableRowCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TableRowCondition allows a row to be marked with additional information.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of row condition. The only defined value is 'Completed' indicating that the object this row represents has reached a completed state and may be given less visual priority than other rows. Clients are not required to honor any conditions but should be consistent where possible about handling the conditions.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) machine readable reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human readable message indicating details about last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_Time(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.",
				Type:        v1.Time{}.OpenAPISchemaType(),
				Format:      v1.Time{}.OpenAPISchemaFormat(),
			},
		},
	}
}

func schema_pkg_apis_meta_v1_Timestamp(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Timestamp is a struct that is equivalent to Time, but intended for protobuf marshalling/unmarshalling. It is generated into a serialization that matches Time. Do not use in Go structs.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"seconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"nanos": {
						SchemaProps: spec.SchemaProps{
							Description: "Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive. This field may be limited in precision depending on context.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"seconds", "nanos"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_TypeMeta(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TypeMeta describes an individual object in an API response or request with strings representing the type of the object and its API schema version. Structures that are versioned or persisted should inline TypeMeta.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_UpdateOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UpdateOptions may be provided when updating an API object. All fields in UpdateOptions should also be present in PatchOptions.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dryRun": {
						SchemaProps: spec.SchemaProps{
							Description: "When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"fieldManager": {
						SchemaProps: spec.SchemaProps{
							Description: "fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldValidation": {
						SchemaProps: spec.SchemaProps{
							Description: "fieldValidation instructs the server on how to handle objects in the request (POST/PUT/PATCH) containing unknown or duplicate fields, provided that the `ServerSideFieldValidation` feature gate is also enabled. Valid values are: - Ignore: This will ignore any unknown fields that are silently dropped from the object, and will ignore all but the last duplicate field that the decoder encounters. This is the default behavior prior to v1.23 and is the default behavior when the `ServerSideFieldValidation` feature gate is disabled. - Warn: This will send a warning via the standard warning response header for each unknown field that is dropped from the object, and for each duplicate field that is encountered. The request will still succeed if there are no other errors, and will only persist the last of any duplicate fields. This is the default when the `ServerSideFieldValidation` feature gate is enabled. - Strict: This will fail the request with a BadRequest error if any unknown fields would be dropped from the object, or if any duplicate fields are present. The error returned from the server will contain all unknown and duplicate fields encountered.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_meta_v1_WatchEvent(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Event represents a single event to a watched resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
				},
				Required: []string{"type", "object"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_k8sio_apimachinery_pkg_runtime_RawExtension(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RawExtension is used to hold extensions in external versions.\n\nTo use this, make a field which has RawExtension as its type in your external, versioned struct, and Object in your internal struct. You also need to register your various plugin types.\n\n// Internal package:\n\n\ttype MyAPIObject struct {\n\t\truntime.TypeMeta `json:\",inline\"`\n\t\tMyPlugin runtime.Object `json:\"myPlugin\"`\n\t}\n\n\ttype PluginA struct {\n\t\tAOption string `json:\"aOption\"`\n\t}\n\n// External package:\n\n\ttype MyAPIObject struct {\n\t\truntime.TypeMeta `json:\",inline\"`\n\t\tMyPlugin runtime.RawExtension `json:\"myPlugin\"`\n\t}\n\n\ttype PluginA struct {\n\t\tAOption string `json:\"aOption\"`\n\t}\n\n// On the wire, the JSON will look something like this:\n\n\t{\n\t\t\"kind\":\"MyAPIObject\",\n\t\t\"apiVersion\":\"v1\",\n\t\t\"myPlugin\": {\n\t\t\t\"kind\":\"PluginA\",\n\t\t\t\"aOption\":\"foo\",\n\t\t},\n\t}\n\nSo what happens? Decode first uses json or yaml to unmarshal the serialized data into your external MyAPIObject. That causes the raw JSON to be stored, but not unpacked. The next step is to copy (using pkg/conversion) into the internal struct. The runtime package's DefaultScheme has conversion functions installed which will unpack the JSON stored in RawExtension, turning it into the correct object type, and storing it in the Object. (TODO: In the case where the object is of an unknown type, a runtime.Unknown object will be created and stored.)",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_k8sio_apimachinery_pkg_runtime_TypeMeta(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TypeMeta is shared by all top level objects. The proper way to use it is to inline it in your type, like this:\n\n\ttype MyAwesomeAPIObject struct {\n\t     runtime.TypeMeta    `json:\",inline\"`\n\t     ... // other fields\n\t}\n\nfunc (obj *MyAwesomeAPIObject) SetGroupVersionKind(gvk *metav1.GroupVersionKind) { metav1.UpdateTypeMeta(obj,gvk) }; GroupVersionKind() *GroupVersionKind\n\nTypeMeta is provided here for convenience. You may use it directly from this package or define your own with the same fields.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_apimachinery_pkg_runtime_Unknown(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Unknown allows api objects with unknown types to be passed-through. This can be used to deal with the API objects from a plug-in. Unknown objects still have functioning TypeMeta features-- kind, version, etc. metadata and field mutatation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"Raw": {
						SchemaProps: spec.SchemaProps{
							Description: "Raw will hold the complete serialized object which couldn't be matched with a registered type. Most likely, nothing should be done with this except for passing it through the system.",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
					"ContentEncoding": {
						SchemaProps: spec.SchemaProps{
							Description: "ContentEncoding is encoding used to encode 'Raw' data. Unspecified means no encoding.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ContentType": {
						SchemaProps: spec.SchemaProps{
							Description: "ContentType  is serialization method used to serialize 'Raw'. Unspecified means ContentTypeJSON.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"Raw", "ContentEncoding", "ContentType"},
			},
		},
	}
}

func schema_k8sio_apimachinery_pkg_version_Info(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Info contains versioning information. how we'll want to distribute that information.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"major": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"minor": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"gitVersion": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"gitCommit": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"gitTreeState": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"buildDate": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"goVersion": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"compiler": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"platform": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"major", "minor", "gitVersion", "gitCommit", "gitTreeState", "buildDate", "goVersion", "compiler", "platform"},
			},
		},
	}
}
