package v1alpha1

import (
	"fmt"
	"time"

	"go.starlark.net/starlark"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"

	"github.com/tilt-dev/tilt/internal/tiltfile/starkit"
	"github.com/tilt-dev/tilt/internal/tiltfile/value"
	"github.com/tilt-dev/tilt/pkg/apis/core/v1alpha1"
)

// AUTOGENERATED by github.com/tilt-dev/tilt-starlark-codegen
// DO NOT EDIT MANUALLY

func (p Plugin) registerSymbols(env *starkit.Environment) error {
	var err error

	err = env.AddBuiltin("v1alpha1.cmd", p.cmd)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.config_map", p.configMap)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.extension", p.extension)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.extension_repo", p.extensionRepo)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.file_watch", p.fileWatch)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.kubernetes_apply", p.kubernetesApply)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.kubernetes_discovery", p.kubernetesDiscovery)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.ui_button", p.uiButton)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.config_map_disable_source", p.configMapDisableSource)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.disable_source", p.disableSource)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.exec_action", p.execAction)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.forward", p.forward)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.http_get_action", p.hTTPGetAction)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.http_header", p.hTTPHeader)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.handler", p.handler)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.ignore_def", p.ignoreDef)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.kubernetes_apply_cmd", p.kubernetesApplyCmd)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.kubernetes_discovery_template_spec", p.kubernetesDiscoveryTemplateSpec)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.kubernetes_image_locator", p.kubernetesImageLocator)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.kubernetes_image_object_descriptor", p.kubernetesImageObjectDescriptor)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.kubernetes_watch_ref", p.kubernetesWatchRef)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.label_selector", p.labelSelector)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.label_selector_requirement", p.labelSelectorRequirement)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.object_selector", p.objectSelector)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.pod_log_stream_template_spec", p.podLogStreamTemplateSpec)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.port_forward_template_spec", p.portForwardTemplateSpec)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.probe", p.probe)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.restart_on_spec", p.restartOnSpec)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.start_on_spec", p.startOnSpec)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.tcp_socket_action", p.tCPSocketAction)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.ui_bool_input_spec", p.uIBoolInputSpec)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.ui_choice_input_spec", p.uIChoiceInputSpec)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.ui_component_location", p.uIComponentLocation)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.ui_hidden_input_spec", p.uIHiddenInputSpec)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.ui_input_spec", p.uIInputSpec)
	if err != nil {
		return err
	}
	err = env.AddBuiltin("v1alpha1.ui_text_input_spec", p.uITextInputSpec)
	if err != nil {
		return err
	}
	return nil
}
func (p Plugin) cmd(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var err error
	obj := &v1alpha1.Cmd{
		ObjectMeta: metav1.ObjectMeta{},
		Spec:       v1alpha1.CmdSpec{},
	}
	var specArgs value.StringList
	var dir value.LocalPath = value.NewLocalPathUnpacker(t)
	err = dir.Unpack(starlark.String(""))
	if err != nil {
		return nil, err
	}

	var env value.StringList
	var readinessProbe Probe = Probe{t: t}
	var restartOn RestartOnSpec = RestartOnSpec{t: t}
	var startOn StartOnSpec = StartOnSpec{t: t}
	var disableSource DisableSource = DisableSource{t: t}
	var labels value.StringStringMap
	var annotations value.StringStringMap
	err = starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"name", &obj.ObjectMeta.Name,
		"labels?", &labels,
		"annotations?", &annotations,
		"args?", &specArgs,
		"dir?", &dir,
		"env?", &env,
		"readiness_probe?", &readinessProbe,
		"restart_on?", &restartOn,
		"start_on?", &startOn,
		"disable_source?", &disableSource,
	)
	if err != nil {
		return nil, err
	}

	obj.Spec.Args = specArgs
	obj.Spec.Dir = dir.Value
	obj.Spec.Env = env
	if readinessProbe.isUnpacked {
		obj.Spec.ReadinessProbe = (*v1alpha1.Probe)(&readinessProbe.Value)
	}
	if restartOn.isUnpacked {
		obj.Spec.RestartOn = (*v1alpha1.RestartOnSpec)(&restartOn.Value)
	}
	if startOn.isUnpacked {
		obj.Spec.StartOn = (*v1alpha1.StartOnSpec)(&startOn.Value)
	}
	if disableSource.isUnpacked {
		obj.Spec.DisableSource = (*v1alpha1.DisableSource)(&disableSource.Value)
	}
	obj.ObjectMeta.Labels = labels
	obj.ObjectMeta.Annotations = annotations
	return p.register(t, obj)
}

func (p Plugin) configMap(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var err error
	obj := &v1alpha1.ConfigMap{
		ObjectMeta: metav1.ObjectMeta{},
	}
	var data value.StringStringMap
	var labels value.StringStringMap
	var annotations value.StringStringMap
	err = starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"name", &obj.ObjectMeta.Name,
		"labels?", &labels,
		"annotations?", &annotations,
		"data?", &data,
	)
	if err != nil {
		return nil, err
	}

	obj.Data = data
	obj.ObjectMeta.Labels = labels
	obj.ObjectMeta.Annotations = annotations
	return p.register(t, obj)
}

func (p Plugin) extension(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var err error
	obj := &v1alpha1.Extension{
		ObjectMeta: metav1.ObjectMeta{},
		Spec:       v1alpha1.ExtensionSpec{},
	}
	var specArgs value.StringList
	var labels value.StringStringMap
	var annotations value.StringStringMap
	err = starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"name", &obj.ObjectMeta.Name,
		"labels?", &labels,
		"annotations?", &annotations,
		"repo_name?", &obj.Spec.RepoName,
		"repo_path?", &obj.Spec.RepoPath,
		"args?", &specArgs,
	)
	if err != nil {
		return nil, err
	}

	obj.Spec.Args = specArgs
	obj.ObjectMeta.Labels = labels
	obj.ObjectMeta.Annotations = annotations
	return p.register(t, obj)
}

func (p Plugin) extensionRepo(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var err error
	obj := &v1alpha1.ExtensionRepo{
		ObjectMeta: metav1.ObjectMeta{},
		Spec:       v1alpha1.ExtensionRepoSpec{},
	}
	var labels value.StringStringMap
	var annotations value.StringStringMap
	err = starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"name", &obj.ObjectMeta.Name,
		"labels?", &labels,
		"annotations?", &annotations,
		"url?", &obj.Spec.URL,
		"ref?", &obj.Spec.Ref,
	)
	if err != nil {
		return nil, err
	}

	obj.ObjectMeta.Labels = labels
	obj.ObjectMeta.Annotations = annotations
	return p.register(t, obj)
}

func (p Plugin) fileWatch(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var err error
	obj := &v1alpha1.FileWatch{
		ObjectMeta: metav1.ObjectMeta{},
		Spec:       v1alpha1.FileWatchSpec{},
	}
	var watchedPaths value.LocalPathList = value.NewLocalPathListUnpacker(t)
	var ignores IgnoreDefList = IgnoreDefList{t: t}
	var disableSource DisableSource = DisableSource{t: t}
	var labels value.StringStringMap
	var annotations value.StringStringMap
	err = starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"name", &obj.ObjectMeta.Name,
		"labels?", &labels,
		"annotations?", &annotations,
		"watched_paths?", &watchedPaths,
		"ignores?", &ignores,
		"disable_source?", &disableSource,
	)
	if err != nil {
		return nil, err
	}

	obj.Spec.WatchedPaths = watchedPaths.Value
	obj.Spec.Ignores = ignores.Value
	if disableSource.isUnpacked {
		obj.Spec.DisableSource = (*v1alpha1.DisableSource)(&disableSource.Value)
	}
	obj.ObjectMeta.Labels = labels
	obj.ObjectMeta.Annotations = annotations
	return p.register(t, obj)
}

func (p Plugin) kubernetesApply(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var err error
	obj := &v1alpha1.KubernetesApply{
		ObjectMeta: metav1.ObjectMeta{},
		Spec:       v1alpha1.KubernetesApplySpec{},
	}
	var imageMaps value.StringList
	var imageLocators KubernetesImageLocatorList = KubernetesImageLocatorList{t: t}
	var timeout value.Duration
	var kubernetesDiscoveryTemplateSpec KubernetesDiscoveryTemplateSpec = KubernetesDiscoveryTemplateSpec{t: t}
	var portForwardTemplateSpec PortForwardTemplateSpec = PortForwardTemplateSpec{t: t}
	var podLogStreamTemplateSpec PodLogStreamTemplateSpec = PodLogStreamTemplateSpec{t: t}
	var discoveryStrategy string
	var disableSource DisableSource = DisableSource{t: t}
	var applyCmd KubernetesApplyCmd = KubernetesApplyCmd{t: t}
	var restartOn RestartOnSpec = RestartOnSpec{t: t}
	var deleteCmd KubernetesApplyCmd = KubernetesApplyCmd{t: t}
	var labels value.StringStringMap
	var annotations value.StringStringMap
	err = starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"name", &obj.ObjectMeta.Name,
		"labels?", &labels,
		"annotations?", &annotations,
		"yaml?", &obj.Spec.YAML,
		"image_maps?", &imageMaps,
		"image_locators?", &imageLocators,
		"timeout?", &timeout,
		"kubernetes_discovery_template_spec?", &kubernetesDiscoveryTemplateSpec,
		"port_forward_template_spec?", &portForwardTemplateSpec,
		"pod_log_stream_template_spec?", &podLogStreamTemplateSpec,
		"discovery_strategy?", &discoveryStrategy,
		"disable_source?", &disableSource,
		"apply_cmd?", &applyCmd,
		"restart_on?", &restartOn,
		"delete_cmd?", &deleteCmd,
		"cluster?", &obj.Spec.Cluster,
	)
	if err != nil {
		return nil, err
	}

	obj.Spec.ImageMaps = imageMaps
	obj.Spec.ImageLocators = imageLocators.Value
	obj.Spec.Timeout = metav1.Duration{Duration: time.Duration(timeout)}
	if kubernetesDiscoveryTemplateSpec.isUnpacked {
		obj.Spec.KubernetesDiscoveryTemplateSpec = (*v1alpha1.KubernetesDiscoveryTemplateSpec)(&kubernetesDiscoveryTemplateSpec.Value)
	}
	if portForwardTemplateSpec.isUnpacked {
		obj.Spec.PortForwardTemplateSpec = (*v1alpha1.PortForwardTemplateSpec)(&portForwardTemplateSpec.Value)
	}
	if podLogStreamTemplateSpec.isUnpacked {
		obj.Spec.PodLogStreamTemplateSpec = (*v1alpha1.PodLogStreamTemplateSpec)(&podLogStreamTemplateSpec.Value)
	}
	obj.Spec.DiscoveryStrategy = v1alpha1.KubernetesDiscoveryStrategy(discoveryStrategy)
	if disableSource.isUnpacked {
		obj.Spec.DisableSource = (*v1alpha1.DisableSource)(&disableSource.Value)
	}
	if applyCmd.isUnpacked {
		obj.Spec.ApplyCmd = (*v1alpha1.KubernetesApplyCmd)(&applyCmd.Value)
	}
	if restartOn.isUnpacked {
		obj.Spec.RestartOn = (*v1alpha1.RestartOnSpec)(&restartOn.Value)
	}
	if deleteCmd.isUnpacked {
		obj.Spec.DeleteCmd = (*v1alpha1.KubernetesApplyCmd)(&deleteCmd.Value)
	}
	obj.ObjectMeta.Labels = labels
	obj.ObjectMeta.Annotations = annotations
	return p.register(t, obj)
}

func (p Plugin) kubernetesDiscovery(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var err error
	obj := &v1alpha1.KubernetesDiscovery{
		ObjectMeta: metav1.ObjectMeta{},
		Spec:       v1alpha1.KubernetesDiscoverySpec{},
	}
	var watches KubernetesWatchRefList = KubernetesWatchRefList{t: t}
	var extraSelectors LabelSelectorList = LabelSelectorList{t: t}
	var portForwardTemplateSpec PortForwardTemplateSpec = PortForwardTemplateSpec{t: t}
	var podLogStreamTemplateSpec PodLogStreamTemplateSpec = PodLogStreamTemplateSpec{t: t}
	var labels value.StringStringMap
	var annotations value.StringStringMap
	err = starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"name", &obj.ObjectMeta.Name,
		"labels?", &labels,
		"annotations?", &annotations,
		"watches?", &watches,
		"extra_selectors?", &extraSelectors,
		"port_forward_template_spec?", &portForwardTemplateSpec,
		"pod_log_stream_template_spec?", &podLogStreamTemplateSpec,
		"cluster?", &obj.Spec.Cluster,
	)
	if err != nil {
		return nil, err
	}

	obj.Spec.Watches = watches.Value
	obj.Spec.ExtraSelectors = extraSelectors.Value
	if portForwardTemplateSpec.isUnpacked {
		obj.Spec.PortForwardTemplateSpec = (*v1alpha1.PortForwardTemplateSpec)(&portForwardTemplateSpec.Value)
	}
	if podLogStreamTemplateSpec.isUnpacked {
		obj.Spec.PodLogStreamTemplateSpec = (*v1alpha1.PodLogStreamTemplateSpec)(&podLogStreamTemplateSpec.Value)
	}
	obj.ObjectMeta.Labels = labels
	obj.ObjectMeta.Annotations = annotations
	return p.register(t, obj)
}

func (p Plugin) uiButton(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var err error
	obj := &v1alpha1.UIButton{
		ObjectMeta: metav1.ObjectMeta{},
		Spec:       v1alpha1.UIButtonSpec{},
	}
	var location UIComponentLocation = UIComponentLocation{t: t}
	var inputs UIInputSpecList = UIInputSpecList{t: t}
	var labels value.StringStringMap
	var annotations value.StringStringMap
	err = starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"name", &obj.ObjectMeta.Name,
		"labels?", &labels,
		"annotations?", &annotations,
		"location?", &location,
		"text?", &obj.Spec.Text,
		"icon_name?", &obj.Spec.IconName,
		"icon_svg?", &obj.Spec.IconSVG,
		"disabled?", &obj.Spec.Disabled,
		"requires_confirmation?", &obj.Spec.RequiresConfirmation,
		"inputs?", &inputs,
	)
	if err != nil {
		return nil, err
	}

	obj.Spec.Location = v1alpha1.UIComponentLocation(location.Value)
	obj.Spec.Inputs = inputs.Value
	obj.ObjectMeta.Labels = labels
	obj.ObjectMeta.Annotations = annotations
	return p.register(t, obj)
}

type ConfigMapDisableSource struct {
	*starlark.Dict
	Value      v1alpha1.ConfigMapDisableSource
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) configMapDisableSource(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var name starlark.Value
	var key starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"name?", &name,
		"key?", &key,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(2)

	if name != nil {
		err := dict.SetKey(starlark.String("name"), name)
		if err != nil {
			return nil, err
		}
	}
	if key != nil {
		err := dict.SetKey(starlark.String("key"), key)
		if err != nil {
			return nil, err
		}
	}
	var obj *ConfigMapDisableSource = &ConfigMapDisableSource{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *ConfigMapDisableSource) Unpack(v starlark.Value) error {
	obj := v1alpha1.ConfigMapDisableSource{}

	starlarkObj, ok := v.(*ConfigMapDisableSource)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "name" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Name = string(v)
			continue
		}
		if key == "key" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Key = string(v)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type ConfigMapDisableSourceList struct {
	*starlark.List
	Value []v1alpha1.ConfigMapDisableSource
	t     *starlark.Thread
}

func (o *ConfigMapDisableSourceList) Unpack(v starlark.Value) error {
	items := []v1alpha1.ConfigMapDisableSource{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := ConfigMapDisableSource{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.ConfigMapDisableSource(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type DisableSource struct {
	*starlark.Dict
	Value      v1alpha1.DisableSource
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) disableSource(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var configMap starlark.Value
	var everyConfigMap starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"config_map?", &configMap,
		"every_config_map?", &everyConfigMap,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(2)

	if configMap != nil {
		err := dict.SetKey(starlark.String("config_map"), configMap)
		if err != nil {
			return nil, err
		}
	}
	if everyConfigMap != nil {
		err := dict.SetKey(starlark.String("every_config_map"), everyConfigMap)
		if err != nil {
			return nil, err
		}
	}
	var obj *DisableSource = &DisableSource{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *DisableSource) Unpack(v starlark.Value) error {
	obj := v1alpha1.DisableSource{}

	starlarkObj, ok := v.(*DisableSource)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "config_map" {
			v := ConfigMapDisableSource{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.ConfigMap = (*v1alpha1.ConfigMapDisableSource)(&v.Value)
			continue
		}
		if key == "every_config_map" {
			v := ConfigMapDisableSourceList{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.EveryConfigMap = v.Value
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type DisableSourceList struct {
	*starlark.List
	Value []v1alpha1.DisableSource
	t     *starlark.Thread
}

func (o *DisableSourceList) Unpack(v starlark.Value) error {
	items := []v1alpha1.DisableSource{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := DisableSource{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.DisableSource(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type ExecAction struct {
	*starlark.Dict
	Value      v1alpha1.ExecAction
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) execAction(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var command starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"command?", &command,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(1)

	if command != nil {
		err := dict.SetKey(starlark.String("command"), command)
		if err != nil {
			return nil, err
		}
	}
	var obj *ExecAction = &ExecAction{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *ExecAction) Unpack(v starlark.Value) error {
	obj := v1alpha1.ExecAction{}

	starlarkObj, ok := v.(*ExecAction)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "command" {
			var v value.StringList
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Command = v
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type ExecActionList struct {
	*starlark.List
	Value []v1alpha1.ExecAction
	t     *starlark.Thread
}

func (o *ExecActionList) Unpack(v starlark.Value) error {
	items := []v1alpha1.ExecAction{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := ExecAction{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.ExecAction(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type Forward struct {
	*starlark.Dict
	Value      v1alpha1.Forward
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) forward(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var localPort starlark.Value
	var containerPort starlark.Value
	var host starlark.Value
	var name starlark.Value
	var path starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"local_port?", &localPort,
		"container_port?", &containerPort,
		"host?", &host,
		"name?", &name,
		"path?", &path,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(5)

	if localPort != nil {
		err := dict.SetKey(starlark.String("local_port"), localPort)
		if err != nil {
			return nil, err
		}
	}
	if containerPort != nil {
		err := dict.SetKey(starlark.String("container_port"), containerPort)
		if err != nil {
			return nil, err
		}
	}
	if host != nil {
		err := dict.SetKey(starlark.String("host"), host)
		if err != nil {
			return nil, err
		}
	}
	if name != nil {
		err := dict.SetKey(starlark.String("name"), name)
		if err != nil {
			return nil, err
		}
	}
	if path != nil {
		err := dict.SetKey(starlark.String("path"), path)
		if err != nil {
			return nil, err
		}
	}
	var obj *Forward = &Forward{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *Forward) Unpack(v starlark.Value) error {
	obj := v1alpha1.Forward{}

	starlarkObj, ok := v.(*Forward)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "local_port" {
			v, err := starlark.AsInt32(val)
			if err != nil {
				return fmt.Errorf("Expected int, got: %v", err)
			}
			obj.LocalPort = int32(v)
			continue
		}
		if key == "container_port" {
			v, err := starlark.AsInt32(val)
			if err != nil {
				return fmt.Errorf("Expected int, got: %v", err)
			}
			obj.ContainerPort = int32(v)
			continue
		}
		if key == "host" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Host = string(v)
			continue
		}
		if key == "name" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Name = string(v)
			continue
		}
		if key == "path" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Path = string(v)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type ForwardList struct {
	*starlark.List
	Value []v1alpha1.Forward
	t     *starlark.Thread
}

func (o *ForwardList) Unpack(v starlark.Value) error {
	items := []v1alpha1.Forward{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := Forward{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.Forward(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type HTTPGetAction struct {
	*starlark.Dict
	Value      v1alpha1.HTTPGetAction
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) hTTPGetAction(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var path starlark.Value
	var port starlark.Value
	var host starlark.Value
	var scheme starlark.Value
	var hTTPHeaders starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"path?", &path,
		"port?", &port,
		"host?", &host,
		"scheme?", &scheme,
		"http_headers?", &hTTPHeaders,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(5)

	if path != nil {
		err := dict.SetKey(starlark.String("path"), path)
		if err != nil {
			return nil, err
		}
	}
	if port != nil {
		err := dict.SetKey(starlark.String("port"), port)
		if err != nil {
			return nil, err
		}
	}
	if host != nil {
		err := dict.SetKey(starlark.String("host"), host)
		if err != nil {
			return nil, err
		}
	}
	if scheme != nil {
		err := dict.SetKey(starlark.String("scheme"), scheme)
		if err != nil {
			return nil, err
		}
	}
	if hTTPHeaders != nil {
		err := dict.SetKey(starlark.String("http_headers"), hTTPHeaders)
		if err != nil {
			return nil, err
		}
	}
	var obj *HTTPGetAction = &HTTPGetAction{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *HTTPGetAction) Unpack(v starlark.Value) error {
	obj := v1alpha1.HTTPGetAction{}

	starlarkObj, ok := v.(*HTTPGetAction)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "path" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Path = string(v)
			continue
		}
		if key == "port" {
			v, err := starlark.AsInt32(val)
			if err != nil {
				return fmt.Errorf("Expected int, got: %v", err)
			}
			obj.Port = int32(v)
			continue
		}
		if key == "host" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Host = string(v)
			continue
		}
		if key == "scheme" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Scheme = v1alpha1.URIScheme(v)
			continue
		}
		if key == "http_headers" {
			v := HTTPHeaderList{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.HTTPHeaders = v.Value
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type HTTPGetActionList struct {
	*starlark.List
	Value []v1alpha1.HTTPGetAction
	t     *starlark.Thread
}

func (o *HTTPGetActionList) Unpack(v starlark.Value) error {
	items := []v1alpha1.HTTPGetAction{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := HTTPGetAction{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.HTTPGetAction(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type HTTPHeader struct {
	*starlark.Dict
	Value      v1alpha1.HTTPHeader
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) hTTPHeader(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var name starlark.Value
	var value starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"name?", &name,
		"value?", &value,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(2)

	if name != nil {
		err := dict.SetKey(starlark.String("name"), name)
		if err != nil {
			return nil, err
		}
	}
	if value != nil {
		err := dict.SetKey(starlark.String("value"), value)
		if err != nil {
			return nil, err
		}
	}
	var obj *HTTPHeader = &HTTPHeader{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *HTTPHeader) Unpack(v starlark.Value) error {
	obj := v1alpha1.HTTPHeader{}

	starlarkObj, ok := v.(*HTTPHeader)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "name" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Name = string(v)
			continue
		}
		if key == "value" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Value = string(v)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type HTTPHeaderList struct {
	*starlark.List
	Value []v1alpha1.HTTPHeader
	t     *starlark.Thread
}

func (o *HTTPHeaderList) Unpack(v starlark.Value) error {
	items := []v1alpha1.HTTPHeader{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := HTTPHeader{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.HTTPHeader(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type Handler struct {
	*starlark.Dict
	Value      v1alpha1.Handler
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) handler(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var exec starlark.Value
	var hTTPGet starlark.Value
	var tCPSocket starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"exec?", &exec,
		"http_get?", &hTTPGet,
		"tcp_socket?", &tCPSocket,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(3)

	if exec != nil {
		err := dict.SetKey(starlark.String("exec"), exec)
		if err != nil {
			return nil, err
		}
	}
	if hTTPGet != nil {
		err := dict.SetKey(starlark.String("http_get"), hTTPGet)
		if err != nil {
			return nil, err
		}
	}
	if tCPSocket != nil {
		err := dict.SetKey(starlark.String("tcp_socket"), tCPSocket)
		if err != nil {
			return nil, err
		}
	}
	var obj *Handler = &Handler{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *Handler) Unpack(v starlark.Value) error {
	obj := v1alpha1.Handler{}

	starlarkObj, ok := v.(*Handler)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "exec" {
			v := ExecAction{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Exec = (*v1alpha1.ExecAction)(&v.Value)
			continue
		}
		if key == "http_get" {
			v := HTTPGetAction{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.HTTPGet = (*v1alpha1.HTTPGetAction)(&v.Value)
			continue
		}
		if key == "tcp_socket" {
			v := TCPSocketAction{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.TCPSocket = (*v1alpha1.TCPSocketAction)(&v.Value)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type HandlerList struct {
	*starlark.List
	Value []v1alpha1.Handler
	t     *starlark.Thread
}

func (o *HandlerList) Unpack(v starlark.Value) error {
	items := []v1alpha1.Handler{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := Handler{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.Handler(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type IgnoreDef struct {
	*starlark.Dict
	Value      v1alpha1.IgnoreDef
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) ignoreDef(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var basePath starlark.Value
	var patterns starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"base_path?", &basePath,
		"patterns?", &patterns,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(2)

	if basePath != nil {
		err := dict.SetKey(starlark.String("base_path"), basePath)
		if err != nil {
			return nil, err
		}
	}
	if patterns != nil {
		err := dict.SetKey(starlark.String("patterns"), patterns)
		if err != nil {
			return nil, err
		}
	}
	var obj *IgnoreDef = &IgnoreDef{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *IgnoreDef) Unpack(v starlark.Value) error {
	obj := v1alpha1.IgnoreDef{}

	starlarkObj, ok := v.(*IgnoreDef)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "base_path" {
			v := value.NewLocalPathUnpacker(o.t)
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.BasePath = v.Value
			continue
		}
		if key == "patterns" {
			var v value.StringList
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Patterns = v
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type IgnoreDefList struct {
	*starlark.List
	Value []v1alpha1.IgnoreDef
	t     *starlark.Thread
}

func (o *IgnoreDefList) Unpack(v starlark.Value) error {
	items := []v1alpha1.IgnoreDef{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := IgnoreDef{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.IgnoreDef(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type KubernetesApplyCmd struct {
	*starlark.Dict
	Value      v1alpha1.KubernetesApplyCmd
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) kubernetesApplyCmd(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var specArgs starlark.Value
	var dir starlark.Value
	var env starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"args?", &specArgs,
		"dir?", &dir,
		"env?", &env,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(3)

	if specArgs != nil {
		err := dict.SetKey(starlark.String("args"), specArgs)
		if err != nil {
			return nil, err
		}
	}
	if dir != nil {
		err := dict.SetKey(starlark.String("dir"), dir)
		if err != nil {
			return nil, err
		}
	}
	if env != nil {
		err := dict.SetKey(starlark.String("env"), env)
		if err != nil {
			return nil, err
		}
	}
	var obj *KubernetesApplyCmd = &KubernetesApplyCmd{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *KubernetesApplyCmd) Unpack(v starlark.Value) error {
	obj := v1alpha1.KubernetesApplyCmd{}

	starlarkObj, ok := v.(*KubernetesApplyCmd)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "args" {
			var v value.StringList
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Args = v
			continue
		}
		if key == "dir" {
			v := value.NewLocalPathUnpacker(o.t)
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Dir = v.Value
			continue
		}
		if key == "env" {
			var v value.StringList
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Env = v
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type KubernetesApplyCmdList struct {
	*starlark.List
	Value []v1alpha1.KubernetesApplyCmd
	t     *starlark.Thread
}

func (o *KubernetesApplyCmdList) Unpack(v starlark.Value) error {
	items := []v1alpha1.KubernetesApplyCmd{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := KubernetesApplyCmd{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.KubernetesApplyCmd(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type KubernetesDiscoveryTemplateSpec struct {
	*starlark.Dict
	Value      v1alpha1.KubernetesDiscoveryTemplateSpec
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) kubernetesDiscoveryTemplateSpec(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var extraSelectors starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"extra_selectors?", &extraSelectors,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(1)

	if extraSelectors != nil {
		err := dict.SetKey(starlark.String("extra_selectors"), extraSelectors)
		if err != nil {
			return nil, err
		}
	}
	var obj *KubernetesDiscoveryTemplateSpec = &KubernetesDiscoveryTemplateSpec{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *KubernetesDiscoveryTemplateSpec) Unpack(v starlark.Value) error {
	obj := v1alpha1.KubernetesDiscoveryTemplateSpec{}

	starlarkObj, ok := v.(*KubernetesDiscoveryTemplateSpec)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "extra_selectors" {
			v := LabelSelectorList{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.ExtraSelectors = v.Value
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type KubernetesDiscoveryTemplateSpecList struct {
	*starlark.List
	Value []v1alpha1.KubernetesDiscoveryTemplateSpec
	t     *starlark.Thread
}

func (o *KubernetesDiscoveryTemplateSpecList) Unpack(v starlark.Value) error {
	items := []v1alpha1.KubernetesDiscoveryTemplateSpec{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := KubernetesDiscoveryTemplateSpec{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.KubernetesDiscoveryTemplateSpec(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type KubernetesImageLocator struct {
	*starlark.Dict
	Value      v1alpha1.KubernetesImageLocator
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) kubernetesImageLocator(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var objectSelector starlark.Value
	var path starlark.Value
	var object starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"object_selector?", &objectSelector,
		"path?", &path,
		"object?", &object,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(3)

	if objectSelector != nil {
		err := dict.SetKey(starlark.String("object_selector"), objectSelector)
		if err != nil {
			return nil, err
		}
	}
	if path != nil {
		err := dict.SetKey(starlark.String("path"), path)
		if err != nil {
			return nil, err
		}
	}
	if object != nil {
		err := dict.SetKey(starlark.String("object"), object)
		if err != nil {
			return nil, err
		}
	}
	var obj *KubernetesImageLocator = &KubernetesImageLocator{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *KubernetesImageLocator) Unpack(v starlark.Value) error {
	obj := v1alpha1.KubernetesImageLocator{}

	starlarkObj, ok := v.(*KubernetesImageLocator)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "object_selector" {
			v := ObjectSelector{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.ObjectSelector = v.Value
			continue
		}
		if key == "path" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Path = string(v)
			continue
		}
		if key == "object" {
			v := KubernetesImageObjectDescriptor{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Object = (*v1alpha1.KubernetesImageObjectDescriptor)(&v.Value)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type KubernetesImageLocatorList struct {
	*starlark.List
	Value []v1alpha1.KubernetesImageLocator
	t     *starlark.Thread
}

func (o *KubernetesImageLocatorList) Unpack(v starlark.Value) error {
	items := []v1alpha1.KubernetesImageLocator{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := KubernetesImageLocator{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.KubernetesImageLocator(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type KubernetesImageObjectDescriptor struct {
	*starlark.Dict
	Value      v1alpha1.KubernetesImageObjectDescriptor
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) kubernetesImageObjectDescriptor(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var repoField starlark.Value
	var tagField starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"repo_field?", &repoField,
		"tag_field?", &tagField,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(2)

	if repoField != nil {
		err := dict.SetKey(starlark.String("repo_field"), repoField)
		if err != nil {
			return nil, err
		}
	}
	if tagField != nil {
		err := dict.SetKey(starlark.String("tag_field"), tagField)
		if err != nil {
			return nil, err
		}
	}
	var obj *KubernetesImageObjectDescriptor = &KubernetesImageObjectDescriptor{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *KubernetesImageObjectDescriptor) Unpack(v starlark.Value) error {
	obj := v1alpha1.KubernetesImageObjectDescriptor{}

	starlarkObj, ok := v.(*KubernetesImageObjectDescriptor)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "repo_field" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.RepoField = string(v)
			continue
		}
		if key == "tag_field" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.TagField = string(v)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type KubernetesImageObjectDescriptorList struct {
	*starlark.List
	Value []v1alpha1.KubernetesImageObjectDescriptor
	t     *starlark.Thread
}

func (o *KubernetesImageObjectDescriptorList) Unpack(v starlark.Value) error {
	items := []v1alpha1.KubernetesImageObjectDescriptor{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := KubernetesImageObjectDescriptor{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.KubernetesImageObjectDescriptor(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type KubernetesWatchRef struct {
	*starlark.Dict
	Value      v1alpha1.KubernetesWatchRef
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) kubernetesWatchRef(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var uID starlark.Value
	var namespace starlark.Value
	var name starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"uid?", &uID,
		"namespace?", &namespace,
		"name?", &name,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(3)

	if uID != nil {
		err := dict.SetKey(starlark.String("uid"), uID)
		if err != nil {
			return nil, err
		}
	}
	if namespace != nil {
		err := dict.SetKey(starlark.String("namespace"), namespace)
		if err != nil {
			return nil, err
		}
	}
	if name != nil {
		err := dict.SetKey(starlark.String("name"), name)
		if err != nil {
			return nil, err
		}
	}
	var obj *KubernetesWatchRef = &KubernetesWatchRef{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *KubernetesWatchRef) Unpack(v starlark.Value) error {
	obj := v1alpha1.KubernetesWatchRef{}

	starlarkObj, ok := v.(*KubernetesWatchRef)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "uid" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.UID = string(v)
			continue
		}
		if key == "namespace" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Namespace = string(v)
			continue
		}
		if key == "name" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Name = string(v)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type KubernetesWatchRefList struct {
	*starlark.List
	Value []v1alpha1.KubernetesWatchRef
	t     *starlark.Thread
}

func (o *KubernetesWatchRefList) Unpack(v starlark.Value) error {
	items := []v1alpha1.KubernetesWatchRef{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := KubernetesWatchRef{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.KubernetesWatchRef(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type LabelSelector struct {
	*starlark.Dict
	Value      metav1.LabelSelector
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) labelSelector(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var matchLabels starlark.Value
	var matchExpressions starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"match_labels?", &matchLabels,
		"match_expressions?", &matchExpressions,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(2)

	if matchLabels != nil {
		err := dict.SetKey(starlark.String("match_labels"), matchLabels)
		if err != nil {
			return nil, err
		}
	}
	if matchExpressions != nil {
		err := dict.SetKey(starlark.String("match_expressions"), matchExpressions)
		if err != nil {
			return nil, err
		}
	}
	var obj *LabelSelector = &LabelSelector{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *LabelSelector) Unpack(v starlark.Value) error {
	obj := metav1.LabelSelector{}

	starlarkObj, ok := v.(*LabelSelector)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "match_labels" {
			var v value.StringStringMap
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.MatchLabels = (map[string]string)(v)
			continue
		}
		if key == "match_expressions" {
			v := LabelSelectorRequirementList{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.MatchExpressions = v.Value
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type LabelSelectorList struct {
	*starlark.List
	Value []metav1.LabelSelector
	t     *starlark.Thread
}

func (o *LabelSelectorList) Unpack(v starlark.Value) error {
	items := []metav1.LabelSelector{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := LabelSelector{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, metav1.LabelSelector(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type LabelSelectorRequirement struct {
	*starlark.Dict
	Value      metav1.LabelSelectorRequirement
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) labelSelectorRequirement(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var key starlark.Value
	var operator starlark.Value
	var values starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"key?", &key,
		"operator?", &operator,
		"values?", &values,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(3)

	if key != nil {
		err := dict.SetKey(starlark.String("key"), key)
		if err != nil {
			return nil, err
		}
	}
	if operator != nil {
		err := dict.SetKey(starlark.String("operator"), operator)
		if err != nil {
			return nil, err
		}
	}
	if values != nil {
		err := dict.SetKey(starlark.String("values"), values)
		if err != nil {
			return nil, err
		}
	}
	var obj *LabelSelectorRequirement = &LabelSelectorRequirement{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *LabelSelectorRequirement) Unpack(v starlark.Value) error {
	obj := metav1.LabelSelectorRequirement{}

	starlarkObj, ok := v.(*LabelSelectorRequirement)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "key" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Key = string(v)
			continue
		}
		if key == "operator" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Operator = metav1.LabelSelectorOperator(v)
			continue
		}
		if key == "values" {
			var v value.StringList
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Values = v
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type LabelSelectorRequirementList struct {
	*starlark.List
	Value []metav1.LabelSelectorRequirement
	t     *starlark.Thread
}

func (o *LabelSelectorRequirementList) Unpack(v starlark.Value) error {
	items := []metav1.LabelSelectorRequirement{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := LabelSelectorRequirement{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, metav1.LabelSelectorRequirement(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type ObjectSelector struct {
	*starlark.Dict
	Value      v1alpha1.ObjectSelector
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) objectSelector(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var aPIVersionRegexp starlark.Value
	var kindRegexp starlark.Value
	var nameRegexp starlark.Value
	var namespaceRegexp starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"api_version_regexp?", &aPIVersionRegexp,
		"kind_regexp?", &kindRegexp,
		"name_regexp?", &nameRegexp,
		"namespace_regexp?", &namespaceRegexp,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(4)

	if aPIVersionRegexp != nil {
		err := dict.SetKey(starlark.String("api_version_regexp"), aPIVersionRegexp)
		if err != nil {
			return nil, err
		}
	}
	if kindRegexp != nil {
		err := dict.SetKey(starlark.String("kind_regexp"), kindRegexp)
		if err != nil {
			return nil, err
		}
	}
	if nameRegexp != nil {
		err := dict.SetKey(starlark.String("name_regexp"), nameRegexp)
		if err != nil {
			return nil, err
		}
	}
	if namespaceRegexp != nil {
		err := dict.SetKey(starlark.String("namespace_regexp"), namespaceRegexp)
		if err != nil {
			return nil, err
		}
	}
	var obj *ObjectSelector = &ObjectSelector{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *ObjectSelector) Unpack(v starlark.Value) error {
	obj := v1alpha1.ObjectSelector{}

	starlarkObj, ok := v.(*ObjectSelector)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "api_version_regexp" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.APIVersionRegexp = string(v)
			continue
		}
		if key == "kind_regexp" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.KindRegexp = string(v)
			continue
		}
		if key == "name_regexp" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.NameRegexp = string(v)
			continue
		}
		if key == "namespace_regexp" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.NamespaceRegexp = string(v)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type ObjectSelectorList struct {
	*starlark.List
	Value []v1alpha1.ObjectSelector
	t     *starlark.Thread
}

func (o *ObjectSelectorList) Unpack(v starlark.Value) error {
	items := []v1alpha1.ObjectSelector{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := ObjectSelector{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.ObjectSelector(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type PodLogStreamTemplateSpec struct {
	*starlark.Dict
	Value      v1alpha1.PodLogStreamTemplateSpec
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) podLogStreamTemplateSpec(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var sinceTime starlark.Value
	var onlyContainers starlark.Value
	var ignoreContainers starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"since_time?", &sinceTime,
		"only_containers?", &onlyContainers,
		"ignore_containers?", &ignoreContainers,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(3)

	if sinceTime != nil {
		err := dict.SetKey(starlark.String("since_time"), sinceTime)
		if err != nil {
			return nil, err
		}
	}
	if onlyContainers != nil {
		err := dict.SetKey(starlark.String("only_containers"), onlyContainers)
		if err != nil {
			return nil, err
		}
	}
	if ignoreContainers != nil {
		err := dict.SetKey(starlark.String("ignore_containers"), ignoreContainers)
		if err != nil {
			return nil, err
		}
	}
	var obj *PodLogStreamTemplateSpec = &PodLogStreamTemplateSpec{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *PodLogStreamTemplateSpec) Unpack(v starlark.Value) error {
	obj := v1alpha1.PodLogStreamTemplateSpec{}

	starlarkObj, ok := v.(*PodLogStreamTemplateSpec)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "only_containers" {
			var v value.StringList
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.OnlyContainers = v
			continue
		}
		if key == "ignore_containers" {
			var v value.StringList
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.IgnoreContainers = v
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type PodLogStreamTemplateSpecList struct {
	*starlark.List
	Value []v1alpha1.PodLogStreamTemplateSpec
	t     *starlark.Thread
}

func (o *PodLogStreamTemplateSpecList) Unpack(v starlark.Value) error {
	items := []v1alpha1.PodLogStreamTemplateSpec{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := PodLogStreamTemplateSpec{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.PodLogStreamTemplateSpec(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type PortForwardTemplateSpec struct {
	*starlark.Dict
	Value      v1alpha1.PortForwardTemplateSpec
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) portForwardTemplateSpec(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var forwards starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"forwards?", &forwards,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(1)

	if forwards != nil {
		err := dict.SetKey(starlark.String("forwards"), forwards)
		if err != nil {
			return nil, err
		}
	}
	var obj *PortForwardTemplateSpec = &PortForwardTemplateSpec{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *PortForwardTemplateSpec) Unpack(v starlark.Value) error {
	obj := v1alpha1.PortForwardTemplateSpec{}

	starlarkObj, ok := v.(*PortForwardTemplateSpec)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "forwards" {
			v := ForwardList{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Forwards = v.Value
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type PortForwardTemplateSpecList struct {
	*starlark.List
	Value []v1alpha1.PortForwardTemplateSpec
	t     *starlark.Thread
}

func (o *PortForwardTemplateSpecList) Unpack(v starlark.Value) error {
	items := []v1alpha1.PortForwardTemplateSpec{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := PortForwardTemplateSpec{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.PortForwardTemplateSpec(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type Probe struct {
	*starlark.Dict
	Value      v1alpha1.Probe
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) probe(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var handler starlark.Value
	var initialDelaySeconds starlark.Value
	var timeoutSeconds starlark.Value
	var periodSeconds starlark.Value
	var successThreshold starlark.Value
	var failureThreshold starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"handler?", &handler,
		"initial_delay_seconds?", &initialDelaySeconds,
		"timeout_seconds?", &timeoutSeconds,
		"period_seconds?", &periodSeconds,
		"success_threshold?", &successThreshold,
		"failure_threshold?", &failureThreshold,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(6)

	if handler != nil {
		err := dict.SetKey(starlark.String("handler"), handler)
		if err != nil {
			return nil, err
		}
	}
	if initialDelaySeconds != nil {
		err := dict.SetKey(starlark.String("initial_delay_seconds"), initialDelaySeconds)
		if err != nil {
			return nil, err
		}
	}
	if timeoutSeconds != nil {
		err := dict.SetKey(starlark.String("timeout_seconds"), timeoutSeconds)
		if err != nil {
			return nil, err
		}
	}
	if periodSeconds != nil {
		err := dict.SetKey(starlark.String("period_seconds"), periodSeconds)
		if err != nil {
			return nil, err
		}
	}
	if successThreshold != nil {
		err := dict.SetKey(starlark.String("success_threshold"), successThreshold)
		if err != nil {
			return nil, err
		}
	}
	if failureThreshold != nil {
		err := dict.SetKey(starlark.String("failure_threshold"), failureThreshold)
		if err != nil {
			return nil, err
		}
	}
	var obj *Probe = &Probe{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *Probe) Unpack(v starlark.Value) error {
	obj := v1alpha1.Probe{}

	starlarkObj, ok := v.(*Probe)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "exec" {
			v := ExecAction{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Exec = (*v1alpha1.ExecAction)(&v.Value)
			continue
		}
		if key == "http_get" {
			v := HTTPGetAction{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.HTTPGet = (*v1alpha1.HTTPGetAction)(&v.Value)
			continue
		}
		if key == "tcp_socket" {
			v := TCPSocketAction{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.TCPSocket = (*v1alpha1.TCPSocketAction)(&v.Value)
			continue
		}
		if key == "initial_delay_seconds" {
			v, err := starlark.AsInt32(val)
			if err != nil {
				return fmt.Errorf("Expected int, got: %v", err)
			}
			obj.InitialDelaySeconds = int32(v)
			continue
		}
		if key == "timeout_seconds" {
			v, err := starlark.AsInt32(val)
			if err != nil {
				return fmt.Errorf("Expected int, got: %v", err)
			}
			obj.TimeoutSeconds = int32(v)
			continue
		}
		if key == "period_seconds" {
			v, err := starlark.AsInt32(val)
			if err != nil {
				return fmt.Errorf("Expected int, got: %v", err)
			}
			obj.PeriodSeconds = int32(v)
			continue
		}
		if key == "success_threshold" {
			v, err := starlark.AsInt32(val)
			if err != nil {
				return fmt.Errorf("Expected int, got: %v", err)
			}
			obj.SuccessThreshold = int32(v)
			continue
		}
		if key == "failure_threshold" {
			v, err := starlark.AsInt32(val)
			if err != nil {
				return fmt.Errorf("Expected int, got: %v", err)
			}
			obj.FailureThreshold = int32(v)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type ProbeList struct {
	*starlark.List
	Value []v1alpha1.Probe
	t     *starlark.Thread
}

func (o *ProbeList) Unpack(v starlark.Value) error {
	items := []v1alpha1.Probe{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := Probe{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.Probe(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type RestartOnSpec struct {
	*starlark.Dict
	Value      v1alpha1.RestartOnSpec
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) restartOnSpec(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var fileWatches starlark.Value
	var uiButtons starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"file_watches?", &fileWatches,
		"ui_buttons?", &uiButtons,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(2)

	if fileWatches != nil {
		err := dict.SetKey(starlark.String("file_watches"), fileWatches)
		if err != nil {
			return nil, err
		}
	}
	if uiButtons != nil {
		err := dict.SetKey(starlark.String("ui_buttons"), uiButtons)
		if err != nil {
			return nil, err
		}
	}
	var obj *RestartOnSpec = &RestartOnSpec{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *RestartOnSpec) Unpack(v starlark.Value) error {
	obj := v1alpha1.RestartOnSpec{}

	starlarkObj, ok := v.(*RestartOnSpec)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "file_watches" {
			var v value.StringList
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.FileWatches = v
			continue
		}
		if key == "ui_buttons" {
			var v value.StringList
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.UIButtons = v
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type RestartOnSpecList struct {
	*starlark.List
	Value []v1alpha1.RestartOnSpec
	t     *starlark.Thread
}

func (o *RestartOnSpecList) Unpack(v starlark.Value) error {
	items := []v1alpha1.RestartOnSpec{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := RestartOnSpec{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.RestartOnSpec(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type StartOnSpec struct {
	*starlark.Dict
	Value      v1alpha1.StartOnSpec
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) startOnSpec(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var startAfter starlark.Value
	var uiButtons starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"start_after?", &startAfter,
		"ui_buttons?", &uiButtons,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(2)

	if startAfter != nil {
		err := dict.SetKey(starlark.String("start_after"), startAfter)
		if err != nil {
			return nil, err
		}
	}
	if uiButtons != nil {
		err := dict.SetKey(starlark.String("ui_buttons"), uiButtons)
		if err != nil {
			return nil, err
		}
	}
	var obj *StartOnSpec = &StartOnSpec{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *StartOnSpec) Unpack(v starlark.Value) error {
	obj := v1alpha1.StartOnSpec{}

	starlarkObj, ok := v.(*StartOnSpec)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "ui_buttons" {
			var v value.StringList
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.UIButtons = v
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type StartOnSpecList struct {
	*starlark.List
	Value []v1alpha1.StartOnSpec
	t     *starlark.Thread
}

func (o *StartOnSpecList) Unpack(v starlark.Value) error {
	items := []v1alpha1.StartOnSpec{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := StartOnSpec{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.StartOnSpec(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type TCPSocketAction struct {
	*starlark.Dict
	Value      v1alpha1.TCPSocketAction
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) tCPSocketAction(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var port starlark.Value
	var host starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"port?", &port,
		"host?", &host,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(2)

	if port != nil {
		err := dict.SetKey(starlark.String("port"), port)
		if err != nil {
			return nil, err
		}
	}
	if host != nil {
		err := dict.SetKey(starlark.String("host"), host)
		if err != nil {
			return nil, err
		}
	}
	var obj *TCPSocketAction = &TCPSocketAction{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *TCPSocketAction) Unpack(v starlark.Value) error {
	obj := v1alpha1.TCPSocketAction{}

	starlarkObj, ok := v.(*TCPSocketAction)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "port" {
			v, err := starlark.AsInt32(val)
			if err != nil {
				return fmt.Errorf("Expected int, got: %v", err)
			}
			obj.Port = int32(v)
			continue
		}
		if key == "host" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Host = string(v)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type TCPSocketActionList struct {
	*starlark.List
	Value []v1alpha1.TCPSocketAction
	t     *starlark.Thread
}

func (o *TCPSocketActionList) Unpack(v starlark.Value) error {
	items := []v1alpha1.TCPSocketAction{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := TCPSocketAction{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.TCPSocketAction(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type UIBoolInputSpec struct {
	*starlark.Dict
	Value      v1alpha1.UIBoolInputSpec
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) uIBoolInputSpec(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var defaultValue starlark.Value
	var trueString starlark.Value
	var falseString starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"default_value?", &defaultValue,
		"true_string?", &trueString,
		"false_string?", &falseString,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(3)

	if defaultValue != nil {
		err := dict.SetKey(starlark.String("default_value"), defaultValue)
		if err != nil {
			return nil, err
		}
	}
	if trueString != nil {
		err := dict.SetKey(starlark.String("true_string"), trueString)
		if err != nil {
			return nil, err
		}
	}
	if falseString != nil {
		err := dict.SetKey(starlark.String("false_string"), falseString)
		if err != nil {
			return nil, err
		}
	}
	var obj *UIBoolInputSpec = &UIBoolInputSpec{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *UIBoolInputSpec) Unpack(v starlark.Value) error {
	obj := v1alpha1.UIBoolInputSpec{}

	starlarkObj, ok := v.(*UIBoolInputSpec)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "default_value" {
			v, ok := val.(starlark.Bool)
			if !ok {
				return fmt.Errorf("Expected bool, got: %v", val.Type())
			}
			obj.DefaultValue = bool(v)
			continue
		}
		if key == "true_string" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.TrueString = (*string)(&v)
			continue
		}
		if key == "false_string" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.FalseString = (*string)(&v)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type UIBoolInputSpecList struct {
	*starlark.List
	Value []v1alpha1.UIBoolInputSpec
	t     *starlark.Thread
}

func (o *UIBoolInputSpecList) Unpack(v starlark.Value) error {
	items := []v1alpha1.UIBoolInputSpec{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := UIBoolInputSpec{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.UIBoolInputSpec(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type UIChoiceInputSpec struct {
	*starlark.Dict
	Value      v1alpha1.UIChoiceInputSpec
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) uIChoiceInputSpec(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var choices starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"choices?", &choices,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(1)

	if choices != nil {
		err := dict.SetKey(starlark.String("choices"), choices)
		if err != nil {
			return nil, err
		}
	}
	var obj *UIChoiceInputSpec = &UIChoiceInputSpec{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *UIChoiceInputSpec) Unpack(v starlark.Value) error {
	obj := v1alpha1.UIChoiceInputSpec{}

	starlarkObj, ok := v.(*UIChoiceInputSpec)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "choices" {
			var v value.StringList
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Choices = v
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type UIChoiceInputSpecList struct {
	*starlark.List
	Value []v1alpha1.UIChoiceInputSpec
	t     *starlark.Thread
}

func (o *UIChoiceInputSpecList) Unpack(v starlark.Value) error {
	items := []v1alpha1.UIChoiceInputSpec{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := UIChoiceInputSpec{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.UIChoiceInputSpec(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type UIComponentLocation struct {
	*starlark.Dict
	Value      v1alpha1.UIComponentLocation
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) uIComponentLocation(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var componentID starlark.Value
	var componentType starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"component_id?", &componentID,
		"component_type?", &componentType,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(2)

	if componentID != nil {
		err := dict.SetKey(starlark.String("component_id"), componentID)
		if err != nil {
			return nil, err
		}
	}
	if componentType != nil {
		err := dict.SetKey(starlark.String("component_type"), componentType)
		if err != nil {
			return nil, err
		}
	}
	var obj *UIComponentLocation = &UIComponentLocation{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *UIComponentLocation) Unpack(v starlark.Value) error {
	obj := v1alpha1.UIComponentLocation{}

	starlarkObj, ok := v.(*UIComponentLocation)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "component_id" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.ComponentID = string(v)
			continue
		}
		if key == "component_type" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.ComponentType = v1alpha1.ComponentType(v)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type UIComponentLocationList struct {
	*starlark.List
	Value []v1alpha1.UIComponentLocation
	t     *starlark.Thread
}

func (o *UIComponentLocationList) Unpack(v starlark.Value) error {
	items := []v1alpha1.UIComponentLocation{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := UIComponentLocation{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.UIComponentLocation(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type UIHiddenInputSpec struct {
	*starlark.Dict
	Value      v1alpha1.UIHiddenInputSpec
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) uIHiddenInputSpec(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var value starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"value?", &value,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(1)

	if value != nil {
		err := dict.SetKey(starlark.String("value"), value)
		if err != nil {
			return nil, err
		}
	}
	var obj *UIHiddenInputSpec = &UIHiddenInputSpec{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *UIHiddenInputSpec) Unpack(v starlark.Value) error {
	obj := v1alpha1.UIHiddenInputSpec{}

	starlarkObj, ok := v.(*UIHiddenInputSpec)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "value" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Value = string(v)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type UIHiddenInputSpecList struct {
	*starlark.List
	Value []v1alpha1.UIHiddenInputSpec
	t     *starlark.Thread
}

func (o *UIHiddenInputSpecList) Unpack(v starlark.Value) error {
	items := []v1alpha1.UIHiddenInputSpec{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := UIHiddenInputSpec{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.UIHiddenInputSpec(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type UIInputSpec struct {
	*starlark.Dict
	Value      v1alpha1.UIInputSpec
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) uIInputSpec(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var name starlark.Value
	var label starlark.Value
	var text starlark.Value
	var bool starlark.Value
	var hidden starlark.Value
	var choice starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"name?", &name,
		"label?", &label,
		"text?", &text,
		"bool?", &bool,
		"hidden?", &hidden,
		"choice?", &choice,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(6)

	if name != nil {
		err := dict.SetKey(starlark.String("name"), name)
		if err != nil {
			return nil, err
		}
	}
	if label != nil {
		err := dict.SetKey(starlark.String("label"), label)
		if err != nil {
			return nil, err
		}
	}
	if text != nil {
		err := dict.SetKey(starlark.String("text"), text)
		if err != nil {
			return nil, err
		}
	}
	if bool != nil {
		err := dict.SetKey(starlark.String("bool"), bool)
		if err != nil {
			return nil, err
		}
	}
	if hidden != nil {
		err := dict.SetKey(starlark.String("hidden"), hidden)
		if err != nil {
			return nil, err
		}
	}
	if choice != nil {
		err := dict.SetKey(starlark.String("choice"), choice)
		if err != nil {
			return nil, err
		}
	}
	var obj *UIInputSpec = &UIInputSpec{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *UIInputSpec) Unpack(v starlark.Value) error {
	obj := v1alpha1.UIInputSpec{}

	starlarkObj, ok := v.(*UIInputSpec)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "name" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Name = string(v)
			continue
		}
		if key == "label" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Label = string(v)
			continue
		}
		if key == "text" {
			v := UITextInputSpec{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Text = (*v1alpha1.UITextInputSpec)(&v.Value)
			continue
		}
		if key == "bool" {
			v := UIBoolInputSpec{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Bool = (*v1alpha1.UIBoolInputSpec)(&v.Value)
			continue
		}
		if key == "hidden" {
			v := UIHiddenInputSpec{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Hidden = (*v1alpha1.UIHiddenInputSpec)(&v.Value)
			continue
		}
		if key == "choice" {
			v := UIChoiceInputSpec{t: o.t}
			err := v.Unpack(val)
			if err != nil {
				return fmt.Errorf("unpacking %s: %v", key, err)
			}
			obj.Choice = (*v1alpha1.UIChoiceInputSpec)(&v.Value)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type UIInputSpecList struct {
	*starlark.List
	Value []v1alpha1.UIInputSpec
	t     *starlark.Thread
}

func (o *UIInputSpecList) Unpack(v starlark.Value) error {
	items := []v1alpha1.UIInputSpec{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := UIInputSpec{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.UIInputSpec(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}

type UITextInputSpec struct {
	*starlark.Dict
	Value      v1alpha1.UITextInputSpec
	isUnpacked bool
	t          *starlark.Thread // instantiation thread for computing abspath
}

func (p Plugin) uITextInputSpec(t *starlark.Thread, fn *starlark.Builtin, args starlark.Tuple, kwargs []starlark.Tuple) (starlark.Value, error) {
	var defaultValue starlark.Value
	var placeholder starlark.Value
	err := starkit.UnpackArgs(t, fn.Name(), args, kwargs,
		"default_value?", &defaultValue,
		"placeholder?", &placeholder,
	)
	if err != nil {
		return nil, err
	}

	dict := starlark.NewDict(2)

	if defaultValue != nil {
		err := dict.SetKey(starlark.String("default_value"), defaultValue)
		if err != nil {
			return nil, err
		}
	}
	if placeholder != nil {
		err := dict.SetKey(starlark.String("placeholder"), placeholder)
		if err != nil {
			return nil, err
		}
	}
	var obj *UITextInputSpec = &UITextInputSpec{t: t}
	err = obj.Unpack(dict)
	if err != nil {
		return nil, err
	}
	return obj, nil
}

func (o *UITextInputSpec) Unpack(v starlark.Value) error {
	obj := v1alpha1.UITextInputSpec{}

	starlarkObj, ok := v.(*UITextInputSpec)
	if ok {
		*o = *starlarkObj
		return nil
	}

	mapObj, ok := v.(*starlark.Dict)
	if !ok {
		return fmt.Errorf("expected dict, actual: %v", v.Type())
	}

	for _, item := range mapObj.Items() {
		keyV, val := item[0], item[1]
		key, ok := starlark.AsString(keyV)
		if !ok {
			return fmt.Errorf("key must be string. Got: %s", keyV.Type())
		}

		if key == "default_value" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.DefaultValue = string(v)
			continue
		}
		if key == "placeholder" {
			v, ok := starlark.AsString(val)
			if !ok {
				return fmt.Errorf("Expected string, actual: %s", val.Type())
			}
			obj.Placeholder = string(v)
			continue
		}
		return fmt.Errorf("Unexpected attribute name: %s", key)
	}

	mapObj.Freeze()
	o.Dict = mapObj
	o.Value = obj
	o.isUnpacked = true

	return nil
}

type UITextInputSpecList struct {
	*starlark.List
	Value []v1alpha1.UITextInputSpec
	t     *starlark.Thread
}

func (o *UITextInputSpecList) Unpack(v starlark.Value) error {
	items := []v1alpha1.UITextInputSpec{}

	listObj, ok := v.(*starlark.List)
	if !ok {
		return fmt.Errorf("expected list, actual: %v", v.Type())
	}

	for i := 0; i < listObj.Len(); i++ {
		v := listObj.Index(i)

		item := UITextInputSpec{t: o.t}
		err := item.Unpack(v)
		if err != nil {
			return fmt.Errorf("at index %d: %v", i, err)
		}
		items = append(items, v1alpha1.UITextInputSpec(item.Value))
	}

	listObj.Freeze()
	o.List = listObj
	o.Value = items

	return nil
}
