package mssql

// ATTENTION!
// This rule was autogenerated!
// Before making changes, consider updating the generator.

import (
	"github.com/aquasecurity/tfsec/internal/app/tfsec/block"
	"github.com/aquasecurity/tfsec/internal/app/tfsec/scanner"
	"github.com/aquasecurity/tfsec/pkg/provider"
	"github.com/aquasecurity/tfsec/pkg/result"
	"github.com/aquasecurity/tfsec/pkg/rule"
	"github.com/aquasecurity/tfsec/pkg/severity"
)

func init() {
	scanner.RegisterCheckRule(rule.Rule{
		Provider:  provider.AzureProvider,
		Service:   "mssql",
		ShortCode: "threat-alert-email-to-owner",
		Documentation: rule.RuleDocumentation{
			Summary:     "Security threat alerts go to subcription owners and co-administrators",
			Explanation: `Subscription owners should be notified when there are security alerts. By ensuring the administrators of the account have been notified they can quickly assist in any required remediation`,
			Impact:      "Administrators and subscription owners may have a delayed response",
			Resolution:  "Enable email to subscription owners",
			BadExample: []string{`
resource "azurerm_mssql_server_security_alert_policy" "bad_example" {
  resource_group_name        = azurerm_resource_group.example.name
  server_name                = azurerm_sql_server.example.name
  state                      = "Enabled"
  storage_endpoint           = azurerm_storage_account.example.primary_blob_endpoint
  storage_account_access_key = azurerm_storage_account.example.primary_access_key
  disabled_alerts = [
  ]
  email_account_admins = false
}
`},
			GoodExample: []string{`
resource "azurerm_mssql_server_security_alert_policy" "good_example" {
  resource_group_name        = azurerm_resource_group.example.name
  server_name                = azurerm_sql_server.example.name
  state                      = "Enabled"
  storage_endpoint           = azurerm_storage_account.example.primary_blob_endpoint
  storage_account_access_key = azurerm_storage_account.example.primary_access_key
  disabled_alerts = []

  email_account_admins = true
}
`},
			Links: []string{
				"https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/mssql_server_security_alert_policy#email_account_admins",
			},
		},
		RequiredTypes: []string{
			"resource",
		},
		RequiredLabels: []string{
			"azurerm_mssql_server_security_alert_policy",
		},
		DefaultSeverity: severity.Low,
		CheckFunc: func(set result.Set, resourceBlock block.Block, module block.Module) {
			if emailAccountAdminsAttr := resourceBlock.GetAttribute("email_account_admins"); emailAccountAdminsAttr.IsNil() { // alert on use of default value
				set.AddResult().
					WithDescription("Resource '%s' uses default value for email_account_admins", resourceBlock.FullName())
			} else if emailAccountAdminsAttr.IsFalse() {
				set.AddResult().
					WithDescription("Resource '%s' has attribute email_account_admins that is false", resourceBlock.FullName()).
					WithAttribute(emailAccountAdminsAttr)
			}
		},
	})
}
