package elasticache

// ATTENTION!
// This rule was autogenerated!
// Before making changes, consider updating the generator.

// generator-locked
import (
	"github.com/aquasecurity/tfsec/internal/app/tfsec/block"
	"github.com/aquasecurity/tfsec/internal/app/tfsec/scanner"
	"github.com/aquasecurity/tfsec/pkg/provider"
	"github.com/aquasecurity/tfsec/pkg/result"
	"github.com/aquasecurity/tfsec/pkg/rule"
	"github.com/aquasecurity/tfsec/pkg/severity"
)

func init() {
	scanner.RegisterCheckRule(rule.Rule{
		Provider:  provider.AWSProvider,
		Service:   "elasticache",
		ShortCode: "add-description-for-security-group",
		Documentation: rule.RuleDocumentation{
			Summary: "Missing description for security group/security group rule.",
			Explanation: `Security groups and security group rules should include a description for auditing purposes.

Simplifies auditing, debugging, and managing security groups.`,
			Impact:     "Descriptions provide context for the firewall rule reasons",
			Resolution: "Add descriptions for all security groups and rules",
			BadExample: []string{`
resource "aws_security_group" "bar" {
  name = "security-group"
}

resource "aws_elasticache_security_group" "bad_example" {
  name                 = "elasticache-security-group"
  security_group_names = [aws_security_group.bar.name]
  description = ""
}
`},
			GoodExample: []string{`
resource "aws_security_group" "bar" {
  name = "security-group"
}

resource "aws_elasticache_security_group" "good_example" {
  name                 = "elasticache-security-group"
  security_group_names = [aws_security_group.bar.name]
  description = "something"
}
`},
			Links: []string{
				"https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/elasticache_security_group#description",
			},
		},
		RequiredTypes: []string{
			"resource",
		},
		RequiredLabels: []string{
			"aws_elasticache_security_group",
		},
		DefaultSeverity: severity.Low,
		CheckFunc: func(set result.Set, resourceBlock block.Block, _ block.Module) {
			if descriptionAttr := resourceBlock.GetAttribute("description"); descriptionAttr.IsNil() { // alert on use of default value
				set.AddResult().
					WithDescription("Resource '%s' uses default value for description", resourceBlock.FullName())
			} else if descriptionAttr.IsEmpty() {
				set.AddResult().
					WithDescription("Resource '%s' has description set to ", resourceBlock.FullName()).
					WithAttribute(descriptionAttr)
			}
		},
	})
}
