package dns

// ATTENTION!
// This rule was autogenerated!
// Before making changes, consider updating the generator.

import (
	"github.com/aquasecurity/tfsec/internal/app/tfsec/block"
	"github.com/aquasecurity/tfsec/internal/app/tfsec/hclcontext"
	"github.com/aquasecurity/tfsec/internal/app/tfsec/scanner"
	"github.com/aquasecurity/tfsec/pkg/provider"
	"github.com/aquasecurity/tfsec/pkg/result"
	"github.com/aquasecurity/tfsec/pkg/rule"
	"github.com/aquasecurity/tfsec/pkg/severity"
)

func init() {
	scanner.RegisterCheckRule(rule.Rule{
		Provider:  provider.GoogleProvider,
		Service:   "dns",
		ShortCode: "no-rsa-sha1",
		Documentation: rule.RuleDocumentation{
			Summary:     "Zone signing should not use RSA SHA1",
			Explanation: `RSA SHA1 is a weaker algorithm than SHA2-based algorithms such as RSA SHA256/512`,
			Impact:      "Less secure encryption algorithm than others available",
			Resolution:  "Use RSA SHA512",
			BadExample: []string{`
resource "google_dns_managed_zone" "foo" {
	name     = "foobar"
	dns_name = "foo.bar."
	
	dnssec_config {
		state         = "on"
		non_existence = "nsec3"
	}
}
	
data "google_dns_keys" "foo_dns_keys" {
	managed_zone = google_dns_managed_zone.foo.id
	zone_signing_keys {
		algorithm = "rsasha1"
	}
}
	
output "foo_dns_ds_record" {
	description = "DS record of the foo subdomain."
	value       = data.google_dns_keys.foo_dns_keys.key_signing_keys[0].ds_record
}
`},
			GoodExample: []string{`
resource "google_dns_managed_zone" "foo" {
	name     = "foobar"
	dns_name = "foo.bar."
	
	dnssec_config {
		state         = "on"
		non_existence = "nsec3"
	}
}
	
data "google_dns_keys" "foo_dns_keys" {
	managed_zone = google_dns_managed_zone.foo.id
	zone_signing_keys {
		algorithm = "rsasha512"
	}
}
	
output "foo_dns_ds_record" {
	description = "DS record of the foo subdomain."
	value       = data.google_dns_keys.foo_dns_keys.key_signing_keys[0].ds_record
}
`},
			Links: []string{
				"https://registry.terraform.io/providers/hashicorp/google/latest/docs/resources/dns_managed_zone#algorithm",
			},
		},
		RequiredTypes: []string{
			"data",
		},
		RequiredLabels: []string{
			"google_dns_keys",
		},
		DefaultSeverity: severity.Medium,
		CheckFunc: func(set result.Set, resourceBlock block.Block, _ *hclcontext.Context) {
			if algorithmAttr := resourceBlock.GetBlock("zone_signing_keys").GetAttribute("algorithm"); algorithmAttr.Equals("rsasha1") {
				set.AddResult().
					WithDescription("Data '%s' has zone_signing_keys.algorithm set to rsasha1", resourceBlock.FullName()).
					WithAttribute(algorithmAttr)
			}
			if algorithmAttr := resourceBlock.GetBlock("key_signing_keys").GetAttribute("algorithm"); algorithmAttr.Equals("rsasha1") {
				set.AddResult().
					WithDescription("Data '%s' has key_signing_keys.algorithm set to rsasha1", resourceBlock.FullName()).
					WithAttribute(algorithmAttr)
			}
		},
	})
}
