package test

import (
	"testing"

	"github.com/tfsec/tfsec/internal/app/tfsec/rules"
)

func Test_AWSRDSEncryptionNotEnabled(t *testing.T) {

	var tests = []struct {
		name                  string
		source                string
		mustIncludeResultCode string
		mustExcludeResultCode string
	}{
		{
			name: "Encryption not enabled on db instance",
			source: `
resource "aws_db_instance" "my-db-instance" {
	
}
`,
			mustIncludeResultCode: rules.AWSRDSEncryptionNotEnabled,
		},
		{
			name: "Encryption not enabled on db instance",
			source: `
resource "aws_db_instance" "my-db-instance" {
	storage_encrypted = false
}
`,
			mustIncludeResultCode: rules.AWSRDSEncryptionNotEnabled,
		},
		{
			name: "Encryption not enabled on db instance",
			source: `
resource "aws_db_instance" "my-db-instance" {
	kms_key_id = "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
}
`,
			mustIncludeResultCode: rules.AWSRDSEncryptionNotEnabled,
		},
		{
			name: "Encryption using specified CMK enabled on db instance",
			source: `
resource "aws_db_instance" "my-db-instance" {
	storage_encrypted = true
	kms_key_id = "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
}
`,
			mustExcludeResultCode: rules.AWSRDSEncryptionNotEnabled,
		},
		{
			name: "Encryption using default CMK enabled on db instance",
			source: `
resource "aws_db_instance" "my-db-instance" {
	storage_encrypted = true
}
`,
			mustExcludeResultCode: rules.AWSRDSEncryptionNotEnabled,
		},
	}

	for _, test := range tests {
		t.Run(test.name, func(t *testing.T) {
			results := scanHCL(test.source, t)
			assertCheckCode(t, test.mustIncludeResultCode, test.mustExcludeResultCode, results)
		})
	}

}
