---
title: GCP010
summary: Shielded GKE nodes not enabled. [google_container_cluster] 
resources: 
permalink: /docs/google/GCP010/
nav_order: 2
parent: GOOGLE Checks
---

## Shielded GKE nodes not enabled.

### Explanation


CIS GKE Benchmark Recommendation: 6.5.5. Ensure Shielded GKE Nodes are Enabled

Shielded GKE Nodes provide strong, verifiable node identity and integrity to increase the security of GKE nodes and should be enabled on all GKE clusters.



### Insecure Example

The following example will fail the GCP010 check.

{% highlight terraform %}

resource "google_container_cluster" "gke" {
	enable_shielded_nodes = "false"
}
{% endhighlight %}



### Secure Example

The following example will pass the GCP010 check.

{% highlight terraform %}

resource "google_container_cluster" "gke" {
	enable_shielded_nodes = "true"
}
{% endhighlight %}


### Related Links


- [https://cloud.google.com/kubernetes-engine/docs/how-to/hardening-your-cluster#shielded_nodes](https://cloud.google.com/kubernetes-engine/docs/how-to/hardening-your-cluster#shielded_nodes){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_shielded_nodes](https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_shielded_nodes){:target="_blank" rel="nofollow noreferrer noopener"}

