---
title: GCP004
summary: An outbound firewall rule allows traffic to `/0`. [google_compute_firewall] 
resources: 
permalink: /docs/google/GCP004/
nav_order: 2
parent: GOOGLE Checks
---

## An outbound firewall rule allows traffic to `/0`.

### Explanation


Network security rules should not use very broad subnets.

Where possible, segments should be broken into smaller subnets and avoid using the <code>/0</code> subnet.



### Insecure Example

The following example will fail the GCP004 check.

{% highlight terraform %}

resource "google_compute_firewall" "my-firewall" {
	destination_ranges = ["0.0.0.0/0"]
}
{% endhighlight %}



### Secure Example

The following example will pass the GCP004 check.

{% highlight terraform %}

resource "google_compute_firewall" "my-firewall" {
	destination_ranges = ["1.2.3.4/32"]
}
{% endhighlight %}


### Related Links


- [https://cloud.google.com/vpc/docs/using-firewalls](https://cloud.google.com/vpc/docs/using-firewalls){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/google/r/compute_firewall.html](https://www.terraform.io/docs/providers/google/r/compute_firewall.html){:target="_blank" rel="nofollow noreferrer noopener"}

