---
title: GCP002
summary: Unencrypted storage bucket. [google_storage_bucket] 
resources: 
permalink: /docs/google/GCP002/
nav_order: 2
parent: GOOGLE Checks
---

## Unencrypted storage bucket.

### Explanation


Google storage buckets should have an <code>encryption</code> block to ensure that the data is encrypted at rest.

When specifying an <code>encryption</code> block, by not including the optional <code>default_kms_key_name</code> you are deferring to Google Provided Encryption.



### Insecure Example

The following example will fail the GCP002 check.

{% highlight terraform %}

resource "google_storage_bucket" "my-bucket" {
	# ...
	# no encryption block specified
	# ...
}
{% endhighlight %}



### Secure Example

The following example will pass the GCP002 check.

{% highlight terraform %}

resource "google_storage_bucket" "my-bucket" {
	encryption {}	
}

resource "google_storage_bucket" "my-bucket" {
	encryption {
		default_kms_key_name = "my-key"
	}	
}
{% endhighlight %}


### Related Links


- [https://cloud.google.com/storage/docs/json_api/v1/buckets](https://cloud.google.com/storage/docs/json_api/v1/buckets){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/google/r/storage_bucket.html](https://www.terraform.io/docs/providers/google/r/storage_bucket.html){:target="_blank" rel="nofollow noreferrer noopener"}

