---
title: GCP001
summary: Unencrypted compute disk. [google_compute_disk] 
resources: 
permalink: /docs/google/GCP001/
nav_order: 2
parent: GOOGLE Checks
---

## Unencrypted compute disk.

### Explanation


By default, Compute Engine encrypts all data at rest. Compute Engine handles and manages this encryption for you without any additional actions on your part.

If the <code>disk_encryption_key</code> block is included in the resource declaration then it *must* include a <code>raw_key</code> or <code>kms_key_self_link</code>.

To use the default offering of Google managed keys, do not include a <code>disk_encryption_key</code> block at all.



### Insecure Example

The following example will fail the GCP001 check.

{% highlight terraform %}

resource "google_compute_disk" "my-disk" {
	# ... 
	disk_encryption_key {}
	# ...
}
{% endhighlight %}



### Secure Example

The following example will pass the GCP001 check.

{% highlight terraform %}

resource "google_compute_disk" "my-disk" {
	disk_encryption_key {
		kms_key_self_link = "something"
	}
}

resource "google_compute_disk" "another-my-disk" {
	disk_encryption_key {
		raw_key = "something"
	}
}
{% endhighlight %}


### Related Links


- [https://cloud.google.com/compute/docs/disks/customer-supplied-encryption](https://cloud.google.com/compute/docs/disks/customer-supplied-encryption){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/google/r/compute_disk.html](https://www.terraform.io/docs/providers/google/r/compute_disk.html){:target="_blank" rel="nofollow noreferrer noopener"}

