---
title: GEN003
summary: Potentially sensitive data stored in block attribute. [] 
resources: 
permalink: /docs/general/GEN003/
nav_order: 2
parent: GENERAL Checks
---

## Potentially sensitive data stored in block attribute.

### Explanation


Sensitive attributes such as passwords and API tokens should not be available in your templates, especially in a plaintext form. You can declare variables to hold the secrets, assuming you can provide values for those variables in a secure fashion. Alternatively, you can store these secrets in a secure secret store, such as AWS KMS.

*NOTE: It is also recommended to store your Terraform state in an encrypted form.*



### Insecure Example

The following example will fail the GEN003 check.

{% highlight terraform %}

resource "evil_corp" "virtual_machine" {
	root_password = "p4ssw0rd"
}

{% endhighlight %}



### Secure Example

The following example will pass the GEN003 check.

{% highlight terraform %}

variable "password" {
  description = "The root password for our VM"
  type        = string
}

resource "evil_corp" "virtual_machine" {
	root_password = var.password
}

{% endhighlight %}


### Related Links


- [https://www.terraform.io/docs/state/sensitive-data.html](https://www.terraform.io/docs/state/sensitive-data.html){:target="_blank" rel="nofollow noreferrer noopener"}

