---
title: AZU016
summary: When using Queue Services for a storage account, logging should be enabled. [azurerm_storage_account] 
resources: 
permalink: /docs/azure/AZU016/
nav_order: 2
parent: AZURE Checks
---

## When using Queue Services for a storage account, logging should be enabled.

### Explanation


Storage Analytics logs detailed information about successful and failed requests to a storage service. 

This information can be used to monitor individual requests and to diagnose issues with a storage service. 

Requests are logged on a best-effort basis.



### Insecure Example

The following example will fail the AZU016 check.

{% highlight terraform %}

resource "azurerm_storage_account" "bad_example" {
    name                     = "example"
    resource_group_name      = data.azurerm_resource_group.example.name
    location                 = data.azurerm_resource_group.example.location
    account_tier             = "Standard"
    account_replication_type = "GRS"
    queue_properties  {
  }
}

{% endhighlight %}



### Secure Example

The following example will pass the AZU016 check.

{% highlight terraform %}

resource "azurerm_storage_account" "good_example" {
    name                     = "example"
    resource_group_name      = data.azurerm_resource_group.example.name
    location                 = data.azurerm_resource_group.example.location
    account_tier             = "Standard"
    account_replication_type = "GRS"
    queue_properties  {
    logging {
        delete                = true
        read                  = true
        write                 = true
        version               = "1.0"
        retention_policy_days = 10
    }
  }
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/storage_account#logging](https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/storage_account#logging){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.microsoft.com/en-us/azure/storage/common/storage-analytics-logging?tabs=dotnet](https://docs.microsoft.com/en-us/azure/storage/common/storage-analytics-logging?tabs=dotnet){:target="_blank" rel="nofollow noreferrer noopener"}

